<?php
if (!defined('SCHLIX_VERSION')) die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
 

/* 
 * Copyright (C) 2015 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
*  
 *
 */
global $SystemDB, $SystemConfig, $SchlixSupportedLanguages, $Application;
$main_frontend_app = $SystemConfig->get('system', 'str_main_app');
if (empty($main_frontend_app))
    $main_frontend_app = 'html'.' ('.___('Web Pages').')';
$current_language = SCHLIX_DEFAULT_LANGUAGE == 'en_us' ? ___('Default (US English)') :
    ($SchlixSupportedLanguages[SCHLIX_DEFAULT_LANGUAGE] ? $SchlixSupportedLanguages[SCHLIX_DEFAULT_LANGUAGE] : SCHLIX_DEFAULT_LANGUAGE);

$current_theme = App\Core_ThemeManager::getCurrentFrontendWebsiteTemplateName();
$theme_manager = new \App\Core_ThemeManager_Admin();
$url_theme_manager = $Application->createFriendlyURL("app=core.thememanager");
if (ini_get('opcache.enable'))
{
    $opcache_icon_colour = 'lime';
    $opcache_icon = 'fa fa-check';
    $opcache_status = ___('Yes');
    $opcache_advice = ___('Faster performance');
} else
{
    $opcache_icon_colour = 'red';
    $opcache_icon = 'fa fa-times';
    $opcache_status = ___('No');
    $opcache_advice = ___('Slower performance');
}

$disk_free_space = disk_free_space(SCHLIX_ROOT_PATH);
$disk_total_space = disk_total_space(SCHLIX_ROOT_PATH);

$disk_free_fraction = $disk_free_space / $disk_total_space;
$readable_disk_free_space = get_readable_bytes($disk_free_space);
$readable_disk_total_space = get_readable_bytes($disk_total_space);
$disk_free_percent = number_format( $disk_free_fraction * 100, 2);

$memory_usage = memory_get_usage(TRUE);
$memory_max = get_estimated_php_memory_limit();
$memory_fraction = $memory_usage / $memory_max;
$readable_memory_usage = get_readable_bytes($memory_usage);
$readable_memory_max = get_readable_bytes($memory_max);
$memory_usage_percent =number_format( $memory_fraction * 100, 2);
?>
<table class="table table-responsive table-hover ">
    <tr>
        <td><i class="fas fa-home"></i> <?= ___('Site name') ?></td>
        <td><?= ___h(SCHLIX_SITE_NAME) ?> </td>
    </tr>      
    <?php /*<tr>
        <td><i class="fas fa-folder text-orange"></i> <?= ___('Root directory') ?></td>
        <td><?= ___h(SCHLIX_ROOT_PATH) ?> </td>
    </tr>   */ ?>   
    <tr>
        <td><i class="fas fa-folder text-orange"></i> <?= ___('Current Sub-site path') ?></td>
        <td><?= ___h(CURRENT_SUBSITE_URL_PATH) ?> </td>
    </tr>      
    
    <tr>
        <td><i class="fab fa-schlix text-schlix-logo"></i> SCHLIX CMS <?= ___('version') ?></td>
        <td><?= SCHLIX_VERSION ?></td>
    </tr>
    <tr>
        <td><i class="far fa-flag"></i> <?= ___('Language') ?></td>
        <td><?= $current_language ?> <a style="float:right" class="btn btn-primary btn-xs schlix-command-button" data-schlix-command="global-config" data-schlix-app-action="editglobalconfig"  > <i class="far fa-edit"></i> <?= ___('Change') ?></a></td>
    </tr>
    
    
    <tr>
        <td><i class="fas fa-window-restore text-purple"></i> <?= ___('Front page application') ?></td>
        <td><?= ___h($main_frontend_app) ?> <a style="float:right" class="btn btn-primary btn-xs schlix-command-button" data-schlix-command="global-config" data-schlix-app-action="editglobalconfig"> <i class="far fa-edit"></i> <?= ___('Change') ?></a></td>
    </tr>
    
    <tr>
        <td><i class="fas fa-window-restore text-purple"></i> <?= ___('Theme') ?></td>
        <td><?= ___h($current_theme) ?> <a style="float:right" class="btn btn-primary btn-xs schlix-command-button" href="<?=  $url_theme_manager ?>"> <i class="far fa-edit"></i> <?= ___('Change') ?></a></td>
    </tr>
    
    <tr>
        <td><i class="fas fa-desktop"></i> <?= ___('System') ?></td>
        <td><?= ___h(@php_uname("s") . ' ' . @php_uname("r") . ' ' . @php_uname("m")); ?></td>
    </tr>
    
    <tr>
        <td><i class="fas fa-server"></i> <?= ___('Web Server') ?></td>
        <td><?=  ___h(@php_uname("n").' ['.$_SERVER['SERVER_ADDR'].'] - '.$_SERVER['SERVER_SOFTWARE']) ?></td>
    </tr>
    
    <tr>
        <td><i class="fab fa-php"></i> PHP</td>
        <td><?=  @phpversion() . ' - ' . @php_sapi_name(). ' - Zend v'.zend_version(); ?></td>
    </tr>
    
    <tr>
        <td><i class="fas fa-tachometer-alt"></i> PHP <?= ___('Opcache Enabled') ?></td>
        <td><i class="<?= $opcache_icon ?>" style="color: <?= $opcache_icon_colour ?>"></i> <?= $opcache_status ?> - <?= $opcache_advice ?> </td>
    </tr>      
    <tr>
        <td><i class="fas fa-hdd-o text-cadetblue"></i> <?= ___('Disk space') ?></td>
        <td><meter max="1.0" min="0.0" value="<?= $disk_free_fraction ?>" low="0.3" high="0.5" optimum="0.51"></meter> 
                <?= $disk_free_percent ?>% <?= ___('free')  ?> (<?= $readable_disk_free_space ?> <?= ___('out of ') ?> <?= $readable_disk_total_space ?>)
                </td>
    </tr>      
    
    <tr>
        <td><i class="fas fa-upload text-cadetblue"></i> <?= ___('Max upload size') ?></td>
        <td><?= get_readable_bytes( get_real_max_upload_size())  ?></td>
    </tr>   
    <tr>
        <td><i class="fas fa-user"></i> <?= ___('Script owner') ?></td>
        <td><?= get_current_user(). ' ('.getmyuid().')' ?></td>
    </tr>        
    
    <tr>
        <td><i class="far fa-clock"></i> <?= ___('Script max execution timeout') ?></td>
        <td><?= ini_get('max_execution_time') ?> <?= ___('seconds') ?></td>
    </tr>        
    
    
    <tr>
        <td><i class="fas fa-database text-slategray"></i> <?= ___('Database') ?></td>
        <td><?= ___h(SCHLIX_DB_DATABASE)  ?> (MySQL <?= $SystemDB->server_info  ?>)</td>
    </tr>        
    
    <tr>
        <td><i class="fas fa-memory"></i> <?= ___('Script Memory Usage') ?></td>
        <td>
            <?php /*<meter max="1.0" min="0.0" value="<?= $memory_free_fraction ?>" low="0.3" high="0.5" optimum="0.4"></meter> */ ?>
                <?= $memory_usage_percent ?>% (<?= $readable_memory_usage ?>)</td>
    </tr>      
    <tr>
        <td><i class="fas fa-network-wired"></i> <?= ___('Your IP Address') ?></td>
        <td><?= get_user_real_ip_address() ?> </td>
    </tr>      
    
    
</table> 