<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

global $CurrentUser;

$invalid_retries_before_captcha = $CurrentUser->getConfig('int_number_of_login_retry_before_captcha', 20);
$enable_captcha_for_user_login = $CurrentUser->getConfig('bool_enable_captcha_user_login');
$show_captcha = $enable_captcha_for_user_login || rate_limit_exceeded('invalid_password_retry', $invalid_retries_before_captcha, 3600);

$force_ssl_admin_login = $SystemConfig->get(SCHLIX_DEFAULT_USER_CLASS,'bool_force_ssl_admin_authentication');
$post_location = ($force_ssl_admin_login == 1) ? force_https_url().$this->createFriendlyUrl('userlogin') : $this->createFriendlyUrl('userlogin');

?>
<div class="admin-login">
    <div class="heading">
        <img src="https://logo.schlix.com/images/schlix_login_logo.png" alt="SCHLIX" class="schlix-logo" />
        <div id="schlix-login-output" class="schlix-ajax-output">
        </div>
    </div> 
        <x-ui:form-simple-ajax class="schlix-cms-simpleform" id="admin-login-form" data-action="<?= $post_location ?>" method="post" data-output="schlix-login-output" enctype="multipart/form-data" >
            <x-ui:csrf />
            <x-ui:textbox name="username" id="username" input-group-size="large" type="text" required="required" fonticon="fa fa-user" placeholder="<?= ___('Username') ?>" autofocus="true" />
            <x-ui:password name="password" id="password" input-group-size="large" type="text" required="required" fonticon="fa fa-lock" placeholder="<?= ___('Password') ?>" value="" />
                                                        
            <?php if ($show_captcha): ?>
            <x-ui:captcha id="verification_code" name="verification_code" required="required" title="<?= ___('Please enter a valid captcha') ?>" fonticon="far fa-hand-paper" input-group-size="large" data-no-label="1" />
            <?php endif; ?>
             
             <x-ui:row>
                 <x-ui:column xs="6">
                     <x-ui:button button-type="warning" type="submit" data-form-submit="1" fonticon="far fa-arrow-alt-circle-right" label="<?= ___('Login') ?>" />            
                 </x-ui:column>
                 <x-ui:column xs="6">
                     <x-ui:checkbox id="chkremember" name="remember" value="1" label="<?= ___('Remember Me'); ?>" />
                     <a class="forgot-password-link" href="<?= $CurrentUser->createFriendlyUrl('action=forgotpassword'); ?>"><i class="fa fa-question-circle"></i> <?= ___('Forgot password') ?></a>
                 </x-ui:column>                 
             </x-ui:row>
            

            
        </x-ui:form-simple-ajax>
    
</div>