<?php

/**
 * Этот файл является частью программы "CRM Руководитель" - конструктор CRM систем для бизнеса
 * https://www.rukovoditel.net.ru/
 * 
 * CRM Руководитель - это свободное программное обеспечение, 
 * распространяемое на условиях GNU GPLv3 https://www.gnu.org/licenses/gpl-3.0.html
 * 
 * Автор и правообладатель программы: Харчишина Ольга Александровна (RU), Харчишин Сергей Васильевич (RU).
 * Государственная регистрация программы для ЭВМ: 2023664624
 * https://fips.ru/EGD/3b18c104-1db7-4f2d-83fb-2d38e1474ca3
 */

class fieldtype_input_ip
{
    public $options;

    function __construct()
    {
        $this->options = array('title' => TEXT_FIELDTYPE_INPUT_IP_TITLE);
    }

    function get_configuration()
    {
        $cfg = array();

        $cfg[] = array('title' => TEXT_ALLOW_SEARCH, 'name' => 'allow_search', 'type' => 'checkbox', 'tooltip_icon' => TEXT_ALLOW_SEARCH_TIP);

        $cfg[] = array('title' => TEXT_HIDE_FIELD_IF_EMPTY, 'name' => 'hide_field_if_empty', 'type' => 'checkbox', 'tooltip_icon' => TEXT_HIDE_FIELD_IF_EMPTY_TIP);

        $cfg[] = array('title' => TEXT_IS_UNIQUE_FIELD_VALUE, 'name' => 'is_unique', 'type' => 'dropdown', 'choices' => fields_types::get_is_unique_choices(_POST('entities_id')), 'tooltip_icon' => TEXT_IS_UNIQUE_FIELD_VALUE_TIP, 'params' => array('class' => 'form-control input-large'));
        $cfg[] = array('title' => TEXT_ERROR_MESSAGE, 'name' => 'unique_error_msg', 'type' => 'input', 'tooltip_icon' => TEXT_UNIQUE_FIELD_VALUE_ERROR_MSG_TIP, 'tooltip' => TEXT_DEFAULT . ': ' . TEXT_UNIQUE_FIELD_VALUE_ERROR, 'params' => array('class' => 'form-control input-xlarge'));

        return $cfg;
    }

    function render($field, $obj, $params = array())
    {
        $cfg = new fields_types_cfg($field['configuration']);

        $attributes = array(
            'class' => 'form-control input-ip' .
            ' fieldtype_input field_' . $field['id'] .
            ($field['is_heading'] == 1 ? ' autofocus' : '') .
            ($field['is_required'] == 1 ? ' required noSpace' : '') .
            ($cfg->get('is_unique')>0 ? ' is-unique' : ''),            
        );

        $attributes = fields_types::prepare_uniquer_error_msg_param($attributes, $cfg);
        
        $script = '
            <script>
            $("#fields_' . $field['id'] . '").inputmask({
                alias: "ip",
                greedy: false,
                clearIncomplete:true,
            });
            </script>
            ';

        return input_tag('fields[' . $field['id'] . ']', $this->long2ip($obj['field_' . $field['id']]), $attributes) . $script;
    }

    function process($options)
    {
        return ip2long(db_prepare_input($options['value']));
    }

    function output($options)
    {
        return $this->long2ip($options['value']);
    }
    
    function long2ip($value)
    {
        return ($value>0 ? long2ip($value) : '');
    }
    
}
