/*
 MapBBCode, a JavaScript library for parsing, displaying and editing [map] code.
 Version 1.2.0 built on 25.12.2013
 http://mapbbcode.org
 (c) 2013, Ilya Zverev
*/
!function(window,document,undefined){var L=window.L;window.MapBBCodeProcessor={options:{decimalDigits:5,brackets:"[]",tagParams:!1,shareTag:"mapid"},setOptions:function(t){for(var e in t)t.hasOwnProperty(e)&&(this.options[e]=t[e])},_getRegExp:function(){var t=this.options.brackets.substring(0,1).replace(/([\[\({])/,"\\$1"),e=this.options.brackets.substring(1,2).replace(/([\]\)}])/,"\\$1"),o="\\s*(-?\\d+(?:\\.\\d+)?)\\s*,\\s*(-?\\d+(?:\\.\\d+)?)",i="\\((?:([a-zA-Z0-9,]*)\\|)?(|[\\s\\S]*?[^\\\\])\\)",n=o+"(?:"+o+")*(?:\\s*"+i+")?",r=t+"map(?:"+(this.options.tagParams?"\\s+z=['\"]([12]?\\d)['\"](?:\\s+ll=['\"]"+o+"['\"])?":"=['\"]?([12]?\\d)(?:,"+o+")?")+")?['\"]?"+e,a=t+"map"+e+"\\s*"+t+"/map"+e,s=r+"("+n+"(?:\\s*;"+n+")*)?\\s*"+t+"/map"+e;return{coord:o,params:i,mapElement:n,map:s,mapEmptyCompiled:new RegExp(a,"i"),mapCompiled:new RegExp(s,"i")}},getOpenTagSubstring:function(){return this.options.brackets.substring(0,1)+"map"},getOpenTagWithPart:function(t){return this.options.brackets.substring(0,1)+"map"+(t&&t.length>0?(this.options.tagParams?" "==t.substring(0,1)?"":" ":"="==t.substring(0,1)?"":"=")+t:"")+this.options.brackets.substring(1,2)},getOpenTag:function(t,e){return this.options.brackets.substring(0,1)+"map"+(t||"0"===t?this.options.tagParams?' z="'+t+'"'+(e?' ll="'+e+'"':""):"="+t+(e?","+e:""):"")+this.options.brackets.substring(1,2)},getCloseTag:function(){return this.options.brackets.substring(0,1)+"/map"+this.options.brackets.substring(1,2)},getShareTag:function(t){var e=this.options.brackets.substring(0,1),o=this.options.brackets.substring(1,2),i=this.options.shareTag||"mapid";return t?e+i+o+t+e+"/"+i+o:e+i+o},getBBCodeRegExp:function(){return this._getRegExp().mapCompiled},isValid:function(t){return this._getRegExp().mapCompiled.test(t)},isEmpty:function(t){return this._getRegExp().mapEmptyCompiled.test(t)},stringToObjects:function(t){var e=this._getRegExp(),o=t.match(e.mapCompiled),i={objs:[]};if(o&&o[1]&&o[1].length&&+o[1]>0&&(i.zoom=+o[1],o[3]&&o[3].length>0))try{i.pos=L&&L.LatLng?new L.LatLng(o[2],o[3]):[+o[2],+o[3]]}catch(n){}if(o&&o[4]){var r,a=o[4],s=new RegExp("^\\s*(?:;\\s*)?("+e.mapElement+")"),l=new RegExp("^"+e.coord);for(r=a.match(s);r;){var d,p=r[1],c=[],h="",u=[];for(d=p.match(l);d;)c.push(L&&L.LatLng?new L.LatLng(d[1],d[2]):[+d[1],+d[2]]),p=p.substring(d[0].length),d=p.match(l);r[6]&&(u=r[6].split(",")),"string"==typeof r[7]&&r[7].length>0&&(h=r[7].replace(/\\\)/g,")").replace(/^\s+|\s+$/g,"")),i.objs.push({coords:c,text:h,params:u}),a=a.substring(r[0].length),r=a.match(s)}}return i},objectsToString:function(t){var e,o;t.zoom>0&&(e=t.zoom,t.pos&&(o=this._latLngToString(t.pos)));for(var i=[],n=[],r=t.objs||[],a=0;a<r.length;a++)if(r[a]&&"coords"in r[a]){for(var s=r[a].coords,l="",d=0;d<s.length;d++)d>0&&(l+=" "),l+=this._latLngToString(s[d]);var p=r[a].text||"",c=r[a].params||[];p.indexOf("|")>=0&&0===c.length&&(p="|"+p),(p.length>0||c.length>0)&&(l=l+"("+(c.length>0?c.join(",")+"|":"")+p.replace(/\)/g,"\\)")+")"),s.length&&(1==s.length?i.push(l):n.push(l))}return i.length||n.length||e?this.getOpenTag(e,o)+i.concat(n).join("; ")+this.getCloseTag():""},_latLngToString:function(t){var e=Math.pow(10,this.options.decimalDigits);return""+Math.round((t.lat||t[0])*e)/e+","+Math.round((t.lng||t[1])*e)/e}},window.MapBBCode=L.Class.extend({options:{createLayers:null,layers:null,maxInitialZoom:15,defaultPosition:[22,11],defaultZoom:2,leafletOptions:{},polygonOpacity:.1,editorHeight:400,viewWidth:600,viewHeight:300,fullViewHeight:600,fullScreenButton:!0,fullFromStart:!1,windowWidth:800,windowHeight:500,windowFeatures:"resizable,status,dialog",windowPath:"lib/mapbbcode-window.html",editorCloseButtons:!0,confirmFormSubmit:!0,outerLinkTemplate:!1,helpButton:!0,allowedHTML:"[auib]|span|br|em|strong|tt",letterIconLength:2,popupIconLength:30,enablePolygons:!0,preferStandardLayerSwitcher:!0,hideInsideClasses:[],watchResize:!1,panelHook:null,externalEndpoint:"http://share.mapbbcode.org/",exportTypes:"csv,geojson,gpx,plt,wpt,kml",uploadButton:!1},strings:{},initialize:function(t){L.setOptions(this,t),L.Browser.ie&&t&&t.defaultPosition&&"splice"in t.defaultPosition&&2==t.defaultPosition.length&&(this.options.defaultPosition=[t.defaultPosition[0],t.defaultPosition[1]])},setStrings:function(t){this.strings=L.extend({},this.strings,t)},_eachHandler:function(t,e,o){var i=window.mapBBCodeHandlers;if(i)for(var n=0;n<i.length;n++)(!o||"applicableTo"in i[n]&&i[n].applicableTo(o))&&t.call(e||this,i[n])},objectToLayer:function(t){var e;return 1==t.coords.length?e=L.marker(t.coords[0]):t.coords.length>2&&t.coords[0].equals(t.coords[t.coords.length-1])?(t.coords.splice(t.coords.length-1,1),e=L.polygon(t.coords,{weight:3,opacity:.7,fill:!0,fillOpacity:this.options.polygonOpacity})):e=L.polyline(t.coords,{weight:5,opacity:.7}),this._eachHandler(function(o){if("objectToLayer"in o){var i=[];if("reKeys"in o)for(var n=0;n<t.params.length;n++)o.reKeys.test(t.params[n])&&i.push(t.params[n]);o.objectToLayer(e,o.text?t.text:i,this)}},this,e),e._objParams=t.params,e},_zoomToLayer:function(t,e,o,i){var n=e.getBounds();if(!n||!n.isValid())return o&&o.zoom?t.setView(o.pos||this.options.defaultPosition,o.zoom):i&&t.setView(this.options.defaultPosition,this.options.defaultZoom),void 0;var r=function(){if(o&&o.pos)t.setView(o.pos,o.zoom||this.options.maxInitialZoom);else{var e=Math.max(this.options.maxInitialZoom,i?0:t.getZoom());t.fitBounds(n,{animate:!1,paddingTopLeft:[30,30],paddingBottomRight:[30,5]}),o&&o.zoom?t.setZoom(o.zoom,{animate:!1}):t.getZoom()>e&&t.setZoom(e,{animate:!1})}},a=t.getBoundsZoom(n,!1);a?r.call(this):t.on("load",r,this)},createOpenStreetMapLayer:function(t){var e=t||L;return e.tileLayer("http://tile.openstreetmap.org/{z}/{x}/{y}.png",{name:"OpenStreetMap",attribution:'Map &copy; <a href="http://openstreetmap.org">OpenStreetMap</a>',minZoom:2,maxZoom:18})},_addLayers:function(t){var e=this.options.createLayers?this.options.createLayers.call(this,L):null;if(e&&e.length||!window.layerList||!this.options.layers||(e=window.layerList.getLeafletLayers(this.options.layers,L)),e&&e.length||(e=[this.createOpenStreetMapLayer(L)]),t.addLayer(e[0]),e.length>1){var o,i;if(!this.options.preferStandardLayerSwitcher&&L.StaticLayerSwitcher)for(o=L.staticLayerSwitcher(null,{enforceOSM:!0}),i=0;i<e.length;i++)e[i]&&"options"in e[i]&&o.addLayer(e[i].options.name,e[i]);else for(o=L.control.layers(),i=0;i<e.length;i++)e[i]&&"options"in e[i]&&o.addBaseLayer(e[i],e[i].options.name);t.addControl(o)}},_hideClassPresent:function(t){if("string"!=typeof t.className)return!1;var e,o,i=t.className.split(" "),n=this.options.hideInsideClasses;if(!n||!n.length)return!1;for(e=0;e<i.length;e++)for(o=0;o<n.length;o++)if(i[e]===n[o])return!0;return t.parentNode&&this._hideClassPresent(t.parentNode)},_checkResize:function(t,e){var o=new L.Point(t.getContainer().clientWidth,t.getContainer().clientHeight);if("_oldSize"in t||(t._oldSize=o),o.x&&o.y){var i=o.subtract(t._oldSize);(i.x||i.y)&&(t._oldSize=o,t._sizeChanged=!0,this._zoomToLayer(t,e)),!this.options.watchResize&&t._bbSizePinger&&window.clearInterval(t._bbSizePinger)}},_createControlAndCallHooks:function(t,e,o,i){var n={_ui:this,map:e,close:function(){this.map=this._ui=null,t.close()},eachLayer:function(t,e){o.eachLayer(function(o){t.call(e||this,o)},this)},zoomToData:function(){this._ui._zoomToLayer(e,o)}};return n=L.extend(n,i),this._eachHandler(function(t){"panelHook"in t&&t.panelHook(n,this)}),this.options.panelHook&&this.options.panelHook.call(this,n),n},_px:function(t){return t?t+"px":"100%"},_createMapPanel:function(t,e){var o="string"==typeof t?document.getElementById(t):t;if(o){var i=o.getAttribute("bbcode")||o.getAttribute("value")||o.innerHTML.replace(/^\s+|\s+$/g,""),n=window.MapBBCodeProcessor.getCloseTag();if(i&&i.toLowerCase().indexOf(n)<0||!i&&o.getAttribute("map")){var r=o.getAttribute("map"),a=window.MapBBCodeProcessor.getOpenTagWithPart(r);i=a+i+n}for(;o.firstChild;)o.removeChild(o.firstChild);if(e||!this._hideClassPresent(o)){var s=document.createElement("div");return s.style.width=e?"100%":this.options.fullFromStart?"100%":this._px(this.options.viewWidth),s.style.height=e?this._px(this.options.editorHeight):this.options.fullFromStart?this._px(this.options.fullViewHeight):this._px(this.options.viewHeight),o.appendChild(s),s.storedBBCode=i,s.close=function(){o.removeChild(s)},s}}},show:function(t,e){var o=this._createMapPanel(t);if(o){e||(e=o.storedBBCode),e&&"string"==typeof e||(e="");var i=L.map(o,L.extend({},{scrollWheelZoom:!1,zoomControl:!1,attributionEditLink:!0},this.options.leafletOptions));i.once("focus",function(){i.scrollWheelZoom.enable()}),i.addControl(new L.Control.Zoom({zoomInTitle:this.strings.zoomInTitle,zoomOutTitle:this.strings.zoomOutTitle})),i.attributionControl&&i.attributionControl.setPrefix('<a href="http://mapbbcode.org" title="'+this.strings.mapbbcodeTitle+'">MapBBCode</a>'),this._addLayers(i);var n=new L.FeatureGroup;n.addTo(i);for(var r=window.MapBBCodeProcessor.stringToObjects(e),a=r.objs,s=0;s<a.length;s++)this.objectToLayer(a[s]).addTo(n);if(this._zoomToLayer(i,n,{zoom:r.zoom,pos:r.pos},!0),(!o.offsetHeight||this.options.watchResize)&&(i._bbSizePinger=window.setInterval(L.bind(this._checkResize,this,i,n),500)),this.options.fullScreenButton&&!this.options.fullFromStart){var l,d=L.functionButtons([{content:window.MapBBCode.buttonsImage,bgPos:[0,0],alt:"&#x2198;",title:this.strings.fullScreenTitle}],{position:"topright"}),p=!1;i.addControl(d),d.on("clicked",function(){var t=i.getContainer().style;p||l||(l=[t.width,t.height]),p=!p,t.width=p?"100%":l[0],t.height=p?this._px(this.options.fullViewHeight):l[1],i.invalidateSize(),d.setBgPos([p?26:0,0]);var e=p?1:-1;i.setZoom(i.getZoom()+e,{animate:!1})},this)}if(this.options.outerLinkTemplate&&"http"==this.options.outerLinkTemplate.substring(0,4)){var c=L.functionButtons([{content:window.MapBBCode.buttonsImage,bgPos:[52,0],alt:"&#x21B7;",title:this.strings.outerTitle,href:"about:blank"}],{position:"topright"}),h=this.options.outerLinkTemplate,u=function(){c.setHref(h.replace("{zoom}",i.getZoom()).replace("{lat}",L.Util.formatNum(i.getCenter().lat,4)).replace("{lon}",L.Util.formatNum(i.getCenter().lng,4)))};u(),i.on("move",u),i.addControl(c)}return this._createControlAndCallHooks(o,i,n,{editor:!1,getBBCode:function(){return e},updateBBCode:function(t,o){e=t;var r=window.MapBBCodeProcessor.stringToObjects(e),a=r.objs;n.clearLayers();for(var s=0;s<a.length;s++)this._ui.objectToLayer(a[s]).addTo(n);o||this._ui._zoomToLayer(i,n,{zoom:r.zoom,pos:r.pos},!0)},toggleObjects:function(t){return t===undefined&&(t=!i.hasLayer(n)),t?i.addLayer(n):i.removeLayer(n),t}})}}}),L.FunctionButtons=L.Control.extend({includes:L.Mixin.Events,initialize:function(t,e){"push"in t&&"splice"in t||(t=[t]),this._buttons=t,!e&&t.length>0&&"position"in t[0]&&(e={position:t[0].position}),L.Control.prototype.initialize.call(this,e)},onAdd:function(t){this._map=t,this._links=[];for(var e=L.DomUtil.create("div","leaflet-bar"),o=0;o<this._buttons.length;o++){var i=this._buttons[o],n=L.DomUtil.create("a","",e);n._buttonIndex=o,n.href=i.href||"#",i.href&&(n.target="funcbtn"),n.style.padding="0 4px",n.style.width="auto",n.style.minWidth="20px",i.bgColor&&(n.style.backgroundColor=i.bgColor),i.title&&(n.title=i.title),i.link=n,this._updateContent(o);var r=L.DomEvent.stopPropagation;L.DomEvent.on(n,"click",r).on(n,"mousedown",r).on(n,"dblclick",r),i.href||L.DomEvent.on(n,"click",L.DomEvent.preventDefault).on(n,"click",this.clicked,this)}return e},_updateContent:function(t){if(!(t>=this._buttons.length)){var e=this._buttons[t],o=e.link,i=e.content;if(o)if(i===undefined||i===!1||null===i||""===i)o.innerHTML=e.alt||"&nbsp;";else if("string"==typeof i){var n=i.length<4?"":i.substring(i.length-4),r="data:image/"===i.substring(0,11);".png"===n||".gif"===n||".jpg"===n||r?(o.style.width=""+(e.imageSize||26)+"px",o.style.height=""+(e.imageSize||26)+"px",o.style.padding="0",o.style.backgroundImage="url("+i+")",o.style.backgroundRepeat="no-repeat",o.style.backgroundPosition=e.bgPos?-e.bgPos[0]+"px "+-e.bgPos[1]+"px":"0px 0px"):o.innerHTML=i}else{for(;o.firstChild;)o.removeChild(o.firstChild);o.appendChild(i)}}},setContent:function(t,e){e===undefined&&(e=t,t=0),t<this._buttons.length&&(this._buttons[t].content=e,this._updateContent(t))},setTitle:function(t,e){if(e===undefined&&(e=t,t=0),t<this._buttons.length){var o=this._buttons[t];o.title=e,o.link&&(o.link.title=e)}},setBgPos:function(t,e){if(e===undefined&&(e=t,t=0),t<this._buttons.length){var o=this._buttons[t];o.bgPos=e,o.link&&(o.link.style.backgroundPosition=e?-e[0]+"px "+-e[1]+"px":"0px 0px")}},setHref:function(t,e){if(e===undefined&&(e=t,t=0),t<this._buttons.length){var o=this._buttons[t];o.href=e,o.link&&(o.link.href=e)}},clicked:function(t){for(var e=window.event&&window.event.srcElement||t.target||t.srcElement;e&&"tagName"in e&&"A"!==e.tagName&&!("_buttonIndex"in e);)e=e.parentNode;if("_buttonIndex"in e){var o=this._buttons[e._buttonIndex];o&&("callback"in o&&o.callback.call(o.context),this.fire("clicked",{idx:e._buttonIndex}))}}}),L.functionButtons=function(t,e){return new L.FunctionButtons(t,e)},L.functionButton=function(t,e,o){return e?e.content=t:e={content:t},L.functionButtons([e],o)},window.MapBBCode.buttonsImage="data:image/png;base64,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","mapBBCodeHandlers"in window||(window.mapBBCodeHandlers=[]),window.mapBBCodeHandlers.unshift({text:!0,reKeys:new RegExp("a^"),applicableTo:function(){return!0},objectToLayer:function(t,e,o){if(e){t._text=e;var i=this._getIcon(t,e,o);i?(t.setIcon(i),t.options.clickable=!1,L.PopupIcon&&i instanceof L.PopupIcon&&(i.options.selectable=!0,i.bindTo(t))):t.bindPopup(e.replace(new RegExp("<(?!/?("+o.options.allowedHTML+")[ >])","g"),"&lt;"))}else t.options.clickable=!1},_getIcon:function(t,e,o){if(t instanceof L.Marker&&e.length>0){if(L.LetterIcon&&e.length<=o.options.letterIconLength)return new L.LetterIcon(e);if(L.PopupIcon&&e.length<=o.options.popupIconLength&&e.indexOf("<")<0)return new L.PopupIcon(e)}},layerToObject:function(t){return t.inputField?t.inputField.value.replace(/\\n/g,"\n").replace(/\\\n/g,"\\n"):t._text||""},createEditorPanel:function(t,e){if(t instanceof L.Marker){var o=document.createElement("div"),i=document.createTextNode(e.strings.title+": "),n=document.createElement("input");return n.type="text",n.size=20,t._text&&(n.value=t._text.replace(/\\n/g,"\\\\n").replace(/[\r\n]+/g,"\\n")),o.appendChild(i),o.appendChild(n),o.style.marginBottom="8px",t.inputField=n,t.options.draggable=!0,t.defaultIcon=new L.Icon.Default,n.onkeypress=function(e){var o=window.event?(e||window.event).which:e.keyCode;return 27==o||13==o?(t.closePopup(),e.preventDefault(),!1):void 0},t.on("popupopen",function(){n.focus()}),t.on("popupclose",function(){var o=t.inputField.value,i=this._getIcon(t,o,e)||t.defaultIcon;t.setIcon(i)},this),o}}}),window.MapBBCode.include({layerToObject:function(t){var e={};if(t instanceof L.Marker)e.coords=[t.getLatLng()];else if(t.getLatLngs){var o,i=t.getLatLngs(),n=i.length,r=[];for(o=0;n>o;o++)r.push(i[o]);t instanceof L.Polygon&&r.push(r[0]),e.coords=r}return e.params=t._objParams||[],this._eachHandler(function(o){if(o.text&&"layerToObject"in o){var i=o.layerToObject(t,"",this);i&&(e.text=i)}else if("layerToObject"in o){var n,r=[];if("reKeys"in o)for(n=e.params.length-1;n>=0;n--)o.reKeys.test(e.params[n])&&r.unshift(e.params.splice(n,1));var a=o.layerToObject(t,r,this);if(a&&a.length>0)for(n=0;n<a.length;n++)e.params.push(a[n])}},this,t),e},_makeEditable:function(t,e){var o=document.createElement("div");o.style.textAlign="center",o.style.clear="both";var i=document.createElement("input");if(i.type="button",i.value=this.strings.close,i.onclick=function(){t.closePopup()},o.appendChild(i),e){var n=document.createElement("input");n.type="button",n.value=this.strings.remove,n.onclick=function(){t.closePopup(),e.removeLayer(t)},o.appendChild(n)}var r=document.createElement("div");return t.options.clickable=!0,(t instanceof L.Polyline||t instanceof L.Polygon)&&t.editing.enable(),this._eachHandler(function(e){var o="createEditorPanel"in e?e.createEditorPanel(t,this):null;o&&r.appendChild(o)},this,t),r.appendChild(o),t.bindPopup(r),t},_findParentForm:function(t){for(var e=t;e&&"FORM"!=e.tagName&&"HTML"!=e.tagName;)e=e.parentElement;return e&&"FORM"==e.tagName?e:!1},_addSubmitHandler:function(t,e){var o=this._getBBCode(t,e),i=this._findParentForm(t.getContainer());i&&L.DomEvent.on(i,"submit",function(i){if(this._findParentForm(t.getContainer())){var n=this._getBBCode(t,e);n!=o&&e.getLayers().length>0&&(window.confirm(this.strings.submitWarning)||L.DomEvent.preventDefault(i))}},this)},_findMapInTextArea:function(t){var e=window.MapBBCodeProcessor.getOpenTagSubstring(),o=window.MapBBCodeProcessor.getCloseTag(),i=t.value,n="selectionStart"in t?t.selectionStart:i.indexOf(o);if(n>=i.length||i.length<10||i.indexOf(o)<0)return"";var r=i.lastIndexOf(e,n);if(r>=0){var a=i.indexOf(o,r);if(a+o.length>n){var s=i.substring(r,a+6);if(window.MapBBCodeProcessor.isValid(s))return s}}return""},_updateMapInTextArea:function(t,e,o){var i=t.selectionStart,n=t.value;t.value=e.length&&n.indexOf(e)>=0?n.replace(e,o):!("selectionStart"in t)||i>=n.length?n+o:n.substring(0,i)+o+n.substring(i)},_getBBCode:function(t,e){var o=[];e.eachLayer(function(t){o.push(this.layerToObject(t))},this);var i=!o.length||t.wasPositionSet;return window.MapBBCodeProcessor.objectsToString({objs:o,zoom:i?t.getZoom():0,pos:i?t.getCenter():0})},editor:function(t,e,o,i){var n=this._createMapPanel(t,!0);if(n){var r=this.strings,a=L.map(n,L.extend({},{zoomControl:!1},this.options.leafletOptions));a.addControl(new L.Control.Zoom({zoomInTitle:r.zoomInTitle,zoomOutTitle:r.zoomOutTitle})),a.attributionControl&&a.attributionControl.setPrefix('<a href="http://mapbbcode.org" title="'+r.mapbbcodeTitle+'">MapBBCode</a>'),L.Control.Search&&a.addControl(new L.Control.Search({title:r.searchTitle})),this._addLayers(a);var s;"string"!=typeof e&&(s=e,e=this._findMapInTextArea(s));for(var l=new L.FeatureGroup,d=window.MapBBCodeProcessor.stringToObjects(e),p=d.objs,c=0;c<p.length;c++)this._makeEditable(this.objectToLayer(p[c]).addTo(l),l);l.addTo(a),this._zoomToLayer(a,l,{zoom:d.zoom,pos:d.pos},!0),a.wasPositionSet=p.length>0&&!!d.pos;var h=L.drawLocal.draw.toolbar,u=L.drawLocal.draw.handlers;h.actions.text=r.cancel,h.actions.title=r.drawCancelTitle,h.undo.text=r.undoPoint,h.undo.title=r.undoPointTitle,h.buttons.polyline=r.polylineTitle,h.buttons.polygon=r.polygonTitle,h.buttons.marker=r.markerTitle,u.marker.tooltip.start=r.markerTooltip,u.polyline.tooltip.start=r.polylineStartTooltip,u.polyline.tooltip.cont=r.polylineContinueTooltip,u.polyline.tooltip.end=r.polylineEndTooltip,u.polygon.tooltip.start=r.polygonStartTooltip,u.polygon.tooltip.cont=r.polygonContinueTooltip,u.polygon.tooltip.end=r.polygonEndTooltip;var g=new L.Control.Draw({position:"topleft",draw:{marker:!0,polyline:{showLength:!1,guidelineDistance:10,shapeOptions:{color:"#0033FF",weight:5,opacity:.7}},polygon:this.options.enablePolygons?{showArea:!1,guidelineDistance:10,shapeOptions:{color:"#0033FF",weight:3,opacity:.7,fillOpacity:this.options.polygonOpacity}}:!1,rectangle:!1,circle:!1},edit:{featureGroup:l,edit:!1,remove:!1}});if(this._eachHandler(function(t){"initDrawControl"in t&&t.initDrawControl(g)}),a.addControl(g),a.on("draw:created",function(t){var e=t.layer;this._eachHandler(function(t){"initLayer"in t&&t.initLayer(e)},this,e),this._makeEditable(e,l),l.addLayer(e),"marker"===t.layerType&&e.openPopup()},this),this.options.editorCloseButtons){var m=L.functionButtons([{content:"<b>"+r.apply+"</b>",title:r.applyTitle}],{position:"topleft"});if(m.on("clicked",function(){var t=this._getBBCode(a,l);n.close(),s&&this._updateMapInTextArea(s,e,t),o&&o.call(i,t)},this),a.addControl(m),this.options.uploadButton&&this._upload){var f=L.functionButtons([{content:r.upload,title:r.uploadTitle}],{position:"topleft"});f.on("clicked",function(){this._upload(n,l.getLayers().length?this._getBBCode(a,l):!1,function(t){n.close();var r=window.MapBBCodeProcessor.getShareTag(t);s&&this._updateMapInTextArea(s,e,r),o&&o.call(i,r)})},this),a.addControl(f)}var y=L.functionButtons([{content:r.cancel,title:r.cancelTitle}],{position:"topright"});y.on("clicked",function(){n.close(),o&&o.call(i,null)},this),a.addControl(y)}if(this.options.helpButton){var v=L.functionButtons([{content:'<span style="font-size: 18px; font-weight: bold;">?</span>',title:r.helpTitle}],{position:"topright"});v.on("clicked",function(){for(var t="",e=r.helpContents.split(/\n+/),o="1.2.0",i="resizable,dialog,scrollbars,height="+this.options.windowHeight+",width="+this.options.windowWidth,n=window.open("","mapbbcode_help",i),a=0;a<e.length;a++)t+=a?"#"===e[a].substring(0,1)?"<h2>"+e[a].replace(/^#\s*/,"")+"</h2>":"<p>"+e[a]+"</p>":"<h1>"+e[0]+"</h1>";t=t.replace("{version}",o),t+='<div id="close"><input type="button" value="'+r.close+'" onclick="javascript:window.close();"></div>';var s="<style>body { font-family: sans-serif; font-size: 12pt; } p { line-height: 1.5; } h1 { text-align: center; font-size: 18pt; } h2 { font-size: 14pt; } #close { text-align: center; margin-top: 1em; }</style>";n.document.open(),n.document.write(s),n.document.write(t),n.document.close(),n.onkeypress=function(t){var e=window.event?(t||window.event).which:t.keyCode;27==e&&n.close()}},this),a.addControl(v)}return this.options.confirmFormSubmit&&this._addSubmitHandler(a,l),this._createControlAndCallHooks(n,a,l,{editor:!0,close:function(){var t=this.getBBCode();this.map=this._ui=null,this.getBBCode=function(){return t},n.close()},getBBCode:function(){return this._ui._getBBCode(a,l)},updateBBCode:function(t,e){var o=window.MapBBCodeProcessor.stringToObjects(t),i=o.objs;l.clearLayers(),a.removeLayer(l);for(var n=0;n<i.length;n++)this._ui._makeEditable(this._ui.objectToLayer(i[n]).addTo(l),l);a.addLayer(l),e||this._ui._zoomToLayer(a,l,{zoom:o.zoom,pos:o.pos},!0)}})}},editorWindow:function(t,e,o){window.storedMapBB={bbcode:t,callback:e,context:o,caller:this};var i=this.options.windowFeatures,n="height="+this.options.windowHeight+",width="+this.options.windowWidth,r=this.options.windowPath,a="/"==r.substring(r.length-1)?r+"mapbbcode-window.html":r;window.open(a,"mapbbcode_editor",i+","+n)}}),window.MapBBCode.include({_getEndpoint:function(){var t=this.options.externalEndpoint;if(!t||"http"!==t.substring(0,4))return"";var e=t.substring(t.length-1);return"/"!=e&&"="!=e&&(t+="/"),t},_ajax:function(t,e,o,i){function n(){var t=r.status;e.call(o,!t&&r.responseText||t>=200&&300>t?!1:t||499,r.responseText)}var r;if(window.XMLHttpRequest&&(r=new window.XMLHttpRequest),!window.XDomainRequest||r&&"withCredentials"in r||(r=new window.XDomainRequest),r){"onload"in r?r.onload=r.onerror=n:r.onreadystatechange=function(){4==r.readyState&&n()};try{i?(r.open("POST",t,!0),r.setRequestHeader("Content-type","application/x-www-form-urlencoded"),r.send(i)):(r.open("GET",t,!0),r.send(null))}catch(a){e.call(o,399)}}},showExternal:function(element,id,callback,context){var endpoint=this._getEndpoint();if(endpoint&&id){var errorDiv=this._createMapPanel(element);errorDiv.style.display="table";var cell=document.createElement("div");cell.style.display="table-cell",cell.style.width="100%",cell.style.backgroundColor="#ddd",cell.style.textAlign="center",cell.style.verticalAlign="middle",cell.innerHTML=this.strings.sharedCodeLoading.replace("{url}",endpoint+id),errorDiv.appendChild(cell);var showMap=function(error,content){var show,result,derror=!1;if(error?derror=!0:result=eval("("+content+")"),error||result.error||!result.bbcode)cell.innerHTML=this.strings.sharedCodeError.replace("{url}",endpoint+id),show={close:function(){errorDiv.close()}};else if(show=this.show(element,result.bbcode),result.title,show){var map=show.map;if(this.options.outerLinkTemplate||map.addControl(L.functionButtons([{content:window.MapBBCode.buttonsImage,bgPos:[52,0],href:endpoint+id,alt:"&#x21B7;",title:this.strings.outerTitle}],{position:"topright"})),L.ExportControl){var ec=new L.ExportControl({name:this.strings.exportName,title:this.strings.exportTitle,filter:"string"==typeof this.options.exportTypes&&this.options.exportTypes.length>0?this.options.exportTypes.split(","):this.options.exportTypes,endpoint:endpoint,codeid:id});map.addControl(ec)}}callback&&callback.call(context||this,show)};this._ajax(endpoint+id+"?api=1",showMap,this)}},_upload:function(mapDiv,bbcode,callback){var outerDiv=document.createElement("div");outerDiv.style.display="table";try{outerDiv.style.backgroundColor="rgba(0, 0, 0, 0.8)"}catch(err){outerDiv.style.backgroundColor="black"}outerDiv.style.zIndex=2e3,outerDiv.style.position="absolute",outerDiv.style.left=outerDiv.style.right=outerDiv.style.top=outerDiv.style.bottom=0,outerDiv.style.width=outerDiv.style.height="100%",mapDiv.appendChild(outerDiv);var back=document.createElement("div");back.style.width=back.style.height="100%",back.style.textAlign="center",back.style.color="white",back.style.verticalAlign="middle",back.style.display="table-cell",back.style.cursor="default";var stop=L.DomEvent.stopPropagation;L.DomEvent.on(back,"click",stop).on(back,"mousedown",stop).on(back,"dblclick",stop),outerDiv.appendChild(back);var cancel=document.createElement("input"),endpoint=this._getEndpoint();if(bbcode){var message=document.createElement("div");message.innerHTML=this.strings.uploading+"...",back.appendChild(message),this._ajax(endpoint+"save?api=1",function(error,content){if(error)message.innerHTML=this.strings.uploadError+": "+error;else{var result=eval("("+content+")");if(result.error||!result.codeid)message.innerHTML=this.strings.uploadError+":<br>"+result.error;else{message.innerHTML=this.strings.uploadSuccess+':<br><a href="'+result.editurl+'" target="editmap" style="line-height: 40px; color: #ccf">'+result.editurl+"</a>";var sthis=this;cancel.onclick=function(){mapDiv.removeChild(outerDiv),callback.call(sthis,result.codeid)}}}},this,"title=&bbcode="+encodeURIComponent(bbcode).replace(/%20/g,"+"))}else{var descDiv=document.createElement("div");descDiv.innerHTML=this.strings.sharedFormHeader,back.appendChild(descDiv);var inputDiv=document.createElement("div"),url=document.createElement("input");url.type="text",url.size=40,inputDiv.appendChild(url);var urlBtn=document.createElement("input");urlBtn.type="button",urlBtn.value=this.strings.apply,inputDiv.appendChild(urlBtn),back.appendChild(inputDiv),url.focus();var errorDiv=document.createElement("div");errorDiv.style.color="#fcc",errorDiv.style.display="none",back.appendChild(errorDiv);var checkCode=function(){errorDiv.style.display="none";var t=new RegExp("(?:/|^)([a-z]+)\\s*$").exec(url.value);if(t){var e=t[1];this._ajax(endpoint+e+"?api=1",function(t,o){t?(errorDiv.innerHTML=this.strings.sharedFormError,errorDiv.style.display="block"):o.substring(0,15).indexOf('"error"')>0?(url.value="",errorDiv.innerHTML=this.strings.sharedFormInvalidCode,errorDiv.style.display="block"):(mapDiv.removeChild(outerDiv),callback.call(this,e))},this)}};L.DomEvent.on(urlBtn,"click",checkCode,this),L.DomEvent.on(url,"keypress",function(t){var e=window.event?(t||window.event).which:t.keyCode;13==e?checkCode.call(this):27==e&&mapDiv.removeChild(outerDiv)},this)}cancel.type="button",cancel.value=this.strings.close,cancel.style.marginTop="30px",cancel.onclick=function(){mapDiv.removeChild(outerDiv)},back.appendChild(cancel)}}),"mapBBCodeHandlers"in window||(window.mapBBCodeHandlers=[]),window.mapBBCodeHandlers.push({lineColors:{def:"#0022dd",blue:"#0022dd",red:"#bb0000",green:"#007700",brown:"#964b00",purple:"#800080",black:"#000000"},reKeys:new RegExp("^(blue|red|green|brown|purple|black)$"),applicableTo:function(t){return t instanceof L.Polygon||t instanceof L.Polyline},objectToLayer:function(t,e){var o=this.lineColors,i=e.length>0&&e[0]in o?o[e[0]]:o.def;t.options.color=i,t instanceof L.Polygon&&(t.options.fillColor=i)},layerToObject:function(t,e){return t._colorName?this.lineColors[t._colorName]!==this.lineColors.def?[t._colorName]:[]:e},initLayer:function(){},initDrawControl:function(t){t.options.draw.polyline.shapeOptions.color=this.lineColors.def,t.options.draw.polygon&&(t.options.draw.polygon.shapeOptions.color=this.lineColors.def)},createEditorPanel:function(t){var e,o=document.createElement("div"),i=[],n=this.lineColors;for(e in n)"string"==typeof n[e]&&"#"===n[e].substring(0,1)&&i.push(e);i=i.sort(),o.style.width=10+20*i.length+"px",o.textAlign="center";for(var r=function(e){var i=window.event&&window.event.srcElement||e.target||e.srcElement,n=i.style;if("white"==n.borderColor){t.setStyle({color:n.backgroundColor,fillColor:n.backgroundColor}),t._colorName=i._colorName;for(var r=o.childNodes,a=0;a<r.length;a++)r[a].style.borderColor="white";n.borderColor="#aaa"}},a=0;a<i.length;a++)if("def"!==i[a]){var s=document.createElement("div");s._colorName=i[a],s.style.width="16px",s.style.height="16px",s.style.cssFloat="left",s.style.styleFloat="left",s.style.marginRight="3px",s.style.marginBottom="5px",s.style.cursor="pointer";var l=n[i[a]];s.style.backgroundColor=l,s.style.borderWidth="3px",s.style.borderStyle="solid",s.style.borderColor=l==t.options.color?"#aaa":"white",s.onclick=r,o.appendChild(s)}var d=document.createElement("div");return d.style.clear="both",o.appendChild(d),o}}),L.LetterIcon=L.Icon.extend({options:{className:"leaflet-div-icon",color:"black",radius:11},initialize:function(t,e){this._letter=t,L.setOptions(this,e)},createIcon:function(){var t=this.options.radius,e=2*t+1,o=document.createElement("div");return o.innerHTML=this._letter,o.className="leaflet-marker-icon",o.style.marginLeft=-t-2+"px",o.style.marginTop=-t-2+"px",o.style.width=e+"px",o.style.height=e+"px",o.style.borderRadius=t+2+"px",o.style.borderWidth="2px",o.style.borderColor="white",o.style.borderStyle="solid",o.style.fontSize="10px",o.style.fontFamily="sans-serif",o.style.fontWeight="bold",o.style.textAlign="center",o.style.lineHeight=e+"px",o.style.color="white",o.style.backgroundColor=this.options.color,o.style.padding="0",this._setIconStyles(o,"icon"),o
},createShadow:function(){return null}}),L.letterIcon=function(t,e){return new L.LetterIcon(t,e)},L.PopupIcon=L.Icon.extend({options:{selectable:!1,color:"white",width:150},initialize:function(t,e){L.Icon.prototype.initialize.call(this,e),this._text=t},bindTo:function(t){return this._marker=t,t.setIcon(this),t},createIcon:function(){var t=document.createElement("div"),e=document.createElement("div"),o=this.options.width;t.style.position="absolute",e.style.position="absolute",e.style.width=o+"px",e.style.bottom="-3px",e.style.pointerEvents="none",e.style.left=-o/2+"px",e.style.margin=e.style.padding="0",t.style.margin=t.style.padding="0";var i=document.createElement("div");if(i.innerHTML=this._text,i.style.textAlign="center",i.style.lineHeight="1.2",i.style.backgroundColor=this.options.color,i.style.boxShadow="0px 1px 10px rgba(0, 0, 0, 0.655)",i.style.padding="4px 7px",i.style.borderRadius="5px",i.style.margin="0 auto",i.style.display="table",i.style.pointerEvents="auto",this.options.selectable&&(!this._marker||!this._marker.options.clickable&&!this._marker.options.draggable)){var n=L.DomEvent.stopPropagation;L.DomEvent.on(i,"click",n).on(i,"mousedown",n).on(i,"dblclick",n)}var r=document.createElement("div");r.className="leaflet-popup-tip-container",r.style.width="20px",r.style.height="11px",r.style.padding="0",r.style.margin="0 auto";var a=document.createElement("div");return a.className="leaflet-popup-tip",a.style.width=a.style.height="8px",a.style.marginTop="-5px",a.style.boxShadow="none",r.appendChild(a),e.appendChild(i),e.appendChild(r),t.appendChild(e),t},createShadow:function(){return null}}),L.popupIcon=function(t,e){return new L.PopupIcon(t,e)},L.Control.Search=L.Control.extend({options:{position:"topleft",title:"Nominatim Search",email:""},onAdd:function(t){this._map=t;var e=L.DomUtil.create("div","leaflet-bar"),o=document.createElement("div");e.appendChild(o);var i=L.DomUtil.create("a","",o);i.href="#",i.style.width="26px",i.style.height="26px",i.style.backgroundImage="url("+this._icon+")",i.style.backgroundSize="26px 26px",i.style.backgroundRepeat="no-repeat",i.title=this.options.title;var n=L.DomEvent.stopPropagation;L.DomEvent.on(i,"click",n).on(i,"mousedown",n).on(i,"dblclick",n).on(i,"click",L.DomEvent.preventDefault).on(i,"click",this._toggle,this);var r=this._form=document.createElement("form");r.style.display="none",r.style.position="absolute",r.style.left="27px",r.style.top="0px",r.style.zIndex=-10;var a=this._input=document.createElement("input");return a.style.height="25px",a.style.border="1px solid grey",a.style.padding="0 0 0 10px",r.appendChild(a),L.DomEvent.on(r,"submit",function(){return this._doSearch(a.value),!1},this).on(r,"submit",L.DomEvent.preventDefault),e.appendChild(r),e},_toggle:function(){"block"!=this._form.style.display?(this._form.style.display="block",this._input.focus()):this._collapse()},_collapse:function(){this._form.style.display="none",this._input.value=""},_nominatimCallback:function(t){if(t&&t.length>0){var e=t[0].boundingbox;this._map.fitBounds(L.latLngBounds([[e[0],e[2]],[e[1],e[3]]]))}this._collapse()},_callbackId:0,_doSearch:function(t){var e="_l_osmgeocoder_"+this._callbackId++;window[e]=L.Util.bind(this._nominatimCallback,this);var o={q:t,format:"json",limit:1,json_callback:e};this.options.email&&(o.email=this.options.email),this._map.getBounds()&&(o.viewbox=this._map.getBounds().toBBoxString());var i="https://nominatim.openstreetmap.org/search"+L.Util.getParamString(o),n=document.createElement("script");n.type="text/javascript",n.src=i,document.getElementsByTagName("head")[0].appendChild(n)},_icon:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADQAAAA0CAYAAADFeBvrAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAL/wAAC/8Bk9f7AQAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAOnSURBVGiB7ZhPaBxVHMc/vxezuzlsQqQqFf+Af8CLoWgsNHjoYjazbrR4SsGbgkcPInooLb1YRdBDQRCtCp6E3NLDZmendRXpaiC1kXqwh17EixQsmxATk935edhJHELczbydskOZz+m937zf+73v/Gbe+82IqnI3YQa9gLhJBSWdVFDSSQUlnVRQ0kkFJZ174p6wXC5nVXXC9/2RXC53bWFhYS3uGN2QOIrTQqFwKJPJnAGeB54GhoNLCtwAlowxHywuLt7oO1gP+hbkOM4rwGfA/T2GbojIKdd1z+sdLPH7EuQ4zufAGyHTH8BPIrKsqn8Dk8BR4KmdAar63fb29ov1en3TOnAXrN8hx3Fe5z8x/4jI2dHR0Y/m5+fb+4w9KSKfqOohETmezWbPAW/bxu6GVYbK5fJD7Xb7V2AMWPd9/5jnedd7+NzXbrd/BB4HfBE5Xq1Wf7BadRestu1Wq3WejhiAd3uJAahUKrdE5DU6G4VR1S9tYvcisiDpUAy6S7Va7dOD+gYZ+SLoPuk4zsNR4/cisqBisfgEkAdQVTfqjqWqi6H2ZNT4vbDJ0DOh7tWo/qq662OMGbwg4IGdhoj8GdV5fX39Fp33CN/3D1vE70pkQar6S6h9JKp/Pp+fAARARK5F9e+FjaAVgjssIs9axNz1McYsW/h3JbIgz/OawM2ge7JYLD5yUN9CoZAD3gy67WazuRI1fi+sziER+ThojhpjLhzUb3h4+D2CMkhVLzQajQ2b+F3XZlMpiIg4juOp6guB6auhoaG3KpXK6n7j5+bmhprN5jvAOTo3sRVUClesV/5/a7MtTmdnZx9ttVrXCc4k4HcROWOMuVKpVG4ClEqlw8BRVT1Np1ANc1tEpqvV6s+2i9+PvqrtmZmZIyLyNTCx59JtYAN4cI99E8iF+n/5vj/teV5su11fn+C1Wm1lbGzsORF5HwhX2ePsESMi36jqYyLihsz3GmMul0ql8GHdF7F8sUKnAm+1WseMMZNBSTOiqldFZBlYcl33N+jsdJlMZgGYCbnH9vjFJigKgaiLQDFkjkXUQP761Ov1za2trROAFzKPq+qlfh+/gWRoh6mpqZF8Pn8RmA6Z+8rUQP/LNRqNjbW1tRPApZC5r0wN/EfjjigRuRwyjwNnbeYbuCDoiFpdXX0Z+DYwfa+qr9rMlQhBsJupl1T1w2w2W3Zdd91mnoFuCneCxGQoLlJBSScVlHRSQUknFZR0UkFJ564T9C+LGmRQ/iQvLwAAAABJRU5ErkJggg=="}),L.control.search=function(t){return new L.Control.Search(t)},L.Control.StandardAttribution=L.Control.Attribution,L.Control.PermalinkAttribution=L.Control.Attribution.extend({onAdd:function(t){var e=L.Control.StandardAttribution.prototype.onAdd.call(this,t);return t.on("moveend",this._update,this),e},onRemove:function(t){t.off("moveend",this._update),L.Control.StandardAttribution.prototype.onRemove.call(this,t)},_update:function(){if(this._map){var t=[];for(var e in this._attributions)if(this._attributions[e]){if(e.indexOf("/openstreetmap.org")>0||e.indexOf("/www.openstreetmap.org")>0){var o="http://www.openstreetmap.org/#map={zoom}/{lat}/{lon}";if(e=e.replace(/(['"])http[^'"]+openstreetmap.org[^'"]*(['"])/,"$1"+o+"$2"),this._map.options.attributionEditLink){var i=o.replace("#","edit#");e=e.replace(/(openstreetmap.org[^'"]*(['"])[^>]*>[^<]+<\/a>)/,"$1 (<a href=$2"+i+"$2 target=$2osmedit$2>Edit</a>)")}}var n=this._map.getCenter();e=e.replace(/\{zoom\}/g,this._map.getZoom()).replace(/\{lat\}/g,L.Util.formatNum(n.lat,4)).replace(/\{lon\}/g,L.Util.formatNum(n.lng,4)),t.push(e)}var r=[];this.options.prefix&&r.push(this.options.prefix),t.length&&r.push(t.join(", ")),this._container.innerHTML=r.join(" | ")}}}),L.control.permalinkAttribution=function(t){return new L.Control.PermalinkAttribution(t)},L.Map.mergeOptions({attributionEditLink:!1}),L.Control.Attribution=L.Control.PermalinkAttribution,L.control.standardAttribution=L.control.attribution,L.control.attribution=L.control.permalinkAttribution,L.ExportControl=L.Control.extend({includes:L.Mixin.Events,options:{position:"topleft",name:"Export",title:"",endpoint:"http://share.mapbbcode.org/",codeid:"",filter:[],types:!1,titles:!1},onAdd:function(){var t=L.DomUtil.create("div","leaflet-bar"),e=document.createElement("div");t.appendChild(e);var o=L.DomUtil.create("a","",e);o.href="#",o.innerHTML=this.options.name,o.title=this.options.title||"",o.style.height="26px",o.style.width="auto",o.style.padding="0 4px";var i=this._variants=document.createElement("div");i.style.display="none",i.style.position="absolute",i.style.left="50px",i.style.top="0px",i.style.width="200px",i.style.padding="0 6px",i.style.backgroundColor="white",i.style.zIndex=-10,t.appendChild(i);var n=L.DomEvent.stopPropagation;return L.DomEvent.on(o,"click",n).on(o,"mousedown",n).on(o,"dblclick",n).on(o,"click",L.DomEvent.preventDefault).on(o,"click",function(){i.style.display="block"==i.style.display?"none":"block"}),this.options.types&&this.options.titles?this._updateVariants():this._ajax(this.options.endpoint+"fmtlist",function(t){t&&t.types&&t.titles&&this._updateTypesAndTitles(t.types,t.titles)},this),t},_updateTypesAndTitles:function(t,e){if(t&&e&&t.length&&t.length==e.length){var o=this.options.filter;if(o&&o.length){var i,n,r=[],a=[];for(i=0;i<t.length;i++)for(n=0;n<o.length;n++)if(t[i]==o[n]){r.push(t[i]),a.push(e[i]);break}this.options.titles=a,this.options.types=r}else this.options.titles=e,this.options.types=t;this._updateVariants()}},_updateVariants:function(){var t,e=this.options.types,o=this.options.titles,i=this.options.codeid,n=this._variants;for(t=0;t<e.length;t++){t>0&&n.appendChild(document.createTextNode(" | "));var r=document.createElement("a");r.style.display="inline",r.style.width="auto",r.style.color="blue",r.style.border="none",r.style.textDecoration="none",r.innerHTML=o[t];var a=L.DomEvent.stopPropagation;i?(r.href=this.options.endpoint+i+"?format="+e[t],L.DomEvent.on(r,"click",a).on(r,"mousedown",a).on(r,"dblclick",a).on(r,"click",this._linkClick,this)):(r.href="#",r._etype=e[t],L.DomEvent.on(r,"click",a).on(r,"mousedown",a).on(r,"dblclick",a).on(r,"click",L.DomEvent.preventDefault).on(r,"click",this._linkClick,this)),n.appendChild(r)}},_linkClick:function(t){var e=window.event&&window.event.srcElement||t.target||t.srcElement;this._variants.style.display="none",this.fire("export",{fmt:e._etype})},_ajax:function(url,callback,context){function respond(){var st=http.status;if(!st&&http.responseText||st>=200&&300>st)try{var result=eval("("+http.responseText+")");callback.call(context,result)}catch(err){}}var http;if(window.XMLHttpRequest&&(http=new window.XMLHttpRequest),!window.XDomainRequest||http&&"withCredentials"in http||(http=new window.XDomainRequest),http){"onload"in http?http.onload=http.onerror=respond:http.onreadystatechange=function(){4==http.readyState&&respond()};try{http.open("GET",url,!0),http.send(null)}catch(err){}}}}),L.exportControl=function(t){return new L.ExportControl(t)},L.StaticLayerSwitcher=L.Control.extend({includes:L.Mixin.Events,options:{position:"topright",editable:!1,bgColor:"white",selectedColor:"#ddd",enforceOSM:!1,maxLayers:7},initialize:function(t,e){if(L.setOptions(this,e),this._layers=[],this._selected=0,this._layerList=window.layerList&&"isOpenStreetMapLayer"in window.layerList,t)if("push"in t&&"splice"in t)for(var o=0;o<t.length;o++)this.addLayer(t[o]);else for(var i in t)this.addLayer(i,t[i])},getLayers:function(){for(var t=[],e=0;e<this._layers.length;e++)t.push(this._layers[e].layer);return t},getLayerIds:function(){for(var t=[],e=0;e<this._layers.length;e++)t.push(this._layers[e].id);return t},getSelectedLayer:function(){return this._layers.length>0&&this._selected<this._layers.length?this._layers[this._selected].layer:null},getSelectedLayerId:function(){return this._layers.length>0&&this._selected<this._layers.length?this._layers[this._selected].id:""},updateId:function(t,e){var o=this._findLayer(t),i=o>=0&&this._layers[o];if(i&&i.id!==e){if(i.id=e,i.fromList){var n=this._map&&this._map.hasLayer(t),r=this._layerList?window.layerList.getLeafletLayer(e):null;n&&this._map.removeLayer(t),r?(i.layer=r,n&&this._map.addLayer(r)):this._layers.splice(o,1)}return this._update(),t}return null},addLayer:function(t,e){if(!(this._layers.length>=this.options.maxLayers)){var o=e||this._layerList&&window.layerList.getLeafletLayer(t);if(o){this._layers.push({id:t,layer:o,fromList:!e});var i=this._findFirstOSMLayer();if(i>0){var n=this._layers[i];this._layers[i]=this._layers[0],this._layers[0]=n}return this._map&&this._addMandatoryOSMLayer(),this._update(),this.fire("layerschanged",{layers:this.getLayerIds()}),1==this._layers.length&&this.fire("selectionchanged",{selected:this.getSelectedLayer(),selectedId:this.getSelectedLayerId()}),e}return null}},removeLayer:function(t){var e=this._findLayer(t);if(e>=0){var o=this._selected==e;if(o&&this._map.removeLayer(t),this._layers.splice(e,1),0===e){var i=this._findFirstOSMLayer();if(i>0){var n=this._layers[i];this._layers[i]=this._layers[0],this._layers[0]=n}}return this._selected>=this._layers.length&&this._selected>0&&(this._selected=this._layers.length-1),this._addMandatoryOSMLayer(),this._update(),this.fire("layerschanged",{layers:this.getLayerIds()}),o&&this.fire("selectionchanged",{selected:this.getSelectedLayer(),selectedId:this.getSelectedLayerId()}),t}return null},moveLayer:function(t,e){var o=this._findLayer(t),i=e?o+1:o-1;if(o>=0&&i>=0&&i<this._layers.length){if(this.options.enforceOSM&&1==o+i&&this._layerList&&!window.layerList.isOpenStreetMapLayer(this._layers[1].layer)){var n=this._findFirstOSMLayer(1);if(!(0===o&&n>1))return;i=n}var r=this._layers[o];this._layers[o]=this._layers[i],this._layers[i]=r,o==this._selected?this._selected=i:i==this._selected&&(this._selected=o),this._update(),this.fire("layerschanged",{layers:this.getLayerIds()})}},_findFirstOSMLayer:function(t){if(!this._layerList||!this.options.enforceOSM)return t||0;for(var e=t||0;e<this._layers.length&&!window.layerList.isOpenStreetMapLayer(this._layers[e].layer);)e++;return e>=this._layers.length&&(e=-1),e},_addMandatoryOSMLayer:function(){if(this.options.enforceOSM&&this._layers.length>0&&this._findFirstOSMLayer()<0){var t=L.tileLayer("http://tile.openstreetmap.org/{z}/{x}/{y}.png",{attribution:'Map &copy; <a href="http://openstreetmap.org">OpenStreetMap</a>',minZoom:0,maxZoom:19});this._selected<this._layers.length&&this._selected++,this._layers.unshift({id:"OpenStreetMap",layer:t,fromList:!1})}},_findLayer:function(t){for(var e=0;e<this._layers.length;e++)if(this._layers[e].layer===t)return e;return-1},onAdd:function(t){var e=L.DomUtil.create("div","leaflet-bar");return L.Browser.touch?L.DomEvent.on(e,"click",L.DomEvent.stopPropagation):(L.DomEvent.disableClickPropagation(e),L.DomEvent.on(e,"mousewheel",L.DomEvent.stopPropagation)),this._map=t,this._container=e,this._addMandatoryOSMLayer(),this._update(),e},_createItem:function(t){var e=document.createElement("div");e.style.backgroundColor=this.options.bgColor,this._addHoverStyle(e,"backgroundColor",this.options.selectedColor),e.style.padding="4px 10px",e.style.margin="0",e.style.color="black",e.style.cursor="default";var o=t.fromList?this._layerList?window.layerList.getLayerName(t.id):"Layer":t.id;return e.appendChild(document.createTextNode(o)),this.options.editable&&e.appendChild(this._createLayerControls(t.layer)),L.DomEvent.on(e,"click",function(){var e=this._findLayer(t.layer);this._selected!=e&&(this._selected=e,this._update(),this.fire("selectionchanged",{selected:this.getSelectedLayer(),selectedId:this.getSelectedLayerId()}))},this),e},_createLayerControls:function(t){var e=document.createElement("span");e.innerHTML="&#x25B4;",e.style.cursor="pointer",this._addHoverStyle(e,"color","#aaa"),L.DomEvent.on(e,"click",function(){this.moveLayer(t,!1)},this);var o=document.createElement("span");o.innerHTML="&#x25BE;",o.style.cursor="pointer",o.style.marginLeft="6px",this._addHoverStyle(o,"color","#aaa"),L.DomEvent.on(o,"click",function(){this.moveLayer(t,!0)},this);var i=document.createElement("span");i.innerHTML="&#x2A2F;",i.style.cursor="pointer",i.style.marginLeft="6px",this._addHoverStyle(i,"color","#aaa"),L.DomEvent.on(i,"click",function(){this.removeLayer(t)},this);var n=document.createElement("span");return n.style.fontSize="12pt",n.style.marginLeft="12px",n.appendChild(e),n.appendChild(o),n.appendChild(i),L.DomEvent.on(n,"click",L.DomEvent.stopPropagation),n},_addHoverStyle:function(t,e,o){var i=t.style[e];L.DomEvent.on(t,"mouseover",function(){t.style[e]!==o&&(i=t.style[e],t.style[e]=o)}),t.resetHoverStyle=function(){t.style[e]=i},t.updateHoverDefault=function(){i=t.style[e]},L.DomEvent.on(t,"mouseout",t.resetHoverStyle)},_recursiveCall:function(t,e){if(t&&t[e]){t[e].call(t);for(var o=t.getElementsByTagName("*"),i=0;i<o.length;i++)o[i][e]&&o[i][e].call(o[i])}},_update:function(){if(this._container){for(var t=[],e=0;e<this._layers.length;e++){var o=this._layers[e];o.div?this._recursiveCall(o.div,"resetHoverStyle"):o.div=this._createItem(o),o.div.style.background=this._selected==e?this.options.selectedColor:this.options.bgColor,o.div.style.borderTop=e?"1px solid "+this.options.selectedColor:"0",this._recursiveCall(o.div,"updateHoverDefault"),this._container.appendChild(o.div),t.push(o.div),this._map.hasLayer(o.layer)&&this._selected!=e?this._map.removeLayer(o.layer):this._map.hasLayer(o.layer)||this._selected!=e||this._map.addLayer(o.layer)}for(var i,n=this._container.childNodes,r=0;r<n.length;r++){i=!1;for(var a=0;a<t.length;a++)t[a]===n[r]&&(i=!0);i||this._container.removeChild(n[r])}}}}),L.staticLayerSwitcher=function(t,e){return new L.StaticLayerSwitcher(t,e)},window.MapBBCode.include({strings:{close:"Close",remove:"Delete",apply:"Apply",cancel:"Cancel",title:"Title",zoomInTitle:"Zoom in",zoomOutTitle:"Zoom out",applyTitle:"Apply changes",cancelTitle:"Cancel changes",fullScreenTitle:"Enlarge or shrink map panel",searchTitle:"Search for a location",helpTitle:"Open help window",outerTitle:"Show this place on an external map",mapbbcodeTitle:"A library for parsing, editing and displaying [map] bbcode",submitWarning:"You will lose changes to the map. Proceed?",exportName:"Export",exportTitle:"Download this map",upload:"Upload",uploadTitle:"Upload this map to an external server",uploading:"Uploading",uploadError:"Error while uploading the map",uploadSuccess:"Upload was successful. Bookmark this link to be able to edit the map",sharedFormHeader:"There are no objects to upload. Enter a MapBBCode Share map URL",sharedFormError:"This map panel has incorrect endpoint set.<br>Please contact an administrator.",sharedFormInvalidCode:"Map code is invalid",sharedCodeLoading:'Downloading <a href="{url}" target="mapbbcode_outer">a map</a>...',sharedCodeError:'Failed to download an external map<br><br><a href="{url}" target="mapbbcode_outer">Open map in a new window</a>',polylineTitle:"Draw a path",polygonTitle:"Draw a polygon",markerTitle:"Add a marker",drawCancelTitle:"Cancel drawing",undoPoint:"Delete last point",undoPointTitle:"Delete last point drawn",markerTooltip:"Click map to place marker",polylineStartTooltip:"Click to start drawing a line",polylineContinueTooltip:"Click to continue drawing line",polylineEndTooltip:"Click the last point to finish line",polygonStartTooltip:"Click to start drawing a polygon",polygonContinueTooltip:"Click to continue drawing polygon",polygonEndTooltip:"Click the last point to close this polygon",deleteLastPoint:"Delete last point",deleteLastPointTooltip:"Delete last point drawn",singleLength:"Length of this line",totalLength:"Total length",helpContents:'Map BBCode Editor\n\nSince you have already activated the editor, you know the drill. There are buttons for markers and geometry, you click the map and objects appear, they have popups activated by clicking, from which you can change some properties, like color. To save the drawing click "Apply", otherwise there is a "Cancel" button.\nWhat you should know is that you are editing not the map, but the underlying bbcode, with all restrictions it imposes. Map BBCode is a text string, which you can copy and paste to different services, and edit directly. <a href="http://mapbbcode.org/bbcode.html" target="mapbb">The syntax</a> of it is quite simple: <tt>[map]...[/map]</tt> tags with a list of objects as coordinate sequences and attributes. When a cursor is inside bbcode, the editor is opened with a drawing it represents, otherwise it will be empty.\nFor a complete manual see <a href="http://mapbbcode.org/guide.html" target="mapbb">User\'s Guide</a> on the official MapBBCode site.\n\n# Navigating the map\nHere are some hints for using map panels. Keyboard arrows work when a map is in focus. Shift+drag with a mouse to quickly zoom into an area, shift+zoom buttons to change zoom 3 steps at a time. Use the layer switcher at the top right corner to see the drawing on a different map. Mouse wheel is disabled in the viewer, but can be used in the editor to quickly zoom in or out. Use the button with a magnifier to navigate to a named place or a road.\n\n# External maps\nIf the feature is not disabled by an administrator, you can upload your maps to a server, <a href="http://share.mapbbcode.org" target="mapbb">share.mapbbcode.org</a> by default, with an "Upload" button. If you click it not having drawn anything, it will ask for a map URL or identifier. Those are converted to <tt>[mapid]id[/mapid]</tt> bbcode, which looks like a regular map, but with an export button: users can download a drawing as GPX or CSV or in any other format. If you share an edit link for a map, others can join in, and changes will be reflected in embedded maps.\n\n# Plugin\n<a href="http://mapbbcode.org/" target="mapbb">MapBBCode</a> is an open source javascript library with plugins around it available for some forum and blog engines. Its goal is to make sharing maps easier. This is version {version}.\n'}})}(window,document);