<?php
namespace Redaxscript\View;

use Redaxscript\Language;
use Redaxscript\Registry;

/**
 * abstract class to create a view class
 *
 * @since 3.0.0
 *
 * @package Redaxscript
 * @category View
 * @author Henry Ruhs
 */

abstract class ViewAbstract implements ViewInterface
{
	/**
	 * constructor of the class
	 *
	 * @since 3.0.0
	 *
	 * @param Registry $_registry instance of the registry class
	 * @param Language $_language instance of the language class
	 */

	public function __construct(protected Registry $_registry, protected Language $_language)
	{
	}
}
