<?php
namespace Redaxscript\Content;

use Redaxscript\Config;
use Redaxscript\Language;
use Redaxscript\Registry;
use Redaxscript\Request;

/**
 * abstract class to create a parser class
 *
 * @since 3.0.0
 *
 * @package Redaxscript
 * @category Content
 * @author Henry Ruhs
 */

abstract class ParserAbstract
{
	/**
	 * array of tag namespaces
	 *
	 * @var array
	 */

	protected array $_namespaceArray =
	[
		'Redaxscript\Content\Tag\Code',
		'Redaxscript\Content\Tag\Language',
		'Redaxscript\Content\Tag\Module',
		'Redaxscript\Content\Tag\More',
		'Redaxscript\Content\Tag\Registry',
		'Redaxscript\Content\Tag\Template'
	];

	/**
	 * constructor of the class
	 *
	 * @since 3.0.0
	 *
	 * @param Registry $_registry instance of the registry class
	 * @param Request $_request instance of the request class
	 * @param Language $_language instance of the language class
	 * @param Config $_config instance of the config class
	 */

	public function __construct(protected Registry $_registry, protected Request $_request, protected Language $_language, protected Config $_config)
	{
	}
}
