<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
* Ελληνική μετάφραση από την ομάδα του phpbbgr.com
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// BBCodes
// Note to translators: you can translate everything but what's between { and }
$lang = array_merge($lang, array(
	'ACP_BBCODES_EXPLAIN'		=> 'Ο BBCode είναι μια ειδική εφαρμογή του HTML που προσφέρει μεγαλύτερο έλεγχο στο πού και πώς κάτι εμφανίζεται. Από αυτή τη σελίδα μπορείτε να προσθέσετε, να αφαιρέσετε ή να επεξεργαστείτε τους BBCodes.',
	'ADD_BBCODE'				=> 'Προσθήκη νέου BBCode',

	'BBCODE_DANGER'				=> 'Ο BBCode που προσπαθείτε να εισάγεται φαίνεται να είναι επισφαλής. Αν ο BBCode χρησιμοποιεί {TEXT} όρισμα σε ευαίσθητο περιεχόμενο, προσπαθήστε έναν πιο περιοριστικό τύπο. Προχωρήστε μόνο αν κατανοείται τους κινδύνους που περιλαμβάνονται.',
	'BBCODE_DANGER_PROCEED'		=> 'Προχωρήστε, καταλαβαίνω τον κίνδυνο',

	'BBCODE_ADDED'				=> 'Ο BBCode προστέθηκε με επιτυχία.',
	'BBCODE_EDITED'				=> 'Ο BBCode επεξεργάστηκε με επιτυχία.',
	'BBCODE_DELETED'			=> 'Ο BBCode διαγράφτηκε με επιτυχία.',
	'BBCODE_NOT_EXIST'			=> 'Ο BBCode που επιλέξατε δεν υπάρχει.',
	'BBCODE_HELPLINE'			=> 'Γραμμή βοήθειας',
	'BBCODE_HELPLINE_EXPLAIN'	=> 'Το πεδίο αυτό περιέχει το κείμενο, το οποίο θα εμφανίζεται στη γραμμή βοήθειας, εάν ο δείκτης του ποντικιού είναι πάνω στον BBCode.',
	'BBCODE_HELPLINE_TEXT'		=> 'Γραμμή βοήθειας κείμενο',
	'BBCODE_HELPLINE_TOO_LONG'	=> 'Η γραμμή βοήθειας που εισαγάγατε είναι πάρα πολύ μεγάλη.',

	'BBCODE_INVALID_TAG_NAME'	=> 'Το όνομα της ετικέτας BBCode που επιλέξατε υπάρχει ήδη.',
	'BBCODE_INVALID'			=> 'Ο BBCode σας είναι δομημένος σε μια άκυρη μορφή.',
	'BBCODE_INVALID_TEMPLATE'	=> 'Το πρότυπο BBCode είναι άκυρο.',
	'BBCODE_TAG'				=> 'Ετικέτα',
	'BBCODE_TAG_TOO_LONG'		=> 'Το όνομα ετικέτας που επιλέξατε είναι πολύ μεγάλο.',
	'BBCODE_TAG_DEF_TOO_LONG'	=> 'Ο ορισμός ετικέτας που έχετε εισαγάγει είναι πολύ μεγάλος, παρακαλώ συντομεύσετε τον ορισμό της ετικέτας σας.',
	'BBCODE_USAGE'				=> 'Χρήση BBCode',
	'BBCODE_USAGE_EXAMPLE'		=> '[highlight={COLOR}]{TEXT}[/highlight]<br /><br />[font={SIMPLETEXT1}]{SIMPLETEXT2}[/font]',
	'BBCODE_USAGE_EXPLAIN'		=> 'Εδώ καθορίστε τον τρόπο χρήσης του BBCode. Αντικαταστήστε οποιαδήποτε μεταβλητή εισαγωγής με το αντίστοιχο σύμβολο (%sδείτε παρακάτω%s).',

	'EXAMPLE'						=> 'Παράδειγμα:',
	'EXAMPLES'						=> 'Παραδείγματα:',

	'HTML_REPLACEMENT'				=> 'Αντικατάσταση HTML',
	'HTML_REPLACEMENT_EXAMPLE'		=> '&lt;span style="background-color: {COLOR};"&gt;{TEXT}&lt;/span&gt;<br /><br />&lt;span style="font-family: {SIMPLETEXT1};"&gt;{SIMPLETEXT2}&lt;/span&gt;',
	'HTML_REPLACEMENT_EXPLAIN'		=> 'Εδώ καθορίστε την προεπιλεγμένη αντικατάσταση HTML. Μην ξεχάστε να ξαναβάλετε τα σύμβολα που χρησιμοποιήσατε παραπάνω!',

	'TOKEN'					=> 'Σύμβολο',
	'TOKENS'				=> 'Σύμβολα',
	'TOKENS_EXPLAIN'		=> 'Τα σύμβολα είναι δεσμευμένες θέσεις για την εισαγωγή του μέλους. Η εισαγωγή θα επικυρωθεί μόνον εάν ταιριάζει με τον αντίστοιχο ορισμό. Εάν χρειάζεται, μπορείτε να τα αριθμήσετε προσθέτοντας έναν αριθμό, ανάμεσα στις αγκύλες, π.χ. {TEXT1}, {TEXT2}.<br /><br />Μέσα στην αντικατάσταση HTML, μπορείτε επίσης να χρησιμοποιήσετε οποιαδήποτε συμβολοσειρά γλώσσας που υπάρχει στη γλώσσα/κατάλογό σας, όπως αυτό: {L_<em>&lt;STRINGNAME&gt;</em>} όπου <em>&lt;STRINGNAME&gt;</em> είναι το όνομα της μεταφρασμένης συμβολοσειράς που θέλετε να προσθέσετε. Για παράδειγμα, {L_WROTE} θα εμφανίζεται ως “έγραψε” ή με τη μετάφρασή του σύμφωνα με την τοπική ρύθμιση του μέλους.<br /><br /><strong>Παρακαλώ σημειώστε ότι μόνο σύμβολα που αναγράφονται παρακάτω είναι σε θέση να χρησιμοποιηθούν μέσα στους προσαρμοσμένους BBCodes.</strong>',
	'TOKEN_DEFINITION'		=> 'Τι είναι συγκεκριμένα;',
	'TOO_MANY_BBCODES'		=> 'Δεν μπορείτε να δημιουργήσετε περισσότερους BBCodes. Παρακαλώ διαγράψτε έναν ή περισσότερους BBCodes και προσπαθήστε πάλι',

	'tokens'	=>	array(
		'TEXT'			=> 'Οποιοδήποτε κείμενο, συμπεριλαμβανομένων των ξένων χαρακτήρων, αριθμών, κλπ…',
		'SIMPLETEXT'	=> 'Χαρακτήρες από το λατινικό αλφάβητο (A-Z), αριθμοί, κενά, κόμματα, τελείες, αρνητικά πρόσημα, θετικά πρόσημα, παύλες και κάτω παύλες',
		'INTTEXT'		=> 'Unicode χαρακτήρες γραμμάτων, αριθμοί, κενά, κόμματα, τελείες, αρνητικά πρόσημα, θετικά πρόσημα, παύλες, κάτω παύλες και κενά διαστήματα.',
		'IDENTIFIER'	=> 'Χαρακτήρες από το λατινικό αλφάβητο (A-Z), αριθμοί, παύλες και κάτω παύλες',
		'NUMBER'		=> 'Οποιοδήποτε σειρά από ψηφία',
		'EMAIL'			=> 'Μια έγκυρη ηλεκτρονική διεύθυνση',
		'URL'			=> 'Μια έγκυρη διεύθυνση URL χρησιμοποιώντας οποιοδήποτε επιτρεπτό πρωτόκολλο (http, ftp, κλπ… δεν μπορεί να χρησιμοποιηθεί γιατί τα javascript το εκμεταλλεύονται). Εάν δεν έχει δοθεί κανένα, το “http://” προστίθεται στην αρχή της συμβολοσειράς.',
		'LOCAL_URL'		=> 'Μια τοπική διεύθυνση URL. Η διεύθυνση URL πρέπει να είναι σχετική με το θέμα της σελίδας και δεν μπορεί να περιέχει το όνομα του διακομιστή ή πρωτόκολλο, καθώς και συνδέσεις με το πρόθεμα “%s”',
		'RELATIVE_URL'	=> 'Μια σχετική διεύθυνση URL. Μπορείτε να χρησιμοποιήσετε αυτό για να ταιριάζει με τα μέρη μιας διεύθυνσης URL, αλλά να είστε προσεκτικοί: μια πλήρη διεύθυνση URL είναι μια έγκυρη σχετική διεύθυνση URL. Όταν θέλετε να χρησιμοποιήσετε τις σχετικές διευθύνσεις του συστήματος συζητήσεών σας, χρησιμοποιήστε το σύμβολο LOCAL_URL.',
		'COLOR'			=> 'Ένα χρώμα HTML, μπορεί να είναι είτε σε αριθμητική μορφή <samp>#FF1234</samp> είτε μια <a href="http://www.w3.org/TR/CSS21/syndata.html#value-def-color">λέξη-κλειδί χρώματος CSS</a> όπως είναι <samp>fuchsia</samp> ή <samp>InactiveBorder</samp>',
		'ALNUM'			=> 'Χαρακτήρες του λατινικού αλφαβήτου (A-Z) και αριθμοί.',
		'CHOICE'		=> 'Μία επιλογή από καθορισμένες τιμές, π.χ. <samp>{CHOICE=σπαθιά,κούπες,καρώ,μπαστούνια}</samp>. Οι τιμές αντιμετωπίζονται με διάκριση πεζών-κεφαλαίων από προεπιλογή και μπορούν να αντιμετωπιστούν διαφορετικά προσδιορίζοντας την επιλογή <samp>caseSensitive</samp>: <samp>{CHOICE=Σπαθιά,Κούπες,Καρώ,Μπαστούνια;caseSensitive}</samp>',
		'FLOAT'			=> 'Μία δεκαδική τιμή, π.χ. <samp>0.5</samp>.',
		'HASHMAP'		=> 'Αντιστοιχίζονται οι συμβολοσειρές με τις αντικαταστάσεις τους στη μορφή <samp>{HASHMAP=συμβολοσειρά1:αντικατάσταση1,συμβολοσειρά2:αντικατάσταση2}</samp>. Διάκριση πεζών-κεφαλαίων. Διατηρούνται οι άγνωστες τιμές από προεπιλογή.',
		'INT'			=> 'Μία τιμή ακέροαιου, π.χ. <samp>2</samp>.',
		'IP'			=> 'Μία έγκυρη διεύθυνση IPv4 ή IPv6.',
		'IPPORT'		=> 'Μία έγκυρη διεύθυνση IPv4 ή IPv6 με αριθμό πόρτας.',
		'IPV4'			=> 'Μία έγκυρη διεύθυνση IPv4.',
		'IPV6'			=> 'Μία έγκυρη διεύθυνση IPv6.',
		'MAP'			=> 'Αντιστοιχίζονται οι συμβολοσειρές με τις αντικαταστάσεις τους στη μορφή <samp>{MAP=string1:replacement1,string2:replacement2}</samp>. Διάκριση πεζών-κεφαλαίων. Διατηρούνται οι άγνωστες τιμές από προεπιλογή.',
		'RANGE'			=> 'Δέχεται έναν ακέραιο στο δωθέν εύρος, π.χ. <samp>{RANGE=-10,42}</samp>.',
		'REGEXP'		=> 'Επικυρώνει την τιμή με μια δεδομένη κανονική έκφραση, π.χ. <samp>{REGEXP=/^foo\w+bar$/}</samp>.',
		'TIMESTAMP'		=> 'Μία χρονοσφραγίδα όπως <samp>1h30m10s</samp> που θα μετατραπεί σε αριθμό δευτερολέπτων. Δέχεται επίσης και έναν αριθμό.',
		'UINT'			=> 'Μία τιμή ακέραιου χωρίς πρόσημα. Ίδιο με <samp>{INT}</samp>, αλλά απόρρίπτονται οι τιμές μικρότερες του 0.',
	),
));

// Smilies and topic icons
$lang = array_merge($lang, array(
	'ACP_ICONS_EXPLAIN'		=> 'Από αυτή τη σελίδα μπορείτε να προσθέσετε, να αφαιρέσετε και να επεξεργαστείτε τα εικονίδια, τα οποία τα μέλη μπορούν να προσθέσουν στα θέματα ή τις δημοσιεύσεις τους. Αυτά τα εικονίδια εμφανίζονται γενικά δίπλα από τους τίτλους θεμάτων στη λίστα της Δ. Συζήτησης, ή τους τίτλους δημοσιεύσεων στις λίστες θεμάτων. Μπορείτε επίσης να εγκαταστήσετε και να δημιουργήσετε νέα πακέτα εικονιδίων.',
	'ACP_SMILIES_EXPLAIN'	=> 'Τα Smilies ή emoticons είναι κατά κανόνα μικρές, μερικές φορές κινούμενες εικόνες που χρησιμοποιούνται για να μεταφέρουν ένα συναίσθημα ή αίσθηση. Από αυτή τη σελίδα μπορείτε να προσθέσετε, να αφαιρέσετε και να επεξεργαστείτε τα emoticons που τα μέλη μπορούν να χρησιμοποιήσουν σε δημοσιεύσεις τους και προσωπικά μηνύματα. Μπορείτε επίσης να εγκαταστήσετε και να δημιουργήσετε νέα πακέτα smilies.',
	'ADD_SMILIES'			=> 'Προσθήκη πολλαπλών εικονιδίων smilies',
	'ADD_SMILEY_CODE'		=> 'Προσθέστε συμπληρωματικούς κώδικες εικονιδίου smiley',
	'ADD_ICONS'				=> 'Προσθήκη πολλαπλών εικονιδίων',
	'AFTER_ICONS'			=> 'Μετά %s',
	'AFTER_SMILIES'			=> 'Μετά %s',

	'CODE'						=> 'Κώδικας',
	'CURRENT_ICONS'				=> 'Τρέχοντα εικονίδια',
	'CURRENT_ICONS_EXPLAIN'		=> 'Επιλέξτε τι θέλετε να κάνετε με τα τρέχοντα εγκατεστημένα εικονίδια.',
	'CURRENT_SMILIES'			=> 'Τρέχοντα εικονίδια smilies',
	'CURRENT_SMILIES_EXPLAIN'	=> 'Επιλέξτε τι θέλετε να κάνετε με τα τρέχοντα εγκατεστημένα εικονίδια smilies.',

	'DISPLAY_ON_POSTING'		=> 'Εμφάνιση στη σελίδα δημοσίευσης',
	'DISPLAY_POSTING'			=> 'Στη σελίδα δημοσίευσης',
	'DISPLAY_POSTING_NO'		=> 'Όχι στη σελίδα δημοσίευσης',

	'EDIT_ICONS'				=> 'Επεξεργασία εικονιδίων',
	'EDIT_SMILIES'				=> 'Επεξεργασία εικονιδίων smilies',
	'EMOTION'					=> 'Περιγραφή',
	'EXPORT_ICONS'				=> 'Εξαγωγή και μεταφόρτωση πακέτου εικονιδίων',
	'EXPORT_ICONS_EXPLAIN'		=> '%sΜε πάτημα σε αυτό το σύνδεσμο, η ρύθμιση παραμέτρων για τα εγκατεστημένα εικονίδιά σας θα πρέπει να συσκευαστεί σε <samp>icons.pak</samp> που μόλις μεταφορτωθεί μπορεί να χρησιμοποιηθεί για τη δημιουργία ενός αρχείου <samp>.zip</samp> ή <samp>.tgz</samp> που περιέχει όλα τα εικονίδια σας και επιπλέον το αρχείο ρυθμίσεων <samp>icons.pak</samp>%s.',
	'EXPORT_SMILIES'			=> 'Εξαγωγή και μεταφόρτωση πακέτου smilies.pak',
	'EXPORT_SMILIES_EXPLAIN'	=> '%sΜε πάτημα σε αυτό το σύνδεσμο, η ρύθμιση παραμέτρων για τα εγκατεστημένα εικονίδια smilies σας θα πρέπει να συσκευαστεί σε <samp>smilies.pak</samp> που μόλις μεταφορτωθεί μπορεί να χρησιμοποιηθεί για τη δημιουργία ενός αρχείου <samp>.zip</samp> ή <samp>.tgz</samp> που περιέχει όλα τα εικονίδια smilies σας και επιπλέον το αρχείο ρυθμίσεων <samp>smilies.pak</samp>%s.',

	'FIRST'			=> 'Στην αρχή',

	'ICONS_ADD'				=> 'Προσθέστε νέο εικονίδιο θέματος',
	'ICONS_ADDED'			=> array(
		0	=> 'Κανένα εικονίδιο δεν έχει προστεθεί.',
		1	=> 'Το εικονίδιο προστέθηκε με επιτυχία.',
		2	=> 'Τα εικονίδια προστέθηκαν με επιτυχία.',
	),
	'ICONS_CONFIG'			=> 'Ρυθμίσεις εικονιδίων',
	'ICONS_DELETED'			=> 'Το εικονίδιο διαγράφτηκε με επιτυχία.',
	'ICONS_EDIT'			=> 'Επεξεργασία εικονιδίου',
	'ICONS_EDITED'			=> array(
		0	=> 'Κανένα εικονίδιο δεν ενημερώθηκε.',
		1	=> 'Τα εικονίδιο ενημερώθηκε με επιτυχία.',
		2	=> 'Τα εικονίδια ενημερώθηκαν με επιτυχία.',
	),
	'ICONS_HEIGHT'			=> 'Ύψος εικονιδίου',
	'ICONS_IMAGE'			=> 'Εικόνα εικονιδίου,',
	'ICONS_IMPORTED'		=> 'Το πακέτο εικονιδίων εγκαταστάθηκε με επιτυχία.',
	'ICONS_IMPORT_SUCCESS'	=> 'Η εισαγωγή του πακέτο εικονιδίων έγινε με επιτυχία.',
	'ICONS_LOCATION'		=> 'Τοποθεσία εικονιδίου',
	'ICONS_NOT_DISPLAYED'	=> 'Τα ακόλουθα εικονίδια δεν θα εμφανίζονται στη σελίδα δημοσίευσης',
	'ICONS_ORDER'			=> 'Ταξινόμηση εικονιδίου',
	'ICONS_URL'				=> 'Αρχείο εικόνας εικονιδίου',
	'ICONS_WIDTH'			=> 'Πλάτος εικονιδίου',
	'IMPORT_ICONS'			=> 'Εγκατεστημένα πακέτα εικονιδίων',
	'IMPORT_SMILIES'		=> 'Εγκατεστημένα πακέτα εικονιδίων smilies',

	'KEEP_ALL'			=> 'Διατηρήστε όλα',

	'MASS_ADD_SMILIES'	=> 'Προσθήκη πολλαπλών εικονιδίων smilies',

	'NO_ICONS_ADD'		=> 'Δεν υπάρχουν διαθέσιμα εικονίδια για προσθήκη.',
	'NO_ICONS_EDIT'		=> 'Δεν υπάρχουν διαθέσιμα εικονίδια για επεξεργασία.',
	'NO_ICONS_EXPORT'	=> 'Δεν έχετε εικονίδια με τα οποία να δημιουργήσετε ένα πακέτο.',
	'NO_ICONS_PAK'		=> 'Δεν βρέθηκαν πακέτα εικονιδίων',
	'NO_SMILIES_ADD'	=> 'Δεν υπάρχουν διαθέσιμα εικονίδια smilies για προσθήκη.',
	'NO_SMILIES_EDIT'	=> 'Δεν υπάρχουν διαθέσιμα εικονίδια smilies για επεξεργασία.',
	'NO_SMILIES_EXPORT'	=> 'Δεν έχετε εικονίδια smilies με τα οποία να δημιουργήσετε ένα πακέτο.',
	'NO_SMILIES_PAK'	=> 'Δεν βρέθηκαν πακέτα smiley',

	'PAK_FILE_NOT_READABLE'		=> 'Αδυναμία ανάγνωσης αρχείου <samp>.pak</samp>.',

	'REPLACE_MATCHES'	=> 'Αντικαταστήστε αντιστοιχίες',

	'SELECT_PACKAGE'			=> 'Επιλέξτε ένα αρχείο πακέτου',
	'SMILIES_ADD'				=> 'Προσθήκη νέου smiley',
	'SMILIES_ADDED'				=> array(
		0	=> 'Δεν προστέθηκαν εικονίδια smilies.',
		1	=> 'Το εικονίδιο smiley προστέθηκε με επιτυχία.',
		2	=> 'Τα εικονίδια smilies προστέθηκαν με επιτυχία.',
	),
	'SMILIES_CODE'				=> 'Κώδικας smiley ',
	'SMILIES_CONFIG'			=> 'Ρυθμίσεις εικονιδίου smiley',
	'SMILIES_DELETED'			=> 'Το εικονίδιο smiley διαγράφτηκε με επιτυχία.',
	'SMILIES_EDIT'				=> 'Επεξεργασία εικονιδίου smiley',
	'SMILIE_NO_CODE'			=> 'Το εικονίδιο smiley “%s” αγνοήθηκε, επειδή κανένας κώδικας δεν εισήχθηκε.',
	'SMILIE_NO_EMOTION'			=> 'Το εικονίδιο smiley “%s” αγνοήθηκε, επειδή καμία περιγραφή δεν εισήχθηκε.',
	'SMILIE_NO_FILE'			=> 'Το smiley “%s” αγνοήθηκε, επειδή το αρχείο λείπει.',
	'SMILIES_EDITED'			=> array(
		0	=> 'Κανένα εικονίδιο smiley δεν ενημερώθηκε.',
		1	=> 'Το εικονίδιο smiley ενημερώθηκε με επιτυχία.',
		2	=> 'Τα εικονίδια smilies ενημερώθηκαν με επιτυχία.',
	),
	'SMILIES_EMOTION'			=> 'Συναίσθημα',
	'SMILIES_HEIGHT'			=> 'Ύψος smiley',
	'SMILIES_IMAGE'				=> 'Εικόνα smiley',
	'SMILIES_IMPORTED'			=> 'Το πακέτο smilies εγκαταστάθηκε με επιτυχία.',
	'SMILIES_IMPORT_SUCCESS'	=> 'Το πακέτο smilies διαγράφηκε με επιτυχία.',
	'SMILIES_LOCATION'			=> 'Τοποθεσία smiley',
	'SMILIES_NOT_DISPLAYED'		=> 'Τα ακόλουθα smilies δεν θα εμφανίζονται στη σελίδα δημοσίευσης',
	'SMILIES_ORDER'				=> 'Ταξινόμηση smiley',
	'SMILIES_URL'				=> 'Αρχείο εικόνας smiley',
	'SMILIES_WIDTH'				=> 'Πλάτος smiley',

	'TOO_MANY_SMILIES'			=> array(
		1	=> 'Το όριο του %d εικονιδίου smiley έχει συμπληρωθεί.',
		2	=> 'Τό όριο των %d εικονιδίων smilies έχει συμπληρωθεί.',
	),

	'WRONG_PAK_TYPE'	=> 'Το συγκεκριμένο πακέτο δεν περιέχει τα κατάλληλα δεδομένα.',
));

// Word censors
$lang = array_merge($lang, array(
	'ACP_WORDS_EXPLAIN'		=> 'Από αυτό τον πίνακα ελέγχου, μπορείτε να προσθέσετε, να επεξεργαστείτε και να αφαιρέσετε λέξεις που θα λογοκρίνονται αυτόματα στις Δ. Συζητήσεις σας. Οι χρήστες εξακολουθούν να μπορούν να εγγραφούν με ονόματα μελών που περιέχουν αυτές τις λέξεις. Ο μπαλαντέρ (*) είναι αποδεκτός στο πεδίο λέξης, π.χ. *test* θα ταιριάζει με detestable, test* θα ταιριάζει με testing, *test θα ταιριάζει με detest.',
	'ADD_WORD'				=> 'Προσθήκη νέας λέξης',

	'EDIT_WORD'		=> 'Επεξεργασία λογοκριμένης λέξης',
	'ENTER_WORD'	=> 'Πρέπει να εισάγετε μια λέξη και την αντικατάστασή της.',

	'NO_WORD'	=> 'Καμία λέξη δεν επιλέχθηκε για επεξεργασία.',

	'REPLACEMENT'	=> 'Αντικατάσταση',

	'UPDATE_WORD'	=> 'Ενημέρωση λογοκριμένων λέξεων',

	'WORD'				=> 'Λέξη',
	'WORD_ADDED'		=> 'Η λογοκριμένη λέξη προστέθηκε με επιτυχία.',
	'WORD_REMOVED'		=> 'Η επιλεγμένη λογοκριμένη λέξη διαγράφηκε με επιτυχία.',
	'WORD_UPDATED'		=> 'Η επιλεγμένη λογοκριμένη λέξη ενημερώθηκε με επιτυχία.',
));

// Ranks
$lang = array_merge($lang, array(
	'ACP_RANKS_EXPLAIN'		=> 'Χρησιμοποιώντας αυτή τη φόρμα μπορείτε να προσθέσετε, να επεξεργαστείτε, να προβάλετε και να διαγράψετε βαθμούς. Μπορείτε επίσης να δημιουργήσετε ειδικούς βαθμούς που μπορούν να εφαρμοστούν σε ένα μέλος μέσω του μηχανισμού διαχείρισης μέλους.',
	'ADD_RANK'				=> 'Προσθήκη νέου βαθμού',

	'MUST_SELECT_RANK'		=> 'Πρέπει να επιλέξετε ένα βαθμό.',

	'NO_ASSIGNED_RANK'		=> 'Κανένας ειδικός βαθμός δεν ανατέθηκε.',
	'NO_RANK_TITLE'			=> 'Δεν έχετε προσδιορίσει ένα τίτλο για το βαθμό.',
	'NO_UPDATE_RANKS'		=> 'Ο βαθμός διαγράφηκε με επιτυχία. Ωστόσο, οι λογαριασμοί μελών που χρησιμοποιούν αυτό τον βαθμό δεν έχουν ενημερωθεί. Θα χρειαστεί να επαναφέρετε χειροκίνητα το βαθμό σε αυτούς τους λογαριασμούς.',

	'RANK_ADDED'			=> 'Ο βαθμός προστέθηκε με επιτυχία.',
	'RANK_IMAGE'			=> 'Εικόνα βαθμού',
	'RANK_IMAGE_EXPLAIN'	=> 'Χρησιμοποιήστε αυτό για να προσδιορίσετε μια μικρή εικόνα που σχετίζεται με το βαθμό. Η διαδρομή είναι σχετική με το ριζικό κατάλογο του phpBB.',
	'RANK_IMAGE_IN_USE'		=> '(Σε χρήση)',
	'RANK_MINIMUM'			=> 'Ελάχιστες δημοσιεύσεις',
	'RANK_REMOVED'			=> 'Ο βαθμός διαγράφτηκε με επιτυχία.',
	'RANK_SPECIAL'			=> 'Θέστε ως ειδικό βαθμό',
	'RANK_TITLE'			=> 'Τίτλος βαθμού',
	'RANK_UPDATED'			=> 'Ο βαθμός ενημερώθηκε με επιτυχία.',
));

// Disallow Usernames
$lang = array_merge($lang, array(
	'ACP_DISALLOW_EXPLAIN'	=> 'Εδώ μπορείτε να ελέγχετε ονόματα μελών τα οποία δεν θα επιτρέπεται να χρησιμοποιούνται. Μη επιτρεπτά ονόματα μελών επιτρέπεται να περιέχουν ένα χαρακτήρα μπαλαντέρ *.',
	'ADD_DISALLOW_EXPLAIN'	=> 'Μπορείτε να απαγορεύσετε ένα όνομα μέλους χρησιμοποιώντας τον χαρακτήρα μπαλαντέρ * για να ταιριάζει με κάθε χαρακτήρα.',
	'ADD_DISALLOW_TITLE'	=> 'Προσθέστε ένα μη επιτρεπτό όνομα μέλους',

	'DELETE_DISALLOW_EXPLAIN'	=> 'Μπορείτε να αφαιρέσετε ένα μη επιτρεπτό όνομα μέλους επιλέγοντας το όνομα από αυτή τη λίστα και πατώντας υποβολή.',
	'DELETE_DISALLOW_TITLE'		=> 'Αφαιρέστε ένα μη επιτρεπτό όνομα μέλους',
	'DISALLOWED_ALREADY'		=> 'Το όνομα που εισάγατε έχει ήδη απαγορευθεί',
	'DISALLOWED_DELETED'		=> 'Το μη επιτρεπτό όνομα μέλους έχει αφαιρεθεί με επιτυχία.',
	'DISALLOW_SUCCESSFUL'		=> 'Το μη επιτρεπτό όνομα μέλους έχει προστεθεί με επιτυχία.',

	'NO_DISALLOWED'				=> 'Δεν υπάρχουν μη επιτρεπτά ονόματα μελών.',
	'NO_USERNAME_SPECIFIED'		=> 'Δεν έχετε επιλέξει ή δεν έχετε εισάγει κανένα όνομα μέλους.',
));

// Reasons
$lang = array_merge($lang, array(
	'ACP_REASONS_EXPLAIN'	=> 'Εδώ μπορείτε να διαχειριστείτε τους λόγους που χρησιμοποιούνται σε αναφορές και μηνύματα κατά την απόρριψη δημοσιεύσεων. Υπάρχει ένας προεπιλεγμένος λόγος (σημειωμένος με *), ο οποίος δεν μπορεί να διαγραφεί. Αυτός ο λόγος χρησιμοποιείται κατά κανόνα για προσαρμοσμένα μηνύματα, εάν δεν υπάρχει λόγος που ταιριάζει.',
	'ADD_NEW_REASON'		=> 'Προσθήκη νέου λόγου',
	'AVAILABLE_TITLES'		=> 'Διαθέσιμοι μεταφρασμένοι τίτλοι λόγου ',

	'IS_NOT_TRANSLATED'			=> 'Ο λόγος <strong>δεν</strong> έχει μεταφραστεί.',
	'IS_NOT_TRANSLATED_EXPLAIN'	=> 'Ο λόγος <strong>δεν</strong> έχει μεταφραστεί. Εάν θέλετε να παράσχει τη μεταφρασμένη μορφή, καθορίστε το σωστό κλειδί από τα αρχεία γλώσσας της ενότητας λόγων αναφοράς.',
	'IS_TRANSLATED'				=> 'Ο λόγος έχει μεταφραστεί.',
	'IS_TRANSLATED_EXPLAIN'		=> 'Ο λόγος έχει μεταφραστεί. Εάν ο τίτλος που εισάγατε εδώ καθορίζεται στα αρχεία γλώσσας της ενότητας λόγων αναφοράς, η μεταφρασμένη φόρμα του τίτλου και της περιγραφής θα χρησιμοποιηθούν.',

	'NO_REASON'					=> 'Ο λόγος δεν μπορεί να βρεθεί.',
	'NO_REASON_INFO'			=> 'Πρέπει να καθορίσετε ένα τίτλο και μια περιγραφή για αυτό το λόγο.',
	'NO_REMOVE_DEFAULT_REASON'	=> 'Δεν μπορείτε να αφαιρέσετε τον προεπιλεγμένο λόγο “Διάφορα”.',

	'REASON_ADD'				=> 'Προσθήκη λόγου αναφοράς/απόρριψης',
	'REASON_ADDED'				=> 'Ο λόγος αναφοράς/απόρριψης προστέθηκε με επιτυχία.',
	'REASON_ALREADY_EXIST'		=> 'Ένας λόγος με αυτό τον τίτλο υπάρχει ήδη, παρακαλώ εισάγετε ένα άλλο τίτλο για αυτό το λόγο.',
	'REASON_DESCRIPTION'		=> 'Περιγραφή λόγου',
	'REASON_DESC_TRANSLATED'	=> 'Περιγραφή λόγου όπως εμφανίζεται μεταφρασμένη',
	'REASON_EDIT'				=> 'Επεξεργασία λόγου αναφοράς/απόρριψης',
	'REASON_EDIT_EXPLAIN'		=> 'Εδώ είστε σε θέση να προσθέσετε ή να επεξεργαστείτε ένα λόγο. Εάν ο λόγος είναι μεταφρασμένος η μεταφρασμένη έκδοση χρησιμοποιείται αντί της περιγραφής που εισάγεται εδώ.',
	'REASON_REMOVED'			=> 'Ο λόγος αναφοράς/απόρριψης διαγράφηκε με επιτυχία',
	'REASON_TITLE'				=> 'Τίτλος λόγου',
	'REASON_TITLE_TRANSLATED'	=> 'Τίτλος λόγου όπως εμφανίζεται μεταφρασμένος',
	'REASON_UPDATED'			=> 'Ο λόγος αναφοράς/απόρριψης ενημερώθηκε με επιτυχία.',

	'USED_IN_REPORTS'		=> 'Χρησιμοποιείται στις αναφορές',
));
