<?php

return [
    'app' => [
        'name' => 'OctoberCMS',
        'tagline' => 'Povratak osnovama',
    ],
    'locale' => [
        'ar' => 'العربية',
        'be' => 'Беларуская',
        'bg' => 'Български',
        'ca' => 'Català',
        'cs' => 'Čeština',
        'da' => 'Dansk',
        'en' => 'English (United States)',
        'en-au' => 'English (Australia)',
        'en-ca' => 'English (Canada)',
        'en-gb' => 'English (United Kingdom)',
        'et' => 'Eesti',
        'de' => 'Deutsch',
        'el' => 'Ελληνικά',
        'es' => 'Español',
        'es-ar' => 'Español (Argentina)',
        'fa' => 'فارسی',
        'fr' => 'Français',
        'fr-ca' => 'Français (Canada)',
        'hu' => 'Magyar',
        'id' => 'Bahasa Indonesia',
        'it' => 'Italiano',
        'ja' => '日本語',
        'kr' => '한국어',
        'lt' => 'Lietuvių',
        'lv' => 'Latviešu',
        'nb-no' => 'Norsk (Bokmål)',
        'nl' => 'Nederlands',
        'pl' => 'Polski',
        'pt-br' => 'Português (Brasil)',
        'pt-pt' => 'Português (Portugal)',
        'ro' => 'Română',
        'ru' => 'Русский',
        'fi' => 'Suomi',
        'sv' => 'Svenska',
        'sk' => 'Slovenský',
        'sl' => 'Slovenščina',
        'rs' => 'Srpski',
        'th' => 'ไทย',
        'tr' => 'Türkçe',
        'uk' => 'Українська мова',
        'zh-cn' => '简体中文',
        'zh-tw' => '繁體中文',
        'vn' => 'Tiếng việt',
    ],
    'directory' => [
        'create_fail' => 'Nije moguće napraviti direktorijum: :name',
    ],
    'file' => [
        'create_fail' => 'Nije moguće napraviti fajl: :name',
    ],
    'combiner' => [
        'not_found' => "Kombinovani fajl ':name' nije pronađen.",
    ],
    'system' => [
        'name' => 'Sistem',
        'menu_label' => 'Sistem',
        'categories' => [
            'cms' => 'CMS',
            'misc' => 'Ostalo',
            'logs' => 'Logovi',
            'mail' => 'Pošta',
            'shop' => 'Prodavnica',
            'team' => 'Tim',
            'users' => 'Korisnici',
            'system' => 'Sistem',
            'social' => 'Društvene mreže',
            'backend' => 'Pozadinski sistem',
            'events' => 'Događaji',
            'customers' => 'Mušterije',
            'my_settings' => 'Moja podešavanja',
            'notifications' => 'Obaveštenja',
        ],
    ],
    'theme' => [
        'label' => 'Tema',
        'unnamed' => 'Tema bez naziva',
        'name' => [
            'label' => 'Naziv teme',
            'help' => 'Imenuj temu po njenom jedinstvenom kodu. Na primer, RainLab.Vanilla',
        ],
    ],
    'themes' => [
        'install' => 'Instaliraj teme',
        'search' => 'traži teme za instaliranje...',
        'installed' => 'Instalirane teme',
        'no_themes' => 'Nijedna tema nije instalirana sa tržišta.',
        'recommended' => 'Preporučene',
        'remove_confirm' => 'Da li zaista želite da uklonite temu?',
    ],
    'plugin' => [
        'label' => 'Priključak',
        'unnamed' => 'Neimenovani priključak',
        'name' => [
            'label' => 'Naziv priključka',
            'help' => 'Imenuj priključak po njegovom jedinstvenom kodu. Na primer, RainLab.Blog',
        ],
        'by_author' => 'Od :name',
    ],
    'plugins' => [
        'manage' => 'Upravljaj priključcima',
        'install' => 'Instaliraj priključke',
        'install_products' => 'Instaliraj proizvode',
        'search' => 'traži priključke za instaliranje...',
        'installed' => 'Instalirani priključci',
        'no_plugins' => 'Nijedan priključak nije instaliran sa tržišta.',
        'recommended' => 'Preporučeni',
        'plugin_label' => 'Priključak',
        'unknown_plugin' => 'Priključak je uklonjen sa sistema.',
        'select_label' => 'Izaberi radnju...',
        'bulk_actions_label' => 'Više radnji',
        'check_yes' => 'Da',
        'check_no' => 'Ne',
        'unfrozen' => 'Uključeno aužuriranje',
        'enabled' => 'Priključak uključen',
        'freeze' => 'isključi ažuriranje za',
        'unfreeze' => 'uključi ažuriranje za',
        'enable' => 'uključi',
        'disable' => 'isključi',
        'refresh' => 'resetuj',
        'remove' => 'Ukloni',
        'freeze_label' => 'Isključi ažuriranje',
        'unfreeze_label' => 'Uključi ažuriranje',
        'enable_label' => 'Uključi priključke',
        'disable_label' => 'Isključi priključke',
        'refresh_label' => 'Resetuj podatke priključka',
        'action_confirm' => 'Da li zaista želite da :action ove priključke?',
        'freeze_success' => 'Uspešno isključeno ažuriranje za izabrane priključke.',
        'unfreeze_success' => 'Uspešno uključeno ažuriranje za izabrane priključke.',
        'enable_success' => 'Izabrani priključci su uspešno uključeni.',
        'disable_success' => 'Izabrani priključci su uspešno isključeni.',
        'refresh_confirm' => 'Da li zaista želite da resetujete sledeće priključke? Ovo će resetovati podatke svakog priključka vraćajući ih na inicijalno stanje.',
        'refresh_success' => 'Izabrani priključci su uspešno resetovani.',
        'remove_confirm' => 'Da li zaista želite da uklonite sledeće priključke? Ovo će takođe ukloniti asocirane podatke.',
        'remove_success' => 'Izabrani priključci su uspešno uklonjeni.',
    ],
    'project' => [
        'name' => 'Projekat',
        'owner_label' => 'Vlasnik',
        'attach' => 'Dodaj projekat',
        'detach' => 'Odvoji projekat',
        'none' => 'Nijedan',
        'id' => [
            'label' => 'ID projekta',
            'help' => 'Kako pronaći svoj ID projekta',
            'missing' => 'Specifikuj ID projekta za korišćenje.',
        ],
        'detach_confirm' => 'Da li zaista želite da odvojite ovaj projekat?',
        'unbind_success' => 'Projekat je uspešno odvojen.',
    ],
    'settings' => [
        'menu_label' => 'Podešavanja',
        'not_found' => 'Nije moguće pronaći navedena podešavanja.',
        'missing_model' => 'Na stranici sa podešavanjima nedostaje definicija modela.',
        'update_success' => 'Podešavanje :name je uspešno ažurirano.',
        'return' => 'Nazad na sistemska podešavanja',
        'search' => 'Traži',
    ],
    'mail' => [
        'log_file' => 'Fajl sa logovima',
        'menu_label' => 'Konfiguracija pošte',
        'menu_description' => 'Upravljaj konfiguracijom pošte.',
        'general' => 'Generalno',
        'method' => 'Metod pošte',
        'sender_name' => 'Ime pošiljaoca',
        'sender_email' => 'Email pošiljaoca',
        'php_mail' => 'PHP mejl',
        'smtp' => 'SMTP',
        'smtp_address' => 'SMTP adresa',
        'smtp_authorization' => 'Potrebna SMTP autorizacija',
        'smtp_authorization_comment' => 'Čekiraj ovo polje ako tvoj server zahteva SMTP autorizaciju.',
        'smtp_username' => 'Korisničko ime',
        'smtp_password' => 'Lozinka',
        'smtp_port' => 'SMTP port',
        'smtp_ssl' => 'Potrebna SSL konekcija',
        'smtp_encryption' => 'SMTP šifarski protokol',
        'smtp_encryption_none' => 'Bez šifrovanja',
        'smtp_encryption_tls' => 'TLS',
        'smtp_encryption_ssl' => 'SSL',
        'sendmail' => 'Sendmail',
        'sendmail_path' => 'Sendmail putanja',
        'sendmail_path_comment' => 'Specificiraj putanju Sendmail programa.',
        'mailgun' => 'Mailgun',
        'mailgun_domain' => 'Mailgun domen',
        'mailgun_domain_comment' => 'Specificiraj Mailgun domen.',
        'mailgun_secret' => 'Mailgun tajna',
        'mailgun_secret_comment' => 'Unesi svoj Mailgun API ključ.',
        'mandrill' => 'Mandrill',
        'mandrill_secret' => 'Mandrill tajna',
        'mandrill_secret_comment' => 'Unesi svoj Mandrill API ključ.',
        'ses' => 'SES',
        'ses_key' => 'SES ključ',
        'ses_key_comment' => 'Unesi svoj SES API ključ.',
        'ses_secret' => 'SES tajna',
        'ses_secret_comment' => 'Unesi svoju SES API tajnu.',
        'sparkpost' => 'SparkPost',
        'sparkpost_secret' => 'SparkPost tajna',
        'sparkpost_secret_comment' => 'Unesi svoju SparkPost API tajnu.',
        'ses_region' => 'SES region',
        'ses_region_comment' => 'Unesi svoj SES region. (e.g. us-east-1)',
        'drivers_hint_header' => 'Drajveri nisu instalirani.',
        'drivers_hint_content' => 'Ovaj metod pošte zahteva instaliranje ":plugin" priključka.',
    ],
    'mail_templates' => [
        'menu_label' => 'Šabloni pošte',
        'menu_description' => 'Izmeni šablone pošte koji se šalju korisnicima i administratorima.',
        'new_template' => 'Novi šablon',
        'new_layout' => 'Novi plan',
        'new_partial' => 'Novi parcijal',
        'template' => 'Šablon',
        'templates' => 'Šabloni',
        'partial' => 'Parcijal',
        'partials' => 'Parcijali',
        'menu_layouts_label' => 'Planovi pošte',
        'menu_partials_label' => 'Parcijali pošte',
        'layout' => 'Plan',
        'layouts' => 'Planovi',
        'no_layout' => '-- Bez plana --',
        'name' => 'Naziv',
        'name_comment' => 'Unikatni naziv za referenciranje ovog šablona.',
        'code' => 'Kod',
        'code_comment' => 'Unikatan kod za referenciranje ovog šablona.',
        'subject' => 'Naslov',
        'subject_comment' => 'Naslov e-pošte.',
        'description' => 'Opis',
        'content_html' => 'HTML',
        'content_css' => 'CSS',
        'content_text' => 'Običan tekst',
        'test_send' => 'Pošalji testnu poruku',
        'test_success' => 'Test poruka poslata.',
        'test_confirm' => 'Pošalji test poruku na :email. Nastavi?',
        'creating' => 'Pravljenje šablona...',
        'creating_layout' => 'Pravljenje plana...',
        'saving' => 'Čuvanje šablona...',
        'saving_layout' => 'Čuvanje plana...',
        'delete_confirm' => 'Izbriši ovaj šablon?',
        'delete_layout_confirm' => 'Izbriši ovaj plan?',
        'deleting' => 'Brisanje šablona...',
        'deleting_layout' => 'Brisanje plana...',
        'sending' => 'Slanje testne poruke...',
        'return' => 'Povratak na listu šablona',
        'options' => 'Opcije',
        'disable_auto_inline_css' => 'Isključi automatsko uvođenje CSS-a.',
    ],
    'mail_brand' => [
        'menu_label' => 'Brendovanje pošte',
        'menu_description' => 'Modifikuj boje i izgled šablona pošte.',
        'page_title' => 'Izmeni izgled pošte',
        'sample_template' => [
            'heading' => 'Zaglavlje',
            'paragraph' => 'Ovo je paragraf ispunjen prozvoljnim tekstom koji ne znači ništa.',
            'table' => [
                'item' => 'Element',
                'description' => 'Opis',
                'price' => 'Cena',
                'centered' => 'Centrirana',
                'right_aligned' => 'Poravnjana na desno',
            ],
            'buttons' => [
                'primary' => 'Primarno dugme',
                'positive' => 'Pozitivno dugme',
                'negative' => 'Negativno dugme',
            ],
            'panel' => 'Koliko je fenomenalan ovaj panel?',
            'more' => 'Još malo teksta',
            'promotion' => 'Kupon: OKTOBAR',
            'subcopy' => 'Ovo je podkopija ovog mejla.',
            'thanks' => 'Hvala',
        ],
        'fields' => [
            '_section_background' => 'Pozadina',
            'body_bg' => 'Pozadina tela',
            'content_bg' => 'Pozadina sadržaja',
            'content_inner_bg' => 'Pozadina unutrašnjeg sadržaja',
            '_section_buttons' => 'Dugmići',
            'button_text_color' => 'Boja teksta dugmeta',
            'button_primary_bg' => 'Primarna pozadina dugmeta',
            'button_positive_bg' => 'Pozitivna pozadina dugmeta',
            'button_negative_bg' => 'Negativna pozadina dugmeta',
            '_section_type' => 'Tipografija',
            'header_color' => 'Boja zaglavlja mejla',
            'heading_color' => 'Boja zaglavlja',
            'text_color' => 'Boja teksta',
            'link_color' => 'Boja linka',
            'footer_color' => 'Boja podnožja',
            '_section_borders' => 'Ivice',
            'body_border_color' => 'Boja ivica tela',
            'subcopy_border_color' => 'Boja ivica podkopije',
            'table_border_color' => 'Boja ivica tabele',
            '_section_components' => 'Komponente',
            'panel_bg' => 'Pozadina panela',
            'promotion_bg' => 'Pozadina promocije',
            'promotion_border_color' => 'Boja ivica promocije',
        ],
    ],
    'install' => [
        'project_label' => 'Dodaj projektu',
        'plugin_label' => 'Instaliraj priključak',
        'theme_label' => 'Instaliraj temu',
        'missing_plugin_name' => 'Specificiraj naziv priključka za instaliranje.',
        'missing_theme_name' => 'Specificiraj naziv teme za instaliranje.',
        'install_completing' => 'Završavanje instalacionog procesa',
        'install_success' => 'Priključak je instaliran uspešno',
    ],
    'updates' => [
        'title' => 'Upravljaj ispravkama',
        'name' => 'Ažuriraj softver',
        'menu_label' => 'Ispravke & priključci',
        'menu_description' => 'Ažuriraj sistem, upravljaj i instaliraj priključke i teme.',
        'return_link' => 'Povratak na ažuriranje sistema',
        'check_label' => 'Proveri ispravke',
        'retry_label' => 'Pokušaj ponovo',
        'plugin_name' => 'Naziv',
        'plugin_code' => 'Kod',
        'plugin_description' => 'Opis',
        'plugin_version' => 'Verzija',
        'plugin_author' => 'Autor',
        'plugin_not_found' => 'Priključak nije pronađen',
        'core_current_build' => 'Trenutna verzija',
        'core_view_changelog' => 'Prikaži listu promena',
        'core_build' => 'Verzija :build',
        'core_build_help' => 'Novija verzija je dostupna.',
        'core_downloading' => 'Dopremanje fajlova aplikacije',
        'core_extracting' => 'Ekstrakcija fajlova aplikacije',
        'core_set_build' => 'Postavljanje broja verzije',
        'changelog' => 'Lista izmena',
        'changelog_view_details' => 'Prikaži detalje',
        'plugins' => 'Priključci',
        'themes' => 'Teme',
        'disabled' => 'Isključeni',
        'plugin_downloading' => 'Dopremanje priključka: :name',
        'plugin_extracting' => 'Ektrakcija priključka: :name',
        'plugin_version_none' => 'Novi priključak',
        'plugin_current_version' => 'Trenutna verzija',
        'theme_new_install' => 'Instalacija nove teme.',
        'theme_downloading' => 'Dopremanje teme: :name',
        'theme_extracting' => 'Ekstrakcija teme: :name',
        'update_label' => 'Ažuriranje softvera',
        'update_completing' => 'Završavanje procesa ažuriranja',
        'update_loading' => 'Učitavanje mogućih ispravki...',
        'update_success' => 'Proces ažuriranja je završen',
        'update_failed_label' => 'Ažuriranje je neuspešno',
        'force_label' => 'Ažuriraj na silu',
        'found' => [
            'label' => 'Nove ispravke su pronađene!',
            'help' => 'Klikni na ažuriraj softver da bi započeo proces.',
        ],
        'none' => [
            'label' => 'Nema ispravki',
            'help' => 'Nove ispravke nisu pronađene.',
        ],
        'important_action' => [
            'empty' => 'Izaberi radnju',
            'confirm' => 'Potvrdi ispravke',
            'skip' => 'Preskoči ovu ispravku (samo jednom)',
            'ignore' => 'Preskoči ovu ispravku (uvek)',
        ],
        'important_action_required' => 'Akcija neophodna',
        'important_view_guide' => 'Prikaži vodič za nadogradnju',
        'important_view_release_notes' => 'Prikaži beleške o izdanju',
        'important_alert_text' => 'Neke ispravke zahtevaju vašu pažnju.',
        'details_title' => 'Detalji priključka',
        'details_view_homepage' => 'Prikaži početnu stranicu',
        'details_readme' => 'Dokumentacija',
        'details_readme_missing' => 'Nema dokumentacije.',
        'details_changelog' => 'Lista izmena',
        'details_changelog_missing' => 'Nema liste izmena.',
        'details_upgrades' => 'Vodič za nadogradnju',
        'details_upgrades_missing' => 'Nema vodiča za nadogradnju.',
        'details_licence' => 'Licenca',
        'details_licence_missing' => 'Nema licence.',
        'details_current_version' => 'Trenutna verzija',
        'details_author' => 'Autor',
    ],
    'server' => [
        'connect_error' => 'Greška pri povezivanju na server.',
        'response_not_found' => 'Server za ispravke nije pronađen.',
        'response_invalid' => 'Odgovor servera nije validan.',
        'response_empty' => 'Odgovor servera je prazan.',
        'file_error' => 'Server nije uspeo da dopremi paket.',
        'file_corrupt' => 'Fajl sa servera je korumpiran.',
    ],
    'behavior' => [
        'missing_property' => 'Klasa :class mora definisati svojstvo $:property korišćeno od strane :behavior ponašanja.',
    ],
    'config' => [
        'not_found' => 'Konfiguracioni fajl :file za definisanu :location lokaciju nije mogao biti pronađen.',
        'required' => "Konfiguracija korišćena u :location lokaciji mora obezbediti vrednost za ':property' svojstvo.",
    ],
    'zip' => [
        'extract_failed' => "Ekstrakcija glavnog fajla ':file' nije moguća.",
    ],
    'event_log' => [
        'hint' => 'Ovaj log prikazuje spisak potencijalnih grešaka koje se mogu dogoditi tokom rada aplikacije.',
        'menu_label' => 'Log događaja',
        'menu_description' => 'Prikaži sistemske poruke sa vremenom i detaljima.',
        'empty_link' => 'Isprazni log događaja',
        'empty_loading' => 'Pražnjenje loga događaja...',
        'empty_success' => 'Log događaja je ispražnjen',
        'return_link' => 'Nazad na log događaja',
        'id' => 'ID',
        'id_label' => 'ID događaja',
        'created_at' => 'Datum & vreme',
        'message' => 'Poruka',
        'level' => 'Nivo',
        'preview_title' => 'Događaj',
    ],
    'request_log' => [
        'hint' => 'Ovaj log prikazuje listu zahteva koji mogu zahtevati vašu pažnju. Na primer, kada posetilac otvori neku stranicu a ona ne postoji.',
        'menu_label' => 'Log zahteva',
        'menu_description' => 'Prikaži loše ili preusmerene zahteve.',
        'empty_link' => 'Isprazni log zahteva',
        'empty_loading' => 'Pražnjenje loga zahteva...',
        'empty_success' => 'Log zahteva je ispražnjen',
        'return_link' => 'Nazad na log zahteva',
        'id' => 'ID',
        'id_label' => 'ID zahteva',
        'count' => 'Broj',
        'referer' => 'Reference',
        'url' => 'URL',
        'status_code' => 'Status',
        'preview_title' => 'Zahtev',
    ],
    'permissions' => [
        'name' => 'Sistem',
        'manage_system_settings' => 'Upravljaj sistemskim podešavanjima',
        'manage_software_updates' => 'Upravljaj softverskim ispravkama',
        'access_logs' => 'Prikaži sistemske logove',
        'manage_mail_templates' => 'Upravljaj šablonima pošte',
        'manage_mail_settings' => 'Upravljaj podešavanjima pošte',
        'manage_other_administrators' => 'Upravljaj drugim administratorima',
        'impersonate_users' => 'Oponašaj korisnike',
        'manage_preferences' => 'Upravljaj preferencama pozadinskog sistema',
        'manage_editor' => 'Upravljaj preferencama editora za kod',
        'view_the_dashboard' => 'Prikaži kontrolnu tablu',
        'manage_default_dashboard' => 'Upravljaj osnovama kontrolne table',
        'manage_branding' => 'Izmeni pozadinski sistem',
    ],
    'log' => [
        'menu_label' => 'Log podešavanja',
        'menu_description' => 'Specificiraj oblasti koje se trebaju logovati.',
        'default_tab' => 'Logovanje',
        'log_events' => 'Log sistemskih događaja',
        'log_events_comment' => 'Čuvanje sistemskih događaja u bazi podataka pored čuvanja na fajlu.',
        'log_requests' => 'Log loših zahteva',
        'log_requests_comment' => 'Zahtevi na koje treba obratiti pažnju.',
        'log_theme' => 'Log izmena kod tema',
        'log_theme_comment' => 'Kada je tema promenjena preko pozadinskog sistema.',
    ],
    'media' => [
        'invalid_path' => "Specificirana putanja fajla nije validna: ':path'.",
        'folder_size_items' => 'element(i)',
    ],
    'page' => [
        'custom_error' => [
            'label' => 'Greška kod stranice',
            'help' => 'Žao nam je, nešto je pošlo po zlu i željena stranica se ne može prikazati.',
        ],
        'invalid_token' => [
            'label' => 'Bezbednosni žeton nije validan.',
        ],
        'maintenance' => [
            'label' => "Odmah se vraćamo!",
            'help' => "Sajt je u fazi održavanja, dođite kasnije!",
            'message' => 'Poruka:',
            'available_at' => 'Pokušajte ponovo za:',
        ],
    ],
    'pagination' => [
        'previous' => 'Prošla',
        'next' => 'Sledeća',
    ],
];
