<?php /*

 Composr
 Copyright (c) ocProducts, 2004-2016

 See text/EN/licence.txt for full licencing information.


 NOTE TO PROGRAMMERS:
   Do not edit this file. If you need to make changes, save your changed file to the appropriate *_custom folder
   **** If you ignore this advice, then your website upgrades (e.g. for bug fixes) will likely kill your changes ****

*/

/**
 * @license    http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright  ocProducts Ltd
 * @package    core
 */

/**
 * Module page class.
 */
class Module_admin
{
    public $keywords;
    public $and_query = true;

    /**
     * Find details of the module.
     *
     * @return ?array Map of module info (null: module is disabled).
     */
    public function info()
    {
        $info = array();
        $info['author'] = 'Chris Graham';
        $info['organisation'] = 'ocProducts';
        $info['hacked_by'] = null;
        $info['hack_version'] = null;
        $info['version'] = 2;
        $info['locked'] = false;
        return $info;
    }

    /**
     * Find entry-points available within this module.
     *
     * @param  boolean $check_perms Whether to check permissions.
     * @param  ?MEMBER $member_id The member to check permissions as (null: current user).
     * @param  boolean $support_crosslinks Whether to allow cross links to other modules (identifiable via a full-page-link rather than a screen-name).
     * @param  boolean $be_deferential Whether to avoid any entry-point (or even return null to disable the page in the Sitemap) if we know another module, or page_group, is going to link to that entry-point. Note that "!" and "browse" entry points are automatically merged with container page nodes (likely called by page-groupings) as appropriate.
     * @return ?array A map of entry points (screen-name=>language-code/string or screen-name=>[language-code/string, icon-theme-image]) (null: disabled).
     */
    public function get_entry_points($check_perms = true, $member_id = null, $support_crosslinks = true, $be_deferential = false)
    {
        return array(
            'browse' => array('ADMIN_ZONE', 'menu/adminzone/adminzone'),
            'structure' => array('STRUCTURE', 'menu/adminzone/structure'),
            'audit' => array('AUDIT', 'menu/adminzone/audit'),
            'style' => array('STYLE', 'menu/adminzone/style'),
            'setup' => array('SETUP', 'menu/adminzone/setup'),
            'tools' => array('TOOLS', 'menu/adminzone/tools'),
            'security' => array('SECURITY', 'menu/adminzone/security'),
            'docs' => array('DOCS', 'menu/adminzone/help'),
        );
    }

    public $title;

    /**
     * Module pre-run function. Allows us to know metadata for <head> before we start streaming output.
     *
     * @return ?Tempcode Tempcode indicating some kind of exceptional output (null: none).
     */
    public function pre_run()
    {
        $type = get_param_string('type', 'browse');

        require_code('menus');
        require_lang('zones');

        switch ($type) {
            case 'browse':
            case 'structure':
            case 'audit':
            case 'style':
            case 'setup':
            case 'tools':
            case 'security':
                breadcrumb_set_self(do_lang_tempcode(($type == 'browse') ? 'ADMIN_ZONE' : strtoupper($type)));
                break;
        }

        switch ($type) {
            case 'browse':
                $this->title = get_screen_title('ADMIN_ZONE');
                break;

            case 'structure':
                $this->title = get_screen_title('menus:STRUCTURE');
                break;
            case 'audit':
                $this->title = get_screen_title('menus:AUDIT');
                break;
            case 'style':
                $this->title = get_screen_title('menus:STYLE');
                break;
            case 'setup':
                $this->title = get_screen_title('SETUP');
                break;
            case 'tools':
                $this->title = get_screen_title('TOOLS');
                break;
            case 'security':
                $this->title = get_screen_title('SECURITY');
                break;

            case 'search':
                $this->title = get_screen_title('ADMIN_ZONE_SEARCH_RESULTS');
                break;
        }

        return null;
    }

    /**
     * Execute the module.
     *
     * @return Tempcode The result of execution.
     */
    public function run()
    {
        require_code('templates_donext');
        require_code('files');

        require_all_lang();

        $type = get_param_string('type', 'browse');

        switch ($type) {
            case 'search':
                return $this->search();

            case 'browse':
                return do_next_manager_hooked('ADMIN_ZONE', 'menus:DOC_ADMIN_ZONE', '');

            case 'structure':
                return do_next_manager_hooked('menus:STRUCTURE', 'menus:DOC_STRUCTURE', 'structure');
            case 'audit':
                return do_next_manager_hooked('menus:AUDIT', 'menus:DOC_AUDIT', 'audit');
            case 'style':
                return do_next_manager_hooked('menus:STYLE', 'menus:DOC_STYLE', 'style');
            case 'setup':
                return do_next_manager_hooked('SETUP', 'menus:DOC_SETUP', 'setup');
            case 'tools':
                return do_next_manager_hooked('TOOLS', 'menus:DOC_TOOLS', 'tools');
            case 'security':
                return do_next_manager_hooked('SECURITY', 'menus:DOC_SECURITY', 'security');
        }

        return do_next_manager_hooked('MENU', 'menus:DOC_FRONTEND_ICONS', $type);
    }

    /**
     * Get synonyms for Composr terminology.
     *
     * @return array Synonyms (each element is an array of synonyms).
     */
    public function _synonyms()
    {
        require_code('textfiles');
        $sets = explode("\n", read_text_file('synonyms', user_lang()));
        $_sets = array();
        foreach ($sets as $set) {
            $_set = explode("\t", $set);
            $__set = array();
            foreach ($_set as $val) {
                if (trim($val) != '') {
                    $__set[] = $val;
                }
            }

            if (count($__set) != 0) {
                $_sets[] = $__set;
            }
        }
        return $_sets;
    }

    /**
     * Strip junk words from the keywords representing a search.
     *
     * @param  array $words Input words.
     * @return array Replaced, with junk words removed.
     */
    public function _strip_junk_words($words)
    {
        require_code('textfiles');
        $bad = array_flip(explode("\n", read_text_file('too_common_words', user_lang())));
        unset($bad['']);

        $bad = array();
        $_words = array();
        foreach ($words as $i => $b) {
            if (!isset($bad[$b])) {
                if ((($b != 'chat') || (!array_key_exists($i + 1, $words)) || (($words[$i + 1] != 'room') && ($words[$i + 1] != 'rooms'))) && (($b != 'user') || (!array_key_exists($i + 1, $words)) || (($words[$i + 1] != 'group') && ($words[$i + 1] != 'groups')))) {
                    $_words[] = $b;
                } else {// Special case of compound terms that are actually single words in Composr; fix the word, and also stop ridiculous amounts of spurious result
                    $words[$i + 1] = $b . $words[$i + 1];
                }
            }
        }
        return $_words;
    }

    /**
     * See if a string matches one of the keywords.
     *
     * @param  ?string $t Search string (null: came in null for whatever reason).
     * @return boolean Whether there is a match.
     */
    public function _keyword_match($t)
    {
        if ($t === null) {
            return false;
        }

        static $regexp = '';
        if (($regexp == '') || ($this->and_query)) {
            foreach ($this->keywords as $keyword_group) {
                if ($this->and_query) {
                    $regexp = '';
                }
                $there_somewhere = false;
                foreach ($keyword_group as $keyword) {
                    if ($regexp != '') {
                        $regexp .= '|';
                    }
                    $regexp_for_keyword = '((^|\.|\#|\s|\/|\-|>|\)|\(|\})' . preg_quote($keyword, '#') . ')';
                    $regexp .= $regexp_for_keyword;

                    if (!$there_somewhere) {
                        $there_somewhere = (stripos($t, $keyword) !== false);
                    }
                }
                if ($this->and_query) { // Running the regexps individually
                    if ((!$there_somewhere/*optimisation*/) || (preg_match('#' . $regexp . '#i', $t) == 0)) {
                        return false;
                    }
                }
            }
        }
        if ($this->and_query) { // Already done all the regexps individually
            return true;
        }
        // Run the built up OR regexp
        return (preg_match('#' . $regexp . '#i', $t) != 0);
    }

    /**
     * See if our current section is going to be searched.
     *
     * @param  array $section_limitations List of sections to search (empty: search all sections).
     * @param  string $results_type Current section.
     * @return boolean Whether there is a match.
     */
    public function _section_match($section_limitations, $results_type)
    {
        if ($section_limitations == array()) {
            return true;
        }

        foreach ($section_limitations as $l) {
            if (@stripos($results_type, $l) !== false) {
                return true;
            }
        }

        return false;
    }

    /**
     * Actualiser to perform Admin Zone search.
     *
     * @return Tempcode Interface.
     */
    public function search()
    {
        require_code('zones2');
        disable_php_memory_limit();

        $GLOBALS['NO_QUERY_LIMIT'] = true;

        if (php_function_allowed('set_time_limit')) {
            @set_time_limit(100);
        }
        send_http_output_ping();

        $n = mixed();

        $default_theme = $GLOBALS['FORUM_DRIVER']->get_theme('');

        // Mess around to find our search keywords (takes synonyms into account, and generally tidies up)
        $raw_search_string = get_param_string('content', false, true);

        cms_profile_start_for('admin search:derive keywords');

        // Work out our keywords
        $keyword_string = $raw_search_string;
        $_keywords = array();
        $current_word = '';
        $in_quotes = false;
        for ($xi = 0; $xi < strlen($keyword_string); $xi++) {
            if (($in_quotes) || (trim($keyword_string[$xi]) != '')) {
                if ($keyword_string[$xi] == '"') {
                    $in_quotes = !$in_quotes;
                } else {
                    $current_word .= $keyword_string[$xi];
                }
            } else {
                if ($current_word != '') {
                    $_keywords[] = $current_word;
                }
                $current_word = '';
            }
        }
        if ($current_word != '') {
            $_keywords[] = $current_word;
        }
        $_keywords = $this->_strip_junk_words($_keywords);
        if (count($_keywords) == 0) {
            return do_template('INDEX_SCREEN_FANCIER_SCREEN', array('_GUID' => '8635190f315a0c1cf1d5bad4009a7955', 'TITLE' => get_screen_title('ADMIN_ZONE_SEARCH_RESULTS'), 'EMPTY' => true, 'ARRAY' => true, 'CONTENT' => '', 'PRE' => '', 'POST' => ''));
        }
        $keywords = array(); // Keyword groups
        $synonym_rows = $this->_synonyms(); // Only in English by default. To do for another language, override this file using inheritance
        $section_limitations = array();
        foreach ($_keywords as $xi => $keyword) {
            $__keywords = array();
            $keyword = trim($keyword);
            if ($keyword == '') {
                continue;
            }

            if (substr($keyword, 0, 1) == '@') {
                $section_limitations[] = substr($keyword, 1);
                continue;
            }

            foreach ($synonym_rows as $synonyms) {
                if ((in_array(strtolower($keyword), $synonyms)) || ((array_key_exists($xi + 1, $_keywords)) && (in_array(strtolower($_keywords[$xi] . ' ' . $_keywords[$xi + 1]), $synonyms)))) {
                    if (in_array('', $synonyms)) {
                        foreach ($synonyms as $synonym) {
                            if (($synonym != '') || (count($_keywords) > 2/*Stop word only if longish search*/)) {
                                $__keywords[] = $synonym;
                            }
                        }
                    } else {
                        $__keywords = array_merge($__keywords, $synonyms);
                    }
                }
            }

            $__keywords[] = $keyword;
            $keywords[] = $__keywords;
        }

        // Stemming, if available (needs Stemmer class like http://www.chuggnutt.com/stemmer-source.php which we can't redistribute due to it being GPL not LGPL)
        if (((is_file(get_file_base() . '/sources/lang_stemmer_' . user_lang() . '.php')) || (is_file(get_file_base() . '/sources_custom/lang_stemmer_' . user_lang() . '.php'))) && (!in_safe_mode())) {
            require_code('lang_stemmer_' . user_lang());
            $stemmer = object_factory('Stemmer_' . user_lang());
            foreach ($keywords as $i => $keyword_group) {
                $_keyword_group = $keyword_group;
                foreach ($keyword_group as $keyword) {
                    // Special stemmer exceptions
                    if ($keyword == 'news') {
                        continue;
                    }
                    if ($keyword == 'defaultness') {
                        continue;
                    }

                    $_keyword_group[] = $stemmer->stem($keyword);
                }
                $keywords[$i] = array_unique($_keyword_group);
            }
        } else {
            foreach ($keywords as $i => $keyword_group) {
                $_keyword_group = $keyword_group;
                foreach ($keyword_group as $keyword) { // Lame pluralisation fudge, if we don't have stemming
                    if ((strlen($keyword) > 3) && (substr($keyword, -1) == 's')) {
                        $_keyword_group[] = substr($keyword, 0, strlen($keyword) - 1);
                    } else {
                        $_keyword_group[] = $keyword . 's';
                    }
                }
                $keywords[$i] = array_unique($_keyword_group);
            }
        }

        $this->keywords = $keywords;

        cms_profile_end_for('admin search:derive keywords');

        $content = array();

        // Targeted tips
        $current_results_type = do_lang('TIPS');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if ($this->_section_match($section_limitations, $current_results_type)) {
            $content[$current_results_type] = new Tempcode();
            $tips = array(
                'delete' => 'TIP_1j',
            );
            foreach ($tips as $n => $tip_string) {
                if ($this->_keyword_match($n)) {
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'de0b2510ac9640ec36805fe39025afdf', 'NAME' => do_lang_tempcode($tip_string, escape_html(get_brand_base_url()), escape_html(brand_name())), 'URL' => '', 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => '')));
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Admin/CMS menu icons
        $current_results_type = do_lang('ADMIN_MODULES');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if ($this->_section_match($section_limitations, $current_results_type)) {
            $content[$current_results_type] = new Tempcode();
            $hooks = find_all_hooks('systems', 'page_groupings');
            foreach (array_keys($hooks) as $hook) {
                require_code('hooks/systems/page_groupings/' . filter_naughty_harsh($hook));
                $object = object_factory('Hook_page_groupings_' . filter_naughty_harsh($hook), true);
                if (is_null($object)) {
                    continue;
                }
                $info = $object->run(null, true);
                foreach ($info as $i) {
                    if (is_null($i)) {
                        continue;
                    }

                    $n = $i[3];
                    if (($i[0] != '') && ($this->_keyword_match(is_object($n) ? $n->evaluate() : $n)) && (has_actual_page_access(get_member(), $i[2][0], $i[2][2]))) {
                        $_url = build_url(array('page' => $i[2][0]) + $i[2][1], $i[2][2]);
                        $breadcrumbs = new Tempcode();
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => $i[0]), 'adminzone'), do_lang_tempcode(($i[0] == 'social') ? 'SECTION_SOCIAL' : strtoupper($i[0])), false, false));
                        $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                        $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'ec53a1d45fe6a80308bf509b896d2763', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => $sup)));
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Cleanup tools
        $current_results_type = do_lang('CLEANUP_TOOLS');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (has_actual_page_access(get_member(), 'admin_cleanup'))) {
            $content[$current_results_type] = new Tempcode();
            $hooks = find_all_hooks('systems', 'cleanup');
            foreach (array_keys($hooks) as $hook) {
                require_code('hooks/systems/cleanup/' . filter_naughty_harsh($hook));
                $object = object_factory('Hook_cleanup_' . filter_naughty_harsh($hook), true);
                if (is_null($object)) {
                    continue;
                }
                $info = $object->info(true);
                if ($info !== null) {
                    $n = $info['title'];
                    if ($this->_keyword_match(is_object($n) ? $n->evaluate() : $n)) {
                        $_url = build_url(array('page' => 'admin_cleanup', 'tick' => $hook), get_module_zone('admin_cleanup'));
                        $breadcrumbs = new Tempcode();
                        $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'fc53a1d45fe6a80308bf509b896d2763', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => '')));
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Module entry points
        $current_results_type = do_lang('SCREENS');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if ($this->_section_match($section_limitations, $current_results_type)) {
            $content[$current_results_type] = new Tempcode();
            foreach (find_all_zones(false, true) as $zone => $zone_details) {
                $modules = find_all_modules($zone);
                foreach (array_keys($modules) as $page) {
                    $_entrypoints = extract_module_functions_page($zone, $page, array('get_entry_points'));
                    if (!is_null($_entrypoints[0])) {
                        $entry_points = is_array($_entrypoints[0]) ? call_user_func_array($_entrypoints[0][0], $_entrypoints[0][1]) : eval($_entrypoints[0]);
                        if ($page == 'admin_themes') {
                            $entry_points['!themes'] = array('EDIT_CSS', 'menu/adminzone/style/themes/css');
                            $entry_points['!!themes'] = array('EDIT_TEMPLATES', 'menu/adminzone/style/themes/templates');
                            $entry_points['!!!themes'] = array('EDIT_THEME_IMAGES', 'menu/adminzone/style/themes/theme_images');
                        }
                        if (is_null($entry_points)) {
                            $entry_points = array();
                        }
                        foreach ($entry_points as $type => $ep_parts) {
                            $val = $ep_parts[0];

                            $type = str_replace('!', '', $type); // The ! was a hackerish thing just to multiply-up possibilities for the single entry-point
                            if (is_object($val)) {
                                $n = $val;
                            } else {
                                $n = (preg_match('#^[A-Z\_]+$#', $val) == 0) ? make_string_tempcode($val) : do_lang_tempcode($val);
                            }

                            if (($this->_keyword_match($n->evaluate())) && (has_actual_page_access(get_member(), $page, $zone))) {
                                $breadcrumbs = new Tempcode();
                                $breadcrumbs->attach(hyperlink(build_url(array('page' => ''), $zone), $zone_details[1], false, true));
                                if (($zone == 'cms') || ($zone == 'adminzone')) {
                                    if (($page != 'admin') && ($page != 'cms')) {
                                        $hooks = find_all_hooks('systems', 'page_groupings');
                                        foreach (array_keys($hooks) as $hook) {
                                            require_code('hooks/systems/page_groupings/' . filter_naughty_harsh($hook));
                                            $object = object_factory('Hook_page_groupings_' . filter_naughty_harsh($hook), true);
                                            if (is_null($object)) {
                                                continue;
                                            }
                                            $info = $object->run();
                                            foreach ($info as $i) {
                                                if (is_null($i)) {
                                                    continue;
                                                }

                                                if (($page == $i[2][0]) && (((!array_key_exists('type', $i[2][1])) && ($type == 'browse')) || ((array_key_exists('type', $i[2][1])) && ($type == $i[2][1]['type']))) && ($zone == $i[2][2])) {
                                                    if ($i[0] == 'cms') {
                                                        $_url = build_url(array('page' => 'cms', 'type' => $i[0]), 'cms');
                                                    } else {
                                                        $_url = build_url(array('page' => 'admin', 'type' => $i[0]), 'adminzone');
                                                    }

                                                    require_lang('menus');

                                                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                                                    $breadcrumbs->attach(hyperlink($_url, do_lang_tempcode(($i[0] == 'social') ? 'SECTION_SOCIAL' : strtoupper($i[0])), false, false));
                                                    if ($type != 'browse') {
                                                        $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                                                        $breadcrumbs->attach(hyperlink(build_url(array('page' => $page, 'type' => 'browse'), $zone), $i[3], false, false));
                                                    }
                                                    break 2;
                                                }
                                            }
                                        }
                                    } else {
                                        $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                                        $breadcrumbs->attach(hyperlink(build_url(array('page' => $page), $zone), $page, false, true));
                                    }
                                }
                                if (strpos($type, ':') !== false) {
                                    $_url = page_link_to_tempcode_url($type);
                                } else {
                                    $_url = build_url(array('page' => $page, 'type' => $type), $zone);
                                }
                                $sup = $breadcrumbs->is_empty() ? null : do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                                $sitemap_editor_url = build_url(array('page' => 'admin_sitemap', 'type' => 'sitemap', 'id' => $zone . ':' . $page), get_module_zone('admin_sitemap'));
                                $permission_tree_editor_url = build_url(array('page' => 'admin_permissions', 'id' => $zone . ':' . $page), get_module_zone('admin_permissions'));
                                $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array(
                                    '_GUID' => 'f656efd513099deac516d3273f9adfc4',
                                    'NAME' => $n,
                                    'URL' => $_url,
                                    'TITLE' => '',
                                    'DESCRIPTION' => do_lang_tempcode('FIND_IN_SITEMAP_EDITOR', escape_html($sitemap_editor_url->evaluate()), escape_html($permission_tree_editor_url->evaluate())),
                                    'SUP' => $sup,
                                )));
                            }
                        }
                    }

                    $n = do_lang('MODULE_TRANS_NAME_' . $page, null, null, null, null, false);
                    if (!is_null($n)) {
                        if (($this->_keyword_match($n)) && (has_actual_page_access(get_member(), $page, $zone))) {
                            $_url = build_url(array('page' => $page), $zone);
                            $site_tree_editor_url = build_url(array('page' => 'admin_sitemap', 'type' => 'sitemap', 'id' => $zone . ':' . $page), get_module_zone('admin_sitemap'));
                            $permission_tree_editor_url = build_url(array('page' => 'admin_permissions', 'id' => $zone . ':' . $page), get_module_zone('admin_permissions'));
                            $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '65420db47f2a73b4cc24258a9e9f3ef9', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => do_lang_tempcode('FIND_IN_SITEMAP_EDITOR', escape_html($site_tree_editor_url->evaluate()), escape_html($permission_tree_editor_url->evaluate())))));
                        }
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Importers
        $current_results_type = do_lang('IMPORT');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (has_actual_page_access(get_member(), 'admin_import'))) {
            $content[$current_results_type] = new Tempcode();
            $hooks = find_all_hooks('modules', 'admin_import');
            foreach (array_keys($hooks) as $hook) {
                if ($this->_keyword_match($hook)) {
                    require_code('hooks/modules/admin_import/' . filter_naughty_harsh($hook));
                    $_hook = object_factory('Hook_' . filter_naughty_harsh($hook));
                    $info = $_hook->info();
                    $name = $info['product'];
                    $_url = build_url(array('page' => 'admin_import', 'type' => 'session', 'importer' => $hook), get_module_zone('admin_import'));
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'e0f1221d5cb9d7f34bd884d6d3e480dc', 'NAME' => $name, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => '')));
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Config options- names, descriptions, groups, categories
        $current_results_type = do_lang('CONFIGURATION');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if ((($this->_section_match($section_limitations, $current_results_type)) || ($this->_section_match($section_limitations, do_lang('OPTION_CATEGORIES'))) || ($this->_section_match($section_limitations, do_lang('OPTION_GROUPS')))) && (has_actual_page_access(get_member(), 'admin_config'))) {
            $content[$current_results_type] = new Tempcode();
            $map = array();
            $hooks = find_all_hooks('systems', 'config');
            $all_options = array();
            foreach (array_keys($hooks) as $hook) {
                require_code('hooks/systems/config/' . filter_naughty_harsh($hook));
                $ob = object_factory('Hook_config_' . filter_naughty_harsh($hook));
                $option = $ob->get_details();
                if ((is_null($GLOBALS['CURRENT_SHARE_USER'])) || ($option['shared_hosting_restricted'] == 0)) {
                    if (!is_null($ob->get_default())) {
                        $all_options[$hook] = $option;
                    }
                }
            }
            $all_options['timezone'] = array('human_name' => 'TIMEZONE', 'c_value' => '', 'the_type' => 'special', 'category' => 'SITE', 'group' => 'GENERAL', 'explanation' => 'DESCRIPTION_TIMEZONE_SITE', 'shared_hosting_restricted' => 0);
            $config_categories = array();
            $conf_found_count = 0;
            foreach ($all_options as $name => $p) {
                $_n = do_lang($p['human_name'], null, null, null, null, false);
                if (is_null($_n)) {
                    continue;
                }
                $n = do_lang_tempcode($p['human_name']);
                $t = do_lang($p['explanation'], null, null, null, null, false);

                $value = array_key_exists('c_value', $p) ? $p['c_value'] : get_option($name);

                if ((($this->_keyword_match($name)) || ($this->_keyword_match($n->evaluate())) || ($this->_keyword_match($t)) || ($this->_keyword_match($value)))) {
                    $_url = build_url(array('page' => 'admin_config', 'type' => 'category', 'id' => $p['category']), get_module_zone('admin_config'));
                    $url = $_url->evaluate();
                    $url .= '#group_' . $p['group'];
                    if (is_null($t)) {
                        $t = '';
                    }
                    $breadcrumbs = new Tempcode();
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'setup'), 'adminzone'), do_lang_tempcode('SETUP'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_config', 'type' => 'browse'), get_module_zone('admin_config')), do_lang_tempcode('CONFIGURATION'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_config', 'type' => 'category', 'id' => $p['category']), get_module_zone('admin_config')), do_lang_tempcode('CONFIG_CATEGORY_' . $p['category']), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink($url, do_lang_tempcode($p['group']), false, false));
                    $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                    $_t = ($t == '') ? new Tempcode() : do_lang_tempcode($p['explanation']);
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'f7271912ccbe0358fe263ed61f7ed427', 'NAME' => $n, 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => $_t, 'SUP' => $sup)));

                    if ($conf_found_count > 100) {
                        $content[$current_results_type] = do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '360a5362435a57f9c1d6a7b18624f53b', 'NAME' => do_lang_tempcode('TOO_MANY_TO_CHOOSE_FROM'), 'URL' => '', 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => ''));
                        break;
                    }

                    $conf_found_count++;

                    if (!array_key_exists($p['category'], $config_categories)) {
                        $config_categories[$p['category']] = array();
                    }
                    $config_categories[$p['category']][$p['group']] = 1;
                }
            }
            $current_results_type = do_lang('OPTION_CATEGORIES');
            $content[$current_results_type] = new Tempcode();
            $current_results_type_2 = do_lang('OPTION_GROUPS');
            $content[$current_results_type_2] = new Tempcode();
            foreach ($config_categories as $_p => $groups) {
                $_n = do_lang('CONFIG_CATEGORY_' . $_p, null, null, null, null, false);
                if (is_null($_n)) {
                    continue;
                }
                $n = do_lang_tempcode('CONFIG_CATEGORY_' . $_p);
                if ($this->_keyword_match($n->evaluate())) {
                    $_url = build_url(array('page' => 'admin_config', 'type' => 'category', 'id' => $_p), get_module_zone('admin_config'));
                    $description = do_lang_tempcode('CONFIG_CATEGORY_DESCRIPTION__' . $_p);
                    $breadcrumbs = new Tempcode();
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'setup'), 'adminzone'), do_lang_tempcode('SETUP'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_config', 'type' => 'browse'), get_module_zone('admin_config')), do_lang_tempcode('CONFIGURATION'), false, false));
                    $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'eec6e7cc57e660bdcbf123db8419e24e', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => $description, 'SUP' => $sup)));
                }
                foreach (array_keys($groups) as $group) {
                    $n2 = do_lang($group, null, null, null, null, false);
                    if (is_null($n2)) {
                        continue;
                    }

                    if ($this->_keyword_match($n2)) {
                        $upload_max_filesize = (ini_get('upload_max_filesize') == '0') ? do_lang('NA') : clean_file_size(php_return_bytes(ini_get('upload_max_filesize')));
                        $post_max_size = (ini_get('post_max_size') == '0') ? do_lang('NA') : clean_file_size(php_return_bytes(ini_get('post_max_size')));
                        $_group_description = do_lang('CONFIG_GROUP_DESCRIP_' . $group, escape_html($post_max_size), escape_html($upload_max_filesize), null, null, false);
                        if (is_null($_group_description)) {
                            $group_description = new Tempcode();
                        } else {
                            $group_description = do_lang_tempcode('CONFIG_GROUP_DESCRIP_' . $group, escape_html($post_max_size), escape_html($upload_max_filesize), false);
                        }
                        $_url = build_url(array('page' => 'admin_config', 'type' => 'category', 'id' => $_p), get_module_zone('admin_config'));
                        $url = $_url->evaluate();
                        $url .= '#group_' . $group;
                        $breadcrumbs = new Tempcode();
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'setup'), 'adminzone'), do_lang_tempcode('SETUP'), false, false));
                        $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_config', 'type' => 'browse'), get_module_zone('admin_config')), do_lang_tempcode('CONFIGURATION'), false, false));
                        $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_config', 'type' => 'category', 'id' => $_p), get_module_zone('admin_config')), do_lang_tempcode('CONFIG_CATEGORY_' . $_p), false, false));
                        $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                        $content[$current_results_type_2]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'e95b87d01c839e41ee1ea484feeb5cd7', 'NAME' => $n2, 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => $group_description, 'SUP' => $sup)));
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Usergroups
        $current_results_type = do_lang('USERGROUPS');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (has_actual_page_access(get_member(), 'admin_cns_groups')) && (get_forum_type() == 'cns')) {
            $content[$current_results_type] = new Tempcode();
            $map = array('g_is_private_club' => 0);
            $all_groups = $GLOBALS['FORUM_DB']->query_select('f_groups', array('id', 'g_name'), $map);
            foreach ($all_groups as $p) {
                $n = get_translated_text($p['g_name'], $GLOBALS['FORUM_DB']);
                if ($this->_keyword_match($n)) {
                    $_url = build_url(array('page' => 'admin_cns_groups', 'type' => '_edit', 'id' => $p['id']), get_module_zone('admin_cns_groups'));
                    $url = $_url->evaluate();
                    $breadcrumbs = new Tempcode();
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'security'), 'adminzone'), do_lang_tempcode('SECURITY'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_cns_groups', 'type' => 'browse'), get_module_zone('admin_cns_groups')), do_lang_tempcode('USERGROUPS'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_cns_groups', 'type' => 'edit'), get_module_zone('admin_cns_groups')), do_lang_tempcode('EDIT_GROUP'), false, false));
                    $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '785e7208a7b10dfd095197754cedf505', 'NAME' => $n, 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => $sup)));
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Themes
        $current_results_type = do_lang('THEMES');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && has_actual_page_access(get_member(), 'admin_themes')) {
            $content[$current_results_type] = new Tempcode();
            $map = array();
            foreach (array(do_lang('MOBILE_PAGES')) as $n) {
                if ($this->_keyword_match($n)) {
                    $_url = build_url(array('page' => 'admin_themes', 'type' => 'edit_theme', 'theme' => $GLOBALS['FORUM_DRIVER']->get_theme('')), get_module_zone('admin_themes'));
                    $url = $_url->evaluate();
                    $breadcrumbs = new Tempcode();
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'style'), 'adminzone'), do_lang_tempcode('STYLE'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_themes', 'type' => 'browse'), get_module_zone('admin_themes')), do_lang_tempcode('THEMES'), false, false));
                    $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '00bb6ce930058afc298ce206b703322b', 'NAME' => $n, 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => $sup)));

                    break;
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Zones
        $current_results_type = do_lang('ZONES');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && has_actual_page_access(get_member(), 'admin_zones')) {
            $content[$current_results_type] = new Tempcode();
            $map = array();
            $all_groups = $GLOBALS['SITE_DB']->query_select('zones', array('zone_name', 'zone_title', 'zone_header_text'), $map, 'ORDER BY zone_title', 50/*reasonable limit; zone_title is sequential for default zones*/);
            foreach ($all_groups as $p) {
                $n = $p['zone_name'];
                $t = get_translated_text($p['zone_title']);
                $ht = get_translated_text($p['zone_header_text']);
                if (($this->_keyword_match($n)) || ($this->_keyword_match($t)) || ($this->_keyword_match($ht))) {
                    $_url = build_url(array('page' => 'admin_zones', 'type' => '_edit', 'id' => $p['zone_name']), get_module_zone('admin_zones'));
                    $url = $_url->evaluate();
                    $breadcrumbs = new Tempcode();
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'setup'), 'adminzone'), do_lang_tempcode('STRUCTURE'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_zones', 'type' => 'browse'), get_module_zone('admin_zones')), do_lang_tempcode('ZONES'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_zones', 'type' => 'edit'), get_module_zone('admin_zones')), do_lang_tempcode('EDIT_ZONE'), false, false));
                    $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'd9e5c8d9ba1aedb920ac7c719d4ace69', 'NAME' => $n, 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => escape_html($t), 'SUP' => $sup)));
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Blocks
        $current_results_type = do_lang('_BLOCKS');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if ($this->_section_match($section_limitations, $current_results_type)) {
            $content[$current_results_type] = new Tempcode();
            $map = array();
            require_code('zones2');
            $all_blocks = find_all_blocks();
            foreach (array_keys($all_blocks) as $_p) {
                $t = do_lang('BLOCK_' . $_p . '_DESCRIPTION', null, null, null, null, false);
                if (($this->_keyword_match($_p)) || ((!is_null($t)) && ($this->_keyword_match($t)))) {
                    $url = '';
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '1368be933d0ccbcd65939f29dd6d7003', 'NAME' => $_p, 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => escape_html($t))));
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Non-installed addons
        $current_results_type = do_lang('ADDONS');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if ($this->_section_match($section_limitations, $current_results_type)) {
            $content[$current_results_type] = new Tempcode();
            $map = array();
            $dh = @opendir(get_custom_file_base() . '/imports/addons');
            if ($dh !== false) {
                while (($f = readdir($dh)) !== false) {
                    if (substr($f, -4) == '.tar') {
                        $_p = basename($f, '.tar');
                        if ($this->_keyword_match($_p)) {
                            require_code('tar');
                            $tar = tar_open(get_custom_file_base() . '/imports/addons/' . $f, 'rb');
                            $directory = tar_get_directory($tar);
                            $info_file = tar_get_file($tar, 'addon.inf');
                            if ($info_file === null) {
                                $info_file = tar_get_file($tar, 'mod.inf'); // LEGACY
                            }
                            tar_close($tar);
                            if (!is_null($info_file)) {
                                $info = better_parse_ini_file(null, $info_file['data']);

                                $title = isset($info['title']) ? $info['title'] : '';
                                $description = isset($info['description']) ? $info['description'] : '';
                                $_url = build_url(array('page' => 'admin_addons'), get_module_zone('admin_addons'));
                                $url = $_url->evaluate();
                                $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'e9cd6b45e33abf4a2136dc6b1ff5b8ee', 'NAME' => $_p, 'URL' => $url, 'TITLE' => $title, 'DESCRIPTION' => $description)));
                            }
                        }
                    }
                }
                closedir($dh);
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Privileges- sections/names/descriptions
        $current_results_type = do_lang('PRIVILEGES');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (has_actual_page_access(get_member(), 'admin_permissions'))) {
            $content[$current_results_type] = new Tempcode();
            $all_permissions = $GLOBALS['SITE_DB']->query_select('privilege_list', array('the_name', 'p_section'));
            $pt_sections = array();
            foreach ($all_permissions as $p) {
                $n = do_lang('PRIVILEGE_' . $p['the_name'], null, null, null, null, false);
                if (is_null($n)) {
                    continue;
                }
                if (($this->_keyword_match($n)) || ($this->_keyword_match($p['the_name']))) {
                    $_url = build_url(array('page' => 'admin_permissions', 'type' => 'privileges', 'id' => $p['p_section']), get_module_zone('admin_permissions'));
                    $breadcrumbs = new Tempcode();
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'security'), 'adminzone'), do_lang_tempcode('SECURITY'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_permissions', 'type' => 'privileges'), get_module_zone('admin_permissions')), do_lang_tempcode('PRIVILEGES'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink($_url, do_lang_tempcode($p['p_section']), false, false));
                    $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '52a412bd158c7dd16f3f9d0e84ae1b0b', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => $sup)));
                }
                $pt_sections[$p['p_section']] = 1;
            }
            $current_results_type = do_lang('PRIVILEGE_SECTIONS');
            $content[$current_results_type] = new Tempcode();
            foreach (array_keys($pt_sections) as $_p) {
                $n = do_lang($_p, null, null, null, null, false);
                if (is_null($n)) {
                    continue;
                }
                if (($this->_keyword_match($n)) || ($this->_keyword_match($_p))) {
                    $_url = build_url(array('page' => 'admin_permissions', 'type' => 'privileges', 'id' => $_p), get_module_zone('admin_permissions'));
                    $breadcrumbs = new Tempcode();
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'security'), 'adminzone'), do_lang_tempcode('SECURITY'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_permissions', 'type' => 'privileges'), get_module_zone('admin_permissions')), do_lang_tempcode('PRIVILEGES'), false, false));
                    $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '43bfb229943e0bb1d2c2e4512e0e5ec9', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => $sup)));
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Usergroup settings
        $current_results_type = do_lang('USERGROUP_SETTINGS_SEARCH_GROUP');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (get_forum_type() == 'cns') && (has_actual_page_access(get_member(), 'admin_cns_groups'))) {
            $content[$current_results_type] = new Tempcode();
            $applicable_langstrings = array(
                array('ENQUIRE_ON_NEW_IPS', 'DESCRIPTION_ENQUIRE_ON_NEW_IPS'),
                array('FLOOD_CONTROL_ACCESS_SECS', 'DESCRIPTION_FLOOD_CONTROL_ACCESS_SECS'),
                array('FLOOD_CONTROL_SUBMIT_SECS', 'DESCRIPTION_FLOOD_CONTROL_SUBMIT_SECS'),
                array('MAX_ATTACHMENTS_PER_POST', 'DESCRIPTION_MAX_ATTACHMENTS_PER_POST'),
                array('MAX_DAILY_UPLOAD_MB', 'DESCRIPTION_MAX_DAILY_UPLOAD_MB'),
                array('MAX_AVATAR_DIMENSIONS', 'DESCRIPTION_MAX_AVATAR_DIMENSIONS'),
                array('MAX_POST_LENGTH_COMCODE', 'DESCRIPTION_MAX_POST_LENGTH_COMCODE'),
                array('MAX_SIG_LENGTH_COMCODE', 'DESCRIPTION_MAX_SIG_LENGTH_COMCODE'),
            );
            if (addon_installed('points')) {
                $applicable_langstrings = array_merge($applicable_langstrings, array(
                    array('GIFT_POINTS_BASE', 'DESCRIPTION_GIFT_POINTS_BASE'),
                    array('GIFT_POINTS_PER_DAY', 'DESCRIPTION_GIFT_POINTS_PER_DAY'),
                ));
            }
            foreach ($applicable_langstrings as $_langstring) {
                $array = is_array($_langstring) ? $_langstring : array($_langstring);
                foreach ($array as $langstring) {
                    $n = do_lang($langstring);
                    if ($this->_keyword_match($n)) {
                        $n = do_lang_tempcode($array[0]);
                        $_url = build_url(array('page' => 'admin_cns_groups', 'type' => 'edit'), get_module_zone('admin_cns_groups'));
                        $descrip = array_key_exists(1, $array) ? do_lang_tempcode($array[1]) : new Tempcode();
                        $breadcrumbs = new Tempcode();
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'security'), 'adminzone'), do_lang_tempcode('SECURITY'), false, false));
                        $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_cns_groups', 'type' => 'browse'), get_module_zone('admin_cns_groups')), do_lang_tempcode('USERGROUPS'), false, false));
                        $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                        $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'd0baedf2ee9cf0bdd00e604bd4c7f3b4', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => $descrip, 'SUP' => $sup)));
                        continue 2;
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Member settings
        $current_results_type = do_lang('MEMBER_SETTINGS_SEARCH_GROUP');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (get_forum_type() == 'cns') && (has_actual_page_access(get_member(), 'members'))) {
            $content[$current_results_type] = new Tempcode();
            $applicable_langstrings = array(
                array('REVEAL_AGE', 'DESCRIPTION_REVEAL_AGE'),
                array('PREVIEW_POSTS', 'DESCRIPTION_PREVIEW_POSTS'),
                array('AUTO_NOTIFICATION_CONTRIB_CONTENT', 'DESCRIPTION_AUTO_NOTIFICATION_CONTRIB_CONTENT'),
                array('PT_RULES_TEXT', 'PT_RULES_TEXT_DESCRIPTION'),
            );
            foreach ($applicable_langstrings as $_langstring) {
                $array = is_array($_langstring) ? $_langstring : array($_langstring);
                foreach ($array as $langstring) {
                    $n = do_lang($langstring);
                    if ($this->_keyword_match($n)) {
                        $n = do_lang_tempcode($array[0]);
                        $descrip = array_key_exists(1, $array) ? do_lang_tempcode($array[1]) : new Tempcode();
                        $_url = build_url(array('page' => 'members', 'type' => 'view'), get_module_zone('members'), null, false, false, false, 'tab__edit');
                        $url = $_url->evaluate();
                        $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '4b2b7dd9c8c81f15583428fc2692bca5', 'NAME' => $n, 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => $descrip)));
                        continue 2;
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Zone options
        $current_results_type = do_lang('ZONE_OPTIONS');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (has_actual_page_access(get_member(), 'admin_zones', get_module_zone('admin_zones')))) {
            $content[$current_results_type] = new Tempcode();
            $applicable_langstrings = array(
                array('DEFAULT_PAGE', 'DESCRIPTION_DEFAULT_PAGE'),
                array('HEADER_TEXT', 'DESCRIPTION_HEADER_TEXT'),
                array('REQUIRE_SESSION', 'DESCRIPTION_REQUIRE_SESSION'),
                array('THEME', (get_forum_type() == 'cns') ? '_DESCRIPTION_THEME_CNS' : '_DESCRIPTION_THEME'),
            );
            foreach ($applicable_langstrings as $_langstring) {
                $array = is_array($_langstring) ? $_langstring : array($_langstring);
                foreach ($array as $langstring) {
                    $n = do_lang($langstring);
                    if ($this->_keyword_match($n)) {
                        $n = do_lang_tempcode($array[0]);
                        $_url = build_url(array('page' => 'admin_zones', 'type' => 'edit'), get_module_zone('admin_zones'));
                        $descrip = array_key_exists(1, $array) ? do_lang_tempcode($array[1]) : new Tempcode();
                        $breadcrumbs = new Tempcode();
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'structure'), 'adminzone'), do_lang_tempcode('STRUCTURE'), false, false));
                        $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_zones', 'type' => 'browse'), get_module_zone('admin_zones')), do_lang_tempcode('ZONES'), false, false));
                        $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                        $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '9c2cadfe9be9776c91c4d99050e0c187', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => $descrip, 'SUP' => $sup)));
                        continue 2;
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Install options
        $current_results_type = do_lang('BASE_CONFIGURATION');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && ($GLOBALS['FORUM_DRIVER']->is_super_admin(get_member()))) {
            $content[$current_results_type] = new Tempcode();
            if (file_exists(get_file_base() . '/config_editor.php')) {
                $file_contents = file_get_contents(get_file_base() . '/config_editor.php');
                $matches = array();
                $num_matches = preg_match_all('#case \'([^\']+)\':\n\s*\$notes=\'([^\']+)\';#', $file_contents, $matches);
                for ($i = 0; $i < $num_matches; $i++) {
                    $n = stripslashes($matches[2][$i]);
                    if ($this->_keyword_match($n)) {
                        $url = get_base_url() . '/config_editor.php';
                        $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'a7f235eb8348c285a40f30538b9d1d40', 'NAME' => stripslashes($matches[1][$i]), 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => $n)));
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Language string names and contents
        $current_results_type = do_lang('MODULE_TRANS_NAME_admin_lang');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (has_actual_page_access(get_member(), 'admin_lang', get_module_zone('admin_lang')))) {
            $content[$current_results_type] = new Tempcode();

            global $LANGUAGE_STRINGS_CACHE;
            $lang_file_contents = array();
            $lang_found = array();
            foreach ($LANGUAGE_STRINGS_CACHE[user_lang()] as $n => $n_value) { // Search all language strings (we loaded all earlier with require_all_lang)
                if (($this->_keyword_match($n)) || ($this->_keyword_match($n_value))) {
                    $lang_found[$n] = $n_value;
                    if (count($lang_found) > 100) {
                        $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'ec40bcba34ccbd6d3e31cbfd3a650241', 'NAME' => do_lang_tempcode('TOO_MANY_TO_CHOOSE_FROM'), 'URL' => '', 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => '')));
                        $lang_found = array();
                        break;
                    }
                }
            }
            foreach ($lang_found as $n => $n_value) {
                // Try and find what lang file it came from
                $lang_file = 'global';
                foreach (array('lang', 'lang_custom') as $lang_dir) {
                    $dh = @opendir(get_file_base() . '/' . $lang_dir . '/' . fallback_lang() . '/');
                    if ($dh !== false) {
                        while (($file = readdir($dh)) !== false) {
                            if (substr(strtolower($file), -4) == '.ini') {
                                if (!array_key_exists($file, $lang_file_contents)) {
                                    $lang_file_contents[$file] = file_get_contents(get_file_base() . '/' . $lang_dir . '/' . fallback_lang() . '/' . $file);
                                }
                                if ((preg_match('#^' . preg_quote($n, '#') . '=#m', $lang_file_contents[$file]) != 0) || ((file_exists(get_custom_file_base() . '/lang_custom/' . user_lang() . '/' . $file)) && (preg_match('#^' . preg_quote($n, '#') . '=#m', file_get_contents(get_custom_file_base() . '/lang_custom/' . user_lang() . '/' . $file)) != 0))) {
                                    $lang_file = basename($file, '.ini');
                                    break;
                                }
                            }
                        }
                    }
                }

                $_url = build_url(array('page' => 'admin_lang', 'type' => 'browse', 'lang' => user_lang(), 'lang_file' => $lang_file), get_module_zone('admin_lang'));
                $url = $_url->evaluate();
                $url .= '#jmp_' . $n;
                $breadcrumbs = new Tempcode();
                $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'style'), 'adminzone'), do_lang_tempcode('STYLE'), false, false));
                $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_lang', 'type' => 'browse'), get_module_zone('admin_lang')), do_lang_tempcode('TRANSLATE_CONTENT'), false, false));
                $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_lang', 'type' => 'browse', 'lang' => user_lang(), 'lang_file' => $lang_file), get_module_zone('admin_lang')), $lang_file, false, true));
                $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => 'cafa14d50ce6ecc1db1486017b364ce5', 'NAME' => $n, 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => escape_html($n_value), 'SUP' => $sup)));
            }
            $lang_file_contents = array();
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Theme images
        $current_results_type = do_lang('EDIT_THEME_IMAGES');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (has_actual_page_access(get_member(), 'admin_themes'))) {
            $content[$current_results_type] = new Tempcode();
            $images = $GLOBALS['SITE_DB']->query_select('theme_images', array('id', 'theme', 'lang'));
            foreach ($images as $image) {
                if ($image['theme'] == 'admin') {
                    continue; // Too bloaty to include
                }
                if (!file_exists(get_custom_file_base() . '/themes/' . $image['theme'])) {
                    continue; // Gone missing or no-overrides
                }

                $n = $image['id'];
                if ($this->_keyword_match($n)) {
                    $_url = build_url(array('page' => 'admin_themes', 'type' => 'edit_image', 'theme' => $image['theme'], 'lang' => $image['lang'], 'id' => $n), get_module_zone('admin_themes'));
                    $breadcrumbs = new Tempcode();
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'style'), 'adminzone'), do_lang_tempcode('STYLE'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_themes', 'type' => 'browse'), get_module_zone('admin_themes')), do_lang_tempcode('THEMES'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_themes', 'type' => 'manage_images', 'theme' => $image['theme']), get_module_zone('admin_themes')), do_lang_tempcode('EDIT_THEME_IMAGE'), false, false));
                    $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                    $breadcrumbs->attach(do_template('BREADCRUMB_LONE_WRAP', array('_GUID' => '78d769e2d7fb010318078f13f3b34ba2', 'LABEL' => $image['theme'])));
                    $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                    $lang = $image['lang'];
                    $lang_map = better_parse_ini_file(file_exists(get_file_base() . '/lang_custom/langs.ini') ? (get_file_base() . '/lang_custom/langs.ini') : (get_file_base() . '/lang/langs.ini'));
                    $lang = array_key_exists($lang, $lang_map) ? $lang_map[$lang] : $lang;
                    $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '68b418db6d3f7676cf1682a68f76f88a', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => escape_html($lang), 'SUP' => $sup)));
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // Template names
        $current_results_type = do_lang('TEMPLATES');
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (has_actual_page_access(get_member(), 'admin_themes', get_module_zone('admin_themes')))) {
            $content[$current_results_type] = new Tempcode();
            $tpl_found = array();
            foreach (array('templates_custom', 'templates', 'xml_custom', 'xml', 'text_custom', 'text') as $template_dir) {
                $dh = opendir(get_file_base() . '/themes/default/' . $template_dir . '/');
                while (($file = readdir($dh)) !== false) {
                    if (((substr(strtolower($file), -4) == '.tpl') || (substr(strtolower($file), -4) == '.xml') || (substr(strtolower($file), -4) == '.txt') || (substr(strtolower($file), -3) == '.js')) && (!array_key_exists($file, $tpl_found))) {
                        $n = $file;
                        if (($this->_keyword_match(basename($n, '.' . get_file_extension($n)))) || ($this->_keyword_match($n)) || (($template_dir == 'templates_custom') && ($this->_keyword_match(file_get_contents(get_file_base() . '/themes/default/' . $template_dir . '/' . $n))))) {
                            $_url = build_url(array('page' => 'admin_themes', 'type' => '_edit_templates', 'theme' => $default_theme, 'f0file' => $template_dir . '/' . $file), get_module_zone('admin_themes'));
                            $breadcrumbs = new Tempcode();
                            $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'style'), 'adminzone'), do_lang_tempcode('STYLE'), false, false));
                            $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                            $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_themes', 'type' => 'browse'), get_module_zone('admin_themes')), do_lang_tempcode('THEMES'), false, false));
                            $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                            $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_themes', 'type' => 'edit_templates', 'theme' => $default_theme), get_module_zone('admin_themes')), do_lang_tempcode('EDIT_TEMPLATES'), false, false));
                            $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                            $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '5cd222ad77fe4bfdf05b4856a5f7b8ac', 'NAME' => $n, 'URL' => $_url, 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => $sup)));
                            $tpl_found[$file] = true;
                        }
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        // CSS file contents
        $current_results_type = 'CSS';
        cms_profile_start_for('admin search: ' . $current_results_type);
        if (($this->_section_match($section_limitations, $current_results_type)) && (has_actual_page_access(get_member(), 'admin_themes'))) {
            $content[$current_results_type] = new Tempcode();
            $dh = opendir(get_file_base() . '/themes/default/css/');
            while (($file = readdir($dh)) !== false) {
                if (substr(strtolower($file), -4) == '.css') {
                    $n = $file;
                    if ($this->_keyword_match(file_get_contents(get_file_base() . '/themes/default/css/' . $n))) {
                        $_url = build_url(array('page' => 'admin_themes', 'type' => 'edit_css', 'theme' => $default_theme, 'file' => $file), get_module_zone('admin_themes'));
                        $url = $_url->evaluate();
                        if (isset($keywords[0])) {
                            $url .= '#' . $keywords[0][0];
                        }
                        $breadcrumbs = new Tempcode();
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin', 'type' => 'style'), 'adminzone'), do_lang_tempcode('STYLE'), false, false));
                        $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_themes', 'type' => 'browse'), get_module_zone('admin_themes')), do_lang_tempcode('THEMES'), false, false));
                        $breadcrumbs->attach(do_template('BREADCRUMB_SEPARATOR'));
                        $breadcrumbs->attach(hyperlink(build_url(array('page' => 'admin_themes', 'type' => 'choose_css', 'theme' => $default_theme), get_module_zone('admin_themes')), do_lang_tempcode('EDIT_CSS'), false, false));
                        $sup = do_lang_tempcode('LOCATED_IN', $breadcrumbs);
                        $content[$current_results_type]->attach(do_template('INDEX_SCREEN_FANCIER_ENTRY', array('_GUID' => '3ac82fa3d03b3367a03116f57993769b', 'NAME' => $n, 'URL' => $url, 'TITLE' => '', 'DESCRIPTION' => '', 'SUP' => $sup)));
                    }
                }
            }
        }
        cms_profile_end_for('admin search: ' . $current_results_type);

        //ksort($content);    Don't sort, we have an implicit good order in this code file

        // And show results...
        if (addon_installed('search')) {
            $_search_url = build_url(array('page' => 'search', 'type' => 'results', 'content' => $raw_search_string, 'days' => '-1', 'search_comcode_pages' => 1, 'all_defaults' => 1), get_module_zone('search'));
            $search_url = $_search_url->evaluate();
            $software_search_url = get_brand_base_url() . '/index.php?page=search&type=results&search_under=docs&search_comcode_pages=1&days=-1&content=' . urlencode($raw_search_string);
            $software_search_url_2 = get_brand_base_url() . '/index.php?page=search&type=results&search_cns_posts=1&days=-1&content=' . urlencode($raw_search_string);
            $pre = do_lang_tempcode('ADMINZONE_SEARCH_RESULTS', escape_html($raw_search_string), escape_html($search_url), array(escape_html($software_search_url), escape_html($software_search_url_2)));
        } else {
            $pre = new Tempcode();
        }
        $found_some = false;
        foreach ($content as $c) {
            if (!$c->is_empty()) {
                $found_some = true;
                break;
            }
        }
        $post = ((strpos($raw_search_string, '"') !== false) || (!$found_some)) ? new Tempcode() : do_lang_tempcode('ADMINZONE_SEARCH_TIP', escape_html(cms_preg_replace_safe('#\s@\w+#', '', $raw_search_string)));

        if ((!$found_some) && ($this->and_query)) { // Oh well, try as an OR query then
            $this->and_query = false;
            return $this->search();
        }

        $javascript = 'document.getElementById(\'search_content\').value=\'' . addslashes($raw_search_string) . '\';';

        return do_template('INDEX_SCREEN_FANCIER_SCREEN', array(
            '_GUID' => 'b34d4765744c359a25a0b71449eafed1',
            'TITLE' => $this->title,
            'EMPTY' => $found_some ? null : true,
            'ARRAY' => true,
            'CONTENT' => $found_some ? $content : array(),
            'PRE' => $pre,
            'POST' => $post,
            'JAVASCRIPT' => $javascript,
        ));
    }
}
