<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'pt_br', version '3.9'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Acima';
$string['activitynavigationposition'] = 'Posição do Navegador da Atividade';
$string['activitynavigationpositiondesc'] = 'Escolha entre "Acima" e "Abaixo" para o navegador da atividade. Onde "Above" é acima da atividade e "Below" é abaixo da atividade. Se você escolher usar o CSS personalizado então use o seletor \'#activitynavigation\'.';
$string['advert_alttext'] = 'Design do Tema Nível 1 Banner de propaganda';
$string['advert_heading'] = 'Design do Tema Nível 1';
$string['advert_tagline'] = 'Quer saber como customizar temas, mas não tem experiencia em desenvolvimento, experiencia com php e experiencia com temas do Moodle, então \'MoodleBites Theme Design Level 1\' é para você. Ele irá dar a você uma introdução de desenvolvimento de Temas para o Moodle e irá fornecer uma boa base para que aos poucos possa se desenvolver. Por favor, clique aqui para mais informações.';
$string['aftercontent'] = 'Depois do conteúdo';
$string['alert1'] = 'Primeiro Alerta';
$string['alert2'] = 'Segundo Alerta';
$string['alert3'] = 'Terceiro Alerta';
$string['alert_edit'] = 'Edite os alertas';
$string['alert_general'] = 'Anúncio';
$string['alert_info'] = 'Informação';
$string['alert_warning'] = 'Aviso';
$string['alertinfodesc'] = 'Forneça as definições para o seu aviso.';
$string['alertsdesc'] = 'Isto irá mostrar um alerta (ou vários) em três estilos diferentes para seus usuários na página inicial do Moodle. Por favor, lembre-se de desativar esta função quando não for mais necessário.';
$string['alertsheading'] = 'Alertas para Usuários';
$string['alertsheadingsub'] = 'Mostrar mensagens importantes para seus usuários na página inicial.';
$string['alerttext'] = 'Texto de Alerta';
$string['alerttextdesc'] = 'Qual é o texto que deseja exibir no seu alerta';
$string['alerttitle'] = 'Título';
$string['alerttitledesc'] = 'Título principal / Título para o alerta';
$string['alerttype'] = 'Nível';
$string['alerttypedesc'] = 'Defina o nível / tipo de alerta apropriado para melhor informar os seus usuários';
$string['allclasses'] = 'Todas as Classes';
$string['allcourses'] = 'Todos os Cursos';
$string['allmodules'] = 'Todos os Módulos';
$string['allunits'] = 'Todas Unidades';
$string['alternativecolors'] = 'Cores alternativas {$a}';
$string['alternativethemecolor'] = 'Cor alternativa para o tema {$a}';
$string['alternativethemecolordesc'] = 'Que cor deve ter o seu tema para as cores de tema alternativas  {$a}.';
$string['alternativethemecolorname'] = 'Nome do conjunto de cores alternativas {$a}';
$string['alternativethemecolornamedesc'] = 'Forneça um nome de fácil reconhecimento para esse conjunto de cores alternativas para o tema';
$string['alternativethemecolors'] = 'Cores alternativas do tema';
$string['alternativethemecolorsdesc'] = 'Defina as cores alternativas que o usuário pode selecionar.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Cor de fundo do botão padrão {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Configure a cor de fundo para todos os botões padrão {$a}.';
$string['alternativethemedefaultbuttontextcolour'] = 'Cor do texto do botão padrão {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Defina a cor do texto para todos os botões padrão {$a}.';
$string['alternativethemehovercolor'] = 'Cor alternativa para o tema quando passar o mouse sobre o elemento ("mouse hover") {$a}';
$string['alternativethemehovercolordesc'] = 'Que cor deve pairar sobre o tema quando passar o mouse sobre ele para as cores alternativas do tema {$a}.';
$string['alternativethemeiconcolor'] = 'Cor alternativa do ícone {$a}';
$string['alternativethemeiconcolordesc'] = 'Defina a cor alternativa {$a} para todos os ícones.';
$string['alternativethemename'] = 'Nome do esquema de cores';
$string['alternativethemenamedesc'] = 'Forneça um nome para as cores alternativas do tema';
$string['alternativethemenavcolor'] = 'Cor do texto de navegação {$a}';
$string['alternativethemenavcolordesc'] = 'Defina a cor alternativa {$a} para o texto de navegação. Sendo a barra de navegação e o breadcrumb no estilo fancy (fantasia).';
$string['alternativethemeslidecolors'] = 'Cores alternativas do slide do tema';
$string['alternativethemetextcolor'] = 'Cor alternativa para o texto {$a}';
$string['alternativethemetextcolordesc'] = 'Defina a cor para o seu texto alternativo {$a}';
$string['alternativethemeurlcolor'] = 'Cor alternativa para os links {$a}';
$string['alternativethemeurlcolordesc'] = 'Defina a cor alternativa para os textos que possuem links {$a}';
$string['alwaysdisplay'] = 'Sempre mostre';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Experimente uma URL para seu aplicativo móvel na Play Store Google. Se você não tem um aplicativo de seu uso próprio, talvez considere utilizar aplicativo Moodle oficial livre para dispositivos móveis.';
$string['androidurl'] = 'Android (Google Play) URL';
$string['backtotop'] = 'Ir para o topo';
$string['badgepreferences'] = 'Emblema';
$string['badgesmi'] = 'Emblemas';
$string['beforecontent'] = 'Antes do conteúdo';
$string['below'] = 'Abaixo';
$string['breadcrumbsimple'] = 'Simples';
$string['breadcrumbstyle'] = 'Estilo do menu de navegação (breadcrumbs)';
$string['breadcrumbstyled'] = 'Fancy (fantasia)';
$string['breadcrumbstyledesc'] = 'Aqui você pode mudar o estilo do menu de navegação (breadcrumbs)';
$string['breadcrumbstylednocollapse'] = 'Estilo Fancy (fantasia) sem colapsar';
$string['breadcrumbthin'] = 'Fino';
$string['cachesused'] = 'Usado em cache';
$string['calendarmi'] = 'Calendário';
$string['categoryctiheading'] = 'Imagens do título da categoria do curso';
$string['categoryctiheadingcs'] = 'Configuração das imagens da categoria do curso';
$string['categoryctiheadingsub'] = 'Use imagens para representar suas categorias em um curso';
$string['categoryiconcategory'] = 'O ícone para a categoria: {$a->category}.';
$string['categoryicondesc'] = 'Quando ativado você pode escolher um conjunto de ícones para cada categoria de cursos.';
$string['categoryiconheading'] = 'Ícones de categoria';
$string['categoryiconheadingsub'] = 'Use ícones para representar as categorias';
$string['categoryiconinfo'] = 'Defina os ícones padrão para as categorias';
$string['categoryiconinfodesc'] = 'Forneça o nome do ícone que você deseja usar.  A lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aqui</a>. Digite apenas o que está após "fa-".';
$string['categoryimagecategory'] = 'A imagem para a categoria: {$a->category}.';
$string['ccd'] = 'Data de criação do curso';
$string['ced'] = 'Data de finalização do curso';
$string['cfn'] = 'Nome completo do curso';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2> Essencial </ h2>
<p> <img class=img-polaroid src="essential/pix/screenshot.jpg" /> </ p>
</ div>
<div class="well">
<h3> Sobre Essencial </ h3>
<p> Essencial é um tema de inicialização Moodle modificado que herda estilos e prestadores de seu tema principal. </ p>
<h3> Pais </ h3>
<p> Este tema é baseado no tema Bootstrap, que foi criado para o Moodle 2.5, com a ajuda de: <br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans. </ P>
<h3> Tema Créditos </ h3>
<p> Autores: Julian Montado <br>
Contato: julian@moodleman.net <br>
Website: <a href="http://www.moodleman.net"> www.moodleman.net </ a>
</ p>
</ div> </ div>';
$string['cid'] = 'ID do curso';
$string['colordesc'] = 'Aqui você pode encontrar várias definições para alterar muitas das cores encontradas neste tema.';
$string['colorheading'] = 'Configurações de cores';
$string['colorheadingsub'] = 'Defina as cores usadas em seu tema';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Informações para Contato';
$string['contactinfodesc'] = 'Insira suas informações para contato';
$string['copyright'] = 'Direitos Autorais';
$string['copyrightdesc'] = 'O nome de sua organização.';
$string['coursecategorysettingstitle'] = 'Configurações da categoria do curso';
$string['coursecontentsearch'] = 'Pesquisa de conteúdo do curso';
$string['coursecontentsearchsortattribute'] = 'Atributo de ordenação da pesquisa de conteúdo do curso';
$string['coursegrades'] = 'Notas dos cursos';
$string['coursegradesmi'] = 'Notas do curso';
$string['courselistteachericon'] = 'Ícone de lista de professores do curso';
$string['courselistteachericondesc'] = 'Nome do ícone que você deseja usar ou vazio para nenhum. A lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new"> aqui </a>. Basta digitar o que está depois de "fa-", por exemplo, "estrela".';
$string['coursesettingstitle'] = 'Configurações do curso';
$string['coursetitleposition'] = 'Posição do título do curso';
$string['csd'] = 'Data de inicio do curso';
$string['ctioverride'] = 'Substituindo imagens de categoria em um curso';
$string['ctioverrideheight'] = 'Substituir a altura padrão da imagem do título do curso';
$string['ctioverridetextbackgroundcolour'] = 'Substituir a cor de fundo padrão do texto do título do curso';
$string['customcss'] = 'Customizar CSS';
$string['customcssdesc'] = 'As regras de CSS que você adicionar nesta área de texto será refletido em cada página, tornando mais fácil a personalização deste tema.';
$string['dbqueries'] = 'DB Read/Write';
$string['dbtime'] = 'Tempo de consulta do banco de dados';
$string['defaultcategoryicon'] = 'Ícones padrão de categorias';
$string['defaultcategoryicondesc'] = 'Defina um ícone padrão para a categoria';
$string['defaultcolors'] = 'Padrão de cores';
$string['displayafterlogin'] = 'Mostre apenas após o login';
$string['displaybeforelogin'] = 'Mostre apenas antes do login';
$string['displaymycourses'] = 'Exibir cursos matriculados';
$string['displaymycoursesdesc'] = 'Exibir cursos matriculados para usuários no Menu Customizável';
$string['dontdisplay'] = 'Não mostrar';
$string['enablealert'] = 'Habilitar Alerta';
$string['enablealertdesc'] = 'Habilitar ou desabilitar alertas';
$string['enablealternativethemecolors'] = 'Habilitar cores alternativas do tema {$a}';
$string['enablealternativethemecolorsdesc'] = 'Se habilitado o usuário poderá escolher as cores alternativas do tema {$a}';
$string['enablecategoryicon'] = 'Habilita os ícones de categoria';
$string['enablecategoryicondesc'] = 'se habilitado você poderá selecionar ícones de categoria depois de clicar em "Salvar mudanças".';
$string['enablecustomcategoryicon'] = 'Habilita os ícones padrão de categoria';
$string['enablecustomcategoryicondesc'] = 'se habilitado, abaixo dessa seção você verá cada categoria com uma opção de personalização, por favor salve depois de habilitar ou desabilitar essa opção.';
$string['extperfinfoheading'] = 'Informações de Desempenho Estendidas';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Digite a URL de sua página no Facebook. (Por exemplo: http://www.facebook.com/mycollege)';
$string['facebookurl'] = 'URL do Facebook';
$string['fitvids'] = 'Use FitVids';
$string['fitvidsdesc'] = 'Ative FitVids (fitvidsjs.com) para tornar seus vídeos incorporados responsivos. Se FitVids está ligado e você quer excluir um vídeo, acrescente \'class ="fitvidsignore"\' para a tag \'iframe\' no modo HTML do editor. Por exemplo: <iframe class="fitvidsignore" width="420" height="315" src="// www.youtube.com/embed/enmEmym85xc" frameborder="0" allowFullScreen = ""></iframe>.';
$string['fixedwidthnarrow'] = 'Fixed width - Estreito';
$string['fixedwidthnormal'] = 'Fixed width - Normal';
$string['fixedwidthwide'] = 'Fixed width - Grande';
$string['flickr'] = 'URL do Flickr';
$string['flickrdesc'] = 'Digite a URL de sua página no Flickr. (Por exemplo: http://www.flickr.com/mycollege)';
$string['flickrurl'] = 'URL do Flickr';
$string['fontcharacterset'] = 'Conjunto de fontes adicionais do Google';
$string['fontcharactersetcyrillic'] = 'Cyrillic';
$string['fontcharactersetcyrillicext'] = 'Cyrillic Extended';
$string['fontcharactersetdesc'] = 'Escolha conjuntos adicionais de fontes para diferentes linguagens.
                                   Usar muitos conjuntos de fontes pode tornar o Moodle mais lento, portanto use apenas aqueles de que realmente precisa.';
$string['fontcharactersetgreek'] = 'Grego';
$string['fontcharactersetgreekext'] = 'Grego estendido';
$string['fontcharactersetlatinext'] = 'Latim estendido';
$string['fontcharactersetvietnamese'] = 'Vietnamita';
$string['fontfileeotbody'] = 'Corpo do arquivo de fonte EOT';
$string['fontfileeotheading'] = 'Cabeçalho do arquivo de fonte OET';
$string['fontfileotfbody'] = 'Corpo do arquivo de fonte EOT';
$string['fontfileotfheading'] = 'Cabeçalho do arquivo de fonte OET';
$string['fontfiles'] = 'Arquivos de fontes';
$string['fontfilesdesc'] = 'Envie seus arquivos de fonte aqui.';
$string['fontfilesvgbody'] = 'Corpo do arquivo de fonte SVG';
$string['fontfilesvgheading'] = 'Cabeçalho do arquivo de fonte SVG';
$string['fontfilettfbody'] = 'Corpo do arquivo de fonte TTF';
$string['fontfilettfheading'] = 'Cabeçalho do arquivo de fonte TTF';
$string['fontfilewoffbody'] = 'Corpo do arquivo de fonte WOFF';
$string['fontfilewoffheading'] = 'Cabeçalho do arquivo de fonte WOFF';
$string['fontfilewofftwobody'] = 'Corpo do arquivo de fonte WOFF2';
$string['fontfilewofftwoheading'] = 'Cabeçalho do arquivo de fonte WOFF2';
$string['fontheadingdesc'] = 'Selecione as fontes que você deseja usar no ambiente do Moodle.';
$string['fontheadingsub'] = 'Configurações de fonte';
$string['fontnamebody'] = 'Fonte do texto';
$string['fontnamebodydesc'] = 'Forneça o nome exato da fonte a ser usada para todos os outros textos.';
$string['fontnameheading'] = 'Cabeçalho da fonte';
$string['fontnameheadingdesc'] = 'Forneça o nome exato da fonte a ser usada nos cabeçalhos.';
$string['fontselect'] = 'Seletor de tipo de fonte';
$string['fontselectdesc'] = 'Escolha a partir da lista de tipos de fontes disponíveis. Por favor, salve para mostrar as opções para sua escolha.';
$string['fontsettings'] = 'Fonte';
$string['fonttypecustom'] = 'Fone personalizada';
$string['fonttypegoogle'] = 'Fontes do Google na web';
$string['footercolor'] = 'Cor da página de fundo da posição Footer';
$string['footercolordesc'] = 'Defina qual a cor de fundo presente no rodapé.';
$string['footercolors'] = 'Cores do rodapé';
$string['footercolorsdesc'] = 'Mude as cores dos rodapés das páginas';
$string['footerheading'] = 'Rodapé';
$string['footerheadingcolor'] = 'Cor do rodapé do Título';
$string['footerheadingcolordesc'] = 'Definir a cor para os títulos do bloco no rodapé.';
$string['footerhovercolor'] = 'Cor do rodapé no Hover';
$string['footerhovercolordesc'] = 'Defina a cor do seu link quando o mouse repousar sobre o texto no rodapé.';
$string['footersepcolor'] = 'Cor do separador no rodapé';
$string['footersepcolordesc'] = 'Separadores são linhas usadas para separar o conteúdo. Defina sua cor aqui.';
$string['footertextcolor'] = 'Cor de texto do rodapé';
$string['footertextcolordesc'] = 'Defina a cor que você quer que apareça em seu texto no rodapé.';
$string['footerurlcolor'] = 'Cores do link no rodapé';
$string['footerurlcolordesc'] = 'Defina a cor de seu link (texto) no rodapé.';
$string['footnote'] = 'Notas de rodapé';
$string['footnotedesc'] = 'Tudo o que você adicionar nesta área de texto será exibido no rodapé em todo o site Moodle.';
$string['frontcontent'] = 'Ative a área de conteúdo da página inicial';
$string['frontcontentarea'] = 'Conteúdo da página inicial';
$string['frontcontentareadesc'] = 'Tudo o que é digitado dentro desta caixa irá mostrar toda a largura da página Island Sands, no "Slideshow" e no "Marketing spots"';
$string['frontcontentdesc'] = 'Isso adiciona uma área de conteúdo personalizado entre o "Slideshow" e as caixas de Marketing, assim você define seu próprio conteúdo personalizado';
$string['frontcontentheading'] = 'Conteúdo da página inicial';
$string['frontpageblocks'] = 'Alinhamento dos blocos da página inicial';
$string['frontpageblocksdesc'] = 'Aqui você pode determinar se os blocos padronizados da página inicial devem ser alinhados à esquerda ou à direita.';
$string['frontpageblocksheading'] = 'Blocos da página inicial';
$string['frontpageheading'] = 'Página inicial';
$string['frontpageheadingdesc'] = 'Configure aqui quais itens adicionais você deseja mostrar na página inicial.';
$string['frontpagemiddleblocks'] = 'Ative os blocos centrais da página inicial';
$string['frontpagemiddleblocksdesc'] = 'Se ativado isso irá mostrar três localizações adicionais para blocos apenas abaixo das áreas de comercialização.';
$string['fullname'] = 'Nome completo do site';
$string['fullnamesummary'] = 'Nome completo e resumo';
$string['generalheadingdesc'] = 'Configure aqui as definições gerais para o tema.';
$string['generalheadingsub'] = 'Configuração geral';
$string['genericsettings'] = 'Geral';
$string['googleplus'] = 'URL Google+';
$string['googleplusdesc'] = 'Digite a URL de seu perfil do Google+. (Por exemplo: http://plus.google.com/107817105228930159735)';
$string['googleplusurl'] = 'URL do Google+';
$string['gotobottom'] = 'Vá para o final da página';
$string['headerbackground'] = 'Imagem de fundo do cabeçalho';
$string['headerbackgrounddesc'] = 'Envie sua própria imagem de fundo';
$string['headerheading'] = 'Cabeçalho';
$string['headertextcolor'] = 'Cor do texto do cabeçalho';
$string['headertextcolordesc'] = 'Defina a cor do texto para o cabeçalho.';
$string['headertitle'] = 'Título do cabeçalho';
$string['headertitledesc'] = 'Configure aqui qual título será mostrado no cabeçalho.';
$string['helplink'] = 'Link da ajuda';
$string['helplinkdesc'] = 'Se você escolheu URL anteriormente, preencha a URL completa para o site de ajuda (deve incluir http:// ou https://). Se escolheu Endereço de E-mail, preencha com o seu endereço de e-mail.';
$string['helplinktype'] = 'Ative o link de ajuda no menu';
$string['helplinktypedesc'] = 'Escolha como você deseja ativar a opção de ajuda no menu do usuário, você pode escolher entre fornecer a URL que será aberta em uma nova janela ou um endereço de e-mail.';
$string['hideonphone'] = 'Esconder Slideshow em dispositivos móveis';
$string['hideonphonedesc'] = 'Escolha se você deseja ter o slideshow aparecendo em celulares ou não';
$string['hideontablet'] = 'Ocultar o slide show em tablets';
$string['hideontabletdesc'] = 'Escolha se você deseja ocultar o slide show em tablets.';
$string['included'] = 'Arquivos incluidos';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Digite a URL de sua página do Instagram. (Por exemplo: http://instagram.com/mycollege)';
$string['instagramurl'] = 'URL do Instagram';
$string['ios'] = 'iPhone / iPad (App Store)';
$string['iosdesc'] = 'Teste uma URL para seu aplicativo móvel na App Store. Se você não tem um aplicativo próprio, talvez considere utilizar um aplicativo oficial Moodle livre, para dispositivos móveis.';
$string['iosicon'] = 'iOS Icons Homescreen';
$string['iosicondesc'] = 'A eles não é fornecido um ícone padrão para iOS e Android homescreens. Você pode fazer upload de seus ícones personalizados, se desejar.';
$string['iosurl'] = 'URL do iPhone/iPad (App Store)';
$string['ipadicon'] = 'Ícone iPad (Non Retina)';
$string['ipadicondesc'] = 'Ícone deve ser no formato PNG 72px por 72px';
$string['ipadretinaicon'] = 'Ícone iPad (Retina)';
$string['ipadretinaicondesc'] = 'Ícone deve ser um PNG 144px por 144px';
$string['iphoneicon'] = 'Ícone iPhone / iPod Touch (Non Retina)';
$string['iphoneicondesc'] = 'Ícone deve ser um PNG 57px por 57px';
$string['iphoneretinaicon'] = 'Ícone iPhone / iPod Touch (Retina)';
$string['iphoneretinaicondesc'] = 'Ícone deve ser um PNG 114px por 114px';
$string['layout'] = 'Use um layout claro padrão';
$string['layoutdesc'] = 'Este tema é projetado para colocar ambas as colunas do bloco ao lado. Se você preferir o layout do curso Moodle padrão, você pode marcar essa caixa e então será adotado layout da coluna no formato padrão (três colunas).';
$string['left'] = 'Esquerda';
$string['linkedin'] = 'Linkedin';
$string['linkedindesc'] = 'Digite a URL de seu perfil do LinkedIn. (Por exemplo: http://www.linkedin.com/company/mycollege)';
$string['linkedinurl'] = 'URL do Linkedin';
$string['loadtime'] = 'Tempo de carregamento';
$string['loggedinas'] = 'logado como';
$string['loggedinfrom'] = 'Logado em';
$string['logo'] = 'Logotipo';
$string['logodesc'] = 'Por favor envie seu logotipo personalizado aqui se você deseja adicioná-lo ao cabeçalho.
                      <br> A imagem deve ter 65px de altura e e qualquer largura razoável que se adapte.
                      <br> Se você carregar um logotipo, este irá substituir o ícone padrão e o nome que foi exibido por padrão.';
$string['marketing1'] = '"Marketing Spot" 01';
$string['marketing2'] = '"Marketing Spot" 02';
$string['marketing3'] = '"Marketing Spot" 03';
$string['marketingbuttontext'] = 'Texto exibido como link';
$string['marketingbuttontextdesc'] = 'Texto a ser exibido no botão.';
$string['marketingbuttonurl'] = 'Endereço do Link';
$string['marketingbuttonurldesc'] = 'URL do botão';
$string['marketingcontent'] = 'Conteúdo';
$string['marketingcontentdesc'] = 'Conteúdo a ser exibido na caixa de marketing. Mantê-lo curto e objetivo.';
$string['marketingdesc'] = 'Este tema oferece a opção de permitir que três &quot;marketing&quot; ou &quot;ad&quot; pontos apenas sob o slideshow. Estes sistemas permitem identificar facilmente informações essenciais para seus usuários e fornecer links diretos.';
$string['marketingheading'] = '"Marketing Spots"';
$string['marketingheadingsub'] = 'Três locais na primeira página para adicionar informações e links';
$string['marketingheight'] = 'Altura das imagens do marketing';
$string['marketingheightdesc'] = 'Se você quiser exibir imagens nas caixas de marketing, você pode especificar sua altura aqui.';
$string['marketingicon'] = 'Ícone';
$string['marketingicondesc'] = 'Nome do ícone que você deseja usar. Lista é <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aqui</a> . Basta digitar o que está depois do &quot;ícones&quot;.';
$string['marketingimage'] = 'Imagem';
$string['marketingimagedesc'] = 'Isto proporciona a opção de exibir uma imagem acima do texto no item de comercialização';
$string['marketinginfodesc'] = 'Introduza as definições para o seu local de marketing.';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Mostrar o título neste ponto o marketing';
$string['marketingurltarget'] = 'Destino do link';
$string['marketingurltargetdesc'] = 'Escolha como o link deve ser aberto';
$string['marketingurltargetnew'] = 'Nova página';
$string['marketingurltargetparent'] = 'Quadro pai';
$string['marketingurltargetself'] = 'Página atual';
$string['memused'] = 'Memória utilizada';
$string['mobileappsdesc'] = 'Tem um aplicativo web na App Store ou Google Play Store? Fornecer um link aqui para que seus usuários possam pegar a aplicativos on-line';
$string['mobileappsheading'] = 'Apps para dispositivos móveis';
$string['mobileappsheadingsub'] = 'Link para o seu aplicativo para que seus estudantes que usam dispositivos móveis possam baixar';
$string['myclasses'] = 'Minhas Classes';
$string['mycourses'] = 'Cursos';
$string['mycoursesinfo'] = 'Lista dinâmica de Cursos Inscritos';
$string['mycoursesinfodesc'] = 'Exibe uma lista dinâmica de cursos inscritos para o usuário.';
$string['mycoursetitle'] = 'Terminologia';
$string['mycoursetitledesc'] = 'Altere a terminologia para o link &quot;Cursos&quot; no menu dropdown';
$string['mygrades'] = 'Minhas notas';
$string['mymodules'] = 'Meus Módulos';
$string['myunits'] = 'Minhas Unidades';
$string['navbartitle'] = 'Título da barra de navegação';
$string['navbartitledesc'] = 'Configure aqui o título para mostrar na barra de navegação.';
$string['nextsection'] = 'Próxima seção';
$string['nobreadcrumb'] = 'Esconder';
$string['noenrolments'] = 'Você não tem matrículas atuais';
$string['noslidetitle'] = 'Nenhum título para o slide {$a->slide}';
$string['notitle'] = 'Sem título';
$string['numberofslides'] = 'Número de slides';
$string['numberofslides_desc'] = 'Número de slides no mostrador de slides.';
$string['oldnavbar'] = 'Use a posição antiga da barra de navegação (navbar)';
$string['oldnavbardesc'] = 'Ative essa opção para usar a antiga posição da barra de navegação (navbar).';
$string['pagebackground'] = 'Imagem de fundo da página';
$string['pagebackgrounddesc'] = 'Envie sua própria imagem de fundo. Isso vai estar lado a lado no fundo em todas as páginas. Se nada for carregado, a imagem padrão é usada.';
$string['pagebackgroundstyle'] = 'Estilo do fundo da página';
$string['pagebackgroundstyledesc'] = 'Selecione o estilo para a imagem enviada.';
$string['pagewidth'] = 'Definir a largura da página';
$string['pagewidthdesc'] = 'Escolha a partir da lista de larguras de página disponíveis para o seu site.';
$string['paypal_click'] = 'Perfil Moodle';
$string['paypal_desc'] = '{$a->url}\' para detalhes como se eu fosse um indivíduo e, portanto, não posso ter uma \'doação\' / botões \'compre-me agora\' sob os termos ou';
$string['peakmem'] = 'Pico de memória';
$string['perf_max'] = 'Detalhado';
$string['perf_min'] = 'Mínimo';
$string['perfinfo'] = 'Modo "Informações de Desempenho"';
$string['perfinfodesc'] = 'Muitos sites não precisam da informação de desempenho totalmente detalhada (especialmente quando vistas pelos usuários). Quando ativado, este mostra um formulário minimamente limpo, com informações básicas de carregamento da página.';
$string['perfinfoheading'] = 'Informações sobre o desempenho';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'Digite a URL de sua página Pinterest. (Por exemplo: http://pinterest.com/mycollege)';
$string['pinteresturl'] = 'URL do Pinterest';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Seção anterior';
$string['profilebarcustomtitle'] = 'Título da barra do bloco personalizada.';
$string['profilebarcustomtitledesc'] = 'Título para o customização do bloco.';
$string['readme_click'] = 'clique para README.txt';
$string['readme_desc'] = 'Por favor {$a->url} contendo maiores informações sobre o tema Essential.';
$string['readme_title'] = 'Leia-me do Essential';
$string['readmore'] = 'Leia mais';
$string['region-footer-left'] = 'Rodapé (esquerda)';
$string['region-footer-middle'] = 'Rodapé (centro)';
$string['region-footer-right'] = 'Rodapé (direito)';
$string['region-hidden-dock'] = 'Ocultar dos usuários';
$string['region-side-post'] = 'Direita';
$string['region-side-pre'] = 'Esquerda';
$string['right'] = 'Direita';
$string['serverload'] = 'Server Load';
$string['sessionsize'] = 'Session Size';
$string['shortname'] = 'Nome curto do site';
$string['shortnamesummary'] = 'Nome curto e resumo';
$string['siteicon'] = 'Ícone do Site';
$string['siteicondesc'] = 'Não tem um logotipo? Digite o nome do ícone que você deseja usar. Lista é <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aqui</a> . Basta digitar o que está depois do &quot;ícones&quot;.';
$string['skype'] = 'Conta do Skype';
$string['skypedesc'] = 'Digite o nome de usuário do Skype da sua conta "Skype Empresa"';
$string['skypeuri'] = 'URL da conta do Skype';
$string['slidebuttoncolor'] = 'Cor do botão de slides';
$string['slidebuttoncolordesc'] = 'Que cor o botão de navegação de slides deve ter.';
$string['slidebuttonhovercolor'] = 'Cor do botão de slides quando tiver o foco';
$string['slidebuttonhovercolordesc'] = 'Que cor o botão de slides deve ter quando tiver o foco.';
$string['slidecaption'] = 'Título do Slide';
$string['slidecaptionbelow'] = 'Legenda do slide abaixo da imagem';
$string['slidecaptionbelowdesc'] = 'Se a legenda do slide deve estar abaixo da imagem.';
$string['slidecaptionbeside'] = 'Ao lado';
$string['slidecaptioncentred'] = 'Legenda do slide centralizada';
$string['slidecaptioncentreddesc'] = 'A legenda do slide deve estar centralizada.';
$string['slidecaptiondesc'] = 'Digite o texto da legenda a ser usada para o primeiro slide';
$string['slidecaptionontop'] = 'No topo';
$string['slidecaptionoptions'] = 'Opções da legenda do slide';
$string['slidecaptionoptionsdesc'] = 'Onde as legendas devem aparecer em relação a imagem.';
$string['slidecaptionunderneath'] = 'Debaixo';
$string['slidecolor'] = 'Cor do texto do slide';
$string['slidecolordesc'] = 'Que cor a legenda do slide deve ter.';
$string['slideimage'] = 'Imagem do Slide';
$string['slideimagedesc'] = 'Imagem funciona melhor se for transparente.';
$string['slideinterval'] = 'Intervalo entre slides';
$string['slideintervaldesc'] = 'Intervalo de transição entre slides em milisegundos.';
$string['slideno'] = 'Slide {$a->slide}';
$string['slidenodesc'] = 'Digite as configurações para o slide {$a->slide}.';
$string['slideshowdesc'] = 'Isso cria um slide show dinâmico de até dezesseis slides para que você promova elementos importantes de seu site. A apresentação é responsiva, onde a altura da imagem é definida de acordo com o tamanho da tela. A altura recomendada é de 300px. A largura é fixado em 100% e, por conseguinte, a altura real será menor se a largura for maior do que o tamanho da tela. Em tamanhos de tela menor a altura é reduzida dinamicamente, sem a necessidade de fornecer imagens separadas. Para a largura de referência <767px = altura 165px, largura entre 768px e 979px = altura 225px e largura> 980px = altura 300px. Se nenhuma imagem for selecionada para um slide, então a imagem default para os slides, na pasta pix, é usada.';
$string['slideshowheading'] = 'Slideshow';
$string['slideshowheadingsub'] = 'Slideshow dinâmico para a página inicial';
$string['slidetitle'] = 'Título do Slide';
$string['slidetitledesc'] = 'Insira um título descritivo para seu slide';
$string['slideurl'] = 'Link do Slide';
$string['slideurldesc'] = 'Digite o destino do link da imagem do primeiro slide';
$string['slideurltarget'] = 'Destino do link';
$string['slideurltargetdesc'] = 'Escolha como o link deve ser aberto';
$string['slideurltargetnew'] = 'Nova página';
$string['slideurltargetparent'] = 'Quadro pai';
$string['slideurltargetself'] = 'Página atual';
$string['socialdesc'] = 'Fornecer links diretos para as redes sociais essenciais que promovem sua marca. Estes irão aparecer no cabeçalho de cada página.';
$string['socialheading'] = 'Redes Sociais';
$string['socialheadingsub'] = 'nvolva os seus usuários nas suas redes sociais';
$string['socialnetworks'] = 'Redes Sociais';
$string['sponsor_desc'] = 'Por favor, dê suporte via PayPal contatando-me via';
$string['sponsor_desc2'] = 'para manter o desenvolvimento do tema Essential, ou simplesmente para expressar sua gratidão.';
$string['sponsor_title'] = 'Patrocinador Essential';
$string['themecolor'] = 'Cor do Tema';
$string['themecolordesc'] = 'Que cor deve ser o seu tema. Isso irá alterar os componentes mulitplos a fim de produzir a cor que você escolheu através do site moodle';
$string['themecolors'] = 'Cores do tema';
$string['themehovercolor'] = 'Cor do Tema no "Hover"';
$string['themehovercolordesc'] = 'Que cor deve aparecer no "Hover" do tema?. Isto é usado para links, menus, etc';
$string['themeiconcolor'] = 'Cor do ícone';
$string['themeiconcolordesc'] = 'Defina a cor para todos os ícones.';
$string['themenavcolor'] = 'Cor da barra de navegação';
$string['themenavcolordesc'] = 'Defina a cor para a barra de navegação.';
$string['themetextcolor'] = 'Cor do texto';
$string['themetextcolordesc'] = 'Defina a cor para o seu texto.';
$string['themeurlcolor'] = 'Cor do link';
$string['themeurlcolordesc'] = 'Defina a cor para o texto do link.';
$string['thiscourse'] = 'Neste curso';
$string['togglemarketing'] = 'Exibição do seu "Marketing Spot"';
$string['togglemarketingdesc'] = 'Escolha se você deseja ocultar ou mostrar os três itens de comercialização.';
$string['toggleslideshow'] = 'Alterne a exibição da apresentação de slides';
$string['toggleslideshowdesc'] = 'Escolha se você deseja esconder ou mostrar a apresentação de slides.';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'Digite a URL de seu feed Twitter. (Por exemplo: http://www.twitter.com/mycollege)';
$string['twitterurl'] = 'URL do Twitter';
$string['variablewidth'] = 'Largura variável';
$string['visibleadminonly'] = 'Blocos estão localizados na área abaixo e só serão vistos pelos administradores';
$string['vk'] = 'Vkontakte';
$string['vkdesc'] = 'Digite a URL de sua página Vkontakte. (Por exemplo: http://www.vk.com/mycollege)';
$string['vkurl'] = 'URL do Vkontakte';
$string['website'] = 'Site';
$string['websitedesc'] = 'Digite a URL de seu próprio site. (Por exemplo: http://www.pukunui.com)';
$string['websiteurl'] = 'URL do site';
$string['windows'] = 'Windows Desktop';
$string['windowsdesc'] = 'Forneça uma URL para seu App mobile na Windows Store. Se você não tem um próprio, considere linkar com o app Moodle Mobile oficial.
(http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)';
$string['windowsurl'] = 'URL do Windows Desktop';
$string['winphone'] = 'Windows Mobile';
$string['winphonedesc'] = 'Forneça uma URL para seu App na Google Play Store. Se você não tem um próprio, considere linkar com o app Moodle Mobile.
(http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)';
$string['winphoneurl'] = 'URL do Windows Mobile';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Digite a URL de seu canal do YouTube. (Por exemplo: http://www.youtube.com/mycollege)';
$string['youtubeurl'] = 'URL do YouTube';
