<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'pt_br', version '3.9'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Você tem sessões Bigbluebuttonbn';
$string['bbbduetimeoverstartingtime'] = 'O prazo para esta atividade deve ser maior que o tempo de início';
$string['bbbdurationwarning'] = 'A duração máxima para esta sessão é %duration% minutos.';
$string['bbbrecordallfromstartwarning'] = 'Esta sessão está sendo gravada do início.';
$string['bbbrecordwarning'] = 'Esta sessão está sendo gravada.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Adicionar uma nova sala/atividade do bigbluebuttonbn';
$string['bigbluebuttonbn:join'] = 'Participar de uma reunião do bigbluebuttonbn';
$string['bigbluebuttonbn:managerecordings'] = 'Gerenciar gravações do bigbluebuttonbn';
$string['bigbluebuttonbn:view'] = 'Ver uma sala/atividade';
$string['calendarstarts'] = '{$a} está agendado para';
$string['completionattendance'] = 'O estudante precisa atender à reunião por:';
$string['completionattendancedesc'] = 'O estudante precisa atender à reunião e permanecer na sessão por, pelo menos, {$a} minuto(s)';
$string['completionattendancegroup'] = 'Requerer participação';
$string['completionattendancegroup_help'] = 'É necessário atender à reunião por (n) minutos para a conclusão';
$string['completionengagementchats'] = 'Eventos do chat';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementpollvotes'] = 'Votos da enquete';
$string['completionupdatestate'] = 'Estado de atualização de conclusão';
$string['completionvalidatestate'] = 'Validar conclusão';
$string['completionvalidatestatetriggered'] = 'A conclusão da validação foi acionada.';
$string['config_default_messages'] = 'Mensagens padrão';
$string['config_default_messages_description'] = 'Definir padrões de mensagem para atividades';
$string['config_disablecam_default_description'] = 'Se habilitado, as webcams serão desativadas.';
$string['config_disablemic_default'] = 'Desativar microfone habilitado por padrão';
$string['config_disablemic_default_description'] = 'Se habilitado, os microfones serão desativados.';
$string['config_disablemic_editable'] = 'Desativar microfone pode ser editado';
$string['config_disablemic_editable_description'] = 'Desabilitar microfone por padrão pode ser editado quando a instância for adicionada ou atualizada.';
$string['config_disablenote_default'] = 'Desabilitar anotações compartilhadas habilitado por padrão';
$string['config_disablenote_default_description'] = 'Se habilitado, as anotações compartilhadas serão desabilitadas.';
$string['config_disablenote_editable'] = 'Desabilitar anotações compartilhadas pode ser editado';
$string['config_disablenote_editable_description'] = 'Desabilitar anotações compartilhadas por padrão podem ser editadas quando a instância é adicionada ou atualizada.';
$string['config_disableprivatechat_default'] = 'Desabilitar bate-papo privado habilitado por padrão';
$string['config_disableprivatechat_default_description'] = 'Se habilitado, o bate-papo privado será desabilitado.';
$string['config_disableprivatechat_editable'] = 'Desabilitar bate-papo privado pode ser editado';
$string['config_disableprivatechat_editable_description'] = 'Desabilitar o bate-papo privado por padrão pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_disablepublicchat_default'] = 'Desabilitar o bate-papo público habilitado por padrão';
$string['config_disablepublicchat_default_description'] = 'Se habilitado, o bate-papo público será desabilitado.';
$string['config_disablepublicchat_editable'] = 'Desabilitar chat público pode ser editado';
$string['config_disablepublicchat_editable_description'] = 'Desabilitar o bate-papo público por padrão pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_experimental_features_description'] = 'Configuração para funcionalidades experimentais.';
$string['config_extended_capabilities'] = 'Configuração para ampliar as capacidades';
$string['config_extended_capabilities_description'] = 'Configuração para ampliar as capacidades quando o servidor BigBlueButton permitir.';
$string['config_general'] = 'Configuração geral';
$string['config_general_description'] = 'Essas configurações <b>sempre</b> são usadas';
$string['config_hideuserlist_default'] = 'Ocultar lista de usuários habilitada por padrão';
$string['config_hideuserlist_default_description'] = 'Se habilitado, a lista de usuários da sessão ficará oculta.';
$string['config_hideuserlist_editable'] = 'Ocultar lista de usuários pode ser editada';
$string['config_hideuserlist_editable_description'] = 'Ocultar lista de usuários por padrão pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_importrecordings'] = 'Configuração para o recurso "Importar gravações"';
$string['config_importrecordings_description'] = 'Essas configurações são específicas de recurso';
$string['config_importrecordings_enabled'] = 'Importação de gravações ativado';
$string['config_importrecordings_enabled_description'] = 'Quando esta e a função de gravação estão ativadas, é possível importar gravações de diferentes cursos para uma atividade.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importar gravações a partir de atividades excluídas ativado';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Quando este e o recurso de importação de gravação estão habilitados, é possível importar gravações de atividades que não estão mais no curso.';
$string['config_lockonjoin_default'] = 'Bloquear ao entrar habilitado por padrão';
$string['config_lockonjoin_default_description'] = 'Se habilitada, as opções bloqueadas pela configuração geral são aplicadas ao usuário quando ele ingressa. A configuração de bloqueio deve estar habilitada para que isso seja aplicado.';
$string['config_lockonjoin_editable'] = 'Bloquear ao entrar habilitado pode ser editado';
$string['config_lockonjoin_editable_description'] = 'Bloquear ao entrar habilitado pode ser editado quando a instância for adicionada ou atualizada.';
$string['config_locksettings'] = 'Configuração para configurações de bloqueio';
$string['config_meetingevents_enabled'] = 'Registrar eventos ao vivo';
$string['config_meetingevents_enabled_description'] = 'O recurso Registrar eventos de reunião está habilitado.';
$string['config_muteonstart_default'] = 'Silenciar ao iniciar ativado como padrão';
$string['config_muteonstart_default_description'] = 'Se habilitado, a sessão será silenciada no início.';
$string['config_muteonstart_description'] = 'Essas configurações ativam ou desativam opções na interface do usuário e também definem valores padrão para essas opções.';
$string['config_muteonstart_editable'] = 'Silenciar ao iniciar pode ser editado';
$string['config_muteonstart_editable_description'] = 'Silenciar na inicialização por padrão pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_participant'] = 'Configuração do participante';
$string['config_participant_description'] = 'Essas configurações definem a função por padrão para participantes em uma conferência.';
$string['config_participant_moderator_default'] = 'Moderador por padrão';
$string['config_participant_moderator_default_description'] = 'Esta regra é usada por padrão quando uma nova sala é adicionada.';
$string['config_presentation_default_description'] = 'Esta configuração permite selecionar um arquivo para usar como padrão em todas as instâncias BBB se "Pré-carregamento de apresentação" estiver habilitado.';
$string['config_preuploadpresentation'] = 'Configuração para o recurso de "Pré-carregamento de apresentação"';
$string['config_preuploadpresentation_description'] = 'Essas configurações ativam ou desativam as opções na interface do usuário e também definem valores padrão para essas opções. O recurso funciona apenas se o servidor Moodle estiver acessível para o BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Pré-carregamento de apresentação editável';
$string['config_preuploadpresentation_editable_description'] = 'O recurso de pré-carregamento da apresentação pode ser editado na IU quando a sala ou conferência é adicionada ou atualizada.';
$string['config_recording'] = 'Configuração para o recurso "Gravar reunião"';
$string['config_recording_all_from_start_default'] = 'Gravar tudo desde o início';
$string['config_recording_all_from_start_default_description'] = 'Se marcado, a reunião será gravada para começar';
$string['config_recording_all_from_start_editable'] = 'Gravar tudo desde o início pode ser editado';
$string['config_recording_all_from_start_editable_description'] = 'Se marcado, a interface inclui uma opção para habilitar e desabilitar o recurso gravar tudo desde o início.';
$string['config_recording_default'] = 'Recurso de gravação ativado por padrão';
$string['config_recording_default_description'] = 'Se ativado, as sessões criadas no BigBlueButton terão capacidades de gravação.';
$string['config_recording_description'] = 'Essas configurações são específicas do recurso';
$string['config_recording_editable'] = 'O recurso de gravação pode ser editado';
$string['config_recording_editable_description'] = 'Se for verificado, a interface inclui uma opção para ativar e desativar o recurso de gravação.';
$string['config_recording_hide_button_default'] = 'Ocultar botão de gravação';
$string['config_recording_hide_button_default_description'] = 'Se estiver marcado, o botão para gravar ficará oculto';
$string['config_recording_hide_button_editable'] = 'O botão Ocultar gravação pode ser editado';
$string['config_recording_hide_button_editable_description'] = 'Se marcado, a interface inclui uma opção para ativar e desativar o recurso de ocultar botão de gravação.';
$string['config_recordingready_enabled'] = 'Enviar notificações quando uma gravação estiver pronta';
$string['config_recordingready_enabled_description'] = 'Habilite o plugin para enviar notificações quando a gravação estiver pronta. (Só funcionará se o script post_publish_recording_ready_callback estiver habilitado no servidor BigBlueButton)';
$string['config_recordings'] = 'Configuração para o recurso "Mostrar gravações"';
$string['config_recordings_deleted_default'] = 'Incluir gravações de atividades excluídas ativadas por padrão';
$string['config_recordings_deleted_default_description'] = 'Se ativado, a tabela de gravação incluirá as gravações pertencentes a atividades excluídas se houver.';
$string['config_recordings_deleted_editable'] = 'O recurso Incluir gravações de atividades excluídas pode ser editado';
$string['config_recordings_deleted_editable_description'] = 'Incluir gravações de atividades excluídas por padrão pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_recordings_description'] = 'Essas configurações são específicas do recurso';
$string['config_recordings_general'] = 'Mostrar configurações de gravação';
$string['config_recordings_general_description'] = 'Essas configurações são usadas apenas ao mostrar gravações';
$string['config_recordings_html_default'] = 'UI como html é habilitado por padrão';
$string['config_recordings_html_default_description'] = 'Se ativado, a tabela de gravação é exibida em HTML simples por padrão.';
$string['config_recordings_html_editable'] = 'UI como recurso html pode ser editado';
$string['config_recordings_html_editable_description'] = 'A UI como valor html por padrão pode ser editada quando a instância é adicionada ou atualizada.';
$string['config_recordings_imported_default'] = 'Mostrar apenas links importados ativados por padrão';
$string['config_recordings_imported_default_description'] = 'Se ativado, a tabela de gravação incluirá apenas os links importados para gravações.';
$string['config_recordings_imported_editable'] = 'O recurso Mostrar apenas links importados pode ser editado';
$string['config_recordings_imported_editable_description'] = 'Mostrar apenas links importados por padrão pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_recordings_preview_default'] = 'A visualização está habilitada por padrão';
$string['config_recordings_preview_default_description'] = 'Se habilitada, a tabela inclui uma visualização da apresentação.';
$string['config_recordings_preview_editable'] = 'O recurso de visualização pode ser editado';
$string['config_recordings_preview_editable_description'] = 'O recurso de visualização pode ser editado quando a instância é adicionada ou atualizada.';
$string['config_recordings_sortorder'] = 'Ordenar as gravações em ordem crescente.';
$string['config_recordings_sortorder_description'] = 'Por padrão, as gravações são exibidas em ordem decrescente. Quando marcados, eles serão classificados em ordem crescente.';
$string['config_recordings_validate_url'] = 'Validar URL';
$string['config_recordings_validate_url_description'] = 'Se marcada, a URL de reprodução será validada antes de o usuário acessá-la.';
$string['config_scheduled'] = 'Configuração para "Sessões agendadas"';
$string['config_scheduled_description'] = 'Essas configurações definem alguns dos comportamentos por padrão para as sessões agendadas.';
$string['config_scheduled_duration_compensation'] = 'Tempo compensatório (minutos)';
$string['config_scheduled_duration_compensation_description'] = 'Minutos adicionados ao fechamento agendado ao calcular a duração.';
$string['config_scheduled_duration_enabled'] = 'Calcular duração ativada';
$string['config_scheduled_duration_enabled_description'] = 'A duração de uma sessão agendada é calculada com base nos horários de abertura e fechamento.';
$string['config_scheduled_pre_opening'] = 'Acessível antes do horário de abertura (minutos)';
$string['config_scheduled_pre_opening_description'] = 'O tempo em minutos para a sessão ser acessível antes do horário de abertura de horários está esgotado.';
$string['config_sendnotifications'] = 'Configuração para o recurso "Enviar notificações"';
$string['config_sendnotifications_description'] = 'Essas configurações habilitam ou desativam as opções na interface do usuário e também definem valores padrão para essas opções.';
$string['config_sendnotifications_enabled'] = 'Enviar notificações ativado';
$string['config_sendnotifications_enabled_description'] = 'Se habilitada, a IU para editar a atividade inclui uma opção para enviar uma notificação ao usuário inscrito quando a atividade é adicionada ou atualizada.';
$string['config_server_url'] = 'URL do servidor BigBlueButton';
$string['config_server_url_description'] = 'A URL do seu servidor BigBlueButton deve terminar com /bigbluebutton/. (Essa URL é padrão para um servidor BigBlueButton fornecido pela Blindside Networks que você pode usar para testes.)';
$string['config_shared_secret'] = 'Segredo compartilhado de BigBlueButton';
$string['config_shared_secret_description'] = 'O "Sal de segurança" do seu servidor BigBlueButton. (Este sal padrão é para um servidor BigBlueButton fornecido pela Blindside Networks que você pode usar para testes.)';
$string['config_uidelegation_enabled'] = 'A delegação de UI está habilitada';
$string['config_uidelegation_enabled_description'] = 'Essas configurações habilitam ou desativam a delegação de UI para o servidor BigBlueButton.';
$string['config_userlimit'] = 'Configuração para o recurso "Limite do usuário"';
$string['config_userlimit_default'] = 'Limite de usuário ativado por padrão';
$string['config_userlimit_default_description'] = 'O número de usuários permitido em uma sessão por padrão quando uma nova sala ou conferência é adicionada. Se o número estiver definido como 0, nenhum limite é estabelecido';
$string['config_userlimit_description'] = 'Essas configurações habilitam ou desativam as opções na interface do usuário e também definem valores padrão para essas opções.';
$string['config_userlimit_editable'] = 'O recurso Limite de usuário pode ser editado';
$string['config_userlimit_editable_description'] = 'O valor limite do usuário por padrão pode ser editado quando a sala ou conferência é adicionada ou atualizada.';
$string['config_voicebridge'] = 'Configuração para o recurso "Canal de voz"';
$string['config_voicebridge_description'] = 'Essas configurações habilitam ou desativam as opções na interface do usuário e também definem valores padrão para essas opções.';
$string['config_voicebridge_editable'] = 'O canal de voz da conferência pode ser editado';
$string['config_voicebridge_editable_description'] = 'O número da ponte de voz da conferência pode ser atribuído permanentemente a uma conferência de sala. Quando atribuído, o número não pode ser usado por nenhuma outra sala ou conferência';
$string['config_waitformoderator'] = 'Configuração para o recurso "Aguarde o moderador"';
$string['config_waitformoderator_cache_ttl'] = 'Aguarde o TTL do cache do moderador (segundos)';
$string['config_waitformoderator_cache_ttl_description'] = 'Para suportar uma grande carga de clientes, este plugin faz uso de um cache. Este parâmetro define a hora em que o cache será mantido antes da próxima solicitação ser enviada para o servidor BigBlueButton.';
$string['config_waitformoderator_default'] = 'Aguardar o moderador ativado por padrão';
$string['config_waitformoderator_default_description'] = 'Aguardar o moderador é habilitado por padrão quando uma nova sala ou conferência é adicionada.';
$string['config_waitformoderator_description'] = 'Essas configurações são características específicas';
$string['config_waitformoderator_editable'] = 'Aguardar o moderador pode ser editado';
$string['config_waitformoderator_editable_description'] = 'Aguardar o valor do moderador por padrão pode ser editado quando a sala ou conferência for adicionada ou atualizada.';
$string['config_waitformoderator_ping_interval'] = 'Aguardar o ping do moderador (segundos)';
$string['config_waitformoderator_ping_interval_description'] = 'Quando o recurso de espera para o moderador está ativado, o cliente envia pings para o status da sessão a cada [número] segundos. Este parâmetro define o intervalo para pedidos feitos ao servidor Moodle';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonBN está fazendo uso de config.php com uma variável global que foi descontinuada. Por favor, converta o arquivo porque isso não será suportado em futuras versões';
$string['config_warning_curl_not_installed'] = 'Este recurso requer a extensão curl para PHP instalada e habilitada. As configurações estarão acessíveis somente se esta condição for cumprida.';
$string['config_welcome_default'] = 'Mensagem de boas-vindas padrão';
$string['config_welcome_default_description'] = 'Substitui a mensagem padrão configurada para o servidor BigBlueButton. A mensagem pode incluir palavras-chave (%% CONFNAME %%, %% DIALNUM %%, %% CONFNUM %%) que serão substituídas automaticamente, e também tags html como <b> ... </b> ou <i> < / i>';
$string['config_welcome_editable'] = 'A mensagem de boas-vindas padrão pode ser editada pelos professores';
$string['config_welcome_editable_description'] = 'A mensagem de boas-vindas pode ser editada quando a instância é adicionada ou atualizada';
$string['email_body_notification_meeting_by'] = 'de';
$string['email_body_notification_meeting_description'] = 'Descrição';
$string['email_body_notification_meeting_details'] = 'Detalhes';
$string['email_body_notification_meeting_end_date'] = 'Data final';
$string['email_body_notification_meeting_has_been'] = 'foi';
$string['email_body_notification_meeting_start_date'] = 'Data inicial';
$string['email_body_notification_meeting_title'] = 'Título';
$string['email_body_recording_ready_for'] = 'Gravação para';
$string['email_body_recording_ready_is_ready'] = 'está pronto';
$string['email_footer_sent_by'] = 'Essa mensagem de notificação automática foi enviada por';
$string['email_footer_sent_from'] = 'do curso';
$string['ends_at'] = 'Termina';
$string['event_activity_created'] = 'Atividade criada';
$string['event_activity_deleted'] = 'Atividade excluída';
$string['event_activity_updated'] = 'Atividade atualizada';
$string['event_activity_viewed'] = 'Atividade visualizada';
$string['event_live_session'] = 'Evento de sessão ao vivo';
$string['event_meeting_created'] = 'Reunião criada';
$string['event_meeting_ended'] = 'Reunião terminou forçadamente';
$string['event_meeting_joined'] = 'Reunião adicionada';
$string['event_meeting_left'] = 'Reunião excluída';
$string['event_recording_deleted'] = 'Gravação excluída';
$string['event_recording_edited'] = 'Gravação editada';
$string['event_recording_imported'] = 'Gravação importada';
$string['event_recording_protected'] = 'Gravação protegida';
$string['event_recording_published'] = 'Gravação publicada';
$string['event_recording_unprotected'] = 'Gravação desprotegida';
$string['event_recording_unpublished'] = 'Gravação não publicada';
$string['event_recording_viewed'] = 'Gravação visualizada';
$string['general_error_not_allowed_to_create_instances'] = 'O usuário não tem permissão para criar qualquer tipo de instância.';
$string['general_error_unable_connect'] = 'Não foi possível conectar. Por favor verifique a url do servidor BigBlueButton e veja se o servidor BigBlueButton está executando.';
$string['index_confirm_end'] = 'Você gostaria finalizar a aula virtual?';
$string['index_disabled'] = 'desabilitado';
$string['index_enabled'] = 'habilitado';
$string['index_ending'] = 'Finalizando a sala de aula virtual ... por favor aguarde';
$string['index_error_bbtn'] = 'BigBlueButton ID {$a} está incorreto';
$string['index_error_checksum'] = 'Ocorreu um erro de soma de verificação. Certifique-se de que você digitou o sal correto.';
$string['index_error_forciblyended'] = 'Incapaz de participar desta reunião porque a mesma foi finalizada manualmente.';
$string['index_error_noinstances'] = 'Não há instâncias de bigbluebuttonbn';
$string['index_error_unable_display'] = 'Não é possível exibir as reuniões. Por favor verifique a url do servidor BigBlueButton e verifique se o servidor BigBlueButton está em execução.';
$string['index_heading'] = 'Salas BigBlueButton';
$string['index_heading_actions'] = 'Ações';
$string['index_heading_group'] = 'Grupo';
$string['index_heading_moderator'] = 'Moderadores';
$string['index_heading_name'] = 'Sala';
$string['index_heading_recording'] = 'Gravação';
$string['index_heading_users'] = 'Usuários';
$string['index_heading_viewer'] = 'Visualizadores';
$string['indicator:cognitivedepth'] = 'BigBlueButton cognitivo';
$string['indicator:cognitivedepth_help'] = 'Este indicador é baseado na profundidade cognitiva alcançada pelo estudante em uma atividade BigBlueButton.';
$string['indicator:socialbreadth'] = 'BigBlueButton social';
$string['indicator:socialbreadth_help'] = 'Este indicador é baseado na amplitude social alcançada pelo estudante em uma atividade BigBlueButton.';
$string['instance_type_default'] = 'Sala/Atividade com gravações';
$string['instance_type_recording_only'] = 'Gravações somente';
$string['instance_type_room_only'] = 'Sala/Atividade somente';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['mod_form_block_clienttype'] = 'Tecnologia Web do Cliente';
$string['mod_form_block_clienttype_flash'] = 'Cliente baseado em tecnologia Adobe Flash';
$string['mod_form_block_clienttype_html5'] = 'Cliente baseado em tecnologia HTML5';
$string['mod_form_block_general'] = 'Configurações gerais';
$string['mod_form_block_participants'] = 'Papel atribuído durante a sessão ao vivo';
$string['mod_form_block_presentation'] = 'Conteúdo da apresentação';
$string['mod_form_block_presentation_default'] = 'Conteúdo padrão da apresentação';
$string['mod_form_block_record'] = 'Configurações de gravação';
$string['mod_form_block_recordings'] = 'Configurações de gravação';
$string['mod_form_block_room'] = 'Configurações de Sala/Atividade';
$string['mod_form_block_schedule'] = 'Agendar para sessão';
$string['mod_form_field_block_clienttype'] = 'Tecnologia Web do Cliente';
$string['mod_form_field_closingtime'] = 'Fechada desde';
$string['mod_form_field_conference_name'] = 'Nome da conferência';
$string['mod_form_field_disablecam'] = 'Desativar câmera';
$string['mod_form_field_disablemic'] = 'Desativar microfones';
$string['mod_form_field_disablenote'] = 'Desativar anotações compartilhadas';
$string['mod_form_field_disableprivatechat'] = 'Desativar chat privado';
$string['mod_form_field_disablepublicchat'] = 'Desativar chat público';
$string['mod_form_field_duration'] = 'Duração';
$string['mod_form_field_duration_help'] = 'Definir a duração para uma reunião irá estabelecer o tempo máximo de reunião para finalizar a gravação';
$string['mod_form_field_hideuserlist'] = 'Ocultar lista de usuários';
$string['mod_form_field_instanceprofiles'] = 'Tipo de instância';
$string['mod_form_field_instanceprofiles_help'] = 'Selecione o tipo dessa instância de BigBlueButton.';
$string['mod_form_field_intro'] = 'Descrição';
$string['mod_form_field_intro_help'] = 'Uma descrição curta para a sala ou conferência.';
$string['mod_form_field_lockonjoin'] = 'Travar configurações ao entrar';
$string['mod_form_field_muteonstart'] = 'Mudo ao iniciar';
$string['mod_form_field_name'] = 'Nome de sala de aula virtual';
$string['mod_form_field_nosettings'] = 'Nenhuma configuração pode ser editada';
$string['mod_form_field_notification'] = 'Notificar essa mudança aos usuários inscritos';
$string['mod_form_field_notification_created_help'] = 'Enviar uma notificação aos usuários inscritos para informá-los de que essa atividade foi criada';
$string['mod_form_field_notification_help'] = 'Enviar uma notificação aos usuários inscritos para informá-los de que essa atividade foi criada ou modificada';
$string['mod_form_field_notification_modified_help'] = 'Enviar uma notificação aos usuários inscritos para informá-los de que esta atividade foi modificada';
$string['mod_form_field_notification_msg_at'] = 'em';
$string['mod_form_field_notification_msg_created'] = 'adicionado';
$string['mod_form_field_notification_msg_modified'] = 'atualizado';
$string['mod_form_field_openingtime'] = 'Aberta desde';
$string['mod_form_field_participant_add'] = 'Adicionar atribuição';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Mediador';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Visualizador';
$string['mod_form_field_participant_list'] = 'Lista de atribuição';
$string['mod_form_field_participant_list_action_add'] = 'Adicionar';
$string['mod_form_field_participant_list_action_remove'] = 'Remover';
$string['mod_form_field_participant_list_text_as'] = 'entra na sessão como';
$string['mod_form_field_participant_list_type_all'] = 'Todos os usuários inscritos';
$string['mod_form_field_participant_list_type_owner'] = 'Proprietário';
$string['mod_form_field_participant_list_type_role'] = 'Papel';
$string['mod_form_field_participant_list_type_user'] = 'Usuário';
$string['mod_form_field_record'] = 'Sessão pode ser gravada';
$string['mod_form_field_recordallfromstart'] = 'Gravar tudo desde o início';
$string['mod_form_field_recordhidebutton'] = 'Ocultar botão de gravação';
$string['mod_form_field_recordings_deleted'] = 'Incluir registros de atividades excluídas';
$string['mod_form_field_recordings_html'] = 'Mostrar a tabela em html simples';
$string['mod_form_field_recordings_imported'] = 'Mostrar somente links importados';
$string['mod_form_field_recordings_preview'] = 'Mostrar visualização da gravação';
$string['mod_form_field_room_name'] = 'Nome da sala';
$string['mod_form_field_userlimit'] = 'Limite de Usuários';
$string['mod_form_field_userlimit_help'] = 'Limite máximo de usuários autorizados em uma reunião';
$string['mod_form_field_voicebridge'] = 'Ponte de voz [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Erro de formato. Você deve incluir um número entre 1 e 9999.';
$string['mod_form_field_voicebridge_help'] = 'Número da conferência de voz que os participantes digitam para participar da conferência de voz.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Não é um valor único. Este número está sendo utilizado por outra sala ou conferência.';
$string['mod_form_field_wait'] = 'Aguardar o moderador';
$string['mod_form_field_wait_help'] = 'Os visualizadores devem aguardar até que um moderador entre na sessão antes de poder fazer isso';
$string['mod_form_field_welcome'] = 'Mensagem de boas vindas';
$string['mod_form_field_welcome_default'] = '<br>Bem-vindo ao <b>%%CONFNAME%%</ b>! <br><br>Para obter ajuda sobre o uso do BigBlueButton, veja estes eventos (curtos) <a href = "event:http://www.bigbluebutton.org/conteúdo/vídeos"><u>vídeos de tutorial</ u></a>.<br> <br>Para entrar no canal de áudio, clique no ícone do telefone (centro superior). <b>Use um fone de ouvido para evitar causar ruídos de fundo para outros.</b>';
$string['mod_form_field_welcome_help'] = 'Substitui a mensagem padrão configurada para o servidor BigBlueButton. A mensagem pode incluir palavras-chave (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) que serão substituídas automaticamente e também tags html como <b> ... </b> ou <i> </i>';
$string['mod_form_locksettings'] = 'Configurações de bloqueio';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton permite que você crie a partir de links do Moodle salas de aula em tempo real usando BigBlueButton, um sistema de webconferência de código aberto para educação a distância.

Usando BigBlueButton você pode especificar para o título, descrição, entrada de calendário (que dá um intervalo de datas para ingressar na sessão), grupos e detalhes sobre a gravação da sessão on-line.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'Administração BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Para criar e ingressar em sessões BigBlueButton, os dados do usuário precisam ser trocados com o servidor.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'O nome completo do usuário acessando o servidor BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'O ID do usuário acessando o servidor BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Armazena a configuração da sala ou atividade que define os recursos e o comportamento geral da sessão BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Uma lista de regras que definem a função que os usuários terão na reunião ao vivo. Um ID de usuário pode ser armazenado, pois as permissões podem ser concedidas por função ou usuário.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Armazena eventos acionados usando o plugin.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'O tipo de evento acionado pelo usuário.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID da reunião que o usuário teve acesso.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Pode incluir informações extras relacionadas à reunião ou gravação afetada pelo evento.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'A hora em que o log foi criado.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'O ID do usuário que acionou o evento.';
$string['removedevents'] = 'Eventos excluídos';
$string['removedlogs'] = 'Logs personalizados excluídos';
$string['removedrecordings'] = 'Gravações excluídas';
$string['removedtags'] = 'Tags excluídas';
$string['resetevents'] = 'Excluir eventos';
$string['resetlogs'] = 'Excluir logs personalizados';
$string['resetlogs_help'] = 'Excluir os logs causará a perda de referências às gravações';
$string['resetrecordings'] = 'Excluir gravações';
$string['resetrecordings_help'] = 'Excluir as gravações irá torná-las inacessíveis de qualquer lugar e não pode ser desfeito';
$string['resettags'] = 'Excluir tags';
$string['search:activity'] = 'BigBlueButton - informações de atividade';
$string['search:tags'] = 'BigBlueButton - informações de tags';
$string['sendnotification'] = 'Enviar notificação';
$string['started_at'] = 'Iniciou';
$string['starts_at'] = 'Inicia';
$string['view_conference_action_end'] = 'Terminar sessão';
$string['view_conference_action_join'] = 'Entrar na sessão';
$string['view_error_action_not_completed'] = 'Ação não pode ser completada';
$string['view_error_bigbluebutton'] = 'BigBlueButton respondeu com erros. {$a}';
$string['view_error_create'] = 'O servidor BigBlueButton respondeu com uma mensagem de erro, a reunião não pode ser criada.';
$string['view_error_current_state_not_found'] = 'O estado atual não foi encontrado. A gravação pode ter sido excluída ou o servidor BigBlueButton não é compatível com a ação executada.';
$string['view_error_import_no_courses'] = 'Sem cursos para pesquisar gravações';
$string['view_error_import_no_recordings'] = 'Nenhuma gravação neste curso para importar';
$string['view_error_invalid_session'] = 'A sessão está expirada. Volte para a página principal da atividade.';
$string['view_error_max_concurrent'] = 'O número de sessões simultâneas permitidas foi atingido.';
$string['view_error_meeting_not_running'] = 'Algo deu errado, a reunião não está sendo executada.';
$string['view_error_no_group'] = 'Não existem grupos configuardos ainda. Por favor configure os grupos antes de tentar participar da reunião.';
$string['view_error_no_group_student'] = 'Você não foi inscrito em um grupo. Por favor entre em contato com seu professor ou o administrador.';
$string['view_error_no_group_teacher'] = 'Não existem grupos configuardos ainda. Por favor configure os grupos ou entre em contato com o administrador.';
$string['view_error_unable_join'] = 'Incapaz de entrar na reunião.Por favor verifique se a url do servidor BigBlueButton está correta e se o servidor está executando.';
$string['view_error_unable_join_student'] = 'Não foi possível conectar o servidor BigBlueButton. Por favor contate seu Professor ou o Administrador.';
$string['view_error_unable_join_teacher'] = 'Não foi possível conectar o servidor BigBlueButton. Por favor contate o Administrador.';
$string['view_error_url_missing_parameters'] = 'Faltam alguns números neste URL';
$string['view_error_userlimit_reached'] = 'Foi atingido o número de usuários autorizados em uma reunião.';
$string['view_groups_nogroups_warning'] = 'A sala foi configurada para usar grupos, mas o curso não possui grupos definidos.';
$string['view_groups_notenrolled_warning'] = 'A sala foi configurada para usar grupos, mas você não está inscrito em nenhum deles.';
$string['view_groups_selection'] = 'Selecione o grupo que você deseja participar e confirme a ação';
$string['view_groups_selection_join'] = 'Entrar';
$string['view_groups_selection_warning'] = 'Existe uma sala de conferências para cada grupo. Se você tiver acesso a mais de um, certifique-se de selecionar o correto.';
$string['view_login_moderator'] = 'Logar como moderador ...';
$string['view_login_viewer'] = 'Logar como espectador ...';
$string['view_message_and'] = 'e';
$string['view_message_conference_has_ended'] = 'Esta conferência terminou.';
$string['view_message_conference_in_progress'] = 'Esta conferência está em andamento.';
$string['view_message_conference_not_started'] = 'Esta conferência ainda não começou.';
$string['view_message_conference_room_ready'] = 'Esta sala de conferências está pronta. Você pode participar da sessão agora.';
$string['view_message_conference_wait_for_moderator'] = 'Esperando um moderador para entrar.';
$string['view_message_finished'] = 'Esta atividade terminou.';
$string['view_message_has_joined'] = 'entrou';
$string['view_message_have_joined'] = 'entraram';
$string['view_message_hour'] = 'hora';
$string['view_message_hours'] = 'horas';
$string['view_message_importrecordings_disabled'] = 'O recurso para importar links de gravação está desativado neste servidor.';
$string['view_message_minute'] = 'minuto';
$string['view_message_minutes'] = 'minutos';
$string['view_message_moderator'] = 'moderador';
$string['view_message_moderators'] = 'moderadores';
$string['view_message_norecordings'] = 'Não há gravação para mostrar.';
$string['view_message_notavailableyet'] = 'Essa sessão ainda não está disponível.';
$string['view_message_recordings_disabled'] = 'Gravações foram desabilitadas neste servidor. Apenas instâncias de BigBlueButtonBN para gravações não podem ser usadas.';
$string['view_message_room_closed'] = 'Está sala está fechada.';
$string['view_message_room_open'] = 'Está sala está aberta.';
$string['view_message_room_ready'] = 'Está sala está pronta.';
$string['view_message_session_for'] = 'a sessão para';
$string['view_message_session_has_user'] = 'Há';
$string['view_message_session_has_users'] = 'Há';
$string['view_message_session_no_users'] = 'Não há usuários nessa sessão';
$string['view_message_session_running_for'] = 'Essa sessão foi executada para';
$string['view_message_session_started_at'] = 'Essa sessão começou às';
$string['view_message_tab_close'] = 'Esta guia/janela deve ser fechada manualmente';
$string['view_message_times'] = 'vezes';
$string['view_message_user'] = 'usuário';
$string['view_message_users'] = 'usuários';
$string['view_message_viewer'] = 'visualizador';
$string['view_message_viewers'] = 'visualizadores';
$string['view_mobile_message_groups_not_supported'] = 'Esta instância está habilitada para trabalhar com grupos, mas o aplicativo móvel não tem suporte para isso. Abra no desktop se quiser usar o suporte de grupo.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Você excedeu os 45 segundos nesta página, recarregue a página para ingressar corretamente na reunião.';
$string['view_noguests'] = 'O BigBlueButton não está aberto para visitantes';
$string['view_nojoin'] = 'Você não está em um papel autorizados a participar nesta sessão.';
$string['view_recording'] = 'gravação';
$string['view_recording_actionbar'] = 'Ação';
$string['view_recording_activity'] = 'Atividade';
$string['view_recording_button_import'] = 'Importar links de gravação';
$string['view_recording_button_return'] = 'Retornar';
$string['view_recording_course'] = 'Curso';
$string['view_recording_date'] = 'Data';
$string['view_recording_delete_confirmation'] = 'Tem certeza de excluir esse {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'Esta gravação tem {$a} links associados que foram importados em diferentes cursos ou atividades. Se a gravação for excluída, esses links também serão removidos';
$string['view_recording_delete_confirmation_warning_s'] = 'Esta gravação tem {$a} link associado que foi importado em um curso ou atividade diferente. Se a gravação for excluída, esse link também será removido';
$string['view_recording_description'] = 'Descrição';
$string['view_recording_duration'] = 'Duração';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'O URL para este formato de gravação está inacessível.';
$string['view_recording_format_notes'] = 'Anotações';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Apresentação';
$string['view_recording_format_screenshare'] = 'Compartilhamento de tela';
$string['view_recording_format_statistics'] = 'Estatísticas';
$string['view_recording_format_video'] = 'Vídeo';
$string['view_recording_import_confirmation'] = 'Tem certeza de importar essa gravação?';
$string['view_recording_length'] = 'Comprimento';
$string['view_recording_link'] = 'link importado';
$string['view_recording_link_warning'] = 'Este é um link apontando para uma gravação que foi criada em um curso ou atividade diferente';
$string['view_recording_list_action_delete'] = 'Excluindo';
$string['view_recording_list_action_edit'] = 'Atualizando';
$string['view_recording_list_action_play'] = 'Reproduzir';
$string['view_recording_list_action_process'] = 'Processando';
$string['view_recording_list_action_protect'] = 'Protegendo';
$string['view_recording_list_action_publish'] = 'Publicando';
$string['view_recording_list_action_unprotect'] = 'Desprotegendo';
$string['view_recording_list_action_unpublish'] = 'Cancelando a publicação';
$string['view_recording_list_action_update'] = 'Atualizando';
$string['view_recording_list_actionbar'] = 'Barra de ferramentas';
$string['view_recording_list_actionbar_delete'] = 'Excluir';
$string['view_recording_list_actionbar_edit'] = 'Editar';
$string['view_recording_list_actionbar_hide'] = 'Ocultar';
$string['view_recording_list_actionbar_import'] = 'Importar';
$string['view_recording_list_actionbar_protect'] = 'Torná-lo privativo';
$string['view_recording_list_actionbar_publish'] = 'Publicar';
$string['view_recording_list_actionbar_show'] = 'Exibir';
$string['view_recording_list_actionbar_unprotect'] = 'Torná-lo público';
$string['view_recording_list_actionbar_unpublish'] = 'Cancelar publicação';
$string['view_recording_list_activity'] = 'Atividade';
$string['view_recording_list_course'] = 'Curso';
$string['view_recording_list_date'] = 'Data';
$string['view_recording_list_description'] = 'Descrição';
$string['view_recording_list_duration'] = 'Duração';
$string['view_recording_list_recording'] = 'Gravação';
$string['view_recording_meeting'] = 'Reunião';
$string['view_recording_modal_button'] = 'Aplicar';
$string['view_recording_modal_title'] = 'Definir valores para gravação';
$string['view_recording_name'] = 'Nome';
$string['view_recording_playback'] = 'Reprodução';
$string['view_recording_preview'] = 'Visualização';
$string['view_recording_preview_help'] = 'Passe o mouse sobre uma imagem para vê-lo em tamanho completo';
$string['view_recording_publish_link_deleted'] = 'Este link não pode ser re-publicado porque a gravação real não existe no servidor BigBlueButton atual. O link deve ser removido.';
$string['view_recording_publish_link_not_published'] = 'Este link não pode ser re-publicado porque a gravação real não está publicada';
$string['view_recording_recording'] = 'Gravação';
$string['view_recording_tags'] = 'Tags';
$string['view_recording_unprotect_link_deleted'] = 'Este link não pode ser desprotegido porque a gravação real não existe no servidor BigBlueButton atual. O link deve ser removido.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Este link não pode ser desprotegido porque a gravação real está protegida';
$string['view_recording_unpublish_confirmation'] = 'Tem certeza de cancelar a publicação dessa {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Esta gravação tem {$a} links associados que foram importados em diferentes cursos ou atividades. Se a gravação não for publicada, esses links também não serão publicados';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Esta gravação tem {$a} link associado que foi importado em um curso ou atividade diferente. Se a gravação não for publicada, esse link também não será publicado.';
$string['view_recording_yui_first'] = 'Primeira';
$string['view_recording_yui_go'] = 'Ir';
$string['view_recording_yui_last'] = 'Última';
$string['view_recording_yui_next'] = 'Próxima';
$string['view_recording_yui_page'] = 'Página';
$string['view_recording_yui_prev'] = 'Anterior';
$string['view_recording_yui_rows'] = 'Linhas';
$string['view_recording_yui_show_all'] = 'Mostrar tudo';
$string['view_room'] = 'Ver sala';
$string['view_section_title_presentation'] = 'Arquivo de apresentação';
$string['view_section_title_recordings'] = 'Gravações';
$string['view_warning_default_server'] = 'Este servidor Moodle está usando o servidor de teste BigBlueButton que vem pré-configurado por padrão. Deve ser substituído para produção.';
