<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_generator', language 'no', version '3.9'.
 *
 * @package     tool_generator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bigfile'] = 'Stor fil {$a}';
$string['courseexplanation'] = 'Dette verktøyet oppretter standard testkurs som inneholder mange emnefelt, aktiviteter og filer.
Dette gjøres for å gi deg en standardisert måling når du skal sjekke stabilitet og ytelse på forskjellige systemkomponenter (som f.eks. sikkerhetskopiering og gjenoppretting).
Denne testen er viktig fordi det har vært mange situasjoner tidligere hvor produksjonsmiljøet ikke har vist seg å tåle trafikken (f.eks. et kurs med 1,000 activities).

Kurs som er opprettet med dette verkøyet vil fylle opp en stor del av databasen og filsystemet (mange titalls GB). Du vil få behov for å slette kursene (og ventet på at den automatiske oppryddingsprosessen får kjørt etterpå), før plassen blir frigjort igjen.

**Ikke bruk dette verktøyet i et produksjonsmiljø!** Verktøyet er KUN ment for bruk på en utviklingsserver. (For å forhindre at verktøyet aktiveres ved et uhell må du slå på Utvikler DEBUG for å kunne kjøre verktøyet.)';
$string['coursesize_0'] = 'XS (~10KB; lages på ~1 sekund)';
$string['coursesize_1'] = 'S (~10MB; lages på ~30 sekunder)';
$string['coursesize_2'] = 'M (~100MB; lages på ~2 minutter)';
$string['coursesize_3'] = 'L (~1GB; lages på ~30 time)';
$string['coursesize_4'] = 'XL (~10GB; lages på ~2 timer)';
$string['coursesize_5'] = 'XXL (~20GB; lages på ~4 timer)';
$string['coursewithoutusers'] = 'Det valgte kurset har ingen brukere';
$string['createcourse'] = 'Opprett kurs';
$string['createtestplan'] = 'Opprett testplan';
$string['creating'] = 'Oppretter kurs';
$string['done'] = 'utført ({$a}s)';
$string['downloadtestplan'] = 'Last ned testplan';
$string['downloadusersfile'] = 'Last ned fil med brukere';
$string['error_nocourses'] = 'Det er ingen kurs til å generere testplanen';
$string['error_noforumdiscussions'] = 'Det valgte kurset inneholder ikke noen forumdiskusjoner.';
$string['error_noforuminstances'] = 'Det valgte kurset inneholder ingen forum';
$string['error_noforumreplies'] = 'Det valgte kurset inneholder ingen svar på foruminnlegg.';
$string['error_nonexistingcourse'] = 'Dette kurset eksisterer ikke.';
$string['error_nopageinstances'] = 'Det valgte kurset inneholder ingen sider.';
$string['error_notdebugging'] = 'Ikke tilgjengelig på denne serveren fordi debuggingen ikke er satt til UTVIKLER';
$string['error_nouserspassword'] = 'Du må angi $CFG->tool_generator_users_password i config.php for å kunne generere en testplan.';
$string['fullname'] = 'Testkurs: {$a->size}';
$string['maketestcourse'] = 'Lag testkurs';
$string['maketestplan'] = 'Lag en JMeter testplan';
$string['notenoughusers'] = 'Det valgte kurset har ikke nok brukere';
$string['pluginname'] = 'Datagenerator for utviklingsformål';
$string['privacy:metadata'] = 'Modulen "Development data generator" lagrer ikke noen persondata';
$string['progress_checkaccounts'] = 'Sjekker brukerkontoer ({$a})';
$string['progress_coursecompleted'] = 'Kurset fullført  ({$a}s)';
$string['progress_createaccounts'] = 'Oppretter brukerkontoer ({$a->from} - {$a->to})';
$string['progress_createassignments'] = 'Oppretter innleveringer ({a})';
$string['progress_createbigfiles'] = 'Oppretter store filer ({$a})';
$string['progress_createcourse'] = 'Oppretter kurs {$a}';
$string['progress_createforum'] = 'Oppretter forum ({$a} posts)';
$string['progress_createpages'] = 'Oppretter sider ({$a})';
$string['progress_createsmallfiles'] = 'Oppretter små filer ({$a})';
$string['progress_enrol'] = 'Melder inn brukere i kurset ({$a})';
$string['progress_sitecompleted'] = 'Portalen fullført ({$a}s)';
$string['shortsize_0'] = 'XS';
$string['shortsize_1'] = 'S';
$string['shortsize_2'] = 'M';
$string['shortsize_3'] = 'L';
$string['shortsize_4'] = 'XL';
$string['shortsize_5'] = 'XXL';
$string['sitesize_0'] = 'XS (~10MB; 3 kurs, opprettet på ~30 sekunder)';
$string['sitesize_1'] = 'S (~50MB; 8 kurs, opprettet på ~2 minutter)';
$string['sitesize_2'] = 'M (~200MB; 73 kurs, opprettet på ~10 minutter)';
$string['sitesize_3'] = 'L (~1\'5GB; 277 kurs, opprettet på ~1,5 timer)';
$string['sitesize_4'] = 'XL (~10GB; 1065 kurs, opprettet på ~5 timer)';
$string['sitesize_5'] = 'XXL (~20GB; 4177 kurs, opprettet på ~10 timer)';
$string['size'] = 'Størrelse på kurset';
$string['smallfiles'] = 'Små filer';
$string['targetcourse'] = 'Test målkurset';
$string['testplanexplanation'] = 'Dette verktøyet oppretter en JMeter testplan-fil sammen med brukerens legimitasjonsfil.
Denne testplanen er designet til å fungere sammen med {$a}, som gjør det lettere å kjøre testplanen i et bestemt Moodle-miljø. Den samler informasjon om kjøringen og sammenligner resultatene, så du vil trenge å laste den ned og bruke dets test_runner.sh skript eller følge instruksjonene for installasjon og bruk.

Du vil ha behov for å angi et passord for kursbrukerne i config.php (F.eks. $CFG->tool_generator_users_password = \'moodle\';). Det finnes ingen standardverdi for dette passordet for å forhindre uønsket bruk av verktøyet. Du må oppdatere passordvalget i de tilfeller dine kursbrukere har andre passord eller de er generert av tool_generator, men uten å angi en $CFG->tool_generator_users_password verdien.

Dette er en del av tool_generator-verktøyet, så den fungerer godt med kurs som er generert av kurs- og portalgeneratorer. Den kan også brukes med alle kurs som minst inneholder:
* Nok påmeldte brukere (avhenger av den testplanen du velger) med passordet resatt til "moodle".
* En instans av side-modulen
* En instans av forum-modulen med minst en diskusjon og ett svar.

Du vil kanskje overveie om serverkapasiteten er tilstrekkelig til å kjøre en omfattende testplan, siden JMeter-genererte testplaner kan bli virkelig store. Oppkjøringsperioden er justert i henhold til antall tråder (brukere) for å redusere slike av tilfeller, men lasten er fortsatt enorm.

**Ikke kjør denne testplanen på et produksjonssystem!** Dette verktøyet oppretter kun filer for å belaste JMeter, så det er ikke farlig på noen måte, men du skal **ALDRI** kjøre denne testplanen på et produksjonssystem.';
$string['testplansize_0'] = 'XS ({$a->users} brukere, {$a->loops} looper og {$a->rampup} rampup perioder)';
$string['testplansize_1'] = 'S ({$a->users} brukere, {$a->loops} looper og {$a->rampup} rampup perioder)';
$string['testplansize_2'] = 'M ({$a->users} brukere, {$a->loops} looper og {$a->rampup} rampup perioder)';
$string['testplansize_3'] = 'L ({$a->users} brukere, {$a->loops} looper og {$a->rampup} rampup perioder)';
$string['testplansize_4'] = 'XL ({$a->users} brukere, {$a->loops} looper og {$a->rampup} rampup perioder)';
$string['testplansize_5'] = 'XXL ({$a->users} brukere, {$a->loops} looper og {$a->rampup} rampup perioder)';
$string['updateuserspassword'] = 'Oppdatér kursbrukernes passord';
$string['updateuserspassword_help'] = 'JMeter har behov for å logge inn som kursbrukere, og du kan angi brukernes passord ved å bruke $CFG->tool_generator_users_password i config.php; denne innstillingen oppdaterer brukernes passord til å samsvare med passordet du setter i $CFG->tool_generator_users_password. Det kan være nyttig i de tilfeller hvor du bruker et kurs som ikke er generert av tool_generator eller hvor $CFG->tool_generator_users_password ikke ble satt da du opprettet testkurs.';
