<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'no', version '3.9'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Den angitte adminmappen er feil';
$string['admindirname'] = 'Adminmappe';
$string['admindirsetting'] = 'Noen få webservere bruker /admin som en spesiell URL for at du skal få tak i kontrollpanel eller lignende. Uheldigvis er dette i konflikt med standardplasseringen for Moodle\'s adminsider. Du kan ordne dette ved å gi adminkatalogen nytt navn i installasjonen din, og skrive det nye navnet her. For eksempel <br /> <br /><b>moodleadmin</b><br /> <br />
Dette vil ordne adminlenkene i Moodle.';
$string['admindirsettinghead'] = 'Setter adminmappen';
$string['admindirsettingsub'] = 'Noen få webservere bruker /admin som en spesiell URL for at du skal få tak i kontrollpanel eller lignende. Uheldigvis er dette i konflikt med standardplasseringen for Moodle\'s adminsider. Du kan ordne dette ved å gi adminkatalogen nytt navn i installasjonen din, og skrive det nye navnet her. For eksempel <br /> <br /><b>moodleadmin</b><br /> <br />
Dette vil ordne adminlenkene i Moodle.';
$string['availablelangs'] = 'Tilgjengelige språkpakker';
$string['caution'] = 'Varsel';
$string['chooselanguage'] = 'Velg et språk';
$string['chooselanguagehead'] = 'Velg et språk';
$string['chooselanguagesub'] = 'Velg et språk for installasjonen. Dette språket vil også bli brukt som standardspråk for portalen, men det kan endres senere.';
$string['cliadminemail'] = 'Ny epostadresse for portaladministrator';
$string['cliadminpassword'] = 'Nytt adminbrukerpassord';
$string['cliadminusername'] = 'Adminkonto brukernavn';
$string['clialreadyconfigured'] = 'Konfigurasjonsfilen config.php finnes allerede. Vennligst bruk admin/cli/install_database.php hvis du vil installere Moodle på denne portalen.';
$string['clialreadyinstalled'] = 'Filen config.php eksisterer allerede. Vennligst bruk admin/cli/install_database.php hvis du vil oppgradere Moodle på denne portalen.';
$string['cliinstallfinished'] = 'Installasjonen fullført feilfritt';
$string['cliinstallheader'] = 'Moodle {$a} kommandolinje installasjonsprogram';
$string['climustagreelicense'] = 'I ikke-interaktivt modus må du godta lisensensen ved å angi --agree-license valget';
$string['cliskipdatabase'] = 'Hopper over databaseinstallasjon.';
$string['clitablesexist'] = 'Databasetabeller finnes allerede, CLI installasjon kan ikke fortsette.';
$string['compatibilitysettings'] = 'Sjekker PHP innstillingene dine...';
$string['compatibilitysettingshead'] = 'Sjekker PHP innstillinge dine...';
$string['compatibilitysettingssub'] = 'Serveren din må tilfredsstille alle disse testene for å kjøre Moodle orntlig.';
$string['configfilenotwritten'] = 'Installerinsprogrammet var ikke i stand til å lage config.php med dine valgte innstillinger automatisk, antakelig fordi det ikke er tilgang til å skrive i Moodle-mappen. Du kan manuelt kopiere følgende kode i en fil som du kaller config.php i rot-mappen i Moodle.';
$string['configfilewritten'] = 'config.php er opprett uten feil';
$string['configurationcomplete'] = 'Konfigurasjonen er ferdig';
$string['configurationcompletehead'] = 'Konfigurasjonen er ferdig';
$string['configurationcompletesub'] = 'Moodle gjorde et forsøk på å lagre konfigurasjonen din i en fil i roten av Moodle-installasjonen din';
$string['database'] = 'Database';
$string['databasehead'] = 'Database innstillinger';
$string['databasehost'] = 'Databasevert';
$string['databasename'] = 'Databasenavn';
$string['databasepass'] = 'Databasepassord';
$string['databaseport'] = 'Databaseport';
$string['databasesocket'] = 'Unix socket';
$string['databasetypehead'] = 'Velg databasedriver';
$string['databasetypesub'] = 'Moodle støtter flere typer databaseservere. Vær vennlig å kontakt serveradministratoren din hvis du ikke vet hvilken type du skal bruke';
$string['databaseuser'] = 'Databasebruker';
$string['dataroot'] = 'Dataområde';
$string['datarooterror'] = 'Dataområdet du oppga ble ikke funnet eller opprettet. Vennligst rett stien eller opprett mappen manuelt.';
$string['datarootpermission'] = 'Tillatelse for datakatalog';
$string['datarootpublicerror'] = 'Dataområdet du oppga er direkte tilgjengelig via web. Du må velge en annen mappe!';
$string['dbconnectionerror'] = 'Fikk ingen forbindelse til databasen du oppga. Vennligst sjekk database-innstillingene dine.';
$string['dbcreationerror'] = 'Feil under opprettelse av database. Kunne ikke opprette gitte databasenavn med oppgitte innstillinger';
$string['dbhost'] = 'Vertstjener';
$string['dbpass'] = 'Passord';
$string['dbport'] = 'Port';
$string['dbprefix'] = 'Tabellprefix';
$string['dbtype'] = 'Type';
$string['directorysettings'] = '<p>Vennligst bekreft lokasjonen for denne Moodle-installsjonen.</p>
<p><b>Web Addresse:</b>
Angi full webadresse for hvor Moodle vil være tilgjengelig.
Hvis portalen er tilgjengelig via flere URL\'er velg den det er mest naturlig at studentene vil bruke. Ikke bruke etterfølgende skråstrek.</p>
<p><b>Moodle Mappe:</b>
Oppgi full mappesti til installasjonen. Pass på at små/store bokstaver stemmer.</p>
<p><b>Data Mappe:</b>
Du trenger et sted hvor moodle kan lagre opplastede filer. Denne katalogen bør være lesbar OG SKRIVBAR av webserverbrukeren (vanligvis \'ingen\' eller \'apache\'), men det må IKKE være tilgjengelig direkte fra webben . Administrator må opprette mappen hvis den ikke eksisterer.</p>';
$string['directorysettingshead'] = 'Vennligst bekreft lokasjonen for denne Moodle-installsjonen';
$string['directorysettingssub'] = '<b>Web Addresse:</b>
Angi full webadresse for hvor Moodle vil være tilgjengelig.
Hvis nettstedet er tilgjengelig via flere URL\'er velg den det er mest naturlig at studentene vil bruke. Ikke bruke etterfølgende skråstrek.<br /><br />
<b>Moodle Mappe:</b>
Oppgi full mappesti til installasjonen. Pass på at små/store bokstaver stemmer.<br /><br />
<b>Data Mappe:</b>
Du trenger et sted hvor moodle kan lagre opplastede filer. Denne katalogen bør være lesbar OG SKRIVBAR av webserverbrukeren (vanligvis \'ingen\' eller \'apache\'), men det må IKKE være tilgjengelig direkte fra webben .Administrator må opprette mappen hvis den ikke eksisterer.';
$string['dirroot'] = 'Moodles filområde';
$string['dirrooterror'] = 'Innstillingen for Moodles filområde ser ut til å være feil - vi kan ikke finne noen Moodle installasjon der. Verdien under har blitt nullstillt.';
$string['download'] = 'Last ned';
$string['downloadlanguagebutton'] = 'Last ned &quot;{$a}&quot; språkpakken';
$string['downloadlanguagehead'] = 'Last ned språkpakke';
$string['downloadlanguagenotneeded'] = 'Du kan fortsette installasjonsprosessen med gjeldende språkpakke, "{$a}".';
$string['downloadlanguagesub'] = 'Du har nå valget mellom å laste ned en språkpakke og fortsette installasjonsprosessen med dette språket.<br /><br />Hvis du ikke får til å laste ned språkpakken, vil installasjonsprosessen fortsette på Engelsk. (Med en gang installasjonen er ferdig, vil du ha muligheten til å laste ned og installere flere språkpakker).';
$string['doyouagree'] = 'Er du enig (ja/nei)';
$string['environmenthead'] = 'Sjekker "omgivelsene" dine...';
$string['environmentsub'] = 'Vi sjekker om forskjellige komponenter i systemet ditt tilfredsstiller systemkravene.';
$string['environmentsub2'] = 'Hver Moodle-utgivelse har minimumskrav til PHP versjon og et sett med obligatoriske PHP-tillegg. En full sjekk av omgivelser gjøres før hver installering og oppgradering. Vær vennlig å kontakte serveradministrator hvis du ikke vet hvordan du skal installere nye versjoner eller slå på PHP-tillegg.';
$string['errorsinenvironment'] = 'Omgivelseskontroll feilet!';
$string['fail'] = 'Feilet';
$string['fileuploads'] = 'Filopplastinger';
$string['fileuploadserror'] = 'Denne skulle finnes på';
$string['fileuploadshelp'] = '<p>Filopplasting ser ut til å være slått av på serveren din.</p>
<p>Moodle kan fortsatt installeres, men uten denne muligheten vil du ikke kunne laste opp kursfiler eller nye profilbilder.</p>
<p>For å slå på filopplasting må du (eller systemadministratoren) redigere php.ini fila på  systemet ditt og endre innstillingene for <b>file_uploads</b> til \'1\'.</p>';
$string['inputdatadirectory'] = 'Datakatalog:';
$string['inputwebadress'] = 'Webadresse:';
$string['inputwebdirectory'] = 'Moodlekatalog:';
$string['installation'] = 'Installasjon';
$string['invaliddbprefix'] = 'Ugyldig prefiks. Prefikset kan bare bestå av små bokstaver og understrek.';
$string['langdownloaderror'] = 'Beklageligvis kunne ikke språkpakken "{$a}" lastes ned. Installasjonsprosessen vil fortsette på Engelsk.';
$string['langdownloadok'] = 'Installasjonen av språket "{$a}" var vellykket. Installasjonen vil nå fortsette på dette språket.';
$string['memorylimit'] = 'Minnegrense';
$string['memorylimiterror'] = 'Minnegrensen for PHP er satt for lavt... du kan få problemer med dette senere.';
$string['memorylimithelp'] = '<p>PHP minnegrensen for serveren din er nå satt til {$a}.</p>
<p>Dette kan skape minneproblemer for Moodle senere, spesielt hvis du har mange moduler tillatt og/eller mange brukere.</p>
<p>Vi anbefaler at du konfigurer PHP med en høyere grense enn mulig, for eksepmel 40M. Det er flere måter å gjøre dette på.:</p>
<ol>
<li>Hvis du har muligheten, rekompiler PHP med<i>--enable-memory-limit</i>.
Dette vil tillate Moodle å sette minnegrensen selv.</li>
<li>Hvis du har tilgang til php.ini fila di, kan du endre <b>memory_limit</b> innstillinga der til omtrent 40M. Hvis du ikke har tilgang kan du be administrator gjøre dette for deg.</li>
<li>På noen PHP-servere kan du lage en .htaccess fil i Moodlemappen som inneholder denne linjen:
<p><blockquote>php_value memory_limit 40M</blockquote></p>
    <p>Uansett, på noen servere kan dette forhindre <b>alle</b> PHP sider fra å virke (du vil se feilmeldinger når du ser på sider) og da må du fjerne .htaccess fila.</p></li>
</ol>';
$string['mysqliextensionisnotpresentinphp'] = 'PHP er ikke ordentlig innstilt med MySQLi tillegget slik at den kan kommunisere med MySQL. Sjekk php.ini fila di eller rekompiler PHP.';
$string['nativeauroramysql'] = 'Aurora MySQL (native/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>Databasen er der de fleste av Moodle-innstillingene og dataene er lagret og må konfigureres her. </p><p> Databasens navn, brukernavn og passord er obligatoriske felt; tabellprefiks er valgfritt. </p><p> Databasens navn kan bare inneholde alfanumeriske tegn, dollar ($) og understrek (_).</p><p> Hvis databasen foreløpig ikke eksisterer, og brukeren du oppgir har tillatelse, vil Moodle prøve å opprette en ny database med riktige tillatelser og innstillinger. </p><p>Denne driveren er ikke kompatibel med eldre MyISAM-motor.</p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>Databasen er der hvor de fleste av Moodles innstillinger og data blir lagret og den må konfigureres her.</p>
<p>Databasenavnet, brukernavn og passord er de påkrevde feltene; tabellprefiks er valgfritt</p>
<p>Databasenavnet kan kun inneholde alfanumeriske tegn, dollarsymbol ($)og understrek (_).</p>
<p>Dersom databasen ikke eksisterer og brukeren du spesifiserer har tilatelsen vil Moodle forsøke å opprette en ny database med de korrekte tillatelsene og innstillingen.</p>
<p>Denne driveren er ikke kompatibel med MylSAM-motoren.</p>';
$string['nativemysqli'] = 'Forbedret MySQL (native/mysqli)';
$string['nativemysqlihelp'] = '<p>Databasen er der hvor de fleste av Moodles innstillinger og data blir lagret og den må konfigureres her.</p>
<p>Databasenavnet, brukernavn og passord er de påkrevde feltene; tabellprefiks er valgfritt</p>
<p>Databasenavnet kan kun inneholde alfanumeriske tegn, dollarsymbol ($)og understrek (_).</p>
<p>Dersom databasen ikke eksisterer og brukeren du spesifiserer har tilatelsen vil Moodle forsøke å opprette en ny database med de korrekte tillatelsene og innstillingen.</p>';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Nå må du konfigurere databasen hvor flesteparten av Moodledataene vil lagres. Denne databasen må ha blitt laget og du trenger et brukernavn og passord for å få tilgang til den. Tabell-prefiks er obligatisk.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>Databasen er der hvor de fleste av Moodles innstillinger og data blir lagret og den må konfigureres her.</p>
<p>Databasenavnet, brukernavn og passord er de påkrevde feltene; tabellprefiks er valgfritt.</p>
<p>Databasen må allerede eksistere og brukeren må ha både lese- og skrivetilgang til den.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Nå skal du sette opp databasen hvor det meste av Moodledataene blir lagret. Denne databasen må allerede være opprettet med brukernavn og passord. Tabellprefiks er obligatorisk.';
$string['nativesqlsrvnodriver'] = 'Microsoft Drivers for SQL Server for PHP er ikke installert eller konfigurert ordentlig.';
$string['ociextensionisnotpresentinphp'] = 'PHP har ikke blitt ordentlig konfigurert med OCI8 tillegget slik at den kan kommunisere med Oracle. Vær vennlig å sjekk php.ini fila di eller rekompiler PHP.';
$string['pass'] = 'Godkjent';
$string['paths'] = 'Stier';
$string['pathserrcreatedataroot'] = 'Datakatalogen ({$a->dataroot}) kan ikke opprettes av installasjonsprogrammet.';
$string['pathshead'] = 'Bekreft stier';
$string['pathsrodataroot'] = 'Dataroot katalog er ikke skrivbar.';
$string['pathsroparentdataroot'] = 'Overordnet katalog ({$a->parent}) er ikke skrivbar. Datakatalogen ({$a->dataroot}) kan ikke opprettes av installasjonsprogrammet.';
$string['pathssubadmindir'] = 'Noen ganske få webhoteller bruker  /admin som en egen url for å få tilgang til et kontrollpanel. Dessverre kommer det i konflikt med standard lokalisering av Moodle sine admin-sider. Du kan fikse dette ved å endre navn på admin-mappen og deretter oppgi dette navnet her. F.eks. <em>moodleadmin</em>.  Dette vil fikse adminlenkene i Moodle.';
$string['pathssubdataroot'] = '<p>Du trenger et sted hvor Moodle kan lagre opplastede filer. </p>
<p>Denne mappen må være med lese og skriverettigheter for webserver-brukeren (veldig ofte \'nobody\' eller \'apache\'), men denne mappen må IKKE være direkte tilgjengelig via web.</p>
<p> Installasjonsprogrammet vil forsøke å opprette den om den ikke finnes fra før.</p>';
$string['pathssubdirroot'] = '<p>Full mappesti til moodleinstallasjonen.</p>';
$string['pathssubwwwroot'] = '<p>Full webadresse til der hvor Moodle skal vises, altså den addressen som brukere skriver inn i adresselinjen i nettlseren sin.</p>
<p>Det er ikke mulig å bruke Moodle med mer enn en adresse. Dersom portalen din har flere webadresser bør du oppgi den enkleste av de her, og bruke videresending for  hver av de andre adressene.</p>
<p>Dersom portalen din er tilgjengelig både fra intranett og internett, skal du oppgi den offentlige internettadressen her og sette opp DNS slik at intranettbrukerne også benytter denne offisielle adressen.</p>
<p>Dersom adressen ikke er korrekt, vennligst endre URL i nettleseren slik at at installasjonen restartes med andre verdier.</p>';
$string['pathsunsecuredataroot'] = 'Dataroot plassering er ikke sikker';
$string['pathswrongadmindir'] = 'Adminkatalog finnes ikke';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP har ikke blitt ordentlig konfigurert med PGSQL tillegget slik at den kan kommunisere med PostgreSQL. Vær vennlig å sjekk php.ini fila di eller rekompiler PHP.';
$string['phpextension'] = '{$a} PHP-tillegg';
$string['phpversion'] = 'PHP versjon';
$string['phpversionhelp'] = '<p>Moodle trenger en PHP versjon minst 5.6.5 eller 7.1.0 (7.0.x har noen begrensninger).</p>
<Du kjører nå versjon {$a}</p>
<p>Du må oppgradere PHP eller flytte til en server med en nyere versjon av PHP!</p>';
$string['releasenoteslink'] = 'For informasjon om denne versjonen av Moodle, vær vennlig å se utgivelsesmerknadene på {$a}';
$string['safemode'] = 'Sikkermodus';
$string['safemodeerror'] = 'Moodle kan ha trøbbel når sikkermodus er på';
$string['safemodehelp'] = '<p>Moodle kan oppleve en rekke problemer med sikkermodus på, ikke minst det at man sannsynligvis ikke har mulighet til å opprette nye filer.</p>
<P>Sikkermodus er vanligvis bare slått på på paranoide offentlige webtjenere, så det kan hende du må finne en ny webtilbyder for Moodle-siden din.</p>
<p>Du kan fortsette installasjonen hvis du ønsker, men det er mulig at du får en del problemer senere.</p>';
$string['sessionautostart'] = 'Autostart sesjon';
$string['sessionautostarterror'] = 'Denne bør være av';
$string['sessionautostarthelp'] = '<P>Moodle trenger sesjonsupport og vil ikke virke uten.</p>
<p>Sesjoner kan slås på i php.ini fila se etter session.auto_start variabelen.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP har ikke blitt ordentlig satt opp med SQLite-tillegget. Vær vennlig å sjekk php.ini-fila di eller rekompiler PHP.';
$string['upgradingqtypeplugin'] = 'Oppgraderer spørsmål/modultype';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Du ser denne siden fordi du nå har fullført installeringen og kjøringen av pakken <strong>{$a->packname} {$a->packversion}</strong> på datamaskinen din. Gratulerer!';
$string['welcomep30'] = 'Denne versjonen av <strong>{$a->installername}</strong> inneholder programmer for å lage et miljø som <strong>Moodle</strong> jobber i, nemlig:';
$string['welcomep40'] = 'Denne pakken inkluderer også  <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Bruken av alle applikasjoner i denne pakken er administrert av egne lisenser. Hele <strong>{$a->installername}</strong>-pakken er <a href="http://www.opensource.org/docs/definition_plain.html">
åpen kildekode</a> og er distribuert under  <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a>-lisensen.';
$string['welcomep60'] = 'De følgende sidene vil vise deg gjennom noen enkle steg for å konfigurere og sette opp <strong>Moodle</strong> på datamaskinen din. Du kan godta standardinnstillingene, eller justere dem etter egne behov hvis du vil.';
$string['welcomep70'] = 'Klikk på "Neste" knappen under for å fortsette med <strong>Moodle</strong>-installasjonen';
$string['wwwroot'] = 'Web addresse';
$string['wwwrooterror'] = 'Webadressen synes ikke å være gyldig - denne Moodleinstallasjonen synes ikke å være der. Innstilling har blitt resatt.';
