<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'no', version '3.9'.
 *
 * @package     data
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Handling';
$string['add'] = 'Legg til post';
$string['addcomment'] = 'Legg til kommentar';
$string['addentries'] = 'Legg til poster';
$string['addtemplate'] = 'Mal: Legg til post';
$string['advancedsearch'] = 'Avansert søk';
$string['allowcomments'] = 'Tillat kommentarer til oppføringer';
$string['alttext'] = 'Alternativ tekst';
$string['approvalstatus'] = 'Godkjenningsstatus';
$string['approve'] = 'Godkjenn';
$string['approved'] = 'Godkjent';
$string['areacontent'] = 'Felter';
$string['ascending'] = 'Stigende';
$string['asearchtemplate'] = 'Mal: Avansert søk';
$string['atmaxentry'] = 'Du har lagt inn det maksimale antall oppføringer som er tillatt!';
$string['authorfirstname'] = 'Forfatterens fornavn';
$string['authorlastname'] = 'Forfatterens etternavn';
$string['autogenallforms'] = 'Generer alle standardmaler';
$string['autolinkurl'] = 'Lag automatisk lenke til URL';
$string['availablefromdate'] = 'Tilgjengelig fra';
$string['availabletags'] = 'Tilgjengelige mer';
$string['availabletags_help'] = '<p>Tagger er plassholder i malen og blir skiftet ut med felter eller andre elementer, som et redigeringsikon, når oppføringer blir redigert eller vist.</p>
<p>Felter har formatet [[fieldname]]. Alle andre tagger har formatet  ##sometag##.</p>
<p>Bare tagger som er listet opp under "Tilgjengelige tagger" kan brukes for gjeldende mal.</p>';
$string['availabletodate'] = 'Tilgjengelig til';
$string['availabletodatevalidation'] = 'Datoen for "Tilgjenglig til" kan ikke være før datoen for "Tilgjengelig etter"';
$string['blank'] = 'Blank';
$string['buttons'] = 'Knapper';
$string['bynameondate'] = 'ved {$a->name} - {$a->date}';
$string['calendarend'] = '{$a} stenger';
$string['calendarstart'] = '{$a} åpner';
$string['cancel'] = 'Avbryt';
$string['cannotaccesspresentsother'] = 'Du har ikke tilgang til forhåndsinnstillinger fra andre brukere';
$string['cannotadd'] = 'Kan ikke legge til oppføringer!';
$string['cannotdeletepreset'] = 'Feil ved sletting av en forhåndsinnstilling!';
$string['cannotoverwritepreset'] = 'Kunne ikke overskrive forhåndsinnstillingen';
$string['cannotunziptopreset'] = 'Kan ikke pakke ut forvalgt mappe';
$string['checkbox'] = 'Valgboks';
$string['chooseexportfields'] = 'Velg feltene du ønsker å eksportere';
$string['chooseexportformat'] = 'Velg formatet du ønsker å eksportere til:';
$string['chooseorupload'] = 'Velg fil';
$string['closebeforeopen'] = 'Du har spesifisert en sluttdato som kommer før startdatoen.';
$string['columns'] = 'Kolonner';
$string['comment'] = 'Kommentar';
$string['commentdeleted'] = 'Kommentaren er slettet';
$string['commentempty'] = 'Kommentaren var tom';
$string['comments'] = 'Kommentarer';
$string['commentsaved'] = 'Kommentaren lagret';
$string['commentsn'] = '{$a} kommentar(er)';
$string['commentsoff'] = 'Kommentarfunksjonen er ikke aktivert';
$string['completionentries'] = 'Krev oppføringer';
$string['completionentriescount'] = 'Antall oppføringer';
$string['completionentriesdesc'] = 'Minste antall oppføringer som kreves: {$a}';
$string['configenablerssfeeds'] = 'Denne bryteren vil aktivere RSS nyhetsagenter for alle databaser. Du må likevel fortsatt slå på RSS i hver enkelt database.';
$string['confirmdeletefield'] = 'Du er i ferd med å slette dette feltet. Er du helt sikker?';
$string['confirmdeleterecord'] = 'Er du sikker på at du vil slette denne oppføringen?';
$string['confirmdeleterecords'] = 'Er du sikker på at du ønsker å slette disse oppføringene?';
$string['csstemplate'] = 'Mal: CSS';
$string['csvfailed'] = 'Ikke mulig å lese data fra CSV-fila';
$string['csvfile'] = 'CSV-fil';
$string['csvimport'] = 'CSV-import';
$string['csvimport_help'] = '<p>CSV betyr Comma-Separated-Values og er et vanlig format for utveksling av data.</p>

<p>Det forventede filformater er ren tekst med en liste over feltnavn som første linje. Deretter følger dataene, med en post pr. linje.
</p>

<p>Feltskilletegnet er som vanligvis bokstaven (,) -KOMMA-  og felthaker er ikke satt som standard. (Felthaker er tegn som legges til før og etter innholdet i hvert felt).</p>

<p>Hver post skal skilles fra hverandre med et linjeskift (RETUR eller ENTER-tasten i din editor). Tabulatorer kan spesifiseres ved å bruke t og nye linjer med n.
</p>

<p>Eksempelfil:</p>

<pre>
  name,height,weight
  Kai,180cm,80kg
  Kim,170cm,60kg
  Koo,190cm,20kg
</pre>

<p>Advarsel: Noen felttyper er ikke støttet .</p>';
$string['csvwithselecteddelimiter'] = '<abbr title="Kommaseparerte verdier">CSV</abbr>';
$string['data:addinstance'] = 'Legg til en ny database';
$string['data:approve'] = 'Godkjenn eller underkjenn tidligere godkjente oppføringer,';
$string['data:comment'] = 'Skriv kommentarer';
$string['data:exportallentries'] = 'Eksporter alle databaseoppføringene';
$string['data:exportentry'] = 'Eksporter en databaseoppføring';
$string['data:exportownentry'] = 'Eksport egen databaseoppføring';
$string['data:exportuserinfo'] = 'Eksporter brukerinformasjon';
$string['data:managecomments'] = 'Administrer kommentarer';
$string['data:manageentries'] = 'Administrere oppføringer';
$string['data:managetemplates'] = 'Administrere maler';
$string['data:manageuserpresets'] = 'Administrere felles malinnstillinger';
$string['data:rate'] = 'Bedøm oppføringer';
$string['data:readentry'] = 'Les oppføringer';
$string['data:view'] = 'Vis databaseaktivitet';
$string['data:viewallratings'] = 'Vis alle bedømminger gitt av enkeltpersoner';
$string['data:viewalluserpresets'] = 'Vis forhåndsinnstillinger for alle brukere';
$string['data:viewanyrating'] = 'Vis alle bedømminger noen har mottatt';
$string['data:viewentry'] = 'Vis oppføringer';
$string['data:viewrating'] = 'Vis vurderinger';
$string['data:writeentry'] = 'Skriv oppføringer';
$string['date'] = 'Dato';
$string['dateentered'] = 'Dato lagt til';
$string['defaultfielddelimiter'] = '( komma-tegnet er standard)';
$string['defaultfieldenclosure'] = '("Ingen" er standard)';
$string['defaultsortfield'] = 'Standard sorteringsfelt';
$string['delcheck'] = 'Slett alle';
$string['delete'] = 'Slett';
$string['deleteallentries'] = 'Slett alle oppføringer';
$string['deletecomment'] = 'Er du sikker på at du vil slette denne kommentaren?';
$string['deleted'] = 'slettet';
$string['deletefield'] = 'Slett et eksisterende felt';
$string['deletenotenrolled'] = 'Slett oppføringer gjort av brukere som ikke er påmeldt';
$string['deletewarning'] = 'Er du sikker på at du vil slette denne forhåndsinnstillingen?';
$string['descending'] = 'Synkende';
$string['directorynotapreset'] = '{$a->directory} Ingen forhåndsinnstilling: Mangler filene: {$a->missing_files}';
$string['disapprove'] = 'Angre godkjenningen';
$string['download'] = 'Last ned';
$string['edit'] = 'Endre';
$string['editcomment'] = 'Endre kommentar';
$string['editentry'] = 'Endre oppføring';
$string['editordisable'] = 'Slå av  editor';
$string['editorenable'] = 'Aktivere editor';
$string['emptyadd'] = 'Malen for "Legg til post" er tom, genererer et standard skjema...';
$string['emptyaddform'] = 'Du har ikke fylt ut noen felter!';
$string['enabletemplateeditorcheck'] = 'Er du sikker på at du ønsker å aktivere editoren?. Dette kan føre til at innholdet endres når malen blir lagret.';
$string['entries'] = 'Oppføringer';
$string['entrieslefttoadd'] = 'Du må legge til  {$a->entriesleft} flere oppføringer før du kan fullføre denne aktiviteten.';
$string['entrieslefttoaddtoview'] = 'Du må legge til {$a->entrieslefttoview} flere poster/innlegg før du kan se andre deltakeres innlegg.';
$string['entry'] = 'Oppføring';
$string['entrysaved'] = 'Din oppføring er lagret';
$string['errormustbeteacher'] = 'Du må være Lærer for å bruke denne siden!';
$string['errormustsupplyvalue'] = 'Du må skrive inn noe her';
$string['errorpresetexists'] = 'Det finnes allerede en forhåndsinnstilling med dette navnet';
$string['eventfieldcreated'] = 'Felt opprettet';
$string['eventfielddeleted'] = 'Felt slettet';
$string['eventfieldupdated'] = 'Felt oppdatert';
$string['eventrecordcreated'] = 'Dokument opprettet';
$string['eventrecorddeleted'] = 'Dokument slettet';
$string['eventrecordupdated'] = 'Dokument oppdatert';
$string['eventtemplateupdated'] = 'Mal oppdatert';
$string['eventtemplateviewed'] = 'Viste maler';
$string['example'] = 'Eksempel på databasemodul';
$string['excel'] = 'Excel';
$string['expired'] = 'Beklager, denne aktiviteten ble stengt {$a} og er ikke lenger tilgjengelig';
$string['export'] = 'Eksport';
$string['exportaszip'] = 'Eksporter som zip';
$string['exportaszip_help'] = '<p>Dette åpner for at du kan laste ned maler til din egen pc og laste dem opp igjen til en annen database. I en annen database kan maler importeres via Import fra ZIP-fil.</p>';
$string['exportedtozip'] = 'Eksportert til midlertidig zip...';
$string['exportentries'] = 'Eksportoppføringer';
$string['exportformat'] = 'Eksportformat';
$string['exportoptions'] = 'Eksportopsjoner';
$string['exportownentries'] = 'Eksporter bare dine egne oppføringer?  ({$a->mine}/{$a->all})';
$string['failedpresetdelete'] = 'Sletting av forhåndsinnstilling mislykkes!';
$string['fieldadded'] = 'Felter er lagt til';
$string['fieldallowautolink'] = 'Tillat autolenking';
$string['fielddeleted'] = 'Feltet er slettet';
$string['fielddelimiter'] = 'Feltbegrensning';
$string['fielddescription'] = 'Feltbeskrivelse';
$string['fieldenclosure'] = 'Feltavgrensning';
$string['fieldheight'] = 'Høyde';
$string['fieldheightlistview'] = 'Høyde i listevisning';
$string['fieldheightsingleview'] = 'Høyde i enkeltvisning';
$string['fieldids'] = 'FeltID-er';
$string['fieldmappings'] = 'Feltegenskaper';
$string['fieldmappings_help'] = 'Denne menyen lar deg beholde data fra en eksisterende database. For å beholde dataene i et felt må du koble feltet til et annet, slik at dataene vises der. Felt kan også være tomme, uten at det er kopiert inn noe innhold i det. Alle gamle felt som ikke kobles til nye vil gå tapt og dataene slettet.
Du kan bare koble felt av samme type, så hver listeboksmeny vil ha forskjellige felt. Videre må du ikke prøve å koble et gammelt felt mot mer enn ett nytt felt.';
$string['fieldname'] = 'Feltnavn';
$string['fieldnametype'] = '{$a->name} ({$a->type})';
$string['fieldnotmatched'] = 'Følgende felt i filen din finnes ikke i denne databasen: {$a}';
$string['fieldoptions'] = 'Alternativer (en på hver linje)';
$string['fields'] = 'Felter';
$string['fieldupdated'] = 'Feltet er oppdatert';
$string['fieldwidth'] = 'Bredde';
$string['fieldwidthlistview'] = 'Bredde i listevisning';
$string['fieldwidthsingleview'] = 'Bredde i enkeltvisning';
$string['file'] = 'Fil';
$string['fileencoding'] = 'Koding';
$string['filesnotgenerated'] = 'Ikke alle filene ble generert: {$a}';
$string['filtername'] = 'Database autolenking';
$string['footer'] = 'Bunntekst';
$string['forcelinkname'] = 'Obligatorisk lenkenavn';
$string['foundnorecords'] = 'Ingen poster funnet (<a href="{$a->reseturl}">Nullstill filter</a>)';
$string['foundrecords'] = 'Funnet poster: {$a->num}/{$a->max} (<a href="{$a->reseturl}">Nullstill filter</a>)';
$string['fromfile'] = 'Importer fra en zip-fil';
$string['fromfile_help'] = '<p>Bruk denne for å laste opp forhåndsinnstillinger du har lagret på din pc. Forhåndsinnstillingene er laget via Export-funksjonen og lagret som en fil.</p>';
$string['generateerror'] = 'Alle filene ble ikke generert!';
$string['header'] = 'Topptekst';
$string['headeraddtemplate'] = 'Definerer skjermbildet for å legge til eller redigere oppføringer';
$string['headerasearchtemplate'] = 'Definerer skjermbildet for avansert søk';
$string['headercsstemplate'] = 'Definerer lokale CSS-maler for de andre malene';
$string['headerjstemplate'] = 'Definerer egendefinert Javascript for manipulering av hvordan elementer vises for listevisning, enkeltvisning og maler.';
$string['headerlisttemplate'] = 'Definerer flervisningen av oppføringer';
$string['headerrsstemplate'] = 'Definerer visning av oppføringene i RSS-agenter';
$string['headersingletemplate'] = 'Definerer enkeltvisning av oppføringer';
$string['importentries'] = 'Importoppføringer';
$string['importsuccess'] = 'Lagring av forhåndsinnstillingen var vellykket.';
$string['includeapproval'] = 'Inkludér godkjenningsstatus';
$string['includetags'] = 'Inkluder tagger';
$string['includetime'] = 'Inkludér tidspunkt for lagt til/endret';
$string['includeuserdetails'] = 'Inkludér brukerinformasjon';
$string['indicator:cognitivedepth'] = 'Kognitiv database';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på kognitiv dybde vist av studenten i en Database-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Database - kognitivt engasjement';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av databaseaktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen visning, visning, innsending)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sosial database';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på sosial bredde vist av studenten i en Database-aktivitet.';
$string['indicator:socialbreadthdef'] = '- Database sosial engasjement';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av databaseaktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen deltakelse, deltaker alene)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insufficiententries'] = 'det trengs flere oppføringer for å vise denne databasen';
$string['intro'] = 'Beskrivelse';
$string['invalidaccess'] = 'Denne siden ble ikke åpnet korrekt';
$string['invalidfieldid'] = 'Felt ID-en er feil';
$string['invalidfieldname'] = 'Vennligst velg et annet navn for dette feltet';
$string['invalidfieldtype'] = 'Felttypen er feil';
$string['invalidid'] = 'Feil data ID';
$string['invalidpreset'] = '{$a} er ingen forhåndsinnstilling.';
$string['invalidrecord'] = 'Feil i oppføringen';
$string['invalidurl'] = 'URL-en du skrev inn var ugyldig';
$string['jstemplate'] = 'Mal: Javascript';
$string['latitude'] = 'Lengde';
$string['latlong'] = 'Lengde/bredde';
$string['latlongboth'] = 'Både lengdegrad og breddegrad må oppgis';
$string['latlongdownloadallhint'] = 'Last ned lenke for alle oppføringer som KML';
$string['latlongkmllabelling'] = 'Hvordan navne elementer i KML-filer (Google Earh)';
$string['latlonglinkservicesdisplayed'] = 'Lenker-ut som kan vises';
$string['latlongotherfields'] = 'Andre felt';
$string['list'] = 'Vis liste';
$string['listtemplate'] = 'Mal: Listevisning';
$string['longitude'] = 'Bredde';
$string['manageapproved'] = 'Tillat redigering av godkjente påmeldiner';
$string['manageapproved_help'] = 'Hvis deaktivert, kan ikke brukeren endre eller slette påmeldingen sin. Denne innstillingen gjelder bare når "Krev godkjenning" er satt til Ja.';
$string['mapexistingfield'] = 'Koble til {$a}';
$string['mapnewfield'] = 'Opprett et nytt felt';
$string['mappingwarning'] = 'Alle gamle felt som ikke er mappet til et nytt vil gå tapt og alle data i feltet vil bli slettet.';
$string['maxentries'] = 'Maks antall oppføringer';
$string['maxentries_help'] = '<p>Maks antall oppføringer en deltaker kan legge inn for denne aktiviteten.</p>';
$string['maxsize'] = 'Maks størrelse';
$string['menu'] = 'Meny';
$string['menuchoose'] = 'Velg...';
$string['missingdata'] = 'Data ID eller objekt må ha feltklasser';
$string['missingfield'] = 'Programmeringsfeil: Du må angi felt og/eller data som definberer feltklasser.';
$string['modulename'] = 'Database';
$string['modulename_help'] = 'Databaseaktiviteten lar brukerne opprette, vedlikeholde og søke i en database. Formatet på oppføringene i databasen defineres av læreren som en rekke felter. Felttypene kan bl.a. være avmerkingsbokser,  radioknapper, nedtrekksmenyer, tekstområder, URL-er, bilder og opplastede filer.

Det visuelle oppsettet av informasjonen når du lister opp, viser eller redigerer databaseoppføringene kan kontrolleres av maler. Databaseaktivitetene kan deles mellom kurs, og læreren kan også importere og eksportere databaseoppføringer.

Hvis auto-linking-filteret i databasen er aktivert, vil alle oppføringene i databasen automatisk lenkes der hvor ordene eller uttrykkene kommer opp i kurset.

Læreren kan tillate kommentarer på oppføringer. Oppføringene kan også graderes av lærere eller studenter. Graderinger kan legges sammen til en endelig karakter som kan registreres i karakterboken.

Databaseaktiviteter har mange bruksområder, bl. a.

* Et samarbeid om å samle lenker, bøker, bokanmeldelser, referanser til tidsskrift, osv.
* For å vise bilder, plakater, nettsteder og dikt som studenter har laget på en plass der medstudenter kan kommentere og vurdere dem.';
$string['modulename_link'] = 'mod/data/view';
$string['modulenameplural'] = 'Databaser';
$string['more'] = 'Mer';
$string['moreurl'] = 'Mer URL';
$string['movezipfailed'] = 'Kan ikke flytte zip';
$string['multientry'] = 'Gjentatt oppføring';
$string['multimenu'] = 'Meny (flervalg)';
$string['multipletags'] = 'Overlappende tagger funnet! Malen ble ikke lagret';
$string['newentry'] = 'Ny oppføring';
$string['newfield'] = 'Opprett et nytt felt';
$string['newfield_help'] = 'I dette skjermbildet kan du opprette datafelt i databasen din. Hvert felt tillater forskjellige typer data og de forskjellige typene har egne innstillinger.
Hvert felt må ha et unikt feltnavn. Beskrivelsesfeltet er valgfritt.';
$string['noaccess'] = 'Du har ikke tilgang til denne siden';
$string['nodefinedfields'] = 'Ny forhåndsinnstilling har ingen definerte felter!';
$string['nofieldcontent'] = 'Feltinnholdet ikke funnet';
$string['nofieldindatabase'] = 'Det er ikke definert noen felter i denne databasen.';
$string['nolisttemplate'] = 'Mal for listevisning er ikke definert ennå';
$string['nomatch'] = 'Ingen treff blant oppføringene!';
$string['nomaximum'] = 'Ingen maks';
$string['norecords'] = 'Ingen oppføringer i databasen';
$string['nosingletemplate'] = 'Mal for enkeltvisning er ikke definert ennå';
$string['notapproved'] = 'Oppføringen er ikke godkjent ennå.';
$string['notinjectivemap'] = 'Ingen oppføringsoversikt';
$string['notopenyet'] = 'Beklager, men dette aktiviteten er ikke tilgjengelig før {$a}';
$string['number'] = 'Antall';
$string['numberrssarticles'] = 'Oppføringer i RSS-leseren';
$string['numnotapproved'] = 'Venter';
$string['numrecords'] = '{$a} oppføringer';
$string['ods'] = '<abbr title="OpenDocument Spreadsheet">ODS</abbr>&nbsp;(OpenOffice)';
$string['openafterclose'] = 'Du har spesifisert en startdato som er etter sluttdatoen';
$string['optionaldescription'] = 'Kort beskrivelse (opsjon)';
$string['optionalfilename'] = 'Filnavn (opsjon)';
$string['other'] = 'Andre';
$string['overrwritedesc'] = 'Overskriv forhåndsinnstillngen hvis den finnes fra før';
$string['overwrite'] = 'Overskriv';
$string['overwritesettings'] = 'Overskriv nåværende innstillinger';
$string['page-mod-data-x'] = 'Alle sider i databasemodulen';
$string['pagesize'] = 'Oppføringer pr side';
$string['participants'] = 'Deltakere';
$string['picture'] = 'Bilde';
$string['pleaseaddsome'] = 'Vennligst skriv inn noe under eller <a href="{$a}">velg et forhåndsdefinert sett</a> for å komme i gang.';
$string['pluginadministration'] = 'Administrere aktiviteten Database';
$string['pluginname'] = 'Database';
$string['portfolionotfile'] = 'Eksporter til en portfolio i stedet for en fil (bare csv og leap2)';
$string['presetinfo'] = 'Når du lagrer denne forhåndsinnstillingen vil malen publiseres. Andre brukere kan dermed bruke den i sine databaser.';
$string['presets'] = 'Forhåndsinnstillinger';
$string['privacy:metadata:commentpurpose'] = 'Kommentarer på databaseoppføringer';
$string['privacy:metadata:data_content'] = 'Representerer et svar til et felt i databaseaktivitetsmodulen';
$string['privacy:metadata:data_content:content'] = 'Innhold';
$string['privacy:metadata:data_content:content1'] = 'Tilleggsinnhold 1';
$string['privacy:metadata:data_content:content2'] = 'Tilleggsinnhold 2';
$string['privacy:metadata:data_content:content3'] = 'Tilleggsinnhold 3';
$string['privacy:metadata:data_content:content4'] = 'Tilleggsinnhold 4';
$string['privacy:metadata:data_content:fieldid'] = 'Feltdefinisjon ID';
$string['privacy:metadata:data_records'] = 'Representerer oppføringen i databaseaktivitetsmodulen';
$string['privacy:metadata:data_records:approved'] = 'Godkjenningsstatus';
$string['privacy:metadata:data_records:groupid'] = 'Gruppe';
$string['privacy:metadata:data_records:timecreated'] = 'Når oppføringen ble opprettet';
$string['privacy:metadata:data_records:timemodified'] = 'Når oppføringen sist ble endret';
$string['privacy:metadata:data_records:userid'] = 'Brukeren som opprettet oppføringen';
$string['privacy:metadata:datafieldnpluginsummary'] = 'Felt for databaseaktivitetsmodulen';
$string['privacy:metadata:filepurpose'] = 'Filvedlegg til databaseoppføringen';
$string['privacy:metadata:ratingpurpose'] = 'Vurderinger på databaseoppføringer';
$string['privacy:metadata:tagpurpose'] = 'Tagger på databaseoppføringer';
$string['radiobutton'] = 'Radioknapper';
$string['recordapproved'] = 'Oppføringen er godkjent';
$string['recorddeleted'] = 'Oppføringen er slettet';
$string['recorddisapproved'] = 'Innlegg underkjent';
$string['recordsnotsaved'] = 'Ingen oppføring ble lagret. Vennligst sjekk formatet på filen du lastet opp.';
$string['recordssaved'] = 'oppføringer lagret';
$string['removealldatatags'] = 'Fjern alle databasetagger';
$string['requireapproval'] = 'Godkjenning påkrevd';
$string['requireapproval_help'] = '<p>Skal oppføringer godkjennes av en lærer før de vises andre deltakere? Dette er meget anvendelig når du opplever at nye oppføringer bør sjekkes før de offentliggjøres.</p>';
$string['required'] = 'Påkrevd';
$string['requiredentries'] = 'Oppføringer krevd for å få fullført';
$string['requiredentries_help'] = 'Hvis satt vil antall påkrevde oppføringer for fullføring vises i en melding. Merk at denne innstillingen ikke er forbundet med aktivitetsfullføringsinnstillingene.

For å besteme antall oppføringer som skal kreves for aktivitetsfullføring, bruk innstillingen "Krev oppføringer". For å fjerne denne innstillingen, endre til "Ingen" og lagre endringer. Vennligst bruk "Krev oppføringer"-feltet i aktivitetsfulføringsdelen i stedet.';
$string['requiredentriestoview'] = 'Oppføring kreves før visning';
$string['requiredentriestoview_help'] = '<p>Antall oppføringer en deltaker må bidra med før de får se de andre oppføringene i databasen.</p>
<p>Merk: Denne funksjonen kan ikke kombineres med database-autolenking (et globalt filter), siden det ikke er mulig for autoklenkingsfilteret å avgjøre om en bruker er kvalifisert for å se  innholdet eller ikke.</p>';
$string['requiredentrieswarning'] = 'Denne innstillingen har blitt erstatten med aktivitetsfullføringskravet "Krev oppføringer"';
$string['requiredfield'] = 'Påkrevd felt';
$string['resetsettings'] = 'Nullstill filtre';
$string['resettemplate'] = 'Tilbakestill mal';
$string['resizingimages'] = 'Endrer bildene';
$string['rows'] = 'rekker';
$string['rssglobaldisabled'] = 'Ikke aktivisert. Sjekk innstillingene for portalen.';
$string['rsstemplate'] = 'Mal: RSS';
$string['rsstitletemplate'] = 'RSS tittelmal';
$string['rsstype'] = 'RSS-utsending for denne aktiviteten';
$string['save'] = 'Lagre';
$string['saveandadd'] = 'Lagre og legg til ny';
$string['saveandview'] = 'Lagre og vis';
$string['saveaspreset'] = 'Lagre som forhåndsinnstilling';
$string['saveaspreset_help'] = 'Dette publiserer gjeldende mal som en forhåndsinnstilling som alle på portalen kan benytte. Den vil fremkomme i listen over forhåndsinnstillinger. Du kan slette en forhåndsinnstilling når som helst.</p>';
$string['savesettings'] = 'Lagre innstillinger';
$string['savesuccess'] = 'Lagringen var vellykket. Forhåndsinnstillingen din vil være aktiv i  hele portalen.';
$string['savetemplate'] = 'Lagre mal';
$string['search'] = 'Søk';
$string['search:activity'] = 'Database - aktivitetsinformasjon';
$string['search:entry'] = 'Database - oppføringer';
$string['selectedrequired'] = 'Velg alle er påkrevd';
$string['selectexportoptions'] = 'Velg eksportopsjoner';
$string['selectfields'] = 'Velg felter';
$string['showall'] = 'Vis alle oppføringer';
$string['single'] = 'Enkeltvisning';
$string['singletemplate'] = 'Mal: Enkeltvisning';
$string['subplugintype_datafield'] = 'Felttype i databasen';
$string['subplugintype_datafield_plural'] = 'Felttyper i databasen';
$string['subplugintype_datapreset'] = 'Forhåndsinnstillinger';
$string['subplugintype_datapreset_plural'] = 'Forhåndsinnstillinger';
$string['tagarea_data_records'] = 'Dataoppføringer';
$string['tags'] = 'Tagger';
$string['tagsdeleted'] = 'Databasetagger har blitt slettet';
$string['teachersandstudents'] = '{$a->teachers} og {$a->students}';
$string['templates'] = 'Maler';
$string['templatesaved'] = 'Malen er lagret';
$string['text'] = 'Tekst';
$string['textarea'] = 'Tekstområde';
$string['timeadded'] = 'Tid lagt til';
$string['timemodified'] = 'Tid endret';
$string['todatabase'] = 'til denne databasen.';
$string['type'] = 'Felttype';
$string['undefinedprocessactionmethod'] = 'Det er ikke definert noen metode for å behandlet Data_Preset "{$a}".';
$string['unsupportedexport'] = '({$a->fieldtype}) kan ikke eksporteres.';
$string['unsupportedfields'] = 'Felter som ikke støttes';
$string['unsupportedfieldslist'] = 'Følgende felt kan ikke eksporteres:';
$string['updatefield'] = 'Oppdatér et eksisterende felt';
$string['uploadfile'] = 'Last opp fil';
$string['uploadrecords'] = 'Last opp oppføringer fra en fil';
$string['uploadrecords_help'] = 'Oppføringer kan lastes opp via en tekstfil. Filformatet skal være som følger:

* Hver linje i fila har en oppføring
* Hver oppføring er en serie av kommaseparerte data (eller andre skilletegn)
* Den første oppføringen i fila skal inneholde en liste med alle feltnavnene for oppføringene i fila.

Hvert felt kan avgrenses av et tegn foran og bak hver oppføring. Dette kan normalt utelates.';
$string['uploadrecords_link'] = 'mod/data/import';
$string['url'] = 'URL';
$string['usedate'] = 'Inkludér i søket.';
$string['usestandard'] = 'Bruk en forhåndsinnstilling';
$string['usestandard_help'] = '<p>Bruk en mal som er tilgjengelig for hele portalen.</p>
<p>Og - dersom du har lagt til en forhåndsinnstilling til biblioteket via "Lagre som forhåndsinnstilling". Når den ikke trengs lenger kan du velge å slette den.</p>';
$string['viewfromdate'] = 'Kan vises fra';
$string['viewtodate'] = 'Kan vises til';
$string['viewtodatevalidation'] = 'Datoen "lesbar kun før" kan ikke være før datoen for "lesbar kun etter"';
$string['wrongdataid'] = 'Feil data-id';
