<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'sr_lt', version '3.9'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktivnosti';
$string['addcategory'] = 'Dodaj kategoriju';
$string['addcategoryerror'] = 'Nije moguće dodati kategoriju';
$string['addexceptionerror'] = 'Došlo je do greške tokom dodavanja izuzetka za userid:gradeitem';
$string['addfeedback'] = 'Dodaj povratne informacije';
$string['addgradeletter'] = 'Dodaj slovnu ocenu';
$string['addidnumbers'] = 'Dodaj ID brojeve';
$string['additem'] = 'Dodaj stavku ocene';
$string['additionalfeedback'] = 'Dodatne povratne informacije';
$string['addoutcome'] = 'Dodaj ishod učenja';
$string['addoutcomeitem'] = 'Dodaj stavku ishoda učenja';
$string['addscale'] = 'Dodaj skalu';
$string['adjustedweight'] = 'Ponder prilagođen';
$string['aggregateextracreditmean'] = 'Srednja vrednost ocena (sa dodatnim bodovima)';
$string['aggregatemax'] = 'Najveća ocena';
$string['aggregatemean'] = 'Srednja vrednost ocena';
$string['aggregatemedian'] = 'Medijana ocena';
$string['aggregatemin'] = 'Najniža ocena';
$string['aggregatemode'] = 'Mod ocena (najčešća ocena)';
$string['aggregatenotonlygraded'] = 'Uključi prazne ocene';
$string['aggregateonlygraded'] = 'Isključi prazne ocene';
$string['aggregateonlygraded_help'] = '"Prazna" ocena je ocena koja nedostaje u knjizi ocena. To može biti predati zadatka koji još nije ocenjen ili test koji polaznik još uvek nije pokušao da reši itd.

Ovo podešavanje određuje  da li će ove "prazne" ocene biti uključene u zbirnu ocenu ili će se računati kao minimalna ocena, na primer 0 za zadatak koji se ocenjuje od 0 do 100.';
$string['aggregateoutcomes'] = 'Uključi ishode učenja u sumiranje';
$string['aggregateoutcomes_help'] = 'Ako je ova opcija omogućena, ishodi učenja su uključeni u zbirni rezultat. Ovo može da rezultira neočekivanom ukupnom ocenom za kategoriju.';
$string['aggregatesonly'] = 'Promeni na \'Samo zbirne ocene\'';
$string['aggregatesubcatsupgradedgrades'] = 'Napomena: Podešavanje "Saberi uključujući potkategorije" je uklonjeno kao deo ažuriranja sajta. Budući da je "Saberi uključujući potkategorije" prethodno korišćeno u ovom kursu preporučujemo da pregledate ovu promenu u knjizi ocena.';
$string['aggregatesum'] = 'Prirodno';
$string['aggregateweightedmean'] = 'Ponderisana srednja vrednost ocena';
$string['aggregateweightedmean2'] = 'Prosta ponderisana srednja vrednost ocena';
$string['aggregation'] = 'Sumiranje ocena';
$string['aggregation_help'] = 'Način sumiranja određuje kako se kombinuju ocene u pojedinoj kategoriji, a mogući načini su:

* Srednja vrednost ocena - zbir svih ocena podeljen sa ukupnim brojem ocena
* Medijana ocena - središnja ocena u rasponu od najveće do najmanje ocene
* Najniža ocena
* Najviša ocena
* Mod ocena - ocena koja se najčešće pojavljuje
* Prirodno - zbir svih vrednosti ocena, skaliranih po težini';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Koeficijent sumiranja';
$string['aggregationcoefextra'] = 'Dodatni bodovi';
$string['aggregationcoefextra_help'] = 'Ako je metod sumiranja \'Prirodno\' ili \'Jednostavna ponderisana srednja vrednost\' i ako je označeno polje za dodatne bodove, maksimalna ocena stavke se ne dodaje najvećoj ukupnoj oceni kategorije, Ovo će za posledicu imati mogućnost da se dostigne maksimalna ocena u kategoriji, a da pri tome ne postoje maksimalne ocene u svim stavkama ocene. Ako je administrator sajta omogućio ocene veće od maksimalne, onda mogu postojati takve ocene.

Ako je metod sumiranja ‘Srednja vrednost ocena’ (sa dodatnim bodovima) i ako je vrednost za dodatne bodove veća od nule, onda su dodatni bodovi faktor kojim se ocena množi pre njenog dodavanja ukupnoj oceni nakon izračunavanja srednje vrednosti.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Dodatni bodovi';
$string['aggregationcoefextrasum_help'] = 'Ako je polje za dodatne bodove označeno maksimalna ocena za stavku se ne dodaje maksimalnoj oceni kategorije, što rezultira mogućnošću da maksimalna ocena u kategoriji bude dostignuta (ili čak prekoračena, ako je administrator sajta omogućio tu opciju), a da pri tome nema nijedne maksimalne ocene za bilo koju od stavki koje se ocenjuju.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Ponder dodatnih bodova';
$string['aggregationcoefextraweight_help'] = 'Ako je ponder dodatnih bodova postavljen tako da bude veći od 0, onda se ocena ponaša kao dodatni kredit u toku sumiranja. Broj je faktor kojim se ocena množi pre nego što se doda ukupnoj vrednosti za izračunavanje srednje vrednosti.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Ponder stavke';
$string['aggregationcoefweight_help'] = 'Ponder stavke se koristi u izračunavanju sumarne ocene kategorije kako bi odredio važnost stavke, u poređenju sa drugim stavkama koje se ocenjuju unutar iste kategorije.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '(Odbačeno)';
$string['aggregationhintexcluded'] = '(Isključeno)';
$string['aggregationhintextra'] = '(Dodatni bodovi)';
$string['aggregationhintnovalue'] = '(Prazno)';
$string['aggregationofa'] = 'Agregacija za {$a}';
$string['aggregationposition'] = 'Pozicija sumarne ocene';
$string['aggregationposition_help'] = 'Ovo podešavanje određuje da li će  kolone sa ocenama za kategorije i kolona sa ukupnom ocenom na kursu biti prikazane prve ili poslednje u izveštajima iz knjige ocena.';
$string['aggregationsvisible'] = 'Dostupni načini sumiranja';
$string['aggregationsvisiblehelp'] = 'Izaberite sve načine sumiranja ocena koji bi trebalo da su dostupni. Držite CTRL taster za izbor više načina.';
$string['allgrades'] = 'Sve ocene po kategorijama';
$string['allstudents'] = 'Svi polaznici';
$string['allusers'] = 'Svi korisnici';
$string['autosort'] = 'Automatsko sortiranje';
$string['availableidnumbers'] = 'Raspoloživi ID brojevi';
$string['average'] = 'Prosek';
$string['averagesdecimalpoints'] = 'Broj decimala u prosecima kolona';
$string['averagesdecimalpoints_help'] = 'Ovo podešavanje određuje broj decimalnih mesta koji će biti prikazan za svaki prosek odnosno da li se koristi (nasleđeno) podešavanje ukupnog broj decimalnih mesta za kategoriju ili za stavku ocene.';
$string['averagesdisplaytype'] = 'Tip prikaza kolone sa srednjim ocenama';
$string['averagesdisplaytype_help'] = 'Ovo podešavanje određuje da li se prosek (srednja vrednost) prikazuje kao broj, procenat ili slovo, odnosno, da li će se koristiti tip prikaza za kategoriju ili za stavku ocene (nasleđeno).';
$string['backupwithoutgradebook'] = 'Rezervna kopija ne sadrži podatke o konfiguraciji knjige ocena';
$string['badgrade'] = 'Data ocena je neispravna';
$string['badlyformattedscale'] = 'Molimo vas unesite spisak vrednosti razdvojenih zarezom (neophodne su najmanje dve vrednosti).';
$string['baduser'] = 'Dati korisnik je neispravan';
$string['bonuspoints'] = 'Dodatni poeni';
$string['bulkcheckboxes'] = 'Polja za potvrdu za masovne operacije';
$string['calculatedgrade'] = 'Izračunata ocena';
$string['calculation'] = 'Proračun';
$string['calculation_help'] = 'Izračunavanje ocene predstavlja formulu koja se koristi kako bi se odredile ocene. Formula treba da počinje znakom jednakosti (=), i može da koristi uobičajene matematičke operatore, kao što su max, min i sum. Ako želite, druge stavke za ocenjivanje mogu biti uključene u izračunavanje tako što ćete upisati ID brojeva tih stavki unutar dvostrukih uglastih zagrada.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Dodaj proračun';
$string['calculationedit'] = 'Uredi proračun';
$string['calculationsaved'] = 'Proračun sačuvan';
$string['calculationview'] = 'Pogledaj proračun';
$string['cannotaccessgroup'] = 'Oprostite, ali ne možete da pristupite ocenama izabrave grupe.';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categoryedit'] = 'Uredi  kategoriju';
$string['categoryname'] = 'Naziv kategorije';
$string['categorytotal'] = 'Ukupna ocena za kategoriju';
$string['categorytotalfull'] = '{$a->category} ukupno';
$string['categorytotalname'] = 'Naziv za ukupnu ocenu kategorije';
$string['changedefaults'] = 'Promeni podrazumevana podešavanja';
$string['changereportdefaults'] = 'Promeni podrazumevana podešavanja izveštaja';
$string['chooseaction'] = 'Izaberi akciju...';
$string['choosecategory'] = 'Izaberi kategoriju';
$string['collapsecriterion'] = 'Skupi kriterijum';
$string['combo'] = 'Kartice i padajući meni';
$string['compact'] = 'Kompaktno';
$string['componentcontrolsvisibility'] = 'Podešavanja aktivnosti kontrolišu da li je ova stavka ocene sakrivena.';
$string['contract'] = 'Skupi kategoriju';
$string['contributiontocoursetotal'] = 'Doprinos ukupnoj oceni na kursu';
$string['controls'] = 'Kontrole';
$string['courseavg'] = 'Prosek na nivou kursa';
$string['coursegradecategory'] = 'Kategorija ocena kursa';
$string['coursegradedisplaytype'] = 'Tip prikazivanja ocena na kursu';
$string['coursegradedisplayupdated'] = 'Tip prikaza ocena na kursu je ažuriran.';
$string['coursegradesettings'] = 'Podešavanje ocena kursa';
$string['coursename'] = 'Naziv kursa';
$string['coursescales'] = 'Skale kursa';
$string['coursesettings'] = 'Podešavanja kursa';
$string['coursesettingsexplanation'] = 'Podešavanja ocena kursa određuju kako će knjiga ocena biti prikazana svim učesnicima kursa.';
$string['coursesiamtaking'] = 'Kursevi koje pohađam';
$string['coursesiamteaching'] = 'Kursevi koje držim';
$string['coursetotal'] = 'Ukupno za kurs';
$string['createcategory'] = 'Kreiraj kategoriju';
$string['createcategoryerror'] = 'Kreiranje nove kategorije nemoguće';
$string['creatinggradebooksettings'] = 'Kreiranje podešavanja knjige ocena';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Trenutno nadređeno sumiranje';
$string['curveto'] = 'Prilagodi na';
$string['decimalpoints'] = 'Ukupan broj decimalnih mesta';
$string['decimalpoints_help'] = 'Ovo podešavanje određuje broj decimalnih mesta koji će biti prikazan za svaku ocenu. Ono ne utiče na izračunavanja ocena, koja se vrše sa preciznošću od 5 decimalnih mesta.';
$string['default'] = 'Podrazumevano';
$string['defaultprev'] = 'Podrazumevano ({$a})';
$string['deletecategory'] = 'Obriši kategoriju';
$string['disablegradehistory'] = 'Onemogući istoriju ocena';
$string['disablegradehistory_help'] = 'Onemogući praćenje istorije promena u tabelama koje se odnose na ocene. Ovo može malo da ubrza server i sačuva prostor u bazi podataka.';
$string['displaylettergrade'] = 'Prikaži slovne ocene';
$string['displaypercent'] = 'Prikaži procente';
$string['displaypoints'] = 'Prikaži poene';
$string['displayweighted'] = 'Prikaži ponderisane ocene';
$string['dropdown'] = 'Padajući meni';
$string['droplow'] = 'Odbaci najniže';
$string['droplow_help'] = 'Ovo podešavanje omogućuje da određeni broj najnižih ocena bude isključen iz sumiranja.';
$string['droplowestvalue'] = 'Podesite broj najnižih ocene za odbacivanje';
$string['droplowestvalues'] = 'Odbaci {$a} najnižu/e/ih vrednost(i)';
$string['dropped'] = 'Odbačeno';
$string['dropxlowest'] = 'Odbaci X najnižih';
$string['dropxlowestwarning'] = 'Napomena: Ako koristite opciju \'odbaci X najnižih ocena\' ocenjivanje pretpostavlja da sve stavke unutar kategorije imaju istu vrednost boda. Ukoliko se vrednosti boda razlikuju rezultati će biti nepredvidljivi';
$string['duplicatedgradeitem'] = '{$a} (copy)';
$string['duplicatescale'] = 'Dupliraj skalu';
$string['edit'] = 'Uredi';
$string['editcalculation'] = 'Uredi proračun';
$string['editcalculationverbose'] = 'Uredi izračunavanje za {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Uredi povratne informacije';
$string['editgrade'] = 'Uredi ocenu';
$string['editgradeletters'] = 'Uredi slovne ocene';
$string['editoutcome'] = 'Uredi ishod učenja';
$string['editoutcomes'] = 'Uredi ishode učenja';
$string['editscale'] = 'Uredi skalu';
$string['edittree'] = 'Podešavanja';
$string['editverbose'] = 'Uredi {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Omogući AJAX';
$string['enableajax_help'] = 'Dodaje AJAX funkcionalnost izveštaju ocenjivača, čime pojednostavljuje i ubrzava uobičajene operacije. Zavisi od toga da li je korisnik uključio Javascript u svom veb čitaču.';
$string['enableoutcomes'] = 'Omogući ishode učenja';
$string['enableoutcomes_help'] = 'Ako je ova opcija omogućena stavke za ocenjivanje mogu se ocenjivati korišćenjem jedne ili više skala koje su povezane sa izjavama o ishodima.';
$string['encoding'] = 'Kodiranje';
$string['encoding_help'] = 'Izaberite kodiranje znakova koje se koristi za podatke (standardni kodni raspored je UTF-8). Ako se slučajno izabere pogrešno kodiranje to će se primetiti pri pregledu podataka za uvoz.';
$string['errorcalculationbroken'] = 'Verovatno postoji kružna referenca ili je formula za izračunavanje oštećena';
$string['errorcalculationnoequal'] = 'Formula mora početi znakom jednakosti (=1+2)';
$string['errorcalculationunknown'] = 'Neispravna formula';
$string['errorgradevaluenonnumeric'] = 'Dobijena je nenumerička vrednost za visoku ili nisku ocenu za';
$string['errornocalculationallowed'] = 'Izračunavanja nisu dozvoljena za ovu stavku';
$string['errornocategorisedid'] = 'Nije moguće dobiti nekategorisan id!';
$string['errornocourse'] = 'Nije moguće dobiti informacije o kursu';
$string['errorreprintheadersnonnumeric'] = 'Dobijena je nenumerička vrednost za ponovni ispis zaglavlja';
$string['errorsavegrade'] = 'Oprostite, nije moguće sačuvati ocenu.';
$string['errorsettinggrade'] = 'Greška pri pokušaju da se sačuva "{$a->itemname}" ocena za korisnički id {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Greška pri ažuriranju podešavanja "Sumiraj samo upisane ocene" za kategoriju ocena čiji je ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Greška pri ažuriranju podešavanja "Uključi ishode učenja u sumiranje" za kategoriju ocena čiji je ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Greška pri ažuriranju načina sumiranja za kategoriju ocena čiji je ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Greška pri ažuriranju koeficijenta sumiranja (pondera ili dodatnih bodova) stavke koja se ocenjuje čiji je ID {$a->id}';
$string['eventgradedeleted'] = 'Ocena obrisana';
$string['eventgradeitemcreated'] = 'Stavka za ocenjivanje je kreirana';
$string['eventgradeitemupdated'] = 'Stavka za ocenjivanje je ažurirana';
$string['eventgradelettercreated'] = 'Slovna ocena je kreirana';
$string['eventgradeletterdeleted'] = 'Slovna ocena je obrisana';
$string['eventgradeletterupdated'] = 'Slovna ocena je ažurirana';
$string['eventgradeviewed'] = 'Ocene korisnika prikazane u knjizi  ocena.';
$string['eventscalecreated'] = 'Skala je kreirana';
$string['eventscaledeleted'] = 'Skala je obrisana';
$string['eventscaleupdated'] = 'Skala je ažurirana';
$string['eventusergraded'] = 'Korisnik ocenjen';
$string['excluded'] = 'Isključeno';
$string['excluded_help'] = 'Ako je označeno, ocena neće biti uključena u bilo koje sumiranje.';
$string['expand'] = 'Proširi kategoriju';
$string['expandcriterion'] = 'Proširi kriterijum';
$string['export'] = 'Izvoz';
$string['exportalloutcomes'] = 'Izvezi sve ishode učenja';
$string['exportfeedback'] = 'Uključi povratne informacije u izvoz';
$string['exportfeedback_desc'] = 'Ovo može biti izmenjeno prilikom izvoza.';
$string['exportformatoptions'] = 'Opcije formata za izvoz';
$string['exportonlyactive'] = 'Isključi suspendovane korisnike';
$string['exportonlyactive_help'] = 'Prilikom izvoza biće uključeni samo polaznici koji su aktivni na kursu i nisu suspendovani';
$string['exportplugins'] = 'Izvezi dodatke';
$string['exportsettings'] = 'Izvezi podešavanja';
$string['exportto'] = 'Izvezi u';
$string['externalurl'] = 'Eksterna URL adresa';
$string['externalurl_desc'] = 'Ukoliko se koristi eksterna knjiga ocena ovde treba navesti njenu URL adresu';
$string['extracreditvalue'] = 'Dodatni bodovi za {$a}';
$string['extracreditwarning'] = 'Napomena: Podešavanje dodatnih bodova za sve stavke u kategoriji će ih ukloniti iz proračuna ocene, te neće biti ukupnog broja bodova';
$string['feedback'] = 'Povratne informacije';
$string['feedback_help'] = 'Ovo polje omogućava dodavanje bilo kakvog komentara o oceni.';
$string['feedbackadd'] = 'Dodaj povratne informacije';
$string['feedbackedit'] = 'Uredi povratne informacije';
$string['feedbackfiles'] = 'Datoteke povratnih informacija';
$string['feedbackforgradeitems'] = 'Povratna informacija za {$a}';
$string['feedbackhistoryfiles'] = 'Datoteke istorije povratnih informacija';
$string['feedbacks'] = 'Povratne informacije';
$string['feedbacksaved'] = 'Povratne informacije su sačuvane';
$string['feedbackview'] = 'Pogledaj povratne informacije';
$string['finalgrade'] = 'Konačna ocena';
$string['finalgrade_help'] = 'Ako je polje za izmenu označeno, ocena može da bude dodata ili izmenjena.';
$string['fixedstudents'] = 'Statična kolona sa studentima';
$string['fixedstudents_help'] = 'Ova opcija fiksira kolonu sa imenima studenata i na taj način omogućava da se kolone sa ocenama pomeraju horizontalno, a da se pri tome kolona sa imenima  studenata sve vreme vidi.';
$string['forceimport'] = '
Obavezan uvoz';
$string['forceimport_help'] = 'Forsiraj uvoz ocena čak i ako su ocene ažurirane nakon izvoza datoteke iz koje je rađen uvoz';
$string['forceoff'] = 'Obavezno: Isključeno';
$string['forceon'] = 'Obavezno: Uključeno';
$string['forelementtypes'] = 'za izabrani {$a}';
$string['forstudents'] = 'Za polaznike';
$string['full'] = 'Pun';
$string['fullmode'] = 'Promeni na \'Puni prikaz\'';
$string['generalsettings'] = 'Opšta podešavanja';
$string['grade'] = 'Ocena';
$string['grade_help'] = 'Ocena koja se dodeljuje polazniku za njegov rad.';
$string['gradeadministration'] = 'Administracija ocena';
$string['gradealreadyupdated'] = '{$a} ocena nije uvezeno jer su ocene u datoteci iz koje se radi uvoz starije od onih u ocenjivačkom izveštaju. Da biste svejedno nastavili sa uvozom koristite opciju za njegovo forsiranje.';
$string['gradeanalysis'] = 'Analiza ocena';
$string['gradebook'] = 'Knjiga ocena';
$string['gradebookcalculationsfixbutton'] = 'Prihvatite izmene ocena i ispravite greške u izračunavanju';
$string['gradebookcalculationsuptodate'] = 'Proračuni u knjizi ocena su ažurirani. Možda ćete morati ponovo da učitate ovu stranicu kako biste videli izmene.';
$string['gradebookcalculationswarning'] = 'Napomena: Neke greške su otkrivene prilikom računanja ocena koje su prikazane u knjizi ocena. Ako vaš kurs još nije započet ili je u toku preporučuje se  da se greške isprave tako što ćete kliknuti na donje dugme iako će neke ocene biti promenjene zbog toga. Ako se vaš kurs već završio i ocene su predate verovatno nećete želeti da ispravljate ove greške.

Novija verzija je {$a->currentversion}; ako koristite dnevnik ocena u verziji {$a->gradebookversion}. Možete videti spisak izmena na stranici <a href="{$a->url}">Izmene izračunavanja ocena</a>.';
$string['gradebookhiddenerror'] = 'Knjiga ocena je trenutno podešena tako da sve skriva od polaznika';
$string['gradebookhistories'] = 'Istorije ocena';
$string['gradebooksetup'] = 'Podešavanje dnevnika ocena';
$string['gradeboundary'] = 'Granice slovnih ocena';
$string['gradeboundary_help'] = 'Ovo podešavanje određuje minimalni procenat iznad kojeg će biti dodeljena slovna ocena.';
$string['gradecategories'] = 'Kategorije ocena';
$string['gradecategory'] = 'Kategorija ocena';
$string['gradecategoryonmodform'] = 'Kategorija ocena';
$string['gradecategoryonmodform_help'] = 'Ovo podešavanje kontroliše kategoriju u koju se smeštaju ocene za ovu aktivnost unutar knjige ocena.';
$string['gradecategorysettings'] = 'Podešavanja kategorije ocena';
$string['gradedisplay'] = 'Prikaz ocena';
$string['gradedisplaytype'] = 'Tip prikaza ocena';
$string['gradedisplaytype_help'] = 'Ovo podešavanje određuje način na koji će ocene biti prikazane u izveštajima ocenjivača i korisnika.

* Slovo - slova ili reči se koriste za prikaz raspona ocena, kao što je definisano u podešavanjima dnevnika
* Procenat - relativno u odnosu na maksimalnu i minimalne ocene
* Broj - Stvarne ocene ili vrednosti skale';
$string['gradedon'] = 'Ocenjeno: $a';
$string['gradeexport'] = 'Izvoz ocena';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Prilagođena polja profila uključena u izvoz ocena';
$string['gradeexportcustomprofilefields_desc'] = 'Uključi u izvoz ocena ova prilagođena polja profila, razdvojena zarezima.';
$string['gradeexportdecimalpoints'] = 'Broj decimalnih mesta pri izvozu ocena';
$string['gradeexportdecimalpoints_desc'] = 'Broj decimalnih mesta koji će biti prikazan pri izvozu. Ovo se može promeniti tokom izvoza.';
$string['gradeexportdisplaytype'] = 'Tip prikaza za izvoz ocena';
$string['gradeexportdisplaytype_desc'] = 'Ocene mogu biti prikazane kao celi brojevi, kao procenti (u odnosu na najmanje i najveće ocene) ili kao slova (A, B, C itd.). Ovo može biti promenjeno tokom eksportovanja.';
$string['gradeexportdisplaytypes'] = 'Tipovi prikaza izvoza ocena';
$string['gradeexportuserprofilefields'] = 'Polja korisničkog profila uključena u izvoz ocena';
$string['gradeexportuserprofilefields_desc'] = 'Uključi u izvoz ocena ova polja korisničkog profila, razdvojena zarezima.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Početna minimalna i početna maksimalna ocena';
$string['gradehelp'] = 'Pomoć za ocene';
$string['gradehistorylifetime'] = 'Trajanje istorije ocena';
$string['gradehistorylifetime_help'] = 'Ovo podešavanje određuje koliko dugo želite da čuvate istoriju promena u tabelama koje su povezane sa ocenama. Preporučeno je da istoriju čuvate što je duže moguće. Ukoliko budete imali problema sa performansama sistema ili ako imate ograničen prostor za bazu podataka, pokušajte da postavite nižu vrednost.';
$string['gradeimport'] = 'Uvoz ocena';
$string['gradeimportfailed'] = 'Увоз оцена није успео. Више информација:';
$string['gradeitem'] = 'Stavka ocene';
$string['gradeitemaddusers'] = 'Isključi iz ocenjivanja';
$string['gradeitemadvanced'] = 'Napredne opcije za stavke ocene';
$string['gradeitemadvanced_help'] = 'Izaberi sve elemente koje treba prikazati kao napredne kada se uređuju stavke ocena.';
$string['gradeitemislocked'] = 'Ova aktivnost je zaključana u knjizi ocena. Promene koje su načinjene u okviru ove aktivnosti neće biti kopirane u knjigu ocena sve dok se ista ne otključa.';
$string['gradeitemlocked'] = 'Ocenjivanje zaključano';
$string['gradeitemmembersselected'] = 'Isključeno iz ocenjivanja';
$string['gradeitemminmax'] = 'Minimalna ocena i maksimalna ocena koje su određene u podešavanjima stavke za ocenjivanje';
$string['gradeitemnonmembers'] = 'Uključeno u ocenjivanje';
$string['gradeitemremovemembers'] = 'Uključi u ocenjivanje';
$string['gradeitems'] = 'Stavke ocene';
$string['gradeitemsettings'] = 'Podešavanja stavki ocene';
$string['gradeitemsinc'] = 'Stavke ocene koje treba uključiti';
$string['gradeletter'] = 'Slovna ocena';
$string['gradeletter_help'] = 'Slovne ocene su A, B, C... ili reči, npr. odličan, dobar, dovoljan,... koje se koriste da predstave raspon ocena.';
$string['gradeletternote'] = 'Da biste izbrisali slovnu ocenu samo obrišite bilo koje od <br /> tri tekstulna polja za to slovo i sačuvajte promene.';
$string['gradeletteroverridden'] = 'Podrazumevane slovne ocene su trenutno izmenjene.';
$string['gradeletters'] = 'Slovne ocene';
$string['gradelocked'] = 'Ocena je zaključana';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Najveća ocena';
$string['grademax_help'] = 'Ovo podešavanje određuje maksimalnu ocenu kada se kao tip ocene koristi brojčana vrednost. Maksimalna ocena za aktivnost se određuje na stranici za podešavanje te aktivnosti.';
$string['grademin'] = 'Najmanja ocena';
$string['grademin_help'] = 'Ovo podešavanje određuje minimalnu ocenu kada se kao tip ocene koristi brojčana vrednost.';
$string['gradenotificationmessage'] = 'Imate nove povratne informacije o svom radu za "{$a}"';
$string['gradenotificationsubject'] = 'Ocenjeni ste';
$string['gradeoutcomeitem'] = 'Oceni stavku ishoda učenja';
$string['gradeoutcomes'] = 'Ishodi učenja';
$string['gradeoutcomescourses'] = 'Ishodi učenja kursa';
$string['gradepass'] = 'Ocena za prolaz';
$string['gradepass_help'] = 'Ovo podešavanje određuje minimalnu ocenu potrebnu za prolaz. Vrednost se koristi kod završetka aktivnosti i kursa, kao i u knjizi ocena gde su prolazne ocene označene zelenom, a neprolazne crvenom bojom.';
$string['gradepassgreaterthangrade'] = 'Prelazna ocena ne može biti veća od maksimalno moguće ocene {$a}';
$string['gradepointdefault'] = 'Podrazumevani broj poena';
$string['gradepointdefault_help'] = 'Ovo podešavanje određuje podrazumevanu vrednost za broj poena koji je na raspolaganju prilikom ocenjivanja aktivnosti.';
$string['gradepointdefault_validateerror'] = 'Ovi podešavanje mora da bude ceo broj između 1 i maksimalnog broja poena.';
$string['gradepointmax'] = 'Maksimalan broj poena';
$string['gradepointmax_help'] = 'Ovo podešavanje odrećuje maksimalan broj poena koji je na raspolaganju prilikom ocenjivanja aktivnosti.';
$string['gradepointmax_validateerror'] = 'Ovi podešavanje mora da bude ceo broj između 1 i 10000';
$string['gradepreferences'] = 'Parametri ocene';
$string['gradepreferenceshelp'] = 'Pomoć za parametre ocene';
$string['gradepublishing'] = 'Omogući objavljivanje';
$string['gradepublishing_help'] = 'Objavljivanje ocena je način uvoza/izvoza ocena putem URL-a bez obavezne prijave na Moodle sajt. Ukoliko je omogućeno, administratori i drugi korisnici sa pravom objavljivanja ocena (podrazumevano su to samo korisnici sa ulogom menadžera) imaju na raspolaganju podešavanja za objavljivanje izvoza ocena u svakoj knjizi ocena.';
$string['gradepublishinglink'] = 'Preuzmi: {$a}';
$string['gradereport'] = 'Izveštaj o ocenama';
$string['graderreport'] = 'Izveštaj ocenjivača';
$string['grades'] = 'Ocene';
$string['gradesforuser'] = 'Ocene za {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Upozorenje: brisanje aktivnost u toku! Neke ocene biće uklonjene.';
$string['gradesmoduledeletionprefix'] = '[Brisanje u toku]';
$string['gradesonly'] = 'Promeni na \'Samo ocene\'';
$string['gradessettings'] = 'Podešavanja ocena';
$string['gradetype'] = 'Tip ocene';
$string['gradetype_help'] = 'Postoje 4 tipa ocena:

* Ništa - ocenjivanje nije moguće
* Vrednost - brojčana vrednost sa maksimalnom i minimalnom vrednošću
* Skala - stavka na spisku
* Tekst - samo povratne informacije

Samo vrednosti i skale mogu da se sumiraju. Tip ocene za pojedinu aktivnost se određuje na stranici za podešavanja te aktivnosti.';
$string['gradevaluetoobig'] = 'Jedna od vrednosti ocena je veća od dozvoljenog maksimuma ({$a})';
$string['gradeview'] = 'Pogledaj ocenu';
$string['gradewasmodifiedduringediting'] = 'Ocena uneta pod stavkom {$a->itemname} za polaznika sa korisničkim imenom {$a->username} je ignorisana jer ju je kasnije ažurirao neko drugi.';
$string['gradeweighthelp'] = 'Pomoć za ponder ocena';
$string['gradingmodulename'] = 'Ocenjivanje ({$a})';
$string['groupavg'] = 'Prosek grupe';
$string['hidden'] = 'Sakriveno';
$string['hidden_help'] = 'Ako je označeno, ocene su sakrivene od polaznika. Ako želite možete postaviti opciju \'sakriveno do dana\' kako bi se ocene objavile nakon što je ocenjivanje završeno.';
$string['hiddenasdate'] = 'Prikaži datum predaje za skrivene ocene';
$string['hiddenasdate_help'] = 'Ukoliko korisnik ne može da vidi sakrivene ocene prikažite datum kada je ocena postavljena umesto znaka \'-\'.';
$string['hiddenuntil'] = 'Sakriveno do';
$string['hiddenuntildate'] = 'Sakriveno do: {$a}';
$string['hideadvanced'] = 'Sakrij napredne opcije';
$string['hideaverages'] = 'Sakrij proseke';
$string['hidecalculations'] = 'Sakrij proračune';
$string['hidecategory'] = 'Sakriveno';
$string['hideeyecons'] = 'Sakrij ikonice prikaži/sakrij';
$string['hidefeedback'] = 'Sakrij povratne informacije';
$string['hideforcedsettings'] = 'Sakrij prinudna podešavanja';
$string['hideforcedsettings_help'] = 'Ne prikazuj prinudna podešavanja u korisničkom interfejsu za ocenjivanje';
$string['hidegroups'] = 'Sakrij grupe';
$string['hidelocks'] = 'Sakrij zaključavanja';
$string['hidenooutcomes'] = 'Prikaži ishode učenja';
$string['hidequickfeedback'] = 'Sakrij brze povratne informacije';
$string['hideranges'] = 'Sakrij opsege';
$string['hidetotalifhiddenitems'] = 'Sakrij ukupne ocene ako sadrže skrivene stavke';
$string['hidetotalifhiddenitems_help'] = 'Ovo podešavanje određuje da li se ukupne ocene koje sadrže sakrivene stavke prikazuju polaznicima ili se zamenjuju crticom (-). Ako se prikazuju, ukupna ocena može biti izračunata ili bez ili sa sakrivenim stavkama.

Ako su sakrivene stavke isključene, ukupna ocena će biti različita od ukupne ocene koju vidi predavač u izveštaju ocenjivača, zato što predavač uvek vidi ukupnu ocenu za sve stavke, bez obzira jesu li one sakrivene ili ne. Ako su sakrivene stavke uključene u ukupnu ocenu, polaznici mogu da izračunaju ocene za sakrivene stavke.';
$string['hidetotalshowexhiddenitems'] = 'Prikaži ukupne ocene bez sakrivenih stavki';
$string['hidetotalshowinchiddenitems'] = 'Prikaži ukupne ocene uključujući sakrivene stavke';
$string['hideverbose'] = 'Sakrij {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Sortiraj po visini ocene - rastući niz';
$string['highgradedescending'] = 'Sortiraj po visini ocene - opadajući niz';
$string['highgradeletter'] = 'Gornja granica';
$string['identifier'] = 'Identifikuj korisnika prema';
$string['idnumbers'] = 'ID brojevi';
$string['ignore'] = 'Ignoriši';
$string['import'] = 'Uvoz';
$string['importcsv'] = 'Uvezi CSV';
$string['importcsv_help'] = 'Ocene se mogu uvesti iz CSV datoteke sledećeg formata:

* Svaki red datoteke sadrži jedan zapis
* Svaki zapis je niz podataka odvojenih zarezima ili alternativnim graničnim znacima
* Prvi zapis sadrži spisak naziva polja definišući format za ostatak datoteke
* Polje koje sadrži identitet korisnika je obavezno - korisničko ime, ID broj ili adresa elektronske pošte

Datoteka odgovarajućeg formata se može dobiti izvozom nekih ocena. Ta se datoteka potom može urediti i sačuvati u CSV formatu.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Uvezi kao namenski prilagođene ishode učenja (samo za ovaj kurs)';
$string['importerror'] = 'Došlo je do greške, ovaj skript nije bio pozvan sa pravim parametrima';
$string['importfailed'] = 'Uvoz nije uspeo. Ništa od podataka nije uvezeno.';
$string['importfeedback'] = 'Uvezi povratne informacije';
$string['importfile'] = 'Uvezi datoteku';
$string['importfilemissing'] = 'Nijedna datoteka nije primljena, vratite se na obrazac i uverite se da ste prosledili ispravnu datoteku.';
$string['importfrom'] = 'Uvezi iz';
$string['importoutcomenofile'] = 'Postavljena datoteka je prazna ili oštećena. Molimo, proverite da li je datoteka ispravna. Problem je otkriven u redu {$a}; ovo je pokrenuto zbog redova sa podacima koji nisu imali jednak broj kolona kao prvi (naslovni) red, ili ukoliko su nedostajala očekivana zaglavlja u uvezenoj datoteci. Pogledajte izvezenu datoteku za primer datoteke ispravnim zaglavljem.';
$string['importoutcomes'] = 'Uvezi ishode učenja';
$string['importoutcomes_help'] = 'Ishodi učenja mogu biti uvezeni iz CSV datoteke koja ima format kao i CSV datoteka za izvoz ishoda učenja.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Uvezen ishod učenja "{$a->name}" sa ID #{$a->id}';
$string['importplugins'] = 'Uvezi dodatke';
$string['importpreview'] = 'Pregled uvezenih ocena';
$string['importsettings'] = 'Podešavanja uvoza';
$string['importskippednomanagescale'] = 'Nemate ovlašćenje za dodavanje nove skale ocenjivanja, tako da je ishod učenja"{$a}" preskočen jer je zahtevao kreiranje nove skale';
$string['importskippedoutcome'] = 'Ishod sa kraćim nazivom "{$a}" već postoji u ovom kontekstu, onaj iz uvezene datoteke je preskočen.';
$string['importstandard'] = 'Uvezi kao standardne ishode učenja';
$string['importsuccess'] = 'Uspešan uvoz ocena';
$string['importxml'] = 'Uvezi XML';
$string['includescalesinaggregation'] = 'Uključi skale u sumiranje';
$string['includescalesinaggregation_help'] = 'Možete promeniti da se skale za ocenjivanje uključe kao brojevi u svim zbirnim ocenama u svim knjigama ocena na svim kursevima. UPOZORENЈE: promena ovog podešavanja pokrenuće ponovno izračunavanje svih zbirnih ocena.';
$string['incorrectcourseid'] = 'ID kursa je netačan';
$string['incorrectcustomscale'] = '(Neispravna prilagođena skala, molimo promenite.)';
$string['incorrectminmax'] = 'Minimalna vrednost mora biti manja od maksimalne';
$string['inherit'] = 'Nasleđeno';
$string['intersectioninfo'] = 'Polaznik/Ocena info';
$string['invalidgradeexporteddate'] = 'Datum izvoza nije validan jer je od pre više od godinu dana, ili je u budućnosti ili njegov format nije korektan.';
$string['item'] = 'Stavka';
$string['iteminfo'] = 'Informacije o stavci';
$string['iteminfo_help'] = 'Ovo podešavanje obezbeđuje prostor za unos informacija o stavci. Informacije se nigde drugde ne prikazuju.';
$string['itemname'] = 'Naziv stavke';
$string['itemnamehelp'] = 'Naziv ove stavke dobijen od modula.';
$string['items'] = 'Stavke';
$string['itemsedit'] = 'Uredi stavku ocene';
$string['keephigh'] = 'Zadrži najveću';
$string['keephigh_help'] = 'Ako je ova opcija podešena, čuvaće se samo X najviših ocena, gde je X izabrana vrednost za ovu opciju.';
$string['keephighestvalues'] = 'Zadrži {$a} najvišu/e/ih ocena';
$string['keymanager'] = 'Upravljanje ključevima';
$string['lessthanmin'] = 'Ocena uneta za {$a->itemname} za korisnika {$a->username} je manja od minimalno dozvoljene';
$string['letter'] = 'Slovo';
$string['lettergrade'] = 'Slovna ocena';
$string['lettergradenonnumber'] = 'Najniža i/ili najviša ocena nisu bile numeričke za';
$string['letterpercentage'] = 'Slovo (procenat)';
$string['letterreal'] = 'Slovo (realna vrednost)';
$string['letters'] = 'Slova';
$string['linkedactivity'] = 'Linkovana aktivnost';
$string['linkedactivity_help'] = 'Ovo podešavanje određuje aktivnost sa kojom je ovaj ishod učenja povezan. Ovo se može koristiti za merenje postignuća polaznika koja se ne procenjuju pomoću ocena aktivnosti.';
$string['linktoactivity'] = 'Link ka {$a->name} aktivnosti {$a->title}';
$string['lock'] = 'Zaključaj';
$string['locked'] = 'Zaključano';
$string['locked_help'] = 'Ako je označeno, ocene su zaključane i više ne mogu biti automatski ažurirane od strane pripadajuće aktivnosti.';
$string['locktime'] = 'Zaključano nakon';
$string['locktimedate'] = 'Zaključaj nakon: {$a}';
$string['lockverbose'] = 'Zaključaj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Najniže';
$string['lowgradeletter'] = 'Donja granica';
$string['manualitem'] = 'Ručne stavke';
$string['mapfrom'] = 'Preslikaj iz';
$string['mapfrom_help'] = 'Odaberite kolonu u tabeli koja sadrži podatke za identifikaciju korisnika, kao što je korisničko ime, identifikacioni broj korisnika ili adresa elektronske pošte.';
$string['mappings'] = 'Preslikavanje stavki ocena';
$string['mappings_help'] = 'Za svaku kolonu ocena u tabeli odaberite odgovarajuću stavku za ocenjivanje u koju će se uvesti ocene.';
$string['mapto'] = 'Preslikaj u';
$string['mapto_help'] = 'Izaberite iste podatke za identifikaciju kao što su izabrani za \'Preslikaj iz\'.';
$string['max'] = 'Najviše';
$string['maxgrade'] = 'Maksimalna ocena';
$string['meanall'] = 'Sve ocene';
$string['meangraded'] = 'Upisane ocene';
$string['meanselection'] = 'Ocene izabrane za računanje proseka kolone';
$string['meanselection_help'] = 'Ovo podešavanje odredite da li  polja bez upisane ocene treba da budu uključene u računanje proseka (srednje vrednosti) za svaku kategoriju ili stavku ocene.';
$string['median'] = 'Medijana';
$string['min'] = 'Najniže';
$string['minimum_show'] = 'Prikaži najnižu ocenu';
$string['minimum_show_help'] = 'Minimalna ocena se koristi za računanje ocena i težina. Ako nije prikazana minimalna ocena ima podrazumevanu vrednost nula i ne može se uređivati.';
$string['minmaxtouse'] = 'Minimalne i maksimalne ocene korišćene u izračunavanju';
$string['minmaxtouse_desc'] = 'Podešavanje koje utvrđuje da li da se koriste početne minimalne i maksimalne vrednosti ocene kada se daje konkretna ocena ili da se minimalne i maksimalne vrednosti posebno utvrde u podešavanjima, kada se izračunava ocena prikazana u knjizi ocena. Preporuka je da se ovo podešavanje izmeni u vreme smanjene aktivnosti, budući da će se sve ocene ponovo računati, što može dovesti do povećanog opterećenja na serveru.';
$string['minmaxtouse_help'] = 'Podešavanje koje utvrđuje da li da se koriste početne minimalne i maksimalne vrednosti ocene kada se daje konkretna ocena ili da se minimalne i maksimalne vrednosti posebno utvrde u podešavanjima, kada se izračunava ocena prikazana u knjizi ocena.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Napomena: Neke ocene su izmenjene radi rešavanja pitanja neusaglašenosti u knjizi ocena izazvane promenom minimalnih i maksimalnih ocena korišćenih pri izračunavanju prikazane ocene. Preporučuje se da se izmene pregledaju u prihvate.';
$string['minmaxupgradefixbutton'] = 'Razreši nedoslednosti';
$string['minmaxupgradewarning'] = 'Napomena: Uočena je neusaglašenost između nekih ocena izazvana promenom minimalnih i maksimalnih ocena korišćenih pri izračunavanju ocene prikazane u knjizi ocena. Preporučuje se da se ta neusaglašenost reši klikom na dugme ispod, mada će to dovesti do izmene nekih ocena.';
$string['missingitemtypeoreid'] = 'Ključ niza (itemtype ili eid) nedostaje od drugog parametra za grade_edit_tree_column_select::get_item_cell($item, $params)';
$string['missingscale'] = 'Skala za ocenjivanje mora biti izabrana';
$string['mode'] = 'Mod';
$string['modgrade'] = 'Ocena';
$string['modgrade_help'] = 'Izaberite tip ocenjivanja  koji se koristi za ovu aktivnost. Ako je izabrana "skala", onda možete da izaberete vrstu skalu iz padajućeg menija. Ako koristite ocenjivanje pomoću "poena", onda možete da unesete maksimalnu ocenu koja će biti na raspolaganju za ovu aktivnost.';
$string['modgradecantchangegradetype'] = 'Ne možete promeniti tip je već postoje ocene za ovu stavku.';
$string['modgradecantchangegradetypemsg'] = 'Neke ocene su već dodeljene, tako da se tip ocene ne može menjati. Ako želite da izmenite maksimalnu ocenu morate prvo odabrati da li će se ili neće skalirati postojeće ocene.';
$string['modgradecantchangegradetyporscalemsg'] = 'Neke ocene su već dodeljene, tako da se tip ocene i skala ne mogu menjati.';
$string['modgradecantchangeratingmaxgrade'] = 'Ne možete imeniti maksimalnu ocenu kad već postoje ocene za aktivnost sa rangiranjem.';
$string['modgradecantchangescale'] = 'Ne možete izmeniti skalu jer već postoje ocene za ovu stavku.';
$string['modgradecategorycantchangegradetypemsg'] = 'Za ovu kategoriju su vezane stavke za ocenjivanje kojima su prepisane vrednosti. Stoga su neke ocene već dodeljene pa se u tim slučajevima tip ocene ne može menjati. Ako želite da izmenite maksimalnu moguću ocenu morate prvo odabrati da li će to inicirati skaliranje postojećih ocena ili ipak neće.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Za ovu kategoriju su vezane stavke za ocenjivanje kojima su prepisane vrednosti. Stoga su neke ocene već dodeljene pa se u tim slučajevima tip ocene i skala ne mogu menjati.';
$string['modgradecategoryrescalegrades'] = 'Skalirajte ponovo izmenjene ocene';
$string['modgradecategoryrescalegrades_help'] = 'Kada se menjaju maksimalne moguće ocene za stavku za ocenjivanje morate specificirati da li će to prouzrokovati i promenu postojećih procentualnih ocena ili ipak neće.

Ako je ovo podešavanje postavljeno na \'Da\', svaka postojeća prepisana ocena će biti skalirana tako da procentualna ocena ostane ista.

Na primer, ukoliko je ova opcija postavljena na \'Da\', izmena maksimalane moguće ocene za neku stavku sa 10 na 20 bi prouzrokovala skaliranje ocene 6/10 (60%) na 12/20 (60%). Sa ovom opcijom postavljenom na \'Ne\' ocena bi ostala nepromenjena, što bi zahtevalo ručno prilagođavanje stavki za ocenjivanje da bi se obezbedili tačni rezultati.';
$string['modgradedonotmodify'] = 'Bez izmena postojećih ocena';
$string['modgradeerrorbadpoint'] = 'Neispravna vrednost ocene. Mora da bude ceo broj između 1 i {$a}';
$string['modgradeerrorbadscale'] = 'Izabrana je neispravna skala. Proverite da li ste izabrali skalu iz donjeg padajućeg menija.';
$string['modgrademaxgrade'] = 'Maksimalna ocena';
$string['modgraderescalegrades'] = 'Skaliraj postojeće ocene';
$string['modgraderescalegrades_help'] = 'Kada menjate maksimalnu ocenu stavke za ocenjivanje morate specificirati da li će to prouzrokovati i izmenu procentualne ocene ili neće.

Ako je ovo podešavanje postavljeno na \'Da\', sve postojeće ocene će biti skalirane tako da procentualna ocena ostane ista.

Na primer, ako je ova opcija postavljena na \'Da\', izmena maksimalne ocene za stavku sa 10 na 20 bi prouzrokovala skaliranje ocene 6/10 (60%) na 12/20 (60%). A ako je ova opcija postavljena na \'Ne\', ocena bi bila izmenjena sa 6/10 (60%) na 6/20 (30%), što bi zahtevalo ručnu korekciju stavki za ocenjivanje da bi se obezbedili tačni rezultati.';
$string['modgradetype'] = 'Tip';
$string['modgradetypenone'] = 'Nijedan';
$string['modgradetypepoint'] = 'Poen';
$string['modgradetypescale'] = 'Skala';
$string['morethanmax'] = 'Ocena uneta za {$a->itemname} za korisnika {$a->username} je veća od maksimalno dozvoljene';
$string['moveselectedto'] = 'Premesti izabrane stavke u';
$string['movingelement'] = 'Pomeranje {$a}';
$string['multfactor'] = 'Multiplikator';
$string['multfactor_help'] = 'Multiplikator je faktor kojim će sve ocene za ovu stavku biti pomnožene, sa najvećom vrednošću maksimalne ocene. Na primer, ako je multiplikator 2 a maksimalna ocena 100, onda će sve ocene manje od 50 biti pomnožene sa 2, a sve ocene iznad 50 promenjene u 100.';
$string['multfactorvalue'] = 'Vrednost multiplikatora za {$a}';
$string['mustchooserescaleyesorno'] = 'Morate odabrati da li će se skalirati postojeće ocene ili neće.';
$string['mygrades'] = 'Link ka ocenama u korisničkom meniju';
$string['mygrades_desc'] = 'Ovo podešavanje vam daje mogućnost povezivanja sa eksternom knjigom ocena iz korisničkog menija.';
$string['mypreferences'] = 'Moja podešavanja';
$string['myreportpreferences'] = 'Moj izveštaj - podešavanja';
$string['navmethod'] = 'Metod navigacije';
$string['neverdeletehistory'] = 'Nikada ne briši istoriju';
$string['newcategory'] = 'Nova kategorija';
$string['newitem'] = 'Nova stavka ocene';
$string['newoutcomeitem'] = 'Novi ishod učenja';
$string['no'] = 'Ne';
$string['nocategories'] = 'Kategorije ocena za ovaj kurs ne mogu biti dodate ili pronađene';
$string['nocategoryname'] = 'Nije dat naziv kategorije';
$string['nocategoryview'] = 'Nema kategorije za prikaz';
$string['nocourses'] = 'Još uvek nema kurseva';
$string['noforce'] = 'Ne forsiraj podešavanja';
$string['nogradeletters'] = 'Nema podešenih slovnih ocena';
$string['nogradesreturned'] = 'Nema dobijenih ocena';
$string['noidnumber'] = 'Nema ID broja';
$string['nolettergrade'] = 'Nema slovne ocene za';
$string['nomode'] = 'Nije primenljivo';
$string['nonnumericweight'] = 'Dobijena je nenumerička vrednost za';
$string['nonunlockableverbose'] = 'Ova ocena ne može se otključati dok se ne otključa {$a->itemname}.';
$string['nonweightedpct'] = 'neponderisani %';
$string['nooutcome'] = 'Bez ishoda učenja';
$string['nooutcomes'] = 'Stavke ishoda učenja moraju biti povezane sa ishodom kursa, ali za ovaj kurs ne postoje ishoda . Da li želite da dodate ishod učenja?';
$string['nopermissiontoresetweights'] = 'Nemate ovlašćenja za resetovanje pondera';
$string['nopublish'] = 'Ne objavljivati';
$string['noreports'] = 'Niste upisani niti se predavač ni na jednom kursu na ovom sajtu.';
$string['norolesdefined'] = 'Nijedna uloga nije definisana u Administracija > Ocene > Opšta podešavanja > Uloge koje se ocenjuju';
$string['noscales'] = 'Ishodi moraju biti povezani sa skalom kursa ili globalnom skalom';
$string['noselectedcategories'] = 'nije izabrana nijedna kategorija.';
$string['noselecteditems'] = 'nije izabrana nijedna stavka.';
$string['notenrolled'] = 'Trenutno niste upisani ni na jedan kurs.';
$string['notteachererror'] = 'Morate biti predavač da biste koristili ovu opciju.';
$string['nousersloaded'] = 'Nisu učitani korisnici';
$string['nouserstograde'] = 'Nema korisnika za ocenjivanje';
$string['numberofgrades'] = 'Broj ocena';
$string['onascaleof'] = 'na skali od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Operacije';
$string['options'] = 'Opcije';
$string['others'] = 'Ostalo';
$string['outcome'] = 'Ishod učenja';
$string['outcome_help'] = 'Ovo podešavanje određuje ishod učenja koji će ova stavka ocene predstavljati u knjizi ocena.';
$string['outcomeassigntocourse'] = 'Dodeli drugi ishod učenja ovom kursu';
$string['outcomecategory'] = 'Kreiraj ishode u kategoriji';
$string['outcomecategorynew'] = 'Nova kategorija';
$string['outcomeconfirmdelete'] = 'Da li ste sigurni da želite da obrišete ishod učenja "{$a}"?';
$string['outcomecreate'] = 'Dodaj novi ishod učenja';
$string['outcomedelete'] = 'Obriši ishod učenja';
$string['outcomefullname'] = 'Puno ime';
$string['outcomeitem'] = 'Stavka ishoda učenja';
$string['outcomeitemsedit'] = 'Uredi stavku ishoda učenja';
$string['outcomereport'] = 'Izveštaj o ishodima učenja';
$string['outcomes'] = 'Ishodi učenja';
$string['outcomescourse'] = 'Ishodi učenja korišćeni na kursu';
$string['outcomescoursecustom'] = 'Koriste se nestandardni ishodi učenja (ne mogu se ukloniti)';
$string['outcomescoursenotused'] = 'Ne koriste se standardni ishodi učenja';
$string['outcomescourseused'] = 'Koriste se standardni ishodi učenja (ne mogu se ukloniti)';
$string['outcomescustom'] = 'Nestandardni ishodi učenja';
$string['outcomeshortname'] = 'Skraćeni naziv';
$string['outcomesstandard'] = 'Standardni ishodi učenja';
$string['outcomesstandardavailable'] = 'Raspoloživi standardni ishodi učenja';
$string['outcomestandard'] = 'Standardni ishod učenja';
$string['outcomestandard_help'] = 'Standardni ishod učenja je dostupan u svim kursevima na sajtu.';
$string['overallaverage'] = 'Sveukupan prosek';
$string['overridden'] = 'Poništeno';
$string['overridden_help'] = 'Ako je označeno, ocene ne mogu više da se menjaju unutar pripadajuće aktivnosti.

Kada se ocena menja unutar izveštaja ocenjivača, polje za izmenu ocene je automatski označeno.
Međutim, oznaka se može ukloniti kako bi se se dozvolilo da ocena bude promenjena unutar pripadajuće aktivnosti.';
$string['overriddennotice'] = 'Vaša konačna ocena za ovu aktivnost je ručno podešena';
$string['overridecat'] = 'Dozvoli da kategorije ocena mogu ručno da se menjaju';
$string['overridecat_help'] = 'Isključivanje ovog podešavanja, onemogućava korisnike da menjaju kategorije ocena.';
$string['overridesitedefaultgradedisplaytype'] = 'Poništi podrazumevane vrednosti na nivou sajta';
$string['overridesitedefaultgradedisplaytype_help'] = 'Ako je označeno, mogu se podešavati slovne ocene i njihovi opsezi na nivou kursa, umesto da se koriste podrazumevana podešavanja na nivou sajta.';
$string['overrideweightofa'] = 'Izmeni ponder za {$a}';
$string['parentcategory'] = 'Nadređena kategorija';
$string['pctoftotalgrade'] = '% od ukupne ocene';
$string['percent'] = 'Procenat';
$string['percentage'] = 'Procenat';
$string['percentageletter'] = 'Procenat (slovo)';
$string['percentagereal'] = 'Procenat (realna vrednost)';
$string['percentascending'] = 'Sortiraj po procentima - rastući niz';
$string['percentdescending'] = 'Sortiraj po procentima - opadajući niz';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Pomak';
$string['plusfactor_help'] = 'Pomak je broj koji se dodaje svakoj oceni za ovu stavku, nakon primene multiplikatora.';
$string['plusfactorvalue'] = 'Ofset (dodatna) vrednost za {$a}';
$string['points'] = 'poena';
$string['pointsascending'] = 'Sortiraj po poenima - rastući niz';
$string['pointsdescending'] = 'Sortiraj po poenima - opadajući niz';
$string['positionfirst'] = 'Prvi';
$string['positionlast'] = 'Poslednji';
$string['preferences'] = 'Parametri';
$string['prefgeneral'] = 'Opšta podešavanja';
$string['prefletters'] = 'Slovne ocene i granice';
$string['prefrows'] = 'Specijalni redovi';
$string['prefshow'] = 'Prekidači prikaži/sakrij';
$string['previewrows'] = 'Pregled redova';
$string['privacy:metadata:categorieshistory'] = 'Dosije prethodnih verzija kategorija ocena';
$string['privacy:metadata:filepurpose'] = 'Datoteke povratnih informacija smeštene u knjizi ocena za korisnika.';
$string['privacy:metadata:grade_import_newitem'] = 'Privremena tabela za skladištenje novih naziva za grade_item iz uvoza ocena';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Jedinstveni grupni kôd za identifikaciju jednog grupnog uvoza';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Korisnik koji uvozi podatke';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Naziv nove stavke ocene';
$string['privacy:metadata:grade_import_values'] = 'Privremena tabela za uvoz ocena';
$string['privacy:metadata:grade_import_values:feedback'] = 'Povratne informacije uz ocenu';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Neobrađena vrednost ocene';
$string['privacy:metadata:grade_import_values:importcode'] = 'Jedinstveni grupni kôd za identifikaciju jednog grupnog uvoza';
$string['privacy:metadata:grade_import_values:importer'] = 'Korisnik koji uvozi podatke';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Označi ako su uvezene samo povratne informacije';
$string['privacy:metadata:grade_import_values:userid'] = 'Korisnik čije su ocene uvezene';
$string['privacy:metadata:grades'] = 'Dosije ocena';
$string['privacy:metadata:grades:aggregationstatus'] = 'Status sumiranja';
$string['privacy:metadata:grades:aggregationweight'] = 'Ponder u sumiranju';
$string['privacy:metadata:grades:feedback'] = 'Povratne informacije';
$string['privacy:metadata:grades:finalgrade'] = 'Ocena';
$string['privacy:metadata:grades:information'] = 'Dodatne informacije o oceni';
$string['privacy:metadata:grades:timemodified'] = 'Vreme kada je ocena poslednji put izmenjena';
$string['privacy:metadata:grades:userid'] = 'ID oznaka korisnika čija je ocena';
$string['privacy:metadata:grades:usermodified'] = 'ID oznaka korisnika koji je poslednji izmenio dosije';
$string['privacy:metadata:gradeshistory'] = 'Dosije ranije stečenih ocena';
$string['privacy:metadata:history:loggeduser'] = 'ID oznaka korisnika koji je bio prijavljen na sistem kada je objavljena nova  verzija ocena';
$string['privacy:metadata:history:timemodified'] = 'Vreme kada je objavljena nova  verzija ocena';
$string['privacy:metadata:itemshistory'] = 'Dosije ranijih verzija stavki za ocenjivanje';
$string['privacy:metadata:outcomes'] = 'Dosije ishoda';
$string['privacy:metadata:outcomes:timemodified'] = 'Vreme kada je zapis izmenjen';
$string['privacy:metadata:outcomes:usermodified'] = 'Korisnik koji je poslednji izmenio dosije';
$string['privacy:metadata:outcomeshistory'] = 'Dosije ranijih verzija ishoda';
$string['privacy:metadata:scale'] = 'Dosije skala';
$string['privacy:metadata:scale:timemodified'] = 'Vreme kada je zapis poslednji put izmenjen';
$string['privacy:metadata:scale:userid'] = 'Korisnik koji je poslednji izmenio dosije';
$string['privacy:metadata:scalehistory'] = 'Dosije prethodnih verzija skala';
$string['privacy:path:relatedtome'] = 'Povezano sa mnom';
$string['privacy:request:historyactiondelete'] = 'Obriši';
$string['privacy:request:historyactioninsert'] = 'Umetni';
$string['privacy:request:historyactionupdate'] = 'Ažuriraj';
$string['privacy:request:unknowndeletedgradeitem'] = 'Nepoznato (stavka ocene je obrisana)';
$string['profilereport'] = 'Izveštaj korisničkog profila';
$string['profilereport_help'] = 'Izveštaj o ocenama koji se koristi na stranici korisničkog profila.';
$string['publishing'] = 'Objavljivanje';
$string['publishingoptions'] = 'Opcije za objavljivanje ocena';
$string['quickfeedback'] = 'Brze povratne informacije';
$string['quickgrading'] = 'Brzo ocenjivanje';
$string['quickgrading_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno , za svaku ocenu se pojavljuje polje za unos teksta, što omogućava da se istovremeno uređuje veći broj ocena. Kada se klikne da na dugme za ažuriranje, promene su sačuvane i istaknute.

Imajte u vidu da je, prilikom uređivanja ocene u izveštaju ocenjivača, postavljena zastavica (indikator) izmene, što znači da ocena ne može više da se menja unutar pripadajuće aktivnosti.';
$string['range'] = 'Opseg';
$string['rangedecimals'] = 'Broj decimalnih mesta opsega';
$string['rangedecimals_help'] = 'Broj decimalnih mesta koji će biti prikazan za opseg .';
$string['rangesdecimalpoints'] = 'Decimale prikazane u opsezima';
$string['rangesdecimalpoints_help'] = 'Ovo podešavanje određuje broj decimalnih mesta koji će biti prikazan za svaki opseg odnosno da li se koristi (nasleđeno) podešavanje ukupnog broj decimalnih mesta za kategoriju ili za stavku ocene.';
$string['rangesdisplaytype'] = 'Tip prikaza opsega';
$string['rangesdisplaytype_help'] = 'Ovo podešavanje određuje da li se opseg prikazuje kao broj, procenat ili slovo, odnosno, da li će se koristiti tip prikaza za kategoriju ili za stavku ocene (nasleđeno).';
$string['rank'] = 'Rang';
$string['rawpct'] = 'Neobrađeni %';
$string['real'] = 'Realna vrednost';
$string['realletter'] = 'Realna vrednost (slovo)';
$string['realpercentage'] = 'Realna vrednost (procenat)';
$string['recalculatinggrades'] = 'Ocene se preračunavaju';
$string['recovergradesdefault'] = 'Povrati podrazumevane ocene';
$string['recovergradesdefault_help'] = 'Standardno, vraća stare ocene kada ponovo upisujete korisnika na kurs.';
$string['refreshpreview'] = 'Osveži pregled';
$string['regradeanyway'] = 'Ipak ponovo oceni';
$string['removeallcoursegrades'] = 'Obriši sve ocene';
$string['removeallcoursegrades_help'] = 'Ako je označeno sve stavke za ocenjivanje koje su ručno dodate u dnevnik biće obrisane, zajedno sa ocenama i podacima o prepisanim, isključenim, sakrivenim i zaključanim ocenama. Ostaće samo stavke za ocenjivanje koje su povezane sa aktivnostima na kursu.';
$string['removeallcourseitems'] = 'Obriši sve stavke i kategorije';
$string['removeallcourseitems_help'] = 'Ako je označeno sve stavke za ocenjivanje koje su ručno dodate u dnevnik biće obrisane, zajedno sa ocenama i podacima o prepisanim, isključenim, sakrivenim i zaključanim ocenama. Ostaće samo stavke za ocenjivanje koje su povezane sa aktivnostima na kursu.';
$string['report'] = 'Izveštaj';
$string['reportdefault'] = 'Podrazumevani izveštaj ({$a})';
$string['reportplugins'] = 'Dodaci za izveštaj';
$string['reportsettings'] = 'Podešavanje izveštaja';
$string['reprintheaders'] = 'Ponovni ispis zaglavlja';
$string['resetweights'] = 'Resetuj pondere za {$a->itemname}';
$string['resetweightsshort'] = 'Resetuj  težinu';
$string['respectingcurrentdata'] = 'ostavljajući trenutna podešavanja neizmenjena';
$string['rowpreviewnum'] = 'Broj redova za pregled';
$string['rowpreviewnum_help'] = 'Podaci za uvoz mogu biti pregledani pre potvrđivanja uvoza. Ovo podešavanje utvrđuje koliko redova se prikazuje u pregledu.';
$string['savechanges'] = 'Sačuvaj promene';
$string['savepreferences'] = 'Sačuvaj podešavanja';
$string['scaleconfirmdelete'] = 'Da li ste sigurni da želite da obrišete skalu "{$a}"?';
$string['scaledpct'] = 'Skalirani %';
$string['seeallcoursegrades'] = 'Pogledaj sve ocene kursa';
$string['select'] = 'Izaberi {$a}';
$string['selectalloroneuser'] = 'Izaberi sve ili nijednog korisnika';
$string['selectauser'] = 'Izaberi korisnika';
$string['selectdestination'] = 'Izaberi odredište za {$a}';
$string['separator'] = 'Graničnik';
$string['separator_help'] = 'Odaberite granični znak koji koristi CSV datoteka. (Uobičajeno je to zarez.)';
$string['sepcolon'] = 'Dvotačka';
$string['sepcomma'] = 'Zarez';
$string['sepsemicolon'] = 'Tačka i zarez';
$string['septab'] = 'Tabulator';
$string['setcategories'] = 'Podesi kategorije';
$string['setcategorieserror'] = 'Prvo morate da podesite kategorije za svoj kurs pre nego što im odredite pondere.';
$string['setgradeletters'] = 'Podesi slovne ocene';
$string['setpreferences'] = 'Podesi parametre';
$string['setting'] = 'Podešavanje';
$string['settings'] = 'Podešavanja';
$string['setweights'] = 'Podesi pondere';
$string['showactivityicons'] = 'Prikaži ikonice aktivnosti';
$string['showactivityicons_help'] = 'Ako je ova opcija omogućena, ikonice aktivnosti će biti prikazane pored naziva aktivnosti.';
$string['showallhidden'] = 'Prikaži skrivene';
$string['showallstudents'] = 'Prikaži sve polaznike';
$string['showanalysisicon'] = 'Prikaži ikonicu za analizu ocena';
$string['showanalysisicon_desc'] = 'Da li, standardno, prikazati ikonicu za analizu ocena. Ako modul aktivnost to podržava, ikonica za analizu ocena je povezana sa stranicom sa detaljnijim objašnjenjem ocene i kako je ona dobijena.';
$string['showanalysisicon_help'] = 'Ako modul aktivnost to podržava, ikonica za analizu ocena je povezana sa stranicom sa detaljnijim objašnjenjem ocene i kako je ona dobijena.';
$string['showaverage'] = 'Prikaži prosek';
$string['showaverage_help'] = 'Da li prikazati prosek kolone? Imajte u vidu da bi učesnici mogli da procene ocene drugih ako se prosek računa na osnovu manjeg broja ocena. Zbog brzine izvođenja, prosek je približan ukoliko zavisi od skrivenih stavki.';
$string['showaverages'] = 'Prikaži prosečne vrednosti kolona';
$string['showaverages_help'] = 'Ako je ova opcija omogućena, izvještaj ocenjivača će sadržati dodatni red u kojem će biti prikazan prosek (srednja vrednost) za svaku kategoriju i svaku stavku koja se ocenjuje.';
$string['showcalculations'] = 'Prikaži proračune';
$string['showcalculations_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno, za svaku stavku ocene i kategoriju  prikazuje se kalkulator, zajedno sa vizuelnim indikatorom da je stavka ocene izračunata.';
$string['showcontributiontocoursetotal'] = 'Prikaži doprinosi ukupnoj oceni na kursu';
$string['showcontributiontocoursetotal_help'] = 'Da li treba prikazati kolonu sa procentima koji pokazuju koliko svaka stavka ocene doprinosi ukupnom procentu korisnika na kursu (nakon što je primenjeno ponderisanje).';
$string['showeyecons'] = 'Prikaži ikonice prikaži/sakrij';
$string['showeyecons_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno, pored svake ocene se pojavljuje ikonica prikaži/sakrij, čime se kontroliše da li će polaznik moći da vidi svoje ocene.';
$string['showfeedback'] = 'Prikaži povratne informacije';
$string['showfeedback_help'] = 'Da li treba prikazati kolonu za povratne informacije.';
$string['showgrade'] = 'Prikaži ocene';
$string['showgrade_help'] = 'Da li treba prikazati kolonu za ocene.';
$string['showgroups'] = 'Prikaži grupe';
$string['showhiddenitems'] = 'Prikaži sakrivene stavke';
$string['showhiddenitems_help'] = 'Da li su sakrivene stavke ocena sakrivene u potpunosti ili su nazivi tih stavki vidljivi polaznicima?

* Prikaži sakriveno - nazivi sakrivenih stavki su prikazani, ali ocene polaznika nisu
* Sakriveno do - stavke su potpuno sakrivene do navedenog datuma nakon čega su u potpunosti vidljive.
* Ne prikazuj - sakrivene stavke su u potpunosti sakrivene';
$string['showhiddenuntilonly'] = 'Sakriveno do';
$string['showingaggregatesonly'] = 'Prikazuje samo zbirove';
$string['showingfullmode'] = 'Prikazuje pun prikaz';
$string['showinggradesonly'] = 'Prikazuje samo ocene';
$string['showlettergrade'] = 'Prikaži slovne ocene';
$string['showlettergrade_help'] = 'Da li treba prikazati kolonu za slovne ocene.';
$string['showlocks'] = 'Prikaži zaključavanja';
$string['showlocks_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno, pored svake ocene se prikazuje ikonica zaključaj/otključaj kojom se kontroliše da li ocene mogu automatski da se ažuriraju od strane pripadajuće aktivnosti.';
$string['shownohidden'] = 'Ne prikazuj';
$string['shownooutcomes'] = 'Sakrij ishode učenja';
$string['shownumberofgrades'] = 'Prikaži broj ocena u prosecima';
$string['shownumberofgrades_help'] = 'Ako je omogućena ova opcija, broj ocena, korišćenih prilikom izračunavanja proseka (srednje vrednosti), prikazan je u zagradi pored svakog proseka.';
$string['showonlyactiveenrol'] = 'Prikaži samo aktivne upise';
$string['showonlyactiveenrol_help'] = 'Ovo podešavanje određuje da li će u izveštaju iz knjige ocena biti vidljivi samo upisani korisnici koji su aktivni. Ako je podešavanje omogućeno suspendovani korisnici neće biti prikazani u knjizi ocena.';
$string['showpercentage'] = 'Prikaži procenat';
$string['showpercentage_help'] = 'Da li prikazati procentualnu vrednost za svaku stavku ocene?';
$string['showquickfeedback'] = 'Prikaži brze povratne informacije';
$string['showquickfeedback_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno, pored svake ocene prikazuje se polje, sa isprekidanim ivicama, za unos povratnih informacija. što omogućava da se istovremeno uređuju povratne informacije za veći broj ocena. Kada se klikne da na dugme za ažuriranje, promene su sačuvane i istaknute.

Imajte u vidu da je, prilikom uređivanja povratnih informacija u izveštaju ocenjivača, postavljena zastavica (indikator) izmene, što znači da povratne informacije ne mogu više da se menjaju unutar pripadajuće aktivnosti';
$string['showrange'] = 'Prikaži opsege';
$string['showrange_help'] = 'Da li treba prikazati kolonu za opseg.';
$string['showranges'] = 'Prikaži opsege';
$string['showranges_help'] = 'Ako je ova opcija omogućena, izveštaj ocenjivača će sadržati dodatni red u kojem će biti prikazan opseg za svaku kategoriju i stavku koja se ocenjuje.';
$string['showrank'] = 'Prikaži rang';
$string['showrank_help'] = 'Da li prikazati poziciju polaznika u odnosu na ostale učesnike za svaku stavku ocene.';
$string['showuserimage'] = 'Prikaži slike iz korisničkih profila';
$string['showuserimage_help'] = 'Da li prikazati sliku korisnika pored njegovog imena u izvešataju ocenjivača?';
$string['showverbose'] = 'Prikaži {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Prikaži pondere';
$string['showweight_help'] = 'Da li treba prikazati kolonu za pondere ocena.';
$string['simpleview'] = 'Pojedinačni prikaz';
$string['singleview'] = 'Pojedinačni prikaz za {$a}';
$string['sitewide'] = 'Na celom sajtu';
$string['sort'] = 'sortiraj';
$string['sortasc'] = 'Sortiraj u rastućem nizu';
$string['sortbyfirstname'] = 'Sortiraj po imenu';
$string['sortbylastname'] = 'Sortiraj po prezimenu';
$string['sortdesc'] = 'Sortiraj u opadajućem nizu';
$string['standarddeviation'] = 'Standardna devijacija';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Statistika';
$string['student'] = 'Polaznik';
$string['studentsperpage'] = 'Broj polaznika po strani';
$string['studentsperpage_help'] = 'Ovo podešavanje određuje broj polaznika koji će biti prikazan na svakoj stranici izveštaja ocenjivača';
$string['studentsperpagereduced'] = 'Maksimalan broj studenata po stranici je smanjen sa {$a->originalstudentsperpage} na {$a->studentsperpage}. Razmislite o povećanju vrednosti za PHP podešavanje max_input_vars iz {$a->maxinputvars}.';
$string['subcategory'] = 'Normalna kategorija';
$string['submissions'] = 'Predato';
$string['submittedon'] = 'Predato: {$a}';
$string['sumofgradesupgradedgrades'] = 'Napomena: Agregacioni metod "Suma ocena" je izmenjena u "Prirodni" kao deo nadogradnje sajta. Kako je "Suma ocena" prethodno korišćena na ovom kursu preporučuje se da pregledate ove izmene u knjizi ocena.';
$string['switchtofullview'] = 'Pređi na potpun prikaz';
$string['switchtosimpleview'] = 'Pređi na jednostavan prikaz';
$string['tabs'] = 'Kartice';
$string['topcategory'] = 'Nadkategorija';
$string['total'] = 'Ukupno';
$string['totalweight100'] = 'Ukupni ponder je jednak 100';
$string['totalweightnot100'] = 'Ukupni ponder nije jednak 100';
$string['turnfeedbackoff'] = 'Isključi povratne informacije';
$string['turnfeedbackon'] = 'Uključi povratne informacije';
$string['typenone'] = 'Nijedan';
$string['typescale'] = 'Skala';
$string['typescale_help'] = 'Ovo podešavanje određuje skalu koja se koristi kada se ocenjivanje vrši pomoću skala. Skala za ocenjivanje aktivnosti se postavlja na stranici za podešavanje te aktivnosti.';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Vrednost';
$string['uncategorised'] = 'Nekategorisano';
$string['unchangedgrade'] = 'Ocena je nepromenjena';
$string['unenrolledusersinimport'] = 'Ovaj uvoz je uključio sledeće ocene za korisnike koji trenutno nisu upisani na ovaj kursu: {$a}';
$string['unlimitedgrades'] = 'Neograničene ocene';
$string['unlimitedgrades_help'] = 'Standardno, ocene su ograničene maksimalnom i minimalnom vrednošću stavke koja se ocenjuje. Ako se omogući ovo podešavanja ukida se to ograničenje i dozvoljava se da ocene veće od 100% budu direktno unete u knjigu ocena.';
$string['unlock'] = 'Otključaj';
$string['unlockverbose'] = 'Otključaj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Nekorišćeno';
$string['updatedgradesonly'] = 'Izvezi samo nove ili ažurirane ocene';
$string['upgradedgradeshidemessage'] = 'Odbaci obaveštenje';
$string['upgradedminmaxrevertmessage'] = 'Poništi izmene';
$string['uploadgrades'] = 'Pošalji ocene';
$string['useadvanced'] = 'Koristi napredne opcije';
$string['usedcourses'] = 'Korišćeni kursevi';
$string['usedgradeitem'] = 'Korišćena stavka ocene';
$string['usenooutcome'] = 'Ne koristi ishode učenja';
$string['usenoscale'] = 'Bez skala';
$string['usepercent'] = 'Koristi procente';
$string['user'] = 'Korisnik';
$string['userenrolmentsuspended'] = 'Upis korisnika je suspendovan';
$string['userfields_show'] = 'Prikaži korisnička polja';
$string['userfields_show_help'] = 'Prikaži dodatna korisnička polja kao šti su e-adresa u iveštaju ocenjivača. Posebna polja koja se prikazuju su pod kontrolom podešavanja sajta showuseridentity';
$string['usergrade'] = 'Korisnik {$a->fullname} ({$a->useridnumber}) za stavku {$a->gradeidnumber}';
$string['userid'] = 'Identifikator korisnika';
$string['useridnumberwarning'] = 'Korisnici bez ID broja isključeni su iz izvoza pošto ne mogu da budu uvezeni.';
$string['usermappingerror'] = 'Грешка приликом мапирања корисника: није могуће пронаћи корисника са пољем {$a->field} које има вредност "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Korisnik nije član tekuće grupe.';
$string['usermappingerrormultipleusersfound'] = 'Greška prilikom mapiranja korisnika: pronađeno je više korisnika sa poljem  {$a->field} koje ima vrednost "{$a->value}". Molimo vas, da za mapiranje iskoristite polje koje je više jedinstveno.';
$string['usermappingerrorusernotfound'] = 'Грешка приликом мапирања корисника: Није могуће пронаћи корисника,';
$string['userpreferences'] = 'Korisnička podešavanja';
$string['useweighted'] = 'Koristi ponderisane vrednosti';
$string['verbosescales'] = 'Detaljne skale';
$string['verbosescales_help'] = 'Verbalna skala koristi reči umesto brojeva. Postavite na "Da" ako želite da se uvezu i numeričke i verbalne skale. Postavite na "Ne" za uvoz samo numeričkih skala.';
$string['viewbygroup'] = 'Grupa';
$string['viewgrades'] = 'Pogledaj ocene';
$string['weight'] = 'Ponder';
$string['weight_help'] = 'Vrednost koja se koristi za određivanje relativne vrednosti više stavki ocene unutar kategorije ili kursa.';
$string['weightcourse'] = 'Koristi ponderisane ocene za kurs';
$string['weightedascending'] = 'Sortiraj prema ponderisanom procentu - rastući niz';
$string['weighteddescending'] = 'Sortiraj prema ponderisanom procentu - opadajući niz';
$string['weightedpct'] = 'ponderisani %';
$string['weightedpctcontribution'] = 'doprinos ponderisanih % u ukupnoj oceni';
$string['weightofa'] = 'Ponder od {$a}';
$string['weightorextracredit'] = 'Ponder ili dodatni bodovi';
$string['weightoverride'] = 'podešavanje pondera';
$string['weightoverride_help'] = 'Isključite ovo da biste ponovo postavili težinu stavke za ocenjivanje na njenu automatski izračunatu vrednost. Uključivanje ove opcije bi sprečilo automatsko prilagođavanje težine.';
$string['weights'] = 'Ponderi';
$string['weightsadjusted'] = 'Vaši ponderi su podešeni na ukupnu ocenu 100';
$string['weightsedit'] = 'Uredi ponder i dodatne bodove';
$string['weightuc'] = 'Izračunati ponder';
$string['writinggradebookinfo'] = 'Zapisivanje podešavanja knjige ocena';
$string['xml'] = 'XML';
$string['yes'] = 'Da';
$string['yourgrade'] = 'Vaša ocena';
