<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'sr_lt', version '3.9'.
 *
 * @package     feedback
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Dodaj pitanje';
$string['add_pagebreak'] = 'Dodaj prelom stranice';
$string['adjustment'] = 'Poravnanje';
$string['after_submit'] = 'Nakon predaje upitnika';
$string['allowfullanonymous'] = 'Dozvoli potpunu anonimnost';
$string['analysis'] = 'Analiza';
$string['anonymous'] = 'Anonimni upitnik';
$string['anonymous_edit'] = 'Da li je upitnik anoniman?';
$string['anonymous_entries'] = 'Anonimni odgovori ({$a})';
$string['anonymous_user'] = 'Anonimni korisnik';
$string['answerquestions'] = 'Odgovorite na pitanja';
$string['append_new_items'] = 'Dodaj nova pitanja';
$string['autonumbering'] = 'Automatska numeracija pitanja';
$string['autonumbering_help'] = 'Uključuje ili isključuje automatsko numerisanje pitanja';
$string['average'] = 'Prosečno';
$string['bold'] = 'Podebljano';
$string['calendarend'] = '{$a} se zatvara';
$string['calendarstart'] = '{$a} se otvara';
$string['cannotaccess'] = 'Ovom upitniku možete pristupiti samo unutar nekog kursa';
$string['cannotsavetempl'] = 'Čuvanje šablona nije dozvoljeno';
$string['captcha'] = 'Captcha upit';
$string['captchanotset'] = 'Captcha upit nije podešen';
$string['check'] = 'Višestruki izbor - više odgovora';
$string['check_values'] = 'Mogući odgovori';
$string['checkbox'] = 'Višestruki izbor - dozvoljeno više odgovora (polja za potvrdu)';
$string['choosefile'] = 'Izaberi datoteku';
$string['chosen_feedback_response'] = 'Izabrani odgovori iz upitnika';
$string['closebeforeopen'] = 'Naveli ste datum završetka pre datuma početka.';
$string['complete_the_form'] = 'Odgovori na pitanja';
$string['completed'] = 'Završeno';
$string['completed_feedbacks'] = 'Analiza odgovora';
$string['completedon'] = 'Završeno dana {$a}';
$string['completionsubmit'] = 'Tretiraj kao završenu aktivnost ako je upitnik predat';
$string['configallowfullanonymous'] = 'Ako je ova opcija postavljena na \'da\' korisnici mogu da popune upitnik na naslovnoj stranici sajta bez zahteva da se prijave na sistem.';
$string['confirmdeleteentry'] = 'Da li ste sigurni da želite da obrišete ovaj unos?';
$string['confirmdeleteitem'] = 'Da li ste sigurni da želite da obrišete ovo pitanje (element upitnika)?';
$string['confirmdeletetemplate'] = 'Da li ste sigurni da želite obrisati ovaj šablon?';
$string['confirmusetemplate'] = 'Da li ste sigurni da želite koristiti ovaj šablon?';
$string['continue_the_form'] = 'Nastavi sa odgovaranjem na pitanja';
$string['count_of_nums'] = 'Broj cifara';
$string['courseid'] = 'ID oznaka kursa';
$string['creating_templates'] = 'Sačuvaj ova pitanja kao novi šablon';
$string['delete_entry'] = 'Obriši unos';
$string['delete_item'] = 'Obriši pitanje';
$string['delete_old_items'] = 'Obriši stara pitanja';
$string['delete_pagebreak'] = 'Obriši prelom stranice';
$string['delete_template'] = 'Obriši šablon';
$string['delete_templates'] = 'Obriši šablone';
$string['depending'] = 'Zavisna pitanja';
$string['depending_help'] = 'Moguće je da zavisna pitanja prikazujete u zavisnosti od  odgovora na druga pitanja.<br />
<strong>Evo primera</strong><br />
<ul>
<li>
Prvo dodajte pitanje od čijeg odgovora zavisi drugo pitanje.
</li>
<li>Zatim dodajte prelom stranice.</li>
<li>U sledećem koraku dodajte pitanje koje zavisi od vrednosti odgovora na prethodno pitanje. Odaberite neku od stavki sa liste obeležene oznakom "Zavisno pitanje" i upišite traženu vrednost u tekstualno polje obeležene oznakom "Zavisni odgovor"
.</li>
 </ul>
<strong> Struktura pitanja bi trebalo da izgleda ovako:</strong>
<ol>
<li>Pitanje P1: Da li imate automobil? O: da/ne</li>
<li>Prelom stranice</li>
<li>Pitanje P2: Koje boje je Vaš automobil?<br /> (ovo pitanje zavisi od  pitanja 1 sa odgovorom = da)</li> <li>Pitanje P3: Zašto nemate automobil?<br /> (ovo pitanje zavisi od pitanja 1 sa odgovorom = ne)</li> <li> ... druga pitanja</li> </ol>';
$string['dependitem'] = 'Zavisno pitanje';
$string['dependvalue'] = 'Zavisni odgovor';
$string['description'] = 'Opis';
$string['do_not_analyse_empty_submits'] = 'Izostavi iz analize nepopunjene upitnike';
$string['downloadresponseas'] = 'Preuzmi sve odgovore kao:';
$string['drop_feedback'] = 'Ukloni iz ovog kursa';
$string['dropdown'] = 'Višestruki izbor - dozvoljen jedan odgovor (padajući meni)';
$string['dropdown_values'] = 'Odgovori';
$string['dropdownlist'] = 'Višestruki izbor - jedan odgovor (padajući meni)';
$string['dropdownrated'] = 'Padajući meni (rangirano)';
$string['edit_item'] = 'Uredi pitanje';
$string['edit_items'] = 'Uredi pitanja';
$string['email_notification'] = 'Omogući slanje obaveštenja o predatim upitnicima';
$string['email_notification_help'] = 'Ako je ovo podešavanje omogućeno, nastavnici, nakon što je upitnik predat, dobijaju obaveštenje o tome e-poštom.';
$string['emailteachermail'] = '{$a->username} je popunio/la upitnik: \'{$a->feedback}\'

Možete ga pogledati na sledećoj adresi:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} je popunio/la upitnik : <i>\'{$a->feedback}\'</i></p>
<p>Upitnik je <a href="{$a->url}">dostupan na sajtu</a>.</p>';
$string['entries_saved'] = 'Vaši odgovori su sačuvani. Hvala!';
$string['eventresponsedeleted'] = 'Odgovor obrisan';
$string['eventresponsesubmitted'] = 'Odgovor predat';
$string['export_questions'] = 'Izvezi pitanja';
$string['export_to_excel'] = 'Izvezi u Excel';
$string['feedback:addinstance'] = 'Dodaj novi upitnik';
$string['feedback:complete'] = 'Popunite upitnik';
$string['feedback:createprivatetemplate'] = 'Kreiraj privatni šablon';
$string['feedback:createpublictemplate'] = 'Kreiraj javni šablon';
$string['feedback:deletesubmissions'] = 'Obriši popunjene upitnika';
$string['feedback:deletetemplate'] = 'Obriši šablon';
$string['feedback:edititems'] = 'Uredi pitanja';
$string['feedback:mapcourse'] = 'Poveži kurseve sa opštim upitnicima';
$string['feedback:receivemail'] = 'Dobiti obaveštenje putem e-poruke';
$string['feedback:view'] = 'Prikaz upitnika';
$string['feedback:viewanalysepage'] = 'Pogledaj stranicu sa analizom rezultata nakon ispunjavanja upitnika';
$string['feedback:viewreports'] = 'Prikaz izveštaja';
$string['feedback_is_not_for_anonymous'] = 'Upitnik nije za anonimne korisnike';
$string['feedback_is_not_open'] = 'Upitnik nije otvoren';
$string['feedbackclose'] = 'Upitnik dostupan do';
$string['feedbackcompleted'] = '{$a->username} je ispunio/la {$a->feedbackname}';
$string['feedbackopen'] = 'Upitnik dostupan od';
$string['file'] = 'Datoteka';
$string['filter_by_course'] = 'Filtriraj prema kursu';
$string['handling_error'] = 'Došlo je do greške prilikom obrade podataka modula \'Upitnik\'';
$string['hide_no_select_option'] = 'Sakrij opciju "Nije izabrano"';
$string['horizontal'] = 'Horizontalno';
$string['import_questions'] = 'Uvezi pitanja';
$string['import_successfully'] = 'Uvoz uspešan';
$string['importfromthisfile'] = 'Uvezi iz ove datoteke';
$string['includeuserinrecipientslist'] = 'Uključite {$a}  na spisak primalaca';
$string['indicator:cognitivedepth'] = 'Upitnik (Feedback) - kognitivni aspekt';
$string['indicator:cognitivedepth_help'] = 'Ovaj indikator se zasniva na kognitivnoj dubini koju je polaznik postigao u okviru aktivnosti \'Upitnik (Feedback)\'.';
$string['indicator:cognitivedepthdef'] = 'Upitnik (Feedback) - kognitivni aspekt';
$string['indicator:cognitivedepthdef_help'] = 'Učesnik je postigao ovaj procenat kognitivnog angažmana koji nude aktivnosti Upitnik (Feedback) tokom ovog intervala analize (Nivoi = Bez pregleda, Pregled, Predaja odgovora)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Upitnik (Feedback) - socijalni aspekt';
$string['indicator:socialbreadth_help'] = 'Ovaj indikator se zasniva na obimu socijalnih interakcija koji je polaznik postigao u okviru aktivnosti \'Upitnik (Feedback)\'.';
$string['indicator:socialbreadthdef'] = 'Upitnik (Feedback) - socijalni aspekt';
$string['indicator:socialbreadthdef_help'] = 'Učesnik je postigao ovaj procenat socijalnog angažmana koji nude aktivnosti Upitnik (Feedback) tokom ovog intervala analize (Nivoi = Bez učešća, Učesnik sâm, Učesnik sa drugima)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Informacije';
$string['infotype'] = 'Tip informacije';
$string['insufficient_responses'] = 'nedovoljno odgovora';
$string['insufficient_responses_for_this_group'] = 'Ne postoji dovoljno odgovora za ovu grupu';
$string['insufficient_responses_help'] = 'Da bi upitnik ostao anoniman, moraju se prikupiti bar dva odgovora.';
$string['item_label'] = 'Oznaka pitanja';
$string['item_name'] = 'Pitanje';
$string['label'] = 'Natpis';
$string['labelcontents'] = 'Sadržaji';
$string['mapcourse'] = 'Poveži upitnik sa kursevima';
$string['mapcourse_help'] = 'Standardno, obrasci upitnika koji su kreirani na početnoj stranici sajta dostupni su svima i pojaviće na svim kursevima koji koriste blok za upitnik. Korišćenje ovog bloka možete učiniti obaveznim ukoliko ga učinite "lepljivim" (<i>sticky</i>). Takođe možete da ograničite kurseve u kojima će se upitnik pojavljivati tako što ćete ga povezati sa određenim kursevima.';
$string['mapcourseinfo'] = 'Ovo je upitnik na nivou sajta dostupan svim kursevima koji koriste blok za upitnik. Ipak, možete ograničiti kurseve u kojima će se upitnik pojavljivati tako što ćete ih povezati. Potražite kurs i povežite ga sa ovim upitnikom.';
$string['mapcoursenone'] = 'Nijedan kurs nije povezan sa upitnikom. Upitnik je dostupan svim kursevima';
$string['mapcourses'] = 'Poveži upitnik sa kursevima';
$string['mappedcourses'] = 'Povezani kursevi';
$string['mappingchanged'] = 'Mapiranje kursa je izmenjeno';
$string['maximal'] = 'Maksimalno';
$string['messageprovider:message'] = 'Podsetnik za upitnik';
$string['messageprovider:submission'] = 'Obaveštenja o upitniku';
$string['minimal'] = 'Minimalno';
$string['mode'] = 'Vrsta upitnika';
$string['modulename'] = 'Upitnik';
$string['modulename_help'] = 'Modul aktivnosti \'Upitnik\' omogućava predavačima da kreiraju sopstvene, namenski prilagođene, upitnike za prikupljanje povratnih informacija od učesnika, koristeći različite tipove pitanja uključujući višestruki izbor, da/ne ili otvorena pitanja

Upitnici, tj. odgovori korisnika, mogu da budu anonimni, ukoliko se želi, a rezultati mogu biti prikazani svim učesnicima, ili samo predavačima. Upitnike na naslovnoj stranici sajta mogu da popunjavaju i korisnici koji nisu prijavljeni na sistem

Upitnici mogu da se koriste:

* za evaluaciju kursa, kako bi se njegov sadržaj unapredio za buduće učesnike
* da bi se omogućilo korisnicima da se prijave za različite događaje, module kursa itd.
* za anketiranje posetilaca o izboru kurseva, politici škole itd.
* za anonimno anketiranje i prikupljanje različite vrste podataka';
$string['modulename_link'] = 'mod/feedback/view';
$string['modulenameplural'] = 'Upitnici';
$string['move_item'] = 'Premesti ovo pitanje';
$string['multichoice'] = 'Višestruki izbor';
$string['multichoice_values'] = 'Vrednosti za višestruki izbor';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'Višestruki izbor (rangirano)';
$string['multichoicetype'] = 'Tip višestrukog izbora';
$string['multiplesubmit'] = 'Dozvoli višestruko popunjavanje upitnika';
$string['multiplesubmit_help'] = 'Ako je ovo podešavanje omogućeno za anonimne upitnike, korisnici će moći da popune upitnik neograničen broj puta.';
$string['name'] = 'Naziv upitnika';
$string['name_required'] = 'Naziv je obavezan';
$string['nameandlabelformat'] = '({$a->label}) {$a->name}';
$string['next_page'] = 'Sledeća stranica';
$string['no_handler'] = 'Nema definisane procedure za obradu događaja za';
$string['no_itemlabel'] = 'Nema oznake pitanja';
$string['no_itemname'] = 'Ne postoji naziv stavke';
$string['no_items_available_yet'] = 'Još nije postavljeno nijedno pitanje';
$string['no_templates_available_yet'] = 'Još nema dostupnih šablona';
$string['non_anonymous'] = 'Ime korisnika biće zapisano i prikazano zajedno sa odgovorima';
$string['non_anonymous_entries'] = 'Neanonimni odgovori ({$a})';
$string['non_respondents_students'] = 'Polaznici koji nisu odgovorili na upitnik ({$a})';
$string['not_completed_yet'] = 'Još nije završeno';
$string['not_selected'] = 'Nije izabrano';
$string['not_started'] = 'Nije započeto';
$string['numberoutofrange'] = 'Broj izvan opsega';
$string['numeric'] = 'Brojčani odgovor';
$string['numeric_range_from'] = 'Rangiraj od';
$string['numeric_range_to'] = 'Rangiraj do';
$string['of'] = 'od';
$string['oldvaluespreserved'] = 'Sva stara pitanja i dodeljene vrednosti biće sačuvani';
$string['oldvalueswillbedeleted'] = 'Trenutno postojeća pitanja i svi odgovori biće obrisani.';
$string['only_one_captcha_allowed'] = 'U upitniku je dozvoljen samo jedan captcha upit';
$string['openafterclose'] = 'Naveli ste datum otvaranja nakon datuma zatvaranja';
$string['overview'] = 'Pregled';
$string['page'] = 'Stranica';
$string['page-mod-feedback-x'] = 'Bilo koja stranica modula \'Upitnik\'';
$string['page_after_submit'] = 'Poruka koja će biti prikazana korisniku nakon što popuni upitnik';
$string['pagebreak'] = 'Prelom stranice';
$string['pluginadministration'] = 'Administracija upitnika';
$string['pluginname'] = 'Upitnik';
$string['position'] = 'Pozicija';
$string['previous_page'] = 'Prethodna stranica';
$string['privacy:metadata:completed'] = 'Zapis o predatim ispunjenim upitnicima';
$string['privacy:metadata:completed:anonymousresponse'] = 'Da li će se predati ispunjeni upitnik koristiti anonimno.';
$string['privacy:metadata:completed:timemodified'] = 'Vreme kada je predati upitnik poslednji put izmenjen.';
$string['privacy:metadata:completed:userid'] = '
ID oznaka korisnika koji je popunio upitnik.';
$string['privacy:metadata:completedtmp'] = 'Zapis o predatim upitnicima koji se još ispunjavaju.';
$string['privacy:metadata:value'] = 'Zapis o odgovoru na pitanje.';
$string['privacy:metadata:value:value'] = 'Odabrani odgovor.';
$string['privacy:metadata:valuetmp'] = 'Zapis o odgovoru na pitanje u okviru upitnika koji se još ispunjava.';
$string['public'] = 'Javni šablon';
$string['question'] = 'Pitanje';
$string['questionandsubmission'] = 'Podešavanja pitanja i upitnika';
$string['questions'] = 'Pitanja';
$string['questionslimited'] = 'Prikazuje se samo prvih {$a} pitanja, pogledajte pojedinačne odgovore ili preuzmite tabelu sa podacima da biste ih videli sva.';
$string['radio'] = 'Višestruki izbor - jedan odgovor';
$string['radio_values'] = 'Odgovori';
$string['ready_feedbacks'] = 'Spremni upitnici';
$string['required'] = 'Obavezno';
$string['resetting_data'] = 'Poništi odgovore na upitnik';
$string['resetting_feedbacks'] = 'Resetuj upitnike';
$string['response_nr'] = 'Broj odgovora';
$string['responses'] = 'Odgovori';
$string['responsetime'] = 'Vreme odgovora';
$string['save_as_new_item'] = 'Sačuvaj kao novo pitanje';
$string['save_as_new_template'] = 'Sačuvaj kao novi šablon';
$string['save_entries'] = 'Pošalji svoje odgovore';
$string['save_item'] = 'Sačuvaj pitanje';
$string['saving_failed'] = 'Nije sačuvano';
$string['search:activity'] = 'Upitnik (Feedback) - informacije o aktivnosti';
$string['search_course'] = 'Pretraži kurs';
$string['searchcourses'] = 'Pretraži kurseve';
$string['searchcourses_help'] = 'Potražite oznaku ili naziv kursa (kurseva) koji želite da povežete sa ovim upitnikom.';
$string['selected_dump'] = 'Izabrani indeksi varijable $SESSION  prikazani su niže:';
$string['send'] = 'Pošalji';
$string['send_message'] = 'Pošalji obaveštenje';
$string['show_all'] = 'Prikaži sve';
$string['show_analysepage_after_submit'] = 'Prikaži stranicu sa analizom odgovora';
$string['show_entries'] = 'Prikaži odgovore';
$string['show_entry'] = 'Prikaži odgovor';
$string['show_nonrespondents'] = 'Prikaži korisnike koje nisu odgovorili na upitnik';
$string['site_after_submit'] = 'Sajt za posle predaje rešenja';
$string['sort_by_course'] = 'Poređaj prema kursu';
$string['started'] = 'Započeto';
$string['startedon'] = 'Započeto dana {$a}';
$string['subject'] = 'Tema';
$string['switch_item_to_not_required'] = 'Prebaci na: odgovor nije obavezan';
$string['switch_item_to_required'] = 'Prebaci na: odgovor je obavezan';
$string['template'] = 'Šablon';
$string['template_deleted'] = 'Šablon obrisan';
$string['template_saved'] = 'Šablon je sačuvan';
$string['templates'] = 'Šabloni';
$string['textarea'] = 'Duži tekstualni odgovor';
$string['textarea_height'] = 'Broj linija';
$string['textarea_width'] = 'Širina';
$string['textfield'] = 'Kratak tekstualni odgovor';
$string['textfield_maxlength'] = 'Maksimalno dozvoljen broj znakova';
$string['textfield_size'] = 'Širina tekstualnog polja';
$string['there_are_no_settings_for_recaptcha'] = 'Ne postoje podešavanja za captcha upit';
$string['this_feedback_is_already_submitted'] = 'Već ste popunili ovaj upitnik.';
$string['typemissing'] = 'Nedostaje vrednost "tip"';
$string['update_item'] = 'Sačuvaj promene u pitanju';
$string['url_for_continue'] = 'Link ka sledećoj aktivnosti';
$string['url_for_continue_help'] = 'Nakon što je predao upitnik, korisnik se prikazuje dugme za nastavak, koje ga vodi na glavnu stranicu kursa. Alternativno, dugme za nastavak može da vodi do sledeće aktivnosti, ako se ovde unese URL adresa te aktivnosti.';
$string['use_one_line_for_each_value'] = 'Upotrebi jedan red za svaki odgovor!';
$string['use_this_template'] = 'Upotrebi ovaj šablon';
$string['using_templates'] = 'Upotrebi šablon';
$string['vertical'] = 'Vertikalno';
