<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'sr_lt', version '3.9'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'O';
$string['Afull'] = 'Odsutan/na';
$string['Eacronym'] = 'OO';
$string['Efull'] = 'Opravdano odsutan/na';
$string['Lacronym'] = 'Z';
$string['Lfull'] = 'Zakasnio/la';
$string['Pacronym'] = 'P';
$string['Pfull'] = 'Prisutan/na';
$string['absenteereport'] = 'Izveštaj o odsustvu';
$string['acronym'] = 'Akronim';
$string['add'] = 'Dodaj';
$string['addedrecip'] = 'Dodat {$a} novi primalac';
$string['addedrecips'] = 'Dodato novih primalaca: {$a}';
$string['addmultiplesessions'] = 'Višestruke sesije';
$string['addsession'] = 'Dodaj sesiju';
$string['adduser'] = 'Dodaj korisnika';
$string['addwarning'] = 'Dodaj upozorenje';
$string['all'] = 'Sve';
$string['allcourses'] = 'Svi kursevi';
$string['allpast'] = 'Sve prethodne';
$string['allsessions'] = 'Sve sesije';
$string['allsessionstotals'] = 'Ukupno za izabrane sesije';
$string['attendance:addinstance'] = 'Dodavanje nove aktivnosti \'Prisustvo\'';
$string['attendance:canbelisted'] = 'Pojavljuje se u spisku';
$string['attendance:changeattendances'] = 'Promena podataka o prisustvu';
$string['attendance:changepreferences'] = 'Promena parametara';
$string['attendance:export'] = 'Izvoz izveštaja';
$string['attendance:manageattendances'] = 'Upravljanje \'Prisustvima\'';
$string['attendance:managetemporaryusers'] = 'Upravljanje privremenim korisnicima';
$string['attendance:takeattendances'] = 'Evidentiranje prisustva';
$string['attendance:view'] = 'Prikaz prisustva';
$string['attendance:viewreports'] = 'Prikaz izveštaja';
$string['attendance:viewsummaryreports'] = 'Prikaz skraćenih izveštaja o prisustvu na kursevima';
$string['attendance:warningemails'] = 'Pretplata na e-poruke sa spiskom odsutnih korisnika';
$string['attendance_already_submitted'] = 'Vaše prisustvo je već podešeno.';
$string['attendance_no_status'] = 'Nijedan ispravan status nije bio dostupan - možda ste zakasnili da evidentirate prisustvo.';
$string['attendancedata'] = 'Podaci o prisustvu';
$string['attendancefile'] = 'Datoteka o prisustvu (csv format)';
$string['attendancefile_help'] = 'Datoteka mora biti CSV datoteka sa zaglavljem i poljima koja identifikuju korisnika i vreme kada je prisustvo evidentirano, npr. "adresa e-pošte" (email,scantime) ili "korisničko ime,vreme" (username,time)';
$string['attendanceforthecourse'] = 'Prisustvo za kurs';
$string['attendancegrade'] = 'Ocena za prisustvo';
$string['attendancenotset'] = 'Morate da označite svoje prisustvo';
$string['attendancenotstarted'] = 'Prisustvo nastavi još uvek nije počelo za ovaj kurs';
$string['attendancepercent'] = 'Procenat prisustva';
$string['attendancereport'] = 'Izveštaj o prisustvu';
$string['attendanceslogged'] = 'Prisustva evidentirana';
$string['attendancestaken'] = 'Prisustva obeležena';
$string['attendancesuccess'] = 'Prisustvo je uspešno obeleženo';
$string['attendanceupdated'] = 'Podaci o prisustvu su uspešno ažurirani';
$string['attforblockdirstillexists'] = 'stari direktorijum mod/attforblock directory još uvek postoji - morate da obrišete ovaj direktorijum na vašem serveru pre nego što pokrenete ovu nadogradnju.';
$string['attrecords'] = 'Evidencija o prisustvu';
$string['autoassignstatus'] = 'Automatski izaberite najviši dostupni status';
$string['autoassignstatus_help'] = 'Ako je ovo izabrano, polaznicima će automatski biti dodeljena najviša dostupna ocena.';
$string['automark'] = 'Automatsko obeležavanje';
$string['automark_help'] = 'Omogućava da se obeležavanje završi automatski.
Ako je podešeno na "Da", polaznici će biti automatski obeleženi u zavisnosti od njihovog prvog pristupa kursu.
Ako je podešeno na "Podesi kao neoznačeno na kraju sesije", za sve polaznike koji nisu označili svoje prisustvo, ono će biti podešeno kao neoznačeno.';
$string['automarkall'] = 'Da';
$string['automarkclose'] = 'Podesi kao neoznačeno na kraju sesije';
$string['automarktask'] = 'Provera da li postoje sesije koje zahtevaju automatsko obeležavanje';
$string['autorecorded'] = 'sistemsko automatsko obeležavanje prisustva';
$string['averageattendance'] = 'Prosečno prisustvo';
$string['averageattendancegraded'] = 'Prosečno prisustvo';
$string['backtoparticipants'] = 'Nazad na spisak učesnika';
$string['below'] = 'Ispod {$a}%';
$string['calclose'] = 'Zatvori';
$string['calendarevent'] = 'Kreirajte događaj u kalendaru za sesiju';
$string['calendarevent_help'] = 'Ako je omogućeno, u kalendaru će biti kreiran događaj za ovu sesiju.
Ako je onemogućeno, svi postojeći događaji u kalendaru za ovu sesiju biće obrisani.';
$string['caleventcreated'] = 'Unos događaja u kalendar za ovu sesiju je uspešno izvršen';
$string['caleventdeleted'] = 'Uspešno je obrisan unos u kalendar za sesiju';
$string['calmonths'] = 'Januar, Februar, Mart, April, Maj, Jun, Jul, Avgust, Septembar, Oktobar, Novembar, Decembar';
$string['calshow'] = 'Izaberi datum';
$string['caltoday'] = 'Danas';
$string['calweekdays'] = 'Ned,Pon,Uto,Sre,Čet,Pet,Sub';
$string['cannottakeforgroup'] = 'Ne možete da evidentirate prisustvo za grupu  "{$a}"';
$string['cantaddstatus'] = 'Morate podesiti akronim i opis kada dodajete novi status.';
$string['categoryreport'] = 'Izveštaj o kategoriji kurseva';
$string['changeattendance'] = 'Promeni podatke o prisustvu';
$string['changeduration'] = 'Promeni trajanje';
$string['changesession'] = 'Promeni sesiju';
$string['checkweekdays'] = 'Odaberite dane u sedmici koji upadaju u opseg datuma odabrane sesije.';
$string['closed'] = 'Ova sesija trenutno nije dostupna za samo-obeležavanje prisustva';
$string['column'] = 'kolona';
$string['columnmap'] = 'Mapiranje kolona';
$string['columnmap_help'] = 'Za svako od prikazanih polja izaberite odgovarajuću kolonu u csv datoteci.';
$string['columns'] = 'kolone';
$string['commonsession'] = 'Svi polaznici';
$string['commonsessions'] = 'Svi polaznici';
$string['confirm'] = 'Potvrdi';
$string['confirmcolumnmappings'] = 'Potvrdite mapiranja kolona';
$string['confirmdeletehiddensessions'] = 'Da li ste sigurni da želite da obrišete {$a->count} sesiju/e/a zakazane pre datuma početka kursa ({$a->date})?';
$string['confirmdeleteuser'] = 'Da li ste sigurni da želite da obrišete korisnika pod imenom \'{$a->fullname}\' ({$a->email})?<br/>Sva zabeležena prisustva tog korisnika će biti trajno obrisana.';
$string['copyfrom'] = 'Kopiraj podatke o prisustvu iz';
$string['countofselected'] = 'Broj izabranih';
$string['course'] = 'Kurs';
$string['coursemessage'] = 'Pošaljite poruku korisnicima na kursu';
$string['courseshortname'] = 'Skraćeni naziv kursa';
$string['coursesummary'] = 'Skraćeni izveštaj o prisustvu na kursevima';
$string['createmultiplesessions'] = 'Kreiraj višestruke sesije';
$string['createmultiplesessions_help'] = 'Ova funkcija vam omogućava da kreirate više sesija u jednom jednostavnom koraku.

Sesije počinju sa datumom prve sesije i nastaviće se sve do datuma navedenog u podešavanju "ponovite do".

* <strong>Ponovite na dan</strong>: izaberite dane u nedelji kada će vaši polaznici da se susreću (na primer, ponedeljak/sreda/petak).
* <strong>Ponovite svake</strong>: ovo omogućava da podesite koliko često će se održavati sesije. Ako će se vaša grupa sastajati svake sedmice, izaberite 1; ako će se sastajati svake druge sedmice, izaberite 2; svake treće sedmice izaberite 3 itd.
* <strong>Ponovite do</strong>: izaberite poslednji dan  kursa (poslednji dan kada želite da evidentirate prisustvo).';
$string['createonesession'] = 'Kreiraj jednu sesiju za kurs';
$string['csvdelimiter'] = 'CSV graničnik';
$string['currentlyselectedusers'] = 'Trenutno izabrani korisnici';
$string['customexportfields'] = 'Izvezite prilagođena polja korisničkog profila';
$string['customexportfields_help'] = 'Dodatna prilagođena polja korisničkog profila koja će biti vidljiva u izveštaju koji se izvozi.';
$string['date'] = 'Datum';
$string['days'] = 'Dani';
$string['defaultdisplaymode'] = 'Podrazumevani režim prikaza';
$string['defaults'] = 'Podrazumevane vrednosti';
$string['defaultsessionsettings'] = 'Podrazumevana podešavanja sesije';
$string['defaultsessionsettings_help'] = 'Ova podešavanja definišu podrazumevane vrednosti za sve nove sesije';
$string['defaultsettings'] = 'Podrazumevana podešavanja prisustva';
$string['defaultsettings_help'] = 'Ova podešavanja definišu podrazumevane vrednosti za sva nova prisustva';
$string['defaultstatus'] = 'Skup podrazumevanih statusa';
$string['defaultsubnet'] = 'Podrazumevana mrežna adresa';
$string['defaultsubnet_help'] = 'Evidentiranje prisustva može biti ograničeno na određene podmreže navođenjem spiska delimičnih ili celih IP adresa razdvojenih zarezima. Ovo je podrazumevana vrednost koja se koristi prilikom kreiranja novih sesija.';
$string['defaultview'] = 'Podrazumevani prikaz prilikom prijavljivanja.';
$string['defaultview_desc'] = 'Ovo je podrazumevani prikaz koji vide predavači prilikom prvog prijavljivanja.';
$string['defaultwarnings'] = 'Skup podrazumevanih upozorenja';
$string['defaultwarningsettings'] = 'Podrazumevana podešavanja upozorenja';
$string['defaultwarningsettings_help'] = 'Ova podešavanja definišu podrazumevane vrednosti za sva nova upozorenja';
$string['delete'] = 'Obriši';
$string['deletecheckfull'] = 'Da li ste potpuno sigurni da želite da u potpunosti obrišete {$a}, uključujući sve korisničke podatke?';
$string['deletedgroup'] = 'Grupa povezana sa ovom sesijom je obrisana';
$string['deletehiddensessions'] = 'Obriši sve skrivene sesije';
$string['deletelogs'] = 'Obriši podatke o prisustvu';
$string['deleteselected'] = 'Obriši izabrane';
$string['deletesession'] = 'Obriši sesiju';
$string['deletesessions'] = 'Обриши све сесије';
$string['deleteuser'] = 'Obriši korisnika';
$string['deletewarningconfirm'] = 'Da li ste sigurni da želite da obrišete ovo upozorenje?';
$string['deletingsession'] = 'Брисање сесије за курс';
$string['deletingstatus'] = 'Brisanje statusa za kurs';
$string['description'] = 'Opis';
$string['display'] = 'Prikaz';
$string['displaymode'] = 'Režim prikaza';
$string['donotusepaging'] = 'Ne koristi straničenje';
$string['downloadexcel'] = 'Preuzmi u Excel formatu';
$string['downloadooo'] = 'Preuzmi u OpenOffice formatu';
$string['downloadtext'] = 'Preuzmi u tekstualnom formatu';
$string['duration'] = 'Trajanje';
$string['editsession'] = 'Uredi sesiju';
$string['edituser'] = 'Uredi korisnika';
$string['emailcontent'] = 'Sadržaj e-poruke';
$string['emailcontent_default'] = 'Poštovani/a %userfirstname%,
Vaše prisustvo na %coursename% %attendancename% je palo ispod %warningpercent% i trenutno je %percent% - nadamo se da ste dobro!

Kako biste izvukli maksimum iz ovog kursa, potrebno je da poboljšate svoje prisustvo; kontaktirajte nas ako vam je potrebna dodatna podrška.';
$string['emailcontent_help'] = 'Kada se polazniku šalje upozorenje, ono preuzima sadržaj e-poruke iz ovog polja. Mogu se koristiti sledeći džoker znaci:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Tema e-poruke';
$string['emailsubject_default'] = 'Upozorenje o (ne)prisustvovanju sesijama';
$string['emailsubject_help'] = 'Kada se polazniku šalje upozorenje, ono preuzima temu e-poruke iz ovog polja.';
$string['emailuser'] = 'Adresa e-pošte korisnika';
$string['emailuser_help'] = 'Ako je označeno, polazniku će biti poslato upozorenje.';
$string['emptyacronym'] = 'Prazne skraćenice nisu dozvoljene. Zapis o statusu nije ažuriran.';
$string['emptydescription'] = 'Prazni opisi nisu dozvoljeni. Zapis o statusu nije ažuriran.';
$string['enablecalendar'] = 'Kreiraj događaje u kalendaru';
$string['enablecalendar_desc'] = 'Ako je ova opcija omogućena, događaj u kalendaru će biti kreiran za svaku sesiju. Nakon promene ovog podešavanja, trebalo bi da pokrenete izveštaj o resetovanju kalendara.';
$string['enablewarnings'] = 'Omogući upozorenja';
$string['enablewarnings_desc'] = 'Ovo omogućava da se definiše skup upozorenja za prisustvo i slanje obaveštenja e-poštom korisnicima kada prisustvo padne ispod konfigurisanog praga. <br/><strong >UPOZORENJE: Ovo je nova funkcija i nije detaljno testirana. Možete je koristiti, ali na sopstveni rizik. Ako nađete da je ova funkcija korisna i da ispravno radi, molimo vas da povratne informacije podelite na Moodle forumima.</strong>';
$string['encoding'] = 'Kodiranje';
$string['encoding_help'] = 'Ovo se odnosi na tip kodiranja bar koda koji se koristi na ID karticama polaznika. Tipični tipovi šema kodiranja bar kodova uključuju Code-39, Code-128 i UPC-A.';
$string['endofperiod'] = 'Kraj vremenskog perioda';
$string['endtime'] = 'Vreme završetka sesije';
$string['enrolmentend'] = 'Učešće korisnika na kursu se završava {$a}';
$string['enrolmentstart'] = 'Učešće korisnika na kursu počinje {$a}';
$string['enrolmentsuspended'] = 'Učešće na kursu suspendovano';
$string['enterpassword'] = 'Unesi lozinku';
$string['error:coursehasnoattendance'] = 'Kurs sa skraćenim nazivom {$a} nema aktivnosti prisustva.';
$string['error:coursenotfound'] = 'Kurs sa skraćenim nazivom {$a} nije moguće pronaći.';
$string['error:qrcode'] = 'Da bi se koristio QR kôd polaznicima mora biti omogućeno da sami obeleže svoje prisustvo! Preskače se.';
$string['error:sessioncourseinvalid'] = 'Sesija kursa je neispravna! Preskače se.';
$string['error:sessiondateinvalid'] = 'Datum se sesije je neispravan! Preskače se.';
$string['error:sessionendinvalid'] = 'Vreme završetka sesije je neispravno! Preskače se.';
$string['error:sessionstartinvalid'] = 'Vreme početka sesije je neispravno! Preskače se.';
$string['error:statusnotfound'] = 'Korisnik: {$a->extuser} ima status koji se ne može pronaći: {$a->status}';
$string['error:timenotreadable'] = 'Korisnik: {$a->extuser} има време очитавања које није могло бити конвертовано помоћу PHP функције strtotime: {$a->scantime}';
$string['error:userduplicate'] = 'Korisnik {$a} je pronađen dva puta u uvezenoj sesiji. Uključite samo jedan zapis po korisniku.';
$string['errorgroupsnotselected'] = 'Izaberite jednu ili više grupa';
$string['errorinaddingsession'] = 'Greška u dodavanju sesije';
$string['erroringeneratingsessions'] = 'Greška u generisanju sesija';
$string['eventdurationupdated'] = 'Trajanje sesije ažurirano';
$string['eventreportviewed'] = 'Izveštaj o prisustvu je prikazan';
$string['eventscreated'] = 'Događaji u kalendaru kreirani';
$string['eventsdeleted'] = 'Događaji u kalendaru obrisani';
$string['eventsessionadded'] = 'Sesija dodata';
$string['eventsessiondeleted'] = 'Sesija obrisana';
$string['eventsessionipshared'] = 'IP konflikt prilikom samo-obeležavanje prisustva';
$string['eventsessionsimported'] = 'Sesije uvezene';
$string['eventsessionupdated'] = 'Sesija ažurirana';
$string['eventstatusadded'] = 'Status dodat';
$string['eventstatusupdated'] = 'Status ažuriran';
$string['eventstudentattendancesessionsupdated'] = 'Izveštaj o sesiji ažuriran';
$string['eventstudentattendancesessionsviewed'] = 'Izveštaj o sesiji prikazan';
$string['eventtaken'] = 'Prisustvo obeleženo';
$string['eventtakenbystudent'] = 'Polaznik je obeležio prisustvo';
$string['export'] = 'Eksportuj';
$string['extrarestrictions'] = 'Dodatna ograničenja';
$string['formattexttype'] = 'Formatiranje';
$string['from'] = 'od:';
$string['gradebookexplanation'] = 'Ocena u knjizi ocena';
$string['gradebookexplanation_help'] = 'Modul \'Prisustvo\' prikazuje vašu trenutnu ocenu za prisustva na osnovu broja bodova koji ste zaradili do sada i broja bodova koji ste mogli da zaradite do danas; Ocena ne obuhvata časove koji će tek biti održani.
U knjizi ocena, vaša ocena za prisustvo se zasniva na vašem  trenutnom procentu prisustva i broja bodova koji se može zaraditi tokom čitavog trajanja kursa, uključujući i buduće časove Zbog toga, vaše ocene za prisustvo prikazane u modulu \'Prisustvo\' i u knjizi ocena ne moraju da imaju isti broj bodoava, ali će imati isti procenat.

Na primer, ako ste do danas zaradili 8 od 10 bodova (80% prisustva), a prisustvo na čitavom kursu vredi 50 bodova, modul \'Prisustvo\' će prikazati 8/10, dok će knjiga ocena prikazati 40/50. Još uvek niste zaradili 40 bodova, ali 40 je ekvivalentna vrednost bodova  za vaš trenutni procenat prisustva od 80%. Vrednost bodova koje ste zaradili u modulu \'Prisustvo\', nikada ne može da se smanji, jer se ona zasniva samo na podacima o prisustvu dosadašnjoj nastavi; međutim, vrednost bodova za prisustvo prikazan u knjizi ocena može da se poveća ili smanji u zavisnosti od vašeg budućeg prisustvovanja nastavi, jer se zasniva na prisustvi tokom čitavog kursa.';
$string['graded'] = 'Ocenjene sesije';
$string['gridcolumns'] = 'Kolone mreže';
$string['group'] = 'Grupa';
$string['groups'] = 'Grupe';
$string['groupsession'] = 'Grupa polaznika';
$string['groupsessionsby'] = 'Grupne sesije';
$string['hiddensessions'] = 'Sakrivene sesije';
$string['hiddensessions_help'] = 'Sesije su sakrivene ukoliko su zakazane za pre početka kursa.

Ovu funkciju možete da koristite kako biste sakrili starije sesije umesto da ih brišete. Samo vidljive sesije će biti prikazane u dnevniku ocena.';
$string['hiddensessionsdeleted'] = 'Sve skrivene sesije su obrisane';
$string['hideextrauserdetails'] = 'Sakrij dodatne podatke o korisniku';
$string['hidensessiondetails'] = 'Sakrij podatke o sesiji';
$string['identifyby'] = 'Identifikuj studenta po';
$string['import'] = 'Uvoz';
$string['importfile'] = 'Uvezi datoteku';
$string['importfile_help'] = 'Uvezi datoteku';
$string['importsessions'] = 'Uvoz sesija';
$string['importstatus'] = 'Polje statusa';
$string['importstatus_help'] = 'Ovo omogućava da se vrednost statusa uključi tokom uvoza - npr. vrednosti kao što su P, Z ili O';
$string['includeabsentee'] = 'Uključite sesiju prilikom izračunavanja izveštaja o odsustvu';
$string['includeabsentee_help'] = 'Ako je označeno, ova sesija će biti uključena u proračune izveštaja o odsustvu.';
$string['includeall'] = 'Izaberi sve sesije';
$string['includedescription'] = 'Uključite opis sesije';
$string['includenottaken'] = 'Uključi sesije za koje prisustvo nije obeleženo';
$string['includeqrcode'] = 'Uključite QR kôd';
$string['includeremarks'] = 'Uključi napomene';
$string['incorrectpassword'] = 'Uneli ste pogrešnu lozinku i vaše prisustvo nije evidentirano, molimo unesite tačnu lozinku.';
$string['incorrectpasswordshort'] = 'Netačna lozinka, prisustvo nije evidentirano.';
$string['indetail'] = 'Detaljnije...';
$string['indicator:cognitivedepth'] = 'Prisustvo - kognitivni aspekt';
$string['indicator:cognitivedepth_help'] = 'Ovaj indikator se zasniva na kognitivnoj dubini koju je polaznik postigao u okviru aktivnosti \'Prisustvo\'.';
$string['indicator:cognitivedepthdef'] = 'Prisustvo - kognitivni aspekt';
$string['indicator:cognitivedepthdef_help'] = 'Učesnik je postigao ovaj procenat kognitivnog angažmana koji nudi \'Prisustvo\' tokom ovog intervala analize (Nivoi = Bez pregleda, Pregled)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Prisustvo - socijalni aspekt';
$string['indicator:socialbreadth_help'] = 'Ovaj indikator se zasniva na obimu socijalnih interakcija koji je polaznik postigao u okviru aktivnosti \'Prisustvo\'.';
$string['indicator:socialbreadthdef'] = 'Prisustvo - socijalni aspekt';
$string['indicator:socialbreadthdef_help'] = 'Učesnik je postigao ovaj procenat socijalnog angažmana koji nudi \'Prisustvo\' tokom ovog intervala analize (Nivoi = Bez učešća, Učesnik sâm)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Morate odabrati akciju';
$string['invalidemails'] = 'Morate da navedete adrese postojećih korisničkih naloga, koje nije moguće pronaći: {$a}';
$string['invalidimportfile'] = 'Format datoteke je neispravan.';
$string['invalidsessionenddate'] = 'Ovaj datum ne može biti pre datuma početka sesije';
$string['invalidsessionendtime'] = 'Vreme završetka mora biti kasnije u odnosu na vreme početka sesije';
$string['invalidstatus'] = 'Izabrali ste neispravan status, pokušajte ponovo';
$string['iptimemissing'] = 'Neispravna vrednost vremena (u minutima) za oslobađanje IP adrese';
$string['jumpto'] = 'skoči na';
$string['keepsearching'] = 'Nastavite pretragu';
$string['marksessionimportcsvhelp'] = 'Ovaj obrazac vam omogućava da postavite csv datoteku koja sadrži identifikator korisnika i status – polje statusa može biti akronim statusa ili vreme kada je evidentirano prisustvo za tog korisnika. Ako je vrednost za vreme ispravna, onda će se biti pokušano da se dodeli status sa najvišom ocenom koja je dostupna u tom trenutku.';
$string['maxpossible'] = 'Maksimalno moguće';
$string['maxpossible_help'] = 'Prikazuje rezultat koji svaki korisnik može postići ako dobije maksimalan broj poena za svaku sesiju (prošlu i buduću) na kojoj prisustvo još nije obeleženo:
  <ul>
    <li><strong>Poeni</strong>: maksimalan broj poene koje svaki korisnik može postići za sve sesije</li>
    <li><strong>Procenti</strong>: maksimalan procenat koji svaki korisnik može postići za sve sesije.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'Maksimalni mogući procenat';
$string['maxpossiblepoints'] = 'Maksimalni mogući broj poena';
$string['maxwarn'] = 'Maksimalan broj upozorenja poslatih e-poštom';
$string['maxwarn_help'] = 'Određuje koliko puta maksimalno treba da bude poslato upozorenje (šalje se samo jedno upozorenje po sesiji)';
$string['mergeuser'] = 'Spoji korisnika';
$string['mobilesessionfrom'] = 'Prikaži sesije koje su starije od';
$string['mobilesessionfrom_help'] = 'Ovo podešavanje omogućava da spisak sesija, na kojima se obeležava prisustvo, bude ograničen – prikazuju se samo sesije koje su započete pre navedenog vremenskog intervala';
$string['mobilesessionto'] = 'Prikaži buduće sesije';
$string['mobilesessionto_help'] = 'Omogućava da se spisak sesija ograniči tako da prikazuje samo mali broj budućih sesija.';
$string['mobilesettings'] = 'Podešavanja mobilne aplikacije';
$string['mobilesettings_help'] = 'Ova podešavanja kontrolišu ponašanje Moodle mobilne aplikacije';
$string['modulename'] = 'Prisustvo';
$string['modulename_help'] = 'Modul aktivnosti \'Prisustvo\' omogućava nastavniku da vodi evidenciju o prisustvu studenata nastavi, a studentima da vide svoje podatke o prisustvu.

Nastavnik može da kreira višestruke sesije i obeleži status prisustva nastavi kao "Prisutan/na", "Odsutan/na", "Zakasnio/la" ili "Opravdano odsutan/na", Nastavnik može, takođe, da modifikuje statuse shodno svojim potrebama.

Izveštaji o prisustvu su dostupni kako za celu grupu, tako i za pojedinačnog studenta.';
$string['modulenameplural'] = 'Prisustva';
$string['months'] = 'Meseci';
$string['moreattendance'] = 'Prisustvo je uspešno obeleženo za ovu stranicu';
$string['moveleft'] = 'Pomeri ulevo';
$string['moveright'] = 'Pomeri udesno';
$string['multisessionexpanded'] = 'Podešavanja "Višestruke sesije" proširena';
$string['multisessionexpanded_desc'] = 'Kada kreirate nove sesije prikažite podešavanja "Višestruke sesije" " standardno proširena.';
$string['mustselectusers'] = 'Morate odabrati korisnike za izvoz';
$string['newdate'] = 'Novi datum';
$string['newduration'] = 'Novo trajanje';
$string['newstatusset'] = 'Novi skup statusa';
$string['noabsentstatusset'] = 'Skup statusa koji se koristi ne poseduje status za polaznike čije priustvo nije obeleženo.';
$string['noattendanceusers'] = 'Nije moguć izvoz podataka pošto nema polaznika upisanih na ovaj kurs.';
$string['noattforuser'] = 'Ne postoje zapisi o prisustvu za korisnika';
$string['noautomark'] = 'Onemogućeno';
$string['nocapabilitytotakethisattendance'] = 'Pokušali ste da promenite prisustvo sesiji sa cmid oznakom: {$a} za koju nemate ovlaćšenje da menjate podatke o prisustvu.';
$string['nodescription'] = 'Redovni čas';
$string['noeventstoreset'] = 'Nema događaja u kalendaru koji zahtevaju ažuriranje.';
$string['nogroups'] = 'Ne možete da dodate grupne sesije. Nijedna grupa ne postoji na kursu.';
$string['noguest'] = 'Gosti ne mogu da vide podatke o prisustvu nastavi';
$string['noofdaysabsent'] = 'Broj dana odsutnosti';
$string['noofdaysexcused'] = 'Broj dana opravdane odsutnosti';
$string['noofdayslate'] = 'Broj dana kašnjenja';
$string['noofdayspresent'] = 'Broj dana prisutnosti';
$string['nosessiondayselected'] = 'Broj izabranih dana sesije';
$string['nosessionexists'] = 'Ne postoji sesija za ovaj kurs';
$string['nosessionsselected'] = 'Nije izabrana nijedna sesija';
$string['notfound'] = 'Aktivnost \'Prisustvo\' nije pronađena na ovom kursu!';
$string['notifytask'] = 'Slanje upozorenja korisnicima';
$string['notmember'] = 'nije&nbsp;član';
$string['notset'] = 'nije podešeno';
$string['noupgradefromthisversion'] = 'Modul \'Prisustvo\' ne može biti nadograđen sa prethodne verzije ovo dodatka (attforblock) koji ste instalirali - molimo vas, obrišite dodatak attforblock ili ga nadogradite na poslednju verziju, pre nego što instalirate novi modul \'Prisustvo\'.';
$string['numsessions'] = 'Broj sesija';
$string['olddate'] = 'Stari datum';
$string['onlyselectedusers'] = 'Izvezi konkretne korisnike';
$string['overallsessions'] = 'Sve sesije';
$string['overallsessions_help'] = 'Prikazuje statistiku za sve sesije uključujući i one kod kojih prisustvo još nisu obeleženo (prošle i buduće):
    <ul>
    <li><strong>Sesije</strong>: ukupan broj sesija.</li>
    <li><strong>Poeni</strong>: broj poena osvojenih na osnovu sesija na kojima je prisustvo obeleženo.</li>
    <li><strong>Procenat</strong>: procenat osvojenih poena u odnosu na maksimalan broj mogućih poena za sve sesije.</li>
    </ul>';
$string['oversessionstaken'] = 'Sesije na kojima je prisustvo obeleženo';
$string['oversessionstaken_help'] = 'Prikazuje statistiku za sesije na kojima je prisustvo obeleženo:
<li><strong>Sesije</strong>: broj sesija na kojima je prisustvo obeleženo.</li>
    <li><strong>Poeni</strong>: broj osvojenih poena na osnovu sesija na kojima je prisustvo obeleženo.</li>
    <li><strong>Procenat</strong>: procenat osvojenih poena u odnosu na maksimalan moguć broj poene za sesije na kojima je prisustvo obeleženo.</li>
    </ul>';
$string['pageof'] = 'Stranica {$a->page} od {$a->numpages}';
$string['participant'] = 'Učesnik';
$string['password'] = 'Lozinka';
$string['passwordgrp'] = 'Lozinka polaznika';
$string['passwordgrp_help'] = 'Ako je podešeno, studenti će morati da unesu ovu lozinku pre nego što budu mogli da obeleže sopstveni status prisustva sesije. Ako je polje prazno, lozinka nije potrebna.';
$string['passwordrequired'] = 'Morate uneti lozinku sesije pre nego što budete mogli da obeležite svoje prisustvo';
$string['percentage'] = 'Procenat';
$string['percentageallsessions'] = 'Procenat za sve sesije';
$string['percentagesessionscompleted'] = 'Procenat za sesije na kojima je obeleženo prisustvo';
$string['pluginadministration'] = 'Administracija modula "Prisustvo"';
$string['pluginname'] = 'Prisustvo';
$string['points'] = 'Poeni';
$string['pointsallsessions'] = 'Broj poena za sve sesije';
$string['pointssessionscompleted'] = 'Broj poena za sesije na kojima je obeleženo prisustvo';
$string['preferences_desc'] = 'Promene skupova statusa će uticati na postojeće sesije i mogu uticati na ocenjivanje.';
$string['preventsharederror'] = 'Samo-obeležavanje je onemogućeno za sesiju jer se čini da je ovaj uređaj već korišćen za evidentiranje prisustva za drugog polaznika.';
$string['preventsharedip'] = 'Sprečite polaznike da dele IP adresu';
$string['preventsharedip_help'] = 'Sprečite polaznike da koriste isti uređaj (identifikovan korišćenjem IP adrese) kako bi obeležili prisustvo drugih polaznika.';
$string['preventsharediptime'] = 'Vreme nakon kog IP adresa može ponovo da se koristi (minuti)';
$string['preventsharediptime_help'] = 'Dozvolite da se IP adresa ponovo koristi za obeležavanje prisustva na ovoj sesiji nakon što protekne navedeni vremenski period.';
$string['preview'] = 'Pregled datoteke';
$string['previewhtml'] = 'Pregled HTML formata';
$string['priorto'] = 'Datum održavanja sesije je raniji u odnosu na datum početka kursa ({$a}) pa će nove sesije zakazane za pre tog datuma biti sakrivene (neće biti dostupne). Možete promeniti datum početka kursa u bilo koje doba (pogledajte podešavanja kursa) da biste imali pristup ranijim sesijama.<br><br>Molimo izmenite datum sesije ili samo kliknite na dugme sa natpisom "Dodaj sesiju" ponovo kako biste potvrdili svoj izbor.';
$string['privacy:metadata:attendancelog'] = 'Evidencija o prisustvima korisnika zabeležena.';
$string['privacy:metadata:attendancesessions'] = 'Sesije na kojima će prisustvo biti evidentirano.';
$string['privacy:metadata:attendancewarningdone'] = 'Zapis upozorenja poslatih korisnicima o evidencije njihovog prisutva sesijama.';
$string['privacy:metadata:duration'] = 'Trajanje sesije u sekundama';
$string['privacy:metadata:groupid'] = 'ID oznaka grupe povezana sa sesijom.';
$string['privacy:metadata:ipaddress'] = 'IP adresa sa koje je prisustvo zabeleženo.';
$string['privacy:metadata:lasttaken'] = 'Vremenska oznaka kada je poslednji put obeleženo prisustvo sesiji.';
$string['privacy:metadata:lasttakenby'] = 'ID oznaka poslednjeg korisnika čije je prisustvo ovoj sesiji obeleženo.';
$string['privacy:metadata:notifyid'] = 'ID oznaka obaveštenja sa kojim je upozorenje o prisustvu sesiji povezano.';
$string['privacy:metadata:remarks'] = 'Komentari o prisustvu korisnika.';
$string['privacy:metadata:sessdate'] = 'Vremenska oznaka kada sesija počinje.';
$string['privacy:metadata:sessionid'] = 'ID oznaka sesije';
$string['privacy:metadata:statusid'] = 'ID oznaka statusa prisustva polaznika.';
$string['privacy:metadata:statusset'] = 'Skup statusa kojem pripada ID oznaka statusa.';
$string['privacy:metadata:studentid'] = 'ID oznaka polaznika čije je prisustvo evidentirano.';
$string['privacy:metadata:takenby'] = 'ID oznaka korisnika koji je evidentirao prisustvo polaznika.';
$string['privacy:metadata:timemodified'] = 'Vremenska oznaka kada je sesija poslednji put izmenjena';
$string['privacy:metadata:timesent'] = 'Vremenska oznaka kada je upozorenje poslato.';
$string['privacy:metadata:timetaken'] = 'Vremenska oznaka kada je polazniku obeleženo prisustvo.';
$string['privacy:metadata:userid'] = 'ID oznaka korisnika kome treba poslati upozorenje.';
$string['processingfile'] = 'Obrada datoteke';
$string['qr_cookie_error'] = 'QR sesija je istekla.';
$string['qr_pass_wrong'] = 'QR lozinka je pogrešna ili je istekla.';
$string['randompassword'] = 'Nasumična lozinka';
$string['remark'] = 'Napomena za: {$a}';
$string['remarks'] = 'Napomene';
$string['repeatasfollows'] = 'Ponovite gore navedenu sesiju na sledeći način';
$string['repeatevery'] = 'Ponovite svake';
$string['repeaton'] = 'Ponovite na dan';
$string['repeatuntil'] = 'Ponovite do';
$string['report'] = 'Izveštaj';
$string['required'] = 'Neophodno*';
$string['requiredentries'] = 'Privremeni zapisi se prepisuju preko zapisa o prisustvu učesnika';
$string['requiredentry'] = 'Vodič za pomoć pri spajanju privremenih korisnika';
$string['requiredentry_help'] = '<p align="center"><b>Prisustvo</b></p>
<p align="left"><strong>Spoji naloge</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodle korisnik</th>
<th>Privremeni korisnik</th>
<th>Akcija</th>
</tr>
<tr>
<td>Podaci o prisustvu</td>
<td>Podaci o prisustvu</td>
<td>Privremeni korisnik će biti prepisan preko Moodle korisnika</td>
</tr>
<tr>
<td>Nema podataka o prisustvu</td>
<td>Podaci o prisustvu</td>
<td>Prisustvo privremenog korisnika će biti preneto Moodle korisniku</td>
</tr>
<tr>
<td>Podaci o prisustvu</td>
<td>Nema podataka o prisustvu</td>
<td>Privremeni korisnik će biti obrisan</td>
</tr>
<tr>
<td>Nema podataka o prisustvu</td>
<td>Nema podataka o prisustvu</td>
<td>Privremeni korisnik će biti obrisan</td>
</tr>
</table>

</p>
<p align="left"><strong>Privremeni korisnik će biti obrisan u svakom slučaju posle akcije spajanja</strong></p>';
$string['requiresubnet'] = 'Zahtevaj mrežnu adresu';
$string['requiresubnet_help'] = 'Evidentiranje prisustva može biti ograničeno na određene podmreže navođenjem spiska delimičnih ili celih IP adresa razdvojenih zarezima.';
$string['resetcaledarcreate'] = 'Kreiranje događaja u kalendaru je omogućeno, ali određeni broj postojećih sesija nema događaje. Da li želite da kreirate događaje u kalendaru za sve postojeće sesije?';
$string['resetcaledardelete'] = 'Kreiranje događaja u kalendaru je onemogućeno, ali određeni broj postojećih sesija ima događaje koje treba obrisati. Da li želite da obrišete sve postojeće događaje?';
$string['resetcalendar'] = 'Resetovanje kalendara';
$string['resetdescription'] = 'Upamtite, brisanje podataka o prisustvu će obrisati informacija iz baze podataka. Možete samo da sakrijete starije sesije tako što ćete promeniti datum početka kursa!';
$string['resetstatuses'] = 'Resetuj statuse na podrazumevane vrednosti';
$string['restoredefaults'] = 'Vrati podrazumevane vrednosti';
$string['resultsperpage'] = 'Broj rezultata po stranici';
$string['resultsperpage_desc'] = 'Broj studenata koji će biti prikazani na jednoj stranici';
$string['rotateqrcode'] = 'Rotirajte QR kôd';
$string['rotateqrcode_cleartemppass_task'] = 'Brisanje privremenih lozinki generisanih funkcijom rotiranja QR kôda (zadatak).';
$string['rotateqrcodeexpirymargin'] = 'Vremenska margina isteka rotacije QR kôda/lozinke (sekunde)';
$string['rotateqrcodeexpirymargin_desc'] = 'Vremenski interval (u sekundama) za omogućavanje isteka QR kôda/lozinke.';
$string['rotateqrcodeinterval'] = 'Interval (u sekundama) za rotaciju QR kôda/lozinke';
$string['rotateqrcodeinterval_desc'] = 'Vremenski interval (u sekundama) za rotiranje QR kôda/lozinke.';
$string['save'] = 'Sačuvaj podatke o prisustvu';
$string['scantime'] = 'Vreme očitavanja';
$string['scantime_help'] = 'Ovo podešavanje pruža mogućnost da vremenska oznaka bude uključena u datoteku za uvoz – ovo će pokušati da konvertuje vremensku oznaku koja je prosleđena pomoću PHP funkcije strtotime, a zatim će koristiti podešavanja statusa prisustva kako bi se odlučilo koji status će biti podešen za korisnika';
$string['search:activity'] = 'Prisustvo - informacije o aktivnosti';
$string['session'] = 'Sesija';
$string['session_help'] = 'Sesija';
$string['sessionadded'] = 'Sesija uspešno dodata';
$string['sessionalreadyexists'] = 'Sesija već postoji za ovaj datum';
$string['sessiondate'] = 'Datum';
$string['sessiondays'] = 'Dani sesije';
$string['sessiondeleted'] = 'Sesija uspešno obrisana';
$string['sessionexist'] = 'Sesija nije dodata (već postoji)!';
$string['sessiongenerated'] = 'Jedna sesija je uspešno generisana';
$string['sessions'] = 'Sesije';
$string['sessionsallcourses'] = 'Svi kursevi';
$string['sessionsbyactivity'] = 'Instanca prisustva';
$string['sessionsbycourse'] = 'Kurs';
$string['sessionsbydate'] = 'Sedmica';
$string['sessionscompleted'] = 'Sesije na kojima je obeleženo prisustvo';
$string['sessionscurrentcourses'] = 'Tekući kursevi';
$string['sessionsgenerated'] = 'Broj uspešno generisanih sesija: {$a}';
$string['sessionsids'] = 'ID brojevi sesija:';
$string['sessionsnotfound'] = 'Nema sesija u izabranom vremenskom periodu';
$string['sessionstartdate'] = 'Datum početka sesije';
$string['sessionstotal'] = 'Ukupan broj sesija';
$string['sessionsupdated'] = 'Sesije su ažurirane';
$string['sessiontype'] = 'Vrsta';
$string['sessiontype_help'] = 'Postoje dve vrste sesije: zajednička i grupne. Mogućnost  da se dodaju različite vrste sesije zavisi od grupnog režima aktivnosti.

* U režimu "Nema grupa" možete da dodate samo zajedničke sesije.
* U režimu "Odvojene grupe" možete da dodate samo grupne sesije.
* U režimu "Vidljive grupe" možete da dodate i zajedničke i grupne sesije.';
$string['sessiontypeshort'] = 'Vrsta';
$string['sessionunknowngroup'] = 'Sesija navodi nepoznate grupu/e: {$a}';
$string['sessionupdated'] = 'Sesija uspešno ažurirana';
$string['set_by_student'] = 'Samostalno evidentiranje';
$string['setallstatuses'] = 'Podesi status za';
$string['setallstatusesto'] = 'Podesi status na «{$a}»';
$string['setperiod'] = 'Navedeno vreme u minutima za oslobađanje IP adrese';
$string['settings'] = 'Podešavanja';
$string['setunmarked'] = 'Status se automatski podešava kada prisustvo nije označeno';
$string['setunmarked_help'] = 'Ako je omogućeno ovo podešavanje unutar sesije, podesite ovaj status ako polaznik nije označio svoje prisustvo.';
$string['showdefaults'] = 'Prikaži podrazumevane vrednosti';
$string['showduration'] = 'Prikaži trajanje';
$string['showextrauserdetails'] = 'Prikaži dodatne podatke o korisniku';
$string['showsessiondescriptiononreport'] = 'Prikaži opis sesije u izveštaju';
$string['showsessiondescriptiononreport_desc'] = 'Prikažite opis sesije na spisku izveštaja o prisustvu.';
$string['showsessiondetails'] = 'Prikaži detalje o sesiji';
$string['somedisabledstatus'] = '(Neke opcije su uklonjene pošto je sesija počela).';
$string['sortedgrid'] = 'Sortirana "mreža"';
$string['sortedlist'] = 'Sortirani spisak';
$string['startofperiod'] = 'Početak vremenskog perioda';
$string['starttime'] = 'Vreme početka';
$string['status'] = 'Status';
$string['statusall'] = 'sve';
$string['statusdeleted'] = 'Status je obrisan';
$string['statuses'] = 'Statusi';
$string['statusset'] = 'Status je podešen na {$a}';
$string['statussetsettings'] = 'Podešavanje statusa';
$string['statusunselected'] = 'neizabrano';
$string['strftimedm'] = '%b %d';
$string['strftimedmw'] = '<nobr>%a %b %d</nobr>';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentid'] = 'ID broj studenta';
$string['studentmarked'] = 'Vaše prisustvo na ovoj sesiji je evidentirano.';
$string['studentmarking'] = 'Evidentiranje prisustva od strane polaznika';
$string['studentpassword'] = 'Lozinka polaznika';
$string['studentrecordingexpanded'] = 'Podešavanja "Evidentiranje prisustva od strane polaznika" proširena';
$string['studentrecordingexpanded_desc'] = 'Kada kreirate nove sesije prikažite podešavanja "Evidentiranje prisustva od strane polaznika" standardno proširena.';
$string['studentscanmark'] = 'Dozvoli studentima da sami obeleže svoje prisustvo';
$string['studentscanmark_desc'] = 'Ako je označeno, predavači će moći da dozvole polaznicima da sami zabeleže svoje prisustvo.';
$string['studentscanmark_help'] = 'Ako je označeno, polaznici će moći sami da promene svoj status za prisustvo sesiji.';
$string['studentscanmarksessiontime'] = 'Polaznici beleže prisustvo tokom sesije';
$string['studentscanmarksessiontime_desc'] = 'Ako je označeno, polaznici mogu da evidentiraju samo svoje prisustvo tokom sesije.';
$string['studentscanmarksessiontimeend'] = 'Kraj sesije (minuti)';
$string['studentscanmarksessiontimeend_desc'] = 'Ako sesija nema podešeno vreme završetka, koliko minuta sesija treba da bude na raspolaganju polaznicima kako bi obeležili svoje prisustvo.';
$string['submit'] = 'Pošalji';
$string['submitattendance'] = 'Pošalji prisustvo';
$string['submitpassword'] = 'Pošalji lozinku';
$string['subnet'] = 'Podmreža';
$string['subnetactivitylevel'] = 'Dozvoli konfiguraciju podmreže na nivou aktivnosti';
$string['subnetactivitylevel_desc'] = 'Ako je ova opcija omogućena, predavači mogu da zamene podrazumevanu podmrežu na nivou aktivnosti kada kreiraju prisustvo. U suprotnom će se prilikom kreiranja sesije koristiti podrazumevani adresa sajta.';
$string['subnetwrong'] = 'Prisustvo može biti evidentirati samo sa određenih lokacija, a ovaj računar nije na spisku dozvoljenih.';
$string['summary'] = 'Rezime';
$string['tablerenamefailed'] = 'Promena stare "attforblock" tabele u novu "attendance" nije uspela';
$string['tactions'] = 'Akcija';
$string['takeattendance'] = 'Evidentiraj prisustvo';
$string['takensessions'] = 'Sesije na kojima je obeleženo prisustvo';
$string['tcreated'] = 'Kreirano';
$string['tempaddform'] = 'Dodaj privremenog korisnika';
$string['tempexists'] = 'Već postoji privremeni korisnik sa ovom e-adresom';
$string['temptable'] = 'Spisak privremenih korisnika';
$string['tempuser'] = 'Privremeni korisnik';
$string['tempusermerge'] = 'Spoji privremenog korisnika';
$string['tempusers'] = 'Privremeni korisnici';
$string['tempusersedit'] = 'Uredi privremenog korisnika';
$string['tempuserslist'] = 'Privremeni korisnici';
$string['thirdpartyemails'] = 'Obavesti druge korisnike';
$string['thirdpartyemails_help'] = 'Spisak ostalih korisnika koji će biti obavešteni (zahteva sposobnost mod/attendance:viewreports).';
$string['thirdpartyemailsubject'] = 'Upozorenje o (ne)prisustvovanju sesijama';
$string['thirdpartyemailtext'] = 'Prisustvo polaznika {$a->firstname} {$a->lastname} na kursu {$a->coursename} {$a->aname} manje je od {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Ovu poruku dobijate jer je predavač na ovom kursu vašu adresu e-pošte dodao na spisak primalaca';
$string['thiscourse'] = 'Ovaj kurs';
$string['time'] = 'Vreme';
$string['timeahead'] = 'Višestruke sesije koje traju duže od godinu dana ne mogu biti kreirane. Molimo prilagodite tome datume početka i kraja.';
$string['to'] = 'do:';
$string['todate'] = 'do danas';
$string['triggered'] = 'Prvo obavešten';
$string['tuseremail'] = 'E-adresa';
$string['tusername'] = 'Puno ime i prezime';
$string['ungraded'] = 'Neocenjene sesije';
$string['unknowngroup'] = 'Nepoznata grupa';
$string['update'] = 'Ažuriraj';
$string['uploadattendance'] = 'Postavite podatke o prisustvovanju putem CSV datoteke';
$string['usedefaultsubnet'] = 'Koristi podrazumevanu adresu';
$string['usemessageform'] = 'ili upotrebite obrazac u nastavku kako biste poslali poruku izabranim polaznicima';
$string['userexists'] = 'Već postoji korisnik sa ovom e-adresom';
$string['userid'] = 'ID oznaka korisnika';
$string['userimportfield'] = 'Polje eksternog korisnika';
$string['userimportfield_help'] = 'Polje iz postavljene CSV  datoteke koje sadrži identifikator korisnika';
$string['userimportto'] = 'Polje Moodle korisnika';
$string['userimportto_help'] = 'Moodle polje koje odgovara podacima iz eksportovane CSV datoteke';
$string['users'] = 'Korisnici za izvoz';
$string['usestatusset'] = 'Skup statusa';
$string['variable'] = 'promenljiva';
$string['variablesupdated'] = 'Promenljive su uspešno ažurirane';
$string['versionforprinting'] = 'verzija za štampu';
$string['viewmode'] = 'Režim prikaza';
$string['warnafter'] = 'Broj obeleženih sesija pre slanja upozorenja';
$string['warnafter_help'] = 'Upozorenja će biti aktivirana samo kada je korisnik obeležio prisustvo najmanje za ovaj broj sesija.';
$string['warningdeleted'] = 'Upozorenje je obrisano';
$string['warningdesc'] = 'Ova upozorenja će biti automatska dodata svakoj novoj aktivnosti \'Prisustvo\'. Ako se više od jednog upozorenja aktivira u isto vreme, biće poslato samo ono sa nižim pragom.';
$string['warningdesc_course'] = 'Ovde podešeni pragovi za upozorenja utiču na izveštaj o odsustvu i omogućavaju da polaznici i treća lica budu obavešteni. Ako se više od jednog upozorenja aktivira u isto vreme, biće poslato samo ono sa nižim pragom.';
$string['warningfailed'] = 'Ne možete kreirati upozorenje koje koristi isti procenat i broj sesija.';
$string['warningpercent'] = 'Pošaljite upozorenje ako procenat padne ispod';
$string['warningpercent_help'] = 'Upozorenje će biti poslato kada ukupan procenat padne ispod ovog broja.';
$string['warnings'] = 'Skup upozorenja';
$string['warningthreshold'] = 'Prag za upozorenje';
$string['warningupdated'] = 'Ažurirana upozorenja';
$string['week'] = 'sedmica(e)';
$string['weekcommencing'] = 'Sedmica započinje';
$string['weeks'] = 'Sedmice';
$string['youcantdo'] = 'Ne možete ništa da uradite';
