<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sr_lt', version '3.9'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Pristup je odbijen';
$string['accounts'] = 'Nalozi';
$string['addcategory'] = 'Dodaj kategoriju';
$string['additionalhtml'] = 'Dodatni HTML';
$string['additionalhtml_desc'] = 'Ovo podešavanje vam dozvoljava da navedete HTML kôd koji želite da bude dodat na svaku stranicu. Možete postaviti HTML kôd koji će biti dodat unutar oznake HEAD za svaku stranicu, odmah nakon otvaranja ili neposredno pre zatvaranja oznake BODY.<br />Na ovaj način možete imati prilagođeno zaglavlje ili podnožje na svakoj stranici ili možete dodati podršku za servise, poput Google Analytics, na jednostavan način, nezavisno od teme koju ste izabrali.';
$string['additionalhtml_heading'] = 'Dodatni HTML koji će biti pridružen svakoj stranici.';
$string['additionalhtmlfooter'] = 'Pre nego što se zatvori BODY oznaka';
$string['additionalhtmlfooter_desc'] = 'Sadržaj koji ovde upišete biće dodat na svaku stranicu neposredno pre nego što se zatvori body oznaka (</body>).';
$string['additionalhtmlhead'] = 'Unutar HEAD oznake';
$string['additionalhtmlhead_desc'] = 'Sadržaj koji ovde upišete biće dodat na kraju HEAD oznake na svakoj stranici.';
$string['additionalhtmltopofbody'] = 'Kada se otvori BODY oznaka';
$string['additionalhtmltopofbody_desc'] = 'Sadržaj koji ovde upišete biće dodat na svaku stranicu odmah nakon što se otvori body oznaka (<body>).';
$string['admincategory'] = 'Kategorija: {$a}';
$string['adminseesall'] = 'Administratori vide sve';
$string['adminseesallevents'] = 'Administratori vide sve događaje';
$string['adminseesownevents'] = 'Administratori su kao ostali korisnici';
$string['advancedfeatures'] = 'Napredna svojstva';
$string['agedigitalconsentverification'] = 'Potvrda digitalnog uzrasta za saglasnost';
$string['agedigitalconsentverification_desc'] = 'Omogućava potvrdu digitalnog uzrasta za saglasnost pre prikazivanja stranice za prijavljivanje za samostalno registrovane korisnike. Ovo štiti vaš sajt od prijava maloletnika bez saglasnosti roditelja/staratelja. <a target="_blank" href="{$a}">Kontakt za podršku</a> se prikazuju maloletnicima za dalju pomoć.';
$string['ageofdigitalconsentmap'] = 'Digitalna uzrast za saglasnost';
$string['ageofdigitalconsentmap_desc'] = 'Podrazumevani digitalni uzrast za saglasnost, kao i uzrast u bilo kojoj zemlji koji se razlikuje od podrazumevanog, mogu se ovde navesti. Unesite svaki od uzrasta u novi red u formatu: kôd države, uzrast (razdvojene zarezom). Podrazumevani uzrast se označava znakom * umesto kôda države. Kôdovi država su navedene u ISO 3166-2.';
$string['allcountrycodes'] = 'Oznake svih zemalja';
$string['allowattachments'] = 'Dozvoli priloge';
$string['allowbeforeblock'] = 'Prvo će biti obrađen spisak dozvoljenih adresa';
$string['allowbeforeblockdesc'] = 'Standardno, prvo se obrađuje spisak blokiranih adresa, ali ako je ova opcija omogućena spisak dozvoljenih IP adresa biće obrađen pre spiska blokiranih adresa.';
$string['allowblockstodock'] = 'Dozvoli blokovima da budu fiksirani';
$string['allowcategorythemes'] = 'Dozvoli izbor grafičke teme na nivou kategorija';
$string['allowcohortthemes'] = 'Dozvoli izbor grafičke teme na nivou kohorte';
$string['allowcoursethemes'] = 'Dozvoli izbor grafičke teme na nivou kurseva';
$string['allowedemaildomains'] = 'Dozvoljeni domeni e-pošte';
$string['allowediplist'] = 'Spisak dozvoljenih IP adresa';
$string['allowemailaddresses'] = 'Dozvoljeni domeni e-pošte';
$string['allowemojipicker'] = 'Birač emodžija';
$string['allowframembedding'] = 'Dozvoli umetanje u okvir';
$string['allowframembedding_help'] = 'Ako je opcija omogućena, ovaj sajt može biti umetnut u okvir na udaljenom sistemu, kao što se to preporučuje kada se koristi dodatak za upis \'Objavi kao LTI alat\'. U suprotnom, preporučuje se da ugrađivanje okvira isključite, iz bezbednosnih razloga. Imajte u vidu, takođe, da se  za mobilnu aplikaciju ovo podešavanje ignoriše i da je ugrađivanje okvira uvek dozvoljeno.';
$string['allowguestmymoodle'] = 'Dozvolite gostima pristup \'Kontrolnom panelu\'';
$string['allowindexing'] = 'Dozvoli indeksiranje od strane veb pretraživača';
$string['allowindexing_desc'] = 'Ovo određuje da li će veb pretraživačima biti omogućeno indeksiranje stranica vašeg sajta. Opcija "Svuda" će omogućiti veb pretraživačima da pretražuju svuda, uključujući stranice za prijavu na sistem, što znači da se indeksiraju i sajtovi kod kojih je uključena opcija "Primoraj korisnike da se prijave na sistem". Kako biste izbegli rizik od neželjene pošte koji postoji kada može da se pretražuje stranica za prijavu koristite opciju "Svuda osim stranica za prijavu". Opcija "Nigde" će sprečiti veb pretraživače da indeksiraju bilo koju stranicu vašeg sajta. Imajte u vidu da je ovo samo oznaka u zaglavlju sajta. Od veb pretraživača zavisi da li će uvažiti oznaku.';
$string['allowindexingeverywhere'] = 'Svuda';
$string['allowindexingexceptlogin'] = 'Svuda osima na stranicama za prijavu na sistem';
$string['allowindexingnowhere'] = 'Nigde';
$string['allowobjectembed'] = 'Dozvoli EMBED i OBJECT oznake';
$string['allowthemechangeonurl'] = 'Dozvoli promenu grafičke teme u URL adresi';
$string['allowuserblockhiding'] = 'Dozvoli korisnicima da sakriju blokove';
$string['allowusermailcharset'] = 'Dozvoli korisnicima da izaberu skupove znakova';
$string['allowuserswitchrolestheycantassign'] = 'Dozvoli korisnicima koji nemaju sposobnost dodeljivanja uloga da menjaju svoje uloge';
$string['allowuserthemes'] = 'Dozvoli korisnicima izbor grafičke teme';
$string['alternativefullnameformat'] = 'Alternativni format punog imena';
$string['alternativefullnameformat_desc'] = 'Ovo definiše kako se imena prikazuju korisnicima koji imaju sposobnost viewfullnames (standardno, korisnici sa ulogom menadžera, predavača ili predavača bez uređivačkih prava. Rezervisana mesta koja mogu da se koriste su ista kao i za podešavanje "Format punog imena".';
$string['always'] = 'Uvek';
$string['appearance'] = 'Izgled';
$string['aspellpath'] = 'Putanja do alata aspell';
$string['authentication'] = 'Provera identiteta';
$string['authpreventaccountcreation'] = 'Spreči kreiranje naloga prilikom provere identiteta';
$string['authpreventaccountcreation_help'] = 'Prilikom provere identiteta korisnika, na sajtu se automatski kreira nalog, ukoliko on već ne postoji. Ako se pak, za proveru identiteta, koristi neka spoljašnja baza podataka, poput LDAP-a, a pri tome želite da dozvolite pristup sajtu  samo korisnicima sa postojećim nalogom, onda treba uključiti ovu opciju. U tom slučaju, novi nalozi se kreiraju ručno ili putem opcije za postavljanje korisnika. Imajte u vidu da se ovo podešavanje ne primenjuje na MNet proveru identiteta.';
$string['authsettings'] = 'Upravljanje proverom identiteta';
$string['autolang'] = 'Automatsko detektovanje jezika';
$string['autologinguests'] = 'Automatsko prijavljivanje gostiju';
$string['availablelicenses'] = 'Raspoložive licence';
$string['availableto'] = 'Dostupno';
$string['backgroundcolour'] = 'Transparentna boja';
$string['backup_shortname'] = 'Koristi skraćeni naziv kursa u nazivu datoteke rezervne kopije';
$string['backup_shortnamehelp'] = 'Koristite skraćeni naziv kursa kao deo naziva datoteke rezervne kopije.';
$string['backups'] = 'Rezervne kopije';
$string['badwordsconfig'] = 'Unesite svoju listu nepristojnih/nepoželjnih reči odvojenih zarezima.';
$string['badwordsdefault'] = 'Ukoliko je vaš spisak nepristojnih/neprikladnih reči prazan, biće korišćen podrazumevani spisak jezičkog paketa. ';
$string['badwordslist'] = 'Lista nepristojnih/nepoželjnih reči';
$string['blockediplist'] = 'Spisak blokiranih IP adresa';
$string['blockinstances'] = 'Instance';
$string['blockmultiple'] = 'Višestruki';
$string['blockprotect'] = 'Zaštiti instance';
$string['blockprotect_help'] = 'Ako zaključate određeni tip bloka, onda niko neće moći da dodaje ili briše instance tog blokova. (Blok možete, naravno,  ponovo da otključavate, ukoliko želite da uredite njegove instance)

Svrha ove opcije je da se zaštite blokovi kao što su \'Navigacija\' i \'Podešavanja \', koje je teško povratiti ako se greškom obrišu.';
$string['blocksettings'] = 'Upravljanje blokovima';
$string['blockunprotect'] = 'Ukloni zaštitu';
$string['bloglevel'] = 'Vidljivost bloga';
$string['bookmarkadded'] = 'Obeleživač je dodat.';
$string['bookmarkalreadyexists'] = 'Već ste obeležili ovu stranicu.';
$string['bookmarkdeleted'] = 'Obeleživač je obrisan.';
$string['bookmarkthispage'] = 'Obeleži ovu stranicu';
$string['cacheapplication'] = 'Keš aplikacije';
$string['cacheapplicationhelp'] = 'Keširane stavke se dele između svih korisnika i ističu nakon određenog perioda (ttl).';
$string['cachejs'] = 'Keširaj Javascript';
$string['cachejs_help'] = 'Keširanje Javascripta i kompresija u velikoj meri poboljšava učitavanje stranice. Veoma se preporučuje za produkcione sajtove. Programeri će verovatno želeti da onemoguće ovu funkciju.';
$string['cacherequest'] = 'Keš zahteva';
$string['cacherequesthelp'] = 'Poseban korisnički keš koji ističe nakon što je zahtev ispunjen. Namena mu je da zameni oblasti gde smo koristili statičko čuvanje podataka.';
$string['cachesession'] = 'Keš sesije';
$string['cachesessionhelp'] = 'Poseban korisnički keš koji ističe nakon što korisnik završi sesiju. Namena mu je da smanji uvećanje/opterećenje sesije.';
$string['cachesettings'] = 'Podešavanja keša';
$string['cachetemplates'] = 'Šabloni keša';
$string['cachetemplates_help'] = 'Keširanje šablona će poboljšati performanse učitavanja stranice i preporučljivo je za produkcione sajtove. Programeri će verovatno želeti da isključe ovu funkciju.';
$string['caching'] = 'Keširanje';
$string['calendar_weekend'] = 'Dani vikenda';
$string['calendarexportsalt'] = 'Nasumični string (salt) za izvoz kalendara';
$string['calendarsettings'] = 'Kalendar';
$string['calendartype'] = 'Tip kalendara';
$string['calendartype_desc'] = 'Izabarite podrazumevani tip kalendara za čitav sajt. Ovo podešavanje može biti promenjeno u podešavanjima kursa ili od strane korisnika na njihovim stranicama profila.';
$string['cannotdeletemodfilter'] = 'Ne možete da deinstalirate filter \'{$a->filter}\' zato što je on deo modula \'{$a->module}\'';
$string['cannotuninstall'] = '{$a} nije moguće deinstalirati';
$string['categoryemail'] = 'E-pošta';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot je pogrešno definisan u config.php datoteci. Uključuje znak \'/\' na kraju koji mora biti uklonjen.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot je pogrešno definisan u config.php datoteci. Trebalo bi da se podudara sa URL adresom koju koristite za pristup ovoj stranici.';
$string['change'] = 'promeni';
$string['checkboxno'] = 'Ne';
$string['checkboxyes'] = 'Da';
$string['checkupgradepending'] = 'Nadogradnja';
$string['choosefiletoedit'] = 'Odaberi datoteku za uređivanje';
$string['cleanup'] = 'Čišćenje';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Graciozni izlaz, molim sačekajte...';
$string['cliexitnow'] = 'Izlazim ODMAH';
$string['cliincorrectvalueerror'] = 'Greška, neispravna vrednost "{$a->value}" za "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Neispravna vrednos, molim pokušajte ponovo';
$string['clistatusdisabled'] = 'Status onemogućen';
$string['clistatusenabled'] = 'Status omogućen';
$string['clistatusenabledlater'] = 'status: CLI režim održavanja biće omogućen {$a}';
$string['clitypevalue'] = 'otkucaj vrednost';
$string['clitypevaluedefault'] = 'otkucaj vrednost, pritisni Enter da biste upotrebili podrazumevanu vrednost ({$a})';
$string['cliunknowoption'] = 'Neprepoznate opcije:
{$a}
Molimo iskoristite opciju za pomoć.';
$string['cliupgradedefault'] = 'Novo podešavanje: {$a}';
$string['cliupgradedefaultheading'] = 'Podešavanje novih podrazumevanih vrednosti';
$string['cliupgradedefaultverbose'] = 'Novo podešavanje: {$a->name}, Podrazumevana vrednost: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Nadogradnja putem komande linije sa verzije {$a->oldversion} na verziju {$a->newversion} uspešno je završena.';
$string['cliupgradenoneed'] = 'Nije potrebna nadogradnja za instaliranu verziju {$}. U svakom slučaju hvala što ste došli !';
$string['cliupgradepending'] = 'Nadogradnja je na čekanju';
$string['cliyesnoprompt'] = 'unesi y (znači da) ili n (znači ne)';
$string['commentsperpage'] = 'Broj komentara prikazanih po stranici';
$string['commonactivitysettings'] = 'Opšta podešavanja';
$string['commonfiltersettings'] = 'Zajednička podešavanja filtera';
$string['commonsettings'] = 'Opšta podešavanja';
$string['componentinstalled'] = 'Komponenta je instalirana';
$string['computedfromlogs'] = 'Izračunato iz zapisa o aktivnostima od {$a}.';
$string['condifmodeditdefaults'] = 'Podrazumevane vrednosti se koriste u formama za podešavanje prilikom kreiranja nove aktivnosti ili resursa.';
$string['confeditorhidebuttons'] = 'Odaberite dugmad koja treba da budu skrivena u HTML editoru.';
$string['configallcountrycodes'] = 'Ovo je spisak zemalja koje mogu biti izabrane na raznim mestima, recimo u korisničkom profilu. Ako je spisak prazan (što je podrazumevana vrednost), koristiće se spisak iz countries.php koji je deo standardnog engleskog jezičkog paketa. Taj spisak je preuzet iz ISO 3166-1. U suprotnom potrebno je da navedete i dvoslovne oznake zemalja odvojene zarezom, npr. \'RS,GB,ES\'. Ako dodate nove, nestandardne oznake, moraćete da ih dodate i u countries.php datoteku, kako engleskog, tako i vašeg jezičkog paketа.';
$string['configallowassign'] = 'Možete dozvoliti ljudima koje imaju uloge navedene u prvoj koloni sa leve strane da drugim ljudima dodeljuju neke od uloga u ostalim kolonama.';
$string['configallowattachments'] = 'Ako je ova opcija omogućena. e-poruke poslate sa sajta mogu da sadrže priloge, kao što su bedževi.';
$string['configallowblockstodock'] = 'Ako je ovo podešavanje omogućeno, a to izabrana tema podržava, korisnici mogu da odaberu da premeštaju blokove u poseban dok (sa desne strane).';
$string['configallowcategorythemes'] = 'Ukoliko omogućite ovu opciju grafičke teme se mogu podeševati na nivou kategorija. To će uticati na sve podređene kategorije i kurseve koje već nemaju podešenu sopstvenu grafičku temu. UPOZORENjE: Omogućavanje izbora grafičke teme na nivou kategorija može uticati na performanse sistema.';
$string['configallowcohortthemes'] = 'Ukoliko omogućite ovu opciju, grafičke teme se mogu podešavati na nivou kohorte. Ovo će uticati na sve korisnike koji su članovi samo jedne kohorte ili više kohorti ali sa istom grafičkom temom.';
$string['configallowcoursethemes'] = 'Ako je omogućena ova opcija, biće dozvoljeno da se grafičke teme podese na nivou kursa. Grafička tema podešena na nivou kursa ima prvenstvo u odnosu na sva ostale mesta gde se teme mogu podesiti (npr, na nivou sajta, korisnika , kategorije, kohorte ili putem URL adrese).';
$string['configallowedemaildomains'] = 'Spisak domena e-adresa kojima je dopušteno da budu prikazane u polju "Od" odlazne e-poruke. Standardno podešavanja "Prazno" će koristiti e-adresu "ne-odgovaraj" (noreply@mojsajt.rs) za svu odlaznu e-poštu. Dozvoljena je upotreba džoker oznaka, npr. *.@mojsajt.rs će dozvoliti slanje e-pošte poslate sa bilo koje adrese poddomena mojsajt.rs, ali ne i sa samog domena mojsajt.rs. Potrebno je sam domen uneti zasebno.';
$string['configallowemailaddresses'] = 'Ako želite da ograničite nove e-adrese na određene domene, navedite ih ovde razdvojene razmacima. Svi ostali domeni biće odbijeni. Kako biste dozvolili korišćenje poddomena dodajte domen sa tačkom ispred. Kako biste dozvolili osnovni domen zajedno sa njegovim poddomenima, dodajte domen dva puta - jednom sa tačkom ispred i jednom bez nje. Na primer: .mojaskola.edu.rs mojaskola.edu.rs.';
$string['configallowemojipicker'] = 'Birač emodžija omogućava korisnicima da izaberu emodžije, poput smajlija, koje mogu da dodaju u poruke i druga tekstualna polja putem dugmeta za biranje emodžija u Atto traci sa alatkama.';
$string['configallowemojipickerincompatible'] = 'Vaša trenutna konfiguracija baze podataka nema odgovarajuću podršku za emodžije. Da biste omogućili birač emodžija potrebno je da <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> nadogradite vašu bazu za punu "Unicode" podršku</a>';
$string['configallowguestmymoodle'] = 'Ako je ova opcija omogućena gosti će moći da pristupe \'Kontrolnom panelu\', u suprotnom biće preusmereni na naslovnu stranicu sajta.';
$string['configallowobjectembed'] = 'Kao podrazumevana bezbednosna mera, krajnjim korisnicima nije dozvoljeno umetanje multimedijalnih sadržaja (poput Flash animacija) unutar teksta eksplicitno korišćenjem oznaka EMBED i OBJECT unutar HTML koda (iako je to i dalje moguće izvesti na sigurniji način putem mediaplugins filtera). Želite li ipak dozvoliti upotrebu ovih oznaka, uključite ovu opciju.';
$string['configallowoverride'] = 'Možete dozvoliti ljudima koje imaju uloge navedene u prvoj koloni sa leve strane da menjaju ovlašćenja uloga
navedenih u preostalim kolonama.';
$string['configallowoverride2'] = 'Izaberite koje uloge se kojim ulogama iz leve kolone mogu promeniti.<br /> Imajte u vidu podešavanja važe samo za one korisnike koji imaju dopuštene sposobnosti moodle/role:override ili moodle/role:safeoverride.';
$string['configallowswitch'] = 'Izaberite u koje uloge korisnik može preći, na osnovu onih uloga koje već poseduje. Pored unosa u ovoj tabeli, korisnik takođe mora posedovati ovlašćenje moodle/role:switchroles da bi mogao da promeni ulogu.<br />Zapazite da je jedino moguće izmeniti uloge koje imaju ovlašćenje moodle/course:view, a nemaju ovlašćenje moodle/site:doanything, pa su neke kolone ove tabele onemogućene.';
$string['configallowthemechangeonurl'] = 'Ako je ovo podešavanje omogućeno, grafička tema može da se promeni dodavanjem <br />?theme=themename bilo kojoj Moodle URL adresi (npr: mymoodlesite.com/?theme=afterburner ) ili <br />&theme=themename bilo kojoj internoj Moodle URL adresi (npr: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Da li želite da korisnicima omogućite da sami  skrivaju/prikazuju bočne blokove na ovom sajtu? Ovo svojstvo koristi Java skript i "kolačiće" kako bi se zapamtilo trenutno stanje blokova, i utiče jedino na izgled sajta pojedinačnog korisnika.';
$string['configallowusermailcharset'] = 'Ako je ova opcija omogućena, korisnici će moći da izaberu set karaktera za elektronsku poštu u svojim podešavanjima za slanje poruka.';
$string['configallowuserswitchrolestheycantassign'] = 'Kao podrazumevano podešavanje, zahteva se da korisnik ima ovlašćenje moodle/role:assign da bi mogao da menja uloge. Omogućavanjem ovog podešavanja ovde, uklanja se ovaj zahtev i za posledicu ima da se pojavljuje padajući spisak "Promeni ulogu u", koji je određen samo podešavanjima u tabeli "Dozvoli dodeljivanje uloga".
Preporučuje se da podešavanja u tabeli "Dozvoli dodeljivanje uloga" ne dozvoljavaju korisnicima da promene ulogu u onu sa većim ovlašćenjima od postojeće.';
$string['configallowuserthemes'] = 'Ukoliko omogućite ovu opciju, korisnicima će biti dozvoljeno da sami podese grafičku temu po svojoj želji. Teme koje izaberu korisnici imaju prednost u odnosu na grafičku temu podešenu na nivou sajta (ali ne i u odnosu na grafičku temu podešenu na nivou kursa).';
$string['configallowview'] = 'Izaberite koje uloge će korisnici videti, moći da ih filtriraju itd. na osnovu uloga koje već imaju.';
$string['configallusersaresitestudents'] = 'Za aktivnosti na početnoj stranici sajta, da li se SVI korisnici smatraju polaznicima? Ukoliko je odgovor "Da", onda će svakom korisniku sa otvorenim nalogom biti dozvoljeno da kao polaznik učestvuje u tim aktivnostima. Ukoliko je odgovor "Ne", onda će samo oni korisnici koji su upisani na najmanje jedan kurs moći da učestvuju u aktivnostima na početnoj strani. Samo administratori i posebno određeni predavači mogu da budu predavači za te aktivnosti.';
$string['configauthenticationplugins'] = 'Molimo odaberite dodatke za proveru identiteta koje želite da koristite i poređajte ih u redosledu smenjivanja u slučaju neuspeha. Samoregistracijom će upravljati dodatak odabran u koloni \'Registracija\' (obično \'e-pošta\')';
$string['configautolang'] = 'Ukoliko podrazumevani jezik na nivou sajt nije uključen, detektuj podrazumevani jezik Web čitača.';
$string['configautologinguests'] = 'Da li bi posetioci sajta trebalo da budu automatski prijavljeni na sistem kao gosti kada ulaze na neki od kurseva koji dozvoljavaju pristup gostima?';
$string['configbloglevel'] = 'Ovo podešavanje vam dozvoljava da ograničite nivo do kog će biti vidljivi blogovi korisnika na ovom sajtu. Imajte u vidu da ovo određuje najširi kontekst ČITAOCA, a ne autora ili tip blog članka. Blogovi mogu biti i potpuno onemogućeni ako uopšte ne želite da ih koristite.';
$string['configcalendarcustomexport'] = 'Omogući prilagođeni vremenski okvir izvoza kalendara';
$string['configcalendarexportsalt'] = 'Ovaj nasumični tekst se koristi za unapređenje bezbednosti tokena za proveru identiteta koji se koriste za izvoz kalendara. Imajte u vidu  da su svi tekući tokeni poništeni ukoliko promenite ovaj nasumični tekst ("hash salt")';
$string['configcookiehttponly'] = 'Omogućava novu PHP 5.2.0 funkciju - veb čitačima se zadaje da šalju kolačiće samo sa pravim http zahtevima; kolačići ne bi trebalo da budu dostupni skript jezicima. Ovo ne podržavaju svi veb čitači i možda neće biti u potpunosti kompatibilno sa trenutnim kôdom. Ovo, takođe, pomaže da se spreče neki tipovi XSS napada.';
$string['configcookiesecure'] = 'Ako server prihvata samo https konekcije, preporučljivo je omogućiti slanje bezbednih kolačića. Ako je podešavanje omogućeno, molimo proverite da veb server ne prihvata http:// ili podesite stalno preusmeravanje na https:// adresu, a bilo bi idealno da podesite HSTS zaglavlja. Kada <em>wwwroot</em> adresa ne počinje sa https:// ovo podešavanje se ignoriše.';
$string['configcountry'] = 'Ukoliko ovde podesite ime države, ono će biti izabrano kao podrazumevano u novootvorenim korisničkim nalozima. Ostavite ovo polje prazno kako bi ste primorali korisnike da sami izaberu državu iz koje su.';
$string['configcoursegraceperiodafter'] = 'Klasifikujte prošle kurseve kao da su u toku još ovoliko dana nakon datuma njihovog završetka.';
$string['configcoursegraceperiodbefore'] = 'Klasifikujte buduće kurseve kao da su u toku ovoliko dana pre datuma njihovog početka.';
$string['configcourseoverviewfilesext'] = 'Spisak dozvoljenih, zarezima razdvojenih, ekstenzija datoteka slika kursa.';
$string['configcourseoverviewfileslimit'] = 'Maksimalan broj datoteka koji se može prikazati pored rezimea kursa na stranici sa spiskom kurseva. Prva dodata slika se koristi kao slika kursa u pregledu kurseva na korisnikovom Kontrolnom panelu; sve dodatne datoteke se prikazuju samo na stranici sa spiskom kurseva';
$string['configcourserequestnotify'] = 'Upišite korisničko ime korisnika koji će biti obavešteni kada se pojavi zahtev za pokretanje novog kursa.';
$string['configcourserequestnotify2'] = 'Korisnici koji će biti obavešteni kada se pojavi zahtev za pokretanje novog kursa. Ovde su navedeni samo korisnici koji mogu odobriti zahtev za pokretanje kursa.';
$string['configcoursesperpage'] = 'Unesite broj kurseva koji će na spisku kurseva biti prikazan po jednoj stranici.';
$string['configcourseswithsummarieslimit'] = 'Maksimalan broj kurseva za prikazivanje na spisku kurseva, uključujući njihov rezimea, pre povratka na jednostavniji spisak kurseva (bez rezimea).';
$string['configcronclionly'] = 'Pokretanje krona iz veb čitača može da otkrije poverljive informacije anonimnim korisnicima. Zbog toga se preporučuje da se kron pokreće samo iz komandne linije, ili, da se za udaljeni pristup kronu postavi lozinka.';
$string['configcronremotepassword'] = 'Ovo znači da cron.php skripta ne može da se pokrene iz veb čitača ukoliko se ne obezbedi lozinka, koristeći sledeći oblik URL adrese:<pre>    https://site.example.com/admin/cron.php?password=opensesame
</pre>Ukoliko se ovo ostavi prazno, lozinka nije potrebna.';
$string['configcurlcache'] = 'Vreme trajanja cURL keša, u sekundama';
$string['configcustommenuitems'] = 'Ovde se može podesiti prilagođeni meni. Unesite svaku stavku menija u novi red u sledećem formatom: tekst menija, URL adrese linka (opciono, ne za stavku koja se nalazi u korenu menija i koja ima podstavke), kratak opis stavke (opciono) i oznaka jezika, odnosno spisak oznaka jezika, odvojenih zarezom, (opciono, za prikaz tog reda isključivo korisnicima navedenog jezika); svi elementi stavke su međusobno odvojeni vertikalnom crtom |. Redovi koji počinju crticom pojaviće se kao stavke unutar podmenija stavke koja je višeg nivoa. Stavke u meniju mogu se razdvojiti dodavanjem reda sa jednim ili više znakova #. Na primer:
<pre>
Kursevi
-Svi kursevi|/course/
-Pretraga kurseva|/course/search.php
-###
-FAQ|https://someurl.xyz/faq
-Često postavljana pitanja|https://someurl.xyz/pmf||sr_cr
Moodle mobilna aplikacija|https://someurl.xyz/app|Preuzmite našu aplikaciju
</pre>';
$string['configcustomusermenuitems'] = 'Možete konfigurisati sadržaj menija korisnika (sa izuzetkom linka za odjavu, koji se automatski dodaje). Svaki red u meniju odvojen je znakom | i sastoji se od 1) stringa u formatu "langstringname, componentname" ili u obliku običnog teksta, 2) URL adrese i 3) ikonice, bilo kao pikselske slike (u direktorijumu pix sa strukturom [subfoldername]/[iconname], npr. i/publish) ili kao URL adrese slike. Tamo gde je potrebno može se koristiti razdelnik dodavanjem reda sa jednim ili više znakova #.';
$string['configdbsessions'] = 'Ako je omogućeno, ovo podešavanje će koristiti bazu podataka za pohranjivanje informacije o tekućim sesijama. Imajte u vidu da:će promena ovog podešavanja prekinuti sesije svih trenutno aktivnih korisnika (uključujući i vas). Ukoliko koristite MySQL proverite da li je vrednost za \'max_allowed_packet\' u my.cnf (ili my.ini) datoteci  barem 4M. Drugi drajveri sesija mogu se direktno konfigurisati u config.php datoteci; za više informacija pogledajte datoteku config-dist.php. Ova opcija nestaje ako navedete drajver sesije u datoteci  config.php.';
$string['configdebug'] = 'Ukoliko uključite ovu opciju onda će biti povećan broj izvešataja o greškama PHP-a (error_reporting). Ova opcija je korisna jedino onima koji razvijaju Moodle.';
$string['configdebugdisplay'] = 'Ako je ova opcija uključena, obaveštavanje o greškama će biti prosleđeno na HTML stranicu. Ovo je praktično, ali generalno nije kompatibilno sa XHTML, JS, kolačićima i HTTP zaglavljem. Ako je isključeno, izlazne informacije biće prosleđene u zapise vašeg servera, omogućavajući tako bolje uklanjanje grešaka. PHP podešavanje error_log kontroliše u koji zapis idu ove informacije.';
$string['configdebugpageinfo'] = 'Uključite ukoliko želite da se informacije o stranici prikazuju u njenom podnožju.';
$string['configdebugvalidators'] = 'Uključite ako u podnožju stranice želite imati linkove na spoljne servere za proveru ispravnosti. Možda će biti potrebno da kreirate novog korisnika sa korisničkim imenom <em>w3cvalidator</em>, i omogućiti mu gostujući pristup. Ove izmene mogu dozvoliti neovlašćeni pristup serveru, ne uključujte na zvanično aktivnim Web lokacijama!';
$string['configdefaulthomepage'] = 'Ovo podešavanje određuje prvi link u navigaciji za korisnike prijavljene na sistem.';
$string['configdefaultrequestcategory'] = 'Kursevi čije pokretanje zahtevaju korisnici, koji imaju mogućnost da zahtevaju nove kurseve u kontekstu sistema, biće smešteni u ovu kategoriju, osim ako korisnici nemaju mogućnost da izabere neku drugu kategroiju.';
$string['configdefaultrequestedcategory'] = 'Podrazumevana kategorija za smeštanje zahtevanih kurseva, ukoliko su isti odobreni.';
$string['configdefaultuserroleid'] = 'Svim korisnicima, prijavljenim  na sistem, biće date mogućnosti uloge koju ovde navedete, na nivou sajta, kao DODATAK na eventualne druge uloge koje možda već imaju. Podrazumevana je uloga autorizovanog korisnika. Imajte u vidu da ovo neće biti u suprotnosti sa drugim ulogama koje korisnici imaju, osim ako ne zabranite mogućnosti.
Ovo samo osigurava da svi korisnici imaju sposobnosti koje nije moguće dodeliti na nivou kursa (npr. pisanje blog članaka, uređivanje sopstvenog kalendara itd.)';
$string['configdeleteincompleteusers'] = 'Po isteku ovog perioda, svi nalozi kod kojih nisu popunjena polja za ime, prezime ili e-adresu se brišu.';
$string['configdeleteunconfirmed'] = 'Za određene metode provere identiteta, kao što je samostalna registracija putem e-pošte, korisnici moraju potvrditi svoj nalog unutar određenog vremensko perioda. Nakon ovog perioda svi stari nepotvrđeni nalozi biće obrisani.';
$string['configdenyemailaddresses'] = 'Da biste onemogućili elektronske adrese sa određenih domena navedite ih ovde na isti način. Svi drugi domeni biće prihvaćeni. Na primer <strong>hotmail.com yahoo.co.uk neželjeni.domen.com</strong>';
$string['configdisableuserimages'] = 'Isključite mogućnost da korisnici menjaju slike u korisničkim profilima';
$string['configdisplayloginfailures'] = 'Ovo će korisnicima prikazati informacije o prethodnim neuspešnim pokušajima prijave na sistem.';
$string['configdndallowtextandlinks'] = 'Omogućite ili onemogućite postavljanje teksta i linkova, zajedno sa datotekama, pomoću opcije \'prevuci i spusti\'. Imajte na umu da je prevlačenje teksta u Fajerfoksu ili između različitih veb čitača nepouzdano i da kao posledicu može imati da podaci ili tekst ne budu postavljeni.';
$string['configdoclang'] = 'Ovaj jezik će se koristiti u linkovima za stranice dokumentacije.';
$string['configdocroot'] = 'Definiše putanju do Moodle dokumentacije za pružanje kontekstualne podrške putem linkova "Moodle dokumentacija za ovu stranicu" u podnožju svake stranice. Ako se ovo polje ostavi prazno ti linkovi se neće prikazivati.';
$string['configdoctonewwindow'] = 'Ako ovo omogućite, linkovi do Moodle dokumentacije će biti prikazani u novom prozoru.';
$string['configeditordictionary'] = 'Ova vrednost se koristi ako aspell nema rečnik za jezik korisnika.';
$string['configeditorfontlist'] = 'Izaberite fontove koji će se pojaviti u listi raspoloživih fontova pri korišćenju editora.';
$string['configemailchangeconfirmation'] = 'Zahtevaj potvrdu putem e-pošte kada korisnici promene svoju elektronsku adresu u svom profilu.';
$string['configemailfromvia'] = 'Dodajte informaciju o pošiljaocu poruke u polju "Od" odlazne poruke. Ovo će primaoca poruke obavestiti o tome ko je poruku poslao. Istovremeno, ovo će biti od  pomoći u situacijama kada primaoci poruka slučajno pokušaju da svoj odgovor pošalju na e-adresu "ne-odgovaraj".';
$string['configemailsubjectprefix'] = 'Tekst koji prethodi naslovu teme svih odlaznih poruka';
$string['configenableactivitychooser'] = 'Birač aktivnosti je okvir za dijalog sa kratkim opisom svake aktivnosti i resursa. Ako je onemogućen, biće umesto njega dostupni posebni padajući meniji za resurse i aktivnosti.';
$string['configenableanalytics'] = 'Analitički modeli, kao što su \'Polaznici izloženi riziku od napuštanja kursa\' ili \'Aktivnosti koje se uskoro završavaju\', mogu da generišu predviđanja, šalju obaveštenja o uvidu i nude druge akcije poput slanja poruka korisnicima.';
$string['configenableblogs'] = 'Ovajj prekidač omogućava svim korisnicima sajta da koriste svoj blog';
$string['configenablecalendarexport'] = 'Omogući izvoz ili prijavu na kalendare';
$string['configenablecomments'] = 'Omogući komentare';
$string['configenablecourserequests'] = 'Ako je omogućeno, korisnici koji imaju sposobnost da zatraže nove kurseve (moodle/course:request) imaće opciju da zatraže kurs. Ova sposobnost nije dozvoljena ni za jednu od standardnih uloga. Može se primeniti u kontekstu sistema ili kategorije.';
$string['configenabledevicedetection'] = 'Omogućava detekciju mobilnih i pametnih telefona, tableta ili standardnih uređaja (stoni ili prenosivi računari, itd.) zbog primene grafičkih tema i drugih funkcija.';
$string['configenablemobilewebservice'] = 'Omogućite primenu mobilnih servisa za zvaničnu Moodle aplikaciju ili druge aplikacije koji to zahtevaju. Za više informacija pročitajte {$a}';
$string['configenablerssfeeds'] = 'Ova je opcija omogućena, RSS izvori će biti generisani na čitavom sajtu od strane različiti modula aktivnosti kao što su blogovi, forumi. baze podataka i rečnici. Imajte u vidu da RSS servis, takođe, treba da bude omogućen na nivou podešavanja pojedinačnog modula aktivnosti.';
$string['configenablerssfeedsdisabled'] = 'RSS servis nije dostupan, zato što njegovo korišćenje nije omogućeno na nivou celog sajta. Da bi ste omogućili korišćenje RSS-a, idite na stranicu za podešavanja promenljivih u okviru administratorske konfiguracije.';
$string['configenablerssfeedsdisabled2'] = 'RSS izvori vesti su onemogućeni na nivou sajta. Mogu se aktivirati podešavanjem Naprednih svojstava u Administraciji sajta.';
$string['configenablestats'] = 'Ako ovde izaberete opciju "Da", kron proces vašeg Moodlea će obraditi zapise i prikupiti neke statističke informacije. U zavisnosti od količine saobraćaja na vašem sajtu to može potraje neko vreme. Ako ovu opciju omogućite, moći ćete da vidite neke zanimljive grafikone i statističke izveštaje o svakom od vaših kurseva, ili na nivou celog sajta.';
$string['configenabletrusttext'] = 'Prema podrazumevanim podešavanjima Moodle će uvek temeljno prečistiti tekst koji dolazi od korisnika, kako bi uklonio eventualne zlonamerne skriptove, multimedijalne i druge sadržaje koji bi mogli predstavljati bezbednosni rizik. Sistem Pouzdanog sadržaja (Trusted Content system) predstavlja način da pojedinim korisnicima, kojima verujete, dozvolite da dodaju i takve napredne sadržaje bez dodatne provere. Da biste omogućili ovaj sistem prvo morate da uključite ovo podešavanje, a potom da odobrite dozvolu za Pouzdani sadržaj odgovarajućoj Moodle ulozi. Tekstovi koje kreiraju ili postavljaju takvi korisnici biće označeni kao pouzdani i neće biti podvrgnuti prečišćavanju pre prikaza.';
$string['configenablewebservices'] = 'Veb servisi omogućavaju drugim sistemima, poput Moodle aplikacije, da se prijave na sajt i izvedu različite operacije. Zbog dodatne bezbednosti ovo podešavanje treba da bude isključena, ako ne koristite Moodle aplikaciju, ili neki eksterni alat/servis koji zahtevaju integraciju putem veb servisa.';
$string['configenablewsdocumentation'] = 'Uključite automatsko generisanje dokumentacije o Web servisima. Korisnik može pristupiti sopstvenoj dokumentaciji na svojoj stranici bezbednosnih ključeva {$a}. Stranica prikazuje dokumentaciju samo za dozvoljene protokole. ';
$string['configerrorlevel'] = 'Odaberite nivo PHP upozorenja koja će Vam se prikazivati na ekranu. Postavka Normal je obično najbolji odabir.';
$string['configexportlookahead'] = 'Dana unapred za praćenje u toku izvoza';
$string['configexportlookback'] = 'Dana unazad za praćenje tokom izvoza';
$string['configextendedusernamechars'] = 'Ako je omogućeno, korisnička imena mogu da sadrže bilo koje znakove, osim velikih slova. U suprotnom, biće dozvoljeni samo alfanumerički znakovi sa malim slovima, donja crta (_), crtica (-), tačka (.) ili simbol "et" (@).';
$string['configextramemorylimit'] = 'Pojedini skriptovi kao što je pretraga, pravljenje rezervnih kopija ili kron zahtevaju više memorije. Za velike sajtove postavite više vrednosti.';
$string['configfilterall'] = 'Filtrirajte sve stringove, uključujući zaglavlja, naslove, navigacijsku traku Ovo je uglavnom korisno kada se koristi višejezični filter, jer će u suprotnom dodatno opteretiti sajt uz malu ili nikakvu korist.';
$string['configfiltermatchoneperpage'] = 'Filteri za automatsko linkovanje će generisati samo jedan link za prvu odgovarajuću instancu (pojavljivanje) teksta koja se nalazi na celoj stranici. Sva ostala pojavljivanja teksta se ignorišu.';
$string['configfiltermatchonepertext'] = 'Filteri za automatsko linkovanje će generisati samo jedan link za prvu odgovarajuću instancu (pojavljivanje) teksta koja se nalazi u svakoj stavci teksta na stranici. Sva ostala pojavljivanja teksta se ignorišu. Ovo podešavanje nema efekta ako je uključeno podešavanje \'Filtriraj podudaranje jednom po stranici\'.';
$string['configfilteruploadedfiles'] = 'Procesiranje svih postavljenih HTML i tekstualnih datoteka filterima pre njihovog prikazivanja, procesiranje samo postavljenih HTML datoteka ili bez procesiranja.';
$string['configforcelogin'] = 'Pod normalnim okolnostima, ljudi će moći da vide naslovnu stranu sajta i spisak kurseva (ali ne i same kurseve) bez prethodnog prijavljivanja. Ukoliko želite da primorate ljude da se prijave pre nego što vide BILO ŠTA na sajtu, onda bi trebalo da omogućite ovo podešavanje.';
$string['configforceloginforprofiles'] = 'Ovo podešavanje primorava ljude da se na sistem prijave sa pravim nalozima (ne kao gosti) pre nego što budu u prilici da vide stranice sa korisničkim profilima. Ako ste onemogućili ovo podešavanje može se desiti da neki korisnici u svoje profile postavljaju reklame ili drugi neprikladan sadržaj, koji će onda biti vidljiv svima na internetu.';
$string['configfrontpage'] = 'Gore izabrane stavke biće prikazane na naslovnoj stranici sajta.';
$string['configfrontpagecourselimit'] = 'Maksimalan broj kurseva';
$string['configfrontpagecourselimithelp'] = 'Maksimalan broj kurseva koji se prikazuje na naslovnoj stranici sajta u okviru spiska kurseva.';
$string['configfrontpageloggedin'] = 'Gore izabrane stavke biće prikazane na naslovnoj stranici sajta kada je korisnik prijavljen na sistem.';
$string['configfullnamedisplay'] = 'Ovo definiše način na koji će biti prikazano ime i prezime. Podrazumevana vrednost, "language", ostavlja da vrednost stringa "fullnamedisplay" u tekućem jezičkom paketu odredi način prikaza. Pojedini jezici imaju različite konvencije za prikaz imena.

Za većinu jednojezičkih sajtova najefikasnije podešavanje je "Ime Prezime", ali možete da izaberete da potpuno sakrijete prezimena. Oznake koje mogu da se koriste su: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename i alternatename.';
$string['configgeoipfile'] = 'Lokacija GeoLite2 City binarne datoteke. Ova datoteka nije deo Moodle distribucije i mora biti zasebno preuzeta sa <a href="http://www.maxmind.com/">MaxMind</a>. Možete, ili da kupite komercijalnu ili da koristite besplatnu verziju. Morate se registrovati da biste preuzeli datoteku City baze, što možete učiniti na <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Kad se registrujete i preuzmete tu datoteku, raspakujte je u direktorijum "{$a}" na svom serveru.';
$string['configgetremoteaddrconf'] = 'Ako je Vaš server iza povratnog (reverse) proksija, možete koristiti ovo podešavanje da podesite za koja HTTP zaglavlja se može verovati da sadrže udaljenu adresu. Zaglavlja se čitaju po redu, koristi se prvo dostupno.';
$string['configgradebookroles'] = 'Ova opcija vam omogućava da kontrolišete ko se pojavljuje u knjizi ocena. Potrebno je da korisnici imaju barem jednu od ovih uloga na kursu kako bi bili prikazani u knjizi ocena za taj kurs.';
$string['configgradeexport'] = 'Odaberite koji formati za izvoz knjige ocena su Vaši primarni metodi za izvoz ocena. Izabrani dodaci će onda postaviti i koristiti polje "last exported" za svaku ocenu. Na primer, ovo može kao rezultat dati izvezene ocene označene kao "nove" ili "ažurirane". Ako niste sigurni šta želite da postignete ovim podešavanjima, slobodno ostavite sve opcije nepotvrđene.';
$string['confighiddenuserfields'] = 'Izaberite koja polja sa korisničkim informacijama želite da sakrijete od drugih korisnika koji nisu predavači na kursu ili administratori. Ovo će povećati privatnost korisnika. Držite CTRL taster da biste izabrali više polja.';
$string['configidnumber'] = 'Ova postavka određuje (a) hoće li korisnici uopšte biti pitani za ID broj, (b) hoće li korisnici biti pitani za ID broj, ali će navedeno polje moći ostaviti prazno ili (c) hoće li korisnicima unos u polje ID broj biti obavezan. Ako je ID broj unet, isti se prikazuje u njihovom profilu.';
$string['configintro'] = 'Na ovoj stranici možete da navedete brojne konfiguracione promenljive koje će pomoći da Moodle pravilno funkcioniše na vašem serveru. Ne brinite previše o tome - podrazumevane vrednosti obično su potpuno adekvatne. Kasnije se možete vratiti na ovu stranicu i promeniti podešavanja prema potrebi.';
$string['configintroadmin'] = 'Potrebno je da na ovoj stranici konfigurišite svoj glavni administratorski nalog koji će imati potpunu kontrolu nad sajtom. Proverite da li ste nalogu dodelili bezbedno korisničko ime i lozinku, kao i ispravnu elektronsku adresu. Kasnije možete kreirati dodatne administratorske naloge.';
$string['configintrosite'] = 'Ova stranica vam omogućava da konfigurišete izgled naslovne stranice i naziv sajta. Uvek se možete naknadno vratiti na ovu stranicu kako biste promenili ova podešavanja, koristeći meni za administraciju.';
$string['configiplookup'] = 'Kada kliknete na IP adresu (poput. 34.12.222.93), na primer u zapisima o aktivnostima, biće vam prikazana mapa sa najpribližnijom procenom lokacije te IP adrese. Postoje različiti dodaci koje možete da izaberete za ovu funkciju, pri čemu svaki ima svoje prednosti i mane.';
$string['configkeeptagnamecase'] = 'Čekirajte ovo ako želite da imena oznaka (tagova) zadrže originalna velika i mala slova kako su ih uneli kreatori';
$string['configlang'] = 'Izaberite podrazumevani jezik za ceo sajt. Korisnici mogu da promene ovo podešavanje koristeći jezički meni ili podešavanje u okviru svog ličnog profila.';
$string['configlanglist'] = 'Ako je ostavljeno prazno, svi jezici instalirani na sajtu biće prikazani u jezičkom meniju. Alternativno, možete skratiti jezički meni tako što ćete uneti spisak željenih jezičkih kôdova odvojenih zarezom. Na primer: en,sr,de,fr. Ako želite, drugačiji naziv za jezik od naziva jezičkog paketa možete ga navesti u formatu: language code|language name npr. en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Izaberite da li želite da prikažete jezički meni na početnoj stranici, stranici za prijavljivanje na sistem, itd. Ovo ne utiče na mogućnost korisnika da sam podesi preferirani jezik u ličnim podešavanjima (stavka \'Parametri\' u korisničkom meniju).';
$string['configlangstringcache'] = 'Kešira sve jezičke izraze (stringove) u kompajlirane datoteke, smeštene u direktorijumu za podatke. Ako prevodite Moodle ili menjate postojeće izraza u izvornom kôdu Moodlea, možda ćete želeti ovo da isključite. U suprotnom, ostavite uključeno kako biste videli koristi za performanse sistema.';
$string['configlatinexcelexport'] = 'Odaberite kodiranje za izvoz Excel dokumenata.';
$string['configlocale'] = 'Odaberite lokalna podešavanja na nivou celog sajta, što će uticati na oblik prikaza i jezik na kojem se ispisuju datumi. Neophodno je da u okviru Vašeg operativnog sistema imate instaliranu podršku za  odgovarajući jezik (npr. eng_US ili sr). Ako ne znate šta biste odabrali, ostavite ovo polje praznim.';
$string['configlockrequestcategory'] = 'Ako je omogućeno, korisnici sa ovlašćenjem za pokretanje novih kurseva u kontekstu sistema neće moći da biraju kategoriju u formi za zahtevanje novog kursa. Alternativni način ograničavanja korisnika da mogu da zahtevaju novi kurs samo u okviru jedne kategorije je postavljanjem ovlašćenja za zahtevanje novih kurseva u kontekst kategorije.';
$string['configloglifetime'] = 'Ovo podešavanje određuje koliko dugo želite da čuvate zapise o aktivnostima korisnika. Zapisi koji su stariji biće automatski obrisani. Najbolje je da zapise o aktivnostima čuvate što je moguće duže, u slučaju da vam zatrebaju, ali ukoliko imate jako opterećen server i ukoliko imate probleme sa njegovim performansama, možda ćete želeti da skratiti vremenski period njihovog čuvanja. Vrednosti manje od 30 dana se ne preporučuju zato što statistika možda neće ispravno funkcionisati.';
$string['configlookahead'] = 'Dana za praćenje unapred';
$string['configmailnewline'] = 'Oznake za novi red koji se koriste u elektronskom porukama. Prema RFC 822bis zahteva se oznaka CRLF. Neki serveri za elektronsku poštu automatski konvertuju oznaku LF u CRLF, drugi serveri nekorektno konvertuju CRLF u CRCRLF, dok ostali odbijaju elektronske poruke koje koriste oznaku LF (qmail na primer). Pokušajte da promenite ovo podešavanje ukoliko imate problema sa neisporučenim elektronskim porukama i dvostrukim novim redovima.';
$string['configmaxbytes'] = 'Ovo podešavanje određuje maksimalnu veličinu datoteka koje se mogu postaviti na sajt. Ovo podešavanje je ograničeno PHP podešavanjima post_max_size i upload_max_filesize, kao i podešavanjem Apache servera LimitRequestBody. Zauzvrat, maxbytes ograničava opseg veličina koje se mogu odabrati na nivou kursa ili aktivnosti. Ako je izabrana opcija \'Ograničenja sajta  za postavljanje\' biće korišćena maksimalna veličina koju dozvoljava server.';
$string['configmaxconsecutiveidentchars'] = 'Lozinke ne smeju imati više od ovog broja istovetnih znakova za redom. Upotrebite 0 kako biste isključili ovu opciju.';
$string['configmaxeditingtime'] = 'Određuje vreme koje korisnici imaju na raspolaganju za naknadno uređivanje poruka na forumima, komentara u rečnicima itd. Obično je 30 minuta sasvim dovoljno.';
$string['configmaxevents'] = 'Broj događaja za praćenje unapred';
$string['configmaxusersperpage'] = 'Maksimalan broj korisnika koji se prikazuje unutar birača korisnika za kurs, grupu, kohortu, veb servis itd.';
$string['configmessaging'] = 'Ako je omogućeno, korisnici mogu da šalju poruke drugim korisnicima na sajtu.';
$string['configmessagingallowemailoverride'] = 'Dozvoli da se korisnicima obaveštenja šalju na adresu e-pošte različitu od one koja je navedena u njihovom profilu';
$string['configmessagingallusers'] = 'Ako je omogućeno, korisnici mogu da vide spisak svih korisnika na sajtu kada izaberu nekoga za slanje poruke, a njihovi parametri za poruke uključuju opciju za prihvatanje poruka od bilo koga na sajtu. Ako je onemogućeno, korisnici mogu samo da vide spisak korisnika na svojim kursevima i imaju samo dve opcije na raspolaganju u parametrima za poruke - da prihvate poruke samo od svojih kontakata, ili od svojih kontakata i bilo koga na svojim kursevima.';
$string['configmessagingdefaultpressenter'] = 'Da li je podrazumevano aktivirana opcija "Pošalji pritiskom na taster Enter" u korisničkim podešavanjima vezanim za slanje poruka.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Pročitana i nepročitana obaveštenja mogu da se obrišu kako bi se uštedeo prostor. Koliko dugo nakon što je kreirano obaveštenja može da se obriše?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Obaveštenja o pročitanim porukama mogu se obrisati kako bi se sačuvao prostor. Nakon koliko vremena posle čitanja mogu biti obrisana?';
$string['configminpassworddigits'] = 'Lozinke moraju imati najmanje ovoliko brojeva.';
$string['configminpasswordlength'] = 'Lozinke moraju da sadrže najmanje ovoliko znakova.';
$string['configminpasswordlower'] = 'Lozinke moraju da sadrže najmanje ovoliko malih slova.';
$string['configminpasswordnonalphanum'] = 'Lozinke moraju da sadrže najmanje ovoliko ne-alfanumeričkih znakova.';
$string['configminpasswordupper'] = 'Lozinke moraju da sadrže najmanje ovoliko velikih slova.';
$string['configmodchooserdefault'] = 'Da li bi trebalo birač aktivnosti, standardno, prikazati korisnicima?';
$string['configmycoursesperpage'] = 'Maksimalan broj kurseva za prikaz na bilo kojoj korisnikovoj listi kurseva';
$string['configmymoodleredirect'] = 'Ovo podešavanje čini obaveznim preusmeravanje na /my pri pristupu sistemu svih korisnika osim administratora i menja postavku osnovnog nivoa sajta na /my';
$string['configmypagelocked'] = 'Ovo podešavanje sprečava da korisnici koji nisu administratori uređuju podrazumevane stranice, poput naslovne stranice sajta.';
$string['confignavcourselimit'] = 'Ograničava broj kurseva prikazanih korisniku  u navigaciji.';
$string['confignavshowallcourses'] = 'Ovo podešavanje određuje da li korisnici, upisani na kurseve, mogu da pored bloka \'Moji kursevi\' (spisak kurseva na koje su upisani). da vide i blok \'Kursevi\' (spisak svih kurseva).';
$string['confignavshowcategories'] = 'Prikaži kategorije kurseva u navigacionoj traci i u blokovima za navigaciju Ovo se ne odnosi na kurseve u koje je korisnik trenutno upisan, jer će kursevi biti prikazani u meniju pod Moji kursevi, bez navođenja kategorija.';
$string['confignoreplyaddress'] = 'Povremeno se u ime korisnika šalje elektronska pošta (npr. kopije njihovih poruka na forumima). Elektronska adresa koju ovde unesete biće korišćena u zaglavlju poruke tj. u polju "Od" u slučajevima kada oni koji poruku primaju ne mogu direktno odgovoriti korisniku (tj. kada korisnik izabere da njegova elektronska adresa bude nedostupna ostalim korisnicima).';
$string['confignotifyloginfailures'] = 'Pošalji poruke o neuspešnim prijavama na sistem izabranim korisnicima. Ovo zahteva da interno skladišta zapisa (npr. Standardno skladište zapisa - Standard Logstore) bude omogućeno.';
$string['confignotifyloginthreshold'] = 'Ukoliko je opcija za registrovanje neuspešnih pristupa aktivna, koliki je minimum pogrešnih pristupa po jednom korisniku odnosno jednoj IP adresi neophodan da bi obaveštenje o tome bilo poslato?';
$string['confignotloggedinroleid'] = 'Korisnici koji nisu prijavljeni na sistem biće tretirani kao da im je ova uloga dodeljena u kontekstu sajta. Skoro uvek je uloga gosta ono što biste poželeli za takve slučajeve, ali na ovaj način imate mogućnost da koristite uloge kreirane kao manje ili više restriktivne. Ipak, akcije kao što je slanje poruka na forume i tome slično zahtevaju da korisnik propisno pristupi sistemu.';
$string['configopentowebcrawlers'] = 'Ukoliko uključite ovo podešavanje, onda će Google-u biti omogućeno da ulazi na Vaš sajt kao gost. Osim toga ljudi koji na Vaš sajt budu dolazili posredstvom Google pretraga automatski će biti prijavljeni kao gosti. Napomena: ovo omogućava pristup samo onim kursevima koji i inače dozvoljavaju pristup sa nalogom za gosta.';
$string['configoverride'] = 'Definisano u config.php datoteci';
$string['configpasswordpolicy'] = 'Ako je ova opcija omogućena, korisničke lozinke biće proverena da li su u skladu sa važećim pravilima za kreiranje lozinki kao što je to naznačeno u dole navedenim podešavanjima. Omogućavanje pravila za kreiranje lozinke neće uticati na postojeće korisnike sve dok oni ne odluče da promene svoju lozinku ili ne budu u obavezi da je promene, ili dok nije omogućeno podešavanje \'Proveri lozinku prilikom prijave\'.';
$string['configpasswordpolicycheckonlogin'] = 'Ako je omogućeno, proveravaće se da li su korisničke lozinke u skladu sa pravilima za kreiranje lozinki pri svakoj prijavi korisnika. Ukoliko provera ne uspe, od korisnika će se zahtevati da promeni lozinku pre nego što bude mogao da nastavi.
Korisno je omogućiti ovo podešavanje nakon izmene pravila za kreiranje lozinki.';
$string['configpasswordresettime'] = 'Ovo određuje vreme koje korisnici imaju na raspolaganju kako bi potvrdili zahtev za resetovanje lozinke, pre nego što ono istekne. Obično je 30 minuta sasvim odgovarajuće vreme.';
$string['configpathtodu'] = 'Putanja do du. Verovatno nešto poput /usr/bin/du. Ako ovo unesete, stranice koje prikazuju sadržaj direktorijuma će raditi mnogo brže za direktorijume sa mnogo datoteka.';
$string['configpathtophp'] = 'Putanja do PHP CLI. Verovatno nešto poput /usr/bin/php. Ako unesete ovo, kron skripte se mogu izvršiti iz administratorskog veb interfejsa.';
$string['configperfdebug'] = 'Ako ovo uključite, informacije o performansama biće prikazane u podnožju standardne grafičke teme';
$string['configprofileroles'] = 'Spisak uloga koje su vidljive na korisničkim profilima i stranici sa spiskom učesnika.';
$string['configprofilesforenrolledusersonly'] = 'Da bi se sprečila zloupotreba od strane spamera, polje za opis na stranici sa profilom korisnika, koji se još nisu upisali ni na jedan kurs, je sakriveno. Novi korisnici moraju da se upišu barem na jedan kurs kako bi mogli da dodaju opis.';
$string['configprotectusernames'] = 'Ako je ova opcija omogućena, obrazac za zaboravljenu lozinku neće prikazivati nikakvu pomoć za pogađanje korisničkih imena ili adresa elektronske pošte.';
$string['configproxybypass'] = 'Spisak (delimičnih) naziva računara ili IP adresa (odvojenih zarezom) koje bi trebalo da premoste proksi (e.g., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Ukoliko ovaj <b>server</b> mora da koristi proksi računar (npr. "zaštitni zid") za pristup internetu, unesite ovde adresu proksija. U suprotnom ostavite ovo polje prazno.';
$string['configproxypassword'] = 'Lozinka potrebna za pristup internetu putem proksi servera, ukoliko je to neophodno. Ostavite prazno ukoliko proksi server nije potreban (neophodna je PHP cURL ekstenzija)';
$string['configproxyport'] = 'Ako ovaj server mora da koristi proksi računar, navedite ovde port za proksi.';
$string['configproxytype'] = 'Tip veb proksi servera (PHP5 i cURL ekstenzija su neophodni za podršku za SOCKS5)';
$string['configproxyuser'] = 'Korisničko ime potrebno za pristup internetu putem proksi servera ukoliko je to neopohodno. Ostaviti prazno ukoliko proksi nije potreban (neophodna je PHP cURL ekstenzija)';
$string['configrecaptchaprivatekey'] = 'Niz znakova (tajni ključ) koji se koristi za komunikaciju između vašeg Moodle servera i recaptcha servera. ReCAPTCHA ključevi se mogu nabaviti na sajtu <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Niz znakova (ključ sajta) koji se koristi za prikaz reCAPTCHA elementa na obrascu za prijavu. ReCAPTCHA ključevi se mogu nabaviti na sajtu <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestcategoryselection'] = 'Dozvoli izbor kategorije prilikom podnošenja zahteva za kurs.';
$string['configrequestedstudentname'] = 'Reč za polaznika koja se koristi u zahtevanim kursevima';
$string['configrequestedstudentsname'] = 'Reč za polaznike koja se koristi u zahtevanim kursevima';
$string['configrequestedteachername'] = 'Reč za predavača koja se koristi u zahtevanim kursevima';
$string['configrequestedteachersname'] = 'Reč za predavače koja se koristi u zahtevanim kursevima';
$string['configreverseproxyignore'] = 'Ako je vaš server iza višestrukih reverznih proksija koji dodaju  X-Forwarded-For zaglavlje, u tom slučaju navedite listu vrednosti odvojenih zapetama koja sadrži IP adrese ili podmreže reverznih proksija koje treba ignorisati kako bi našli ispravnu IP adresu korisnika.';
$string['configsectioninterface'] = 'Interfejs';
$string['configsectionmail'] = 'Pošta';
$string['configsectionmaintenance'] = 'Održavanje';
$string['configsectionmisc'] = 'Razno';
$string['configsectionoperatingsystem'] = 'Operativni sistem';
$string['configsectionpermissions'] = 'Ovlašćenja';
$string['configsectionrequestedcourse'] = 'Zahtevi za pokretanje novog kursa';
$string['configsectionsecurity'] = 'Bezbednost';
$string['configsectionstats'] = 'Statistika';
$string['configsectionuser'] = 'Korisnik';
$string['configsecureforms'] = 'Moodle može da koristi dodatni nivo bezbednosti kada prima podatke iz veb obrazaca. Ukoliko je to omogućeno, onda se HTTP_REFERER promenljiva veb čitača upoređuje sa tekućom adresom obrasca. U veoma malom broju slučajeva to može prouzrokovati probleme ako korisnik upotrebljava "zaštitni zid" (npr. Zonealarm) konfigurisan tako da uklanja HTTP_REFERER promenljivu iz veb saobraćaja. Posledica toga je tzv. "zaglavljivanje u obrascu". Ukoliko Vaši korisnici imaju problema, na primer, sa stranicom za prijavljivanje, možda ćete želeti da onemogućite ovo podešavanje, iako će to vaš sajt učiniti daleko osetljivijim na hakerske napade razbijanja lozinki grubom silom. Ukoliko ste u dilemi, omogućite ovu opciju.';
$string['configsessioncookie'] = 'Ovo podešavanje prilagođava ime "kolačića" za Moodle sesije. Podešavanje je opciono i korisno je samo da bi se izbegla mešanje "kolačića", u situaciji kada je u okviru istog Web sajta pokrenuto više od jedne kopije Moodlea.';
$string['configsessioncookiedomain'] = 'Ovo Vam dozvoljava da menjate domen sa kog su Moodle kolačići dostupni. To je korisno za razna prilagođavanja Moodlea (npr. dodaci za proveru identiteta ili upis) koji moraju da dele informacije o Moodle sesiji sa Web aplikacijom na drugom poddomenu. <strong>UPOZORENJE: toplo preporučujemo da ovo podešavanje ostavite prazno (podrazumevana vrednost) - neispravna vrednost će sprečiti bilo kakvu prijavu na sajt.</strong>';
$string['configsessioncookiepath'] = 'Ako je potrebno da promenite gde veb čitači šalju Moodle "kolačiće", možete promeniti ovo podešavanje tako što ćete odredite poddirektorijum svog veb sajta. Inače, standardna vrednost \'/\' trebalo bi da je sasvim prihvatljiva.';
$string['configsessiontimeout'] = 'Ukoliko su korisnici koji su prijavljeni na sajt, neaktivni duži vremenski period (ne učitavaju stranice), biće automatski odjavljeni (njihove sesije biće završene). Ova promenljiva određuje koliko treba da bude ovo vreme.';
$string['configshowcommentscount'] = 'Prikaži broj komentara. Biće potrebno izvršiti samo jedan upit više prilikom prikaza linka komentara.';
$string['configshowicalsource'] = 'Prikaži izvorne informacije za ical događaje';
$string['configshowsiteparticipantslist'] = 'Svi ovi polaznici i predavači na nivou sajta biće prikazani na spisku učesnika. Kome će biti dozvoljeno da vidi ovaj spisak učesnika?';
$string['configsitedefaultlicense'] = 'Podrazumevana licenca na nivou sajta';
$string['configsitedefaultlicensehelp'] = 'Podrazumevana licenca za objavljivanje sadržaja na ovom sajtu';
$string['configsitemailcharset'] = 'Ovo podešavanje određuje podrazumevani kodni raspored za sve poruke e-pošte poslate sa sajta.';
$string['configsitemaxcategorydepth'] = 'Maksimalan broj potkategorija';
$string['configsitemaxcategorydepthhelp'] = 'Ovo određuje maksimalan broj potkategorija koji će se pojaviti kada se prikazuju kategorije ili kombinovana lista. Niži nivo kategorija će pojaviti kao linkovi koje će korisnik moći da proširi pomoću AJAX zahteva.';
$string['configslasharguments'] = 'Argumenti sa obrnutom kosom crtom (slash arguments) (korišćenjem <em>PATH_INFO</em>) su neophodni da bi se SCORM paketi i resursi koji sadrže više datoteka pravilno prikazivali. Ako vaš Web server ne podržava takve argumente i niste u mogućnosti da tu podršku obezbedite, ovo podešavanje može biti onemogućeno, s tim da treba imati na umu da pomenuti tipovi resursa neće biti pravilno prikazivani.<br />Napomena: U narednim verzijama sistema će aktivacija korišćenja tih argumenata biti obavezna.';
$string['configsmartpix'] = 'Ako se ova opcija uključi ikonice će učitavati PHP skript koji pretražuje tekuću grafičku temu sajta, potom sve nadređene teme, i konačno Moodle /pix direktorijum. Ovo smanjuje potrebu za čuvanjem duplikata slika unutar tema, ali pomalo utiče na performanse sistema.';
$string['configsmtpauthtype'] = 'Ovo postavlja tip provere identiteta koji će se koristiti na smtp serveru.';
$string['configsmtphosts'] = 'Navedite punu adresu jednog ili više lokalnih SMTP servera koje Moodle treba da koristi za slanje e-pošte (npr. mail.a.com ili mail.a.com;mail.b.com). Da biste odredili nestandardni port (tj. različit od porta 25), možete da koristite sintaksu [sever]:[port] (npr. \'mail.a.com:587\'). Ukoliko polje ostavite prazno Moodle će za slanje e-pošte koristiti podrazumevani PHP metod.';
$string['configsmtpmaxbulk'] = 'Maksimalan broj poruka poslatih po jednoj SMTP sesiji. Grupisanje poruka može da ubrza slanje elektronske pošte.  Vrednosti manje od 2 dovode do kreiranja nove SMTP sesije za svaku elektronsku poruku.';
$string['configsmtpsecure'] = 'Ako SMTP server zahteva bezbednu vezu, navedite tačan tip protokola.';
$string['configsmtpuser'] = 'Ako ste prethodno naveli SMTP server i ako on traži proveru identiteta unesite korisničko ime i lozinku';
$string['configstartwday'] = 'Početak nedelje';
$string['configstatsfirstrun'] = 'Ovo određuje koliki će se vremenski ići unazad prilikom obrade zapisa o aktivnostima, <b>prvi put</b> kada kron proces želi da obradi statističke podatke. Ako imate dosta saobraćaja i na deljenom ste serveru, verovatno nije dobra ideja da idete previše unazad, jer bi moglo biti potrebno previše vremena za izvršavanje procesa i ta aktivnost bi bila prilično zahtevna za server. (Imajte na umu da je za ovo podešavanje 1 mesec = 28 dana. Na grafikonima i u izveštajima koji se generišu 1 mesec odgovara jednom kalendarskom mesecu).';
$string['configstatsmaxruntime'] = 'Obrada statističkih podataka može biti prilično intenzivna, pa je najbolje da koristite kombinaciju ovog i sledećeg polja kako biste odredili kada će se obrada pokrenuti i koliko dugo će trajati.';
$string['configstatsmaxruntime2'] = 'Statistička obrada može biti prilično intezivna. Odredite maksimalno vreme koje se dopušta za prikupljanje statističkih podataka za jedan dan. Maksimalni broj dana koji se obrađuje u jednom izvršenju krona je 31.';
$string['configstatsmaxruntime3'] = 'Ovo određuje maksimalno dozvoljeno vreme za izračunavanje statistike za jedan dan. Imajte u vidu da obrada statističkih podataka može u velikoj meri opteretiti server. Maksimalna broj dana obrađenih u jednom kronu može biti dole određen.';
$string['configstatsruntimedays'] = 'Ovo određuje maksimalan broj dana koji se obrađuje prilikom svakog procesuiranja statistike. Kada je statistika ažurna, samo će se jedan dan obrađivati - zato podesite ovu vrednost zavisno od opterećenja vašeg servera, smanjujući je ako su potrebna kraća pokretanja krona.';
$string['configstatsruntimestart'] = 'U koje vreme treba da započne sa izvršavanjem kron obrada statističkih podataka? Ukoliko na serveru ima više Moodle sajtova, preporučljivo je navesti različita vremena.';
$string['configstatsuserthreshold'] = 'Ovo podešavanje određuje minimalan broj upisanih korisnika, potreban da bi kurs bio uključen u statističko izračunavanje.';
$string['configstrictformsrequired'] = 'Ako je ovo podešavanje omogućeno, korisnicima neće biti dozvoljeno da unose razmak ili prelaz u novi red, ali samo unutar obaveznih polja u obrascima.';
$string['configstripalltitletags'] = 'Isključite ovo podešavanje kako biste omogućili HTML oznake u nazivima aktivnosti i resursa.';
$string['configsupportemail'] = 'Ova adresa elektronske pošte će se prikazivati korisnicima sajta kao ona na koju treba pisati kad im je potrebna neka opšta pomoć (na primer kad novi korisnici kreiraju svoje naloge). Ako se ne popuni ovo polje, onda takva korisna adresa neće biti dostupna.';
$string['configsupportname'] = 'Ovo je ime osobe/organizacije zadužene za pružanje opšte pomoći korisnicima putem elektronske pošte ili Web sajta.';
$string['configsupportpage'] = 'Ova Web adresa će se prikazivati korisnicima sajta kao ona koju treba posetiti u slučaju da im zatreba neka opšta pomoć (na primer kad novi korisnici kreiraju svoje naloge). Ako se ne popuni ovo polje, takav link neće biti dostupan.';
$string['configtempdatafoldercleanup'] = 'Ukloni iz direktorijuma sa podacima privremene datoteke, koje su starije od izabranog vremenskog perioda.';
$string['configthemedesignermode'] = 'Uobičajeno je da se sve slike grafičke teme kao i CSS datoteke na duži vremenski period keširaju u veb čitaču i na serveru, zbog brzine izvršavanja. Ako dizajnirate teme ili razvijate izvorni kôd, verovatno ćete želite da uključiti ovaj režim rada kako bi ste izbegli da dobijate verzije iz keša. Upozorenje: ovo će usporiti vaš sajt za sve korisnike! Alternativno, možete da resetujete keš ručno na stranici za izbor teme.';
$string['configthemelist'] = 'Ostavite ovo polje prazno da biste dozvolili upotrebu bilo koje grafičke teme. Ukoliko želite da skratite listu tema, ovde možete da navedite spisak njihovih naziva, razdvojenih zarezima (nemojte koristiti razmake!).
Na primer: standard,orangewhite.';
$string['configtimezone'] = 'Ovo je podrazumevana vremenska zona za prikazivanje datuma - svaki korisnik može da promeni ovo podešavanje u svom profilu. Zadaci krona i ostala podešavanja servera navedeni su u ovoj vremenskoj zoni. Ako je prikazano "Neispravna vremenska zona" potrebno je da promenite podešavanje.';
$string['configuseblogassociations'] = 'Da li je potrebno da korisnici mogu da organizuju svoje blogove povezivanjem članaka sa kursevima i modulima kursa?';
$string['configuseexternalyui'] = 'Umesto lokalnih datoteka, koristite onlajn datoteke dostupne na Yahoo serverima. UPOZORENJE: Ovo zahteva Internt konekciju, ili AJAX uopšte neće raditi na Vašem sajtu.';
$string['configuserquota'] = 'Maksimalan broj bajtova koje korisnik može da sačuva u svom prostoru za privatne datoteke. {$a->bytes} bajtova == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Ako je ovo podešavanje omogućeno, onda će se u navigaciji za stranice sajta, umesto fraze \'Stranice sajta\', koristiti skraćeni naziv sajta.';
$string['configusetags'] = 'Da li treba omogućiti oznake (tagove) na čitavom sajtu?';
$string['configvariables'] = 'Promenljive';
$string['configverifychangedemail'] = 'Omogućava potvrdu promenjenih e-adresa koristeći podešavanje za dozvoljene i zabranjene domene e-adresa. Ukoliko je ovo podešavanje isključeno ograničenje domena će biti korišćeno samo prilikom kreiranja novih korisničkih naloga.';
$string['configvisiblecourses'] = 'Prikaži normalno kurseve koji su u skrivenim kategorijama.';
$string['configwarning'] = 'Budite oprezni pri menjanju ovih podešavanja - neobične vrednosti mogu izazvati probleme u radu.';
$string['configyuicomboloading'] = 'Ova opcija omogućava optimizaciju učitavanje kombinovanih datoteka YUI biblioteke. Ovo podešavanje treba da bude uključeno na produkcionim sajtovima zbog boljih performansi.';
$string['confirmation'] = 'Potvrda';
$string['confirmcontextlock'] = '{$a->contextname} je trenutno odmrznut. Zamrzavanje će ga učiniti dostupnim samo za čitanje i sprečiće korisnike da prave izmene. Jeste li sigurni da želite da nastavite?';
$string['confirmcontextunlock'] = '{$a->contextname} je trenutno zamrznut. Odmrzavanje će omogućiti korisnicima da prave izmene. Jeste li sigurni da želite da nastavite?';
$string['confirmdeletecomments'] = 'Obrisaćete komentare. Da li ste sigurni?';
$string['confirmed'] = 'Potvrđeno';
$string['contenttypeuninstalling'] = 'Postoji {$a->count} sadržaj(a) podržanih od {$a->type}. Sadržaji će biti izbrisani. Da li ste sigurni da želite da nastavite?';
$string['contextlockappliestoadmin'] = 'Zamrzavanje konteksta odnosi se na administratore';
$string['contextlockappliestoadmin_desc'] = 'Ako je onemogućeno, administratori ostaju sa pravom upisivanja u bilo kom zamrznutom kontekstu.';
$string['contextlocking'] = 'Zamrzavanje konteksta';
$string['contextlocking_desc'] = 'Ovo podešavanje omogućava da pristup samo za čitanje bude postavljeno za izabrane kategorije, kurseve, aktivnosti odnosno blokove.';
$string['cookiehttponly'] = 'Samo http kolačići';
$string['cookiesecure'] = 'Samo bezbedni kolačići';
$string['country'] = 'Podrazumevana država';
$string['course_customfield'] = 'Prilagođena polja kursa';
$string['coursecolor'] = 'Boja {$a}';
$string['coursecolorheading_desc'] = 'Svi kursevi za koje nije postavljena slika u osnovnim podešavanjima kursa se na kontrolnom panelu prikazuju u vidu šrafirane kartice kursa. Boje koje se koriste mogu da se specificiraju niže.';
$string['coursecolorsettings'] = 'Boje kartice kursa';
$string['coursecontact'] = 'Kurs - kontakt osobe';
$string['coursecontact_desc'] = 'Ovo podešavanje vam omogućava da odredite ko se pojavljuje na stranici sa opisom kursa. Korisnici moraju da imaju barem jednu od ovih uloga na kursu kako bi njihova imena bila prikazani pored opisa tog kursa.';
$string['coursecontactduplicates'] = 'Prikažite sve uloge kontakt osobe za kurs';
$string['coursecontactduplicates_desc'] = 'Ako je omogućeno, korisnici koji imaju više od jedne uloge izabrane da budu kontakt osobe za kurs, biće prikazani u opisu kursa sa svim svojim ulogama. U suprotnom, biće prikazani samo sa jednom ulogom (koja ja navedena kao najviši na stranici \'Definiši uloge\' u okviru Administracije sajta).';
$string['coursegraceperiodafter'] = 'Dodatno vreme za prošle kurseve';
$string['coursegraceperiodbefore'] = 'Dodatno vreme za buduće kurseve';
$string['courselistshortnames'] = 'Prikaži pune nazive kurseva';
$string['courselistshortnames_desc'] = 'Ako je ova opcija omogućena, na spisku kurseva, pored punih naziva, biće prikazani i skraćeni nazivi kurseva. Ako je neophodno, puni nazivi kurseva se mogu prilagoditi uređivanjem jezičkog stringa \'courseextendednamedisplay\', koristeći mogućnost za prilagođavanje jezika.';
$string['coursemgmt'] = 'Upravljanje kursevima i kategorijama';
$string['courseoverview'] = 'Pregled kurseva';
$string['courserequestnotify'] = 'Obaveštenje o zahtevu za pokretanje novog kursa';
$string['courserequestnotifyemail'] = 'Korisnik {$a->user} je zatražio/la novi kurs na {$a->link}';
$string['courserequests'] = 'Zahtevi za pokretanje novog kursa';
$string['courserequestspending'] = 'Zahtevi za pokretanje kurs na čekanju';
$string['courses'] = 'Kursevi';
$string['coursesperpage'] = 'Broj kurseva po stranici';
$string['courseswithsummarieslimit'] = 'Broj kurseva sa rezimeom';
$string['creatornewroleid'] = 'Uloga kreatora u novim kursevima';
$string['creatornewroleid_help'] = 'Ukoliko korisnik već nema ovlašćenja da upravlja novim kursom, onda je automatski upisan koristeći ovu ulogu';
$string['cron'] = 'Kron';
$string['cron_help'] = 'Cron.php pokreće brojne zadataka u različitim vremenskim intervalima, kao što je slanje kopija novih poruka sa foruma putem e-pošte. Potrebno je redovno pokretanje kron skripte - idealno svakog minuta.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Pokretanje krona isključivo preko komandne linije';
$string['cronerrorclionly'] = 'Nažalost, pristup ovoj stranici je onemogućen od strane administratora.';
$string['cronerrorpassword'] = 'Žao nam je, niste uneli ispravnu lozinku da biste pristupili ovoj stranici';
$string['croninfrequent'] = 'Vreme između poslednja dva pokretanja kron skripte za održavanje bilo je {$a->actual}, a trebalo bi da se skripta pokreće svake {$a->expected}. Preporučujemo da kron konfigurišete tako da se češće pokreće.';
$string['cronremotepassword'] = 'Kron lozinka za udaljeni pristup';
$string['cronwarning'] = '<a href="{$a->url}">Skript admin/cron.php</a> nije pokretan poslednjih {$a->actual}, a trebalo bi na svakih  {$a->expected}.';
$string['cronwarningcli'] = '<code>admin/cli/cron.php</code> skript nije pokretan {$a->actual} a trebalo bi da se izvršava na svakih {$a->expected}.';
$string['cronwarningnever'] = 'Skript <code>admin/cli/cron.php</code> nikada nije pokrenut, a trebalo bi na svakih  {$a->expected}.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">Skript admin/cron.php</a> nikada nije pokrenut, a trebalo bi na svakih  {$a->expected}.';
$string['ctyperequired'] = 'PHP ekstenzije ctype je sada obavezna za Moodle, kako bi se unapredile performanse sajta i obezbedila višejezična kompatibilnost.';
$string['curlcache'] = 'cURL keš TTL';
$string['curlrequired'] = 'PHP ekstenzijа cURL sada je obavezna za Moodle zbog komunikacije sa Moodle repozitorijumima.';
$string['curlsecurityallowedport'] = 'Spisak dozvoljenih portova za cURL';
$string['curlsecurityallowedportsyntax'] = 'Spisak brojeva portova sa kojima cURL može da se poveže. Ispravni unosi su samo celobrojne vrednosti. Unesite svaki broj porta u zaseban red. Ako se ostavi prazno onda su dozvoljeni svi portovi. Ako je podešeno, u skoro svim slučajevima, i port 443 i port 80 treba navesti za povezivanje sa standardnim HTTP i HTTPS portovima.';
$string['curlsecurityblockedhosts'] = 'Spisak blokiranih računara za cURL';
$string['curlsecurityblockedhostssyntax'] = 'Unesite svaki računar u novi red. Ispravni unosi su ili IPv4 ili IPv6 adrese (kao na primer 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) koje odgovaraju jednom računaru; ili CIDR notacija (kao na primer 231.54.211.0/20 ili fe80::/64); ili opseg IP adresa (kao na primer 231.3.56.10-20 ili fe80::1111-bbbb) gde se opseg odnosi na poslednju grupu adrese; ili nazivi domena (kao na primer localhost ili example.com); ili nazivi domena sa džoker znacima (kao na primer *.example.com ili *.sub.example.com). Prazni redovi nisu dozvoljeni.';
$string['curlsecurityurlblocked'] = 'URL adresa je blokirana.';
$string['curltimeoutkbitrate'] = 'Brzina protoka u bitovima koja se koristi prilikom izračunavanja vremena čekanja za cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Ovo podešavanje se koristi za izračunavanje odgovarajućeg tajm-auta kod velikih cURL zahteva. Kao deo ovog proračuna kreira se HTTP HEAD zahtev kako bi se odredila veličina sadržaja. Postavljanjem ovog parametra na 0 onemogućava se kreiranje ovog zahteva.';
$string['currenttheme'] = 'Trenutna grafička tema';
$string['customcheck'] = 'Druge provere';
$string['custommenu'] = 'Prilagođeni meni';
$string['custommenuitems'] = 'Stavke prilagođenog menija';
$string['customusermenuitems'] = 'Stavke korisničkog menija';
$string['datarootsecurityerror'] = '<p><strong>BEZBEDNOSNO UPOZORENjE!</strong></p><p>Vaš direktorijum sa podacima je na pogrešnom mestu i moguće mu je pristupiti sa veba. To znači da su sve vaše privatne datoteke dostupne svakome ko ima pristup internetu, pa neke od njih mogu iskoristiti zlonamerni korisnici kako bi dobili neautorizovan administratorski pristup vašem sajtu!</p>
<p><em>Morate</em> da premestite direktorijum sa podacima ({$a}) na novu lokaciju koja nije u okviru vašeg javnog veb direktorijuma, a potom da ažurirate <code>$CFG->dataroot</code> podešavanje u datoteci config.php u skladu sa načinjenim promenama.</p>';
$string['datarootsecuritywarning'] = 'Konfiguracija vašeg sajta možda nije bezbedna. Molimo proverite da li vaš direktorijum podataka ({$a}) nije direktno dostupan preko veba.';
$string['dbprefixtoolong'] = 'Prefiks vaše baze podataka ($CFG->prefix) je predugačak (trenutno, broj znakova iznosi: {$a->current}). Maksimalni dozvoljeni broj znakova je {$a->maximum}.';
$string['dbsessions'] = 'Koristite bazu podataka za informacije o sesijama';
$string['debug'] = 'Poruke za otklanjanje grešaka';
$string['debugall'] = 'SVE: Prikaži sve razumljive PHP poruke o greškama';
$string['debugdeveloper'] = 'RAZVOJNE: Prikaži dodatne Moodle poruke o greškama, namenjene samo programeri';
$string['debugdisplay'] = 'Prikaži poruke za otklanjanje grešaka';
$string['debugging'] = 'Otklanjanje grešaka';
$string['debugminimal'] = 'MINIMALNO: Prikaži samo fatalne greške';
$string['debugnone'] = 'BEZ PORUKE: Ne prikazuj greške ili upozorenja';
$string['debugnormal'] = 'NORMALNO: Prikaži greške, upozorenja i obaveštenja';
$string['debugpageinfo'] = 'Prikaži informacijе o stranici';
$string['debugstringids'] = 'Prikaži poreklo jezičkih izraza';
$string['debugstringids_desc'] = 'Kada je ova opcija omogućena, ako URL adresi dodate parametar ?strings=1 ili &strings=1, to će prikazati jezičku datoteku i identifikator stringa pored svakog izraza.';
$string['debugvalidators'] = 'Prikaži link ka servisima za proveru validnosti';
$string['defaultcity'] = 'Podrazumevani grad';
$string['defaultcity_help'] = 'Grad koji ovde unesete biće podrazumevani grad za sve novootvorene korisničke naloge.';
$string['defaultformatnotset'] = 'Greška prilikom određivanja podrazumevanog formata kursa. Proverite podešavanja sajta.';
$string['defaulthomepage'] = 'Početna stranica za korisnike';
$string['defaultrequestcategory'] = 'Podrazumevana kategorija za zahtevane kurseve';
$string['defaultsettinginfo'] = 'Podrazumevana vrednost: {$a}';
$string['defaultuserroleid'] = 'Podrazumevana uloga za sve korisnike';
$string['deleteincompleteusers'] = 'Obriši nepotpune korisničke naloge nakon';
$string['deleteunconfirmed'] = 'Obriši nepotvrđene korisnike nakon';
$string['deleteuser'] = 'Obriši korisnika';
$string['density'] = 'Gustina';
$string['denyemailaddresses'] = 'Nedozvoljeni domeni e-pošte';
$string['development'] = 'Razvoj';
$string['devicedetectregex'] = 'Regularni izrazi za detekciju uređaja';
$string['devicedetectregex_desc'] = '<p>Standardno, Moodle može da detektuje podrazumevani tip uređaja (stoni i prenosivi računari itd.), mobilni uređaj (pametni telefoni, ručni računari) tablet (iPad, Android tableti) kao i starije tipove Web čitača (Internet Explorer 6 korisnici). Pomoću selektora grafičke teme moguće je za svaki od ovih tipova uređaja podesiti zasebnu tema. Ovo podešavanje dozvoljava korišćenje regularnih izraza koji omogućavaju detekciju dodatnih tipova uređaja (ovi imaju prednost u odnosu na podrazumevane tipove).</p>
<p>Na primer, možete da unesete regularni izraz \'/(MIDP-1.0|Maemo|Windows CE)/\'  za detekciju nekih najčešće korišćenih telefona dodajte povratnu vrednost \'featurephone\'. Ovo dodaje \'featurephone\' u selektor grafičke teme što će vam omogućiti da dodate temu koja će se koristiti na ovim uređajima. Ostali telefoni će i dalje koristiti temu koja je izabrana za mobilne uređaje.</p>';
$string['devicedetectregexexpression'] = 'Regularni izrazi';
$string['devicedetectregexvalue'] = 'Povratna vrednost';
$string['devicetype'] = 'Tip uređaja';
$string['devlibdirpresent'] = 'Direktorijumi sa razvojnim bibliotekama, posebno <em>vendor</em> i <em>node_modules</em> ne bi trebalo da budu prisutni na javnim sajtovima. Za više informacija pogledajte <a href="{$a->moreinfourl}">izveštaj o bezbednosti</a>.';
$string['disabled'] = 'Onemogućeno';
$string['disableuserimages'] = 'Isključi slike u korisničkom profilu';
$string['displayerrorswarning'] = 'Omogućavanje podešavanja u PHP-u <em>display_errors</em> nije preporučljivo na produkcionim sajtovima, jer neke poruke o greškama mogu otkriti osetljive informacije o vašem serveru.';
$string['displayloginfailures'] = 'Prikaži neuspešne prijave';
$string['dndallowtextandlinks'] = 'Postavljanje teksta/linkova pomoću opcije \'prevuci i spusti\'';
$string['doclang'] = 'Jezik za dokumentaciju';
$string['docroot'] = 'Korenski direktorijum Moodle dokumentacije';
$string['doctonewwindow'] = 'Otvoriti u novom prozoru';
$string['doesnotfit'] = 'Podešavanja prikaza e-pošte';
$string['doesnotfitdetail'] = 'Podešavanja prikaza za e-poštu koja se šalje sa Moodlea.';
$string['download'] = 'Preuzmi';
$string['durationunits'] = 'jedinice trajanja:';
$string['edithelpdocs'] = 'Uređivanje dokumenata pomoći';
$string['editlang'] = '<b>Uredi</b>';
$string['editorbackgroundcolor'] = 'Boja pozadine';
$string['editordictionary'] = 'Editor rečnika';
$string['editorfontfamily'] = 'Familija fontova';
$string['editorfontlist'] = 'Spisak fontova';
$string['editorfontsize'] = 'Veličina fonta';
$string['editorhidebuttons'] = 'Sakrivena dugmad';
$string['editorkillword'] = 'Filter Word formata';
$string['editorspelling'] = 'Editor pravopisa';
$string['editorspellinghelp'] = 'Uključi/isključi proveru pravopisa. Kada je uključeno, <strong>aspell</strong> mora biti instaliran na serveru.';
$string['editstrings'] = 'Uređivanje reči ili izraza';
$string['emailchangeconfirmation'] = 'Potvrda izmene adrese e-pošte';
$string['emailfromvia'] = 'Informacija o pošiljaocu poruke';
$string['emailsubjectprefix'] = 'Tekst koji prethodi temi e-poruke';
$string['emoticonalt'] = 'Alternativni tekst';
$string['emoticoncomponent'] = 'Grafička komponenta emotikona';
$string['emoticonimagename'] = 'Naziv slike';
$string['emoticons'] = 'Emotikoni';
$string['emoticons_desc'] = 'Na ovoj stranici možete podesiti emotikone koji se koriste na vašem sajtu. Kako biste uklonili red iz tabele (odnosno neki emotikon) obrišite sadržaj bilo kog od zahtevanih polja i sačuvajte obrazac. Za dodavanje novog emotikona, popunite polja u poslednjem praznom redu. Za resetovanje svih polja na podrazumevane, početne vrednosti kliknite na gornji link.

* Tekst (obavezno) - ovaj tekst će biti zamenjen sa slikom emotikona. Mora sadržati bar 2 znaka.
* Naziv slike (obavezno) - naziv datoteka sa slikom emotikona (bez ekstenzije), relativno u odnosu na pix direktorijum komponente.
* Grafička komponenta (obavezno) - komponenta koja obezbeđuje ikonicu.
* Alternativni tekst (opciono) - identifikator stringa i komponenta alternativnog teksta emotikona.';
$string['emoticonsreset'] = 'Resetuj podešavanja emotikona na podrazumevane vrednosti';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Prazno';
$string['enableactivitychooser'] = 'Omogući birač aktivnosti';
$string['enableanalytics'] = 'Analitika';
$string['enableblogs'] = 'Omogući blog';
$string['enablecalendarexport'] = 'Omogući izvoz kalendara';
$string['enablecomments'] = 'Omogući komentare';
$string['enablecourserelativedates'] = 'Omogući relativne datume kursa';
$string['enablecourserelativedates_desc'] = 'Dozvoli da se kursevi podese tako da prikazuju datume relativno u odnosu na datum prvog pristupa kursu od strane svakog korisnika.';
$string['enablecourserequests'] = 'Omogući slanje zahteva za pokretanje novih kurseva';
$string['enabled'] = 'Omogućeno';
$string['enabledevicedetection'] = 'Omogućite detekciju uređaja';
$string['enableglobalsearch'] = 'Omogući globalnu pretragu';
$string['enableglobalsearch_desc'] = 'Ako je ova opcija uključena podaci će biti indeksirani i sinhronizovani pomoću planiranog zadatka.';
$string['enablegravatar'] = 'Omogući Gravatar';
$string['enablegravatar_help'] = 'Kada je ova opcija omogućena Moodle će pokušati da preuzme sliku za profil sa Gravatara, ako korisnik nije postavio svoju sliku.';
$string['enablemobilewebservice'] = 'Omogućite veb servise za mobilne uređaje';
$string['enablerecordcache'] = 'Uključi keš za zapis podataka';
$string['enablerssfeeds'] = 'Omogući RSS izvore vesti';
$string['enablesearchareas'] = 'Omogući oblasti za pretragu';
$string['enablestats'] = 'Omogući statistiku';
$string['enabletrusttext'] = 'Omogući pouzdani sadržaj';
$string['enableuserfeedback'] = 'Omogući povratne informacije o ovom softveru';
$string['enableuserfeedback_desc'] = 'Ako je ova opcija omogućena, u podnožju se prikazuje link \'Pošaljite povratne informacije o ovom softveru\' kako bi korisnici mogli da daju povratne informacije o Moodle softveru Moodle HQ-u. Ako je podešena opcija \'Sledeći podsetnik za povratne informacije\', korisniku se takođe prikazuje podsetnik na Kontrolnom panelu u određenom intervalu. Ako se \'Sledeći podsetnik za povratne informacije\' podesi na \'Nikad\', podsetnik će biti onemogućen na Kontrolnom panelu, dok će link \'Pošaljite povratne informacije o ovom softveru\' biti prikazan u podnožju stranice.';
$string['enablewebservices'] = 'Omogući Web servise';
$string['enablewsdocumentation'] = 'Dokumentacija Web servisa';
$string['enrolinstancedefaults'] = 'Podrazumevane vrednosti instance upisa';
$string['enrolinstancedefaults_desc'] = 'Podrazumevana podešavanja upisa u novim kursevima';
$string['enrolmultipleusers'] = 'Upisati korisnike';
$string['environment'] = 'Okruženje';
$string['environmenterrortodo'] = 'Morate rešiti sve probleme okruženja (greške) navedene iznad pre nastavka instalacije ove Moodle verzije!';
$string['environmenterrorupgrade'] = 'UPOZORENjE: Potrebno je da rešiti sve pronađene probleme okruženja (greške) pre nego što nastavite sa nadogradnjom ove verzije Moodlea. Prelazak na novu verziju bez ispravljanja pronađenih grešaka može dovesti do probleme kao što je gubitak podataka. Da li ste sigurni da želite da nastavite nadogradnju?';
$string['environmentmariadbwrongdbtype'] = 'Pogrešan tip baze <code>$CFG->dbtype</code>: morate uneti izmenu u vašu <code>config.php</code> datoteku, sa \'<code>mysql</code>\' na \'<code>mariadb</code>\'.';
$string['environmentmustfixsetting'] = 'PHP podešavanje mora biti promenjeno.';
$string['environmentok'] = 'Vaše serversko okruženje zadovoljava sve minimalne zahteve.';
$string['environmentrecommendcustomcheck'] = 'ukoliko ovaj test ne prođe, postoji mogućnost pojavljivanja potencijalnog problema.';
$string['environmentrecommendinstall'] = 'je preporučljivo instalirati/omogućiti da bi se dobili najbolji rezultati';
$string['environmentrecommendversion'] = 'preporučena verzija je {$a->needed} a vi trenutno koristite verziju {$a->current}';
$string['environmentrequirecustomcheck'] = 'Ovaj test mora proći';
$string['environmentrequireinstall'] = 'mora biti instaliran i omogućen';
$string['environmentrequireversion'] = 'neophodna verzija je {$a->needed} a vi trenutno koristite verziju {$a->current}';
$string['environmentsettingok'] = 'detektovano je preporučeno podešavanje';
$string['environmentshouldfixsetting'] = 'PHP podešavanje bi trebalo biti promenjeno.';
$string['environmentxmlerror'] = 'Greška u čitanju podataka okruženja ({$a->error_code})';
$string['errordeletingconfig'] = 'Došlo je do greške prilikom brisanja konfiguracionih zapisa za dodatak \'{$a}\'.';
$string['errorsetting'] = 'Nije moguće sačuvati podešavanje';
$string['errorwithsettings'] = 'Neka podešavanja nisu promenjena zbog greške.';
$string['eventshandlersinuse'] = 'Sledeći dodaci u vašem sistemu koriste Events 1 API, odnosno zastarele procedure za obradu događaja: \'{$a}\'. Molimo ažurirajte ih da bi koristili Events 2 API. Pogledajte https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Svako ko može \'{$a}\'';
$string['exceptions'] = 'izuzeci';
$string['execpathnotallowed'] = 'Podešavanje izvršnih i lokalnih putanja u datoteci config.php je onemogućeno';
$string['experimental'] = 'Eksperimentalno';
$string['experimentalsettings'] = 'Eksperimentalna podešavanja';
$string['extendedusernamechars'] = 'Dozvoliti prošireni izbor znakova u korisničkim imenima';
$string['extramemorylimit'] = 'Dodatno PHP memorijsko ograničenje.';
$string['fatalsessionautostart'] = '<p>Otkrivena je ozbiljna konfiguraciona greška. Molimo Vas da obavestite administratora.</p><p> Kako bi funkcionisao pravilno Moodle zahteva da administrator promeni PHP podešavanja.</p>
<p><code>session.auto_start</code> mora biti podešen na <code>off</code>.</p>
<p>Ovo podešavanje se može promenti editovanjem <code>php.ini</code>datoteke, konfiguracijom Apache/IIS severa<br />ili <code>.htaccess</code> datoteke na serveru.</p>';
$string['feedbacksettings'] = 'Podešavanja povratnih informacija';
$string['fileconversioncleanuptask'] = 'Čišćenje privremenih zapisa za konverziju datoteka';
$string['filecreated'] = 'Kreirana je nova datoteka';
$string['filescleanupperiod'] = 'Očisti datoteke označene kao smeće';
$string['filescleanupperiod_help'] = 'Koliko često se uklanjaju datoteke koje su označene kao smeće. U pitanju su datoteke vezane za kontekst koji više ne postoji, na primer kada je kurs obrisan. Imajte u vidu: ovo podešavanje može za posledicu imati da neke datoteke nedostaju na kursu koji se bekapuje, briše a zatim restaurira, ako je podešavanje \'Uključi datoteke\' (backup_auto_files) u \'Podešavanja za automatskog kreiranja rezervnih kopija\' isključeno.';
$string['filesizeunits'] = 'jedinice mere veličine datoteka';
$string['filestoredin'] = 'Snimi datoteku u direktorijum:';
$string['filestoredinhelp'] = 'Gde će datoteka biti smeštena';
$string['filterall'] = 'Filtriraj sve stringove';
$string['filtermatchoneperpage'] = 'Filtriraj podudaranje jednom po stranici';
$string['filtermatchonepertext'] = 'Filtriraj podudaranje jednom po tekstu';
$string['filters'] = 'Filteri';
$string['filtersettings'] = 'Upravljanje filterima';
$string['filtersettingsgeneral'] = 'Opšta podešavanja filtera';
$string['filteruploadedfiles'] = 'Filtriraj postavljene datoteke';
$string['forceclean'] = 'Čišćenje sadržaja svuda';
$string['forceclean_desc'] = 'Sadržaj dodat sajtu obično se briše pre prikazivanja, kako bi se uklonile bezbednosne pretnje. Međutim, sadržaj se ne briše na pojedinim mestima kao što su opisi aktivnosti, resurs stranica ili HTML blokovi, kako bi bilo moguće da na tim mestima budu dodati skriptovi, okviri, multimedijalni sadržaji itd. Ako je ova opcija omogućena, SAV sadržaj biće očišćen. Ovo može dovesti do toga da se postojeći sadržaj više ne prikazuje pravilno.';
$string['forcelogin'] = 'Primoraj korisnike da se prijave na sistem';
$string['forceloginforprofileimage'] = 'Primoraj korisnike da se prijave na sistem da bi videli korisničke slike';
$string['forceloginforprofileimage_help'] = 'Ako je ovo podešavanje omogućeno, korisnici moraju da se prijave na sistem kako bi mogli da vide slike drugih korisnika, a u svim e-porukama će se koristiti podrazumevana slika korisnika.';
$string['forceloginforprofiles'] = 'Primoraj korisnike da se prijave na sistem za da bi videli korisničke profile';
$string['forcetimezone'] = 'Obavezna vremenska zona';
$string['formatuninstallwithcourses'] = 'Postoji/e {$a->count} kurs/a/eva koji koriste  {$a->format}. Format ovih kurseva biće promenjen u  {$a->defaultformat} (podrazumevani format za ovaj sajt). Neki podaci koji su specifični za pojedine formate mogu se izgubiti .Da li ste sigurni da želite da nastavite?';
$string['frontpage'] = 'Naslovna stranica';
$string['frontpagebackup'] = 'Rezervna kopija naslovne stranice';
$string['frontpagedefaultrole'] = 'Podrazumevana uloga za naslovnu stranicu';
$string['frontpagefilters'] = 'Filteri naslovne stranice';
$string['frontpageloggedin'] = 'Stavke na naslovnoj stranici kada je korisnik prijavljen na sistem';
$string['frontpageoverrides'] = 'Promene ovlašćenja na naslovnoj stranici';
$string['frontpagequestions'] = 'Pitanja naslovne stranice';
$string['frontpagerestore'] = 'Restauracija naslovne stranice';
$string['frontpageroles'] = 'Uloge na naslovnoj stranici';
$string['frontpagesettings'] = 'Podešavanja naslovne stranice';
$string['fullnamedisplay'] = 'Format punog imena';
$string['fullnamedisplayprivate'] = 'Format punog imena - privatno';
$string['gdrequired'] = 'Moodle sada zahteva GD ekstenziju za konverziju slika';
$string['generalsettings'] = 'Opšta podešavanja';
$string['geoipfile'] = 'GeoLite2 City MaxMind baza podataka';
$string['getremoteaddrconf'] = 'Izvor zabeležene IP adrese';
$string['globalsearch'] = 'Globalna pretraga';
$string['globalsearchmanage'] = 'Upravljanje globalnom pretragom';
$string['googlemapkey3'] = 'Google Maps API V3 ključ';
$string['googlemapkey3_help'] = 'Da biste koristili Google Maps za lociranje IP adrese potrebno je da unesete specijalni ključ. Ključ možete dobiti besplatno na <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Idi na prvi izraz koji nedostaje';
$string['gradebook'] = 'Evidencija ocena';
$string['gradebookroles'] = 'Uloge koje mogu da se ocenjuju';
$string['gradeexport'] = 'Primarni metodi za izvoz ocena';
$string['gravatardefaulturl'] = 'URL adresa podrazumevane Gravatar slike';
$string['gravatardefaulturl_help'] = 'Gravatar traži podrazumevanu sliku za prikazivanje, ukoliko nije u mogućnosti da pronađe sliku datog korisnika. Unesite punu URL adresu slike. Ako podešavanje ostavite prazno, Moodle će pokušati da upotrebi podrazumevanu sliku koja je najprikladnija za stranicu koju posmatrate. Imajte na umu da Gravatar ima niz kôdova koji mogu da se koriste za <a href="https://en.gravatar.com/site/implement/images/#default-image"> generisanje podrazumevanih slika </a>.';
$string['groupenrolmentkeypolicy'] = 'Pravila za lozinku za upis u grupu';
$string['groupenrolmentkeypolicy_desc'] = 'Ako je ova opcija omogućena, lozinke za upis u grupu biće proverena da li su u skladu sa važećim pravilima za kreiranje lozinki kao što je to naznačeno u gore navedenim podešavanjima.';
$string['guestroleid'] = 'Uloga za gosta';
$string['guestroleid_help'] = 'Ova uloga se automatski dodeljuje gostu. Ona se dodeljuje privremeno i neupisanim korisnicima koji pristupaju kursu preko dodatka za upis gostiju.';
$string['h5pgetcontenttypestask'] = 'Preuzimanje dostupnih H5P tipova sadržaja sa h5p.org';
$string['helpadminseesall'] = 'Da li u kalendaru sajta administratori vide i filtriraju događaje iz kalendara svih kurseva ili samo onih na koje se upisani? Bez obzira na izabranu opciju administratori će uvek moći da upravaljaju događajima za svaki kalendar kursa, tako što će prvo otići na sam kurs, a onda direktno pristupiti njegovom kalendaru.';
$string['helpcalendarcustomexport'] = 'Omogući opciju za prilagođeni vremenski okvir u izvozima kalendara. Prethodno moraju biti omogućeni izvozi kalendara, kako bi ova opcija bila moguća.';
$string['helpexportlookahead'] = 'Koliko dana unapred će kalendar tražiti dešavanja prilikom izvoza, za opciju prilagođenog izvoza?';
$string['helpexportlookback'] = 'Koliko dana unazad će kalendar tražiti dešavanja prilikom izvoza, za opciju prilagođenog izvoza?';
$string['helpforcetimezone'] = 'Možete dozvoliti korisnicima da sami izaberu vremensku zonu, ili ih primorati da koriste onu koju ste Vi izabrali.';
$string['helpshowicalsource'] = 'Ako je ova opcija omogućena, naziv pretplate i link biće prikazani za iCal-uvezene događaje.';
$string['helpsitemaintenance'] = 'Za nadogradnje i ostale poslove održavanja sistema';
$string['helpstartofweek'] = 'Kojim danom započinje sedmica u kalendaru?';
$string['helpupcominglookahead'] = 'Koliko dana unapred će kalendar tražiti predstojeća dešavanja?';
$string['helpupcomingmaxevents'] = 'Koliko se (maksimalno) narednih događaja prikazuje korisnicima?';
$string['helpweekenddays'] = 'Koji dani u sedmici se smatraju vikendom i prikazuju u drugoj boji?';
$string['hiddenuserfields'] = 'Sakrivanje korisničkih polja';
$string['hidefromall'] = 'Sakrij od svih korisnika';
$string['hidefromnone'] = 'Ne sakrivati';
$string['hidefromstudents'] = 'Sakrij od polaznika';
$string['htmleditor'] = 'HTML editor';
$string['htmleditorsettings'] = 'Podešavanja HTML editora';
$string['htmlsettings'] = 'HTML podešavanja';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP bezbednost';
$string['iconvrequired'] = 'Potrebno je instalirati ICONV ekstenziju.';
$string['igbinary322buggyversion'] = 'Ekstenzija php-igbinary instaliran na sajtu može dovesti do problema kada se pokreće sa PHP 7.2 verzijom. Preporučuje se, ili da nadogradite ekstenziju na php-igbinary 3.2.5 ili noviju verziju, ili, alternativno, da instalirate  PHP 7.3 ili noviju verziju.';
$string['ignore'] = 'Ignoriši';
$string['includemoduleuserdata'] = 'Uključi podatke korisnika modula';
$string['incompatibleblocks'] = 'Nekompatibilni blokovi';
$string['incompleteunicodesupport'] = 'Trenutno podešavanje MySQL ili MariaDB baze podataka koristi \'utf8\' kodni raspored. Ovaj skup znakova ne podržava četvorobajtne znakove, koji uključuju neke emotikone. Pokušaj korišćenja ovih znakova dovešće do greške prilikom ažuriranja zapisa, i sve informacije koje se šalju u bazu podataka biće izgubljene. Razmotrite mogućnost promene podešavanja kodnog rasporeda u \'utf8mb4\'. Pogledajte dokumentaciju za više informacija.';
$string['indexdata'] = 'Indeksiraj podatke';
$string['indexinginfo'] = 'Preporučeni način indeksiranja sadržaja vašeg sajta je korišćenjem planiranog zadatka "Indeksiranje za globalnu pretragu".';
$string['installhijacked'] = 'Instalacija mora biti završena sa originalne IP adrese.';
$string['installsessionerror'] = 'Nije moguće započeti PHP sesiju. Proverite da li vaš veb čitač prihvata kolačiće.';
$string['intlrecommended'] = 'Intl ekstenzija se koristi za unapređenje internacionalne podrške, kao što je sortiranje prema pravilima lokalnog jezika.';
$string['intlrequired'] = 'Intl ekstenzija je neophodna za poboljšanje podrške internacionalizaciji, kao što su nazivi međunarodnih domena i sortiranje u skladu sa pravopisom lokalnog jezika.';
$string['invalidagedigitalconsent'] = 'Digitalni uzrast za saglasnost nije validan: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL adresa za zaboravljenu lozinku nije ispravna.';
$string['invalidsection'] = 'Neispravna sekcija';
$string['invalidthemepreset'] = 'Izabrana unapred postavljena datoteka nije kompatibilna sa ovom temom. SCSS greška kompajliranja: "{$a}"';
$string['invaliduserchangeme'] = 'Korisničko ime "changeme" je rezervisano -- ne možete kreirati nalog sa tim imenom.';
$string['ipblocked'] = 'Ovaj sajt trenutno nije dostupan.';
$string['ipblocker'] = 'Bloker IP adresa';
$string['ipblockersyntax'] = 'Jedan zapis po jednom redu. Ispravni zapisi su ili pune IP adrese (npr. <b>192.168.10.1</b>), koje koje odgovaraju jednom serveru; ili delimične adrese (npr. <b>192.168.</b>), koje odgovaraju svi računarima čija IP adresa počinje tim brojevima; ili CIDR notacije (npr. <b>231.54.211.0/20</b>); ili opseg IP adresa (npr. <b>231.3.56.10-20</b>) gde opseg odgovara poslednjem delu adrese. Slovima napisani domeni (npr. \'example.com\') nisu podržani. Prazni redovi i tekst koji sledi znaka"#" biće zanemareni.';
$string['iplookup'] = 'Traženje IP adrese';
$string['iplookupgeoplugin'] = '<a href="https://www.geoplugin.com">geoPlugin</a> servis se trenutno koristi za pronalaženje geografskih informacija. Za preciznije rezultata predlažemo vam da instalirate lokalnu kopiju MaxMind GeoLite baze podataka.';
$string['iplookupinfo'] = 'Kako bi locirao IP adresu Moodle standardno koristi besplatan onlajn NetGeo (The Internet Geographic Database) server. Nažalost, ova baza podataka se više ne održava pa se može desiti da dobijete <em>krajnje pogrešne</em> podatke.
Preporučuje se da instalirate lokalnu kopiju besplatne GeoLite2 City baze podataka kompanije MaxMind.<br />
Pozicija IP adrese se prikazuje na jednostavnoj mapi ili korišćenjem Google Maps. Napomena: da biste omogućili interaktivne mape neophodno je da imate Google nalog kao i da se prijavite za besplatan Google Maps API ključ.';
$string['iplookupmaxmindnote'] = 'Ovaj proizvod uključuje GeoLite2 podatke kreirane od strane MaxMind kompanije, koji je dostupan na <a href="https://www.maxmind.com/">https://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'Otkriveno je da vaš sajt koristi prilagođeni administratorski direktorijum. Ova funkcija više nije podržana i biće uklonjena nakon verzije Moodlea 4.2.';
$string['ishttpswarning'] = 'Otkriveno je da vaš sajt nije bezbedan jer ne koristi HTTPS protokol. Toplo se preporučuje da migrirate svoj sajt na HTTPS kako biste povećali bezbednost i unapredili integraciju sa drugim sistemima.';
$string['keeptagnamecase'] = 'Zadržati velika i mala slova oznaka (tagova)';
$string['lang'] = 'Podrazumevani jezik';
$string['langcache'] = 'Keširaj jezički meni';
$string['langcache_desc'] = 'Keširaj jezički meni. Ako je ovo podešavanje omogućeno, spisak dostupnih prevoda se kešira. Keš memorija se automatski osvežava kada instalirate ili obrišete jezički pakete pomoću ugrađenog alata za upravljanje jezičkim paketima. Ako ručno instalirate novi paket, morate da upotrebite naredbu "Očistite sve keš memorije" kako biste osvežili keširanu listu jezičkih paketa.';
$string['langlist'] = 'Jezici na jezičkom meniju';
$string['langmenu'] = 'Prikaz jezičkog menija';
$string['langmenuinsecurelayout'] = 'Prikaži jezički meni u bezbednom prikazu stranice';
$string['langmenuinsecurelayout_desc'] = 'Ako je ova opcija omogućena, korisnik će moći da promeni jezik kada pokušava da rešava test ili neku drugu aktivnost koristeći bezbedni prikaz stranice.';
$string['langpackwillbeupdated'] = 'Napomena: U toku nadogradnje Moodle će pokušati da ažurira vaše jezičke pakete.';
$string['langstringcache'] = 'Keširaj sve jezičke stringove';
$string['languagesettings'] = 'Jezička podešavanja';
$string['latinexcelexport'] = 'Excel kodiranje';
$string['legacyfilesaddallowed'] = 'Dozvoli dodavanje nasleđenim datotekama';
$string['legacyfilesaddallowed_help'] = 'Ako kurs ima stare nasleđene datoteke, dozvolite da im budu dodate nove datoteke i direktorijumi.';
$string['legacyfilesinnewcourses'] = 'Nasleđene datoteke kursa u novom kursu';
$string['legacyfilesinnewcourses_help'] = 'Standardno, prostori za nasleđene datoteke kurseva su dostupni samo u nadograđenim kursevima. Imajte u vidu da pojedina svojstva, poput kreiranja i restauriranja rezervne kopije nisu kompatibilne sa ovim podešavanjem.';
$string['libcurlwarning'] = 'Otkriveno je da Libcurl nema podršku za CURLOPT_PROTOCOL. Preporučuje se da instalirate najnoviju libcurl verziju iz bezbednosnih razloga.';
$string['licensesettings'] = 'Podešavanja licence';
$string['linkadmincategories'] = 'Prikaži administratorske kategorije kao linkove';
$string['linkadmincategories_help'] = 'Ako je ovo podešavanje omogućeno, kategorije, unutar administratorskog bloka za podešavanja, biće prikazane kao linkovi i povezane sa stranicama  odgovarajućih administratorskih kategorija.';
$string['linkcoursesections'] = 'Uvek linkuj sekcije kursa';
$string['linkcoursesections_help'] = 'Uvek se potrudite da date link za sekcije kursa. Sekcije kursa se obično prikazuju kao linkovi samo ako format kursa prikazuje jednu sekciju po stranici. Ako je ovo podešavanje omogućeno link će uvek biti prikazan.';
$string['loading'] = 'Učitavanje';
$string['localetext'] = 'Lokalni tekst na nivou sajta';
$string['localstringcustomization'] = 'Prilagođavanje stringova lokala';
$string['location'] = 'Lokacija';
$string['locationsettings'] = 'Podešavanja lokacije';
$string['locked'] = 'Zaključano';
$string['lockoutduration'] = 'Period u kom je nalog zaključan';
$string['lockoutduration_desc'] = 'Zaključani nalog se automatski otključava.nakon što istekne ovaj vremenski period';
$string['lockoutemailbody'] = 'Vaš nalog sa korisničkim imenom {$a->username} na sajtu \'{$a->sitename}\'
je zaključan nakon višestrukih neispravnih pokušaja prijave na sistem.

Da biste otključali nalog odmah idite na sledeću adresu

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora,
{$a->admin}';
$string['lockoutemailsubject'] = 'Vaš nalog na sajtu {$a} je zaključan';
$string['lockouterrorunlock'] = 'Dobavljena je neispravna informacija za otključavanje naloga.';
$string['lockoutthreshold'] = 'Prag zaključavanja naloga';
$string['lockoutthreshold_desc'] = 'Izaberite broj neuspešnih pokušaja prijave na sistem koji će dovesti do zaključavanja naloga. Ova funkcija može biti zloupotrebljena u napadima uskraćivanjem usluga (DoS - denial of service).';
$string['lockoutwindow'] = 'Vreme praćenja za zaključavanje naloga';
$string['lockoutwindow_desc'] = 'Vreme praćenja za prag zaključavanja – ukoliko nema neuspešnih pokušaja prijave na sistem brojač praga zaključavanja se resetuje nakon ovog vremenskog perioda.';
$string['lockrequestcategory'] = 'Spreči izbor kategorije';
$string['log'] = 'Zapisi o aktivnostima';
$string['logguests'] = 'Beleži pristupe gostiju';
$string['logguests_help'] = 'Ovo podešavanje omogućava beleženje aktivnosti od strane gostiju, kao i korisnika koji nisu prijavljeni na sistem. Ako vaš sajt ima veliki broj korisnika možda ćete želeti da isključite ovo podešavanje zbog boljih performansi. Preporučljivo je da ovo podešavanje držite uključeno na produkcionim sajtovima.';
$string['logininfoinsecurelayout'] = 'Prikaži prijavljenog korisnika u bezbednom prikazu stranice';
$string['logininfoinsecurelayout_desc'] = 'Ako je ova opcija omogućena, puno ime prijavljenog korisnika biće prikazano u navigacionoj traci prilikom otvaranja testa ili neke druge aktivnosti korišćenjem bezbednog prikaza stranice.';
$string['loginpageautofocus'] = 'Obrazac sa autofokusirajućim poljima na stranici za prijavljivanje';
$string['loginpageautofocus_help'] = 'Uključivanjem ove opcije povećava se upotrebljivost stranice za prijavljivanje, ali automatski fokusirajuća polja mogu predstavljati problem pristupačnosti svim korisnicima, naročito onima sa posebnim potrebama.';
$string['loglifetime'] = 'Čuvaj zapise';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Pun logotip koji će kao ukras koristiti neke grafičke tema (kao što su glavne teme). Ova slika može biti prilično visoke rezolucije, pošto će biti umanjena za korišćenje (i keširana zbog boljih performansi sistema). Logotipovi čija je širina veća od njihove visine obično daju bolje rezultate. Format slike mora biti PNG ili JPEG.';
$string['logocompact'] = 'Kompaktan logo';
$string['logocompact_desc'] = 'Kompaktna verzija istog, prethodno podešenog, logotipa (kao što je npr. grb, štit ili ikonica), Slika treba da bude jasna čak i na malim veličinama. Format slike mora biti PNG ili JPEG.';
$string['logossettings'] = 'Logotipi';
$string['logstorenotrequired'] = 'Skladište zapisa nije potrebno';
$string['logstoressupported'] = 'Skladište zapisa koje podržava ovaj izveštaj';
$string['longtimewarning'] = '<b>Molimo vas da uzmete u obzir da ovaj proces može potrajati</b>';
$string['mailnewline'] = 'Oznake za novi red u elektronskim porukama';
$string['maintenancemode'] = 'U režimu održavanja';
$string['maintenancemodeisscheduled'] = 'Sajt se prebacuje u režimu održavanja za {$a->min} min. {$a->sec} sek.';
$string['maintenancemodeisscheduledlong'] = 'Ovaj sajt će biti prebačen u režim održavanja za {$a->hour} č. {$a->min} min. {$a->sec} sek.';
$string['maintfileopenerror'] = 'Greška pri otvaranju datoteka za održavanje!';
$string['maintinprogress'] = 'Održavanje je u toku...';
$string['managecontextlock'] = 'Zamrzni ovaj kontekst';
$string['managecontextlocklocked'] = '{$a->contextname} i svi niži kontekst sada su zamrznuti.';
$string['managecontextlockunlocked'] = '{$a->contextname} i svi niži kontekst sada su odmrznuti.';
$string['managecontextunlock'] = 'Odmrzni ovaj kontekst';
$string['managecustomfields'] = 'Upravljanje prilagođenim poljima kursa';
$string['manageformats'] = 'Upravljanje formatima kursa';
$string['manageformatsgotosettings'] = 'Podrazumevani format može biti promenjen u {$a}';
$string['managelang'] = 'Upravljanje';
$string['managelicenses'] = 'Upravljanje licencama';
$string['manageqbehaviours'] = 'Upravljanje ponašanjima pitanja';
$string['manageqtypes'] = 'Upravljanje tipovima pitanja';
$string['maturity100'] = 'Beta verzija';
$string['maturity150'] = 'RC (Release candidate) verzija';
$string['maturity200'] = 'Stabilna verzija';
$string['maturity50'] = 'Alfa verzija';
$string['maturityallowunstable'] = 'Savet: Možda ćete želeti da pokrenete ovu skriptu sa opcijom --allow-unstable option';
$string['maturitycoreinfo'] = 'Vaš sajt trenutno pokreće nestabilni "{$a}" razvojni kôd.';
$string['maturitycorewarning'] = 'Verzija Moodlea koju nameravate da instalirate ili nadogradite sadrži nestabilan "{$a}" razvojni kôd koji nije pogodan za korišćenje na većini produkcionih sajtova.  Ako to nije ono što ste želeli  onda bi trebalo da proverite  da li za ažuriranje koristite STABILNU verziju kôda. Pogledajte Moodle dokumentaciju za više informacija.';
$string['maxbytes'] = 'Maksimalna veličina postavljene datoteke';
$string['maxconsecutiveidentchars'] = 'Uzastopni identični znakovi';
$string['maxeditingtime'] = 'Maksimalno vreme za uređivanje poruka';
$string['maxtimelimit'] = 'Maksimalno vremensko ograničenje';
$string['maxtimelimit_desc'] = 'Da biste ograničili maksimalno vreme izvršavanja PHP-a koje će Moodle dozvoliti pre nego što bilo šta bude prikazano, unesite ovde vrednost u sekundama . Vrednost 0 znači da se koriste standardna Moodle ograničenja. Ako imate server sa sopstvenim vremenskim ograničenjem, smanjite ovu vrednost kako bi PHP greške bile evidentirane. Ovo se ne odnosi na CLI skripte.';
$string['maxusersperpage'] = 'Maksimalan broj korisnika po stranici';
$string['mbstringrecommended'] = 'Instaliranje opcione MBSTRING biblioteke je vrlo preporučljivo zbog unapređivanja performansi sajta, pogotovo ako vaš sajt podržava jezike koji ne koriste latinično pismo.';
$string['mbstringrequired'] = 'Instalacija biblioteke MBSTRING je neophodna radi unapređivanja performansi sajta, posebno ako vaš sajt podržava nelatinične jezike.';
$string['mediapluginavi'] = 'Omogući .avi filter';
$string['mediapluginflv'] = 'Omogući .flv filter';
$string['mediapluginimg'] = 'Omogući automatsko umetanje linkovanih slika';
$string['mediapluginmov'] = 'Omogući .mov filter';
$string['mediapluginmp3'] = 'Omogući .mp3 filter';
$string['mediapluginmpg'] = 'Omogući .mpg filter';
$string['mediapluginogg'] = 'Omogući .ogg filter';
$string['mediapluginogv'] = 'Omogući .ogv filter';
$string['mediapluginram'] = 'Omogući .ram filter';
$string['mediapluginrm'] = 'Omogući .rm filter';
$string['mediapluginrpm'] = 'Omogući .rpm filter';
$string['mediapluginswf'] = 'Omogući .swf filter';
$string['mediapluginswfnote'] = 'Kao podrazumevanu meru bezbednosti, običnim korisnicima ne treba dozvoliti da umeću swf flash datoteke.';
$string['mediapluginwmv'] = 'Omogućiti .wmv filter';
$string['mediapluginyoutube'] = 'Omogući filte za YouTube linkove';
$string['messaging'] = 'Omogući sistem za slanje poruka';
$string['messagingallowemailoverride'] = 'Izmena e-adrese za slanje obaveštenja';
$string['messagingallusers'] = 'Omogućite slanje poruka na nivou sajta';
$string['messagingcategory'] = 'Slanje poruka';
$string['messagingdefaultpressenter'] = 'Podrazumevano pošalji pritiskom na taster Enter';
$string['messagingdeleteallnotificationsdelay'] = 'Obrišite sve obaveštenja';
$string['messagingdeletereadnotificationsdelay'] = 'Obriši obaveštenje o pročitanim porukama';
$string['messagingssettings'] = 'Podešavanja za slanje poruka';
$string['minpassworddigits'] = 'Brojevi';
$string['minpasswordlength'] = 'Dužina lozinke';
$string['minpasswordlower'] = 'Mala slova';
$string['minpasswordnonalphanum'] = 'Ne-alfanumerički znakovi';
$string['minpasswordupper'] = 'Velika slova';
$string['misc'] = 'Razno';
$string['mlbackendsettings'] = 'Pozadinska podešavanja mašinskog učenja';
$string['mnetrestore_extusers'] = '<strong>Napomena:</strong> Ova rezervna kopija sadrži udaljene korisničke naloge iz odgovarajuće Moodle mreže. Ti nalozi će tokom ovog procesa takođe biti restaurirani.';
$string['mnetrestore_extusers_admin'] = '<strong>Napomena:</strong> Izgleda da je ova datoteka rezervne kopije kreirana na nekoj drugoj Moodle instalaciji i da sadrži korisničke naloge udaljene Moodle Mreže. Proces restauracije će pokušati da uskladi hostove Moodle Mreže za sve korisnike. One korisnici, za koje to ne uspe, automatski će biti prebačeni na internu proveru identiteta (umesto mnet). Zapis o restauraciji će Vas informisati o tome.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Napomena!</strong> Ova rezervna kopija očigledno potiče sa neke druge Moodle instalacije i sadrži korisničke naloge udaljene Moodle Mreže koji se možda neće uspešno restaurirati. Ova operacija nije podržana. Ako ste sigurni da je arhiva kreirana na ovoj Moodle instalaciji, ili možete da potvrdite da su svi potrebni hostovi u vašoj Moodle mreži  konfigurisani, možda ćete ipak želeti da pokušate restauraciju.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Napomena:</strong> Izgleda da je ova dadoteka rezervne kopije kreirana na nekoj drugoj Moodle instalaciji i da sadrži korisničke naloge udaljene Moodle Mreže. Nije Vam dozvoljeno da izvršavate ovaj tip restauriranja. Kontaktirajte administratora ovog sajta ili, alternativno, restaurirajte ovaj kurs bez bilo kakve informacije o korisnivima (moduli, datoteke...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Udaljeni korisnik Moodle Mreže {$a->username} (koji dolazi sa {$a->mnethosturl}) prebačen je na lokalnog {$a->auth} autorizovanog korisnika.';
$string['mobilenotconfiguredwarning'] = 'Moodle aplikacija nije omogućena';
$string['modassignmentinuse'] = 'Otkriveno je da vaš sajt još uvek koristi dodatak Zadatak 2.2. Ovo možete da rešite pre nadogradnje tako što ćete 1) napraviti rezervnu kopiju aktivnosti Zadatka 2.2 i restaurirati ih kao aktivnosti novog modula Zadatak; ili 2) obrisati podataka iz tabela za Zadatak 2.2 dodele u bazi podataka.';
$string['modassignmentsubpluginsexist'] = 'Moguće da je prisutan stari modul Zadatak 2.2 (Assignment 2.2). Potrebno je, pre nadogradnje, ukloniti direktorijum mod/assignment i sve njegove (pod)dodatke';
$string['modchooserdefault'] = 'Podrazumevani status birača aktivnosti';
$string['modeditdefaults'] = 'Podrazumevane vrednosti za podešavanja aktivnosti';
$string['modsettings'] = 'Upravljanje aktivnostima';
$string['modulesecurity'] = 'Bezbednost modula';
$string['moodleapp'] = 'Moodle aplikacija';
$string['moodleapp_help'] = '<p>Besplatna Moodle aplikacija omogućava korisnicima da pristupe svojim kursevima putem mobilnih uređaja. Dodatne funkcije aplikacije su dostupne sa Pro ili Premium paketom za korišćenje aplikacije.</p>
<a href="https://moodle.com/mobile-app">Preuzmite Moodle aplikaciju</a><br />
<a href="https://apps.moodle.com">Portal Moodle aplikacije</a>';
$string['moodlebrandedapp'] = 'Brendirana Moodle aplikacija';
$string['moodlebrandedapp_help'] = '<p>Brendirana Moodle aplikacija ima sve funkcionalnosti naše besplatne mobilne aplikacije za Moodle u kombinaciji sa vašim vlastitim prilagođenim brendom.</p>
<a href="https://moodle.com/branded-app">O brendiranoj Moodle aplikaciji</a>';
$string['moodlebrandedappreference'] = 'Alternativno, možete da dobijete<a href="https://moodle.com/branded-app/">Brendiranu Moodle aplikaciju</a> sa sopstvenim prilagođenim brendom.';
$string['moodlepartners'] = 'Moodle partneri';
$string['moodlepartners_help'] = 'Moodle partneri su pružaoci usluga ovlašćeni od strane Moodle HQ-a za pružanje visoko kvalitetnih Moodle servisa za učenje u onlajn okruženje u vašoj organizaciji/instituciji. </p>
<a href="https://moodle.com/about-partners/">O našim partnerima</a><br />
<a href="https://moodle.com/partners">Pronađite partnera</a>';
$string['moodleservices'] = 'Moodle servisi';
$string['moodleservices_help'] = 'Pobrinite se da dobijete najbolje od svog Moodle okruženja za učenje pomoću ovih Moodle servisa:';
$string['multilangforceold'] = 'Insistirati na staroj višejezičkoj sintaksi: &lt;span&gt; bez class="multilang" i &lt;lang&gt;';
$string['mustenablestats'] = 'Statistika još nije omogućena na ovom sajtu.';
$string['mycoursesperpage'] = 'Broj kurseva';
$string['mydashboard'] = 'Podrazumevani kontrolni panel sistema';
$string['mymoodle'] = 'Kontrolni panel';
$string['mymoodleredirect'] = 'Primoraj korisnike da koriste Moj Moodle';
$string['mypage'] = 'Podrazumevana stranica \'Kontrolni panel\'';
$string['mypagelocked'] = 'Zaključaj podrazumevanu stranicu';
$string['myprofile'] = 'Podrazumevana stranica profila';
$string['navadduserpostslinks'] = 'Dodaj linkove za prikaz korisničkih poruka';
$string['navadduserpostslinks_help'] = 'Ako je ovo podešavanje omogućeno, svakom korisniku će u bloku za navigaciju biti dodata dva linka, jedan za prikaz diskusija koje je korisnik započeo i drugi za prikaz poruka koje je postavio na forumima širom sajta ili na određenim kursevima.';
$string['navcourselimit'] = 'Broj kurseva';
$string['navigationupgrade'] = 'Ova nadogradnja uvodi dva nova bloka za navigaciju koji će zameniti sledeće blokove: Administracija, Kursevi, Aktivnosti i Učesnici. Ako ste prethodno dodelili neka posebna ovlašćenja u ovim blokovima, trebalo bi da proverite da li se sve događa onako kako želite.';
$string['navshowallcourses'] = 'Prikaži sve kurseve';
$string['navshowcategories'] = 'Prikaži kategorije kurseva';
$string['navshowfrontpagemods'] = 'Prikaži aktivnosti na naslovnoj stranici sajta';
$string['navshowfrontpagemods_help'] = 'Ako je ovo podešavanje omogućeno, aktivnosti na naslovnoj stranici sajta biće prikazane u bloku za navigacije pod stavkom \'Stranice sajta\'.';
$string['navshowfullcoursenames'] = 'Prikaži pune nazive kurseva';
$string['navshowfullcoursenames_help'] = 'Ako je ova opcija omogućena, u navigaciji će umesto skraćenih biti prikazani puni nazivi kurseva';
$string['navshowmycoursecategories'] = 'Prikaži kategorije mojih kurseva';
$string['navshowmycoursecategories_help'] = 'Ako je ovo podešavanje omogućeno, kursevi će biti prikazani korisnicima u bloku za navigaciju pod stavkom \'Moji kursevi\', kao grane odgovarajućih kategorija (samo kod grafičkih tema koje se baziraju na temi Classic).';
$string['navsortmycourseshiddenlast'] = 'Sortiraj moje skrivene kurseve kao poslednje';
$string['navsortmycourseshiddenlast_help'] = 'Ako je omogućeno, svi skriveni kursevi biće uvršćeni posle vidljivih kurseva (za korisnike koje mogu da vide skrivene kurseve). Inače, svi kursevi, bez obzira na vidljivost, biće uvršćeni u skladu sa podešavanjem \'Sortiraj moje kurseve\'.';
$string['navsortmycoursessort'] = 'Sortiraj moje kurseve';
$string['navsortmycoursessort_help'] = 'Ovo određuje da li su kursevi unutar stavke \'Moji kursevi\', u bloku za navigaciju, poređani prema redosledu sortiranja (tj. redosledu koji je podešen u Administracija sajta > Kursevi > Upravljanje kursevima i kategorijama) ili alfabetski prema podešavanju kursa.';
$string['never'] = 'Nikada';
$string['neverdeleteruns'] = 'Nikada ne briši pokretanja';
$string['newestdocindexed'] = 'Najnoviji indeksirani dokument';
$string['nobookmarksforuser'] = 'Nemate postavljenih obeleživača.';
$string['nodatabase'] = 'Nema baze podataka';
$string['nohttpsformobilewarning'] = 'Preporučuje se da omogućite HTTPS protokol sa važećim sertifikatom. Moodle aplikacija će uvek prvo pokušati da koristi bezbednu konekciju.';
$string['nomissingstrings'] = 'Nema nedostajućih izraza';
$string['none'] = 'Niko';
$string['nonewsettings'] = 'Nije dodato nijedno novo podešavanje tokom ovog ažuriranja.';
$string['nonexistentbookmark'] = 'Traženi obeleživač ne postoji.';
$string['noreplyaddress'] = 'E-adresa "ne-odgovaraj”';
$string['noreplydomain'] = 'E-adresa "ne-odgovaraj" i domen';
$string['noreplydomaindetail'] = 'Podešavanja za e-adresu "ne-odgovaraj" i konfigurisane domene';
$string['noresults'] = 'Nema rezultata';
$string['noroles'] = 'Nema uloga';
$string['nosupportedlogstore'] = 'Nije pronađeno podržano skladište zapisa';
$string['notifications'] = 'Obaveštenja';
$string['notifyloginfailures'] = 'Poslati izveštaj o neuspešnim pristupima sistemu korisniku';
$string['notifyloginthreshold'] = 'Granična vrednost za obaveštenja e-poštom';
$string['notloggedinroleid'] = 'Uloga za posetioce';
$string['numberofmissingstrings'] = 'Broj nedostajućih stringova: {$a}';
$string['numberofstrings'] = 'Ukupan broj stringova: {$a->strings}<br />Nedostaje: {$a->missing} ({$a->missingpercent} %)';
$string['oauthrefreshtokenexpired'] = 'Token osvežavanja za jedan od OAuth servisa {$a->issuer} na vašem sajtu {$a->siteurl} je istekao. Ovo će ograničiti funkcionalnost dodataka koji koriste ovaj servis. Kako biste rešili ovaj problem posetite stranicu za konfigurisanje OAuth 2 servisa i kliknite na ikonicu "Connect system account" u redu tabele u kom se nalazi ovaj servis. Proverite da li prilikom prijave, svaki put, koristite isti nalog za OAuth sistem.';
$string['oauthrefreshtokenexpiredshort'] = 'OAuth token osvežavanja je istekao za {$a->issuer} na vašem sajtu {$a->siteurl}.';
$string['onlynoreply'] = 'Samo kada se šalje sa e-adrese "ne-odgovaraj"';
$string['opcacherecommended'] = 'Keširanje PHP operativnog kôda poboljšava performanse i smanjuje memorijske zahteve. OPcache ekstenzija se preporučuje i u potpunosti je podržana.';
$string['opensslrecommended'] = 'Instaliranje opcione OpenSSL biblioteke je vrlo preporučljivo -- ona omogućava korišćenje funkcija za umrežavanje.';
$string['opensslrequired'] = 'Moodle sada zahteva OpenSSL PHP ekstenziju kako bi se obezbedila jača kriptografska zaštita.';
$string['opentowebcrawlers'] = 'Otvoreno za pretraživače';
$string['optionalmaintenancemessage'] = 'Opciona poruka u toku održavanja sistema';
$string['order1'] = 'Prvi';
$string['order2'] = 'Drugi';
$string['order3'] = 'Treći';
$string['order4'] = 'Četvrti';
$string['outgoingmailconfig'] = 'Konfiguracija odlazne pošte';
$string['overridetossl'] = 'HTTP protokol se više ne može koristiti za prijavu na sistem. Ova instanca mora da koristi SSL. Da biste uklonili upozorenje, podesite stavku wwwroot u config.php datoteci  na https: //.';
$string['pageinfodebugsummary'] = 'Ova stranica je: {$a}';
$string['passwordchangelogout'] = 'Odjava nakon promene lozinke';
$string['passwordchangelogout_desc'] = 'Ako je ova opcija omogućena, kada se promeni lozinka sve sesije veb čitača se prekidaju, izuzev one u kojoj je sačuvana nova lozinka. (Ovo podešavanje ne utiče na promene lozinki putem masovnog postavljanja korisnika.)';
$string['passwordchangetokendeletion'] = 'Ukloni tokene za pristup veb servisima nakon promene lozinke';
$string['passwordchangetokendeletion_desc'] = 'Ako je ova opcija omogućena, svi tokeni za pristup veb servisima se brišu kada se promeni lozinka.';
$string['passwordpolicy'] = 'Pravila za kreiranje lozinke';
$string['passwordpolicycheckonlogin'] = 'Proveri lozinku prilikom prijave';
$string['passwordresettime'] = 'Maksimalno vreme za potvrdu zahteva za resetovanje lozinke.';
$string['passwordreuselimit'] = 'Ograničenje rotacije lozinke';
$string['passwordreuselimit_desc'] = 'Broj puta koliko korisnici moraju da promeni svoju lozinku pre nego što im bude dozvoljeno da ponovo upotrebe staru lozinku. Heš vrednosti prethodnih lozinki se čuvaju u lokalnoj tabeli baze podataka. Ovo svojstvo možda neće biti kompatibilna sa nekim eksternim dodacima za proveru identiteta.';
$string['pathtodot'] = 'Putanja do dot';
$string['pathtodot_help'] = 'Putanja do dot. Na Linux platformama nešto poput /usr/bin/dot. Na Windows sistemima nešto poput C:Program Files (x86)Graphviz2.38bindot.exe. Na Mac sistemima nešto kao /opt/local/bin/dot. Da biste mogli da generišete slike iz DOT datoteka morate imati instaliran izvršni dot i ovde zadati putanju do njega.';
$string['pathtodu'] = 'Putanja do du alata';
$string['pathtogs'] = 'Putanja do ghostscripta';
$string['pathtogs_help'] = 'Na većini Linux instalacija, ovo se može ostaviti kao \'/usr/bin/gs\'. Na Windows instalaciji ove će biti nešto poput \'c:\\gs\\bin\\gswin32c.exe\' (proverite da nema razmaka u putanji - ako je potrebno kopirajte datoteke \'gswin32c.exe\' i \'gsdll32.dll\' u novi direktorijum bez razmaka u putanji)';
$string['pathtopgdump'] = 'Putanja do pg_dump';
$string['pathtopgdumpdesc'] = 'Ovo je neophodno uneti samo ako imate više od jednog pg_dumpa na svom sistemu (na primer ako ste instalirali više od jedne verzije postgresqla)';
$string['pathtopgdumpinvalid'] = 'Putanja do pg_dump-a nije validna - ili je putanja pogrešna ili nije izvršiva';
$string['pathtophp'] = 'Putanja do PHP CLI';
$string['pathtopsql'] = 'Putanja do psql';
$string['pathtopsqldesc'] = 'Ovo je neophodno uneti samo ako imate više od jednog psqla na svom sistemu (na primer ako ste instalirali više od jedne verzije postgresqla)';
$string['pathtopsqlinvalid'] = 'Putanja do psql-a nije validna - ili je putanja pogrešna ili nije izvršiva';
$string['pathtopython'] = 'Putanja za Python';
$string['pathtopythondesc'] = 'Putanja do vaše izvršne Python binarne datoteke (prihvataju se i Python 2 i Python 3 datoteke).';
$string['pathtosassc'] = 'Putanja do SassC';
$string['pathtosassc_help'] = 'Specificiranje lokacije SassC binarne datoteke će prebaciti SASS kompajler iz Moodle-ove PHP implementacije na SassC. Pogledajte https://github.com/sass/sassc za više informacija.';
$string['pcreunicodewarning'] = 'Strogo se preporučuje da koristite PCRE PHP ekstenziju koji je kompatibilna sa Unicode setom znakova.';
$string['perfdebug'] = 'Informacije o izvršavanju';
$string['performance'] = 'Performanse';
$string['pgcluster'] = 'PostgreSQL klaster';
$string['pgclusterdescription'] = 'Parametar PostgreSQL verzije/klastera za operacije komandne linije. Ako imate samo jedan postgresql na svom sistemu ili niste sigurni šta ovo podešavanje predstavlja, ostavite polje prazno.';
$string['phpfloatproblem'] = 'Otrkriven je neočekivani problem u obradi PHP brojeva sa pokretnim zarezom - {$a}';
$string['pleaserefreshregistration'] = 'Vaš sajt je registrovan. Registracija je poslednji put ažurirana  {$a}.<br /> Planirani zadatak \'Registracija sajta\' omogućava da vaša registracija bude ažurna. Takođe, možete sami ručno da ažurirate svoju registraciju u bilo kom trenutku.';
$string['pleaserefreshregistrationnewdata'] = 'Podaci o registraciji su promenjeni. Potvrdite promene pomoću dugmeta \'Ažuriraj registraciju\'.';
$string['pleaserefreshregistrationunknown'] = 'Vaš sajt je registrovan ali je datum registracije nepoznat. Molimo vas da ažurirate svoju registraciju pomoću dugmeta \'Ažuriraj registraciju\' ili tako što ćete proveriti da li je planirani zadatak \'Registracija sajta\' omogućen tako da se vaša registracija automatski ažurira.';
$string['plugin'] = 'Dodatak';
$string['plugins'] = 'Dodaci';
$string['pluginscheck'] = 'Provera zavisnosti dodataka';
$string['pluginscheckfailed'] = 'Provera zavisnosti nije uspela za {$a->pluginslist}';
$string['pluginschecktodo'] = 'Morate rešiti sve zahteve dodataka pre nego što nastavite sa instalacijom ove verzije Moodlea!';
$string['pluginsoverview'] = 'Pregled dodataka';
$string['pluginsoverviewsee'] = 'Za više informacija pogledajte stranicu <a href="{$a->url}">Pregled dodataka</a>.';
$string['policysettings'] = 'Podešavanje pravila';
$string['privacy:metadata'] = 'Dodatak Administracija ne čuva nikakve lične podatke.';
$string['privacyandpolicies'] = 'Privatnost i pravila';
$string['privacysettings'] = 'Podešavanja privatnosti';
$string['profilecategory'] = 'Kategorija';
$string['profilecategoryname'] = 'Naziv kategorije (mora biti jedinstven)';
$string['profilecategorynamenotunique'] = 'Ovaj naziv kategorije se već koristi';
$string['profilecommonsettings'] = 'Zajednička podešavanja';
$string['profileconfirmcategorydeletion'] = 'Postoje {$a}. polja u ovoj kategoriji koja mogu biti pomerena u kategoriju iznad (ili ispod).<br />Da li želite da obrišete ovu kategoriju?';
$string['profileconfirmfielddeletion'] = 'Postoji {$a} korisničkih unosa za ovo polje koji trebaju biti obrisani.<br />Da li i dalje želite obrisati ovo polje?';
$string['profilecreatecategory'] = 'Kreiraj novu kategoriju profila';
$string['profilecreatefield'] = 'Kreiraj novo polje profila:';
$string['profilecreatenewcategory'] = 'Kreiraj novu kategoriju';
$string['profilecreatenewfield'] = 'Kreiranje novog polja profila: &quot;{$a}&quot;';
$string['profiledefaultcategory'] = 'Ostala polja';
$string['profiledefaultchecked'] = 'Uključeno podrazumevano';
$string['profiledefaultdata'] = 'Podrazumevana vrednost';
$string['profiledeletecategory'] = 'Brisanje kategorije';
$string['profiledeletefield'] = 'Brisanje polja \'{$a}\'';
$string['profiledescription'] = 'Opis polja';
$string['profiledscript'] = 'Ovaj skript je profilisan';
$string['profiledscriptview'] = 'Vidi informacije o profilisanju za ovaj skript';
$string['profileeditcategory'] = 'Uređivanje kategorije: {$a}';
$string['profileeditfield'] = 'Uređivanje polja  profila: {$a}';
$string['profilefield'] = 'Polje profila';
$string['profilefieldcolumns'] = 'Kolone';
$string['profilefieldispassword'] = 'Da li je ovo polje za lozinku?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Za pretvaranje teksta u link, unesite URL koji sadrži $$, gde će $$ biti zamenjen tekstom. Na primer, da biste Twitter ID oznaku pretvorili u link, upišite https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Odredište linka';
$string['profilefieldmaxlength'] = 'Maksimalna dužina';
$string['profilefieldrows'] = 'Redova';
$string['profilefields'] = 'Polja korisničkog profila';
$string['profilefieldsize'] = 'Veličina polja';
$string['profileforceunique'] = 'Da li podaci treba da budu jedinstveni?';
$string['profileinvaliddata'] = 'Neodgovarajuća vrednost';
$string['profilelocked'] = 'Da li je ovo polje zaključano?';
$string['profilemenudefaultnotinoptions'] = 'Podrazumevana vrednost nije u listi opcija.';
$string['profilemenunooptions'] = 'Bez opcija sa menijima';
$string['profilemenuoptions'] = 'Meni opcije (po jedna u liniji)';
$string['profilemenutoofewoptions'] = 'Morate ponuditi bar 2 mogućnosti';
$string['profilename'] = 'Naziv';
$string['profilenofieldsdefined'] = 'Nije definisano nijedno polje';
$string['profilerequired'] = 'Da li je ovo polje obavezno?';
$string['profileroles'] = 'Uloge vidljive u profilu';
$string['profilesforenrolledusersonly'] = 'Profili samo za korisnike upisane na kurs.';
$string['profileshortname'] = 'Skraćen naziv (mora biti jedinstven)';
$string['profileshortnameinvalid'] = 'Ovaj skraćeni naziv može da sadrži samo alfanumeričke znake (slova i brojeve) ili donju crtu (_).';
$string['profileshortnamenotunique'] = 'Ovaj skraćen naziv se već koristi';
$string['profilesignup'] = 'Prikazati na stranici za prijavu?';
$string['profilespecificsettings'] = 'Specifična podešavanja';
$string['profilevisible'] = 'Kome je ovo polje vidljivo?';
$string['profilevisible_help'] = '* Nije vidljivo - za lične podatke vidljive samo administratorima
* Vidljivo korisniku - za lične podatke vidljive samo administratorima i korisniku čiju su podaci
* Vidljivo korisniku, predavačima i administratorima - za lične podatke vidljive samo korisniku, administratorima i predavačima (u profilu kurseva)
* Vidljivo svima';
$string['profilevisibleall'] = 'Vidljivo svima';
$string['profilevisiblenone'] = 'Nije vidljivo';
$string['profilevisibleprivate'] = 'Vidljivo korisniku';
$string['profiling'] = 'Profilisanje';
$string['profilingallowall'] = 'Kontinuirano profilisanje';
$string['profilingallowall_help'] = 'Ako omogućite ovo podešavanje, onda, u bilo kom trenutku možete da koristite parametar PROFILEALL bilo gde (PGC) kako biste omogućili profilisanje za sve izvršene skripte tokom trajanja Moodle sesije. Analogno tome, možete da koristite parametar PROFILEALLSTOP kako biste to zaustavili.';
$string['profilingallowme'] = 'Selektivno profilisanje';
$string['profilingallowme_help'] = 'Ako omogućite ovо podešavanje, onda, selektivno, možete da koristite parametar PROFILEME bilo gde (PGC) i taj skript će biti profilisan. Analogno tome, možete da koristite parametar DONTPROFILEME kako bi sprečili profilisanje.';
$string['profilingautofrec'] = 'Automatsko profilisanje';
$string['profilingautofrec_help'] = 'Konfigurisanjem ovog podešavanja, neki zahtevi (nasumično odabrani, zasnovano na učestalosti određenoj kao 1 od N) biće odabrani i automatski profilisani, smeštajući rezultate za dalju analizu. Imajte na umu da se ovaj način profilisanja pridržava podešavanja "isključi/uključi" (include/exclude). Postavite vrednost na 0 kako biste onemogućili automatsko profilisanje.';
$string['profilingenabled'] = 'Omogući profilisanje';
$string['profilingenabled_help'] = 'Ako omogućite ovu podešavanje, onda će profilisanje biti dostupno na ovom sajtu i moći ćete da odrediti njegovo ponašanje tako što ćete podesiti sledeće opcije.';
$string['profilingexcluded'] = 'Isključi profilisanje';
$string['profilingexcluded_help'] = 'Spisak URL adresa (odvojenih zarezom ili novim redom, apsolutnih, preskačući wwwroot, koje mogu biti pozvane) koje će biti izuzete od profilisanja definisanog u podešavanju \'Profiliši ove\'.';
$string['profilingimportprefix'] = 'Prefiks uvezenih profilisanja';
$string['profilingimportprefix_desc'] = 'Radi lakšeg otkrivanja, sva uvezena pokretanja profilisanja će dobiti prefikse sa vrednošću koja je ovde navedena.';
$string['profilingincluded'] = 'Profiliši ove';
$string['profilingincluded_help'] = 'Spisak URL adresa (odvojenih zarezom ili novim redom, apsolutnih, preskačući wwwroot, koje mogu biti pozvane) koje će biti automatski profilisane. Primer: /index.php, /course/view.php. Takođe je prihvatljiva upotreba * džoker oznaka na bilo kojoj poziciji. Primer: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Nastavi sa profilisanjem';
$string['profilinglifetime_help'] = 'Odredite koliko dugo želite da čuvate informacije o prethodnim pokretanjima profilisanja. Starije će periodično biti odstranjivana. Imajte u vidu da ovo isključuje bilo koje pokretanje profilisanja označeno kao "referentno pokretanje".';
$string['profilingslow'] = 'Profiliši spore stranice';
$string['profilingslow_help'] = 'Podešavanjem minimalnog vremena, u sekundama, biće profilisane sve stranice koje su sporije. Biće zadržani samo profili koji su sporiji od postojećeg profila za isti skript. Podesite na 0 da biste onemogućili ovu opciju. Imajte na umu da se ovaj način profilisanja pridržava podešavanja "isključi" (exclude).';
$string['protectusernames'] = 'Zaštititi korisnička imena';
$string['proxybypass'] = 'Hostovi za premošćenje Proxy servera';
$string['proxyhost'] = 'Proxy domaćin';
$string['proxypassword'] = 'Lozinka za proksi server';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Tip Proxy servera';
$string['proxyuser'] = 'Korisničko ime za Proxy';
$string['purgecaches'] = 'Očistite sve keš memorije';
$string['purgecachesconfirm'] = 'Moodle može da čuva u keš memoriji grafičke teme, Javascript, jezičke stringove, filtrirani tekst, RSS izvore vesti i mnoge druge obrađene podataka. Brisanje keš memorije će obrisati te privremeno sačuvane podatke sa servera i time primorati Web čitač da ponovo preuzme podatke, tako da možete biti sigurni da gledate najnovije vrednosti koje je proizveo trenutni kôd. Nema nikakve opasnosti u brisanju keš memorije, ali vaš sajt može, na trenutak, biti sporiji, sve dok server i klijentski program ne generišu nove informacije i ponovo ih smeste u keš.';
$string['purgecachesfinished'] = 'Sve keš memorije su očišćene.';
$string['purgecachesnoneselected'] = 'Izaberite jednu ili više keš memorija da biste ih očistili';
$string['purgecachespage'] = 'Očistite keš memorije';
$string['purgefiltercache'] = 'Tekstualni filteri';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Jezički string';
$string['purgemuc'] = 'Sve MUC keš memorije';
$string['purgeothercaches'] = 'Sve datoteke i različite keš memorije';
$string['purgeselectedcaches'] = 'Očistite izabrane keš memorije';
$string['purgeselectedcachesfinished'] = 'Izabrane keš memorije su očišćene.';
$string['purgetemplates'] = 'Šabloni';
$string['purgethemecache'] = 'Grafičke teme';
$string['query'] = 'Upit';
$string['question'] = 'Pitanje';
$string['questionbehaviours'] = 'Ponašanja pitanja';
$string['questioncwqpfscheck'] = 'Jedno ili više \'nasumično izabranih\' pitanja u testu podešeno je da vrši odabir pitanja i iz kategorija deljenih i iz kategorija nedeljenih pitanja. Detaljniji izveštaj pogledajte <a href="{$a->reporturl}">ovde</a>, ili potražite dodatne informacije u okviru stranica Moodle <a href="{$a->docsurl}">dokumentacije</a>.';
$string['questioncwqpfsok'] = 'U redu. Nema \'nasumično izabranih\' pitanja u Vašim testovima koja su podešena tako da vrše odabir pitanja i iz kategorija deljenih i iz kategorija nedeljenih pitanja.';
$string['questiontype'] = 'Tip pitanja';
$string['questiontypes'] = 'Tipovi pitanja';
$string['quizattemptsupgradedmessage'] = 'U verziji Moodle 2.1 izvršen je velika nadogradnja onog  dela koji se odnosi na pitanja. Bilo je moguće da se deo nadogradnje baze podataka odloži i pokrene kasnije. Pre prelaska na verziju Moodle 2.7 ova nadogradnja mora da bude završena.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA tajni ključ';
$string['recaptchapublickey'] = 'ReCAPTCHA ključ sajta';
$string['register'] = 'Registrujte svoj sajt';
$string['registermoodlenet'] = '<p>Voleli bismo da ostanemo u kontaktu i pružimo vam važne stvari za vaš Moodle sajt!</p><p>Registracijom svog sajta:</p><ul><li>
Možete se pretplatiti da primate obaveštenja o novim verzijama Moodlea, bezbednosna upozorenja i druge važne vesti.</li><li>Možete da pristupite i aktivirati slanje obaveštenja sa svog Moodle sajta na mobilne uređaje putem naše besplatne <a href="https://download.moodle.org/mobile/">Moodle aplikacije</a>.</li><li>Doprinosite <a href="https://stats.moodle.org">Moodle statistici</a> svetske zajednice, što nam pomaže da unapredimo Moodle i sajtove naše zajednice.</li><li>Ako želite, vaš sajt može biti uvršten na <a href="https://stats.moodle.org/sites">spisak registrovanih sajtova</a>, u vašoj zemlji.</li></ul>';
$string['registermoodleorg'] = 'Kada registrujete svoj sajt';
$string['registermoodleorgli1'] = 'Bićete dodati na listu e-pošte za slanje važnih obaveštenja kao što su bezbednosna upozorenja i informacije o novim izdanjima Moodlea.';
$string['registermoodleorgli2'] = 'Statistički podaci o vašem sajtu biće dodati statistici svetske Moodle zajednice - {$a}.';
$string['registerwithmoodleorg'] = 'Registrujte svoj sajt';
$string['registration'] = 'Registracija';
$string['registration_help'] = 'Registracijom svog sajta:

* dobijaćete bezbednosna upozorenja
* moći ćete da aktivirate slanje obaveštenja sa svog sajt na mobilnu aplikaciju
* daćete svoj doprinos statistici Moodle svetske zajednice';
$string['registrationwarning'] = 'Vaš sajt još nije registrovan';
$string['registrationwarningcontactadmin'] = 'Vaš sajt još nije registrovan. Molimo. obavestite svog administratora.';
$string['releasenoteslink'] = 'Za informacije o ovoj verziji Moodlea, molimo pogledajte onlajn <a target="_new" href="{$a}">Beleške o izdanju</a>';
$string['rememberuserlicensepref'] = 'Upamti preferiranu licencu korisnika';
$string['rememberuserlicensepref_help'] = 'Ako je omogućeno ova opcija, poslednja licenca koju je korisnik izabrao biće unapred izabrana, prilikom postavljanja datoteke u birač datoteka. U suprotnom, kao unapred izabrana koristiće se podrazumevana licenca na nivou sajta.';
$string['rememberusername'] = 'Zapamti korisničko ime';
$string['rememberusername_desc'] = 'Omogućite ovu opciju ako želite da sačuvate permanentne kolačiće sa korisničkim imenima prilikom prijavljivanja korisnika na sistem. Permanentni kolačići mogu da predstavljaju problem privatnosti ako se koriste bez saglasnosti.';
$string['reportsmanage'] = 'Upravljanje izveštajima';
$string['requestcategoryselection'] = 'Omogući izbor kategorija';
$string['required'] = 'Obavezno';
$string['requiredentrieschanged'] = 'Napomena: Nakon nadogradnje sistema podešavanje \'Obavezni unosi pre pregledanja\' je sada obavezno za sledeće aktivnosti baze podataka:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Zahtevaj opis aktivnosti';
$string['requiremodintro_desc'] = 'Ako je opcija omogućena korisnici će biti primorani da unesu opis za svaku aktivnosti';
$string['requires'] = 'Neophodno';
$string['restorecourse'] = 'Restauriraj kurs';
$string['restorernewroleid'] = 'Uloga restauratora na kursevima';
$string['restorernewroleid_help'] = 'Ako korisnik već nema dozvolu da upravlja nedavno restaurisanim kursom, automatski će mu biti dodeljena ova uloga i biće upisan na kurs ako je to potrebno. Izaberite "Ništa", ako ne želite da oni koji restauriraju kurseve budu  u mogućnosti da upravljaju svakim restaurisanim kursom.';
$string['resultfilter'] = 'Filtriraj prema rezultatima';
$string['reverseproxy'] = 'Reverzni proksi';
$string['reverseproxyignore'] = 'Ignoriši uzvratne posrednike';
$string['riskconfig'] = 'Korisnici bi mogli promeniti konfiguraciju i ponašanje sajta';
$string['riskconfigshort'] = 'Konfiguracioni rizik';
$string['riskdataloss'] = 'Korisnici mogu da unište veliku količinu sadržaja ili informacija';
$string['riskdatalossshort'] = 'Rizik od gubitkka podataka';
$string['riskmanagetrust'] = 'Korisnici bi mogli promeniti sigurnosna podašavanja drugih korisnika';
$string['riskmanagetrustshort'] = 'Upravljanje dozvolama za pristup';
$string['riskpersonal'] = 'Korisnici bi mogli steći pristup privatnim informacijama drugih korisnika';
$string['riskpersonalshort'] = 'Rizik po privatnost';
$string['riskspam'] = 'Korisnici bi mogli slati neželjenu poštu korisnicima sajta ili drugim licima';
$string['riskspamshort'] = 'Rizik od neželjene e-pošte';
$string['riskxss'] = 'Korisnici bi mogli dodati datoteke i tekstove koji dozvoljavaju skriptovanje u okviru čitavog sajta (XSS)';
$string['riskxssshort'] = 'XSS rizik';
$string['roleswithexceptions'] = '{$a->roles}, sa {$a->exceptions}';
$string['rssglobaldisabled'] = 'Onemogućeno na nivou sajta';
$string['save'] = 'Sačuvaj';
$string['savechanges'] = 'Sačuvaj promene';
$string['scssinvalid'] = 'SCSS kôd nije ispravan. Izvršavanje kôda nije uspelo sa porukom: {$a}';
$string['search'] = 'Pretraga';
$string['searchablecourses'] = 'Pretraživi kursevi';
$string['searchallavailablecourses'] = 'Kursevi koji se mogu pretraživati';
$string['searchallavailablecourses_desc'] = 'U nekim situacijama pretraživač možda neće funkcionisati prilikom pretraživanja velikog broja kurseva. Ako morate da ograničite broj kurseva koji se pretražuju, podesite pretragu samo na upisane kurseve.';
$string['searchallavailablecourses_off'] = 'Pretraga samo unutar upisanih kurseva';
$string['searchallavailablecourses_on'] = 'Pretraga unutar svih kurseva kojima korisnik može da pristupi';
$string['searchallavailablecoursesdesc'] = 'Ako je podešeno da se pretraga vrši samo unutar upisanih kurseva, informacije o kursu (naziv i rezime) kao i njegov sadržaj biće pretraživani samo unutar onih kurseva koje je korisnik upisao. U suprotnom, informacije o kursu i sadržaj kursa biće pretraživani unutar svih kurseva kojima korisnik može da pristupi, kao što su to kursevi koji imaju omogućen pristup gostima.';
$string['searchalldeleted'] = 'Sav indeksirani sadržaj je obrisan';
$string['searchareadisabled'] = 'Oblast pretrage je onemogućena';
$string['searchareaenabled'] = 'Oblast pretrage je omogućena';
$string['searchareas'] = 'Oblasti pretrage';
$string['searchdefaultcategory'] = 'Podrazumevana kategorija za pretragu';
$string['searchdefaultcategory_desc'] = 'Podrazumevano će biti prikazani rezultati iz izabrane kategorije kao oblasti za pretragu.';
$string['searchdeleteindex'] = 'Obriši sav indeksirani sadržaj';
$string['searchdisplay'] = 'Opcije prikaza rezultata pretrage';
$string['searchenablecategories'] = 'Prikaži rezultate u odvojenim kategorijama';
$string['searchenablecategories_desc'] = 'Ako je ova opcija omogućena, rezultati pretrage biće prikazani u različitim kategorijama.';
$string['searchengine'] = 'Pretraživač';
$string['searchhideallcategory'] = 'Sakrij kategoriju \'Svi rezultati\\';
$string['searchhideallcategory_desc'] = 'Ako je označeno, kategorija sa svim rezultatima biće sakrivena na ekranu sa rezultatima pretrage.';
$string['searchincludeallcourses'] = 'Uključi sve vidljive kurseve';
$string['searchincludeallcourses_desc'] = 'Ako je ova opcija omogućena, rezultati pretrage će uključivati informacije (naziv i rezime) o kursevima koji su vidljivi korisnicima, čak i ako oni nemaju pristup sadržaju kurseva.';
$string['searchindexactions'] = 'Akcije indeksiranja';
$string['searchindexdeleted'] = 'Indeks je obrisan';
$string['searchindextime'] = 'Vremensko ograničenje indeksiranja';
$string['searchindextime_desc'] = 'Prilikom indeksiranja velikih količina novog sadržaja, planirani zadatak će se zaustaviti nakon što se dostigne ovo vremensko ograničenje. Indeksiranje će se nastaviti sledeći put kada se zadatak pokrene.';
$string['searchindexupdated'] = 'Sadržaj pretraživača je ažuriran';
$string['searchindexwhendisabled'] = 'Indeksiraj kada je pretraga onemogućena';
$string['searchindexwhendisabled_desc'] = 'Dozvoljava planiranom zadatku da kreira indeks pretraživanja čak i kada je pretraga onemogućena. Ovo je korisno ako želite da kreirate indeks pre nego što se polaznicima pojavi mogućnost za pretraživanje.';
$string['searchinsettings'] = 'Traži u podešavanjima';
$string['searchlastrun'] = 'Poslednje izvršavanje (vreme, # dokumenata, # zapisa, # ignorisanja)';
$string['searchnotavailable'] = 'Pretraga nije na raspolaganju';
$string['searchoptions'] = 'Opcije za pretragu';
$string['searchpartial'] = '(Još nije u potpunosti indeksirano)';
$string['searchreindexed'] = 'Sav sadržaj sajta je ponovo indeksiran.';
$string['searchreindexindex'] = 'Ponovo indeksiraj sav sadržaj sajta';
$string['searchresults'] = 'Rezultati pretrage';
$string['searchsetupinfo'] = 'Podešavanje pretraživača';
$string['searchupdateindex'] = 'Ažuriraj sadržaj indeksa';
$string['sectionerror'] = 'Greška sekcije!';
$string['secureforms'] = 'Koristiti dodatne mere bezbednosti formulara';
$string['security'] = 'Bezbednost';
$string['selectdevice'] = 'Izaberi uređaj';
$string['selectsearchengine'] = 'Izaberi pretraživač';
$string['selecttheme'] = 'Izaberi grafičku temu za uređaj {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Provere servera';
$string['serverlimit'] = 'Ograničenje servera';
$string['sessionautostartwarning'] = '<p>Otkrivena je ozbiljna greška pri konfiguraciji, molimo obavestite administratora servera</p><p> Za ispravan rad, administrator treba da promeni PHP podešavanja.</p> <p><code>session.auto_start</code> mora biti podešeno na <code>off</code>.</p><p> Ovo podešavanje može se promeniti uređivanjem <code>php.ini</code> datoteke, konfiguracije Apache/IIS Web servera<br />ili <code>.htaccess</code> datoteke na serveru.</p>';
$string['sessioncookie'] = 'Prefiks kolačića';
$string['sessioncookiedomain'] = 'Domen kolačića';
$string['sessioncookiepath'] = 'Putanja kolačića';
$string['sessionhandling'] = 'Upravljanje sesijama';
$string['sessiontimeout'] = 'Vreme isteka sesije';
$string['settingdependenton'] = 'Ovo podešavanje može biti skriveno, na osnovu vrednosti <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Postavljanje datoteka je neophodno za normalan rad sistema. Molimo vas da omogućite ovo u PHP konfiguracionoj datoteci.';
$string['settingmaxinputvars'] = 'Preporučuje se da PHP podešavanje max_input_vars bude najmanje 5000.';
$string['settingmaxinputvarsrequired'] = 'PHP podešavanje max_input_vars mora da bude najmanje 5000.';
$string['settingmemorylimit'] = 'Uočena je nedostatak memorije. Molimo Vas da postavite veći limit za memoriju u PHP podešavaljima.';
$string['settingsafemode'] = 'Moodle nije u potpunosti kompatibilan sa bezbednim režimom. Zamolite administratora server da ga isključi. Pokretanje Moodlea u bezbednom režimu nije podržano, tako da ako to uradite možete očekivati različite probleme.';
$string['setupsearchengine'] = 'Podesi pretraživač';
$string['showcommentscount'] = 'Prikaži broj komentara';
$string['showdetails'] = 'Prikaži detalje';
$string['showuseridentity'] = 'Prikaži identitet korisnika';
$string['showuseridentity_desc'] = 'Prilikom izbora ili pretrage korisnika, kada se prikazuje spisak korisnika, ova polja se mogu prikazati pored njihovih imena i prezimena. Polja će se prikazati samo onim korisnicima koji imaju sposobnost moodle/site:viewuseridentity capability,  standardno, predavačima i menadžerima (ova opcija najviše ima smisla ako izaberete jedno ili dva polja koja su u vašoj instituciji obavezna).';
$string['simplexmlrequired'] = 'Moodle sada zahteva SimpleXML PHP ekstenziju.';
$string['sitemailcharset'] = 'Skup znakova';
$string['sitemaintenance'] = 'Sajt je u fazi održavanja i trenutno nije dostupan';
$string['sitemaintenancemode'] = 'Režim održavanja sistema';
$string['sitemaintenanceoff'] = 'Održavanje sistema je završeno i sajt je ponovo u normalnom režimu rada';
$string['sitemaintenanceon'] = 'Vaš sajt je trenutno u režimu održavanja (samo administratori mogu da pristupe sajtu)';
$string['sitemaintenanceoncli'] = 'Vaš sajt je trenutno u CLI režimu održavanja. Internet pristup nije dozvoljen.';
$string['sitemaintenancewarning'] = 'Vaš sajt je trenutno u režimu održavanja (samo administratori mogu da pristupe sajtu). Da bi ste vratili sajt u normalan režim rada, <a href="maintenance.php"> isključite režim održavanja</a>.';
$string['sitemaintenancewarning2'] = 'Vaš sajt je trenutno u režimu održavanja (samo administratori mogu da se prijave na sistem). Da biste vratili ovaj sajt u normalan režim rada, <a href="{$a}">isključite režim održavanja</a>.';
$string['sitemenubar'] = 'Navigacija na sajtu';
$string['sitepolicies'] = 'Bezbednosna podešavanja sajta';
$string['sitepolicy'] = 'URL adresa pravilnika o korišćenju sajta';
$string['sitepolicy_help'] = 'URL pravilnika o korišćenju sajta koji svi registrovani korisnici moraju da pročitaju i prihvate pre pristupa sajtu. Imajte u vidu da će ovo podešavanje imati efekta samo ukoliko je upravljač pravilnikom o korišćenju sajta postavljen na Podrazumevano (core).';
$string['sitepolicyguest'] = 'URL adresa pravilnika o korišćenju sajta za goste';
$string['sitepolicyguest_help'] = 'URL adresa pravilnika o korišćenju sajta koji svi gosti moraju da pročitaju i prihvate pre nego što pristupe sajtu. Imajte u vidu da će ovo podešavanje imati efekta samo ukoliko je upravljač pravilnikom o korišćenju sajta postavljen na Podrazumevano (core).';
$string['sitepolicyhandler'] = 'Upravljač pravilnikom o korišćenju sajta';
$string['sitepolicyhandler_desc'] = 'Ovo određuje kako se upravlja pravilima sajta i saglasnostima korisnika sa tim pravilima. Podrazumevani (osnovni) upravljač omogućava da budu navedena kako URL adresa pravilnika o korišćenju sajtu, tako i URL adresa pravilnika o korišćenju sajtu za goste. Upravljač pravilima omogućava da budu podešena pravila korišćenja sajta, pravila privatnosti kao i druga pravila. On, takođe, omogućava da budu prikazane saglasnost korisnika  kao i da se, ako je to potrebno, dâ saglasnost u ime maloletnog lica.';
$string['sitepolicyhandlercore'] = 'Podrazumevano  (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Ukoliko je ova opcija izabrana, tematska sekcija će biti prikazana na naslovnoj stranici sajta.';
$string['sixtyfourbitsrequired'] = 'Otkriveno je da vaš sajt ne koristi 64-bitnu PHP verziju. Od vas se zahteva da nadogradite svoj sistem (operativni sistem, PHP...) pre instaliranja ove verzije Moodlea.';
$string['sixtyfourbitswarning'] = 'Otkriveno je da vaš sajt ne koristi 64-bitnu verziju PHP-a. Preporučuje se da nadogradite vaš sajt da biste obezbedili kompatibilnost sa budućim verzijama sistema.';
$string['slasharguments'] = 'Koristiti slash argumente';
$string['slashargumentswarning'] = 'Preporučuje se omogućavanje upotrebe argumenata sa kosom crtom. U budućnosti će to biti obavezno. Za više informacija pogledajte dokumentaciju <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Korišćenje argumenata sa kosom crtom</a>.';
$string['smartpix'] = '"Pametna" pretraga slika';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP tip provere identiteta';
$string['smtpdetail'] = 'Podešavanja SMTP (Simple Mail Transfer Protocol) servera za slanje e-pošte.';
$string['smtphosts'] = 'SMTP domaćin';
$string['smtpmaxbulk'] = 'Ograničenje SMTP sesije';
$string['smtppass'] = 'SMTP lozinka';
$string['smtpsecure'] = 'SMTP bezbednost';
$string['smtpuser'] = 'SMTP korisničko ime';
$string['soaprecommended'] = 'Instaliranje opcione soap ekstenzije je korisno za veb servise i neke dodatke za Moodle.';
$string['sort_fullname'] = 'Pun naziv kursa';
$string['sort_idnumber'] = 'ID broj  kursa';
$string['sort_shortname'] = 'Skraćeni naziv kursa';
$string['sort_sortorder'] = 'Redosled sortiranja';
$string['spellengine'] = 'Sistem za proveru pravopisa';
$string['spelllanguagelist'] = 'Spisak jezika za proveru pravopisa';
$string['splrequired'] = 'Moodle zahteva SPL PHP ekstenziju';
$string['stats'] = 'Statistika';
$string['statsfirstrun'] = 'Maksimalni interval obrade';
$string['statsmaxruntime'] = 'Maksimalno vreme izvršavanja';
$string['statsmoodleorg'] = 'statistika';
$string['statsruntimedays'] = 'Dana za obradu';
$string['statsruntimestart'] = 'Izvršavanje u';
$string['statsuserthreshold'] = 'Granična vrednost korisnika';
$string['stickyblocks'] = 'Fiksirani blokovi';
$string['stickyblockscourseview'] = 'Stranica kursa';
$string['stickyblocksduplicatenotice'] = 'Ako je bilo koji blok koji ovde dodate već prisutan na nekoj konkretnoj stranici, biće prikazan i njegov duplikat.<br />Jedino što se fiksirani blok neće moći menjati, a duplikat još uvek hoće.';
$string['stickyblocksmymoodle'] = 'Moj Moodle';
$string['stickyblockspagetype'] = 'Vrsta stranice za konfigurisanje';
$string['strictformsrequired'] = 'Striktna provera obaveznih polja';
$string['stripalltitletags'] = 'Ukloni HTML oznake iz svih naziva aktivnosti';
$string['supportcontact'] = 'Kontakt za podršku';
$string['supportemail'] = 'Adresa e-pošte za podršku';
$string['supportname'] = 'Ime za podršku';
$string['supportpage'] = 'Web stranica za podršku';
$string['suspenduser'] = 'Suspenduj korisnički nalog';
$string['switchlang'] = 'Promeni lang direktorijum';
$string['systempaths'] = 'Sistemske putanje';
$string['tablenosave'] = 'Promene u gornjoj tabeli se automatski čuvaju.';
$string['tablesnosave'] = 'Promene u gornjim tabelama se automatski čuvaju.';
$string['tabselectedtofront'] = 'U tabelama sa tabovima, da li bi red sa trenutno izabranim tabom trebalo da bude stavljen u prvi plan';
$string['tabselectedtofronttext'] = 'Postavite izabrani red kartice napred';
$string['task_adhoc_concurrency_limit'] = 'Ograničenja broja paralelnih ad hok zadataka';
$string['task_adhoc_concurrency_limit_desc'] = 'Broj pokretača ad hok zadataka kojima je dozvoljeno da rade istovremeno. Ako je limit visok, planirani zadaci se ne mogu izvršavati redovno kada postoji puno ad hok zadataka. Podešavanje 0 će u potpunosti onemogućiti obradu ad hok zadataka.';
$string['task_adhoc_max_runtime'] = 'Životni vek pokretača ad hok zadatka';
$string['task_adhoc_max_runtime_desc'] = 'Starost pokretača ad hok zadatka pre nego što se oslobodi. Preporučuje se kraći vremenski period jer ne postoji ograničenje broja ad hok zadataka koji mogu da budu na čekanju. Ako je ovaj broj previsok i ako imate veliki broj ad hok zadataka na čekanju, onda se planirani zadaci možda neće redovno pokretati.';
$string['task_dbstats'] = 'Baza podataka';
$string['task_duration'] = 'Vreme trajanja';
$string['task_logmode'] = 'Kada zapisivati';
$string['task_logmode_all'] = 'Čuvajte evidenciju svih zadataka';
$string['task_logmode_desc'] = 'Možete izabrati kada želite da se vodi evidencija o zadacima. Standardno, evidencije se uvek snimaju. Možete da onemogućite zapisivanje u potpunosti, ili da promenite pa da se evidentiraju samo zadaci koji nisu uspešno izvršeni.';
$string['task_logmode_failonly'] = 'Čuvajte samo evidencije za zadatke koji nisu uspešno izvršeni';
$string['task_logmode_none'] = 'Ne zapisuj ništa';
$string['task_logretainruns'] = 'Upamćena pokretanja';
$string['task_logretainruns_desc'] = 'Broj pokretanja svakog zadatka koje treba upamtiti. Ovo podešavanje je u interakciji sa podešavanjem \'Period zadržavanja\': primenjuje se prvo od ova dva ograničenje koje se dostigne';
$string['task_logretention'] = 'Period zadržavanja';
$string['task_logretention_desc'] = 'Maksimalni vremenski period tokom kog se evidencije čuvaju. Ovo podešavanje je u interakciji sa podešavanjem \'Upamćena pokretanja\': primenjuje se prvo od ova dva ograničenje koje se dostigne';
$string['task_logtostdout'] = 'Prikaži zapise izlaznih informacija';
$string['task_logtostdout_desc'] = 'Kada se zadaci izvršavaju, a izlazne informacije snimaju, da li bi, takođe, trebalo prikazati snimljene izlazne informacije dok se zadatak izvodi.';
$string['task_result'] = 'Rezultat';
$string['task_result:failed'] = 'Nije prošlo';
$string['task_scheduled_concurrency_limit'] = 'Ograničenja broja paralelnih planiranih zadataka';
$string['task_scheduled_concurrency_limit_desc'] = 'Broj izvršilaca planiranih zadataka kojima je dozvoljeno da rade istovremeno.
Ako je limit visok, može doćo do velikog opterećenja server što će uticati na njegove performanse. Podešavanje 0 će u potpunosti onemogućiti obradu planiranih zadataka.';
$string['task_scheduled_max_runtime'] = 'Životni vek pokretača planiranog zadatka';
$string['task_scheduled_max_runtime_desc'] = 'Starost pokretača planiranog zadatka pre nego što se oslobodi.';
$string['task_starttime'] = 'Početno vreme';
$string['task_stats:dbreads'] = 'očitavanja: {$a}';
$string['task_stats:dbwrites'] = 'upisivanja: {$a}';
$string['task_type:adhoc'] = 'Ad hok';
$string['task_type:scheduled'] = 'Planiran';
$string['taskadmintitle'] = 'Zadaci';
$string['taskanalyticscleanup'] = 'Čišćenje analitike';
$string['taskautomatedbackup'] = 'Automatsko kreiranje rezervnih kopija';
$string['taskbackupcleanup'] = 'Čišćenje tabela rezervnih kopija i zapisa';
$string['taskbadgescron'] = 'Dodela bedževa';
$string['taskbadgesmessagecron'] = 'Pozadinska obrada za slanje obaveštenja o bedževima';
$string['taskblogcron'] = 'Sinhronizacija eksternih blogova';
$string['taskcachecleanup'] = 'Uklanjanje zastarelih stavki keša';
$string['taskcachecron'] = 'Pozadinska obrada keša';
$string['taskcalendarcron'] = 'Slanje obaveštenja kalendara';
$string['taskcheckforupdates'] = 'Provera najnovijih verzija';
$string['taskcompletiondaily'] = 'Oznaka završenosti: započeto';
$string['taskcompletionregular'] = 'Izračunavanje redovnih podataka o završetku';
$string['taskcontextcleanup'] = 'Čišćenje konteksta';
$string['taskcreatecontexts'] = 'Kreiranje nedostajućih konteksta';
$string['taskdeletecachetext'] = 'Brisanje starih tekstualnih zapisa keša';
$string['taskdeleteincompleteusers'] = 'Brisanje nepotpunih korisničkih naloga';
$string['taskdeleteunconfirmedusers'] = 'Brisanje nepotvrđenih korisničkih naloga';
$string['taskeventscron'] = 'Pozadinska obrada događaja';
$string['taskfiletrashcleanup'] = 'Čišćenje datoteka iz korpe za otpatke';
$string['taskglobalsearchindex'] = 'Indeksiranje za globalnu pretragu';
$string['taskglobalsearchoptimize'] = 'Optimizacija indeksiranja globalne pretrage';
$string['taskgradecron'] = 'Pozadinska obrada knjige ocena';
$string['taskgradehistorycleanup'] = 'Pozadinska obrada za čišćenje tabela sa istorijom ocena';
$string['tasklegacycron'] = 'Nasleđena kron obrada dodataka';
$string['tasklogcleanup'] = 'Čišćenje evidencije zadataka';
$string['tasklogging'] = 'Konfiguracija evidencije zadataka';
$string['tasklogs'] = 'Evidencija zadataka';
$string['taskmessagingcleanup'] = 'Pozadinska obrada slanja poruka';
$string['taskpasswordresetcleanup'] = 'Čišćenje pokušaja resetovanja lozinke';
$string['taskplagiarismcron'] = 'Pozadinska obrada za nasleđeni kron u dodacima za proveru plagijata';
$string['taskportfoliocron'] = 'Pozadinska obrada dodataka za portfolio';
$string['taskprocessing'] = 'Obrada zadataka';
$string['taskquestioncron'] = 'Pozadinska obrada za čišćenje pregleda pitanja';
$string['taskquestionstatscleanupcron'] = 'Pozadinska obrada za čišćenje keša statistike pitanja';
$string['taskrefreshsystemtokens'] = 'Osvežavanje OAuth tokena za naloge servisa';
$string['taskregistrationcron'] = 'Registracija sajta';
$string['tasksendfailedloginnotifications'] = 'Slanje obaveštenja o neuspešnim prijavama na sistem';
$string['tasksendnewuserpasswords'] = 'Slanje novih korisničkih lozinki';
$string['tasksessioncleanup'] = 'Čišćenje starih sesija';
$string['taskstatscron'] = 'Pozadinska obrada statistike';
$string['tasktagcron'] = 'Pozadinska obrada oznaka';
$string['tasktempfilecleanup'] = 'Brisanje zastarelih privremenih datoteka';
$string['tasktype'] = 'Tip';
$string['tempdatafoldercleanup'] = 'Obriši privremene datoteke starije od';
$string['templates'] = 'Šabloni';
$string['testoutgoingmailconf'] = 'Testirajte konfiguraciju odlazne pošte';
$string['testoutgoingmailconf_errorcommunications'] = 'Vaš sajt ne može da komunicira sa vašim serverom e-pošte. Proverite konfiguraciju  odlazne pošte.';
$string['testoutgoingmailconf_message'] = 'Ovo je test poruka koja potvrđuje da ste uspešno konfigurirali odlaznu poštu na svom sajtu.';
$string['testoutgoingmailconf_sendtest'] = 'Pošalji test poruku';
$string['testoutgoingmailconf_sentmail'] = 'Ovaj sajt je uspešno isporučio test poruku serveru e-pošte. <br />Od: {$a->fromemail}<br />Za: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a}: test poruka';
$string['testoutgoingmailconf_toemail'] = 'Na adresu e-pošte';
$string['testoutgoingmaildetail'] = 'Napomena: pre testiranja sačuvajte konfiguraciju.<br />{$a}';
$string['testsiteupgradewarning'] = 'Trenutno koristite test sajt {$a}; da biste ga ispravno nadogradili , upotrebite interfejs sa komandom linijom';
$string['themedesignermode'] = 'Režim za dizajniranje teme';
$string['themedesignermodewarning'] = 'Režim za dizajniranje teme je uključen. Ovaj režim ne bi trebalo da bude uključen na produkcionim sajtovima, pošto on može značajno da umanji performanse sistema.';
$string['themelist'] = 'Spisak grafičkih tema';
$string['themenoselected'] = 'Nijedna grafička tema nije izabrana';
$string['themeresetcaches'] = 'Obriši teme iz keš memorije';
$string['themeselect'] = 'Promeni grafičku temu';
$string['themeselector'] = 'Selektor grafičke teme';
$string['themesettings'] = 'Podešavanja grafičkih tema';
$string['therewereerrors'] = 'Bilo je grešaka u vašim podacima';
$string['thirdpartylibrary'] = 'Biblioteka';
$string['thirdpartylibrarylocation'] = 'Lokacija';
$string['thirdpartylibs'] = 'Nezavisne biblioteke';
$string['timezone'] = 'Podrazumevana vremenska zona';
$string['timezoneforced'] = 'Ovo je administrator sajta proglasio obaveznim';
$string['timezoneinvalid'] = 'Neispravna vremenska zona "{$a}"';
$string['timezoneisforcedto'] = 'Obavezna upotreba za sve korisnike';
$string['timezonenotforced'] = 'Korisnici mogu odabrati sopstvenu vremensku zonu';
$string['timezonephpdefault'] = 'Podrazumevana PHP vremenska zona ({$a})';
$string['timezoneserver'] = 'Vremenska zona servera ({$a})';
$string['tlswarning'] = 'Nije detektovan PHP/cURL dodatak sa TLSv1.2 podrškom. Neki servisi možda neće raditi. Vrlo je preporučljivo da ažurirate svoje TLS biblioteke.';
$string['tokenduration'] = 'Trajanje tokena koji je kreirao korisnik';
$string['tokenduration_desc'] = 'Vremenski period za koji je korisnik kreirao token veb servisa (na primer putem mobilne aplikacije) je ispravan.';
$string['tokenizerrecommended'] = 'Preporučuje se instalacija opcionog PHP Tokenizer dodatka radi poboljšavanja funkcionalnosti za umrežavanje.';
$string['tools'] = 'Administratorski alati';
$string['toolsmanage'] = 'Upravljanje administratorskim alatima';
$string['unattendedoperation'] = 'Automatska instalacija';
$string['unbookmarkthispage'] = 'Ukloni obeleživač sa ove stranice';
$string['unicoderequired'] = 'Potrebno je da sve vaše podatke čuvate u Unicode formatu (UTF-8). Nove instalacije moraju biti primenjene u bazama podataka koje imaju osnovni skup znakova podešen na Unicode. Ukoliko vršite nadogradnju, potrebno je pokrenuti UTF-8 proces migracije (pogledajte stranicu za administraciju).';
$string['uninstallplugin'] = 'Deinstaliraj';
$string['unlockaccount'] = 'Otključaj nalog';
$string['unoconvwarning'] = 'Verzija unoconv konvertora koju ste instalirali nije podržana. Funkcionalnost koja omogućava ocenjivanja zadataka u Moodleu zahteva verziju 0.7 ili noviju.';
$string['unsettheme'] = 'Ukloni grafičku temu';
$string['unsupported'] = 'Nepodržano';
$string['unsupporteddbfileformat'] = 'Vaša baza podataka koriste Antelope kao format datoteke. Puna UTF-8 podrška u MySQL i MariaDB bazi podataka zahteva Barracuda format datoteke. Prebacite format datoteke na Barracuda format. Za više informacija pogledajte <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">Puna UTF-8 podrška u MySQL</a>';
$string['unsupporteddbfilepertable'] = 'Za punu podršku UTF-8 kodnog rasporeda i MySQL i MariaDB baza podataka zahteva da promenite MySQL podešavanje \'innodb_file_per_table\' na \'ON\'. Pogledajte dokumentaciju za više informacija.';
$string['unsupporteddblargeprefix'] = 'Za punu podršku UTF-8 kodnog rasporeda i MySQL i MariaDB baza podataka zahteva da promenite MySQL podešavanje \'innodb_file_per_table\' na \'ON\'. Pogledajte dokumentaciju za više informacija.';
$string['unsupporteddbstorageengine'] = 'Mašina baze podataka koja se koristi nije više podržana.';
$string['unsupporteddbtablerowformat'] = 'Vaša baza sadrži tabele koje koriste Antelope kao format datoteke. Preporučuje se da konvertujete te tabele u Barracuda format datoteke. Pogledajte dokumentaciju <a href="https://docs.moodle.org/en/cli">Administracija putem komandne linije</a> za detalje vezane za alat za konverziju InnoDB tabela u format Barracuda.';
$string['unsupportedphpversion7'] = 'PHP verzija 7 nije podržana.';
$string['unsupportedphpversion71'] = 'PHP verzija 7.1 nije podržana.';
$string['unsupportedphpversion72'] = 'PHP verzija 7.2 nije podržana.';
$string['unsupportedphpversion73'] = 'PHP verzija 7.3 nije podržana.';
$string['unsupportedphpversion74'] = 'PHP verzija 7.4 nije podržana.';
$string['unsupportedphpversion80'] = 'PHP verzija 8.0 nije podržana.';
$string['unsupportedphpversion81'] = 'PHP verzija 8.1 i novije nisu podržane.';
$string['unsupportedphpversion82'] = 'PHP verzija 8.2 i novije nisu podržane.';
$string['unsuspenduser'] = 'Aktivirajte korisnički nalog';
$string['updateaccounts'] = 'Ažuriranje postojećih naloga';
$string['updateautocheck'] = 'Automatski proveri dostupnost novih verzija';
$string['updateautocheck_desc'] = 'Ako je ovo podešavanje omogućeno,  vaš sajt će automatski proveravati da li su dostupne nove verzije kako osnovnog Moodle paketa, tako i svih dodataka. Ako postoje dostupne nove verzije, biće poslato obaveštenje e-poštom administratorima sajta.';
$string['updateavailable'] = 'Dostupna je novija verzija Moodlea!';
$string['updateavailable_moreinfo'] = 'Više informacija...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Verzija{$a}';
$string['updateavailabledetailslink'] = 'Za više informacija pogledajte {$a->url}';
$string['updateavailableforplugin'] = 'Dostupne su novije verzije za neke od vaših dodataka!';
$string['updateavailableinstall'] = 'Instaliraj novu verziju';
$string['updateavailableinstallall'] = 'Instaliraj dostupne nove verzije ({$a})';
$string['updateavailableinstallallhead'] = 'Instaliranje dostupnih novih verzija';
$string['updateavailablenot'] = 'Koristite poslednju verziju Moodlea!';
$string['updateavailablerecommendation'] = 'Veoma je preporučljivo da ažurirate svoj sajt na najnoviju verziju kako biste dobili sve skorašnje bezbednosne ispravke, kao i ispravke grešaka.';
$string['updatecomponent'] = 'Ažuriraj komponentu';
$string['updateminmaturity'] = 'Potrebna zrelost kôda';
$string['updateminmaturity_desc'] = 'Pošalji obaveštenje o novim verzijama samo ako dostupni kôd ima, najmanje, izabrani nivo zrelosti. Nove verzije dodataka koje ne objavljuju zrelost svog kôda uvek se prijavljuju, bez obzira na ovo podešavanje.';
$string['updatenotificationfooter'] = 'Vaš Moodle sajt {$a->siteurl} je konfigurisan da automatski proverava da li su dostupne nove verzije programa. Ovu poruku ste dobili kao administrator sajta. Automatsku proveru novih verzija možete da onemogućite na Administracija sajta/Server/Obaveštenja o novim verzijama ili da prilagodite način slanja ove poruke na svojoj stranici sa parametrima.';
$string['updatenotifications'] = 'Obaveštenja o novim verzijama';
$string['updatenotificationsubject'] = 'Dostupne su nove verzije Moodlea ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Obavesti o novim podverzijama';
$string['updatenotifybuilds_desc'] = 'Ako je ovo podešavanje omogućeno,  onda će obaveštenje o novoj verziji Moodle paketa biti poslato i u situacijama kada je dostupna nova podverzija za tekuću verziju programa. Podverzije (builds) predstavljaju kontinuirana poboljšanja date verzije Moodlea. Generalno, ova obaveštenja se objavljuju svake nedelje. Ako je ovo podešavanje onemogućeno, obaveštenje o novoj verziji će biti poslato samo kada se pojavi nova, unapređena verzija. Ovo podešavanje ne utiče na proveru novih verzija dodataka.';
$string['upgradeerror'] = 'Nepoznata greška u toku nadogradnje {$a->plugin} na verziju {$a->version}. Nije moguće nastaviti.';
$string['upgradeforumread'] = 'Moodle verziji 1.5 je dodata nova opcija za praćenje pročitanih/nepročitanih poruka u forumima. <br />Da biste mogli da koristite ovu opciju morate da <a href={$a}>ažurirate svoje tabele</a>.';
$string['upgradeforumreadinfo'] = 'Moodle verziji 1.5 je dodata nova opcija za praćenje pročitanih/nepročitanih poruka u forumima. Da biste mogli da koristite ovu opciju morate da ažurirate svoje tabele zajedno sa svim informacijama za postojeće poruke na forumima. U zavisnosti od veličine Vašeg sajta takva akcija može potrajati (i do nekoliko sati) i može opteretiti bazu podataka, tako da je najbolje da to obavite kada je server manje opterećen. Ipak, Vaš sajt će u toku osvežavanja biti u funkciji i korisnici neće biti time pogođeni. Kada jednom započnete ovaj proces pustite da se završi (ostavite otvoren prozor svog Web čitača). Ukoliko, ipak, zatvorite prozor: ne brinite, moći ćete ponovo da startujte proces.<br /><br />Da li želite da započnete proces ažuriranja?';
$string['upgradekeyreq'] = 'Neophodan ključ za nadogradnju';
$string['upgradekeyset'] = 'Ključ za nadogradnju (ostavite prazno ako ne želite da postavite ključ)';
$string['upgradelogs'] = 'Zbog potpune fukcionalnosti, vaši stari zapisi o aktivnostima treba da budu nadograđeni. <a href="{$a}">Više informacija</a>';
$string['upgradelogsinfo'] = 'Nedavno su napravljene određene promene u načinu čuvanja zapisa o aktivnostima. Da biste mogli da vidite sve svoje stare zapise, redom po aktivnostima, potrebno je da ih nadogradite. U zavisnosti od vašeg sajta, to može da potraje (i do nekoliko sati) i da optereti bazu podataka za velike sajtove. Jednom kada započnete ovaj proces, potrebno je da ga pustite da se završi (tako što ćete prozor veb čitača ostaviti otvoren). Ne brinite - dok se zapisi o aktivnostima nadograđuju. vaš sajt će i dalje raditi bez problema za ostale korisnike,.<br /><br />Da li želite sada da nadogradite zapise o aktivnostima?';
$string['upgradepluginsfirst'] = 'Preporučuje se da prvo instalirate sve dostupne nove verzije';
$string['upgradepluginsinfo'] = 'Nadogradnja dodataka';
$string['upgradepluginsinfo_help'] = 'Postoje dostupne nove verzije za neke od vaših dodataka. Trebalo bi da ih sve instalirate pre nadogradnje Moodle baze podataka. Ako vaš sajt ne podržava automatsko ažuriranje, morate da preuzmete i ručno, na serveru, instalirate nove verzije dodataka.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nova podešavanja';
$string['upgradesettingsintro'] = 'Dole navedena podešavanja su dodata tokom poslednje nadogradnje Moodlea. Napravite sve potrebne promene podrazumevanih vrednosti i kliknite na dugme \'Sačuvaj promene\' na dnu ove stranice.';
$string['upgradestalefiles'] = 'Otkrivene su izmešane verzije Moodle pa nadogradnja ne može da se nastavi';
$string['upgradestalefilesinfo'] = 'Proces nadogradnje Moodlea je zaustavljen zato što su u Moodle direktorijumu otkrivene PHP skripte iz najmanje dve različite verzije Moodlea

Ovo kasnije može da napravi velike probleme. Kako biste nastavili proces nadogradnje, morate prvo da obezbedite da u Moodle direktorijumu budu datoteke samo jedne verzije Moodlea

Da biste očistili Moodle direktorijum i rešili ovaj problem uradite sledeće:

* promenite naziv tekućeg Moodle direktorijuma u "moodle_old"
* kreirajte novi Moodle direktorijum koji sadrži samo datoteke iz standardnog Moodle paketa, ili iz GIT repozitorijuma.
* prebacite originalnu config.php datoteku i sve nestandardne dodatke iz starog, ”moodle_old”, u novi Moodle direktorijum.

Kada završite opisanu proceduru, osvežite ovu stranicu kako biste nastavili proces nadogradnju Moodlea.

Ovo upozorenje je često posledica raspakivanja standardnog Moodle paketa u postojeći direktorijum, u kojem se nalazi prethodna verzija Moodlea. Iako ovaj postupak ne stvara probleme prilikom manjih nadogradnji, nikako se ne savetuje kada se rade velike nadogradnje Moodlea.

Upozorenje, takođe, može da bude posledica nepotpune provere ili nadogradnje iz GIT repozitorijuma, u kom slučaju ćete morati samo da sačekate da se operacija završi, eventualno pokrenete odgovarajuću komandu za čišćenje i ponovo pokušate operaciju.

Više informacija možete naći u dokumentaciji o nadogradnji na <a href=”{$a}">{$a}</a>';
$string['upgradestart'] = 'Nadogradi Moodle bazu podataka sada';
$string['upgradesure'] = '<p>Vaše Moodle datoteke su izmenjene, i nameravate da automatski nadogradite svoj server na ovu verziju:</p>
<p><strong>{$a}</strong></p>
<p>Jednom kada ovo uradite ne možete se vratiti nazad. Molimo uzmite u obzir i to da ovaj proces može da potraje.</p>
<p>Da li ste sigurni da želite da nadogradite server na ovu verziju?</p>';
$string['upgradetimedout'] = 'Isteklo je vreme za ažuriranje, molimo započnite proces ažuriranja iznova.';
$string['upgradingdata'] = 'Ažuriranje podataka je u toku';
$string['upgradinglogs'] = 'Nadogradnja zapisa o aktivnostima je u toku';
$string['upgradingversion'] = 'Nadogradnja na novu verziju';
$string['upwards'] = 'nagore';
$string['useblogassociations'] = 'Omogući povezivanje';
$string['useexternalyui'] = 'Koristi YUI biblioteke na mreži';
$string['user'] = 'Korisnik';
$string['userbulk'] = 'Masovne akcije nad korisnicima';
$string['userbulkdownload'] = 'Izvezi korisnike kao';
$string['userdefaultpreferences'] = 'Podrazumevana podešavanja profila korisnika';
$string['userfeedbackafterupgrade'] = 'Posle svake veće nadogradnje';
$string['userfeedbackencouragement'] = '<p>Od verziji 3.9 u Moodle je uključena nova funkcija koja korisnicima daje mogućnost da Moodle HQ-u daju povratne informacije o Moodle softveru putem eksternog sajta za anketiranje koji hostuje Moodle HQ. Nijedna informacija koja  bi mogla da identifikuje korisnika ne prosleđuje se sajtu na kojem se anketa nalazi.</p>
<p>Moodle HQ nastoji da bude otvoren i transparentan u pogledu svojih pravila o prikupljanju podataka. Stoga želimo da budemo sigurni da ste svesni ove funkcije i da imate punu kontrolu nad njom.</p>
<p>Povratne informacije korisnika će u velikoj meri pomoći da Moodle HQ unapredi Moodle softver. Da biste omogućili ovu funkciju, idite na <a href="{$a}">Podešavanja povratnih informacija</a>.</p>';
$string['userfeedbacknextreminder'] = 'Sledeći podsetnik za povratne informacije';
$string['userfeedbacknextreminder_desc'] = 'Kada treba ponovo tražiti od korisnika da dâ povratne informacije?';
$string['userfeedbackperiodically'] = 'Periodično';
$string['userfeedbackremindafter'] = 'Prikaži podsetnik nakon';
$string['userfeedbackremindafter_desc'] = 'Podsetite korisnike ponovo da pošlju povratne informacije nakon određenog broja dana.';
$string['userfiltersdefault'] = 'Podrazumevani korisnički filteri';
$string['userfiltersdefault_desc'] = 'Izaberite filtere koji će se prikazivati na stranici "Pretraga spiska učesnika", kao i  na stranici "Akcije nad više korisnika". Držite pritisnut taster Ctrl da biste izabrali više stavki. Svi filteri koje ne izaberete biće raspoloživi klikom na link "Prikaži više".';
$string['userimagesdisabled'] = 'Slike korisničkih profila su onemogućene';
$string['userlist'] = 'Pregled spiska korisnika';
$string['usermanagement'] = 'Upravljanje korisnicima';
$string['userpolicies'] = 'Pravila za korisnike';
$string['userpreference'] = 'Korisnička podešavanja';
$string['userquota'] = 'Odeljak za privatne datoteke';
$string['userquota_desc'] = 'Maksimalna veličina podataka koje korisnik može da čuva u svom privatnom odeljku za datoteke.';
$string['users'] = 'Korisnici';
$string['usesitenameforsitepages'] = 'Koristi naziv sajta za stranice sajta';
$string['usetags'] = 'Omogući oznake (tagove)';
$string['validateemptylineerror'] = 'Prazni redovi nisu ispravni';
$string['validateerror'] = 'Ova vrednost nije ispravna';
$string['validateerrorlist'] = 'Ovi unosi su neispravni: {$a}';
$string['validateiperror'] = 'Sledeće IP adrese nisu validne: {$a}';
$string['verifychangedemail'] = 'Ograniči domene prilikom promene e-adrese';
$string['warningcurrentsetting'] = 'Neispravna trenutna vrednost: {$a}';
$string['warningiconvbuggy'] = 'Vaša verzija iconv biblioteke ne podržava //IGNORE modifikator. Trebalo bi da instalirate ekstenziju mbstring koja može, umesto iconv biblioteke, da se koristi za čišćenje stringova koji sadrže neispravne UTF-8 znakove.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Popuni sledeće opcije ukoliko Moodle server ne može da pristupi Internetu direktno. Pristup Internetu je neophodan za preuzimanje podataka o okruženju, jezičkih paketa, RSS izvora vesti, vremenskih zona itd.<br /><em>PHP cURL ekstenzija se preporučuje!!!.</em>';
$string['xmlrpcmaharaenabled'] = 'Otkriveno je da je Mahara ePortfolio omogućen na vašem sajtu. Ova funkcija se oslanja na PHP XML-RPC ekstenziju koju PHP više ne održava.';
$string['xmlrpcmnetenabled'] = 'Otkriveno je da je Moodle Networking omogućen na vašem sajtu. Ova funkcija se oslanja na PHP XML-RPC ekstenziju koju PHP više ne održava.';
$string['xmlrpcrecommended'] = 'XMLRPC ekstenzija je korisna za veb servise i Moodle umrežavanje.';
$string['xmlrpcwebserviceenabled'] = 'Otkriveno je da je na vašem sajtu omogućen protokol XML-RPC Web Service. Ova funkcija se oslanja na PHP XML-RPC ekstenziju koju PHP više ne održava.';
$string['yuicomboloading'] = 'YUI combo se učitava';
$string['ziprequired'] = 'PHP ekstenzija Zip sada je obavezna za Moodle, binarne info-ZIP datoteke i biblioteka PclZip više se ne koriste.';
