<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'nl', version '3.9'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Actie';
$string['activityoverview'] = 'U heeft niet ingevulde vragenlijsten';
$string['additionalinfo'] = 'Bijkomende informatie';
$string['additionalinfo_help'] = 'Tekst die wordt getoond bovenaan de eerste pagina van deze vragenlijst (bijvoorbeeld instructies, achtergrondinformatie, enz).';
$string['addnewquestion'] = 'Voeg {$a} vraag toe';
$string['addnewsection'] = 'Nieuwe sectie toevoegen';
$string['addquestion'] = 'Vraag toevoegen...';
$string['addquestions'] = 'Vragen toevoegen';
$string['addquestiontosection'] = 'Vraag toevoegen aan sectie';
$string['addselqtype'] = 'Geselecteerde vraagtype toevoegen';
$string['alignment'] = 'Uitlijning van de keuzerondjes';
$string['alignment_help'] = 'Selecteer uitlijning voor de selectievakjes: verticaal (standaard) of horizontaal';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Alles';
$string['allnameddegrees'] = 'Namen voor waardes';
$string['allnameddegrees_help'] = 'Specificeer een weer te geven tekst voor beoordelingswaardes in plaats van het cijfer. Leeg laten om niet te gebruiken.';
$string['alreadyfilled'] = 'Deze vragenlijst heb je voor ons al ingevuld {$a}. Bedankt!';
$string['andaveragevalues'] = 'en gemiddelde waardes';
$string['anonymous'] = 'Anoniem';
$string['answer'] = 'Antwoord';
$string['answergiven'] = 'Dit antwoord gegeven';
$string['answernotgiven'] = 'Dit antwoord niet gegeven';
$string['answerquestions'] = 'Beantwoord de vragen...';
$string['answers'] = 'Antwoorden';
$string['attempted'] = 'Deze vragenlijst is ingeleverd.';
$string['attemptstillinprogress'] = 'Deels voltooid. Opgeslagen op:';
$string['autonumbering'] = 'Automatische nummering';
$string['autonumbering_help'] = 'Automatische nummering van vragen en pagina\'s. Voor vragenlijsten met conditionele vertakkingen kunt u automatische nummering het beste uitschakelen.';
$string['autonumberno'] = 'Nummer de vragen en pagina\'s niet';
$string['autonumberpages'] = 'Pagina\'s automatisch nummeren';
$string['autonumberpagesandquestions'] = 'Pagina\'s en vragen automatisch nummeren';
$string['autonumberquestions'] = 'Vragen automatisch nummeren';
$string['average'] = 'Gemiddeld';
$string['averageposition'] = 'Gemiddeld standpunt';
$string['averagerank'] = 'Gemiddelde classificatie';
$string['averagesrow'] = 'Gemiddelde (wanneer van toepassing):';
$string['bodytext'] = 'Eigenlijke tekst';
$string['boxesnbexact'] = 'precies {$a} vak(jes).';
$string['boxesnbmax'] = 'maximaal {$a} vak(jes).';
$string['boxesnbmin'] = 'minimaal {$a} vak(jes).';
$string['boxesnbreq'] = 'Selecteer bij deze vraag';
$string['by'] = 'door';
$string['cannotviewpublicresponses'] = 'U kunt de antwoorden van deze vragenlijst niet bekijken.';
$string['chart:bipolar'] = 'Balken met twee polen';
$string['chart:hbar'] = 'Horizontaal staafdiagram';
$string['chart:radar'] = 'Radardiagram';
$string['chart:rose'] = 'Roosdiagram';
$string['chart:type'] = 'Grafiektype';
$string['chart:type_help'] = 'Selecteer het gewenste grafiektype voor deze terugkoppeling';
$string['chart:vprogress'] = 'Verticale voortgangsbalk';
$string['checkallradiobuttons'] = 'Selecteer <strong>{$a}</strong> selectievakje(s) alstublieft!';
$string['checkboxes'] = 'Selectievakjes';
$string['checkboxes_help'] = 'Voer één optie in per regel waarvan de gebruiker één of meerdere antwoorden kan selecteren.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Nieuw pagina-einde ingevoegd op positie(s):';
$string['checkbreaksok'] = 'Alle vereiste pagina-eindes zijn aanwezig!';
$string['checkbreaksremoved'] = '{$a} extra pagina-einde(s) verwijderd.';
$string['checknotstarted'] = 'Selecteer niet gestart';
$string['checkstarted'] = 'Selecteer gestart';
$string['clicktoswitch'] = '(klik om te switchen)';
$string['closebeforeopen'] = 'Je hebt een sluitingsdatum voor de open datum opgegeven.';
$string['closed'] = 'De vragenlijst is gesloten op {$a}. Dank je.';
$string['closedate'] = 'Antwoorden toestaan tot';
$string['closeson'] = 'Vragenlijst sluit op {$a}';
$string['completionsubmit'] = 'Leerling moet deze enquête insturen om hem te voltooien';
$string['condition'] = 'Voorwaarde';
$string['confalts'] = '- OF - <br />Bevestigingspagina';
$string['configemailreporting'] = 'Start e-mailen van rapportages toe';
$string['configemailreportinglong'] = 'Maakt het mogelijk om sommige rapporten rechtstreeks of naar gespecificeerde e-mailadressen te sturen.';
$string['configmaxsections'] = 'Maximum aantal feedback-secties';
$string['configusergraph'] = 'Toon grafieken voor feedback "Persoonlijkheidstest"';
$string['configusergraphlong'] = 'Gebruik de <a href="http://www.rgraph.net/">Rgraph</a> library om de "Personaliteitstest" feedback grafieken weer te geven.';
$string['confirmdelallresp'] = 'Weet je zeker dat je ALLE antwoorden in deze enquête wilt verwijderen?';
$string['confirmdelchildren'] = 'Als je deze vraag verwijdert, worden ook de onderliggende vragen verwijderd:';
$string['confirmdeletesection'] = 'Weet je zeker dat je de feedback sectie "{$a}" wilt verwijderen?';
$string['confirmdelgroupresp'] = 'Weet je zeker dat je ALLE antwoorden van {$a} wilt verwijderen?';
$string['confirmdelquestion'] = 'Weet je zeker dat je de vraag op positie {$a} wilt verwijderen?';
$string['confirmdelquestionresps'] = 'Hierdoor zullen ook de {$a} antwoord(en) op deze vraag worden verwijderd.';
$string['confirmdelresp'] = 'Weet je zeker dat je het antwoord wilt verwijderen door&nbsp;{$a}&nbsp;?';
$string['confirmremovequestion'] = 'Weet je zeker dat je de vraag "{$a->qname}" uit sectie "{$a->sname}" wilt verwijderen?';
$string['confpage'] = 'Tekst voor kop';
$string['confpage_help'] = 'Kop (vetgedrukt) en body tekst voor "Bevestigingspagina" nadat een gebruiker deze enquête voltooit. (URL, indien aanwezig, heeft voorrang boven bevestigingstekst.)
Als dit veld wordt leeg gelaten, wordt er een standaardbericht getoond na voltooiing van de enquête (Bedankt voor het voltooien van deze Enquête).';
$string['confpagedesc'] = 'Kop (vetgedrukt) en body tekst voor "Bevestigingspagina" nadat een gebruiker deze enquête voltooit. (URL, indien aanwezig, heeft voorrang boven bevestigingstekst.)';
$string['contentoptions'] = 'Inhoudopties';
$string['couldnotcreatenewsurvey'] = 'Kon geen nieuwe enquête maken!';
$string['couldnotdelresp'] = 'Kon antwoord niet verwijderen';
$string['createcontent'] = 'Maak nieuwe inhoud';
$string['createcontent_help'] = 'Selecteer een van de opties voor keuzerondjes. \'Maak nieuwe\' is standaard.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Maak nieuwe';
$string['crontask'] = 'Enquête opruimtaak';
$string['date'] = 'Datum';
$string['date_help'] = 'Gebruik dit vraagtype als je verwacht dat het antwoord een correct geformatteerde datum is.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Gebruik het dag/maand/jaar format, bijv. voor 14 maart 1945:&nbsp;<strong>14/3/1945</strong>';
$string['deleteallresponses'] = 'Verwijder ALLE antwoorden';
$string['deletecurrentquestion'] = 'Verwijder vraag {$a}';
$string['deletedallgroupresp'] = 'Verwijder ALLE antwoorden in groep {$a}';
$string['deletedallresp'] = 'Antwoorden van enquête verwijderd';
$string['deletedisabled'] = 'Dit item kan niet worden verwijderd';
$string['deletedresp'] = 'Verwijderd antwoord';
$string['deleteresp'] = 'Verwijder dit antwoord';
$string['deletesection'] = 'Verwijder deze sectie';
$string['deletingresp'] = 'Dit antwoord verwijderen';
$string['dependencies'] = 'Afhankelijkheden';
$string['dependquestion'] = 'Bovenliggende vraag';
$string['dependquestion_help'] = 'Je kunt een bovenliggende vraag en keuzeoptie voor deze vraag selecteren. Een onderliggende vraag wordt alleen aan de leerling getoond wanneer de bovenliggende vraag en bovenliggende keuze eerder zijn geselecteerd.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Vraag niet beantwoord';
$string['directwarnings'] = 'Directe afhankelijkheden naar deze vraag zullen worden verwijderd. Dit beïnvloedt:';
$string['displaymethod'] = 'Vertoningsmethode is niet gedefinieerd voor deze vraag.';
$string['download'] = 'Downloaden';
$string['downloadpdf'] = 'PDF downloaden';
$string['downloadtextformat'] = 'Downloaden';
$string['downloadtextformat_help'] = 'Hiermee kun je alle antwoorden van een enquête bewaren naar een geselecteerd, en ondersteund file format.
Je kan eventueel extra data items toevoegen aan een export, en tevens automatisch rapportages als een bestand sturen naar geselecteerde gebruikers.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Rapport type';
$string['dropdown'] = 'Rolmenu';
$string['dropdown_help'] = 'Er is geen werkelijk voordeel voor het gebruiken van het rolmenu  boven keuzerondjes, behalve wellicht de ietwat lange lijsten met opties, om ruimte te besparen.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Bewerk';
$string['editingfeedback'] = 'Feedbackinstellingen bewerken';
$string['editingquestionnaire'] = 'Enquête-instellingen bewerken';
$string['editquestion'] = 'Vraag {$a} bewerken';
$string['email'] = 'E-mail';
$string['emailextra'] = 'Stuur download naar e-mailadressen';
$string['emailextra_help'] = 'Zal een download bestand sturen naar een lijst van e-mailadressen, gescheidde door een komma. Wees je ervan bewust dat er géén veiligheid en/of privacy controle plaatst vindt. De instelling \'allowemailreporting\' moet aangevinkt staan in de module instellingen om deze functie te gebruiken.';
$string['emailroles'] = 'Stuur download naar rollen';
$string['emailroles_help'] = 'Zal per e-mail een download bestand sturen naar alle rollen met het recht "mod/questionnaire:submissionnotification". De instelling \'allowemailreporting\' moet aangevinkt staan in de module instellingen om deze functie te gebruiken.';
$string['emailsend'] = 'Stuur rapportages';
$string['emailsnotspecified'] = 'Er zijn géén e-mailadressen opgegeven.';
$string['emailssent'] = 'Download gestuurd naar de opgeven e-mailadres(sen).';
$string['errnewname'] = 'Sorry, deze naam wordt al gebruikt. Kies een nieuwe naam.';
$string['erroropening'] = 'Fout bij openen enquête.';
$string['errortable'] = 'Fout systeemtabel corrupt.';
$string['essaybox'] = 'Ruimte voor open vraag';
$string['essaybox_help'] = 'Deze vraag zal een leeg tekstvak met x kolommen (of breedte van het vak) en y rijen (aantal tekstregels) tonen.

Als je de waarde van zowel x als y op standaard 0 laat (of wanneer je deze instelt op 0), zal de standaard HTML editor van Moodle worden getoond met standaard hoogte en breedte (indien beschikbaar in de cursus- en gebruikerscontext en het gebruikersprofiel).';
$string['event_all_responses_deleted'] = 'Alle antwoorden verwijderd';
$string['event_all_responses_saved_as_text'] = 'Alle antwoorden opgeslagen als tekst';
$string['event_all_responses_viewed'] = 'Rapport alle antwoorden bekeken';
$string['event_individual_responses_viewed'] = 'Rapport individuele antwoorden bekeken';
$string['event_non_respondents_viewed'] = 'Non-respondenten bekeken';
$string['event_previewed'] = 'Enquête voorvertoond';
$string['event_question_created'] = 'Vraag gecreëerd';
$string['event_question_deleted'] = 'Vraag verwijderd';
$string['event_response_deleted'] = 'Individueel antwoord verwijderd';
$string['event_resumed'] = 'Poging hervat';
$string['event_saved'] = 'Antwoorden opgeslagen';
$string['event_submitted'] = 'Antwoorden ingestuurd';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Hulp bij Feedback';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Voeg {no} feedbackvelden toe';
$string['feedbackbysection'] = 'Categorie feedback';
$string['feedbackdefaultlabel'] = '[Nieuwe sectie]';
$string['feedbackeditingglobal'] = 'Globale feedback Enquête bewerken';
$string['feedbackeditingmessages'] = 'Feedbackberichten Enquête bewerken';
$string['feedbackeditingsections'] = 'Feedbacksecties Enquête bewerken';
$string['feedbackeditmessages'] = 'Sectie-instellingen opslaan en Feedbackberichten bewerken';
$string['feedbackeditsections'] = 'Instellingen opslaan en Feedbacksecties bewerken';
$string['feedbackerrorboundaryformat'] = 'Grenswaarden voor de feedbackscores moeten een percentage of een getal zijn. De waarde die je hebt ingevoerd voor grenswaarde {$a} wordt niet herkend.';
$string['feedbackerrorboundaryoutofrange'] = 'Grenswaarden voor de feedbackscores moeten tussen 0% en 100% zijn. De waarde die je hebt ingevoerd voor grenswaarde {$a} valt buiten dit bereik.';
$string['feedbackerrorjunkinboundary'] = 'Je moet de vakjes voor grenswaarden voor de feedbackscores invullen zonder tussenruimte over te laten.';
$string['feedbackerrorjunkinfeedback'] = 'Je moet de feedbackvakken vullen zonder tussenruimte over te laten.';
$string['feedbackerrororder'] = 'Grenswaarden voor de feedbackscores moeten op volgorde zijn, hoogste waarde eerst. De waarde die je hebt ingevoerd voor grenswaarde {$a} is niet op volgorde.';
$string['feedbackglobal'] = 'Globale feedback';
$string['feedbackglobalheading'] = 'Kop globale feedback';
$string['feedbackglobalmessages'] = 'Globale feedbackberichten';
$string['feedbackhdr'] = 'Feedback';
$string['feedbackheading'] = 'Kop feedback';
$string['feedbackheading_help'] = 'In het veld Kop feedback kun je 2 variabelen gebruiken: $scorepercent en $oppositescorepercent.';
$string['feedbackmessages'] = 'Berichten voor sectie {$a}';
$string['feedbacknextsection'] = 'Volgende categorie {$a}';
$string['feedbacknone'] = 'Geen feedbackberichten';
$string['feedbacknotes'] = 'Feedbacknotities';
$string['feedbacknotes_help'] = 'De hier ingevoerde tekst zal aan respondenten worden getoond aan het einde van hun Feedback rapportage.';
$string['feedbackoptions'] = 'Feedbackopties';
$string['feedbackoptions_help'] = 'Feedbackopties zijn beschikbaar indien je enquête de volgende vraagtypen en -instellingen bevat:
Radio buttons; Rolmenu; Ja/Nee of Beoordeel (normaal of Osgood schaal). Deze vragen moeten ingesteld zijn als Vereist, hun vraagnaam mag NIET leeg gelaten worden en de Mogelijke antwoordkeuzes moeten een waarde bevatten.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Deze vraag maakt deel uit van feedbacksectie [{$a}]';
$string['feedbackremovesection'] = 'Het verwijderen van deze vraag zal feedbacksectie [{$a}] volledig verwijderen';
$string['feedbackreport'] = 'Feedbackrapport';
$string['feedbackscore'] = 'Feedbackscore';
$string['feedbackscoreboundary'] = 'Grens feedbackscore';
$string['feedbackscores'] = 'Toon scores';
$string['feedbackscores_help'] = 'Toon de tabel met feedbackscores';
$string['feedbacksection'] = 'Categorie';
$string['feedbacksectionheading'] = 'Kop voor sectie {$a}';
$string['feedbacksectionheadingmissing'] = 'Je moet een kop invoeren voor deze Feedbacksectie!';
$string['feedbacksectionheadingtext'] = 'Kop';
$string['feedbacksectionlabel'] = 'Label';
$string['feedbacksectionlabel_help'] = 'Dit label wordt gebruikt in grafieken/diagrammen. Houd het daarom zo kort mogelijk!';
$string['feedbacksectionquestions'] = 'Vragen in sectie {$a}';
$string['feedbacksections'] = 'Feedback-secties';
$string['feedbacksectionsselect'] = 'Categorieën';
$string['feedbacksectionsselect_help'] = 'Plaats je vragen in deze secties';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Feedbackinstellingen opgeslagen';
$string['feedbacktype'] = 'Feedbacktype';
$string['field'] = 'Vraag {$a}';
$string['fieldlength'] = 'Input box lengte';
$string['fieldlength_help'] = 'Voor het **Tekstvak** vraagtype, voer de **Input box lengte** en de **Maximale lengte van tekst** in van de door respondent in te voeren tekst.

Standaardwaarden zijn 20 tekens voor de Input Box en 25 tekens voor de maximale lengte van ingevoerde tekst.';
$string['finished'] = 'U heeft alle vragen in deze enquête beantwoord';
$string['firstrespondent'] = 'Eerste respondent';
$string['formateditor'] = 'HTML-editor';
$string['formatplain'] = 'Platte tekst';
$string['grade'] = 'Cijfer inzending';
$string['gradesdeleted'] = 'Cijfers voor enquête verwijderd';
$string['headingtext'] = 'Titel';
$string['horizontal'] = 'Horizontaal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Keuzecodes opnemen';
$string['includechoicetext'] = 'Keuzetekst opnemen';
$string['includeincomplete'] = 'Onvolledige inzendingen mee opnemen';
$string['includerankaverages'] = 'Neem het gemiddelde van de rangvragen op';
$string['incorrectcourseid'] = 'Incorrecte Cursus ID';
$string['incorrectmodule'] = 'Cursusmodule ID was onjuist';
$string['incorrectquestionnaire'] = 'Enquête is onjuist';
$string['indirectwarnings'] = 'Deze lijst toont de indirect afhankelijke vragen en de resterende afhankelijkheden voor direct afhankelijke vragen:';
$string['invalidresponse'] = 'Ongeldig antwoord gespecificeerd.';
$string['invalidresponserecord'] = 'Ongeldig antwoordrecord gespecificeerd.';
$string['invalidsectionid'] = 'Ongeldige feedbacksectie ingesteld.';
$string['invalidsurveyid'] = 'Ongeldige enquête ID';
$string['kindofratescale'] = 'Type beoordelingsschaal';
$string['kindofratescale_help'] = 'Rechtermuisklik op de link Meer Hulp hieronder.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Laatste respondent';
$string['length'] = 'Lengte';
$string['managequestions'] = 'Beheer de vragen';
$string['managequestions_help'] = 'In de sectie Beheer vragen van de pagina Bewerk vragen kun je een aantal handelingen uitvoeren op de vragen in de Enquête.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Verplicht - Al deze afhankelijkheden moeten worden voldaan.';
$string['maxdigitsallowed'] = 'Max. aantal tekens toegestaan';
$string['maxdigitsallowed_help'] = 'Gebruik **Max. aantal tekens toegestaan** om een limiet in te stellen op het aantal tekens dat kan worden ingevoerd bij een Numerieke vraag. Let op dat het decimaalpunt ook telt als een teken!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Max. geforceerde antwoorden';
$string['maxforcedresponses_help'] = 'Gebruik deze parameters om respondenten te dwingen een minimum van **Min.** en een maximum van **Max.** vakjes aan te vinken.
Stel **Min.** en **Max.** op dezelfde waarde in om een exact aantal vakjes aan te laten vinken. Als er alleen een min of max waarde gewenst is, laat dan de andere waarde op standaard **0**. Als je de **Min.** of **Max.** op een andere waarde instelt dan de standaard **0**, wordt er een waarschuwing getoond als de respondent niet voldoet aan de vereisten. Het is vanzelfsprekend dat je de vereisten duidelijk maakt aan de respondenten, ofwel in de algemene instructies van je Enquête ofwel in de tekst van relevante vragen.';
$string['maxtextlength'] = 'Max. lengte van tekst';
$string['maxtextlength_help'] = 'Voer voor het vraagtype Tekstvak waarden in voor de lengte van het invoervak en de maximale tekstlengte die respondenten kunnen invoeren.
Standaardwaarden zijn 20 tekens voor de breedte van het invoervak en 25 tekens voor de maximale lengte van in te voeren tekst.';
$string['messageprovider:message'] = 'Enquête herinnering';
$string['messageprovider:notification'] = 'Inzending enquête';
$string['minforcedresponses'] = 'Min. geforceerde antwoorden';
$string['minforcedresponses_help'] = 'Gebruik deze parameters om respondenten te dwingen een minimum van **Min.** en een maximum van **Max.** vakjes aan te vinken.
Stel **Min.** en **Max.** op dezelfde waarde in om een exact aantal vakjes aan te laten vinken. Als er alleen een min of max waarde gewenst is, laat dan de andere waarde op standaard **0**. Als je de **Min.** of **Max.** op een andere waarde instelt dan de standaard **0**, wordt er een waarschuwing getoond als de respondent niet voldoet aan de vereisten. Het is vanzelfsprekend dat je de vereisten duidelijk maakt aan de respondenten, ofwel in de algemene instructies van je Enquête ofwel in de tekst van relevante vragen.';
$string['misconfigured'] = 'Cursus is onjuist geconfigureerd';
$string['missingname'] = 'Vraag {$a} kan niet worden gebruikt in deze feedbacksectie omdat deze geen naam heeft.';
$string['missingnameandrequired'] = 'Vraag {$a} kan niet gebruikt worden in deze feedbacksectie omdat deze geen naam heeft en niet vereist is.';
$string['missingquestion'] = 'Beantwoord verplichte vraag';
$string['missingquestions'] = 'Beantwoord alle verplichte vragen:';
$string['missingrequired'] = 'Vraag {$a} kan niet gebruikt worden in deze feedbacksectie omdat deze niet vereist is.';
$string['modulename'] = 'Enquête';
$string['modulename_help'] = 'Met de enquête-module bouw je enquêtes met een breed scala aan vraagtypes, om gegevens van gebruikers te verzamelen.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Enquêtes';
$string['movedisabled'] = 'Dit item kan niet worden verplaatst';
$string['myresponses'] = 'Al uw antwoorden';
$string['myresponsetitle'] = 'Jouw {$a} antwoord(en)';
$string['myresults'] = 'Jouw resultaat';
$string['name'] = 'Naam';
$string['navigate'] = 'Vertakkende vragen toestaan';
$string['navigate_help'] = 'Ja/Nee en vragen met keuzerondjes instellen om onderliggende vragen te hebben afhankelijk van hun keuzes in je enquête.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Ga naar feedbacksectie';
$string['next'] = 'Volgende';
$string['nextpage'] = 'Volgende pagina';
$string['nlines'] = '{$a} regels';
$string['noanswer'] = 'Geen antwoord';
$string['noattempts'] = 'Er zijn nog geen pogingen voor deze enquête';
$string['nodata'] = 'Er zijn geen gegevens opgeslagen.';
$string['noduplicates'] = 'Geen duplicaat keuzes';
$string['noduplicateschoiceserror'] = 'Je moet ten minste 2 mogelijke antwoorden invoeren voor de "Geen duplicaat keuzes" optie!';
$string['non_respondents'] = 'Gebruikers die hun antwoorden nog niet hebben ingestuurd voor deze enquête';
$string['noneinuse'] = 'Deze enquête bevat nog geen vragen.';
$string['nopublicsurveys'] = 'Geen openbare enquêtes';
$string['noresponsedata'] = 'Geen antwoorden voor deze vraag.';
$string['noresponses'] = 'Geen antwoorden';
$string['normal'] = 'Normaal';
$string['not_started'] = 'niet begonnen';
$string['notanumber'] = '<strong>{$a}</strong> is geen geaccepteerd getalformat.';
$string['notapplicable'] = 'N.v.t.';
$string['notapplicablecolumn'] = 'N.v.t. kolom';
$string['notavail'] = 'Deze enquête is niet meer beschikbaar. Vraag je leraar hem te verwijderen.';
$string['noteligible'] = 'Je mag deze enquête niet invullen';
$string['notemplatesurveys'] = 'Geen sjabloonenquêtes';
$string['notenoughscaleitems'] = 'Je moet een minimumwaarde van 2 items op de schaal invoeren!';
$string['notificationfull'] = 'Volledige inzending';
$string['notifications'] = 'Stuur een melding bij inzending';
$string['notifications_help'] = 'Stuur een melding van inzending naar de rollen met het recht "mod/questionnair:submissionnotification"';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Alleen melding';
$string['notopen'] = 'Deze enquête start pas op {$a}.';
$string['notrequired'] = 'Antwoord is niet vereist';
$string['notset'] = 'niet ingesteld';
$string['nousersselected'] = 'Geen gebruikers geselecteerd';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} pogingen voor deze enquête';
$string['numberfloat'] = 'Het getal dat je hebt ingevoerd <strong>{$a->number}</strong> is opnieuw opgemaakt/afgerond met <strong>{$a->precision}</strong> decimalen.';
$string['numberofdecimaldigits'] = 'Aantal decimalen';
$string['numberofdecimaldigits_help'] = 'Gebruik **aantal decimalen** om het format te specificeren voor de berekende en getoonde gemiddelde waarde op de rapportage-pagina van de enquête.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Aantal schaalitems';
$string['numberscaleitems_help'] = 'Aantal items in schaal is het te gebruiken *aantal items* voor je beoordelingsschaal. Je zou normaal gesproken een waarde van 3 tot 5 gebruiken. Standaardwaarde is **5**.';
$string['numeric'] = 'Numeriek';
$string['numeric_help'] = 'Gebruik dit vraagtype wanneer je verwacht dat het antwoord een correct geformatteerd getal is.';
$string['of'] = 'van';
$string['openafterclose'] = 'Je hebt een sluitingsdatum voor de open datum opgegeven.';
$string['opendate'] = 'Antwoorden toestaan vanaf';
$string['option'] = 'optie  {$a}';
$string['optional'] = 'Optioneel - Ten minste één van deze afhankelijkheden moet worden voldaan.';
$string['optionalname'] = 'Vraagnaam';
$string['optionalname_help'] = 'De vraagnaam wordt alleen gebruikt wanneer je antwoorden exporteert naar CSV/Excel format. Als je nooit naar CSV exporteert, hoef je je geen zorgen te maken om vraagnamen. Als je regelmatig gegevens van enquêtes wilt exporteren naar CSV, kun je de vragen op twee manieren namen geven.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- OF -';
$string['order_ascending'] = 'Oplopende volgorde';
$string['order_default'] = 'Bekijk standaardvolgorde';
$string['order_descending'] = 'Aflopende volgorde';
$string['orderresponses'] = 'Rangschik antwoorden';
$string['orderresponses_help'] = 'Wanneer Alle Antwoorden worden getoond, kun je de keuzes rangschikken op het aantal antwoorden (de kolom Gemiddelde) voor de volgende 4 vraagtypes:

* Radio button één antwoord
* Rolmenu één antwoord
* Keuzevakje meerdere antwoorden
* Beoordeel (inclusief Likert-schalen)

Wanneer je op de pagina Alle Antwoorden komt, zijn alle antwoorden standaard gerangschikt in de volgorde die de maker van de enquête heeft ingesteld voor de vraagkeuzes.
Je kunt deze op- of aflopend rangschikken.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Overige:';
$string['otherempty'] = 'Als je deze keuze aanvinkt, moet je wat tekst in het tekstvak invoeren!';
$string['overviewnumresplog'] = 'antwoorden';
$string['overviewnumresplog1'] = 'antwoord';
$string['overviewnumrespvw'] = 'antwoorden';
$string['overviewnumrespvw1'] = 'antwoord';
$string['owner'] = 'Eigenaar';
$string['page'] = 'Pagina';
$string['pageof'] = 'Pagina {$a->page} van {$a->totpages}';
$string['parent'] = 'Bovenliggende';
$string['participant'] = 'Deelnemer';
$string['pleasecomplete'] = 'Gelieve deze keuze in te vullen.';
$string['pluginadministration'] = 'Enquêtebeheer';
$string['pluginname'] = 'Enquête';
$string['position'] = 'positie';
$string['possibleanswers'] = 'Mogelijke antwoorden';
$string['posteddata'] = 'Pagina bereikt met geplaatste gegevens:';
$string['preview_label'] = 'Voorvertoning';
$string['preview_questionnaire'] = 'Voorvertoning enquête';
$string['previewing'] = 'Enquête voorvertonen';
$string['previous'] = 'Vorige';
$string['previouspage'] = 'Vorige pagina';
$string['print'] = 'Dit antwoord afdrukken';
$string['printblank'] = 'Blanco afdrukken';
$string['printblanktooltip'] = 'Opent printervriendelijk venster met blanco Enquête';
$string['printtooltip'] = 'Opent printervriendelijk venster met huidig Antwoord';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Een antwoord op een meerkeuzevraag.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'Het ID van een keuzerecord voor deze inzending.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'Het ID van het vraagrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'Het ID van het inzendingsrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Een antwoord op een vraag met een keuze.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'Het ID van het keuzerecord voor deze inzending.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'Het ID van het vraagrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'Het ID van het inzendingsrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response'] = 'Een inzending met status bezig of ingezonden';
$string['privacy:metadata:questionnaire_response:complete'] = 'De voltooiingsstatus van de inzending.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Het cijfer voor deze inzending.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'Het ID van het enquêterecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Het tijdstempel waarop deze inzending het laatst werd bewaard.';
$string['privacy:metadata:questionnaire_response:userid'] = 'Het ID van de gebruiker voor dit antwoord.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Een antwoord op een boolean (ja/nee) vraag.';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Het specificieke boolean antwoord.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'Het ID van het vraagrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'Het ID van het inzendingsrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_date'] = 'Een antwoord op een datumvraag.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'Het ID van het vraagrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'De specifieke ingevulde datum.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'Het ID van het inzendingsrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_other'] = 'Een tekstantwoord voor de keuze \'Overige\'.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'Het ID van het keuzerecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'Het ID van het vraagrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'De specifieke antwoordtekst.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'Het ID van het inzendingsrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Een antwoord op een rangschikvraag.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'Het ID van het keuzerecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'Het ID van het vraagrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Het specifieke rangschikantwoord.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'Het ID van het inzendingsrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_text'] = 'Een antwoord op een tekstvraag.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'Het ID van het vraagrecord voor deze inzending.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Het specifieke tekstantwoord.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'Het ID van het inzendingsrecord voor deze inzending.';
$string['private'] = 'Privaat';
$string['progressbar'] = 'Toon voortgangsbalk';
$string['progressbar_info'] = 'Enquête {$a} voltooid.';
$string['progresshelp'] = 'Voortgangsbalk';
$string['progresshelp_help'] = 'Ga door naar de volgende pagina om de voortgangsbalk te vullen';
$string['public'] = 'Publiek';
$string['publiccopy'] = 'Kopie:';
$string['publicoriginal'] = 'Origineel:';
$string['qtype'] = 'Type';
$string['qtype_help'] = 'Selecteer of gebruikers één keer, dagelijks, wekelijks, maandelijks of een onbeperkt aantal (veel) keren mogen antwoorden.';
$string['qtypedaily'] = 'dagelijks beantwoorden';
$string['qtypemonthly'] = 'maandelijks beantwoorden';
$string['qtypeonce'] = 'antwoord één keer';
$string['qtypeunlimited'] = 'meerdere keren antwoorden';
$string['qtypeweekly'] = 'wekelijks beantwoorden';
$string['questionnaire:addinstance'] = 'Voeg een nieuwe enquête toe';
$string['questionnaire:copysurveys'] = 'Kopieer sjabloon- en private enquêtes';
$string['questionnaire:createpublic'] = 'Creëer openbare enquêtes';
$string['questionnaire:createtemplates'] = 'Creëer sjabloonenquêtes';
$string['questionnaire:deleteresponses'] = 'Verwijder ieder antwoord';
$string['questionnaire:downloadresponses'] = 'Download antwoorden in een CSV bestand';
$string['questionnaire:editquestions'] = 'Creëer en bewerk enquêtevragen';
$string['questionnaire:manage'] = 'Creëer en bewerk enquêtes';
$string['questionnaire:message'] = 'Een bericht naar non-respondenten sturen';
$string['questionnaire:preview'] = 'Enquêtes voorvertonen';
$string['questionnaire:printblank'] = 'Blanco enquête afdrukken';
$string['questionnaire:readallresponseanytime'] = 'Alle antwoorden altijd bekijken';
$string['questionnaire:readallresponses'] = 'Antwoordsamenvattingen lezen, afhankelijk van openstellingstijden';
$string['questionnaire:readownresponses'] = 'Eigen antwoorden lezen';
$string['questionnaire:submissionnotification'] = 'Ontvang een melding voor iedere inzending';
$string['questionnaire:submit'] = 'Een enquête voltooien en insturen';
$string['questionnaire:view'] = 'Een enquête bekijken';
$string['questionnaire:viewsingleresponse'] = 'Volledige individuele antwoorden bekijken';
$string['questionnaireadministration'] = 'Enquêtebeheer';
$string['questionnairecloses'] = 'Enquête sluit';
$string['questionnaireopens'] = 'Enquête wordt geopend';
$string['questionnairereport'] = 'Enquête rapportage';
$string['questionnum'] = 'Vraag #';
$string['questions'] = 'Vragen';
$string['questionsinsection'] = 'Vragen in deze sectie:';
$string['questiontypes'] = 'Vraagtypes';
$string['questiontypes_help'] = 'Zie de Moodle Documentatie hieronder';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Radio Buttons';
$string['radiobuttons_help'] = 'In dit vraagtype moet de respondent één van de geboden keuzes selecteren.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rangschik';
$string['ratescale'] = 'Beoordeel (schaal 1 - 5)';
$string['ratescale_help'] = 'Zie de Moodle Documentatie hieronder';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Enquête-type';
$string['realm_help'] = '** Er zijn drie soorten enquêtes: **
 * Privé - hoort alleen bij de cursus waarbinnen deze is gedefinieerd.
 * Sjabloon - kan worden gekopieerd en bewerkt.
 * Publiek - kan worden gedeeld tussen cursussen.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'De URL waarnaar een gebruiker wordt doorgeleid na het voltooien van deze enquête.';
$string['remove'] = 'Verwijder';
$string['removeallquestionnaireattempts'] = 'Verwijder alle antwoorden van deze enquête';
$string['removenotinuse'] = 'Deze enquête was afhankelijk van een Publieke enquête die verwijderd is. Daarom kan deze niet langer worden gebruikt en zou deze verwijderd moeten worden.';
$string['required'] = 'Antwoord is vereist';
$string['required_help'] = 'Als je ***Ja*** selecteert, wordt het antwoord op deze vraag vereist. Dat wil zeggen dat de respondent de enquête niet kan insturen wanneer deze vraag niet beantwoord is.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Er ontbreekt een vereiste parameter.';
$string['reset'] = 'Resetten';
$string['respeligiblerepl'] = '(vervangen door overschrijven rollen)';
$string['respondent'] = 'Respondent';
$string['respondenteligibleall'] = 'allen';
$string['respondenteligiblestudents'] = 'enkel leerlingen';
$string['respondenteligibleteachers'] = 'enkel leraren';
$string['respondents'] = 'Respondenten';
$string['respondenttype'] = 'Type respondent';
$string['respondenttype_help'] = 'Je kunt de volledige naam van je gebruikers tonen bij ieder antwoord door dit in te stellen op "volledige naam". Je kunt de identiteit van je gebruikers verbergen door dit in te stellen op "anoniem".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anoniem';
$string['respondenttypefullname'] = 'volledige naam';
$string['response'] = 'Antwoord';
$string['responsefieldlines'] = 'Afmetingen invoervak';
$string['responseformat'] = 'Antwoordformat';
$string['responseoptions'] = 'Antwoordopties';
$string['responses'] = 'Antwoorden';
$string['responseview'] = 'Leerling kan ALLE antwoorden zien';
$string['responseview_help'] = 'Je kunt specificeren wie de antwoorden van alle respondenten op ingediende enquêtes kunnen zien (algemene statistische tabellen).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Altijd';
$string['responseviewstudentsnever'] = 'Nooit';
$string['responseviewstudentswhenanswered'] = 'Na het beantwoorden van de enquête';
$string['responseviewstudentswhenclosed'] = 'Nadat de enquête gesloten is';
$string['restrictedtoteacher'] = 'Deze functies zijn alleen toegankelijk voor leraren met bewerkrechten!';
$string['resume'] = 'Bewaar antwoorden en ga verder';
$string['resume_help'] = 'Door deze optie in te schakelen kunnen gebruikers hun antwoorden bewaren voordat zij de enquête insturen.
Gebruikers kunnen de enquête onvoltooid laten en hervatten vanaf het bewaarde punt op een later moment.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Ga verder';
$string['return'] = 'Terug';
$string['save'] = 'Bewaar';
$string['save_and_exit'] = 'Opslaan en sluiten';
$string['saveasnew'] = 'Opslaan als nieuwe vraag';
$string['savedbutnotsubmitted'] = 'Deze enquête is opgeslagen maar nog niet ingestuurd.';
$string['savedprogress'] = 'Je voortgang is opgeslagen. Je kunt op ieder moment terugkeren om deze enquête te voltooien.';
$string['saveeditedquestion'] = 'Vraag {$a} opslaan';
$string['savesettings'] = 'Instellingen opslaan';
$string['search:activity'] = 'Enquête - informatie over activiteit';
$string['search:question'] = 'Enquête - vragen';
$string['section'] = 'Beschrijving';
$string['sectionbreak'] = '----- Pagina-einde -----';
$string['sectionbreak_help'] = '----- Pagina-einde -----';
$string['sectionsnotset'] = 'Je moet tenminste EEN vraag per sectie selecteren!<br />Niet geselecteerde sectie(s): {$a}';
$string['sectiontext'] = 'Label';
$string['sectiontext_help'] = 'Dit is geen vraag maar een korte tekst die wordt getoond om een reeks vragen in te leiden.';
$string['selecttheme'] = 'Selecteer een thema (css) om met deze enquête te gebruiken.';
$string['send'] = 'Verzenden';
$string['send_message'] = 'Bericht verzenden aan geselecteerde gebruikers';
$string['send_message_to'] = 'Bericht verzenden aan:';
$string['sendemail'] = 'E-mail verzenden';
$string['sendemail_help'] = 'Verstuurt een kopie van elke inzending naar een opgegeven mailadres of mailadressen. Je kunt meer dan één adres invoeren door deze met een komma te scheiden.
Laat het veld leeg voor géén e-mail back-up.
\'allowemailreporting\' moet aanstaan in de module instelling om deze functie te gebruiken.';
$string['set'] = 'ingesteld';
$string['settings'] = 'Instellingen';
$string['settingssaved'] = 'Instellingen opgeslagen';
$string['show_nonrespondents'] = 'Non-respondenten';
$string['started'] = 'Begonnen';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Voer de datum in met behulp van de datumkiezer hieronder.';
$string['subject'] = 'Onderwerp';
$string['submissionnotificationhtmlanon'] = 'Er is een nieuwe  <a href="{$a->submissionurl}">inzending</a> in de "{$a->name}" enquête.';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> heeft een nieuwe <a href="{$a->submissionurl}">inzending</a> in de "{$a->name}" enquête van cursus "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Nieuwe inzending enquête';
$string['submissionnotificationtextanon'] = 'Er is een nieuwe inzending ({$a->submissionurl}) in de "{$a->name}" enquête.';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) heeft een nieuwe inzending ({$a->submissionurl}) in de "{$a->name}" enquête van cursus "{$a->coursename}".';
$string['submitoptions'] = 'Instuuropties';
$string['submitpreview'] = 'Voorvertoning insturen';
$string['submitpreviewcorrect'] = 'Deze inzending zou geaccepteerd worden als correct ingevuld.';
$string['submitsurvey'] = 'Stuur enquête in';
$string['submitted'] = 'Ingestuurd op:';
$string['subtitle'] = 'Ondertitel';
$string['subtitle_help'] = 'Ondertitel van deze enquête. Verschijnt alleen onder de titel op de eerste pagina.';
$string['summary'] = 'Samenvatting';
$string['summaryreportattached'] = 'Enquête samenvattingsrapport is bijgevoegd';
$string['surveynotexists'] = 'enquête bestaat niet.';
$string['surveyowner'] = 'Je moet eigenaar van de enquête zijn om deze handeling uit te voeren.';
$string['surveyresponse'] = 'Antwoorden van de enquête';
$string['template'] = 'Sjabloon';
$string['templatenotviewable'] = 'Sjabloon-enquêtes zijn niet zichtbaar';
$string['text'] = 'Vraagtekst';
$string['textareacolumns'] = 'Kolommen tekstvak';
$string['textareacolumns_help'] = 'Deze vraag zal een blanco tekstvak tonen met **x** *tekstvak kolommen* (of *breedte* van het vak) en **y** *tekstvak rijen* (aantal *regels* tekst).

Als je de standaardwaarde **0** behoudt voor zowel x als y (of als je deze instelt op **0**), dan zal de HTML editor worden getoond met de standaard hoogte en breedte (indien beschikbaar in de context van de cursus/gebruiker &amp; gebruikersprofiel).';
$string['textarearows'] = 'Rijen tekstvak';
$string['textbox'] = 'Tekstvak';
$string['textbox_help'] = 'Voor het vraagtype Tekstvak, voer de lengte van het invoervak en de maximale lengte van de tekst in die respondent kan invoeren.
Standaardwaarden zijn 20 tekens voor de breedte van het invoervak en 25 tekens voor de maximale lengte van de ingevoerde tekst.';
$string['textdownloadoptions'] = 'Opties voor downloaden als CSV';
$string['thank_head'] = 'Dank je wel voor het invullen van deze enquête.';
$string['theme'] = 'Thema';
$string['thismonth'] = 'deze maand';
$string['thisresponse'] = 'Dit antwoord';
$string['thisweek'] = 'deze week';
$string['thousands'] = 'Gebruik geen scheidingsteken voor duizendtallen.';
$string['title'] = 'Titel';
$string['title_help'] = 'Titel van deze enquête, die boven iedere pagina zal verschijnen. Standaard is de titel ingesteld op de naam van de enquête, maar je kunt dit naar de eigen voorkeur aanpassen.';
$string['today'] = 'vandaag';
$string['total'] = 'Totaal';
$string['totalofnumbers'] = 'Totaal aantal opgegeven cijfers';
$string['totalresponses'] = 'Totaal aantal antwoorden op een vraag';
$string['type'] = 'Type';
$string['undefinedquestiontype'] = 'Niet gedefinieerd vraagtype!';
$string['unknown'] = 'Onbekend';
$string['unknownaction'] = 'Onbekende enquête actie gespecificeerd...';
$string['url'] = 'Bevestigings-URL';
$string['url_help'] = 'De URL waarnaar een gebruiker wordt doorverwezen na het voltooien van deze enquête.';
$string['useprivate'] = 'Kopieer bestaande';
$string['usepublic'] = 'Gebruik publieke';
$string['usetemplate'] = 'Gebruik sjabloon';
$string['vertical'] = 'Verticaal';
$string['view'] = 'Bekijk';
$string['viewallresponses'] = 'Bekijk alle antwoorden';
$string['viewallresponses_help'] = 'Als de enquête is ingesteld op **Groepsmodus**: *Zichtbare groepen*, of is ingesteld op *Gescheiden groepen* en de huidige gebruiker heeft het recht *moodle/site:accessallgroups* (in de huidige context), en er zijn groepen gedefinieerd binnen de huidige cursus, dan heeft de gebruiker toegang tot een dropdown lijst met groepen. Deze dropdown lijst zorgt ervoor dat de gebruiker de antwoorden op de enquête kan filteren op groepen.
Als de instelling **Groepsmodus**: *Gescheiden groepen* is, kunnen gebruikers zonder het recht *moodle/site:accessallgroups* (zoals leerlingen of leraren niet bewerken, etc.) alleen de antwoorden bekijken van de groep(en) waartoe zij behoren.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Lijst van antwoorden';
$string['viewindividualresponse'] = 'Individuele antwoorden';
$string['viewindividualresponse_help'] = 'Klik op de naam van de respondenten in onderstaande lijst om hun individuele antwoorden te bekijken.';
$string['viewresponses'] = 'Alle antwoorden ({$a})';
$string['viewyourresponses'] = 'Bekijk jouw antwoorde(n)';
$string['warning'] = 'Waarschuwing, er is een fout opgetreden.';
$string['wronganswers'] = 'Er is iets mis met je antwoorden (zie hieronder)';
$string['wrongdateformat'] = 'De ingevoerde datum: <strong>{$a}</strong> komt niet overeen met het format uit het voorbeeld.';
$string['wrongdaterange'] = 'FOUT! Het jaartal moet binnen het bereik 1902 tot 2037 vallen.';
$string['wrongformat'] = 'Er is iets mis met je antwoord op vraag: &nbsp;';
$string['wrongformats'] = 'Er is iets mis met je antwoorden op vragen: &nbsp;';
$string['yesno'] = 'Ja/Nee';
$string['yesno_help'] = 'Eenvoudige Ja/Nee vraag';
$string['yourresponse'] = 'Bekijk jouw antwoorde(n)';
$string['yourresponses'] = 'Bekijk jouw antwoorde(n)';
