<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_compilatio', language 'nl', version '3.9'.
 *
 * @package     plagiarism_compilatio
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['account_expire_soon_title'] = 'Je Compilatio.net-account zal snel vervallen';
$string['activate_compilatio'] = 'Compilatio inschakelen';
$string['activate_submissiondraft'] = 'Om leerlingen hun concepten te laten analyseren, moet je eerste de <b>{$a}</b>-optie inschakelen in de sectie';
$string['admin_account_expire_content'] = 'Jouw huidige inschrijving eindigt aan het eind van de huidige maand. Als je contract niet vervalt aan het einde van de maand, dan zal er automatisch een nieuw abonnement opgezet worden bij onze diensten. Wanneer dit gebeurd is, zal dit bericht verdwijnen. Voor meer informatie kan je altijd onze verkoop of technische diensten contacteren via support@compilatio.net';
$string['admin_disabled_reports'] = 'De beheerder staat niet toe dat leraren vergelijkingsrapporten tonen aan leerlingen.';
$string['admin_goto_helpcenter'] = 'Toegang tot het Compilatio help center om artikels te lezen over het beheer van de Moodle-plugin.';
$string['aiscore'] = 'AI-gegenereerde tekst';
$string['allow_analyses_auto'] = 'Mogelijkheid om de analyses onmiddellijk te starten';
$string['allow_analyses_auto_help'] = 'Met deze optie kunnen leraars automatisch de analyse van documenten starten bij een bepaalde activiteit (vb onmiddellijk na dat ze afgegeven zijn).<br />
Merk op dat in dit geval:
<ul>
  <li>Het aantal scans die jouw instituut uitvoert aanzienlijk hoger kan worden.</li>
  <li>De documenten van de eerste inzenders niet vergeleken worden met de documenten van wie laatst instuurt.</li>
</ul>
Om alle documenten van een opdracht met elkaar te vergelijken is het nodig om de analyse gepland uit te voeren door een moment te kiezen na de uiterste inleverdatum.';
$string['allow_search_tab'] = 'Tool om de auteur van een document te identificeren.';
$string['allow_search_tab_help'] = 'Deze tool maakt het mogelijk om de voornaam en achternaam van een leerling te vinden, gebaseerd om de ID die zichtbaar is in de analyserapporten van alle documenten die op je platform zitten.';
$string['allow_student_analyses'] = 'Mogelijkheid om leerlingen concepten te laten analyseren.';
$string['allow_student_analyses_help'] = 'Met deze opties kunnen leraren in een activiteit de mogelijkheid voorzien dat leerlingen hun concepten kunnen analyseren met Compilatio Magister, voor ze die insturen.';
$string['allow_teachers_to_show_reports'] = 'Mogelijkheid om vergelijkingsrapporten aan leerlingen te tonen';
$string['analysing'] = 'Document analyseren';
$string['analysis'] = 'Analyse start';
$string['analysis_auto'] = 'Analyse start';
$string['analysis_auto_help'] = '<p>Je hebt drie opties:
  <ul>
    <li><strong>Manueel:</strong> Analyse van documenten moet manueel gestart worden met de "Analyseer"-knop van elk document om met de "Analyseer alle documenten"-knop.</li>
    <li><strong>Gepland:</strong> Alle documenten worden geanalyseerd op het gekozen tijdstip.</li>
    <li><strong>Onmiddellijk:</strong> elk document wordt geanalyseerd wanneer de leerling het instuurt. De documenten in de activiteit worden dan niet met elkaar vergeleken.</li>
  </ul>
Om ale documenten met elkaar te vergelijken gedurende de analyse, moet je wachten tot ze allemaal ingestuurd zijn door de leerlingen en dan de analyse starten.</p>';
$string['analysis_completed'] = 'Analyse voltooid: {$a}% overeenkomsten';
$string['analysis_date'] = 'Analysedatum (enkel geplande analyses)';
$string['analysis_help'] = '<p>Je hebt twee opties:
  <ul>
    <li><strong>Manueel:</strong> Analyse van documenten moet manueel gestart worden met de "Analyseer"-knop van elk document of met de "Analyseer alle documenten"-knop.</li>
    <li><strong>Gepland:</strong> Alle documenten worden op het gekozen tijdstip geanalyseerd.</li>
  </ul>
Om ale documenten met elkaar te vergelijken gedurende de analyse, moet je wachten tot ze allemaal ingestuurd zijn door de leerlingen en dan de analyse starten.</p>';
$string['analysis_started'] = '{$a} analyses gevraagd.';
$string['analysistype_auto'] = 'Onmiddellijk';
$string['analysistype_manual'] = 'Manueel';
$string['analysistype_prog'] = 'Gepland';
$string['analyze'] = 'Analyseer';
$string['analyzing'] = 'Aan het analyseren';
$string['api_key_not_tested'] = 'Je API-sleutel is niet geverifieerd omdat de verbinding met Compilatio.net mislukt is.';
$string['api_key_not_valid'] = 'Je API-sleutel is niet geldig. Die is specifiek voor het gebruikte platform. Je kunt een sleutel bekomen door contact op te nemen met <a href=\'mailto:ent@compilatio.net\'>ent@compilatio.net</a>.';
$string['api_key_valid'] = 'Je API-sleutel is geldig';
$string['apiconfiguration'] = 'API-configuratie';
$string['assign_statistics'] = 'Statistieken over opdrachten';
$string['auto_diagnosis_title'] = 'Auto-diagnose';
$string['average'] = 'Gemiddelde verhouding';
$string['average_similarities'] = 'In deze activiteit is de gemiddelde verhouding overeenkomsten {$a}%.';
$string['badqualityanalysis'] = 'Er zjin problemen gevonden met de analyse van het document. Het is mogelijk dat sommige bronnen niet geïdentificeerd zijn of het resultaat kan onvolledig zijn.';
$string['compi_student_analyses'] = 'Leerlingen toestaan hun documenten te analyseren';
$string['compi_student_analyses_help'] = 'Hiermee kunnen leerlingen hun concepten analyseren met Compilatio Magister voor ze die definitief insturen.';
$string['compilatio'] = 'Compilatio plagiaatscanner';
$string['compilatio:enable'] = 'Leraren toestaan om Compilatio in te schakelen / uit te schakelen in een activiteit';
$string['compilatio:resetfile'] = 'Leraren toestaan een bestand opnieuw in te sturen naar Compilatio na een fout';
$string['compilatio:triggeranalysis'] = 'Toestaan dat leraren manueel een analyse starten';
$string['compilatio:viewreport'] = 'Toestaan dat leraren het volledig rapport van Compilatio zien';
$string['compilatio_author'] = 'Het document {$a->idcourt} in activiteit <b>{$a->modulename}</b> is van <b>{$a->firstname} {$a->lastname}</b>.';
$string['compilatio_display_student_report'] = 'Toon vergelijkingsrapport aan leerling';
$string['compilatio_display_student_report_help'] = 'Het vergelijkingsrapport toont gedetailleerd welke delen van de opdracht geplagieerd zijn en waar de gedetecteerde bronnen zijn.';
$string['compilatio_display_student_score'] = 'Toon vergelijkingsscore aan leerling';
$string['compilatio_display_student_score_help'] = 'De vergelijkingsscore is het percentage van de ingestuurde opdracht dat overeenkomt met andere inhoud.';
$string['compilatio_help_assign'] = 'Toon hulp over de Compilatio-plugin';
$string['compilatio_iddocument'] = 'Document-identificatie';
$string['compilatio_search'] = 'Zoek';
$string['compilatio_search_help'] = 'Je kunt de auteur van een document vinden via de document-identificatie van de bronnen in het analyserapport. Bijoorbeeld: 1. Your document: <b>1st5xfj2</b> - Assign_Name(30)Name_Copied_Document.odt.';
$string['compilatio_search_notfound'] = 'Er is geen document gevonden met deze docunent-identificatie op jouw Moodle-platform.';
$string['compilatio_search_tab'] = 'Zoek de auteur van een document.';
$string['compilatio_studentemail'] = 'Stuur leerling e-mail';
$string['compilatio_studentemail_help'] = 'Dit zal een e-mail sturen naar de leerling wanneer een bestand is verwerkt om te laten weten dat er een rapport beschikbaar is.';
$string['compilatioapi'] = 'Compilatio API adres';
$string['compilatioapi_help'] = 'Dit is het adres van de Compilatio API';
$string['compilatiodate'] = 'Activatiedatum';
$string['compilatiodate_help'] = 'Klik op "inschakelen" als je deze API-configuratie automatisch wil activeren op de gewenste datum. Laat leeg als je onmiddellijk wil activeren.';
$string['compilatiodefaults'] = 'Compilatio standaardinstellingen';
$string['compilatioenableplugin'] = 'Compilatio inschakelen voor {$a}';
$string['compilatioexplain'] = 'Kijk voor meer informatie over deze plugin op: <a href="http://www.compilatio.net/en/" target="_blank">compilatio.net</a>';
$string['compilatiopassword'] = 'API-sleutel';
$string['compilatiopassword_help'] = 'Persoonlijke code die Compilatio ter beschikking stelt voor toegang tot de API';
$string['context'] = 'Context';
$string['cron_check'] = 'Cron is op {$a} de laatste keer uitgevoerd.';
$string['cron_check_never_called'] = 'Cron is nooit uitgevoerd sinds de activatie van de plugin. Dit is waarschijnlijk fout geconfigureerd op je server.';
$string['cron_check_not_ok'] = 'Niet uitgevoerd in het laatste uur.';
$string['cron_frequency'] = 'Loopt blijkbaar elke {$a} minuten';
$string['cron_recommandation'] = '';
$string['defaults_desc'] = 'Volgende instellingen zijn de standaardinstellingen wanneer Compilatio ingeschakeld wordt in een activiteit.';
$string['defaultupdated'] = 'Standaardinstellingen aangepast';
$string['disable_ssl_verification'] = 'Negeer SSL-certificaatsverificatie.';
$string['disable_ssl_verification_help'] = 'Schakel deze optie in wanneer je problemen hebt met het verifiëren van SSL-certificaten of wanneer je fouten ondervindt bij het versturen van bestanden naar Compilatio.';
$string['disclaimer_data'] = 'Bij het inschakelen van Compilatio aanvaard je dat gegevens over je Moodle-confiiguratie zullen verzameld worden om de ondersteuning van deze service te verbeteren.';
$string['display_notifications'] = 'Toon meldingen';
$string['display_stats'] = 'Toont statistieken over deze activiteit';
$string['document_deleting'] = 'Verwijder documenten';
$string['documents_analyzed'] = '{$a->countAnalyzed} document(en) van {$a->documentsCount} zijn verstuurd en geanalyseerd.';
$string['documents_analyzed_between_thresholds'] = '{$a->documentsBetweenThresholds} document(en) tussen {$a->greenThreshold}% en {$a->redThreshold}%.';
$string['documents_analyzed_higher_red'] = '{$a->documentsAboveRedThreshold} document(en) meer dan {$a->redThreshold}%.';
$string['documents_analyzed_lower_green'] = '{$a->documentsUnderGreenThreshold} document(en) minder dan {$a->greenThreshold}%';
$string['documents_analyzing'] = '{$a} document(en) worden geanalyseerd.';
$string['documents_failed'] = '{$a} document(en) waarvan de analyse niet correct liep.';
$string['documents_in_queue'] = '{$a} document(en) in de wachtrij om geanalyseerd te worden.';
$string['documents_notfound'] = '{$a} document(en) niet gevonden.';
$string['documents_number'] = 'Geanalyseerde documenten';
$string['enable_activities_title'] = 'Schakel Compilatio in voor activiteiten';
$string['enable_javascript'] = 'Schakel Javascript in voor een betere ervaring met de Compilatio-plugin.</br />
Gebruik volgende instructies om <a href=\'http://www.enable-javascript.com/\' target=\'_blank\'>
 Javascript in te schakelen in je browser</a>.';
$string['enable_mod_assign'] = 'Compilatio inschakelen voor opdrachten';
$string['enable_mod_forum'] = 'Compilatio inschakelen voor forums';
$string['enable_mod_quiz'] = 'Compilatio inschakelen voor testen';
$string['enable_mod_workshop'] = 'Compilatio inschakelen voor workshop';
$string['enabledandworking'] = 'De Compilatio-plugin is ingeschakeld en werkt.';
$string['error'] = 'Fout';
$string['errors'] = 'Fouten:';
$string['export_csv'] = 'Exporteer gegevens over deze activiteit in een CSV-bestand';
$string['export_global_csv'] = 'Klik hier om deze gegevens in CSV-formaat te exporteren';
$string['export_raw_csv'] = 'Klik hier om ruwe gegevens in CSV-formaat te exporteren';
$string['extraction_in_progress'] = 'Document wordt uitgepakt - probeer later opnieuw.';
$string['failed'] = 'De analyse van dit document werkte niet correct.';
$string['failedanalysis'] = 'Compilatio kon jouw document niet analyseren:';
$string['failedanalysis_files'] = 'De analyse van volgende documenten werkte niet correct. Je kunt deze documenten resetten en hun analyse opnieuw starten:';
$string['filename'] = 'Bestandsnaam';
$string['filereset'] = 'Er is een bestand opnieuw ingestuurd naar Compilatio';
$string['firstname'] = 'Voornaam';
$string['formapikey'] = 'API-sleutel';
$string['formcheck'] = 'Controleer';
$string['formdelete'] = 'Verwijder';
$string['formenabled'] = 'Insgeschakeld';
$string['formstartdate'] = 'Activatiedatum';
$string['formurl'] = 'API-URL';
$string['get_scores'] = 'Haal de plagiaatscores op van Compilatio.net';
$string['global_statistics'] = 'Globale statistieken';
$string['global_statistics_description'] = 'Alle documentsgegevens die naar Compilatio zijn gestuurd.';
$string['goto_compilatio_service_status'] = 'Compilatio service status';
$string['goto_helpcenter'] = 'Klik op het vraagteken om een nieuw venster te openen en te verbinden met het Compilatio helpcentrum.';
$string['green_threshold'] = 'Groen tot';
$string['help_compilatio_format_content'] = 'Compilatio.net kan de meeste formaten gebruikt in tekstverwerkers en op het internet behandelen.
Volgende formaten worden ondersteund:';
$string['helpcenter'] = 'Toegang tot het Compilatio helpcentrum voor het gebruik van de Compilatioplugin in Moodle';
$string['helpcenter_error'] = 'We kunnen geen verbinding maken met het helpcentrum. Probeer later opnieuw of ga er rechtstreeks naartoe met volgende link:';
$string['hide_area'] = 'Verberg Compilatio informatie';
$string['immediately'] = 'Onmiddellijk';
$string['indexed_document'] = 'Document toegevoegd aan de databank met documenten van je instituut. De inhoud kan gebruikt worden om te vergelijken met andere documenten;';
$string['indexing_state'] = 'Voeg documenten toe aan de documentendatabank';
$string['indexing_state_help'] = 'Ja, voeg documenten toe aan de documentendatabank. Deze documenten zullen gebruikt worden als vergelijkingsmateriaal voor toekomstige analyse.
Nee, documenten worden niet toegevoegd aan de documentendatabank en zullen niet gebruikt worden voor vergelijkingen.';
$string['information_settings'] = 'Informatie';
$string['keep_docs_indexed'] = 'Bewaar documenten in de referentiebibliotheek';
$string['keep_docs_indexed_help'] = 'Bij het verwijderen van een cursus, het terug op standaardinstellingen zetten of het verwijderen van een activiteit, kun je er voor kiezen om de documenten die naar Compilatio verstuurd zijn, permanent te verwijderen of ze te behouden in de referentiebibliotheek. Enkel de tekst zal behouden blijven en worden gebruikt als vergelijkingsmateriaal in volgende analyses.';
$string['lastname'] = 'Achternaam';
$string['loading'] = 'Laden, wachten aub...';
$string['manual_analysis'] = 'De analyse van dit document moet manueel gestart worden.';
$string['manual_send_confirmation'] = '{$a} bestand(en) zijn ingestuurd naar Compilatio.';
$string['max_attempts_reach_files'] = 'De analyse is onderbroken voor volgende bestanden. Analyses waren te vaak verstuurd, je kunt ze niet meer herstarten:';
$string['max_file_size_allowed'] = 'Maximale documentgrootte: {$a->Mo} MB';
$string['maximum'] = 'Maximaal tarief';
$string['migration_apikey'] = 'Geeft de nieuwe v5 API-sleutel';
$string['migration_btn'] = 'Start de update van de in Moodle bewaarde gegevens';
$string['migration_completed'] = 'Update voltooid:';
$string['migration_failed_doc'] = 'document kon niet aangepast worden, je kunt het nog eens proberen aan het einde van de update';
$string['migration_form_title'] = 'Start de update van de in Moodle bewaarde gegevens om de migratie van v4 naar v5 te voltooien.';
$string['migration_info'] = 'Compilatio implementeert een nieuw v5 technisch platform voor al zijn klanten.<br>Wanneer het technisch team daarom verzoekt, zul je een actie moeten ondernemen om deze migratie te voltooien.';
$string['migration_inprogress'] = 'Update bezig. Dit kan verschillende uren duren. Je mag deze pagina verlaten tijdens de update.';
$string['migration_np'] = 'Je kunt de Compilatio-plugin blijven gebruiken, zelfs wanneer de migratie nog niet voltooid is.';
$string['migration_restart'] = 'Opnieuw';
$string['migration_success_doc'] = 'documenten zijn aangepast';
$string['migration_task'] = 'Update documenten van v4 naar v5';
$string['migration_title'] = 'Migratie van v4 naar v5';
$string['migration_toupdate_doc'] = 'aan te passen documenten';
$string['minimum'] = 'Minimaal tarief';
$string['news_analysis_perturbated'] = 'Compilatio.net - Analyse verstoord';
$string['news_incident'] = 'Compilatio.net incident';
$string['news_maintenance'] = 'Compilatio.net onderhoud';
$string['news_update'] = 'Compilatio.net update';
$string['no_document_available_for_analysis'] = 'Er zijn geen documenten voor analyse beschikbaar';
$string['no_documents_available'] = 'Er zijn geen documenten voor analyse beschikbaar in deze activiteit.';
$string['no_statistics_yet'] = 'Er zijn nog geen documenten geanalyseerd.';
$string['not_analyzed'] = 'Onderstaande documenten kunnen niet geanalyseerd worden:';
$string['not_analyzed_extracting'] = 'Onderstaande documenten kunnen nog niet geanalyseerd worden omdat ze uitgepakt worden. Probeer later opnieuw.';
$string['not_analyzed_toolong'] = '{$a} document(en) zijn niet geanalyseerd omdat ze teveel woorden bevatten.';
$string['not_analyzed_tooshort'] = '{$a} document(en) zijn niet geanalyseerd omdat ze niet genoeg woorden bevatten.';
$string['not_analyzed_unextractable'] = '{$a} document(en) zijn niet geanalyseerd omdat ze niet geladen konden worden op Compilatio.';
$string['not_analyzed_unsupported'] = '{$a} document(en) zijn niet geanalyseerd omdat hun formaat niet ondersteund wordt.';
$string['not_indexed_document'] = 'Dit document is niet toegevoegd aan de documentendatabank van je instituut. De inhoud ervan zal niet gebruikt worden om te vergelijken met andere documenten.';
$string['notfound'] = 'Dit document is niet gevonden. Neem contact op met je Moodlebeheerder. Fout: document niet gevonden voor deze API-sleutel.';
$string['numeric_threshold'] = 'Drempel moet een getal zijn.';
$string['orange_threshold'] = 'Oranje tot';
$string['owner_file'] = 'AIV en eigenaarschap van documenten';
$string['owner_file_school'] = 'De school is eigenaar van de documenten';
$string['owner_file_school_details'] = 'Wanneer een leerling vraagt om al zijn gegevens te verwijderen, dan zullen zijn documenten en rapporten bewaard worden en beschikbaar blijven voor toekomstige vergelijking met andere documenten. Aan het eind van het contract met Compilatio, zullen alle persoonlijke gegevens van jouw school, inclusief alle geanalyseerde documenten, verwijderd worden binnen de contractuele deadlines.';
$string['owner_file_student'] = 'De leerling is de enige eigenaar van dit document';
$string['owner_file_student_details'] = 'Wanneer een leerling vraagt om al zijn gegevens te verwijderen, dan zullen zijn documeten en rapporten verwijderd worden van Moodle en de Compilatio documentendatabase. Documenten zullen niet langer beschikbaar zijn voor vergelijking met andere documenten.';
$string['pending'] = 'Dit document is in de wachtrij om verstuurd te worden naar Compilatio';
$string['pending_status'] = 'In de wachtrij';
$string['planned'] = 'Gepland';
$string['plugin_disabled'] = 'De plugin is niet ingeschakeld in Moodle.';
$string['plugin_disabled_assign'] = 'De plugin is niet ingeschakeld voor opdrachten.';
$string['plugin_disabled_forum'] = 'De plugin is niet ingeschakeld voor forums.';
$string['plugin_disabled_quiz'] = 'De plugin is niet ingeschakeld voor testen.';
$string['plugin_disabled_workshop'] = 'De plugin is niet ingeschakeld voor workshops.';
$string['plugin_enabled'] = 'De plugin is ingeschakeld in Moodle.';
$string['plugin_enabled_assign'] = 'De plugin is ingeschakeld voor opdrachten.';
$string['plugin_enabled_forum'] = 'De plugin is ingeschakeld voor forums.';
$string['plugin_enabled_quiz'] = 'De plugin is ingeschakeld voor testen.';
$string['plugin_enabled_workshop'] = 'De plugin is ingeschakeld voor workshops.';
$string['pluginname'] = 'Compilatio plagiaatsplugin';
$string['previouslysubmitted'] = 'Voordien ingestuurd als';
$string['privacy:metadata:core_files'] = 'Bestanden als bijlage bij inzendingen of gemaakt als online tekst.';
$string['privacy:metadata:core_plagiarism'] = 'Deze plugin wordt door het Moodle plagiaat subsysteem gebruikt';
$string['privacy:metadata:external_compilatio_document'] = 'Informatie en inhoud over documenten in de Compilatio databank';
$string['privacy:metadata:external_compilatio_document:authors'] = 'Voornaam, achternaam en e-mail van de Moodlegebruiker (of leden van de groep) die het bestand ingestuurd hebben';
$string['privacy:metadata:external_compilatio_document:depositor'] = 'Voornaam, achternaam en e-mail van de Moodlegebruiker die het bestand instuurde';
$string['privacy:metadata:external_compilatio_document:filename'] = 'Bestandsnaam ingestuurd of gegenereerde naam voor online tekst';
$string['privacy:metadata:plagiarism_compilatio_files'] = 'Informatie over bestanden ingestuurd naar Compilatio';
$string['privacy:metadata:plagiarism_compilatio_files:filename'] = 'Bestandsnaam ingestuurd of gegenereerde naam voor online tekst';
$string['privacy:metadata:plagiarism_compilatio_files:userid'] = 'De MoodleID van de gebruiker die de inzending maakte';
$string['processing_doc'] = 'Compilatio analyseert dit bestand.';
$string['programmed_analysis_future'] = 'Documenten zullen door Compilatio geanalyseerd worden op {$a}.';
$string['programmed_analysis_past'] = 'Documenten zijn voor analyse naar Compilatio gestuurd op {$a}.';
$string['progress'] = 'Vooruitgang:';
$string['queue'] = 'Wachtrij';
$string['queued'] = 'Het document is nu in de wachtrij en zal snel geanalyseerd worden door Compilatio.';
$string['quiz_help'] = 'Enkel open vragen waarvan het antwoord minstens {$a} woorden bevat zullen geanalyseerd worden.';
$string['read_only_apikey_error'] = 'Jouw alleen lezen API-sleutel staat je niet toe om documenten te uploaden of te analyseren.';
$string['read_only_apikey_title'] = 'Enkel lezen API-sleutel';
$string['red_threshold'] = 'anders rood';
$string['redirect_report_failed'] = 'Er is een fout opgetreden bij het ophalen van het analyserapport. Probeer later opnieuw of neem contact op met de ondersteuning (support@compilatio.net) als dit probleem zich blijft voordoen.';
$string['report'] = 'Rapport';
$string['reset'] = 'Opnieuw instellen';
$string['reset_failed_document'] = 'Documenten met fout opnieuw instellen';
$string['reset_failed_document_in_progress'] = 'Documenten met fout in voortgang opnieuw instellen';
$string['reset_failed_document_title'] = 'Documenten met fout opnieuw instellen:';
$string['results'] = 'Resultaten:';
$string['saved_config_failed'] = '<strong>De ingegeven combinatie  API-sleutel - adres is niet geldig. Compilatio is uitgeschakeld. Probeer opnieuw.<br/>
								De <a href="autodiagnosis.php">automatische diagnosepagina</a> kan je helpen bij de configuratie van deze plugin.</strong><br/>
								Fout:';
$string['savedconfigsuccess'] = 'Plagiaatsinstellingen bewaard';
$string['send_files'] = 'Upload bestanden naar Compilatio.net voor plagiaatsdetectie';
$string['sending_failed'] = 'Bestandsupload naar Compilatio mislukt {$a}';
$string['showwhenclosed'] = 'Wanneer activiteit sluit';
$string['similarities'] = 'Overeenkomsten';
$string['similarities_disclaimer'] = 'Je kunt overeenkomsten in de documenten van deze activiteit analyseren met <a href=\'http://www.compilatio.net/en/\' target=\'_blank\'>Compilatio</a>.<br/> Opgelet: sommige gevonden overeenkomsten zijn niet noodzakelijk plagiaat. Het analyserapport helpt je met het identificeren van overeenkomsten en de beoordeling of iets in aanmerking komt voor quoteren of plagiaat is.';
$string['similarity_percent'] = '% overeenkomsten';
$string['simscore'] = 'Overeenkomsten';
$string['start_analysis_in_progress'] = 'De analyse is gestart';
$string['start_analysis_title'] = 'Start analyse';
$string['startallcompilatioanalysis'] = 'Analyseer alle documenten';
$string['startanalysis'] = 'Start analyse';
$string['statistics_title'] = 'Statistieken';
$string['stats_errors'] = 'Fouten';
$string['stats_failed'] = 'Analyse mislukt';
$string['stats_notfound'] = 'Bestand niet gevonden';
$string['stats_toolong'] = 'Bestand bevat teveel woorden';
$string['stats_tooshort'] = 'Bestand bevat niet genoeg woorden';
$string['stats_unextractable'] = 'Bestand kon niet geladen worden in Compilatio';
$string['stats_unsupported'] = 'Bestandsformaat niet ondersteund';
$string['student_analyze'] = 'Leerlinganalyse';
$string['student_help'] = 'Je kunt je concept analyseren met Compilatio Magister, zodat je overeenkomsten in je teksten kunt meten.<br />
De inhoud van je concept zal niet gebruikt worden door Compilatio als vergelijkingsmateriaal voor toekomstige analyses.<br />
Je leraar zal toegang hebben tot dit analyserapport.';
$string['student_start_analyze'] = 'De analyse kan gestart worden door de leerling';
$string['studentdisclosuredefault'] = 'Alle hier geüploade bestanden zullen op plagiaat gecontroleerd worden door Compilatio';
$string['studentemailcontent'] = 'Het bestand dat je instuurde voor {$a->modulename} in {$a->coursename} is nu verwerkt door de plagiaatscanner Compilatio.
{$a->modulelink}';
$string['studentemailsubject'] = 'Bestand verwerkt door Compilatio';
$string['students_disclosure'] = 'Zichtbaar voor leerlingen';
$string['students_disclosure_help'] = 'Deze tekst zal aan alle leerlingen op de uploadpagina voor bestanden getoond worden.';
$string['subscription_will_expire'] = 'Je Compilatio-abonnement eindigt aan het einde van';
$string['tabs_title_help'] = 'Help';
$string['tabs_title_notifications'] = 'Meldingen';
$string['tabs_title_stats'] = 'Statistieken';
$string['teacher'] = 'Leraar';
$string['teacher_features_title'] = 'Functies, ingeschakeld voor leraren';
$string['thresholds_description'] = 'Geef de drempel aan die je wil gebruiken om overeenkomsten te vinden met het analyserapport (% overeenkomsten):';
$string['thresholds_settings'] = 'Limieten:';
$string['timesubmitted'] = 'Ingestuurd naar Compilatio op';
$string['toolarge'] = 'Dit bestand is te groot om door Compilatio verwerkt te worden. Maximale grootte: {$a->Mo} MB';
$string['toolong'] = 'Dit document bevat teveel woorden om geanalyseerd te worden. Maximaal {$a} woorden.';
$string['toolong_files'] = 'Volgende bestand(en) kunnen niet geanalyseerd worden door Compilatio omdat ze teveel woorden bevatten (maximaal {$a} woorden):';
$string['tooltip_detailed_scores'] = '% verdachte tekst, inclusief';
$string['tooshort'] = 'Dit document bevat niet genoeg woorden om door Compilatio verwerkt te worden. Minimaal {$a} woorden';
$string['tooshort_files'] = 'Volgende bestand(en) kunnen niet geanalyseerd worden door Compilatio omdat ze te weinig woorden bevatten (minimaal {$a} woorden):';
$string['trigger_analyses'] = 'Start analyse';
$string['unextractable'] = 'Het document kon niet geladen worden in Compilatio';
$string['unextractable_files'] = 'Volgende bestand(en) kunnen niet geanalyseerd worden omdat ze niet in Compilatio geladen konden worden:';
$string['unextractablefile'] = 'Dit document kon niet geladen worden in Compilatio';
$string['unknownlang'] = 'Opgelet, de taal van sommige delen van dit document werd niet herkend.';
$string['unknownwarning'] = 'Er is een fout opgetreden bij het sturen van dit document naar Compilatio';
$string['unmeasured'] = 'niet gemeten';
$string['unsent_documents'] = 'Document(en) niet verstuurd';
$string['unsent_documents_content'] = 'Deze activiteit bevat document(en) die niet naar Compilatio zijn verstuurd.';
$string['unsupported'] = 'Document niet ondersteund';
$string['unsupported_files'] = 'Volgende bestand(en) kunnen niet geanalyseerd worden door Compilatio  omdat het formaat niet ondersteund wordt:';
$string['unsupportedfiletype'] = 'Dit bestandstype wordt niet ondersteund door Compilatio';
$string['update_in_progress'] = 'Informatie aanpassen';
$string['update_meta'] = 'Voer de geplande taken voor Compilatio uit';
$string['updatecompilatioresults'] = 'Ververs de informatie';
$string['updated_analysis'] = 'De Compilatio analyseresultaten zijn aangepast.';
$string['use_compilatio'] = 'Compilatio plagiaatscanner inschakelen';
$string['utlscore'] = 'Taal niet herkend';
$string['waitingforanalysis'] = 'Dit bestand zal verwerkt worden op {$a}';
$string['webservice_not_ok'] = 'De server kon niet verbinden met de webservice. Je firewall blokkeert misschien de verbinding.';
$string['webservice_ok'] = 'De server kan verbinden met de webservice.';
$string['webservice_unreachable_content'] = 'Compilatio.net is nu niet beschikbaar. Sorry voor het ongemak.';
$string['webservice_unreachable_title'] = 'Compilatio.net is niet beschikbaar.';
