<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'nl', version '3.9'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Je hebt aankomende bigbluebuttonbn-sessies';
$string['bbbduetimeoverstartingtime'] = 'De eindtijd voor deze activiteit moet later zijn dan de begintijd';
$string['bbbdurationwarning'] = 'De maximale lengte voor deze sessie is %duration% minuten.';
$string['bbbrecordallfromstartwarning'] = 'Deze sessie wordt vanaf het begin opgenomen.';
$string['bbbrecordwarning'] = 'Deze sessie kan opgenomen worden.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Voeg een nieuwe BigBlueButton ruimte / activiteit toe';
$string['bigbluebuttonbn:join'] = 'Neem deel aan een BigBlueButton bijeenkomst';
$string['bigbluebuttonbn:managerecordings'] = 'Beheer BigBlueButton opnames';
$string['bigbluebuttonbn:meeting'] = 'Creëer instanties met live bijeenkomstmogelijkheden';
$string['bigbluebuttonbn:recording'] = 'Maak instanties met opnamemogelijkheden';
$string['bigbluebuttonbn:view'] = 'Bekijk een ruimte / activiteit';
$string['calendarstarts'] = '{$a} is gepland voor';
$string['completionattendance'] = 'De leerling moet de bijeenkomst bijwonen voor:';
$string['completionattendancedesc'] = 'De leerling moet de bijeenkomst bijwonen en ten minste {$a} minuut / minuten in de sessie blijven';
$string['completionattendancegroup'] = 'Aanwezigheid vereist';
$string['completionattendancegroup_help'] = 'Het bijwonen van de bijeenkomst gedurende (n) minuten is vereist voor voltooiing';
$string['completionengagementchats'] = 'Chat-evenementen';
$string['completionengagementdesc'] = 'De leerling moet tijdens de bijeenkomst activiteiten ontplooien';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementgroup'] = 'Betrokkenheid vereisen';
$string['completionengagementgroup_help'] = 'Actieve deelname tijdens de sessie is vereist voor voltooiing';
$string['completionengagementpollvotes'] = 'Poll stemmen';
$string['completionengagementraisehand'] = 'Gebeurtenissen met de hand opsteken';
$string['completionengagementtalks'] = 'Praat evenementen';
$string['completionengagementtalktime'] = 'Gesprekstijd';
$string['completionupdatestate'] = 'Status voltooiing update';
$string['completionvalidatestate'] = 'Bevestig voltooiing';
$string['completionvalidatestatetriggered'] = 'Valideren dat de voltooiing is geactiveerd.';
$string['config_clienttype'] = 'Configuratie voor type "Webclient"';
$string['config_clienttype_default'] = 'Standaard type webclient';
$string['config_clienttype_default_description'] = 'Kies tussen de klassieke Adobe Flash-client of de nieuwe HTML5-client.';
$string['config_clienttype_description'] = 'Deze instelling schakelt de keuze van de webclient voor elke ruimte in / uit.';
$string['config_clienttype_editable'] = 'De keuze van de webclient kan worden bewerkt';
$string['config_clienttype_editable_description'] = 'Met deze optie kan de keuze van de webclient (AdobeFlash / HTML5) vanuit het ruimtebewerkingsformulier worden gekozen.';
$string['config_default_messages'] = 'Standaardberichten';
$string['config_default_messages_description'] = 'Stel standaardberichten in voor activiteiten';
$string['config_disablecam_default'] = 'Schakel standaard de camera uit';
$string['config_disablecam_default_description'] = 'Indien ingeschakeld, worden de webcams uitgeschakeld.';
$string['config_disablecam_editable'] = 'Camera uitschakelen kan worden gewijzigd';
$string['config_disablecam_editable_description'] = 'Camera standaard uitschakelen kan worden gewijzigd wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_disablemic_default'] = 'Schakel microfoon standaard uit';
$string['config_disablemic_default_description'] = 'Indien ingeschakeld, worden de microfoons uitgeschakeld.';
$string['config_disablemic_editable'] = 'Microfoon uitschakelen kan worden gewijzigd';
$string['config_disablemic_editable_description'] = 'Microfoon standaard uitschakelen kan worden gewijzigd wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_disablenote_default'] = 'Schakel gedeelde notities standaard uit';
$string['config_disablenote_default_description'] = 'Indien ingeschakeld, worden de gedeelde notities uitgeschakeld.';
$string['config_disablenote_editable'] = 'Gedeelde notities uitschakelen kunnen worden bewerkt';
$string['config_disablenote_editable_description'] = 'Gedeelde notities standaard uitschakelen kan worden bewerkt wanneer het exemplaar wordt toegevoegd of bijgewerkt.';
$string['config_disableprivatechat_default'] = 'Schakel privéchat standaard uit';
$string['config_disableprivatechat_default_description'] = 'Indien ingeschakeld, wordt de privéchat uitgeschakeld.';
$string['config_disableprivatechat_editable'] = 'Schakel privéchat uit kan worden bewerkt';
$string['config_disableprivatechat_editable_description'] = 'Standaard uitschakelen van privéchat kan worden bewerkt wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_disablepublicchat_default'] = 'Schakel openbare chat standaard uit';
$string['config_disablepublicchat_default_description'] = 'Indien ingeschakeld, wordt de openbare chat uitgeschakeld.';
$string['config_disablepublicchat_editable'] = 'Schakel openbare chat uit kan worden bewerkt';
$string['config_disablepublicchat_editable_description'] = 'Het standaard uitschakelen van openbare chat kan worden bewerkt wanneer het exemplaar wordt toegevoegd of bijgewerkt.';
$string['config_experimental_features'] = 'Configuratie voor experimentele functies';
$string['config_experimental_features_description'] = 'Configuratie voor experimentele functies.';
$string['config_extended_capabilities'] = 'Configuratie voor uitgebreide mogelijkheden';
$string['config_extended_capabilities_description'] = 'Configuratie voor uitgebreide mogelijkheden wanneer de BigBlueButton server deze aanbiedt.';
$string['config_general'] = 'Algemene configuratie';
$string['config_general_description'] = 'Deze instellingen worden <b>altijd</b> gebruikt';
$string['config_hideuserlist_default'] = 'Gebruikerslijst verbergen standaard ingeschakeld';
$string['config_hideuserlist_default_description'] = 'Indien ingeschakeld, wordt de gebruikerslijst van de sessie verborgen.';
$string['config_hideuserlist_editable'] = 'De gebruikerslijst verbergen kan worden bewerkt';
$string['config_hideuserlist_editable_description'] = 'De standaard gebruikerslijst verbergen kan worden bewerkt wanneer het exemplaar wordt toegevoegd of bijgewerkt.';
$string['config_importrecordings'] = 'Configuratie voor de functie "Opnames importeren"';
$string['config_importrecordings_description'] = 'Deze instellingen zijn kenmerkspecifiek';
$string['config_importrecordings_enabled'] = 'Opnamen importeren ingeschakeld';
$string['config_importrecordings_enabled_description'] = 'Wanneer dit en de opnamefunctie zijn ingeschakeld, is het mogelijk om opnames van verschillende cursussen in een activiteit te importeren.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importeer opnames van verwijderde activiteiten ingeschakeld';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Wanneer dit en de functie voor het importeren van opnames zijn ingeschakeld, is het mogelijk om opnames te importeren van activiteiten die niet langer in de cursus zijn.';
$string['config_lockonjoin_default'] = 'Negeer vergrendeling bij deelname is standaard ingeschakeld';
$string['config_lockonjoin_default_description'] = 'Indien ingeschakeld, worden de vergrendelingsinstellingen genegeerd. De vergrendelingsconfiguratie moet zijn ingeschakeld om dit te kunnen toepassen.';
$string['config_lockonjoin_editable'] = 'Negeer vergrendeling bij deelname kan worden aangepast';
$string['config_lockonjoin_editable_description'] = 'De negeer vergrendeling bij deelname kan standaard worden aangepast wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_locksettings'] = 'Configuratie voor vergrendelingsinstellingen';
$string['config_locksettings_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface voor vergrendelingsinstellingen in of uit, en definiëren ook standaardwaarden voor deze opties.';
$string['config_meetingevents_enabled'] = 'Bijeenkomsten registreren';
$string['config_meetingevents_enabled_description'] = 'De functie voor het registreren van bijeenkomsten is ingeschakeld.';
$string['config_muteonstart'] = 'Configuratie voor "Mute on Start" -functie';
$string['config_muteonstart_default'] = 'Standaard microfoon stil bij aanvang';
$string['config_muteonstart_default_description'] = 'Indien ingeschakeld, wordt de microfoon stil gezet bij de aanvang van een sessie.';
$string['config_muteonstart_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface in of uit en definiëren ook standaardwaarden voor deze opties.';
$string['config_muteonstart_editable'] = 'Microfoon stil bij aanvang kanaangepast worden';
$string['config_muteonstart_editable_description'] = 'Microfoon stil bij aanvang kan standaard aangepast worden wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_participant'] = 'Configuratie van deelnemers';
$string['config_participant_description'] = 'Deze instellingen definiëren standaard de rol voor deelnemers aan een conferentie.';
$string['config_participant_moderator_default'] = 'Moderator standaard';
$string['config_participant_moderator_default_description'] = 'Deze regel wordt standaard gebruikt wanneer een nieuwe ruimte wordt toegevoegd.';
$string['config_presentation_default'] = 'Standaardbestand voor de functie "Presentatie vooraf uploaden"';
$string['config_presentation_default_description'] = 'Deze instelling maakt het mogelijk om een bestand te selecteren dat als standaard moet worden gebruikt in alle BBB-instanties als "Pre-upload presentatie" is ingeschakeld.';
$string['config_preuploadpresentation'] = 'Configuratie voor "Pre-upload presentatie" -functie';
$string['config_preuploadpresentation_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface in of uit en definiëren ook standaardwaarden voor deze opties. De functie werkt alleen als de Moodle-server toegankelijk is voor BigBlueButton ..';
$string['config_preuploadpresentation_editable'] = 'Bewerkbaar vooraf uploaden van presentatie';
$string['config_preuploadpresentation_editable_description'] = 'Het vooraf uploaden van de presentatie is bewerkbaar in de gebruikersinterface wanneer de kamer wordt toegevoegd of aangepast.';
$string['config_recording'] = 'Configuratie voor "Bijeenkomst opname" -functie';
$string['config_recording_all_from_start_default'] = 'Neem alles vanaf het begin op';
$string['config_recording_all_from_start_default_description'] = 'Indien aangevinkt zal de bijeenkomst vanaf het bezig worden opgenomen';
$string['config_recording_all_from_start_editable'] = 'Alles opnemen vanaf het begin kan worden bewerkt';
$string['config_recording_all_from_start_editable_description'] = 'Indien aangevinkt, bevat de interface een optie voor het in- en uitschakelen van de opname vanaf de startfunctie.';
$string['config_recording_default'] = 'Opnamefunctie standaard ingeschakeld';
$string['config_recording_default_description'] = 'Indien ingeschakeld, hebben de sessies die in BigBlueButton zijn gemaakt opnamemogelijkheden.';
$string['config_recording_description'] = 'Deze instellingen zijn kenmerkspecifiek';
$string['config_recording_editable'] = 'Opnamefunctie kan worden bewerkt';
$string['config_recording_editable_description'] = 'Indien aangevinkt, bevat de interface een optie voor het in- en uitschakelen van de opnamefunctie.';
$string['config_recording_hide_button_default'] = 'Opnameknop verbergen';
$string['config_recording_hide_button_default_description'] = 'Indien aangevinkt zal de knop voor record verborgen zijn';
$string['config_recording_hide_button_editable'] = 'Verberg opnameknop kan worden bewerkt';
$string['config_recording_hide_button_editable_description'] = 'Indien aangevinkt bevat de interface een optie voor het in- en uitschakelen van de functie voor het verbergen van de opnameknop.';
$string['config_recordingready_enabled'] = 'Meldingen bij opname gereed ingeschakeld';
$string['config_recordingready_enabled_description'] = 'Meldingen wanneer opname gereed-functie is ingeschakeld.';
$string['config_recordings'] = 'Configuratie voor "Toon opnames" functie';
$string['config_recordings_deleted_default'] = 'Neem opnamen op van verwijderde activiteiten die standaard zijn ingeschakeld';
$string['config_recordings_deleted_default_description'] = 'Indien ingeschakeld, bevat de opnametabel de opnames die behoren tot verwijderde activiteiten als die er zijn.';
$string['config_recordings_deleted_editable'] = 'Opnames van de verwijderde activiteitenfunctie opnemen kunnen worden bewerkt';
$string['config_recordings_deleted_editable_description'] = 'Opnamen van verwijderde activiteiten opnemen, kan standaard worden bewerkt wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_recordings_description'] = 'Deze instellingen zijn kenmerkspecifiek';
$string['config_recordings_general'] = 'Opname-instellingen weergeven';
$string['config_recordings_general_description'] = 'Deze instellingen worden alleen gebruikt bij het weergeven van opnames';
$string['config_recordings_html_default'] = 'UI als html is standaard ingeschakeld';
$string['config_recordings_html_default_description'] = 'Indien ingeschakeld, wordt de opnametabel standaard weergegeven in gewone HTML.';
$string['config_recordings_html_editable'] = 'UI als html-functie kan worden bewerkt';
$string['config_recordings_html_editable_description'] = 'UI als html-waarde kan standaard worden bewerkt wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_recordings_imported_default'] = 'Toon alleen geïmporteerde links die standaard zijn ingeschakeld';
$string['config_recordings_imported_default_description'] = 'Indien ingeschakeld, bevat de opnametabel alleen de geïmporteerde links naar opnames.';
$string['config_recordings_imported_editable'] = 'Alleen de functie voor geïmporteerde links weergeven kan worden bewerkt';
$string['config_recordings_imported_editable_description'] = 'Alleen standaard geïmporteerde links weergeven kan worden bewerkt wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_recordings_preview_default'] = 'Voorbeeldweergave is standaard ingeschakeld';
$string['config_recordings_preview_default_description'] = 'Indien ingeschakeld, bevat de tabel een voorbeeldweergave van de presentatie.';
$string['config_recordings_preview_editable'] = 'Voorbeeldweergave kan aangepast worden';
$string['config_recordings_preview_editable_description'] = 'De voorbeeldweergave kan aangepast worden wanneer de instantie wordt toegevoegd of bijgewerkt.';
$string['config_recordings_sortorder'] = 'Sorteer de opnames in oplopende volgorde.';
$string['config_recordings_sortorder_description'] = 'Opnames worden standaard weergegeven in aflopende volgorde. Indien aangevinkt worden ze gesorteerd in oplopende volgorde.';
$string['config_recordings_validate_url'] = 'Valideer URL';
$string['config_recordings_validate_url_description'] = 'Indien aangevinkt, wordt de afspeel-URL gevalideerd voordat de gebruiker er toegang toe heeft.';
$string['config_scheduled'] = 'Configuratie van "Geplande sessies"';
$string['config_scheduled_description'] = 'Deze instellingen definiëren delen van het standaardgedrag voor geplande sessies.';
$string['config_scheduled_duration_compensation'] = 'Compenserende tijd (minuten)';
$string['config_scheduled_duration_compensation_description'] = 'Aantal minuten toegevoegd aan de geplande eindtijd wanneer de duur wordt berekend.';
$string['config_scheduled_duration_enabled'] = 'Duur berekenen ingesteld';
$string['config_scheduled_duration_enabled_description'] = 'De duur van een geplande sessie wordt berekend op basis van de openings- en sluitingstijden.';
$string['config_scheduled_pre_opening'] = 'Toegankelijk voor openingstijd (minuten)';
$string['config_scheduled_pre_opening_description'] = 'De tijd in minuten dat de sessie toegankelijk is voor de geplande openingstijd.';
$string['config_sendnotifications'] = 'Configuratie voor de functie "Meldingen verzenden"';
$string['config_sendnotifications_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface in of uit en definiëren ook standaardwaarden voor deze opties.';
$string['config_sendnotifications_enabled'] = 'Meldingen verzenden ingeschakeld';
$string['config_sendnotifications_enabled_description'] = 'De functie voor het verzenden van meldingen is ingeschakeld in de gebruikersinterface wanneer de ruimte of conferentie wordt toegevoegd of bijgewerkt.';
$string['config_server_url'] = 'BigBlueButton Server URL';
$string['config_server_url_description'] = 'De URL van je BigBlueButton server moet eindigen op /bigbluebutton/. (Deze standaard URL is voor een BigBlueButton server geleverd door Blindside Networks die je kunt gebruiken om te testen.)';
$string['config_shared_secret'] = 'BigBlueButton Shared Secret';
$string['config_shared_secret_description'] = 'De beveiligings-salt van je BigBlueButton server (Deze standaard salt is voor een BigBlueButton server geleverd door Blindside Networks die je kunt gebruiken om te testen.)';
$string['config_uidelegation_enabled'] = 'UI-delegatie is ingeschakeld';
$string['config_uidelegation_enabled_description'] = 'Deze instellingen schakelen de delegatie van de gebruikersinterface naar de BigBlueButton-server in of uit.';
$string['config_userlimit'] = 'Configuratie voor de functie "Gebruikerslimiet"';
$string['config_userlimit_default'] = 'Gebruikerslimiet standaard ingeschakeld';
$string['config_userlimit_default_description'] = 'Het aantal gebruikers dat standaard is toegestaan in een sessie wanneer een nieuwe ruimte of conferentie wordt toegevoegd. Als het nummer is ingesteld op 0, wordt er geen limiet vastgesteld';
$string['config_userlimit_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface in of uit en definiëren ook standaardwaarden voor deze opties.';
$string['config_userlimit_editable'] = 'Gebruikerslimietfunctie kan worden bewerkt';
$string['config_userlimit_editable_description'] = 'De gebruikerslimietwaarde kan standaard worden bewerkt wanneer de ruimte of conferentie wordt toegevoegd of bijgewerkt.';
$string['config_voicebridge'] = 'Configuratie voor "Voice bridge" -functie';
$string['config_voicebridge_description'] = 'Deze instellingen schakelen opties in de gebruikersinterface in of uit en definiëren ook standaardwaarden voor deze opties.';
$string['config_voicebridge_editable'] = 'Conference voice bridge kan worden bewerkt';
$string['config_voicebridge_editable_description'] = 'Het nummer van de conferentiestembrug kan permanent worden toegewezen aan een conferentieruimte. Indien toegewezen, kan het nummer niet worden gebruikt door een andere ruimte of conferentie';
$string['config_waitformoderator'] = 'Configuratie voor "Wacht op moderator" -functie';
$string['config_waitformoderator_cache_ttl'] = 'Wacht op moderator cache TTL (seconden)';
$string['config_waitformoderator_cache_ttl_description'] = 'Om een grote hoeveelheid gebruikers te ondersteunen, maakt deze plug-in gebruik van een cache. Deze parameter definieert de tijd dat de cache wordt bewaard voordat het volgende verzoek naar de BigBlueButton-server wordt verzonden.';
$string['config_waitformoderator_default'] = 'Wacht tot moderator standaard is ingeschakeld';
$string['config_waitformoderator_default_description'] = 'Wachten op moderatorfunctie is standaard ingeschakeld wanneer een nieuwe ruimte of conferentie wordt toegevoegd.';
$string['config_waitformoderator_description'] = 'Deze instellingen zijn kenmerkspecifiek';
$string['config_waitformoderator_editable'] = 'Wacht tot de moderatorfunctie kan worden bewerkt';
$string['config_waitformoderator_editable_description'] = 'Wacht tot de moderatorwaarde standaard kan worden bewerkt wanneer de ruimte of conferentie wordt toegevoegd of bijgewerkt.';
$string['config_waitformoderator_ping_interval'] = 'Wacht op moderator-ping (seconden)';
$string['config_waitformoderator_ping_interval_description'] = 'Als het wachten op moderatorfunctie is ingeschakeld, pingt de client elke [aantal] seconden voor de status van de sessie. Deze parameter definieert het interval voor verzoeken aan de Moodle-server';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButtonBN maakt gebruik van config.php met een globale variabele die is afgeschaft. Converteer het bestand alstublieft omdat het niet zal worden ondersteund in toekomstige versies';
$string['config_warning_curl_not_installed'] = 'Deze functie vereist dat de CURL extensie voor php is geïnstalleerd en ingeschakeld. Deze instellingen zullen alleen toegankelijk zijn als is voldaan aan deze voorwaarde.';
$string['config_welcome_default'] = 'Standaard welkomstbericht';
$string['config_welcome_default_description'] = 'Vervangt het standaardbericht dat is ingesteld voor de BigBlueButton-server. Het bericht kan trefwoorden bevatten  (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%)  die automatisch worden vervangen, en ook html-tags zoals <b>...</b> or <i></i>';
$string['config_welcome_editable'] = 'Standaard welkomstbericht is bewerkbaar door leraren';
$string['config_welcome_editable_description'] = 'Welkomstbericht kan bewerkt worden wanneer de kamer wordt toegevoegd of aaangepast';
$string['email_body_notification_meeting_by'] = 'door';
$string['email_body_notification_meeting_description'] = 'Beschrijving';
$string['email_body_notification_meeting_details'] = 'Details';
$string['email_body_notification_meeting_end_date'] = 'Einddatum';
$string['email_body_notification_meeting_has_been'] = 'was';
$string['email_body_notification_meeting_start_date'] = 'Startdatum';
$string['email_body_notification_meeting_title'] = 'Titel';
$string['email_body_recording_ready_for'] = 'Opname voor';
$string['email_body_recording_ready_is_ready'] = 'is gereed';
$string['email_footer_sent_by'] = 'Deze automatische melding is verstuurd door';
$string['email_footer_sent_from'] = 'vanuit de cursus';
$string['ends_at'] = 'Eindigt';
$string['event_activity_created'] = 'Activiteit gemaakt';
$string['event_activity_deleted'] = 'Activiteit verwijderd';
$string['event_activity_updated'] = 'Activiteit bijgewerkt';
$string['event_activity_viewed'] = 'Activiteit bekeken';
$string['event_live_session'] = 'Live sessie-evenement';
$string['event_meeting_created'] = 'BigBlueButtonBN bijeenkomst aangemaakt';
$string['event_meeting_ended'] = 'BigBlueButton bijeenkomst gedwongen beëindigd';
$string['event_meeting_joined'] = 'bBigBlueButtonBN bijeenkomst bijgewoond';
$string['event_meeting_left'] = 'BigBlueButtonBN bijeenkomst verlaten';
$string['event_recording_deleted'] = 'Opname verwijderd';
$string['event_recording_edited'] = 'Opname bewerkt';
$string['event_recording_imported'] = 'Opname geïmporteerd';
$string['event_recording_protected'] = 'Opname beveiligd';
$string['event_recording_published'] = 'Opname gepubliceerd';
$string['event_recording_unprotected'] = 'Onbeschermd opnemen';
$string['event_recording_unpublished'] = 'Publicatie van opname ongedaan gemaakt';
$string['event_recording_viewed'] = 'Opname bekeken';
$string['general_error_not_allowed_to_create_instances'] = 'Het is de gebruiker niet toegestaan om een type instantie te maken.';
$string['general_error_unable_connect'] = 'Kon geen verbinding maken. Controleer de url van de BigBlueButton server EN  controleer of de BigBlueButton server aan staat.';
$string['index_confirm_end'] = 'Wil je de virtuele les beëindigen?';
$string['index_disabled'] = 'uitgeschakeld';
$string['index_enabled'] = 'ingeschakeld';
$string['index_ending'] = 'Het virtuele klaslokaal beëindigen ... wachten';
$string['index_error_bbtn'] = 'BigBlueButton-ID {$a} is onjuist';
$string['index_error_checksum'] = 'Er is een checksum-fout opgetreden. Controleer of je de correcte salt hebt ingevoerd.';
$string['index_error_forciblyended'] = 'Kon niet deelnemen aan deze bijeenkomst omdat deze handmatig is beëindigd.';
$string['index_error_noinstances'] = 'Er zijn geen gevallen van bigbluebuttonbn';
$string['index_error_unable_display'] = 'Kon geen bijeenkomst tonen. Controleer de url van de BigBlueButton server EN  controleer of de BigBlueButton server aan staat.';
$string['index_heading'] = 'BigBlueButton Ruimtes';
$string['index_heading_actions'] = 'Acties';
$string['index_heading_group'] = 'Groep';
$string['index_heading_moderator'] = 'Moderators';
$string['index_heading_name'] = 'Ruimte';
$string['index_heading_recording'] = 'Opname';
$string['index_heading_users'] = 'Gebruikers';
$string['index_heading_viewer'] = 'Kijkers';
$string['indicator:cognitivedepth'] = 'BigBlueButtonBN cognitief';
$string['indicator:cognitivedepth_help'] = 'Deze indicator is gebaseerd op de cognitieve diepte die de student bereikt bij een BigBlueButtonBN-activiteit.';
$string['indicator:socialbreadth'] = 'BigBlueButtonBN sociaal';
$string['indicator:socialbreadth_help'] = 'Deze indicator is gebaseerd op de sociale breedte die de student bereikt bij een BigBlueButtonBN-activiteit.';
$string['instance_type_default'] = 'Ruimte / activiteit met opnames';
$string['instance_type_recording_only'] = 'Alleen opnames';
$string['instance_type_room_only'] = 'Alleen ruimte / activiteit';
$string['minute'] = 'minuut';
$string['minutes'] = 'minuten';
$string['mod_form_block_clienttype'] = 'Webclienttechnologie';
$string['mod_form_block_clienttype_flash'] = 'Client gebaseerd op Adobe Flash-technologie';
$string['mod_form_block_clienttype_html5'] = 'Client gebaseerd op HTML5-technologie';
$string['mod_form_block_general'] = 'Algemene instellingen';
$string['mod_form_block_participants'] = 'Toegewezen rol gedurende live sessie';
$string['mod_form_block_presentation'] = 'Inhoud van presentatie';
$string['mod_form_block_presentation_default'] = 'Standaard inhoud van presentatie';
$string['mod_form_block_record'] = 'Opname-instellingen';
$string['mod_form_block_recordings'] = 'Opname-instellingen';
$string['mod_form_block_room'] = 'Activiteit- / ruimte-instellingen';
$string['mod_form_block_schedule'] = 'Planning voor sessie';
$string['mod_form_field_block_clienttype'] = 'Webclienttechnologie';
$string['mod_form_field_closingtime'] = 'Deelnemen gesloten';
$string['mod_form_field_conference_name'] = 'Naam van conferentie';
$string['mod_form_field_disablecam'] = 'Schakel webcams uit';
$string['mod_form_field_disablemic'] = 'Schakel microfoons uit';
$string['mod_form_field_disablenote'] = 'Schakel gedeelde notities uit';
$string['mod_form_field_disableprivatechat'] = 'Schakel privéchat uit';
$string['mod_form_field_disablepublicchat'] = 'Schakel openbare chat uit';
$string['mod_form_field_duration'] = 'Duur';
$string['mod_form_field_duration_help'] = 'Het instellen van de duur van een bijeenkomst stelt de maximale tijd vast dat een bijeenkomst open blijft alvorens de opname stopt';
$string['mod_form_field_hideuserlist'] = 'Gebruikerslijst verbergen';
$string['mod_form_field_instanceprofiles'] = 'Instantietype';
$string['mod_form_field_instanceprofiles_help'] = 'Selecteer het type voor deze BigBlueButtonBN-instantie.';
$string['mod_form_field_intro'] = 'Beschrijving';
$string['mod_form_field_intro_help'] = 'Een korte beschrijving voor de ruimte of conferentie.';
$string['mod_form_field_lockonjoin'] = 'Negeer de vergrendelingsinstellingen';
$string['mod_form_field_muteonstart'] = 'Microfoon stil bij aanvang';
$string['mod_form_field_name'] = 'Naam virtueel klaslokaal';
$string['mod_form_field_nosettings'] = 'Er kunnen geen instellingen worden bewerkt';
$string['mod_form_field_notification'] = 'Stuur melding over deze wijziging naar aangemelde gebruikers';
$string['mod_form_field_notification_created_help'] = 'Stuur een melding naar aangemelde gebruikers om te meldendat deze activiteit is gecreëerd';
$string['mod_form_field_notification_help'] = 'Stuur een melding naar aangemelde gebruikers om te melden dat deze activiteit is gecreëerd of aangepast';
$string['mod_form_field_notification_modified_help'] = 'Stuur een melding naar aangemelde gebruikers om te melden dat deze activiteit is aangepast';
$string['mod_form_field_notification_msg_at'] = 'op';
$string['mod_form_field_notification_msg_created'] = 'toegevoegd';
$string['mod_form_field_notification_msg_modified'] = 'aangepast';
$string['mod_form_field_openingtime'] = 'Deelnemen geopend';
$string['mod_form_field_participant_add'] = 'Deelnemer toevoegen';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Toeschouwer';
$string['mod_form_field_participant_list'] = 'Deelnemerslijst';
$string['mod_form_field_participant_list_action_add'] = 'Toevoegen';
$string['mod_form_field_participant_list_action_remove'] = 'Verwijderen';
$string['mod_form_field_participant_list_text_as'] = 'Sessie volgen als';
$string['mod_form_field_participant_list_type_all'] = 'Alle aangemelde gebruikers';
$string['mod_form_field_participant_list_type_owner'] = 'Eigenaar';
$string['mod_form_field_participant_list_type_role'] = 'Rol';
$string['mod_form_field_participant_list_type_user'] = 'Gebruiker';
$string['mod_form_field_record'] = 'Sessie kan worden opgenomen';
$string['mod_form_field_recordallfromstart'] = 'Neem alles vanaf het begin op';
$string['mod_form_field_recordhidebutton'] = 'Opnameknop verbergen';
$string['mod_form_field_recordings_deleted'] = 'Voeg opnames toe van verwijderde activiteiten';
$string['mod_form_field_recordings_html'] = 'Toon de tabel in gewone html';
$string['mod_form_field_recordings_imported'] = 'Toon alleen geïmporteerde links';
$string['mod_form_field_recordings_preview'] = 'Toon voorbeeldweergave van opname';
$string['mod_form_field_room_name'] = 'Naam van de ruimte';
$string['mod_form_field_userlimit'] = 'Gebruikerslimiet';
$string['mod_form_field_userlimit_help'] = 'Maximaal aantal toegestane gebruikers in een bijeenkomst. Indien ingesteld op 0 is het aantal gebruikers onbeperkt.';
$string['mod_form_field_voicebridge'] = 'Voice bridge [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Format fout. Een getal tussen 1 en 9999 wordt verwacht.';
$string['mod_form_field_voicebridge_help'] = 'Voice conference getal dat deelnemers invoeren om deel te nemen aan de voice conference wanneer zij inbellen. Er moet een getal tussen 1 en 9999 worden ingevoerd. Als de waarde 0 is, wordt het statische voice bridge getal genegeerd en zal er een willekeurig getal worden gegenereerd door BigBlueButton. Het cijfer 7 zal voor de vier ingevoerde cijfers verschijnen.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Geen unieke waarde. Dit getal wordt door een andere ruimte of conferentie gebruikt.';
$string['mod_form_field_wait'] = 'Wachten op moderator';
$string['mod_form_field_wait_help'] = 'Toeschouwers moeten wachten tot er een moderator in de sessie binnenkomt voordat zij dat zelf kunnen doen';
$string['mod_form_field_welcome'] = 'Welkomstbericht';
$string['mod_form_field_welcome_default'] = '<br>Welkom bij <b>%%CONFNAME%%</b>!<br><br>Bekijk onze korte <a href="event:http://www.bigbluebutton.org/content/videos">tutorial video\'s</a> om te leren hoe BigBlueButton werkt.<br><br>Klik op het hoofdtelefoon-icoontje om deel te nemen aan de audioverbinding (bovenaan in het midden). <b>Gebruik een hoofdtelefoon om geen achtergrondgeluid te veroorzaken voor anderen.</b>';
$string['mod_form_field_welcome_help'] = 'Vervangt het standaardbericht dat voor de BigBlueButton server is ingesteld. Het bericht kan sleutelwoorden (%%CONFNAME%%, %%DIALNUM%%, %%CONFNUM%%) bevatten die automatisch vervangen worden, en html tags als &lt;b>...&lt;/b>, &lt;br />, &lt;u>&lt;/u> of &lt;i>&lt;/i>';
$string['mod_form_locksettings'] = 'Vergrendelinstellingen';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'Met BigBlueButton maak je binnen Moodle links to real-time online klassen die BigBlueButton gebruiken, een open-source webconferencing systeem voor leren op afstand.

Met BigBlueButton kun je de titel, beschrijving, melding in de kalender (die tijdspanne geeft om deel te nemen aan de sessie), groepen en details over de opname van de online sessie specificeren.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['pluginadministration'] = 'BigBlueButton beheer';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Om BigBlueButton-sessies te creëren en eraan deel te nemen, moeten gebruikersgegevens worden uitgewisseld met de server.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'De volledige naam van de gebruiker die toegang heeft tot de BigBlueButton-server.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Het gebruikers-ID van de gebruiker die toegang heeft tot de BigBlueButton-server.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Slaat de configuratie op voor de ruimte of activiteit die de kenmerken en het algemene gedrag van de BigBlueButton-sessie definieert.';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Een lijst met regels die de rol definiëren die gebruikers tijdens de live bijeenkomst zullen hebben. Een gebruikers-ID kan worden opgeslagen omdat per rol of gebruiker rechten kunnen worden verleend.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Slaat gebeurtenissen op die zijn geactiveerd bij het gebruik van de plug-in.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Het type gebeurtenis dat door de gebruiker is geactiveerd.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'De bijeenkomst ID waartoe de gebruiker toegang heeft.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Kan extra informatie bevatten met betrekking tot de bijeenkomst of de opname waarop het evenement betrekking heeft.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Het tijdstip waarop het logboek is gemaakt.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'De gebruikers-ID van de gebruiker die de gebeurtenis heeft geactiveerd.';
$string['removedevents'] = 'Verwijderde evenementen';
$string['removedlogs'] = 'Aangepaste logboeken verwijderd';
$string['removedrecordings'] = 'Verwijderde opnames';
$string['removedtags'] = 'Verwijderde tags';
$string['resetevents'] = 'Gebeurtenissen verwijderen';
$string['resetlogs'] = 'Verwijder aangepaste logboeken';
$string['resetlogs_help'] = 'Als u de logboeken verwijdert, gaan verwijzingen naar opnamen verloren';
$string['resetrecordings'] = 'Verwijder opnames';
$string['resetrecordings_help'] = 'Het verwijderen van de opnames maakt ze overal ontoegankelijk en kan niet ongedaan worden gemaakt';
$string['resettags'] = 'Verwijder tags';
$string['search:activity'] = 'BigBlueButtonBN - activiteitsinformatie';
$string['search:tags'] = 'BigBlueButtonBN - tagt informatie';
$string['sendnotification'] = 'Stuur een melding';
$string['started_at'] = 'Is begonnen';
$string['starts_at'] = 'Begint';
$string['view_conference_action_end'] = 'Sessie beëindigen';
$string['view_conference_action_join'] = 'Deelnemen aan sessie';
$string['view_error_action_not_completed'] = 'Actie kon niet worden voltooid';
$string['view_error_bigbluebutton'] = 'BigBlueButton antwoordde met fouten. {$a}';
$string['view_error_create'] = 'De BigBlueButton-server reageerde met een foutmelding, de bijeenkomst kon niet worden gecreëerd.';
$string['view_error_current_state_not_found'] = 'Huidige status is niet gevonden. De opname is mogelijk verwijderd of de BigBlueButton-server is niet compatibel met de uitgevoerde actie.';
$string['view_error_import_no_courses'] = 'Er zijn geen cursussen om op te zoeken voor opnames';
$string['view_error_import_no_recordings'] = 'Er zijn geen opnames in deze cursus om te importeren';
$string['view_error_invalid_session'] = 'De sessie is verlopen. Ga terug naar de hoofdpagina van de activiteit.';
$string['view_error_max_concurrent'] = 'Het aantal toegestane gelijktijdige overeenkomsten is bereikt.';
$string['view_error_meeting_not_running'] = 'Er is iets misgegaan, de bijeenkomst loopt niet.';
$string['view_error_no_group'] = 'Er zijn nog geen groepen geconfigureerd. Stel groepen in voordat je probeert deel te nemen aan de bijeenkomst.';
$string['view_error_no_group_student'] = 'Je bent nog niet aangemeld in een groep. Neem contact op met je leraar of de beheerder.';
$string['view_error_no_group_teacher'] = 'Er zijn nog geen groepen geconfigureerd. Stel groepen in of neem contact op met de beheerder.';
$string['view_error_unable_join'] = 'Kon niet deelnemen aan de bijeenkomst. Controleer de url van de BigBlueButton server EN controleer of de BigBlueButton server aan staat.';
$string['view_error_unable_join_student'] = 'Kon geen verbinding maken met de BigBlueButton server. Neem contact op met je leraar of de beheerder.';
$string['view_error_unable_join_teacher'] = 'Kon geen verbinding maken met de BigBlueButton server. Neem contact op met de beheerder.';
$string['view_error_url_missing_parameters'] = 'Er ontbreken parameters in deze URL';
$string['view_error_userlimit_reached'] = 'Het aantal toegestane gebruikers in een bijeenkomst is bereikt.';
$string['view_groups_nogroups_warning'] = 'De ruimte is geconfigureerd voor het gebruik van groepen, maar er zijn geen groepen gedefinieerd voor de cursus.';
$string['view_groups_notenrolled_warning'] = 'De ruimte is geconfigureerd voor het gebruik van groepen, maar u bent bij geen van hen ingeschreven.';
$string['view_groups_selection'] = 'Selecteer de groep waaraan je wilt deelnemen en bevestig';
$string['view_groups_selection_join'] = 'Deelnemen';
$string['view_groups_selection_warning'] = 'Er is een conferentieruimte voor iedere groep. Als je tot meer dan een groep toegang hebt, zorg er dan voor dat je de juiste selecteert.';
$string['view_login_moderator'] = 'Inloggen als moderator ...';
$string['view_login_viewer'] = 'Inloggen als toeschouwer ...';
$string['view_message_and'] = 'en';
$string['view_message_conference_has_ended'] = 'De conferentie is geëindigd.';
$string['view_message_conference_in_progress'] = 'De conferentie is bezig.';
$string['view_message_conference_not_started'] = 'De conferentie is nog niet begonnen.';
$string['view_message_conference_room_ready'] = 'De conferentieruimte is gereed. Je kunt nu deelnemen aan de sessie.';
$string['view_message_conference_wait_for_moderator'] = 'Wachten op een moderator om te kunnen deelnemen.';
$string['view_message_finished'] = 'Deze activiteit is afgelopen.';
$string['view_message_has_joined'] = 'is binnengekomen';
$string['view_message_have_joined'] = 'zijn binnengekomen';
$string['view_message_hour'] = 'uur';
$string['view_message_hours'] = 'uren';
$string['view_message_importrecordings_disabled'] = 'De functie voor het opnemen van opnamekoppelingen is uitgeschakeld op deze server.';
$string['view_message_minute'] = 'minuut';
$string['view_message_minutes'] = 'minuten';
$string['view_message_moderator'] = 'moderator';
$string['view_message_moderators'] = 'moderators';
$string['view_message_norecordings'] = 'Er zijn geen opnames om te tonen.';
$string['view_message_notavailableyet'] = 'Deze sessie is nog niet beschikbaar.';
$string['view_message_recordings_disabled'] = 'Opnames zijn uitgeschakeld op deze server. BigBlueButtonBN-instanties voor alleen opnamen kunnen niet worden gebruikt.';
$string['view_message_room_closed'] = 'Deze ruimte is gesloten.';
$string['view_message_room_open'] = 'Deze ruimte is open.';
$string['view_message_room_ready'] = 'Deze ruimte is gereed.';
$string['view_message_session_for'] = 'de sessie voor';
$string['view_message_session_has_user'] = 'Er is';
$string['view_message_session_has_users'] = 'Er zijn';
$string['view_message_session_no_users'] = 'Er zijn geen gebruikers voor deze sessie';
$string['view_message_session_running_for'] = 'De sessie is bezig voor';
$string['view_message_session_started_at'] = 'De sessie is begonnen om';
$string['view_message_tab_close'] = 'Dit tab/venster moet handmatig gesloten worden';
$string['view_message_times'] = 'keer';
$string['view_message_user'] = 'gebruiker';
$string['view_message_users'] = 'gebruikers';
$string['view_message_viewer'] = 'toeschouwer';
$string['view_message_viewers'] = 'toeschouwers';
$string['view_mobile_message_groups_not_supported'] = 'Deze instantie is ingeschakeld om met groepen te werken, maar de mobiele app ondersteunt dit niet. Open de desktop als je de groepsondersteuning wilt gebruiken.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'U heeft de 45 seconden op deze pagina overschreden. Laad de pagina opnieuw om correct deel te nemen aan de bijeenkomst.';
$string['view_noguests'] = 'BigBlueButton is niet geopend voor gasten';
$string['view_nojoin'] = 'Je hebt een rol die niet is toegestaan om deel te nemen aan deze sessie.';
$string['view_recording'] = 'opname';
$string['view_recording_actionbar'] = 'Werkbalk';
$string['view_recording_activity'] = 'Activiteit';
$string['view_recording_button_import'] = 'Opname-links importeren';
$string['view_recording_button_return'] = 'Ga terug';
$string['view_recording_course'] = 'Cursus';
$string['view_recording_date'] = 'Datum';
$string['view_recording_delete_confirmation'] = 'Weet je zeker dat je deze {$a} wilt verwijderen?';
$string['view_recording_delete_confirmation_warning_p'] = 'Deze opname heeft {$a} geassocieerde links die in andere cursussen of activiteiten zijn geïmporteerd. Als de opname wordt verwijderd, gebeurt dit ook voor deze links';
$string['view_recording_delete_confirmation_warning_s'] = 'Deze opname heeft {$a} geassocieerde link die in andere cursussen of activiteiten is geïmporteerd. Als de opname wordt verwijderd, gebeurt dit ook voor deze link';
$string['view_recording_description'] = 'Beschrijving';
$string['view_recording_duration'] = 'Duur';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'De URL voor dit opnameformaat is niet bereikbaar.';
$string['view_recording_format_notes'] = 'Opmerkingen';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Presentatie';
$string['view_recording_format_screenshare'] = 'Scherm delen';
$string['view_recording_format_statistics'] = 'Statistieken';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Weet je zeker dat je deze opname wilt importeren?';
$string['view_recording_length'] = 'Lengte';
$string['view_recording_link'] = 'geïmporteerde link';
$string['view_recording_link_warning'] = 'Dit is een link die wijst naar een opname die is gecreëerd in een andere cursus of activiteit';
$string['view_recording_list_action_delete'] = 'Verwijderen';
$string['view_recording_list_action_edit'] = 'Bijwerken';
$string['view_recording_list_action_play'] = 'Afspelen';
$string['view_recording_list_action_process'] = 'Verwerken';
$string['view_recording_list_action_protect'] = 'Beschermen';
$string['view_recording_list_action_publish'] = 'Publiceren';
$string['view_recording_list_action_unprotect'] = 'Beveiliging opheffen';
$string['view_recording_list_action_unpublish'] = 'Publicatie ongedaan maken';
$string['view_recording_list_action_update'] = 'Updaten';
$string['view_recording_list_actionbar'] = 'Werkbalk';
$string['view_recording_list_actionbar_delete'] = 'Verwijder';
$string['view_recording_list_actionbar_edit'] = 'Bewerken';
$string['view_recording_list_actionbar_hide'] = 'Verberg';
$string['view_recording_list_actionbar_import'] = 'Importeren';
$string['view_recording_list_actionbar_protect'] = 'Maak het privé';
$string['view_recording_list_actionbar_publish'] = 'Publiceer';
$string['view_recording_list_actionbar_show'] = 'Toon';
$string['view_recording_list_actionbar_unprotect'] = 'Maak het openbaar';
$string['view_recording_list_actionbar_unpublish'] = 'Maak publiceren ongedaan';
$string['view_recording_list_activity'] = 'Activiteit';
$string['view_recording_list_course'] = 'Cursus';
$string['view_recording_list_date'] = 'Datum';
$string['view_recording_list_description'] = 'Beschrijving';
$string['view_recording_list_duration'] = 'Duur';
$string['view_recording_list_recording'] = 'Opname';
$string['view_recording_meeting'] = 'Bijeenkomst';
$string['view_recording_modal_button'] = 'Toepassen';
$string['view_recording_modal_title'] = 'Waarden instellen voor opname';
$string['view_recording_name'] = 'Naam';
$string['view_recording_playback'] = 'Afspelen';
$string['view_recording_preview'] = 'Voorbeeldweergave';
$string['view_recording_preview_help'] = 'Plaats de muisaanwijzer op een afbeelding om deze op volledige grootte te bekijken';
$string['view_recording_publish_link_deleted'] = 'Deze link kan niet opnieuw worden gepubliceerd omdat de daadwerkelijke opname niet bestaat op de huidige BigBlueButton-server. De link moet worden verwijderd.';
$string['view_recording_publish_link_not_published'] = 'Deze link kan niet opnieuw worden gepubliceerd omdat de daadwerkelijke opname niet is gepubliceerd';
$string['view_recording_recording'] = 'Opname';
$string['view_recording_tags'] = 'Tags';
$string['view_recording_unprotect_link_deleted'] = 'Deze link kan niet onbeschermd zijn omdat de daadwerkelijke opname niet bestaat op de huidige BigBlueButton-server. De link moet worden verwijderd.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Deze link kan niet onbeschermd zijn omdat de daadwerkelijke opname is beveiligd';
$string['view_recording_unpublish_confirmation'] = 'Weet je zeker dat je publiceren ongedaan wilt maken voor deze {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Deze opname heeft {$a} geassocieerde links die in andere cursussen of activiteiten zijn geïmporteerd. Als de publicatie van de opname ongedaan gemaakt wordt, gebeurt dat ook voor deze links';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Deze opname heeft {$a} geassocieerde link die in andere cursussen of activiteiten is geïmporteerd. Als de publicatie van de opname ongedaan gemaakt wordt, gebeurt dat ook voor deze link';
$string['view_recording_yui_first'] = 'Eerste';
$string['view_recording_yui_go'] = 'Ga';
$string['view_recording_yui_last'] = 'Laatste';
$string['view_recording_yui_next'] = 'Volgende';
$string['view_recording_yui_page'] = 'Pagina';
$string['view_recording_yui_prev'] = 'Vorige';
$string['view_recording_yui_rows'] = 'Rijen';
$string['view_recording_yui_show_all'] = 'Toon alles';
$string['view_room'] = 'Bekijk ruimte';
$string['view_section_title_presentation'] = 'Presentatie-bestand';
$string['view_section_title_recordings'] = 'Opnames';
$string['view_warning_default_server'] = 'Deze Moodle-server maakt gebruik van de BigBlueButton-testserver die standaard vooraf is geconfigureerd. Het moet worden vervangen voor productie.';
