<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_rebel', language 'pt', version '3.9'.
 *
 * @package     theme_rebel
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Cores';
$string['alert'] = 'Alerta na página de autenticação';
$string['alert_desc'] = 'Adicione um alerta especial à sua página principal, como por exemplo, uma emergência.';
$string['backgrounds'] = 'Fundos';
$string['badges'] = '&nbsp;Medalhas';
$string['badges_desc'] = 'Dê prémios aos seus alunos';
$string['brandcolor'] = 'Cor da marca';
$string['brandcolor_desc'] = 'Cor do destaque.';
$string['brandemail'] = 'E-mail da organização';
$string['brandemaildesc'] = 'Endereço de e-mail da organização que aparece no rodapé.';
$string['brandinginfo'] = 'Opções';
$string['brandinginfo_desc'] = 'Use as opções abaixo para fornecer identidade visual ao seu site.';
$string['brandingsettings'] = 'Organização';
$string['brandlogo'] = 'Logótipo da organização';
$string['brandlogo_desc'] = 'Imagem que é exibida na área do cabeçalho e rodapé. Deve ser um logótipo de tamanho pequeno.';
$string['brandorganization'] = 'Nome da organização';
$string['brandorganizationdesc'] = 'Nome da organização a ser exibido no rodapé.';
$string['brandphone'] = 'Telefone da organização';
$string['brandphonedesc'] = 'Número de contacto a ser exibido no rodapé.';
$string['brandwebsite'] = 'Página web da organização';
$string['brandwebsitedesc'] = 'Endereço do site que aparecerá no rodapé da organização.';
$string['choosereadme'] = 'O tema Rebel é um tema obtido a partir do Boost. Adiciona a capacidade de carregar imagens de fundo.';
$string['cmnotestudent'] = 'Mensagem para o aluno';
$string['cmnotestudent_desc'] = 'Mostre uma mensagem a todos os alunos no painel de gestão da disciplina.';
$string['cmnoteteacher'] = 'Mensagem para o professor';
$string['cmnoteteacher_desc'] = 'Mostre uma mensagem a todos os professores no painel de gestão da disciplina.';
$string['cmnotetitle'] = 'Painel da disciplina';
$string['cmnotetitle_desc'] = 'Notas do Painel da disciplina';
$string['color_desc'] = 'Escolha uma nova cor de fundo para esta variável.';
$string['configtitle'] = 'Tema Rebel';
$string['courseadmininfo'] = 'Hiperligação da gestão da disciplina para professores';
$string['courseadmininfo_desc'] = 'Determine quais as hiperligações que pretende exibir para os professores no menu de navegação da disciplina.';
$string['courseadminlinktoggle'] = 'Mostrar ou ocultar esta hiperligação no menu de navegação da administração da disciplina.';
$string['courseadminmenusettings'] = 'Configurações do menu de navegação';
$string['courseadminmenutitle'] = 'Gestão da disciplina';
$string['courseadminreportinfo'] = 'Hiperligação do relatório da gestão da disciplina do professor';
$string['courseheaderlinktoggle'] = 'Mostrar ou ocultar esta hiperligação na área do cabeçalho.';
$string['courseinfo'] = 'Descrição da disciplina';
$string['coursemanage'] = '&nbsp;Disciplina';
$string['coursemanage_desc'] = 'Gerir a disciplina';
$string['coursemanagementbutton'] = 'Gestão da disciplina';
$string['coursereportmenutitle'] = 'Relatórios da disciplina';
$string['coursestaff'] = 'Professores da disciplina';
$string['coursetilebg'] = 'Imagem predefinida da disciplina';
$string['coursetilebg_desc'] = 'Imagem predefinida para os cartões de disciplinas no Painel do utilizador e a imagem predefinida do cabeçalho em todas as disciplinas onde o professor não carregou uma imagem nas Configurações da disciplina. Mesmo com as imagens do cabeçalho desativadas, pode usar uma imagem aqui para ser a imagem predefinida do cartão da disciplina no Painel.';
$string['createinfo'] = 'Botão especial de Criador de disciplinas';
$string['createinfodesc'] = 'Este botão aparece na página principal quando um utilizador pode criar novas disciplinas. Os utilizadores com o papel de Criador de disciplinas ao nível do site irão ver este botão.';
$string['customlogininfo'] = 'Configure a página de autenticação';
$string['customlogininfo_desc'] = 'Use as opções abaixo para melhorar a aparência da página de autenticação do tema Rebel.';
$string['dashboardbackgroundimage'] = 'Imagem de fundo da página do painel do utilizador';
$string['dashboardbackgroundimage_desc'] = 'Imagem que será ajustada para preencher o fundo da página do painel.';
$string['dashboardiconbutton'] = 'Painel da disciplina';
$string['dashboardtextbox'] = 'Caixa de texto do painel';
$string['dashboardtextbox_desc'] = 'Caixa de texto personalizada que é exibida no painel do site. Use-a para dar as boas-vindas aos alunos ou fornecer instruções.';
$string['defaultbackgroundimage'] = 'Imagem do cabeçalho da página';
$string['defaultbackgroundimage_desc'] = 'Esta imagem é usada na área do cabeçalho para todas as páginas principais do Moodle: Painel do utilizador, Perfil, Página principal do Site e todas as páginas fora das páginas das disciplinas.';
$string['easyenrol_blurp'] = 'Insira abaixo o seu código da disciplina para se inscrever. O teu professor é quem fornece o código da disciplina.';
$string['easyenrol_btn'] = 'Inscrição numa disciplina';
$string['easyenrol_title'] = 'Formulário de inscrição';
$string['editoff'] = 'Desativar modo de edição';
$string['editon'] = 'Ativar modo de edição';
$string['featuretext'] = 'Caixa de Texto do Destaque';
$string['featuretext_desc'] = 'Uma das três caixas de texto apresentadas abaixo do formulário de autenticação.';
$string['footer-bg'] = 'Fundo do rodapé';
$string['footeroverlay'] = 'Textura do rodapé';
$string['footeroverlay_desc'] = 'Textura recomendada: "Brushed.png". Selecione para alterar a textura do fundo do rodapé. As imagens de fundo transparentes foram descarregada aqui: <a href="https://www.transparenttextures.com/">https://www.transparenttextures.com</a>';
$string['footnote'] = 'Nota de rodapé';
$string['footnotedesc'] = 'Editor do conteúdo do rodapé da página principal';
$string['frontpagebackgroundimage'] = 'Imagem de fundo da página principal';
$string['frontpagebackgroundimage_desc'] = 'Imagem que será ajustada para preencher o fundo da página principal.';
$string['generalsettings'] = 'Configurações gerais';
$string['header-bg'] = 'Fundo do cabeçalho';
$string['headerlinks-bg'] = 'Fundo da barra de navegação do cabeçalho';
$string['headermenuinfo'] = 'Itens do menu do cabeçalho';
$string['headermenuinfo_desc'] = 'Determine quais as hiperligações que pretende exibir na área do cabeçalho.';
$string['headeroverlay'] = 'Textura do cabeçalho';
$string['headeroverlay_desc'] = 'Textura recomendada: "Brushed.png". Selecione para alterar a textura do fundo do cabeçalho. As imagens de fundo transparentes foram descarregada aqui: <a href="https://www.transparenttextures.com/">https://www.transparenttextures.com</a>';
$string['iconnavheading'] = 'Ícones';
$string['iconnavinfo'] = 'Ícones de navegação no painel';
$string['iconnavinfo_desc'] = 'Crie botões com ícones para usar na página principal. Aparecerão na parte superior da página do Painel do utilizador.';
$string['iconwidth'] = 'Largura do ícone';
$string['iconwidth_desc'] = 'Largura dos 8 ícones na barra de ícones de navegação na página principal.';
$string['iconwidthinfo'] = 'Configuração da largura do botão do ícone';
$string['iconwidthinfodesc'] = 'Selecione a largura que permitirá que o texto da hiperligação caiba dentro do ícone dos botões de navegação.';
$string['incoursebackgroundimage'] = 'Imagem de fundo das diciplinas';
$string['incoursebackgroundimage_desc'] = 'Imagem que será ajustada para preencher o fundo das páginas das disciplinas.';
$string['loginbackgroundimage'] = 'Imagem de fundo da página de autenticação';
$string['loginbackgroundimage_desc'] = 'Imagem que será ajustada para preencher o fundo da página de autenticação.';
$string['loginbottomtext'] = 'Caixa de texto do fundo';
$string['loginbottomtext_desc'] = 'Caixa de texto de largura total que aparece na parte inferior da página de autenticação.';
$string['loginiconbutton'] = 'Entrar';
$string['loginsettings'] = 'Autenticação';
$string['logintopimage'] = 'Imagem da página de autenticação';
$string['logintopimage_desc'] = 'Carregue uma imagem que será colocada à direita do formulário de autenticação.';
$string['logintoptext'] = 'Caixa de texto do topo';
$string['logintoptext_desc'] = 'Caixa de texto de largura total que aparece logo abaixo da imagem na página de autenticação.';
$string['marketingurltarget'] = 'Destino da hiperligação';
$string['marketingurltargetdesc'] = 'Escolha como deve abrir a hiperligação';
$string['marketingurltargetnew'] = 'Nova página';
$string['marketingurltargetparent'] = 'Frame ascendente';
$string['marketingurltargetself'] = 'Página atual';
$string['moreoptions'] = 'Mais opções...';
$string['mygradestext'] = 'Minhas notas';
$string['myprogresspercentage'] = '% Concluído';
$string['myprogresstext'] = 'O meu progresso';
$string['navbar-bg'] = 'Fundo da barra de navegação superior';
$string['navicon'] = 'Ícone';
$string['navicon1'] = 'Ícone Um da Página principal';
$string['navicon2'] = 'Ícone Dois da Página principal';
$string['navicon3'] = 'Ícone Três da Página principal';
$string['navicon4'] = 'Ícone Quatro da Página principal';
$string['navicon5'] = 'Ícone Cinco da Página principal';
$string['navicon6'] = 'Ícone Seis da Página principal';
$string['navicon7'] = 'Ícone Sete da Página principal';
$string['navicon8'] = 'Ícone Oito da Página principal';
$string['naviconbuttontext'] = 'Texto da hiperligação';
$string['naviconbuttontextdesc'] = 'Texto que aparecerá por baixo do ícone.';
$string['naviconbuttonurl'] = 'URL da hiperligação';
$string['naviconbuttonurldesc'] = 'URL para o qual o botão apontará. Basta inserir o URL adequado para ligar-se a qualquer lugar, incluindo sites externos. Se o seu site Moodle estiver numa subdiretoria, o URL predefinido não funcionará. Ajuste o URL para refletir a subdiretoria. Por exemplo: se a subdiretoria tiver o nome de "moodle", o URL terá de ser alterado para /moodle/';
$string['navicondesc'] = 'Nome do ícone que pretende usar. Consulte a lista <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aqui</a>.  Basta inserir o que está depois de "fa-". Exemplo: "star".';
$string['naviconslidedesc'] = 'Texto do ícone sugerido: "arrow-circle-down". Pode escolher outro <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aqui</a>.  Basta inserir o que está depois de "fa-". Exemplo: "star".';
$string['nomycourses'] = 'Não está inscrito em nenhuma disciplina.';
$string['nothiscourse'] = 'Não é possível identificar nenhuma secção ou tópico da disciplina';
$string['pluginname'] = 'Rebel';
$string['preset'] = 'Predefinição do tema';
$string['preset_desc'] = 'Escolha uma predefinição para alterar amplamente a aparência do tema.';
$string['presetfiles'] = 'Ficheiros de predefinições adicionais do tema';
$string['presetfiles_desc'] = 'Os ficheiros de predefinições podem ser usados para alterar drasticamente a aparência do tema. Consulte a página <a href=https://docs.moodle.org/dev/Boost_Presets>Predefinições do Boost</a> para obter informações sobre como criar e partilhar os seus próprios ficheiros de predefinições. O tema Rebel requer certas variáveis de predefinições SCSS. Pode ver as predefinições do tema Rebel aqui: <a href=https://github.com/dbnschools/moodle-theme_rebel/tree/master/scss/preset target=_blank>Repositório de predefinições Rebel no Github</a>.';
$string['privacy:metadata'] = 'O tema Rebel não armazena quaisquer dados dos utilizadores.';
$string['qbank'] = '&nbsp;Banco de perguntas';
$string['qbank_desc'] = 'Criar e organizar perguntas dos testes';
$string['rawscss'] = 'Raw SCSS';
$string['rawscss_desc'] = 'Use este campo para fornecer código SCSS ou CSS que será colocado no fim da folha de estilo.';
$string['rawscsspre'] = 'Raw SCSS inicial';
$string['rawscsspre_desc'] = '//Área da barra de navegação superior</br>
$navbar-bg: #e3eaf5 ;</br>
$navbartextcolor: #333;</br>

//Cabeçalho da barra de navegação superior</br>
$header-bg: #eef5f9;</br>
$headerlinks-bg: #e3eaf5;</br>
$headerlinks-link: $black;</br>

//Migalhas no Rebel</br>
$breadcrumbblock: #607d8b;</br>
$breadcrumbblock-darken: #213561;</br>
$breadcrumbblock-highlight: #213561;</br>
$breadcrumbblock-highlight-darken: #607d8b;</br>
$breadcrumblinkcolor: $white;</br>
$breadcrumblinkcolor-hover: $white;</br>

//Ícones do menu da barra lateral</br>
$sidebar-bg: $body-bg;</br>
$sidebar-iconcolor: $white;</br>
$sidebar-ahover-bg: #1f77b2;</br>
$sidebar-aattention: #4caf50;</br>
$sidebar-borderright-color: $white;</br>

//Área inferior do rodapé</br>
$footer-bg: #e5ebef;</br>
$footerlinkcolor: #333;</br>
$footertextcolor: #333;</br>

//Usado para dar estilo ao módulo Incrição Fácil</br>
$easyenrolltextcolor: $white;</br>
$easyenroll-bg: #4caf50;</br>

//Outras Cores Importantes</br>
$card-bg: rgba(255, 255, 255, 0.98)!default;</br>
$body-bg: #213561;</br>
$primary:       #1968BE;</br>
$success:       $green;</br>
$info:          #4caf50;</br>
$warning:       $orange;</br>
$danger:        $red;</br>
$secondary:     $gray-400;</br>

// Separadores</br>
$nav-tabs-border-color:             $gray-300;</br>
$nav-tabs-link-hover-border-color:  $gray-200 $gray-200 $nav-tabs-border-color;</br>
$nav-tabs-link-active-color:        $gray-700;</br>
$nav-tabs-link-active-bg:           $gray-200;</br>
$nav-tabs-link-active-border-color: $gray-300 $gray-300 $nav-tabs-link-active-bg;';
$string['region-side-pre'] = 'Direita';
$string['sectionlayout'] = 'Seletor do estilo da secção';
$string['sectionlayout1'] = 'Predefinição do Moodle';
$string['sectionlayout2'] = 'Título da secção a negrito';
$string['sectionlayout3'] = 'Caixa arredondada simples';
$string['sectionlayout4'] = 'Tópico 0 em caixa';
$string['sectionlayout_desc'] = 'Selecione o estilo das secções para o formato de tópicos/semanas.';
$string['showcoursesections'] = 'Mostrar lista das secções da disciplina';
$string['showcoursesections_desc'] = 'Fornece uma lista pendente das secções da disciplina e permite uma navegação rápida dentro daa disciplina. Pode não funcionar com todos os formatos de disciplina.';
$string['showcustomlogin'] = 'Usar página de autenticação personalizada';
$string['showcustomlogin_desc'] = 'Se ativar esta opção é possível utilizar as configurações abaixo para serem exibidas na página de autenticação do Moodle.';
$string['showheaderimages'] = 'Mostrar imagens do cabeçalho';
$string['showheaderimages_desc'] = 'Permitir que o tema Rebel use imagens personalizadas para a área do cabeçalho. Será ainda possível definir abaixo uma imagem do cartão da disciplina mas ela não será usada como uma imagem do cabeçalho dentro das disciplinas. Esta configuração desativa completamente o uso de imagens no cabeçalho.';
$string['sidebar-bg'] = 'Fundo da barra lateral';
$string['sliderinfo'] = 'Ícone do botão Slide';
$string['sliderinfodesc'] = 'Este botão irá mostrar/ocultar uma caixa de texto especial que desliza para baixo na barra de ícones de navegação. É ideal para destacar disciplinas, fornecer ajuda ou listar o plano de trabalhos, etc.';
$string['slidetextbox'] = 'Caixa de texto do Slide';
$string['slidetextbox_desc'] = 'Este conteúdo da caixa de texto será exibido quando o botão Slide for pressionado.';
$string['studentdashbutton'] = 'Painel da disciplina';
$string['thiscourse'] = 'Secções da disciplina';
$string['userlinks'] = '&nbsp;Utilizadores';
$string['userlinks_desc'] = 'Gerir os seus alunos';
