<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'pt', version '3.9'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutdemosite'] = 'O nosso sítio de demonstração do Moodle é um sítio completo com algumas disciplinas de exemplo que poderá experimentar como professor, aluno ou mesmo como administrador. Não se preocupe se alterar algo, o estado original do sítio é restaurado cada hora.';
$string['aboutdemositetitle'] = 'Sítio de demonstração';
$string['aboutintro'] = 'O Moodle é um Sistema de Software Livre de Gestão de Disciplinas - Course Management System (CMS), também conhecido como Learning Management System (LMS) ou um Ambiente Virtual de Aprendizagem (AVA). Tornou-se muito popular entre educadores de todo o mundo como uma ferramenta para criar sítios Web dinâmicos para os seus alunos. Deverá ser instalado num servidor Web, num dos seus próprios computadores ou numa empresa de hospedagem de sítios.';
$string['aboutoverview'] = '<p>O foco do projeto Moodle é sempre disponibilizar aos educadores as melhores ferramentas para gerir e promover a aprendizagem, mas pode ser utilizado de muitas maneiras diferentes: </p>
<ul>
<li>O Moodle possui características que lhe permitem usabilidade em grande escala para centenas de milhares de estudantes, mas também pode ser usado para uma escola primária ou por um entusiasta da educação.</li>
<li>Muitas instituições utilizam-no como plataforma para realização de disciplinas totalmente em linha, enquanto outros simplesmente o usam para facilitar o contato nas suas disciplinas (conhecido como blended learning).</li>
<li>Muitos dos nossos utilizadores gostam de usar os módulos de atividade (como fóruns, wikis e bases de dados) para construir comunidades amplamente colaborativas de aprendizagem em torno dum tema (na tradição do construtivismo social), enquanto outros preferem utilizá-lo como um meio de fornecer conteúdo aos alunos (tais como pacotes SCORM) e avaliar a aprendizagem utilizando tarefas ou testes.</li>
</ul>';
$string['aboutoverviewtitle'] = 'O que é o Moodle?';
$string['aboutstatistics'] = 'O Moodle pode ser descarregado livremente e não é obrigatório qualquer registo. Por isso, não temos informação detalhada sobre todos os que o utilizam. No entanto, com o que sabemos, geramos automaticamente números e gráficos interessantes na nossa página de estatísticas.';
$string['aboutstatisticsheading'] = 'Estatísticas Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Estatísticas Moodle';
$string['activeusers24hours'] = 'Utilizadores registados que acederam nas últimas 24 horas:';
$string['activeuserspastmonth'] = 'Utilizadores registados que acederam no último mês:';
$string['browsegittitle'] = 'Consulte o nosso código fonte';
$string['cachedef_frontpagecolumn'] = 'Colunas da página principal';
$string['cachedef_usefulposts'] = 'Mensagens úteis';
$string['communities'] = 'Comunidades';
$string['communitiesmy'] = 'Minhas comunidades';
$string['community'] = 'Comunidade';
$string['communityadministration'] = 'Administração da comunidade';
$string['communitycurrent'] = 'Comunidade atual';
$string['communityenrolme'] = 'Tornar-se membro desta comunidade';
$string['communityenrolmentoptions'] = 'Juntar-se a uma comunidade';
$string['communityintro'] = 'O Moodle tem uma grande e diversificada comunidade de utilizadores, com mais de <a href="http://moodle.org/userpics">{$a->usercount} utilizadores registados</a> que comunicam entre si em <a href="https://download.moodle.org/langpack/">{$a->langcount} idiomas</a> de <a href="http://moodle.org/sites"> {$a->countrycount} países</a> (pode consultar mais estatísticas <a href="http://moodle.org/stats">neste site</a>).';
$string['communityjoinbyyourself'] = 'Junte-se por si próprio';
$string['communityjoinbyyourselfas'] = 'Junte-se por si próprio como {$a->rolename}';
$string['communitynoguestaccess'] = 'Os visitantes não podem aceder a esta área da comunidade. Por favor, autentique-se.';
$string['communitynotenrollable'] = 'Não pode ser membro desta comunidade por si próprio. Contacte o facilitador da comunidade.';
$string['communitysomeallowguest'] = 'Algumas comunidades podem permitir o acesso a visitantes';
$string['communityunenrolme'] = 'Sair da comunidade \'{$a}\'';
$string['conferencecenter'] = 'Centro de conferências Moodle';
$string['connectedsites'] = 'Alguns sites Moodle estão ligados a moodle.org utilizando a rede Moodle, o que permite autenticar-se diretamente a partir daqui.';
$string['contactbugs'] = 'Pode relatar problemas com o Software Moodle e em qualquer sítio no domínio moodle.org criando um novo problema no Tracker do Moodle.';
$string['contactbugstitle'] = 'Relatar problema';
$string['contactintro'] = 'Por favor escolha uma das seguintes opções de contato:';
$string['contactlogin'] = 'Para todas as outras consultas, autentique-se no sítio e use o formulário de contato que aparece nesta página';
$string['contactmoodlecom'] = 'Para todas as perguntas relativas ao licenciamento, marca registrada, ou questões comerciais, bem como os principais desenvolvimentos do Moodle, por favor contate o serviço de atendimento, <a href="http://moodle.com/"> Moodle.com </a>';
$string['contactmoodlecomhelpdesk'] = 'Suporte técnico Moodle.com';
$string['contactmoodlecomtitle'] = '	
Moodle.com';
$string['contactmoodleorgemail'] = 'Em caso de problemas com a confirmação da conta do moodle.org, envie correio eletrónico  para:';
$string['contactmoodleorglogin'] = 'Autenticar-se neste sítio agora';
$string['contactmoodleorgother'] = 'Para todas as outras consultas, por favor, use o formulário de contato abaixo.';
$string['contactmoodleorgtitle'] = 'Moodle.org';
$string['contactsecurity'] = 'Os problemas de segurança também podem ser relatados no tracker, permitindo configurar o nível de segurança adequado.';
$string['contactsent'] = 'A sua mensagem foi enviada para a Administração da Comunidade Moodle';
$string['contactsupport'] = 'Para suporte com a utilização do software Moodle, consulte a nossa página de suporte que lista muitos recursos úteis disponíveis.';
$string['contactsupporttitle'] = 'Suporte';
$string['developerlist'] = 'Lista completa de programadores com direito de escrita';
$string['developermeetings'] = 'Encontros de programadores';
$string['developers'] = 'O desenvolvimento principal do Moodle é liderado pela equipa principal no Moodle.com, ajudado por centenas de outros programadores no mundo inteiro. Muitos desses programadores também são diretamente responsáveis por vários módulos e plugins.';
$string['developerstitle'] = 'Programadores';
$string['developmentdocs'] = 'A maior parte da nossa documentação está em Moodle Docs - incluindo especificações, divagações, procedimentos, normas e manuais do utilizador.';
$string['developmentdocstitle'] = 'Documentação para programadores';
$string['developmentintro'] = 'Procuramos seguir um processo de desenvolvimento transparente e aberto, que convide toda a comunidade para contribuir. Congratulamo-nos com os programadores PHP, é claro, mas poderá sempre
contribuir por meio de discussões, artigos, opiniões e documentação.';
$string['developmenttracker'] = 'Todas as questões de desenvolvimento (como bugs, novas funcionalidades e melhorias) são registrados e geridos no Moodle Tracker. Pode ver quem está trabalhando em quê e participar em qualquer conversa. Deverá também pesquisar sempre no tracker quando estiver a procura de informações sobre questões específicas e certifique-se de <strong>votar</strong> sobre os problemas a resolver que julga que são mais urgentes; o seu voto ajudará a determinar as prioridades de desenvolvimento.';
$string['donations'] = 'Moodle é completamente livre de obrigações financeiras; porém várias pessoas da comunidade têm feito doações para o nosso projeto para ajudar a pagar os programadores que contribuem no desenvolvimento do Moodle.';
$string['donations10over'] = 'Outros donativos de 10 $ (US) ou mais';
$string['donationsassociation'] = 'Junte-se à <a href="https://moodleassociation.org/">Associação Moodle</a> - Ajude a decidir como devem ser gastas as taxas de associação nos itens de evolução do Moodle';
$string['donationsdevelopment'] = 'No entanto, o desenvolvimento do Moodle e a manutenção de todos os sites da nossa comunidade custam muito dinheiro e podemos usar sempre um suporte extra. Se gosta do Moodle ou acha útil para o seu negócio, escola ou instituição, faça um donativo. Toda a ajuda é bem-vinda.';
$string['donationsdonatenow'] = 'Fazer donativo';
$string['donationsensure'] = 'Os donativos garantem que as engrenagens essenciais da máquina Moodle (os nossos programadores) continuem a criar novos recursos e a corrigir erros, tornando o Moodle melhor para todos nós.';
$string['donationsmoney'] = 'Pode também contribuir com dinheiro por meio de uma doação. Todo o dinheiro é usado para transformar os nossos planos em características reais das que todos poderemos usufruir. Para fazer uma doação usando cartão de crédito, na maioria das principais moedas, por favor clique no botão Paypal abaixo.<br /><br />Doadores de US$ 10 podem adicionar o seu nome a esta página por um ano. Não se esqueça de clicar no botão "continuar" depois de pagar para ver o formulário onde pode editar como será visualizado o seu nome.';
$string['donationsmoodle'] = 'Donativo para o Moodle';
$string['donationsopensource'] = 'O Moodle é verdadeiramente código aberto e completamente livre de obrigações financeiras para os nossos utilizadores - é assim que o software deve ser!';
$string['donationsover1000'] = 'Donativos anteriores de valor acima de 1000 $ (US)';
$string['donationsover200'] = 'Outros donativos de valor acima de 200 $ (US)';
$string['donationsover500'] = 'Outros donativos de valor acima de 500 $ (US)';
$string['donationspartner'] = 'Contacte um <a href="https://moodle.com/partners/">Parceiro Moodle certificado</a> para aquisição de serviços - 10% da receita é contribuição para o projeto Moodle.';
$string['donationsservices'] = 'Se precisar de serviços de hospedagem Moodle, suporte, instalação, codificação personalizada, desenvolvimento de disciplinas ou consultoria, entre em contato com o <a href="http://moodle.com/"> Parceiro Moodle do moodle.com </a> na sua localidade (esse sítio inclui publicidade). Os nossos parceiros contribuem com uma percentagem fixa de todos os seus ganhos para o fundo de desenvolvimento do Moodle Trust, para o benefício de todos.';
$string['donationsshop'] = 'Compre online na nossa <a href="http://www.zazzle.com/moodle_hq/">loja Moodle</a> e use-o com orgulho!';
$string['donationsthankeveryone'] = 'Obrigado a todos os que contribuíram para o projeto Moodle.';
$string['donationsthankyou'] = 'Obrigado';
$string['donationstitle'] = 'Donativos';
$string['donationstrust'] = 'O Moodle tem um fundo de desenvolvimento, gerido pelo Moodle Trust, usado para contratar programadores para o seu desenvolvimento e para suportar as despesas de moodle.org.';
$string['donationsways'] = 'Outras maneiras de contribuir financeiramente para o Moodle:';
$string['download_activities'] = 'Atividades';
$string['download_admintools'] = 'Ferramentas de administração';
$string['download_appdocumentation'] = 'Documentação da aplicação';
$string['download_appreleasenotes'] = 'Notas de lançamento';
$string['download_browseall'] = 'Consultar tudo';
$string['download_downloadosx'] = 'Descarregue o Moodle para OS X (contém o Moodle, Apache, MySQL e PHP para funcionar no Mac OS)';
$string['download_downloadwindows'] = 'Descarregue o Moodle para Windows (contém o Moodle, Apache, MySQL e PHP para funcionar no Windows)';
$string['download_forandroid'] = 'Para Android';
$string['download_forios'] = 'Para iOS';
$string['download_helpbox_description'] = 'Para começar, leia a documentação e visite os fóruns da comunidade ou simplesmente entre em contacto com um parceiro Moodle para alojamento, instalação e outros serviços';
$string['download_helpbox_installing'] = 'Instalar o Moodle';
$string['download_helpbox_partners'] = 'Parceiros Moodle';
$string['download_helpbox_support'] = 'Fóruns de suporte';
$string['download_helpbox_title'] = 'Precisa de ajuda?';
$string['download_helpbox_upgrading'] = 'Atualizar o Moodle';
$string['download_hero_description'] = 'Está sob a <a class="link" href="http://docs.moodle.org/dev/License"> licença GPL</a>, o que significa que qualquer pessoa pode usar livremente e aproveitar os benefícios do nosso software. <br><br>Confira a versão mais recente do Moodle.';
$string['download_hero_headline'] = 'Moodle é código aberto.';
$string['download_langpackinfo'] = 'Os pacotes linguísticos são gerados automaticamente a partir do trabalho dos tradutores no <a href="http://lang.moodle.org/">site da tradução</a>. Para mais detalhes, consulte a <a href="https://docs.moodle.org/dev/Translation">documentação da tradução</a>.';
$string['download_langpackinstallinfo'] = 'Podem ser instalados pacotes linguísticos adicionais no seu site Moodle via <em>Administração do Site / Idioma / Pacotes linguísticos</em> ou manualmente. Para mais detalhes, consulte a <a href="https://docs.moodle.org/en/Language_packs">documentação dos pacotes linguísticos</a>.';
$string['download_langpackinstalltitle'] = 'Instalação de pacotes linguísticos';
$string['download_langpacktitle'] = 'Pacotes linguísticos para o Moodle {$a}';
$string['download_mobileapp'] = 'Aplicação móvel Moodle';
$string['download_themes'] = 'Temas';
$string['download_viewallbuilds'] = 'Ver todas as versões (requer um servidor web, PHP e uma base de dados)';
$string['downloadcore'] = 'O nosso principal método de distribuição é através de pacotes com o núcleo básico do Moodle. Os pacotes contêm vários módulos que são mantidos pelos programadores do projeto e que podem ser instalados praticamente em qualquer plataforma que disponha de PHP e de uma base de dados.';
$string['downloadcoretitle'] = 'Pacotes básicos do Moodle';
$string['downloadintro'] = 'Moodle é Software Livre sob a <a href="http://docs.moodle.org/en/License">licença GPL</a>. Tudo o que produzimos está disponível para ser descarregado e usado livremente.';
$string['downloadlang'] = 'Nas versões atuais do Moodle, a adição de suporte para novos idiomas foi automatizada a partir do menu de administração do site. No entanto, para algumas versões antigas do Moodle, os pacotes linguísticos têm de ser descarregados manualmente.';
$string['downloadlangtitle'] = 'Pacotes linguísticos';
$string['downloadlogotitle'] = 'Logótipos do Moodle';
$string['downloadmac'] = 'Se tiver um servidor web já criado, estes pacotes "all-in-one" (tudo em um) tornam muito fácil a instalação do Moodle em qualquer computador Apple com o Mac OS X.';
$string['downloadmactitle'] = 'Moodle para Mac OS X';
$string['downloadmodules'] = 'Explore a nossa base de dados repleta de módulos extras que podem ser instalados no seu site Moodle e que permitem funcionalidades adicionais para além dos pacotes básicos.';
$string['downloadmodulestitle'] = 'Módulos';
$string['downloadthemes'] = 'A aparência de um site Moodle pode ser modificada totalmente utilizando um tema diferente. Mantemos uma base de dados de temas criados e partilhados por outros utilizadores do Moodle.';
$string['downloadthemestitle'] = 'Temas';
$string['downloadviagitcvs'] = 'Outras maneiras de obter o Moodle inclui <a href="http://docs.moodle.org/en/Git_for_Administrators">descarregar via Git</a> ou <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">descarregar via CVS</a>.';
$string['downloadwin'] = 'Se não tiver um servidor web já criado, estes pacotes "all-in-one" (tudo em um) tornam mais fácil a instalação do Moodle em qualquer computador com Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle para Windows';
$string['erroradminonly'] = 'Apenas os administradores podem usar esta interface.';
$string['erroralreadyvoted'] = 'Já votou a favor de {$a}';
$string['errormaxmessages'] = 'Lamentamos, mas não pode enviar mais do que 3 mensagens.';
$string['errornomainnews'] = 'Não foi possível encontrar ou criar um fórum de notícias principal para o site';
$string['errorsendingmail'] = 'Ocorreu um erro no envio da sua mensagem. Por favor, tente mais tarde ou contacte o administrador do site.';
$string['eventdonation_created'] = 'Lista de doações criada';
$string['eventdonation_submitted'] = 'Donativo submetido';
$string['events'] = 'Embora a nossa especialidade seja a aprendizagem remota, é sempre agradável reunirmos presencialmente! Consulte estes sites para obter mais informações sobre as nossas conferências (designadas de MoodleMoots) e outros eventos.';
$string['eventstitle'] = 'Eventos';
$string['feed_events'] = 'Eventos';
$string['feed_events_more'] = 'Mais eventos';
$string['feed_news'] = 'Anúncios';
$string['feed_news_more'] = 'Ver todos os anúncios';
$string['feed_resources'] = 'Recursos';
$string['feed_useful'] = 'Mensagens úteis';
$string['feed_useful_more'] = 'Mais mensagens';
$string['focusbox_community'] = 'Fóruns de suporte e da comunidade';
$string['focusbox_community_text'] = 'Obtenha suporte e partilhe ideias no seu idioma.';
$string['focusbox_community_viewall'] = 'Todas as comunidades';
$string['focusbox_future'] = 'Ajude a moldar o futuro do Moodle';
$string['focusbox_future_crowdfund'] = 'Financiamento colaborativo de projetos';
$string['focusbox_future_gdf'] = 'Discussões de programador';
$string['focusbox_future_research'] = 'Pesquisa Moodle';
$string['focusbox_future_roadmap'] = 'Roteiro';
$string['focusbox_future_text'] = 'Descubra o que vem a seguir e ajude a fazer a diferença.';
$string['focusbox_settingup'] = 'Configuração';
$string['focusbox_settingup_community'] = 'Suporte à comunidade';
$string['focusbox_settingup_download'] = 'Descarregar gratuitamente';
$string['focusbox_settingup_hosting'] = 'Alojamento';
$string['focusbox_settingup_install'] = 'Instalação';
$string['focusbox_settingup_own'] = 'Por si próprio';
$string['focusbox_settingup_partner'] = 'Via parceiro Moodle';
$string['focusbox_settingup_plugins'] = 'Módulos';
$string['focusbox_settingup_support'] = 'Suporte comercial';
$string['focusbox_teaching'] = 'Ensinar com o Moodle';
$string['focusbox_teaching_books'] = 'Livros';
$string['focusbox_teaching_courses'] = 'Disciplinas e conteúdos';
$string['focusbox_teaching_docs'] = 'Documentação';
$string['focusbox_teaching_text'] = 'Explore a ampla variedade de funcionalidades e recursos disponíveis no Moodle.';
$string['focusbox_theproject'] = 'O projeto Moodle';
$string['focusbox_theproject_about'] = 'Acerca do Moodle';
$string['focusbox_theproject_devs'] = 'Programadores';
$string['focusbox_theproject_hq'] = 'Moodle HQ';
$string['focusbox_theproject_partners'] = 'Parceiros Moodle';
$string['focusbox_theproject_stats'] = 'Estatísticas';
$string['focusbox_theproject_text'] = 'Saiba mais sobre o projeto Moodle e as nossas parcerias abertas e colaborativas.';
$string['focusbox_uptodate'] = 'Manter-se atualizado';
$string['focusbox_uptodate_buzz'] = 'Moodle buzz';
$string['focusbox_uptodate_news'] = 'Anúncios';
$string['focusbox_uptodate_planet'] = 'Planeta Moodle';
$string['focusbox_uptodate_security'] = 'Anúncios sobre segurança';
$string['focusbox_uptodate_social'] = 'Redes sociais';
$string['focusbox_uptodate_text'] = 'Últimas novidades, atualizações e informações do Moodle em todo o mundo.';
$string['frontpagewelcome1'] = 'O Moodle é um Sistema de Gestão de Disciplinas  (CMS), também conhecido como Sistema de Gestão da Aprendizagem (LMS) ou Ambiente Virtual de Aprendizagem (AVA). Trata-se de uma aplicação Web livre que os educadores podem utilizar na criação de sítios de aprendizagem eficazes.';
$string['frontpagewelcome2'] = 'Moodle.org é o nosso sítio da comunidade Moodle, onde é feito e discutido. Por favor, use os menus para explorar e participar!';
$string['frontpagewelcometitle'] = 'Bem-vindo à comunidade Moodle!';
$string['generaldeveloperforum'] = 'Fórum geral de programadores';
$string['graphpopulation'] = 'Gráfico populacional do Moodle';
$string['graphregistrationmap'] = 'Mapa de registos do Moodle';
$string['graphregistrationmapdesc'] = 'Os primeiros 10 dos sites registados em {$a} países';
$string['graphusersites'] = 'Comparação de sites Moodle por utilizadores';
$string['heroslide_community_description'] = 'Bem-vindo à comunidade Moodle e descubra o valor de um esforço aberto e colaborativo de uma das maiores equipas de código aberto do mundo.';
$string['heroslide_community_headline'] = 'Impulsionado pela comunidade, com suporte global';
$string['heroslide_community_slidecontrol'] = 'Suportado por uma comunidade global';
$string['heroslide_donate_headline'] = 'Ajude-nos a fazer a diferença com educação aberta e de qualidade para todos';
$string['heroslide_getstarted_description'] = 'O Moodle é o sistema de gestão da aprendizagem mais popular do mundo. Comece a criar o seu site de aprendizagem online em minutos!';
$string['heroslide_getstarted_headline'] = 'Começar é fácil';
$string['heroslide_getstarted_slidecontrol'] = 'Começar hoje';
$string['heroslide_global_description'] = 'Disponível em mais de 100 idiomas, o Moodle é confiado por organizações e instituições, pequenas e grandes, com milhões de utilizadores em todo o mundo.';
$string['heroslide_global_headline'] = 'Potenciamos ambientes de aprendizagem em todo o mundo';
$string['heroslide_global_slidecontrol'] = 'Potenciamos ambientes de aprendizagem em todo o mundo';
$string['heroslide_link_demo'] = 'Demonstração';
$string['heroslide_link_donate'] = 'Donativo';
$string['heroslide_link_features'] = 'Funcionalidades';
$string['heroslide_link_forums'] = 'Fóruns da comunidade';
$string['heroslide_link_getstarted'] = 'Começar hoje';
$string['heroslide_link_sites'] = 'Sites registados';
$string['heroslide_link_stats'] = 'Estatísticas';
$string['heroslide_link_stories'] = 'Ler mais';
$string['heroslide_power_description'] = 'A plataforma mundial gratuita de aprendizagem que ajuda a criar experiências eficazes de ensino e aprendizagem online num ambiente colaborativo e privado.';
$string['heroslide_power_headline'] = 'Poderoso. Seguro. Código aberto.';
$string['heroslide_power_slidecontrol'] = 'Plataforma de aprendizagem com código aberto robusto';
$string['heroslide_story1_description'] = '“Acompanhar a aprendizagem com tecnologia apropriada permite-nos facilitar a descoberta, a criatividade e a oportunidade do aluno.” - Professor Darrell Evans, Vice-Chanceler Pro (Learning and Teaching), Monash University';
$string['heroslide_story1_headline'] = 'Melhorando o ensino e a aprendizagem em todos os lugares';
$string['heroslide_story2_description'] = 'Transporte global, logística e serviços marítimos, a GAC, oferece iniciativas de aprendizagem e desenvolvimento a mais de 10.000 funcionários em mais de 70 países na sua Corporate Academy.';
$string['heroslide_story2_headline'] = 'Atingir a excelência da aprendizagem na empresa';
$string['heroslide_story3_description'] = 'A Forth Valley College é uma das maiores faculdades da Escócia, que oferece mais de 750 cursos com mais de 20.000 utilizadores ativos nos seus sites.';
$string['heroslide_story3_headline'] = 'Oferecer educação flexível e abrangente';
$string['heroslide_story4_description'] = 'O Voluntary Service Overseas (VSO) oferece aprendizagem interativa e apoio a voluntários a nível internacional para permitir abordagens de formação global.';
$string['heroslide_story4_headline'] = 'Ajudar voluntários a oferecer programas para combater a pobreza';
$string['heroslide_story_slidecontrol'] = 'Histórias do Moodle de todo o mundo';
$string['jobs'] = 'Visite a nossa base de dados de empregos para mais informações sobre as oportunidades de empregos relacionados com o Moodle em todo o mundo.';
$string['logoinfo'] = 'O nome Moodle™ é uma marca registada da Moodle Trust.

Se pretende usar o nome e/ou o logótipo para anunciar serviços genéricos do Moodle (por exemplo, alojamento Moodle, suporte Moodle, certificação Moodle, formação Moodle, consultoria Moodle, personalização do Moodle, desenvolvimento de material didático para o Moodle, criação de temas Moodle, integrações Moodle, instalações do Moodle, etc.) ou como o nome de um pacote de software, deve procurar e obter permissão direta por escrito da Moodle Trust através do [helpdesk moodle.com] (http://moodle.com/helpdesk/), de acordo com com as restrições normais de marca comercial.

Não existem restrições sobre como usa o nome noutros contextos (por exemplo, se usa o Moodle apenas para formação/ensino, pode usar o nome livremente para se referir a ele). Se não tem a certeza de um caso específico, por favor pergunte-nos através do [helpdesk moodle.com] (http://moodle.com/helpdesk/). Teremos o maior prazer em fornecer-lhe a permissão oficial por escrito ou ajudá-lo a corrigir a sua redação.';
$string['logotitle'] = 'Logótipo Moodle';
$string['manageads'] = 'Gerir publicidade de parceiros';
$string['managedonations'] = 'Gerir donativos';
$string['moodledocs'] = 'Moodle Docs';
$string['moodleorg:manageads'] = 'Gerir publicidade de parceiros';
$string['moodleorg:managedonations'] = 'Gerir o registo dos donativos';
$string['moodlepartner_corporate'] = 'Formação nas empresas';
$string['moodlepartner_other'] = 'Outros setores';
$string['moodlepartner_school'] = 'Escola';
$string['moodlepartner_university'] = 'Universidade';
$string['mycoursesintro'] = 'Atualmente está inscrito nas seguintes "disciplinas" neste sítio da comunidade, cada uma com um ou mais fóruns.';
$string['nameabout'] = 'Sobre';
$string['nameaboutmoodle'] = 'Sobre o Moodle';
$string['namecommercial'] = 'Serviços comerciais';
$string['namecommunity'] = 'Comunidade';
$string['namecontact'] = 'Contato';
$string['namedevelopment'] = 'Desenvolvimento';
$string['namedocumentation'] = 'Documentação';
$string['namedownloads'] = 'Downloads';
$string['nameevents'] = 'Eventos';
$string['nameforums'] = 'Fóruns';
$string['namemycourses'] = 'As minhas disciplinas';
$string['namenetwork'] = 'Sítios conectados';
$string['namenews'] = 'Notícias';
$string['namesecurity'] = 'Notícias de segurança';
$string['namesupport'] = 'Suporte';
$string['networkinfo'] = 'Os seguintes sites Moodle foram ligados a moodle.org usando a rede Moodle, para que possa autenticar-se diretamente a partir daqui.';
$string['networkintro'] = 'Os seguintes sítios Moodle foram ligados à rede moodle.org usando o Moodle Networking, para permitir-lhe entrar diretamente a partir de este sítio.';
$string['networktitle'] = 'Sites ligados';
$string['newregistrations'] = 'Novos registos';
$string['newstitle'] = 'Anúncios';
$string['noenrolledcoursesyet'] = 'Ainda não está inscrito em nenhuma disciplina deste site.';
$string['partnerslogan'] = 'O Projeto Moodle é suportado por mais de 90 <a href="https://moodle.com/partners/">Parceiros Moodle</a> certificados espalhados pelo mundo inteiro.';
$string['permalink'] = 'Hiperligação permanente';
$string['pluginname'] = 'Site moodle.org';
$string['popularissues'] = 'Questões mais populares';
$string['privacy:metadata:db:registerdonations'] = 'Mantém os registos dos donativos para o Moodle';
$string['privacy:metadata:db:registerdonations:amount'] = 'Valor do donativo';
$string['privacy:metadata:db:registerdonations:name'] = 'Nome do doador';
$string['privacy:metadata:db:registerdonations:org'] = 'Organização doadora';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Data/hora do donativo';
$string['privacy:metadata:db:registerdonations:url'] = 'URL do doador';
$string['recentlyratedposts'] = 'Mensagens avaliadas recentemente';
$string['recentpart'] = 'Esta página mostra algumas das pessoas que estão a usar atualmente o moodle.org.';
$string['registeredsites'] = 'As instituições não são obrigadas a informar quando utilizam o Moodle, já que o Moodle é código aberto. No entanto, alguns sites Moodle optaram por registar-se e constam da nossa lista.';
$string['registeredsitestitle'] = 'Sites registados';
$string['registereduserslastday'] = 'Novos utilizadores nas últimas 24 horas:';
$string['registereduserstotal'] = 'Total de utilizadores registados:';
$string['registrationgraphalt'] = 'Todos os registos do Moodle ao longo do tempo';
$string['registrationgraphdesc'] = 'Realizamos regularmente uma <a href="http://docs.moodle.org/en/Usage">verificação dos sites</a> para conferir que ainda estão ativos. Por isso, poderá acontecer flutuações na contagem.';
$string['registrationslast6months'] = 'Registos nos últimos 6 meses';
$string['registrationslastmonths'] = 'Registos nos últimos {$a} meses';
$string['registrationstotal'] = 'Todos os registos atuais';
$string['resources_buzz'] = 'Buzz';
$string['resources_courses'] = 'Disciplinas';
$string['resources_jobs'] = 'Empregos';
$string['resources_plugins'] = 'Módulos';
$string['roadmap'] = 'Roteiro do Moodle';
$string['rssdescription'] = 'Mensagens recentes ou com classificação de útil no fórum Moodle.org';
$string['rsstitle'] = 'Mensagens no fórum Moodle.org';
$string['searchmoodleorg'] = 'Pesquisar em moodle.org';
$string['securitytitle'] = 'Anúncios sobre segurança';
$string['shop'] = 'Procura alguma forma de mostrar que faz parte da nossa comunidade? Visite a loja onde pode encontrar vestuário, canecas e todos os tipos de lembranças.';
$string['social-facebook-moodle'] = 'Página oficial do Moodle no Facebook';
$string['social-googleplus-community'] = 'Página oficial da comunidade Moodle no Google+';
$string['social-googleplus-moodle'] = 'Página oficial do Moodle no Google+';
$string['social-linkedin-moodle'] = 'Página oficial do Moodle no LinkedIn';
$string['social-twitter-moodle'] = 'Anúncios oficiais do Moodle, notícias agregadas do Planeta Moodle e do Moodle buzz e mensagens úteis no fórum';
$string['social-twitter-moodledev'] = 'Notícias e atualizações do desenvolvimento do Moodle';
$string['social-twitter-moodlehq'] = 'Tweets do Moodle HQ';
$string['social-twitter-moodlejobs'] = 'Oferta de empregos relacionados com o Moodle';
$string['social-twitter-moodlenet'] = 'Disciplinas e conteúdos partilhados do Moodle';
$string['social-twitter-moodleplugins'] = 'Módulos do Moodle lançados recentemente';
$string['social-twitter-moodleresearch'] = 'Notícias e atualizações sobre a Conferência anual de pesquisa do Moodle e pesquisas relacionadas com o Moodle';
$string['social-twitter-moodlesecurity'] = 'Anúncios sobre segurança do Moodle';
$string['social-twitter-moodlesites'] = 'Atualizações do estado da rede de sites e serviços do Moodle HQ';
$string['social-twitter-moodlethemes'] = 'Temas Moodle lançados recentemente';
$string['social-youtube-moodle'] = 'Página oficial do Moodle no Youtube';
$string['socialinfo'] = 'Estamos em várias redes sociais para ajudar a aumentar a consciencialização sobre o projeto Moodle e partilhar as últimas notícias e acontecimentos no mundo Moodle. Siga-nos para manter-se atualizado e conhecer outras pessoas da comunidade!';
$string['socialtitle'] = 'Redes sociais';
$string['statscountries'] = 'Países';
$string['statscourses'] = 'Disciplinas';
$string['statsenrolments'] = 'Inscrições';
$string['statsposts'] = 'Mensagens no fórum';
$string['statsquestions'] = 'Perguntas em testes';
$string['statsresources'] = 'Recursos';
$string['statsteachers'] = 'Professores';
$string['statsusers'] = 'Utilizadores';
$string['supportbooks'] = 'Existe uma lista de livros sobre o Moodle disponíveis para compra.';
$string['supportcommercial'] = 'Os Parceiros Moodle são fornecedores certificados de serviços em todo o mundo que podem ajudá-lo na implementação do seu Moodle.';
$string['supportdocs1'] = 'A documentação Moodle é um ótimo lugar para começar, especialmente as páginas de Perguntas Mais Frequentes (FAQ).';
$string['supportdocs2'] = 'Um bom modo de ter acesso à documentação relevante é usar a hiperligação "Ajuda e documentação" no rodapé de cada página do seu site Moodle.';
$string['supportdocsfaq'] = 'Perguntas Mais Frequentes';
$string['supportdocslang'] = 'Documentação Moodle em outros idiomas';
$string['supportforums'] = 'A nossa comunidade de utilizadores comunica principalmente através de fóruns nas "disciplinas" disponíveis neste site baseado no Moodle. É necessário "inscrever-se" na disciplina para publicar mensagens nos fóruns (a inscrição é totalmente gratuita).';
$string['supportforumsenglish'] = 'As discussões principais dos programadores e o suporte a outros utilizadores estão aqui (em inglês):';
$string['supportforumsenglishname'] = 'Utilização do Moodle';
$string['supportforumslang'] = 'O fórum principal para os utilizadores do Moodle interagirem está aqui (em inglês):';
$string['supportforumslangname'] = 'Moodle Lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Existem muitos outros fóruns em vários idiomas:';
$string['supportforumslistname'] = 'Lista de todos os fóruns';
$string['supportintro'] = 'Não está sozinho! Há muitas maneiras de receber ajuda com o Moodle, caso venha a precisar.';
$string['syncregistrationstask'] = 'Sincronizar as atualizações do registo de site 1.9 com o moodle.net';
$string['top10countriesbyregistration'] = 'Primeiros 10 sites por registos';
$string['top10sitesbycourses'] = 'Primeiros 10 sites por disciplinas';
$string['top10sitesbyusers'] = 'Primeiros 10 sites por utilizadores';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'Versões usadas';
