<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'es_mx', version '3.9'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutdemosite'] = 'Nuestros sitios de demostración le permiten explorar Moodle  como un profesor, estudiante o incluso como administrador. No se preocupe por estropear algo, los sitios completos se vacían y reinician cada hora.';
$string['aboutdemositetitle'] = 'Sitios de demostración';
$string['aboutintro'] = 'Moodle es un Sistema de Gestión de Cursos de Código Abierto (<i>Open Source Course Management System, CMS</i>), conocido también como Sistema de Gestión del Aprendizaje (<i>Learning Management System, LMS</i>) o como Entorno de Aprendizaje Virtual (<i>Virtual Learning Environment, VLE</i>).  Es muy popular entre los educadores de todo el mundo como una herramienta para crear sitios web dinámicos en línea para sus estudiantes. Para utilizarlo, necesita ser instalado en un servidor web, puede ser instalado tanto en una computadora personal como en un servidor proporcionado por una compañía de hospedaje de páginas web.';
$string['aboutoverview'] = '<p>El objetivo del proyecto Moodle es siempre facilitar a los educadores las mejores herramientas para gestionar y promover el aprendizaje, pero hay muchas formas de utilizar Moodle:</p>
<ul>
<li>Moodle dispone de características que le permiten escalar a grandes despliegues con cientos de miles de estudiantes, pero también puede ser utilizado en escuelas de educación infantil y primaria.</li>
<li>Muchas instituciones lo utilizan como su plataforma para formación en línea mientras que otras lo utilizan como apoyo a la formación presencial (conocida como blended learning en inglés).</li>
<li>A muchos de nuestros usuarios les encanta utilizar los módulos de actividad (como los foros, bases de datos o wikis) para construir ricas comunidades colaborativas de aprendizaje alrededor de una materia (en la tradición del constructivismo social), mientras que otros prefieren utilizar Moodle como una forma de ofrecer contenidos a sus estudiantes (utilizando por ejemplo paquetes SCORM) y realizar evaluaciones utilizando tareas o exámenes.</li>
</ul>';
$string['aboutoverviewtitle'] = '¿Qué es Moodle?';
$string['aboutstatistics'] = 'Moodle se puede descargar libremente y su registro es voluntario, de manera que no disponemos de la información completa de quién lo está utilizando. Sin embargo, con la información de que disponemos, generamos automáticamente algunas gráficas y datos numéricos interesantes en nuestra página de Estadísticas.';
$string['aboutstatisticsheading'] = 'Estadísticas de Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org: Estadísticas de Moodle';
$string['activeusers24hours'] = 'Usuarios registrados que han accesado en las últimas 24 horas:';
$string['activeuserspastmonth'] = 'Usuarios registrados que han accesado en el último mes:';
$string['browsegittitle'] = 'Vea nuestro código fuente';
$string['cachedef_frontpagecolumn'] = 'Columnas de portada';
$string['cachedef_usefulposts'] = 'Publicaciones útiles';
$string['communities'] = 'Comunidades';
$string['communitiesmy'] = 'Mis comunidades';
$string['community'] = 'Comunidad';
$string['communityadministration'] = 'Administración de comunidad';
$string['communitycurrent'] = 'Comunidad actual';
$string['communityenrolme'] = 'Volverse miembro de esta comunidad';
$string['communityenrolmentoptions'] = 'Unirse a comunidad';
$string['communityintro'] = 'Moodle tiene una gran y diversa comunidad de usuarios con más de <a href="http://moodle.org/userpics">{$a->usercount} usuarios registrados</a> sólamente en este sitio Moodle, hablando más de <a href="http://download.moodle.org/lang16/">{$a->langcount} idiomas</a> en <a href="http://moodle.org/sites">{$a->countrycount} países</a> (disponemos de <a href="http://moodle.org/stats">más estadísticas</a>).';
$string['communityjoinbyyourself'] = 'Unirse Usted mismo';
$string['communityjoinbyyourselfas'] = 'Unirse Usted mismo como {$a->rolename}';
$string['communitynoguestaccess'] = 'Los invitados no pueden acceder a esta área de la comunidad; por favor, trate de ingresar.';
$string['communitynotenrollable'] = 'Usted mismo no puede volverse miembro de esta comunidad. Por favor, contacte al facilitador de la comunidad.';
$string['communitysomeallowguest'] = 'Algunas comunidades pueden permitir el acceso de invitados';
$string['communityunenrolme'] = 'Abandonar la comunidad {$a}';
$string['conferencecenter'] = 'Centro de Conferencias Moodle';
$string['connectedsites'] = 'Algunos sitios Moodle han sido conectados con moodle.org usando la Red Moodle (Moodle Networking), de manera que puede acceder a dichos sitios directamente una vez que se haya autenticado aquí.';
$string['contactbugs'] = 'Puede reportar sus problemas con el programa Moodle o en cualquier sitio de moodle.org creando una nueva entrada en el Moodle Tracker.';
$string['contactbugstitle'] = 'Informar sobre errores';
$string['contactintro'] = 'Por favor, escoja entre las siguientes opciones de contacto:';
$string['contactlogin'] = 'Para otras consultas, acceda a este sitio y use el formato de contacto que aparecerá en esta página.';
$string['contactmoodlecom'] = 'Para cualquier consulta relativa a la licencia, marca comercial o asuntos comerciales, así como grandes desarrollos sobre Moodle, por favor contactar con el servicio de ayuda en <a href="http://moodle.com/">Moodle.com</a>';
$string['contactmoodlecomhelpdesk'] = 'Para cualquier consulta relativa a la licencia, marca comercial o asuntos comerciales, así como grandes desarrollos sobre Moodle, por favor contactar con el servicio de ayuda en <a href="http://moodle.com/">Moodle.com</a>';
$string['contactmoodlecomtitle'] = 'Moodle.com';
$string['contactmoodleorgemail'] = 'Si tiene problemas con la confirmación de su cuenta en moodle.org, enviar un correo electrónico a esta dirección:';
$string['contactmoodleorglogin'] = 'Entrar a este sitio ahora';
$string['contactmoodleorgother'] = 'Para otro tipo de consultas, utilice el formato de contacto situado en la parte inferior de la página.';
$string['contactmoodleorgtitle'] = 'Moodle.org';
$string['contactsecurity'] = 'También puede informar de asuntos de seguridad mediante el Tracker, siempre que el nivel de seguridad configurado sea adecuado.';
$string['contactsent'] = 'Su mensaje se envió por correo electrónico al Gestor de la Comunidad Moodle.';
$string['contactsupport'] = 'Si desea obtener soporte para utilizar Moodle, por favor visite la página de Soporte donde encontrará disponibles muchos recursos de ayuda.';
$string['contactsupporttitle'] = 'Soporte';
$string['demomoodlenet'] = 'Sitio de demostración';
$string['developercredits'] = 'Créditos de desarrolladores';
$string['developerlist'] = 'Listado completo de desarrolladores con acceso de escritura';
$string['developermeetings'] = 'Encuentros de desarrolladores';
$string['developers'] = 'El desarrollo principal de Moodle es lidereado por el equipo del núcleo de Moodle.com y ayudado por cientos de otros desarrolladores en todo el mundo.  Muchos de esos desarrolladores son también responsables directos de diferentes módulos y plugins.';
$string['developerstitle'] = 'Desarrolladores';
$string['developmentdocs'] = 'La mayor parte de nuestra documentación está en Moodle Docs - incluyendo especificaciones, lluvia de ideas, procedimientos,  estándares y guías de usuario.';
$string['developmentdocstitle'] = 'Documentación para desarrolladores';
$string['developmentintro'] = 'Moodle se plantea como un proceso de desarrollo abierto y transparente que invita a toda la comunidad de usuarios a participar. Naturalmente damos la bienvenida a desarrolladores en PHP pero también puede contribuir mediante los debates en los foros, probando la aplicación, dándonos su opinión y documentando.';
$string['developmenttracker'] = 'Todos los temas sobre desarrollo, fallos, mejoras y nuevas funcionalidades las registramos en el Tracker de Moodle. Puede ver quién está trabajando y contribuir a las conversaciones. Si está buscando algo sobre un tema específico, debería mirar en primer lugar en el tracker y, por favor, no olvide <strong>votar</strong> en los temas que le gustaría ver resueltos lo antes posible: su voto determina las prioridades a la hora de resolver los temas.';
$string['donations'] = 'Moodle está completamente libre de obligaciones financieras; Sin embargo, muchos miembros de la comunidad han donado algo a nuestro proyecto para ayudar a pagar a los desarrolladores que lo hacen posible.';
$string['donations10over'] = 'Otros donativos de $10 o más';
$string['donationsassociation'] = 'Únase a <a href="https://moodleassociation.org/">Moodle Association</a> - Ayude a decidir como deberían gastarse las cuotas de membresía em los asuntos del Mapa de desarrollo de Moodle';
$string['donationsdevelopment'] = 'Sin embargo, el desarrollo de Moodle y el mantenimiento de todos nuestros sitios comunitarios si nos cuesta mucho dinero y siempre podríamos utilizar más apoyo. Si Usted ama Moodle o lo ha encontrado útil para su negocio, escuela o institución, por favor haga un donativo. Cada peso ayuda.';
$string['donationsdonatenow'] = 'Donar ahora';
$string['donationsensure'] = 'Los donativos aseguran que los engranes esenciales de la Maquinaria Moodle (nuestros desarrolladores) continúen creando nuevas características y composturas de problemas, haciendo a Moodle mejor para todos nosotros.';
$string['donationsmoney'] = 'Puede contribuir con dinero directamente al fondo a través de una donación en efectivo. Todo este dinero se utiliza para convertir los deseos de nuestro plan de desarrollo en características reales que todos podamos usar. Para hacer una donación con tarjeta de crédito en la mayoría de las principales monedas, por favor haga clic en el botón inferior de Paypal. <br /> <br /> Los donantes de más de $10 (dólares) añadirán su nombre a esta página durante un año. Por favor, recuerde pulsar el botón "Continuar" después de pagar, para ver el formato donde podrá editar la manera en que aparecerá su donativo.';
$string['donationsmoodle'] = 'Donar a Moodle';
$string['donationsopensource'] = 'Moodle es auténtico código abierto y completamente gratis  y libre de obligaciones financieras para nuestros usuarios - ¡así debería de ser el software!';
$string['donationsover1000'] = 'Donativos anteriores mayores de $1000';
$string['donationsover200'] = 'Otros donativos mayores de $200';
$string['donationsover500'] = 'Otros donativos mayores de $500';
$string['donationspartner'] = 'Use un <a href="https://moodle.com/partners/">Socio Moodle certificado</a> para servicios -10% de sus ingresos son contribuidos al proyecto Moodle..';
$string['donationsservices'] = 'Si usted tiene necesidad de servicios de Moodle, tales como como alojamiento (hosting), soporte, instalación, programación personalizada, desarrollo de cursos o asesoría, por favor contacte con su distribuidor autorizado <a href="http://moodle.com/"> Moodle Partner de moodle.com </ a> (puede encontrar sus anuncios publicitarios en este sitio). Los socios aportan un porcentaje fijo de todos sus ingresos para el fondo fiduciario de desarrollo de Moodle, por lo que todo el mundo gana.';
$string['donationsshop'] = 'Compre algo en nuestra <a href="http://www.zazzle.com/moodle_hq/">Tienda Moodle </a> y ¡úselo con orgullo!';
$string['donationsthankeveryone'] = 'Gracias a todos los que han contribuido al proyecto Moodle.';
$string['donationsthankyou'] = 'Gracias';
$string['donationstitle'] = 'Donativos';
$string['donationstrust'] = 'Moodle tiene un fondo de desarrollo mantenido por el fideicomiso Moodle, que contrata a programadores para trabajar en Moodle, y sufraga asimismo gastos como moodle.org.';
$string['donationsways'] = 'Otras formas de contribuir financieramente a Moodle:';
$string['download_activities'] = 'Actividades';
$string['download_admintools'] = 'Herramientas administrativas';
$string['download_appdocumentation'] = 'Documentación de la App';
$string['download_appreleasenotes'] = 'Notas de la versión';
$string['download_browseall'] = 'Mirar todo';
$string['download_downloadosx'] = 'Descargar Moodle para OS X (Contiene Moodle, Apache, MySQL y PHP para ejecutar en Mac OS)';
$string['download_downloadwindows'] = 'Descargar Moodle para Windows (Contiene Moodle, Apache, MySQL y PHP para ejecutar en Sistema Operativo Windows)';
$string['download_forandroid'] = 'Para Androide';
$string['download_forios'] = 'Para iOS';
$string['download_helpbox_description'] = 'Lea la documentación para comenzar y visite nuestros foros comunitarios, o simplemente póngase en contacto con un Socio Moodle para alojamiento, instalación y otros servicios.';
$string['download_helpbox_installing'] = 'Instalando Moodle';
$string['download_helpbox_partners'] = 'Socios Moodle';
$string['download_helpbox_support'] = 'Foros de soporte';
$string['download_helpbox_title'] = '¿Necesita ayuda?';
$string['download_helpbox_upgrading'] = 'Actualizando Moodle';
$string['download_hero_description'] = 'Está bajo la <a class="link" href="http://docs.moodle.org/dev/License">licencia GPL-</a>, lo que significa que todos están licenciados libremente para usar y disfrutar los beneficios de nuestro software.<br><br>Revise nuestra más reciente versión de Moodle.';
$string['download_hero_headline'] = 'Moodle es código abierto';
$string['download_langpackinfo'] = 'Los paquetes de idioma son generados automáticamente a partir del trabajo de traductores en el  <a href="http://lang.moodle.org/">Sitio de traducción</a>Para más detalles, vea la documentación en inglés para desarrolladores en <a href="https://docs.moodle.org/dev/Translation">Translation documentation</a>.';
$string['download_langpackinstallinfo'] = 'Se pueden instalar paquetes adicionales de idioma en su sitio Moodle via <em>Administración > Administración del sitio > Idioma > Paquetes de idioma</em>, o manualmente. Para más detalles, vea la   <a href="https://docs.moodle.org/all/es/Paquetes_de_idioma">Documentación sobre paquetes de idioma</a>.';
$string['download_langpackinstalltitle'] = 'Instalación de paquetes de idioma';
$string['download_langpacktitle'] = 'Paquetes de idioma para Moodle {$a}';
$string['download_mobileapp'] = 'App Mobile';
$string['download_themes'] = 'Temas';
$string['download_viewallbuilds'] = 'Ver todas las versiones (Requiere un servidor web, PHP y base de datos para ejecutarse)';
$string['downloadcore'] = 'Nuestro principal método de distribución es a través de estos paquetes estándar con la distribución base. Contienen un conjunto de módulos que son mantenidos por los desarrolladores de Moodle, y son adecuados para ser utilizados en cualquier plataforma donde tenga instalados PHP y una base de datos.';
$string['downloadcoretitle'] = 'Paquetes estándar de Moodle';
$string['downloadintro'] = 'Moodle es código abierto bajo <a href="http://docs.moodle.org/dev/License">licencia GPL</a>. Todo lo que creamos se puede descargar y utilizar gratuita y libremente.';
$string['downloadlang'] = 'En las versiones actuales de Moodle se ha automatizado la adición de paquetes de idiomas desde el menú de administración del sitio. Sin embargo, para  algunas versiones antiguas de Moodle, los paquetes de idioma se pueden descargar de forma manual.';
$string['downloadlangtitle'] = 'Paquetes de idioma';
$string['downloadlogotitle'] = 'Logos de Moodle';
$string['downloadmac'] = 'Si aún no dispone de un servidor web, estos paquetes con todo incluido le ayudarán a instalar de forma fácil Moodle en cualquier computadora con Mac OS X.';
$string['downloadmactitle'] = 'Moodle para Mac OS X';
$string['downloadmodules'] = 'Navegue por nuestra base de datos de módulos y plugins extra que pueden ser instalados en su sitio Moodle, para dotarlo de funcionalidades extras más allá de las incluidas en la distribución base de Moodle.';
$string['downloadmodulestitle'] = 'Plugins';
$string['downloadthemes'] = 'El aspecto visual de Moodle puede cambiar notablemente en función del tema gráfico. Mantenemos una base de datos de temas creados y compartidos por usuarios de Moodle.';
$string['downloadthemestitle'] = 'Temas';
$string['downloadviagit'] = 'Usted también puede descargar Moodle <a href="http://docs.moodle.org/en/Git_for_Administrators">con Git</a>.';
$string['downloadviagitcvs'] = 'Otras formas de obtener Moodle incluyen <a href="http://docs.moodle.org/all/es/Git_para_Administradores">descarga mediante Git</a> o <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">descarga mediante CVS</a>.';
$string['downloadwin'] = 'Si aún no dispone de un servidor web, estos paquetes con todo incluido le ayudarán a instalar de forma fácil Moodle en cualquier computadora con Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle para Windows';
$string['erroradminonly'] = 'Únicamente los administradores pueden acceder a esta interfaz.';
$string['erroralreadyvoted'] = 'Usted ya ha votado por {$a}';
$string['errormaxmessages'] = 'Lo sentimos, pero no puede enviar más de 3 mensajes.';
$string['errornomainnews'] = 'No se ha podido encontrar o crear un foro principal de noticias en el sitio';
$string['errorsendingmail'] = 'Ha ocurrido un error al enviar el mensaje. Por favor, inténtelo de nuevo más tarde, o contacte con el administrador del sitio.';
$string['eventdonation_created'] = 'Listado de donativo creado';
$string['eventdonation_submitted'] = 'Donativo enviado';
$string['events'] = 'Aunque estamos especializados en la enseñanza en línea, ¡siempre es bueno verse todos juntos en persona!. Visite estos enlaces para más información sobre nuestras conferencias (las llamamos MoodleMoots) y otros eventos.';
$string['eventstitle'] = 'Eventos';
$string['feed_events'] = 'Eventos';
$string['feed_events_more'] = 'Más entradas de calendario';
$string['feed_news'] = 'Anuncios';
$string['feed_news_more'] = 'Ver todos los anuncios';
$string['feed_resources'] = 'Recursos';
$string['feed_useful'] = 'Publicaciones útiles';
$string['feed_useful_more'] = 'Más publicaciones';
$string['focusbox_community'] = 'Soporte y foros comunitarios';
$string['focusbox_community_text'] = 'Obtenga soporte y comparta ideas, en su propio idioma.';
$string['focusbox_community_viewall'] = 'Todas las comunidades';
$string['focusbox_future'] = 'Ayude a darle forma al futuro de Moodle';
$string['focusbox_future_crowdfund'] = 'Proyectos financiados por la comunidad';
$string['focusbox_future_gdf'] = 'Discusiones de desarrolladores';
$string['focusbox_future_research'] = 'Investigación Moodle';
$string['focusbox_future_roadmap'] = 'Plan de desarrollo';
$string['focusbox_future_text'] = 'Encuentre lo qué sigue y ayude a marcar una diferencia.';
$string['focusbox_settingup'] = 'Configuración';
$string['focusbox_settingup_community'] = 'Soporte comunitario';
$string['focusbox_settingup_download'] = 'Descarga gratuita';
$string['focusbox_settingup_hosting'] = 'Alojamiento';
$string['focusbox_settingup_install'] = 'Instalación';
$string['focusbox_settingup_own'] = 'Por Usted mismo';
$string['focusbox_settingup_partner'] = 'Con un Moodle Partner';
$string['focusbox_settingup_plugins'] = 'Plugins';
$string['focusbox_settingup_support'] = 'Soporte comercial';
$string['focusbox_teaching'] = 'Enseñanza con Moodle';
$string['focusbox_teaching_books'] = 'Libros';
$string['focusbox_teaching_courses'] = 'Cursos y contenido';
$string['focusbox_teaching_docs'] = 'Documentación';
$string['focusbox_teaching_text'] = 'Explore el gran rango de características y recursos disponibles.';
$string['focusbox_theproject'] = 'El proyecto Moodle';
$string['focusbox_theproject_about'] = 'Acerca de Moodle';
$string['focusbox_theproject_devs'] = 'Desarrolladores';
$string['focusbox_theproject_hq'] = 'Cuartel General Moodle';
$string['focusbox_theproject_partners'] = 'Moodle Partners';
$string['focusbox_theproject_stats'] = 'Estadísticas';
$string['focusbox_theproject_text'] = 'Aprenda más sobre el proyecto Moodle y nuestras sociedades colaborativas abiertas.';
$string['focusbox_uptodate'] = 'Manténgase actualizado';
$string['focusbox_uptodate_buzz'] = 'Chismes Moodle';
$string['focusbox_uptodate_news'] = 'Anuncios';
$string['focusbox_uptodate_planet'] = 'Planeta Moodle';
$string['focusbox_uptodate_security'] = 'Avisos de seguridad';
$string['focusbox_uptodate_social'] = 'Medios sociales';
$string['focusbox_uptodate_text'] = 'Últimas noticias sobre Moodle, actualizaciones y percepciones en el mundo.';
$string['frontpagewelcome1'] = 'Moodle es un Sistema de Gestión de Cursos de Código Abierto (<i>Open Source Course Management System, CMS</i>), conocido también como Sistema de Gestión del Aprendizaje (<i>Learning Management System, LMS</i>) o como Entorno de Aprendizaje Virtual (<i>Virtual Learning Environment, VLE</i>). Es una aplicación web gratuita que los educadores pueden utilizar para crear sitios de aprendizaje efectivo en línea.';
$string['frontpagewelcome2'] = 'Moodle.org es el sitio de nuestra comunidad donde se crea y discute Moodle. Por favor, utilice los menús para explorarla y unirse a ella.';
$string['frontpagewelcometitle'] = '¡Bienvenido a la comunidad Moodle!';
$string['generaldeveloperforum'] = 'Foro general de desarrolladores';
$string['graphpopulation'] = 'Gráfico de la población de Moodle';
$string['graphregistrationmap'] = 'Mapa de registros de Moodle';
$string['graphregistrationmapdesc'] = 'Los 10 primeros entre los sitios registrados en {$a} países';
$string['graphusersites'] = 'Comparación de usuarios de Moodle y sitios';
$string['heroslide_community_description'] = 'Bienvenido a la comunidad Moodle. Descubra el valor de un esfuerzo abierto colaborativo por uno de los equipos de código abierto más grandes del mundo.';
$string['heroslide_community_headline'] = 'Impulsado por la comunidad, soportado globalmente.';
$string['heroslide_community_slidecontrol'] = 'Impulsado por una comunidad global';
$string['heroslide_donate_headline'] = 'Ayúdenos a hacer una diferencia con la educación abierta y de calidad para todos';
$string['heroslide_getstarted_description'] = 'Moodle es el sistema de gestión del aprendizaje más popular del mundo. ¡Comience a crear su sitio de aprendizaje en línea en minutos!';
$string['heroslide_getstarted_headline'] = 'Comenzar es fácil';
$string['heroslide_getstarted_slidecontrol'] = 'Comience hoy mismo';
$string['heroslide_global_description'] = 'Disponible en más de 100 idiomas, Moodle tiene la confianza de organizaciones e instituciones, grandes y pequeñas, con millones de usuarios en todo el mundo.';
$string['heroslide_global_headline'] = 'Impulsando ambientes de aprendizaje en todo el mundo';
$string['heroslide_global_slidecontrol'] = 'Impulsando ambientes de aprendizaje en todo el mundo';
$string['heroslide_link_demo'] = 'Demo';
$string['heroslide_link_donate'] = 'Haga un donativo';
$string['heroslide_link_features'] = 'Características';
$string['heroslide_link_forums'] = 'Foros comunitarios';
$string['heroslide_link_getstarted'] = 'Comience hoy mismo';
$string['heroslide_link_sites'] = 'Sitios registrados';
$string['heroslide_link_stats'] = 'Estadísticas';
$string['heroslide_link_stories'] = 'Lea más';
$string['heroslide_power_description'] = 'La plataforma para enseñanza gratuita que le ayuda a crear experiencias de aprendizaje y enseñanza en línea efectivas, en un ambiente colaborativo privado.';
$string['heroslide_power_headline'] = 'Poderoso. Seguro. Código abierto.';
$string['heroslide_power_slidecontrol'] = 'Plataforma robusta de aprendizaje de código abierto,';
$string['heroslide_story1_description'] = '“Ser líderes en el aprendizaje impulsado por tecnología nos permite facilitar el descubrimiento, creatividad y oportunidad del estudiante.” - Profesor Darrell Evans, Pro Vice-Chancellor (Enseñanza y Aprendizaje), Universidad Monash';
$string['heroslide_story1_headline'] = 'Mejorando la educación y el aprendizaje en todos lados';
$string['heroslide_story2_description'] = 'El proveedor de envíos globales, logística y servicio marino GAC le proporciona iniciativas de aprendizaje y desarrollo a más de 10000 empleados en más de 70 países con su Academia Corporativa.';
$string['heroslide_story2_headline'] = 'Logrando excelencia en el aprendizaje corporativo';
$string['heroslide_story3_description'] = 'El Colegio del Valle Forth es uno de los colegios más grandes de Escocia, proporciona más de 750 cursos con más de 20,000 usuarios activos en sus sitios.';
$string['heroslide_story3_headline'] = 'Proporcionando educación flexible para todos';
$string['heroslide_story4_description'] = 'Voluntary Service Overseas (VSO) proporciona aprendizaje interactivo y soporte para voluntarios internacionalmente para habilitar tácticas de entrenamiento global.';
$string['heroslide_story4_headline'] = 'Ayudando a voluntarios a realizar programas para luchar contra la pobreza';
$string['heroslide_story5_description'] = '';
$string['heroslide_story5_headline'] = '';
$string['heroslide_story_description'] = '"Al ser lider en el aprendizaje habilitado por  tecnología, nos permite a nosotros facilitar el descubrimiento por el estudiante, la creatividad y oportunidad."- Profesor Darrell Evans, Vicerrector (Aprendizaje y Enseñanza), Universidad Monash';
$string['heroslide_story_headline'] = 'Mejorando la enseñanza y el aprendizaje en todas partes';
$string['heroslide_story_slidecontrol'] = 'Historias de todo el mundo acerca de Moodle';
$string['jobs'] = 'Visite nuestra base de datos de trabajo para encontrar ofertas de trabajo relacionado con Moodle en todo el mundo.';
$string['logoinfo'] = 'El nombre Moodle™ es una marca registrada del Moodle Trust.

Si Usted pretende usar el nombre o el logo para anunciar servicios genéricos de Moodle (por ejemplo: alojamiento de Moodle, soporte a Moodle, certificación en Moodle, entrenamiento en Moodle, consultoría en Moodle, personalización de Moodle, desarrollo de cursos en Moodle, diseño de temas de Moodle, integraciones con Moodle, instalaciones de Moodle, etc) o como el nombre de un paquete  de software, entonces Usted debe de buscar y obtener  permiso directo por escrito del Moodle Trust mediante el [moodle.com helpdesk](http://moodle.com/helpdesk/), de acuerdo con las restricciones normales para marcas registradas.

No hay restricciones sobre cómo use Usted el nombre en otros contextos (por ejemplo: si Usted usa Moodle solamente para proporcionar cursos, entonces Usted puede usar libremente el nombre para referirse a él.) Si Usted no está seguro sobre un caso particular, por favor, pregúntenos mediante el [moodle.com helpdesk](http://moodle.com/helpdesk/). Estaremos contentos, ya sea de proporcionarle el permiso oficial por escrito o ayudarle a componer su redacción.';
$string['logotitle'] = 'Logo de Moodle';
$string['manageads'] = 'Gestionar anuncios del socio';
$string['managedonations'] = 'Gestionar donativos';
$string['moodledocs'] = 'Documentación de Moodle';
$string['moodleorg:manageads'] = 'Gestionar anuncios del socio';
$string['moodleorg:managedonations'] = 'Gestionar el registro de donativos';
$string['moodlepartner_corporate'] = 'Entrenamiento corporativo';
$string['moodlepartner_other'] = 'Otros sectores';
$string['moodlepartner_school'] = 'Escuela';
$string['moodlepartner_university'] = 'Universidad';
$string['moodlepartnersinfo'] = '<p><a href="http://moodle.com/partners/" title="Moodle.com - Partners"><img src="http://moodle.com/wp-content/themes/moodle/images/mpcsp-hor-trans.png" alt="Moodle Partner - Certified Services Provider" style="float: right;"></a><br /> Los Socios de Moodle (Moodle Partners) are Certified Service Providers worldwide that can help you with your Moodle implementation.</p> <p>They provide services such as hosting, customisation, support, training and even full management of a Moodle project.</p> <p>Partners contribute 10% of their earnings to support the development and maintenance of the Moodle project, so to help improve the Moodle software we ask that you always use certified Moodle Partners!</p>';
$string['mycoursesintro'] = 'Actualmente está inscrito en los siguientes "cursos" en este sitio de la comunidad, cada uno de ellos tiene uno o más foros.';
$string['nameabout'] = 'Acerca de';
$string['nameaboutmoodle'] = 'Acerca de Moodle';
$string['namecommercial'] = 'Servicios comerciales';
$string['namecommunity'] = 'Comunidad';
$string['namecontact'] = 'Contacto';
$string['namedevelopment'] = 'Desarrollo';
$string['namedocumentation'] = 'Documentación';
$string['namedownloads'] = 'Descargas';
$string['nameevents'] = 'Eventos';
$string['nameforums'] = 'Foros';
$string['namemycourses'] = 'Foros';
$string['namenetwork'] = 'Sitios conectados';
$string['namenews'] = 'Noticias';
$string['namesecurity'] = 'Avisos de seguridad';
$string['namesupport'] = 'Soporte';
$string['networkinfo'] = 'Los siguientes sitios Moodle hasn sido conectados a moodle.org empleando la red Moodle, por lo que Usted puede ingresar a ellos directamente desde aquí.';
$string['networkintro'] = 'Los sitios Moodle que figuran a continuación han sido conectados con moodle.org utilizando la Red Moodle, de manera que puede entrar a ellos directamente desde aquí.';
$string['networktitle'] = 'Sitios conectados';
$string['newregistrations'] = 'Nuevos registros';
$string['newstitle'] = 'Anuncios';
$string['noenrolledcoursesyet'] = 'Aún no se ha inscrito en ningún curso de este sitio';
$string['partnerslogan'] = 'El proyecto Moodle está soportado globalmente por más de 90 (Socios Moodle) .<a href="https://moodle.com/partners/">Moodle Partners</a> certificados globalmente.';
$string['permalink'] = 'Perma_enlace';
$string['pluginname'] = 'Sitio Moodle.org';
$string['popularissues'] = 'Asuntos más populares';
$string['privacy:metadata:db:registerdonations'] = 'Conservar registros de donativos a Moodle';
$string['privacy:metadata:db:registerdonations:amount'] = 'Cantidad donada';
$string['privacy:metadata:db:registerdonations:name'] = 'Nombre del donante';
$string['privacy:metadata:db:registerdonations:org'] = 'Orgnización del donante';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Sello de tiempo del donativo';
$string['privacy:metadata:db:registerdonations:url'] = 'URL del donante';
$string['recentlyratedposts'] = 'Publicaciones recientemente valuadas';
$string['recentpart'] = 'Esta página muestra algunas de las personas que están utilizando moodle.org hoy.';
$string['registeredsites'] = 'Las instituciones no están obligadas a informar a nadie cuando usan Moodle, porque Moodle es Código Abierto.  Aún así, algunos sitios Moodle han escogido registrarse con nosotros y así mantenemos un listado de ellos.';
$string['registeredsitestitle'] = 'Sitios registrados';
$string['registereduserslastday'] = 'Usuarios nuevos en las últimas 24 horas';
$string['registereduserstotal'] = 'Total de usuarios registrados';
$string['registrationgraphalt'] = 'Todos los registros de Moodle a lo largo del tiempo';
$string['registrationgraphdesc'] = 'Llevamos a cabo una <a href="http://docs.moodle.org/en/Usage">comprobación masiva regular de los sitios </a> para asegurarnos de que aún existen, por lo que en ocasiones es posible que vea reducciones en el conteo';
$string['registrationslast6months'] = 'Registros en los últimos 6 meses';
$string['registrationslastmonths'] = 'Registros en los {$a} meses anteriores';
$string['registrationstotal'] = 'Todos los registros vigentes';
$string['resources_buzz'] = 'Chismes';
$string['resources_courses'] = 'Cursos';
$string['resources_jobs'] = 'Empleos';
$string['resources_plugins'] = 'Plugins';
$string['roadmap'] = 'Mapa del desarrollo de Moodle';
$string['rssdescription'] = 'Publicaciones recientes, o valuadas como útiles, de foros de moodle.org';
$string['rsstitle'] = 'Publicaciones de foros de moodle.org';
$string['schooldemommoodlenet'] = 'Escuela Monte Naranja';
$string['searchmoodleorg'] = 'Buscar en moodle.org';
$string['securitytitle'] = 'Avisos de seguridad';
$string['shop'] = '¿Busca la forma para demostrar que forma parte de nuestra comunidad? Eche un ojo a nuestra tienda, donde encontrará camisetas, tazas y muchas otras cosas.';
$string['social-facebook-moodle'] = 'Página oficial de Moodle en Facebook';
$string['social-googleplus-community'] = 'Página oficial de comunidad Moodle en Google+';
$string['social-googleplus-moodle'] = 'Página oficial de Moodle en Google+';
$string['social-linkedin-moodle'] = 'Página oficial de Moodle en Linkedln';
$string['social-twitter-moodle'] = 'Anuncios oficiales de Moodle, novedades acumuladas del Planeta Moodle, chismes sobre Moodle y publicaciones útiles de foros';
$string['social-twitter-moodledev'] = 'Actualizaciones y noticias sobre el desarrollo de Moodle';
$string['social-twitter-moodlehq'] = 'Tweets del Cuartel General de Moodle';
$string['social-twitter-moodlejobs'] = 'Ofertas de trabajos relacionados con Moodle';
$string['social-twitter-moodlenet'] = 'Contenido y cursos compartidos de Moodle';
$string['social-twitter-moodleplugins'] = 'Complementos para Moodle recientemente liberados';
$string['social-twitter-moodleresearch'] = 'Noticias y actualizaciones sobre la Conferencia de Investigación en Moodle y sobre investigación relacionada con Moodle';
$string['social-twitter-moodlesecurity'] = 'Avisos de seguridad de Moodle';
$string['social-twitter-moodlesites'] = 'Actualizaciones de estatus para la red del Cuartel General de Moodle sobre sitios y servicios';
$string['social-twitter-moodlethemes'] = 'Temas de Moodle recientemente liberados';
$string['social-youtube-moodle'] = 'Canal oficial de Moodle en YouTube';
$string['socialinfo'] = 'Estamos en varios sitios de medios sociales para ayudar a crear conciencia sobre el proyecto Moodle y compartir las últimas noticias y acontecimientos en el mundo Moodle. ¡Síganos para permanecer actualizado y conocer otras personas en la comunidad!';
$string['socialtitle'] = 'Medios sociales';
$string['statscountries'] = 'Países';
$string['statscourses'] = 'Cursos';
$string['statsenrolments'] = 'Inscripciones';
$string['statsposts'] = 'Mensajes en foros';
$string['statsquestions'] = 'Preguntas de examen';
$string['statsresources'] = 'Recursos';
$string['statsteachers'] = 'Profesores';
$string['statsusers'] = 'Usuarios';
$string['supportbooks'] = 'Mantenemos una lista de muchos libros sobre Moodle a la venta.';
$string['supportcommercial'] = 'Los Socios de Moodle (Moodle Partners) son Prestadores de Servicio Certificados de todo el mundo, y pueden ayudarle con su implementación de Moodle.';
$string['supportdocs1'] = 'La documentación de Moodle es un buen sitio para empezar, sobre todo nuestras páginas de Preguntas Frecuentes.';
$string['supportdocs2'] = 'Una buena manera de acceder a la documentación relevante de Moodle es utilizar el enlace "Documentación de Moodle para esta página" en la parte inferior de cada página de su sitio Moodle.';
$string['supportdocsfaq'] = 'Preguntas Frecuentes';
$string['supportdocslang'] = 'Documentación Moodle en otros idiomas';
$string['supportforums'] = 'Nuestra comunidad de usuarios se comunica principalmente mediante los foros dentro de los "cursos" de este sitio Moodle.  Debe "inscribirse" en el curso para poder enviar mensajes (la inscripción es totalmente gratuita).';
$string['supportforumsenglish'] = 'Aquí la mayoría del soporte y debates entre usuarios y desarrolladores están en inglés:';
$string['supportforumsenglishname'] = 'Usando Moodle';
$string['supportforumslang'] = 'El foro de Moodle para socializar en inglés está aquí:';
$string['supportforumslangname'] = 'Sala de estar de Moodle';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'También disponemos de muchos otros foros, en muchos idiomas:';
$string['supportforumslistname'] = 'Lista de todos los cursos';
$string['supportintro'] = '¡No está solo!  Hay muchas formas de conseguir ayuda con Moodle si la necesita.';
$string['syncregistrationstask'] = 'Sincronizar actualizaciones de registro de sitio 1.9 a  moodle.net';
$string['top10countriesbyregistration'] = 'Los 10 países con más registros';
$string['top10sitesbycourses'] = 'Los 10 sitios con más cursos';
$string['top10sitesbyusers'] = 'Los 10 sitios con más usuarios';
$string['url-about'] = 'http://docs.moodle.org/all/es/Acerca_de_Moodle';
$string['url-features'] = 'http://docs.moodle.org/all/es/Características';
$string['url-install'] = 'http://docs.moodle.org/all/es/Instalación';
$string['url-standards'] = 'http://docs.moodle.org/all/es/Estándares';
$string['url-userdocs'] = 'http://docs.moodle.org/all/es/Página_Principal';
$string['versionsused'] = 'Versiones usadas';
