<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'fr', version '3.9'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Action';
$string['activityoverview'] = 'Il reste des questionnaires auxquels vous n\'avez pas encore répondu.';
$string['additionalinfo'] = 'Info supplémentaire';
$string['additionalinfo_help'] = 'Texte qui sera affiché en tête de la première page de ce questionnaire (consignes, etc.).';
$string['addnewquestion'] = 'Ajout d\'une question de type {$a}';
$string['addnewsection'] = 'Ajouter une nouvelle section';
$string['addquestion'] = 'Ajouter une question…';
$string['addquestions'] = 'Ajouter des questions';
$string['addquestiontosection'] = 'Ajouter une question à la section';
$string['addselqtype'] = 'Ajouter une question de ce type';
$string['alignment'] = 'Alignement des boutons radio';
$string['alignment_help'] = 'Par défaut les boutons radio sont disposés et alignés verticalement. Si vous avez des items relativements courts ou nombreux vous pouvez préférer les disposer horizontalement.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Tout';
$string['allnameddegrees'] = 'Degrés nommés';
$string['allnameddegrees_help'] = 'Indiquer le texte à afficher pour les valeurs de taux au lieu du nombre. Laissez une valeur vide pour ne pas utiliser.';
$string['alreadyfilled'] = 'Vous avez déjà répondu à ce questionnaire {$a}. Merci.';
$string['andaveragevalues'] = 'et moyenne des valeurs';
$string['anonymous'] = 'Anonyme';
$string['answer'] = 'Réponse';
$string['answergiven'] = 'Cette réponse étant donnée';
$string['answernotgiven'] = 'Cette réponse n\'étant pas donnée';
$string['answerquestions'] = 'Répondre aux questions';
$string['answers'] = 'Réponses';
$string['attempted'] = 'Vous avez répondu à ce questionnaire.';
$string['attemptstillinprogress'] = 'En cours. Enregistré le :';
$string['autonumbering'] = 'Numérotation automatique';
$string['autonumbering_help'] = 'Numérotation automatique des questions (et des pages). Il peut être utile de désactiver la numérotation automatique dans les questionnaires qui comportent des questions à branchement conditionnel.';
$string['autonumberno'] = 'Ne pas numéroter les questions ni les pages';
$string['autonumberpages'] = 'Numéroter automatiquement les pages';
$string['autonumberpagesandquestions'] = 'Numéroter automatiquement les pages et les questions';
$string['autonumberquestions'] = 'Numéroter automatiquement les questions';
$string['average'] = 'Moyenne';
$string['averageposition'] = 'Position moyenne';
$string['averagerank'] = 'Rang moyen';
$string['averagesrow'] = 'Moyennes (le cas échéant) :';
$string['bodytext'] = 'Corps de texte';
$string['boxesnbexact'] = 'exactement {$a} case(s).';
$string['boxesnbmax'] = 'un maximum de {$a} case(s).';
$string['boxesnbmin'] = 'un minimum de {$a} case(s).';
$string['boxesnbreq'] = 'Pour cette question vous devez cocher ';
$string['by'] = 'par';
$string['cannotviewpublicresponses'] = 'Vous n\'êtes pas autorisé à voir les réponses données à ce questionnaire « public ».';
$string['chart:bipolar'] = 'Barres bipolaires';
$string['chart:hbar'] = 'Barres horizontales';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Polaire';
$string['chart:type'] = 'Type de graphique';
$string['chart:type_help'] = 'Sélectionnez le type de graphique qui illustrera ce feedback';
$string['chart:vprogress'] = 'Barre verticale (progression)';
$string['checkallradiobuttons'] = 'Veuillez cocher un bouton radio sur <em>chaque</em> ligne !';
$string['checkboxes'] = 'Cases à cocher';
$string['checkboxes_help'] = 'Entrez une option par ligne, parmi lesquelles l\'utilisateur pourra choisir.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Nouveau(x) saut(s) de page ajouté(s) en position(s) :';
$string['checkbreaksok'] = 'Tous les sauts de page nécessaires sont présents !';
$string['checkbreaksremoved'] = 'Supprimé {$a} saut(s) de page inutile(s).';
$string['checknotstarted'] = 'Sélectionner les tentatives non commencées';
$string['checkstarted'] = 'Sélectionner les tentatives commencées';
$string['clicktoswitch'] = '(cliquez pour modifier)';
$string['closebeforeopen'] = 'Vous avez spécifié une date de fermeture antérieure à la date d\'ouverture.';
$string['closed'] = 'Questionnaire fermé le {$a}. Merci.';
$string['closedate'] = 'Autoriser les réponses jusqu\'au';
$string['closeson'] = 'Ce questionnaire est disponible jusqu\'au {$a}';
$string['completionsubmit'] = 'L\'étudiant doit soumettre ce questionnaire pour compléter l\'activité';
$string['condition'] = 'Condition';
$string['confalts'] = '- OU - <br />Page de confirmation';
$string['configemailreporting'] = 'Autoriser les rapports par courriel';
$string['configemailreportinglong'] = 'Permet à certains rapports d\'être envoyés par courriel directement aux adresses de courriel spécifiées.';
$string['configmaxsections'] = 'Sections maximales de feedback';
$string['configusergraph'] = 'Afficher les graphiques pour les « Tests de personnalité »';
$string['configusergraphlong'] = 'Utiliser la bibliothèque <a href="http://www.rgraph.net/">Rgraph</a> pour afficher les graphiques illustrant le feedback des tests de personnalité.';
$string['confirmdelallresp'] = 'Voulez-vous vraiment supprimer TOUTES les réponses à ce questionnaire ?';
$string['confirmdelchildren'] = 'Si vous supprimez cette question, ses questions « enfants » suivantes seront également supprimées :';
$string['confirmdeletesection'] = 'Voulez-vous vraiment supprimer la section de feedback « {$a} » ?';
$string['confirmdelgroupresp'] = 'Voulez-vous vraiment supprimer toutes les réponses de {$a} ?';
$string['confirmdelquestion'] = 'Voulez-vous vraiment supprimer la question en position {$a} ?';
$string['confirmdelquestionresps'] = 'Cette action supprimera également la ou les {$a} réponse(s) déjà donnée(s) à cette question.';
$string['confirmdelresp'] = 'Voulez-vous vraiment supprimer les réponses de {$a} ?';
$string['confirmremovequestion'] = 'Voulez-vous vraiment supprimer la question « {$a->qname} » de la section « {$a->sname} » ?';
$string['confpage'] = 'Titre';
$string['confpage_help'] = 'Vous pouvez facultativement saisir un titre et un texte qui seront affichés lorsque l\'utilisateur aura répondu à ce questionnaire. Si vous spécifiez une adresse Web, celle-ci aura priorité sur la page de confirmation. Si vous laissez cette zone vide, un message par défaut s\'affichera, du genre « Merci d\'avoir répondu à ce questionnaire ».';
$string['confpagedesc'] = 'Titre (en gras) et corps de texte pour la page de « Confirmation » affichée après qu\'un utilisateur a répondu au questionnaire. (Si vous donnez une adresse Web, elle sera affichée à la place du texte de confirmation).';
$string['contentoptions'] = 'Options de contenu';
$string['couldnotcreatenewsurvey'] = 'Impossible de créer un nouveau questionnaire !';
$string['couldnotdelresp'] = 'Impossible d\'effacer les réponses.';
$string['createcontent'] = 'Définir un nouveau contenu';
$string['createcontent_help'] = 'Choisir l\'un des boutons radio de la liste. Défaut : « Créer un nouveau questionnaire ».';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Créer un nouveau questionnaire';
$string['crontask'] = 'Nettoyage du questionnaire';
$string['date'] = 'Date';
$string['date_help'] = 'Utilisez ce type de question si vous voulez que la réponse soit donnée sous forme d\'une date correctement formatée.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Utilisez le format jour-mois-année, par exemple pour le 14 mars 1945 : <strong>14-03-1945</strong>';
$string['deleteallresponses'] = 'Effacer toutes les réponses';
$string['deletecurrentquestion'] = 'Supprimer la question {$a}';
$string['deletedallgroupresp'] = 'Toutes les réponses du groupe {$a} ont été effacées.';
$string['deletedallresp'] = 'Les réponses à ce questionnaire ont été supprimées';
$string['deletedisabled'] = 'Impossible de supprimer cet élément';
$string['deletedresp'] = 'Réponses supprimées.';
$string['deleteresp'] = 'Supprimer ces réponses';
$string['deletesection'] = 'Supprimer cette section';
$string['deletingresp'] = 'Suppression des réponses';
$string['dependencies'] = 'Dépendances';
$string['dependquestion'] = 'Question « parent »';
$string['dependquestion_help'] = 'Vous pouvez sélectionner une question « parent » et une option (choix) pour cette question. Une question « enfant » ne sera affichée que si sa question « parent » et le « choix parent » ont été sélectionnés au préalable.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'N\'a pas répondu à la question';
$string['directwarnings'] = 'Les dépendances directes à cette question seront supprimées. Ceci affectera :';
$string['displaymethod'] = 'La méthode d\'affichage n\'est pas définie pour ce type de question.';
$string['download'] = 'Exporter les réponses en format texte/CSV';
$string['downloadpdf'] = 'Télécharger le PDF';
$string['downloadtextformat'] = 'Télécharger';
$string['downloadtextformat_help'] = 'Cette fonction vous permet d\'enregistrer toutes les réponses d\'un questionnaire dans un format de fichier sélectionnable et pris en charge.
Vous pouvez choisir d\'inclure des éléments de données supplémentaires dans l\'exportation, ainsi que d\'envoyer automatiquement le fichier aux utilisateurs sélectionnés.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Type de rapport';
$string['dropdown'] = 'Liste déroulante';
$string['dropdown_help'] = 'Il n\'y a aucun avantage à utiliser la question « liste déroulante » plutôt que la question « boutons radio », sauf peut-être lorsque la liste d\'options est relativement longue, pour économiser de l\'espace.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Modifier';
$string['editingfeedback'] = 'Modification des paramètres de feedback';
$string['editingquestionnaire'] = 'Modification du questionnaire - page Générale';
$string['editquestion'] = 'Édition de la question {$a}';
$string['email'] = 'Courriel';
$string['emailextra'] = 'Envoyer le téléchargement aux adresses de courriel';
$string['emailextra_help'] = 'Enverra le fichier téléchargé aux adresses e-mail indiquées, séparées par des virgules. Notez qu\'aucune vérification de sécurité ou de confidentialité n\'est effectuée.
« allowemailreporting » doit être activé dans les paramètres du module pour y accéder.';
$string['emailroles'] = 'Envoyer le téléchargement aux rôles';
$string['emailroles_help'] = 'Enverra le fichier de téléchargement à tous les rôles ayant la capacité « mod/questionnaire:submissionnotification » par courriel.  « allowemailreporting » doit être activé dans les paramètres du module pour y accéder.';
$string['emailsend'] = 'Envoyer les rapports';
$string['emailsnotspecified'] = 'Aucune adresse de courriel n\'a été spécifiée.';
$string['emailssent'] = 'Téléchargements envoyés aux adresses de courriel spécifiées.';
$string['errnewname'] = 'Désolé, ce nom est déjà pris. Saisissez un nouveau nom.';
$string['erroropening'] = 'Erreur d\'ouverture du questionnaire.';
$string['errortable'] = 'Erreur système (table corrompue).';
$string['essaybox'] = 'Texte long';
$string['essaybox_help'] = 'Affiche une boîte de texte non formatable de x colonnes (Nb de colonnes du texte) et de y lignes (Nb de lignes du texte).

Si vous laissez x et y à leur valeur par défaut de 0 (zéro), alors l\'éditeur HTML sera affiché avec sa hauteur et sa largeur par défaut s\'il est disponible dans le contexte du cours et du profil de l\'utilisateur courant.';
$string['event_all_responses_deleted'] = 'Toutes les réponses supprimées';
$string['event_all_responses_saved_as_text'] = 'Réponses téléchargées au format texte';
$string['event_all_responses_viewed'] = 'Rapport de toutes les réponses consulté';
$string['event_individual_responses_viewed'] = 'Rapport des réponses individuelles consulté';
$string['event_non_respondents_viewed'] = 'Liste des utilisateurs n\'ayant pas répondu consultée';
$string['event_previewed'] = 'Questionnaire prévisualisé';
$string['event_question_created'] = 'Question créée';
$string['event_question_deleted'] = 'Question supprimée';
$string['event_response_deleted'] = 'Réponse individuelle supprimée';
$string['event_resumed'] = 'Questionnaire poursuivi';
$string['event_saved'] = 'Réponses sauvegardées';
$string['event_submitted'] = 'Questionnaire soumis';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Aide sur le feedback';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Ajouter {no} champs de feedback';
$string['feedbackbysection'] = 'Feedback de sections';
$string['feedbackdefaultlabel'] = '[Nouvelle section]';
$string['feedbackeditingglobal'] = 'Modification du feedback global du questionnaire';
$string['feedbackeditingmessages'] = 'Modification des messages de feedback du questionnaire';
$string['feedbackeditingsections'] = 'Modification des sections de feedback du questionnaire';
$string['feedbackeditmessages'] = 'Enregistrer les paramètres des sections et éditer les messages de feedback';
$string['feedbackeditsections'] = 'Enregistrer les paramètres et éditer les sections de feedback';
$string['feedbackerrorboundaryformat'] = 'Les limites des scores des feedbacks doivent être soit un pourcentage soit un nombre. La valeur saisie pour la limite {$a} n\'est pas correcte.';
$string['feedbackerrorboundaryoutofrange'] = 'Les limites des scores des feedbacks doivent être comprises entre 0% et 100%. La valeur saisie pour la limite {$a} est hors limites.';
$string['feedbackerrorjunkinboundary'] = 'Les limites des notes des feedbacks doivent être saisies sans discontinuité.';
$string['feedbackerrorjunkinfeedback'] = 'Les champs pour les feedbacks doivent être remplis sans discontinuité.';
$string['feedbackerrororder'] = 'Les limites des notes des feedbacks doivent être ordonnées, la plus haute en premier. La valeur saisie pour la limite {$a} n\'est pas dans l\'ordre.';
$string['feedbackglobal'] = 'Feedback global';
$string['feedbackglobalheading'] = 'Titre du feedback global';
$string['feedbackglobalmessages'] = 'Messages de feedback global';
$string['feedbackhdr'] = 'Feedbacks';
$string['feedbackheading'] = 'Titre de feedback';
$string['feedbackheading_help'] = 'Dans ce champ de l\'intitulé du feedback vous pouvez utiliser 2 variables : $scorepercent et $oppositescorepercent.';
$string['feedbackmessages'] = '{$a} messages de section';
$string['feedbacknextsection'] = 'Section suivante {$a}';
$string['feedbacknone'] = 'Aucun message de feedback';
$string['feedbacknotes'] = 'Notes de feedback';
$string['feedbacknotes_help'] = 'Le texte entré ici sera affiché à la fin du rapport de feedback.';
$string['feedbackoptions'] = 'Options de feedback';
$string['feedbackoptions_help'] = 'Les options de feedback sont disponibles si votre questionnaire contient les types de questions et les paramètres de question suivants :
Boutons radio; Liste déroulante; Oui/Non; ou Taux (barème normal ou Osgood). Ces questions doivent être définies comme obligatoires, leur champ « Nom de la question » ne doit PAS être vide et les choix de réponses possibles doivent contenir une valeur.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Cette question fait partie de la section de feedback [{$a}]';
$string['feedbackremovesection'] = 'Retirer cette question supprimera définitivement la section du feedback [{$a}]';
$string['feedbackreport'] = 'Rapport de feedback';
$string['feedbackscore'] = 'Score du feedback';
$string['feedbackscoreboundary'] = 'Limite de score du feedback';
$string['feedbackscores'] = 'Afficher les scores';
$string['feedbackscores_help'] = 'Affiche un tableau des scores obtenus';
$string['feedbacksection'] = 'Section';
$string['feedbacksectionheading'] = 'En-tête de la section {$a}';
$string['feedbacksectionheadingmissing'] = 'Vous devez entrer un titre pour cette section de feedback !';
$string['feedbacksectionheadingtext'] = 'Titre';
$string['feedbacksectionlabel'] = 'Étiquette';
$string['feedbacksectionlabel_help'] = 'Cette étiquette sera utilisée dans les graphiques. Veillez à rédiger une étiquette la plus courte possible !';
$string['feedbacksectionquestions'] = 'Questions de la section {$a}';
$string['feedbacksections'] = 'Sections de feedback';
$string['feedbacksectionsselect'] = 'Sections';
$string['feedbacksectionsselect_help'] = 'Veuillez indiquer dans quelles sections vous souhaitez placer vos questions.';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Les paramètres de feedback ont bien été enregistrés.';
$string['feedbacktype'] = 'Type de feedback';
$string['field'] = 'Question {$a}';
$string['fieldlength'] = 'Longueur de la boîte de texte';
$string['fieldlength_help'] = 'Affiche une boîte de texte d\'une seule ligne de hauteur, d\'une longueur de x caractères et où la longueur maximale du texte saisi par le répondant est limitée à y caractères.

Valeurs par défaut : 20 caractères pour la longueur de la boîte [Longueur de la boîte de texte] et 25 caractères pour le texte effectivement saisi par le répondant [Longueur texte max.].';
$string['finished'] = 'Vous avez répondu à toutes les questions de ce questionnaire !';
$string['firstrespondent'] = 'Premier répondant';
$string['formateditor'] = 'Éditeur HTML.';
$string['formatplain'] = 'Texte brut';
$string['grade'] = 'Note pour ce questionnaire';
$string['gradesdeleted'] = 'Les notes de ce questionnaire ont été supprimées';
$string['headingtext'] = 'Titre';
$string['horizontal'] = 'Horizontal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Inclure les numéros des réponses choisies';
$string['includechoicetext'] = 'Inclure le texte des réponses choisies';
$string['includeincomplete'] = 'Inclure les réponses incomplètes';
$string['includerankaverages'] = 'Inclure les moyennes des questions de classement';
$string['incorrectcourseid'] = 'Identificateur de cours incorrect';
$string['incorrectmodule'] = 'L\'identificateur du module de cours était incorrect';
$string['incorrectquestionnaire'] = 'Questionnaire incorrect';
$string['indirectwarnings'] = 'Cette liste affiche les questions dépendantes indirectes et les dépendances restantes pour les questions dépendantes directement :';
$string['invalidresponse'] = 'Réponse non valide.';
$string['invalidresponserecord'] = 'Enregistrement de réponse non valide.';
$string['invalidsectionid'] = 'Section de feedback spécifiée non valide.';
$string['invalidsurveyid'] = 'Identifiant de questionnaire non valide.';
$string['kindofratescale'] = 'Type d\'échelle';
$string['kindofratescale_help'] = 'Cliquez droit sur le lien « Plus d\'aide » ci-dessous';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Dernier répondant';
$string['length'] = 'Longueur';
$string['managequestions'] = 'Gérer les questions';
$string['managequestions_help'] = 'Dans la section « Gérer les questions » de la page « Éditer les questions » vous pouvez effectuer toutes les opérations utiles sur les questions déjà créées.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Obligatoire - Toutes ces dépendances doivent être complétées.';
$string['maxdigitsallowed'] = 'Max. chiffres autorisés';
$string['maxdigitsallowed_help'] = 'Utilisez **Max. chiffres autorisés** pour limiter le nombre de chiffres entrés pour une question de type numérique. Remarque : la virgule pour la décimale compte pour 1 caractère !';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Max. cases à cocher';
$string['maxforcedresponses_help'] = 'Utilisez ces paramètres pour forcer le répondant à cocher un minimum et un maximum de cases.
Pour indiquer un nombre exact de cases à cocher, définissez **Min.** et **Max.** avec la même valeur. Si seulement une valeur minimale OU maximale est souhaitée, il suffit de laisser l\'autre valeur à sa valeur par défaut **0**.
Si vous définissez **Min.** Ou **Max.** à des valeurs autres que par défaut **0**, un message d\'avertissement sera affiché si le répondant ne se conforme pas à votre demande. Évidemment, vous devez faire preuve de clarté, soit dans les instructions générales de votre questionnaire ou dans le texte des questions.';
$string['maxtextlength'] = 'Longueur texte max.';
$string['maxtextlength_help'] = 'Pour la question de type Texte court, définissez la longueur de la zone de saisie et le nombre maximal de caractères possibles par le répondant.

Valeurs par défaut : 20 caractères pour la longueur de la boîte [Longueur de la boîte de texte] et 25 caractères pour le texte effectivement saisi par le répondant [Longueur texte max.].';
$string['messageprovider:message'] = 'Rappel de réponse au questionnaire';
$string['messageprovider:notification'] = 'Envoi du questionnaire';
$string['minforcedresponses'] = 'Min. cases à cocher';
$string['minforcedresponses_help'] = 'Utilisez ces paramètres si vous voulez forcer les étudiants à cocher un minimum de **Min. cases à cocher** ou un maximum de **Max. cases à cocher**.
Pour les forcer à cocher un nombre exact de cases, tapez la même valeur pour **Min.** et **Max**. Si vous voulez uniquement forcer un minimum ou un maximum de cases cochées, laissez l\'autre valeur à zéro. Ex. pour avoir un minimum de 2 cases cochées sur un total de 5, tapez **Min.** = 2 et laissez **Max.** à 0.
Si vous avez saisi pour l\'un ou l\'autre de ces paramètres une valeur différente de 0, si l\'étudiant ne respecte pas le nombre mini ou maxi imposé, un message d\'erreur sera affiché.
Évidemment, il vous appartient de préciser vos exigences dans le texte de la question !';
$string['misconfigured'] = 'Le cours est mal configuré.';
$string['missingname'] = 'Vous ne pouvez pas utiliser la question {$a} dans cette section de feedback parce qu\'elle n\'a pas de nom.';
$string['missingnameandrequired'] = 'Vous ne pouvez pas utiliser la question {$a} dans cette section de feedback parce qu\'elle n\'a pas de nom et qu\'elle n\'est pas obligatoire.';
$string['missingquestion'] = 'Veuillez répondre à la question obligatoire ';
$string['missingquestions'] = 'Veuillez répondre aux questions obligatoires :';
$string['missingrequired'] = 'Vous ne pouvez pas utiliser la question {$a} dans cette section de feedback parce qu\'elle n\'est pas obligatoire.';
$string['modulename'] = 'Questionnaire';
$string['modulename_help'] = 'Le module « questionnaire » vous permet de créer des enquêtes utilisant divers types de questions, afin de collecter l\'opinion des utilisateurs.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Questionnaires';
$string['movedisabled'] = 'Impossible de déplacer cet élément.';
$string['myresponses'] = 'Toutes vos réponses';
$string['myresponsetitle'] = 'Vos résultats pour {$a} réponses.';
$string['myresults'] = 'Vos résultats';
$string['name'] = 'Nom';
$string['navigate'] = 'Autoriser les questions à branchement conditionnel';
$string['navigate_help'] = 'Autoriser les questions de type Oui/Non et Boutons Radio à avoir des questions « enfant » dépendant de leurs choix dans ce questionnaire.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Aller à la section des feedbacks';
$string['next'] = 'Suite';
$string['nextpage'] = 'Page suivante';
$string['nlines'] = '{$a} lignes';
$string['noanswer'] = 'Sans réponse';
$string['noattempts'] = 'Ce questionnaire ne contient encore aucune réponse.';
$string['nodata'] = 'Aucune donnée n\'a été envoyée.';
$string['noduplicates'] = 'Choix uniques';
$string['noduplicateschoiceserror'] = 'Vous devez entrer au moins 2 « réponses possibles » pour l\'option « Choix uniques » !';
$string['non_respondents'] = 'Inscrits au cours qui n\'ont pas encore soumis leurs réponses à ce questionnaire';
$string['noneinuse'] = 'Ce questionnaire ne contient aucune question.';
$string['nopublicsurveys'] = 'Pas de questionnaire public.';
$string['noresponsedata'] = 'Il n\'y a pas de réponse pour cette question.';
$string['noresponses'] = 'Pas de réponse';
$string['normal'] = 'Normal';
$string['not_started'] = 'pas commencé';
$string['notanumber'] = '<strong>{$a}</strong> n\'est pas un nombre.';
$string['notapplicable'] = 'NSP';
$string['notapplicablecolumn'] = 'Colonne NSP';
$string['notavail'] = 'Ce questionnaire n\'est plus disponible. Demandez à votre enseignant de le supprimer.';
$string['noteligible'] = 'Vous n\'êtes pas autorisé à répondre à ce questionnaire.';
$string['notemplatesurveys'] = 'Pas de modèle de questionnaire.';
$string['notenoughscaleitems'] = 'Vous devez entrer au minimum 2 items sur cette échelle.';
$string['notificationfull'] = 'Soumission complète';
$string['notifications'] = 'Envoyer les notifications de remises';
$string['notifications_help'] = 'Notifier les rôles ayant la capacité « mod/questionnaire:submissionnotification » lorsqu\'un envoi est faite.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Notification seulement';
$string['notopen'] = 'Ce questionnaire ne sera pas disponible avant le {$a}.';
$string['notrequired'] = 'Réponse facultative';
$string['notset'] = 'Non défini';
$string['nousersselected'] = 'Aucun utilisateur sélectionné';
$string['num'] = 'n°';
$string['numattemptsmade'] = 'Ce questionnaire a été soumis {$a} fois.';
$string['numberfloat'] = 'Le nombre que vous avez tapé<strong>{$a->number}</strong> a été reformaté/arrondi avec une précision de <strong>{$a->precision}</strong> chiffres après la virgule.';
$string['numberofdecimaldigits'] = 'Nb de chiffres après la virgule';
$string['numberofdecimaldigits_help'] = 'Utilisez **Nb de décimales** pour spécifier le format de la valeur moyenne comptée et affichée sur la page Rapport du questionnaire.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Nb d\'items sur l\'échelle';
$string['numberscaleitems_help'] = 'Nb d\'items sur l\'échelle indique le nombre d\'items qui seront affichés sur votre échelle horizontale. Une valeur comprise entre 3 et 5 est habituelle. La valeur par défaut est de 5.';
$string['numeric'] = 'Numérique';
$string['numeric_help'] = 'Utilisez ce type de question si vous voulez que la réponse soit donnée sous forme d\'un nombre correctement formaté.';
$string['of'] = 'de';
$string['openafterclose'] = 'Vous avez spécifié une date d\'ouverture postérieure à la date de fermeture';
$string['opendate'] = 'Autoriser les réponses à partir de';
$string['option'] = 'option {$a}';
$string['optional'] = 'Optionnel - Au moins une de ces dépendances doit être complétée.';
$string['optionalname'] = 'Nom de la question';
$string['optionalname_help'] = 'Le **nom de la question** est seulement utilisé lors de l\'exportation des données au format CSV/Excel.
Si vous ne faites jamais d\'export de ce type, vous n\'avez pas besoin d\'entrer un nom de question.
Pour plus de détails voir la documentation ci-dessous.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- OU -';
$string['order_ascending'] = 'Ordre ascendant';
$string['order_default'] = 'Ordre normal';
$string['order_descending'] = 'Ordre descendant';
$string['orderresponses'] = 'Ordonner les réponses';
$string['orderresponses_help'] = 'Lorsque vous affichez Toutes les Réponses, vous pouvez ordonner les choix par nombre de réponses (colonne « Rang Moyen »)
pour les 4 types de questions suivants.

* bouton radio (QCM à choix unique)
* liste déroulante (QCM à choix unique)
* cases à cocher (QCM à choix multiple)
* questions de type Echelle de Likert.

Lorsque vous arrivez sur la page Toutes les réponses, par défaut toutes les réponses sont triées dans l\'ordre où les choix ont été entrés lors de la création des questions. Vous pouvez alors effectuer des tris par ordre descendant ou ascendant.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Autre :';
$string['otherempty'] = 'Si vous cochez ce choix vous devez taper du texte dans la case de texte !';
$string['overviewnumresplog'] = 'réponses';
$string['overviewnumresplog1'] = 'réponse';
$string['overviewnumrespvw'] = 'réponses';
$string['overviewnumrespvw1'] = 'réponse';
$string['owner'] = 'Propriétaire';
$string['page'] = 'Page';
$string['pageof'] = 'Page {$a->page} sur {$a->totpages}';
$string['parent'] = 'Parent';
$string['participant'] = 'Participant';
$string['pleasecomplete'] = 'Veuillez compléter ce choix';
$string['pluginadministration'] = 'Administration du questionnaire';
$string['pluginname'] = 'Questionnaire';
$string['position'] = 'position';
$string['possibleanswers'] = 'Réponses possibles.';
$string['posteddata'] = 'Cette page a été atteinte avec les données suivantes :';
$string['preview_label'] = 'Prévisualisation';
$string['preview_questionnaire'] = 'Prévisualisation du Questionnaire';
$string['previewing'] = 'Prévisualisation du questionnaire';
$string['previous'] = 'Précédent';
$string['previouspage'] = 'Page précédente';
$string['print'] = 'Imprimer';
$string['printblank'] = 'Imprimer un questionnaire vierge';
$string['printblanktooltip'] = 'Ouvrir une fenêtre formatée pour l\'impression d\'un questionnaire vierge.';
$string['printtooltip'] = 'Ouvrir une fenêtre formatée pour l\'impression des réponses en cours.';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Une réponse à une question à choix multiples.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'L\'identifiant d\'un enregistrement du choix pour cette réponse.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'L\'identifiant de l\'enregistrement de la question pour cette réponse.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'L\'identifiant de l\'enregistrement de la réponse pour cette réponse.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Réponse à une question à choix unique.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'L\'identifiant de l\'enregistrement du choix pour cette réponse.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'L\'identifiant de l\'enregistrement de la question pour cette réponse.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'L\'identifiant de l\'enregistrement de la réponse pour cette réponse.';
$string['privacy:metadata:questionnaire_response'] = 'Une réponse en cours ou envoyée';
$string['privacy:metadata:questionnaire_response:complete'] = 'Le statut d\'achèvement de la réponse.';
$string['privacy:metadata:questionnaire_response:grade'] = 'La note pour cette réponse.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'L\'identifiant de l\'enregistrement du questionnaire pour cette réponse.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Horodatage de la dernière sauvegarde pour cette réponse.';
$string['privacy:metadata:questionnaire_response:userid'] = 'L\'identifiant de l\'utilisateur pour cette réponse.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Une réponse à la question booléenne (oui/non).';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'La réponse booléenne spécifique.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'L\'identifiant de l\'enregistrement de la question pour cette réponse.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'L\'identifiant de l\'enregistrement de la réponse pour cette réponse.';
$string['privacy:metadata:questionnaire_response_date'] = 'Une réponse à une question de date.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'L\'identifiant de l\'enregistrement de la question pour cette réponse.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'La date spécifique de réponse.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'L\'identifiant de l\'enregistrement de la réponse pour cette réponse.';
$string['privacy:metadata:questionnaire_response_other'] = 'Une réponse de type « autre » choix.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'L\'identifiant de l\'enregistrement du choix pour cette réponse.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'L\'identifiant de l\'enregistrement de la question pour cette réponse.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'La réponse de texte spécifique.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'L\'identifiant de l\'enregistrement de la réponse pour cette réponse.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Une réponse à une question de rang.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'L\'identifiant de l\'enregistrement du choix pour cette réponse.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'L\'idnetifiant de l\'enregistrement de la question pour cette réponse.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'La réponse de rang spécifique.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'L\'identifiant de l\'enregistrement de la réponse pour cette réponse.';
$string['privacy:metadata:questionnaire_response_text'] = 'Une réponse à une question texte.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'L\'identifiant de l\'enregistrement de la question pour cette réponse.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'La réponse de texte spécifique.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'L\'identifiant de l\'enregistrement de la réponse pour cette réponse.';
$string['private'] = 'Privé';
$string['progressbar'] = 'Afficher la barre de progression';
$string['progressbar_info'] = 'Questionnaire {$a} terminé.';
$string['progresshelp'] = 'Barre de progression';
$string['progresshelp_help'] = 'Passer à la page suivante pour remplir la barre de progression';
$string['public'] = 'Public';
$string['publiccopy'] = 'Copie :';
$string['publicoriginal'] = 'Original :';
$string['qtype'] = 'Type';
$string['qtype_help'] = 'Ce paramètre vous permet de définir si les étudiants pourront répondre au questionnaire une seule fois, une fois par jour, par semaine, par mois ou un nombre illimité de fois.';
$string['qtypedaily'] = 'répondre tous les jours';
$string['qtypemonthly'] = 'répondre tous les mois';
$string['qtypeonce'] = 'répondre une fois seulement';
$string['qtypeunlimited'] = 'répondre un nombre illimité de fois';
$string['qtypeweekly'] = 'répondre chaque semaine';
$string['questionnaire:addinstance'] = 'Ajouter un questionnaire';
$string['questionnaire:copysurveys'] = 'Copier des questionnaires Modèles et Privés';
$string['questionnaire:createpublic'] = 'Créer des questionnaires Public';
$string['questionnaire:createtemplates'] = 'Créer des questionnaires Modèle';
$string['questionnaire:deleteresponses'] = 'Supprimer toutes les réponses';
$string['questionnaire:downloadresponses'] = 'Exporter les réponses au format texte/CSV';
$string['questionnaire:editquestions'] = 'Créer et modifier des questions de questionnaire';
$string['questionnaire:manage'] = 'Créer et modifier des questionnaires';
$string['questionnaire:message'] = 'Envoyer un message à ceux qui n\'ont pas encore répondu.';
$string['questionnaire:preview'] = 'Prévisualiser les questionnaires';
$string['questionnaire:printblank'] = 'Imprimer un questionnaire vierge';
$string['questionnaire:readallresponseanytime'] = 'Voir toutes les réponses tout le temps';
$string['questionnaire:readallresponses'] = 'Voir les Résumés de réponses en fonction des dates d\'ouverture du questionnaire';
$string['questionnaire:readownresponses'] = 'Voir ses propres réponses';
$string['questionnaire:submissionnotification'] = 'Recevoir une notification pour chaque envoi';
$string['questionnaire:submit'] = 'Répondre à un questionnaire et l\'envoyer';
$string['questionnaire:view'] = 'Voir un questionnaire';
$string['questionnaire:viewsingleresponse'] = 'Voir les réponses individuelles';
$string['questionnaireadministration'] = 'Administration du questionnaire';
$string['questionnairecloses'] = 'Fermeture du questionnaire';
$string['questionnaireopens'] = 'Ouverture du questionnaire';
$string['questionnairereport'] = 'Rapport de questionnaire';
$string['questionnum'] = 'Question n°';
$string['questions'] = 'Questions';
$string['questionsinsection'] = 'Nombre de questions dans cette section :';
$string['questiontypes'] = 'Types de questions';
$string['questiontypes_help'] = 'Voir la documentation ci-dessous.';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Boutons radio';
$string['radiobuttons_help'] = 'Type de question à choix multiple et à réponse unique.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rang';
$string['ratescale'] = 'Échelle de Likert';
$string['ratescale_help'] = 'Voir la documentation ci-dessous.';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Type de questionnaire';
$string['realm_help'] = '* **Il existe 3 types de questionnaires :**
 * Privé - appartient seulement au cours dans lequel il a été créé.
 * Modèle - peut être copié et modifié.
 * Public - peut être partagé entre plusieurs cours.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'L\'URL vers laquelle l\'utilisateur sera redirigé après avoir répondu au questionnaire.';
$string['remove'] = 'Supprimer';
$string['removeallquestionnaireattempts'] = 'Supprimer toutes les réponses à ce questionnaire';
$string['removenotinuse'] = 'Ce questionnaire dépend d\'un questionnaire Public qui a été effacé.
Il ne sera plus utilisé et peut donc être supprimé.';
$string['required'] = 'Une réponse est requise';
$string['required_help'] = 'Si vous sélectionnez **Oui**, la question sera obligatoire,
c\'est-à-dire que le répondant ne pourra pas soumettre le questionnaire sans y avoir répondu.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Un paramètre obligatoire manque.';
$string['reset'] = 'Réinitialiser';
$string['respeligiblerepl'] = '(remplacé par la gestion des rôles)';
$string['respondent'] = 'Nom';
$string['respondenteligibleall'] = 'Tout le monde';
$string['respondenteligiblestudents'] = 'Les étudiants seulement';
$string['respondenteligibleteachers'] = 'Les enseignants seulement';
$string['respondents'] = 'Répondants';
$string['respondenttype'] = 'Anonyme ou nominatif ?';
$string['respondenttype_help'] = 'Vous pouvez ici choisir si le nom de l\'étudiant sera affiché ou non lorsque vous visualiserez les réponses à ce questionnaire. Si non, le mot **Anonyme** sera affiché.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonyme';
$string['respondenttypefullname'] = 'nominatif';
$string['response'] = 'Réponse';
$string['responsefieldlines'] = 'Taille du champ de saisie';
$string['responseformat'] = 'Format de réponse';
$string['responseoptions'] = 'Options des réponses';
$string['responses'] = 'Réponses';
$string['responseview'] = 'Les étudiants peuvent voir TOUTES les réponses';
$string['responseview_help'] = 'Vous pouvez paramétrer si les étudiants auront le droit de voir les réponses de leurs camarades (tableau statistique général).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Toujours';
$string['responseviewstudentsnever'] = 'Jamais';
$string['responseviewstudentswhenanswered'] = 'Après avoir répondu au questionnaire';
$string['responseviewstudentswhenclosed'] = 'Après la fermeture du questionnaire';
$string['restrictedtoteacher'] = 'Ces fonctions sont réservées aux enseignants avec des droits d\'édition !';
$string['resume'] = 'Sauvegarder & Reprendre';
$string['resume_help'] = 'Cette option permet aux étudiants de sauvegarder leurs réponses à un questionnaire avant de les soumettre. Les étudiants peuvent commencer à répondre, sauvegarder l\'état d\'avancement, et reprendre le questionnaire plus tard à leur convenance, pour reprendre au point où ils en étaient. Ceci peut se révéler utile pour un questionnaire particulièrement long.';
$string['resume_link'] = 'mod/questionnaire/mod#Save.2FResume_answers';
$string['resumesurvey'] = 'Poursuivre le questionnaire';
$string['return'] = 'Retour';
$string['save'] = 'Sauvegarder';
$string['save_and_exit'] = 'Sauvegarder et quitter';
$string['saveasnew'] = 'Enregistrer comme nouvelle question';
$string['savedbutnotsubmitted'] = 'Les réponses à ce questionnaire ont été sauvegardées mais le questionnaire n\'a pas encore été soumis.';
$string['savedprogress'] = 'Vos réponses ont été sauvegardées. Vous pouvez reprendre ce questionnaire pour le compléter à tout moment.';
$string['saveeditedquestion'] = 'Enregistrer la question {$a}';
$string['savesettings'] = 'Enregistrer les paramètres';
$string['search:activity'] = 'Questionnaire - information sur l\'activité';
$string['search:question'] = 'Questionnaire - questions';
$string['section'] = 'Description';
$string['sectionbreak'] = '----- Saut de page -----';
$string['sectionbreak_help'] = '----- Saut de page -----';
$string['sectionsnotset'] = 'Vous devez sélectionner au moins UNE question par section<br />Sections non sélectionnées : {$a}.';
$string['sectiontext'] = 'Description';
$string['sectiontext_help'] = 'Ceci n\'est pas une question mais un bref texte par ex. pour introduire une série de quesions.';
$string['selecttheme'] = 'Choisissez un thème (CSS) pour ce questionnaire.';
$string['send'] = 'Envoyer';
$string['send_message'] = 'Envoyer un message aux utilisateurs sélectionnés';
$string['send_message_to'] = 'Envoyer un message à :';
$string['sendemail'] = 'Envoyer une copie par courriel.';
$string['sendemail_help'] = 'Envoyer une copie de chaque questionnaire rempli à l\'adresse ou aux adresses spécifiées.
Vous pouvez saisir plusieurs adresses, séparées par une virgule.
Laissez vide si vous ne souhaitez pas recevoir de courriel. « allowemailreporting » doit être activé dans les paramètres du module pour y accéder.';
$string['set'] = 'défini';
$string['settings'] = 'Paramètres';
$string['settingssaved'] = 'Paramètres enregistrés.';
$string['show_nonrespondents'] = 'Utilisateurs n\'ayant pas répondu';
$string['started'] = 'commencé';
$string['strfdate'] = '%d-%m-%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Saisir la date en utilisant le sélecteur de date ci-dessous ou en utilisant le format « JJ/MM/AAAA ».';
$string['subject'] = 'Sujet';
$string['submissionnotificationhtmlanon'] = 'Il y a un <a href="{$a->submissionurl}">nouvel envoi</a> du questionnaire « {$a->name} ».';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a>  a modifié sa <a href="{$a->submissionurl}">réponse</a> au questionnaire « {$a->name} » dans le cours « {$a->coursename} ».';
$string['submissionnotificationsubject'] = 'Nouvel envoi de questionnaire';
$string['submissionnotificationtextanon'] = 'Il y a un nouvel envoi ({$a->submissionurl}) du questionnaire « {$a->name} ».';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) a modifié sa réponse ({$a->submiturl}) au questionnaire « {$a->name} » dans le cours « {$a->coursename} ».';
$string['submitoptions'] = 'Options d\'envoi du questionnaire';
$string['submitpreview'] = 'Soumettre cette prévisualisation';
$string['submitpreviewcorrect'] = 'Cette soumission serait acceptée comme correctement remplie.';
$string['submitsurvey'] = 'Envoyer le questionnaire';
$string['submitted'] = 'Soumis le :';
$string['subtitle'] = 'Sous-titre';
$string['subtitle_help'] = 'Ce sous-titre (facultatif) n’apparaît que sur la 1ère page du questionnaire (si celui-ci comporte plusieurs pages).';
$string['summary'] = 'Résumé';
$string['summaryreportattached'] = 'Rapport de synthèse du questionnaire joint';
$string['surveynotexists'] = 'Le questionnaire n\'existe pas.';
$string['surveyowner'] = 'Seuls les propriétaires de ce questionnaire sont autorisés à effectuer cette opération.';
$string['surveyresponse'] = 'Réponse du questionnaire';
$string['template'] = 'Modèle';
$string['templatenotviewable'] = 'Vous ne pouvez pas afficher les questionnaires de type « modèle ».';
$string['text'] = 'Texte';
$string['textareacolumns'] = 'Nb de colonnes du texte';
$string['textareacolumns_help'] = 'Affiche une boîte de texte non formatable de x colonnes (Nb de colonnes du texte) et de y lignes (Nb de lignes du texte).

Si vous laissez x et y à leur valeur par défaut de 0 (zéro), alors l\'éditeur HTML sera affiché avec sa hauteur et sa largeur par défaut s\'il est disponible dans le contexte du cours et du profil de l\'utilisateur courant.';
$string['textarearows'] = 'Nb de lignes du texte';
$string['textbox'] = 'Texte court';
$string['textbox_help'] = 'Entrez la longueur de la fenêtre de saisie ainsi que la longueur maximum du texte entré.
Les valeurs par défaut sont de 20 caractères pour la longueur de la fenêtre de saisie et de 25 caractères pour la longueur maximum du texte entré.';
$string['textdownloadoptions'] = 'Options de téléchargement CSV';
$string['thank_head'] = 'Merci d\'avoir répondu à ce questionnaire.';
$string['theme'] = 'Thème';
$string['thismonth'] = 'ce mois';
$string['thisresponse'] = 'Cette réponse';
$string['thisweek'] = 'cette semaine';
$string['thousands'] = 'Ne pas utiliser de séparateur des milliers.';
$string['title'] = 'Titre';
$string['title_help'] = 'Titre du questionnaire, qui s\'affichera en haut de chaque page. Par défaut ce titre est le même que le Nom du questionnaire.';
$string['today'] = 'aujourdhui';
$string['total'] = 'Total';
$string['totalofnumbers'] = 'Total des nombres saisis';
$string['totalresponses'] = 'Total des réponses à la question';
$string['type'] = 'Type de question';
$string['undefinedquestiontype'] = 'Type de question inconnu !';
$string['unknown'] = 'Inconnu';
$string['unknownaction'] = 'Action inconnue…';
$string['url'] = 'URL';
$string['url_help'] = 'Adresse vers laquelle rediriger l\'étudiant après qu\'il a soumis ses réponses.';
$string['useprivate'] = 'Copier un questionnaire existant';
$string['usepublic'] = 'Utiliser un questionnaire public';
$string['usetemplate'] = 'Copier un modèle de questionnaire';
$string['vertical'] = 'Vertical';
$string['view'] = 'Voir';
$string['viewallresponses'] = 'Voir toutes les réponses';
$string['viewallresponses_help'] = 'Si le questionnaire est paramétré pour **Type des groupes** : *Groupes visibles*, ou *Groupes séparés* et que l\'utilisateur actuel possède la capacité *Accéder à tous les groupes* (dans le contexte actuel) et que des groupes d\'utilisateurs ont été définis dans le cours actuel, alors l\'utilisateur a accès à une liste déroulante des groupes existants. Cette liste déroulante lui permet de « filtrer » les réponses au questionnaire par groupes.';
$string['viewallresponses_link'] = 'Voir_les_réponses#Filtrer_par_groupes';
$string['viewbyresponse'] = 'Liste des réponses';
$string['viewindividualresponse'] = 'Réponses individuelles';
$string['viewindividualresponse_help'] = 'Cliquez sur les noms des répondants dans la liste ci-dessous pour voir leurs réponses individuelles.';
$string['viewresponses'] = 'Toutes les réponses ({$a})';
$string['viewyourresponses'] = 'Vos réponses : voir {$a}';
$string['warning'] = 'ATTENTION ! Erreur rencontrée.';
$string['wronganswers'] = 'Il y a une erreur dans vos réponses (voir ci-dessous)';
$string['wrongdateformat'] = 'Le format de la date entrée <strong>{$a}</strong> ne correspond pas au format montré dans l\'exemple.';
$string['wrongdaterange'] = 'ERREUR ! L\'année doit se situer entre 1902 et 2037.';
$string['wrongformat'] = 'Il y a une erreur avec votre réponse à la question :';
$string['wrongformats'] = 'Il y a une erreur avec votre réponse aux questions :';
$string['yesno'] = 'Oui/Non';
$string['yesno_help'] = 'Simple question à réponse **Oui** ou **Non**.';
$string['yourresponse'] = 'Votre réponse';
$string['yourresponses'] = 'Vos réponses';
