<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlecloudsignup', language 'fr', version '3.9'.
 *
 * @package     local_moodlecloudsignup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['FOSUserBundle:change_password.flash.success'] = 'Le mot de passe a été modifié.';
$string['FOSUserBundle:change_password.submit'] = 'Modifier le mot de passe';
$string['FOSUserBundle:form.current_password'] = 'Mot de passe actuel :';
$string['FOSUserBundle:form.email'] = 'Adresse de courriel :';
$string['FOSUserBundle:form.group_name'] = 'Nom du groupe :';
$string['FOSUserBundle:form.new_password'] = 'Nouveau mot de passe :';
$string['FOSUserBundle:form.new_password_confirmation'] = 'Répétez le nouveau mot de passe :';
$string['FOSUserBundle:form.password'] = 'Mot de passe :';
$string['FOSUserBundle:form.password_confirmation'] = 'Répéter le mot de passe :';
$string['FOSUserBundle:form.username'] = 'Nom d\'utilisateur :';
$string['FOSUserBundle:group.edit.submit'] = 'Modifier le groupe';
$string['FOSUserBundle:group.flash.created'] = 'Le groupe a été créé';
$string['FOSUserBundle:group.flash.deleted'] = 'Le groupe a été supprimé';
$string['FOSUserBundle:group.flash.updated'] = 'Le groupe a été modifié';
$string['FOSUserBundle:group.new.submit'] = 'Créer un groupe';
$string['FOSUserBundle:group.show.name'] = 'Nom du groupe';
$string['FOSUserBundle:layout.logged_in_as'] = 'Connecté en tant que %username%';
$string['FOSUserBundle:layout.login'] = 'Connexion';
$string['FOSUserBundle:layout.logout'] = 'Déconnexion';
$string['FOSUserBundle:layout.register'] = 'S\'enregistrer';
$string['FOSUserBundle:profile.edit.submit'] = 'Modifier';
$string['FOSUserBundle:profile.flash.updated'] = 'Le profil a été modifié';
$string['FOSUserBundle:profile.show.email'] = 'Adresse de courriel';
$string['FOSUserBundle:profile.show.username'] = 'Nom d\'utilisateur';
$string['FOSUserBundle:registration.back'] = 'Retour à la page d\'origine';
$string['FOSUserBundle:registration.check_email'] = 'Un message a été envoyé à %email%. Il contient un lien d\'activation sur lequel vous devez cliquer pour activer votre compte.';
$string['FOSUserBundle:registration.confirmed'] = 'Félicitations $username%, votre compte est maintenant activé.';
$string['FOSUserBundle:registration.email.message'] = 'Bonjour %username% !

Pour terminer votre enregistrement, veuillez cliquer sur %confirmationUrl%.

Notre équipe vous en remercie.';
$string['FOSUserBundle:registration.email.subject'] = 'Bienvenue %username% !';
$string['FOSUserBundle:registration.flash.user_created'] = 'L\'utilisateur a bien été créé';
$string['FOSUserBundle:registration.submit'] = 'S\'enregistrer';
$string['FOSUserBundle:resetting.check_email'] = 'Un message a été envoyé à %email%. Il contient un lien d\'activation sur lequel vous devez cliquer pour réinitialiser votre mot de pase.';
$string['FOSUserBundle:resetting.email.message'] = 'Bonjour %username%,

Pour réinitialiser votre mot de passe, rendez-vous sur %confirmationUrl%

Cordiales salutations';
$string['FOSUserBundle:resetting.email.subject'] = 'Réinitialiser le mot de passe';
$string['FOSUserBundle:resetting.flash.success'] = 'Le mot de passe a bien été réinitialisé';
$string['FOSUserBundle:resetting.password_already_requested'] = 'Le mot de passe de cet utilisateur a déjà été demandé au cours des dernières 24 heures.';
$string['FOSUserBundle:resetting.request.invalid_username'] = 'Le nom d\'utilisateur ou l\'adresse de courriel « %username% » n\'existe pas.';
$string['FOSUserBundle:resetting.request.submit'] = 'Réinitialiser le mot de passe';
$string['FOSUserBundle:resetting.request.username'] = 'Nom d\'utilisateur ou adresse de courriel :';
$string['FOSUserBundle:resetting.reset.submit'] = 'Modifier le mot de passe';
$string['FOSUserBundle:security.login.password'] = 'Mot de passe :';
$string['FOSUserBundle:security.login.remember_me'] = 'Se souvenir de moi';
$string['FOSUserBundle:security.login.submit'] = 'Connexion';
$string['FOSUserBundle:security.login.username'] = 'Nom d\'utilisateur :';
$string['homepage:Table.activities'] = 'Nombre illimité d\'activités';
$string['homepage:Table.annualprice'] = 'Prix annuel*';
$string['homepage:Table.button'] = 'S\'inscrire';
$string['homepage:Table.conferencing'] = 'Vidéo-conférence';
$string['homepage:Table.gb'] = '%limit% Go';
$string['homepage:Table.maxusers'] = 'Nombre d\'utilisateurs';
$string['homepage:Table.mb'] = '%limit% Mo';
$string['homepage:Table.noplugins'] = 'Pas de plugin supplémentaire';
$string['homepage:Table.notheme'] = 'Pas de thème avancé';
$string['homepage:Table.plan'] = 'Plan';
$string['homepage:Table.plugins'] = 'Plugins supplémentaires';
$string['homepage:Table.sitename'] = 'Nom de site personnalisé';
$string['homepage:Table.theme'] = 'Thème avancé';
$string['homepage:Table.uptodate'] = 'Toujours à la dernière version';
$string['homepage:body.intro'] = 'par les créateurs de Moodle';
$string['homepage:body.title'] = 'Hébergement Moodle';
$string['homepage:general.faq'] = 'FAQ';
$string['homepage:general.servicestatus'] = 'État du service';
$string['homepage:needmore'] = 'Vous avez besoin de plus? <a href="https://moodle.com/contact">Contactez-nous</a>.';
$string['homepage:notfound.badnews'] = 'La mauvaise nouvelle est que ce site n\'existe pas - il a été supprimé ou n\'est pas encore en ligne.';
$string['homepage:notfound.button'] = 'Inscrivez-vous est obtenez ce site';
$string['homepage:notfound.goodnews'] = 'La bonne nouvelle est que ce site est disponible et que vous pouvez l\'obtenir dès maintenant.';
$string['homepage:notfound.title'] = 'Nous avons une bonne et une mauvaise nouvelle.';
$string['homepage:page.description'] = 'Hébergement Moodle disponible à tous, pour utiliser le logiciel d\'enseignement dans le cloud.';
$string['homepage:page.title'] = 'MoodleCloud : hébergement Moodle gratuit, par les créateurs de Moodle.';
$string['homepage:plans.free.description'] = 'Pour une seule classe ou simplement pour essayer Moodle';
$string['homepage:plans.free.name'] = 'Moodle gratuit';
$string['homepage:plans.free.plan_free'] = 'Gratuit';
$string['homepage:plans.school1.description'] = 'Parfait pour plusieurs classes';
$string['homepage:plans.school1.name'] = 'Moodle pour l\'école';
$string['homepage:plans.school1.plan_idmedium'] = 'Moyen';
$string['homepage:plans.school1.plan_idsmall'] = 'Petit';
$string['homepage:plans.school1.plan_tiny'] = 'Minuscule';
$string['homepage:sitelimit'] = '** Limite d\'un site par client';
$string['homepage:taxes'] = '* Plus taxes, le cas échéant';
$string['langconfig:direction'] = 'ltr';
$string['langconfig:langname'] = 'Français';
$string['login:brandname'] = 'MoodleCloud';
$string['login:gotoportal'] = 'Aller au portail';
$string['login:logout'] = 'Se déconnecter';
$string['login:security.login.password'] = 'Mot de passe';
$string['login:security.login.password_placeholder'] = 'Mot de passe';
$string['login:security.login.submit'] = 'Connexion';
$string['login:security.login.username'] = 'Nom du site MoodleCloud';
$string['login:security.login.username_placeholder'] = 'monsite';
$string['login:security.token.invalid'] = 'La connexion au portail a échouée. Veuillez réessayer.';
$string['login:signup.login.panel.title'] = 'Se connecter';
$string['messages:auditlog.administrator'] = 'Équipe d\'administration MoodleCloud';
$string['messages:auditlog.automatedtool'] = 'Robot MoodleCloud';
$string['messages:auditlog.site.removalComplete'] = 'Le site a été supprimé';
$string['messages:auditlog.site.removalQueued'] = 'La suppression du site a été demandée';
$string['messages:close'] = 'Fermer';
$string['plans:packages.free'] = 'Moodle gratuit';
$string['plans:packages.school'] = 'Moodle pour écoles';
$string['plans:plans.free.0.description'] = 'Moodle gratuit';
$string['plans:plans.free.0.name'] = 'Gratuit';
$string['plans:plans.school_1000.0.description'] = 'Moodle pour écoles de taille moyenne';
$string['plans:plans.school_1000.0.name'] = 'Moyenne';
$string['plans:plans.school_250.0.description'] = 'Moodle pour écoles de très petite taille';
$string['plans:plans.school_250.0.name'] = 'Très petit';
$string['plans:plans.school_500.0.description'] = 'Moodle pour écoles de petite taille';
$string['plans:plans.school_500.0.name'] = 'Petit';
$string['pluginname'] = 'Chaînes de caractères de MoodleCloud';
$string['portal:addons.School_1000_0.title'] = 'Moodle pour écoles / Moyen';
$string['portal:addons.buttons.add'] = 'Ajouter';
$string['portal:addons.buttons.remove'] = 'Supprimer';
$string['portal:addons.buttons.removing'] = 'Suppression';
$string['portal:addons.errors.doesnotexist'] = 'Le plugin que vous avez indiqué n\'existe pas.';
$string['portal:addons.nostudentads.flashes.enabled'] = 'Merci de votre soutien ! Les publicités ne s\'afficheront plus pour les étudiants sur votre site.';
$string['portal:addons.nostudentads.label'] = 'Publicités';
$string['portal:addons.nostudentads.removalconfirmation.title'] = 'Supprimer le plugin';
$string['portal:addons.panel.title'] = 'Plugins';
$string['portal:addons.pay'] = 'Procéder au paiement';
$string['portal:addons.strings.cost'] = '%price% %currency%';
$string['portal:addons.strings.month'] = 'mois';
$string['portal:addons.strings.price'] = '%price% %currency% / %period%';
$string['portal:billing.billingdetails.change.fields.cancel'] = 'Annuler';
$string['portal:billing.billingdetails.change.fields.save'] = 'Effectuer le paiement';
$string['portal:billing.billingdetails.change.labels.ccname'] = 'Nom du titulaire de la carte';
$string['portal:billing.billingdetails.change.labels.ccnumber'] = 'Numéro de carte de crédit';
$string['portal:billing.billingdetails.change.labels.cvv'] = 'CVV';
$string['portal:billing.billingdetails.change.labels.expiration'] = 'Échéance MM/AA';
$string['portal:billing.billingdetails.change.panel.cardrequiredbecause'] = 'Les informations de votre carte de crédit sont enregistrées chez notre partenaire de confiance PayPal.';
$string['portal:billing.billingdetails.change.panel.title'] = 'Infos carte de crédit';
$string['portal:billing.billingdetails.change.panel.verificationamount'] = 'Pour vérifier les infos de votre carte de crédit, un petit montant (par exemple 1 €) sera débité de votre carte de crédit, puis re-crédité après quelques jours.';
$string['portal:billing.billingdetails.change.placeholders.ccname'] = 'Jean Dupond';
$string['portal:billing.billingdetails.change.placeholders.expiration'] = 'MM/AA';
$string['portal:billing.billingdetails.set.fields.pay'] = 'Effectuer le paiement';
$string['portal:billing.billingdetails.set.fields.save'] = 'Suivant';
$string['portal:billing.billingdetails.strings.changepaymentdetails'] = 'Modifier les infos de paiement';
$string['portal:billing.billingdetails.strings.usethis'] = 'Utiliser cette méthode de paiement';
$string['portal:billing.paymentMethods.mastercard'] = 'MasterCard';
$string['portal:billing.paymentMethods.types.creditcard'] = 'Carte de crédit';
$string['portal:billing.paymentMethods.types.paypal'] = 'PayPal';
$string['portal:billing.paymentMethods.visa'] = 'Visa';
$string['portal:billing.receipt.amount'] = 'Montant';
$string['portal:billing.receipt.billedto'] = 'Facturé à';
$string['portal:billing.receipt.cardnumber'] = 'Numéro de carte';
$string['portal:billing.receipt.date'] = 'Date de la facture';
$string['portal:billing.receipt.email'] = 'Courriel';
$string['portal:billing.receipt.lineitems.description'] = 'Description';
$string['portal:billing.receipt.lineitems.total'] = 'Montant total';
$string['portal:billing.receipt.name'] = 'Nom';
$string['portal:billing.receipt.paypalaccount'] = 'Compte PayPal';
$string['portal:billing.receipt.reference'] = 'Référence facture';
$string['portal:billing.receipt.summary.chargedto'] = 'Facturé à';
$string['portal:billing.receipt.url'] = 'URL';
$string['portal:billing.subscriptions.panel.title'] = 'Paiements récurrents';
$string['portal:billing.subscriptions.table.nextBillingDate.title'] = 'Date du prochain paiement';
$string['portal:billing.subscriptions.table.nextBillingPeriodAmount.title'] = 'Montant';
$string['portal:billing.subscriptions.table.status.title'] = 'Statut';
$string['portal:billing.transactions.statuses.settlement_pending.title'] = 'Autorisé';
$string['portal:billing.transactions.statuses.settling.title'] = 'Autorisé';
$string['portal:billing.transactions.statuses.submitted_for_settlement.title'] = 'Autorisé';
$string['portal:billing.transactions.statuses.unrecognized.title'] = 'Inconnu';
$string['portal:billing.transactions.table.amount.title'] = 'Montant';
$string['portal:billing.transactions.table.creationDate.title'] = 'Date';
$string['portal:billing.transactions.table.status.title'] = 'Statut';
$string['portal:graphs.axes.dbsize'] = 'Taille de la base de données';
$string['portal:graphs.axes.filesize'] = 'Taille de fichier';
$string['portal:graphs.axes.users'] = 'Utilisateurs';
$string['portal:graphs.filetypes.application'] = 'Données de l\'application';
$string['portal:graphs.filetypes.audio'] = 'Audio';
$string['portal:graphs.filetypes.example'] = 'Exemple';
$string['portal:graphs.filetypes.image'] = 'Images';
$string['portal:graphs.filetypes.message'] = 'Messages';
$string['portal:graphs.filetypes.model'] = 'Modèles';
$string['portal:graphs.filetypes.text'] = 'Texte';
$string['portal:graphs.filetypes.video'] = 'Vidéos';
$string['portal:historical.fetchfailure.title'] = 'Oh non !';
$string['portal:list.body.title'] = 'Portail';
$string['portal:list.table.titles.location'] = 'Emplacement géographique';
$string['portal:list.table.titles.site'] = 'Site';
$string['portal:list.table.titles.subdomain'] = 'Sous-domaines';
$string['portal:messages.csrffailure'] = 'Impossible de confirmer les modifications. Veuillez réessayer.';
$string['portal:messages.removalqueued'] = 'En attente de suppression';
$string['portal:messages.sitenotfound'] = 'Le site ne peut être chargé. Veuillez réessayer.';
$string['portal:page.body.title'] = 'Portail';
$string['portal:page.tabs.paymentdetails'] = 'Détails du paiement';
$string['portal:page.tabs.statistics'] = 'Statistiques';
$string['portal:page.tabs.support'] = 'Support';
$string['portal:page.tabs.tools'] = 'Outils';
$string['portal:page.title'] = 'MoodleCloud : portail';
$string['portal:plans.plans.MCFREE.cost'] = 'Gratuit';
$string['portal:purchases.confirmationpage.cancel'] = 'Non merci';
$string['portal:siteinfo.page.title'] = 'MoodleCloud : détails du site pour SUBDOMAIN';
$string['portal:siteinfo.panels.historical.title'] = 'Statistiques';
$string['portal:siteinfo.panels.info.limit_disk'] = '%maxbytes% Mo d\'espace disque';
$string['portal:siteinfo.panels.info.limit_users'] = '%maxusers% utilisateurs';
$string['portal:siteinfo.panels.info.limits'] = 'Limites';
$string['portal:siteinfo.panels.info.location'] = 'Localisation';
$string['portal:siteinfo.panels.info.sitename'] = 'Nom du site';
$string['portal:siteinfo.panels.info.status'] = 'État';
$string['portal:siteinfo.panels.info.title'] = 'Informations';
$string['portal:siteinfo.panels.info.version'] = 'Version';
$string['portal:siteinfo.panels.statistics.title'] = 'Statistiques';
$string['portal:statistics.fetchfailure.lead'] = 'Nous sommes désolés de ne pouvoir extraire vos statistiques actuelles. Il est possible que celles-ci soient disponibles si vous revenez plus tard.';
$string['portal:statistics.fetchfailure.title'] = 'Oh non !';
$string['portal:statistics.graphs.databasesize'] = 'Taille de la base de données';
$string['portal:statistics.graphs.files'] = 'Fichiers';
$string['portal:statistics.graphs.users'] = 'Utilisateurs';
$string['portal:support.title'] = 'Besoin d\'aide avec votre site Moodle ?';
$string['portal:tasks.removal.warning.html'] = '<h1>Bonjour de MoodleCloud !</h1>
<p>Nous avons remarqué que vous n\'avez pas utilisé votre site MoodleCloud <a href="%url%">%fqdn%</a> dans les 60 derniers jours.</p>
<p>Comme spécifié dans nos conditions d\'utilisation, nous supprimerons votre site après %day% %month% %year%.</p>
<p>Vous pouvez éviter cela en <a href="%url%/login/index.php">vous connectant</a> avant cette date.</p>
<p>Si vous souhaitez nous expliquer pourquoi vous n\'utilisez pas votre site MoodleCloud, veuillez remplir <a href="https://www.surveymonkey.com/r/moodlecloud-inactive">ce court questionnaire</a>.</p>

<p>Merci d\'avoir essayé notre service,</p>
<p>L\'équipe MoodleCloud</p>';
$string['portal:tasks.removal.warning.plain'] = 'Bonjour !

Nous avons remarqué que vous n\'avez pas utilisé votre site MoodleCloud  %fqdn% dans les 60 derniers jours.

Comme spécifié dans nos conditions d\'utilisation, nous supprimerons votre site après %day% %month% %year%.

Vous pouvez éviter cela en vous connectant avant cette date sur %url%/login/index.php.

Si vous souhaitez nous expliquer pourquoi vous n\'utilisez pas votre site MoodleCloud, veuillez remplir ce court questionnaire : https://www.surveymonkey.com/r/moodlecloud-inactive

Merci d\'avoir essayé notre service,
L\'équipe MoodleCloud';
$string['portal:tasks.removal.warning.title'] = 'Le site MoodleCloud "%subdomain%" est inactif et sera bientôt supprimé';
$string['portal:view.actionpending.panel.body'] = 'Changements en cours';
$string['portal:view.billing.payment.success'] = 'Votre paiement a bien été effectué.';
$string['portal:view.danger.modal.buttons.cancel'] = 'Annuler';
$string['portal:view.danger.modal.buttons.continue'] = 'Oui, veuillez supprimer mon site';
$string['portal:view.danger.modal.lead'] = 'En confirmant ci-dessous, vous confirmez que vous avez retiré tout le contenu du site et vous acceptez que le site soit complètement supprimé de nos systèmes.';
$string['portal:view.danger.modal.title'] = 'Confirmer la suppression';
$string['portal:view.danger.panel.body.buttons.remove'] = 'Supprimer mon site MoodleCloud';
$string['portal:view.danger.panel.body.buttons.title'] = 'Voulez-vous vraiment nous quitter ?';
$string['portal:view.danger.panel.body.lead'] = '<p>Une fois le site supprimé, il sera bel et bien détruit pour de bon.</p>
<p>Veuillez vous assurer de ne plus en avoir besoin et d\'avoir récupéré tout le contenu que vous souhaitez conserver.</p>';
$string['portal:view.danger.panel.body.title'] = 'Supprimer mon site MoodleCloud';
$string['portal:view.danger.panel.title'] = 'Trucs dangereux';
$string['portal:view.export.panel.button'] = 'Exporter ce site';
$string['portal:view.export.panel.lead'] = 'Exporter ce site';
$string['portal:view.export.panel.title'] = 'Vos données MoodleCloud';
$string['regions:au'] = 'Australie';
$string['signup:auditlog.account.created'] = 'Nouveau compte utilisateur créé';
$string['signup:authcode.body.lead_email'] = 'Vérifiez votre boîte d\'entrée ! Nous avons envoyé un code de vérification temporaire à %email%. Entrez votre code de vérification ci-dessous.';
$string['signup:authcode.body.lead_phone'] = 'Nous avons envoyé un code de vérification temporaire à %phonenumber%. Entrez votre code de vérification ci-dessous.';
$string['signup:authcode.body.links.nocodereceived'] = 'Je n\'ai pas reçu mon code';
$string['signup:authcode.body.links.startover'] = 'Vous voulez recommencer ?  <a href="%link%">Repartons depuis le début</a>.';
$string['signup:authcode.body.title'] = 'Vérifier votre identité';
$string['signup:authcode.form.fields.authcode'] = 'Code de vérification';
$string['signup:authcode.form.fields.continue'] = 'Suivant';
$string['signup:authcode.form.placeholders.authcode'] = '123456';
$string['signup:authcode.modal.button'] = 'Fermer';
$string['signup:authcode.modal.link'] = 'Visitez la FAQ pour plus de détails.';
$string['signup:authcode.modal.title'] = 'Je n\'ai pas reçu mon code';
$string['signup:errors.blacklistinline'] = 'Désolé, ce site n\'est pas disponible.';
$string['signup:errors.invalidinline'] = 'Désolé, le nom du site doit contenir entre 3 et 53 caractères et n\'être composé que des lettres a-z, de nombres ou du trait d\'union.';
$string['signup:errors.maxsites'] = 'Un utilisateur ayant le même numéro de téléphone existe déjà. Les utilisateurs ne peuvent créer qu\'un seul site MoodleCloud.';
$string['signup:errors.reserved'] = 'Ah, dommage, quelqu\'un a déjà pris ce nom-là.';
$string['signup:messages.failedvalidationcode'] = 'Quelque chose ne vas pas avec ce code. Êtes-vous certain de l\'avoir tapé correctement ?';
$string['signup:messages.passwordupdated'] = 'Excellent ! Nous avons mis à jour votre mot de passe. Vous pouvez l\'utiliser pour vous connecter à votre site MoodleCloud.';
$string['signup:messages.validationcode'] = '%code% est votre code de vérification pour %subdomain%.moodlecloud.com.';
$string['signup:nopassword.body.continue'] = 'Suivant';
$string['signup:page.title'] = 'MoodleCloud : enregistrez-vous pour avoir votre site Moodle gratuit';
$string['signup:password.body.title'] = 'Choisissez un mot de passe';
$string['signup:password.form.fields.password'] = 'Nouveau mot de passe (minimum 5 caractères)';
$string['signup:password.form.fields.password_confirmation'] = 'Et une deuxième fois, pour être bien certain';
$string['signup:password.form.fields.save'] = 'Suivant';
$string['signup:payment.body.title'] = 'Choisissez votre méthode de paiement';
$string['signup:payment.form.fields.continue'] = 'Suivant';
$string['signup:personal.body.lead'] = 'Nous avons uniquement besoin de savoir qui vous êtes et d\'être certain que vous acceptez nos Conditions Générales d\'Utilisation.';
$string['signup:personal.body.title'] = 'Votre site est disponible !';
$string['signup:personal.form.fields.city'] = 'Ville';
$string['signup:personal.form.fields.continue'] = 'Suivant';
$string['signup:personal.form.fields.country'] = 'Pays';
$string['signup:personal.form.fields.email'] = 'Adresse de courriel';
$string['signup:personal.form.fields.firstname'] = 'Prénom';
$string['signup:personal.form.fields.lastname'] = 'Nom';
$string['signup:personal.form.fields.organisationtype.other'] = 'Autre';
$string['signup:personal.form.fields.password'] = 'Mot de passe';
$string['signup:personal.form.fields.personalrole'] = 'Votre rôle';
$string['signup:personal.form.fields.phonenumber'] = 'Numéro de téléphone portable';
$string['signup:personal.form.fields.tandc'] = 'Pour continuer, vous devez accepter nos Conditions Générales d\'Utilisation';
$string['signup:personal.form.fields.timezone'] = 'Votre fuseau horaire';
$string['signup:personal.form.placeholders.country'] = 'Sélectionner…';
$string['signup:personal.form.placeholders.organisationtype'] = 'Sélectionner…';
$string['signup:personal.form.placeholders.timezone'] = 'Sélectionnez votre fuseau horaire';
$string['signup:provision_mail.page.html'] = '<h1>Bienvenue sur le MoodleCloud !</h1>
<p>Votre site Moodle gratuit <a href="%url%">%url%</a> a bien été créé.</p>
<p>Vous pouvez vous y connecter avec le nom d\'utilisateur « admin » et le mot de passe que vous avez choisi lors de votre inscription.</p>
<p>Votre site gratuit est limité à 50 utilisateurs actifs et a un quota d\'espace disque de 200 Mo.</p>
<p>Conseils :</p>
<ul>
<li>vous pouvez supprimer les utilisateurs inactifs de votre site, afin de pouvoir en accueillir de nouveaux ;</li>
<li>pour éviter de dépasser votre quota d\'espace disque, vous pouvez utiliser des ressources publiques disponibles sur internet, telles que des sites web, des vidéos sur Youtube, etc.</li>
</ul>
<p>Pour faire le suivi de l\'utilisation que votre site fait des ressources (espace disque et utilisateurs), connectez-vous au portail moodlecloud.com. Utilisez le nom « %subdomain% » ainsi que le mot de passe que vous avez choisi pour l\'administrateur de votre site.</p>
<p>Chaleureusement,</p>
<p>L\'équipe MoodleCloud</p>';
$string['signup:provision_mail.page.plain'] = 'Bienvenue sur le MoodleCloud !
Votre site Moodle gratuit %url% a bien été créé.
Vous pouvez vous y connecter avec le nom d\'utilisateur « admin » et le mot de passe que vous avez choisi lors de votre inscription.
Votre site gratuit est limité à 50 utilisateurs actifs et a un quota d\'espace disque de 200 Mo.
Conseils :
 - vous pouvez supprimer les utilisateurs inactifs de votre site, afin de pouvoir en accueillir de nouveaux ;
 - Pour éviter de dépasser votre quota d\'espace disque, vous pouvez utiliser des ressources publiques disponibles sur internet, telles que des sites web, des vidéos sur Youtube, etc.

Pour faire le suivi de l\'utilisation que votre site fait des ressources (espace disque et utilisateurs), connectez-vous au portail moodlecloud.com. Utilisez le nom « %subdomain% » ainsi que le mot de passe que vous avez choisi pour l\'administrateur de votre site.

Chaleureusement,
L\'équipe MoodleCloud';
$string['signup:provision_mail.page.title'] = 'Votre site MoodleCloud %fqdn% est prêt !';
$string['signup:provision_mail.subject'] = 'Votre site MoodleCloud %site.fqdn% est prêt !';
$string['signup:reserve.available'] = 'Super ! Le nom de votre site est disponible.';
$string['signup:reserve.body.lead'] = 'Choisissez le nom de votre site ainsi que sa localisation (le lieu où il sera hébergé, nous recommandons un lieu près de vous et de vos étudiants).';
$string['signup:reserve.body.title'] = 'Donnez un nom à votre site MoodleCloud';
$string['signup:reserve.form.fields.continue'] = 'Suivant';
$string['signup:reserve.form.fields.region'] = 'Localisation de l\'hébergement';
$string['signup:reserve.form.fields.subdomain'] = 'Nom du site';
$string['signup:reserve.form.placeholders.subdomain'] = 'votre-site.moodlecloud.com';
$string['signup:reserve.form.tooltips.region'] = 'Ceci est le lieu où votre site sera hébergé. Nous recommandons un lieu près de vous et de vos étudiants.';
$string['signup:status.body.ariasetupcomplete'] = 'La configuration de votre site est terminée. Vous pouvez maintenant vous connecter.';
$string['signup:status.body.lead'] = '<p>Allez hop, c\'est fait !</p>
<p>Vous l\'espériez, vous l\'avez, votre propre site Moodle.</p>
<p>Plongez et continuez la création de votre parfait espace d\'apprentissage en ligne.</p>';
$string['signup:status.body.login'] = 'Connexion';
$string['signup:status.body.title'] = 'Terminé ! Votre propre site Moodle, gratuitement !';
$string['signup:steps.x'] = 'Étape %x%';
$string['signup:steps.xofy'] = 'Étape %x% sur %y%';
$string['signup:support.body.portal.title'] = 'Portail';
$string['signup:support.body.support.title'] = 'Support';
$string['signup:support.head.title'] = 'Succès !';
$string['signup:terms.title'] = 'Conditions Générales d\'Utilisation de MoodleCloud';
$string['signup:texts.statustitle'] = 'Vous l\'espériez. Votre propre site Moodle, gratuitement !';
$string['signup:usertype.form.fields.existing'] = 'Connexion';
$string['signup:usertype.form.fields.new'] = 'Créer un nouveau compte';
$string['signup:verification_mail.page.html'] = '<h1>Vérifiez votre adresse de courriel.</h1>
<p>Votre code de vérification MoodleCloud est : %code%. Copiez ce code dans l\'écran de vérification pour valider votre compte.</p>
<p>L\'équipe MoodleCloud</p>';
$string['signup:verification_mail.page.plain'] = 'Vérifiez votre adresse de courriel.

Votre code de vérification MoodleCloud est : %code%. Copiez ce code dans l\'écran de vérification pour valider votre compte.

L\'équipe MoodleCloud';
$string['signup:verification_mail.page.title'] = 'Code de vérification MoodleCloud';
$string['status:label.expired'] = 'Supprimé pour cause d\'inactivité';
$string['status:label.pendingIdentityConfirmation'] = 'En attente de vérification';
$string['status:label.pendingProvision'] = 'En cours de création';
$string['status:label.pendingRemoval'] = 'En attente de suppression';
$string['status:label.provisioned'] = 'Actif';
$string['status:label.removed'] = 'Supprimé';
$string['status:label.reserved'] = 'Réservé';
$string['status:tooltip.expired'] = 'Ce site a été supprimé de nos systèmes pour cause d\'inactivité';
$string['status:tooltip.pendingIdentityConfirmation'] = 'Ce site a été réservé et un SMS de confirmation a été envoyé.';
$string['status:tooltip.pendingProvision'] = 'Ce site a été envoyé à notre système d\'installation et vous y aurez accès sous peu !';
$string['status:tooltip.pendingRemoval'] = 'Ce site est en attente de suppression et sera bientôt supprimé de nos systèmes.';
$string['status:tooltip.provisioned'] = 'Ce site est actif et disponible.';
$string['status:tooltip.removed'] = 'Ce site a été supprimé.';
$string['telephony:lookup.invalidnumber'] = 'Numéro de téléphone invalide';
$string['telephony:lookup.notacellphone'] = 'Vous devez indiquer un numéro de téléphone valide';
$string['validators:fos_user.current_password.invalid'] = 'Le mot de passe saisi est invalide';
$string['validators:fos_user.email.already_used'] = 'L\'adresse de courriel est déjà utilisée';
$string['validators:fos_user.email.blank'] = 'Veuillez saisir une adresse de courriel';
$string['validators:fos_user.email.invalid'] = 'L\'adresse de courriel n\'est pas valide';
$string['validators:fos_user.email.long'] = '[-Inf,Inf]L\'adresse de courriel est trop longue';
$string['validators:fos_user.email.short'] = '[-Inf,Inf]L\'adresse de courriel est trop courte';
$string['validators:fos_user.group.blank'] = 'Veuillez saisir un nom';
$string['validators:fos_user.group.long'] = '[-Inf,Inf]Le nom est trop long';
$string['validators:fos_user.group.short'] = '[-Inf,Inf]Le nom est trop court';
$string['validators:fos_user.new_password.blank'] = 'Veuillez saisir un nouveau mot de passe';
$string['validators:fos_user.new_password.short'] = '[-Inf,Inf]Le nouveau mot de passe est trop court';
$string['validators:fos_user.password.blank'] = 'Veuillez saisir un mot de passe';
$string['validators:fos_user.password.mismatch'] = 'Les mots de passe saisis ne correspondent pas';
$string['validators:fos_user.password.short'] = '[-Inf,Inf]Le mot de passe est trop court';
$string['validators:fos_user.username.already_used'] = 'Le nom d\'utilisateur est déjà utilisé';
$string['validators:fos_user.username.blank'] = 'Veuillez saisir un nom d\'utilisateur';
$string['validators:fos_user.username.long'] = '[-Inf,Inf]Le nom d’utilisateur est trop long';
$string['validators:fos_user.username.short'] = '[-Inf,Inf]Le nom d\'utilisateur est trop court';
$string['validators:signup.country.mustexist'] = 'Veuillez sélectionner votre pays.';
$string['validators:signup.email.format'] = 'Veuillez saisir une adresse de courriel valide.';
$string['validators:signup.email.mismatch'] = 'Les adresses de courriel que vous avez saisies ne correspondent pas.';
$string['validators:signup.email.mustexist'] = 'Veuillez saisir une adresse de courriel valide.';
$string['validators:signup.phone.mustexist'] = 'Veuillez saisir votre numéro de téléphone mobile.';
$string['validators:signup.status.password_length'] = 'Votre mot de passe doit faire 5 caractères ou plus.';
$string['validators:signup.status.password_mismatch'] = 'Les mots de passe que vous avez saisis ne correspondent pas.';
$string['validators:signup.tandc.mustagree'] = 'Pour utiliser MoodleCloud, vous devez accepter nos Conditions Générales d\'Utilisation.';
$string['validators:signup.timezone.mustselect'] = 'Veuillez choisir votre fuseau horaire';
$string['validators:site.firstname.mustexist'] = 'Veuillez spécifier votre prénom.';
$string['validators:site.lastname.mustexist'] = 'Veuillez spécifier votre nom de famille.';
$string['validators:site.subdomain.maxlength'] = 'Les sous-domaines ne doivent pas excéder 53 caractères.';
$string['validators:site.subdomain.minlength'] = 'Les sous-domaines doivent faire au moins 3 caractères.';
$string['validators:site.subdomain.mustexist'] = 'Vous devez spécifier un sous-domaine.';
