<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'et', version '3.9'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'P';
$string['Afull'] = 'Puudub';
$string['Eacronym'] = 'V';
$string['Efull'] = 'Vabastatud';
$string['Lacronym'] = 'H';
$string['Lfull'] = 'Hilines';
$string['Pacronym'] = 'K';
$string['Pfull'] = 'Olevik';
$string['absenteereport'] = 'Puudujate aruanne';
$string['acronym'] = 'Akronüüm';
$string['add'] = 'Lisa';
$string['addedrecip'] = 'Lisati {$a} uus vastuvõtja';
$string['addedrecips'] = 'Lisati {$a} uued vastuvõtjad';
$string['addmultiplesessions'] = 'Mitu tundi';
$string['addsession'] = 'Lisa tund';
$string['adduser'] = 'Lisa kasutaja';
$string['addwarning'] = 'Lisa hoiatus';
$string['all'] = 'Kõik';
$string['allcourses'] = 'Kõik kursused';
$string['allpast'] = 'Kogu minevik';
$string['allsessions'] = 'Kõik tunnid';
$string['attendance:addinstance'] = 'Lisa uus osalustegevus';
$string['attendance:canbelisted'] = 'Ilmub nimekirjas';
$string['attendance:changeattendances'] = 'Muudan osalemisi';
$string['attendance:changepreferences'] = 'Muudan eelistusi';
$string['attendance:export'] = 'Ekspordi aruanded';
$string['attendance:manageattendances'] = 'Halda osalemisi';
$string['attendance:managetemporaryusers'] = 'Halda ajutisi kasutajaid';
$string['attendance:takeattendances'] = 'Osalejate arvestamine';
$string['attendance:view'] = 'Vaatan osalejaid';
$string['attendance:viewreports'] = 'Vaatan aruandeid';
$string['attendance:viewsummaryreports'] = 'Vaata kursuse kokkuvõtvaid aruandeid';
$string['attendance:warningemails'] = 'Saab tellida e-kirju koos puuduvate kasutajatega';
$string['attendance_already_submitted'] = 'Sinu osalemine on juba seatud';
$string['attendance_no_status'] = 'Kehtivat staatust ei ole saadaval -  osalemise registreerimiseks võib olla liiga hilja';
$string['attendancedata'] = 'Osalemise andmed';
$string['attendancefile'] = 'Osalemise fail (csv formaat)';
$string['attendancefile_help'] = 'Fail peab olema CSV-fail koos päiserea ja väljadega, mis võimaldavad tuvastada kasutaja ja registreerimise kellaaega nt (meiliaadress, vähene aeg) või (kasutajanimi, kellaaeg)';
$string['attendanceforthecourse'] = 'Kursusel osalemine';
$string['attendancegrade'] = 'Osalemise hinne';
$string['attendancenotset'] = 'Sa pead oma osalemise määrama';
$string['attendancenotstarted'] = 'Selle kursuse jaoks ei ole osalemise määramine veel võimalik';
$string['attendancepercent'] = 'Osalemisprotsent';
$string['attendancereport'] = 'Osalemisaruanne';
$string['attendanceslogged'] = 'Osalemine on registreeritud';
$string['attendancestaken'] = 'Toimus osalemine';
$string['attendancesuccess'] = 'Osalemine on edukalt läbi viidud';
$string['attendanceupdated'] = 'Osalemine edukalt uuendatud';
$string['attrecords'] = 'Osalemiste arvestus';
$string['autoassignstatus'] = 'Vali automaatselt kõrgeim vaba staatus';
$string['autoassignstatus_help'] = 'Selle valimisel määratakse õpilastele automaatselt kõrgeim saadaolev hinne.';
$string['automark'] = 'Automaatne märkimine';
$string['automark_help'] = 'Võimaldab märgistuse automaatselt lõpule viia.
Kui "Jah" märgitakse õpilased automaatselt, sõltuvalt nende esimesest juurdepääsust kursusele.
Kui valik „Määra tunni lõpus märkimata olekusse”, määratakse kõigile õpilastele, kes pole oma kohalolekut märkinud, valitud märgistamata olek.';
$string['automarkall'] = 'Jah';
$string['automarkclose'] = 'Määra tunni lõpus märkimata olekusse';
$string['automarktask'] = 'Kontrolli osalemistunde, mis nõuavad automaatset märgistamist';
$string['autorecorded'] = 'süsteem on automaatselt salvestatud';
$string['averageattendance'] = 'Keskmine osalemine';
$string['averageattendancegraded'] = 'Keskmine osalemine';
$string['backtoparticipants'] = 'Tagasi osalejate nimekirja juurde';
$string['below'] = 'Alla {$a}%';
$string['calclose'] = 'Sulge';
$string['calendarevent'] = 'Loo tunni jaoks kalendrisündmus';
$string['calendarevent_help'] = 'Kui see on lubatud, luuakse selle tunni jaoks kalendrisündmus.
Kui see on keelatud, kustutatakse kõik selle tunni olemasolevad kalendrisündmused.';
$string['caleventcreated'] = 'Tunni kalendrisündmus on edukalt loodud';
$string['caleventdeleted'] = 'Tunni kalendrisündmus on edukalt kustutatud';
$string['calmonths'] = 'Jaanuar,Veebruar,Märts,Aprill,Mai,Juuni,Juuli,August,September,Oktoober,November,Detsember';
$string['calshow'] = 'Vali kuupäev';
$string['caltoday'] = 'Täna';
$string['calweekdays'] = 'P, E, T, K, N, R, L';
$string['cannottakeforgroup'] = 'Sa ei saa osaleda grupis "{$a}"';
$string['cantaddstatus'] = 'Uue oleku lisamisel pead määrama akronüümi ja kirjelduse.';
$string['categoryreport'] = 'Kursuse kategooria aruanne';
$string['changeattendance'] = 'Muuda osalemist';
$string['changeduration'] = 'Muuda kestvust';
$string['changesession'] = 'Muuda tundi';
$string['checkweekdays'] = 'Vali tööpäevad, mis jäävad sinu valitud tunni kuupäevavahemikku.';
$string['closed'] = 'See tund ei ole praegu isemärgistamiseks saadaval';
$string['column'] = 'veerg';
$string['columnmap'] = 'Veergude kaardistamine';
$string['columnmap_help'] = 'Vali kõigi esitatud väljade jaoks vastav veerg csv-failis.';
$string['columns'] = 'veerud';
$string['commonsession'] = 'Kõik õpilased';
$string['commonsessions'] = 'Kõik õpilased';
$string['confirm'] = 'Kinnita';
$string['confirmcolumnmappings'] = 'Kinnita veeru kaardistamised';
$string['confirmdeletehiddensessions'] = 'Kas soovid kindlasti kustutada enne kursuse alguskuupäeva ({$a->date}) planeeritud
{$a->count} tundi?';
$string['confirmdeleteuser'] = 'Kas oled kindel et soovid kustutada kasutaja \'{$a->fullname}\' ({$a->email})?<br/>Kogu nende osalemine eemaldatakse jäädavalt.';
$string['copyfrom'] = 'Kopeeri kohaloleku andmed asukohast';
$string['countofselected'] = 'Valitud arv';
$string['course'] = 'Kursus';
$string['coursemessage'] = 'Saada kursuse kasutajatele sõnum';
$string['courseshortname'] = 'Kursuse lühinimi';
$string['coursesummary'] = 'Kursust kokkuvõttev aruanne';
$string['createmultiplesessions'] = 'Loo mitu tundi';
$string['createonesession'] = 'Loo üks tund selle kursuse jaoks';
$string['csvdelimiter'] = 'CSV eraldaja';
$string['currentlyselectedusers'] = 'Hetkel valitud kasutajad';
$string['date'] = 'Kuupäev';
$string['days'] = 'Päevad';
$string['defaultdisplaymode'] = 'Vaikekuva režiim';
$string['defaults'] = 'Vaikimisi';
$string['defaultsessionsettings'] = 'Vaikimisi tunni sätted';
$string['defaultsessionsettings_help'] = 'Need seaded määravad kõikide uute tundide vaikesätted';
$string['defaultsettings'] = 'Vaikimisi osalemise seaded';
$string['defaultsettings_help'] = 'Need seaded määravad kõigi uute osavõttude vaikeväärtused';
$string['defaultstatus'] = 'Vaikimisi staatus määratud';
$string['defaultsubnet'] = 'Vaikimisi võrguaadress';
$string['defaultsubnet_help'] = 'Osalemise registreerimine võib piirduda teatud alamvõrkudega, määrates komaga eraldatud osaliste või täielike IP-aadresside loendi. See on vaikeväärtus, mida kasutatakse uute tundide loomisel.';
$string['defaultview'] = 'Vaikevaade sisselogimisel';
$string['defaultview_desc'] = 'See on vaikevaade, mida õpetajatele esimesel sisselogimisel kuvatakse.';
$string['defaultwarnings'] = 'Vaikehoiatuste komplekt';
$string['defaultwarningsettings'] = 'Hoiatuste vaikeseaded';
$string['defaultwarningsettings_help'] = 'Need seaded määratlevad kõigi uute hoiatuste vaikesätted';
$string['delete'] = 'Kustuta';
$string['deletecheckfull'] = 'Kas oled kindel, et soovid {$a}, sealhulgas kõik kasutajaandmed, täielikult kustutada?';
$string['deletedgroup'] = 'Selle tunniga seotud rühm on kustutatud';
$string['deletehiddensessions'] = 'Kustuta kõik peidetud tunnid';
$string['deletelogs'] = 'Kustuta osalemise andmed';
$string['deleteselected'] = 'Kustutamine valitud';
$string['deletesession'] = 'Kustuta tund';
$string['deletesessions'] = 'Kustuta kõik tunnid';
$string['deleteuser'] = 'Kustuta kasutaja';
$string['deletewarningconfirm'] = 'Kas soovid kindlasti selle hoiatuse kustutada?';
$string['deletingsession'] = 'Kursuse tunni kustutamine';
$string['deletingstatus'] = 'Kursuse oleku kustutamine';
$string['description'] = 'Kirjeldus';
$string['display'] = 'Kuva';
$string['displaymode'] = 'Kuva režiim';
$string['donotusepaging'] = 'Ära kasuta lehitsemist';
$string['downloadexcel'] = 'Laadi alla Exceli formaadis';
$string['downloadooo'] = 'Laadi alla OpenOffice formaadis';
$string['downloadtext'] = 'Laadi alla tekstiformaadis';
$string['duration'] = 'Kestus';
$string['editsession'] = 'Muuda tundi';
$string['edituser'] = 'Muuda kasutajat';
$string['emailcontent'] = 'E-maili sisu';
$string['emailcontent_default'] = 'Tere %userfirstname%,
Sinu osavõtt %coursename% %attendancename% -st on langenud alla %warningpercent%  ja on praegu %percent% - loodame, et sul on kõik korras!

Selle kursuse maksimaalseks kasutamiseks peaksid parandama oma külastatavust. Võta ühendust, kui vajad täiendavat tuge.';
$string['emailcontent_help'] = 'Kui hoiatus saadetakse õpilasele, võtab ta emaili sisu sellelt väljalt. Järgnevad metamärke võidakse kasutada:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'E-maili teema';
$string['emailsubject_default'] = 'Osalemise hoiatus';
$string['emailsubject_help'] = 'Kui õpilasele saadetakse hoiatus, võetakse sellelt väljalt meilisõnumi teema.';
$string['emailuser'] = 'Saada kasutajale e-mail';
$string['emailuser_help'] = 'Selle märkimisel saadetakse õpilasele hoiatus.';
$string['emptyacronym'] = 'Tühjad akronüümid ei ole lubatud. Osaluskirjet ei värskendatud.';
$string['emptydescription'] = 'Tühjad kirjeldused ei ole lubatud. Osaluskirjet ei värskendatud.';
$string['enablecalendar'] = 'Loo kalendrisündmused';
$string['enablecalendar_desc'] = 'Kui valitud, luuakse iga osalustunni kohta kalendrisündmus. Selle sätte muutmise järel peaksid kalendriraporti taaskäivitama.';
$string['enablewarnings'] = 'Luba hoiatused';
$string['enablewarnings_desc'] = 'See võimaldab määratleda hoiatuskomplekti külastajatele ja e-posti teel saadetavatele teadetele, kui osalemine langeb alla seadistatud künnise. <br/><strong>HOIATUS: see on uus funktsioon ja seda pole põhjalikult testitud. Kasuta seda omal vastutusel ja paku Moodle\'i foorumites tagasisidet, kui leiad, et see töötab hästi.</strong>';
$string['encoding'] = 'Kodeerimine';
$string['encoding_help'] = 'See viitab õpilaste ID-kaardil kasutatavale vöötkoodi kodeerimise tüübile. Tüüpilised vöötkoodi kodeerimisskeemide tüübid hõlmavad Code-39, Code-128 ja UPC-A.';
$string['endofperiod'] = 'Perioodi lõpp';
$string['endtime'] = 'Tunni lõpuaeg';
$string['enrolmentend'] = 'Kasutaja registreerumine lõpeb {$a}';
$string['enrolmentstart'] = 'Kasutaja registreerumine algab {$a}';
$string['enrolmentsuspended'] = 'Registreerimine on peatatud';
$string['enterpassword'] = 'Sisesta salasõna';
$string['error:coursehasnoattendance'] = 'Lühinimega {$a} kursusel puuduvad osalemistegevused.';
$string['error:coursenotfound'] = 'Kursust lühinimega {$a} ei leitud.';
$string['error:sessioncourseinvalid'] = 'Tunni kursus on vale! Jätan vahele.';
$string['error:sessiondateinvalid'] = 'Tunni kuupäev on vale. Jätan vahele.';
$string['error:sessionendinvalid'] = 'Tunni lõpuaeg on vale. Jätan vahele.';
$string['error:sessionstartinvalid'] = 'Tunni algusaeg on vale. Jätan vahele.';
$string['error:statusnotfound'] = 'Kasutajal: {$a->extuser} on oleku väärtus, mida ei leitud: {$a->status}';
$string['error:userduplicate'] = 'Kasutaja {$a} leiti impordist kaks korda. Palun lisa kasutaja kohta ainult üks kirje.';
$string['error:usernotfound'] = 'Kasutajat, kelle {$a->userfield} oli seatud väärtusele {$a->extuser}, ei leitud';
$string['errorgroupsnotselected'] = 'Vali üks või rohkem rühma';
$string['errorinaddingsession'] = 'Tõrge tunni lisamisel';
$string['erroringeneratingsessions'] = 'Tõrge tunni loomisel';
$string['eventdurationupdated'] = 'Tunni kestvus uuendatud';
$string['eventreportviewed'] = 'Osalemise aruannet on vaadatud';
$string['eventscreated'] = 'Kalendrisündmused loodud';
$string['eventsdeleted'] = 'Kalendrisündmused on kustutatud';
$string['eventsessionadded'] = 'Tund on lisatud';
$string['eventsessiondeleted'] = 'Tund on kustutatud';
$string['eventsessionipshared'] = 'Osalemise isemärkimise IP konflikt';
$string['eventsessionsimported'] = 'Tund on imporditud';
$string['eventsessionupdated'] = 'Tund on uuendatud';
$string['eventstatusadded'] = 'Staatus on lisatud';
$string['eventstatusupdated'] = 'Staatus on uuendatud';
$string['eventstudentattendancesessionsviewed'] = 'Tunni aruannet on vaadatud';
$string['eventtaken'] = 'Osalemine võetud';
$string['eventtakenbystudent'] = 'Osalemine õpilase poolt võetud';
$string['export'] = 'Eksport';
$string['extrarestrictions'] = 'Täiendavad piirangud';
$string['formattexttype'] = 'Vormindamine';
$string['from'] = 'alates:';
$string['gradebookexplanation'] = 'Hinne päevikus';
$string['gradebookexplanation_help'] = 'Osavõtumoodul kuvab sinu praeguse osalushinde, lähtudes tänaseks teenitud punktide arvust. See ei sisalda tulevikus planeeritud tunde. Hinne põhineb sinu praegusel kohalolekuprotsendil ja kogu kursuse kestel, sealhulgas tulevaste teenitavate punktide arvust.

Näiteks kui oled tänaseks teeninud 8 punkti 10-st 10-st (osavõtt 80%) ja kogu kursuse külastatavus on väärt 50 punkti, kuvatakse osalemismoodulis 8/10 ja hinneteraamatus 40/50. Sa ei ole veel teeninud 40 punkti, kuid 40 on võrdne sinu praeguse külastatavuse protsendiga 80%. Punkti väärtus, mille oled teeninud moodulis Osalemine, ei saa kunagi väheneda, kuna see põhineb ainult tänasel kohalviibimisel; hinneteraamatus näidatud kohalolekupunkti väärtus võib aga teie tulevasest osalemisest sõltuvalt suureneda või väheneda, kuna see põhineb kogu kursuse külastatavusel.';
$string['graded'] = 'Hinnatud tunnid';
$string['gridcolumns'] = 'Ruudustiku veerud';
$string['group'] = 'Rühm';
$string['groups'] = 'Rühmad';
$string['groupsession'] = 'Õpilaste rühm';
$string['hiddensessions'] = 'Peidetud tunnid';
$string['hiddensessions_help'] = 'Tunnid on peidetud, kui need on kavandatud enne kursuse alguskuupäeva.

Seda funktsiooni saad kasutada vanemate tundide peitmise asemel, et neid kustutada. Hinderaamatusse kuvatakse ainult nähtavad seansid.';
$string['hiddensessionsdeleted'] = 'Kõik peidetud tunnid kustutati';
$string['hideextrauserdetails'] = 'Peida täiendavad kasutaja andmed';
$string['hidensessiondetails'] = 'Peida tunni detailid';
$string['identifyby'] = 'Tee õpilane kindlaks';
$string['import'] = 'Import';
$string['importfile'] = 'Impordi fail';
$string['importfile_help'] = 'Impordi fail';
$string['importsessions'] = 'Impordi seansid';
$string['importstatus'] = 'Staatuse väli';
$string['importstatus_help'] = 'See võimaldab importimisel lisada staatuse väärtuse - nt sellised väärtused nagu K, H, P';
$string['includeabsentee'] = 'Kaasa tund puudujate aruande arvutamisel';
$string['includeabsentee_help'] = 'Kui see on märgitud, lisatakse see tund puudujate aruande arvutustesse.';
$string['includeall'] = 'Vali kõik tunnid';
$string['includenottaken'] = 'Kaasa võtmata tunnid';
$string['includeqrcode'] = 'Kaasa QR kood';
$string['includeremarks'] = 'Kaasa märkused';
$string['incorrectpassword'] = 'Sisestasid vale parooli ja sinu kohalolek ei ole registreeritud. Palun sisesta õige parool.';
$string['incorrectpasswordshort'] = 'Vale parool, osalemist ei registreerita.';
$string['indetail'] = 'Detailselt...';
$string['indicator:cognitivedepth'] = 'Tunnetuslik osalemine';
$string['indicator:cognitivedepth_help'] = 'See näitaja põhineb tunnetuslikul sügavusel, mille õpilane on saavutanud osalemistegevuses.';
$string['indicator:cognitivedepthdef'] = 'Tunnetuslik osalemine';
$string['indicator:cognitivedepthdef_help'] = 'Osaleja on selle analüüsivahemiku jooksul saavutanud osalemise pakutava kognitiivse seotuse protsendi (tasemed = vaadet pole, vaade)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sotsiaalne osalemine';
$string['indicator:socialbreadth_help'] = 'See näitaja põhineb ühiskondlikul tasemel, mille õpilane on saavutanud osalemistegevuses.';
$string['indicator:socialbreadthdef'] = 'Sotsiaalne osalemine';
$string['indicator:socialbreadthdef_help'] = 'Osaleja on selle analüüsivahemiku jooksul saavutanud osalemise pakutava sotsiaalse kaasatuse protsendi (tasemed = ei osale, osaleja üksi)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Sa pead valima tegevuse';
$string['invalidemails'] = 'Pead määrama olemasolevate kasutajakontode aadressid, ei leitud: {$a}';
$string['invalidimportfile'] = 'Failiformaat on kehtetu';
$string['invalidsessionenddate'] = 'See kuupäev ei saa olla varasem kui tunni kuupäev';
$string['invalidsessionendtime'] = 'Lõppaeg peab olema pikem kui algusaeg';
$string['invalidstatus'] = 'Valisid vale oleku, proovi uuesti';
$string['iptimemissing'] = 'Kehtetud minutid vabastamiseks';
$string['jumpto'] = 'Hüppa';
$string['keepsearching'] = 'Jätka otsimist';
$string['marksessionimportcsvhelp'] = 'See vorm võimaldab üles laadida csv-faili, mis sisaldab kasutajatunnust ja olekut - olekuväljaks võib olla oleku akronüüm või kellaaeg, millal selle kasutaja juuresolek registreeriti. Kui ajaväärtus on möödas, proovib see määrata oleku väärtuse, millel on sel ajal kõrgeim hinne.';
$string['maxpossible'] = 'Maksimaalne võimalik';
$string['maxpossible_help'] = 'Näitab skoori, mille iga kasutaja võib saavutada, kui ta saab igas veel võtmata tunnis (minevikus ja tulevikus) maksimaalsed punktid:
     <ul>
     <li><strong>Punktid</strong>: maksimaalsed punktid, mida iga kasutaja saab kõikide tundide ajal saavutada.</li>
     <li><strong>Protsent</strong>: maksimaalne protsent, mida iga kasutaja võib kõikide tundide ajal saavutada.</li>
     </ul>';
$string['maxpossiblepercentage'] = 'Maksimaalne võimalik protsent';
$string['maxpossiblepoints'] = 'Maksimaalne võimalik punktide arv';
$string['maxwarn'] = 'Maksimaalne arv e-maili hoiatusi';
$string['maxwarn_help'] = 'Hoiatuse saatmise maksimaalne arv (ühe tunni kohta saadetakse ainult üks hoiatus)';
$string['mergeuser'] = 'Ühenda kasutaja';
$string['mobilesessionfrom'] = 'Näita viimasest vanemaid tunde';
$string['mobilesessionfrom_help'] = 'Lubab tundide loendi rakenduses märkimisel piirata - kuvatakse ainult tunnid, mis algasid sellest väärtusest alates';
$string['mobilesessionto'] = 'Kuva tuleviku tunnid';
$string['mobilesessionto_help'] = 'Võimaldab tundide loendit piirata nii, et see näitaks ainult väikest arvu tulevasi tunde.';
$string['mobilesettings'] = 'Mobiilirakenduse seaded';
$string['mobilesettings_help'] = 'Need seaded kontrollivad Moodle\'i mobiilirakenduse käitumist';
$string['modulename'] = 'Osalemine';
$string['modulename_help'] = 'Osalemise moodul võimaldab õpetajal osaleda tunni ajal ja õpilastel oma kohaloleku arvestust vaadata.

Õpetaja saab luua mitu tundi ja võib märkida kohaloleku olekuks "kohal”, „hilines”, „vabastatud” või „puudub” või muuta olekuid vastavalt nende vajadustele.

Aruanded on saadaval kogu klassile või üksikutele õpilastele.';
$string['modulenameplural'] = 'Osalemised';
$string['months'] = 'Kuud';
$string['moreattendance'] = 'Selle lehe osalemine on edukalt sisestatud';
$string['moveleft'] = 'Liigu vasakule';
$string['moveright'] = 'Liigu paremale';
$string['multisessionexpanded'] = 'Mitu tundi on laiendatud';
$string['multisessionexpanded_desc'] = 'Uute tundide loomisel kuva vaikimisi laiendatud seaded „Mitu tundi”.';
$string['mustselectusers'] = 'Ekspordiks on vaja kasutajad valida';
$string['newdate'] = 'Uus kuupäev';
$string['newduration'] = 'Uus kestus';
$string['newstatusset'] = 'Uus staatuste valik';
$string['noabsentstatusset'] = 'Kasutusel oleval staatusel pole märgistamata olekut.';
$string['noattendanceusers'] = 'Andmeid ei ole võimalik eksportida, kuna kursusele pole registreeritud ühtegi õpilast.';
$string['noattforuser'] = 'Kasutaja kohta ei ole kohalolekukirjeid';
$string['noautomark'] = 'Keelatud';
$string['nodescription'] = 'Tavaline klassitund';
$string['noeventstoreset'] = 'Pole ühtegi kalendrisündmust, mis vajaks värskendamist.';
$string['nogroups'] = 'Sa ei saa rühmatunde lisada, sest kursusel pole rühmi.';
$string['noguest'] = 'Külaline ei näe osalemist';
$string['noofdaysabsent'] = 'Puudutud päevade arv';
$string['noofdaysexcused'] = 'Vabastatud päevade arv';
$string['noofdayslate'] = 'Hilinenud päevade arv';
$string['noofdayspresent'] = 'Kohaloldud päevade arv';
$string['nosessiondayselected'] = 'Tunni päeva ei ole valitud';
$string['nosessionexists'] = 'Selle kursuse jaoks ei ole tunde';
$string['nosessionsselected'] = 'Ühtegi tundi ei ole valitud';
$string['notfound'] = 'Osalustegevust sellel kursusel ei leitud';
$string['notifytask'] = 'Saada kasutajatele hoiatused';
$string['notset'] = 'ei ole seatud';
$string['noupgradefromthisversion'] = 'Osalemismoodulit ei saa teie installitud attforblocki versioonilt uuendada. - enne uue osalemismooduli paigaldamist kustuta palun attforblock või värskenda uusimale versioonile';
$string['numsessions'] = 'Tundide arv';
$string['olddate'] = 'Vana kuupäev';
$string['onlyselectedusers'] = 'Ekspordi valitud kasutajad';
$string['overallsessions'] = 'Üle kõikide tundide';
$string['overallsessions_help'] = 'Näitab kõikide tundide statistikat, sealhulgas nende kohta, mida veel ei ole (minevikus ja tulevikus):
     <ul>
     <li><strong>Tunnid</strong>:tundide koguarv.</li>
     <li><strong>Punktid</strong>:toimunud tundide põhjal antud punktid.</li>
     <li><strong>Protsent</strong>:kõikide tundide võimalikku maksimaalset punktiarvu arvestav protsent</li>
     </ul>';
$string['oversessionstaken'] = 'Üle võetud tundide';
$string['oversessionstaken_help'] = 'Näitab kõikide osaletud tundide statistikat:
     <ul>
     <li><strong>Tunnid</strong>:toimunud tundide koguarv.</li>
     <li><strong>Punktid</strong>:toimunud tundide põhjal antud punktid.</li>
     <li><strong>Protsent</strong>:toimunud tundide võimalikku maksimaalset punktiarvu arvestav protsent</li>
     </ul>';
$string['pageof'] = 'Lehekülg {$a->page} {$a->numpages}';
$string['participant'] = 'Osaleja';
$string['password'] = 'Salasõna';
$string['passwordgrp'] = 'Õpilase salasõna';
$string['passwordgrp_help'] = 'Kui see on seadistatud, peavad õpilased selle parooli sisestama, enne kui nad saavad ise tunnis osalemise oleku määrata. Kui tühi, pole parooli vaja.';
$string['passwordrequired'] = 'Enne osalemise esitamist pead sisestama tunni parooli';
$string['percentage'] = 'Protsent';
$string['percentageallsessions'] = 'Kõikide tundide protsent';
$string['percentagesessionscompleted'] = 'Kõikide võetud tundide protsent';
$string['pluginadministration'] = 'Osalemise administreerimine';
$string['pluginname'] = 'Osalemine';
$string['points'] = 'Punktid';
$string['pointsallsessions'] = 'Kõikide tundide punktid';
$string['pointssessionscompleted'] = 'Kõikide läbitud tundide punktid';
$string['preferences_desc'] = 'Olekukomplektide muudatused mõjutavad olemasolevaid osalemistunde ja võivad mõjutada hindeid.';
$string['preventsharederror'] = 'Ise märgistamine on tunni ajal keelatud, kuna näib, et seda seadet on kasutatud teise õpilase kohaloleku registreerimiseks.';
$string['preventsharedip'] = 'Väldi õpilaste IP-aadressi jagamist';
$string['preventsharedip_help'] = 'Keela õpilastel kasutada sama seadet (tuvastatud IP-aadressi abil) teiste õpilaste osalemise märkimiseks.';
$string['preventsharediptime'] = 'Aeg IP-aadressi taaskasutamiseks (minutites)';
$string['preventsharediptime_help'] = 'Luba pärast selle aja möödumist selles tunnis osalemiseks uuesti kasutada IP-aadressi.';
$string['preview'] = 'Faili eelvaade';
$string['previewhtml'] = 'HTML formaadi eelvaade';
$string['priorto'] = 'Tunni kuupäev on enne kursuse alguskuupäeva ({$a}), nii et enne seda kuupäeva kavandatud uued tunnid on peidetud (pole saadaval). Varasematele tundidele juurdepääsu saamiseks võid kursuse alguskuupäeva igal ajal muuta (vt kursuse seadeid).<br><br>Palun muuda tunni kuupäeva või klõpsa kinnitamiseks lihtsalt nuppu "Lisa tund"?';
$string['privacy:metadata:attendancelog'] = 'Kasutajate osalemiste register on salvestatud.';
$string['privacy:metadata:attendancesessions'] = 'Tunnid, kus osalemine registreeritakse.';
$string['privacy:metadata:attendancewarningdone'] = 'Kasutajatele saadetud hoiatuste logi nende kohaloleku kohta.';
$string['privacy:metadata:duration'] = 'Tunni kestus sekundites';
$string['privacy:metadata:groupid'] = 'Tunniga seotud rühma ID';
$string['privacy:metadata:ipaddress'] = 'Kohalolek märgiti sellelt IP aadressilt.';
$string['privacy:metadata:lasttaken'] = 'Ajatempel, millal tunnis osalemist viimati märgiti.';
$string['privacy:metadata:lasttakenby'] = 'Viimati selles tunnis osalenud kasutaja kasutajatunnus';
$string['privacy:metadata:notifyid'] = 'Osalemistunni hoiatuse ID on seotud.';
$string['privacy:metadata:remarks'] = 'Kommentaarid kasutaja osalemise kohta.';
$string['privacy:metadata:sessdate'] = 'Tunni alguse ajatempel.';
$string['privacy:metadata:sessionid'] = 'Tunnis osalemise ID.';
$string['privacy:metadata:statusid'] = 'Õpilaste osalemisstaatuse ID';
$string['privacy:metadata:statusset'] = 'Olek on määratud oleku ID juurde.';
$string['privacy:metadata:studentid'] = 'Osalenud õpilase ID';
$string['privacy:metadata:takenby'] = 'Kasutaja ID, kes märkis õpilaste osalemisi.';
$string['privacy:metadata:timemodified'] = 'Ajatempel, millal tundi viimati muudeti';
$string['privacy:metadata:timesent'] = 'Ajatempel, millal hoiatus seadistati.';
$string['privacy:metadata:timetaken'] = 'Ajatempel selle kohta, millal õpilane kohal käis.';
$string['privacy:metadata:userid'] = 'Kasutaja ID, kellele hoiatus saata.';
$string['processingfile'] = 'Faili töötlemine';
$string['qr_cookie_error'] = 'QR seanss on aegunud.';
$string['qr_pass_wrong'] = 'QR salasõna on vale või aegunud.';
$string['qrcode'] = 'QR kood';
$string['randompassword'] = 'Juhuslik salasõna';
$string['remark'] = 'Märkus: {$a}';
$string['remarks'] = 'Märkused';
$string['repeatasfollows'] = 'Korda ülalolevat tundi järgnevalt';
$string['repeatevery'] = 'Korda iga';
$string['repeaton'] = 'Korda';
$string['repeatuntil'] = 'Korda kuni';
$string['report'] = 'Aruanne';
$string['required'] = 'Nõutud*';
$string['requiredentries'] = 'Ajutised kirjed kirjutavad osalejate kohaloleku registrid üle';
$string['requiredentry'] = 'Ajutiste kasutajate ühendamise abijuhend';
$string['requiredentry_help'] = '<p align="center"><b>Osalemine</b></p>
<p align="left"><strong>Ühenda kontod</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodle\'i kasutaja</th>
<th>Ajutine kasutaja</th>
<th>Tegevus</th>
</tr>
<tr>
<td>Osalemise andmed</td>
<td>Osalemise andmed</td>
<td>Ajutine kasutaja asendab Moodle\'i kasutaja</td>
</tr>
<tr>
<td>Osalemise andmed puuduvad</td>
<td>Osalemise andmed</td>
<td>Ajutise kasutaja osalemine kantakse üle Moodle\'i kasutajale</td>
</tr>
<tr>
<td>Osalemise andmed</td>
<td>Osalemise andmed puuduvad</td>
<td>Ajutine kasutaja kustutatakse</td>
</tr>
<tr>
<td>Osalemise andmed puuduvad</td>
<td>Osalemise andmed puuduvad</td>
<td>Ajutine kasutaja kustutatakse</td>
</tr>
</table>

</p>
<p align="left"><strong>Ajutine kasutaja kustutatakse kõikide ühendamise tegevuste käigus</strong></p>';
$string['requiresubnet'] = 'Nõua võrguaadressi';
$string['requiresubnet_help'] = 'Kohaloleku registreerimine võib piirduda teatud alamvõrkudega, määrates komaga eraldatud osaliste või täielike IP-aadresside loendi.';
$string['resetcaledarcreate'] = 'Kalendrisündmused on lubatud, kuid paljudel olemasolevatel tundidel sündmusi pole. Kas soovid luua kõikide olemasolevate tundide jaoks kalendrisündmused?';
$string['resetcaledardelete'] = 'Kalendrisündmused on keelatud, kuid paljudel olemasolevatel tundidel on sündmused, mis tuleks kustutada. Kas soovid kustutada kõik olemasolevad sündmused?';
$string['resetcalendar'] = 'Lähtesta kalender';
$string['resetdescription'] = 'Pea meeles, et kohaloleku andmete kustutamine kustutab andmebaasist teabe. Võid vanemad tunnid lihtsalt peita, kui kursuse alguskuupäev on muutunud.';
$string['resetstatuses'] = 'Lähtesta olekute vaikeseadetele';
$string['restoredefaults'] = 'Taasta vaikeseaded';
$string['resultsperpage'] = 'Tulemusi lehekülje kohta';
$string['resultsperpage_desc'] = 'Lehel kuvatud õpilaste arv';
$string['rotateqrcode'] = 'Pööra QR-koodi';
$string['rotateqrcode_cleartemppass_task'] = 'Ülesanne tühistada QR-koodi pööramise funktsiooni abil loodud ajutised paroolid.';
$string['rotateqrcodeexpirymargin'] = 'Pööra QR-koodi / parooli aegumismarginaali (sekundit)';
$string['rotateqrcodeexpirymargin_desc'] = 'Ajavahemik (sekundites) aegunud QR-koodi / parooli lubamiseks.';
$string['rotateqrcodeinterval'] = 'Pööra QR-koodi / parooli intervalli (sekundit)';
$string['rotateqrcodeinterval_desc'] = 'Ajavahemik (sekundites) QR-koodi / parooli pööramiseks.';
$string['save'] = 'Salvesta osalemine';
$string['scantime'] = 'Skaneerimise aeg';
$string['scantime_help'] = 'See võimaldab impordifaili lisada ajatempli - see üritab teisendada PHP strtotime funktsiooni abil edastatud ajatempli ja seejärel otsustada, millise oleku kasutajale määrata osalemise oleku sätetega';
$string['search:activity'] = 'Osalemine - teave tegevuste kohta';
$string['session'] = 'Tund';
$string['session_help'] = 'Tund';
$string['sessionadded'] = 'Tund on edukalt lisatud';
$string['sessionalreadyexists'] = 'Sel kuupäeval tund juba eksiseerib';
$string['sessiondate'] = 'Kuupäev';
$string['sessiondays'] = 'Tunni päevad';
$string['sessiondeleted'] = 'Tund on edukalt kustutatud';
$string['sessionduplicate'] = 'Kursuse jaoks on olemas duplikaattund :{$a->course} osalemisi: {$a->activity}';
$string['sessionexist'] = 'Tundi ei lisatud (juba olemas)';
$string['sessiongenerated'] = 'Üks tund edukalt loodud';
$string['sessions'] = 'Tunnid';
$string['sessionscompleted'] = 'Võetud tunnid';
$string['sessionsgenerated'] = '{$a} tund(i) loodi edukalt';
$string['sessionsids'] = 'Tundide ID-d';
$string['sessionsnotfound'] = 'Valitud ajavahemikus pole tunde';
$string['sessionstartdate'] = 'Tunni alguskuupäev';
$string['sessionstotal'] = 'Tundide koguarv';
$string['sessionsupdated'] = 'Tunnid uuendatud';
$string['sessiontype'] = 'Tüüp';
$string['sessiontype_help'] = 'Saad lisada tunde kõikidele õpilastele või õpilaste rühmale. Võimalus lisada erinevaid tüüpe sõltub tegevusgrupi režiimist.

* Grupirežiimis "Rühmi pole" saad lisada tunnid ainult kõigile õpilastele.
* Grupirežiimis "Eraldage rühmad" saad lisada tunnid ainult õpilaste rühmale.
* Grupirežiimis "Nähtavad rühmad" saad lisada mõlemat tüüpi tunde.';
$string['sessiontypeshort'] = 'Tüüp';
$string['sessionunknowngroup'] = 'Tund määrab tundmatud rühmad: {$a}';
$string['sessionupdated'] = 'Tund edukalt uuendatud';
$string['set_by_student'] = 'Iseregistreeritud';
$string['setallstatuses'] = 'Sea staatus';
$string['setallstatusesto'] = 'Sea staatus «{$a}»';
$string['setperiod'] = 'IP vabastamiseks määratud kindel aeg minutites';
$string['settings'] = 'Seadistused';
$string['setunmarked'] = 'Sea automaatselt, kui on jäetud märkimata';
$string['setunmarked_help'] = 'Kui see on tunni puhul lubatud, määra see olek, kui õpilane pole oma kohalviibimist märkinud.';
$string['showdefaults'] = 'Kuva vaikimisi';
$string['showduration'] = 'Kuva kestus';
$string['showextrauserdetails'] = 'Näita kasutaja lisaandmeid';
$string['showqrcode'] = 'Kuva QR kood';
$string['showsessiondescriptiononreport'] = 'Kuva aruandes tunni kirjeldus';
$string['showsessiondescriptiononreport_desc'] = 'Näita tunni kirjeldust Osalemisaruande loendis.';
$string['showsessiondetails'] = 'Kuva tunni detailid';
$string['somedisabledstatus'] = '(Mõned valikud on tunni alustamisel eemaldatud.)';
$string['sortedgrid'] = 'Sorteeritud ruudustik';
$string['sortedlist'] = 'Sorteeritud nimekiri';
$string['startofperiod'] = 'Perioodi algus';
$string['starttime'] = 'Algusaeg';
$string['status'] = 'Staatus';
$string['statusall'] = 'Kõik';
$string['statusdeleted'] = 'Staatus kustutatud';
$string['statuses'] = 'Staatused';
$string['statusset'] = 'Staatus seatud {$a}';
$string['statussetsettings'] = 'Staatus seatud';
$string['statusunselected'] = 'Valimata';
$string['strftimedm'] = '%b %d';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentavailability'] = 'Kättesaadav õpilastele (minutites)';
$string['studentavailability_help'] = 'Kui õpilased märgivad ise oma osalemist - minutite arv pärast tunni algust, kuni see olek on saadaval.
  <br/>Kui see on tühi, on see olek alati saadaval. Kui väärtuseks seatakse 0, on see õpilaste jaoks alati peidetud.';
$string['studentid'] = 'Õpilase ID';
$string['studentmarked'] = 'Sinu selles tunnis osalemine on registreeritud.';
$string['studentmarking'] = 'Õpilase registreerimine';
$string['studentpassword'] = 'Õpilase salasõna';
$string['studentrecordingexpanded'] = 'Õpilase registeerimist on laiendatud';
$string['studentrecordingexpanded_desc'] = 'Uute tundide loomisel kuva vaikimisi laiendatud sätet "Õpilase registreerimine".';
$string['studentscanmark'] = 'Luba õpilastel oma osalemist registreerida.';
$string['studentscanmark_desc'] = 'Kui see on märgitud, saavad õpetajad lubada õpilastel ise oma kohalviibimist märkida.';
$string['studentscanmark_help'] = 'Kui see on märgitud, saavad õpilased ise oma tunnis osalemise olekut muuta.';
$string['studentscanmarksessiontime'] = 'Õpilased registreerivad tunnis osalemise';
$string['studentscanmarksessiontime_desc'] = 'Kui see on valitud, saavad õpilased registreerida oma osalemise ainult tunni ajal.';
$string['studentscanmarksessiontimeend'] = 'Tunni lõpp (minutites)';
$string['studentscanmarksessiontimeend_desc'] = 'Kui tunnil ei ole lõpuaega, siis kui mitu minutit peaks õpilastel olema tunnis osalemise registreerimiseks vaba aega.';
$string['submit'] = 'Esita';
$string['submitattendance'] = 'Esita osalemine';
$string['submitpassword'] = 'Esita salasõna';
$string['subnet'] = 'Alamvõrk';
$string['subnetactivitylevel'] = 'Luba alamvõrgu konfigureerimine tegevuse tasemel';
$string['subnetactivitylevel_desc'] = 'Kui see on lubatud, saavad õpetajad kohaloleku loomisel aktiivsuse tasemel vaikevõrgu alamvõrgu tühistada. Vastasel juhul kasutatakse seansi loomisel saidi vaikeseadet.';
$string['subnetwrong'] = 'Osalemist saab märkida ainult kindlatest asukohtadest ja see arvuti ei oma selleks õigusi.';
$string['summary'] = 'Kokkuvõte';
$string['tactions'] = 'Tegevus';
$string['takeattendance'] = 'Võta osa';
$string['takensessions'] = 'Võetud tunnid';
$string['tcreated'] = 'Loodud';
$string['tempaddform'] = 'Lisa ajutine kasutaja';
$string['tempexists'] = 'Selle e-maili aadressiga ajutine kasutaja on juba olemas';
$string['temptable'] = 'Ajutiste kasutajate nimekiri';
$string['tempuser'] = 'Ajutine kasutaja';
$string['tempusermerge'] = 'Liida ajutine kasutaja';
$string['tempusers'] = 'Ajutised kasutajad';
$string['tempusersedit'] = 'Muuda ajutist kasutajat';
$string['tempuserslist'] = 'Ajutised kasutajad';
$string['thirdpartyemails'] = 'Teavita teisi kasutajaid.';
$string['thirdpartyemails_help'] = 'Nimekiri teistest kasutajatest, keda teavitatakse.';
$string['thirdpartyemailsubject'] = 'Osalemise hoiatus.';
$string['thirdpartyemailtext'] = '{$a->firstname} {$a->lastname} osalemine kursusel {$a->coursename} {$a->aname} on madalam kui {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Said selle, kuna selle kursuse õpetaja on sinu e-maili aadressi loendisse lisanud';
$string['thiscourse'] = 'See kursus';
$string['time'] = 'Aeg';
$string['timeahead'] = 'Mitut tundi, mis ületavad ühe aasta piiri, ei saa luua. Palun kohanda algus- ja lõppkuupäeva.';
$string['to'] = 'Kellele:';
$string['triggered'] = 'Esimesena teavitatud';
$string['tuseremail'] = 'E-mail';
$string['tusername'] = 'Täisnimi';
$string['ungraded'] = 'Hindamata tunnid';
$string['unknowngroup'] = 'Tundmatu rühm';
$string['update'] = 'Uuenda';
$string['uploadattendance'] = 'Laadi osalemine üle CSV failiga';
$string['usedefaultsubnet'] = 'Kasuta vaikimisi';
$string['usemessageform'] = 'või kasuta valitud õpilastele sõnumi saatmiseks allolevat vormi';
$string['userexists'] = 'Selle e-maili aadressiga kasutaja on juba olemas';
$string['userid'] = 'Kasutaja ID';
$string['userimportfield'] = 'Välise kasutaja väli';
$string['userimportfield_help'] = 'Üleslaaditud CSV-i väli, mis sisaldab kasutajatunnust';
$string['userimportto'] = 'Moodle\'i kasutaja väli';
$string['userimportto_help'] = 'Moodle\'i väli, mis vastab CSV-ekspordi andmetele';
$string['users'] = 'Kasutajad eksportimiseks';
$string['usestatusset'] = 'Staatuse valikud';
$string['variable'] = 'Muutuja';
$string['variablesupdated'] = 'Muutujad edukalt uuendatud';
$string['versionforprinting'] = 'Printversioon';
$string['viewmode'] = 'Vaatamise režiim';
$string['warnafter'] = 'Enne hoiatamist võetud tundide arv';
$string['warnafter_help'] = 'Hoiatused käivitatakse alles siis, kui kasutaja on lasknud osalemist märkida vähemalt sellisel arvul tundidest.';
$string['warningdeleted'] = 'Hoiatus kustutatud';
$string['warningdesc'] = 'Need hoiatused lisatakse automaatselt uutele osavõtutegevustele. Kui korraga käivitatakse mitu hoiatust, saadetakse ainult madalama hoiatuskünnisega hoiatus.';
$string['warningdesc_course'] = 'Siin seatud hoiatuste künnised mõjutavad puudujate aruannet ja võimaldavad õpilastele ja kolmandatele isikutele sellest teada anda. Kui korraga käivitatakse mitu hoiatust, saadetakse ainult madalama hoiatuskünnisega hoiatus.';
$string['warningfailed'] = 'Sa ei saa luua hoiatust, mis kasutab sama tundide protsenti ja arvu.';
$string['warningpercent'] = 'Hoiata kui protsent jääb alla';
$string['warningpercent_help'] = 'Hoiatus käivitatakse, kui üldine protsent langeb alla selle arvu.';
$string['warnings'] = 'Hoiatused on seatud';
$string['warningthreshold'] = 'Hoiatuslävi';
$string['warningupdated'] = 'Uuendatud hoiatused';
$string['week'] = 'Nädal(ad)';
$string['weeks'] = 'Nädalad';
$string['youcantdo'] = 'Sa ei saa midagi teha';
