<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scorm', language 'sr_cr', version '3.9'.
 *
 * @package     scorm
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activation'] = 'Активација';
$string['activityloading'] = 'Бићете аутоматски преусмерени на ову активност за';
$string['activityoverview'] = 'Имате SCORM пакете на које треба обратити пажњу';
$string['activitypleasewait'] = 'Активност се учитава, молимо сачекајте...';
$string['adminsettings'] = 'Администраторска подешавања';
$string['advanced'] = 'Параметри';
$string['aicchacpkeepsessiondata'] = 'Подаци о AICC HACP сесији';
$string['aicchacpkeepsessiondata_desc'] = 'Временски период, у данима, током којег ће се одржавати спољна AICC HACP сесија (превелие вредности ће испунити табелу старим подацима, али ово може бити корисно приликом отклањања грешака)';
$string['aicchacptimeout'] = 'AICC HACP тајмаут';
$string['aicchacptimeout_desc'] = 'Временски период, у минутима, током којег спољна AICC HACP сесија може да остане отворена';
$string['aiccuserid'] = 'AICC пренос нумеричког корисничког идентификатора';
$string['aiccuserid_desc'] = 'AICC стандард за корисничка имена је у поређењу са Moodleom веома рестриктиван, и дозвољава само алфанумеричке ознаке, црту и доњу црту. Тачке, размаци и симбол @ нису допуштени. Уколико је омогућено, AICC пакету се уместо корисничких имена прослеђује ID број корисника.';
$string['aliasonly'] = 'Приликом избора imsmanifest.xml  датотеке из репозиторијума морате да користите алијас/пречицу за ту датотеку.';
$string['allowapidebug'] = 'Активирај API за отклањање грешака и праћење (подесите маску за хватање са apidebugmask)';
$string['allowtypeaicchacp'] = 'Омогући спољни AICC HACP';
$string['allowtypeaicchacp_desc'] = 'Ако је омогућено, ово ће дозволити спољну AICC HACP комуникацију, а да се при томе не тражи пријава корисника  за слање захтеве из спољног AICC пакета';
$string['allowtypeexternal'] = 'Омогући спољашњи тип пакета';
$string['allowtypeexternalaicc'] = 'Омогући директни AICC URL';
$string['allowtypeexternalaicc_desc'] = 'Ако је омогућено ово ће дозволити директан url приступ једноставном AICC пакету';
$string['allowtypelocalsync'] = 'Омогући преузети тип пакета';
$string['apidebugmask'] = 'Маска за хватање API система за отклањање грешака - користи једноставан регуларни израз на <username>:<activityname> нпр. admin:.* ће отклонити грешке само за админ корисника';
$string['areacontent'] = 'Датотеке садржаја';
$string['areapackage'] = 'Датотека пакета';
$string['asset'] = 'Елемент';
$string['assetlaunched'] = 'Елемент - Прегледано';
$string['attempt'] = 'Покушај';
$string['attempt1'] = '1 покушај';
$string['attempts'] = 'Покушаји';
$string['attemptsmanagement'] = 'Управљање покушајима';
$string['attemptstatusall'] = 'Контролни панел и улазна страница';
$string['attemptstatusentry'] = 'Само улазна страница';
$string['attemptstatusmy'] = 'Само \'Контролни панел\'';
$string['attemptsx'] = '{$a} покушај(а)';
$string['attr_error'] = 'Неадекватне вредности за атрибут ({$a->attr}) у ознаци {$a->tag}.';
$string['autocommit'] = 'Аутоматски предај';
$string['autocommit_help'] = 'Ако је ово подешавање укључено, SCORM подаци се аутоматски чувају у бази. Ово је корисно за SCORM објекте који не чувају своје податке редовно.';
$string['autocommitdesc'] = 'Аутоматски чувај SCORM податке ако их SCORM пакет не чува.';
$string['autocontinue'] = 'Аутоматски наставак';
$string['autocontinue_help'] = 'Ако је ова опција омогућена, наредни објекти учења се аутоматски покрећу. У супротном мора се употребити дугме \'Настави\'.';
$string['autocontinuedesc'] = 'Ако је ова опција омогућена, наредни објекти учења се аутоматски покрећу. У супротном мора се употребити дугме \'Настави\'.';
$string['averageattempt'] = 'Просек свих покушаја';
$string['badarchive'] = 'Морате обезбедити валидну zip датотеку';
$string['badimsmanifestlocation'] = 'Датотека imsmanifest.xml је пронађена али није у корену Ваше zip датотеке, молимо поново запакујте Ваш SCORM пакет';
$string['badmanifest'] = 'Има грешака у манифесту: погледајте извештај о грешкама';
$string['browse'] = 'Преглед';
$string['browsed'] = 'Претражено';
$string['browsemode'] = 'Режим прегледа';
$string['browserepository'] = 'Претрага репозиторијума';
$string['calculatedweight'] = 'Израчунати пондер';
$string['calendarend'] = '{$a} се затвара';
$string['calendarstart'] = '{$a} се отвара';
$string['cannotaccess'] = 'Не можете позвати овај скрипт на тај начин';
$string['cannotfindsco'] = 'Није било могуће наћи SCO';
$string['chooseapacket'] = 'Изабери или ажурирај SCORM пакет';
$string['closebeforeopen'] = 'Навели сте датум затварања пре датума отварања.';
$string['collapsetocwinsize'] = 'Скупи садржај када је величина прозора испод';
$string['collapsetocwinsizedesc'] = 'Ово подешавање вам дозвољава да одредите величину прозора испод које садржај треба аутоматски да се скупи.';
$string['compatibilitysettings'] = 'Подешавања компатибилности';
$string['completed'] = 'Завршено';
$string['completionscorerequired'] = 'Захтевај минимални резултат';
$string['completionscorerequired_help'] = 'Ако је омогућено, ово подешавање тражити од корисник да има барем минималан резултат како би ова SCORM активност била обележена као завршена, исто као и било који други услов за завршетак активности.';
$string['completionscorerequireddesc'] = 'Минималан резултат од {$a} је потребан за завршетак';
$string['completionstatus_completed'] = 'Завршено';
$string['completionstatus_passed'] = 'Положено';
$string['completionstatusallscos'] = 'Захтевај све дељиве објекте садржаја да би се вратио комплетан статус';
$string['completionstatusallscos_help'] = 'Неки SCORM пакети садрже вишеструке компоненте или дељиве објекте садржаја ("scos") - када је то омогућено сви дељиви објекти садржаја у оквиру пакета морају враћати релевантан lesson_status да би се ова активност означила као испуњена.';
$string['completionstatusrequired'] = 'Захтевај статус';
$string['completionstatusrequired_help'] = 'Избор једног или више статуса захтеваће од корисника да испуни  најмање један од означених статуса, како би ова SCORM активност била обележена као завршена, исто као и било који други услови за завршетак активности.';
$string['completionstatusrequireddesc'] = 'Полазник мора да постигне најмање један од следећих статуса: {$a}';
$string['confirmloosetracks'] = 'УПОЗОРЕЊЕ: Изгледа да је пакет промењен или модификован. Ако је структура пакета промењена, подаци о неким активностима корисника се могу изгубити током процеса ажурирања.';
$string['contents'] = 'Садржај';
$string['coursepacket'] = 'Пакет курса';
$string['coursestruct'] = 'Структура курса';
$string['crontask'] = 'Позадинска обрада SCORM активности';
$string['currentwindow'] = 'Тренутно отворен прозор';
$string['datadir'] = 'Грешка система датотека: није могуће креирати директоријум за податке курса';
$string['defaultdisplaysettings'] = 'Подразумевана подешавања приказа';
$string['defaultgradesettings'] = 'Подразумевана подешавања оцене';
$string['defaultothersettings'] = 'Остала подразумевана подешавања';
$string['deleteallattempts'] = 'Обриши све SCORM  покушаје';
$string['deleteattemptcheck'] = 'Да ли сте сигурни да желите да потпуно обришете ове покушаје?';
$string['deleteselected'] = 'Обриши издвојене покушаје';
$string['deleteuserattemptcheck'] = 'Да ли сте сигурни да желите да потпуно обришете све своје покушаје?';
$string['details'] = 'Детаљи записа';
$string['directories'] = 'Прикажи линкове директоријума';
$string['disabled'] = 'Онемогућено';
$string['display'] = 'Прикажи пакет';
$string['displayactivityname'] = 'Прикажи назив активности';
$string['displayactivityname_help'] = 'Ова опција одеђује да ли треба приказати назив активности изнад SCORM плејера';
$string['displayattemptstatus'] = 'Прикажи статус покушаја';
$string['displayattemptstatus_help'] = 'Овај параметар омогућава да резиме корисникових покушаја буде приказан у блоку за преглед курсева на \'Контролном панелу\' и/или SCORM улазној страници.';
$string['displayattemptstatusdesc'] = 'Да ли се резиме покушаја корисника појављује у блоку за преглед курсева на \'Контролном панелу\' и/или на улазној страници SCORM  пакета.';
$string['displaycoursestructure'] = 'Прикажи структуру курса на улазној страници';
$string['displaycoursestructure_help'] = 'Ако је омогућена ова опција, садржај се приказује на улазној страници SCORM пакета.';
$string['displaycoursestructuredesc'] = 'Ако је омогућена ова опција, садржај се приказује на улазној страници SCORM пакета.';
$string['displaydesc'] = 'Да ли приказати SCORM пакет у новом прозору.';
$string['displaysettings'] = 'Подешавања приказа';
$string['dnduploadscorm'] = 'додај SCORM пакет';
$string['domxml'] = 'DOMXML екстерна библиотека';
$string['duedate'] = 'Крајњи рок';
$string['element'] = 'Елемент';
$string['enter'] = 'Уђи';
$string['entercourse'] = 'Уђи у SCORM курс';
$string['errorlogs'] = 'Запис о грешкама';
$string['eventattemptdeleted'] = 'Покушај обрисан';
$string['eventinteractionsviewed'] = 'Интеракције приказане';
$string['eventreportviewed'] = 'Извештај приказан';
$string['eventscolaunched'] = 'SCORM покренут';
$string['eventscorerawsubmitted'] = 'Необрађени резултат предатог SCORM пакета';
$string['eventstatussubmitted'] = 'Статус предатог SCORM пакета';
$string['eventtracksviewed'] = 'Записи приказани';
$string['eventuserreportviewed'] = 'Извештај о кориснику приказан';
$string['everyday'] = 'Свакодневно';
$string['everytime'] = 'Сваки пут када се користи';
$string['exceededmaxattempts'] = 'Достигли сте максималан број покушаја';
$string['exit'] = 'Изађи из SCORM курса';
$string['exitactivity'] = 'Изађи из активности';
$string['expired'] = 'Опростите, ова активност је затоврена {$a} и није више доступна';
$string['external'] = 'Ажурирај временско усклађивање екстерних пакета';
$string['failed'] = 'Непрелазна оцена';
$string['finishscorm'] = 'Ако сте завршили са прегледом овог ресурса, {$a}';
$string['finishscormlinkname'] = 'кликните овде за повратак на почетну страницу курса';
$string['firstaccess'] = 'Први приступ';
$string['firstattempt'] = 'Први покушај';
$string['floating'] = 'Плутајућа';
$string['forceattemptalways'] = 'Увек';
$string['forceattemptoncomplete'] = 'Када је претходни покушај завршен, положен или неположен';
$string['forcecompleted'] = 'Принудни завршетак';
$string['forcecompleted_help'] = 'Ако је ова опција омогућена, статус тренутних покушаја се принудно означава као "завршено". Ово подешавање је примењиво само за SCORM 1.2 пакете.';
$string['forcecompleteddesc'] = 'Овај параметар дефинише подразумевану вредност за принудни завршетак';
$string['forcejavascript'] = 'Приморај кориснике да омогуће JavaScript';
$string['forcejavascript_desc'] = 'Ако је ова опција омогућена (препоручено), она ће спречити приступ SCORM објектима када у корисниковом веб читачу JavaScript није подржан/омогућен. Ако је JavaScript онемогућен корисник ће моћи да види SCORM, али API комуникација ће бити неуспешна, а информације о оцени неће бити сачуване.';
$string['forcejavascriptmessage'] = 'Да бисте видели овај објекат неопходан је JavaScript, па вас молимо да га омогућите у свом веб читачу и покушате поново.';
$string['forcenewattempts'] = 'Принудни нови покушај';
$string['forcenewattempts_help'] = 'Постоје 3 опције:

* Не - Ако је претходни покушај завршен, положен или неположен, полазник ће биће понуђена опција да уђе у режим прегледа или да започне нови покушај.
* Када је претходни покушај завршен, положен или неположен - ово се ослања на SCORM пакет који подешава статус као \'завршен\', \'положен\' или \'неположен\'.
* Увек - Сваки поновни улазак у SCORM активност ће генерисати нови покушај и полазник неће бити враћен на исту тачку коју је досегнуо у свом претходном покушају.';
$string['found'] = 'Манифест је пронађен';
$string['frameheight'] = 'Висина оквира или прозора.';
$string['framewidth'] = 'Ширина оквира или прозора.';
$string['fromleft'] = 'Од леве ивице';
$string['fromtop'] = 'Од горње ивице';
$string['fullscreen'] = 'Попуни цео екран';
$string['general'] = 'Општи подаци';
$string['gradeaverage'] = 'Просечна оцена';
$string['gradeforattempt'] = 'Оцена за покушај';
$string['gradehighest'] = 'Највиша оцена';
$string['grademethod'] = 'Метод оцењивања';
$string['grademethod_help'] = 'Начин оцењивања дефинише начин како ће се оцењивати појединачни покушаји:

Постоје 4 начина оцењивања:

* Објекти учења - број завршених објеката учења
* Највиша оцена - највиша оцена добијена за све завршене објекте учења
* Просечна оцена - средња вредност свих резултата
* Збирна оцена - сума свих резултата';
$string['grademethoddesc'] = 'Метод оцењивања дефинише како се одређује оцена за појединачни покушај.';
$string['gradereported'] = 'Оцена забележена';
$string['gradescoes'] = 'Објекти за учење';
$string['gradesettings'] = 'Подешавања оцене';
$string['gradesum'] = 'Збирна оцена';
$string['height'] = 'Висина';
$string['hidden'] = 'Сакривено';
$string['hidebrowse'] = 'Онемогући режим прегледа';
$string['hidebrowse_help'] = 'Режим прегледа омогућава полазницима да прегледају активност пре неко што покушају да је реше. Ако је режим прегледа онемогућен, онда ће дугме за преглед бити сакривено.';
$string['hidebrowsedesc'] = 'Режим прегледа дозвољава полазницима да прегледају активност пре него што покушају да је реше.';
$string['hideexit'] = 'Сакриј линк за излаз';
$string['hidereview'] = 'Сакриј дугме за преглед';
$string['hidetoc'] = 'Приказ структуре курса у плејеру';
$string['hidetoc_help'] = 'Како се приказује садржај у SCORM плејеру.';
$string['hidetocdesc'] = 'Ово подешавање одређује како ће садржај бити приказан у SCORM плејеру.';
$string['highestattempt'] = 'Најбољи покушај';
$string['identifier'] = 'Идентификатор питања';
$string['incomplete'] = 'Непотпуно';
$string['indicator:cognitivedepth'] = 'SCORM - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'SCORM\'.';
$string['indicator:cognitivedepthdef'] = 'SCORM - когнитивни аспект';
$string['indicator:cognitivedepthdef_help'] = 'Учесник је постигао овај проценат когнитивног ангажмана који нуде активности SCORM током овог интервала анализе (Нивои = Без прегледа, Преглед, Предаја одговора, Преглед повратних информација)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'SCORM - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'SCORM\'.';
$string['indicator:socialbreadthdef'] = 'SCORM - социјални аспект';
$string['indicator:socialbreadthdef_help'] = 'Учесник је постигао овај проценат социјалног ангажмана који нуде активности SCORM  током овог интервала анализе (Нивои = Без учешћа, Учесник сâм)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Информације';
$string['interactions'] = 'Интеракције';
$string['invalidactivity'] = 'SCORM активност је неисправна';
$string['invalidhacpsession'] = 'Неисправна HACP сесија';
$string['invalidmanifestname'] = 'Могу бити изабране само imsmanifest.xml или .zip датотеке';
$string['invalidmanifestresource'] = 'УПОЗОРЕЊЕ: Следећи ресурси су наведени у вашој манифест датотеци али нису могле бити пронађени:';
$string['invalidstatus'] = 'Невалидни статус';
$string['invalidurl'] = 'Наведена је неисправна URL адреса';
$string['invalidurlhttpcheck'] = 'Наведена је неисправна URL адреса. Порука о грешци:<pre>{$a->cmsg}</pre>';
$string['last'] = 'Последњи пут приступљено дана';
$string['lastaccess'] = 'Последњи приступ';
$string['lastattempt'] = 'Последњи завршени покушај';
$string['lastattemptlock'] = 'Закључај након последњег покушаја';
$string['lastattemptlock_help'] = 'Ако је омогућенa ова опција, полазник неће моћи да покрене SCORM плејер након што искористи све дозвољене покушаје.';
$string['lastattemptlockdesc'] = 'Ако је омогућенa ова опција, полазник неће моћи да покрене SCORM плејер након што искористи све дозвољене покушаје.';
$string['location'] = 'Прикажи адресну траку';
$string['masteryoverride'] = 'Резултат вичности се преписује преко статуса';
$string['masteryoverride_help'] = 'Ако је ово подешавање омогућено и дат је резултат вичности, кад се позове LMSFinish и постави се сиров резултат статус ће бити прерачунат коришћењем сировог резултата и резултата вичности и он ће бити преписан преко било ког статуса добијеног од SCORM пакета (укључујући "није завршен").';
$string['masteryoverridedesc'] = 'Ово подешавање поставља подразумевано понашање за поставку преписивања резултата вичности';
$string['max'] = 'Најбољи резултат';
$string['maximumattempts'] = 'Број покушаја';
$string['maximumattempts_help'] = 'Ово подешавање омогућава ограничење броја покушаја. Примењиво је само за SCORM 1.2 и AICC пакете.';
$string['maximumattemptsdesc'] = 'Овај параметар дефинише подразумевани максималан број дозвољених покушаја за активност';
$string['maximumgradedesc'] = 'Овај параметар дефинише подразумевану максималну оцену за активност';
$string['menubar'] = 'Прикажи траку менија';
$string['min'] = 'Најлошији резултат';
$string['missing_attribute'] = 'Недостаје атрибут {$a->attr} у ознаци {$a->tag}';
$string['missing_tag'] = 'Недостаје ознака {$a->tag}';
$string['missingparam'] = 'Неопходан параметар недостаје или је погрешан';
$string['mode'] = 'Режим рада';
$string['modulename'] = 'SCORM пакет';
$string['modulename_help'] = 'SCORM i AICC представљају скуп датотека које су паковане према договореном стандарду за објекте учења. Модул активности SCORM омогућава да се SCORM или AICC пакети поставе као zip архиве и додају на курс.

Садржај пакета се обично приказује на неколико страница заједно са навигацијом. Постоје различите опције за приказивање садржаја у искачућем прозору, са табелом садржаја, са навигационим дугмадима итд, SCORM активности обично садрже питања, са оценама које се бележе у књигу оцена.

SCORM активности могу да се користе:

* за приказивање мултимедијалног садржаја и анимација
* као средство за процену';
$string['modulename_link'] = 'mod/scorm/view';
$string['modulenameplural'] = 'SCORM пакети';
$string['myaiccsessions'] = 'Моје AICC сесије';
$string['myattempts'] = 'Моји покушаји';
$string['nav'] = 'Прикажи навигацију';
$string['nav_help'] = 'Ово подешавање одређује да ли треба приказати или сакрити дугмад за навигацију, као и њихов положај.

Постоје три могућности:

* Не - дугмад за навигацију се не приказују
* Испод садржаја - дугмад за навигацију се приказују испод садржаја SCORM пакета
* Плутајућа дугмад - дугмад за навигацију се приказују као плутајућа дугмад; положај  дугмади за навигацију, од врха и слева, одређен је од стране пакета.';
$string['navdesc'] = 'Ово подешавање одређује да ли треба приказати или сакрити дугмад за навигацију, као и њихов положај.';
$string['navigation'] = 'Навигација';
$string['navpositionleft'] = 'Позиција дугмади за навигацију у односу на леву ивицу прозора, у пикселима.';
$string['navpositiontop'] = 'Позиција дугмади за навигацију у односу на горњу ивицу прозора, у пикселима.';
$string['networkdropped'] = 'SCORM плејер је открио да је ваша интернет веза непоуздана или да је у прекиду. Ако наставите са овом  SCORM активношћу, ваше напредовање можда неће бити сачувано.<br />
Најбоље ће бити да сада напустите ову активност и поново је покренете када будете успоставили поуздану интернет везу.';
$string['newattempt'] = 'Почни нови покушај';
$string['next'] = 'Настави';
$string['no_attributes'] = 'Ознака {$a->tag} мора имати атрибуте';
$string['no_children'] = 'Ознака {$a->tag} мора имати подређене ознаке';
$string['noactivity'] = 'Нема података за извештај';
$string['noattemptsallowed'] = 'Број дозвољених покушаја';
$string['noattemptsmade'] = 'Број покушаја који сте имали';
$string['nolimit'] = 'Неограничени број покушаја';
$string['nomanifest'] = 'Некоректно паковање датотеке - недостаје imsmanifest.xml или AICC структура';
$string['noprerequisites'] = 'Нажалост, нисте испунили довољно предуслова за приступ овој активности.';
$string['noreports'] = 'Нема извештаја за приказ';
$string['normal'] = 'Нормално';
$string['noscriptnoscorm'] = 'Ваш веб читач не подржава Javascript или је у његовим подешавањима искључена подршка за Javascript. SCORM пакет можда неће моћи да буде приказан или да сачува податке исправно.';
$string['not_corr_type'] = 'Неслагање типова за ознаку {$a->tag}';
$string['notattempted'] = 'Није покушавано';
$string['notopenyet'] = 'Опростите, али ова активност није доступна до {$a}';
$string['objectives'] = 'Циљеви';
$string['openafterclose'] = 'Навели сте датум отварања након датума затварања';
$string['optallstudents'] = 'сви корисници';
$string['optattemptsonly'] = 'само корисници са покушајима';
$string['options'] = 'Опције (онемогућено у неким веб читачима)';
$string['optionsadv'] = 'Опције (напредне)';
$string['optionsadv_desc'] = 'Ако је означено, ширина и висина ће бити приказани у обрасцу као напредна подешавања.';
$string['optnoattemptsonly'] = 'само корисници без покушаја';
$string['organization'] = 'Организација';
$string['organizations'] = 'Организације';
$string['othersettings'] = 'Додатна подешавања';
$string['package'] = 'Пакет';
$string['package_help'] = 'Датотека пакета је zip (или pif) архива која садржи датотеке SCORM/AICC курса.';
$string['packagedir'] = 'Грешка у система датотека: није могуће креирати директоријум пакета';
$string['packagefile'] = 'Није наведена датотека с пакетом';
$string['packagehdr'] = 'Пакет';
$string['packageurl'] = 'URL';
$string['packageurl_help'] = 'Ово подешавање омогућава да се наведе URL адреса SCORM пакета, уместо да се датотека бира на уобичајени начин путем бирача датотека.';
$string['page-mod-scorm-x'] = 'Било која страница модула SCORM';
$string['pagesize'] = 'Величина странице';
$string['passed'] = 'Положено';
$string['php5'] = 'PHP 5 (DOMXML изворна библиотека)';
$string['pluginadministration'] = 'Администрација SCORM/AICC пакета';
$string['pluginname'] = 'SCORM пакет';
$string['popup'] = 'Нови прозор';
$string['popuplaunched'] = 'Овај SCORM пакет покренут је у искачућем прозору. Ако се завршили са прегледом овог ресурса кликните овде за повратак на страницу курса.';
$string['popupmenu'] = 'У падајућем менију';
$string['popupopen'] = 'Отвори пакет у новом прозору';
$string['popupsblocked'] = 'Изгледа да су искачући прозори блокирани, што спречава да SCORM модул буде покренут. Молимо, проверите подешавања свог веб читача, пре него што покушате поново.';
$string['position_error'] = 'Ознака {$a->tag} не може бити подређена ознаци {$a->parent}';
$string['preferencespage'] = 'Параметри само за ову страницу';
$string['preferencesuser'] = 'Параметри за овај извештај';
$string['prev'] = 'Претходни';
$string['privacy:metadata:aicc:data'] = 'Лични подаци који се преносе са AICC/SCORM подсистема.';
$string['privacy:metadata:aicc:externalpurpose'] = 'Овај додатак шаље податке ван система користећи AICC HACP.';
$string['privacy:metadata:aicc_session:lessonstatus'] = 'Статус лекције који треба пратити';
$string['privacy:metadata:aicc_session:scormmode'] = 'Мод елемента који треба пратити';
$string['privacy:metadata:aicc_session:scormstatus'] = 'Статус елемента који треба пратити';
$string['privacy:metadata:aicc_session:sessiontime'] = 'Време сесије које треба пратити';
$string['privacy:metadata:aicc_session:timecreated'] = 'Време када је праћени елемент креиран';
$string['privacy:metadata:attempt'] = 'Број покушаја';
$string['privacy:metadata:scoes_track:element'] = 'Назив елемента који треба пратити';
$string['privacy:metadata:scoes_track:value'] = 'Вредност датог елемента';
$string['privacy:metadata:scorm_aicc_session'] = 'Информације о сесији AICC HACP-а';
$string['privacy:metadata:scorm_scoes_track'] = 'Праћени подаци за SCO-е који припадају активности';
$string['privacy:metadata:timemodified'] = 'Време када је праћени елемент последњи пут измењен';
$string['privacy:metadata:userid'] = 'Идентификатор корисника који је приступио SCORM активности';
$string['protectpackagedownloads'] = 'Заштити пакет од преузимања.';
$string['protectpackagedownloads_desc'] = 'Ако је ова опција омогућена SCORM пакет може да се преузме само уколико корисник има способност course:manageactivities. Ако је опција онемогућена, SCORM пакет може увек да се преузме (путем мобилног уређаја или на други начин).';
$string['raw'] = 'Необрађени резултат';
$string['regular'] = 'Регуларни манифест';
$string['report'] = 'Извештај';
$string['reportcountallattempts'] = '{$a->nbattempts} покушаја for {$a->nbusers} корисника, од укупно {$a->nbresults} резултата';
$string['reportcountattempts'] = '{$a->nbresults} резултата ({$a->nbusers} корисника)';
$string['reports'] = 'Извештаји';
$string['repositorynotsupported'] = 'Овај репозиторијум не подржава директно повезивање са imsmanifest.xml датотеком.';
$string['response'] = 'Одговор';
$string['result'] = 'Резултат';
$string['results'] = 'Резултати';
$string['review'] = 'Преглед';
$string['reviewmode'] = 'Режим прегледа';
$string['rightanswer'] = 'Тачан одговор';
$string['scoes'] = 'Објекти за учење';
$string['score'] = 'Резултат';
$string['scorm:addinstance'] = 'Додај нови SCORM  пакет';
$string['scorm:deleteownresponses'] = 'Обриши своје покушаје';
$string['scorm:deleteresponses'] = 'Обриши SCORM покушаје';
$string['scorm:savetrack'] = 'Сачувај записе';
$string['scorm:skipview'] = 'Прескакање прегледа';
$string['scorm:viewreport'] = 'Преглед извештаја';
$string['scorm:viewscores'] = 'Преглед резултата';
$string['scormclose'] = 'Доступно до';
$string['scormcourse'] = '(SCORM) курс за учење';
$string['scormloggingoff'] = 'API записиавање активности је искључено';
$string['scormloggingon'] = 'API записиавање активности је укључено';
$string['scormopen'] = 'Датум од ког ће бити доступно:';
$string['scormresponsedeleted'] = 'Обрисани покушаји корисника';
$string['scormstandard'] = 'Режим SCORM стандарда';
$string['scormstandarddesc'] = 'Када је онемогућено, Moodle дозвољава SCORM 1.2 пакетима да чувају више података него што спецификаија допушта, и користи Moodle подешавања за формата пуног имена када прослеђују корисничко име SCORM пакету.';
$string['scormtype'] = 'Тип';
$string['scormtype_help'] = 'Ово подешавање одређује како ће пакет бити укључен у курс. Постоје 4 могућности:

* Постављени пакет - омогућава да SCORM пакет буде изабран путем бирача датотека
* Екстерни SCORM манифест - омогућава да буде наведена URL адреса за imsmanifest.xml. Напомена: ако URL адреса има различит назив домена од Вашег сајта, онда је боља опција "Преузети пакет",  с обзиром да оцене неће бити сачуване.
* Преузети пакет - омогућава да буде наведена URL адреса пакета. Пакет ће бити распакован и сачуван локално, и ажуриран када се екстерни SCORM пакет промени
* Екстерни AICC URL - овај URL је почетни за појединачну AICC активност. Псеудо пакет ће бити конструисан око ње.';
$string['scrollbars'] = 'Дозволи померање (скроловање) прозора';
$string['search:activity'] = 'SCORM пакет - информације о активности';
$string['selectall'] = 'Изабери све';
$string['selectnone'] = 'Поништи избор свега';
$string['show'] = 'Прикажи';
$string['sided'] = 'Са стране';
$string['skipview'] = 'Полазник прескаче страницу са структуром садржаја';
$string['skipview_help'] = 'Ово подешавање одређује да ли страница са структуром садржаја треба увек да буде прескочена (неприказана). Ако пакет садржи само један објекат учења, страница са структуром садржаја може увек бити прескочена.';
$string['skipviewdesc'] = 'Овај параметар дефинише подразумевану вредност која одређује када ће бити прескочена структура садржаја за страницу';
$string['slashargs'] = 'УПОЗОРЕЊЕ: слеш аргументи нису дозвољени на овом сајту и објекти можда неће функционисати како се очекује!';
$string['stagesize'] = 'Величина нивоа';
$string['stagesize_help'] = 'Ова два подешавања одређују ширину и висину октвира/прозора за објекте учења.';
$string['started'] = 'Започето дана';
$string['status'] = 'Статус';
$string['statusbar'] = 'Прикажи статусну линију';
$string['student_response'] = 'Одговор';
$string['subplugintype_scormreport'] = 'Извештај';
$string['subplugintype_scormreport_plural'] = 'Извештаји';
$string['suspended'] = 'Суспендовано';
$string['syntax'] = 'Синтаксна грешка';
$string['tag_error'] = 'Непозната ознака ({$a->tag}) са овим садржајем: {$a->value}';
$string['time'] = 'Време';
$string['title'] = 'Наслов';
$string['toc'] = 'Садржај';
$string['too_many_attributes'] = 'Ознака {$a->tag} има јако пуно карактеристика';
$string['too_many_children'] = 'Ознака {$a->tag} има превише подређених ознака';
$string['toolbar'] = 'Прикажи траку са алаткама';
$string['totaltime'] = 'Време';
$string['trackcorrectcount'] = 'Исправи пребрајање';
$string['trackcorrectcount_help'] = 'Број тачних резултата за питање';
$string['trackid'] = 'ID';
$string['trackid_help'] = 'Ово је идентификатор који је поставио ваш SCORM пакет за ово питање: SCORM спецификација не допушта да се користи цео текст питања.';
$string['trackingloose'] = 'УПОЗОРЕЊЕ: Подаци о праћењу овог SCORM пакета биће изгубљени!';
$string['tracklatency'] = 'Латенција';
$string['tracklatency_help'] = 'Време протекло између тренутка када је инетеракција постала доступна полазнику и тренутка првог одговора';
$string['trackpattern'] = 'Образац';
$string['trackpattern_help'] = 'Овако би требало да гласи тачан одговор на ово питање; не приказује одговоре студената.';
$string['trackresponse'] = 'Одговор';
$string['trackresponse_help'] = 'Ово је одговор који је дао полазник на ово питање';
$string['trackresult'] = 'Резултат';
$string['trackresult_help'] = 'Резултат на основу одговора полазника и тачног одговора.';
$string['trackscoremax'] = 'Максималан скор';
$string['trackscoremax_help'] = 'Максимална вредност у опсегу за необрађени резултат';
$string['trackscoremin'] = 'Минималан скор';
$string['trackscoremin_help'] = 'Минимална вредност у опсегу за необрађени резултат';
$string['trackscoreraw'] = 'Необрађени резултат';
$string['trackscoreraw_help'] = 'Број који одражава постигнуће полазника у односу на опсег ограничен минималном и максималном вредношћу';
$string['tracksuspenddata'] = 'Суспендуј податке';
$string['tracksuspenddata_help'] = 'Обезбеђује простор за складиштење и преузимање података између сесија полазника';
$string['tracktime'] = 'Време';
$string['tracktime_help'] = 'Време када је започет покушај';
$string['tracktype'] = 'Тип';
$string['tracktype_help'] = 'Тип питања, на пример "избор" или "кратак одговор"';
$string['trackweight'] = 'Тежина';
$string['trackweight_help'] = 'Тежина додељена питању приликом израчунавања резултата.';
$string['type'] = 'Тип';
$string['typeaiccurl'] = 'URL адреса екстерног AICC пакета';
$string['typeexternal'] = 'Екстерни SCORM манифест';
$string['typelocal'] = 'Постављени пакет';
$string['typelocalsync'] = 'Преутети пакет';
$string['undercontent'] = 'Испод садржаја';
$string['unziperror'] = 'Дошло је до грешке приликом распакивања пакета';
$string['updatefreq'] = 'Учесталост аутоматског ажурирања';
$string['updatefreq_error'] = 'Учесталост аутоматског ажурирања се може подесити само онда када се пакет екстерно хостује';
$string['updatefreq_help'] = 'Ово омогућава да се екстерни пакет аутоматски преузме и ажурира';
$string['updatefreqdesc'] = 'Овај параметар дефинише подразумевану вредност која одређује учесталост аутоматског ажурирања активности';
$string['validateascorm'] = 'Провери исправност SCORM пакета';
$string['validation'] = 'Резултат провере исправности';
$string['validationtype'] = 'Ово својство одређује DOMXML библиотеку која се користи за валидацију SCORM манифеста. Ако нисте сигурни коју вредност треба да поставите, оставите тренутно активни избор.';
$string['value'] = 'Вредност';
$string['versionwarning'] = 'Верзија манифеста је старија од 1.3, упозорење на ознаци {$a->tag}';
$string['viewallreports'] = 'Прикажи извештај за {$a} покушаја';
$string['viewalluserreports'] = 'Погледај извештај за {$a} корисника';
$string['whatgrade'] = 'Оцењивање покушаја';
$string['whatgrade_help'] = 'Ако су дозвољени вишеструки покушаји, ова подешавање одређује да ли ће у књигу оцена бити уписана највећа, средња, или оцена првог односно пoследње завршеног покушаја.
Опција за последње завршени покушај не укључује оне који имају статус неуспелог покушаја.

Рад са вишеструким покушајима

* Опција за почетак новог покушаја биће приказана као поље за потврду изнад дугмета за улазак, на страници са структуром садржаја. Проверите да ли сте обезбедили приступ тој страници, ако желите да дозволите вишеструке покушаје.
* Неки SCORM пакети паметно поступају са новим покушајима, али већина не. Ово значи да ако корисник настави са претходним покушајем, а SCORM нема сопствену логику за избегавање преписивања преко претходног покушаја, нови покушај ће заменити стари, чак иако је стари покушај био обележен са \'завршен\' или \'положио\'.
* Подешавaњa "Принудни завршетак", "Принудни нови покушај" и "Закључај након последњег покушаја" такође пружају додатне могућности за рад са вишеструким покушајима.';
$string['whatgradedesc'] = 'Да ли се у књигу оцена уписује највећа, просечна, или оцена првог односно последње завршеног покушај, уколико су дозвољени вишеструки покушаји.';
$string['width'] = 'Ширина';
$string['window'] = 'Прозор';
$string['youmustselectastatus'] = 'Морате одабрати статус који ће се захтевати';
