<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'sr_cr', version '3.9'.
 *
 * @package     scheduler
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Акција';
$string['actions'] = 'Акције';
$string['addappointment'] = 'Додај још једног полазника';
$string['addcommands'] = 'Додај термине';
$string['addondays'] = 'Додај састанке за';
$string['addsession'] = 'Додај термине који се понављају';
$string['addsingleslot'] = 'Додај појединачни термин';
$string['addslot'] = 'Можете додати још термина у свако доба.';
$string['addstudenttogroup'] = 'Додај овој полазника заказаној групи';
$string['allappointments'] = 'Сви састанци';
$string['allononepage'] = 'Сви термини на једној страници';
$string['allowgroup'] = 'Ексклузиван термин - кликните за измену статуса';
$string['alreadyappointed'] = 'Није могуће заказати састанак. Термин је већ потпуно попуњен.';
$string['appointagroup_help'] = 'Одаберите да ли желите да закажете састанак само за себе или за целу групу.';
$string['appointforgroup'] = 'Направи састанке за: {$a}';
$string['appointingstudent'] = 'Састанак у термину';
$string['appointingstudentinnew'] = 'Састанак у новом термину';
$string['appointment'] = 'Састанак';
$string['appointmentmode'] = 'Подешавање режима рада за састанак';
$string['appointmentmode_help'] = '<p>Овде можете одабрати неке варијанте реализације састанака. </p>
<p><ul>
<li><strong>"<emph>n</emph> састанак у овом планеру":</strong> Полазник може да закаже прецизно одређен број састанака у оквиру ове активности. Чак и ако првобитно заказане састанке предавач означи као "Одржане" , полазнику неће бити дозвољено да заказује даље сусрете. Једини начин да се ресетује способност полазника да заказује састанке је да се обришу стари термини који су већ реализовани.</li>
<li><strong>"<emph>n</emph> састанака одједном":</strong> Полазник може да закаже прецизно одређен број састанака. Једном кад се неки састанак заврши и предавач га означи "Одржаним" полазник може да заказује наредни сусрет. У сваком тренутку је ограничен на <emph>n</emph> "отворених" (неодржаних) термина.
</li>
</ul>
</p>';
$string['appointmentno'] = 'Састанак {$a}';
$string['appointments'] = 'Састанци';
$string['appointmentsgrouped'] = 'Састанци груписани по терминима';
$string['appointmentsummary'] = 'Састанак у {$a->startdate} од {$a->starttime} до {$a->endtime} са предавачем под именом {$a->teacher}';
$string['appointsolo'] = 'само ја';
$string['appointsomeone'] = 'Додај нови састанак';
$string['attendable'] = 'Може се присуствовати';
$string['attendablelbl'] = 'Укупан број кандидата за заказивање';
$string['attended'] = 'Присуствовано';
$string['attendedlbl'] = 'Број полазника који су присуствовали састанку';
$string['attendedslots'] = 'Термини у којима је присуствовано';
$string['availableslots'] = 'Расположиви термини';
$string['availableslotsall'] = 'Сви термини';
$string['availableslotsnotowned'] = 'Није поседован';
$string['availableslotsowned'] = 'Поседован';
$string['bookslot'] = 'Резервиши термин';
$string['bookwithteacher'] = 'Предавач';
$string['bookwithteacher_help'] = 'Одаберите предавача за састанак.';
$string['break'] = 'Пауза између термина';
$string['breaknotnegative'] = 'Дужина паузе не сме бити негативна';
$string['canbook1appointment'] = 'Можете заказати још један састанак у овом планеру.';
$string['canbooknappointments'] = 'Можете заказати још {$a} састан(а)ка у овом планеру.';
$string['canbooknofurtherappointments'] = 'Не можете заказати више састанака у овом планеру.';
$string['canbooksingleappointment'] = 'Можете заказати један састанак у овом планеру.';
$string['canbookunlimitedappointments'] = 'Можете заказати колико год желите састанака у овом планеру.';
$string['cancelbooking'] = 'Откажи резервацију';
$string['chooseexisting'] = 'Изабери постојећи';
$string['choosingslotstart'] = 'Изаберите време почетка';
$string['choosingslotstart_help'] = 'Промените (или одаберите) време почетка састанка. Ако је оно у колизији са неким другим термином бићете питани да ли овај термин замењује све састанке с којима се преклапа. Имајте на уму да ће параметри новог термина бити сачувани уместо свих претходних подешавања.';
$string['comments'] = 'Коментари';
$string['complete'] = 'Заказан';
$string['conflictingslots'] = 'Преклапа се';
$string['contentformat'] = 'Формат';
$string['contentformat_help'] = '<p>Постоје три основна формата за извоз, који се разликују по томе како третирају термине са више заказаних састанака.
     <dl>
         <dt>Један ред по термину</dt>:
         <dd>
             Излазна датотека ће садржати један ред за сваки термин. Ако термин садржи више састанака уместо имена полазника и сл. биће уписана ознака "више".
         </dd>
         <dt>Један ред по састанку</dt>:
         <dd>
             Излазна датотека ће садржати један ред за сваки састанак. Ако термин садржи више састанака појавиће се више пута  на списку (са поновљеним подацима о њему).
         </dd>
         <dt>Састанци груписани по терминима</dt>:
         <dd>
             Сви састанци заказани за један термин се групишу и тако уписују у излазну датотеку уз линију заглавља у којој се наводи о ком је термину реч. Ова опција можда неће добро радити у случају одабира CSV формата излазне датотеке пошто број колона није константан.
         </dd>
    </dl>
    Можете проучити ефекте активације ових опција кликом на дугме са натписом "Преглед".</p>';
$string['course'] = 'Курс';
$string['createexport'] = 'Креирај излазну датотеку';
$string['csvfieldseparator'] = 'Гранични знак за CSV';
$string['csvformat'] = 'CSV';
$string['cumulatedduration'] = 'Укупно трајање састанака';
$string['datatoinclude'] = 'Подаци које треба укључити';
$string['datatoinclude_help'] = 'Одаберите поља која треба укључити у извоз. Свако од њих ће се појавити у посебној колони извозне датотеке.';
$string['date'] = 'Датум';
$string['datelist'] = 'Преглед';
$string['defaultslotduration'] = 'Подразумевано трајање термина';
$string['defaultslotduration_help'] = 'Подразумевана дужина (у минутима) за термине састанака које подешавате';
$string['deleteallslots'] = 'Обриши све термине';
$string['deleteallunusedslots'] = 'Обриши неискоришћене термине';
$string['deletecommands'] = 'Обриши термине';
$string['deletemyslots'] = 'Обриши све моје термине';
$string['deleteselection'] = 'Обриши изабране термине';
$string['deletetheseslots'] = 'Обриши ове термине';
$string['deleteunusedslots'] = 'Обриши моје неискоришћене термине';
$string['department'] = 'Одакле?';
$string['disengage'] = 'Откажи моје састанке';
$string['displayfrom'] = 'Приказ састанака полазницима од дана';
$string['distributetoslot'] = 'Дистрибуирај целој групи';
$string['divide'] = 'Подели у термине?';
$string['duration'] = 'Трајање';
$string['durationrange'] = 'Дужина термина мора бити између {$a->min} и {$a->max} минута.';
$string['email_applied_html'] = '<p>Заказан је састанак за {$a->date} у {$a->time},<br/>
од стране полазника под именом <a href="{$a->attendee_url}">{$a->attendee}</a> на курсу:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>коришћењем планера под насловом "<em>{$a->module}</em>" на сајту: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'За састанак је дана {$a->date} у {$a->time} пријављен полазник {$a->attendee} на курсу:

{$a->course_short}: {$a->course}

коришћењем планера под насловом "{$a->module}" на сајту: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: Нови састанак';
$string['email_cancelled_html'] = '<p>Ваш састанак заказан за <strong>{$a->date}</strong> у <strong>{$a->time}</strong>,<br/>
са полазником под именом <strong><a href="{$a->attendee_url}">{$a->attendee}</a></strong> на курсу:</p>

<p><strong>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>у планеру под насловом "<em>{$a->module}</em>" на сајту: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">је отказан или померен</span></strong>.</p>';
$string['email_cancelled_plain'] = 'Ваш састанак за дан  {$a->date} у {$a->time},
са полазником {$a->attendee} на курсу:

{$a->course_short} : {$a->course}

у планеру под насловом "{$a->module}" на сајту: {$a->site}

је отказан или померен.';
$string['email_cancelled_subject'] = '{$a->course_short}: Састанак је отказан или померен од стране полазника';
$string['email_reminder_html'] = '<p>Приближава се састанак заказан за <strong>{$a->date}</strong>
од <strong>{$a->time}</strong> до <strong>{$a->endtime}</strong><br/>
са корисником под именом <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong>.</p>

<p>Локација: <strong>{$a->location}</strong></p>';
$string['email_reminder_plain'] = 'Приближава се састанак заказан за {$a->date} од {$a->time} до {$a->endtime}
са полазником под именом {$a->attendant}.

Локација: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Подсетник о састанку';
$string['email_teachercancelled_html'] = '<p>Ваш састанак заказан за <strong>{$a->date}</strong> у <strong>{$a->time} </strong>,<br/>
са {$a->staffrole} <strong><a href="{$a->attendant_url}">{$a->attendant}</a></strong> на курсу:</p>

<p><strong>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></strong></p>

<p>у планеру "<em>{$a->module}</em>" на сајту: <strong><a href="{$a->site_url}">{$a->site}</a></strong></p>

<p><strong><span class="error">је отказан</span></strong>. Молимо пријавите се за нови термин.</p>';
$string['email_teachercancelled_plain'] = 'Ваш састанак планиран за {$a->date} at {$a->time},
са {$a->staffrole} {$a->attendant} на курсу:

{$a->course_short}: {$a->course}

према планеру под називом "{$a->module}" на сајту: {$a->site}

је отказан. Молимо пријавите се за нови термин.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Састанак је отказан од стране предавача';
$string['emailreminder'] = 'Пошаљи подсетник електронском поштом';
$string['emailreminderondate'] = 'Пошаљи подсетник електронском поштом дана';
$string['end'] = 'Завршетак';
$string['enddate'] = 'Понављај термине до';
$string['event_appointmentlistviewed'] = 'Приказана је листа састанака у планеру';
$string['event_bookingadded'] = 'Додат је заказан термин у планер';
$string['event_bookingformviewed'] = 'Приказан је формулар за заказивање у планеру';
$string['event_bookingremoved'] = 'Уклоњен је заказан термин из планера';
$string['everyone'] = 'Свако';
$string['excelformat'] = 'Excel';
$string['exclusive'] = 'Ексклузивно';
$string['exclusivity'] = 'Ексклузивност';
$string['exclusivity_help'] = '<p>Можете ограничити број полазника који се могу пријавити за дати термин. </p>
<p>Постављање ограничења на 1 (подразумевано) ће значити да ће термин бити расположив само једном полазнику.</p>
<p>Постављање ограничења на нпр. 3 ће значити да се за њега може пријавити до 3 полазника.</p>
<p>Ако је ово подешавање искључено било који број полазника ће моћи да закаже састанак у том термину; он никад неће бити сматран "попуњеним".</p>';
$string['exclusivityoverload'] = 'Термин је заказан за {$a} полазника, више него што је дозвољено овим подешавањем.';
$string['exclusivitypositive'] = 'Број полазника по термину мора бити 1 или више.';
$string['explaingeneralconfig'] = 'Ове опције се могу подесити искључиво на нивоу сајта како би се примениле на све планере на овој Moodle инсталацији.';
$string['export'] = 'Извоз';
$string['exporthdr'] = 'Извези темине и састанке';
$string['field-attended'] = 'Присуствовао/ла';
$string['field-date'] = 'Датум';
$string['field-endtime'] = 'Време завршетка';
$string['field-grade'] = 'Оцена';
$string['field-location'] = 'Локација';
$string['field-maxstudents'] = 'Максималан број полазника';
$string['field-slotnotes'] = 'Белешке о термину';
$string['field-starttime'] = 'Време почетка';
$string['field-studentemail'] = 'Полазникова адреса електронске поште';
$string['field-studentfirstname'] = 'Полазниково име';
$string['field-studentfullname'] = 'Полазниково пуно име';
$string['field-studentidnumber'] = 'Полазников идентификациони број';
$string['field-studentlastname'] = 'Полазниково презиме';
$string['field-studentusername'] = 'Полазниково корисничко име';
$string['fileformat'] = 'Формат датотеке';
$string['fileformat_help'] = 'Расположиви су следећи формати:
     <ul>
          <li>Текстуална датотека са вредностима раздвојеним зарезима (CSV). Знак за раздвајање вредности, подразумевано зарез, може се одабрати ниже.
               CSV датотеке се могу отворити у већини апликација за табеларне прорачуне;</li>
          <li>Microsoft Excel датотека (Excel 2007 формат);</li>
          <li>Open Document табела за прорачуне (ODS);</li>
          <li>HTML формат - веб страница на којој се приказује излазна табела,
                која се може штампати коришћењем опција за штампу које нуди читач;</li>
          <li>PDF документ. Можете бирати између хоризонталне и вертикалне оријентације.</li>
     </ul>';
$string['finalgrade'] = 'Коначна оцена';
$string['firstslotavailable'] = 'Први термин ће бити отворен на дан: {$a}';
$string['forbidgroup'] = 'Групни термин - кликните за измену статуса';
$string['forcewhenoverlap'] = 'Форсирај при преклапању';
$string['forcewhenoverlap_help'] = '<h3>Форсирање креирања термина кад дође до преклапања</h3>
<p>Ово подешавања одређује како ће се третирати нови термини у случају њиховог преклапања са другим, већ постојећим терминима.</p>
<p>Ако је укључено постојећи термин који се преклапа с новим ће бити обрисан а нови ће бити креиран.</p>
<p>Ако је искључено, постојећи термин који се преклапа с новим ће бити задржан а нови <em>неће</em> бити креиран.</p>';
$string['forcewhenoverlap_link'] = 'mod/scheduler/conflict';
$string['forcourses'] = 'Одаберите студенте са курсева';
$string['friday'] = 'Петак';
$string['generalconfig'] = 'Општа подешавања';
$string['grade'] = 'Оцена';
$string['gradeingradebook'] = 'Оцена у дневнику оцена';
$string['gradingstrategy'] = 'Стратегија оцењивања';
$string['gradingstrategy_help'] = 'Одаберите како да се израчунавају оцене кад полазници могу да имају више састанака у планеру.
    Дневник оцена може да приказује или <ul><li>просечну оцену или</li><li>максималну оцену</li></ul> коју је полазник добио.';
$string['group'] = 'група';
$string['groupbookings'] = 'Заказивање у групама';
$string['groupbookings_help'] = 'Дозволи полазницима да закажу термин за све чланове своје групе. (Приметите да се ово разликује од подешавања групног мода који контролише који термини се прказују полазницима.)';
$string['groupbreakdown'] = 'Према величини групе';
$string['groupmodeyourgroups'] = 'Групни мод: {$a->groupmode}. Само полазници у {$a->grouplist} могу да закажу састанак са Вама.';
$string['groupmodeyourgroupsempty'] = 'Групни мод: {$a->groupmode}. Нисте члан ниједне групе па полазници не могу да закажу састанак са Вама.';
$string['groupscheduling'] = 'Омогући групно заказивање';
$string['groupscheduling_desc'] = 'Дозволи заказивање за целе групе одједном.
(Осим глобалне опције, подешавање "Заказивање у групама" мора бити активирано у поставкама конкретног планера.)';
$string['groupsession'] = 'Групна сесија';
$string['groupsize'] = 'Величина групе';
$string['guardtime'] = 'Заштитна временска маргина';
$string['guardtime_help'] = 'Заштитна временска маргина спречава полазнике да промене своје заказане термине тик пред њихову реализацију.
<p>Ако је заштитна временска маргина подешена на, на пример, 2 сата, полазници неће моћи да закажу термин који почиње за мање од 2 сата од момента заказивања, а неће моћи ни да откажу састанак ако он треба да почне за мање од 2 сата.</p>';
$string['guestscantdoanything'] = 'Гости овде не могу ништа да раде.';
$string['howtoaddstudents'] = 'Да бисте додали полазнике у планер са глобалним опсегом користите подешавање улоге за модул.<br/>Можете користити и дефиниције улоге модула да бисте одредили полазнике који ће присуствовати.';
$string['htmlformat'] = 'HTML';
$string['ignoreconflicts'] = 'Игнориши преклапања термина';
$string['ignoreconflicts_help'] = 'Ако је ово поље означено термин ће бити померен на захтеван датум и време, чак и ако постоје други термини у истом временском интервалу. То може довести до преклапања састанака за неке од предавача или полазника и стога ова опција треба да се користи врло пажљиво.';
$string['ignoreconflicts_link'] = 'mod/scheduler/conflict';
$string['includeemptyslots'] = 'Укључи празне термине';
$string['includeslotsfor'] = 'Укључи термине за';
$string['incourse'] = 'На курсу';
$string['introduction'] = 'Увод';
$string['isnonexclusive'] = 'Није ексклузивно';
$string['landscape'] = 'Хоризонтална';
$string['lengthbreakdown'] = 'Према трајању термина';
$string['limited'] = 'Ограничен број места (преостало их је {$a})';
$string['location'] = 'Локација';
$string['location_help'] = 'Одредите локацију на којој ће се одржати састанак.';
$string['markasseennow'] = 'Сад означи да је одржан';
$string['markseen'] = 'Након што завршите састанак са полазником молимо означите га са "Одржан" кликом на поље за потврду поред слике корисника изнад.';
$string['maxgrade'] = 'Узми највишу оцену.';
$string['maxstudentlistsize'] = 'Максимална дужина списка полазника';
$string['maxstudentlistsize_desc'] = 'Максимална дужина списка полазника који треба да закажу састанак приказаног у прегледу планера из визуре предавача. Ако је на курсу више полазника него што је овде назначено неће бити приказана никаква листа.';
$string['maxstudentsperslot'] = 'Максималан број полазника по термину';
$string['maxstudentsperslot_desc'] = 'Групни термини / термини који нису ексклузивни могу важити за највише овај број полазника. Приметите да се додатно подешавање на неограничени број полазника увек може одабрати за сваки термин.';
$string['meangrade'] = 'Узми просечну оцену';
$string['meetingwith'] = 'Састајете се са корисником у улози';
$string['meetingwithplural'] = 'Састајете се са корисницима у улози';
$string['minutes'] = 'минута';
$string['minutesperslot'] = 'минута по термину';
$string['missingstudents'] = 'Број полазника који још треба да закажу састанак:  {$a}';
$string['missingstudentsmany'] = '{$a} полазника још треба да закаже састанак. Њихов списак није приказан јер је предугачак.';
$string['mode'] = 'Режим рада';
$string['modeappointments'] = 'састан(а)к(а)';
$string['modeintro'] = 'Полазници се могу пријавити';
$string['modeoneatatime'] = 'одједном';
$string['modeoneonly'] = 'у овом планеру';
$string['modulename'] = 'Планер';
$string['modulename_help'] = 'Активност планер помаже при прављењу распореда састанака са полазницима курса.

Предавачи одређују термине састанака од којих полазници потом бирају оне који им одговарају. Предавачи као повратну информацију могу да забележе исход састанка - и опционо оцену - све у оквиру планера.

Групно заказивање је подржано; сваки термин може да закаже неколико полазника а опционо је могуће заказивати и састанке за целе групе одједном.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'Планери';
$string['monday'] = 'Понедељак';
$string['multiple'] = '(више)';
$string['myappointments'] = 'Моји састанци';
$string['myself'] = 'Ја';
$string['name'] = 'Назив планера';
$string['needteachers'] = 'Није могуће додати термине јер на овом курсу нема предавача';
$string['negativerange'] = 'Опсег је негативан. То не може бити исправно.';
$string['never'] = 'Никад';
$string['noappointments'] = 'Нема састанака';
$string['noexistingstudents'] = 'Нема полазника расположивих за заказивање састанака';
$string['nogroups'] = 'Нема група расположивих за заказивање.';
$string['noresults'] = 'Нема резултата.';
$string['noschedulers'] = 'Нема планера';
$string['noslots'] = 'Нема слободних термина за састанак.';
$string['noslotsavailable'] = 'Тренутно нема расположивих термина за заказивање састанака.';
$string['noslotsopennow'] = 'Тренутно нема отворених термина за заказивање састанака.';
$string['nostudents'] = 'Ниједан полазник није заказао састанак';
$string['nostudenttobook'] = 'Нема полазника који би могли да заказују састанке';
$string['note'] = 'Оцена';
$string['noteacherforslot'] = 'Нема предавача за термине';
$string['noteachershere'] = 'Нема расположивих предавача';
$string['notenoughplaces'] = 'Жао нам је, нема довољно слободних места у овом термину.';
$string['notifications'] = 'Обавештења';
$string['notifications_help'] = 'Када је ова опција укључена предавачи и полазници ће добијати обавештења кад год се састанци закажу или откажу.';
$string['notseen'] = 'Није одржан';
$string['now'] = 'Сад';
$string['occurrences'] = 'Извођења';
$string['odsformat'] = 'ODS';
$string['on'] = 'дана';
$string['onedaybefore'] = '1 дан пре термина';
$string['onelineperappointment'] = 'Један ред по састанку';
$string['onelineperslot'] = 'Један ред по термину';
$string['oneslotadded'] = 'Додат је 1 термин';
$string['oneweekbefore'] = '1 седмицу пре термина';
$string['onthemorningofappointment'] = 'Ујутро на дан састанка';
$string['options'] = 'Опције';
$string['otherstudents'] = 'Остали учесници';
$string['overall'] = 'Укупно';
$string['overlappings'] = 'Неки други термини се преклапају с овим';
$string['pageperteacher'] = 'Једна страница за сваки {$a}';
$string['pagination'] = 'Прелом страна';
$string['pagination_help'] = 'Одаберите да ли ће излазна датотека садржати посебну страницу  за сваког предавача или не. У Excel и ODS формату те странице одговарају радним листовима табеле за прорачуне.';
$string['pdfformat'] = 'PDF';
$string['pdforientation'] = 'Оријентација стране у PDF датотеци';
$string['pluginadministration'] = 'Администрација планера';
$string['pluginname'] = 'Планер';
$string['portrait'] = 'Вертикална';
$string['preview'] = 'Преглед';
$string['previewlimited'] = '(Преглед је ограничен на {$a} редова.)';
$string['registeredlbl'] = 'Полазници којима су заказани састанци';
$string['reminder'] = 'Подсетник';
$string['resetappointments'] = 'Обриши састанке и оцене';
$string['resetslots'] = 'Обриши термине у планеру';
$string['return'] = 'Назад на курс';
$string['revoke'] = 'Откажи састанак';
$string['saturday'] = 'Субота';
$string['save'] = 'Сачувај';
$string['savechoice'] = 'Сачувај мој избор';
$string['saveseen'] = 'Сачувај одржано';
$string['schedule'] = 'План';
$string['scheduleappointment'] = 'Закажи састанак за {$a}';
$string['schedulecancelled'] = '{$a}: Ваш састанак је отказан или померен';
$string['schedulegroups'] = 'Закажи као група';
$string['scheduleinnew'] = 'Закажи у новом термину';
$string['scheduleinslot'] = 'Закажи у термину';
$string['scheduler'] = 'Планер';
$string['scheduler:addinstance'] = 'Додај нови планер';
$string['scheduler:appoint'] = 'Закажи';
$string['scheduler:attend'] = 'Прими полазнике';
$string['scheduler:canscheduletootherteachers'] = 'Закажи састанке за друге чланове наставног особља';
$string['scheduler:canseeotherteachersbooking'] = 'Види и прегледај заказане термине других предавача';
$string['scheduler:disengage'] = 'Ова могућност је застарела и не ради ништа';
$string['scheduler:manage'] = 'Управљај својим терминима и састанцима';
$string['scheduler:manageallappointments'] = 'Управљај свим подацима планера';
$string['scheduler:seeotherstudentsbooking'] = 'Види резервације термина које су направили други полазници';
$string['scheduler:seeotherstudentsresults'] = 'Види резултат полазника за други термин';
$string['scheduler:seeoverviewoutsideactivity'] = 'Користите екран за преглед да бисте видели термине ван текућег планера.';
$string['schedulestudents'] = 'Планер по полазнику';
$string['scopemenu'] = 'Прикажи термине у: {$a}';
$string['scopemenuself'] = 'Прикажи моје термине у: {$a}';
$string['seen'] = 'Одржан';
$string['selectedtoomany'] = 'Одабрали сте превише термина. Не можете одабрати више од {$a}.';
$string['sepcolon'] = 'Двотачка';
$string['sepcomma'] = 'Зарез';
$string['sepsemicolon'] = 'Тачка и зарез';
$string['septab'] = 'Табулатор';
$string['showemailplain'] = 'Прикажи адресу електронске поште као обичан текст';
$string['showemailplain_desc'] = 'У приказу планера за предаваче прикажи адресе полазника којима треба састанак као обичан текст, као додатак mailto: линковима.';
$string['showparticipants'] = 'Прикажи учеснике';
$string['slot'] = 'Термин';
$string['slot_is_just_in_use'] = 'Извињавамо се, састанак је управо одабрао неки други полазник! Молимо покушајте поново.';
$string['slotdatetime'] = '{$a->shortdatetime} за {$a->duration} минута';
$string['slotdescription'] = '{$a->status} на дан {$a->startdate} од {$a->starttime} до {$a->endtime} на локацији {$a->location} са предавачем под именом {$a->facilitator}.';
$string['slots'] = 'Термини';
$string['slotsadded'] = 'Додато је {$a} термина';
$string['slottype'] = 'Тип термина';
$string['slotupdated'] = 'Ажуриран је 1 термин';
$string['slotwarning'] = '<strong>Упозорење: </strong>Померање овог термина на одабрано време доводи до његовог преклапања са термином(-има) наведеним испод. Означите опцију "Игнориши преклапања термина" ако желите да померите термин упркос томе.';
$string['staffbreakdown'] = 'Према {$a}';
$string['staffrolename'] = 'Назив улоге предавача';
$string['staffrolename_help'] = 'Натпис за улогу оног ко прима полазнике. То не мора нужно бити "предавач".';
$string['start'] = 'Почетак';
$string['startpast'] = 'Не можете започети незаказан састанак у прошлости.';
$string['statistics'] = 'Статистика';
$string['student'] = 'Полазник';
$string['studentbreakdown'] = 'Према полазнику';
$string['studentcomments'] = 'Белешке полазника';
$string['studentdetails'] = 'Детаљи о полазнику';
$string['studentmultiselect'] = 'Сваки полазник може бити одабран само једном у овом термину';
$string['students'] = 'Полазници';
$string['sunday'] = 'Недеља';
$string['tab-otherappointments'] = 'Сви састанци овог полазника';
$string['tab-otherstudents'] = 'Полазници у овом термину';
$string['tab-thisappointment'] = 'Овај састанак';
$string['teacher'] = 'Предавач';
$string['teachersmenu'] = 'Прикажи термине за: {$a}';
$string['thiscourse'] = 'овај курс';
$string['thisscheduler'] = 'овај планер';
$string['thissite'] = 'цео сајт';
$string['thursday'] = 'Четвртак';
$string['totalgrade'] = 'Укупна оцена';
$string['tuesday'] = 'Уторак';
$string['unattended'] = 'Није присуствовано';
$string['unlimited'] = 'Није ограничено';
$string['unregisteredlbl'] = 'Полазници којима није заказан састанак';
$string['upcomingslots'] = 'Предстојећи термини';
$string['updategrades'] = 'Ажурирај оцене';
$string['updatesingleslot'] = '';
$string['usebookingform_link'] = 'mod/scheduler/bookingform';
$string['wednesday'] = 'Среда';
$string['welcomebackstudent'] = 'Можете заказати додатне термине кликовима на одговарајућа дугмад са натписом "Закажи термин" ниже.';
$string['welcomenewstudent'] = 'Табела испод приказује све расположиве термине за састанак. Начините свој избор кликом на одговарајуће дугме са натписом "Закажи термин". Ако касније будете желели да направите неку измену увек се можете вратити на ову страницу.';
$string['welcomenewteacher'] = 'Молимо кликните на дугме испод да бисте додали термине за састанке.';
$string['what'] = 'Шта?';
$string['whathappened'] = 'Шта се десило?';
$string['whatresulted'] = 'Шта је исход?';
$string['when'] = 'Када?';
$string['where'] = 'Где?';
$string['who'] = 'Са ким?';
$string['whosthere'] = 'Ко је тамо?';
$string['xdaysbefore'] = '{$a} дана пре термина';
$string['xweeksbefore'] = '{$a} седмица пре термина';
$string['yesallgroups'] = 'Да, за све групе';
$string['yesingrouping'] = 'Да, у груписању {$a}';
$string['yourappointmentnote'] = 'Коментари само за ваше очи';
$string['yourslotnotes'] = 'Коментари о сусрету';
$string['yourtotalgrade'] = 'Ваша укупна оцена за ову активност је <strong>{$a}</strong>.';
