<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'sr_cr', version '3.9'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutdemosite'] = 'Наш демонстрациони сајт је потпуно функционалан Moodle сајт који можете испробати као наставник, студент или, чак, администратор. Не брините ако направите било какву грешку, цео сајт се сваких сат времена враћа на почетно стање.';
$string['aboutdemositetitle'] = 'Демонстрациони сајт';
$string['aboutintro'] = 'Moodle је Систем за управљање курсевима (Course Management System - CMS) отворенога кода, познат и као Систем за управљања учењем (Learning Management System - LMS) или Виртуелно окружење за учење (Virtual Learning Environment - VLE). Moodle је  постао врло популаран међу предавачима широм света као алат за креирање онлајн динамичких веб сајтова намењених студентима и ученицима. Потребно је да Moodle инсталирате на веб сервер, који се налази било на вашем рачунару, било на рачунару неке комерцијалне фирме која пружа услугу веб хостинга.';
$string['aboutoverview'] = '<p>Од самог  почетка Moodle пројекат је усредсређен на то да предавачима пружи најбоље алате за управљање и унапређења процеса учења. Ипак, постоји пуно различитих начина како се Moodle може користити:</p>
<ul>
<li>Moodle има моћне функције које омогућавају његову примену на великим факултетима и школама са стотинама хиљада корисника, али се исто тако он може користи за основне школе и друга релативно мања образовна окружења.</li>
<li>Многе установе користе Moodle као своју платформу за спровођење наставе тј. курсева који се у потпуности реализују у онлајн окружењу, док га друге користе као подршку настави која се делимично одвија у класичном F2F окружењу (овај облик је познат и као хибридно учење - "blended learning").</li>
<li>Многи од наших корисника воле да користе активности (као што су форуми, базе података и викији) како би за потребе изучавања свог предмета креирали моћне колаборативне заједнице учења (у духу педагошког приступа који је познат као социјални конструктивизам). Други корисници,  више воле да користе Moodle као репозиторијум образовних садржаја за студенте (као што су то нпр. стандардни SCORM пакети), и/или да га користе за процену наученог тј. знања студената кроз задатке и тестове.</li>
</ul>';
$string['aboutoverviewtitle'] = 'Шта је то Moodle?';
$string['aboutstatistics'] = 'С обзиром да Moodle можете бесплатно да преузмете, и да је регистрација добровољна, немамо потпуне податке о свима који Moodle користе. Међутим, на основу података које поседујемо, аутоматски генеришемо неке занимљиве графиконе и бројчане податке који се могу видети на нашој страници за статистику.';
$string['aboutstatisticsheading'] = 'Moodle статистика';
$string['aboutstatisticstitle'] = 'Статистика';
$string['activeusers24hours'] = 'Регистровани корисници који су приступали сајту у последња 24 часа.';
$string['activeuserspastmonth'] = 'Регистровани корисници који су приступали сајту у последња месец дана.';
$string['communityintro'] = 'Moodle има велику и разнолику заједницу корсиника са преко <a href="http://moodle.org/userpics">{$a->usercount} регистрованих корисника</a> само на овом Moodle сајту, који говоре преко <a href="http://download.moodle.org/lang16/">{$a->langcount} језика</a> у <a href="http://moodle.org/sites">{$a->countrycount} земаља</a> (на <a href="http://moodle.org/stats">можете видети детаљније статистичке податке</a>).';
$string['conferencecenter'] = 'Moodle конференцијски центар';
$string['connectedsites'] = 'Неки Moodle сајтови су повезани са moodle.org путем Moodle умрежавања (MNet), тако да се на њих можете пријавити директно, након што Ваш идентитет буден проверен на овом сајту.';
$string['contactbugs'] = 'Проблеме са Moodle софтвером или било којим moodle.org. сајтом можете пријавити на Moodle Trackeru.';
$string['contactbugstitle'] = 'Пријава багова';
$string['contactintro'] = 'Молим, изаберите једну од следећих могућности за контакт.';
$string['contactlogin'] = 'За све остале упите, пријавите на овај сајт и употребите образац за контак који ће се појавити на овој страници.';
$string['contactmoodlecom'] = 'За сва питања у вези са лиценцирањем, заштитним знаком или комерцијалном употребом, као и за питања у вези са развојем Moodea, молимо Вас да контактирате центар за помоћ на <a href="http://moodle.com/">Moodle.com</a>';
$string['contactmoodlecomhelpdesk'] = 'Moodle.com центар за помоћ';
$string['contactmoodlecomtitle'] = 'Moodle.com';
$string['contactmoodleorgemail'] = 'Ако имате проблеме са активацијом moodle.org корисничког налога, пошаљите поруку на ову електронску адресу:';
$string['contactmoodleorglogin'] = 'Пријавите се сада на овај сајт';
$string['contactmoodleorgother'] = 'За сва остала питања, молимо, употребите доњи образац за контакт.';
$string['contactmoodleorgtitle'] = 'Moodle.org';
$string['contactsecurity'] = 'Безбедносни проблеми се, такође, могу безбедно пријавити путем Moodle Trackera,  под условом да подесите одговарајући ниво безбедности.';
$string['contactsent'] = 'Ваша порука је послата електронском поштом менаџеру Moodle заједнице.';
$string['contactsupport'] = 'За подршку у коришћењу Moodle софтвера, погледајте нашу страницу за подршку на којој се налази списак бројних корисних ресурса који Вам стоје на располагању.';
$string['contactsupporttitle'] = 'Подршка';
$string['developerlist'] = 'Списак развојних програмера са правом записивања кода';
$string['developermeetings'] = 'Састанци програмера';
$string['developers'] = 'Главни развој Moodlea води основни тим програмeра окупљених око Moodle.com, којима помаже на стотине других развојних програмера широм света. Многи од ових програмера су, такође, директно одговорни за развој различитих модула и додатака.';
$string['developerstitle'] = 'Програмери';
$string['developmentdocs'] = 'Највећи део наше документације се налази у Moodle Docs - укључујући спецификације, развојне идеје, процедуре, стандарде и водиче за кориснике.';
$string['developmentdocstitle'] = 'Развојна документација';
$string['developmentintro'] = 'Наш циљ је транспарентни и отворени процес развоја који позива све кориснике да дају свој допринос. PHP програмери су, наравно, добродошли, али развоју Moodlea можете допринети и кроз дискусије, тестирање, повратне информације и писање документације.';
$string['developmenttracker'] = 'Сва питања и проблеми везани за развоја Moodlea (као што су багови, нове функције и побољшања) се бележе и њима се управља путем Moodle Trackera. На Trackeru можете да видите ко ради на ком делу кода, као што можете да дате свој дорпинос тако што ћете учествовати у дискусијама које су тамо покренуте. Уколико желите да сазнате нешто више о неком конкретном проблему/питању прво треба да претражите Tracker. Такође Вас молимо да <strong>гласате</strong> за оне проблеме за које највише желите да буду решени, пошто Ваши гласови помажу да се одреде приоритети у развоју Moodlea.';
$string['donations'] = 'Moodle је потпуно бесплатан за коришћење, без икаквих финансијских обавеза. Међутим, многи чланови заједнице корисника су донирали извесне суме нашем пројекту како би помогли плаћање програмера који раде на развоју  Moodlea.';
$string['donationsmoney'] = 'Такође, можете да дате свој допринос тако што ћете директно у Фонд уплатити готовинску новчану донацију. Сав тај новац се користи како би се жеље из плана развоја Moodlea претвориле у стварност односно нове функције које ће сви моћи да користе. За новчане донације путем кредитне картице (у већини главних валута) кликните на Paypal дугме испод /> <br /> Они који донирају више од 10 USD могу, уколико то желе, да додају своје име на ову страницу (њихово име ће ту стајати годину дана). Молимо Вас да не заборавите да, након плаћања, притиснете дугме "Настави" како бисте видели образац у којем можете да уредите како ће се приказати Ваша донација.';
$string['donationsservices'] = 'Ако имате потребу за Moodle услугама, као што су хостинг, подршка, инсталација, прилагођавање програмског кода, развој курсева или консалтинг, молимо посетите локалног овлашћеног  <a href="http://moodle.com/">Moodle партнера са moodle.com</a> (видећете њихове рекламне банере на овом сајту). Партнери уплаћују фиксни проценат своје  зараде у Moodle Trust развојни фонд, тако да су сви на добитку.';
$string['donationstitle'] = 'Донације';
$string['donationstrust'] = 'Moodle има развојни фонд којим управља Moodle Trust, који запошљава програмере за рад на Moodleu и који, такође, сноси трошкове попут оних за одржавање moodle.org.';
$string['downloadcore'] = 'Наш главни начин дистрибуције је путем ових стандардних основних пакета. Они садрже велики број модула које одржавају наши главни програмери. Пакети су погодни за инсталацију на скоро свим платформама на којима већ постоје PHP и нека од база података.';
$string['downloadcoretitle'] = 'Стандардни Moodle пакети';
$string['downloadintro'] = 'Moodle је пакет отовореног кода под <a href="http://docs.moodle.org/en/License">GPL лиценцом</a>. Све што произведемо вама је доступно за бесплатно преузимање и коришћење.';
$string['downloadlang'] = 'У текућим верзијама Moodlea, додавање подршке за нове језике је аутоматизовано из администраторског менија унутар вашем сајта. Међутим, за неке старије верзије Moodlea нови језички пакети се морају ручно преузети и инсталирати.';
$string['downloadlangtitle'] = 'Језички палети';
$string['downloadlogotitle'] = 'Moodle лого';
$string['downloadmac'] = 'Уколико већ немате инсталиран веб сервер, ови "све-у-једном" пакети ће вам олакшати инсталацију Moodlea на било ком Apple рачунару са Mac OS X оперативним системом.';
$string['downloadmactitle'] = 'Moodle за Mac OS X';
$string['downloadmodules'] = 'Претражите нашу свеобухватну базу нестандардних модула и додатака који могу бити додати вашем Moodleu, како бисте му обезбедили додатну функционалност, изван основног пакета.';
$string['downloadmodulestitle'] = 'Модули и додаци';
$string['downloadthemes'] = 'Изглед Moodle сајта се може драматично променити коришћењем различитих графичких тема. Ми одржавамо базу графичких тема које су креирали наши корисници.';
$string['downloadthemestitle'] = 'Графичке теме';
$string['downloadwin'] = 'Уколико већ немате инсталиран веб сервер, ови "све-у-једном" пакети ће Вам олакшати инсталацију Moodlea на било ком  рачунару са Microsoft Windows оперативним системом.';
$string['downloadwintitle'] = 'Moodle за Windows';
$string['erroradminonly'] = 'Овом интерфејсу могу да приступе само администратори';
$string['erroralreadyvoted'] = 'Већ сте гласали за {$a}';
$string['errormaxmessages'] = 'Опростите, али не можете послати више од 3 поруке.';
$string['errornomainnews'] = 'На овом сајту, није могуће пронаћи или креирати главни форум Вести';
$string['errorsendingmail'] = 'Догодила се грешка приликом слања поруке. Молимо, покушајте поново касније или контактирајте администратора сајта.';
$string['events'] = 'Иако смо ми специјализовани за онлајн учење, још увек је лепо срести се уживо, у реалном свету. Погледајте ове линкове за више информација о нашим конференцијама (ми их зовемо Moodle Moot) и другим догађајима.';
$string['eventstitle'] = 'Догађаји';
$string['frontpagewelcome1'] = 'Moodle је Систем за управљање курсевима (Course Management System - CMS), познат и као Систем за управљање учењем (Learning Management System - LMS) или Виртуално окружење за учење и подучавање (Virtual Learning Environment - VLE). Moodle је бесплатна веб апликација коју предавачи могу да користе за креирање ефикасних сајтова за онлајн учење.';
$string['frontpagewelcome2'] = 'Moodle.org је сајт наше заједнице на којем се Moodle развија и на којем се о њему дискутује. Употребите меније како бисте истражили сајт и придружите нам се!';
$string['frontpagewelcometitle'] = 'Добро дошли у Moodle заједницу!';
$string['generaldeveloperforum'] = 'Општи форум за развој';
$string['graphpopulation'] = 'Графикон Moodle популације';
$string['graphregistrationmap'] = 'Moodle мапа регистрованих сајтова';
$string['graphregistrationmapdesc'] = 'Топ 10 регистрованих сајтова из {$a} земаља';
$string['graphusersites'] = 'Поређење Moodle сајтова према броју корисника';
$string['heroslide_link_sites'] = 'Регистровани сајтови';
$string['jobs'] = 'Посетите нашу базу података о пословима за више информација о радним местима широм света, која су у вези са Моodleom';
$string['moodledocs'] = 'Moodle документација';
$string['mycoursesintro'] = 'Тренутно сте уписани на следеће "курсеве" на сајту ове заједнице, при чему сваки од њих садржи један или више форума.';
$string['nameabout'] = 'О нама';
$string['nameaboutmoodle'] = 'О Moodleu';
$string['namecommercial'] = 'Комерцијалне услуге';
$string['namecommunity'] = 'Заједница';
$string['namecontact'] = 'Контакт';
$string['namedevelopment'] = 'Развој';
$string['namedocumentation'] = 'Документација';
$string['namedownloads'] = 'Преузимања';
$string['nameevents'] = 'Догађаји';
$string['nameforums'] = 'Форуми';
$string['namemycourses'] = 'Моји курсеви';
$string['namenetwork'] = 'Повезани сајтови';
$string['namenews'] = 'Вести';
$string['namesecurity'] = 'Безбедносна обавештења';
$string['namesupport'] = 'Подршка';
$string['networkintro'] = 'Следећи Moodle сајтови су повезани са moodle.org коришћењем Moodle умрежавања (MNet), тако да се на њих можете пријавити директно, са овог сајта.';
$string['newregistrations'] = 'Нове регистрације';
$string['noenrolledcoursesyet'] = 'Још увек нисте уписани ни на један курс на овом сајту';
$string['permalink'] = 'Перманентни линк';
$string['popularissues'] = 'Најпопуларнији питања';
$string['recentpart'] = 'Ова страница приказује неке од људи који су данас користили moodle.org';
$string['registeredsites'] = 'Институције нису обавезне да било кога обавесте о томе да користе Moodle, зато што је  Moodle софтвер отвореног кода. Међутим, неки Moodle сајтови су изабрали да се региструју код нас и ми одржавамо списак тих сајтова.';
$string['registeredsitestitle'] = 'Регистровани сајтови';
$string['registereduserslastday'] = 'Нови корисници (у последња 24 часа)';
$string['registereduserstotal'] = 'Укупно регистрованих корисника';
$string['registrationgraphalt'] = 'Сви Moodle регистровани сајтови током времена';
$string['registrationgraphdesc'] = 'Ми спроводимо <a href="http://docs.moodle.org/en/Usage">редовну масовну проверу регистрованих сајтова</a> како би били сигурни да су они и даље активни, тако да повремено можете видети да се њихов број смањује.';
$string['registrationslast6months'] = 'Регистровани сајтови у последњих 6 месеци';
$string['registrationstotal'] = 'Све тренутне регистрације';
$string['roadmap'] = 'План развоја Moodlea';
$string['shop'] = 'Да ли тражите начин на који ћете показати да сте део наше заједнице? Посетите онлајн продавницу у којој можете купити мајице, шоље и разне друге производе.';
$string['statscountries'] = 'Земље';
$string['statscourses'] = 'Курсеви';
$string['statsenrolments'] = 'Уписи';
$string['statsposts'] = 'Постови на форуму';
$string['statsquestions'] = 'Тест питања';
$string['statsresources'] = 'Ресурси';
$string['statsteachers'] = 'Предавачи';
$string['statsusers'] = 'Корисници';
$string['supportbooks'] = 'Одржавамо списак великог броја књига о Moodleu, које можете наручити.';
$string['supportcommercial'] = '<a href="http://moodle.com/">Moodle партнери</a> представљају групу овлашћених компанија широм света који финансијски подржавају Moodle пројекат отвореног кода. Они пружају читав низ додатних комерцијалних сервиса Moodle корисницима широм света.';
$string['supportdocs1'] = 'Moodle Docs је одлично место за почетак, посебно наше странице са Често постављаним питањима (FAQ).';
$string['supportdocs2'] = 'Најбољи начин за приступ релевантној документацији јесте коришћење линка "Moodle документација за ову страницу" који се налази на дну сваке странице Вашег Moodle сајта.';
$string['supportdocsfaq'] = 'Често постављана питања (FAQ)';
$string['supportdocslang'] = 'Moodle Docs на другим језицима';
$string['supportforums'] = 'Наша заједница корисника већином комуницира путем форума унутар "курсева" на овом Moodle сајту. Морате да се "упишете" на курс како бисте могли да учествујете у дискусијама на форумима (упис је потпуно бесплатан).';
$string['supportforumsenglish'] = 'Главна подршка и дискусије о развоју између корисника и програмера се одвијају (на енглеском) овде:';
$string['supportforumsenglishname'] = 'Коришћење Moodlea';
$string['supportforumslang'] = 'Главни форум за дружење корисника Moodlea, на енглеском, се налази овде:';
$string['supportforumslangname'] = 'Moodle Lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Постоји велики број других форума на многобројним језицима:';
$string['supportforumslistname'] = 'Списак свих форума';
$string['supportintro'] = 'Нисте сами! Постоје разни начини да добијете помоћ у коришћењу Moodlea, уколико Вам је она потребна.';
$string['top10sitesbycourses'] = '10 топ сајтова по броју курсева';
$string['top10sitesbyusers'] = '10 топ сајтова по броју корисника';
