<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'plagiarism_urkund', language 'cs', version '3.9'.
 *
 * @package     plagiarism_urkund
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allowallsupportedfiles'] = 'Povolit všechny podporované typy souborů';
$string['allowallsupportedfiles_help'] = 'Toto nastavení umožňuje učiteli omezit typy souborů, které budou kontrolovány pomocí nástroje Ouriginal. Nebrání však studentům v odevzdávání souborů jiných typů.';
$string['areyousurebulk'] = 'Jste si jisti, že chcete smazat tyto soubory? (celkem {$a})';
$string['areyousurefiltereddelete'] = 'Jste si jisti, že chcete smazat všechny soubory odpovídající aktuálnímu filtru? (celkem {$a})';
$string['areyousurefilteredresubmit'] = 'Jste si jisti, že chcete opětovně odeslat k analýze všechny soubory odpovídající aktuálnímu filtru? (celkem {$a})';
$string['assessmentresubmitted'] = 'Text opětovně odeslán ke kontrole';
$string['assignforcedisclosureagreement'] = 'Vnutit souhlas s odesláním do nástroje Ouriginal';
$string['assignforcedisclosureagreement_desc'] = 'Pokud je zapnuto, uživatelé budou nuceni souhlasit před odevzdáním svých textů s tím, že jejich texty budou odeslány do nástroje Ouriginal ke kontrole.';
$string['assignforcesubmissionstatement'] = 'Vnutit souhlas s prohlášením před odesláním textu';
$string['assignforcesubmissionstatement_desc'] = 'Pokud je tato možnost povolena, je ve všech úkolech, v nichž je povolen nástroj Ouriginal, vynuceno potvrzení prohlášení o odevzdání úkolu.<br/>
<strong>POZNÁMKA: zaškrtnutím tohoto políčka se vyhledají všechny existující úkoly na vašich stránkách s povoleným nástrojem Ouriginal a zapne se v nich prohlášení o odevzdání úkolu.</strong>';
$string['assignpreventexistingenable'] = 'Zabránit povolení funkce pokud již existují úkoly';
$string['assignpreventexistingenable_desc'] = 'Zabránit uživatelům bez administrátorských pravomocí povolit nástroj Ouriginal pokud modul již obsahuje odevzdané úkoly.';
$string['assignsettings'] = 'Přiřadit nastavení';
$string['attempts'] = 'Vykonaných pokusů';
$string['cannotsubmitonbehalf'] = 'Studenti v tomto úkolu musí před odesláním souhlasit s Prohlášením o odeslání do nástroje Ouriginal. Toto za ně učitelé nemohou udělat jejich jménem.';
$string['cannotupgradeunprocesseddata'] = '<h1>Na tuto verzi zásuvného modulu nelze přejít kvůli existujícím nezpracovaným datům, vraťte se prosím ke starší verzi tohoto zásuvného modulu a vymažte staré události.</h1>
<p>Tato verze zásuvného modulu se spoléhá na nové rozhraní API pro události v systému Moodle, ale vaše instalace obsahuje nezpracované události související se starým rozhraním API.</p>
<p>Měli byste se vrátit ke starší verzi zásuvného modulu Ouriginal, přepnout web do režimu údržby, spustit cron a ujistit se, že jsou všechny staré události vymazány. Poté zkuste znovu přejít na tuto verzi zásuvného modulu Ouriginal.</p>
<p>Více informací najdete na webu <a href="https://docs.moodle.org/en/Plagiarism_Prevention_Ouriginal_Settings#Installation_failed_due_to_unprocessed_data" target="_blank">Ouriginal Installation failed due to unprocessed data</a></p>';
$string['charcount'] = 'Minimální počet znaků';
$string['charcount_help'] = 'Nastavuje minimální počet znaků, který musí mít online text (příspěvek ve fóru nebo úkol typu online text), aby mohl být odeslán na kontrolu nástrojem Ouriginal.';
$string['confirmresetall'] = 'Toto resetuje všechny soubopry ve stavu: {$a}';
$string['courseshortname'] = 'Krátký název kurzu';
$string['cronwarningscores'] = 'Úloha Získat skóre podobnosti (\\plagiarism_urkund\\task\\get_scores) nebyla během posledních 30 minut spuštěna. Aby nástroj Ouriginal fungoval správně, musí být nakonfigurován cron.';
$string['cronwarningsendfiles'] = 'Úloha Odeslat soubory do fronty (\\plagiarism_urkund\\task\\send_files) nebyla během posledních 30 minut spuštěna. Aby nástroj Ouriginal fungoval správně, musí být nakonfigurován cron.';
$string['debugfilter'] = 'Filtrovat soubory podle';
$string['defaultsdesc'] = 'Následující nastavení budou použita jako výchozí při povolení nástroje Ouriginal v rámci aktivity.';
$string['defaultupdated'] = 'Výchozí hodnoty aktualizovány';
$string['deleteallfiltered'] = 'Vymazat všechny soubory, které vyhovují aktuálnímu filtru';
$string['deletedwarning'] = 'Tento soubor nelze najít. Je možné, že byl smazán uživatelem.';
$string['deleteselectedfiles'] = 'Smazat vybrané';
$string['errorcode'] = 'Chybový kód';
$string['errorcode_101'] = 'Chyba: Dosažen limit pro dokumenty';
$string['errorcode_3'] = 'Chyba: Dokument je příliš krátký';
$string['errorcode_4'] = 'Chyba: Překročen deadline';
$string['errorcode_403'] = 'Prop váš účet příjemce nebylo možné vytvořit adresu. Zadejte ji prosím ručně.';
$string['errorcode_409'] = 'Vaše adresa příjemce byla smazána a musí být obnovena. Obraťte se na Ouriginal, aby vám byl účet obnoven';
$string['errorcode_5000'] = 'Chyba: Zprávu o podobnosti nebylo možné vytvořit';
$string['errorcode_7001'] = 'Chyba: Indexování se nazdařilo';
$string['errorcode_unknown'] = 'Chyba: {$a}';
$string['errorcreate'] = 'Adresu pro analýzu musíte zadat ručně.';
$string['explainerrors'] = 'Na této stránce jsou uvedeny všechny soubory, při jejichž zpracování došlo k chybám.<br/>
Pokud budou soubory na této stránce smazány, nebude možné je znovu odeslat a chyby se již nebudou zobrazovat učitelům ani studentům.';
$string['file'] = 'Soubor';
$string['filedeleted'] = 'Soubor smazán z fronty';
$string['filereset'] = 'Soubor byl resetován kvůli znovuodeslání do nástroje Ouriginal';
$string['fileresubmitted'] = 'Soubor je ve frontě pro opětovné odeslání';
$string['filesresubmitted'] = '{$a} souborů opětovně odesláno';
$string['filter30'] = 'Vyřadit všechny starší 30 dní';
$string['filter7'] = 'Vyřadit všechny starší 7 dní';
$string['filter90'] = 'Vyřadit všechny starší 90 dní';
$string['getallscores'] = 'Získat všechna skóre podobnosti';
$string['getscore'] = 'Získat skóre podobnosti';
$string['getscores'] = 'Získat skóre podobnosti';
$string['heldevents'] = 'Uskutečněné události';
$string['heldeventsdescription'] = 'Jedná se o události, které nebyly dokončeny na první pokus a byly zařazeny do fronty k opětovnému odeslání. Tyto události brání dalším událostem v dokončení a mohou vyžadovat další prošetření. Některé z těchto událostí nemusí být pro Ouriginal relevantní.';
$string['iagree'] = 'Souhlasím';
$string['iagreetostatement'] = 'Souhlasím s tím, že mnou odevzdané úkoly budou zaslány do nástroje Ouriginal ke zpracování.';
$string['id'] = 'ID';
$string['identifier'] = 'Identifikátor';
$string['idisagree'] = 'Zrušit';
$string['module'] = 'Modul';
$string['modulenotfound'] = 'Nebylo možné nalézt modul {$a->module} s ID {$a->modid}.';
$string['name'] = 'Jméno';
$string['nofilter'] = 'Bez filtru';
$string['noreceiver'] = 'Nebyla zadána adresa příjemce';
$string['optout'] = 'Vyřadit z databáze zdrojů';
$string['pending'] = 'Soubor čeká na odeslání do nástroje Ouriginal';
$string['pluginname'] = 'Antiplagiátorský nástroj Ouriginal';
$string['previouslysubmitted'] = 'Dříve odesláno jako';
$string['privacy:metadata:core_files'] = 'Soubory a texty přiřazené k modulům aktivit, v nichž je nástroj Ouriginal povolen.';
$string['privacy:metadata:plagiarism_urkund_client'] = 'Uživatelské informace zaslané na externí Ouriginal API';
$string['privacy:metadata:plagiarism_urkund_client:email'] = 'E-mail uživatele';
$string['privacy:metadata:plagiarism_urkund_client:file'] = 'Fyzická kopie textu nebo obsahu souboru zaslaných do nástroje Ouriginal';
$string['privacy:metadata:plagiarism_urkund_client:filename'] = 'Název odeslaného souboru.';
$string['privacy:metadata:plagiarism_urkund_files'] = 'Uchovává informace o odeslaných souborech.';
$string['privacy:metadata:plagiarism_urkund_files:lastmodified'] = 'Čas, kdy byl záznam naposledy upraven';
$string['privacy:metadata:plagiarism_urkund_files:similarityscore'] = 'Skóre podobnosti získané z nástroje Ouriginal';
$string['privacy:metadata:plagiarism_urkund_files:userid'] = 'Moodle userid';
$string['processing'] = 'Tento soubor byl odeslán ke kontrole do nástroje Ouriginal. Nyní se vyčkává, než bude analýza k dispozici.';
$string['receivernotvalid'] = 'Toto není platná adresa příjemce.';
$string['recordsdeleted'] = '{$a} chyb bylo smazáno';
$string['regenerationrequested'] = 'Všechny zprávy byly označeny k obnovení. Může trvat nějakou dobu, než budou aktualizované zprávy k dispozici.';
$string['report'] = 'zpráva o podobnosti';
$string['restrictcontent'] = 'Odesílat soubory i online text';
$string['restrictcontent_help'] = 'Nástroj Ouriginal může kontrolovat vložené soubory ale také úkoly typu online text či příspěvky ve fórech. Zde můžete vybrat, co má být odesíláno ke kontrole.';
$string['restrictcontentfiles'] = 'Odesílat pouze přiložené soubory';
$string['restrictcontentno'] = 'Odesílat vše';
$string['restrictcontenttext'] = 'Odesílat pouze online text';
$string['restrictfiles'] = 'Typy souborů k odeslání';
$string['resubmit'] = 'Odeslat znovu';
$string['resubmitall'] = 'Odeslat znovu vše ve stavu: {$a}';
$string['resubmitallfiltered'] = 'Znovu odeslat všechny soubory vyhovující aktuálnímu filtru';
$string['resubmitclose'] = 'Znovu odeslat po datu ukončení';
$string['resubmitdue'] = 'Znovu odeslat po termínu pro odevzdání';
$string['resubmittourkund'] = 'Znovu vytvořit všechny zprávy o podobnosti';
$string['savedconfigfailed'] = 'Byla zadána nesprávná kombinace uživatelského jména a hesla nebo adresa Ouriginal API. Nástroj Ouriginal byl vypnut. Zkuste to prosím znovu.';
$string['savedconfigsuccess'] = 'Nastavení uloženo';
$string['scoreavailable'] = 'Tento soubor byl zpracován nástrojem Ouriginal a nyní je k dispozici zpráva o podobnosti.';
$string['scorenotavailableyet'] = 'Tento soubor zatím nebyl zpracován nástrojem Ouriginal.';
$string['sendfiles'] = 'Odeslat soubory do fronty';
$string['showall'] = 'Ukázat všechny chyby';
$string['showwhencutoff'] = 'Po termínu ukončení';
$string['showwhendue'] = 'Po termínu pro odevzdání';
$string['similarity'] = 'Ouriginal';
$string['status'] = 'Stav';
$string['status_202'] = 'Přijato, čeká se na zprávu';
$string['status_404'] = 'Adresa pro analýzu neexistuje';
$string['status_413'] = 'Soubor je příliš veliký';
$string['status_415'] = 'Formát souboru není podporován';
$string['status_444'] = 'Nebyla přidána adresa pro analýzu';
$string['status_pending'] = 'Čeká na odeslání';
$string['storedocuments'] = 'Přidat texty do databáze nástroje Ouriginal';
$string['storedocuments_help'] = 'Pokud je tato možnost povolena, odevzdané úkoly budou přidány do databáze nástroje Ouriginal pro budoucí porovnání s dalšími odevzdanými úkoly. Pokud je tato možnost zakázána, bude dokument po ukončení';
$string['studentdisclosure'] = 'Upozornění pro studenty';
$string['studentdisclosure_help'] = 'Tento text bude zobrazen všem studentům na stránce pro nahrání souboru.';
$string['studentdisclosuredefault'] = 'Všechny vložené soubory budou zkontrolovány antiplagiátorským nástrojem Ouriginal.

Pokud si nepřejete, aby byl váš dokument dále používán jako jeden ze zdrojů při budoucích antiplagiátorských analýzách mimo tento systém, použijte odkaz pro vyřazení dokumentu z databáze zdrojů, který se objeví po dokončení analýzy.';
$string['studentemailcontent'] = 'Soubor, který jste odevzdali v rámci úkolu "{$a->modulename}" v kurzu "{$a->coursename}" byl nyní zpracován nástrojem Ouriginal, viz: {$a->modulelink}.

Pokud si nepřejete, aby byl váš dokument dále používán jako jeden ze zdrojů při budoucích antiplagiátorských analýzách mimo tento systém, použijte následující odkaz pro vyřazení dokumentu z databáze zdrojů: {$a->optoutlink}.';
$string['studentemailcontentnoopt'] = 'Soubor, který jste odevzdali v rámci úkolu "{$a->modulename}" v kurzu "{$a->coursename}" byl nyní zpracován nástrojem Ouriginal, viz: {$a->modulelink}.';
$string['studentemailsubject'] = 'Soubor zpracován nástrojem Ouriginal';
$string['submissionagreement'] = 'Souhlas s odesláním';
$string['submitondraft'] = 'Odeslat soubor jakmile je poprvé nahrán';
$string['submitonfinal'] = 'Odeslat soubor jakmile jej student odešle k hodnocení';
$string['timesubmitted'] = 'Čas odeslání';
$string['toolarge'] = 'Soubor je příliš velký pro zpracování nástrojem Ouriginal.';
$string['unknownwarning'] = 'Nastala chyba při pokusu odeslat tento soubor ke kontrole antiplagiátorským nástrojem Ouriginal.';
$string['unknownwarninggetscore'] = 'Při pokusu o získání skóre podobnosti z nástroje Ouriginal došlo k chybě';
$string['unsupportedfiletype'] = 'Tento typ souboru není podporován nástrojem Ouriginal.';
$string['updateallowedfiletypes'] = 'Aktualizovat povolené typy souborů a odstranit původní záznamy nástroje Ouriginal spojené se smazanými aktivitami.';
$string['urkund'] = 'Antiplagiátorský nástroj Ouriginal';
$string['urkund:advancedsettings'] = 'Polvolit učiteli vidět pokročilá nastavení nástroje Ouriginal';
$string['urkund:enable'] = 'Povolit učiteli zapnout/vypnout nástroj Ouriginal v rámci aktivity';
$string['urkund:resetfile'] = 'Umožnit učiteli odeslat soubor k opětovnému zpracování';
$string['urkund:resubmitallfiles'] = 'Povolit učiteli odeslat VŠECHNY soubory k opětovnému zpracování';
$string['urkund:resubmitonclose'] = 'Umožnit učiteli znovu odeslat soubory v termínu pro odevzdání/ukončení úkolu do nástroje Ouriginal.';
$string['urkund:viewreport'] = 'Umožnit učiteli zobrazení zprávy o podobnosti z nástroje Ouriginal';
$string['urkund_advanceditems'] = 'Sada nastavení považovaných za pokročilá';
$string['urkund_advanceditems_help'] = 'Seznam nastavení, která jsou zde označena coby pokročilá, se v nastavení modulu zobrazí jako mezi pokročilými nastaveními. Taková nastavení budou také skryta učitelům, pokud nemají povolené nastavení "urkund:advancedsettings".';
$string['urkund_api'] = 'Ouriginal adresa pro integraci';
$string['urkund_api_help'] = 'Adresa Ouriginal API';
$string['urkund_draft_submit'] = 'Kdy má být soubor odeslán do nástroje Ouriginal';
$string['urkund_enableoptout'] = 'Ukázat odkaz pro vyřazení dokumentu z databáze zdrojů';
$string['urkund_enableoptoutdesc'] = 'Zakázáním této funkce se zruší možnost studentů zobrazit nebo skrýt obsah jejich textů (v závislosti na výchozím nastavení) v případě, že by byla nalezena shoda v úkolech studentů jiných klientů Ouriginalu ("opt-in" a "opt-out"). Deaktivací této funkce potvrzujete, že přebíráte odpovědnost za správu autorských práv k pracím svých studentů a že tento krok není v rozporu se zákony platnými ve vaší zemi.';
$string['urkund_enableplugin'] = 'Povolit Ouriginal pro {$a}';
$string['urkund_hidefilename'] = 'Skrýt název souboru odevzdaného úkolu';
$string['urkund_hidefilenamedesc'] = 'Povolením této možnosti se do nástroje Ouriginal odesílají soubory s generickým název souboru. Studenti tak neuvidí název souboru žádného zdroje, který odpovídá existujícím odevzdaným úkolům.';
$string['urkund_lang'] = 'Jazyk';
$string['urkund_lang_help'] = 'Kód jazyka poskytnutý Ouriginalem';
$string['urkund_password'] = 'Heslo';
$string['urkund_password_help'] = 'Heslo pro přístup k Ouriginal API';
$string['urkund_receiver'] = 'Adresa příjemce';
$string['urkund_receiver_help'] = 'Toto je unikátní adresa poskytnutá službou Ouriginal ke kontrole odevzdaných prací.';
$string['urkund_resubmit_on_close'] = 'Znovu odeslat po uzavření';
$string['urkund_resubmit_on_close_desc'] = 'Znovu odeslat odevzdané úkoly po ukončení období pro odevzdávání.';
$string['urkund_resubmit_on_close_help'] = 'Povolení této možnosti způsobí, že po skončení období pro odevzdání úkolu budou do nástroje Ouriginal opětovně odeslány odevzdané úkoly.';
$string['urkund_show_student_report'] = 'Ukázat studentům zprávu o podobnosti';
$string['urkund_show_student_report_help'] = 'Zpráva o podobnosti uvádí, které části odevzdaného úkolu byly plagiáty, a místo, kde se Ouriginal s tímto obsahem poprvé setkal';
$string['urkund_show_student_score'] = 'Ukázat studentům skóre podobnosti';
$string['urkund_show_student_score_help'] = 'Skóre podobnosti odpovídá procentu z textu (v rámci odevzdaného úkolu), který byl identifikován jako shodný s jinými texty v databázi zdrojů.';
$string['urkund_studentemail'] = 'Poslat studentovi e-mail';
$string['urkund_studentemail_help'] = 'Toto nastavení umožňuje poslat e-mail studentovi, jakmile je soubor zpracován a je k dispozici finální zpráva o podobnosti. E-mail zároveň obsahuje odkaz pro vyřazení dokumentu z databáze zdrojů.';
$string['urkund_unitid'] = 'Unit ID';
$string['urkund_unitid_help'] = 'Nástroj Ouriginal může automaticky vytvářet adresy příjemců pro každého uživatele. Pokud chcete používat stejnou výchozí adresu pro všechna odevzdané úkoly, ponechte toto nastavení prázdné. Pokud chcete tuto funkci využívat, kontaktujte Ouriginal a vyžádejte si Unit ID.
Pozor! Nastavením této hodnoty také zrušíte výchozí adresy příjemců na úrovni stránek, jelikož tyto adresy se nadále nebudou využívat.';
$string['urkund_username'] = 'Uživatelské jméno';
$string['urkund_username_help'] = 'Uživatelské jméno pro přístup k Ouriginal API';
$string['urkund_userpref'] = 'Použít posledního nastaveného příjemce';
$string['urkund_userprefdesc'] = 'Pokud je tato možnost povolena, bude poslední adresa příjemce zadaná uživatelem uložena coby výchozí adresa, která se použije při vytváření nových úkolů. Pokud tato možnost nebude povolena, bude vždy použita výchozí adresa příjemce nastavená na úrovni stránek.';
$string['urkunddebug'] = 'Ladění';
$string['urkunddefaults'] = 'Výchozí nastavení nástroje Ouriginalu';
$string['urkunddefaults_assign'] = 'Výchozí nastavení úkolu';
$string['urkunddefaults_forum'] = 'Výchozí nastavení fóra';
$string['urkunddefaults_hsuforum'] = 'Výchozí nastavení pro hsuforum';
$string['urkunddefaults_quiz'] = 'Výchozí nastavení testu';
$string['urkunddefaults_workshop'] = 'Výchozí nastavení workshopu';
$string['urkundexplain'] = 'Pro více informací o tomto pluginu viz: <a href="https://ouriginal.com" target="_blank">https://ouriginal.com</a>';
$string['urkundfiles'] = 'Soubory Ouriginal';
$string['useurkund'] = 'Povolit nástroj Ouriginal';
$string['waitingevents'] = 'Je celkem {$a->countallevents} událostí čekajících na cron a {$a->countheld} událostí čeká na opětovné odeslání';
