<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_tenant', language 'es', version '3.9'.
 *
 * @package     tool_tenant
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activetenants'] = 'Micrositios activos';
$string['addtenant'] = 'Nuevo micrositio';
$string['adduser'] = 'Nuevo usuario';
$string['admin'] = 'Administrador';
$string['administrators'] = 'Administradores';
$string['advanced'] = 'Avanzado';
$string['allocateusers'] = 'Asignar usuarios';
$string['archivedtenants'] = 'Micrositios archivados';
$string['archivetenant'] = 'Archivar micrositio';
$string['basicinformation'] = 'Información básica';
$string['cachedef_mytenant'] = 'Información sobre el micrositio actual';
$string['cachedef_tenants'] = 'Listado de micrositios';
$string['cannotarchivetenant'] = 'No se puede archivar el micrositio por defecto.';
$string['category'] = 'Categoría de cursos';
$string['category_help'] = 'A los administradores de micrositios se les asignará automáticamente el rol de "Administrador de micrositio en la categoría de cursos" en esta categoría de cursos. Podrán crear cursos, asignar roles, etc.
A todos los usuarios de los respectivos micrositios se les asignará automáticamente el rol de \'Usuario de micrositio\' en esta categoría.<br><br>Solo las categorías en el nivel superior se pueden seleccionar como categorías de micrositios.<br>
Si se selecciona \'Nueva categoría\', se creará una categoría con el mismo nombre que el nombre del micrositio.';
$string['categorynameexist'] = 'La categoría con el nombre \'{$a}\' ya existe en el nivel superior. Por favor, seleccionar esta categoría o elegir otro nombre';
$string['categorytaken'] = 'Esta categoría es asignada a otro micrositio.';
$string['chooseexistingcategory'] = 'Elegir una categoría existente';
$string['colours'] = 'Colores';
$string['confirmallocateusers'] = '¿Estás seguro de asignar los usuarios seleccionados al micrositio seleccionado?';
$string['confirmarchivetenant'] = '¿Estás seguro de archivar el micrositio \'{$a}\'? Todos los usuarios asignados a este micrositio se moverán al micrositio por defecto.';
$string['confirmdeletetenant'] = '¿Estás seguro de querer borrar el micrositio \'{$a}\'? Esta acción no se puede deshacer.';
$string['confirmdeleteuser'] = '¿Estás seguro de querer borrar este usuario? Esta acción no se puede deshacer.';
$string['confirmdeleteusers'] = '¿Estás seguro de querer borrar los usuarios seleccionados? Esta acción no se puede deshacer.';
$string['confirmrestoretenant'] = '¿Estás seguro de restaurar el micrositio \'{$a}\'?';
$string['confirmsuspenduser'] = '¿Estás seguro de suspender este usuario?';
$string['confirmsuspendusers'] = '¿Estás seguro de suspender los usuarios seleccionados?';
$string['confirmunsuspenduser'] = '¿Estás seguro de querer reactivar este usuario?';
$string['confirmunsuspendusers'] = '¿Estás seguro de querer reactivar este listado de usuarios?';
$string['createnewcategory'] = 'Crear una nueva categoría';
$string['customcss'] = 'SCSS personalizado';
$string['defaultname'] = 'Micrositio por defecto';
$string['defaulttenantmobileconfig'] = 'Este es el micrositio por defecto, por lo tanto, la aplicación móvil siempre usará su configuración.';
$string['deletetenant'] = 'Eliminar micrositio';
$string['deleteuser'] = 'Eliminar usuario';
$string['deleteusers'] = 'Eliminar usuarios';
$string['editdetails'] = 'Editar detalles';
$string['editdetailsinsharedspace'] = 'Editar en el Espacio compartido';
$string['edittenant'] = 'Editar micrositio \'{$a}\'';
$string['edittenantname'] = 'Editar nombre';
$string['edituser'] = 'Editar cuenta de usuario';
$string['edituserwithname'] = 'Editar usuario \'{$a}\'';
$string['enablesharedspace'] = 'Habilitar Espacio compartido';
$string['enrolinseparategroups'] = 'Este curso puede ser compartido con otros micrositios, pero los usuarios de distintos micrositios se asignarán a grupos separados';
$string['enrolwithoutgroups'] = 'Usuarios de este micrositio serán matriculados en este curso y podrán verse entre sí debido a que este curso no está configurado para grupos separados';
$string['errorcannotallocate'] = 'No se puede asignar el usuario al micrositio';
$string['errorinvalidtenant'] = 'Micrositio inválido \'{$a}\'';
$string['eventtenantcreated'] = 'Micrositio creado';
$string['eventtenantdeleted'] = 'Micrositio eliminado';
$string['eventtenantupdated'] = 'Micrositio actualizado';
$string['eventtenantusercreated'] = 'Usuario asignado a un micrositio';
$string['eventtenantuserupdated'] = 'Se modificó la asignación del usuario a un micrositio';
$string['favicon'] = 'Favicon';
$string['footertext'] = 'Texto de pie de página';
$string['gotosharedspace'] = 'Ir al Espacio compartido';
$string['headerlogo'] = 'Logo de la cabecera';
$string['idnumber'] = 'Número de ID';
$string['idnumber_help'] = 'El número de ID de un micrositio sólo se usa cuando se compara con sistemas externos o en la herramienta Subir usuarios. No se muestra en ninguna parte del sitio. Si el micrositio tiene un código oficial, se puede ingresar, de lo contrario, el campo se puede dejar en blanco.';
$string['images'] = 'Imágenes';
$string['invalidcolour'] = 'Este código de color no tiene el formato correcto. Utilice el formato #000 o #000000.';
$string['loginbackground'] = 'Imagen de fono para el inicio de sesión';
$string['loginlogo'] = 'Logo para el inicio de sesión';
$string['loginurl'] = 'URL para iniciar sesión';
$string['loginurl_help'] = 'Las URLs seleccionadas se mostrarán a los administradores gestores de entorno y pueden pasarlas a sus usuarios para tener temas de su entorno desde el primer momento. Si no se especifica "ID number" el enlace del número de ID no estará disponible incluso si se selecciona. Tenga en cuenta que durante la creación del entorno el ID no está disponible.';
$string['management'] = 'Administrar';
$string['managetenants'] = 'Administrar micrositios';
$string['migrationcoursecategories'] = 'Categorías de cursos, con cohortes y estructuras de curso';
$string['migrationcreate'] = 'Crear un nuevo micrositio';
$string['migrationdestinationsummary'] = 'Destino: {$a}';
$string['migrationexporterdescription'] = 'Micrositios junto con todas las entidades contenidas por ellos';
$string['migrationlogerror'] = 'No se pudo importar el micrositio \'{$a}\'';
$string['migrationlogsuccess'] = 'Micrositio importado \'<a href="{$a->url}">{$a->name}</a>\'';
$string['migrationmappingerror'] = 'Algunos micrositios no existen';
$string['migrationmappingerrorlog'] = 'El micrositio {$a} no fue encontrado';
$string['migrationmerge'] = 'Fusionar con un micrositio existente...';
$string['migrationmerge_help'] = 'Combinar la información con las entidades seleccionadas en un gestor de entorno existente. Tenga en cuenta que los detalles y la apariencia (en caso de seleccionarse) se sobreescribirán.';
$string['migrationmergeselecttenant'] = 'Seleccionar micrositio para fusionar';
$string['migrationmergetoomany'] = 'Sólo se puede seleccionar un objeto para fusionar con un micrositio existente';
$string['migrationselectalltenants'] = 'Seleccionar todos los micrositios';
$string['migrationselectexcludingarchived'] = 'Seleccionar todos los micrositios (excluyendo los archivados)';
$string['migrationselectincludingarchived'] = 'Seleccionar todos los micrositios (incluyendo los archivados)';
$string['migrationselectmanually'] = 'Seleccionar los micrositios manualmente...';
$string['movebetweentenants'] = 'Mover entre micrositios';
$string['movetenant'] = 'Mover micrositio \'{$a}\'';
$string['name'] = 'Nombre del micrositio';
$string['newname'] = 'Nuevo micrositio \'{$a}\'';
$string['newnamefor'] = 'Nuevo nombre para \'{$a}\'';
$string['nocategory'] = 'Sin categoría';
$string['nomanualassignment'] = 'Este rol no puede ser asignado manualmente en ningún contexto';
$string['notnow'] = 'No ahora';
$string['notspecified'] = 'Sin especificar';
$string['organisationadmintab'] = 'Estructura de la organización';
$string['pluginname'] = 'Multi-micrositios';
$string['primary'] = 'Links';
$string['primary_help'] = 'El color utilizado para links y elementos interactivos.';
$string['privacy:metadata:user'] = 'Asignación de usuarios a micrositios';
$string['privacy:metadata:user:component'] = 'Componente responsable de la matriculación';
$string['privacy:metadata:user:id'] = 'ID';
$string['privacy:metadata:user:reason'] = 'Motivo de la matriculación';
$string['privacy:metadata:user:tenantid'] = 'MIcrositio';
$string['privacy:metadata:user:timecreated'] = 'Hora de asignación';
$string['privacy:metadata:user:timemodified'] = 'Hora de modificación';
$string['privacy:metadata:user:userid'] = 'Usuario';
$string['privacy:metadata:user:usermodified'] = 'Usuarios que modificaron el registro';
$string['reg_wptenants'] = 'Cantidad de micrositios ({$a})';
$string['resetappearance'] = 'Reiniciar apariencia';
$string['resettenantappearance'] = 'Reiniciar la apariencia del micrositio';
$string['resettenantappearancecolours'] = 'Reiniciar todos los colores personalizados';
$string['resettenantappearancecss'] = 'Eliminar SCSS personalizado';
$string['resettenantappearancedesc'] = 'Haciendo clic en este botón, podrás seleccionar qué elementos (imágenes, colores, etc.) se restaurarán a los estándar de accesibilidad.';
$string['resettenantappearancefooter'] = 'Eliminar el texto del pie de página';
$string['resettenantappearanceformend'] = 'Esta acción no se puede deshacer';
$string['resettenantappearanceformintro'] = 'Reiniciar la configuración de este micrositio a su configuración de accesibilidad por defecto.<br> Esta acción implicará:';
$string['resettenantappearanceimages'] = 'Eliminar todas las imágenes subidas (logo, imagen de fondo)';
$string['restoretenant'] = 'Restaurar micrositio';
$string['selecttenant'] = 'Seleccionar micrositio';
$string['selectuser'] = 'Seleccionar usuario \'{$a}\'';
$string['sharedspace'] = 'Espacio compartido';
$string['sharedspaceconfirmationtext'] = 'El Espacio compartido es un lugar para compartir entidades y contenidos entre todos los micrositios. Todo lo que crees en este espacio estará disponible instantáneamente para los usuarios de cualquier micrositio que tengan los permisos correctos. <br/> Una vez que el Espacio compartido se activa, no puede desactivarse.<br/> ¿Quisieras habilitar el Espacio compartido?';
$string['sharedspaceenabledmessage'] = 'El espacio compartido se habilitó con éxito. Usar el selector de micrositio que se encuentra en la barra de navegación para acceder a él.';
$string['sitename'] = 'Nombre del sitio';
$string['siteshortname'] = 'Nombre corto del sitio';
$string['suspenduser'] = 'Usuario suspendido';
$string['suspendusers'] = 'Usuarios suspendidos';
$string['switchedto'] = 'Has cambiado a \'{$a}\'';
$string['switchtenant'] = 'Cambiar de micrositio';
$string['tenant'] = 'Micrositio';
$string['tenant:allocate'] = 'Asignar usuarios a todos los micrositios';
$string['tenant:browseusers'] = 'Explorar usuarios en el micrositio actual';
$string['tenant:manage'] = 'Administrar la adición y edición de micrositios';
$string['tenant:managetheme'] = 'Administrar la configuración del tema para el micrositio actual';
$string['tenant:manageusers'] = 'Agregar y editar usuarios del micrositio actual';
$string['tenantadmin'] = 'Administrador de micrositio';
$string['tenantadmincapabilitieslimit'] = 'Los permisos que no son compatibles con Multiusuario no se enumeran aquí. <a href="{$a}">Más información</a>';
$string['tenantadmindescription'] = 'El rol de administrador de la gestión de entorno del lugar de trabajo. Se asigna automáticamente a los administradores gesstores del contexto del sistema.';
$string['tenantadministration'] = 'Administración del micrositio';
$string['tenantadministrator'] = 'Este usuario es administrador de micrositio';
$string['tenantcategorycapabilitieslimit'] = 'Aquí sólo se enumeran los permisos que se pueden establecer en el contexto de la categoría de cursos.';
$string['tenantdetails'] = 'Detalles';
$string['tenantlimit'] = 'Límite de micrositios';
$string['tenantlimit_desc'] = 'Número máximo de micrositios permitidos en el sistema, se contabilizan los activos y los archivados.';
$string['tenantlimitenabled'] = 'Habilitar el límite de micrositios';
$string['tenantlimitenabled_desc'] = 'Si se habilita es posible limitar el número de micrositios en este sitio.';
$string['tenantlimitreached'] = 'Se alcanzó el límite de micrositios.';
$string['tenantlimitreached1'] = 'La característica de multisitio no está habilitada en este sitio';
$string['tenantlimitreachedmult'] = 'Solo pueden crear {$a} micrositios en este sitio. Tener en cuenta que los micrositios archivados también se contabilizan.';
$string['tenantmanager'] = 'Administrador de micrositio en la categoría de cursos';
$string['tenantmanagerdescription'] = 'El rol de administrador gestor de entorno segundo del lugar de trabajo. Asignado automáticamente a los administradores gestores en el contexto de su categoría de curso.';
$string['tenantnotfound'] = 'Micrositio no encontrado';
$string['tenants'] = 'Micrositios';
$string['tenantuser'] = 'Usuario de micrositio';
$string['tenantuserdescription'] = 'El rol de usuario del micrositio. Asignado automáticamente a todos los usuarios de micrositio en el contexto de su categoría de curso.';
$string['themesettingssaved'] = 'Los ajustes del tema fueron guardados. Puede tomar varios minutos hasta que los cambios sean visibles en el sitio.';
$string['toomanytenantstoshow'] = 'Demasiados micrositios para mostrar';
$string['unsuspenduser'] = 'Reactivar usuario';
$string['unsuspendusers'] = 'Usuarios reactivados';
$string['userscount'] = 'Usuarios';
$string['usersuspendedsuccess'] = 'Usuario suspendido satisfactoriamente';
$string['userunsuspendedsuccess'] = 'Usuario reactivado satisfactoriamente';
$string['viewusers'] = 'Administrar micrositio \'{$a}\'';
