<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'es', version '3.9'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Todos los descendientes están completados';
$string['competencies'] = 'Competencias';
$string['competenciesarenotenabled'] = 'Las competencias no están activadas';
$string['competenciessettings'] = 'Configuración de las competencias';
$string['completeplanstask'] = 'Completar los planes de aprendizaje que están finalizados';
$string['coursecompetencyoutcome_complete'] = 'Completar la competencia';
$string['coursecompetencyoutcome_evidence'] = 'Adjuntar evidencia';
$string['coursecompetencyoutcome_none'] = 'No hacer nada';
$string['coursecompetencyoutcome_recommend'] = 'Enviar para revisión';
$string['coursemodulecompetencyoutcome_complete'] = 'Completar la competencia';
$string['coursemodulecompetencyoutcome_evidence'] = 'Adjuntar evidencia';
$string['coursemodulecompetencyoutcome_none'] = 'No hacer nada';
$string['coursemodulecompetencyoutcome_recommend'] = 'Enviar para revisión';
$string['deletecompetencyratings'] = 'Eliminar la valoración de la competencia';
$string['duplicateditemname'] = '{$a} (copiar)';
$string['enablecompetencies'] = 'Habilitar las competencias';
$string['enablecompetencies_desc'] = 'Las competencias permiten a los alumnos ser evaluados de acuerdo a sus planes de aprendizaje';
$string['errorcannotchangeapastduedate'] = 'La fecha de finalización ha vencido. No puede ser cambiada';
$string['errorcannotsetduedateinthepast'] = 'La fecha de finalización no puede ser anterior.';
$string['errorcannotsetduedatetoosoon'] = 'La fecha de finalizacion es demasiado pronto.';
$string['errorcompetencyrule'] = 'La regla de la competencia del curso \'{$a}\' es desconocida';
$string['errorcoursecompetencyrule'] = 'La regla de la competencia del curso \'{$a}\' es desconocida';
$string['errorinvalidcourse'] = 'Curso no válido.';
$string['errornocompetency'] = 'La competencia {$a} no existe';
$string['errorplanstatus'] = 'El estado de plan de aprendizaje \'{$a}\' es desconocido';
$string['errorscalealreadyused'] = 'La escala no se puede modificar porque ya está en uso.';
$string['errorscaleconfiguration'] = 'La escala precisa ser configurada seleccionando los apartados de valor por defecto y competente';
$string['errorusercomptencystatus'] = 'El estado de la competencia del usuario \'{$a}\' es desconocido';
$string['eventcompetencycreated'] = 'Competencia creada.';
$string['eventcompetencydeleted'] = 'Competencia eliminada.';
$string['eventcompetencyframeworkcreated'] = 'Marco de competencia creado.';
$string['eventcompetencyframeworkdeleted'] = 'Marco de competencia eliminado.';
$string['eventcompetencyframeworkupdated'] = 'Marco de competencia modificado.';
$string['eventcompetencyframeworkviewed'] = 'Marco de competencia visto.';
$string['eventcompetencyupdated'] = 'Competencia actualizada.';
$string['eventcompetencyviewed'] = 'Competencia vista.';
$string['eventevidencecreated'] = 'Evidencia creada.';
$string['eventplanapproved'] = 'Plan de aprendizaje aprobado.';
$string['eventplancompleted'] = 'Plan de aprendizaje completado.';
$string['eventplancreated'] = 'Plan de aprendizaje creado.';
$string['eventplandeleted'] = 'Plan de aprendizaje eliminado.';
$string['eventplanreopened'] = 'Plan de aprendizaje reabierto.';
$string['eventplanreviewrequestcancelled'] = 'Solicitud de revisión del plan de aprendizaje cancelada.';
$string['eventplanreviewrequested'] = 'Revisión del plan de aprendizaje solicitada.';
$string['eventplanreviewstarted'] = 'Revisión de Plan de aprendizaje iniciada.';
$string['eventplanreviewstopped'] = 'Revisión de Plan de aprendizaje detenida.';
$string['eventplanunapproved'] = 'Plan de aprendizaje no-aprobado.';
$string['eventplanunlinked'] = 'Plan de aprendizaje  des-ligado.';
$string['eventplanupdated'] = 'Plan de aprendizaje actualizado.';
$string['eventplanviewed'] = 'Plan de aprendizaje visto';
$string['eventtemplatecreated'] = 'Plantilla de Plan de aprendizaje creada.';
$string['eventtemplatedeleted'] = 'Plantilla de Plan de aprendizaje eliminada.';
$string['eventtemplateupdated'] = 'Plantilla de Plan de aprendizaje actualizada.';
$string['eventtemplateviewed'] = 'Plantilla de Plan de aprendizaje vista.';
$string['eventusercompetencyplanviewed'] = 'Plan de competencia del usuario visto.';
$string['eventusercompetencyrated'] = 'Competencia del usuario valorada.';
$string['eventusercompetencyratedincourse'] = 'Competencia del usuario valorada en curso.';
$string['eventusercompetencyratedinplan'] = 'Competencia del usuario valorada en un plan de aprendizaje.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Solicitud de revisión de competencia del usuario cancelada.';
$string['eventusercompetencyreviewrequested'] = 'Revisión de competencia del usuario solicitada.';
$string['eventusercompetencyreviewstarted'] = 'Revisión de competencia del usuario iniciada.';
$string['eventusercompetencyreviewstopped'] = 'Revisión de competencia del usuario detenida.';
$string['eventusercompetencyviewed'] = 'Competencia del usuario vista.';
$string['eventusercompetencyviewedincourse'] = 'Competencia del usuario vista en un curso.';
$string['eventusercompetencyviewedinplan'] = 'Competencia del usuario vista en un plan de aprendizaje.';
$string['eventuserevidencecreated'] = 'Evidencia de aprendizaje previo creada.';
$string['eventuserevidencedeleted'] = 'Evidencia de aprendizaje previo eliminada.';
$string['eventuserevidenceupdated'] = 'Evidencia de aprendizaje previo actualizada.';
$string['evidence_competencyrule'] = 'Se cumplió la regla de la competencia.';
$string['evidence_coursecompleted'] = 'El curso \'{$a}\' ha sido completado.';
$string['evidence_coursemodulecompleted'] = 'La actividad \'{$a}\' ha sido completada.';
$string['evidence_courserestored'] = 'La valoración fue restaurada junto con el curso \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'La evidencia de aprendizaje previo \'{$a}\' fue enlazada.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'La evidencia de aprendizaje previo \'{$a}\' fue desvinculada.';
$string['evidence_manualoverride'] = 'La valoración de competencia fue configurada manualmente.';
$string['evidence_manualoverrideincourse'] = 'La valoración de competencia fue configurada manualmente en el curso \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'La valoración de competencia fue configurada manualmente en el plan de aprendizaje \'{$a}\'.';
$string['invalidevidencedesc'] = 'Descripción de evidencia inválida';
$string['invalidgrade'] = 'Valoración inválida';
$string['invalidpersistenterror'] = 'Error: {$a}';
$string['invalidplan'] = 'Plan de aprendizaje inválido';
$string['invalidtaxonomy'] = 'Taxonomía inválida: {$a}';
$string['invalidurl'] = 'La URL no es válida. Asegúrese de que comienza con \'http://\' o \'https://\'.';
$string['nouserplanswithcompetency'] = 'No hay planes de aprendizaje para esta competencia.';
$string['planstatusactive'] = 'Activo';
$string['planstatuscomplete'] = 'Completado';
$string['planstatusdraft'] = 'Borrador';
$string['planstatusinreview'] = 'En revisión';
$string['planstatuswaitingforreview'] = 'Esperando revisión';
$string['pointsrequiredaremet'] = 'Se cumplieron los puntos requeridos';
$string['privacy:evidence:action:complete'] = 'Completar competencia si no hay valoración';
$string['privacy:evidence:action:log'] = 'Registrar acción';
$string['privacy:evidence:action:override'] = 'Anular valoración de competencia';
$string['privacy:metadata:competency'] = 'Un registro de las competencias';
$string['privacy:metadata:competency_coursecomp'] = 'Un registro de las competencias enlazadas a un curso';
$string['privacy:metadata:competency_coursecompsetting'] = 'Un registro de las configuraciones de las competencias en un curso';
$string['privacy:metadata:competency_evidence'] = 'Un registro de la evidencia que afecta un estado de competencia';
$string['privacy:metadata:competency_framework'] = 'Un registro de las estructuras de competencia';
$string['privacy:metadata:competency_modulecomp'] = 'Un registro de las competencias enlazadas a un módulo';
$string['privacy:metadata:competency_plan'] = 'Un registro de los planes de aprendizaje';
$string['privacy:metadata:competency_plancomp'] = 'Un registro de las competencias en un plan de aprendizaje';
$string['privacy:metadata:competency_relatedcomp'] = 'Un registro de las relaciones entre las competencias';
$string['privacy:metadata:competency_template'] = 'Un registro de las plantillas de los planes de aprendizaje';
$string['privacy:metadata:competency_templatecohort'] = 'Un registro de las cohortes asociadas con una plantilla de plan de aprendizaje';
$string['privacy:metadata:competency_templatecomp'] = 'Un registro de las competencias en una plantilla de plan de aprendizaje';
$string['privacy:metadata:competency_usercomp'] = 'Un registro del estado de las competencias del usuario';
$string['privacy:metadata:competency_usercompcourse'] = 'Un registro del estado de las competencias del usuario en un curso';
$string['privacy:metadata:competency_usercompplan'] = 'Un registro del estado de las competencias del usuario en un plan de aprendizaje';
$string['privacy:metadata:competency_userevidence'] = 'Un registro de la evidencia de aprendizaje previo';
$string['privacy:metadata:competency_userevidencecomp'] = 'Un registro de las competencias asociadas con evidencia de aprendizaje previo';
$string['privacy:metadata:core_comments'] = 'Comentarios hechos en planes de aprendizaje y competencias';
$string['privacy:metadata:evidence:action'] = 'El tipo de acción tomada con la evidencia';
$string['privacy:metadata:evidence:actionuserid'] = 'El usuario que realiza la acción';
$string['privacy:metadata:evidence:desca'] = 'Los parámetros opcionales de la descripción de la evidencia traducible';
$string['privacy:metadata:evidence:desccomponent'] = 'El componente de la descripción de evidencia traducible';
$string['privacy:metadata:evidence:descidentifier'] = 'Un identificador de la descripción de evidencia traducible';
$string['privacy:metadata:evidence:grade'] = 'La calificación asociada con la evidencia';
$string['privacy:metadata:evidence:note'] = 'Una anotación no localizada anexada a la evidencia';
$string['privacy:metadata:evidence:url'] = 'Una URL asociada con la evidencia';
$string['privacy:metadata:plan:description'] = 'La descripción del plan de aprendizaje';
$string['privacy:metadata:plan:duedate'] = 'La fecha esperada del plan de aprendizaje';
$string['privacy:metadata:plan:name'] = 'El nombre del plan de aprendizaje';
$string['privacy:metadata:plan:reviewerid'] = 'El ID del revisor del plan de aprendizaje';
$string['privacy:metadata:plan:status'] = 'El estado del plan de aprendizaje';
$string['privacy:metadata:plan:userid'] = 'El ID del usuario de quien es el plan de aprendizaje';
$string['privacy:metadata:timecreated'] = 'El momento en el cual fue creado el registro';
$string['privacy:metadata:timemodified'] = 'El momento en el cual fue editado el registro';
$string['privacy:metadata:usercomp:grade'] = 'La calificación dada para la competencia';
$string['privacy:metadata:usercomp:proficiency'] = 'Si se logró la maestría/pericia/dominio';
$string['privacy:metadata:usercomp:reviewerid'] = 'El ID del revisor';
$string['privacy:metadata:usercomp:status'] = 'El estado de la competencia';
$string['privacy:metadata:usercomp:userid'] = 'El ID del usuario de quien es la competencia';
$string['privacy:metadata:userevidence:description'] = 'La descripción de la evidencia';
$string['privacy:metadata:userevidence:name'] = 'El nombre de la evidencia del aprendizaje previo';
$string['privacy:metadata:userevidence:url'] = 'Una URL asociada con la evidencia';
$string['privacy:metadata:usermodified'] = 'El usuario que creó o modificó el registro';
$string['privacy:path:plans'] = 'Planes de aprendizaje';
$string['privacy:path:relatedtome'] = 'Relacionado conmigo';
$string['privacy:path:userevidence'] = 'Evidencia de aprendizaje anterior';
$string['pushcourseratingstouserplans'] = 'Enviar valoraciones de cursos a planes de aprendizaje individuales';
$string['pushcourseratingstouserplans_desc'] = 'Valor por defecto de la configuración del curso para actualizar los planes de aprendizaje individuales cuando son valoradas las competencias del curso.';
$string['syncplanscohorts'] = 'Sincronizar planes desde cohortes de plantillas de plan de aprendizaje';
$string['taxonomy_behaviour'] = 'Comportamiento';
$string['taxonomy_competency'] = 'Competencia';
$string['taxonomy_concept'] = 'Concepto';
$string['taxonomy_domain'] = 'Dominio';
$string['taxonomy_indicator'] = 'Indicador';
$string['taxonomy_level'] = 'Nivel';
$string['taxonomy_outcome'] = 'Resultado de aprendizaje';
$string['taxonomy_practice'] = 'Práctica';
$string['taxonomy_proficiency'] = 'Aptitud';
$string['taxonomy_skill'] = 'Habilidad';
$string['taxonomy_value'] = 'Valor';
$string['usercommentedonacompetency'] = '{$a->fullname} comentó en la competencia "{$a->competency}":

{$a->comment}

Ver: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} comentó en la competencia "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Ver: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} comentó en la competencia';
$string['usercommentedonacompetencysubject'] = '{$a} comentó en una competencia.';
$string['usercommentedonaplan'] = '{$a->fullname} comento en el plan de aprendizaje "{$a->plan}":

{$a->comment}

Ver: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} comentó en el plan de aprendizaje "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Ver: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} comentó en el plan de aprendizaje "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} comentó en el plan de aprendizaje.';
$string['usercompetencystatus_idle'] = 'No activo';
$string['usercompetencystatus_inreview'] = 'En revision';
$string['usercompetencystatus_waitingforreview'] = 'Esperando revisión';
$string['userplans'] = 'Planes de aprendizaje';
