<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'es', version '3.9'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Acceso denegado';
$string['accounts'] = 'Cuentas';
$string['addcategory'] = 'Añadir una categoría';
$string['additionalhtml'] = 'HTML adicional';
$string['additionalhtml_desc'] = 'Estas opciones permiten especificar el código HTML a añadir en todas las páginas. Puede establecer el código HTML que se añadirá dentro de la etiqueta HEAD de la página, inmediatamente después de que se haya abierto la etiqueta BODY o inmediatamente antes de que  la etiqueta BODY se cierre. <br /> Hacer esto le permite agregar encabezados o pies de página personalizados en cada página o añadir fácilmente, con independencia del tema elegido, soporte para servicios como Google Analytics.';
$string['additionalhtml_heading'] = 'HTML adicional que será añadido a cada página.';
$string['additionalhtmlfooter'] = 'Antes de cerrar BODY';
$string['additionalhtmlfooter_desc'] = 'Este contenido se agregará a cada página justo antes de que se cierre la etiqueta BODY.';
$string['additionalhtmlhead'] = 'Dentro del HEAD';
$string['additionalhtmlhead_desc'] = 'Este contenido se agregará al final de la etiqueta HEAD en cada página. ';
$string['additionalhtmltopofbody'] = 'Cuando BODY está abierto';
$string['additionalhtmltopofbody_desc'] = 'Este contenido es añadido en cada página inmediatamente después de la etiqueta de apertura de cuerpo';
$string['admincategory'] = 'Categoría: {$a}';
$string['adminseesall'] = 'Los Administradores ven todo';
$string['adminseesallevents'] = 'Los Administradores ven todos los eventos';
$string['adminseesownevents'] = 'Los administradores son como los demás usuarios';
$string['advancedfeatures'] = 'Opciones avanzadas';
$string['agedigitalconsentverification'] = 'Verificación de la edad de consentimiento digital.';
$string['agedigitalconsentverification_desc'] = 'Habilita la verificación de la edad digital de consentimiento antes de mostrar la página de alta para auto-registrar usuarios. Esto protege a su sitio de menores de edad que se podrían apuntar sin el consentimiento de sus padres o tutores. Los detalles del <a target="_blank" href="{$a}">Contacto para soporte</a> son proporcionados a menores de edad para más asistencia.';
$string['ageofdigitalconsentmap'] = 'Edad de consentimiento digital.';
$string['ageofdigitalconsentmap_desc'] = 'Si hay diferencia entre la edad de consentimiento digital y la edad por defecto en cualquier país, debe ser especificado aquí. Para ello, debe introducir cada edad en una nueva línea con el siguiente formato: código del país, edad (separada por una coma). La edad por defecto se indica con * en lugar del código del país. Los códigos de los países están especificados en la ISO 3166-2.';
$string['allcountrycodes'] = 'Todos los códigos de país';
$string['allowattachments'] = 'Permitir archivos adjuntos';
$string['allowbeforeblock'] = 'La lista autorizada será procesada primero';
$string['allowbeforeblockdesc'] = 'Por defecto, se procesará en primer lugar la lista de IPs bloqueadas; si la opción se activa, la lista de IPs permitidas se procesará antes que la lista bloqueada.';
$string['allowblockstodock'] = 'Permitir que los bloques utilicen la barra lateral \'dock\'';
$string['allowcategorythemes'] = 'Permitir temas por categoría';
$string['allowcohortthemes'] = 'Permitir temas en cohortes';
$string['allowcoursethemes'] = 'Permitir estilos en el curso';
$string['allowedemaildomains'] = 'Dominios de correo electrónico permitidos.';
$string['allowediplist'] = 'Lista de IP permitidas';
$string['allowemailaddresses'] = 'Dominios de Email permitidos';
$string['allowemojipicker'] = 'Selector de Emoji';
$string['allowframembedding'] = 'Permitir incrustación de marco';
$string['allowframembedding_help'] = 'Si se encuentra habilitado, este sitio puede ser incrustado en un marco en un sistema remoto, según es recomendado cuando se utiliza  el plugin de matricula "Publicar como herramienta LTI". En caso contrario, por razones de seguridad, se recomienda dejar deshabilitada la opción de incrustado. Favor tener en cuenta que para las app moviles ésta configuracion es ignorada y el incrustado en marco siempre es permitido.';
$string['allowguestmymoodle'] = 'Permitir el acceso de invitados al Área Personal';
$string['allowindexing'] = 'Permitir indexado por motores de búsqueda';
$string['allowindexing_desc'] = 'Esto determina si se permite a los motores de búsqueda indexar su sitio. "Todas las páginas" permitirá que los motores de búsqueda busquen en todas las páginas del sitio, incluidas las de inicio de sesión y registro, lo que significa que las páginas que cuentan con la condición de forzar acceso activado, también serán indexadas. Para evitar el riesgo de spam en relación a estas páginas de registro en las búsquedas, utilice "Todas las páginas, excepto las de inicio de sesión y registro". "Ninguna página" les dirá a los motores de búsqueda que no indexen nada. Tenga en cuenta que esto es solo una etiqueta en el encabezado del sitio. Depende del motor de búsqueda respetar la etiqueta.';
$string['allowindexingeverywhere'] = 'Todas las páginas';
$string['allowindexingexceptlogin'] = 'Todas las páginas, excepto las de inicio de sesión y registro';
$string['allowindexingnowhere'] = 'Ninguna página';
$string['allowobjectembed'] = 'Permitir marcas EMBED y OBJECT';
$string['allowthemechangeonurl'] = 'Permitir cambios de tema en la URL';
$string['allowuserblockhiding'] = 'Permitir el acceso a usuarios a bloques ocultos';
$string['allowusermailcharset'] = 'Permitir al usuario cambiar el conjunto de caracteres';
$string['allowuserswitchrolestheycantassign'] = 'Permitir a los usuarios sin el permiso para asignar roles cambiar de rol.';
$string['allowuserthemes'] = 'Permitir estilos al usuario';
$string['alternativefullnameformat'] = 'Formato del nombre completo alternativo';
$string['alternativefullnameformat_desc'] = 'Define como se muestran los nombres a los usuarios que tienen activada la capacidad "viewfullnames" (por defecto, disponible en usuarios con roles de gestor, profesor o profesor sin permisos de edición). Los marcadores que pueden ser usados vienen determinados por el parámetro \'Formato de nombre completo\'.';
$string['always'] = 'Siempre';
$string['appearance'] = 'Apariencia';
$string['aspellpath'] = 'Ruta a aspell';
$string['authentication'] = 'Autenticación';
$string['authpreventaccountcreation'] = 'Evitar la creación de cuentas al identificarse';
$string['authpreventaccountcreation_help'] = 'Cuando un usuario se identifica, si aún no existe su cuenta, se crea una en el sitio de forma automática. Si se utiliza una base de datos externa para la identificación, por ejemplo LDAP, pero se desea restringir el acceso al sitio solo a los usuarios con una cuenta existente, esta opción debe estar habilitada. Las nuevas cuentas tendrán que ser creadas manualmente o mediante la función de carga de usuarios. Tenga en cuenta que este ajuste no se aplica a la identificación MNet.';
$string['authsettings'] = 'Gestionar la autenticación';
$string['autolang'] = 'Detección automática de idiomas';
$string['autologinguests'] = 'Acceso automático de invitados';
$string['availablelicenses'] = 'Licencias disponibles';
$string['availableto'] = 'Disponible para';
$string['backgroundcolour'] = 'Color transparente';
$string['backup_shortname'] = 'Usar nombre del curso en el nombre del archivo de copia de seguridad';
$string['backup_shortnamehelp'] = 'Usar el nombre del curso como parte del nombre del archivo de copia de seguridad.';
$string['backups'] = 'Copias de seguridad';
$string['badwordsconfig'] = 'Escribe la lista de palabras malsonante separadas por comas.';
$string['badwordsdefault'] = 'Si la lista personalizada está vacía, se usará una lista por defecto contenida en el paquete de idioma.';
$string['badwordslist'] = 'Lista de palabras malsonantes personalizadas.';
$string['blockediplist'] = 'Lista de IPs bloqueadas';
$string['blockinstances'] = 'Instancias';
$string['blockmultiple'] = 'Múltiple';
$string['blockprotect'] = 'Proteger instancias';
$string['blockprotect_help'] = 'Si bloquea un determinado tipo de bloque, entonces nadie será capaz de añadir o eliminar instancias (puede, por supuesto, desbloquear de nuevo si necesita editar alguno).

Con ello se pretende proteger los bloques de la misma manera que navegación y ajustes, que son muy difíciles de recuperar en caso de eliminarse.';
$string['blocksettings'] = 'Gestionar bloques';
$string['blockunprotect'] = 'Desproteger';
$string['bloglevel'] = 'Visibilidad del blog';
$string['bookmarkadded'] = 'Marcador añadido.';
$string['bookmarkalreadyexists'] = 'Ya tiene un marcador de esta página.';
$string['bookmarkdeleted'] = 'Marcador borrado.';
$string['bookmarkthispage'] = 'Marcar esta página';
$string['cacheapplication'] = 'Caché de aplicación';
$string['cacheapplicationhelp'] = 'Los items en caché se comparten entre los usuarios y caducan en un tiempo determinado.';
$string['cachejs'] = 'Caché Javascript';
$string['cachejs_help'] = 'El almacenamiento en caché y la conversión Javascript mejoran enormemente el rendimiento de carga de la página. Se recomienda para los sitios de producción. Los desarrolladores probablemente querrán desactivar esta función.';
$string['cacherequest'] = 'Solicitar caché';
$string['cacherequesthelp'] = 'Caché específica de usuario que caduca cuando se completa la solicitud. Diseñada para remplazar áreas en donde estamos usando los almacenamientos estáticos.';
$string['cachesession'] = 'Caché de la sesión';
$string['cachesessionhelp'] = 'Caché específica del usuario que caduca cuando termina la sesión del usuario. Diseñada para aliviar la sobrecarga de la sesión.';
$string['cachesettings'] = 'Configuración de caché';
$string['cachetemplates'] = 'Caché de plantillas';
$string['cachetemplates_help'] = 'La caché de plantillas mejorará el rendimiento de carga y es altamente recomendado para sitios en producción. Los desarrolladores probablemente deseen mantener esta característica desactivada.';
$string['caching'] = 'Almacenamiento en caché';
$string['calendar_weekend'] = 'Días del fin de semana';
$string['calendarexportsalt'] = 'Salado de exportación de calendarios';
$string['calendarsettings'] = 'Calendario';
$string['calendartype'] = 'Tipo de calendario';
$string['calendartype_desc'] = 'Elija un tipo de calendario por defecto para todo el sitio. Este ajuste se puede sobrescribir por los ajustes de la configuración del curso o por los del perfil personal del usuario';
$string['cannotdeletemodfilter'] = 'No puedes desinstalar \'{$a->filter}\' porque es parte del módulo \'{$a->module}\'.';
$string['cannotuninstall'] = '{$a} no puede ser desinstalado.';
$string['categoryemail'] = 'Correo electrónico';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot ha sido definido incorrectamente en el archivo config.php. Ha incluído el carácter \'/\' al final. Por favor, elimínelo.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot ha sido definido incorrectamente en el archivo config.php. Debe corresponder a la URL que usted está utilizando para acceder a ésta página.';
$string['change'] = 'cambiar';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Sí';
$string['checkupgradepending'] = 'Actualizar';
$string['choosefiletoedit'] = 'Elija el fichero a editar';
$string['cleanup'] = 'Limpieza';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 's';
$string['cliexitgraceful'] = 'Saliendo elegantemente, por favor aguarde ...';
$string['cliexitnow'] = 'Saliendo AHORA';
$string['cliincorrectvalueerror'] = 'Error, valor incorrecto  "{$a->value}" para "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Valor incorrecto, por favor, intente de nuevo';
$string['clistatusdisabled'] = 'Estado: desactivado';
$string['clistatusenabled'] = 'Estado: activado';
$string['clistatusenabledlater'] = 'estado: se habilitará modo de mantenimiento CLI en {$a}';
$string['clitypevalue'] = 'valor del tipo';
$string['clitypevaluedefault'] = 'valor del tipo, pulse Enter para utilizar el valor por defecto ({$a})';
$string['cliunknowoption'] = 'Opciones no reconocidas:
{$a}
Por favor, utilice la opción Ayuda.';
$string['cliupgradedefault'] = 'Nueva configuración: {$a}';
$string['cliupgradedefaultheading'] = 'Configurando los nuevos valores por defecto';
$string['cliupgradedefaultverbose'] = 'Nueva configuración: {$a->name}, Valor por defecto: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Actualización a través de línea de comandos desde {$a->oldversion} a {$a->newversion} finalizada con éxito.';
$string['cliupgradenoneed'] = 'No se necesita actualizar la versión instalada {$a}. ¡Gracias!';
$string['cliupgradepending'] = 'Una actualización está pendiente';
$string['cliyesnoprompt'] = 'escriba s (para sí) o n (para no)';
$string['commentsperpage'] = 'Comentarios por página';
$string['commonactivitysettings'] = 'Ajustes comunes de actividades';
$string['commonfiltersettings'] = 'Ajustes comunes de filtros';
$string['commonsettings'] = 'Ajustes comunes';
$string['componentinstalled'] = 'Componente instalado';
$string['computedfromlogs'] = 'Calculado a partir de los registros desde {$a}.';
$string['condifmodeditdefaults'] = 'Los valores por defecto se utilizan en el formulario de configuración cuando se crea una nueva actividad o recurso.';
$string['confeditorhidebuttons'] = 'Seleccione los botones que podrían ser ocultados en el editor HTML.';
$string['configallcountrycodes'] = 'Esta es la lista de países que pueden ser seleccionadas en varios lugares, por ejemplo, en el perfil de un usuario. Si está en blanco (por defecto) se utilizará la lista de \'countries.php\' en el paquete de idioma Inglés estándar. Esta es la lista de la norma ISO 3166-1. De lo contrario, puede especificar una lista separada por comas de los códigos, por ejemplo, "GB, FR, ES. Si se agregan nuevos códigos, no estándar aquí, tendrá que añadirlos a countries.php en \'en\' y su paquete de idioma.';
$string['configallowassign'] = 'Puede permitir a las personas que tienen los roles de la izquierda asignar algunos de los roles de la columna a otras personas';
$string['configallowattachments'] = 'Al habilitar esta opción permitirá que se pueden enviar archivos adjuntos con los mensajes de correo electrónico generados por diversas funcionalidades dentro del sitio, como blogs, foros, o insignias';
$string['configallowblockstodock'] = 'Si se activa y está soportado por el tema seleccionado, los usuarios pueden optar por mover los bloques a una barra lateral \'dock\' especial';
$string['configallowcategorythemes'] = 'Si activa esta opción, los temas pueden ajustarse al nivel de la categoría. Esto afectará a todas las categorías y cursos de nivel inferior (\'hijos\') a menos que tengan especificado su propio tema. ATENCIÓN: Habilitar esta opción puede afectar al rendimiento.';
$string['configallowcohortthemes'] = 'Si activa esto, se podrán asignar temas a nivel de cohorte. Esto afecta a todos los usuarios con solo una cohorte o con varias cohortes que usen el mismo tema.';
$string['configallowcoursethemes'] = 'Si activa esta opción, se permitirá a los cursos elegir sus propios temas. Los temas de los cursos tienen prioridad sobre todas las demás opciones (sitio, usuario, categoría, cohorte o sesión).';
$string['configallowedemaildomains'] = 'Liste los dominios de correo electrónico que se permiten divulgar en la sección "De" del correo electrónico saliente. El valor predeterminado "Vacío" utilizará la dirección No-reply para todos los mensajes de correo salientes. Se permite el uso de comodines, por ejemplo *.example.com permitirá que los correos electrónicos sean enviados desde cualquier subdominio de example.com, pero no del propio dominio ejemplo.com. Este último requerirá una entrada independiente en el listado.';
$string['configallowemailaddresses'] = 'Si desea restringir todas las direcciones nuevas de correo a ciertos dominios, lístelos aquí separados por espacios. El resto de los dominios serán rechazados. Para permitir subdominios agregue el dominio precedido por \'.\',  por ejemplo, <strong>.ourcollege.edu.au .gov.au</strong>';
$string['configallowemojipicker'] = 'El selector de emoji permite a los usuarios seleccionar emojis, como caras sonrientes,  para añadir a mensajes y otros campos de texto a través de un botón selector de emoji en la barra de herramientas de Atto.';
$string['configallowemojipickerincompatible'] = 'La configuración actual de su base de datos no es compatible con emojis. Para habilitar el selector de emoji, deberá <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">Actutualice su Base de Datos para soporte completo de caracteres unicode</a>.';
$string['configallowguestmymoodle'] = 'Si se habilita, los invitados podrán acceder al Área Personal, de lo contrario los invitados serán redirigidos a la página principal del sitio.';
$string['configallowobjectembed'] = 'Como medida de seguridad por defecto, los usuarios normales no podrán incrustar en el código HTML objetos multimedia (e.g., Flash) dentro del texto utilizando las marcas explícitas EMBED y OBJECT (si bien podrá hacerse con seguridad utilizando el filtro mediaplugins). Active la opción si desea permitir dichas marcas.';
$string['configallowoverride'] = 'Puede permitir a las personas que tengan los roles de la izquierda anular algunos de los roles de la columna';
$string['configallowoverride2'] = 'Seleccione qué rol(es) puede(n) ser invalidado(s) por cada rol de la columna izquierda.<br />Tenga en cuenta que estos ajustes sólo se aplican a los usuarios que tienen la capacidad \'moodle/role:override\' o \'moodle/role:safeoverride\'.';
$string['configallowswitch'] = 'Seleccione a qué roles puede cambiar un usuario, de entre los roles que ya tiene asignados. Además de una entrada en esta tabla el usuario debe tener también la capacidad moodle/role:switchroles para poder cambiar de rol.<br />Tenga en cuenta que solamente es posible cambiar hacia roles que tienen la capacidad moodle/course:view, y que no tengan la capacidad moodle/site:doanything, por lo que algunas columnas en esta tabla están deshabilitadas.';
$string['configallowthemechangeonurl'] = 'Si está activado, el tema gráfico se puede cambiar mediante la adición de <br/>?theme=nombredeltema a cualquier URL de Moodle (ej: misitiomoodle.com/?theme=afterburner) o <br/>&theme=nombredeltema a cualquier URL interna de Moodle (ej: misitiomoodle.com/course/view.php?id=2&theme=afterburner)';
$string['configallowuserblockhiding'] = '¿Desea que los usuarios puedan mostrar u ocultar bloques laterales en el sitio? Esta opción usa Javascript y \'cookies\' para recordar el estado de cada bloque colapsable, y sólo afecta al modo en que cada usuario ve la información.';
$string['configallowusermailcharset'] = 'Si habilita esta opción, todos los usuarios del sitio podrán especificar su propio juego de caracteres para escribir emails.';
$string['configallowuserswitchrolestheycantassign'] = 'Por defecto es necesario tener el permiso moodle/role:assign para cambiar roles. Habilitando este ajuste se elimina este requisito de manera que que los roles disponibles en el menú desplegable "Cambiar rol a" estén determinados únicamente por los ajustes de la tabla "Permitir asignación de roles". Se recomienda que los ajustes de la tabla "Permitir asignación de roles" no den  permisos a los usuarios para cambiarse a un rol con más capacidades que las de su rol actual.';
$string['configallowuserthemes'] = 'Si se activa esta opción, los usuarios podrán elegir sus propios temas. Los temas de los usuarios anulan los temas del sitio (pero no los temas del curso)';
$string['configallowview'] = 'Seleccionar qué roles podrá ver un usuario, podrá filtrar por, etc. basado en los roles que ya tienen.';
$string['configallusersaresitestudents'] = 'En lo que concierne a las actividades de la página principal del sitio, ¿deberían todos los usuarios ser considerados como estudiantes? Si la respuesta es "Sí", cualquier usuario con cuenta confirmada podrá participar como estudiante en tales actividades. Si la respuesta es "No", sólo los usuarios que ya participan en al menos un curso podrán tomar parte en las actividades de la página principal. Sólo los administradores y profesores especialmente asignados pueden actuar como profesores en las actividades de la página principal.';
$string['configauthenticationplugins'] = 'Por favor, seleccione los \'plugins\' de identificación que desea utilizar y dispóngalos en orden de fallo.';
$string['configautolang'] = 'Detectar idioma por defecto desde el ajuste del navegador. Si está deshabilitado, se utiliza el idioma por defecto del sitio.';
$string['configautologinguests'] = '¿Deberá permitirse a los visitantes automáticamente el acceso como invitados cuando entran a los cursos con acceso de invitado?';
$string['configbloglevel'] = 'Esta opción le permite restringir el nivel en el que pueden verse los blogs de los usuarios en este sitio. Advierta que se especifica el contexto máximo de quien los ve, pero no de quien envía mensajes ni de los tipos de mensaje enviados al blog. Los blogs pueden también deshabilitarse completamente si así lo desea.';
$string['configcalendarcustomexport'] = 'Habilitar exportación personalizada de un rango de fechas del calendario';
$string['configcalendarexportsalt'] = 'Esta cadena de caracteres aleatorios se utiliza para mejorar las claves de seguridad (tokens) de identificación utilizadas para la exportación de los calendarios. Tenga en cuenta que todas las claves de seguridad actuales quedarán invalidadas si modifica esta sal.';
$string['configcookiehttponly'] = 'Habilita la nueva característica de PHP 5.2.0: se instruye a los navegadores para que envíen una \'cookie\' sólo a petición de http reales. Las \'cookies\' no deberían ser accesibles desde lenguajes de script. No todos los navegadores pueden ejecutar esta opción, y podría no ser compatible con el código actual. Ayuda a prevenir algunos tipos de ataques XSS.';
$string['configcookiesecure'] = 'Si el servidor solo acepta conexiones https, se recomienda habilitar el envío de \'cookies\' seguras. Si la opción está habilitada, por favor asegúrese que el servidor web no acepte http:// ni ha fijado una redirección permanente a direcciones https:// e idealmente envíe encabezados HSTS. Cuando una dirección <em>wwwroot</em> no comienza con https:// esta configuración es ignorada.';
$string['configcountry'] = 'Si selecciona un país, dicho país quedará como valor por defecto para nuevos usuarios o cuentas. Para forzar a los usuarios a elegir un país, deje la opción sin seleccionar.';
$string['configcoursegraceperiodafter'] = 'Clasificar cursos pasados como en progreso por este número de días después de la fecha de fin del curso.';
$string['configcoursegraceperiodbefore'] = 'Clasificar cursos futuros como en progreso por este número de días antes de la fecha de inicio del curso.';
$string['configcourseoverviewfilesext'] = 'Una lista separada por comas de extensiones permitidas de archivos de imágenes del curso.';
$string['configcourseoverviewfileslimit'] = 'El número de archivos que pueden ser mostrados junto al resumen del curso en la página de lista de cursos. El primer archivo añadido es usado como la imagen del curso en la vista general del curso en los Tableros de los usuarios; los archivos adicionales son mostrados solamente en la página de la lista de cursos.';
$string['configcourserequestnotify'] = 'Escriba el nombre de usuario a quien se enviará una notificación cuando se solicite un nuevo curso';
$string['configcourserequestnotify2'] = 'Usuarios a quienes se notificará cuando un campo es requerido. En esta lista figuran únicamente los usuarios que pueden aprobar las solicitudes de curso.';
$string['configcoursesperpage'] = 'Introduzca el número de cursos a mostrar por página en un listado de cursos.';
$string['configcourseswithsummarieslimit'] = 'El número máximo de cursos que se mostrarán en un listado de cursos que incluye resúmenes antes de volver de nuevo a una lista simple.';
$string['configcronclionly'] = 'Ejecutar el programador de tareas cron desde un navegador web puede exponer información privilegiada a usuarios anónimos. Por ello se recomienda ejecutar cron solamente desde la línea de comandos o establecer una contraseña en cron para el acceso remoto.';
$string['configcronremotepassword'] = 'Esto significa que el script cron.php no puede ejecutarse desde un navegador web sin suministrar la contraseña usando la siguiente formato para la URL:<pre>http://site.example.com/admin/cron.php?password=opensesame
</pre>Si se deja vacío, no se necesita contraseña.';
$string['configcurlcache'] = 'Tiempo de vigencia (en segundos) de la caché cURL.';
$string['configcustommenuitems'] = 'Aquí se puede configurar un menú personalizado. Ingrese cada elemento del menú en una nueva línea con formato: texto del menú, una URL de enlace (opcional, no para un elemento del menú superior con subelementos), un título de información sobre herramientas (opcional) y un código de idioma o una lista de códigos separados por comas ( opcional, para mostrar la línea a los usuarios del idioma especificado solamente), separados por caracteres de barra. Las líneas que comienzan con un guión aparecerán como elementos de menú en el menú de nivel superior anterior y ### forma un divisor. Por ejemplo:
<pre>
Cursos
-Todos los cursos|/curso/
-Búsqueda de cursos|/course/search.php
- ###
-FAQ|https://someurl.xyz/faq
-Preguntas más frecuentes|https://someurl.xyz/pmf||es
Aplicación móvil|https://someurl.xyz/app | Descarga nuestra aplicación
</pre>';
$string['configcustomusermenuitems'] = 'Puede configurar los contenidos del menú del usuario (con excepción del enlace para cerrar sesión, que se añade automáticamente). Cada línea está separada por caracteres de | y consiste de 1) una cadena de texto en el formato "nombredecadenadeidioma, nombredelcomponente" o como texto simple, 2) una URL, y 3) un icono que puede ser un icono de pix (dentro de la carpeta pix con la estructura  [nombredesubcarpeta]/[nombredelicono], por ejemplo, i/publish), o como una URL. Pueden usarse divisores añadiendo una línea de uno o más caracteres # donde se quiera.';
$string['configdbsessions'] = 'Si elige esta opción, se usará la base de datos para almacenar información sobre las sesiones actuales. Tenga en cuenta que la modificación de este ajuste desconectará a todos los usuarios (incluído usted). Si está utilizando MySQL por favor confirme que la opción \'max_allowed_packet\' en my.cnf (o my.ini) es de por lo menos 4M. Otros drivers de sesión pueden ser configurados directamente en config.php, lea el fichero config-dist.php para más información. Esta opción desaparece si usted especifica un driver de sesión en el fichero config.php.';
$string['configdebug'] = 'Si activa esta opción, se incrementará el error_reporting de PHP, de modo que recibirá más advertencias. Sólo resulta útil para los desarrolladores.';
$string['configdebugdisplay'] = 'Si activa esta opción, el informe de errores irá a la página HTML. Es práctico pero rompe XHTML, JS, \'cookies\' y cabeceras HTTP en general. Si deshabilita esta opción, se enviarán las salidas a los registros del servidor, permitiendo una mejor depuración. El parámetro de configuración de PHP <b>error_log</b>controla a qué registro va el error.';
$string['configdebugpageinfo'] = 'Habilítelo si desea que la información de la página aparezca en el pie de página.';
$string['configdebugvalidators'] = 'Activar si quiere disponer de enlaces a servidores externos de validación a pie de página. Es posible que necesite crear un nuevo usuario con nombre de usuario <em>w3cvalidator</em>, y permitir el acceso de invitados. Estos cambios pueden facilitar el acceso no autorizado al servidor, ¡no lo hago en los sitios de producción!';
$string['configdefaulthomepage'] = 'Determina el primer enlace en la navegación para usuarios identificados';
$string['configdefaultrequestcategory'] = 'Los cursos que sean solicitados por usuarios con capacidad para solicitar nuevos cursos en el ámbito del sistema serán ubicados en esta categoría, a menos que los usuarios puedan seleccionar una categoría diferente.';
$string['configdefaultrequestedcategory'] = 'Categoría por defecto en la que incluir los cursos solicitados, en el caso de que sean aprobados.';
$string['configdefaultuserroleid'] = 'A todos los usuarios identificados se les asignarán los permisos del rol que usted especifique aquí, en el nivel del sitio, ADEMÁS de cualesquiera otros roles que puedan tener. El rol por defecto es el de Usuario identificado. Advierta que esto no entrará en conflicto con otros roles que tengan a menos que prohiba permisos. Simplemente asegura que todos los usuarios tengan permisos que no son asignables a nivel de curso (e.g., enviar entradas al blog, gestionar su propio calendario, etc.).';
$string['configdeleteincompleteusers'] = 'Después de este período, se eliminarán todas las cuentas que no tengan cumplimentados el nombre, apellido o el email.';
$string['configdeleteunconfirmed'] = 'Los usuarios deben confirmar su cuenta dentro de un tiempo determinado para algunos métodos de autenticación, tal como el auto-registro por medio de email. Despues de éste período, las cuentas que no hayan sido confirmadas seran eliminadas.';
$string['configdenyemailaddresses'] = 'Para denegar direcciones de email de dominios particulares, escriba aquí una lista de ellos. El resto de los dominios serán aceptados. Para denegar subdominios escriba el dominio precedido por un punto \'.\' Por ejemplo, <strong>hotmail.com (para dominios) .yahoo.es (para los subdominios)</strong>';
$string['configdisableuserimages'] = 'Desactiva la posibilidad de que los usuarios cambien las imágenes de sus perfiles.';
$string['configdisplayloginfailures'] = 'Mostrará información a los usuarios sobre los anteriores intentos de identificación  fallidos.';
$string['configdndallowtextandlinks'] = 'Activar o desactivar la función "Arrastrar y Soltar" en una página del curso, para texto y enlaces, además de para archivos. Tenga en cuenta que el arrastre de texto en Firefox, o entre diferentes navegadores no es fiable y puede dar lugar a que no se suba ningún dato o que el texto subido está corrupto.';
$string['configdoclang'] = 'Este idioma se puede utilizar en enlaces para las páginas de documentación.';
$string['configdocroot'] = 'Define la ruta a Moodle Docs para proporcionar documentación específica según el contexto mediante enlaces hacia \'Moodle Docs para esta página\' en el pie de cada página. Si deja vacío este espacio, desaparecerá el enlace hacia \'Moodle Docs para esta página\'.';
$string['configdoctonewwindow'] = 'Si habilita esta opción los enlaces a Moodle Docs se mostrarán en una nueva ventana.';
$string['configeditordictionary'] = 'Este valor será usado si el corrector de ortografía no tiene un diccionario para el idioma propio de los usuarios.';
$string['configeditorfontlist'] = 'Seleccione las fuentes que deberían aparecer en la lista del menú emergente del editor.';
$string['configemailchangeconfirmation'] = 'Cuando los usuarios cambien su dirección de correo electrónico en sus perfiles de usuario, se requerirá confirmación del correo electrónico.';
$string['configemailfromvia'] = 'Agregar información de origen (nombre corto del sitio) en la sección "De" del correo saliente.  Se informa al receptor de donde proviene el correo y además ayuda a evitar que los receptores accidentalmente respondan a una dirección de correo de "no responder" (no-reply en inglés).';
$string['configemailsubjectprefix'] = 'Texto a ser prefijado a la línea de asunto de todo el correo saliente.';
$string['configenableactivitychooser'] = 'El selector de actividad es una caja de diálogo con una breve descripción de cada actividad y recurso. Si está deshabilitada, habrá menús desplegables de recursos y actividades por separado.';
$string['configenableanalytics'] = 'Los modelos analíticos, tal como \'Riesgo de que los estudiantes abandonen\' o \'Vencimiento de próximas actividades\', pueden generar predicciones, enviar notificaciones de advertencia y ofrecer más acciones como contactar a los usuarios.';
$string['configenableblogs'] = 'Esta configuración les proporciona a todos los usuarios su propio blog.';
$string['configenablecalendarexport'] = 'Habilitar la exportación o suscripción a los calendarios.';
$string['configenablecomments'] = 'Habilitar comentarios';
$string['configenablecourserequests'] = 'Si se encuentra habilitado, los usuarios con la capacidad para solicitar nuevos cursos (moodle/course:request) tendrán la opción de solicitar un nuevo curso. Esta función no está permitida para ninguno de los roles predeterminados. Puede ser aplicada en el sistema or en el ámbito de categorías';
$string['configenabledevicedetection'] = 'Permite la detección de teléfonos móviles, móviles inteligentes, tabletas o dispositivos por defecto (PC de escritorio, PC portátil, etc.) para la aplicación de temas u otras características.';
$string['configenablemobilewebservice'] = 'Habilitar el servicio para móviles para la aplicación oficial Moodle u otra aplicación que lo solicite. Para más información lea la {$a}';
$string['configenablerssfeeds'] = 'Si está activado, los canales RSS son generados para varias características en todo el sitio, tales como blogs, foros, actividades de base de datos y glosarios. Tenga en cuenta que los feeds RSS también necesitan ser habilitados para los módulos de actividad particulares.';
$string['configenablerssfeedsdisabled'] = 'No está disponible porque los canales RSS están desactivados en todo el sitio. Para activarlos, vaya a Variables en Admin - Configuración.';
$string['configenablerssfeedsdisabled2'] = 'Los canales RSS están deshabilitados a nivel del sitio. Pueden ser activados desde Características avanzadas, en la Administración del sitio.';
$string['configenablestats'] = 'Si selecciona \'sí\', el cronjob de Moodle procesará los registros y recopilará algunas estadísticas. Dependiendo de la cantidad de tráfico del sitio, esta operación puede demorarse. Si activa esta opción, podrá ver algunos gráficos y estadísticas interesantes sobre cada uno de sus cursos, o bien sobre todo el sitio.';
$string['configenabletrusttext'] = 'Por defecto, Moodle limpiará siempre a fondo el texto escrito por los usuarios a fin de eliminar cualesquiera \'scripts\', medios, etc., que pudieran constituir un riesgo para la seguridad. El sistema de contenido confiable es una forma de otorgar a determinados usuarios en los que usted confía la capacidad para incluir estas características avanzadas en su contenido sin interferencias. Para activar este sistema, necesita en primer lugar activar este ajuste, y luego otorgar permiso de Contenido confiable a un rol específico de Moodle. Los textos creados o subidos por tales usuarios serán marcados como confiables y no serán sometidos a limipieza antes de ser mostrados.';
$string['configenablewebservices'] = 'Los servicios Web permiten otros sistemas para acceder a este Moodle y realizar operaciones. Para mayor seguridad esta característica debe ser desactivada a menos que realmente la esté utilizando.';
$string['configenablewsdocumentation'] = 'Habilitar la auto-generación de documentación de servicios web. Un usuario puede tener acceso a su propia documentación en su página de claves de seguridad {$a}. Solo se muestra la documentación de los protocolos habilitados.';
$string['configerrorlevel'] = 'Seleccionar la cantidad de advertencias PHP que desea mostrar. La mejor elección es \'Normal\'.';
$string['configexportlookahead'] = 'Días a mirar hacia adelante durante la exportación';
$string['configexportlookback'] = 'Días a mirar hacia atrás durante la exportación';
$string['configextendedusernamechars'] = 'Si está habilitado, los nombres de usuario pueden incluir cualquier carácter excepto letras mayúsculas. De lo contrario, solo se permiten caracteres alfanuméricos con letras minúsculas, guión bajo (_), guión (-), punto (.) y el símbolo de arroba (@).';
$string['configextramemorylimit'] = 'Algunas secuencias de comandos como búsqueda, copia de seguridad / restaurar o cron requieren más memoria. Establezca valores más altos para los sitios grandes.';
$string['configfilterall'] = 'Filtrar todas las cadenas, incluyendo cabeceras, títulos, barra de navegación, etc. Esto resulta muy útil cuando se usa el filtro multi-idioma; de otro modo, únicamente se ocasionará una sobrecarga en el sitio para obtener escasas ganancias.';
$string['configfiltermatchoneperpage'] = 'Los filtros de enlace automático sólo generarán un enlace único al primer ejemplo de texto coincidente que se encuentre en la página completa, pasando por alto el resto.';
$string['configfiltermatchonepertext'] = 'Los filtros de enlace automáticos solo generarán un enlace único para la primera instancia de texto coincidente que se encuentre en cada elemento de texto de la página. Todos los demás se ignoran. Esta configuración no tiene ningún efecto si la opción "Filtrar coincidencia una vez por página" está habilitada.';
$string['configfilteruploadedfiles'] = 'Esta opción posibilita que Moodle procese con los filtros todos los archivos HTML y de texto subidos antes de mostrarlos.';
$string['configforcelogin'] = 'Normalmente la página principal del sitio y las listas de los cursos (pero no los cursos) pueden ser leídos por cualquier visitante sin necesidad de identificarse. Si desea forzar a los visitantes a identificarse antes de acceder a CUALQUIER CONTENIDO debería activar esta opción.';
$string['configforceloginforprofiles'] = 'Esta opción obliga a los usuarios a acceder al sitio con cuentas válidas (no como invitados) antes de poder ver las páginas de los perfiles de usuario. Si deshabilita esta opción puede darse el caso de que algunos usuarios publiquen anuncios (spam) u otro contenido inapropiado en sus perfiles y este contenido será visible para todo el mundo.';
$string['configfrontpage'] = 'Los elementos seleccionados se mostrarán en la página principal del sitio.';
$string['configfrontpagecourselimit'] = 'Número máximo de cursos';
$string['configfrontpagecourselimithelp'] = 'Número máximo de cursos que se mostrará en la página principal del sitio en los listados de cursos.';
$string['configfrontpageloggedin'] = 'Los elementos seleccionados se mostrarán en la portada del sitio cuando un usuario se identifica.';
$string['configfullnamedisplay'] = 'Esta opción define cómo se verán los nombres cuando se muestren completos. Por defecto, "idioma", redirige a la cadena de caracteres "mostrarnombrecompleto" en el idioma a escoger. Algunos idiomas siguen un método de visualización del nombre diferente.

Para la mayoría de los sitios que usen un solo idioma, el ajuste más eficiente es el valor por defecto ("Nombre + Apellido"), pero puede elegir ocultar los apellidos. Los marcadores de posición que se pueden utilizar son: nombre, apellido, nombrefonético, apellidofonético, segundonombre, nombrealternativo.';
$string['configgeoipfile'] = 'Ubicación del archivo binario GeoIP City. Este archivo no forma parte de la distribución de Moodle y debe obtenerse de forma independiente en <a href="http://www.maxmind.com/">MaxMind</a>. Puede adquirir una versión comercial u optar por la versión gratuita.<br />Simplemente descargue <a href="http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz</a> y extráigalo en el directorio "{$a}" de su servidor.';
$string['configgetremoteaddrconf'] = 'Si su servidor está detrás de un proxy reverso, puede usar esta opción para especificar en qué cabeceras HTTP se puede confiar que contengan la dirección IP remota. Las cabeceras se leen por orden, usando la primera que esté disponible.';
$string['configgradebookroles'] = 'Esta opción le permite controlar quién aparece en el libro de calificaciones. Los usuarios necesitan tener al menos uno de estos roles en un curso para poder aparecer en el libro de calificaciones de ese curso.';
$string['configgradeexport'] = 'Elija qué formatos de exportación del libro de calificaciones constituyen su método principal para exportar calificaciones. Los conectores elegidos ajustarán y usarán un campo ("últimos exportados") para cada calificación. Por ejemplo, esto podría dar como resultado que los registros exportados se identificaran como "nuevos" o "actualizados". Si no está seguro de cómo hacer esto, no marque nada.';
$string['confighiddenuserfields'] = 'Para aumentar la privacidad de los estudiantes, seleccione qué campos de información sobre el usuario desea ocultar a otros usuarios distintos de los profesores del curso o los administradores. Mantenga pulsada la tecla CTRL para seleccionar varios campos.

Por favor, cuide los datos personales de los usuarios y considere IMPORTANTE tener la precaución de  no escribir ni permitir el acceso no-autorizado a "datos personales sensibles" (estado de salud, información genética, creencias religiosas, filosóficas y morales, afiliación sindical, opiniones políticas, orígen racial o étnico, preferencia sexual, ...) que pudieran causarle responsabilidades o riesgos innecesarios a usted y a la Institución.';
$string['configidnumber'] = 'Esta opción especifica si (a) No se pide a los usuarios un número de ID, (b) Se les pide un número de ID pero pueden dejarlo en blanco o (c) Se les pide un número de ID y no pueden dejarlo en blanco. En caso afirmativo, el número de ID del Usuario se muestra en su Perfil.';
$string['configintro'] = 'En esta página puede especificar un número de variables de configuración que ayudan a Moodle a trabajar adecuadamente en su servidor. Que esto no le preocupe demasiado: los valores por defecto funcionarán bien y, en todo caso, siempre podrá volver a esta página y cambiar los ajustes.';
$string['configintroadmin'] = 'En esta página debería configurar su cuenta de administrador principal, que le dará un control absoluto sobre el sitio. Asegúrese de que usa un nombre de usuario y contraseña seguros, así como una dirección de correo electrónico válida. Más adelante podrá crear más cuentas de administrador.';
$string['configintrosite'] = 'Esta página le permite configurar la página principal y dar un nombre a su nuevo sitio. Puede volver aquí más adelante y cambiar estos ajustes en cualquier momento usando los menús de Administración.';
$string['configiplookup'] = 'Cuando usted hace clic en una dirección IP (e.g., 34.12.222.93), como sucede en los registros, se mostrará un mapa con la mejor aproximación posible de la ubicación de la IP. Para hacer esto, existen diferentes \'plugins\' entre los que puede elegir, y cada uno de ellos tiene ventajas e inconvenientes.';
$string['configkeeptagnamecase'] = 'Marque esta opción si desea que los nombres de marca conserven el \'casing\' original tal como fue introducido por los usuarios que los crearon.';
$string['configlang'] = 'Elija un idioma por defecto para el sitio completo. Los usuarios pueden más tarde elegir otra opción en el menú de idiomas o en su perfil personal.';
$string['configlanglist'] = 'Si se deja en blanco, todos los idiomas instalados en el sitio se mostrarán en el menú de idioma. De manera alternativa, el menú de idioma puede simplificarse introduciendo una lista de códigos de idioma separados por comas como por ejemplo "en,de,fr". Si se desea se puede especificar un nombre diferente para el paquete de idioma utilizando el siguiente formato: código de idioma | nombre de idioma. Por ejemplo: en_kids | English, de_kids | Deutsch.';
$string['configlangmenu'] = 'Decida si quiere o no mostrar el menú de idiomas de propósito general en la página de inicio, en la de acceso, etc. Esto no afecta a la posibilidad que los usuarios tienen de elegir su idioma preferido en su propio perfil.';
$string['configlangstringcache'] = 'Guarda en la caché todas las cadenas del idioma en archivos compilados dentro del directorio de datos. Si está traduciendo Moodle o cambiando cadenas en el código fuente de Moodle entonces puede desactivar esto. De lo contrario, déjelo activo en beneficio del rendimiento.';
$string['configlatinexcelexport'] = 'Elegir la codificación para exportaciones en formato Excel.';
$string['configlocale'] = 'Elija una localización para el sitio. Esta localización tendrá preferencia sobre todos los paquetes de idiomas a la hora de elegir el formato y el lenguaje de las fechas (aunque los nombres de los días en el calendario no se verán afectados). Necesita tener estos datos de localización instalados en su sistema operativo (e.g., en linux en_US.UTF8 o es_ES.UTF8). En la mayoría de los casos debería dejar este campo en blanco.';
$string['configlockrequestcategory'] = 'En caso de habilitarse, los usuarios con competencias para solicitar nuevos cursos en el contexto del sistema, no podrán seleccionar una categoría en la solicitud de nuevo curso. Una vía alternativa para restringir a los usuarios poder solicitar un nuevo curso en una sola categoría es pedir la competencia de solicitar nuevos cursos en la categoría contexto';
$string['configloglifetime'] = 'Esta opción especifica durante cuánto tiempo desea conservar los registros de actividad de cada usuario. Los registros anteriores serán eliminados. Es mejor que la cifra sea alta (por si los necesita) pero si el servidor está muy ocupado y hay problemas de funcionamiento, tal vez convenga acortar el tiempo. No se recomiendan valores menores de 30 porque en ese caso puede que las estadísticas no funcionen correctamente.';
$string['configlookahead'] = 'Días de previsión';
$string['configmailnewline'] = 'Caracteres de línea nueva usados en los mensajes de correo electrónico. CRLF es necesario de acuerdo RFC 822bis; algunos servidores realizan una conversión automática desde LF a CRLF, en tanto que otros realizan una conversión incorrecta de CRLF a CRCRLF y, finalmente, otros rechazarn los correos con LF vacío (qmail, por ejemplo). Intente modificar este ajuste si tiene problemas con correos sin entregar o con nuevas líneas dobles.';
$string['configmaxbytes'] = 'Esta opción especifica el tamaño máximo que deben tener los archivos subidos al sitio. Está limitada por los ajustes post_max_size y upload_max_size de  PHP y por el ajuste LimitRequestBody de Apache. A su vez, la opción limita el rango de tamaños que pueden elegirse en el nivel de curso o de módulo. Si se elige la opción \'Límite de Servidor\' se usará el máximo permitido por el servidor.';
$string['configmaxconsecutiveidentchars'] = 'Las contraseñas no deben tener más de este número de caracteres idénticos consecutivos. Utilice el 0 para deshabilitar esta comprobación.';
$string['configmaxeditingtime'] = 'Esta opción especifica cuánto tiempo tienen los usuarios para reeditar los mensajes enviados al foro, el feedback del diario, etc. Normalmente 30 minutos es un valor adecuado.';
$string['configmaxevents'] = 'Eventos de previsión';
$string['configmaxusersperpage'] = 'Número máximo de usuarios que se mostrará en el selector de usuarios dentro de cursos, grupos, cohortes, servicios web, etc.';
$string['configmessaging'] = '¿Debe habilitarse el sistema de mensajería entre los usuarios del sitio?';
$string['configmessagingallowemailoverride'] = 'Permitir a los usuarios recibir notificaciones de mensajes de correo enviados a una dirección de correo electrónico distinta de la dirección de correo electrónico en su perfil';
$string['configmessagingallusers'] = 'Si se habilita, los usuarios pueden ver la lista de todos los usuarios en el sitio cuando seleccionen a alguien para enviarle un mensaje, y sus preferencias de mensajería incluyen la opción para aceptar mensajes de cualquiera en el sitio. Si está deshabilitado, los usuarios solamente pueden ver la lista de usuarios en sus cursos, y ellos solo tienen dos opciones en preferencias de mensajería - solamente aceptar mensajes de sus contactos, o de sus contactos y cualquiera en sus cursos.';
$string['configmessagingdefaultpressenter'] = 'Si \'Usar Intro para enviar\' está habilitado de forma predeterminada en la configuración de mensajería de los usuarios.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Las notificaciones leídas y sin leer pueden ser eliminadas para ahorrar espacio. ¿Cuanto tiempo después de que es creada una notificación puede ser eliminada?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Las notificaciones ya leídas pueden borrarse para ahorrar espacio. ¿Al cabo de cúanto tiempo después de ser leída puede borrarse?';
$string['configminpassworddigits'] = 'Las contraseñas deben tener al menos estos dígitos.';
$string['configminpasswordlength'] = 'Las contraseñas deben tener al menos este número de caracteres.';
$string['configminpasswordlower'] = 'Las contraseñas deben tener al menos este número de minúsculas.';
$string['configminpasswordnonalphanum'] = 'Las contraseñas deben tener al menos este número de caracteres no alfanuméricos.';
$string['configminpasswordupper'] = 'Las contraseñas deben tener al menos este número de mayúsculas.';
$string['configmodchooserdefault'] = '¿Se presentará por defecto a los usuarios el selector de actividad?';
$string['configmycoursesperpage'] = 'Número máximo de cursos que se mostrará en cualquier lista de cursos propios de un usuario';
$string['configmymoodleredirect'] = 'Esta opción fuerza a los no administradores a dirigirse a /my al ingresar y reemplaza la navegación de nivel superior del sitio con /my';
$string['configmypagelocked'] = 'Este ajuste impide que la página por defecto sea editada por cualquiera que no sea administrador';
$string['confignavcourselimit'] = 'Limita el número de cursos mostrados al usuario en la navegación.';
$string['confignavshowallcourses'] = 'Esta configuración determina si los usuarios que están inscritos en cursos pueden ver Cursos (enumerando todos los cursos) en la navegación, además de Mis cursos (enumerando los cursos en los que están inscritos).';
$string['confignavshowcategories'] = 'Mostrar las categorías de curso en la barra de navegación y en los bloques de navegación. Esto no afecta a los cursos en los que el usuario está actualmente matriculado, de manera que todavía aparecerán en la lista \'Mis cursos\' sin categorías.';
$string['confignoreplyaddress'] = 'A veces los emails son enviados por el usuario (e.g., mensajes a un foro). La dirección email especificada aquí se usará como dirección "De" en aquellos casos en que los receptores no puedan replicar directamente al usuario (e.g., cuando un usuario elige mantener oculta su dirección).';
$string['confignotifyloginfailures'] = 'Enviar notificación de acceso fallido a los usuarios seleccionados. Esto requiere la habilitación de un logstore interno (p.ej. Estándar Logstore).';
$string['confignotifyloginthreshold'] = 'Si las notificaciones de intentos de identificación fallidos están activas, ¿cuántos intentos fallidos son necesarios para enviar una notificación al respecto a un usuario o a una dirección IP?';
$string['confignotloggedinroleid'] = 'Los usuarios que no están identificados en el sitio serán tratados como si tuvieran este rol en el contexto del sitio. \'Invitado\' es aquí casi siempre lo que usted quiera, pero quizás desee crear roles que sean más o menos restrictivos. Cosas como colorar mensajes requieren aún que el usuario se autentifique adecuadamente.';
$string['configopentowebcrawlers'] = 'Si activa esta opción, se permitirá a Google entrar al sitio como Invitado. Además, quien acceda al sitio vía búsqueda en Google accederá automáticamente como Invitado. Note que esta opción sólo proporciona acceso transparente a los cursos que ya permiten el acceso a invitados.';
$string['configoverride'] = 'Definido en config.php';
$string['configpasswordpolicy'] = 'Si está habilitado, las contraseñas de usuario se compararán con la política de contraseñas como se especifica en la configuración a continuación. Habilitar la política de contraseñas no afectará a los usuarios existentes hasta que decidan, o se les solicite, cambiar su contraseña, o hasta que se habilite la configuración \'Comprobar contraseña al iniciar sesión\'.';
$string['configpasswordpolicycheckonlogin'] = 'Si se habilita, las contraseñas del usuario serán revisadas contra la política de contraseña cada vez que los usuarios ingresen al sitio. Si la revisión falla, se le pedirá al usuario que cambie su contraseña antes de proceder. Resulta útil el habilitar esta configuración después de actualizar la política de contraseña.';
$string['configpasswordresettime'] = 'Especifica de cuánto tiempo se dispone para validar una solicitud de restablecimiento de contraseña antes de que caduque. En general 30 minutos es un buen valor.';
$string['configpathtodu'] = 'Ruta a du (probablemente algo parecido a /usr/bin/du). Si escribe esto, las páginas que muestran el contenido del directorio se ejecutarán mucho más rápidamente cuando los directorios contengan muchos archivos.';
$string['configpathtophp'] = 'Ruta al CLI de PHP. Probablemente algo similar a /usr/bin/php. Si introduce esto, los scripts de cron podrán ser ejecutados desde el interfaz web de administración.';
$string['configperfdebug'] = 'Si activa esta opción, aparecerá la información sobre el rendimiento en el pie de página del tema estándar.';
$string['configprofileroles'] = 'Lista de roles que son visibles en los perfiles de usuario y en la página de participación.';
$string['configprofilesforenrolledusersonly'] = 'Para prevenir el abuso de los creadores de spam, se ocultan las descripciones del perfil de los usuarios que aún no están matriculados en ningún curso. Los usuarios nuevos deben matricularse en al menos un curso antes de que puedan agregar la descripción del perfil.';
$string['configprotectusernames'] = 'Por defecto, forget_password.php no muestra ninguna indicación que permita adivinar nombres de usuario o direcciones de email.';
$string['configproxybypass'] = 'Lista separada por comas de los nombres de host (parciales) o direcciones IP que deberían saltar el proxy (por ejemplo, 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Si este <b>servidor</b> necesita usar un proxy (e.g., un cortafuegos) para acceder a Internet, escriba aquí el nombre del proxy. En caso contrario, déjelo en blanco.';
$string['configproxypassword'] = 'Contraseña necesaria para acceder a internet a través del proxy; dejar vacío en caso contrario (se requiere extensión PHP cURL).';
$string['configproxyport'] = 'Si este servidor necesita usar un ordenador proxy, escriba aquí el puerto del proxy.';
$string['configproxytype'] = 'Tipo de proxy web (se requiere extensión PHP5 y cURL para apoyo SOCKS5).';
$string['configproxyuser'] = 'Nombre de usuario necesario para acceder a internet a través del proxy; dejar vacío en caso contrario (se requiere extensión PHP cURL).';
$string['configrecaptchaprivatekey'] = 'Cadena de caracteres (Clave secreta) usada para comunicarse entre su servidor Moodle y el servidor recaptcha.net. Obtenga una para este sitio visitando <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Cadena de caracteres (Clave del sitio) usados para mostrar el elemento reCAPTCHA en el formulario de acceso. Generada por <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestcategoryselection'] = 'Permitir la selección de una categoría cuando se solicita un curso.';
$string['configrequestedstudentname'] = 'Término utilizado para \'estudiante\' en los cursos solicitados';
$string['configrequestedstudentsname'] = 'Término utilizado para \'estudiantes\' en los cursos solicitados';
$string['configrequestedteachername'] = 'Término utilizado para \'profesor\' en los cursos solicitados';
$string['configrequestedteachersname'] = 'Término utilizado para \'profesores\' en los cursos solicitados';
$string['configreverseproxyignore'] = 'Si tu servidor está detrás de múltiples proxies inversos que se adjuntan con el encabezado X-Forwarded-For, entonces especifica una lista separada por comas de las direcciones IP o subredes de proxies inversos que deban ser ignoradas para poder encontrar la dirección IP correcta del usuario.';
$string['configsectioninterface'] = 'Interfaz';
$string['configsectionmail'] = 'Correo electrónico';
$string['configsectionmaintenance'] = 'Mantenimiento';
$string['configsectionmisc'] = 'Miscelánea';
$string['configsectionoperatingsystem'] = 'Sistema Operativo';
$string['configsectionpermissions'] = 'Permisos';
$string['configsectionrequestedcourse'] = 'Solicitudes de cursos';
$string['configsectionsecurity'] = 'Seguridad';
$string['configsectionstats'] = 'Estadísticas';
$string['configsectionuser'] = 'Usuario';
$string['configsecureforms'] = 'Moodle puede usar un nivel adicional de seguridad cuando acepta datos provenientes de formularios web. Si la opción está activada, se contrastará la variable HTTP_REFERER del navegador con la dirección del formulario actual. En muy pocos casos esto ocasiona problemas si el usuario utiliza un cortafuegos (e.g., ZoneAlarm) configurado para desmontar su HTTP_REFERER del tráfico web. El síntoma consiste en quedarse \'atascasdo\' en un formulario. Si, pongamos por caso, los usuarios tuvieran problemas con la página de acceso, quizás conviniera desactivar la opción, aun con el riesgo de dejar el sitio más vulnerable a ataques de fuerza bruta. En caso de duda, seleccione la opción \'Sí\'.';
$string['configsessioncookie'] = 'Esta opción personaliza el nombre de la \'cookie\' usada para las sesiones de Moodle. Es opcional, y resulta útil únicamente para evitar que las \'cookies\' se confundan cuando hay más de una copia de Moodle ejecutándose en el mismo sitio web.';
$string['configsessioncookiedomain'] = 'Le permite cambiar el dominio donde están disponibles las cookies de Moodle. Es útil para la personalización de Moodle (por ejemplo, extensiones de identificación o de matriculación) que necesitan compartir información de la sesión de Moodle con una aplicación web en otro subdominio. <strong> ADVERTENCIA: se recomienda dejar este ajuste en el valor por defecto (vacío) - un valor incorrecto impedirá todos los accesos al sitio </strong>.';
$string['configsessioncookiepath'] = 'Si necesita cambiar el lugar al que los navegadores envían las \'cookies\' de Moodle, cambie esta opción para especifirar un subdirectorio de su sitio web. En caso contrario, \'/\' por defecto funcionará correctamente..';
$string['configsessiontimeout'] = 'Si los usuarios conectados al sitio están inactivos durante mucho tiempo (i.e., sin cargar páginas), serán desconectados automáticamente (i.e., terminará la sesión). Esta variable especifica el tiempo de inactividad antes de la desconexión.';
$string['configshowcommentscount'] = 'Mostrar el número de comentarios. Supone una consulta más cuando se muestre el enlace a los comentarios';
$string['configshowicalsource'] = 'Mostrar información del origen de eventos iCal';
$string['configshowsiteparticipantslist'] = 'Todos los estudiantes y profesores del sitio aparecerán en la lista de participantes. ¿Quién puede ver esa lista?';
$string['configsitedefaultlicense'] = 'Licencia predeterminada del sitio';
$string['configsitedefaultlicensehelp'] = 'Licencia predeterminada para publicar contenidos en este sitio';
$string['configsitemailcharset'] = 'Todos los emails generados por su sitio se enviarán en el juego de caracteres que aquí se especifique. En cualquier caso, cada usuario individual podrá ajustar esta opción si está habilitado el siguiente ajuste.';
$string['configsitemaxcategorydepth'] = 'Profundidad máxima de la categoría';
$string['configsitemaxcategorydepthhelp'] = 'Especifica la profundidad máxima de las subcategorías cuando se muestan las categorías o la lista combo. Las categorías de nivel más bajo aparecerán como enlaces y los usuarios pueden desplegarlas con una petición AJAX.';
$string['configslasharguments'] = '"Slash arguments" (usando <em>PATH_INFO</em>) se requiere para que paquetes SCORM y múltiples formatos de archivo se muestren correctamente. Si su servidor web no admite "slash arguments" y es incapaz de configurarlo, este ajuste se puede deshabilitar, aunque ésto puede provocar fallos. <br /> Atención: El uso de "slash arguments" será requerido en futuras versiones de Moodle.';
$string['configsmartpix'] = 'Cuando se activa, los inconos se sirven a través de un script PHP que busca el tema actual, luego todos los temas padre, luego la carpeta /pix de Moodle. Esto reduce la necesidad de duplicar archivos de imágenes dentro de los temas, pero tiene un pequeño costo de rendimiento.';
$string['configsmtpauthtype'] = 'Este elemento configura el tipo de autenticación que se usará en el servidor smtp.';
$string['configsmtphosts'] = 'Escriba el nombre completo de uno o más servidores SMTP locales que Moodle usará para enviar correo (e.g., \'mail.a.com\' o \'mail.a.com;mail.b.com\'). Si lo deja en blanco, Moodle usará el método PHP por defecto para enviar correo.';
$string['configsmtpmaxbulk'] = 'Número máximo de mensajes enviados por sesión SMTP. La agrupación de mensajes puede agilizar el envío de emails. Valores inferiores a 2 fuerzan la creación de una nueva sesión SMTP para cada email.';
$string['configsmtpsecure'] = 'Si el servidor SMTP requiere conexión segura, especifique el tipo correcto de protocolo.';
$string['configsmtpuser'] = 'Si antes ha especificado un servidor SMTP, y el servidor requiere identificación, escriba aquí el nombre de usuario y la contraseña.';
$string['configstartwday'] = 'Comienzo de la semana';
$string['configstatsfirstrun'] = 'Esta opción especifica cuánto tiempo hacia atrás deberían procesarse los registros <b>la primera vez</b> que el cronjob procesa las estadísticas. Si el sitio tiene mucho tráfico y el servidor es compartido, probablemente no sea una buena idea ir muchos días atrás, puesto que el procesamiento de los registros tardará mucho tiempo y se consumirán muchos recursos. (Nótese que en esta opción 1 mes equivale a 28 días, en tanto que en los gráficos e informes generados, 1 mes equivale a 1 mes de calendario).';
$string['configstatsmaxruntime'] = 'El procesamiento estadístico puede ser muy intenso, de modo que conviene combinar este campo y el siguiente para especificar cuándo y durante cuánto tiempo funcionará.';
$string['configstatsmaxruntime2'] = 'El procesamiento de datos estadísticos puede ser muy intenso. Especifique el tiempo máximo permitido para recopilar las estadísticas de un día. El número máximo de días procesados en una ejecución del cron es de 31.';
$string['configstatsmaxruntime3'] = 'Especifica el tiempo máximo permitido para calcular las estadísticas de un día, teniendo en cuenta que el proceso de datos estadísticos supone una gran carga para el servidor. El número máximo de días procesados en un cron puede especificarse más abajo.';
$string['configstatsruntimedays'] = 'Especifica el número máximo de días procesados en cada ejecución estadística. Una vez que las estadísticas estén al día, se procesará sólo un día, así que ajuste este valor en función de la carga del servidor, reduciéndola si es necesario realizar ejecuciones de cron cortas.';
$string['configstatsruntimestart'] = '¿En qué momento comenzará a trabajar el cronjob que procesa las estadísticas? Se recomienda indicar distintas horas si existen varios Moodle en el mismo servidor.';
$string['configstatsuserthreshold'] = 'Este ajuste especifica el número mínimo de usuarios matriculados en un curso para que este valor sear incluidos en los cálculos de las estadísticas.';
$string['configstrictformsrequired'] = 'Si está activado, se impide a los usuarios introducir un espacio en blanco o un salto de línea en los campos obligatorios de los formularios.';
$string['configstripalltitletags'] = 'Desactive esta opción para permitir marcas HTML en los nombres de actividades y recursos.';
$string['configsupportemail'] = 'Esta dirección email se publicará a los usuarios del sitio como aquella a la que deberán dirigirse cuando necesiten ayuda de tipo general (por ejemplo, cuando un usuario nuevo crea su propia cuenta). Si se deja en blanco, no se dispondrá de una dirección de ayuda del tipo mencionado.';
$string['configsupportname'] = 'Este es el nombre de una persona u otra entidad  que ofrece ayuda general por medio de una dirección email o una página web.';
$string['configsupportpage'] = 'Esta dirección web se publicará a los usuarios del sitio como aquella a la que deberán dirigirse cuando necesiten ayuda de tipo general (por ejemplo, cuando un usuario nuevo crea su propia cuenta). Si se deja en blanco, no se suministrará el enlace correspondiente.';
$string['configtempdatafoldercleanup'] = 'Eliminar ficheros de datos temporales de la carpeta de datos que sean más viejos que la fecha seleccionada.';
$string['configthemedesignermode'] = 'Habitualmente todas las imágenes del tema y hojas de estilo se almacenan en caché en los navegadores y en el servidor durante un tiempo muy largo, para mejorar el rendimiento. Si va a rediseñar los temas o desarrollar código, es probable que desee activar este modo para que no se guarden versiones en la caché. Advertencia: esto hará que su sitio sea más lento para todos los usuarios mientras esté activado. Opcionalmente también puede restablecer la caché manualmente desde la página del selector de temas.';
$string['configthemelist'] = 'Deje esta opción en blanco para permitir que se utilice cualquier tema válido. Si quiere acortar el menú de temas, puede especificar una lista de nombres separados por comas (¡No use espacios!). Por ejemplo: standard,orangewhite';
$string['configtimezone'] = 'Aquí puede decidir la zona horaria por defecto. Ésta es la única zona horaria POR DEFECTO para mostrar fechas (cada usuario puede cambiar esta opción en su perfil). La "Hora del Servidor" hará que Moodle tome por defecto la del sistema operativo, pero esa opción en el perfil del usuario lo ajustará a la correspondiente zona horaria.';
$string['configuseblogassociations'] = '¿Deberían los usuarios poder organizar su blog asociando entradas con los cursos y con los módulos de curso?';
$string['configuseexternalyui'] = 'En lugar de usar archivos locales, usar archivos disponibles en línea en servidores de Yahoo. ADVERTENCIA: esto requiere una conexión de internet, de otro modo, AJAX no funcionará en el sitio. Esta configuración no es compatible con sitios que usan https.';
$string['configuserquota'] = 'El número máximo de bytes que un usuario puede almacenar en sus carpetas de archivos privados. {$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Si está habilitado se utilizará el nombre corto del sitio en lugar de la cadena de texto \'Páginas del sitio\' en la navegación por las páginas del sitio.';
$string['configusetags'] = '¿Habilitar la funcionalidad de marcas a través del sitio?';
$string['configvariables'] = 'Variables';
$string['configverifychangedemail'] = 'Habilita la verificación de direcciones de email cambiadas usando ajustes de dominios de correo electrónico permitidos y denegados. Si esta opción está deshabilitada, los dominios se fuerzan sólo cuando se crean usuarios nuevos.';
$string['configvisiblecourses'] = 'Mostrar normalmente los cursos de categorías ocultas';
$string['configwarning'] = 'Sea cuidadoso al modificar estos resultados (valores extraños pueden ocasionar problemas).';
$string['configyuicomboloading'] = 'Esta opción permite la optimización de carga de archivos de bibliotecas YUI. Esta opción debe estar habilitada en los centros de producción por razones de rendimiento.';
$string['confirmation'] = 'Confirmación';
$string['confirmcontextlock'] = '{$a->contextname} actualmente está descongelado. Congelarlo lo hará de solo lectura e impedirá a los usuarios hacer cambios. ¿Está seguro de querer continuar?';
$string['confirmcontextunlock'] = '{$a->contextname} actualmente está congelado. Descongelarlo permitirá a los usuarios realizar cambios. ¿Está seguro de querer continuar?';
$string['confirmdeletecomments'] = 'Está a punto de eliminar comentarios, ¿está seguro?';
$string['confirmed'] = 'Confirmado';
$string['contenttypeuninstalling'] = 'Hay {$a->count} contenidos soportados por {$a->type}. Serán eliminados. ¿Está seguro que desea continuar?';
$string['contextlockappliestoadmin'] = 'Congelar el contexto afecta a administradores';
$string['contextlockappliestoadmin_desc'] = 'Si se habilita, los administradores permanecen con acceso a cambiar a cualquier contexto que esté congelado.';
$string['contextlocking'] = 'Congelamiento de contexto';
$string['contextlocking_desc'] = 'Esta configuración le permite configurar acceso de solo lectura para  categorías, cursos, actividades o bloques seleccionados.';
$string['cookiehttponly'] = 'Sólo \'cookies\' http';
$string['cookiesecure'] = 'Sólo \'cookies\' seguras';
$string['country'] = 'País por defecto';
$string['course_customfield'] = 'Campos personalizados del curso';
$string['coursecolor'] = 'Color {$a}';
$string['coursecolorheading_desc'] = 'Cualquier curso sin imagen preestablecida en los ajustes del curso serán mostrados en la pantalla principal con una credencial estandarizada del curso. Los colores usados en el modelo se especificarán abajo.';
$string['coursecolorsettings'] = 'Colores de la credencial del curso';
$string['coursecontact'] = 'Gestores (contactos) del curso';
$string['coursecontact_desc'] = 'Esta opción le permite controlar quién aparece en la descripción del curso. Los usuarios deben tener al menos uno de estos roles en un curso a fin de poder mostrarlos en la descripción de ese curso.';
$string['coursecontactduplicates'] = 'Mostrar todos los roles de contacto del curso';
$string['coursecontactduplicates_desc'] = 'Si se habilita, los usuarios con más de uno de los roles de contacto del curso serán mostrados en la descripción del curso con cada uno de sus roles. De lo contrario, se mostrarán con solamente un rol (el que esté  listado más arriba en \'Definir roles\' en la Administración del sitio).';
$string['coursegraceperiodafter'] = 'Período de gracia para cursos pasados';
$string['coursegraceperiodbefore'] = 'Periodo de gracia para cursos futuros';
$string['courselistshortnames'] = 'Mostrar nombres extendidos del curso';
$string['courselistshortnames_desc'] = 'Si está activado, en las listas de cursos se mostrarán los nombres cortos además de los nombres largos. Si es necesario, los nombres largos de los cursos pueden personalizarse editando la cadena "courseextendednamedisplay" utilizando la función de personalización de idioma.';
$string['coursemgmt'] = 'Administrar cursos y categorías';
$string['courseoverview'] = 'Vista general del curso';
$string['courserequestnotify'] = 'Notificación de solicitud de curso';
$string['courserequestnotifyemail'] = 'El usuario {$a->user} ha solicitado un nuevo curso en {$a->link}';
$string['courserequests'] = 'Solicitudes de cursos';
$string['courserequestspending'] = 'Solicitudes de curso pendientes';
$string['courses'] = 'Cursos';
$string['coursesperpage'] = 'Cursos por página';
$string['courseswithsummarieslimit'] = 'Límite de cursos con resúmenes';
$string['creatornewroleid'] = 'Rol de los creadores en cursos nuevos';
$string['creatornewroleid_help'] = 'Si el usuario no tiene aún permiso para administrar el nuevo curso, el usuario es matriculado  automáticamente utilizando este rol.';
$string['cron'] = 'Cron';
$string['cron_help'] = 'El script de mantenimiento cron.php es requerido por algunos de los módulos de Moodle para realizar tareas de forma programada tales como enviar por correo la copia de los nuevos mensajes de los foros. Es necesario ejecutar, mediante algún mecanismo programado, la secuencia de comandos que ejecute la acción de cron.php periódicamente, lo ideal es cada 5 minutos.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Ejecución de cron sólo mediante comandos';
$string['cronerrorclionly'] = 'Lo sentimos, el acceso a esta página ha sido desactivado por el administrador.';
$string['cronerrorpassword'] = 'Lo sentimos, no ha introducido una contraseña válida para acceder a esta página';
$string['croninfrequent'] = 'Pasaron {$a->actual} entre las dos útimas ejecuciones del script cron de mantenimiento y debería ejecutarse cada {$a->expected}. Le recomendamos que lo configure para que se ejecute más frecuentemente.';
$string['cronremotepassword'] = 'Contraseña de cron para acceso remoto';
$string['cronwarning'] = 'El <a href="{$a}">script de mantenimiento del cron.php </a> no ha sido ejecutado durante las últimas 24 horas.';
$string['cronwarningcli'] = 'El script <code>admin/cli/cron.php</code> no ha sido ejecutado durante {$a->actual} y debería ejecutarse cada {$a->expected}.';
$string['cronwarningnever'] = 'El script <code>admin/cli/cron.php</code> nunca se ha ejecutado y debería ejecutarse cada {$a->expected}.';
$string['cronwarningneverweb'] = 'El script <code>admin/cron.php</code> nunca se ha ejecutado y debería ejecutarse cada {$a->expected}.';
$string['ctyperequired'] = 'Con el fin de mejorar el rendimiento del sitio y ofrecer compatibilidad multilingüe, Moodle requiere la extensión ctype de PHP.';
$string['curlcache'] = 'cURL caché TTL';
$string['curlrequired'] = 'La extensión cURL PHP ahora es requerida por Moodle con el fin de comunicarse con los repositorios de Moodle.';
$string['curlsecurityallowedport'] = 'Lista de puertos cURL autorizados';
$string['curlsecurityallowedportsyntax'] = 'Listado de número de puertos a los que cURL puede conectarse. Las entradas son únicamente numéricas. Pon cada entrada en una nueva línea. Si se deja vacío, todos los puertos están permitidos. Si está especificado, en la mayoría de casos, ambos puertos 443 y 80 deberían ser especificados para cURL para conectar a los puertos estándar de HTTPS y HTTP.';
$string['curlsecurityblockedhosts'] = 'Lista de puertos cURL bloqueados';
$string['curlsecurityblockedhostssyntax'] = 'Ponga cada entrada en una nueva línea. Son válidas las entradas de direcciones completas IPv4 o IPv6 (como por ejemplo 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) las cuales coincidan con un único host; o notación CIDR  (como por ejemplo 231.54.211.0/20 o fe80::/64); o un rango de direcciones IP (como por ejemplo 231.3.56.10-20 o fe80::1111-bbbb) donde el rango se aplica al último grupo de direcciones; o nombres de dominio (como por ejemplo localhost o ejemplo.com); o comodines de nombres de dominio (como por ejemplo *.ejemplo.com o *.sub.ejemplo.com). No se permiten líneas en blanco.';
$string['curlsecurityurlblocked'] = 'Esta URL está bloqueada.';
$string['curltimeoutkbitrate'] = 'Velocidad de transmisión a utilizar cuando se calculan los tiempos de expiración de cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Este ajuste se usa para calcular un tiempo de expiración apropiado para las solicitudes cURL grandes. Como parte del cálculo se hace una petición HTTP HEAD para determinar el tamaño del contenido. Ajustar este valor a 0 deshabilita que se haga esta solicitud.';
$string['currenttheme'] = 'Tema actual';
$string['customcheck'] = 'Otras comprobaciones';
$string['custommenu'] = 'Menú personalizado';
$string['custommenuitems'] = 'Ítems del menú personalizado';
$string['customusermenuitems'] = 'Items del menú de usuario';
$string['datarootsecurityerror'] = '<p><strong>¡ADVERTENCIA DE SEGURIDAD!</strong></p><p>Su directorio dataroot está en una ubicación errónea y está expuesto a la web. Esto significa que cualquiera desde cualquier lugar puede acceder a todos sus archivos privados y que algunos de ellos podrían ser usados por un cracker para obtener acceso no autorizado al sitio.</p>
<p><em>Debe</em> cambiar el directorio dataroot ({$a}) a una nueva ubicación fuera de su directorio web público y actualizar el correspondiente ajuste de <code>$CFG->dataroot</code> en su config.php.</p>';
$string['datarootsecuritywarning'] = 'La configuración de su sitio podría no ser segura. Por favor, asegúrese de que su directorio raíz ({$a}) no es accesible directamente vía web.';
$string['dbprefixtoolong'] = 'El prefijo de su sitio ($CFG->prefix) es demasiado largo ({$a->current} caracteres). El número máximo de caracteres permitidos es {$a->maximum}.';
$string['dbsessions'] = 'Usar la base de datos para información de la sesión';
$string['debug'] = 'Mensajes de depuración';
$string['debugall'] = 'TODOS: Mostrar todos los mensajes de depuración PHP';
$string['debugdeveloper'] = 'DESARROLLADOR: mensajes extra de depuración Moodle para desarrolladores';
$string['debugdisplay'] = 'Mostrar mensajes de depuración';
$string['debugging'] = 'Depuración (debugging)';
$string['debugminimal'] = 'MÍNIMO: Mostrar solamente errores fatales';
$string['debugnone'] = 'NINGUNO: No mostrar errores ni avisos';
$string['debugnormal'] = 'NORMAL: Mostrar errores, avisos y noticias';
$string['debugpageinfo'] = 'Mostrar información de la página';
$string['debugstringids'] = 'Mostrar el origen de las cadenas de idiomas';
$string['debugstringids_desc'] = 'Esta opción está diseñada para ayudar a los traductores. Cuando esta opción está activada, si se agrega el parámetro strings = 1 para una petición de URL, se mostrará el archivo de idioma y el identificador de cadena al lado de cada cadena que se emite.';
$string['debugvalidators'] = 'Mostrar enlaces de validación';
$string['defaultcity'] = 'Ciudad por defecto';
$string['defaultcity_help'] = 'La ciudad introducida aquí será la ciudad por defecto al crear nuevas cuentas de usuario.';
$string['defaultformatnotset'] = 'Error para determinar el formato del curso por defecto. Compruebe la configuración del sitio.';
$string['defaulthomepage'] = 'Página de inicio predeterminada para los usuarios';
$string['defaultrequestcategory'] = 'Categoría por defecto de las solicitudes de curso';
$string['defaultsettinginfo'] = 'Valor por defecto: {$a}';
$string['defaultuserroleid'] = 'Rol por defecto de todos los usuarios';
$string['deleteincompleteusers'] = 'Eliminar usuarios incompletos después de';
$string['deleteunconfirmed'] = 'Eliminar usuarios no confirmados después de';
$string['deleteuser'] = 'Eliminar usuario';
$string['density'] = 'Densidad';
$string['denyemailaddresses'] = 'Dominios de correo electrónico denegados';
$string['development'] = 'Desarrollo';
$string['devicedetectregex'] = 'Expresiones regulares para la detección de dispositivos';
$string['devicedetectregex_desc'] = '<p>Por defecto Moodle puede detectar dispositivos del tipo \'por defecto\' (PC de escritorio, PC portátil, etc.) dispositivos móviles (teléfonos y pequeños dispositivos como PDAs), tabletas (iPads, tabletas Android) y \'heredados\' (usuarios de Internet Explorer 6). Se puede usar el selector de temas para aplicar temas diferentes a cada uno de ellos. Este ajuste admite expresiones regulares que permiten detectar tipos de dispositivos extra (éstos tienen precedencia sobre los tipos por defecto).</p><p>Por ejemplo, podría introducir la expresión regular \'/(MIDP-1.0|Maemo|Windows CE)/\' para detectar algunos teléfonos usados habitualmente con determinada característica y añadir el valor \'telefonocaracteristica\'. Esto añade \'telefonocaracteristica\' en el selector de temas, lo que permite añadir un tema para usarse con estos dispositivos. El resto de teléfonos seguirán usando el tema seleccionado para los tipos de dispositivos móviles.</p>';
$string['devicedetectregexexpression'] = 'Expresión regular';
$string['devicedetectregexvalue'] = 'Valor devuelto';
$string['devicetype'] = 'Tipo de dispositivo';
$string['devlibdirpresent'] = 'Los directorios con bibliotecas de desarrollo, especialmente <em>/vendor</em> y <em>/node_modules</em>, no deben estar presentes en sitios públicos. Vea el <a href="{$a->moreinfourl}">informe general de seguridad</a> para más detalles.';
$string['disabled'] = 'Deshabilitado';
$string['disableuserimages'] = 'Desactivar imágenes en el perfil del usuario';
$string['displayerrorswarning'] = 'No se recomienda habilitar el ajuste PHP <em>display_errors</em> en sitios en producción debido a que algunos mensajes de error pueden revelar información sensible sobre su servidor.';
$string['displayloginfailures'] = 'Mostrar intentos de identificación  fallidos';
$string['dndallowtextandlinks'] = 'Subir texto/enlaces mediante "Arrastrar y Soltar"';
$string['doclang'] = 'Idioma de los documentos';
$string['docroot'] = 'Raíz de Moodle Docs';
$string['doctonewwindow'] = 'Abrir en nueva ventana';
$string['doesnotfit'] = 'Configuraciones de como mostrar correo electrónico.';
$string['doesnotfitdetail'] = 'Mostrar configuraciones para el correo electrónico de salida del Moodle.';
$string['download'] = 'Descargar';
$string['durationunits'] = 'unidades de duración';
$string['edithelpdocs'] = 'Editar documentos de ayuda';
$string['editlang'] = '<b>Edición</b>';
$string['editorbackgroundcolor'] = 'Color de fondo';
$string['editordictionary'] = 'Diccionario del editor';
$string['editorfontfamily'] = 'Familia de fuentes';
$string['editorfontlist'] = 'Lista de fuentes';
$string['editorfontsize'] = 'Tamaño de la fuente por defecto';
$string['editorhidebuttons'] = 'Botones ocultos';
$string['editorkillword'] = 'Filtro formato Word';
$string['editorspelling'] = 'Corrector del editor';
$string['editorspellinghelp'] = 'Activar o desactivar corrector de ortografía. Cuando está activado, el <strong>aspell</strong> debe estar instalado en el servidor.';
$string['editstrings'] = 'Editar palabras o frases';
$string['emailchangeconfirmation'] = 'Confirmación de cambio de email';
$string['emailfromvia'] = 'Información de origen en el asunto';
$string['emailsubjectprefix'] = 'Prefijo del asunto del correo electrónico';
$string['emoticonalt'] = 'Texto alternativo';
$string['emoticoncomponent'] = 'Componente de imagen';
$string['emoticonimagename'] = 'Nombre de la imagen';
$string['emoticons'] = 'Emoticones';
$string['emoticons_desc'] = 'Este formulario define los \'emoticons\' (o iconos gestuales o \'caritas\') usados en su sitio. Para eliminar una fila de la tabla, guarde el formulario con un valor vacío en cualquiera de los campos obligatorios. Para registrar un nuevo \'emoticon\', rellene los campos de la última fila en blanco. Para restablecer todos los campos en los valores predeterminados, siga el enlace de arriba.
* Texto (obligatorio) - Este texto será reemplazado por la imagen de icono gestual. Debe haber al menos dos caracteres de longitud.
* Nombre de la imagen (obligatorio) - El nombre del fichero de imagen del  icono gestual sin la extensión, como en la carpeta de componentes pix.
* Componente de imagen (obligatorio) - El componente que proporciona el icono.
* Texto alternativo (opcional) - identificador de cadena y los componentes del texto alternativo de los iconos gestuales.';
$string['emoticonsreset'] = 'Reconfigurar los emoticonos a los valores predeterminados';
$string['emoticontext'] = 'Texto';
$string['emptysettingvalue'] = 'Vacío';
$string['enableactivitychooser'] = 'Habilitar selector de actividad';
$string['enableanalytics'] = 'Analítica';
$string['enableblogs'] = 'Habilitar blogs';
$string['enablecalendarexport'] = 'Habilitar exportación de calendario';
$string['enablecomments'] = 'Habilitar comentarios';
$string['enablecourserelativedates'] = 'Habilitar fechas de curso relativas';
$string['enablecourserelativedates_desc'] = 'Permitir a los cursos ser configurados para mostrar fechas relativas a la fecha de inicio del usuario dentro del curso.';
$string['enablecourserequests'] = 'Habilitar solicitudes de curso';
$string['enabled'] = 'Habilitado';
$string['enabledevicedetection'] = 'Habilitar detección de dispositivos';
$string['enableglobalsearch'] = 'Habilitar búsqueda global';
$string['enableglobalsearch_desc'] = 'Si se habilita, los datos serán indexados y sincronizados por una tarea programada.';
$string['enablegravatar'] = 'Activar Gravatar';
$string['enablegravatar_help'] = 'Cuando se habilita Moodle intentará buscar una imagen de perfil de usuario desde Gravatar si el usuario no ha subido una imagen';
$string['enablemobilewebservice'] = 'Habilitar servicio web para dispositivos móviles';
$string['enablerecordcache'] = 'Habilitar caché de registro';
$string['enablerssfeeds'] = 'Habilitar canales RSS';
$string['enablesearchareas'] = 'Habilitar áreas de búsqueda';
$string['enablestats'] = 'Habilitar estadísticas';
$string['enabletrusttext'] = 'Habilitar contenido confiable';
$string['enableuserfeedback'] = 'Habilitar el envío de comentarios sobre este software';
$string['enableuserfeedback_desc'] = 'Si está habilitado, se muestra un enlace \'Dar comentarios sobre este software\' en el pie de página para que los usuarios envíen comentarios sobre el software Moodle a Moodle HQ. Si se establece la opción \'Siguiente recordatorio de comentarios\', al usuario también se le muestra un recordatorio en el Panel de control en el intervalo especificado. Si configura "Siguiente recordatorio de comentarios" en "Nunca", se deshabilita el recordatorio del panel, mientras que deja el enlace "Enviar comentarios sobre este software" en el pie de página.';
$string['enablewebservices'] = 'Habilitar servicios web';
$string['enablewsdocumentation'] = 'Documentación de servicios web';
$string['enrolinstancedefaults'] = 'Valores por defecto de la matriculacion';
$string['enrolinstancedefaults_desc'] = 'Ajustes predeterminados de matriculación en nuevos cursos.';
$string['enrolmultipleusers'] = 'Matricular a los usuarios';
$string['environment'] = 'Entorno';
$string['environmenterrortodo'] = 'Debe resolver todos los problemas de entorno (errores) encontrados arriba antes de proceder a instalar esta versión de Moodle';
$string['environmenterrorupgrade'] = 'Advertencia: ¡Debería resolver todos los problemas de entorno (errores) encontrados antes de proceder con la actualización de esta versión de Moodle! Actualizar sin arreglar estos requerimientos podría causar problemas como pérdida de datos. ¿Está seguro que desea continuar con la actualización?';
$string['environmentmariadbwrongdbtype'] = '<code>$CFG->dbtype</code> erróneo: debe de cambiarlo en su fichero <code>config.php</code>,  desde \'<code>mysql</code>\' a \'<code>mariadb</code>\'.';
$string['environmentmustfixsetting'] = 'El ajuste PHP debe cambiarse.';
$string['environmentok'] = 'Su entorno de servidor cumple todos los requerimientos mínimos.';
$string['environmentrecommendcustomcheck'] = 'Si esta comprobación falla, ello indica un problema potencial';
$string['environmentrecommendinstall'] = 'debería estar instalado y activado para conseguir los mejores resultados';
$string['environmentrecommendversion'] = 'versión {$a->needed} es recomendada y está ejecutando {$a->current}';
$string['environmentrequirecustomcheck'] = 'esta prueba debe pasar';
$string['environmentrequireinstall'] = 'debe estar instalado/activado';
$string['environmentrequireversion'] = 'versión {$a->needed} es obligatoria y está ejecutando {$a->current}';
$string['environmentsettingok'] = 'detectado ajuste recomendado';
$string['environmentshouldfixsetting'] = 'El ajuste PHP debe cambiarse.';
$string['environmentxmlerror'] = 'Error leyendo la información sobre el entorno ({$a->error_code})';
$string['errordeletingconfig'] = 'Ha ocurrido un error al eliminar los registros de configuración del plugin \'{$a}\'.';
$string['errorsetting'] = 'No pudo guardarse el ajuste:';
$string['errorwithsettings'] = 'Algunos ajustes no se han cambiado debido a un error:';
$string['eventshandlersinuse'] = 'Los siguientes plugins de tu sistema están usando manejadores obsoletos para la API Events 1: \'{$a}\'. Por favor, actualízalos para utilizar la API Events 2. Consulta https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Todos los que puedan \'{$a}\'';
$string['exceptions'] = 'excepciones';
$string['execpathnotallowed'] = 'La configuración de rutas locales y rutas hacia ejecutables está deshabilitada en config.php';
$string['experimental'] = 'Experimental';
$string['experimentalsettings'] = 'Experimental';
$string['extendedusernamechars'] = 'Permitir caracteres extendidos en nombres de usuario';
$string['extramemorylimit'] = 'Límite de memoria de PHP extra';
$string['fatalsessionautostart'] = '<p>Se ha detectado un error de configuración grave; por favor notifique al administrador del servidor. </p><p>Para que funcione correctamente, Moodle requiere que el administrador cambie la configuración de PHP. </p><p> <code> session.auto_start </code> debe establecerse en <code>off </code>. </p> <p>Esta configuración se controla editando <code> php.ini </code>, la configuración de Apache/IIS <br /> o el fichero <code>. htaccess </code> en el servidor. </p>';
$string['feedbacksettings'] = 'Configuración de la encuesta externa';
$string['fileconversioncleanuptask'] = 'Limpieza de archivos temporales para conversiones de archivos.';
$string['filecreated'] = 'Creado nuevo archivo';
$string['filescleanupperiod'] = 'Limpiar archivos de basura';
$string['filescleanupperiod_help'] = 'Con qué frecuencia se eliminan los archivos de la papelera de basura. Estos son archivos que están asociados con un contexto que ya no existe, por ejemplo, cuando se elimina un curso. Tenga en cuenta: esta configuración puede resultar en la pérdida de archivos en un curso que se respalda, borra y luego restaura si la configuración \'Incluir archivos\' (backup_auto_files) en \'Configuración de copia de seguridad automatizada\' está deshabilitada.';
$string['filesizeunits'] = 'unidades de tamaño de archivos';
$string['filestoredin'] = 'Guardar archivo en la carpeta:';
$string['filestoredinhelp'] = 'Dónde se almacenará el archivo';
$string['filterall'] = 'Filtrar todas las cadenas';
$string['filtermatchoneperpage'] = 'Filtrar una coincidencia por página';
$string['filtermatchonepertext'] = 'Filtrar una coincidencia por texto';
$string['filters'] = 'Filtros';
$string['filtersettings'] = 'Gestionar filtros';
$string['filtersettingsgeneral'] = 'Ajustes generales de filtro';
$string['filteruploadedfiles'] = 'Filtrar archivos subidos';
$string['forceclean'] = 'Limpieza de contenido en todos lados';
$string['forceclean_desc'] = 'El contenido añadido al sitio normalmente es limpiado antes de ser mostrado, para quitarle todo lo que podría ser un riesgo de seguridad. Sin embargo, el contenido no es limpiado en ciertos lugares, como las descripciones de actividad, recursos o Bloques HTML, para permitir que sean añadidos scripts, medios, marcos en línea, etc. Si esta configuración es habilitada, TODO el contenido será limpiado. Esto podría provocar que parte del contenido existente ya no se muestre correctamente.';
$string['forcelogin'] = 'Forzar a los usuarios a iniciar sesión';
$string['forceloginforprofileimage'] = 'Forzar a los usuarios a identificarse para ver los avatares de los usuario';
$string['forceloginforprofileimage_help'] = 'Si está habilitado, los usuarios deben identificarse para ver las imágenes de perfil de usuarios.  La imagen de usuario predefinida se utilizará en todos las notificaciones electrónicas.';
$string['forceloginforprofiles'] = 'Forzar a los usuarios a iniciar sesión para ver los perfiles';
$string['forcetimezone'] = 'Forzar zona horaria';
$string['formatuninstallwithcourses'] = 'Hay {$a->count} cursos que usan {$a->format}. Sus formatos serán cambiados a {$a->defaultformat} (el formato por defecto para este sitio). Algunos datos específicos de este formato se pueden perder. ¿Está usted seguro de querer hacerlo?';
$string['frontpage'] = 'Página Principal';
$string['frontpagebackup'] = 'Copia de seguridad de la página principal';
$string['frontpagedefaultrole'] = 'Rol por defecto en la página principal';
$string['frontpagefilters'] = 'Filtros de la página principal';
$string['frontpageloggedin'] = 'Elementos de la página principal al entrar al sitio';
$string['frontpageoverrides'] = 'Anulaciones de permisos en la página principal';
$string['frontpagequestions'] = 'Preguntas de la página principal';
$string['frontpagerestore'] = 'Restauración de la página principal';
$string['frontpageroles'] = 'Roles de la página principal';
$string['frontpagesettings'] = 'Ajustes de la página principal';
$string['fullnamedisplay'] = 'Formato de nombre completo';
$string['fullnamedisplayprivate'] = 'Formato del nombre completo - privado';
$string['gdrequired'] = 'La extensión GD es requerida por Moodle para la conversión de imágenes.';
$string['generalsettings'] = 'Ajustes generales';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Fuente de direcciones IP registradas';
$string['globalsearch'] = 'Búsqueda global';
$string['globalsearchmanage'] = 'Administrar búsqueda global';
$string['googlemapkey3'] = 'Clave API V3 de Google Maps';
$string['googlemapkey3_help'] = 'Necesita introducir una clave especial para utilizar Google Maps para visualizar la búsqueda de la dirección IP. Puede obtener dicha clave gratuitamente en <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Ir a la primera cadena ausente';
$string['gradebook'] = 'Libro de calificaciones';
$string['gradebookroles'] = 'Roles calificados';
$string['gradeexport'] = 'Principales métodos de exportación de calificaciones';
$string['gravatardefaulturl'] = 'URL para imagen por defecto de Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar necesita una imagen por defecto para utilizar en caso de que no se pueda localizar la imagen de un determinado usuario. Si dejas esta opción vacía, Moodle intentará usar la imagen por defecto más adecuada para la página que estés viendo. Ten en cuenta que Gravatar dispone de una serie de parámetros que pueden ser usados para <a href="https://es.gravatar.com/site/implement/images/#default-image">generar imágenes por defecto</a>.';
$string['groupenrolmentkeypolicy'] = 'Política de matriculación de grupos';
$string['groupenrolmentkeypolicy_desc'] = 'Si está habilitado, las claves de inscripción de grupo se compararán con la política de contraseñas como se especifica en la configuración anterior.';
$string['guestroleid'] = 'Rol para invitado';
$string['guestroleid_help'] = 'Este rol se le asigna automáticamente a los invitados. También se asigna, temporalmente, por medio del plugin de matriculación de invitados a los usuarios que no están inscritos en un curso.';
$string['h5pgetcontenttypestask'] = 'Descargar tipos de contenido disponibles desde h5p.org';
$string['helpadminseesall'] = 'En el calendario del sitio, ¿los administradores ven y filtran eventos de todos los calendarios de cursos o solo de los cursos en los que están inscritos? Independientemente de la opción elegida, los administradores siempre podrán administrar los eventos para cada calendario de cursos navegando primero al curso y luego accediendo directamente al calendario de cursos.';
$string['helpcalendarcustomexport'] = 'Habilitar la opción de periodo personalizado en las exportaciones del calendario. Las opciones de exportación del calendario deben estar activas para que sea efectivo.';
$string['helpexportlookahead'] = '¿Cuántos días hacia delante buscará el calendario de eventos durante la exportación en la opción de exportación personalizada?';
$string['helpexportlookback'] = '¿Cuántos días hacia atrás buscará el calendario de eventos durante la exportación en la opción de exportación personalizada?';
$string['helpforcetimezone'] = 'Puede permitir que los usuarios seleccionen su zona horaria, o forzarla para todos.';
$string['helpshowicalsource'] = 'Si está habilitado, se mostrará el nombre de la suscripción y el enlace de los eventos iCal-importados.';
$string['helpsitemaintenance'] = 'Para actualizaciones y otras tareas. Si se habilita, su sitio Moodle sólo será accesible para los administradores.';
$string['helpstartofweek'] = '¿Qué día comienza la semana?';
$string['helpupcominglookahead'] = '¿Cuántos días debe considerar el calendario por defecto para eventos próximos?';
$string['helpupcomingmaxevents'] = '¿Cuántos eventos próximos se mostrarán como máximo a los usuarios?';
$string['helpweekenddays'] = '¿Cuántos días de la semana se considerarán como \'fin de semana\' y se mostrarán con un color diferente?';
$string['hiddenuserfields'] = 'Ocultar campos de usuario';
$string['hidefromall'] = 'Ocultar a todos los usuarios';
$string['hidefromnone'] = 'No ocultar a nadie';
$string['hidefromstudents'] = 'Ocultar a estudiantes';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Ajustes del editor HTML';
$string['htmlsettings'] = 'Ajustes HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Seguridad HTTP';
$string['iconvrequired'] = 'Es necesario instalar la extensión ICONV';
$string['igbinary322buggyversion'] = 'La extensión php-igbinary instalada en el sitio puede ocasionar problemas cuando se ejecuta con PHP 7.2. Se recomienda actualizar a php-igbinary 3.2.5 o posterior, o alternativamente actualizar a PHP 7.3 o posterior.';
$string['ignore'] = 'Ignorar';
$string['includemoduleuserdata'] = 'Incluir datos del usuario del módulo';
$string['incompatibleblocks'] = 'Bloques imcompatibles';
$string['incompleteunicodesupport'] = 'La configuración actual de MySQL o MariaDB está usando \'utf8\'. Este set de caracteres no soporta caracteres de 4 byte los cuales incluyen algunos emoji. Si intenta usar esos caracteres finalizará con un error al actualizar una fila, y toda la información que esté siendo enviada a la base de datos se perderá. Por favor considere cambiar la configuración a \'utf8mb4\'. Mire la documentación para más información.';
$string['indexdata'] = 'Indexar datos';
$string['indexinginfo'] = 'La forma recomendada para indexar el contenido de tu sitio es utilizar la tarea programada "Indexación de búsqueda global".';
$string['installhijacked'] = 'La instalación debe finalizarse desde la misma dirección IP original';
$string['installsessionerror'] = 'No se puede inicializar la sesión PHP. Verifique que su navegador acepta cookies.';
$string['intlrecommended'] = 'La extensión internacional se utiliza para mejorar el soporte a la internacionalización, como en el caso de la ordenación de localidades.';
$string['intlrequired'] = 'La extensión Intl es necesaria para mejorar el soporte de internacionalización, como la clasificación local y los dominios internacionales.';
$string['invalidagedigitalconsent'] = 'La edad de consentimiento digital no es válida: {$a}';
$string['invalidforgottenpasswordurl'] = 'La URL de contraseña olvidada no es una URL válida.';
$string['invalidsection'] = 'Sección no válida.';
$string['invalidthemepreset'] = 'La opción seleccionada no es compatible con este tema. El error de compilación de SCSS fue: "{$a}"';
$string['invaliduserchangeme'] = 'El nombre de usuario "changeme" es reservado: no puede crear una cuenta con ese nombre.';
$string['ipblocked'] = 'Actualmente este sitio no está disponible.';
$string['ipblocker'] = 'Bloqueador de IP';
$string['ipblockersyntax'] = 'Ponga cada entrada en una línea. Las entradas válidas son la dirección IP completa (como <b>192.168.10.1</b>) que coincide con un solo host; o dirección parcial (como <b>192.168</b>) que coincida con cualquier dirección que comience con esos números; o notación CIDR (como <b>231.54.211.0/20</b>); o un rango de direcciones IP (como <b>231.3.56.10-20</b>) donde el rango se aplica a la última parte de la dirección. Los nombres de dominio de texto (como \'ejemplo.com\') no son compatibles. Las líneas en blanco y el texto que sigue al carácter "#" se ignoran.';
$string['iplookup'] = 'Búsqueda de dirección IP';
$string['iplookupgeoplugin'] = 'El servicio <a href="https://www.geoplugin.com">geoPlugin</a> se emplea actualmente para buscar información geográfica. Para tener resultados más exactos le recomendamos instalar una copia local de la base de datos MaxMind GeoLite.';
$string['iplookupinfo'] = 'Por defecto Moodle utiliza el servidor gratuito en línea NetGeo (The Internet Geographic Database) para buscar la ubicación de las direcciones IP. Desafortunadamente, ha cesado el mantenimiento de esta base de datos, y puede devolver información <em>totalmente errónea</em>.
Se recomienda instalar una copia local de la base de datos GeoLite2 City, desde MaxMind.<br />
La ubicación de la dirección IP se muestra en un mapa simple, o usando Google Maps. Para activar los mapas interactivos necesita tener una cuenta Google y aplicar la clave API de Google Maps.';
$string['iplookupmaxmindnote'] = 'Este producto incluye datos de GeoLite2 creado por MaxMind, disponible en <a href="https://www.maxmind.com">https://www.maxmind.com</a>.';
$string['iscustomadminwarnings'] = 'Se ha detectado que su sitio está utilizando un directorio de administración personalizado. Esta característica ya no es compatible y se eliminará después de Moodle 4.2.';
$string['ishttpswarning'] = 'Se ha detectado que su sitio no se comunica a través de HTTPS. Se recomienda migrar su sitio a HTTPS para incrementar la seguridad y mejorar la integración con otros sistemas.';
$string['keeptagnamecase'] = 'Mantener minús/MAYÚS de nombre de marca';
$string['lang'] = 'Idioma por defecto';
$string['langcache'] = 'Guardar en caché el menú de idioma';
$string['langcache_desc'] = 'Cachear el menú de idiomas. Si se habilita, la lista de idiomas disponibles se cachea. La caché se refresca automáticamente cuando se instala o elimina un paquete de idioma por medio de la herramienta de gestión de paquetes de idiomas incorporada. Si instala un paquete de idioma manualmente, deberá usar la característica "Purgar todas las cachés" para refrescar la lista cacheada.';
$string['langlist'] = 'Idiomas en el menú de idioma';
$string['langmenu'] = 'Mostrar menú de idioma';
$string['langmenuinsecurelayout'] = 'Mostrar menú de idioma en capa segura';
$string['langmenuinsecurelayout_desc'] = 'Si está habilitado, un usuario podrá cambiar su idioma cuando intente un cuestionario u otra actividad usando un diseño seguro.';
$string['langpackwillbeupdated'] = 'NOTA: Moodle intentará descargar actualizaciones para sus paquetes de idioma durante la actualización.';
$string['langstringcache'] = 'Guardar en caché todas las cadenas del idioma';
$string['languagesettings'] = 'Ajustes de idioma';
$string['latinexcelexport'] = 'Codificación Excel';
$string['legacyfilesaddallowed'] = 'Permitir añadir a archivos de curso heredados';
$string['legacyfilesaddallowed_help'] = 'Si un curso tiene archivos de curso heredados, permitir agregarle nuevos archivos y carpeta';
$string['legacyfilesinnewcourses'] = 'Archivos heredados en los cursos nuevos';
$string['legacyfilesinnewcourses_help'] = 'De forma predeterminada, los archivos heredados solo están disponibles en los cursos actualizados desde versiones anteriores de Moodle (1.9.x a 2.0 por ejemplo). Tenga en cuenta que algunas características como la copia de seguridad y la restauración no son compatibles con esta configuración.';
$string['libcurlwarning'] = 'Se ha detectado que libcurl no tiene el soporte para CURLOPT_PROTOCOL. Se recomienda una actualización de libcurl a la última versión por motivos de seguridad.';
$string['licensesettings'] = 'Configuración de licencias';
$string['linkadmincategories'] = 'Enlace al administrador de categorías';
$string['linkadmincategories_help'] = 'Si se habilita, los parámetros de configuación de las categorías se mostrarán como enlaces en la barra de navegación y cargarán a las páginas de la categoría.';
$string['linkcoursesections'] = 'Enlazar siempre las secciones de los cursos';
$string['linkcoursesections_help'] = 'Intenta proporcionar siempre un enlace a la secciones de los cursos. Las secciones de los cursos son mostradas normalmente como enlaces si el formato del curso muestra una sección por página. Si este ajuste está habilitado se mostrará siempre un enlace.';
$string['loading'] = 'Cargando';
$string['localetext'] = '\'Locale\' del sitio';
$string['localstringcustomization'] = 'Personalización local del idioma';
$string['location'] = 'Ubicación';
$string['locationsettings'] = 'Ajustes de ubicación';
$string['locked'] = 'Bloqueado';
$string['lockoutduration'] = 'Tiempo de duración del bloqueo';
$string['lockoutduration_desc'] = 'La cuenta bloqueada se desbloquea automáticamente después de esta tiempo.';
$string['lockoutemailbody'] = 'Su cuenta de usuario {$a->username} en el sitio \'{$a->sitename}\' ha sido bloqueada tras múltiples intentos de acceso no válidos.

Para desbloquear la cuenta de forma inmediata pulse en el siguiente enlace

{$a->link}

En la mayoría de programas de correo aparecerá como un enlace en azul sobre el que puede pulsar. Si no funciona, simplemente copie el texto del enlace y péguelo en la barra de direcciones de la parte superior de su navegador web.

Si necesita ayuda, por favor contacte con el administrador del sitio, {$a->admin}';
$string['lockoutemailsubject'] = 'Su cuenta en {$a} fue bloqueada';
$string['lockouterrorunlock'] = 'Suministrada información no válida de bloqueo de cuenta.';
$string['lockoutthreshold'] = 'Umbral de bloqueo de la cuenta';
$string['lockoutthreshold_desc'] = 'Seleccione el número de intentos de conexión fallidos que dan como resultado el bloqueo de la cuenta. Esta característica puede ser objeto de abuso en ataques de denegación de servicio.';
$string['lockoutwindow'] = 'Ventana de observación de cuenta bloqueada';
$string['lockoutwindow_desc'] = 'Tiempo de observación para el umbral de bloqueo, si no hay intentos fallidos el contador se restablece después de este tiempo.';
$string['lockrequestcategory'] = 'Prevenir selección de categoría';
$string['log'] = 'Registros';
$string['logguests'] = 'Registro del acceso de invitados';
$string['logguests_help'] = 'Esta configuración habilita el registro de acciones para cuentas de invitados o usuarios no registrados. En determinados sitios se podría desactivar esta opción por razones de rendimiento. Se recomienda mantener esta opción habilitada en los sitios en producción.';
$string['logininfoinsecurelayout'] = 'Mostrar el usuario que inició sesión en un diseño seguro';
$string['logininfoinsecurelayout_desc'] = 'Si está habilitado, el nombre completo del usuario que inició sesión se mostrará en la barra de navegación cuando intente realizar un cuestionario u otra actividad utilizando un diseño seguro.';
$string['loginpageautofocus'] = 'Formulario de página de enfoque automático de inicio de sesión';
$string['loginpageautofocus_help'] = 'Al activar esta opción se mejora la usabilidad de la página de identificación de usuario, pero el enfoque automático de campos puede ser considerado como un problema de accesibilidad.';
$string['loglifetime'] = 'Mantener registros para';
$string['logo'] = 'Logotipo';
$string['logo_desc'] = 'Un logotipo completo que se usará como decoración por algunos temas (como por ejemplo, los temas del núcleo de Moodle). Esta imagen puede ser de bastante alta resolución porque será escalada para usarse (y será cacheada para un mejor desempeño). Los logos que son más anchos que altos usualmente dan mejores resultados. Los formatos aceptados son PNG y JPG.';
$string['logocompact'] = 'Logotipo compacto';
$string['logocompact_desc'] = 'Una versión compacta del mismo logotipo de arriba, como por ejemplo, un emblema, escudo o icono. La imagen debe de ser clara, aun en tamaños pequeños. Los formatos aceptados son PNG y JPEG.';
$string['logossettings'] = 'Logotipos';
$string['logstorenotrequired'] = 'Almacén de registro no obligatorio';
$string['logstoressupported'] = 'Almacenes de registro que dan soporte a este informe';
$string['longtimewarning'] = '<b>Por favor, tenga en cuenta que este proceso puede durar mucho.</b>';
$string['mailnewline'] = 'Caracteres de línea nueva en correo electrónico';
$string['maintenancemode'] = 'En Modo Mantenimiento';
$string['maintenancemodeisscheduled'] = 'Este sitio entrará en modo mantenimiento en {$a->min} minutos y {$a->sec} segundos';
$string['maintenancemodeisscheduledlong'] = 'Este sitio será puesto en modo mantenimiento en {$a->hour} horas {$a->min} minutos {$a->sec} segundos';
$string['maintfileopenerror'] = '¡Error al abrir los archivos de mantenimiento!';
$string['maintinprogress'] = 'Mantenimiento en curso...';
$string['managecontextlock'] = 'Congelar este contexto';
$string['managecontextlocklocked'] = '{$a->contextname} y todos los contextos inferiores están ahora congelados.';
$string['managecontextlockunlocked'] = '{$a->contextname} y todos los contextos inferiores están ahora descongelados.';
$string['managecontextunlock'] = 'Descongelar este contexto';
$string['managecustomfields'] = 'Administrar tipos de campos personalizados';
$string['manageformats'] = 'Gestionar formatos de curso';
$string['manageformatsgotosettings'] = 'El formato por defecto puede cambiarse en {$a}';
$string['managelang'] = 'Administrar';
$string['managelicenses'] = 'Administrar licencias';
$string['manageqbehaviours'] = 'Gestionar comportamientos de preguntas.';
$string['manageqtypes'] = 'Administrar tipos de preguntas';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Candidato a versión final';
$string['maturity200'] = 'Versión estable';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Sugerencia: Es posible que desee ejecutar este script con la opción - "allow-inestable"';
$string['maturitycoreinfo'] = 'Su sitio está actualmente en código de desarrollo "{$a}" y podría ser inestable.';
$string['maturitycorewarning'] = 'La versión de Moodle que usted va a instalar o actualizar contiene código de desarrollo "{$a}" que no es adecuada para usarse en la mayoría de los sitios de producción. Si no es esto lo que desea entonces debería asegurarse de que instala o actualiza una versión de una rama "STABLE" del código de Moodle. Vea Moodle Docs para más detalles.';
$string['maxbytes'] = 'Tamaño máximo del archivo subido';
$string['maxconsecutiveidentchars'] = 'Caracteres consecutivos idénticos';
$string['maxeditingtime'] = 'Tiempo máximo para editar mensajes';
$string['maxtimelimit'] = 'Límite de tiempo máximo';
$string['maxtimelimit_desc'] = 'Para restringir el tiempo máximo de ejecución de PHP que Moodle permitirá sin que se muestre ninguna salida, introduzca aquí un valor en segundos. 0 significa que se utilizan restricciones predeterminadas de Moodle. Si dispone de un servidor front-end con su propio límite de tiempo, establezca este valor más bajo para recibir errores de PHP en los logs. No se aplica a los scripts de CLI.';
$string['maxusersperpage'] = 'Número máximo de usuarios por página';
$string['mbstringrecommended'] = 'La instalación de la librería opcional MBSTRING es muy recomendable para mejorar el rendimiento del sitio, especialmente si su sitio está soportando idiomas no latinos.';
$string['mediapluginavi'] = 'Habilitar filtro .avi';
$string['mediapluginflv'] = 'Habilitar filtro .flv';
$string['mediapluginimg'] = 'Habilitar la inserción automática de imágenes';
$string['mediapluginmov'] = 'Habilitar filtro .mov';
$string['mediapluginmp3'] = 'Habilitar filtro .mp3';
$string['mediapluginmpg'] = 'Habilitar filtro .mpg';
$string['mediapluginogg'] = 'Habilitar el filtro .ogg';
$string['mediapluginogv'] = 'Habilitar el filtro .ogv';
$string['mediapluginram'] = 'Habilitar filtro .ram';
$string['mediapluginrm'] = 'Habilitar filtro .rm';
$string['mediapluginrpm'] = 'Habilitar filtro .rpm';
$string['mediapluginswf'] = 'Habilitar filtro .swf';
$string['mediapluginswfnote'] = 'Como medida de seguridad por defecto, no se permite a los usuarios incrustar archivos flash swf.';
$string['mediapluginwmv'] = 'Habilitar filtro .wmv';
$string['mediapluginyoutube'] = 'Habilitar el filtro de enlaces de YouTube';
$string['messaging'] = 'Habilitar sistema de mensajería';
$string['messagingallowemailoverride'] = 'Anulación de correo de notificación';
$string['messagingallusers'] = 'Permitir mensajería para todo el sitio';
$string['messagingcategory'] = 'Mensajería';
$string['messagingdefaultpressenter'] = 'Usar Intro para enviar, habilitado por defecto';
$string['messagingdeleteallnotificationsdelay'] = 'Eliminar todas las notificaciones';
$string['messagingdeletereadnotificationsdelay'] = 'Eliminar las notificaciones ya leídas';
$string['messagingssettings'] = 'Ajustes de mensajería';
$string['minpassworddigits'] = 'Dígitos';
$string['minpasswordlength'] = 'Longitud de la contraseña';
$string['minpasswordlower'] = 'Minúsculas';
$string['minpasswordnonalphanum'] = 'Caracteres no alfanuméricos';
$string['minpasswordupper'] = 'Mayúsculas';
$string['misc'] = 'Varios';
$string['mnetrestore_extusers'] = 'Esta copia de seguridad contiene cuentas de usuario de red Moodle remotas las cuales serán recuperadas como parte del proceso.';
$string['mnetrestore_extusers_admin'] = '<strong> Nota: </strong> Este archivo de copia de seguridad parece venir de otro de instalación de Moodle y contiene cuentas de usuario de Moodle Network. El proceso de restauración intentará hacer coincidir los host de Moodle Network con todos los usuarios creados. Los que no coincidan se conectarán automáticamente mediante identificación interna (en lugar de la de Mnet). El informe de restauración le informará al respecto.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Nota:</strong> Esta copia de seguridad aparentemente se origina de una instalación diferente de Moodle y contiene cuentas de red Moodle remotas que se puede fallar en recuperar. Esta operación no es admitida. Si usted está seguro que fue creada en esta instalación de Moodle, o puede asegurarse de que todos los hosts de red Moodle necesarios están configurados, podría intentar la restauración.';
$string['mnetrestore_extusers_noadmin'] = '<strong> Nota: </strong> Este archivo de copia de seguridad parece venir de otra instalación de Moodle y contiene cuentas de usuario de  Moodle Network. No tiene permiso para ejecutar este tipo de restauración. Póngase en contacto con el administrador del sitio o bien,  restaure este curso sin ningún tipo de información de usuario (módulos, archivos ...)';
$string['mnetrestore_extusers_switchuserauth'] = 'El usuario remoto de Moodle Network {$a->username} (proveniente de {$a->mnethosturl}) ha cambiado a usuario identificado {$a->auth} local.';
$string['mobilenotconfiguredwarning'] = 'Moodle para móviles no está habilitado.';
$string['modassignmentinuse'] = 'Su sitio todavía está usando el plugin de Tarea 2.2. Antes de actualizar usted necesita 1) respaldar cualquier actividad de Tarea 2.2 que quiera conservar y restaurarlas como actividades de Tarea, y 2) eliminar todos los datos de Tarea 2.2 de la base de datos.';
$string['modassignmentsubpluginsexist'] = 'Podrían estar presentes subplugins de Tarea 2.2. La carpeta mod/assignment y todos sus subplugins necesitan ser eliminados antes de la actualización.';
$string['modchooserdefault'] = 'Selector de actividades por defecto';
$string['modeditdefaults'] = 'Valores predeterminados para la configuración de la actividad';
$string['modsettings'] = 'Gestionar actividades';
$string['modulesecurity'] = 'Seguridad del módulo';
$string['moodleapp'] = 'App de Moodle';
$string['moodleapp_help'] = '<p>La aplicación gratuita Moodle permite a los usuarios acceder a sus cursos en dispositivos móviles. Las funciones adicionales de la aplicación están disponibles con un plan de aplicación Pro o Premium.</p>
<a href="https://moodle.com/mobile-app">Obtenga la aplicación Moodle </a><br />
<a href="https://apps.moodle.com"> Portal de aplicaciones de Moodle </a>';
$string['moodlebrandedapp'] = 'App Moodle de marca';
$string['moodlebrandedapp_help'] = '<p>La App Moodle de marca tiene toda la funcionalidad de nuestra App móvil gratuita para Moodle combinada con las características de su marca personalizada propia.</p>
<a href="https://moodle.com/branded-app">Acerca de la App Moodle de marca</a>';
$string['moodlebrandedappreference'] = 'Alternativamente, obtenga una  <a href="https://moodle.com/branded-app/">Branded Moodle app (App Moodle de marca)</a> con su propio estilo personalizable.';
$string['moodlepartners'] = 'Moodle Partners (Socios Moodle)';
$string['moodlepartners_help'] = '<p>Los Moodle Partners (Socios Moodle) son proveedores de servicio que están certificados por Moodle HQ para proporcionar servicios de alta calidad para el entorno de aprendizaje en línea de su organización.</p>
<a href="https://moodle.com/about-partners/">Acerca de nuestros Socios</a><br />
<a href="https://moodle.com/partners">Encuentra un Socio</a>';
$string['moodleservices'] = 'Servicios de Moodle';
$string['moodleservices_help'] = 'Asegúrese de obtener lo mejor de su entorno de aprendizaje Moodle al usar estos servicios:';
$string['multilangforceold'] = 'Forzar sintaxis vieja multi-idioma: <span> sin la class="multilang" and <lang>';
$string['mustenablestats'] = 'Las estadísticas aún no se han habilitado en este sitio.';
$string['mycoursesperpage'] = 'Número de cursos';
$string['mydashboard'] = 'Panel por defecto del sistema';
$string['mymoodle'] = 'Área personal';
$string['mymoodleredirect'] = 'Forzar a los usuarios a usar Mi Moodle';
$string['mypage'] = 'Área personal predeterminada';
$string['mypagelocked'] = 'Bloquear página por defecto';
$string['myprofile'] = 'Página de perfil por defecto';
$string['navadduserpostslinks'] = 'Añada enlaces para ver los mensajes del usuario';
$string['navadduserpostslinks_help'] = 'Si está habilitado, dos enlaces se añadirán a la navegación del usuario  para ver las discusiones que el usuario ha comenzado y los mensajes que el usuario ha hecho en foros en todo el sitio o en cursos específicos.';
$string['navcourselimit'] = 'Límite del curso';
$string['navigationupgrade'] = 'Esta actualización introduce dos nuevos bloques de navegación que sustituirán a estos bloques: Administración, Cursos, Actividades y Participantes. Si tiene establecido algún permiso especial en estos  bloques debe asegurarse de que todo se está comportando como usted desea.';
$string['navshowallcourses'] = 'Mostrar todos los cursos';
$string['navshowcategories'] = 'Mostrar las categorías de los cursos';
$string['navshowfrontpagemods'] = 'Mostrar actividades de la página principal en la navegación';
$string['navshowfrontpagemods_help'] = 'Si se activa, las actividades de la página de portada se mostrarán en la navegación debajo de las páginas del sitio.';
$string['navshowfullcoursenames'] = 'Ver nombres completos de curso';
$string['navshowfullcoursenames_help'] = 'Si se habilita, el nombre completo de los cursos se mostrarán en los elementos de navegación en lugar de sus nombres cortos.';
$string['navshowmycoursecategories'] = 'Mostrar mis categorías de curso';
$string['navshowmycoursecategories_help'] = 'Si está habilitado, los cursos mostrados en la opción de menú "Mis cursos" se mostrarán en categorías en el bloque de navegación (sólo para temas basados en clásicos).';
$string['navsortmycourseshiddenlast'] = 'Ordenar mis cursos ocultos al final';
$string['navsortmycourseshiddenlast_help'] = 'Si está habilitado, los cursos ocultos se enumerarán después de los cursos visibles (para los usuarios que pueden ver los cursos ocultos). De lo contrario, todos los cursos, independientemente de su visibilidad, se enumerarán de acuerdo con la configuración "Ordenar mis cursos".';
$string['navsortmycoursessort'] = 'Ordenar mis cursos';
$string['navsortmycoursessort_help'] = 'Determina si se mostrarán los cursos en \'Mis cursos\' siguiendo un orden determinado (orden establecido en Administración del sitio > Cursos > Administrar cursos y categorías) o alfabéticamente.';
$string['never'] = 'Nunca';
$string['neverdeleteruns'] = 'Nunca eliminar ejecuciones';
$string['newestdocindexed'] = 'Documento más reciente indexado';
$string['nobookmarksforuser'] = 'No tiene ninguna marca.';
$string['nodatabase'] = 'Ninguna base de datos';
$string['nohttpsformobilewarning'] = 'Se recomienda que se habilite HTTPS con un certificado válido. La aplicación Moodle siempre intentará usar una conexión segura en primer lugar.';
$string['nomissingstrings'] = 'No hay cadenas sin traducir';
$string['none'] = 'Ninguno';
$string['nonewsettings'] = 'No se han agregado nuevos ajustes durante esta actualización.';
$string['nonexistentbookmark'] = 'La marca solicitada no existe.';
$string['noreplyaddress'] = 'Dirección \'no-reply\'';
$string['noreplydomain'] = 'No-responder y dominio';
$string['noreplydomaindetail'] = 'Ajustes para No-reply y dominios configurados.';
$string['noresults'] = 'No hay resultados.';
$string['noroles'] = 'No roles';
$string['nosupportedlogstore'] = 'Sin soporte para el tipo de almacenamiento de registros encontrado';
$string['notifications'] = 'Notificaciones';
$string['notifyloginfailures'] = 'Enviar por correo electrónico las identificaciones fallidas a';
$string['notifyloginthreshold'] = 'Umbral para notificaciones email';
$string['notloggedinroleid'] = 'Rol de los visitantes';
$string['numberofmissingstrings'] = 'Número de cadenas sin traducir: {$a}';
$string['numberofstrings'] = 'Número total de cadenas: {$a->strings}<br />Ausentes: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'El símbolo refrescar para uno de los servicios OAuth {$a->issuer} en su sitio {$a->siteurl} ha expirado. Esto limitará la funcionalidad de cualquiera de los plugins que usan este servicio. Para solucionar este problema, visite la página de configuración Servicios OAuth 2 y haga click en el icono "Conectar cuenta del sistema" en la fila de la tabla de este servicio. Asegúrese de iniciar sesión usando la misma cuenta de servicio para el sistema OAuth cada vez.';
$string['oauthrefreshtokenexpiredshort'] = 'El símbolo para refrescar OAuth ha expirado para {$a->issuer} en su sitio {$a->siteurl}.';
$string['onlynoreply'] = 'Únicamente cuando se utilice la dirección de no-responder';
$string['opcacherecommended'] = 'PHP opcode caché mejora el rendimiento y reduce los requisitos de memoria, se recomienda la extensión OPcache, totalmente compatible.';
$string['opensslrecommended'] = 'Instalar la librería opcional OpenSSL es altamente recomendado -- activa la funcionalidad de red de Moodle (\'Moodle Networking\').';
$string['opensslrequired'] = 'La extensión OpenSSL PHP es requerida por Moodle para brindar mayor fortaleza a los servicios criptográficos.';
$string['opentowebcrawlers'] = 'Abrir a Google';
$string['optionalmaintenancemessage'] = 'Mensaje de mantenimiento opcional';
$string['order1'] = 'Primero';
$string['order2'] = 'Segundo';
$string['order3'] = 'Tercero';
$string['order4'] = 'Cuarto';
$string['outgoingmailconfig'] = 'Configuración de correo saliente';
$string['overridetossl'] = 'El acceso con HTTPS está obsoleto. Esta instancia está forzada ahora con SSL. Para solucionar esta advertencia, cambie el wwwroot en config.php a https://';
$string['pageinfodebugsummary'] = 'Esta página es: {$a}';
$string['passwordchangelogout'] = 'Cerrar sesión después de cambiar la contraseña';
$string['passwordchangelogout_desc'] = 'Si se activa, cuando la clave sea modificada todas las sesiones del navegador serán terminadas, a excepción de en la que se ha introducido la nueva contraseña. (Este ajuste no afecta a los cambios realizados vía subida masiva de usuarios.)';
$string['passwordchangetokendeletion'] = 'Borrar los tokens de acceso de los web service tras cambiar la contraseña.';
$string['passwordchangetokendeletion_desc'] = 'Si está habilitado, cuando una contraseña es cambiada, todos los tokens de acceso de webservice de usuario son borrados.';
$string['passwordpolicy'] = 'Política de contraseñas';
$string['passwordpolicycheckonlogin'] = 'Comprobar contraseña al iniciar sesión';
$string['passwordresettime'] = 'Tiempo máximo para validar una solicitud de restablecimiento de contraseña';
$string['passwordreuselimit'] = 'Límite de rotación de contraseñas';
$string['passwordreuselimit_desc'] = 'Número de veces que un usuario puede cambiar su contraseña antes de que se le permita reutilizar una contraseña. Los hashes de las contraseñas utilizadas anteriormente son almacenados en una tabla de la base de datos local. Esta opción puede no ser compatible con algunos plugins de autentificación externos.';
$string['pathtodot'] = 'Ruta a dot';
$string['pathtodot_help'] = 'La ruta al ejecutable de dot. En Linux es algo similar a /usr/bin/dot. En Windows es algo como C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. En Mac es algo como /opt/local/bin/dot. Para ser capaz de generar gráficos a partir de ficheros DOT necesita tener instalado el ejecutable de dot (de las utilidades Graphviz) y apuntar al mismo desde aquí. Tenga en cuenta que por ahora solo lo usan las características de perfilado (Desarrollo->Perfilado) incorporadas en Moodle.';
$string['pathtodu'] = 'Ruta a du';
$string['pathtogs'] = 'Ruta del ghostcript';
$string['pathtogs_help'] = 'En la mayoría de las instalaciones de Linux, esto se puede dejar como \'/usr/bin/gs\'. En Windows, será algo así como \'c:\\gs\\bin\\gswin32c.exe\' (asegúrese de que no haya espacios en la ruta; si es necesario, copie los archivos \'gswin32c.exe\' y \'gsdll32.dll\' en una nueva carpeta sin espacio en la ruta)';
$string['pathtopgdump'] = 'Ruta a pg_dump';
$string['pathtopgdumpdesc'] = 'Sólo es necesario entrar si usted tiene má de un pg_dump en su sistema (por ejemplo, si tiene instalada más de una versión de postgresql)';
$string['pathtopgdumpinvalid'] = 'Ruta no válida a pg_dump: o bien es errónea, o bien no es ejecutable';
$string['pathtophp'] = 'Ruta al CLI de PHP';
$string['pathtopsql'] = 'Ruta a psql';
$string['pathtopsqldesc'] = 'Esto sólo es necesario si tiene más de un psql en su sistema (por ejemplo, si tiene instalada más de una versión de postgresql)';
$string['pathtopsqlinvalid'] = 'Ruta a psql no válida: o bien es errónea, o bien no es ejecutable';
$string['pathtopython'] = 'Ruta a Python';
$string['pathtopythondesc'] = 'Ruta a los archivos binarios de ejecución de Python (se permite Python 2 y Python 3).';
$string['pathtosassc'] = 'Ruta hacia SassC';
$string['pathtosassc_help'] = 'Al especificar la localización del binario de SassC cambiará al compilador de SASS de la implementación PHP de Moodle a SassC. Vea https://github.com/sass/sassc para más información.';
$string['pcreunicodewarning'] = 'Se recomienda encarecidamente usar la extensión PCRE PHP que sea compatible con caracteres Unicode.';
$string['perfdebug'] = 'Información de rendimiento';
$string['performance'] = 'Rendimiento';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'Parámetro de versión/cluster PostgreSQL para operaciones de línea de comandos. Si sólo tiene un postgresql en su sistema o no está seguro de qué es esto, déjelo en blanco.';
$string['phpfloatproblem'] = 'Detectado problema inesperado en el manejo de números flotantes PHP - {$a}';
$string['pleaserefreshregistration'] = 'Su sitio ha sido registrado. Última actualización del registro {$a}.<br />  Su registro se mantiene actualizado mediante la tarea programada "Registro del Sitio". Puede actualizarlo manualmente en cualquier momento.';
$string['pleaserefreshregistrationnewdata'] = 'La información de registro cambió. Por favor, confírmela usando el botón \'Actualizar registro\'.';
$string['pleaserefreshregistrationunknown'] = 'Su sitio ha sido registrado pero la fecha del registro es desconocida. Por favor actualice su registro utilizando el botón "Actualizar registro" o compruebe que la tarea programada "Registro de Sitio" está habilitada para que su registro se actualice automáticamente.';
$string['plugin'] = 'Extensión';
$string['plugins'] = 'Extensiones';
$string['pluginscheck'] = 'Comprobación de las dependencias de las extensiones';
$string['pluginscheckfailed'] = 'Falló la revisión de dependencias para {$a->pluginslist}';
$string['pluginschecktodo'] = '¡Debe resolver todos los requerimientos sobre extensiones antes de proceder a la instalación de esta versión de Moodle!';
$string['pluginsoverview'] = 'Vista general de extensiones';
$string['pluginsoverviewsee'] = 'Vea la página <a href="{$a->url}"> Vista general de extensiones</a> para más detalles';
$string['policysettings'] = 'Configuraciones de Política';
$string['privacy:metadata'] = 'El complemento de Administración no almacena ningún de dato personal.';
$string['privacyandpolicies'] = 'Privacidad y Políticas';
$string['privacysettings'] = 'Opciones de privacidad';
$string['profilecategory'] = 'Categoría';
$string['profilecategoryname'] = 'Nombre de la categoría (debe ser único)';
$string['profilecategorynamenotunique'] = 'Este nombre de categoría ya está en uso';
$string['profilecommonsettings'] = 'Ajustes comunes';
$string['profileconfirmcategorydeletion'] = 'Hay {$a} campo/s en esta categoría que serán movidos a la categoría superior (o inferior de estar en la categoría más superior).<br />¿Aún desea eliminar ésta categoría?';
$string['profileconfirmfielddeletion'] = 'Hay {$a} registro/s de usuario para este campo que serán eliminados. <br />¿Aún desea eliminar este campo?';
$string['profilecreatecategory'] = 'Crear una nueva categoría de perfiles';
$string['profilecreatefield'] = 'Crear un nuevo campo de perfil:';
$string['profilecreatenewcategory'] = 'Creando una nueva categoría';
$string['profilecreatenewfield'] = 'Creando un nuevo campo de perfil "{$a}"';
$string['profiledefaultcategory'] = 'Otros campos';
$string['profiledefaultchecked'] = 'Marcado por defecto';
$string['profiledefaultdata'] = 'Valor por defecto';
$string['profiledeletecategory'] = 'Eliminando una categoría';
$string['profiledeletefield'] = 'Eliminando el campo \'{$a}\'';
$string['profiledescription'] = 'Descripción del campo';
$string['profiledscript'] = 'Este script ha sido perfilado';
$string['profiledscriptview'] = 'Ver información de perfil para este script';
$string['profileeditcategory'] = 'Editando la categoría {$a}';
$string['profileeditfield'] = 'Editando el campo de perfil {$a}';
$string['profilefield'] = 'Campo del perfil';
$string['profilefieldcolumns'] = 'Columnas';
$string['profilefieldispassword'] = '¿Es éste un campo de contraseña?';
$string['profilefieldlink'] = 'Enlace';
$string['profilefieldlink_help'] = 'Para transformar el texto en un enlace, ingrese una URL que contenga $$, donde $$ se reemplazará con el texto. Por ejemplo, para transformar una ID de Twitter en un enlace, ingrese https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Enlazar objetivo';
$string['profilefieldmaxlength'] = 'Longitud máxima';
$string['profilefieldrows'] = 'Filas';
$string['profilefields'] = 'Campos de perfil del usuario';
$string['profilefieldsize'] = 'Mostrar tamaño';
$string['profileforceunique'] = '¿Deberían ser únicos los datos?';
$string['profileinvaliddata'] = 'Valor no válido';
$string['profilelocked'] = '¿Está este campo bloqueado?';
$string['profilemenudefaultnotinoptions'] = 'El valor por defecto no está entre las opciones';
$string['profilemenunooptions'] = 'No se han suministrado opciones de menú';
$string['profilemenuoptions'] = 'Opciones de menú (una por línea)';
$string['profilemenutoofewoptions'] = 'Debe proporcionar al menos dos opciones';
$string['profilename'] = 'Nombre';
$string['profilenofieldsdefined'] = 'No se han definido campos';
$string['profilerequired'] = '¿Es este campo necesario?';
$string['profileroles'] = 'Roles de perfil visibles';
$string['profilesforenrolledusersonly'] = 'Perfiles sólo para usuarios matriculados';
$string['profileshortname'] = 'Nombre corto (debe ser único)';
$string['profileshortnameinvalid'] = 'Este nombre corto solo puede contener caracteres alfanuméricos (letras y números) o guión bajo (_).';
$string['profileshortnamenotunique'] = 'Este nombre corto ya está en uso';
$string['profilesignup'] = '¿Mostrar en la página para inscribirse?';
$string['profilespecificsettings'] = 'Ajustes específicos';
$string['profilevisible'] = '¿Quién puede ver este campo?';
$string['profilevisible_help'] = '<p>Se puede asignar a cada campo personalizado uno de tres ajustes de visibilidad: invisible, a todo el mundo y usuario. El ajuste \'invisible\' normalmente es decidido por un administrador que quiere mantener la privacidad de los datos de los usuarios. El ajuste \'usuario\' es seleccionado normalmente para un campo que contiene información delicada, en tanto que la opción \'todo el mundo\' puede usarse para cualquier tipo de información.</p>';
$string['profilevisibleall'] = 'Todos pueden verlo';
$string['profilevisiblenone'] = 'No visible';
$string['profilevisibleprivate'] = 'Visible por el usuario';
$string['profiling'] = 'Perfilado (análisis del rendimiento)';
$string['profilingallowall'] = 'Perfilado continuo';
$string['profilingallowall_help'] = 'Si habilita este ajuste entonces, en cualquier momento, puede usar el parámetros PROFILEALL en cualquier parte (PGC) para habilitar el perfilado de todos los scripts ejecutados durante la duración de la sesión Moodle. De igual manera, puede usar el parámetro PROFILEALLSTOP para detenerlo.';
$string['profilingallowme'] = 'Perfilado selectivo';
$string['profilingallowme_help'] = 'Si habilita este ajuste entonces, de forma selectiva, puede usar el parámetro PROFILEME en cualquier parte (PGC) y se habilitará el perfilado para ese script. De igual manera, puede usar el parámetro DONTPROFILEME para evitar que tenga lugar el perfilado.';
$string['profilingautofrec'] = 'Perfilado automático';
$string['profilingautofrec_help'] = 'Al configurar este ajuste, algunas peticiones (de forma aleatoria, basada en la frecuencia especificada - 1 de cada N) será escogida y perfilada automáticamente, almacenando los resultados para un análisis posterior. Note que esta forma de perfilado respeta los ajustes de inclusion/exclusión. Ponga el valor a 0 para deshabilitar el perfilado automático.';
$string['profilingenabled'] = 'Habilitar perfilado (análisis del rendimiento)';
$string['profilingenabled_help'] = 'Si habilita este ajuste el perfilado estará disponible en este sitio y podrá definir su comportamiento configurando las siguientes opciones.';
$string['profilingexcluded'] = 'Excluir perfilado (análisis del rendimiento)';
$string['profilingexcluded_help'] = 'Lista de (separadas por comas o por saltos de línea, omisión absoluta de wwwroot, invocables) URLs que se excluirán del perfil de las definidas por la configuración "Perfilar estos".';
$string['profilingimportprefix'] = 'Prefijo de la importación de perfiles';
$string['profilingimportprefix_desc'] = 'Para una detección más fácil, todas las importaciones de perfiles se prefijan con el valor que aquí se especifica,';
$string['profilingincluded'] = 'Perfilar estos';
$string['profilingincluded_help'] = 'Lista de (separadas por comas o por saltos de línea, wwwroot de omisión absoluta, invocables) URLs que se perfilarán automáticamente. Ejemplos: /index.php, /course/view.php. También acepta el comodín * en cualquier posición. Ejemplos: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Mantener perfilado de ejecuciones';
$string['profilinglifetime_help'] = 'Especifique cuanto tiempo desea mantener la información de anteriores ejecuciones de perfilado. Las más antiguas se eliminarán automáticamente. Note que esto excluye cualquier ejecución de perfilado marcada como \'ejecución de referencia\'.';
$string['profilingslow'] = 'Hacer un perfil de páginas lentas';
$string['profilingslow_help'] = 'Al fijar un tiempo mínimo en segundos se creará un perfil de todas las páginas más lentas. Para un mismo Script sólo se guardarán aquellos perfiles que son más lentos que los existentes. Poner 0 para deshabilitar. Notar que esto respeta la configuración de exclusión.';
$string['protectusernames'] = 'Proteger nombres de usuario';
$string['proxybypass'] = 'Servidores que saltan el proxy ';
$string['proxyhost'] = 'Host proxy';
$string['proxypassword'] = 'Contraseña del proxy';
$string['proxyport'] = 'Puerto proxy';
$string['proxytype'] = 'Tipo de proxy';
$string['proxyuser'] = 'Nombre de usuario del proxy';
$string['purgecaches'] = 'Purgar todas las cachés';
$string['purgecachesconfirm'] = 'Moodle puede guardar en caché los temas, javascript, cadenas de idioma, texto filtrado, RSS feeds y muchos otros datos. La depuración de estos datos en el servidor forzará a los navegadores de los clientes a actualizar la información y usted se asegurará de que los usuarios están viendo la información con los cambios más recientes. No se corre ningún riesgo por hacerlo, aunque su sitio podría parecer algo más lento en un principio hasta que el servidor y los clientes vuelven a actualizar la información guardándose nuevamente los datos en la caché.';
$string['purgecachesfinished'] = 'Todas las cachés han sido purgadas';
$string['purgecachesnoneselected'] = 'Seleccione una o más cachés para purgar';
$string['purgecachespage'] = 'Purgar cachés';
$string['purgefiltercache'] = 'Filtros de texto';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Cadenas de idioma';
$string['purgemuc'] = 'Todas las cachés MUC';
$string['purgeothercaches'] = 'Todos los ficheros y diversas cachés';
$string['purgeselectedcaches'] = 'Purgar cachés seleccionadas';
$string['purgeselectedcachesfinished'] = 'Las cachés seleccionadas han sido purgadas.';
$string['purgetemplates'] = 'Plantillas';
$string['purgethemecache'] = 'Temas';
$string['query'] = 'Consulta';
$string['question'] = 'Pregunta';
$string['questionbehaviours'] = 'Comportamientos de las preguntas';
$string['questioncwqpfscheck'] = 'Una o más preguntas \'aleatorias\' de un cuestionario se disponen para seleccionar preguntas de una mezcla de categorías de pregunta compartidas y no compartidas. Puede ver un informe más detallado <a href="{$a->reporturl}">aquí</a> o consultar la página de Moodle Docs <a href="{$a->docsurl}">here</a>.';
$string['questioncwqpfsok'] = 'Bueno. No existen preguntas \'aleatorias\' en sus cuestionarios que estén ajustadas para seleccionar preguntas a partir de una mezcla de categorías de pregunta compartidas y no compartidas.';
$string['questiontype'] = 'Tipo de pregunta';
$string['questiontypes'] = 'Tipos de preguntas';
$string['quizattemptsupgradedmessage'] = 'En Moodle 2.1 se produjo una importante actualización de preguntas. Fue posible retrasar partes de la actualización de base de datos que se ejecute más tarde. Antes de actualizar a Moodle 2.7, se debe completar la actualización.';
$string['recaptchaprivatekey'] = 'Clave secreta ReCAPTCHA';
$string['recaptchapublickey'] = 'Clave del sitio ReCAPTCHA';
$string['register'] = 'Registre su sitio';
$string['registermoodlenet'] = '<p> ¡Nos encantaría estar en contacto y brindarle información importante para su sitio Moodle! </p> <p> Al registrarse: </p> <ul> <li> Puede suscribirse para recibir notificaciones de nuevos lanzamientos de Moodle, alertas de seguridad y otras noticias importantes. </li> <li> Puede acceder y activar notificaciones push móviles desde su sitio Moodle a través de nuestra <a href="https://download.moodle.org/mobile/"> Aplicación Moodle </a> gratuita. </li> <li> Está contribuyendo a nuestras <a href="https://stats.moodle.org"> estadísticas de Moodle </a> de la comunidad mundial, que nos ayudan mejorar Moodle y los sitios de nuestra comunidad. </li> <li> Si lo desea, su sitio puede incluirse en la <a href="https://stats.moodle.org/sites/"> lista de sitios Moodle registrados </a> en su país. </li> </ul>';
$string['registermoodleorg'] = 'Al registrar su sitio';
$string['registermoodleorgli1'] = 'Su nombre se ha añadido a una lista de correo de bajo volumen para recibir las notificaciones importantes, como alertas de seguridad  o nuevas versiones de Moodle.';
$string['registermoodleorgli2'] = 'Las estadísticas sobre su sitio se incorporarán a la {$a} de la comunidad de Moodle en todo el mundo.';
$string['registerwithmoodleorg'] = 'Registre su sitio';
$string['registration'] = 'Registro';
$string['registration_help'] = 'Al registrarse:

* Recibirás alertas de seguridad
* Puede activar las notificaciones push de aplicaciones móviles desde su sitio
* Estás contribuyendo a nuestras estadísticas de Moodle de la comunidad mundial';
$string['registrationwarning'] = 'Su sitio aún no está registrado.';
$string['registrationwarningcontactadmin'] = 'Su sitio no está registrado aún. Por favor, consulte con su administrador.';
$string['releasenoteslink'] = 'Si desea información sobre esta versión de Moodle, por favor vea <a target="_blank" href="{$a}">Release Notes</a>';
$string['rememberuserlicensepref'] = 'Recordar preferencia de licencia de usuario';
$string['rememberuserlicensepref_help'] = 'Si está habilitado, la última licencia seleccionada por el usuario se preselecciona al cargar un archivo en el selector de archivos. De lo contrario, se preselecciona la licencia del sitio predeterminada.';
$string['rememberusername'] = 'Recordar nombre de usuario';
$string['rememberusername_desc'] = 'Activar si desea almacenar las cookies permanentes con nombres de usuario durante el inicio de sesión. Las cookies permanentes se deben tratar como un asunto de privacidad si se utilizan sin consentimiento.';
$string['reportsmanage'] = 'Gestionar informes';
$string['requestcategoryselection'] = 'Habilitar selección de categorías';
$string['required'] = 'Requerido';
$string['requiredentrieschanged'] = 'Nota: Después de la actualización, la configuración \'Entradas requeridas antes de ver\' ahora se aplica en las siguientes actividades de la base de datos:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Requerir descripción de la actividad';
$string['requiremodintro_desc'] = 'Si se activa, los usuarios serán forzados a ingresar una descripción para cada actividad.';
$string['requires'] = 'Requerido';
$string['restorecourse'] = 'Restaurar curso';
$string['restorernewroleid'] = 'Rol de los restauradores en los cursos';
$string['restorernewroleid_help'] = 'Si el usuario no tiene todavía permiso para administrar el curso recién restaurado, se le asignar este permiso automáticamente y se le da de alta  en caso necesario. Seleccione "Ninguno" si no quieres que los restauradores puedan gestionar todos los cursos restaurados.';
$string['resultfilter'] = 'Filtrar por resultado';
$string['reverseproxy'] = 'Reverse proxy';
$string['reverseproxyignore'] = 'Ignorar proxy inverso';
$string['riskconfig'] = 'Los usuarios podrían cambiar la configuración y el comportamiento del sitio';
$string['riskconfigshort'] = 'Riesgo de configuración';
$string['riskdataloss'] = 'Los usuarios podrían destruir grandes cantidades de contenido o la información';
$string['riskdatalossshort'] = 'Riesgo de pérdida de datos';
$string['riskmanagetrust'] = 'Los usuarios podrían cambiar los ajustes de confianza de otros usuarios';
$string['riskmanagetrustshort'] = 'Gestionar ajustes fiables';
$string['riskpersonal'] = 'Los usuarios podrían acceder a información privada de otros usuarios';
$string['riskpersonalshort'] = 'Riesgo de privacidad';
$string['riskspam'] = 'Los usuarios podrían enviar \'spam\' a usuarios del sitio o a otros';
$string['riskspamshort'] = 'Riesgo de spam';
$string['riskxss'] = 'Los usuarios podrían agregar archivos y textos que permiten \'scripting\' a través del sitio (XSS)';
$string['riskxssshort'] = 'Riesgo XSS';
$string['roleswithexceptions'] = '{$a->roles}, con {$a->exceptions}
';
$string['rssglobaldisabled'] = 'Deshabilitado a nivel de sitio';
$string['save'] = 'Guardar';
$string['savechanges'] = 'Guardar cambios';
$string['scssinvalid'] = 'El código SCSS no es válido, falla en: {$a}';
$string['search'] = 'Buscar';
$string['searchablecourses'] = 'Cursos en los que se puede buscar';
$string['searchallavailablecourses'] = 'Cursos en los que se puede buscar';
$string['searchallavailablecourses_desc'] = 'En algunas situaciones el motor de búsqueda puede no funcionar correctamente si se busca en un gran número de cursos. Realice la búsqueda sólo en los cursos matriculados para restringir la búsqueda.';
$string['searchallavailablecourses_off'] = 'Buscar solo entre los cursos matriculados';
$string['searchallavailablecourses_on'] = 'Buscar entre todos los cursos a los que el usuario tiene acceso';
$string['searchallavailablecoursesdesc'] = 'Si se configura a buscar solamente dentro  de cursos inscritos, la información del curso (nombre y resumen) y el contenido del curso solamente será buscada en los cursos en los cuales el usuario está inscrito. De otra forma, la información del curso y el contenido del curso será buscada en todos los cursos a los cuales el usuario puede acceder, como por ejemplo los cursos con acceso de invitados habilitado.';
$string['searchalldeleted'] = 'Todos los contenidos indexados han sido borrados';
$string['searchareadisabled'] = 'Área de búsqueda deshabilitada';
$string['searchareaenabled'] = 'Área de búsqueda habilitada';
$string['searchareas'] = 'Áreas de búsqueda';
$string['searchdefaultcategory'] = 'Categoría de búsqueda por defecto';
$string['searchdefaultcategory_desc'] = 'Los resultados de la categoría de búsqueda seleccionada se mostrarán por defecto.';
$string['searchdeleteindex'] = 'Borrar todos los contenidos indexados';
$string['searchdisplay'] = 'Opciones de visualización de resultados de búsqueda';
$string['searchenablecategories'] = 'Mostrar resultados en categorías separadas';
$string['searchenablecategories_desc'] = 'Si se habilita, los resultados de búsqueda se mostrarán en categorías separadas.';
$string['searchengine'] = 'Motor de búsqueda';
$string['searchhideallcategory'] = 'Ocultar la categoría de resultados: Todos';
$string['searchhideallcategory_desc'] = 'Si se activa, la categoría con todos los resultados estará oculta en la pantalla de resultados de búsqueda.';
$string['searchincludeallcourses'] = 'Incluir todos los cursos visibles';
$string['searchincludeallcourses_desc'] = 'Si se habilita, los resultados de búsqueda incluirán información de los cursos (nombre y resumen) visibles para el usuario, aún no disponiendo de acceso al contenido del curso.';
$string['searchindexactions'] = 'Acciones del índice';
$string['searchindexdeleted'] = 'Índice borrado';
$string['searchindextime'] = 'Límite de tiempo de indexación';
$string['searchindextime_desc'] = 'Al indexar grandes cantidades de contenido, la tarea programada se detendrá después de que se alcance este límite de tiempo. Continuará la siguiente vez que se ejecute la tarea.';
$string['searchindexupdated'] = 'Los contenidos del motor de búsqueda han sido actualizados';
$string['searchindexwhendisabled'] = 'Indexar cuando esté deshabilitado';
$string['searchindexwhendisabled_desc'] = 'Permite que la tarea programada construya el índice de búsqueda aun y cuando esté deshabilitada la búsqueda. Esto es útil si quiere construir el índice antes de que a los estudiantes les aparezca la opción de búsqueda.';
$string['searchinsettings'] = 'Ajustes de búsqueda';
$string['searchlastrun'] = 'Última ejecución (time, # docs, # records, # ignores)';
$string['searchnotavailable'] = 'La búsqueda no está disponible';
$string['searchoptions'] = 'Opciones de búsqueda';
$string['searchpartial'] = '(aun no indexado completamente)';
$string['searchreindexed'] = 'Todos los contenidos del sitio han sido indexados de nuevo.';
$string['searchreindexindex'] = 'Indexar de nuevo todos los contenidos del sitio';
$string['searchresults'] = 'Resultados de la búsqueda';
$string['searchsetupinfo'] = 'Configuración de búsqueda';
$string['searchupdateindex'] = 'Actualizar contenidos indexados';
$string['sectionerror'] = 'Error de sección';
$string['secureforms'] = 'Usar formulario adicional de seguridad';
$string['security'] = 'Seguridad';
$string['selectdevice'] = 'Seleccionar dispositivo';
$string['selectsearchengine'] = 'Seleccionar motor de búsqueda';
$string['selecttheme'] = 'Seleccionar tema para el dispositivo {$a}';
$string['server'] = 'Servidor';
$string['serverchecks'] = 'Comprobaciones del servidor';
$string['serverlimit'] = 'Límite del servidor';
$string['sessionautostartwarning'] = '<p>Se ha detectado un error de configuración grave; por favor notifique al administrador del servidor. </p><p>Para que funcione correctamente, Moodle requiere que el administrador cambie la configuración de PHP. </p><p> <code> session.auto_start </code> debe establecerse en <code>off </code>. </p> <p>Esta configuración se controla editando <code> php.ini </code>, la configuración de  Apache/IIS <br /> o el fichero <code>. htaccess </code> en el servidor. </p>';
$string['sessioncookie'] = 'Prefijo de las \'cookies\'';
$string['sessioncookiedomain'] = 'Dominio de las \'cookies\'';
$string['sessioncookiepath'] = 'Ruta de las \'cookies\'';
$string['sessionhandling'] = 'Gestión de sesión';
$string['sessiontimeout'] = 'Tiempo límite';
$string['settingdependenton'] = 'Dependiendo del valor de <strong>{$a}</strong>, este ajuste puede estar oculto.';
$string['settingfileuploads'] = 'La subida de archivos es necesaria para el funcionamiento normal, por favor, actívela en la configuración PHP.';
$string['settingmaxinputvars'] = 'Se recomienda que la configuración de PHP max_input_vars sea al menos 5000.';
$string['settingmaxinputvarsrequired'] = 'La configuración de PHP max_input_vars debe ser al menos 5000.';
$string['settingmemorylimit'] = 'Memoria insuficiente, defina un valor mayor de la memoria en la configuración de PHP (memory_limit)';
$string['settingsafemode'] = 'Moodle no es totalmente compatible con el modo seguro, por favor, pida al administrador del servidor que lo desactive. La ejecución de Moodle en modo seguro no es compatible, se producirán diversos problemas si lo hace.';
$string['setupsearchengine'] = 'Configurar el motor de búsqueda';
$string['showcommentscount'] = 'Mostrar número de comentarios';
$string['showdetails'] = 'Mostrar detalles';
$string['showuseridentity'] = 'Mostrar identidad de usuario';
$string['showuseridentity_desc'] = 'Al seleccionar o buscar usuarios, y cuando se muestran las listas de usuarios, estos campos se mostrarán adicionalmente a su nombre completo. Los campos solo se muestran a los usuarios que tienen la capacidad moodle/site:viewuseridentity por defecto, profesores y gestores. (Esta opción tiene más sentido si selecciona uno o dos campos obligatorios en su institución).

Por favor, cuide los datos personales de los usuarios y considere IMPORTANTE tener la precaución de  no escribir ni permitir el acceso no-autorizado a "datos personales sensibles" (estado de salud, información genética, creencias religiosas, filosóficas y morales, afiliación sindical, opiniones políticas, orígen racial o étnico, preferencia sexual...) que pudieran causarle responsabilidades o riesgos innecesarios a Usted y a la Institución.';
$string['simplexmlrequired'] = 'Moodle requiere ahora la extensión SimpleXML de PHP.';
$string['sitemailcharset'] = 'Conjunto de caracteres';
$string['sitemaintenance'] = 'Este sitio está en fase de mantenimiento y no está disponible en este momento';
$string['sitemaintenancemode'] = 'Modo de mantenimiento';
$string['sitemaintenanceoff'] = 'El modo de mantenimiento está desactivado y el sitio vuelve a funcionar con normalidad';
$string['sitemaintenanceon'] = 'El sitio está en modo mantenimiento (sólo los administradores tienen acceso).';
$string['sitemaintenanceoncli'] = 'Su sitio está actualmente en modo de mantenimiento CLI, no se permiten accesos web .';
$string['sitemaintenancewarning'] = 'El sitio está en modo mantenimiento (sólo los administradores tienen acceso). Para ponerlo en funcionamiento de nuevo, <a href="maintenance.php">desactive el modo de mantenimiento</a>.';
$string['sitemaintenancewarning2'] = 'Su sitio se encuentra actualmente en modo de mantenimiento (solo los administradores pueden iniciar sesión). Para devolver este sitio a la operación normal, <a href="{$a}">desactive el modo de mantenimiento</a>.';
$string['sitemenubar'] = 'Navegación del sitio';
$string['sitepolicies'] = 'Políticas del sitio';
$string['sitepolicy'] = 'URL con la política del sitio';
$string['sitepolicy_help'] = 'La URL de la política del sitio que todos los usuarios registrados deben ver y aceptar antes de acceder al sitio. Tenga en cuenta que esta configuración solo tendrá efecto si el controlador de políticas del sitio está configurado como predeterminado (core).';
$string['sitepolicyguest'] = 'URL con la política del sitio para invitados';
$string['sitepolicyguest_help'] = 'La URL de la política del sitio que todos los invitados deben ver y aceptar antes de acceder al sitio. Tenga en cuenta que esta configuración solo tendrá efecto si el controlador de políticas del sitio está configurado como predeterminado (core).';
$string['sitepolicyhandler'] = 'Manejador de políticas del sitio';
$string['sitepolicyhandler_desc'] = 'Esto determina cómo se gestionan las políticas y los consentimientos de los usuarios. El controlador predeterminado (core) habilita una URL de política de sitio y una URL de política de sitio para los invitados que se especifiquen. El controlador de políticas permite establecer políticas de sitio, privacidad y otras. También permite ver los consentimientos de los usuarios y, si es necesario, dar el consentimiento en nombre de menores.';
$string['sitepolicyhandlercore'] = 'Por defecto (núcleo)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Si se selecciona, se mostrará una sección en la página principal del sitio.';
$string['sixtyfourbitsrequired'] = 'Se ha detectado que su sitio no está usando una versión de PHP de 64 bits. Se le pide que actualice su sistema (sistema operativo, PHP, ...) antes de instalar esta versión de Moodle.';
$string['sixtyfourbitswarning'] = 'Se ha detectado que su sitio no utiliza una versión PHP de 64 bits. Se recomienda que actualice su sitio para garantizar la compatibilidad futura.';
$string['slasharguments'] = 'Usar argumentos \'slash\'';
$string['slashargumentswarning'] = 'Es recomendable que se habilite el uso de slash arguments. En el futuro esto será requerido. Para más detalles, revise la documentación <a href="https://docs.moodle.org/all/es/Usando_slash_arguments">Usando slash arguments</a>.';
$string['smartpix'] = 'Búsqueda de \'smart pix\'';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP Auth Type';
$string['smtpdetail'] = 'Configuraciones del Simple Mail Transfer Protocol (SMTP) para envío de correo electrónico.';
$string['smtphosts'] = 'Servidores SMTP';
$string['smtpmaxbulk'] = 'Límite de sesión SMTP';
$string['smtppass'] = 'Contraseña SMTP';
$string['smtpsecure'] = 'Seguridad SMTP';
$string['smtpuser'] = 'Nombre de usuario SMTP';
$string['soaprecommended'] = 'La instalación de la extensión SOAP es útil para los servicios web y para algunos plugins.';
$string['sort_fullname'] = 'Nombre completo del curso';
$string['sort_idnumber'] = 'Número ID del curso';
$string['sort_shortname'] = 'Nombre corto del curso';
$string['sort_sortorder'] = 'Criterio de ordenación';
$string['spellengine'] = 'Motor ortográfico';
$string['spelllanguagelist'] = 'Lista de idiomas';
$string['splrequired'] = 'Moodle requiere ahora la extensión SPL de PHP.';
$string['stats'] = 'Estadísticas';
$string['statsfirstrun'] = 'Intervalo máximo de procesamiento';
$string['statsmaxruntime'] = 'Tiempo de ejecución máximo';
$string['statsmoodleorg'] = 'estadísticas';
$string['statsruntimedays'] = 'Días para procesar';
$string['statsruntimestart'] = 'Ejecutar en';
$string['statsuserthreshold'] = 'Usar umbral';
$string['stickyblocks'] = 'Bloques \'sticky\'';
$string['stickyblockscourseview'] = 'Página del curso';
$string['stickyblocksduplicatenotice'] = 'Si cualquier bloque que agregue aquí está ya presente en una página en particular, el resultado será un duplicado.<br />Únicamente el bloque agregado no será editable, en tanto que el duplicado podrá editarse.';
$string['stickyblocksmymoodle'] = 'Mi Moodle';
$string['stickyblockspagetype'] = 'Tipo de página a configurar';
$string['strictformsrequired'] = 'Validación estricta de campos obligatorios';
$string['stripalltitletags'] = 'Eliminar marcas HTML de todos los nombres de actividad';
$string['supportcontact'] = 'Contacto de soporte';
$string['supportemail'] = 'Email de soporte';
$string['supportname'] = 'Nombre del soporte';
$string['supportpage'] = 'Página de soporte';
$string['suspenduser'] = 'Suspender cuenta de usuario';
$string['switchlang'] = 'Cambiar directorio de idioma';
$string['systempaths'] = 'Rutas del sistema';
$string['tablenosave'] = 'Los cambios de la tabla superior se guardan automáticamente.';
$string['tablesnosave'] = 'Los cambios en la tabla de arriba se guardan automáticamente.';
$string['tabselectedtofront'] = 'En tablas con tabuladores, la fila con el tabulador actualmente seleccionado debería colocarse en el frente';
$string['tabselectedtofronttext'] = 'Poner en primer término la fila de pestañas seleccionada';
$string['task_adhoc_concurrency_limit'] = 'Límite de concurrencia de trabajo ad hoc';
$string['task_adhoc_concurrency_limit_desc'] = 'El número de ejecutores de tareas ad hoc que se pueden ejecutar al mismo tiempo. Si el límite es alto, es posible que las tareas programadas no se ejecuten con regularidad cuando hay muchas tareas ad hoc. Un valor de 0 inhabilitará el procesamiento de tareas ad hoc por completo.';
$string['task_adhoc_max_runtime'] = 'Tiempo de vida de ejecución de la tarea ad hoc';
$string['task_adhoc_max_runtime_desc'] = 'La edad de un ejecutor de tareas ad hoc antes de su liberación. Se recomienda una duración baja ya que no hay límite para el número de tareas ad hoc en cola. Si este número es demasiado alto y tiene una gran cola de tareas ad hoc, es posible que las tareas programadas no se ejecuten con regularidad.';
$string['task_dbstats'] = 'Base de datos';
$string['task_duration'] = 'Duración';
$string['task_logmode'] = 'Cuando registrar en log';
$string['task_logmode_all'] = 'Almacenar la salida de logis de todos los trabajos';
$string['task_logmode_desc'] = 'Puede elegir cuando desea que tenga lugar el registro de logs. Por defecto los logs son capturados siempre. Puede deshabilitar enteramente los logs, o cambiarlos a solamente guardar en logs los trabajos que fallen.';
$string['task_logmode_failonly'] = 'Solamente guardar logs para los trabajos que fallen';
$string['task_logmode_none'] = 'No registrar en log nada';
$string['task_logretainruns'] = 'Retener ejecuciones';
$string['task_logretainruns_desc'] = 'El número de ejecuciones de cada trabajo a retener. Esta configuración interactúa con la configuración de \'Período de retención\': la que sea alcanzada primero se aplicará';
$string['task_logretention'] = 'Período de retención';
$string['task_logretention_desc'] = 'El período máximo por el que deberían de conservarse los logs. Esta configuración interactúa con la configuración de \'Retener ejecuciones\': la que sea alcanzada primero se aplicará.';
$string['task_logtostdout'] = 'Mostrar salida de log';
$string['task_logtostdout_desc'] = 'Cuando se están ejecutando trabajos y la salida es capturada, si además la salida capturada también debe mostrarse a medida que se ejecuta la tarea.';
$string['task_result'] = 'Resultado';
$string['task_result:failed'] = 'Fallo';
$string['task_scheduled_concurrency_limit'] = 'Límite de concurrencia de tareas programadas';
$string['task_scheduled_concurrency_limit_desc'] = 'El número de tareas programas permitidas para que corran concurrentemente. Si el límite es alto entonces el servidor podría experimentar una alta carga que afecte el desempeño. Una configuración de 0 deshabilitará completamente el procesamiento de trabajos programados.';
$string['task_scheduled_max_runtime'] = 'Tiempo de vida de una tarea programada';
$string['task_scheduled_max_runtime_desc'] = 'La edad de una tarea programado antes de que sea liberada.';
$string['task_starttime'] = 'Hora de comienzo';
$string['task_stats:dbreads'] = '{$a} lecturas';
$string['task_stats:dbwrites'] = '{$a} escrituras';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Programado';
$string['taskadmintitle'] = 'Tareas';
$string['taskanalyticscleanup'] = 'Limpieza de Analítica';
$string['taskautomatedbackup'] = 'Copias de seguridad automáticas';
$string['taskbackupcleanup'] = 'Limpiar copias de seguridad y logs';
$string['taskbadgescron'] = 'Insignias del premio';
$string['taskbadgesmessagecron'] = 'Procesamiento en segundo plano para enviar notificaciones de insignias';
$string['taskblogcron'] = 'Sincronizar blogs externos';
$string['taskcachecleanup'] = 'Eliminar entradas de caché expiradas';
$string['taskcachecron'] = 'Procesamiento de cachés en segundo plano';
$string['taskcalendarcron'] = 'Enviar notificaciones de calendario';
$string['taskcheckforupdates'] = 'Comprobar actualizaciones';
$string['taskcompletiondaily'] = 'Marcado diario de finalización de actividades y cursos';
$string['taskcompletionregular'] = 'Marcado continuo de finalización de actividades y cursos';
$string['taskcontextcleanup'] = 'Limpiar contextos';
$string['taskcreatecontexts'] = 'Crear contextos que faltan';
$string['taskdeletecachetext'] = 'Eliminar registros de caché antiguos';
$string['taskdeleteincompleteusers'] = 'Eliminar usuarios incompletos';
$string['taskdeleteunconfirmedusers'] = 'Eliminar usuarios no confirmados';
$string['taskeventscron'] = 'Procesamiento en segundo plano de eventos';
$string['taskfiletrashcleanup'] = 'Limpiar archivos en la papelera';
$string['taskglobalsearchindex'] = 'Indexado de búsqueda global';
$string['taskglobalsearchoptimize'] = 'Optimización del indexado de búsqueda global';
$string['taskgradecron'] = 'Procesamiento en segundo plano del libro de calificaciones';
$string['taskgradehistorycleanup'] = 'Procesamiento en segundo plano para limpiar tablas de historia de calificación';
$string['tasklegacycron'] = 'Procesamiento heredado de extensiones';
$string['tasklogcleanup'] = 'Limpieza de logs de tareas';
$string['tasklogging'] = 'Configuración de logs de tareas';
$string['tasklogs'] = 'Logs de tareas';
$string['taskmessagingcleanup'] = 'Procesamiento en segundo plano de la mensajería';
$string['taskpasswordresetcleanup'] = 'Limpiar intentos de restablecimiento de contraseña';
$string['taskplagiarismcron'] = 'Procesamiento en segundo plano para cron heredado en las extensiones de plagio';
$string['taskportfoliocron'] = 'Procesamiento en segundo plano de los extensiones de portfolio';
$string['taskprocessing'] = 'Procesamiento de Tareas';
$string['taskquestioncron'] = 'Procesamiento en segundo plano para limpieza de vistas previas de preguntas';
$string['taskquestionstatscleanupcron'] = 'Procesamiento en segundo plano para limpieza de caché de estadísticas de pregunta';
$string['taskrefreshsystemtokens'] = 'Refrescar los símbolos OAuth para los servicios de cuenta';
$string['taskregistrationcron'] = 'Registro en el Sitio';
$string['tasksendfailedloginnotifications'] = 'Enviar notificaciones de inicio de sesión fallidos';
$string['tasksendnewuserpasswords'] = 'Enviar nuevas contraseñas de usuario';
$string['tasksessioncleanup'] = 'Limpiar sesiones antiguas';
$string['taskstatscron'] = 'Procesamiento en segundo plano de las estadísticas';
$string['tasktagcron'] = 'Procesamiento en segundo plano de las etiquetas';
$string['tasktempfilecleanup'] = 'Eliminar archivos temporales obsoletos';
$string['tasktype'] = 'Tipo';
$string['tempdatafoldercleanup'] = 'Borrar ficheros de datos temporales más viejos de';
$string['templates'] = 'Plantillas';
$string['testoutgoingmailconf'] = 'Probar configuración de correo saliente';
$string['testoutgoingmailconf_errorcommunications'] = 'Moodle no se pudo comunicar con su servidor de correo. Por favor revise su configuración del correo saliente de Moodle.';
$string['testoutgoingmailconf_message'] = 'Este es un mensaje de prueba que significa que ha configurado exitosamente sus configuraciones de E-mail saliente del sitio.';
$string['testoutgoingmailconf_sendtest'] = 'Enviar un mensaje de prueba';
$string['testoutgoingmailconf_sentmail'] = 'Moodle envió con éxito el mensaje de prueba al servidor de correo.<br />De: {$a->fromemail}<br />Para: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a}: mensaje de prueba';
$string['testoutgoingmailconf_toemail'] = 'Para la dirección de Email';
$string['testoutgoingmaildetail'] = 'Nota: Antes de probar, por favor guarde su configuración.<br />{$a}';
$string['testsiteupgradewarning'] = 'En este momento está usando el sitio de prueba {$a}; para actualizarlo correctamente utilice la herramienta de línea de comandos';
$string['themedesignermode'] = 'Modo de diseño de temas';
$string['themedesignermodewarning'] = 'Está activado el Modo de diseñador de tema. Este no debe estar activado en entornos de producción ya que puede reducir significativamente su rendimiento.';
$string['themelist'] = 'Lista de temas';
$string['themenoselected'] = 'No hay tema seleccionado';
$string['themeresetcaches'] = 'Borrar cachés de temas';
$string['themeselect'] = 'Cambiar tema';
$string['themeselector'] = 'Selector de temas';
$string['themesettings'] = 'Ajustes de temas';
$string['therewereerrors'] = 'Hay errores en sus datos';
$string['thirdpartylibrary'] = 'Biblioteca';
$string['thirdpartylibrarylocation'] = 'Ubicación';
$string['thirdpartylibs'] = 'Bibliotecas de terceros';
$string['timezone'] = 'Zona horaria por defecto';
$string['timezoneforced'] = 'Esta opción está forzada por el administrador del sitio';
$string['timezoneinvalid'] = 'Zona "{$a}" horaria no válida';
$string['timezoneisforcedto'] = 'Forzar a todos los usuarios a utilizar';
$string['timezonenotforced'] = 'Los usuarios pueden elegir su propia zona horaria';
$string['timezonephpdefault'] = 'Zona horaria por defecto de PHP ({$a})';
$string['timezoneserver'] = 'Zona horaria del servidor ({$a})';
$string['tlswarning'] = 'No se ha detectado la extensión PHP/cURL con soporte para TLSv1.2. Puede que algunos servicios no funcionen. Es altamente recomendado el actualizar las librerías TLS.';
$string['tokenduration'] = 'Duración del token creado por usuario';
$string['tokenduration_desc'] = 'Tiempo que un token para servicios web creado por un usuario (por ejemplo, mediante la aplicación móvil) será válido.';
$string['tokenizerrecommended'] = 'Se recomienda instalar la extensión opcional PHP Tokenizer -- Mejora la funcionalidad red de Moodle (\'Moodle Networking\').';
$string['tools'] = 'Herramientas de administración';
$string['toolsmanage'] = 'Gestionar herramientas de administración';
$string['unattendedoperation'] = 'Operación no atendida';
$string['unbookmarkthispage'] = 'Desmarcar esta página';
$string['unicoderequired'] = 'Es necesario que almacene todos sus datos en formato Unicode (UTF-8). Las instalaciones nuevas deberían ejecutarse en bases de datos cuyo juego de caracteres por defecto fuera Unicode. Si está realizando una actualización, debería llevar a cabo el proceso de migración UTF-8 (vea al respecto la página de Administración).';
$string['uninstallplugin'] = 'Desinstalar';
$string['unlockaccount'] = 'Desbloquear cuenta';
$string['unoconvwarning'] = 'La versión de unoconv que tienes instaladas no está soportada. La aplicación de evaluación de tareas de Moodle requiere la versión 0.7 o superior.';
$string['unsettheme'] = 'Desmarcar tema';
$string['unsupported'] = 'No admitido';
$string['unsupporteddbfileformat'] = 'Su base de datos utiliza Antelope como formato de archivo. La compatibilidad total con UTF-8 en MySQL y MariaDB requiere el formato de archivo Barracuda. Por favor, cambie al formato de archivo Barracuda. Consulte la documentación <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support"> MySQL full unicode support </a> para obtener más detalles.';
$string['unsupporteddbfilepertable'] = 'Para el soporte completo de UTF-8 en MySQL y MariaDB se requiere cambiar la opción de MySQL \'innodb_file_per_table\' a \'ON\'. Mira la documentación para más detalles.';
$string['unsupporteddblargeprefix'] = 'Para el soporte completo de UTF-8 en MySQL y MariaDB se requiere cambiar la opción de MySQL \'innodb_large_prefix\' a \'ON\'. Mira la documentación para más detalles.';
$string['unsupporteddbstorageengine'] = 'El motor de almacenamiento de base de datos que se utiliza ya no es compatible.';
$string['unsupporteddbtablerowformat'] = 'Su base de datos tiene tablas utilizando el formato de fichero Antelope. Se le recomienda convertir las tablas al formato de fichero Barracuda. Revise la documentación <a href="https://docs.moodle.org/29/en/Administration_via_command_line">Administración mediante línea de comandos</a> para detalles de la herramienta para convertir tablas InnoDB a Barracuda.';
$string['unsupportedphpversion7'] = 'La versión 7 de PHP no está soportada.';
$string['unsupportedphpversion71'] = 'PHP versión 7.1 no es compatible.';
$string['unsupportedphpversion72'] = 'Versión 7.2 de PHP no soportada.';
$string['unsupportedphpversion73'] = 'La versión 7.3 de PHP no está soportada.';
$string['unsupportedphpversion74'] = 'La versión 7.4 de PHP, no está soportada.';
$string['unsupportedphpversion80'] = 'La versión de PHP 8.0 no está soportada.';
$string['unsupportedphpversion81'] = 'Versión de PHP 8.1 y superiores no soportadas.';
$string['unsupportedphpversion82'] = 'Versión de PHP 8.2 y superior no soportada.';
$string['unsuspenduser'] = 'Activar cuenta de usuario';
$string['updateaccounts'] = 'Actualizar cuentas existentes';
$string['updateautocheck'] = 'Compruebe automáticamente las actualizaciones disponibles';
$string['updateautocheck_desc'] = 'Si está habilitado, su sitio comprobará automáticamente actualizaciones disponibles, tanto para Moodle como para las extensiones adicionales. Si hay una nueva actualización disponible, se enviará una notificación a los administradores.';
$string['updateavailable'] = '¡Hay una nueva versión de Moodle disponible!';
$string['updateavailable_moreinfo'] = 'Más información...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versión {$a}';
$string['updateavailabledetailslink'] = 'Vea {$a->url} para más detalles';
$string['updateavailableforplugin'] = '¡Hay nuevas versiones disponibles para algunas de sus extensiones!';
$string['updateavailableinstall'] = 'Instalar esta actualización';
$string['updateavailableinstallall'] = 'Instalar actualizaciones disponibles ({$a})';
$string['updateavailableinstallallhead'] = 'Instalando actualizaciones disponibles';
$string['updateavailablenot'] = 'Su Moodle está actualizado';
$string['updateavailablerecommendation'] = 'Se recomienda encarecidamente que actualice su sitio a la última versión para obtener todas las correcciones de bugs y de seguridad recientes.';
$string['updatecomponent'] = 'Actualizar componente';
$string['updateminmaturity'] = 'Madurez requerida del código';
$string['updateminmaturity_desc'] = 'Notificarme las actualizaciones disponibles sólo si el código tiene al menos el nivel de madurez del código seleccionado. Las actualizaciones para las extensiones que no declaran su nivel de madurez de código se reportan siempre sin tener en cuenta este ajuste.';
$string['updatenotificationfooter'] = 'Su sitio Moodle {$a->siteurl} está configurado para buscar automáticamente actualizaciones disponibles. Estás recibiendo este mensaje como administrador del sitio. Puede desactivar las comprobaciones automáticas de las actualizaciones disponibles en Administración del sitio / Servidor / Notificaciones de actualización o personalizar la entrega de este mensaje a través de su página de preferencias.';
$string['updatenotifications'] = 'Notificaciones de actualización';
$string['updatenotificationsubject'] = 'Actualizaciones de Moodle disponibles ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notificación de nuevas compilaciones';
$string['updatenotifybuilds_desc'] = 'Si está activado, la comprobación de actualizaciones del código de Moodle también informa cuando hay una disponible una nueva compilación de la versión actual. Normalmente hay nuevas compilaciones cada semana. Si está desactivado, se informará solamente cuando se libere una versión superior de Moodle. Compruebe que las extensiones no se vean afectadas por este ajuste.';
$string['upgradeerror'] = 'Error desconocido al actualizar {$a->plugin} a la versión {$a->version}. No puede continuar.';
$string['upgradeforumread'] = 'Se ha incorporado a Moodle 1.5 una nueva característica para rastrear mensajes enviados al foro leídos y no leídos.<br />Para hacer uso de esta funcionalidad, necesita <a href="{$a}">actualizar sus tablas</a>.';
$string['upgradeforumreadinfo'] = 'Se ha incorporado a Moodle 1.5 una nueva funcionalidad para rastrear mensajes enviados al foro leídos y no leídos. Para hacer uso de ella, necesita actualizar sus tablas con toda la información concerniente a los mensajes existentes. Dependiendo del tamaño del sitio, esto puede llevar mucho tiempo (horas) y hacer un uso intensivo de la base de datos, de modo que es mejor llevar a cabo esta operación durante un período de tranquilidad. Sin embargo, el sitio continuará funcionando durante la actualización y los usuarios no se verán afectados. Una vez que comience este proceso, debería dejarlo terminar (i.e., mantenga abierta la ventana del navegador). En todo caso, si detiene el proceso cerrando la ventana, no se preocupe, siempre podrá recomenzar.<br /><br />¿Desea comenzar el proceso de actualización ahora?';
$string['upgradekeyreq'] = 'Clave de actualización requerida';
$string['upgradekeyset'] = 'Clave de actualización (dejar en blanco para no establecerla)';
$string['upgradelogs'] = 'Para conseguir una funcionalidad total, sus registros antiguos deben ser actualizados. <a href="{$a}">Más información</a>';
$string['upgradelogsinfo'] = 'Recientemente se han llevado a cabo algunos cambios en la forma en que se almacenan los registros. Para poder ver sus registros antiguos clasificados por actividad, esos registros se deben actualizar. Dependiendo del tamaño de su sitio este proceso puede tardar bastante tiempo (e.g., varias horas) puesto que habrá de consultar continuamente la base de datos. Una vez iniciado el proceso debe permitir que llegue a su fin (manteniendo la ventana de su navegador abierta). No se preocupe: durante este proceso su sitio funcionará correctamente para los otros usuarios.<br /><br /> ¿Desea actualizar sus registros ahora?';
$string['upgradepluginsfirst'] = 'Se recomienda instalar primero todas las actualizaciones disponibles';
$string['upgradepluginsinfo'] = 'Actualizando extensiones';
$string['upgradepluginsinfo_help'] = 'Hay actualizaciones disponibles para algunas de sus extensiones. Debería instalar todas ellas antes de actualizar la base de datos de Moodle. Si su sitio no admite la distribución de actualizaciones automática, tendrá que descargar e instalar en el servidor las nuevas versiones de la extensión de forma manual.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nuevos ajustes';
$string['upgradesettingsintro'] = 'Las configuraciones que se muestran a continuación se agregaron durante su última actualización de Moodle. Realice los cambios necesarios en los valores predeterminados y luego haga clic en el botón \'Guardar cambios\' en la parte inferior de esta página.';
$string['upgradestalefiles'] = 'Se ha detectado una mezcla de versiones de Moodle . La actualización no puede continuar.';
$string['upgradestalefilesinfo'] = 'El proceso de actualización de Moodle se ha detenido debido a los scripts PHP a partir de al menos dos versiones principales de Moodle se han detectado en el directorio Moodle.

Esto puede causar problemas significativos después, por lo que a fin de continuar debe asegurarse de que el directorio Moodle contiene sólo los archivos para una única versión de Moodle.

El método recomendado para limpiar su directorio Moodle es el siguiente:

* Cambiar el nombre del directorio actual de Moodle "moodle_old"
* Crear un nuevo directorio Moodle que contiene sólo los archivos desde un paquete de descarga estándar de Moodle, o desde el repositorio Git Moodle
* Mover el archivo config.php original y plugins no estándar desde el directorio "moodle_old" al nuevo directorio Moodle

Cuando usted tiene un directorio Moodle limpio, volver a cargar esta página para reanudar el proceso de actualización de Moodle.

Esta advertencia es a menudo causada por descomprimir un paquete estándar de Moodle sobre una versión anterior de Moodle. Si bien esto está bien para mejoras de menor importancia, se desaconseja para las principales actualizaciones de Moodle.

Esta advertencia también puede ser causada por un pago y envío o actualización incompleta operación del repositorio Git, en cuyo caso es posible que sólo tenga que esperar a que se complete la operación, o tal vez ejecute el comando de limpieza apropiado y vuelva a intentar la operación.

Puede encontrar más información en la documentación de actualización en <a href="{$a}"> {$ a} </a>.';
$string['upgradestart'] = 'Actualizar base de datos Moodle ahora';
$string['upgradesure'] = 'Sus archivos Moodle han sido modificados, y usted está a punto de actualizar automáticamente su servidor a esta versión:<br /><br /><strong>
{$a}</strong><br /><br />
Una vez que haga esto, no podrá volver atrás.<br /><br />Por favor, tenga en cuenta que este proceso puede tardar bastante tiempo.<br /><br />
¿Está seguro de que quiere actualizar este servidor a esta versión?';
$string['upgradetimedout'] = 'Se acabó el tiempo de actualización; por favor, reinicie la actualización.';
$string['upgradingdata'] = 'Actualizando los datos';
$string['upgradinglogs'] = 'Actualizando los registros';
$string['upgradingversion'] = 'Actualizando la versión';
$string['upwards'] = 'arriba';
$string['useblogassociations'] = 'Habilitar asociaciones';
$string['useexternalyui'] = 'Usar librerías YUI en línea';
$string['user'] = 'Usuario';
$string['userbulk'] = 'Acciones de usuario masivas';
$string['userbulkdownload'] = 'Exportar usuarios como';
$string['userdefaultpreferences'] = 'Preferencias predeterminadas del usuario';
$string['userfeedbackafterupgrade'] = 'Luego de cada actualización mayor';
$string['userfeedbackencouragement'] = '<p>Moodle 3.9 incluye nuevas funciones que le permiten al usuario la opción de proveer retroalimentación acerca del software Moodle a Moodle HQ a través de una encuesta externa almacenada en el sitio de Moodle HQ. Ninguna información de usuarios será enviada al servidor de la encuesta.</p>
<p>Moodle HQ se esfuerza para ser abierto y transparente acerca de las prácticas de  recolección de información. Por esto, queremos asegurarnos que ud. está al tanto y en control de esta funcionalidad.</p>
<p>La retroalimentación de los usuarios asistirá enormemente a Moodle HQ en mejorar el software Moodle. Para habilitar esta función, por favor, vaya a <a href="{$a}">Configuración de retroalimentación</a>.</p>';
$string['userfeedbacknextreminder'] = 'Siguiente recordatorio de comentarios';
$string['userfeedbacknextreminder_desc'] = '¿Cuándo deberíamos pedirle al usuario que vuelva a dar su opinión?';
$string['userfeedbackperiodically'] = 'Periódicamente';
$string['userfeedbackremindafter'] = 'Mostrar recordatorio después';
$string['userfeedbackremindafter_desc'] = 'Recuerde a los usuarios de nuevo que den su opinión después de la cantidad de días indicada.';
$string['userfiltersdefault'] = 'Filtros predeterminados del usuario';
$string['userfiltersdefault_desc'] = 'Seleccione los filtros que deben mostrarse en la página \'Examinar lista de usuarios\' y en la página \'Acciones masivas de usuario\'. Mantenga presionada la tecla Ctrl para seleccionar varios elementos. Cualquier filtro no seleccionado estará disponible haciendo clic en el enlace \'Mostrar más\'.';
$string['userimagesdisabled'] = 'Imágenes en el perfil de usuario están deshabilitadas.';
$string['userlist'] = 'Examinar lista de usuarios';
$string['usermanagement'] = 'Gestión de usuarios';
$string['userpolicies'] = 'Políticas de usuario';
$string['userpreference'] = 'Preferencias del usuario';
$string['userquota'] = 'Espacio de archivos privados';
$string['userquota_desc'] = 'La cantidad máxima de datos que cada usuario puede almacenar en su área de archivos privados.';
$string['users'] = 'Usuarios';
$string['usesitenameforsitepages'] = 'Usa el nombre del sitio en las páginas del sitio';
$string['usetags'] = 'Activar funcionalidad de las marcas';
$string['validateemptylineerror'] = 'No son válidas líneas vacías';
$string['validateerror'] = 'Este valor no es válido';
$string['validateerrorlist'] = 'Estas entradas son inválidas: {$a}';
$string['validateiperror'] = 'Estas direcciones IP no son válidas: {$a}';
$string['verifychangedemail'] = 'Restringir los dominios cuando se modifique el correo electrónico';
$string['warningcurrentsetting'] = 'Valor actual no válido: {$a}';
$string['warningiconvbuggy'] = 'Su versión de la biblioteca de iconv no soporta el modificador  //IGNORE. Usted debe instalar la extensión mbstring que puede emplearse en su lugar para limpiar cadenas que contengan caracteres UTF-8 inválidos.';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Complete las siguientes opciones si su servidor Moodle no puede acceder a Internet directamente. Se requiere acceso a Internet para descargar datos del entorno, paquetes de idioma, fuentes RSS, zonas horarias, etc.<br/><em> Se recomienda encarecidamente la extensión PHP cURL.</em>';
$string['xmlrpcmaharaenabled'] = 'Se ha detectado que Mahara ePortfolio está habilitado en su sitio. Esta función se basa en la extensión PHP XML-RPC que PHP ya no mantiene.';
$string['xmlrpcmnetenabled'] = 'Se ha detectado que Moodle Networking está habilitado en su sitio. Esta función se basa en la extensión PHP XML-RPC que PHP ya no mantiene.';
$string['xmlrpcrecommended'] = 'La extensión XMLRPC es útil para servicios web y redes Moodle.';
$string['xmlrpcwebserviceenabled'] = 'Se ha detectado que el protocolo XML-RPC Web Service está habilitado en su sitio. Esta función se basa en la extensión PHP XML-RPC que PHP ya no mantiene.';
$string['yuicomboloading'] = 'Carga de combo YUI';
$string['ziprequired'] = 'Moodle requiere ahora la extensión Zip PHP. Ya no se usan ni las binarias info-ZIP ni la librería PclZip.';
