<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'publication', language 'ja', version '3.9'.
 *
 * @package     publication
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_uploads'] = 'ファイルを追加する';
$string['allfiles'] = 'すべてのファイル';
$string['allowedfiletypes'] = '許可されるファイルタイプ';
$string['allowedfiletypes_err'] = '入力をチェックしてください! 無効なファイル拡張子またはセパレータです。';
$string['allowedfiletypes_help'] = '許可されるファイルタイプはカンマで区切られた mimetypeのリスト (例「video/mp4, audio/mp3, image/png, image/jpeg」) またはドットを含むファイル拡張子 (例「.png, .jpg」を入力して制限できます。フィールドが空白の場合、すべてのファイルタイプが許可されます。';
$string['allowsubmissionsanddescriptionfromdatesummary'] = '課題詳細および提出フォームは <strong>{$a}</strong> から入手可能です。';
$string['allowsubmissionsfromdate'] = '開始';
$string['allowsubmissionsfromdate_import'] = '承認開始';
$string['allowsubmissionsfromdateh_help'] = 'あなたは学生がファイルをアップロードできる期間またはファイル公開を承認する期間を設定できます。この期間中、学生はファイルを編集および公開の承認を取り消せます。';
$string['allowsubmissionsfromdatesummary'] = 'この課題は <strong>{$a}</strong> からの提出を受け付けます。';
$string['alwaysshowdescription'] = '常に説明を表示する';
$string['approval_timeover'] = 'あなたは変更期間中のみ承認を変更できます。';
$string['approvalchange'] = '承認ステータスが変更されました。';
$string['approved'] = '承認済み';
$string['assignment'] = '課題';
$string['assignment_help'] = 'ファイルをインポートする課題を選択してください。現在のところ、グループ課題はサポートされていないため選択できません。';
$string['assignment_notfound'] = 'ファイルがインポートされた課題が見つかりませんでした。';
$string['assignment_notset'] = '選択された課題はありません。';
$string['configautoimport'] = 'あなたが学生の提出物を自動的に学生フォルダインスタンスにインポートしたい場合、この設定を有効にしてください。この機能は学生フォルダインスタンスごとに個別に有効/無効を設定できます。';
$string['configmaxbytes'] = '学生フォルダ内すべてのファイルのデフォルトの最大サイズです。';
$string['configmaxfiles'] = 'ユーザーごとに許可される添付のデフォルトの最大数です。';
$string['configobtainstudentapproval'] = 'ドキュメントは学生の承認後に閲覧可能となります。';
$string['configobtainteacherapproval'] = '学生のドキュメントはデフォルトで他のすべての参加者が閲覧できます。';
$string['configrequiremodintro'] = 'あなたがユーザにそれぞれの活動の説明を入力させたくない場合、このオプションを無効にしてください。';
$string['courseuploadlimit'] = 'コースアップロード制限';
$string['cutoffdate'] = '遮断日';
$string['cutoffdate_help'] = 'この設定を有効にした場合、提出期限を延長しない限り、この期日経過後の提出は受け付けられません。';
$string['cutoffdate_import'] = '最終承認';
$string['cutoffdatefromdatevalidation'] = '遮断日は提出許可日以降にする必要があります。';
$string['cutoffdatevalidation'] = '遮断日は提出期限以前にできません。';
$string['details'] = '詳細';
$string['downloadall'] = 'すべてのファイルをZIPとしてダウンロードする';
$string['duedate'] = '終了';
$string['duedate_help'] = 'これは課題の提出期限です。この日以降も提出は許可されますが、この日以降に提出された課題は遅延マークされます。特定の日付以降の提出を防ぐには課題遮断日を設定してください。';
$string['duedate_import'] = '承認終了';
$string['duedatevalidation'] = '提出期限は提出許可日以降にする必要があります。';
$string['edit_timeover'] = 'ファイルは変更期間中のみ編集可能です。';
$string['emailteachermail'] = '{a->username} が「 {$a->publication} 」に対する「 {$a->filename} 」をアップロードしました ({$a->dayupdated} {$a->timeupdated})。
次で確認できます: {a->url}';
$string['emailteachermailhtml'] = '{a->username} が「 {$a->publication} 」に対する「 {$a->filename} 」をアップロードしました ({$a->dayupdated} {$a->timeupdated})。
<br /><br />
<a href="{$a->url}">ウェブサイトで内容を確認できます</a>。';
$string['entiresperpage'] = '1ページあたりの参加者数';
$string['eventpublicationapprovalchanged'] = '公開ファイルの承認が変更されました。';
$string['eventpublicationduedateextended'] = '公開ファイルの期限が延長されました。';
$string['eventpublicationfiledeleted'] = '公開ファイル削除';
$string['eventpublicationfileimported'] = '公開ファイルインポート';
$string['eventpublicationfileuploaded'] = '公開ファイルアップロード';
$string['extensionduedate'] = '延長期限';
$string['extensionnotafterduedate'] = '延長日は期限後にする必要があります。';
$string['extensionnotafterfromdate'] = '延長日は提出許可日以降にする必要があります。';
$string['extensionto'] = '延長:';
$string['filedetails'] = '詳細';
$string['filesofthesetypes'] = 'これらのタイプのファイルを追加できます:';
$string['go'] = 'Go';
$string['groupapprovalmode'] = 'グループ承認モード';
$string['groupapprovalmode_all'] = 'すべてのグループメンバーの承認を必要とする';
$string['groupapprovalmode_help'] = 'ここであなたはファイルを表示するためにグループメンバ全員の承認が必要か、少なくとも1名のグループメンバの承認が必要かを決定します。ファイルはグループメンバ全員または少なくとも1名のグループメンバの承認後にのみ表示されます。';
$string['importfrom_err'] = 'あなたがインポートしたい課題を選択する必要があります。';
$string['maxbytes'] = '最大添付サイズ';
$string['maxfiles'] = '最大添付数';
$string['messageprovider:publication_updates'] = '公開通知';
$string['mode'] = 'モード';
$string['mode_help'] = '学生がフォルダ内のドキュメントをアップロードできるか、課題のドキュメントがそのソースであるか選択してください。';
$string['modulename'] = '学生フォルダ';
$string['modulename_help'] = '学生フォルダには以下の機能があります:
* 参加者はドキュメントをアップロードできます。ドキュメントはすぐにまたはあなたが確認および承認した後に他の参加者が利用できます。
* 課題を学生フォルダのベースとして選択できます。教師はすべての参加者がどの課題のドキュメントを閲覧できるか決定できます。教師は自分のドキュメントを他の参加者に見せるかどうか参加者に決定させることもできます。';
$string['modulenameplural'] = '学生フォルダ';
$string['myfiles'] = '自分のファイル';
$string['mygroupfiles'] = 'マイグループファイル';
$string['name'] = '学生フォルダ名';
$string['noentries'] = 'エントリなし';
$string['nofiles'] = '利用可能なファイルはありません。';
$string['nofilestozip'] = 'ZIP圧縮するファイルはありません。';
$string['nonexistentfiletypes'] = '次のファイルタイプが認識されませんでした: {$a}';
$string['nopublicationsincourse'] = 'このコースには学生フォルダのインスタンスはありません。';
$string['nothingtodisplay'] = '表示するエントリはありません。';
$string['notice'] = '注意:';
$string['notice_groupimportrequireallapproval'] = 'あなたのファイルを誰でも利用できるようにするかどうか決定します。ファイルを公開するにはすべてのグループメンバの承認が必要です。';
$string['notice_groupimportrequireoneapproval'] = 'あなたのファイルを誰でも利用できるようにするかどうか決定します。ファイルを公開するにはグループメンバ1名の承認で十分です。ファイルを承認する前にあなたのファイルを公開するかどうかグループ内で話し合ってください!';
$string['notice_importnoapproval'] = '次のファイルは誰でも閲覧できます。';
$string['notice_importrequireapproval'] = 'あなたのファイルを誰でも利用できるかどうかを決定します。';
$string['notice_uploadnoapproval'] = 'すべてのファイルはアップロードされた時点ですぐに誰でも閲覧できます。教師は公開されたファイルをいつでも秘匿できる権利を留保します。';
$string['notice_uploadrequireapproval'] = 'すべてのアップロードされたファイルは教師の確認後のみ閲覧可能となります。';
$string['notifications'] = '通知';
$string['notifystudents'] = '承認変更に関して学生に通知する';
$string['notifystudents_help'] = 'この設定を有効にした場合、学生はアップロードの承認ステータスが変更されるたびにメッセージを受信します。メッセージ方法は設定可能です。';
$string['obtainstudentapproval'] = '承認を取得する';
$string['obtainteacherapproval'] = 'デフォルトで承認する';
$string['optionalsettings'] = 'オプション';
$string['pending'] = '保留中';
$string['pluginadministration'] = '学生フォルダ管理';
$string['pluginname'] = '学生フォルダ';
$string['privacy:metadata:approval'] = 'グループメンバがファイルを承認したか拒否したか。';
$string['privacy:metadata:contenthash'] = 'ファイルが変更されたかどうか判断するために使用されるファイルコンテンツのSHA1ハッシュです。';
$string['privacy:metadata:extduedates'] = 'mod_publicationのオーバーライド/延長された期限に関する情報を保存します。';
$string['privacy:metadata:extensionduedate'] = 'オーバーライド/延長を原因とするユーザの有効な期限です。';
$string['privacy:metadata:fileid'] = 'ファイルの識別子です。';
$string['privacy:metadata:filename'] = 'ファイル名';
$string['privacy:metadata:files'] = 'mod_publicationにアップロード/インポートされたファイルに関する情報 (識別子、所有者、入手元、コンテンツハッシュ、ファイル名、教師または学生の承認の有無) を保存します。';
$string['privacy:metadata:groupapproval'] = 'グループ提出からインポートされたファイルのグループメンバ承認または拒否に関する情報を保存します。';
$string['privacy:metadata:publicationfileexplanation'] = 'このプラグインのファイルおよび変換されたオンラインテキスト提出はMoodleのファイルAPI経由で保存されます。';
$string['privacy:metadata:publicationperpage'] = '単一テーブルページににいくつのエントリを表示しますか!';
$string['privacy:metadata:studentapproval'] = '学生がファイルを承認したか拒否したか。';
$string['privacy:metadata:teacherapproval'] = '教師がファイルを承認したか拒否したか。';
$string['privacy:metadata:timecreated'] = 'データレコードが作成された日時です。';
$string['privacy:metadata:timemodified'] = 'データレコードが更新/変更された最新の日時です。';
$string['privacy:metadata:type'] = 'ファイルの発生元をマークする (学生によるアップロード、提出課題からのインポートまたは提出課題からオンラインテキストへの変換)。';
$string['privacy:metadata:userid'] = 'ユーザの識別子です。';
$string['publication:addinstance'] = '新しい学生フォルダを追加する';
$string['publication:approve'] = 'すべての学生にファイルを表示するかどうか決定する';
$string['publication:grantextension'] = '延長を許可する';
$string['publication:receiveteachernotification'] = '教師への通知を受信する';
$string['publication:upload'] = 'ファイルを学生フォルダにアップロードする';
$string['publication:view'] = '学生フォルダを閲覧する';
$string['publicfiles'] = '公開ファイル';
$string['rejected'] = '却下';
$string['requiremodintro'] = '活動説明を必要とする';
$string['reset'] = '元に戻す';
$string['reset_userdata'] = 'すべてのデータ';
$string['resetstudentapproval'] = 'ステータスをリセットする';
$string['save_changes'] = '変更を保存する';
$string['search:activity'] = '学生フォルダ - 活動情報';
$string['show_details'] = '詳細を表示する';
$string['status'] = 'ステータス';
$string['studentapproval'] = 'ステータス';
$string['teacher_rejected'] = '拒否';
$string['teacherapproval'] = '承認';
$string['updatefiles'] = 'ファイルを更新する';
$string['updatefileswarning'] = '学生フォルダ内の個々の学生のファイルは学生の課題提出により更新されます。すでに表示されている学生のファイルが削除または更新された場合も置き換えられます - 可視性に関する学生の設定は変更されません。';
$string['uploaded'] = 'アップロード済み';
$string['warning_changefromobtainstudentapproval'] = 'この変更を実行した場合、あなたのみすべての学生にどのファイルを公開するか決定できます。学生に承認は求められません。承認済みとマークされたすべてのファイルは学生の決定とは無関係にすべての学生に閲覧可となります。';
$string['warning_changefromobtainteacherapproval'] = 'この設定を有効にした場合、すべてのアップロード済みファイルは他の参加者に公開されます。すべてのアップロード済みファイルは閲覧可能となります。あなたは特定の学生に対して手動でファイルを閲覧不可にできます。';
$string['warning_changetoobtainstudentapproval'] = 'あなたがこの変更を実行した場合、学生は閲覧可マークが付けられたすべてのファイルに関して承認が求められます。ファイルは学生が承認した場合のみ、閲覧可能となります。';
$string['warning_changetoobtainteacherapproval'] = 'この設定を無効にした場合、アップロードされたファイルは自動的に他の参加者から閲覧できなくなります。あなたはどのファイルを公開するか決定する必要があります。すでに公開されているファイルは表示されなくなります。';
$string['withselected'] = '選択したものに対して ...';
$string['zipusers'] = 'ZIPとしてダウンロードする';
