<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'eu', version '3.8'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'E';
$string['Afull'] = 'Ez dago';
$string['Eacronym'] = 'S';
$string['Efull'] = 'Salbuetsia';
$string['Lacronym'] = 'B';
$string['Lfull'] = 'Berandu';
$string['Pacronym'] = 'P';
$string['Pfull'] = 'Presente';
$string['absenteereport'] = 'Absentismoaren txostena';
$string['acronym'] = 'Akronimoa';
$string['add'] = 'Gehitu';
$string['addedrecip'] = 'Jasotzaile berri {$a} gehitu da';
$string['addedrecips'] = '{$a} jasotzaile berri gehitu dira';
$string['addmultiplesessions'] = 'Saio errepikakorra';
$string['addsession'] = 'Gehitu saioa';
$string['adduser'] = 'Gehitu erabiltzailea';
$string['addwarning'] = 'Gehitu abisua';
$string['all'] = 'Guztiak';
$string['allcourses'] = 'Ikastaro guztiak';
$string['allpast'] = 'Iraganeko guztiak';
$string['allsessions'] = 'Saio guztiak';
$string['allsessionstotals'] = 'Aukeratutako saioetarako guztirakoak';
$string['attendance:addinstance'] = 'Gehitu bertaratzearen erregistroaren jarduera berri bat';
$string['attendance:canbelisted'] = 'Zerrendan agertzen da';
$string['attendance:changeattendances'] = 'Bertaratzearen erregistroak aldatzen';
$string['attendance:changepreferences'] = 'Hobespenak aldatzen';
$string['attendance:export'] = 'Esportatu txostenak';
$string['attendance:manageattendances'] = 'Kudeatu bertaratzeak';
$string['attendance:managetemporaryusers'] = 'Kudeatu behin behineko erabiltzaileak';
$string['attendance:takeattendances'] = 'Bertaratzeak jasotzen';
$string['attendance:view'] = 'Bertaratzeak ikusten';
$string['attendance:viewreports'] = 'Txostenak ikusten';
$string['attendance:viewsummaryreports'] = 'Ikusi ikastaroko laburpen-txostenak';
$string['attendance:warningemails'] = 'Ez dauden erabiltzaileak dituen e-mailetara harpidetu daiteke';
$string['attendance_already_submitted'] = 'Zure bertaratzea dagoeneko erregistratuta dago.';
$string['attendance_no_status'] = 'Ez dago egoera baliagarririk eskuragarri - baliteke zure bertaratzea erregistratzeko beranduegi izatea.';
$string['attendancedata'] = 'Bertaratzeen datuak';
$string['attendancefile'] = 'Bertaratze-fitxategia (csv formatua)';
$string['attendancefile_help'] = 'Fitxategiak CSV formatua izan behar du, goiburuko errenkada batekin eta erabiltzailea identifikatzeko eta gordetako bertaratze-unerako eremuekin, (email,eskaneatzeunea) edo (erabiltzailea,unea) adibidez.';
$string['attendanceforthecourse'] = 'Ikastarorako bertaratzea';
$string['attendancegrade'] = 'Bertaratze-maila';
$string['attendancenotset'] = 'Zure bertaratzea zehaztu behar duzu';
$string['attendancenotstarted'] = 'Bertaratzearen erregistroa ez da oraindik hasi ikastaro honentzako.';
$string['attendancepercent'] = 'Bertaratze-ehunekoa';
$string['attendancereport'] = 'Bertaratze-txostena';
$string['attendanceslogged'] = 'Erregistratutako bertaratzeak';
$string['attendancestaken'] = 'Jasotako bertaratzeak';
$string['attendancesuccess'] = 'Bertaratzearen erregistroa ondo jaso da';
$string['attendanceupdated'] = 'Bertaratzearen erregistroa ondo eguneratu da';
$string['attforblockdirstillexists'] = 'mod/attforblock direktorioa zaharra oraindik existitzen da - zure zerbitzarian direktorio hau ezabatu behar duzu eguneratzea egin baino lehen.';
$string['attrecords'] = 'Bertaratze-erregistroak';
$string['autoassignstatus'] = 'Aukeratu automatikoki eskuragarri dagoen egoerarik altuena';
$string['autoassignstatus_help'] = 'Aukera hau markatuz gero, ikasleei automatikoki eskuragarri dagoen egoerarik altuena esleituko zaie.';
$string['automark'] = 'Markatze automatikoa';
$string['automark_help'] = 'Bertaratzea automatikoki jasotzea ahalbidetzen du.
"Bai" aukeratuz gero bertaratzea ikasle bakoitzaren ikastarorako lehen sarreraren arabera markatuko da.
"Ezarri markatu gabe gisa saioa amaitzean" aukeratuz gero bere bertaratzea adierazi ez duen edozein ikasleri markatu gabe egoera aukeratuko zaio.';
$string['automarkall'] = 'Bai';
$string['automarkclose'] = 'Ezarri markatu gabe gisa saioa amaitzean';
$string['automarktask'] = 'Egiaztatu markatze automatikoa behar duten saioen bertaratze-erregistroak';
$string['autorecorded'] = 'sistemak auto-erregistratua';
$string['averageattendance'] = 'Batez besteko bertaratzea';
$string['averageattendancegraded'] = 'Batez besteko bertaratzea';
$string['backtoparticipants'] = 'Itzuli partaideen zerrendara';
$string['below'] = '%{$a} baino gutxiagokoak';
$string['calclose'] = 'Itxi';
$string['calendarevent'] = 'Sortu egutegiko ekitaldia saio honetarako';
$string['calendarevent_help'] = 'Gaituz gero, egutegiko ekitaldia sortuko da saio honetarako.
Desgaituz gero, saio honetarako sortutako edozein ekitaldi ezabatuko da.';
$string['caleventcreated'] = 'Saio honetarako egutegiko ekitaldia ondo sortu da';
$string['caleventdeleted'] = 'Saio honetarako egutegiko ekitaldia ondo ezabatu da';
$string['calmonths'] = 'Urtarrila,Otsaila,Martxoa,Apirila,Maiatza,Ekaina,Uztaila,Abuztua,Iraila,Urria,Azaroa,Abendua';
$string['calshow'] = 'Aukeratu data';
$string['caltoday'] = 'Gaur';
$string['calweekdays'] = 'Ig,As,Ar,Az,Og,Ol,Lr';
$string['cannottakeforgroup'] = 'Ezin duzu "{$a}" taldearen bertaratzea jaso';
$string['cantaddstatus'] = 'Egoera berria gehitzean akronimoa eta deskribapena zehaztu behar dira.';
$string['categoryreport'] = 'Ikastaro-kategoria txostena';
$string['changeattendance'] = 'Aldatu bertaratzea';
$string['changeduration'] = 'Aldatu iraupena';
$string['changesession'] = 'Aldatu saioa';
$string['checkweekdays'] = 'Aukeratu aukeratutako saioaren data-tartearekin bat datozen asteko egunak.';
$string['closed'] = 'Saio hau ez dago norbere bertaratzearen markatzea egiteko eskuragarri une honetan';
$string['column'] = 'zutabea';
$string['columnmap'] = 'Zutabeen lotura';
$string['columnmap_help'] = 'Aukeratu eremu bakoitzarekin bat datorren CSV fitxategiko zutabea.';
$string['columns'] = 'zutabeak';
$string['commonsession'] = 'Ikasle guztiak';
$string['commonsessions'] = 'Ikasle guztiak';
$string['confirm'] = 'Baieztatu';
$string['confirmcolumnmappings'] = 'Baieztatu zutabe-loturak';
$string['confirmdeletehiddensessions'] = 'Ziur zaude ikastaroaren hasiera-dataz aurretik ({$a->date}) programatutako {$a->count} saio ezabatu nahi duzula?';
$string['confirmdeleteuser'] = 'Ziur zaude \'{$a->fullname}\' erabiltzailea ({$a->email}) ezabatu nahi duzula?<br/>Bere bertaratze-erregistro guztiak behin betiko ezabatuko dira.';
$string['copyfrom'] = 'Kopiatu bertaratze-datuak hemendik:';
$string['countofselected'] = 'Aukeratutako kopurua';
$string['course'] = 'Ikastaroa';
$string['coursemessage'] = 'Mezua bidali ikastaroko partaideei';
$string['courseshortname'] = 'Ikastaroaren izen laburra';
$string['coursesummary'] = 'Ikastaroko laburpen-txostena';
$string['createmultiplesessions'] = 'Sortu saio errepikakorra';
$string['createmultiplesessions_help'] = 'Funtzio honek pauso erraz batean hainbat saio sortzeko aukera ematen dizu.
Saioa goian zehaztutako datan hasiko da eta \'errepikapenaren amaiera\' datara arte jarraituko du.

* <strong>Errepikatzeko egunak</strong>: Aukeratu zure klasea izango den asteko egunak (esaterako Astelehena, Asteazkena eta Ostirala).
* <strong>Errepikatzeko maiztasuna</strong>: Hemen maiztasuna aukeratu ahal da. Zure klasea astero izango bada, 1 aukeratu ezazu; bi astean behin izango bada 2 aukeratu ezazu; hiru astean behin bada 3 aukeratu ezazu, etab.
* <strong>Errepikapenaren amaiera</strong>: Aukeratu ezazu klasearen azken eguna (bertaratzea erregistratuko duzun azken eguna alegia).';
$string['createonesession'] = 'Sortu saio bat ikastarorako';
$string['csvdelimiter'] = 'CSV banatzailea';
$string['currentlyselectedusers'] = 'Une honetan aukeratutako erabiltzaileak';
$string['customexportfields'] = 'Esportatu erabiltzaile-profileko eremu pertsonalizatuak';
$string['customexportfields_help'] = 'Esportatze-txostenean erabiltzaile-profileko eremu gehigarriak erakusteko.';
$string['date'] = 'Data';
$string['days'] = 'Egunak';
$string['defaultdisplaymode'] = 'Erakuste-modu lehenetsia';
$string['defaults'] = 'Lehenetsitakoak';
$string['defaultsessionsettings'] = 'Saioen ezarpen lehenetsiak';
$string['defaultsessionsettings_help'] = 'Ezarpen hauek saio berri guztietarako balio lehenetsiak zehazten dituzte';
$string['defaultsettings'] = 'Bertaratze-ezarpen lehenetsiak';
$string['defaultsettings_help'] = 'Ezarpen hauek bertaratze-erregistro berri guztietarako balio lehenetsiak zehazten dituzte';
$string['defaultstatus'] = 'Egoera-multzo lehenetsia';
$string['defaultsubnet'] = 'Sare-helbide lehenetsia';
$string['defaultsubnet_help'] = 'Bertaratzeen erregistroa azpisare zehatzetara mugatu daiteke komaz banatutako IP helbide oso edo partzialen zerrenda zehaztuta. Eremu honetan saio berriak sortzean erabiliko den balio lehenetsia zehazten da.';
$string['defaultview'] = 'Ikuspegi lehenetsia saioa hastean';
$string['defaultview_desc'] = 'Hau irakasleei lehen aldiz sartzen direnean erakusten zaien ikuspegi lehenetsia da.';
$string['defaultwarnings'] = 'Abisu-multzo lehenetsia';
$string['defaultwarningsettings'] = 'Abisuen ezarpen lehenetsiak';
$string['defaultwarningsettings_help'] = 'Ezarpen hauek abisu berri guztientzako ezarpen lehenetsiak zehazten dituzte';
$string['delete'] = 'Ezabatu';
$string['deletecheckfull'] = 'Erabat ziur zaude {$a} guztiz ezabatu nahi duzula, erabiltzaileen datu guztiak barne?';
$string['deletedgroup'] = 'Saio honekin lotutako taldea ezabatu da';
$string['deletehiddensessions'] = 'Ezabatu ezkutuko saio gzutiak';
$string['deletelogs'] = 'Ezabatu bertaratzeen datuak';
$string['deleteselected'] = 'Ezabatu aukeratutakoak';
$string['deletesession'] = 'Ezabatu saioa';
$string['deletesessions'] = 'Ezabatu saio guztiak';
$string['deleteuser'] = 'Ezabatu erabiltzailea';
$string['deletewarningconfirm'] = 'Ziur zaude abisu hau ezabatu nahi duzula?';
$string['deletingsession'] = 'Ezabatu saioa ikastarorako';
$string['deletingstatus'] = 'Ezabatu egoera ikastarorako';
$string['description'] = 'Deskribapena';
$string['display'] = 'Erakutsi';
$string['displaymode'] = 'Erakusteko modua';
$string['donotusepaging'] = 'Ez erabili orrikatzea';
$string['downloadexcel'] = 'Deskargatu Excel formatuan';
$string['downloadooo'] = 'Deskargatu OpenOffice formatuan';
$string['downloadtext'] = 'Deskargatu testu-formatuan';
$string['duration'] = 'Iraupena';
$string['editsession'] = 'Editatu saioa';
$string['edituser'] = 'Editatu erabiltzailea';
$string['emailcontent'] = 'E-mailaren edukia';
$string['emailcontent_default'] = 'Kaixo, %userfirstname%,
Zure %coursename% ikastaroko %attendancename% bertaratzea %warningpercent%tik behera dago eta une honetan %percent% da - espero dugu ondo zaudela!

Ikastaro hau aprobetxatzeko zure bertaratzea hobetu beharko zenuke, gurekin harremanetan jarri zaitez laguntza behar izanez gero.';
$string['emailcontent_help'] = 'Ikasle bati ohar bat bidaltzen zaionean, emailaren edukia eremu honetatik hartzen da. Erabili daitezkeen gakoak hurrengo zerrendakoak dira:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'E-mailaren gaia';
$string['emailsubject_default'] = 'Bertaratzearen abisua';
$string['emailsubject_help'] = 'Ikasle bati abisu bat bidaltzen zaionean, e-mailaren izenburua eremu honetatik hartzen da.';
$string['emailuser'] = 'Posta elektronikoko erabiltzailea';
$string['emailuser_help'] = 'Markatuz gero, ikasleari abisu bat bidaliko zaio.';
$string['emptyacronym'] = 'Hutsik dauden akronimoak ez daude baimenduta. Egoeraren erregistroa ez da eguneratu.';
$string['emptydescription'] = 'Hutsik dauden deskribapenak ez daude baimenduta. Egoeraren erregistroa ez da eguneratu.';
$string['enablecalendar'] = 'Sortu egutegi-ekitaldiak';
$string['enablecalendar_desc'] = 'Gaituz gero, bertaratze-saio bakoitzarentzat egutegiko ekitaldi bana sortuko da. Ezarpen hau aldatu ondoren egutegia berrabiarazteko txostena exekutatu beharko zenuke.';
$string['enablewarnings'] = 'Gaitu abisuak';
$string['enablewarnings_desc'] = 'Ezarpen honek bertaratzea ezarritako atalasetik jaisten denean erabiltzaileei posta elektroniko bidezko jakinarazpenak bidaltzeko aukera ematen du. <br/><strong>OHARRA: Hau ezarpen berria da eta ez da behar bezain beste probatu. Zure arriskupean erabili ezazu eta zerbaitek ez badu behar bezala funtzionatzen feedbacka Moodleko foroetan eman ezazu.</strong>';
$string['encoding'] = 'Kodeaketa';
$string['encoding_help'] = 'Honek ikaslearen ID txartelak erabilitako barra-kodearen kodifikazio motari dagokio. Barra-kodeen ohiko kodifikazio batzuk hauek dira: Code-39, Code-128 eta UPC-A.';
$string['endofperiod'] = 'Aldiaren amaiera';
$string['endtime'] = 'Saioaren amaiera-ordua';
$string['enrolmentend'] = 'Erabiltzaile-matrikulazioaren amaiera: {$a}';
$string['enrolmentstart'] = 'Erabiltzaile-matrikulazioaren hasiera: {$a}';
$string['enrolmentsuspended'] = 'Etendako matrikulazioa';
$string['enterpassword'] = 'Sartu pasahitza';
$string['error:coursehasnoattendance'] = '{$a} izen laburra duen ikastaroak ez du bertaratzearen erregistrorako jarduerarik.';
$string['error:coursenotfound'] = 'Ezin da aurkitu {$a} izen laburra duen ikastaroa.';
$string['error:qrcode'] = 'Ikasleek euren bertaratzea erregistratzea baimenduta egon behar da QR kodea erabiltzeko! Alde batera uzten.';
$string['error:sessioncourseinvalid'] = 'Saioaren ikastaroa baliogabea da! Alde batera uzten.';
$string['error:sessiondateinvalid'] = 'Saioaren data baliogabea da! Alde batera uzten.';
$string['error:sessionendinvalid'] = 'Saioaren amaiera-data baliogabea da! Alde batera uzten.';
$string['error:sessionstartinvalid'] = 'Saioaren hasiera-data baliogabea da! Alde batera uzten.';
$string['error:statusnotfound'] = 'Erabiltzailea: {$a->extuser} erabiltzaileak aurkitu ezin den egoera bat dauka: {$a->status}';
$string['error:timenotreadable'] = 'Erabiltzailea: {$a->extuser} erabiltzaileak strtotime-k bihurtu ezin duen eskaneatze-unea dauka: {$a->scantime}';
$string['error:userduplicate'] = 'Inportazioan {$a} erabiltzailea birritan agertzen da. Erabiltzaile bakoitzarentzat erregistro bakarra zehaztu ezazu.';
$string['error:usernotfound'] = '{$a->userfield} eremuan {$a->extuser} balioa duen erabiltzailea ezin izan da aurkitu';
$string['errorgroupsnotselected'] = 'Aukeratu talde bat edo gehiago';
$string['errorinaddingsession'] = 'Errorea saioa gehitzean';
$string['erroringeneratingsessions'] = 'Errorea saioak sortzerakoan';
$string['eventdurationupdated'] = 'Saioaren iraupena eguneratu da';
$string['eventreportviewed'] = 'Bertaratze-txostena ikusi da';
$string['eventscreated'] = 'Egutegi-ekitaldiak sortu dira';
$string['eventsdeleted'] = 'Egutegi-ekitaldiak ezabatu dira';
$string['eventsessionadded'] = 'Saioa gehitu da';
$string['eventsessiondeleted'] = 'Saioa ezabatu da';
$string['eventsessionipshared'] = 'IP talka norbere bertaratzearen markatzean';
$string['eventsessionsimported'] = 'Saioak inportatu dira';
$string['eventsessionupdated'] = 'Saioa eguneratu da';
$string['eventstatusadded'] = 'Egoera gehitu da';
$string['eventstatusupdated'] = 'Egoera eguneratu da';
$string['eventstudentattendancesessionsupdated'] = 'Saioaren txostena eguneratu da';
$string['eventstudentattendancesessionsviewed'] = 'Saio-txostena ikusi da';
$string['eventtaken'] = 'Bertaratzea jaso da';
$string['eventtakenbystudent'] = 'Ikasleak bertaratzea jaso du';
$string['export'] = 'Esportatu';
$string['extrarestrictions'] = 'Baldintza gehigarriak';
$string['formattexttype'] = 'Formateatzea';
$string['from'] = 'hasiera:';
$string['gradebookexplanation'] = 'Kalifikazioa kalifikazio-liburuan';
$string['gradebookexplanation_help'] = 'Bertaratzearen erregistroa moduluak zure une honetako bertaratze-maila erakusten du, orain arte jasotako puntuen eta gehienez jaso zitezkeen puntuak kontuan hartuta; ez ditu kontuan hartzen etorkizuneko saioak. Kalifikazio-liburuko zure kalifikazioa oraingo bertaratze-ehunekoan eta ikasturte osoan gehienez jaso daitezkeen puntuetan oinarritzen da, etorkizuneko saioak barne. Beraz, gerta liteke bertaratze-moduluan eta kalifikazio-liburuan agertzen diren bertaratze-mailak ez izatea puntu-kopuru bera, baina ehuneko bera izango dute.

Adibidez, orain arteko 10 puntutik 8 lortu badituzu (%80ko bertaratzea) eta ikasturte osorako bertaratzea 50 puntu badira, bertaratze-moduluak 8/10 erakutsiko du eta kalifikazio-liburuak 40/50. Oraindik ez duzu 40 puntu irabazi, baina 40 puntu horiek zure oraingo bertaratze-ehunekoaren baliokidea dira: %80. Bertaratze-moduluan lortu dituzun puntu-balioa ez da inoiz murriztuko, orain arteko bertaratzean soilik oinarritzen baita; hala ere, kalifikazio-liburuan erakutsitako bertaratze-puntuen balioa handitu edo txikitu egin daiteke, etorkizunean izango duzun bertaratzearen arabera, ikasturte osorako bertaratzean oinarritzen baita.';
$string['graded'] = 'Kalifikatutako saioak';
$string['gridcolumns'] = 'Zutabeen sarea';
$string['group'] = 'Taldea';
$string['groups'] = 'Taldeak';
$string['groupsession'] = 'Ikasle-taldea';
$string['groupsessionsby'] = 'Taldekatu saioak honela:';
$string['hiddensessions'] = 'Ezkutuko saioak';
$string['hiddensessions_help'] = 'Saioak ezkutuan egongo dira ikastaroaren hasiera-data baino lehenagokoak badira.

Funtzionalitate hau erabili dezakezu saio zaharrak ezabatu beharrean ezkutuan uzteko. Kalifikazio-liburuan soilik ikusgai dauden saioak agertuko dira.';
$string['hiddensessionsdeleted'] = 'Ezkutuko saio guztiak ezabatu dira';
$string['hideextrauserdetails'] = 'Ezkutatu erabiltzaileen xehetasun gehigarriak';
$string['hidensessiondetails'] = 'Ezkutatu saioaren xehetasunak';
$string['identifyby'] = 'Identifikatu ikasleak honen arabera:';
$string['import'] = 'Inportatu';
$string['importfile'] = 'Inportatu fitxategia';
$string['importfile_help'] = 'Inportatu fitxategia';
$string['importsessions'] = 'Inportatu saioak';
$string['importstatus'] = 'Egoera-eremua';
$string['importstatus_help'] = 'Eremu honek inportatzerakoan egoera adierazteko aukera ematen du - esaterako E, S edo B balioak';
$string['includeabsentee'] = 'Kontuan hartu saioa absentismoaren txostena kalkulatzean';
$string['includeabsentee_help'] = 'Markatuz gero saio hau kontuan hartuko da absentismoaren txostena kalkulatzean.';
$string['includeall'] = 'Aukeratu saio guztiak';
$string['includedescription'] = 'Saioren deskribapena barne du';
$string['includenottaken'] = 'Jaso gabeko saioak barne ditu';
$string['includeqrcode'] = 'Gehitu QR kodea';
$string['includeremarks'] = 'Iruzkinak barne ditu';
$string['incorrectpassword'] = 'Pasahitza baliogabea sartu duzu eta ondorioz zure bertaratzea ez da erregistratu, sartu ezazu mesedez pasahitz zuzena.';
$string['incorrectpasswordshort'] = 'Pasahitz baliogabea, bertaratzea ez da erregistratu.';
$string['indetail'] = 'Xehetasunak';
$string['indicator:cognitivedepth'] = 'Bertaratze kognitiboa';
$string['indicator:cognitivedepth_help'] = 'Adierazle hau ikasleak Bertaratzearen erregistroaren jardueran lortutako sakontasun kognitiboan oinarritzen da.';
$string['indicator:cognitivedepthdef'] = 'Bertaratze kognitiboa';
$string['indicator:cognitivedepthdef_help'] = 'Partaideak Bertaratzearen erregistroaren pluginak eskainitako gaitasun kognitiboaren ehuneko hau lortu du analisi-tarte honetan (Mailak = Ikusi gabe, Ikusi da)';
$string['indicator:socialbreadth'] = 'Bertaratze soziala';
$string['indicator:socialbreadth_help'] = 'Adierazle hau ikasleak Bertaratzearen erregistroaren jardueran lortutako hedadura sozialean oinarritzen da.';
$string['indicator:socialbreadthdef'] = 'Bertaratze soziala';
$string['indicator:socialbreadthdef_help'] = 'Partaideak Bertaratzearen erregistroaren pluginak eskainitako gaitasun sozialaren ehuneko hau lortu du analisi-tarte honetan (Mailak = Parte-hartzerik ez, Bakarkako parte-hartzea)';
$string['invalidaction'] = 'Ekintza bat aukeratu behar duzu';
$string['invalidemails'] = 'Existitzen diren erabiltzaileen helbideak zehaztu behar dituzu, ezin izan da aurkitu hurrengoa: {$a}';
$string['invalidimportfile'] = 'Fitxategi-formatu baliogabea';
$string['invalidsessionenddate'] = 'Data hau ezin da saioaren data baino lehenagokoa izan';
$string['invalidsessionendtime'] = 'Amaiera-data hasiera-data baino beranduagokoa izan behar da';
$string['invalidstatus'] = 'Egoera baliogabea aukeratu duzu, mesedez saiatu zaitez berriz.';
$string['iptimemissing'] = 'Desblokeatzeko minutu baliogabeak';
$string['jumpto'] = 'Joan hona';
$string['keepsearching'] = 'Jarraitu bilatzen';
$string['marksessionimportcsvhelp'] = 'Formulario honek erabiltzaileen identifikatzaile bat eta egoera bat CSV fitxategi batean igotzea ahalbidetzen dizu - egoeraren eremuak egoeraren akronimoa edo erabiltzaileak bertaratzea gorde zueneko unea izan dezake. Balioa data bat bada sistemak une horretarako eskuragarri dagoen puntuazio altuena esleitzen saiatuko da.';
$string['maxpossible'] = 'Lortu daitekeen gehienezkoa';
$string['maxpossible_help'] = 'Erabiltzaile bakoitzak orain arte jaso gabeko saio bakoitzean (iraganekoak zein etorkizunekoak) gehienezko puntuazioa jasoz gero lortu dezakeen puntuazioa erakusten du:
    <ul>
    <li><strong>Puntuak</strong>: erabiltzaile bakoitzak saioetan guztira gehienez lortu dezakeen gehienezko puntuazioa.</li>
    <li><strong>Ehunekoa</strong>: erabiltzaile bakoitzak saioetan guztira gehienez lortu dezakeen gehienezko ehunekoa.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'Lortu daitekeen gehienezko ehunekoa';
$string['maxpossiblepoints'] = 'Lortu daitezkeen gehienezko puntuak';
$string['maxwarn'] = 'Gehienezko abisuzko e-posta mezuak';
$string['maxwarn_help'] = 'Ohar bat gehienez bidali beharreko aldiak (saio bakoitzeko ohar bakarra bidaltzen da)';
$string['mergeuser'] = 'Batu erabiltzailea';
$string['mobilesessionfrom'] = 'Erakutsi azkena baino zaharragoak diren saioak';
$string['mobilesessionfrom_help'] = 'Aplikazioaren bitartez erregistratzean erakusten den saioen zerrenda murriztea ahalbidetzen du - hemen zehaztutako unetik aurrera hasitako saioak bakarrik erakutsiko dira';
$string['mobilesessionto'] = 'Erakutsi etorkizuneko saioak';
$string['mobilesessionto_help'] = 'Erakusten den etorkizuneko saioen zerrenda kopuru txiki batera murriztea ahalbidetzen du.';
$string['mobilesettings'] = 'Aplikazio mugikorreko ezarpenak';
$string['mobilesettings_help'] = 'Ezarpen hauek Moodleko aplikazio mugikorreko portaera kontrolatzen dute';
$string['modulename'] = 'Bertaratzearen erregistroa';
$string['modulename_help'] = 'Bertaratzearen erregistroa jarduera moduluak irakasleei klasean zehar bertaratutakoen erregistroa egitea eta ikasle bakoitzari bere bertaratzea erregistroa egitea ahalbidetzen die.

Irakasleak hainbat saio sortu ditzake eta bertaratzearen egoeran "Presente", "Ez dago", "Berandu" edo "Desenkusatua" aukeratu dezake edo lehenetsitako egoerak aldatu bere beharretara egokitzeko.

Gela osoko eta banakako ikasleen txostenak eskuragarri daude.';
$string['modulenameplural'] = 'Bertaratzearen erregistroak';
$string['months'] = 'Hilabeteak';
$string['moreattendance'] = 'Orri honetarako bertaratzea ondo gorde da';
$string['moveleft'] = 'Mugitu ezkerrera';
$string['moveright'] = 'Mugitu eskuinera';
$string['multisessionexpanded'] = 'Saio errepikakorra zabalduta';
$string['multisessionexpanded_desc'] = 'Erakutsi "Saio errepikakorra" ezarpenak zabalduta saio berriak sortzean modu lehenetsian.';
$string['mustselectusers'] = 'Erabiltzaileak aukeratu behar dituzu esportatzeko';
$string['newdate'] = 'Data berria';
$string['newduration'] = 'Iraupen berria';
$string['newstatusset'] = 'Egoera-multzo berria';
$string['noabsentstatusset'] = 'Erabiltzen ari zaren egoera-multzoak ez dauka markatu gabekoetan erabiltzen egoerarik.';
$string['noattendanceusers'] = 'Ezin da daturik esportatu ikastaroetan ez dagoelako ikaslerik matrikulatuta.';
$string['noattforuser'] = 'Ez dago erabiltzaile honen bertaratze-erregistrorik';
$string['noautomark'] = 'Desgaituta';
$string['nocapabilitytotakethisattendance'] = 'Aldatzeko baimenik ez duzun {$a} cmid-a duen bertaratze-saio bat aldatzen saiatu zara.';
$string['nodescription'] = 'Ohiko klase-saioa';
$string['noeventstoreset'] = 'Ez dago eguneratzea behar duen egutegiko ekitaldirik.';
$string['nogroups'] = 'Ezin dituzu talde-saioak sortu. Ikastaroan ez dago talderik.';
$string['noguest'] = 'Gonbidatuek ezin duten bertaratzea ikusi';
$string['noofdaysabsent'] = 'Ez egondako egun kopurua';
$string['noofdaysexcused'] = 'Salbuetsitako egun kopurua';
$string['noofdayslate'] = 'Berandu heldutako egun kopurua';
$string['noofdayspresent'] = 'Presente egondako egun kopurua';
$string['nosessiondayselected'] = 'Ez duzu aukeratu saioaren eguna';
$string['nosessionexists'] = 'Ez dago saiorik ikastaro honetan';
$string['nosessionsselected'] = 'Ez dago aukeratutako saiorik';
$string['notfound'] = 'Ez da bertaratzearen erregistroaren jarduerarik aurkitu ikastaro honetan!';
$string['notifytask'] = 'Bidali abisuak erabiltzaileei';
$string['notmember'] = 'ez da partaidea';
$string['notset'] = 'ezarri gabe';
$string['noupgradefromthisversion'] = 'Bertaratzearen erregistroaren modulua ezin da eguneratu instalatuta daukazun attforblock bertsiotik. - attforblock ezabatu edo bere bertsio berrienera eguneratu ezazu mesedez bertaratzearen erregistroaren modulua instalatu baino lehen.';
$string['numsessions'] = 'Saio kopurua';
$string['olddate'] = 'Data zaharra';
$string['onlyselectedusers'] = 'Esportatu erabiltzaile jakin batzuk';
$string['overallsessions'] = 'Saio guztiekiko';
$string['overallsessions_help'] = 'Erakutsi saio guztien estatistikak oraindik eman ez direnak barne (iraganekoak zein etorkizunekoak):
    <ul>
    <li><strong>Saioak</strong>: saio kopurua osoa.</li>
    <li><strong>Puntuak</strong>: jasotako saioetan oinarrituta lortutako puntuak.</li>
    <li><strong>Ehunekoa</strong>: saio guztien gehienezko puntuekiko jasotako saioen puntuen ehunekoa.</li>
    </ul>';
$string['oversessionstaken'] = 'Jasotako saioekiko';
$string['oversessionstaken_help'] = 'Erakutsi dagoeneko eman diren saioen estatistikak:
    <ul>
    <li><strong>Saioak</strong>: dagoeneko emandako saioak.</li>
    <li><strong>Points</strong>: jasotako saioetan oinarrituta lortutako puntuak.</li>
    <li><strong>Percentage</strong>: emandako saio guztien gehienezko puntuekiko jasotako saioen puntuen ehunekoa.</li>
    </ul>';
$string['pageof'] = '{$a->page}. orria {$a->numpages}(e)tik';
$string['participant'] = 'Partaidea';
$string['password'] = 'Pasahitza';
$string['passwordgrp'] = 'Ikasleentzako pasahitza';
$string['passwordgrp_help'] = 'Zehaztuz gero ikasleei pasahitz bat eskatuko zaie euren saio honetako bertaratzea erregistratu ahal izateko. Hutsik utziz gero, ez da pasahitzik eskatuko.';
$string['passwordrequired'] = 'Saioko pasahitza idatzi behar duzu zure bertaratzea erregistratu ahal izateko';
$string['percentage'] = 'Ehunekoa';
$string['percentageallsessions'] = 'Ehunekoa saio guztiekiko';
$string['percentagesessionscompleted'] = 'Ehunekoa jasotako saioekiko';
$string['pluginadministration'] = 'Bertaratzearen erregistroaren kudeaketa';
$string['pluginname'] = 'Bertaratzearen erregistroa';
$string['points'] = 'Puntuak';
$string['pointsallsessions'] = 'Puntuak saio guztiekiko';
$string['pointssessionscompleted'] = 'Puntuak jasotako saioekiko';
$string['preferences_desc'] = 'Egoera-multzoei egindako aldaketek gordetako bertaratze-saioei eragingo die eta kalifikazioetan eragin dezakete.';
$string['preventsharederror'] = 'Norbere bertaratzearen markatzea desgaituta dago gailu hau dagoeneko saio honetako beste ikasle baten erregistroa egiteko erabili dela antzeman delako.';
$string['preventsharedip'] = 'Saihestu ikasleek IP helbidea partekatzea';
$string['preventsharedip_help'] = 'Saihestu ikasleek gailu bera erabiltzea (IP helbide berarekin identifikatzea) beste ikasleen bertaratzearen erregistroa egiteko.';
$string['preventsharediptime'] = 'IP helbidea berrerabiltzeko denbora-tartea (minutuak)';
$string['preventsharediptime_help'] = 'Baimendu IP helbidea berrerabilia izatea saio honetako bertaratzea erregistratzeko, denbora-tarte hau igaro ondoren.';
$string['preview'] = 'Fitxategiaren aurrebista';
$string['previewhtml'] = 'HTML formatuaren aurreikuspena';
$string['priorto'] = 'Saioaren data ikastaroaren hasiera-data ({$a}) baino lehenagokoa da eta data hori baino lehenago programatutako saioak ezkutatuko dira (ez dira eskuragarri egongo). Ikastaroaren hasiera-data edozein unetan aldatu dezakezu (ikusi ikastaroaren ezarpenak) lehenagoko saioetara sarbidea izateko.<br><br>Aldatu ezazu mesedez saioaren data edo egin klik "Gehitu saioa" botoian saioaren sorrera baieztatzeko.';
$string['privacy:metadata:attendancelog'] = 'Gordetako erabiltzaileen bertaratzearen erregistroa.';
$string['privacy:metadata:attendancesessions'] = 'Bertaratzea gordeko diren saioak.';
$string['privacy:metadata:attendancewarningdone'] = 'Erabiltzaileei euren bertaratzearen inguruan bidalitako jakinarazpenen erregistroa.';
$string['privacy:metadata:duration'] = 'Saioaren iraupena segundoetan';
$string['privacy:metadata:groupid'] = 'Saioarekin lotutako taldearen IDa.';
$string['privacy:metadata:ipaddress'] = 'Bertaratzea erregistratu zeneko IP helbidea.';
$string['privacy:metadata:lasttaken'] = 'Saioaren bertaratzea azkenengoz gorde zeneko unea.';
$string['privacy:metadata:lasttakenby'] = 'Saio honetan bertaratzea gorde zeneko azken erabiltzailearen IDa.';
$string['privacy:metadata:notifyid'] = 'Jakinarazpenarekin lotutako bertaratze-saioaren IDa.';
$string['privacy:metadata:remarks'] = 'Erabiltzailearen bertaratzearen inguruko iruzkinak.';
$string['privacy:metadata:sessdate'] = 'Saioa hasi zeneko unea.';
$string['privacy:metadata:sessionid'] = 'Bertaratze-saioaren IDa.';
$string['privacy:metadata:statusid'] = 'Ikaslearen bertaratze egoeraren IDa.';
$string['privacy:metadata:statusset'] = 'IDari dagokion egoera-multzoa .';
$string['privacy:metadata:studentid'] = 'Jasotako bertaratzearen ikaslearen IDa.';
$string['privacy:metadata:takenby'] = 'Ikaslearen bertaratzea jaso zuen erabiltzailearen IDa.';
$string['privacy:metadata:timemodified'] = 'Saioa azkenengoz aldatu zeneko unea.';
$string['privacy:metadata:timesent'] = 'Jakinarazpena bidali zeneko unea.';
$string['privacy:metadata:timetaken'] = 'Ikaslearen bertaratzea jaso zeneko unea.';
$string['privacy:metadata:userid'] = 'Jakinarazpena bidali zaioneko erabiltzailearen IDa.';
$string['processingfile'] = 'Fitxategia prozesatzen';
$string['qr_cookie_error'] = 'QR saioa iraungi da.';
$string['qr_pass_wrong'] = 'QR pasahitza okerra da edo iraungi da.';
$string['qrcode'] = 'QR kodea';
$string['randompassword'] = 'Ausazko pasahitza';
$string['remark'] = 'Iruzkinak {$a}-(r)entzako';
$string['remarks'] = 'Iruzkinak';
$string['repeatasfollows'] = 'Errepikatu goiko saioa hurrengo irizpideen arabera';
$string['repeatevery'] = 'Errepikatzeko maiztasuna';
$string['repeaton'] = 'Errepikatzeko egunak';
$string['repeatuntil'] = 'Errepikapenaren amaiera';
$string['report'] = 'Txostena';
$string['required'] = 'Beharrezkoa*';
$string['requiredentries'] = 'Behin-behineko erregistroek partaideen bertaratze-erregistroak baliogabetzen dituzte';
$string['requiredentry'] = 'Behin-behineko erabiltzaileak batzeko laguntza-gida';
$string['requiredentry_help'] = '<p align="center"><b>Bertaratzea</b></p>
<p align="left"><strong>Elkartu Kontuak</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodleko Erabiltzailea</th>
<th>Behin-behineko Erabiltzailea</th>
<th>Ekintza</th>
</tr>
<tr>
<td>Bertaratze-datuak</td>
<td>Bertaratze-datuak</td>
<td>Behin-behineko erabiltzaileak Moodleko erabiltzailea baliogabetuko du</td>
</tr>
<tr>
<td>Bertaratze daturik ez</td>
<td>Bertaratze-datuak</td>
<td>Behin-behineko erabiltzailearen bertaratzea Moodleko erabiltzaileari transferituko zaio</td>
</tr>
<tr>
<td>Bertaratze-datuak</td>
<td>Bertaratze daturik ez</td>
<td>Behin-behineko erabiltzailea ezabatuko da</td>
</tr>
<tr>
<td>Bertaratze daturik ez</td>
<td>Bertaratze daturik ez</td>
<td>Behin-behineko erabiltzailea ezabatuko da</td>
</tr>
</table>

</p>
<p align="left"><strong>Behin-behineko erabiltzailea beti elkartze-ekintza egin ondoren ezabatuko da</strong></p>';
$string['requiresubnet'] = 'Behartu sare-helbide zehatza';
$string['requiresubnet_help'] = 'Bertaratzeen erregistroa azpisare zehatzetara mugatu daiteke komaz banatutako IP helbide oso edo partzialen zerrenda zehaztuta.';
$string['resetcaledarcreate'] = 'Egutegi-ekitaldiak gaitu dira baina existitzen diren saio batzuk ez dute ekitaldirik. Existitzen diren saio guztientzako egutegi-ekitaldiak sortu nahi dituzu?';
$string['resetcaledardelete'] = 'Egutegi-ekitaldiak desgaitu dira baina existitzen diren saio batzuk ezabatu beharko liratekeen ekitaldiak dituzte. Existitzen diren saio guztientzako egutegi-ekitaldiak ezabatu nahi dituzu?';
$string['resetcalendar'] = 'Berrabiarazi egutegia';
$string['resetdescription'] = 'Gogoratu ezazu bertaratze-datuak ezabatuta informazioa datu-basetik ezabatuko duela. Saio zaharrak ezkutatu ditzakezu ikastaroaren hasiera-data aldatuta!';
$string['resetstatuses'] = 'Berrabiarazi egoerak lehenetsitakoetara';
$string['restoredefaults'] = 'Berrabiarazi lehenetsitakoak';
$string['resultsperpage'] = 'Emaitzak orriko';
$string['resultsperpage_desc'] = 'Orri bakoitzean erakutsiko den ikasle kopurua';
$string['rotateqrcode'] = 'Aldatu QR kodea';
$string['rotateqrcode_cleartemppass_task'] = 'QR kodearen funtzionalitateak sortutako behin-behineko pasahitzak garbitzeko ataza.';
$string['rotateqrcodeexpirymargin'] = 'Aldatu QR kodea/pasahitzaren iraungitze-epea (segundotan)';
$string['rotateqrcodeexpirymargin_desc'] = 'QR kodea/pasahitzaren iraungitzearen denbora-tartea (segundotan).';
$string['rotateqrcodeinterval'] = 'Aldatu QR kodea/pasahitzaren denbora-tartea (segundotan)';
$string['rotateqrcodeinterval_desc'] = 'QR kodea/pasahitzaren aldatzearen denbora-tartea (segundotan).';
$string['save'] = 'Gorde bertaratzea';
$string['scantime'] = 'Eskaneatze-unea';
$string['scantime_help'] = 'Honek inportatze-fitxategian timestamp formatuko data gehitzea ahalbidetzen du - fitxategiko timestamp eremuko balioak PHPko strtotime funtzioa erabilita bihurtu eta ondoren dagokion erabiltzailearen bertaratzearen egoeraren ezarpenetan erabiltzen saiatuko da.';
$string['search:activity'] = 'Bertaratzearen erregistroa - jardueraren informazioa';
$string['session'] = 'Saioa';
$string['session_help'] = 'Saioa';
$string['sessionadded'] = 'Saioa ondo gehitu da';
$string['sessionalreadyexists'] = 'Saioa existitzen da data honetarako';
$string['sessiondate'] = 'Data';
$string['sessiondays'] = 'Saioaren egunak';
$string['sessiondeleted'] = 'Saioa ondo ezabatu da';
$string['sessionduplicate'] = 'Bikoiztutako saioa existitzen da {$a->course} ikastaroko {$a->activity} bertaratzearen erregistroan.';
$string['sessionexist'] = 'Saioa ez da gehitu (dagoeneko existitzen da)!';
$string['sessiongenerated'] = 'Saioa ondo sortu da';
$string['sessions'] = 'Saioak';
$string['sessionsallcourses'] = 'Ikastaro guztiak';
$string['sessionsbyactivity'] = 'Bertaratzearen erregistro instantzia';
$string['sessionsbycourse'] = 'Ikastaroa';
$string['sessionsbydate'] = 'Astea';
$string['sessionscompleted'] = 'Jasotako saioak';
$string['sessionscurrentcourses'] = 'Oraingo ikastaroak';
$string['sessionsgenerated'] = '{$a} saio ondo sortu dira';
$string['sessionsids'] = 'Saioen IDak:';
$string['sessionsnotfound'] = 'Ez dago saiorik aukeratutako denbora-tartean';
$string['sessionstartdate'] = 'Saioaren hasiera-data';
$string['sessionstotal'] = 'Saio kopurua denetara';
$string['sessionsupdated'] = 'Saioak eguneratu dira';
$string['sessiontype'] = 'Mota';
$string['sessiontype_help'] = 'Saioak ikasle guztientzat edo ikasle-talde batentzat sortu ditzakezu. Mota ezberdinak erabiltzeko aukera jardueraren talde-moduaren araberakoa izango da.

* "Talderik ez" talde-moduan soilik ikasle guztientzako saioak sortu ahal dira.
* "Taldeek ezin elkar ikusi" talde-moduan saioak ikasle-talde bakar batentzat sortu ahal dira.
* "Taldeek elkar ikusten dute" talde-moduan bi motetako saioak sortu ahal dira.';
$string['sessiontypeshort'] = 'Mota';
$string['sessionunknowngroup'] = 'Saio batek talde ezezagunen bat zehazten du: {$a}';
$string['sessionupdated'] = 'Saioa ondo eguneratu da';
$string['set_by_student'] = 'Norberak markatuta';
$string['setallstatuses'] = 'Ezarri egoera hauentzat:';
$string['setallstatusesto'] = 'Ezarri «{$a}» egoera';
$string['setperiod'] = 'IP helbidea desblokeatzeko zehaztutako denbora-tartea (minutuetan)';
$string['settings'] = 'Ezarpenak';
$string['setunmarked'] = 'Automatikoki ezarria bertaratzea adierazi gabe dagoenean';
$string['setunmarked_help'] = 'Saioan gaituta badago, egoera hau ezartzen da ikasle batek bere bertaratzea erregistratzen ez badu.';
$string['showdefaults'] = 'Erakutsi lehenetsitakoak';
$string['showduration'] = 'Erakutsi iraupena';
$string['showextrauserdetails'] = 'Erakutsi erabiltzailearen xehetasun gehigarriak';
$string['showqrcode'] = 'Erakutsi QR kodea';
$string['showsessiondescriptiononreport'] = 'Erakutsi saioaren deskribapena txostenean';
$string['showsessiondescriptiononreport_desc'] = 'Erakutsi saioaren deskribapena bertaratze-txostenaren zerrendan.';
$string['showsessiondetails'] = 'Erakutsi saioen xehetasunak';
$string['somedisabledstatus'] = '(Aukera batzuk kendu dira saioa dagoeneko hasi delako.)';
$string['sortedgrid'] = 'Sare ordenatua';
$string['sortedlist'] = 'Zerrenda ordenatua';
$string['startofperiod'] = 'Aldiaren hasiera';
$string['starttime'] = 'Hasiera-ordua';
$string['status'] = 'Egoera';
$string['statusall'] = 'guztiak';
$string['statusdeleted'] = 'Egoera ezabatu da';
$string['statuses'] = 'Egoerak';
$string['statusset'] = '{$a}. egoera-multzoa';
$string['statussetsettings'] = 'Egoera-multzoa';
$string['statusunselected'] = 'aukeratu gabekoak';
$string['strftimedm'] = '%b %d';
$string['strftimedmw'] = '<nobr>%a %b %d</nobr>';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentavailability'] = 'Eskuragarri ikasleentzat (minutuetan)';
$string['studentavailability_help'] = 'Ikasleek euren bertaratzea jasotzen dutenean, saioa hasi eta egoera hau eskuragarri egongo den minutu kopurua.<br/>
Hutsik utziz gero, egoera hau beti egongo da eskuragarri, eta zero jarriz gero ikasleentzat ezkutuan egongo da beti.';
$string['studentid'] = 'Ikaslearen IDa';
$string['studentmarked'] = 'Zure saio honetako bertaratzea gorde da.';
$string['studentmarking'] = 'Ikasleen auto-erregistroa';
$string['studentpassword'] = 'Ikaslearen pasahitza';
$string['studentrecordingexpanded'] = 'Ikasleen auto-erregistroa';
$string['studentrecordingexpanded_desc'] = 'Erakutsi "Ikasleen auto-erregistroa" ezarpenak zabalduta modu lehenetsian saio berriak sortzerakoan.';
$string['studentscanmark'] = 'Baimendu ikasleek euren bertaratzea erregistratzea';
$string['studentscanmark_desc'] = 'Markatuz gero, irakasleek ikasleei norbere bertaratzea erregistratzeko aukera eman ahalko diete.';
$string['studentscanmark_help'] = 'Markatuz gero ikasle bakoitzak bere saio honetako bertaratzearen egoera aldatu ahalko du.';
$string['studentscanmarksessiontime'] = 'Ikasleek saioan zehar bertaratzea erregistratzen dute';
$string['studentscanmarksessiontime_desc'] = 'Markatuz gero ikasleek euren bertaratzea saioan zehar erregistratu ahalko dute.';
$string['studentscanmarksessiontimeend'] = 'Saioaren amaiera (minutuak)';
$string['studentscanmarksessiontimeend_desc'] = 'Saioak ez badu amaiera-datarik, ikasleek zenbat minututan izango dute euren bertaratzea erregistratzeko aukera.';
$string['submit'] = 'Bidali';
$string['submitattendance'] = 'Erregistratu bertaratzea';
$string['submitpassword'] = 'Bidali pasahitza';
$string['subnet'] = 'Azpisarea';
$string['subnetactivitylevel'] = 'Baimendu azpisarearen konfigurazioa jarduera bakoitzean';
$string['subnetactivitylevel_desc'] = 'Gaituz gero, irakasleek lehenetsitako azpisarea baliogabetu dezakete sortzen duten bertaratzearen erregistrorako jarduera bakoitzean. Bestela gunean lehenetsitakoa erabiliko da saio bat sortzerakoan.';
$string['subnetwrong'] = 'Bertaratzea kokapen zehatz batzuetatik soilik erregistratu daiteke, eta ordenagailu hau ez dago baimendutakoen zerrendan.';
$string['summary'] = 'Laburpena';
$string['tablerenamefailed'] = 'attforblock taula zaharraren berrizendatzeak huts egin du';
$string['tactions'] = 'Ekintza';
$string['takeattendance'] = 'Erregistratu bertaratzea';
$string['takensessions'] = 'Jasotako saioak';
$string['tcreated'] = 'Sortu da';
$string['tempaddform'] = 'Gehitu behin-behineko erabiltzailea';
$string['tempexists'] = 'Dagoeneko helbide elektroniko hori duen behin-behineko erabiltzaile bat existitzen da';
$string['temptable'] = 'Behin-behineko erabiltzaileen zerrenda';
$string['tempuser'] = 'Behin-behineko erabiltzailea';
$string['tempusermerge'] = 'Batu behin-behineko erabiltzailea';
$string['tempusers'] = 'Behin-behineko erabiltzaileak';
$string['tempusersedit'] = 'Editatu behin-behineko erabiltzailea';
$string['tempuserslist'] = 'Behin-behineko erabiltzaileak';
$string['thirdpartyemails'] = 'Jakinarazi beste erabiltzaileak';
$string['thirdpartyemails_help'] = 'Jakinarazpenak jasoko duten erabiltzaileen zerrenda. (mod/attendance:viewreports baimena behar du)';
$string['thirdpartyemailsubject'] = 'Bertaratzearen abisua';
$string['thirdpartyemailtext'] = '{$a->firstname} {$a->lastname} erabiltzailearen {$a->coursename} {$a->aname} bertaratzea {$a->warningpercent} ({$a->percent}) baino txikiagoa da';
$string['thirdpartyemailtextfooter'] = 'Mezu hau jaso duzu ikastaro honetako irakasleak zure helbide elektronikoa jasotzaileen zerrendan sartu duelako';
$string['thiscourse'] = 'Ikastaro hau';
$string['time'] = 'Ordua';
$string['timeahead'] = 'Ezin dira sortu urtebete baino gehiagoko saio errepikakorrak, murriztu mesedez hasiera eta amaiera-datak.';
$string['to'] = 'amaiera:';
$string['todate'] = 'orain arte';
$string['triggered'] = 'Lehen aldiz jakinarazia';
$string['tuseremail'] = 'Posta elektronikoa';
$string['tusername'] = 'Izen osoa';
$string['ungraded'] = 'Kalifikatu gabeko saioak';
$string['unknowngroup'] = 'Talde ezezaguna';
$string['update'] = 'Eguneratu';
$string['uploadattendance'] = 'Igo bertaratzea CSV bidez';
$string['usedefaultsubnet'] = 'Erabili lehenetsitakoa';
$string['usemessageform'] = 'edo erabili azpiko formularioa aukeratutako ikasleei mezu bat bidaltzeko';
$string['userexists'] = 'Dagoeneko helbide elektroniko hori duen erabiltzaile bat existitzen da';
$string['userid'] = 'Erabiltzaile IDa';
$string['userimportfield'] = 'Kanpoko erabiltzaile-eremua';
$string['userimportfield_help'] = 'Igotako CSV fitxategian erabiltzaile-identifikatzailea daukan eremua';
$string['userimportto'] = 'Moodleko erabiltzaile-eremua';
$string['userimportto_help'] = 'Esportatutako CSVaren datuekin bat datorren Moodleko eremua';
$string['users'] = 'Esportatzeko erabiltzaileak';
$string['usestatusset'] = 'Egoera-multzoa';
$string['variable'] = 'aldagaia';
$string['variablesupdated'] = 'Aldagaiak ondo eguneratu dira';
$string['versionforprinting'] = 'Inprimatzeko bertsioa';
$string['viewmode'] = 'Erakuste modua';
$string['warnafter'] = 'Jasotako saioak abisuaren aurretik';
$string['warnafter_help'] = 'Oharrak soilik erakutsiko dira erabiltzaileak gutxienezko saio-kopuru honetan bertaratzea erregistratu duenean.';
$string['warningdeleted'] = 'Abisua ezabatu da';
$string['warningdesc'] = 'Jakinarazpen hauek automatikoki gehituko dira bertaratzearen erregistrorako instantzia berrietan. Une berean jakinarazpen bat baino gehiago abiarazten bada, jakinarazpen-atalase baxuena duen jakinarazpena baino ez da bidaliko.';
$string['warningdesc_course'] = 'Hemen konfiguratutako jakinarazpen-atalaseak absentismoaren txostenari eragiten diote eta ikasleak edo beste batzuk jakinaraztea ahalbidetzen du. Une berean jakinarazpen bat baino gehiago abiarazten bada, jakinarazpen-atalase baxuena duen jakinarazpena baino ez da bidaliko.';
$string['warningfailed'] = 'Ezin duzu ehuneko eta saio kopuru bera erabiltzen duen beste ohar bat.';
$string['warningpercent'] = 'Ohartarazi ehunekoa kopuru honetatik behera jaisten denean';
$string['warningpercent_help'] = 'Guztirako ehunekoa kopuru honetatik behera jaisten denean ohar bat bidaliko da.';
$string['warnings'] = 'Abisu-multzoa';
$string['warningthreshold'] = 'Oharren atalasea';
$string['warningupdated'] = 'Ohar eguneratuak';
$string['week'] = 'aste';
$string['weekcommencing'] = 'Aste-hasiera';
$string['weeks'] = 'Asteak';
$string['youcantdo'] = 'Ezin duzu ezer egin';
