<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'simplecertificate', language 'sr_lt', version '3.8'.
 *
 * @package     simplecertificate
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['awardedto'] = 'Dodeljuje se polazniku';
$string['cantdeleteissue'] = 'Greška prilikom uklanjanja izdatih sertifikata';
$string['certificateimage'] = 'Datoteka slike sertifikata';
$string['certificateimage_help'] = 'Ovo je slika koja će se koristiti na sertifikatu';
$string['certificatename'] = 'Naziv sertifikata';
$string['certificatename_help'] = 'Naziv sertifikata';
$string['certificatetext'] = 'Tekst sertifikata';
$string['certificatetext_help'] = 'Ovo je tekst koji će biti iskorišćen za sertifikat; neke posebne reči će biti zamenjene promenljivim vrednostima, kao što su naziv kursa, ime studenta, ocena...
To su:

{USERNAME} -> Puno ume korisnika

{COURSENAME} -> Pun naziv kursa (ili definisani alternativni naziv kursa)

{GRADE} -> Formatirana ocena

{DATE} -> Formatirani datum

{OUTCOME} -> Ishodi

{HOURS} -> Definisani broj časova na kursu

{TEACHERS} -> Spisak predavača

Tekst može da koristi osnovni html, osnovne fontove, tabele,  ali izbegavajte bilo kakvu definiciju položaja teksta';
$string['certificatetextx'] = 'Horizontalni položaj teksta sertifikata';
$string['certificatetexty'] = 'Vertikalan položaj teksta sertifikata';
$string['certificateverification'] = 'Provera sertifikata';
$string['certlifetime'] = 'Čuvajte izdate sertifikate još: (u mesecima)';
$string['certlifetime_help'] = 'Ova opcija određuje vremenski period tokom kojeg želite da čuvate izdate sertifikate. Sertifikati koji su stariji od navedenog perioda automatski se brišu.';
$string['code'] = 'Kôd';
$string['completiondate'] = 'Završetak kursa';
$string['coursegrade'] = 'Ocena na kursu';
$string['coursename'] = 'Alternativni naziv kursa';
$string['coursename_help'] = 'Alternativni naziv kursa';
$string['coursetimereq'] = 'Potreban broj minuta provedenih na kursu';
$string['coursetimereq_help'] = 'Ovde unesite minimalno vreme, u minutima, koje studenti moraju da bude prijavljeni na sistem, tj. da provedu na kursu, pre nego što budu mogli da dobiju sertifikat.';
$string['datefmt'] = 'Format datuma';
$string['datefmt_help'] = 'Izaberite format u kojem će biti odštampan datum na sertifikatu, ili, izaberite poslednju opciju kako bi datum bio odštampan u formatu korisnikovog izabranog jezika.';
$string['defaultcertificatetextx'] = 'Podrazumevani horizontalan položaj teksta';
$string['defaultcertificatetexty'] = 'Podrazumevani vertikalan položaj teksta';
$string['defaultheight'] = 'Podrazumevana visina';
$string['defaultwidth'] = 'Standardna širina';
$string['deletissuedcertificates'] = 'Obriši izdate sertifikate';
$string['delivery'] = 'Dostava sertifikata';
$string['delivery_help'] = 'Izaberite ovde kako želite da vaši studenti dobiju sertifikat.
Otvori u veb čitaču: otvara sertifikat u novom prozoru veb čitača.
Obavezno preuzimanje: otvara prozor čitača za preuzimanje datoteke.
Pošalji sertifikat e-poštom: ako je izabrana ova opcija sertifikat se šalje studentu kao prilog e-poruci. Nakon što korisnik dobije svoj sertifikat, ukoliko klikne na link sertifikata na naslovnoj stranici kursa, videće datum kada je dobio sertifikat i moći će da ga pregleda.';
$string['designoptions'] = 'Opcije za dizajn';
$string['download'] = 'Obavezno preuzimanje';
$string['emailcertificate'] = 'Pošalji sertifikat e-poštom (takođe mora izabrati sačuvaj!)';
$string['emailfrom'] = 'Ime pošiljaoca elektronske poruke';
$string['emailfrom_help'] = 'Alternativno ime pošiljaoca elektronske poruke';
$string['emailothers'] = 'Pošalji e-poštom drugima';
$string['emailothers_help'] = 'Unesite ovede elektronske adrese, razdvojene zarezom, onih koje treba obavestiti elektronsko poštom svaki put kada studenti dobiju sertifikat.';
$string['emailstudenttext'] = 'U prilogu je Vaš sertifikat za kurs {$a->course}.';
$string['emailteachermail'] = '{$a->student} je primio svoj sertifikat: \'{$a->certificate}\' za kurs {{$a->course}.

Možete ga pregledati ovde:

{$a->url}';
$string['emailteachermailhtml'] = '{$a->student} je primio svoj sertifikat: \'<i>{$a->certificate}</i>\' za kurs {$a->course}.

Možete ga pregledati ovde:

<a href="{$a->url}">Izveštaj o sertifikatu</a>.';
$string['emailteachers'] = 'Pošalji e-poštu predavačima';
$string['emailteachers_help'] = 'Ako je ova opcija omogućena, onda će predavači biti obavešteni e-poštom svaki put kada studenti dobiju sertifikat';
$string['filenotfound'] = 'Datoteka nije pronađena: {$a}';
$string['getcertificate'] = 'Preuzmite svoj sertifikat';
$string['grade'] = 'Ocena';
$string['gradefmt'] = 'Format ocene';
$string['gradefmt_help'] = 'Ako želite da na sertifikatu odštampate ocenu postoje tri dostupna formata:

Procentualna ocena: štampa ocenu kao procenat.
Bodovna ocena: štampa ocenu kao broj bodova.
Slovna ocena: štampa ocenu kao slovo.';
$string['gradeletter'] = 'Slovna ocena';
$string['gradepercent'] = 'Procentualna ocena';
$string['gradepoints'] = 'Bodovna ocena';
$string['height'] = 'Visina sertifikata';
$string['hours'] = 'časa/ova';
$string['intro'] = 'Uvod';
$string['invalidcode'] = 'Neispravan kôd sertifikata';
$string['issued'] = 'Izdat';
$string['issueddate'] = 'Datum izdavanja';
$string['issueoptions'] = 'Opcije za izdavanje';
$string['keywords'] = 'sertifikat, kurs, pdf, moodle';
$string['modulename'] = 'Jednostavan sertifikat';
$string['modulenameplural'] = 'Jednostavni sertifikati';
$string['neverdeleteoption'] = 'Nikada ne briši';
$string['nocertificatesissued'] = 'Ne postoje sertifikati koji su izdati';
$string['openbrowser'] = 'Otvori u novom prozoru';
$string['opendownload'] = 'Kliknite donje dugme da biste sačuvali sertifikat na svom računaru';
$string['openemail'] = 'Kliknite donje dugme i sertifikat će Vam biti poslat kao prilog e-poruci.';
$string['openwindow'] = 'Kliknite donje dugme da biste otvorili sertifikat u novom prozoru veb čitača';
$string['pluginadministration'] = 'Administracija sertifikata';
$string['pluginname'] = 'Jednostavan sertifikat';
$string['printdate'] = 'Štampaj datum';
$string['printdate_help'] = 'Ovo je datum koji će biti odštampan ako izaberete opciju \'Štampaj datum\'. U slučaju da je izabran datum završetka kursa, a student kurs nije završio, biće odštampan datum dobijanja sertifikata. Takođe, možete da izaberete da kao datum bude odštampan dan kada je aktivnost ocenjena. Ako se sertifikat izdaje pre ocenjivanja aktivnosti, biće odštampan datum dobijanja sertifikata.';
$string['printgrade'] = 'Štampaj ocenu';
$string['printgrade_help'] = 'Možete da izaberete bilo koju dostupnu stavku iz knjige ocena kako biste tu ocenu štampali na sertifikatu, Stavke ocena poređane su istom redosledom kojim se pojavljuju u knjizi ocena. Izaberite format ocene dole.';
$string['printoutcome'] = 'Štampaj ishod';
$string['printoutcome_help'] = 'Možete da izaberete bilo koji ishod kursa kako biste na sertifikatu odštampali naziv ishoda i rezultat koji je student/korisnik postigao. Na primer: Ishod zadataka: Odličan (Vešt).';
$string['receiveddate'] = 'Datum dobijanja';
$string['report'] = 'Izveštaj';
$string['size'] = 'Veličina sertifikata';
$string['size_help'] = 'Ovo je širina i visina sertifikata (u milimetrima). Standardna veličina je položena stranica A4 formata';
$string['summaryofattempts'] = 'Rezime ranije dobijenih sertifikata';
$string['textposition'] = 'Položaj teksta sertifikata';
$string['textposition_help'] = 'Ovo su xy koordinate teksta sertifikata (u milimetrima)';
$string['userdateformat'] = 'Datum u formatu jezika korisnika';
$string['viewcertificateviews'] = 'Pogledaj {$a} izdata/ih sertifikata';
$string['width'] = 'Širina sertifikata';
