<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_pioneer', language 'sr_cr', version '3.8'.
 *
 * @package     theme_pioneer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitybackground'] = 'Боја позадине активности на курсу';
$string['activitybackground_desc'] = 'Ово је боја позадине поља када се приказују активности као што су лекција, задатак итд.';
$string['allclasses'] = 'Сви часови';
$string['allcourses'] = 'Сви курсеви';
$string['allmodules'] = 'Сви модули';
$string['allunits'] = 'Све јединице';
$string['alwaysdisplay'] = 'Увек прикажи';
$string['analyticscleanurl'] = 'Чиста URL адреса';
$string['analyticscleanurldesc'] = 'Генерише чисту URL адресу за напредно праћење';
$string['analyticsenabled'] = 'Омогућено';
$string['analyticsenableddesc'] = 'Омогућава аналитику за Moodle';
$string['analyticsheading'] = 'Google Analytics';
$string['analyticssiteid'] = 'ID ознака сајта';
$string['analyticssiteiddesc'] = 'Унесите ID ознаку вашег сајта';
$string['analyticstrackadmin'] = 'Праћење администратора';
$string['analyticstrackadmindesc'] = 'Омогућава праћење активности администратора (не препоручује се)';
$string['analyticstrackingid'] = 'ID ознака сајта';
$string['analyticstrackingiddesc'] = 'Унесите вашу ID ознаку праћења са Googlea';
$string['backgroundfixed'] = 'Фиксирана позадина';
$string['backgroundfixed_desc'] = 'Употребите ово подешавање како бисте фиксирали позадинску слику за страницу.';
$string['backgroundimage'] = 'Позадинска слика';
$string['backgroundimage_desc'] = 'Слика која се приказује у позадини сајта.';
$string['backgroundimageinfo'] = 'Позадинска слика';
$string['backgroundimageinfodesc'] = 'Пошто се главни садржај распростире читавом ширином екрана видећете само мали део боје позадине на самом дну странице. Можете да поставите слику ако желите.';
$string['backgroundposition'] = 'Положај позадине';
$string['backgroundposition_desc'] = 'Положај позадинске слике.';
$string['backgroundpositioncenterbottom'] = 'Центар дно';
$string['backgroundpositioncentercenter'] = 'Центар средина';
$string['backgroundpositioncentertop'] = 'Центар врх';
$string['backgroundpositionleftbottom'] = 'Лево дно';
$string['backgroundpositionleftcenter'] = 'Лево средина';
$string['backgroundpositionlefttop'] = 'Лево врх';
$string['backgroundpositionrightbottom'] = 'Десно дно';
$string['backgroundpositionrightcenter'] = 'Десно средина';
$string['backgroundpositionrighttop'] = 'Десно врх';
$string['backgroundrepeat'] = 'Понављање позадине';
$string['backgroundrepeat_desc'] = 'Дефинише начин на који ће се позадинска слика понављати.';
$string['backgroundrepeatnorepeat'] = 'Без понављања';
$string['backgroundrepeatrepeat'] = 'Понови';
$string['backgroundrepeatrepeatx'] = 'Понови хоризонтално';
$string['backgroundrepeatrepeaty'] = 'Понови вертикално';
$string['blockbordercolor'] = 'Боја ивице блока';
$string['blockbordercolor_desc'] = 'Ово је боја ивице блока унутар курса. То је и боја позадине наслова блока.';
$string['blockcolor'] = 'Боја блока';
$string['blockcolor_desc'] = 'Ово је боја позадине блока унутар курса';
$string['blockheadercolor'] = 'Боја заглавља блока';
$string['blockheadercolor_desc'] = 'Ово је боја позадине заглавља у сваком блоку. Користите ове подешавање ако желите једну боју позадине заглавља за све блокове.';
$string['blockposition'] = 'Поравнај блокове';
$string['blockposition_desc'] = 'Поставите блокове лево или десно од садржаја.';
$string['blocksdesc'] = 'Поравнајте блокове уз леву или десну ивицу странице.';
$string['blocksinfo'] = 'Позиција блокова';
$string['blocksleft'] = 'Поравнај блокове налево';
$string['blocksright'] = 'Поравнај блокове надесно';
$string['blocktitlecolor'] = 'Боја текста наслова блока';
$string['blocktitlecolor_desc'] = 'Ово је боја текста наслова блока.';
$string['bodybackground'] = 'Боја позадине';
$string['bodybackground_desc'] = 'Главна боја која ће се користити за позадину.';
$string['bodyfont'] = 'Основни фонт';
$string['bodyfontdesc'] = 'ОСНОВНИ ФОНТ - КОРАК 2: Копирајте кôд Google фонта који почиње са породицом фонтова (интегришите фонтове у ваш CSS)';
$string['bodysize'] = 'Величина основног текста';
$string['bodysizedesc'] = 'Користите број, нпр. 14 пиксела';
$string['bodyweight'] = 'Дебљина основног фонта';
$string['bodyweightdesc'] = 'Типично, Google фонтови имаће број као што је 100, 200, 300, итд. Упишите тај број овде.';
$string['bothpositions'] = 'Обе позиције';
$string['breadcrumbcolor'] = 'Боја навигационе путање';
$string['breadcrumbcolor_desc'] = 'Изаберите боју позадине траке са навигационом путањом. Трака је смештена одмах испод слике главног заглавља странице.';
$string['breadcrumbcolorhover'] = 'Лебдећа боја навигационе путање';
$string['breadcrumbcolorhover_desc'] = 'Изаберите боју позадине за траку навигационе путање када се мишем прелази преко њених ставки. Трака је смештена одмах испод слике главног заглавља странице.';
$string['breadcrumbtext'] = 'Боја текста навигационе путање';
$string['breadcrumbtext_desc'] = 'Изаберите боју за текст навигационе путање.';
$string['choosereadme'] = '<p>Pioneer је лепа графичка тема, прилагодљивог дизајна са великим бројем функција почев од наменски прилагођених картица и клизача за књигу оцена до могућности да предавач постави засебну слику заглавља међу датотеке резимеа курса! Сваки од главних елемената теме може бити прилагођен према потребама, на страници за подешавање теме. Pioneer је тема која направљена за потребе  Dearborn Public Schools, Michigan.</p>';
$string['colorheading'] = 'Боје';
$string['configtitle'] = 'Pioneer';
$string['contentbackground'] = 'Боја позадине главног садржаја';
$string['contentbackground_desc'] = 'Боја позадине главног садржаја на сајту. Оставите празно ако желите да главни садржај нема боју позадине.';
$string['contentbackgroundcolor'] = 'Боја позадине садржаја';
$string['contentbackgroundcolor_desc'] = 'Ово је боја позадине главног садржаја курса. Ако боју овде обришете, као боја позадине биће искоришћена основна боја позадина, доле наведена, као и подешавања позадинске слике.';
$string['copyrighttext'] = 'Обавештење о ауторским правима';
$string['copyrighttext_desc'] = 'Додајте обавештење о ауторским правима. Оно ће се појавити у подножју странице.';
$string['coursecomplete'] = 'Кружни индикатор завршетка активности';
$string['coursecomplete_desc'] = 'Ако курс користи опцију за праћење завршетка активности и ако је ова опција укључена, онда ће полазници, у горњем левом углу странице, видети индикатор својих постигнућа у облику круга, заједно са процентом активности које су успешно завршили.';
$string['coursegradebutton'] = 'Оцене на курсу';
$string['coursegradeinfo'] = 'Регион заглавља курса (Картице насловне странице и Оцене на курсу)';
$string['coursegradeinfodesc'] = 'Ова подешавања контролишу дугме клизача на на насловној страници и главној страници курса. Клизач ”Оцене на курсу” приказује списак свих активности на курсу које се оцењују као и оцене студента за сваку од њих. Картице на насловној страници захтевају да претходно додате садржај за њих на страници за уређивање ”Картице насловне странице”. Да би се оцене на курсу уопште појавиле потребно је да, у делу страници за подешавање курса ”Изглед”, подесите опцију ”Прикажи оцене полазницима” на ДА.';
$string['coursegradestext'] = 'Текст дугмета ”Оцене на курсу”';
$string['coursegradestextdesc'] = 'Унесите текст који желите да се појави на дугмету прекидача.';
$string['coursegradetoggle'] = 'Прикажи/сакриј клизач за оцене на курсу';
$string['coursegradetoggle_desc'] = 'Ово ће омогућити полазницима да брзо виде списак свих активности и своје оцене у заглављу на врху странице, одмах изнад навигационе путање а испод назива курса.';
$string['coursetitlebkg'] = 'Боја позадине наслова курса';
$string['coursetitlebkg_desc'] = 'Ово је боја поља које се појављује иза наслова курса. Како би тема изгледала конзистенто, ова боја се, такође, користи као боја позадине за слајд-шоу курсева и наслове доступних курсева.';
$string['coursetitletxt'] = 'Боја текста наслова курса';
$string['coursetitletxt_desc'] = 'Ово је боја наслова курса.';
$string['createusertoggle'] = 'Линк за креирање новог налога';
$string['createusertoggle_desc'] = 'Приказује/скрива линк за креирање новог корисничког налога на прилагођеном обрасцу за пријаву на насловној страници.';
$string['customcss'] = 'Прилагођени CSS';
$string['customcssdesc'] = 'CSS правила која додате у ово поље за текст одразиће се на изглед свих страница, што олакшава прилагођавање ове теме.';
$string['customlogindesc'] = 'Опције за прилагођену пријаву';
$string['customlogininfo'] = 'Прилагођена пријава';
$string['custommenudesc'] = 'Ова подешавања дају вам могућност да прилагођеном менију додате допунску функционалност (познату и као падајући мени)';
$string['custommenuheadingsub'] = 'Додајте допунску функционалност свом прилагођеном менију.';
$string['displayafterlogin'] = 'Прикажи само након пријаве на систем';
$string['displaybeforelogin'] = 'Прикажи само пре пријаве на систем';
$string['displaymycourses'] = 'Прикажи уписане курсеве';
$string['displaymycoursesdesc'] = 'Приказује корисницима у прилагођеном менију курсеве које су уписали';
$string['displaymydashboard'] = 'Прикажи контролни панел';
$string['displaymydashboarddesc'] = 'Приказује линк за контролни панел у прилагођеном менију корисника';
$string['dontdisplay'] = 'Никад не приказуј';
$string['editoff'] = 'Искључи уређивање';
$string['editon'] = 'Укључи уређивање';
$string['enablethiscourse'] = 'Мени активности на курсу';
$string['enablethiscoursedesc'] = 'Приказује падајући мени са активностима на курсу.';
$string['footertext1'] = 'Текстуално поље подножја један';
$string['footertext2'] = 'Текстуално поље подножја два';
$string['footertext3'] = 'Текстуално поље подножја три';
$string['footertext4'] = 'Текстуално поље подножја четири';
$string['footertext_desc'] = 'Унесите HTML текст и он ће се појавити на дну сваке странице. На располагању су вам четири поља (ступца) која користе  Bootstrap.';
$string['footertextboxes'] = 'Прилагођено подножје странице';
$string['forgotpasstoggle'] = 'Линк за заборављену лозинку';
$string['forgotpasstoggle_desc'] = 'Приказује/скрива линк за заборављену лозинку на прилагођеном обрасцу за пријаву на насловној страници.';
$string['fpcreatortextbox'] = 'Текстуално поље на насловној страници за креаторе курсева';
$string['fpcreatortextbox_desc'] = 'Додајте садржај који могу да виде само корисници са улогом креатора курса.';
$string['fpdashboard'] = 'Контролни панел насловне странице';
$string['fpheaderimagepadding'] = 'Величина слике заглавља на насловној страници';
$string['fpheaderimagepadding_desc'] = 'Ово подешавање контролише висину слике заглавља на насловној страници (односно удаљеност обрасца за пријаву од горње ивице слике), када корисник није пријављен на систем.';
$string['fpsearch'] = 'Претражи курсеве';
$string['fpsearchboxmain'] = 'Прикажи поље за претрагу курсева у региону главног садржаја';
$string['fpsearchboxmain_desc'] = 'Приказује поље за претрагу курсева у текстуалном пољу насловне странице. Ова опција зависи од подешавања иконица за навигацију, тј. поље за претрагу биће приказано само ако је подешено да иконице за навигацију буду приказане у делу странице са главним садржајем.';
$string['fpsearchboxtop'] = 'Прикажи поље за претрагу курсева у навигационoj траци на врху странице';
$string['fpsearchboxtop_desc'] = 'Приказује поље за претрагу курсева у навигационој траци на врху насловне странице. Поље за претрагу ће се појавити десно од иконица за навигацију на врху странице, и биће приказано чак и ако су иконице за навигацију сакривене. Ово поље за претрагу не зависи од подешавања иконица за навигацију.';
$string['fpsearchbutton'] = 'Претражи';
$string['fptextbox'] = 'Текстуално поље насловне странице';
$string['fptextboxdesc'] = 'Ово текстуално поље се појављује на насловној страници и идеално је за постављање поруке добродошлице.';
$string['fptextboxinfo'] = 'Поље за добродошлицу на насловној страници';
$string['fptextboxinfodesc'] = 'Додајте поруку добродошлице корисницима.';
$string['fptoppromotedpadding'] = 'Висина слајд-шоу презентације';
$string['fptoppromotedpadding_desc'] = 'Ово подешавање контролише висину слајд-шоу презентације.';
$string['frontpagecoursesettings'] = 'Курсеви на насловној страници';
$string['frontpagedesc'] = 'Конфигуришите начин на који ће поља курсева бити приказана на насловној страници.';
$string['frontpageheading'] = 'Опције насловне странице';
$string['frontpagerenderer'] = 'Поља курсева на насловној страници';
$string['frontpagerendererdefaultimage'] = 'Подразумевана слика курса';
$string['frontpagerendererdefaultimagedesc'] = 'Подразумевана слика курса која ће се користити када не постоји слика курса (примењиво само за опцију ”Плочице са прекривачем”)';
$string['frontpagerendererdesc'] = 'Ово подешавање контролише на који начин ће бити приказана поља курсева на насловној страници.';
$string['frontpagerendereroption1'] = 'Плочице';
$string['frontpagerendereroption2'] = 'Плочице са прекривачем';
$string['frontpagesettingsheading'] = 'Визуализација насловне странице';
$string['fullfootertext'] = 'Текстуално поље читавом ширином подножја странице';
$string['fullfootertext_desc'] = 'Ово је текстуално поље које се пружа читавом ширином подножја странице, изнад 4 ступца са текстуалним пољима. Ово поље је идеално ако не желите да користите ова 4 ступца.';
$string['gbodyimporturl'] = 'URL адреса за увоз основног фонта';
$string['gbodyimporturldesc'] = 'ОСНОВНИ ФОНТ - КОРАК 1: пронађите фонт на google.com/fonts. Пронађите корак који каже ”Додајте овај кôд на ваш сајт”.  Прекопирајте тај кôд овде. Будите сигурни да сте завршили КОРАК 2.  <a href="https://www.google.com/fonts"> Пронађите Google Font</a>';
$string['geneicsettings'] = 'Општа подешавања';
$string['generalalert'] = 'Општа важна обавештења';
$string['generalalertdesc'] = 'Садржај који додате у ово поље за текст биће приказан у пољу ”Општа важна обавештења” на насловној страници.';
$string['gheadingimporturl'] = 'URL адреса за увоз фонта наслова';
$string['gheadingimporturldesc'] = 'ФОНТ НАСЛОВА - КОРАК 1: пронађите фонт на google.com/fonts. Пронађите корак који каже ”Додајте овај кôд на ваш сајт”.  Прекопирајте тај кôд овде. Будите сигурни да сте завршили КОРАК 2.  <a href="https://www.google.com/fonts"> Пронађите Google Font</a>';
$string['googleheading'] = 'Google фонтови';
$string['gradecomplete'] = 'Кружни индикатор укупне оцене на курсу';
$string['gradecomplete_desc'] = 'Ако je курс тако подешен да приказује оцене полазницима и ако је ова опција укључена, онда ће они у горњем левом углу странице, видети индикатор својих постигнућа у облику круга, заједно са процентом укупне оцене на курсу.';
$string['grades'] = 'Моје оцене';
$string['headerbackgroundimage'] = 'Подразумевана слика заглавља';
$string['headerbackgroundimage_desc'] = 'Ово је подразумевана слика заглавља.';
$string['headerbackgroundtoggle'] = 'Дозволи предавачима да поставе слику заглавља';
$string['headerbackgroundtoggle_desc'] = 'Ако је опција укључена предавач може да постави слику у <a href="https://docs.moodle.org/29/en/Course_settings#Course_summary_files" target="_new">Датотеке резимеа курса</a>. Ова слика би требало да буде оптимизована како би се скратило време учитавања. Препоручује се да слика буде широка 1024 пиксела и мања од 500kb. У супротном, сви курсеви ће користити фотографију коју доле поставите као слику заглавља.';
$string['headerimageinfo'] = 'Висина слике заглавља';
$string['headerimageinfodesc'] = 'Ова подешавања контролишу висину слике заглавља на страницама сајта, као и на страницама активности унутар курсева.';
$string['headerimagepadding'] = 'Величина слике заглавља';
$string['headerimagepadding_desc'] = 'Ово подешавање контролише висину слике у заглављу насловне странице курса. Уколико се користе кружни индикатори за завршетак активности и укупну оцену, онда слика мора бити најмање 120 пиксела висине.';
$string['headerimagepage'] = 'Подешавање слике заглавља';
$string['headerincourseimagepadding'] = 'Величина слике заглавља унутар активности на курсевима';
$string['headerincourseimagepadding_desc'] = 'Ово подешавање контролише величине слике заглавља на свим страницама, осим на насловној страници  курса. Што је величина заглавља мања, биће приказано више садржаја.';
$string['headingfont'] = 'Породица фонтова наслова';
$string['headingfontdesc'] = 'ФОНТ НАСЛОВА - КОРАК 2: Копирајте овде информацију о породици Google фонта.';
$string['iconnavbackgroundcolor'] = 'Позадина иконица за навигацију и поља за претрагу на главном делу странице';
$string['iconnavbackgroundcolor_desc'] = 'Ово је боја позадине за иконице за навигацију и поље за претрагу, који се налазе на делу странице са главним садржајем.';
$string['iconnavbackgroundcolortop'] = 'Позадина иконица за навигацију и поља за претрагу на врху странице';
$string['iconnavbackgroundcolortop_desc'] = 'Ово је боја позадине за иконице за навигацију и поље за претрагу, који се налазе се налазе на самом врху странице.';
$string['iconnavheading'] = 'Иконице за навигацију';
$string['inmaincontent'] = 'Само главни садржај';
$string['intopnav'] = 'Само навигациона трака на врху';
$string['invert'] = 'Инвертуј навигациону траку';
$string['invertdesc'] = 'Ова опција мења боју текста и позадине навигационе траке на врху странице између црне и беле.';
$string['lginforgot'] = 'заборавили сте лозинку?';
$string['lginlogin'] = 'Пријава';
$string['lginpass'] = 'лозинка';
$string['lginuser'] = 'корисничко име';
$string['linkcolor'] = 'Боја линкова';
$string['linkcolor_desc'] = 'Боја линкова.';
$string['loginbuttoncolor'] = 'Боја дугмета за пријаву';
$string['loginbuttoncolor_desc'] = 'Ово је боја дугмета на прилагођеном обрасцу за пријаву на систем.';
$string['logo'] = 'Лого';
$string['logodesc'] = 'Лого треба да буде величине 140 са 140 пиксела. Лого се приказају у горњем левом и доњем десном углу теме.';
$string['marketboxbuttoncolor'] = 'Боја дугмета промотивног блока';
$string['marketboxbuttoncolor_desc'] = 'Боја позадине дугмета промотивног блока.';
$string['marketboxcolor'] = 'Боја позадине промотивног блока';
$string['marketboxcolor_desc'] = 'Боја позадине промотивног блока.';
$string['marketboxcontentcolor'] = 'Боја позадине садржаја промотивног блока';
$string['marketboxcontentcolor_desc'] = 'Боја позадине садржаја промотивног блока. Ово се односи на онај део промотивног блока у којем се појављује текст и може бити различита од позадинске боје самог блока да би се пажња скренула на текст.';
$string['marketing1'] = 'Промотивни блок један';
$string['marketing2'] = 'Промотивни блок два';
$string['marketing3'] = 'Промотивни блок три';
$string['marketing4'] = 'Промотивни блок четири';
$string['marketing5'] = 'Промотивни блок пет';
$string['marketing6'] = 'Промотивни блок шест';
$string['marketingbuttontext'] = 'Текст линка';
$string['marketingbuttontextdesc'] = 'Текст који се појављује на дугмету';
$string['marketingbuttonurl'] = 'URL адреса линка';
$string['marketingbuttonurldesc'] = 'URL адреса са којом је дугме повезано.';
$string['marketingcontent'] = 'Садржај';
$string['marketingcontentdesc'] = 'Текст који се приказује у промотивном блоку. Треба да буде кратак и занимљив.';
$string['marketingdesc'] = 'Ова тема пружа опцију да на насловној страници поставите три промотивна блока или огласа, одмах испод слајд-шоу презентације. Ово вам омогућава да својим корисницима лако назначите најбитније информације и обезбедите одговарајуће директне линкове.';
$string['marketingheading'] = 'Доњи промотивни блокови';
$string['marketingheadingsub'] = 'Три места на насловној страници сајта за додатне информације и линкове';
$string['marketingheadingtextbox'] = 'Горњи оквир за текст промотивних блокова';
$string['marketingheadingtop'] = 'Горњи промотивни блокови';
$string['marketingheight'] = 'Висина слике у промотивном блоку';
$string['marketingheightdesc'] = 'Уколико желите да прикажете слике у промотивним блоковима овде можете да наведете њихову висину.';
$string['marketingicon'] = 'Иконица линка';
$string['marketingicondesc'] = 'Назив иконице коју желите да користите за URL дугме у промотивном блоку. Списак иконица можете наћи <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">овде</a>. Унесите само оно што следи иза  "fa-",", нпр.  "star".';
$string['marketingimage'] = 'Слика';
$string['marketingimage_desc'] = 'Ово даје могућност да се у промотивном блоку прикаже слика';
$string['marketinginfodesc'] = 'Унесите подешавања за ваш промотивни блок.';
$string['marketingtitle'] = 'Наслов';
$string['marketingtitledesc'] = 'Наслов који ће бити приказан у овом промотивном блоку';
$string['marketingurltarget'] = 'Одредиште линка';
$string['marketingurltargetdesc'] = 'Изаберите како линк треба да буде отворен';
$string['marketingurltargetnew'] = 'Нова страница';
$string['marketingurltargetparent'] = 'Надређени оквир';
$string['marketingurltargetself'] = 'Текућа страница';
$string['mybkg'] = 'Позадина клизача ”Моји курсеви”';
$string['mybkg_desc'] = 'Изаберите боју за позадину клизача  ”Моји курсеви”';
$string['myclasses'] = 'Моји часови';
$string['mycorusesinfo'] = 'Опције навигационог менија';
$string['mycorusesinfodesc'] = 'Ова подешавања контролишу навигациону траку на врху странице. Ово укључује падајуће меније ”Моји курсеви” и ”Овај курс”.';
$string['mycourses'] = 'Моји курсеви';
$string['mycoursesheading'] = 'Клизач ”Моји курсеви”';
$string['mycoursesheadingdesc'] = 'Ово ће приказати курсеве на које корисник уписан као полазник односно предавач. Курсеви се приказују у лепо дизајнираном, прилагодљивом клизачу. Најпогодније је за приказ на стоним рачунарима.';
$string['mycoursesinfo'] = 'Динамички списак уписаних курсева';
$string['mycoursesinfodesc'] = 'Приказује кориснику динамички списак курсева које је уписао.';
$string['mycoursetitle'] = 'Терминологија';
$string['mycoursetitledesc'] = 'Промените термин за линк "Моји курсеви" у падајућем менију';
$string['mydashboardinfo'] = 'Прилагођени контролни панел корисника';
$string['mydashboardinfodesc'] = 'Приказује списак заједничких функција које користе корисници.';
$string['mymodules'] = 'Моји модули';
$string['myunits'] = 'Моје јединице';
$string['navbkgcolor'] = 'Позадина главне навигације';
$string['navbkgcolor_desc'] = 'Ово је боја позадине за главну навигациону траку';
$string['navcolor'] = 'Боја падајућег менија навигационе траке';
$string['navcolor_desc'] = 'Боја падајућег менија у навигационој траци';
$string['navcolorhover'] = 'Лебдећа боја падајућег менија навигационе траке';
$string['navcolorhover_desc'] = 'Боја падајућег менија у навигационој траци када се мишем пређе преко њега';
$string['navicon'] = 'Иконица';
$string['navicon1'] = 'Прилагођена иконица насловне странице један';
$string['navicon2'] = 'Прилагођена иконица насловне странице два';
$string['navicon3'] = 'Прилагођена иконица насловне странице три';
$string['navicon4'] = 'Прилагођена иконица насловне странице четири';
$string['navicon5'] = 'Прилагођена иконица насловне странице пет';
$string['navicon6'] = 'Прилагођена иконица насловне странице шест';
$string['navicon7'] = 'Прилагођена иконица насловне странице седам';
$string['navicon8'] = 'Прилагођена иконица насловне странице осам';
$string['naviconbuttontext'] = 'Kратак опис иконице';
$string['naviconbuttontextdesc'] = 'Текст који се појављује у кратком опису иконице када се мишем пређе преко ње.';
$string['naviconbuttonurl'] = 'URL адреса линка';
$string['naviconbuttonurldesc'] = 'URL адреса са којом је дугме повезано. Дугме можете да повежете са било који веб сајтом, само унесите исправну URL адресу. Ако је ваш Мoodle сајт смештен у поддиректоријуму подразумевана URL адреса неће функционисати. Подесите URL адресу тако да она указује на поддиректоријум. На пример, ако је назив вашег поддиректоријума "moodle" онда URL адресу треба променити у /moodle/my/';
$string['navicondesc'] = 'Назив иконице коју желите да користите. Списак иконица можете наћи <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">овде</a>. Унесите само оно што следи иза  "fa-",", нпр.  "star".';
$string['naviconoff'] = 'Искључи прилагођене навигационе иконице';
$string['naviconon'] = 'Укључи прилагођене навигационе иконице';
$string['navigation'] = 'Опције навигације';
$string['noenrolments'] = 'Тренутно нисте уписани ни на један курс';
$string['pcourseenable'] = 'Омогући истакнуте курсеве';
$string['pcourses'] = 'Доњи истакнути курсеви';
$string['pcoursesdesc'] = 'Наведите ID ознаке истакнутих курсева, раздвојене зарезом.';
$string['people'] = 'Колеге';
$string['pluginname'] = 'Pioneer';
$string['promotedcoursesheading'] = 'Доњи клизач ”Истакнути курсеви”';
$string['promotedlink'] = '”Истакнути курсеви” - URL адреса за линк ”Прикажи још курсева”';
$string['promotedlink_desc'] = 'Унесите URL адресу за једну од ваших категорија. Ово ће се приказати одмах поред наслова ”Истакнути курсеви”.';
$string['promotedlinktext'] = '”Истакнути курсеви” - текст за ”Прикажи још курсева”';
$string['promotedlinktext_desc'] = 'Ово пружа могућност за повезивање са категоријом курса како би у доњем клизачу ”Истакнути курсеви” било приказано још курсева. Унесите URL адресу у доње поље.';
$string['promotedmylink'] = 'Клизач ”Моји курсеви” - URL адреса за линк ”Прикажи још курсева”';
$string['promotedmylink_desc'] = 'Унесите URL адресу за једну од ваших категорија. Ово ће се приказати одмах поред наслова клизача ”Моји курсеви”.';
$string['promotedmylinktext'] = 'Клизач ”Моји курсеви” - текст за ”Прикажи још курсева”';
$string['promotedmylinktext_desc'] = 'Ово пружа могућност за повезивање са категоријом курса како би било приказано још курсева. Унесите URL адресу у доње поље.';
$string['promotedmytextbox'] = 'Текстуално поље (са описом) клизача ”Моји курсеви”';
$string['promotedmytextbox_desc'] = 'Текстуално поље које се појављује са блоком клизача ”Моји курсеви”';
$string['promotedmytitle'] = 'Наслов клизача  ”Моји курсеви”';
$string['promotedmytitledesc'] = 'Молимо, дајте наслов блоку клизача ”Моји курсеви”';
$string['promotedtaglink'] = '”Препоручени курсеви” - URL адреса за линк ”Прикажи још курсева”';
$string['promotedtaglink_desc'] = 'Унесите URL адресу за једну од ваших категорија. Ово ће се приказати одмах поред наслова ”Истакнути курсеви”.';
$string['promotedtaglinktext'] = '”Препоручени курсеви” - текст за ”Прикажи још курсева”';
$string['promotedtaglinktext_desc'] = 'Ово пружа могућност за повезивање са категоријом курса како би било приказано још курсева. Унесите URL адресу у доње поље.';
$string['promotedtagtextbox'] = 'Текстуално поље (са описом) клизача ”Персонализовани курсеви”';
$string['promotedtagtextbox_desc'] = 'Искористите ово поље како бисте корисницима објаснили како да додају ознаке (интересовања) у свој профил, као и како се додају ознаке курса, тако да препоручени курсеви могу да се прикажу кориснику.';
$string['promotedtagtitle'] = 'Наслов клизача  ”Персонализовани препоручени курсеви”';
$string['promotedtagtitledesc'] = 'Молимо, дајте наслов блоку клизача ”Персонализовани препоручени курсеви”';
$string['promotedtitledefault'] = 'Истакнути курсеви';
$string['promotedtitledesc'] = 'Молимо вас, дајте назив блока ”Препоручени курсеви”.';
$string['radialboxbackground'] = 'Позадина кружних индикатора завршетка курса за завршетак активности и укупну оцену';
$string['radialboxbackground_desc'] = 'Ово је боја позадине поља које садржи кружне индикаторе за завршетак активности и укупну оцену у горњем левом углу страница курса.';
$string['radialcolor'] = 'Боја круга индикатора';
$string['radialcolor_desc'] = 'Подесите боју круга индикатора';
$string['recommendedbkg'] = 'Боја позадине више клизача';
$string['recommendedbkg_desc'] = 'Ова боја биће примењена за клизаче ”Истакнути курсеви”, ”Персонализовани препоручени курсеви” и ”Моји курсеви”. Они се налазе на насловној страници.';
$string['recommendedcoursesheading'] = 'Клизач ”Персонализовани препоручени курсеви”';
$string['recommendedcoursesheadingdesc'] = 'Клизач ”Персонализовани препоручени курсеви” спарује ознаке (интересовања) корисника из њихових профила са ознакама курсева. Када се поклапања пронађу, резултујући списак курсева биће приказана у лепо дизајнираном, прилагодљивом клизачу на насловној страници. Ово подешавање је аутоматско и није потребна никаква интеракција, осим уношења ознака за курсеве и ознака (интересовања) у профилима корисника.';
$string['region-side-post'] = 'Десно';
$string['region-side-pre'] = 'Лево';
$string['rendereroverlaycolor'] = 'Боја прекривача';
$string['rendereroverlaycolordesc'] = 'Боја прекривача, када је изабрана опција приказа ”Плочице са прекривачем”.';
$string['rendereroverlayfontcolor'] = 'Боја фонта прекривача';
$string['rendereroverlayfontcolordesc'] = 'Боја фонта када се мишем пређе преко поља курса (у ситуацији када је омогућена опција приказа ”Плочице са прекривачем”).';
$string['secondarybackground'] = 'Секундарна боја позадине';
$string['secondarybackground_desc'] = 'Боја позадине било ког секундарног садржаја, као што су нпр. блокови.';
$string['sectionheadericon'] = 'Иконица наслова секције';
$string['sectionheadericondesc'] = 'Ова иконица се појављује пре наслова сваке теме унутар седмичног и тематског формата курса. Користите unicode подешавања са Font Awesome сајта. Списак иконица можете наћи <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_new">овде</a>. Стандардна, f02d иконица је књига.';
$string['settingfeaturedmyslider'] = 'Курсеви на које сам уписан';
$string['settingfeaturedslider'] = 'Истакнути курсеви';
$string['settingfeaturedtagslider'] = 'Персонализовани препоручени курсеви';
$string['settinggradebutton'] = 'Прикажи оцене на курсу';
$string['settingpromotedlink'] = 'http://mymoodlesite/course/';
$string['settingpromotedlinktext'] = '”Истакнути курсеви” - Прикажи још курсева';
$string['settingpromotedmylink'] = 'http://mymoodlesite/course/';
$string['settingpromotedmylinktext'] = 'Клизач ”Моји курсеви” - Прикажи још курсева';
$string['settingpromotedtaglink'] = 'http://mymoodlesite/course/';
$string['settingpromotedtaglinktext'] = '”Препоручени курсеви” - Прикажи још курсева';
$string['settingshowtagline'] = 'Упишите се сада';
$string['settingtabbutton'] = 'Почетни кораци у Moodleu';
$string['showlogintoggle'] = 'Прикажи образац за пријаву';
$string['showlogintoggle_desc'] = 'Приказује односно сакрива прилагођени образац за пријави на насловној страници.';
$string['showmycourses'] = 'Прикажи/сакриј клизач ”Моји курсеви”';
$string['showmycourses_desc'] = 'Искључите ову опцију ако не желите да се приказује клизач ”Моји курсеви”.';
$string['showrecommendedcourses'] = 'Прикажи/Сакриј персонализоване препоручене курсеве';
$string['showrecommendedcourses_desc'] = 'Искључите ову опцију ако не желите да се приказују персонализовани препоручени курсеви.';
$string['signuplogin'] = 'Креирај нови налог';
$string['socialicon1'] = 'Facebook URL адреса';
$string['socialicon2'] = 'Twitter URL адреса';
$string['socialicon3'] = 'Pinterest URL адреса';
$string['socialicon4'] = 'Flickr URL адреса';
$string['socialicon5'] = 'LinkedIn URL адреса';
$string['socialicon6'] = 'YouTube URL адреса';
$string['socialicon7'] = 'Vimeo URL адреса';
$string['socialicon8'] = 'Google Plus URL адреса';
$string['socialiconheading'] = 'Друштвене мреже';
$string['socialwallheaddesc'] = 'Формат курса "Друштвени зид" је скуп додатака за формат курса за Moodle који омогућава предавачима да курс организују на такав начин да он личи на Facebook. Формат курса "Друштвени зид"  можете преузети са сајт Moodle.org <a href="https://moodle.org/plugins/browse.php?list=set&id=74">https://moodle.org/plugins/browse.php?list=set&id=74</a>. Доња подешавања вам омогућавају да наменски прилагодите боје друштвеног зида.';
$string['socialwallheading'] = 'Опције за формат курса "Друштвени зид"';
$string['stylinginfo'] = 'Форматирање и важна обавештења';
$string['stylinginfodesc'] = 'Додатне опције за прилагођавање теме и подешавања важних обавештења.';
$string['swaddpost'] = 'Формат курса ”Друштвени зид” - позадина поља ”Додај пост”';
$string['swaddpost_desc'] = 'Ако користите формат курса ”Друштвени зид” ово подешавање ће променити боју позадине у делу зида за додавање постова.';
$string['swattach'] = 'Формат курса ”Друштвени зид” - позадина поља ”Прилог”';
$string['swattach_desc'] = 'Ако користите формат курса ”Друштвени зид” ово подешавање ће променити боју позадине у делу зида са прилозима.';
$string['swcomment'] = 'Формат курса ”Друштвени зид” - позадина поља ”Коментар”';
$string['swcomment_desc'] = 'Ако користите формат курса ”Друштвени зид” ово подешавање ће променити боју позадине у делу зида са коментарима.';
$string['swicontext'] = 'Формат курса ”Друштвени зид” - боја иконица и текста';
$string['swicontext_desc'] = 'Ако користите формат курса ”Друштвени зид” ово подешавање ће променити боје иконица и речи Прилози, Постови, Поруке и Коментари.';
$string['swlabelattachment'] = 'Прилог - CSS ознака';
$string['swlabelattachment_desc'] = 'Када постоје прилози са постом ова ознака ће означити прилоге.';
$string['swlabelcomment'] = 'Коментар - CSS ознака';
$string['swlabelcomment_desc'] = 'Ова ознака означава одељак са коментаром за сваки пост на временској линији.';
$string['swlabelmessage'] = 'Порука - CSS ознака';
$string['swlabelmessage_desc'] = 'Ово ознака поруке се појављује на временској линији, изнад садржаја поста.';
$string['swlabelpost'] = 'Пост - CSS ознака';
$string['swlabelpost_desc'] = 'Ово је ознака која се појављује на временској линији, изнад сваког поста.';
$string['swmessage'] = 'Формат курса ”Друштвени зид” - позадина поља ”Порука”';
$string['swmessage_desc'] = 'Ако користите формат курса ”Друштвени зид” ово подешавање ће променити боју позадине у делу зида са порукама.';
$string['swmultilangcss'] = 'Преведите ознаке на ”Друштвеном зиду”';
$string['swmultilangcss_desc'] = 'Уколико одржавате вишејезички сајт, можете да употребите овај пример како бисте ознаке на ”Друштвеном зиду” локализовали на језике које подржавате.';
$string['swpost'] = 'Формат курса ”Друштвени зид” - позадина поља ”Пост”';
$string['swpost_desc'] = 'Ако користите формат курса ”Друштвени зид” ово подешавање ће променити боју позадине у делу зида са постовима.';
$string['tab1'] = 'Картица један';
$string['tab2'] = 'Картица два';
$string['tab3'] = 'Картица три';
$string['tab4'] = 'Картица четири';
$string['tab5'] = 'Картица пет';
$string['tab6'] = 'Картица шест';
$string['tabbutton'] = 'Почетак';
$string['tabbuttoncolor'] = 'Боја дугмета за приказ картица';
$string['tabbuttoncolor_desc'] = 'Боја дугмета које се користи као прекидач за картице на насловној страници и као прекидач за клизач за оцене на курсу. Када је дугме активирано оно се појављује одмах испод наслова странице.';
$string['tabbuttonhovercolor'] = 'Боја ефекта прелаза преко дугмета за приказ картица';
$string['tabbuttonhovercolor_desc'] = 'Боја приликом преласка мишем преко дугмета које се користи као прекидач за картице на насловној страници, и као прекидач за клизач оцена на курсу. Када је дугме активирано оно се појављује одмах испод наслова странице.';
$string['tabbuttontext'] = 'Текст дугмета за приказ картица';
$string['tabbuttontextdesc'] = 'Овај текст се користи у дугмету за приказ картица.';
$string['tabcontent'] = 'Садржај картице';
$string['tabcontentdesc'] = 'Текст и HTML који овде унесете биће приказан као садржај картице.';
$string['tabheading'] = 'Картице насловне странице';
$string['tabinfodesc'] = 'Додајте наслов и опис (садржај) картице. Они ће се појавити на насловној страници тек када је активиран клизач. Дугме за активирање клизача се налази у заглављу врха странице.';
$string['tabtitle'] = 'Наслов картице';
$string['tabtitledesc'] = 'Ово је наслов картице који се појављује на врху садржаја картице.';
$string['tabtoggle'] = 'Прекидач за приказ картица';
$string['tabtoggle_desc'] = 'Прикажи или сакриј картице на насловној страници.';
$string['textcolor'] = 'Боја текста';
$string['textcolor_desc'] = 'Боја текста';
$string['themecolorsettings'] = 'Боја теме';
$string['thiscourse'] = 'Овај курс';
$string['title'] = 'Наслов';
$string['togglefptextbox'] = 'Прикажи/сакриј текстуално поље на насловној страници';
$string['togglefptextboxdesc'] = 'Изаберите да ли желите да сакријете или прикажете текстуално поље на насловној страници, за одјављене кориснике.';
$string['toggleiconnav'] = 'Позиција иконица за навигацију';
$string['toggleiconnav_desc'] = 'Одредити где желите да се појаве иконице и поље за претрагу курсева.';
$string['togglemarketing'] = 'Прекидач за приказ промотивних блокова';
$string['togglemarketingdesc'] = 'Изаберите да ли желите да сакријете или прикажете три промотивна блока.';
$string['togglenavicons'] = 'Укључи прилагођене иконице';
$string['togglenaviconsdesc'] = 'Изаберите уколико желите да користите прилагођене иконице за навигацију базирана на Font-Awesome иконицама.';
$string['toolsmenu'] = 'Мени алата';
$string['toolsmenudesc'] = 'Можете да конфигуришете линкове у оквиру менија Алати. Сваки ред се састоји од текста ставке у менију, одговарајуће URL адресе линка (опционо), кратког описа ставке (опционо), као и ознаке језика или листе ознака језика, одвојених зарезима, (опционо, за приказ тог реда искључиво корисницима наведеног језика) који су међусобно одвојени вертикалном цртом |. Можете да одредите и структуру менија користећи цртицe. На пример:
<pre>
Moodle заједница|https://moodle.org
-Moodle бесплатна подршка|https://moodle.org/support
-Moodle развој|https://moodle.org/development
--Moodle документација|https://docs.moodle.org|Moodle документација
--Moodle документација на немачком|http://docs.moodle.org/de|Документација на немачком
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenulabel'] = 'Алати';
$string['topclosefeatured'] = 'Линк ”Затвори списак истакнутих курсева”';
$string['topclosefeatureddesc'] = 'Овај текст се појављује изнад списка истакнутих курсева. Препоручује се да текст гласи ”Затвори списак курсева”.';
$string['topclosefeaturedtext'] = 'Затвори списак курсева';
$string['topichighlight'] = 'Боја за истицање теме';
$string['topichighlight_desc'] = 'Боја која се користи за истицање теме односно седмице унутар курса.';
$string['topicweekcolor'] = 'Позадина секције у тематском и седмичном формату курса';
$string['topicweekcolor_desc'] = 'У тематском и седмичном формату курса ово је боја позадине за сваку тему, односно недељу, унутар курса.';
$string['toppcourseenable'] = 'Омогући слајд-шоу истакнутих курсева';
$string['toppcourses'] = 'Слајд-шоу истакнутих курсева';
$string['toppcoursesdesc'] = 'ОГРАНИЧЕЊЕ=10 Не можете унети више од 10 ID ознака курсева. Наведите ID ознаке истакнутих курсева, раздвојене зарезом.';
$string['toppromotedcoursesheading'] = 'Слајд-шоу истакнутих курсева';
$string['toppromotedtitledefault'] = 'Истакнути курсеви';
$string['toppromotedtitledesc'] = 'Овај текст се појављује испод наслова курса у клизачу. ”Упишите се сада” је идеалан слоган.';
$string['topsearch'] = 'Претражи курсеве';
$string['topsearchbutton'] = 'Пронађи';
$string['topshowfeatured'] = 'Линк ”Прикажи списак свих курсева”';
$string['topshowfeatureddesc'] = 'Овај текст се појављује у слајд-шоу презентацији и приказује списак свих истакнутих курсева. Препоручује се да текст гласи ”Прикажи све курсеве”.';
$string['topshowfeaturedtext'] = 'Прикажи све истакнуте курсеве';
$string['toptitle'] = 'Слоган';
