<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'pt', version '3.8'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Pode pré-visualizar o teste, mas se fosse uma tentativa real não seria possível porque:';
$string['action'] = 'Ação';
$string['activityoverview'] = 'Atenção aos seus testes! Clique aqui para mais informações.';
$string['adaptive'] = 'Modo adaptável';
$string['adaptive_help'] = 'Se selecionar \'Sim\', o aluno poderá responder várias vezes à mesma pergunta, durante a mesma tentativa de resolução do teste. Por exemplo, se a primeira resposta for incorreta, o aluno poderá, de imediato, responder novamente até acertar. Porém, se a configuração "Aplicar penalizações" estiver ativa será aplicada uma penalização na nota da pergunta por cada tentativa errada.';
$string['add'] = 'Adicionar';
$string['addaquestion'] = 'uma nova pergunta';
$string['addarandomquestion'] = 'uma pergunta aleatória';
$string['addarandomquestion_help'] = 'Quando adiciona uma pergunta aleatória, esta será selecionada aleatoriamente entre as perguntas de uma determinada categoria. Isto significa que os diferentes alunos obterão uma diferente seleção de perguntas e, quando o teste permite múltiplas tentativas, cada tentativa irá conter uma diferente seleção de perguntas.';
$string['addarandomselectedquestion'] = 'Adicionar uma pergunta selecionada aleatoriamente';
$string['addasection'] = 'uma nova secção';
$string['adddescriptionlabel'] = 'Adicionar uma descrição/legenda';
$string['addingquestion'] = 'Adicionar uma pergunta';
$string['addingquestions'] = '<p>Este lado da página permite gerir a sua base de dados de perguntas. As perguntas são guardadas em categorias de forma a organizar as mesmas e podem ser usadas em qualquer teste desta disciplina, ou mesmo noutras disciplinas, caso opte por as publicar.</p>
<p>Após selecionar ou criar uma categoria, pode criar ou editar perguntas que poderá depois adicionar ao teste, no outro lado desta página.</p>';
$string['addmoreoverallfeedbacks'] = 'Adicionar mais {no} campos de feedback';
$string['addnewgroupoverride'] = 'Adicionar exceção para grupo';
$string['addnewpagesafterselected'] = 'Iniciar página após perguntas selecionadas';
$string['addnewquestionsqbank'] = 'Adicionar perguntas à categoria {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Adicionar exceção para utilizador';
$string['addpagebreak'] = 'Adicionar quebra de página';
$string['addpagehere'] = 'Inserir página';
$string['addquestion'] = 'Adicionar pergunta';
$string['addquestionfrombankatend'] = 'Adicionar no final a partir da base de dados de perguntas';
$string['addquestionfrombanktopage'] = 'Adicionar a partir da base de dados de perguntas à página {$a}';
$string['addquestions'] = 'Adicionar perguntas';
$string['addquestionstoquiz'] = 'Adicionar perguntas ao teste atual';
$string['addrandom'] = 'Adicionar {$a} perguntas aleatórias';
$string['addrandom1'] = '<< Adicionar';
$string['addrandom2'] = 'perguntas aleatórias';
$string['addrandomfromcategory'] = 'Adicionar perguntas aleatórias da categoria:';
$string['addrandomquestion'] = 'Adicionar pergunta aleatória';
$string['addrandomquestionatend'] = 'Adicionar uma pergunta aleatória no final';
$string['addrandomquestiontopage'] = 'Adicionar uma pergunta aleatória à página {$a}';
$string['addrandomquestiontoquiz'] = 'Adicionar uma pergunta aleatória ao teste \'{$a}\'';
$string['addselectedquestionstoquiz'] = 'Adicionar as perguntas selecionadas ao teste';
$string['addselectedtoquiz'] = 'Adicionar perguntas selecionadas ao teste';
$string['addtoquiz'] = 'Adicionar ao teste';
$string['affectedstudents'] = '{$a} afetados';
$string['aftereachquestion'] = 'Após adicionar cada pergunta';
$string['afternquestions'] = 'Após adicionar {$a} perguntas';
$string['age'] = 'idade';
$string['allattempts'] = 'Todas as tentativas';
$string['allinone'] = 'Ilimitado';
$string['allowreview'] = 'Permitir revisão';
$string['alreadysubmitted'] = 'É provável que já tenha submetido esta tentativa';
$string['alternativeunits'] = 'Unidades alternativas';
$string['alwaysavailable'] = 'Sempre disponível';
$string['analysisoptions'] = 'Opções da análise';
$string['analysistitle'] = 'Análise por item';
$string['answer'] = 'Resposta';
$string['answered'] = 'Respondido';
$string['answerhowmany'] = 'Uma ou mais respostas?';
$string['answers'] = 'Respostas corretas';
$string['answersingleno'] = 'São permitidas múltiplas respostas';
$string['answersingleyes'] = 'Só é permitida uma resposta';
$string['answertoolong'] = 'Resposta demasiado extensa a partir da linha {$a} (máximo 255 car.)';
$string['anytags'] = 'Sem seleção';
$string['aon'] = 'Formato AON';
$string['areyousureremoveselected'] = 'Tem a certeza de que pretende apagar todas as perguntas selecionadas?';
$string['asshownoneditscreen'] = 'Como é exibida ao editar o teste';
$string['attempt'] = 'Tentativa {$a}';
$string['attemptalreadyclosed'] = 'Esta tentativa já foi concluída.';
$string['attemptclosed'] = 'Esta tentativa ainda não foi concluída';
$string['attemptduration'] = 'Tempo gasto';
$string['attemptedon'] = 'Tentativa em';
$string['attempterror'] = 'Não possui permissão para realizar o teste porque: {$a}';
$string['attempterrorcontentchange'] = 'Esta pré visualização do teste já não existe. (Quando um teste é editado, qualquer pré-visualização em progresso é automaticamente apagada)';
$string['attempterrorcontentchangeforuser'] = 'A tentativa já não existe';
$string['attempterrorinvalid'] = 'ID de tentativa inválido';
$string['attemptfirst'] = 'Primeira tentativa';
$string['attemptincomplete'] = 'Essa tentativa (feita por {$a}) ainda não foi concluída';
$string['attemptlast'] = 'Última tentativa';
$string['attemptnumber'] = 'Tentativa';
$string['attemptquiznow'] = 'Responder ao teste agora';
$string['attemptreviewtitle'] = '{$a}: Revisão da tentativa';
$string['attemptreviewtitlepaged'] = '{$a->name}: Resumo da tentativa (página {$a->currentpage} de {$a->totalpages})';
$string['attempts'] = 'Tentativas';
$string['attempts_help'] = 'O número total de tentativas permitidas (não o número de tentativas extras).';
$string['attemptsallowed'] = 'Tentativas permitidas';
$string['attemptsdeleted'] = 'Tentativas apagadas';
$string['attemptselection'] = 'Selecione quais as tentativas a analisar por utilizador:';
$string['attemptsexist'] = 'Já não é possível adicionar ou remover perguntas.';
$string['attemptsnum'] = 'Total de tentativas: {$a}';
$string['attemptsnumthisgroup'] = 'Tentativas: {$a->total} ({$a->group} deste grupo)';
$string['attemptsnumyourgroups'] = 'Tentativas: {$a->total} ({$a->group} dos seus grupos)';
$string['attemptsonly'] = 'Mostrar apenas os alunos com tentativas';
$string['attemptstate'] = 'Estado';
$string['attemptstillinprogress'] = 'Tentativa ainda em progresso';
$string['attemptsummarytitle'] = '{$a}: Resumo da tentativa';
$string['attemptsunlimited'] = 'Tentativas ilimitadas';
$string['attempttitle'] = '{$a}:';
$string['attempttitlepaged'] = '{$a->name} (página {$a->currentpage} de {$a->totalpages})';
$string['autosaveperiod'] = 'Intervalo de tempo entre gravações automáticas';
$string['autosaveperiod_desc'] = 'As respostas dos alunos podem ser guardadas automaticamente, em intervalos de tempo definidos, durante as tentativas de realização do teste. Esta funcionalidade aumenta a carga do servidor mas, em contrapartida, reduz a possibilidade dos alunos perderem o seu trabalho. Se pretender tornar este intervalo de tempo muito mais curto, deve alterar gradualmente este valor e monitorizar a carga do servidor. Se a carga estiver demasiado alta, modifique o intervalo de tempo para um valor maior. Se configurar o intervalo de tempo para 0 a gravação automática é desligada.';
$string['back'] = 'Voltar à pré-visualização da pergunta';
$string['backtocourse'] = 'Voltar à disciplina';
$string['backtoquestionlist'] = 'Voltar à lista de perguntas';
$string['backtoquiz'] = 'Voltar à edição do teste';
$string['basicideasofquiz'] = 'Ajuda';
$string['bestgrade'] = 'Melhor nota';
$string['bothattempts'] = 'Mostrar todos os alunos';
$string['browsersecurity'] = 'Segurança do Navegador';
$string['browsersecurity_help'] = 'Se escolher a opção "Janela pop-up e segurança JavaScript":

* O teste só começa se o aluno estiver a aceder com um navegador que suporte JavaScript
* O teste surge numa janela pop-up de ecrã inteiro que se sobrepõe a todas as outras janelas, não havendo a possibilidade de aceder a outros controlos de navegação
* Os alunos são impedidos, tanto quanto possível, de utilizar funcionalidades como as de copiar e colar';
$string['calculated'] = 'Calculada';
$string['calculatedquestion'] = 'A pergunta calculada não é suportada na alínea {$a}. A pergunta será ignorada.';
$string['cannotcreatepath'] = 'O caminho não pode ser criado ({$a})';
$string['cannoteditafterattempts'] = 'Não pode adicionar nem remover perguntas porque já houve tentativas de resolução do Teste. ({$a})';
$string['cannotfindprevattempt'] = 'Não foi possível encontrar a tentativa anterior para servir de base.';
$string['cannotfindquestionregard'] = 'Não foi possível obter perguntas para reavaliar!';
$string['cannotinsert'] = 'Não é possível adicionar a pergunta';
$string['cannotinsertrandomquestion'] = 'Não foi possível adicionar uma nova pergunta aleatória!';
$string['cannotloadquestion'] = 'Não foi possível carregar as opções da pergunta';
$string['cannotloadtypeinfo'] = 'Não é possível carregar as informações específicas da pergunta';
$string['cannotopen'] = 'Não é possível abrir o ficheiro exportado ({$a})';
$string['cannotremoveallsectionslots'] = 'Selecionou todas as perguntas abaixo do cabeçalho da secção \'{$a}\'. Não é permitido remover todas as perguntas abaixo de um cabeçalho de secção.';
$string['cannotremoveslots'] = 'Não é possível remover perguntas';
$string['cannotrestore'] = 'Não foi possível restaurar as sessões das perguntas';
$string['cannotreviewopen'] = 'Não pode rever esta tentativa pois ainda está em curso.';
$string['cannotsavelayout'] = 'Não foi possível guardar a estrutura';
$string['cannotsavenumberofquestion'] = 'Não foi possível guardar o número de perguntas por página';
$string['cannotsavequestion'] = 'Não é possível guardar a lista de perguntas';
$string['cannotsetgrade'] = 'Não foi possível definir uma nova nota máxima para o teste';
$string['cannotsetsumgrades'] = 'Não foi possível definir somatórios das notas';
$string['cannotstartgradesmismatch'] = 'Não é possível iniciar uma tentativa de resolução do teste. Está configurado para uma nota de {$a->grade}, mas nenhuma das perguntas tem uma nota associada. Pode alterar isto na página de edição do teste.';
$string['cannotstartmissingquestion'] = 'Não é possível iniciar uma tentativa. As definições do teste incluem uma pergunta que não existe.';
$string['cannotstartnoquestions'] = 'Não é possível iniciar uma tentativa de resolução do teste. O teste ainda não foi configurado nem foram adicionadas perguntas';
$string['cannotwrite'] = 'Não é possível escrever no ficheiro de exportação ({$a})';
$string['canredoquestions'] = 'Permitir responder novamente durante a tentativa';
$string['canredoquestions_desc'] = 'Se ativar esta opção, depois de terminar a tentativa de responder a uma pergunta, é exibido o botão \'Tentar outra pergunta como esta\'. Permite que uma pergunta semelhante (selecionada aleatoriamente) seja tentada ou a mesma pergunta novamente, sem que seja enviada toda a tentativa do teste e iniciada outra tentativa. Esta configuração é útil para testes de treino.

Esta configuração apenas afeta as perguntas e os comportamentos das perguntas (como por exemplo: Feedback imediato ou Interativo com múltiplas tentativas) que permitem finalizar a pergunta antes de submeter a tentativa.';
$string['canredoquestions_help'] = 'Se ativar esta opção, depois de terminar a tentativa de responder a uma pergunta, é exibido o botão \'Tentar outra pergunta como esta\'. Permite que uma pergunta semelhante (selecionada aleatoriamente) seja tentada ou a mesma pergunta novamente, sem que seja enviada toda a tentativa do teste e iniciada outra tentativa. Esta configuração é útil para testes de treino.

Esta configuração apenas afeta as perguntas e os comportamentos das perguntas (como por exemplo: Feedback imediato ou Interativo com múltiplas tentativas) que permitem finalizar a pergunta antes de submeter a tentativa.';
$string['canredoquestionsyes'] = 'Sim, permitir a opção de tentar outra pergunta';
$string['caseno'] = 'Não. Ignorar maiúsculas/minúsculas';
$string['casesensitive'] = 'Respeitar maiúsculas/minúsculas';
$string['caseyes'] = 'Sim. Respeitar maiúsculas/minúsculas';
$string['categoryadded'] = 'A categoria {$a} foi adicionada';
$string['categorydeleted'] = 'A categoria {$a} foi apagada';
$string['categorynoedit'] = 'Não tem permissões de edição na categoria \'{$a}\'.';
$string['categoryupdated'] = 'A categoria foi atualizada com sucesso';
$string['close'] = 'Fechar janela';
$string['closebeforeopen'] = 'Não foi possível atualizar o teste. Definiu uma data de fecho anterior à data de abertura.';
$string['closed'] = 'Fechado';
$string['closepreview'] = 'Fechar pré-visualização';
$string['closereview'] = 'Fechar revisão';
$string['comment'] = 'Comentário';
$string['commentorgrade'] = 'Introduzir comentário ou ajustar a nota';
$string['comments'] = 'Comentários';
$string['completedon'] = 'Terminada em';
$string['completionattemptsexhausted'] = 'Ou concluir todas as tentativas disponíveis';
$string['completionattemptsexhausted_help'] = 'Assinalar como concluída quando o aluno esgotar o número máximo de tentativas.';
$string['completionattemptsexhausteddesc'] = 'Concluída se todas as tentativas disponíveis estão esgotadas';
$string['completionpass'] = 'Exigir nota de aprovação';
$string['completionpass_help'] = 'Se ativar esta opção, esta atividade é considerada concluída quando o aluno recebe uma nota de aprovação (de acordo com a nota de aprovação definida na pauta) ou superior.';
$string['completionpassdesc'] = 'O aluno deve obter uma nota de aprovação para concluir esta atividade';
$string['configadaptive'] = 'Se selecionar \'Sim\', os alunos podem responder várias vezes à mesma pergunta na mesma tentativa de resolução do teste.';
$string['configattemptsallowed'] = 'Restrição no número de tentativas de resolução do Teste que os alunos podem realizar.';
$string['configdecimaldigits'] = 'Número de casas decimais apresentadas na nota.';
$string['configdecimalplaces'] = 'Número de casas decimais apresentadas na nota do teste.';
$string['configdecimalplacesquestion'] = 'Número de casas decimais apresentadas na nota das perguntas individuais.';
$string['configdelay1'] = 'Se definir um tempo de espera, o aluno terá de aguardar para realizar uma nova tentativa do Teste depois de ter concluído a primeira tentativa.';
$string['configdelay1st2nd'] = 'Se definir um tempo de espera, o aluno terá de aguardar o intervalo de tempo especificado para poder realizar uma nova tentativa do Teste depois de ter concluído a primeira tentativa.';
$string['configdelay2'] = 'Se definir um tempo de espera, o aluno terá de aguardar para realizar uma nova tentativa do Teste depois de ter concluído a segunda tentativa ou posterior.';
$string['configdelaylater'] = 'Se definir um tempo de espera, o aluno terá de aguardar o intervalo de tempo especificado para poder realizar uma nova tentativa do Teste depois de ter concluído a segunda tentativa ou posterior.';
$string['configeachattemptbuildsonthelast'] = 'Se o teste permitir múltiplas tentativas, cada nova tentativa irá conter os resultados da tentativa anterior.';
$string['configgrademethod'] = 'Nos testes com múltiplas tentativas, qual o método a ser usado para calcular a nota final do aluno no teste.';
$string['configintro'] = 'As configurações seguintes serão usadas por predefinição sempre que criar um novo teste. Poderá também definir quais as configurações do teste que serão consideradas avançadas.';
$string['configmaximumgrade'] = 'Nota máxima predefinida do teste.';
$string['confignavmethod'] = 'Na navegação livre, as perguntas podem ser respondidas sem qualquer ordem usando a navegação. Em Sequencial, as perguntas devem ser respondidas na sequência em que são apresentadas.';
$string['confignewpageevery'] = 'Ao adicionar perguntas ao teste, são inseridas quebras de página de acordo com a opção que escolher aqui.';
$string['configoutcomesadvanced'] = 'Se ativar esta opção, os resultados da aprendizagem são considerados como configurações avançadas na edição do teste.';
$string['configpenaltyscheme'] = 'Aplicar uma penalização à pergunta por cada resposta errada, quando configurada em Modo adaptável.';
$string['configpopup'] = 'Forçar o Teste a abrir numa janela de pop-up e usar o JavaScript para restringir a possibilidade de copiar e colar, etc. durante as tentativas de resolução.';
$string['configrequirepassword'] = 'Os alunos têm de inserir uma senha para aceder ao teste.';
$string['configrequiresubnet'] = 'Os alunos só podem aceder ao teste a partir de computadores com estes endereços de rede.';
$string['configreviewoptions'] = 'Estas opções definem que informação será exibida aos utilizadores quando estes fazem a revisão do teste ou consultam os relatórios do teste.';
$string['configshowblocks'] = 'Mostrar blocos durante a resolução do teste.';
$string['configshowuserpicture'] = 'Mostrar a fotografia do utilizador durante a resolução do teste.';
$string['configshufflewithin'] = 'Se ativar esta opção, a ordem dos itens que integram cada pergunta individual será definida aleatoriamente em cada tentativa que o aluno fizer para responder ao teste, desde que esta opção também esteja ativa na configuração da pergunta.';
$string['configtimelimit'] = 'Tempo máximo para realização do Teste. 0 (zero) significa sem tempo limite.';
$string['configtimelimitsec'] = 'Tempo máximo para realização do Teste. 0 (zero) significa sem tempo limite.';
$string['configurerandomquestion'] = 'Configurar pergunta';
$string['confirmclose'] = 'Está prestes a concluir esta tentativa. Uma vez concluída, não poderá alterar as suas respostas.';
$string['confirmremovequestion'] = 'Tem a certeza de que pretende remover esta pergunta do tipo \'{$a}\'?';
$string['confirmremovesectionheading'] = 'Tem a certeza de que pretende apagar a categoria \'{$a}\'?';
$string['confirmserverdelete'] = 'Tem a certeza de que pretende apagar o servidor <b>{$a}</b> da lista?';
$string['connectionerror'] = 'Ligação à rede perdida (gravação automática falhou).

Anote quaisquer respostas inseridas nesta página nos últimos minutos e tente ligar novamente à rede.

Quando a ligação for restabelecida, as suas respostas devem ser guardadas e esta mensagem irá desaparecer.';
$string['connectionok'] = 'Conexão de rede restaurada. Pode continuar com segurança.';
$string['containercategorycreated'] = 'Esta categoria foi criada para guardar todas as categorias movidas para o nível do site, devido às razões apresentadas abaixo.';
$string['continueattemptquiz'] = 'Continuar a última tentativa';
$string['continuepreview'] = 'Continuar a última pré-visualização';
$string['copyingfrom'] = 'Criar uma cópia da pergunta \'{$a}\'';
$string['copyingquestion'] = 'A copiar a pergunta';
$string['correct'] = 'Correta';
$string['correctanswer'] = 'Resposta correta';
$string['correctanswerformula'] = 'Fórmula da resposta correta';
$string['correctansweris'] = 'Resposta correta: {$a}';
$string['correctanswerlength'] = 'Algarismos significativos';
$string['correctanswers'] = 'Respostas corretas';
$string['correctanswershows'] = 'A resposta correta é exibida';
$string['corrresp'] = 'Resposta correta';
$string['countdown'] = 'Contagem decrescente';
$string['countdownfinished'] = 'O teste está prestes a terminar. Deve submeter imediatamente as suas respostas.';
$string['countdowntenminutes'] = 'O teste vai fechar dentro de 10 minutos.';
$string['coursetestmanager'] = 'Formato Course Test Manager';
$string['createcategoryandaddrandomquestion'] = 'Criar categoria e adicionar pergunta aleatória';
$string['createfirst'] = 'Primeiro deve criar perguntas de resposta curta.';
$string['createmultiple'] = 'Adicionar várias perguntas aleatórias ao teste';
$string['createnewquestion'] = 'Criar nova pergunta';
$string['createquestionandadd'] = 'Criar nova pergunta e adicionar ao teste';
$string['custom'] = 'Formato personalizado';
$string['dataitemneed'] = 'Necessita de adicionar pelo menos um conjunto de dados para a pergunta ser válida';
$string['datasetdefinitions'] = 'Definições do conjunto de dados reutilizável para a categoria {$a}';
$string['datasetnumber'] = 'Número';
$string['daysavailable'] = 'Disponibilidade (em dias)';
$string['decimaldigits'] = 'Casas decimais na nota do teste';
$string['decimalplaces'] = 'Casas decimais na nota do teste';
$string['decimalplaces_help'] = 'Esta configuração estabelece o número de casas decimais com que as notas do teste são exibidas. Isto afeta apenas a visualização das notas e não a forma como são armazenadas nem como são feitos os cálculos, os quais são realizados com precisão total.';
$string['decimalplacesquestion'] = 'Casas decimais nas notas das perguntas';
$string['decimalplacesquestion_help'] = 'Esta configuração estabelece o número de casas decimais com que as notas das perguntas individuais são exibidas.';
$string['decimalpoints'] = 'Casas decimais';
$string['default'] = 'Predefinido';
$string['defaultgrade'] = 'Nota predefinida da pergunta';
$string['defaultinfo'] = 'A categoria predefinida para as perguntas.';
$string['delay1'] = 'Intervalo de tempo entre a primeira e a segunda tentativa';
$string['delay1st2nd'] = 'Tempo de espera entre a primeira e segunda tentativa';
$string['delay1st2nd_help'] = 'Se ativar esta opção, o aluno tem de aguardar o tempo especificado antes de tentar resolver o Teste pela segunda vez.';
$string['delay2'] = 'Tempo de espera entre tentativas posteriores';
$string['delaylater'] = 'Tempo de espera entre tentativas posteriores';
$string['delaylater_help'] = 'Se ativar esta opção, o aluno tem de aguardar o tempo especificado antes de tentar resolver o teste pela terceira vez e seguintes.';
$string['deleteattemptcheck'] = 'Tem a certeza absoluta de que pretende apagar estas tentativas?';
$string['deleteselected'] = 'Apagar as selecionadas';
$string['deletingquestionattempts'] = 'A apagar tentativas de resolução da pergunta';
$string['description'] = 'Descrição';
$string['disabled'] = 'Desativado';
$string['displayoptions'] = 'Opções de visualização';
$string['donotuseautosave'] = 'Não usar a gravação automática';
$string['download'] = 'Clique para descarregar o ficheiro de categorias exportado';
$string['downloadextra'] = '(o ficheiro é igualmente guardado, na área de ficheiros da disciplina, na pasta /backupdata/quiz folder)';
$string['dragtoafter'] = 'Depois de {$a}';
$string['dragtostart'] = 'Para o início';
$string['duplicateresponse'] = 'Esta submissão foi ignorada pois já havia dado uma resposta equivalente.';
$string['eachattemptbuildsonthelast'] = 'Cada tentativa contém resultados da anterior';
$string['eachattemptbuildsonthelast_help'] = 'Se forem permitidas múltiplas tentativas e ativar esta opção, cada nova tentativa de resolução irá conter os resultados da tentativa anterior. Esta opção permite que as respostas ao Teste sejam aperfeiçoadas em várias tentativas.';
$string['editcategories'] = 'Editar categorias';
$string['editcategory'] = 'Editar categoria';
$string['editcatquestions'] = 'Editar perguntas da categoria';
$string['editingquestion'] = 'A editar uma pergunta';
$string['editingquiz'] = 'Editar teste';
$string['editingquiz_help'] = 'Quando cria um teste, os principais conceitos são:

* O teste, que contém perguntas em uma ou mais páginas
* A base de dados de perguntas, que guarda cópias de todas as perguntas, organizadas em categorias
* As perguntas aleatórias, que permitem que os testes dos alunos sejam diferentes a cada nova tentativa de resolução';
$string['editingquiz_link'] = 'mod/testes/editar';
$string['editingquizx'] = 'Editar teste: {$a}';
$string['editmaxmark'] = 'Editar nota máxima';
$string['editoverride'] = 'Editar exceção';
$string['editqcats'] = 'Editar categorias';
$string['editquestion'] = 'Editar pergunta';
$string['editquestions'] = 'Editar perguntas';
$string['editquiz'] = 'Editar teste';
$string['editquizquestions'] = 'Editar perguntas do teste';
$string['emailconfirmbody'] = 'Caro(a) {$a->username},

Obrigado por ter respondido ao teste \'{$a->quizname}\' na disciplina \'{$a->coursename}\' em {$a->submissiontime}.

Este e-mail serve para confirmar que as suas respostas foram guardadas.

Pode consultar o teste em {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Obrigado por submeter as suas respostas ao teste \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Confirmação de submissão do teste: {$a->quizname}';
$string['emailnotifybody'] = 'Caro(a) {$a->username},

{$a->studentname} completou o teste \'{$a->quizname}\' ({$a->quizurl}) na disciplina \'{$a->coursename}\'.

Pode rever esta tentativa em {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} completou {$a->quizname}. Ver {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} completou o teste {$a->quizname}';
$string['emailoverduebody'] = 'Caro(a) {$a->studentname},

Iniciou uma tentativa no teste \'{$a->quizname}\' na disciplina \'{$a->coursename}\' mas não a submeteu. Deve fazê-lo até {$a->attemptduedate}.

Se pretender submeter a sua tentativa agora, vá a {$a->attemptsummaryurl} e clique no botão de submeter.
Tem de submeter até {$a->attemptgraceend} ou a sua tentativa não será avaliada.';
$string['emailoverduesmall'] = 'Não submeteu a sua tentativa de resolução do teste \'{$a->quizname}\'. Vá a {$a->attemptsummaryurl} até {$a->attemptgraceend} se pretender submetê-la para avaliação.';
$string['emailoverduesubject'] = 'Tempo limite ultrapassado: {$a->quizname}';
$string['empty'] = 'Vazio';
$string['enabled'] = 'Ativado';
$string['endtest'] = 'Terminar tentativa';
$string['erroraccessingreport'] = 'Não pode consultar este relatório';
$string['errorinquestion'] = 'Erro na pergunta';
$string['errormissingquestion'] = 'Erro: A pergunta com ID {$a} está em falta no sistema.';
$string['errornotnumbers'] = 'Erro - as respostas têm de ser numéricas';
$string['errorunexpectedevent'] = 'Foi encontrado um código de evento inesperado {$a->event} para a pergunta {$a->questionid} na tentativa {$a->attemptid}.';
$string['essay'] = 'Desenvolvimento';
$string['essayquestions'] = 'Perguntas';
$string['eventattemptdeleted'] = 'Tentativa de Teste eliminada';
$string['eventattemptpreviewstarted'] = 'Pré-visualização da tentativa de Teste iniciada';
$string['eventattemptreviewed'] = 'Tentativa de Teste revista';
$string['eventattemptsummaryviewed'] = 'Sumário da tentativa de Teste visualizado';
$string['eventattemptviewed'] = 'Tentativa de Teste visualizada';
$string['eventeditpageviewed'] = 'Página de edição de Teste visualizada';
$string['eventoverridecreated'] = 'Exceção para Teste criada';
$string['eventoverridedeleted'] = 'Exceção para Teste eliminada';
$string['eventoverrideupdated'] = 'Exceção para Teste atualizada';
$string['eventquestionmanuallygraded'] = 'Pergunta avaliada manualmente';
$string['eventquizattemptabandoned'] = 'Tentativa de Teste abandonada';
$string['eventquizattemptregraded'] = 'Tentativa de resposta ao teste reavaliada';
$string['eventquizattemptstarted'] = 'Tentativa de Teste iniciada';
$string['eventquizattemptsubmitted'] = 'Tentativa de Teste submetida';
$string['eventquizattempttimelimitexceeded'] = 'Tempo limite da tentativa de Teste excedido';
$string['eventreportviewed'] = 'Relatório de Teste visualizado';
$string['everynquestions'] = 'A cada {$a} perguntas';
$string['everyquestion'] = 'A cada nova pergunta inserida';
$string['everythingon'] = 'Tudo em';
$string['existingcategory'] = 'Categoria existente';
$string['exportcategory'] = 'exportar categoria';
$string['exporterror'] = 'Ocorreu um erro durante o processo de exportação';
$string['exportingquestions'] = 'As perguntas estão a ser exportadas para um ficheiro';
$string['exportname'] = 'Nome do ficheiro';
$string['exportquestions'] = 'Exportar perguntas para um ficheiro';
$string['extraattemptrestrictions'] = 'Outras restrições na realização do teste';
$string['false'] = 'Falso';
$string['feedback'] = 'Feedback';
$string['feedbackerrorboundaryformat'] = 'O valor do limite de avaliação para o Feedback deve ser uma percentagem ou um número. O valor que introduziu no limite {$a} não foi reconhecido.';
$string['feedbackerrorboundaryoutofrange'] = 'O valor do limite de avaliação para o Feedback deve estar entre 0% e 100%. O valor que introduziu no limite {$a} encontra-se fora deste intervalo.';
$string['feedbackerrorjunkinboundary'] = 'Deve preencher os limites de avaliação sem deixar intervalos em branco.';
$string['feedbackerrorjunkinfeedback'] = 'Deve preencher os campos de Feedback sem deixar intervalos em branco.';
$string['feedbackerrororder'] = 'Os limites de avaliação devem ser indicados por ordem decrescente. O valor que introduziu no limite de avaliação {$a} não respeita a ordem.';
$string['file'] = 'Ficheiro';
$string['fileformat'] = 'Formato de ficheiro';
$string['fillcorrect'] = 'Preencher com o correto';
$string['filloutnumericalanswer'] = 'Indique pelo menos uma resposta possível e a sua margem de erro. A primeira resposta possível que coincidir com a do aluno será usada para determinar a nota e o feedback. Se escrever algum feedback sem resposta no último campo, este será apresentado às respostas que não se enquadrem em nenhuma das anteriores.';
$string['filloutoneanswer'] = 'Deve preencher pelo menos uma resposta possível. As respostas em branco não serão consideradas. O \'*\' pode ser usado como um caratere universal para representar qualquer sequência de caracteres. A primeira resposta possível que coincidir com a do aluno será usada para determinar a nota e o feedback.';
$string['filloutthreequestions'] = 'Deve preencher pelo menos três perguntas com respostas correspondentes. Pode acrescentar respostas extra erradas, introduzindo a resposta e deixando a pergunta em branco. Os campos em que tanto a pergunta como a resposta se encontrem em branco serão ignorados.';
$string['fillouttwochoices'] = 'Deve preencher pelo menos duas opções. Opções em branco serão ignoradas.';
$string['finishattemptdots'] = 'Terminar tentativa';
$string['finishreview'] = 'Terminar revisão';
$string['forceregeneration'] = 'forçar regeneração';
$string['formatnotfound'] = 'não foi encontrado o formato {$a} de importação/exportação';
$string['formulaerror'] = 'Fórmula com erros!';
$string['fractionsaddwrong'] = 'As notas positivas que selecionou não somam 100%.<br /> A soma é de {$a}%.<br /> Pretende voltar atrás e corrigir esta pergunta?';
$string['fractionsnomax'] = 'Uma das respostas deve ter a nota de 100% para que seja possível obter a pontuação máxima nesta pergunta.<br /> Pretende voltar atrás e corrigir esta pergunta?';
$string['fromfile'] = 'do ficheiro:';
$string['functiondisabledbysecuremode'] = 'Essa funcionalidade está de momento desativada';
$string['generalfeedback'] = 'Feedback geral';
$string['generalfeedback_help'] = 'O feedback geral consiste num texto que é exibido quando é submetida uma resposta. Ao contrário do feedback específico, que depende da resposta do aluno, o feedback geral é sempre o mesmo.';
$string['graceperiod'] = 'Tempo extra';
$string['graceperiod_desc'] = 'Tempo extra permitido se a opção \'Quando o tempo termina\' estiver configurada como \'É permitido um tempo extra para submeter, mas sem alterar respostas\'.';
$string['graceperiod_help'] = 'Tempo extra permitido se a opção \'Quando o tempo termina\' estiver configurada como \'É permitido um tempo extra para submeter, mas sem alterar respostas\'.';
$string['graceperiodmin'] = 'Tempo extra para processamento';
$string['graceperiodmin_desc'] = 'Existe um potencial problema quando o limite de tempo é atingido e o teste termina. Pretende-se que os alunos aproveitem o tempo limite até ao último segundo - com a ajuda do cronómetro que submete automaticamente o Teste quando o tempo se esgota. Porém, o servidor pode ficar sobrecarregado naquele instante e levar algum tempo a processar as respostas submetidas. Por esta razão, esta configuração permite que, após o tempo terminar, sejam aceites as submissões durante o intervalo de tempo aqui definido para que deste modo os alunos não sejam penalizados pela lentidão do servidor. Contudo, o aluno pode fazer batota e usufruir deste tempo extra para continuar a responder ao teste. Tem que tomar esta decisão com base na confiança que tem no desempenho do seu servidor durante a realização dos testes.';
$string['graceperiodtoosmall'] = 'O tempo extra deve ser superior a {$a}.';
$string['grade'] = 'Nota';
$string['gradeall'] = 'Avaliar tudo';
$string['gradeaverage'] = 'Nota média';
$string['gradeboundary'] = 'Limite de avaliação';
$string['gradeessays'] = 'Avaliar perguntas de desenvolvimento';
$string['gradehighest'] = 'Nota mais alta';
$string['grademethod'] = 'Método de avaliação';
$string['grademethod_help'] = 'Quando o teste é configurado para múltiplas tentativas de resolução, a nota final é calculada segundo um dos seguintes métodos:

* Nota mais alta de todas as tentativas
* Nota média de todas as tentativas
* Primeira tentativa (as outras tentativas são ignoradas)
* Última tentativa (as outras tentativas são ignoradas)';
$string['gradesdeleted'] = 'As notas do teste foram apagadas';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}';
$string['gradetopassmustbeset'] = 'A nota de aprovação não pode ser zero uma vez que na verificação da conclusão do teste está definido que os alunos devem ter nota de aprovação para concluir a atividade. Tem definir um valor diferente de zero.';
$string['gradetopassnotset'] = 'Este teste ainda não tem definida uma nota de aprovação. Pode ser definida na secção Avaliação das configurações do teste.';
$string['gradingdetails'] = 'Notas para esta submissão: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Com as penalizações anteriores fica com <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Esta submissão foi penalizada com {$a}.';
$string['gradingdetailszeropenalty'] = 'Não sofreu penalizações com esta submissão.';
$string['gradingmethod'] = 'Método de avaliação: {$a}';
$string['groupoverrides'] = 'Exceções para grupos';
$string['groupoverridesdeleted'] = 'Exceções para grupos apagadas';
$string['groupsnone'] = 'Sem grupos a que possa aceder.';
$string['guestsno'] = 'Os visitantes não podem ver nem responder a testes.';
$string['hidebreaks'] = 'Ocultar quebras de páginas';
$string['hidereordertool'] = 'Ocultar a ferramenta de reordenação';
$string['history'] = 'Histórico de respostas:';
$string['howquestionsbehave_desc'] = 'Configuração predefinida para o comportamento das perguntas num Teste.';
$string['imagedisplay'] = 'Imagem a exibir';
$string['import_help'] = 'Esta função permite importar perguntas a partir de ficheiros de texto externos.

Se o ficheiro contêm caracteres não-ascii, deve usar a codificação UTF-8. Tenha especial atenção aos ficheiros criados com o Microsoft Office, pois geralmente usam codificações especiais que não serão interpretados corretamente.

Os formatos de importação e exportação disponíveis correspondem a  módulos instalados. Podem existir outros formatos opcionais na base de dados de módulos do Moodle.';
$string['import_link'] = 'pergunta/importar';
$string['importcategory'] = 'importar categoria';
$string['importerror'] = 'Ocorreu um erro durante o processo de importação';
$string['importfilearea'] = 'Importar de ficheiro já existente nos ficheiros da disciplina...';
$string['importfileupload'] = 'Importar de ficheiro a carregar...';
$string['importfromthisfile'] = 'Importar deste ficheiro';
$string['importingquestions'] = 'A importar {$a} perguntas do ficheiro';
$string['importmax10error'] = 'Existe um erro na pergunta. Não pode ter mais do que dez respostas.';
$string['importmaxerror'] = 'Existe um erro na pergunta. Contém demasiadas respostas.';
$string['importquestions'] = 'Importar perguntas de um ficheiro';
$string['inactiveoverridehelp'] = '* Essa substituição está inativa porque o acesso do utilizador à atividade é restrito. Pode ser devido ao grupo ou atribuições de papel, outras restrições de acesso ou atividade oculta.';
$string['incorrect'] = 'Incorreta';
$string['indicator:cognitivedepth'] = 'Compreensão do Teste';
$string['indicator:cognitivedepth_help'] = 'Este indicador é baseado na capacidade cognitiva alcançada pelo aluno na atividade Teste.';
$string['indicator:cognitivedepthdef'] = 'Compreensão do Teste';
$string['indicator:cognitivedepthdef_help'] = 'O participante alcançou esta percentagem da capacidade cognitiva oferecida pelas atividades Teste durante esse intervalo de análise (Níveis = Não visualizado, Visualizado, Submetido, Visualizado feedback, Comentários ao feedback, Voltar a submeter após visualizar feedback)';
$string['indicator:socialbreadth'] = 'Socialização do Teste';
$string['indicator:socialbreadth_help'] = 'Este indicador é baseado na extensão social alcançada pelo aluno na atividade Teste.';
$string['indicator:socialbreadthdef'] = 'Socialização do Teste';
$string['indicator:socialbreadthdef_help'] = 'O participante alcançou esta percentagem do relacionamento social oferecido pelas atividades Teste durante esse intervalo de análise (Níveis = Sem participação, Participante individual, Participante com outros)';
$string['indivresp'] = 'Respostas a cada item';
$string['info'] = 'Informação';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Número inicial de campos de feedback global';
$string['initialnumfeedbacks_desc'] = 'Ao criar um novo teste, serão criados o número de campos em branco aqui especificado para o feedback. Depois de criado o teste, o formulário mostra o número de campos obrigatórios para o número de campos de feedback do teste. O valor deve ser pelo menos 1.';
$string['inprogress'] = 'Em progresso';
$string['introduction'] = 'Descrição';
$string['invalidattemptid'] = 'Não existe nenhuma tentativa com este ID';
$string['invalidcategory'] = 'O ID da categoria não é válido';
$string['invalidoverrideid'] = 'O ID da exceção não é válido';
$string['invalidquestionid'] = 'O ID da pergunta não é válido';
$string['invalidquizid'] = 'O ID do teste não é válido';
$string['invalidrandomslot'] = 'ID inválido da vaga de perguntas aleatórias.';
$string['invalidsource'] = 'A origem não é aceite como válida.';
$string['invalidsourcetype'] = 'O tipo de origem não é válido';
$string['invalidstateid'] = 'O ID do estado não é válido';
$string['lastanswer'] = 'A sua última resposta foi';
$string['layout'] = 'Estrutura';
$string['layoutasshown'] = 'Pré-visualização da estrutura';
$string['layoutasshownwithpages'] = 'Pré-visualização da estrutura. <small>(Uma nova página é inserida automaticamente a cada {$a} perguntas inseridas.)</small>';
$string['layoutshuffledandpaged'] = 'Perguntas baralhadas aleatoriamente com {$a} perguntas exibidas por página';
$string['layoutshuffledsinglepage'] = 'Perguntas baralhadas aleatoriamente, apenas com uma pergunta exibida por página';
$string['legacyquizaccessrulescron'] = 'Regras de acesso ao teste do Cron legado';
$string['legacyquizreportscron'] = 'Relatórios do teste do Cron legado';
$string['link'] = 'Hiperligação';
$string['listitems'] = 'Listagem de itens no teste';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Não foi possível carregar as perguntas: {$a}';
$string['makecopy'] = 'Guardar como nova pergunta';
$string['managetypes'] = 'Gerir tipos de perguntas e servidores';
$string['manualgradequestion'] = 'Avaliação manual da pergunta \'{$a->question}\' em \'{$a->quiz}\' de {$a->user}';
$string['manualgrading'] = 'A avaliar';
$string['mark'] = 'Submeter';
$string['markall'] = 'Submeter página';
$string['marks'] = 'Nota';
$string['marks_help'] = 'A nota obtida em cada pergunta e a nota global da tentativa.';
$string['match'] = 'Correspondência';
$string['matchanswer'] = 'Resposta correspondente';
$string['matchanswerno'] = 'Resposta correspondente {$a}';
$string['max'] = 'Máx.';
$string['maxmark'] = 'Nota máxima';
$string['messageprovider:attempt_overdue'] = 'Avisar quando as tentativas do teste ultrapassarem o tempo limite';
$string['messageprovider:confirmation'] = 'Confirmação das suas submissões nos testes';
$string['messageprovider:submission'] = 'Notificações das submissões do teste';
$string['min'] = 'Mín.';
$string['minutes'] = 'Minutos';
$string['missingcorrectanswer'] = 'Tem de definir a resposta correta';
$string['missingitemtypename'] = 'O nome está em falta';
$string['missingquestion'] = 'Esta pergunta já não existe';
$string['modulename'] = 'Teste';
$string['modulename_help'] = 'A atividade Teste permite aos professores criar testes com diversos tipos de perguntas, tais como, escolha múltipla, verdadeiro/falso, correspondência, de resposta curta e calculadas.

O professor pode configurar o teste para múltiplas tentativas, por forma a ser realizado várias vezes e com perguntas aleatórias. Também pode configurar um limite de tempo para a sua realização.

Cada tentativa é automaticamente avaliada e registada na pauta da disciplina. O professor pode escolher se pretende dar feedback e/ou mostrar as respostas corretas ao aluno durante a tentativa, apenas após terminar a tentativa ou após o Teste fechar.

O professor pode escolher entre uma variedade de comportamentos das perguntas, incluindo o modo adaptável (facultando ajudas antes do aluno responder de novo) e feedback imediato baseado no grau de certeza (onde o aluno indica qual o seu grau de certeza naquela resposta).

Os Testes podem ser utilizados:

* Como mini-testes de compreensão de um tema;
* Como treino para um exame com perguntas de exames de anos anteriores;
* Para dar feedback sobre o desempenho do aluno;
* Para autoavaliação.';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Testes';
$string['moveselectedonpage'] = 'Mover as perguntas selecionadas para a página: {$a}';
$string['multichoice'] = 'Escolha múltipla';
$string['multipleanswers'] = 'Escolha pelo menos uma resposta';
$string['mustbesubmittedby'] = 'Esta tentativa deve ser submetida até {$a}.';
$string['name'] = 'Nome';
$string['navigatenext'] = 'Página seguinte';
$string['navigateprevious'] = 'Página anterior';
$string['navmethod'] = 'Método de navegação';
$string['navmethod_free'] = 'Livre';
$string['navmethod_help'] = 'Quando a navegação sequencial está ativa o aluno segue pelo teste, sem possibilidade de retornar às páginas anteriores, nem saltar nenhuma.';
$string['navmethod_seq'] = 'Sequencial';
$string['navnojswarning'] = 'Aviso: estas hiperligações não guardarão as suas respostas. Use o botão Seguinte no final da página.';
$string['neverallononepage'] = 'Nunca, todas as perguntas numa só página';
$string['newattemptfail'] = 'Erro: Não foi possível começar uma nova tentativa de resolução do teste';
$string['newcategory'] = 'Nova categoria';
$string['newpage'] = 'Inserir nova página';
$string['newpage_help'] = 'Para testes com muitas perguntas, pode separar o teste em várias páginas configurando um número máximo de perguntas a exibir por página. Quando adiciona as perguntas, as quebras de página são inseridas automaticamente de acordo com esta configuração. As quebras de página poderão depois ser movidas manualmente na página de edição do teste.';
$string['newpageevery'] = 'Inserir nova página automaticamente';
$string['newsectionheading'] = 'Nova secção';
$string['noanswers'] = 'Não foi selecionada nenhuma resposta!';
$string['noattempts'] = 'Ainda não houve tentativas de resolução deste teste';
$string['noattemptsfound'] = 'Não foram encontradas tentativas.';
$string['noattemptstoshow'] = 'Não existem tentativas para mostrar';
$string['nocategory'] = 'Incorreto ou não foi especificada uma categoria';
$string['noclose'] = 'Sem data de fim';
$string['nocommentsyet'] = 'Ainda sem comentários.';
$string['noconnection'] = 'Atualmente não existe ligação a nenhum web service que possa processar esta pergunta. Por favor, contacte o administrador';
$string['nodataset'] = 'nada - não é uma variável';
$string['nodatasubmitted'] = 'Não foi submetido nada.';
$string['noessayquestionsfound'] = 'Não foram encontradas perguntas avaliadas manualmente';
$string['nogradewarning'] = 'Este teste não tem avaliação e, por isso, não é possível configurar o feedback global consoante a nota obtida.';
$string['nomoreattempts'] = 'Não são permitidas mais tentativas';
$string['none'] = 'Nenhuma';
$string['noopen'] = 'Sem data de abertura';
$string['nooverridedata'] = 'Deve inserir uma exceção em pelo menos uma opção de configuração do teste';
$string['nopossibledatasets'] = 'Não há conjuntos de dados possíveis';
$string['noquestionintext'] = 'O texto da pergunta não contém nenhuma pergunta incorporada';
$string['noquestions'] = 'Ainda não foram adicionadas perguntas ao teste';
$string['noquestionsfound'] = 'Não foi encontrada nenhuma pergunta';
$string['noquestionsinquiz'] = 'Não existem perguntas neste teste';
$string['noquestionsnotinuse'] = 'A pergunta aleatória não está em uso, pois a sua categoria encontra-se vazia.';
$string['noquestionsonpage'] = 'Página em branco';
$string['noresponse'] = 'Sem resposta';
$string['noreview'] = 'Não pode rever este teste';
$string['noreviewattempt'] = 'Não pode rever esta tentativa';
$string['noreviewshort'] = 'Não é permitido';
$string['noreviewuntil'] = 'Não pode rever este teste até {$a}';
$string['noreviewuntilshort'] = 'Disponível {$a}';
$string['noscript'] = 'O JavaScript tem de estar ativo para poder continuar!';
$string['notavailabletostudents'] = 'Nota: Este teste não está atualmente disponível para os alunos';
$string['notenoughrandomquestions'] = 'Não existem perguntas suficientes na categoria {$a->category} para criar a pergunta {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Não foram definidas subperguntas suficientes!<br /> Pretende voltar atrás e corrigir a pergunta?';
$string['notimedependentitems'] = 'O módulo de testes atualmente não suporta itens dependentes do tempo. Uma alternativa consiste em definir um tempo limite para todo o teste. Quer selecionar outro item (ou usar o item atual de qualquer forma)?';
$string['notyetgraded'] = 'Por avaliar';
$string['notyetviewed'] = 'Não visto';
$string['notyourattempt'] = 'Não é a sua tentativa!';
$string['noview'] = 'O utilizador autenticado não tem permissões para ver o teste';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} realizou {$a->attemptnum} tentativas';
$string['numattemptsmade'] = '{$a} tentativas de resolução deste teste';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numérica';
$string['numquestionsx'] = 'Perguntas: {$a}';
$string['oneminute'] = '1 minuto';
$string['onlyteachersexport'] = 'Apenas os professores podem exportar perguntas';
$string['onlyteachersimport'] = 'Apenas os professores com permissões de edição podem importar perguntas';
$string['onthispage'] = 'Nesta página';
$string['open'] = 'Não respondido';
$string['openafterclose'] = 'Não foi possível atualizar o teste. Especificou uma data de abertura posterior à data de fecho.';
$string['openclosedatesupdated'] = 'Foram atualizadas as datas de abertura e fecho do teste';
$string['optional'] = 'opcional';
$string['orderandpaging'] = 'Ordem e paginação';
$string['orderandpaging_help'] = 'Os números 10, 20, 30, ... em cada pergunta indicam a sua ordem. Ao apresentar intervalos de 10 é possível inserir perguntas no meio. Para  reordenar as perguntas, altere a numeração e clique no botão "Reordenar perguntas".

Para adicionar quebras de páginas após uma pergunta em particular, selecione as perguntas e clique no botão "Iniciar página após perguntas selecionadas".

Para organizar as perguntas num diferente número de páginas, clique no botão de Repaginação e insira o número pretendido de perguntas por página.';
$string['orderingquiz'] = 'Ordenar e Paginar';
$string['orderingquizx'] = 'Ordenação e paginação: {$a}';
$string['outcomesadvanced'] = 'Resultados da aprendizagem são configurações avançadas';
$string['outof'] = '{$a->grade} num máximo de {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} num máximo de {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback global';
$string['overallfeedback_help'] = 'Texto que surge após o aluno concluir a tentativa de resolução do teste. Ao especificar limites (como percentagem ou valor), o texto exibido ao aluno dependerá da nota obtida.';
$string['overdue'] = 'Atingiu o tempo limite';
$string['overduehandling'] = 'Quando o tempo termina';
$string['overduehandling_desc'] = 'O que deve acontecer por predefinição se o aluno não submeter a tentativa antes do tempo terminar.';
$string['overduehandling_help'] = 'Esta opção determina o que acontece se o aluno não submeter a sua tentativa antes do tempo terminar. Se o aluno estiver a responder ao teste naquele momento, então o cronómetro submeterá automaticamente o teste, mas se o aluno não estiver ativo ou autenticado, então esta configuração determina o que acontece.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'As tentativas devem ser submetidas antes do tempo terminar, ou não serão consideradas';
$string['overduehandlingautosubmit'] = 'As tentativas em aberto são submetidas automaticamente';
$string['overduehandlinggraceperiod'] = 'É permitido um tempo extra para submeter, mas sem alterar respostas';
$string['overduemustbesubmittedby'] = 'Esta tentativa atingiu o tempo limite e já devia ter sido submetida. Se pretende ter avaliação nesta tentativa, deve submetê-la até {$a}. Se não submeter até lá, não irá obter nota para esta tentativa.';
$string['override'] = 'Exceção';
$string['overridedeletegroupsure'] = 'Tem a certeza de que pretende apagar a exceção para o grupo {$a}?';
$string['overridedeleteusersure'] = 'Tem a certeza de que pretende apagar a exceção para o utilizador {$a}?';
$string['overridegroup'] = 'Exceção para grupo';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Exceções';
$string['overrideuser'] = 'Exceção para utilizador';
$string['overrideusereventname'] = '{$a->quiz} - Exceção';
$string['page-mod-quiz-attempt'] = 'Página de tentativa de Teste';
$string['page-mod-quiz-edit'] = 'Editar página do teste';
$string['page-mod-quiz-report'] = 'Qualquer página de relatório do Teste';
$string['page-mod-quiz-review'] = 'Rever página de tentativa de Teste';
$string['page-mod-quiz-summary'] = 'Página de sumário da tentativa de Teste';
$string['page-mod-quiz-view'] = 'Página de informação do Teste';
$string['page-mod-quiz-x'] = 'Qualquer página da atividade Teste';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Número de tentativas por página';
$string['parent'] = 'Ascendente';
$string['parentcategory'] = 'Categoria ascendente';
$string['parsingquestions'] = 'A ler perguntas do ficheiro importado.';
$string['partiallycorrect'] = 'Parcialmente correta';
$string['penalty'] = 'Penalização';
$string['penaltyscheme'] = 'Aplicar penalizações';
$string['penaltyscheme_help'] = 'Se ativar esta opção, por cada resposta errada é subtraída uma penalização da nota final da pergunta. O valor da penalização é definido nas configurações da pergunta. Esta configuração só é aplicável se o comportamento das perguntas é Modo adaptável.';
$string['percentcorrect'] = 'Percentagem correta';
$string['pleaseclose'] = 'O seu pedido foi processado. Pode fechar a janela';
$string['pluginadministration'] = 'Administração do Teste';
$string['pluginname'] = 'Teste';
$string['popup'] = 'Mostrar o teste numa janela "segura"';
$string['popupblockerwarning'] = 'Esta secção do Teste está em modo seguro. Isto significa que é necessário abrir o teste numa janela segura. Por favor, desligue o bloqueador de janelas pop-up.';
$string['popupnotice'] = 'Os alunos resolverão este teste numa janela segura';
$string['preprocesserror'] = 'Ocorreu um erro durante o pré-processamento!';
$string['preview'] = 'Pré-visualização';
$string['previewquestion'] = 'Pré-visualizar pergunta';
$string['previewquiz'] = 'Pré-visualizar {$a}';
$string['previewquiznow'] = 'Pré-visualizar o teste';
$string['previous'] = 'Estado anterior';
$string['privacy:metadata:core_question'] = 'A atividade Teste armazena informação sobre a utilização da pergunta no subsistema \'core_question\'';
$string['privacy:metadata:quiz'] = 'A atividade Teste utiliza relatórios do teste.';
$string['privacy:metadata:quiz_attempts'] = 'Detalhes sobre cada tentativa num teste.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'O númeor da tentativa.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'A página atual em que o utilizador está.';
$string['privacy:metadata:quiz_attempts:preview'] = 'Se isto é uma visualização do teste.';
$string['privacy:metadata:quiz_attempts:state'] = 'O estado atual da tentativa';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'A soma das notas na tentativa';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = '.A hora em que o estado foi confirmado.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'A hora em que a tentativa foi concluída.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'A hora a que a tentativa foi atualizada.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'A hora a que a tentativa foi atualizada offline.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'A hora a que a tentativa iniciou.';
$string['privacy:metadata:quiz_grades'] = 'Detalhes da nota global deste teste.';
$string['privacy:metadata:quiz_grades:grade'] = 'Nota global deste teste';
$string['privacy:metadata:quiz_grades:quiz'] = 'O teste que foi avaliado.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'A hora em que a avaliação foi modificada.';
$string['privacy:metadata:quiz_grades:userid'] = 'O utilizador que foi avaliado';
$string['privacy:metadata:quiz_overrides'] = 'Detalhes sobre substituições para este Teste';
$string['privacy:metadata:quiz_overrides:quiz'] = 'O Teste com informação substituída';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'O nova data de fecho do teste';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'A nova data de abertura do teste';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'O novo tempo de início para o teste';
$string['privacy:metadata:quiz_overrides:userid'] = 'O utilizador a ser substituído';
$string['privacy:metadata:quizaccess'] = 'A atividade Teste utiliza as regras de acesso ao teste.';
$string['publish'] = 'Publicar';
$string['publishedit'] = 'Deve ter permissões de edição na disciplina correspondente para adicionar ou editar perguntas nesta categoria';
$string['qbrief'] = 'P. {$a}';
$string['qname'] = 'nome';
$string['qti'] = 'Formato IMS QTI';
$string['qtypename'] = 'tipo, nome';
$string['question'] = 'Pergunta';
$string['questionbank'] = 'da base de dados de perguntas';
$string['questionbankmanagement'] = 'Gestão da base de dados de perguntas';
$string['questionbehaviour'] = 'Comportamento das perguntas';
$string['questioncats'] = 'Categorias de perguntas';
$string['questiondeleted'] = 'Esta pergunta foi apagada. Por favor, contacte o professor da disciplina.';
$string['questiondependencyadd'] = 'Não existem restrições para responder à pergunta {$a->thisq} • Clique para alterar';
$string['questiondependencyfree'] = 'Sem restrições para esta pergunta';
$string['questiondependencyremove'] = 'A pergunta {$a->thisq} não pode ser respondida até que a pergunta anterior {$a->previousq} esteja concluída • Clique para alterar';
$string['questiondependsonprevious'] = 'Esta pergunta não pode ser respondida até que a pergunta anterior esteja concluída.';
$string['questioninuse'] = 'A pergunta {$a->questionname} está atualmente a ser utilizada em: <br />{$a->quiznames}.<br />A pergunta não será apagada destes testes mas apenas da categoria.';
$string['questionmissing'] = 'Falta a pergunta para esta sessão';
$string['questionname'] = 'Nome da pergunta';
$string['questionnonav'] = '<span class="accesshide">Pergunta </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informação </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Pergunta {$a} não foi carregada da base de dados';
$string['questionorder'] = 'Ordem das perguntas';
$string['questionposition'] = 'Nova posição na ordem para a pergunta {$a}';
$string['questions'] = 'Perguntas';
$string['questionsetpreview'] = 'Pré-visualização do conjunto de perguntas';
$string['questionsinclhidden'] = 'Perguntas (incluindo ocultas)';
$string['questionsinthisquiz'] = 'Perguntas neste teste';
$string['questionsmatchingfilter'] = 'Perguntas que correspondem a este filtro: {$a}';
$string['questionsperpage'] = 'Perguntas por página';
$string['questionsperpageselected'] = 'O número de perguntas por página foi configurado para a paginação ser fixa. Como tal, os controlos de paginação foram desativados. Pode alterar esta configuração em {$a}.';
$string['questionsperpagex'] = 'Perguntas por página: {$a}';
$string['questiontext'] = 'Texto da pergunta';
$string['questiontextisempty'] = '[Texto da pergunta vazio]';
$string['questiontype'] = 'Tipo de pergunta {$a}';
$string['questiontypesetupoptions'] = 'Opções de configuração para tipos de perguntas:';
$string['quiz:addinstance'] = 'Adicionar novo teste';
$string['quiz:attempt'] = 'Responder a testes';
$string['quiz:deleteattempts'] = 'Apagar tentativas';
$string['quiz:emailconfirmsubmission'] = 'Receber e-mail de confirmação quando submeter';
$string['quiz:emailnotifysubmission'] = 'Receber e-mail de confirmação das submissões';
$string['quiz:emailwarnoverdue'] = 'Obter uma notificação quando uma tentativa atinge o tempo limite e tem de ser submetida.';
$string['quiz:grade'] = 'Avaliar testes manualmente';
$string['quiz:ignoretimelimits'] = 'Ignorar tempo limite do teste';
$string['quiz:manage'] = 'Gerir testes';
$string['quiz:manageoverrides'] = 'Gerir exceções do teste';
$string['quiz:preview'] = 'Pré-visualizar testes';
$string['quiz:regrade'] = 'Reavaliar tentativas';
$string['quiz:reviewmyattempts'] = 'Rever as próprias tentativas';
$string['quiz:view'] = 'Ver informações do teste';
$string['quiz:viewreports'] = 'Ver relatórios do teste';
$string['quizavailable'] = 'O teste está disponível até: {$a}';
$string['quizclose'] = 'Fechar o teste em';
$string['quizclosed'] = 'O teste fechou {$a}';
$string['quizcloses'] = 'Teste fecha';
$string['quizcloseson'] = 'O teste fecha {$a}';
$string['quizeventcloses'] = 'Fecha \'{$a}\'';
$string['quizeventopens'] = 'Inicia \'{$a}\'';
$string['quizisclosed'] = 'Este teste está fechado';
$string['quizisclosedwillopen'] = 'Teste fechado (abre {$a})';
$string['quizisopen'] = 'Este teste está aberto';
$string['quizisopenwillclose'] = 'Teste aberto (fecha {$a})';
$string['quiznavigation'] = 'Navegação do teste';
$string['quizopen'] = 'Abrir o teste em';
$string['quizopenclose'] = 'Datas de abertura e fecho';
$string['quizopenclose_help'] = 'Os alunos só podem iniciar a(s) sua(s) tentativa(s) após a data/hora de abertura e devem terminá-las até à data/hora de fecho.';
$string['quizopened'] = 'Este teste está aberto.';
$string['quizopenedon'] = 'Este teste abriu {$a}';
$string['quizopens'] = 'Abertura do teste';
$string['quizopenwillclose'] = 'O teste está aberto, irá fechar às {$a}';
$string['quizordernotrandom'] = 'A ordem das perguntas não está baralhada';
$string['quizorderrandom'] = '* A ordem das perguntas está baralhada';
$string['quizsettings'] = 'Configurações do teste';
$string['quiztimer'] = 'Cronómetro';
$string['quizwillopen'] = 'Este teste irá abrir {$a}';
$string['random'] = 'Pergunta aleatória';
$string['randomcreate'] = 'Criar perguntas aleatórias';
$string['randomediting'] = 'A editar uma pergunta aleatória';
$string['randomfromcategory'] = 'Pergunta aleatória da categoria:';
$string['randomfromexistingcategory'] = 'Pergunta aleatória de uma categoria existente';
$string['randomfromunavailabletag'] = '{$a} (não disponível)';
$string['randomnosubcat'] = 'Apenas perguntas desta categoria, não utilizar das suas subcategorias';
$string['randomnumber'] = 'Número de perguntas aleatórias';
$string['randomquestion'] = 'Pergunta aleatória';
$string['randomquestion_help'] = 'Uma pergunta aleatória é um método de inserir uma pergunta escolhida aleatoriamente de uma categoria específica.';
$string['randomquestiontags'] = 'Palavras-chave';
$string['randomquestiontags_help'] = 'Pode restringir ainda mais os critérios de seleção especificando algumas palavras-chave de pergunta.

As perguntas "aleatórias" serão selecionadas das perguntas que tiverem todas as palavras-chave escolhidas.';
$string['randomquestionusinganewcategory'] = 'Pergunta aleatória de uma nova categoria';
$string['randomwithsubcat'] = 'Perguntas desta categoria e suas subcategorias';
$string['readytosend'] = 'Está prestes a submeter o teste para a avaliação. Tem a certeza de que pretende continuar?';
$string['reattemptquiz'] = 'Iniciar uma nova tentativa de resolução do teste';
$string['recentlyaddedquestion'] = 'Pergunta recentemente adicionada!';
$string['recurse'] = 'Incluir também perguntas das subcategorias';
$string['redoesofthisquestion'] = 'Outras tentativas de resposta: {$a}';
$string['redoquestion'] = 'Responder a esta pergunta novamente';
$string['regrade'] = 'Reavaliar todas as tentativas';
$string['regradecomplete'] = 'Todas as tentativas foram reavaliadas';
$string['regradecount'] = '{$a->changed} em {$a->attempt} notas foram alteradas';
$string['regradedisplayexplanation'] = 'Tentativas alteradas durante a reavaliação são exibidas com hiperligações para a janela de revisão da pergunta';
$string['regradenotallowed'] = 'Não tem permissão para reavaliar este teste';
$string['regradingquestion'] = 'A reavaliar "{$a}".';
$string['regradingquiz'] = 'A reavaliar teste "{$a}"';
$string['remove'] = 'Apagar';
$string['removeallgroupoverrides'] = 'Apagar todas as exceções para grupos';
$string['removeallquizattempts'] = 'Apagar todas as tentativas do teste';
$string['removealluseroverrides'] = 'Apagar todas as exceções para utilizadores';
$string['removeemptypage'] = 'Apagar página vazia';
$string['removepagebreak'] = 'Remover quebra de página';
$string['removeselected'] = 'Apagar selecionadas';
$string['rename'] = 'Renomear';
$string['renderingserverconnectfailed'] = 'O servidor {$a} falhou ao processar um pedido RQP. Verifique se o URL se está correto.';
$string['reorderquestions'] = 'Reordenar perguntas';
$string['reordertool'] = 'Mostrar a ferramenta de reordenação';
$string['repaginate'] = 'Repaginar com {$a} perguntas por página';
$string['repaginatecommand'] = 'Repaginar';
$string['repaginatenow'] = 'Repaginar agora';
$string['replace'] = 'Substituir';
$string['replacementoptions'] = 'Opções de substituição';
$string['report'] = 'Relatórios';
$string['reportanalysis'] = 'Análise de itens';
$string['reportattemptsfrom'] = 'Tentativas de';
$string['reportattemptsthatare'] = 'Tentativas que estão';
$string['reportdisplayoptions'] = 'Opções de exibição';
$string['reportfullstat'] = 'Estatísticas detalhadas';
$string['reportmulti_percent'] = 'Percentagens múltiplas';
$string['reportmulti_q_x_student'] = 'Multi-escolhas dos alunos';
$string['reportmulti_resp'] = 'Respostas individuais';
$string['reportmustselectstate'] = 'Deve selecionar pelo menos um estado.';
$string['reportnotfound'] = 'Relatório desconhecido ({$a})';
$string['reportoverview'] = 'Perspetiva global';
$string['reportregrade'] = 'Reavaliar tentativas';
$string['reportresponses'] = 'Respostas detalhadas';
$string['reports'] = 'Relatórios';
$string['reportshowonly'] = 'Mostrar apenas';
$string['reportshowonlyfinished'] = 'Uma tentativa terminada por utilizador ({$a})';
$string['reportsimplestat'] = 'Estatísticas simples';
$string['reportusersall'] = 'todos os utilizadores que responderam ao teste';
$string['reportuserswith'] = 'utilizadores inscritos que responderam ao teste';
$string['reportuserswithorwithout'] = 'utilizadores inscritos que responderam, ou não, ao teste';
$string['reportuserswithout'] = 'utilizadores inscritos que não responderam ao teste';
$string['reportwhattoinclude'] = 'O que incluir no relatório';
$string['requirepassword'] = 'Senha para entrar no teste';
$string['requirepassword_help'] = 'Se for definida uma senha, o aluno tem de a inserir para conseguir responder ao teste.';
$string['requiresubnet'] = 'Endereços de rede autorizados';
$string['requiresubnet_help'] = 'O acesso ao Teste pode ser permitido apenas para subnets particulares na LAN ou por endereços de IP que devem ser inseridos separados por vírgulas. Isto pode ser útil para controlar que apenas as pessoas num determinado local têm acesso ao teste.';
$string['response'] = 'Resposta';
$string['responses'] = 'Respostas';
$string['results'] = 'Resultados';
$string['returnattempt'] = 'Voltar à tentativa';
$string['reuseifpossible'] = 'reutilizar o que foi apagado previamente';
$string['reverttodefaults'] = 'Reverter para predefinições do teste';
$string['review'] = 'Rever';
$string['reviewafter'] = 'Permitir revisão depois do teste fechar';
$string['reviewalways'] = 'Permitir sempre a revisão';
$string['reviewattempt'] = 'Rever a tentativa';
$string['reviewbefore'] = 'Permitir a revisão enquanto o teste está aberto';
$string['reviewclosed'] = 'Após o teste fechar';
$string['reviewduring'] = 'Durante a tentativa';
$string['reviewimmediately'] = 'Imediatamente a seguir à tentativa';
$string['reviewnever'] = 'Nunca permitir a revisão';
$string['reviewofattempt'] = 'Revisão da tentativa {$a}';
$string['reviewofpreview'] = 'Revisão da pré-visualização';
$string['reviewofquestion'] = 'Revisão da pergunta \'{$a->question}\' em \'{$a->quiz}\' por \'{$a->user}\'';
$string['reviewopen'] = 'Mais tarde, com o teste ainda aberto';
$string['reviewoptions'] = 'Os alunos podem rever o teste';
$string['reviewoptionsheading'] = 'Informação exibida na revisão do teste';
$string['reviewoptionsheading_help'] = 'Estas opções definem a informação que os alunos podem ver ao rever uma tentativa ou ao consultar os relatórios do Teste.

**Durante a tentativa** é relevante apenas para alguns tipos de comportamentos das perguntas, como o \'Interativo com múltiplas tentativas\', que pode mostrar feedback durante a tentativa.

**Imediatamente a seguir à tentativa** aplicável ao período de dois minutos após o aluno submeter a tentativa de realização do Teste e, como tal, ao relatório de revisão do Teste que surge imediatamente a seguir.

**Mais tarde, com o teste ainda aberto** aplicável desde o período anterior até à data de fecho do Teste.

**Após o Teste fechar** aplicável após a data de fecho do Teste. Se o Teste não tiver uma data de fecho definida, este estado nunca é aplicado.';
$string['reviewoverallfeedback'] = 'Feedback global';
$string['reviewoverallfeedback_help'] = 'Feedback global dado ao aluno no final da tentativa em função da nota total obtida.';
$string['reviewresponse'] = 'Rever resposta';
$string['reviewresponsetoq'] = 'Rever resposta (pergunta {$a})';
$string['reviewthisattempt'] = 'Rever as suas respostas para esta tentativa';
$string['rqp'] = 'Pergunta remota';
$string['rqps'] = 'Perguntas remotas';
$string['sameasoverall'] = 'O mesmo da nota do teste';
$string['save'] = 'Guardar';
$string['saveandedit'] = 'Guardar alterações e editar perguntas';
$string['saveattemptfailed'] = 'Ocorreu um erro ao guardar a tentativa de realização do teste';
$string['savedfromdeletedcourse'] = 'Guardado da disciplina apagada "{$a}"';
$string['savegrades'] = 'Guardar notas';
$string['savemyanswers'] = 'Guardar as minhas respostas';
$string['savenosubmit'] = 'Guardar, sem submeter';
$string['saveoverrideandstay'] = 'Guardar e adicionar outra exceção';
$string['savequiz'] = 'Guardar todo o teste';
$string['saving'] = 'A guardar';
$string['savingnewgradeforquestion'] = 'A guardar nova nota para a pergunta com ID {$a}.';
$string['savingnewmaximumgrade'] = 'A guardar nova nota máxima.';
$string['score'] = 'Nota bruta';
$string['scores'] = 'Avaliações';
$string['search:activity'] = 'Teste - informações da atividade';
$string['sectionheadingedit'] = 'Editar título \'{$a}\'';
$string['sectionheadingremove'] = 'Eliminar secção \'{$a}\'';
$string['seequestions'] = '(Ver perguntas)';
$string['select'] = 'Selecionar';
$string['selectall'] = 'Selecionar tudo';
$string['selectattempt'] = 'Selecione a tentativa';
$string['selectcategory'] = 'Selecionar categoria';
$string['selectedattempts'] = 'Tentativas selecionadas...';
$string['selectmultipleitems'] = 'Selecionar vários itens';
$string['selectmultipletoolbar'] = 'Selecionar mais do que uma barra de ferramentas';
$string['selectnone'] = 'Desselecionar todas';
$string['selectquestiontype'] = '-- Selecionar tipo de pergunta --';
$string['serveradded'] = 'Servidor adicionado';
$string['serveridentifier'] = 'Identificador';
$string['serverinfo'] = 'Informação do servidor';
$string['servers'] = 'Servidores';
$string['serverurl'] = 'URL do servidor';
$string['settingsoverrides'] = 'Exceções das configurações';
$string['shortanswer'] = 'Resposta curta';
$string['show'] = 'Mostrar';
$string['showall'] = 'Mostrar todas as perguntas numa página';
$string['showblocks'] = 'Mostrar blocos durante a realização do teste';
$string['showblocks_help'] = 'Se selecionar \'Sim\', os blocos serão mostrados durante a realização do teste';
$string['showbreaks'] = 'Mostrar quebras de página';
$string['showcategorycontents'] = 'Mostrar conteúdo da categoria {$a->arrow}';
$string['showcorrectanswer'] = 'Mostrar respostas corretas no feedback?';
$string['showdetailedmarks'] = 'Mostrar detalhes da nota';
$string['showeachpage'] = 'Mostrar uma página de cada vez';
$string['showfeedback'] = 'Mostrar feedback após responder?';
$string['showinsecurepopup'] = 'Usar uma janela pop-up segura para realizar o teste';
$string['showlargeimage'] = 'Imagem grande';
$string['shownoattempts'] = 'Mostrar alunos sem tentativas';
$string['shownoattemptsonly'] = 'Mostrar apenas alunos sem tentativas';
$string['shownoimage'] = 'Nenhuma imagem';
$string['showreport'] = 'Mostrar relatório';
$string['showsmallimage'] = 'Imagem pequena';
$string['showteacherattempts'] = 'Mostrar tentativas de professores';
$string['showuserpicture'] = 'Mostrar fotografia do utilizador';
$string['showuserpicture_help'] = 'Se selecionar uma imagem, o nome do aluno e a respetiva fotografia serão exibidos durante a resolução do teste, assim como na revisão. Assim, torna-se mais fácil verificar se o aluno que está autenticado é o que está a resolver o teste num ambiente vigiado.';
$string['shuffle'] = 'Baralhar';
$string['shuffleanswers'] = 'Baralhar opções de resposta';
$string['shuffledrandomly'] = 'Baralhadas aleatoriamente';
$string['shufflequestions'] = 'Baralhar perguntas';
$string['shufflequestions_help'] = 'Se ativar esta opção, sempre que iniciar uma nova tentativa de resolução do teste, a ordem das perguntas desta secção será baralhada aleatoriamente.

Esta configuração pode dificultar a partilha de respostas entre alunos, mas também torna mais difícil pedir ajuda ao professor acerca de uma determinada pergunta.';
$string['shufflewithin'] = 'Baralhar dentro das perguntas';
$string['shufflewithin_help'] = 'Se selecionar \'Sim\', as opções de resposta serão baralhadas aleatoriamente cada vez que o aluno realiza uma tentativa do teste. Esta configuração só se aplica a perguntas com várias opções como as de resposta múltipla ou correspondência.';
$string['singleanswer'] = 'Escolha uma resposta…';
$string['sortage'] = 'Ordenar por idade';
$string['sortalpha'] = 'Ordenar por nome';
$string['sortquestionsbyx'] = 'Ordenar perguntas por: {$a}';
$string['sortsubmit'] = 'Ordenar perguntas';
$string['sorttypealpha'] = 'Ordenar por tipo, nome';
$string['specificapathnotonquestion'] = 'O caminho do ficheiro especificado não está na pergunta especificada';
$string['specificquestionnotonquiz'] = 'A pergunta não se encontra no teste indicado';
$string['startagain'] = 'Reiniciar';
$string['startattempt'] = 'Iniciar tentativa';
$string['startedon'] = 'Iniciada';
$string['startnewpreview'] = 'Iniciar nova pré-visualização';
$string['stateabandoned'] = 'Nunca submetidas';
$string['statefinished'] = 'Terminada';
$string['statefinisheddetails'] = 'Submetida {$a}';
$string['stateinprogress'] = 'Em progresso';
$string['statenotloaded'] = 'O estado para a pergunta {$a} não foi carregado da base de dados';
$string['stateoverdue'] = 'Tempo limite ultrapassado';
$string['stateoverduedetails'] = 'Deve ser submetido até {$a}';
$string['status'] = 'Estado';
$string['stoponerror'] = 'Parar em caso de erro';
$string['submitallandfinish'] = 'Submeter tudo e terminar';
$string['subneterror'] = 'O acesso a este teste está limitado a alguns locais. Atualmente, o seu computador não se encontra num dos locais autorizados a aceder ao teste.';
$string['subnetnotice'] = 'O acesso a este teste está limitado a alguns locais. O seu computador não se encontra em nenhuma subnet permitida. No entanto, na qualidade de professor, pode pré-visualizar o teste.';
$string['subplugintype_quiz'] = 'Relatório';
$string['subplugintype_quiz_plural'] = 'Relatórios';
$string['subplugintype_quizaccess'] = 'Regra de acesso';
$string['subplugintype_quizaccess_plural'] = 'Regras de acesso';
$string['substitutedby'] = 'será substituído por';
$string['summaryofattempt'] = 'Síntese da tentativa';
$string['summaryofattempts'] = 'Síntese das tentativas anteriores';
$string['temporaryblocked'] = 'Está temporariamente impedido de tentar resolver o teste novamente.<br /> Poderá voltar a tentar em:';
$string['theattempt'] = 'Resposta submetida';
$string['theattempt_help'] = 'A resposta submetida pelo aluno.';
$string['time'] = 'Horas';
$string['timecompleted'] = 'Terminada';
$string['timedelay'] = 'Não pode responder ao teste porque ainda não passou o tempo de espera exigido antes de realizar nova tentativa de resolução.';
$string['timeleft'] = 'Tempo restante';
$string['timelimit'] = 'Tempo limite';
$string['timelimit_help'] = 'Se ativar esta opção, o limite de tempo é anunciado na página inicial do teste e um cronómetro que conta o tempo restante é exibido no bloco de navegação do teste.';
$string['timelimitexeeded'] = 'Lamentamos mas terminou o tempo limite previsto para realizar o teste!';
$string['timestr'] = '%H:%M:%S em %d/%m/%y';
$string['timesup'] = 'O tempo terminou!';
$string['timetaken'] = 'Tempo gasto';
$string['timing'] = 'Disponibilidade e duração';
$string['tofile'] = 'para o ficheiro';
$string['tolerance'] = 'Margem de erro';
$string['toomanyrandom'] = 'O número de perguntas aleatórias exigidas é maior do que as disponíveis na categoria!';
$string['top'] = 'Topo';
$string['totalmarksx'] = 'Total de pontos: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total de {$a} perguntas nesta categoria';
$string['true'] = 'Verdadeiro';
$string['truefalse'] = 'Verdadeiro/Falso';
$string['type'] = 'Tipo';
$string['unfinished'] = 'aberto';
$string['ungraded'] = 'Sem avaliação';
$string['unit'] = 'Unidade';
$string['unknowntype'] = 'O tipo de pergunta não é suportado na linha {$a}. A pergunta será ignorada.';
$string['updateoverdueattemptstask'] = 'A atualizar tentativas do teste com tempo limite ultrapassado';
$string['updatequizslotswithrandomxofy'] = 'A atualizar as vagas do teste com dados de perguntas "aleatórias" ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Atualizar configurações do teste';
$string['updatingatttemptgrades'] = 'A atualizar as notas das tentativas.';
$string['updatingfinalgrades'] = 'A atualizar notas finais';
$string['updatingthegradebook'] = 'A atualizar a pauta';
$string['upgradesure'] = '<div>O módulo de testes, em particular, produzirá alterações significativas nas tabelas de testes. Uma vez que esta atualização ainda não foi suficientemente testada, é altamente recomendável que faça uma cópia de segurança das suas tabelas da base de dados antes de continuar.</div>';
$string['upgradingquizattempts'] = 'A atualizar tentativas: Teste {$a->done}/{$a->outof} (ID do Teste {$a->info})';
$string['upgradingveryoldquizattempts'] = 'A atualizar tentativas antigas: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Esta categoria foi preservada e movida para o nível do site pois é uma categoria pública ainda em uso noutras disciplinas.';
$string['useroverrides'] = 'Exceções para utilizadores';
$string['useroverridesdeleted'] = 'Exceções para utilizador apagadas';
$string['usersnone'] = 'Nenhum aluno tem acesso a este teste';
$string['validate'] = 'Validar';
$string['viewallanswers'] = 'Ver {$a} tentativas de resolução do teste';
$string['viewallreports'] = 'Ver relatórios para {$a} tentativas';
$string['viewed'] = 'Visualizado';
$string['warningmissingtype'] = '<b>Esta pergunta é de um tipo que ainda não se encontra instalado no seu Moodle.<br />Por favor, alerte o administrador da plataforma.</b>';
$string['wheregrade'] = 'Onde consulto a minha nota?';
$string['wildcard'] = 'Variável';
$string['windowclosing'] = 'Esta janela será fechada em breve';
$string['withsummary'] = 'com síntese das Estatísticas';
$string['wronguse'] = 'Não pode utilizar esta página dessa forma';
$string['xhtml'] = 'formato XHTML';
$string['youneedtoenrol'] = 'Tem de estar inscrito na disciplina para poder resolver o Teste.';
$string['yourfinalgradeis'] = 'A sua nota final do teste é {$a}';
