<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'pt', version '3.8'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.blog.errorloadentries'] = 'Ocorreu um erro ao carregar publicações do Blogue.';
$string['addon.blog.showonlyyourentries'] = 'Mostrar apenas as suas publicações';
$string['addon.calendar.calendarevent'] = 'Evento do calendário';
$string['addon.calendar.calendarevents'] = 'Eventos do calendário';
$string['addon.calendar.calendarreminders'] = 'Lembretes do calendário';
$string['addon.calendar.currentmonth'] = 'Mês atual';
$string['addon.calendar.defaultnotificationtime'] = 'Hora de notificação predefinida';
$string['addon.calendar.errorloadevent'] = 'Erro ao carregar evento.';
$string['addon.calendar.errorloadevents'] = 'Erro ao carregar eventos.';
$string['addon.calendar.noevents'] = 'Sem eventos';
$string['addon.calendar.reminders'] = 'Lembretes';
$string['addon.calendar.setnewreminder'] = 'Definir um novo lembrete';
$string['addon.competency.errornocompetenciesfound'] = 'Competências não encontradas';
$string['addon.competency.nocompetencies'] = 'Sem competências';
$string['addon.coursecompletion.complete'] = 'Concluído';
$string['addon.coursecompletion.couldnotloadreport'] = 'Não foi possível carregar o relatório de conclusão da disciplina. Por favor, tente mais tarde.';
$string['addon.files.couldnotloadfiles'] = 'Não foi possível carregar a lista de ficheiros';
$string['addon.files.emptyfilelist'] = 'Não existem ficheiros';
$string['addon.files.erroruploadnotworking'] = 'Infelizmente não é possível carregar ficheiros para o seu site.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configurar dispositivos';
$string['addon.messages.contactlistempty'] = 'A lista de contactos está vazia';
$string['addon.messages.contactname'] = 'Nome do contacto';
$string['addon.messages.deletemessage'] = 'Apagar mensagem';
$string['addon.messages.deletemessageconfirmation'] = 'Tem a certeza de que pretende apagar esta mensagem? Apenas será excluída do seu histórico de mensagens. Poderá ser visualizada pelo utilizador que enviou ou recebeu a mensagem.';
$string['addon.messages.errordeletemessage'] = 'Erro ao eliminar a mensagem.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Erro ao obter contactos do servidor.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Erro ao obter tópicos de discussão do servidor.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Erro ao obter mensagens do servidor.';
$string['addon.messages.errorwhileretrievingusers'] = 'Erro ao obter utilizadores do servidor.';
$string['addon.messages.messagenotsent'] = 'A mensagem não foi enviada. Tente novamente mais tarde.';
$string['addon.messages.newmessages'] = 'Novas mensagens';
$string['addon.messages.nousersfound'] = 'Nenhum utilizador encontrado';
$string['addon.messages.showdeletemessages'] = 'Mostrar o apagar mensagens';
$string['addon.messages.type_blocked'] = 'Bloqueado';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Resultados da pesquisa';
$string['addon.messages.type_strangers'] = 'Outros';
$string['addon.messages.useentertosenddescdesktop'] = 'Se desativar esta opção, pode utilizar Ctrl+Enter para enviar a mensagem.';
$string['addon.messages.useentertosenddescmac'] = 'Se desativar esta opção, pode utilizar Cmd+Enter para enviar a mensagem.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Não foi possível enviar mensagens para a conversação {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Não foi possível enviar mensagens ao utilizador {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Por favor, aceite a declaração de submissão.';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'Não pode adicionar ou editar uma submissão na aplicação porque não foi possível recuperar a declaração de submissão desde o site.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Alguns métodos de avaliação ainda não são suportados pela aplicação e não podem ser modificados.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'Não pode submeter o trabalho na aplicação porque não foi possível obter a declaração de submissão desde o site.';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'Não pode adicionar ou editar uma submissão na aplicação porque alguns módulos ainda não são suportados para edição.';
$string['addon.mod_assign.errorshowinginformation'] = 'Não é possível mostrar informações da submissão';
$string['addon.mod_assign.feedbacknotsupported'] = 'Este feedback não é suportado pela aplicação e pode não conter toda a informação.';
$string['addon.mod_assign.gradenotsynced'] = 'Nota não está sincronizada';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Não são mostrados os participantes sem submissão.';
$string['addon.mod_assign.submissionnotsupported'] = 'Esta submissão não é suportada pela aplicação e pode não conter toda a informação.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'nota do utilizador';
$string['addon.mod_assign.userwithid'] = 'Utilizador com ID {{id}}';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'A nota da submissão foi modificada no site.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'A submissão do utilizador foi modificada no site.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Erro ao entrar no chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Erro ao obter os dados do chat.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Erro ao obter os utilizadores do chat.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Erro ao obter mensagens do servidor.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Erro ao enviar a mensagem.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Tem de estar online para poder enviar mensagens.';
$string['addon.mod_chat.nosessionsfound'] = 'Nenhuma sessão encontrada';
$string['addon.mod_chat.showincompletesessions'] = 'Mostrar sessões incompletas';
$string['addon.mod_choice.errorgetchoice'] = 'Erro ao obter os dados da sondagem.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% dos utilizadores escolheram esta opção: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'A sua última resposta tem de ser sincronizada para estar incluída nos resultados.';
$string['addon.mod_data.edittagsnotsupported'] = 'A edição de palavras-chave não é suportada pela aplicação.';
$string['addon.mod_data.errorapproving'] = 'Erro ao aprovar ou desaprovar uma entrada.';
$string['addon.mod_data.errordeleting'] = 'Erro ao apagar a entrada.';
$string['addon.mod_data.gettinglocation'] = 'A obter localização';
$string['addon.mod_data.locationnotenabled'] = 'Localização não está ativada';
$string['addon.mod_data.locationpermissiondenied'] = 'Foi negada a permissão para aceder à sua localização.';
$string['addon.mod_data.mylocation'] = 'Minha localização';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Pesquisar por palavras-chave não é suportado pela aplicação.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Inquérito com CAPTCHA não pode ser concluído em modo offline, ou se não estiver configurado, ou o servidor não está acessível.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'O Inquérito foi gravado para ser enviado mais tarde.';
$string['addon.mod_folder.emptyfilelist'] = 'Não existem ficheiros para mostrar.';
$string['addon.mod_forum.errorgetforum'] = 'Erro ao obter dados do fórum.';
$string['addon.mod_forum.errorgetgroups'] = 'Erro ao obter as configurações do grupo.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Não foi possível criar nova conversação em todos os grupos.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'Ainda não existem tópicos de discussão neste fórum.';
$string['addon.mod_forum.group'] = 'Grupo';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} tópicos de discussão';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} respostas';
$string['addon.mod_forum.refreshdiscussions'] = 'Atualizar mensagens';
$string['addon.mod_forum.refreshposts'] = 'Atualizar tópicos de discussão';
$string['addon.mod_glossary.browsemode'] = 'Ver entradas';
$string['addon.mod_glossary.byalphabet'] = 'Alfabeticamente';
$string['addon.mod_glossary.byauthor'] = 'Agrupar por autor';
$string['addon.mod_glossary.bycategory'] = 'Agrupar por categoria';
$string['addon.mod_glossary.bynewestfirst'] = 'Ordenar por mais recentes';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Recentemente atualizados';
$string['addon.mod_glossary.bysearch'] = 'Pesquisar';
$string['addon.mod_glossary.cannoteditentry'] = 'Não é possível editar a entrada';
$string['addon.mod_glossary.entriestobesynced'] = 'Entradas a ser sincronizadas';
$string['addon.mod_glossary.entrypendingapproval'] = 'Este termo aguarda aprovação.';
$string['addon.mod_glossary.errorloadingentries'] = 'Ocorreu um erro ao carregar os termos.';
$string['addon.mod_glossary.errorloadingentry'] = 'Ocorreu um erro ao carregar o termo.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Ocorreu um erro ao carregar o glossário.';
$string['addon.mod_glossary.noentriesfound'] = 'Não foi encontrado nenhum termo.';
$string['addon.mod_glossary.searchquery'] = 'Pesquisa';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Descarregar ficheiro H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Erro ao obter dados da atividade do H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'O pacote H5P ainda não foi descarregado. Tem de descarregar primeiro para poder usá-lo.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'O pacote H5P foi modificado desde a última vez que foi descarregado. Tem de o descarregar novamente para poder usá-lo.';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'Tem de estar online para visualizar o pacote H5P.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Ver a tentativa {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Mostrar descrição';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Esta lição contém um salto para uma página de conteúdo aleatório. Não pode ser tentada na aplicação antes de ser iniciada no site.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Já não é possível rever esta tentativa porque já foi terminada outra tentativa.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Esta tentativa foi concluída em modo offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Uma tentativa offline foi sincronizada. Pretende rever a tentativa?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'A tentativa foi terminada no site.';
$string['addon.mod_lti.errorgetlti'] = 'Erro ao obter os dados do módulo.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'O URL não é válido.';
$string['addon.mod_lti.launchactivity'] = 'Iniciar a atividade';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Erro ao carregar o conteúdo da página.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'Pode tentar responder a este teste na aplicação, mas precisará de enviar a tentativa através do navegador pelos seguintes motivos:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Esta tentativa de resolução do teste não pode ser submetida pelas seguintes razões:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Esta tentativa não foi sincronizada desde {{$a}}. Se continuou esta tentativa noutro dispositivo desde então, pode perder dados.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Ocorreu um erro ao guardar as respostas. Tem a certeza de que pretende sair do teste?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Este teste não pode ser respondido na aplicação porque o comportamento das questões não é suportado:';
$string['addon.mod_quiz.errordownloading'] = 'Erro ao descarregar os dados necessários.';
$string['addon.mod_quiz.errorgetattempt'] = 'Erro ao obter dados da tentativa.';
$string['addon.mod_quiz.errorgetquestions'] = 'Erro ao obter perguntas.';
$string['addon.mod_quiz.errorgetquiz'] = 'Erro ao obter dados de teste.';
$string['addon.mod_quiz.errorparsequestions'] = 'Ocorreu um erro ao ler as perguntas. Tente o teste num navegador Web.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Este teste não pode ser tentado na aplicação porque apenas contém tipos de perguntas não suportados pela aplicação:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Este teste não pode ser tentado na aplicação porque tem regras de acesso não suportadas pela aplicação:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Ocorreu um erro ao guardar os dados da tentativa.';
$string['addon.mod_quiz.finishnotsynced'] = 'Terminado mas não sincronizado';
$string['addon.mod_quiz.opentoc'] = 'Abrir navegação';
$string['addon.mod_quiz.warningattemptfinished'] = 'Esta tentativa offline foi descartada por já estar concluída no site ou não ter  sido encontrada.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Algumas respostas offline foram descartadas porque as perguntas foram modificadas no site.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Tentativa inacabada porque algumas respostas offline foram descartadas. Por favor reveja as suas respostas e reenvie a tentativa.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Este teste contém tipos de perguntas não suportados pela aplicação:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Erro ao carregar o conteúdo.';
$string['addon.mod_resource.openthefile'] = 'Abrir o ficheiro';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Não foi possível calcular a nota.';
$string['addon.mod_scorm.dataattemptshown'] = 'Estes dados pertencem à tentativa número {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Ocorreu um erro ao criar uma nova tentativa offline. Por favor, tente novamente.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Erro ao descarregar o SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Erro ao obter os dados do SCORM.';
$string['addon.mod_scorm.errorinvalidversion'] = 'A aplicação apenas suporta a versão SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Não é permitido descarregar pacotes SCORM. Por favor, contacte o administrador do site.';
$string['addon.mod_scorm.errornovalidsco'] = 'Este pacote SCORM não possui um SCO visível para carregar.';
$string['addon.mod_scorm.errorpackagefile'] = 'A aplicação apenas suporta pacotes ZIP.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Ocorreu um erro durante o processo de sincronização. Por favor, tente novamente.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Esta tentativa possui dados que ainda não foram sincronizados.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Esta tentativa não pode ser enviada porque já excedeu o número máximo de tentativas.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Este pacote SCORM não foi descarregado. Será descarregado assim que o abrir.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Este pacote SCORM foi modificado desde a última vez que o descarregou. A versão mais recente do mesmo será descarregada automaticamente assim que o abrir.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Alguns dados offline da tentativa {{number}} foram excluídos porque não podem ser considerados numa nova tentativa.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Algumas tentativas ainda não foram sincronizadas com o site porque a última tentativa ainda não se está finalizada. Por favor, termine a tentativa online primeiro.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Ocorreu um problema durante a submissão do seu inquérito. Por favor, tente novamente.';
$string['addon.mod_survey.errorgetsurvey'] = 'Erro ao obter os dados do inquérito.';
$string['addon.mod_survey.results'] = 'Resultados';
$string['addon.mod_url.accessurl'] = 'Aceder ao URL';
$string['addon.mod_url.pointingtourl'] = 'O URL para onde aponta este recurso.';
$string['addon.mod_wiki.errorloadingpage'] = 'Ocorreu um erro ao carregar a página.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Este Wiki ainda não possui conteúdo.';
$string['addon.mod_wiki.gowikihome'] = 'Ir para página principal do Wiki';
$string['addon.mod_wiki.subwiki'] = 'Sub-Wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'O título não deve estar vazio';
$string['addon.mod_wiki.viewpage'] = 'Visualizar página';
$string['addon.mod_wiki.wikipage'] = 'Página Wiki';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Estratégia de avaliação {{$a}} não suportada';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'É necessário indicar um título.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'A submissão foi alterada no site.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'O trabalho foi modificado no site.';
$string['addon.notes.userwithid'] = 'Utilizador com o ID {{id}}';
$string['addon.notes.warningnotenotsent'] = 'Não foi possível adicionar anotações à disciplina {{course}}. {{error}}';
$string['addon.notifications.errorgetnotifications'] = 'Erro ao obter notificações.';
$string['addon.notifications.notifications'] = 'Notificações';
$string['addon.notifications.playsound'] = 'Reproduzir som';
$string['addon.notifications.therearentnotificationsyet'] = 'Não existem notificações.';
$string['addon.storagemanager.deletecourse'] = 'Carregar todos os dados da disciplina';
$string['addon.storagemanager.deletecourses'] = 'Descarregar todos os dados das disciplinas';
$string['addon.storagemanager.deletedatafrom'] = 'Carregar dados de {{name}}';
$string['addon.storagemanager.info'] = 'Os ficheiros armazenados no seu dispositivo tornam a aplicação mais rápida e permitem que possa ser usada offline. Pode carregar ficheiros em segurança se precisar de libertar espaço de armazenamento.';
$string['addon.storagemanager.managestorage'] = 'Gerir armazenamento';
$string['addon.storagemanager.storageused'] = 'Armazenamento usado por ficheiros:';
$string['appstoredescription'] = 'NOTA: Esta aplicação oficial Moodle Mobile apenas funciona com sites Moodle que foram configurados para o permitir. Fale com o administrador do seu Moodle se tiver quaisquer dificuldades em se ligar. Se o seu site Moodle foi configurado corretamente, pode usar esta aplicação para:

- Navegar no conteúdo das suas disciplinas, mesmo quando estiver offline
- Receber notificações instantâneas de mensagens e outros eventos
- Encontrar de forma rápida e entrar em contacto com outras pessoas nas suas disciplinas
- Carregar imagens, áudio, vídeos e outros ficheiros do seu dispositivo móvel
- Visualizar as suas notas das disciplinas
- E muito mais!

Por favor, consulte http://docs.moodle.org/en/Mobile_app para aceder à informação mais atualizada.

Gostaríamos muito de receber boas opiniões sobre a funcionalidade até agora implementada e as suas sugestões para outras funcionalidades que desejaria que esta aplicação tivesse!

A aplicação requer as seguintes permissões:
Gravar áudio - Para gravação de áudio e carregar no Moodle
Ler e modificar o conteúdo do cartão SD - Os conteúdos são descarregados para o cartão SD para que os possa consultar offline
Acesso à rede - Para ser capaz de se ligar ao seu site Moodle e verificar se está ligado ou não, para mudar para o modo offline
Executar no arranque do sistema - Para receber notificações, mesmo quando a aplicação está a ser executada em segundo plano
Impedir que dispositivo entre em suspensão - Para que possa receber notificações a qualquer momento';
$string['core.browser'] = 'Navegador';
$string['core.cannotconnect'] = 'Não é possível estabelecer a ligação';
$string['core.cannotconnecttrouble'] = 'Estamos com problemas para estabelecer a ligação ao seu site.';
$string['core.cannotconnectverify'] = '<strong>Por favor, verifique se o endereço está correto.</strong>';
$string['core.cannotdownloadfiles'] = 'A descarga de ficheiros está desativada. Por favor, contacte o administrador do site.';
$string['core.cannotopeninapp'] = 'Este ficheiro pode não funcionar como esperado neste dispositivo. Pretende abri-lo mesmo assim?';
$string['core.cannotopeninappdownload'] = 'Este ficheiro pode não funcionar como esperado neste dispositivo. Pretende descarregá-lo mesmo assim?';
$string['core.captureaudio'] = 'Gravar áudio';
$string['core.capturedimage'] = 'Fotografia tirada.';
$string['core.captureimage'] = 'Tirar fotografia';
$string['core.capturevideo'] = 'Gravar vídeo';
$string['core.clearsearch'] = 'Limpar pesquisa';
$string['core.clearstoreddata'] = 'Limpar armazenamento {{$a}}';
$string['core.clicktoseefull'] = 'Clique para ver todos os conteúdos.';
$string['core.comments.commentsnotworking'] = 'Comentários não podem ser recuperados';
$string['core.comments.warningcommentsnotsent'] = 'Não foi possível sincronizar os comentários. {{error}}';
$string['core.confirmcanceledit'] = 'Tem a certeza de que pretende sair desta página? Todas as alterações serão perdidas.';
$string['core.confirmgotabroot'] = 'Tem a certeza de que pretende voltar para {{name}}?';
$string['core.confirmgotabrootdefault'] = 'Tem a certeza de que pretende ir para a página inicial do separador atual?';
$string['core.confirmleaveunknownchanges'] = 'Tem a certeza de que pretende sair desta página? Quaisquer alterações não guardadas serão perdidas.';
$string['core.confirmloss'] = 'Tem a certeza absoluta? Todas as alterações serão perdidas.';
$string['core.confirmopeninbrowser'] = 'Pretende abrir a ligação no navegador de internet?';
$string['core.contenteditingsynced'] = 'O conteúdo que está a editar foi sincronizado.';
$string['core.contentlinks.chooseaccount'] = 'Escolha a conta';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Escolha uma conta para abrir a hiperligação.';
$string['core.contentlinks.confirmurlothersite'] = 'Esta hiperligação pertence a outro site. Pretende abri-la?';
$string['core.contentlinks.errornoactions'] = 'Não foi possível encontrar uma ação para executar com esta hiperligação.';
$string['core.contentlinks.errornosites'] = 'Não foi possível encontrar um site que suporte esta hiperligação.';
$string['core.contentlinks.errorredirectothersite'] = 'O URL de redirecionamento não pode apontar para um site diferente.';
$string['core.copiedtoclipboard'] = 'Texto copiado para a área de transferência';
$string['core.copytoclipboard'] = 'Copiar para área de transferência';
$string['core.course.activitydisabled'] = 'A sua organização desativou esta atividade na aplicação para dispositivos móveis.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'A sua organização instalou um módulo que ainda não é suportado.';
$string['core.course.activitynotyetviewablesiteupgradeneeded'] = 'A instalação do Moodle da sua organização precisa ser atualizada.';
$string['core.course.allsections'] = 'Todas as secções';
$string['core.course.askadmintosupport'] = 'Contacte o administrador do site e informe-lhes que pretende usar esta atividade com a aplicação móvel Moodle.';
$string['core.course.availablespace'] = 'Atualmente, dispõe aproximadamente {{available}} de espaço livre.';
$string['core.course.cannotdeletewhiledownloading'] = 'Os ficheiros não podem ser apagados enquanto a atividade está a ser descarregada. Por favor, aguarde que termine o descarregamento.';
$string['core.course.confirmdeletemodulefiles'] = 'Tem a certeza de que pretende apagar estes ficheiros?';
$string['core.course.confirmdeletestoreddata'] = 'Tem a certeza de que pretende apagar os dados armazenados?';
$string['core.course.confirmdownload'] = 'Está prestes a descarregar {{size}}.{{availableSpace}} Tem a certeza de que pretende continuar?';
$string['core.course.confirmdownloadunknownsize'] = 'Não foi possível calcular o tamanho da descarga.{{availableSpace}} Tem a certeza de que pretende continuar?';
$string['core.course.confirmdownloadzerosize'] = 'Está prestes a iniciar a descarga. {{AvailableSpace}} Tem a certeza de que pretende continuar?';
$string['core.course.confirmlimiteddownload'] = 'Não está ligado a qualquer rede Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Está prestes a descarregar <strong>pelo menos</strong> {{size}}. {{availableSpace}} Tem a certeza de que pretende continuar?';
$string['core.course.contents'] = 'Conteúdos';
$string['core.course.couldnotloadsectioncontent'] = 'Não foi possível carregar o conteúdo da secção. Por favor, tente novamente mais tarde.';
$string['core.course.couldnotloadsections'] = 'Não foi possível carregar as secções. Por favor, tente novamente mais tarde.';
$string['core.course.errordownloadingcourse'] = 'Erro ao descarregar a disciplina.';
$string['core.course.errordownloadingsection'] = 'Erro ao descarregar a secção.';
$string['core.course.errorgetmodule'] = 'Erro ao obter os dados da atividade.';
$string['core.course.insufficientavailablequota'] = 'O seu dispositivo não conseguiu libertar espaço para guardar o que pretende descarregar. Pode estar a reservar espaço para atualizações de aplicações e do sistema. Por favor, liberte espaço livre para armazenamento.';
$string['core.course.insufficientavailablespace'] = 'Está a tentar descarregar {{size}}. Se prosseguir, o dispositivo deixará de ter espaço suficiente para funcionar normalmente. Por favor, liberte espaço livre para armazenamento.';
$string['core.course.manualcompletionnotsynced'] = 'Conclusão manual não sincronizada.';
$string['core.course.nocontentavailable'] = 'Neste momento não existe conteúdo disponível.';
$string['core.course.refreshcourse'] = 'Atualizar disciplina';
$string['core.course.useactivityonbrowser'] = 'No entanto, pode usá-lo no navegador do seu dispositivo.';
$string['core.course.warningmanualcompletionmodified'] = 'A conclusão manual de uma atividade foi modificada no site.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Uma conclusão manual offline da disciplina \'{{name}}\' foi apagada. {{error}}';
$string['core.coursenogroups'] = 'Não é membro de qualquer grupo desta disciplina.';
$string['core.courses.cannotretrievemorecategories'] = 'Categorias abaixo do nível {{$a}} não podem ser recuperadas.';
$string['core.courses.confirmselfenrol'] = 'Tem a certeza de que deseja inscrever-se nesta disciplina?';
$string['core.courses.downloadcourses'] = 'Descarregar disciplinas';
$string['core.courses.enrolme'] = 'Inscreva-me';
$string['core.courses.errorloadcategories'] = 'Ocorreu um erro ao carregar as categorias.';
$string['core.courses.errorloadcourses'] = 'Ocorreu um erro ao carregar as disciplinas.';
$string['core.courses.errorloadplugins'] = 'Não foram carregados corretamente os módulos exigidos por esta disciplina. Por favor, recarregue a aplicação para tentar novamente.';
$string['core.courses.errorsearching'] = 'Ocorreu um erro durante a pesquisa.';
$string['core.courses.errorselfenrol'] = 'Ocorreu um erro na autoinscrição.';
$string['core.courses.filtermycourses'] = 'Filtrar as minhas disciplinas';
$string['core.courses.notenrollable'] = 'Não pode inscrever-se nesta disciplina.';
$string['core.courses.password'] = 'Senha de inscrição';
$string['core.courses.searchcoursesadvice'] = 'Pode usar o botão Procurar disciplinas para encontrar disciplinas com acesso permitido a visitantes ou inscrever-se em disciplinas que o permitam.';
$string['core.courses.selfenrolment'] = 'Autoinscrição';
$string['core.courses.totalcoursesearchresults'] = 'Total de disciplinas: {{$a}}';
$string['core.currentdevice'] = 'Dispositivo atual';
$string['core.datastoredoffline'] = 'Dados armazenados no dispositivo por não ter sido possível enviar. Serão automaticamente enviados mais tarde.';
$string['core.deletedoffline'] = 'Apagada em modo offline';
$string['core.deleting'] = 'A apagar';
$string['core.desktop'] = 'PC de secretária';
$string['core.dfdaymonthyear'] = 'DD-MM-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'hh[:]mm';
$string['core.discard'] = 'Descartar';
$string['core.dismiss'] = 'Dispensar';
$string['core.downloaded'] = 'Descarregada';
$string['core.downloading'] = 'A descarregar';
$string['core.editor.hidetoolbar'] = 'Ocultar barra de ferramentas';
$string['core.editor.toggle'] = 'Alternar editor';
$string['core.emptysplit'] = 'Esta página aparecerá em branco se o painel esquerdo estiver vazio ou enquanto estiver a ser carregado.';
$string['core.errorchangecompletion'] = 'Ocorreu um erro ao alterar o estado da conclusão. Por favor, tente novamente.';
$string['core.errordeletefile'] = 'Erro ao apagar o ficheiro. Por favor, tente novamente.';
$string['core.errordownloading'] = 'Erro ao descarregar o ficheiro.';
$string['core.errordownloadingsomefiles'] = 'Erro ao descarregar os ficheiros. Alguns ficheiros poderão estar em falta.';
$string['core.errorfileexistssamename'] = 'Já existe um ficheiro com este nome.';
$string['core.errorinvalidform'] = 'O formulário contém dados inválidos. Por favor, verifique se todos os campos obrigatórios estão preenchidos e que os dados são válidos.';
$string['core.errorinvalidresponse'] = 'Foi recebida uma resposta inválida. Se o erro persistir, por favor, contacte o administrador do site.';
$string['core.errorloadingcontent'] = 'Erro ao carregar o conteúdo.';
$string['core.errorofflinedisabled'] = 'A navegação offline está desativada no site. Precisa de estar ligado à internet para usar a aplicação.';
$string['core.erroropenfilenoapp'] = 'Erro ao abrir o ficheiro: não foi encontrada nenhuma aplicação compatível com este tipo de ficheiro.';
$string['core.erroropenfilenoextension'] = 'Erro ao abrir o ficheiro: o ficheiro não possui uma extensão.';
$string['core.erroropenpopup'] = 'Esta atividade está a tentar abrir uma janela pop-up. Esta funcionalidade não é suportada na aplicação.';
$string['core.errorrenamefile'] = 'Erro ao mudar o nome do ficheiro. Por favor, tente novamente.';
$string['core.errorsomedatanotdownloaded'] = 'Se descarregou esta atividade, tenha em atenção que alguns dados não são descarregados durante o processo de descarregamento por motivos de desempenho e uso de dados.';
$string['core.errorsync'] = 'Ocorreu um erro durante a sincronização. Por favor, tente novamente.';
$string['core.errorsyncblocked'] = 'Não é possível sincronizar agora este {{$a}} devido a outro processo já em andamento. Por favor, tente novamente mais tarde. Se o problema persistir, tente reiniciar a aplicação.';
$string['core.errorurlschemeinvalidscheme'] = 'Este URL deve ser usado em outra aplicação: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'O URL deste site não pode ser aberto nesta aplicação.';
$string['core.filenameexist'] = 'O nome do ficheiro já existe: {{$a}}';
$string['core.fileuploader.audio'] = 'Áudio';
$string['core.fileuploader.camera'] = 'Câmara';
$string['core.fileuploader.confirmuploadfile'] = 'Está prestes a carregar {{size}}. Tem a certeza que pretende continuar?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Não foi possível calcular o tamanho do carregamento. Tem a certeza que pretende continuar?';
$string['core.fileuploader.errorcapturingaudio'] = 'Erro ao capturar áudio.';
$string['core.fileuploader.errorcapturingimage'] = 'Erro ao capturar imagem.';
$string['core.fileuploader.errorcapturingvideo'] = 'Erro ao capturar vídeo.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Erro ao obter imagem do álbum';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Tem de estar online para enviar ficheiros';
$string['core.fileuploader.errornoapp'] = 'Não possui a aplicação móvel necessária para executar esta ação.';
$string['core.fileuploader.errorreadingfile'] = 'Erro ao ler o ficheiro';
$string['core.fileuploader.errorwhileuploading'] = 'Ocorreu um erro durante o carregamento do ficheiro.';
$string['core.fileuploader.file'] = 'Ficheiro';
$string['core.fileuploader.fileuploaded'] = 'Ficheiro carregado com sucesso';
$string['core.fileuploader.maxbytesfile'] = 'O ficheiro {{$a.file}} é muito grande. O tamanho máximo que pode carregar é de {{$a.size}}.';
$string['core.fileuploader.photoalbums'] = 'Álbuns de fotos';
$string['core.fileuploader.readingfile'] = 'A ler ficheiro';
$string['core.fileuploader.readingfileperc'] = 'A ler ficheiro: {{$a}}%';
$string['core.fileuploader.selectafile'] = 'Selecione um ficheiro';
$string['core.fileuploader.uploadafile'] = 'Carregar um ficheiro';
$string['core.fileuploader.uploading'] = 'A carregar';
$string['core.fileuploader.uploadingperc'] = 'A carrregar: {{$a}}%';
$string['core.fileuploader.video'] = 'Vídeo';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.h5p.errorgetemail'] = 'Erro ao obter o e-mail do utilizador. Por favor, verifique a sua ligação e tente novamente.';
$string['core.h5p.offlinedisabled'] = 'O site não permite descarregar pacotes H5P.';
$string['core.h5p.play'] = 'Executar H5P';
$string['core.hasdatatosync'] = '{{$a}} tem dados offline que precisam de ser sincronizados.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.image'] = 'Imagem';
$string['core.imageviewer'] = 'Visualizador de imagens';
$string['core.lastdownloaded'] = 'Descarregado última vez em';
$string['core.lastsync'] = 'Última sincronização';
$string['core.loadmore'] = 'Ver mais';
$string['core.login.authenticating'] = 'Autenticação';
$string['core.login.changepasswordbutton'] = 'Abrir a página de alteração da senha';
$string['core.login.changepasswordhelp'] = 'Se tiver problemas para alterar a sua senha, entre em contacto com o administrador do site. Os "Administradores do site" são as pessoas que gerem o Moodle na sua escola/universidade/empresa ou organização de ensino. Se não souber como contactá-los, entre em contacto com os seus professores/formadores.';
$string['core.login.changepasswordinstructions'] = 'Não pode alterar a sua senha na aplicação. Clique no botão a seguir para abrir o site num navegador web e alterar a sua senha. Tenha em consideração que é necessário fechar o navegador após alterar a senha, pois não será redirecionado para a aplicação.';
$string['core.login.changepasswordlogoutinstructions'] = 'Se pretender alterar o site ou sair, clique no botão:';
$string['core.login.changepasswordreconnectinstructions'] = 'Clique no botão a seguir para voltar a ligar-se ao site. (Tenha em consideração que, se não alterou a sua senha com sucesso, será redirecionado para a página anterior).';
$string['core.login.confirmdeletesite'] = 'Tem a certeza que pretende remover o site {{sitename}}?';
$string['core.login.connect'] = 'Ligar';
$string['core.login.connecttomoodle'] = 'Ligar ao Moodle';
$string['core.login.connecttomoodleapp'] = 'Está a tentar ligar-se a um site normal do Moodle. Descarregue a Aplicação móvel Moodle para aceder a este site.';
$string['core.login.connecttoworkplaceapp'] = 'Está a tentar ligar-se a um site do Moodle Workplace. Descarregue a Aplicação móvel Moodle para aceder a este site.';
$string['core.login.contactyouradministrator'] = 'Contacte o administrador do site para obter mais ajuda.';
$string['core.login.contactyouradministratorissue'] = 'Por favor, solicite ao administrador que verifique o seguinte problema: {{$a}}';
$string['core.login.credentialsdescription'] = 'Por favor, digite o nome de utilizador e senha para entrar';
$string['core.login.emailconfirmsentnoemail'] = '<p>Foi enviado um e-mail para o seu endereço.</p><p> Contém instruções fáceis para concluir o seu registo.</p><p>Se continuar com dificuldades, entre em contacto com o administrador do site.</p>';
$string['core.login.emailnotmatch'] = 'Os e-mails não coincidem';
$string['core.login.erroraccesscontrolalloworigin'] = 'A acção de Cross-Origin que tentou executar foi rejeitada. Por favor, consulte mais informações em https://docs.moodle.org/dev/Moodle_Mobile_development_using_Chrome_or_Chromium';
$string['core.login.errordeletesite'] = 'Ocorreu um erro ao apagar este site. Por favor, tente novamente.';
$string['core.login.errorexampleurl'] = 'O URL https://campus.example.edu é apenas um exemplo de URL, não é um site real. <strong>Use o URL do site da sua escola ou organização.</strong>';
$string['core.login.errorqrnoscheme'] = 'Este URL não é um URL de autenticação válido.';
$string['core.login.errorupdatesite'] = 'Ocorreu um erro enquanto atualizava o token do site.';
$string['core.login.faqcannotconnectanswer'] = 'Por favor, contacte um administrador do site.';
$string['core.login.faqcannotconnectquestion'] = 'Digitei o endereço do meu site corretamente mas ainda não consigo ligar.';
$string['core.login.faqcannotfindmysiteanswer'] = 'Digitou o nome corretamente? Também pode acontecer que o seu site não esteja incluído no nosso diretório de sites públicos. Se continua a não conseguiu encontrar, digite o endereço do site.';
$string['core.login.faqcannotfindmysitequestion'] = 'Não consigo encontrar o meu site.';
$string['core.login.faqsetupsiteanswer'] = 'Visite a página {{$link}} para consultar as diferentes opções que precisa para criar o seu próprio site Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Iniciar.';
$string['core.login.faqsetupsitequestion'] = 'Eu pretendo criar o meu próprio site Moodle.';
$string['core.login.faqtestappanswer'] = 'Para testar a aplicação num site de demonstração do Moodle, digite "teacher" ou "student" no campo "O seu site" e clique no botão "Entrar".';
$string['core.login.faqtestappquestion'] = 'Eu apenas pretendo testar a aplicação? O que devo fazer?';
$string['core.login.faqwhatisurlanswer'] = '<p>Todas as organizações têm o seu endereço único para o site Moodle. Para encontrar o endereço:</p><ol><li>Abra um navegador da Web e aceda à página de autenticação do seu site Moodle</li><li>Na parte superior da página, na barra de endereços, verá o URL do seu site Moodle, por exemplo, "campus.example.edu".<br>{{$image}}</li><li>Copie o endereço (não copie a autenticação e o que está depois), cole-o na Aplicação móvel Moodle e clique em "Entrar no seu site"</li><li>Agora pode autenticar-se no seu site usando o seu nome de utilizador e senha.</li>';
$string['core.login.faqwhatisurlquestion'] = 'Qual é o endereço do meu site? Como posso encontrar o URL do meu site?';
$string['core.login.faqwhereisqrcode'] = 'Onde posso encontrar o código QR?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Se a sua organização ativou o código QR, irá aparecer um código QR na parte inferior da sua página de perfil do utilizador.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Procurar o site';
$string['core.login.helpmelogin'] = '<p>Existem muitos milhares de sites Moodle em todo o mundo. Esta aplicação só pode ligar-se a sites Moodle que ativaram especificamente o acesso a aplicações para dispositivos móveis.</p><p>Se não conseguir ligar-se ao seu site Moodle, entre em contacto com o administrador do site e peça-lhe para consultar <a href="http://docs.moodle.org/en/Mobile_app" target="_blank">http://docs.moodle.org/en/Mobile_app.</a></p><p> Para testar a aplicação num site de demonstração do Moodle digite <i>professor</i> ou <i>aluno</i> no campo <i>Endereço do site</i> e depois clique no botão <b>Ligar</b>.</p >';
$string['core.login.invalidaccount'] = 'Por favor, verifique os detalhes dos seus dados de utilizador ou peça ao administrador do site para verificar as configurações do site.';
$string['core.login.invalidmoodleversion'] = '<p>Versão inválida do site Moodle. A aplicação móvel Moodle apenas suporta sistemas Moodle {{$a}} ou superior.</p>
<p>Entre em contacto com os administradores do site e peça para atualizem o sistema Moodle.</p>
<p>Os "Administradores do site" são as pessoas que gerem o Moodle na sua escola/universidade/empresa ou organização de ensino. Se não souber como contactá-los, entre em contacto com os seus professores/formadores.</p>';
$string['core.login.invalidsite'] = 'O URL do site é inválido.';
$string['core.login.invalidtime'] = 'Hora inválida';
$string['core.login.invalidvaluemax'] = 'O valor máximo é {{$a}}';
$string['core.login.invalidvaluemin'] = 'O valor mínimo é {{$a}}';
$string['core.login.localmobileunexpectedresponse'] = 'Ocorreu um erro inesperado na verificação de Moodle Mobile Additional Features. Será autenticado através do serviço Mobile padrão.';
$string['core.login.loggedoutssodescription'] = 'Tem de autenticar-se novamente. A autenticação no site tem de ser numa janela do navegador.';
$string['core.login.loginbutton'] = 'Iniciar sessão';
$string['core.login.logininsiterequired'] = 'Precisa de entrar no site através de uma janela de navegador.';
$string['core.login.mobileservicesnotenabled'] = 'O seu site não permite acesso através da Mobile App. Por favor, contacte o administrador se pretender que esta funcionalidade seja ativada.';
$string['core.login.notloggedin'] = 'Precisa de estar autenticado.';
$string['core.login.onboardingcreatemanagecourses'] = 'Criar e gerir as suas disciplinas';
$string['core.login.onboardingenrolmanagestudents'] = 'Inscrever e gerir os seus alunos';
$string['core.login.onboardinggetstarted'] = 'Começar com o Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Eu já tenho um site Moodle';
$string['core.login.onboardingimalearner'] = 'Eu sou um aluno';
$string['core.login.onboardingimaneducator'] = 'Eu sou educador';
$string['core.login.onboardingineedasite'] = 'Eu preciso de um site Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Fornecer feedback oportuno';
$string['core.login.onboardingtoconnect'] = 'Para se ligar à aplicação Moodle, precisa de um site Moodle';
$string['core.login.onboardingwelcome'] = 'Bem-vindo à aplicação Moodle!';
$string['core.login.or'] = 'OU';
$string['core.login.passwordrequired'] = 'É necessária a senha';
$string['core.login.recaptchachallengeimage'] = 'Imagem reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'O prazo de verificação expirou. Responda novamente à pergunta de segurança.';
$string['core.login.recaptchaincorrect'] = 'A resposta à pergunta de segurança está incorreta.';
$string['core.login.reconnect'] = 'Entrar novamente';
$string['core.login.reconnectdescription'] = 'O seu token de autenticação é inválido ou expirou. Tem de entrar novamente no site.';
$string['core.login.reconnectssodescription'] = 'O seu token de autenticação é inválido ou expirou. Tem de entrar novamente no site. Precisa de autenticar-se no site através de uma janela de navegador.';
$string['core.login.searchby'] = 'Procurar por:';
$string['core.login.selectsite'] = 'Selecione o seu site:';
$string['core.login.signupplugindisabled'] = '{{$a}} não está ativado.';
$string['core.login.signuprequiredfieldnotsupported'] = 'O formulário de inscrição contém um campo personalizado obrigatório que não é compatível com a aplicação. Por favor, crie sua a conta usando um navegador web.';
$string['core.login.siteaddress'] = 'O seu site';
$string['core.login.sitehasredirect'] = 'O seu site contém pelo menos um redirecionamento de HTTP. A aplicação não pode seguir redirecionamentos. Pode ser este o problema que impede a aplicação de se ligar ao seu site.';
$string['core.login.siteinmaintenance'] = 'O seu site está em modo de manutenção';
$string['core.login.sitepolicynotagreederror'] = 'Não concordou com as políticas do site.';
$string['core.login.siteurl'] = 'URL do site';
$string['core.login.siteurlrequired'] = 'É necessário o URL do site, por exemplo <i>http://www.yourmoodlesite.org</i>';
$string['core.login.stillcantconnect'] = 'Continua com problemas na ligação?';
$string['core.login.usernamerequired'] = 'É necessário o nome de utilizador';
$string['core.login.visitchangepassword'] = 'Pretende visitar o site para alterar a senha?';
$string['core.login.webservicesnotenabled'] = 'O servidor do site talvez não tenha ativado os web services. Por favor, contacte o administrador se pretender que esta funcionalidade seja ativada.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Ainda pode ligar-se ao site digitando o seu nome de utilizador e a senha.';
$string['core.login.yourenteredsite'] = 'Ligar-se ao seu site';
$string['core.lostconnection'] = 'O seu token é inválido ou expirou. Terá de se autenticar novamente no site.';
$string['core.mainmenu.changesite'] = 'Mudar de site';
$string['core.mainmenu.website'] = 'Site';
$string['core.needhelp'] = 'Precisa de ajuda?';
$string['core.networkerroriframemsg'] = 'Este conteúdo não está disponível offline. Por favor, ligue-se à internet e tente novamente.';
$string['core.networkerrormsg'] = 'Ocorreu um erro ao ligar ao site. Por favor, verifique a sua ligação e tente novamente.';
$string['core.nooptionavailable'] = 'Nenhuma opção disponível';
$string['core.nopasswordchangeforced'] = 'Não pode prosseguir sem alterar a sua senha.';
$string['core.nopermissionerror'] = 'Desculpe, mas não tem permissões para executar esta operação';
$string['core.notapplicable'] = 'n/a';
$string['core.notsent'] = 'Não enviado';
$string['core.nummore'] = '{{$a}} mais';
$string['core.openfile'] = 'Abrir ficheiro';
$string['core.openfullimage'] = 'Clique aqui para mostrar a imagem em tamanho real';
$string['core.openinbrowser'] = 'Abrir no navegador';
$string['core.openmodinbrowser'] = 'Abrir {{$a}} no navegador';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.pulltorefresh'] = 'Puxe para atualizar';
$string['core.qrscanner'] = 'Leitor códigos QR';
$string['core.question.cannotdeterminestatus'] = 'Não é possível determinar o estado';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'O seu site ainda não oferece suporte para anexar ficheiros às respostas.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'O seu site ainda não oferece suporte à edição de ficheiros incorporados.';
$string['core.question.errorquestionnotsupported'] = 'Este tipo de pergunta não é suportado pela aplicação: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Toque para selecionar e depois toque para largar.';
$string['core.question.questionmessage'] = 'Pergunta {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Irá ser redirecionado para o site.';
$string['core.removefiles'] = 'Remover ficheiros {{$a}}';
$string['core.requireduserdatamissing'] = 'Este utilizador não possui todos os dados de perfil obrigatórios. Por favor, preencha os dados em falta no seu site e tente novamente.<br>{{$a}}';
$string['core.retry'] = 'Tentar novamente';
$string['core.scanqr'] = 'Ler código QR';
$string['core.searching'] = 'A procurar';
$string['core.settings.about'] = 'Acerca';
$string['core.settings.appsettings'] = 'Configurações da aplicação';
$string['core.settings.appversion'] = 'Versão da aplicação';
$string['core.settings.cannotsyncloggedout'] = 'Este site não pode ser sincronizado porque terminou a sua sessão/saiu. Por favor, tente novamente quando estiver autenticado no site novamente.';
$string['core.settings.cannotsyncoffline'] = 'Não é possível sincronizar offline.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Não é possível sincronizar porque as configurações atuais só permitem sincronizar quando ligado a uma rede sem fios. Por favor, ligue-se a uma rede Wi-Fi.';
$string['core.settings.colorscheme'] = 'Esquema de cores';
$string['core.settings.colorscheme-auto'] = 'Automático (basedo nas configurações do sistema)';
$string['core.settings.colorscheme-dark'] = 'Escuro';
$string['core.settings.colorscheme-light'] = 'Claro';
$string['core.settings.compilationinfo'] = 'Informação da compilação';
$string['core.settings.copyinfo'] = 'Copiar informações do dispositivo para a  área de transferência';
$string['core.settings.cordovadevicemodel'] = 'Modelo do dispositivo Cordova';
$string['core.settings.cordovadeviceosversion'] = 'Versão do OS do dispositivo Cordova';
$string['core.settings.cordovadeviceplatform'] = 'Plataforma do dispositivo Cordova';
$string['core.settings.cordovadeviceuuid'] = 'UUID do dispositivo Cordova device UUID';
$string['core.settings.cordovaversion'] = 'Versão do Cordova';
$string['core.settings.debugdisplaydescription'] = 'Se ativar esta opção, as janelas modais dos erros mostrarão mais informações sobre o erro, se for possível.';
$string['core.settings.deletesitefiles'] = 'Tem a certeza de que pretende apagar os ficheiros descarregados e os  dados guardados em cache do site \'{{sitename}}\'? Não poderá usar a aplicação no modo offline.';
$string['core.settings.deletesitefilestitle'] = 'Apagar os ficheiros do site';
$string['core.settings.deviceinfo'] = 'Informação do dispositivo';
$string['core.settings.deviceos'] = 'OS do dispositivo';
$string['core.settings.displayformat'] = 'Formato de visualização';
$string['core.settings.enabledownloadsection'] = 'Ativar secções de transferência';
$string['core.settings.enablefirebaseanalytics'] = 'Ativar a análise Firebase';
$string['core.settings.enablefirebaseanalyticsdescription'] = 'Se ativar esta opção, a aplicação guardará o uso de dados anónimos.';
$string['core.settings.enablerichtexteditor'] = 'Ativar o editor de texto';
$string['core.settings.enablerichtexteditordescription'] = 'Se ativar esta opção, um editor de texto será mostrado ao inserir conteúdos.';
$string['core.settings.enablesyncwifi'] = 'Permitir sincronização apenas através de Wi-Fi';
$string['core.settings.entriesincache'] = '{{$a}} entradas na cache';
$string['core.settings.errordeletesitefiles'] = 'Erro ao apagar os ficheiros do site.';
$string['core.settings.errorsyncsite'] = 'Erro ao sincronizar os dados do site. Por favor, verifique a sua ligação à Internet e tente novamente.';
$string['core.settings.estimatedfreespace'] = 'Espaço livre estimado';
$string['core.settings.filesystemroot'] = 'Raíz dos ficheiros do sistema';
$string['core.settings.fontsize'] = 'Tamanho do texto';
$string['core.settings.forcedsetting'] = 'Esta configuração foi forçada pela configuração do seu site.';
$string['core.settings.localnotifavailable'] = 'Notificações locais disponíveis';
$string['core.settings.locationhref'] = 'URL da vista Web';
$string['core.settings.navigatorlanguage'] = 'Idioma do navegador';
$string['core.settings.navigatoruseragent'] = 'UserAgent do navegador';
$string['core.settings.networkstatus'] = 'Estado da ligação à Internet';
$string['core.settings.opensourcelicenses'] = 'Licenças de Código Aberto';
$string['core.settings.privacypolicy'] = 'Politica de privacidade';
$string['core.settings.publisher'] = 'Editor';
$string['core.settings.pushid'] = 'Enviar ID das notificações';
$string['core.settings.reportinbackground'] = 'Reportar erros automaticamente';
$string['core.settings.screen'] = 'Informação do ecrã';
$string['core.settings.showdownloadoptions'] = 'Mostrar opções de descarga';
$string['core.settings.siteinfo'] = 'Informação do site';
$string['core.settings.spaceusage'] = 'Utilização do espaço';
$string['core.settings.spaceusagehelp'] = 'Ao apagar as informações armazenadas do site removerá todos os dados offline do site. Esta informação permite que use o aplicativo quando estiver offline.';
$string['core.settings.synchronization'] = 'Sincronização';
$string['core.settings.synchronizenow'] = 'Sincronizar agora';
$string['core.settings.synchronizenowhelp'] = 'A sincronização de um site enviará alterações pendentes e todas as atividades offline armazenadas no dispositivo e sincronizará alguns dados, como por exemplo, mensagens e notificações.';
$string['core.settings.syncsettings'] = 'Configurações da sincronização';
$string['core.settings.wificonnection'] = 'Ligação Wi-Fi';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Escolha uma conta para onde armazenar o ficheiro.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Já existe um ficheiro com este nome. Deseja substituir o ficheiro existente ou renomeá-lo para "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Não existem sites armazenados. Adicione um site antes de partilhar um ficheiro com a aplicação.';
$string['core.sharedfiles.nosharedfiles'] = 'Não existem quaisquer ficheiros partilhados armazenados neste site.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Não existem ficheiros para fazer o carregamento. Se pretender carregar um ficheiro de outra aplicação, localize o ficheiro e clique no botão \'Abrir em\'.';
$string['core.sharedfiles.rename'] = 'Mudar nome';
$string['core.sharedfiles.replace'] = 'Substituir';
$string['core.sharedfiles.sharedfiles'] = 'Ficheiros partilhados';
$string['core.sharedfiles.successstorefile'] = 'Ficheiro armazenado com sucesso. Selecione este ficheiro para enviá-lo para os seus ficheiros privados ou usá-lo em atividades.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Desculpe...';
$string['core.storingfiles'] = 'A armazenar ficheiros';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Esta área de palavras-chave não é suportada pela aplicação.';
$string['core.tag.warningareasnotsupported'] = 'Algumas das áreas de palavras-chave não são mostraas porque não são suportadas pela aplicação.';
$string['core.thereisdatatosync'] = 'Existem {{$a}} offline que têm de ser sincronizados.';
$string['core.tryagain'] = 'Tente novamente';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Ocorreu um erro!';
$string['core.unexpectederror'] = 'Erro inesperado. Por favor, feche e abra a aplicação e tente de novo.';
$string['core.unicodenotsupported'] = 'Alguns emojis não são suportados neste site. Estes caracteres serão removidos quando a mensagem for enviada.';
$string['core.unicodenotsupportedcleanerror'] = 'Foi encontrado texto vazio ao limpar caracteres Unicode.';
$string['core.unknown'] = 'Desconhecido';
$string['core.unzipping'] = 'A descompactar';
$string['core.updaterequired'] = 'É necessário atualizar a aplicação';
$string['core.updaterequireddesc'] = 'Por favor, atualize a aplicação para a versão {{$a}}';
$string['core.user.contact'] = 'Contacto';
$string['core.user.detailsnotavailable'] = 'Não tem acesso aos detalhes deste utilizador.';
$string['core.user.errorloaduser'] = 'Erro ao carregar o utilizador';
$string['core.user.sendemail'] = 'E-mail';
$string['core.viewcode'] = 'Ver código';
$string['core.vieweditor'] = 'Ver editor';
$string['core.viewembeddedcontent'] = 'Ver conteúdo incorporado';
$string['core.warningofflinedatadeleted'] = 'Os dados offline de {{component}} \'{{name}}\' foram apagados. {{error}}';
$string['core.whoissiteadmin'] = '"Administradores do Site" são os utilizadores que gerem o Moodle na sua escola/universidade/empresa ou organização de ensino. Se não souber como contactá-los, fale com os seus professores/treinadores.';
$string['core.whoops'] = 'Oops!';
$string['core.whyisthishappening'] = 'Por que é que isto está a acontecer?';
$string['core.wsfunctionnotavailable'] = 'A função do webservice não está disponível.';
$string['core.youreoffline'] = 'Está offline';
$string['core.youreonline'] = 'Está online novamente';
$string['pluginname'] = 'Strings de idioma do Moodle Mobile';
