<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'filter_filtercodes', language 'pt', version '3.8'.
 *
 * @package     filter_filtercodes
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['contentmissing'] = '<h1>Conteúdo em falta.</h1><p>Por favor, notifique o webmaster.</p>';
$string['disabled_customnav_description'] = '<strong>Nota sobre o suporte ao menu personalizado</strong> - Para ativar o suporte aos Filtro Códigos no menu personalizado do seu site Moodle, pode ser necessário personalizar o seu tema ou núcleo do Moodle. <a href="https://github.com/michael-milette/moodle-filter_filtercodes#can-i-use-filtercodes-in-moodles-custom-menus">Informações sobre como adicionar suporte ao Filtro Códigos em menus personalizados</a>.';
$string['enable_customnav'] = 'Suporte à navegação personalizada';
$string['enable_customnav_description'] = '<strong>Experimental</strong>: Ativar suporte para tags do filtro Códigos no menu de navegação personalizado do Moodle.
Nota: Sabe-se que é compatível com os temas Clean e com os temas baseados em Boost. Não filtra tags na página \'Configurações do tema\' do Moodle.';
$string['enable_scrape'] = 'Suporte à tag Scrape';
$string['enable_scrape_description'] = 'Ativar o suporte à tag Scrape (obter conteúdo de URL)';
$string['escapebraces'] = 'Ignorar tags';
$string['escapebraces_desc'] = 'Se ativar esta opção, será possível exibir as tags do Filtro Códigos sem que elas sejam interpretadas pelo filtro, se as escrever entre [parênteses retos]. Pode ser muito útil ao criar a documentação do Filtro Códigos para os professores e criadores de disciplinas no seu site Moodle.<br><br>Exemplo: [{fullname}] não mostrará o nome completo do utilizador, mas exibirá a tag {fullname} sem os parênteses.';
$string['filtername'] = 'Filtro Códigos';
$string['formcheckin'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf check-in">
    <fieldset>
        <input type="hidden" id="subject" name="subject" value="Presente!">
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Estou aqui!">
    </div>
</form>';
$string['formcontactus'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf contact-us">
    <fieldset>
        <div class="form-group">
            <label for="name" id="namelabel" class="d-block">Nome <strong class="required">(required)</strong></label>
            <input id="name" name="name" type="text" size="57" maxlength="45" pattern="[A-zÀ-ž]([A-zÀ-ž\\s]){2,}"
                    title="Mínimo 3 letras/espaços." required="required" {readonly} value="{fullname}">
        </div>
        <div class="form-group">
            <label for="email" id="emaillabel" class="d-block">E-mail <strong class="required">(required)</strong></label>
            <input id="email" name="email" type="email" size="57" maxlength="60"
                    required="required" {readonly} value="{email}">
        </div>
        <div class="form-group">
            <label for="subject" id="subjectlabel" class="d-block">Assunto <strong class="required">(required)</strong></label>
            <input id="subject" name="subject" type="text" size="57" maxlength="80" minlength="5"
                    title="Mínimo 5 caracteres." required="required">
        </div>
        <div class="form-group">
            <label for="message" id="messagelabel" class="d-block">Mensagem <strong class="required">(required)</strong></label>
            <textarea id="message" name="message" rows="5" cols="58" minlength="5"
                    title="Mínimo 5 caracteres." required="required"></textarea>
        </div>
        <div class="form-group">
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
        {recaptcha}
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Enviar">
    </div>
</form>';
$string['formcourserequest'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf new-course-request">
    <fieldset>
        <div class="form-group">
            <label for="name" id="namelabel" class="d-block">Nome <strong class="required">(required)</strong></label>
            <input id="name" name="name" type="text" size="57" maxlength="45" pattern="[A-zÀ-ž]([A-zÀ-ž\\s]){2,}"
                    title="Mínimo 3 letras/espaços." required="required" {readonly} value="{fullname}">
        </div>
        <div class="form-group">
            <label for="email" id="emaillabel" class="d-block">E-mail <strong class="required">(required)</strong></label>
            <input id="email" name="email" type="email" size="57" maxlength="60" required="required" {readonly} value="{email}">
        </div>
        <div class="form-group">
            <label for="new_course_name" id="new_course_namelabel" class="d-block">Nome proposto para a nova disciplina <strong class="required">(required)</strong></label>
            <input id="new_course_name" name="new_course_name" type="text" size="57" maxlength="80" minlength="5"
                    title="Mínimo 5 caracteres." required="required">
        </div>
        <div class="form-group">
            <label for="description" id="descriptionlabel" class="d-block">Descrição da disciplina <strong class="required">(required)</strong></label>
            <textarea id="description" name="description" rows="5" cols="58" minlength="5"
                    title="Mínimo 5 caracteres." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Enviar solicitação para esta disciplina">
    </div>
</form>';
$string['formquickquestion'] = '<fieldset>
    <div class="form-group">
        <label for="subject" id="subjectlabel" class="d-block">Assunto <strong class="required">(required)</strong></label>
        <input class="block" id="subject" name="subject" type="text" size="57" maxlength="80" minlength="5"
                title="Mínimo 5 caracteres." required="required">
    </div>
    <div class="form-group">
        <label for="message" id="messagelabel" class="d-block">Mensagem <strong class="required">(required)</strong></label>
        <textarea id="message" name="message" rows="5" cols="58" minlength="5"
                title="Mínimo 5 caracteres." required="required"></textarea>
    </div>
    <input type="hidden" id="sesskey" name="sesskey" value="">
    <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
</fieldset>
<div>
    <input type="submit" name="submit" id="submit" value="Enviar">
</div>';
$string['formsupport'] = '<form action="{wwwroot}/local/contact/index.php" method="post" class="cf support-request">
    <fieldset>
        <div class="form-group">
            <label for="name" id="namelabel" class="d-block">Nome <strong class="required">(required)</strong></label>
            <input id="name" name="name" type="text" size="57" maxlength="45" pattern="[A-zÀ-ž]([A-zÀ-ž\\s]){2,}"
                    title="Mínimo 3 letras/espaços." required="required" {readonly} value="{fullname}">
        </div>
        <div class="form-group">
            <label for="email" id="emaillabel" class="d-block">E-mail <strong class="required">(required)</strong></label>
            <input id="email" name="email" type="email" size="57" maxlength="60" required="required" {readonly} value="{email}">
        </div>
        <div class="form-group">
            <label for="subject" id="subjectlabel" class="d-block">Assunto <strong class="required">(required)</strong></label>
            <select id="subject" name="subject" required="required">
                <option label="Escolha o assunto"></option>
                <option>Não consigo alterar a minha senha</option>
                <option>Não consigo autenticar-me</option>
                <option value="Sugestão">Tenho uma sugestão</option>
                <option value="Mensagem de erro">Apareceu uma mensagem de erro</option>
                <option value="Erro do sistema">Funcionamento anormal</option>
                <option value="Disciplina">Dificuldades para aceder a uma disciplina ou a algum conteúdo da disciplina</option>
                <option value="Outro motivo">Outro (especifique)</option>
            </select>
        </div>
        <div class="form-group">
            <label for="specific_subject" id="specifylabel" class="d-block">Assunto específico ou o nome da disciplina&nbsp;<strong class="required">(required)</strong></label>
            <input type="text" id="specific_subject" name="specific_subject" size="57" maxlength="80" required="required">
        </div>
        <div class="form-group">
            <label for="url" id="urllabel" class="d-block">Especifique o endereço URL</label>
            <input type="url" id="url" name="url" size="57" maxlength="80" value="{referer}">
        </div>
        <div class="form-group">
            <label for="description" id="descriptionlabel" class="d-block">Descrição e detalhes passo a passo sobre como reproduzir o problema&nbsp;<strong class="required">(required)</strong></label>
            <textarea id="description" name="description" rows="5" cols="58" minlength="5"
                    title="Mínimo 5 caracteres." required="required"></textarea>
        </div>
        <input type="hidden" id="sesskey" name="sesskey" value="">
        <script>document.getElementById("sesskey").value = M.cfg.sesskey;</script>
    </fieldset>
    <div>
        <input type="submit" name="submit" id="submit" value="Enviar pedido de ajuda">
    </div>
</form>';
$string['pluginname'] = 'Filtro Códigos';
$string['privacy:metadata'] = 'O módulo Filtro Códigos não armazena dados pessoais dos utilizadores.';
