<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'it', version '3.8'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Attività';
$string['addcategory'] = 'Aggiungi categoria';
$string['addcategoryerror'] = 'Non è stato possibile aggiungere la categoria';
$string['addexceptionerror'] = 'Si è verificato un errore aggiungendo un eccezione per userid:gradeitem';
$string['addfeedback'] = 'Aggiungi feedback';
$string['addgradeletter'] = 'Aggiungi graduatoria letterale';
$string['addidnumbers'] = 'Aggiungi codici identificativi';
$string['additem'] = 'Aggiungi elemento di valutazione';
$string['additionalfeedback'] = 'Feedback aggiuntivo';
$string['addoutcome'] = 'Aggiungi un obiettivo';
$string['addoutcomeitem'] = 'Aggiungi elemento raggiungimento obiettivo';
$string['addscale'] = 'Aggiungi una scala';
$string['adjustedweight'] = 'Peso adattato';
$string['aggregateextracreditmean'] = 'Voto medio (con crediti extra)';
$string['aggregatemax'] = 'Voto più alto';
$string['aggregatemean'] = 'Media dei voti';
$string['aggregatemedian'] = 'Mediana dei voti';
$string['aggregatemin'] = 'Voto più basso';
$string['aggregatemode'] = 'Moda dei voti';
$string['aggregatenotonlygraded'] = 'Includi valutazioni mancanti';
$string['aggregateonlygraded'] = 'Escludi i voti mancanti';
$string['aggregateonlygraded_help'] = '<p>I voti non ancora ricevuti possono essere aggregati considerandoli come voto minimo oppure possono essere ignorati durante l\'aggregazione.</p>';
$string['aggregateoutcomes'] = 'Aggrega gli obiettivi';
$string['aggregateoutcomes_help'] = 'E\' possibile includere gli obiettivi nella aggregazione dei voti ma i totali calcolati potrebbero essere non congruenti.';
$string['aggregatesonly'] = 'Solo l\'aggregazione delle valutazioni';
$string['aggregatesubcatsupgradedgrades'] = 'Nota: per effetto dell\'aggiornamento del sito, l\'impostazione "Aggrega includendo le sotto categorie" è stata rimossa. Poiché questo corso utilizzava l\'impostazione "Aggrega includendo le sotto categorie", si raccomanda di verificare le variazioni nel registro valutatore.';
$string['aggregatesum'] = 'Naturale';
$string['aggregateweightedmean'] = 'Media ponderata dei voti';
$string['aggregateweightedmean2'] = 'Media ponderata semplice dei voti';
$string['aggregation'] = 'Aggregazione dei voti';
$string['aggregation_help'] = 'L\'aggregazione determina la modalità di calcolo della valutazione complessiva per una data categoria.

* Media dei voti - La somma di tutti i voti divisa per il numero totale di voti.
* Mediana dei voti - La mediana è calcolata mettendo in ordine tutti i voti e selezionando quello che si trova a metà
* Voto più basso
* Voto più alto
* Moda dei voti - il voto ottenuto più frequentemente
* Naturale . La somma di tutti i voti scalati da un peso.';
$string['aggregationcoef'] = 'Coefficiente di aggregazione';
$string['aggregationcoefextra'] = 'Credito extra';
$string['aggregationcoefextra_help'] = 'Se l\'aggregazione è \'Naturale\' oppure \'Media pesata semplice\' e la casella credito extra è spuntata, allora il punteggio massimo dell\'elemento non sarà aggiunto al massimo punteggio della categoria. Questo comporterà la possibilità di ottenere il punteggio massimo per la categoria senza aver ottenuto il punteggio massimo in tutti gli elementi di valutazione. Se l\'amministratore del sito ha abilitato la funzionalità \'Voti privi di limiti\', potranno essere presenti punteggi superiori al punteggio massimo. Se l\'aggregazione è \'Media dei voti (con crediti extra)\' ed il credito extra ha un valore maggiore di zero, il credito extra sarà il valore per il quale sarà moltiplicato il punteggio prima di essere aggiunto al totale e dopo il calcolo della media.';
$string['aggregationcoefextrasum'] = 'Credito extra';
$string['aggregationcoefextrasum_help'] = 'Selezionando "Credito extra", il punteggio massimo dell\'elemento di valutazione non sarà sommato al punteggio massimo della categoria, rendendo possibile il raggiungimento del punteggio massimo della categoria (o il voto privo di limiti se la funzione è stata abilitata dall\'amministratore) senza aver ottenuto il punteggio massimo in tutti gli elementi di valutazione.';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Peso credito extra';
$string['aggregationcoefextraweight_help'] = 'Se il credito extra è un valore maggiore di zero, la valutazione fungerà da credito extra durante l\'aggregazione. Il numero rappresenta il fattore per il quale sarà moltiplicata la valutazione prima di essere aggiunta al totale utilizzato per il calcolo della media.';
$string['aggregationcoefweight'] = 'Peso dell\'elemento';
$string['aggregationcoefweight_help'] = '<p>Peso applicato ai voti durante l\'aggregazione.</p>';
$string['aggregationhintdropped'] = '( Tralasciato )';
$string['aggregationhintexcluded'] = '( Escluso )';
$string['aggregationhintextra'] = '( Credito extra )';
$string['aggregationhintnovalue'] = '( Vuoto )';
$string['aggregationofa'] = 'Aggregazione di {$a}';
$string['aggregationposition'] = 'Posizione colonna aggregazione dei voti';
$string['aggregationposition_help'] = 'Consente di impostare la posizione della colonna contenente l\'aggregazione dei voti, all\'inizio oppure alla fine del registro valutatore.';
$string['aggregationsvisible'] = 'Tipi di aggregazione disponibili';
$string['aggregationsvisiblehelp'] = 'Selezionate tutti i tipi di aggregazione che saranno disponibili nel registro valutatore. Per selezionarne più di una, fate click con il mouse tenendo premuto il tasto Ctrl.';
$string['allgrades'] = 'Valutazioni per categoria';
$string['allstudents'] = 'Tutti gli studenti';
$string['allusers'] = 'Tutti gli utenti';
$string['autosort'] = 'Ordina automaticamente';
$string['availableidnumbers'] = 'Codici identificativi disponibili';
$string['average'] = 'Media';
$string['averagesdecimalpoints'] = 'Decimali nelle media di colonna';
$string['averagesdecimalpoints_help'] = 'Imposta il numero di cifre decimali da usare nella visualizzazione delle medie di colonna. Selezioando Eredita, verrà utilizzato il numero di decimali già impostato per ciascuna colonna.';
$string['averagesdisplaytype'] = 'Visualizza le medie di colonna come';
$string['averagesdisplaytype_help'] = 'Imposta il tipo di visualizzazione delle media di colonna. Selezionando Eredita, verrà utilizzato il tipo di visualizzazione già impostata per ciascuna colonna.';
$string['backupwithoutgradebook'] = 'Il backup non contiene la configurazione del registro valutatore';
$string['badgrade'] = 'Il voto inserito non è valido';
$string['badlyformattedscale'] = 'Per favore inserisci un elenco separato da virgole (sono necessari almeno due elementi)';
$string['baduser'] = 'L\'utente fornito non è valido';
$string['bonuspoints'] = 'Punti bonus';
$string['bulkcheckboxes'] = 'Selezioni in blocco';
$string['calculatedgrade'] = 'Voto calcolato';
$string['calculation'] = 'Calcolo';
$string['calculation_help'] = 'Il calcolo delle valutazioni consente l\'aggregazione dei voti in base ad una formula. La formula deve iniziare con un segno uguale (=) e può usare i normali operatori matematici come max, min e sum. E\' anche possibile inserire ulteriori elementi di valutazione referenziandoli nella formula racchiudendo il loro codice identificativo tra doppie parentesi quadre.';
$string['calculationadd'] = 'Aggiungi calcolo';
$string['calculationedit'] = 'Modifica calcolo';
$string['calculationsaved'] = 'Calcolo salvato';
$string['calculationview'] = 'Visualizza calcolo';
$string['cannotaccessgroup'] = 'Spiacente, non è possibile accedere ai voti del gruppo selezionato.';
$string['categories'] = 'Categorie';
$string['category'] = 'Categoria';
$string['categoryedit'] = 'Modifica categoria';
$string['categoryname'] = 'Nome categoria';
$string['categorytotal'] = 'Totale categoria';
$string['categorytotalfull'] = 'Totale {$a->category}';
$string['categorytotalname'] = 'Nome del totale di categoria';
$string['changedefaults'] = 'Cambia default';
$string['changereportdefaults'] = 'Cambia default dei report';
$string['chooseaction'] = 'Scegli un\'azione ...';
$string['choosecategory'] = 'Scegli categoria';
$string['combo'] = 'Schede e menù a discesa';
$string['compact'] = 'Compatto';
$string['componentcontrolsvisibility'] = 'La visibilità di questo elemento di valutazione è regolata dalle impostazioni dell\'attività.';
$string['contract'] = 'Minimizza categoria';
$string['contributiontocoursetotal'] = 'Quota di contribuzione sul totale del corso';
$string['controls'] = 'Controlli';
$string['courseavg'] = 'Media del corso';
$string['coursegradecategory'] = 'Valutazione di corso';
$string['coursegradedisplaytype'] = 'Tipo visualizzazione valutazioni del corso';
$string['coursegradedisplayupdated'] = 'Il tipo di visualizzazione delle valutazioni nei corsi';
$string['coursegradesettings'] = 'Impostazioni registro del corso';
$string['coursename'] = 'Titolo del corso';
$string['coursescales'] = 'Scale del corso';
$string['coursesettings'] = 'Impostazioni corso';
$string['coursesettingsexplanation'] = 'Le impostazioni del corso stabiliscono in quale modo apparirà ai partecipanti il registro valutatore .';
$string['coursesiamtaking'] = 'Corsi dove sono partecipante';
$string['coursesiamteaching'] = 'Corsi dove sono docente';
$string['coursetotal'] = 'Totale corso';
$string['createcategory'] = 'Crea Categoria';
$string['createcategoryerror'] = 'Non si può creare una nuova categoria';
$string['creatinggradebooksettings'] = 'Impostazioni creazione registro valutatore';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Aggregazione in uso nella categoria genitore';
$string['curveto'] = 'Trasforma in';
$string['decimalpoints'] = 'Cifre decimali';
$string['decimalpoints_help'] = 'Il numero di cifre decimali visualizzate nei voti. L\'impostazione non influenza come vengono effettuati i calcoli, per i quali si usa sempre una precisione a 5 cifre decimali.';
$string['default'] = 'Default';
$string['defaultprev'] = 'Default ({$a})';
$string['deletecategory'] = 'Elimina categoria';
$string['disablegradehistory'] = 'Disabilita storico delle valutazioni';
$string['disablegradehistory_help'] = 'Disabilita la registrazione storica delle modifiche nelle tabelle relative alle valutazioni. Questo può velocizzare un po\' il server e risparmiare spazio nel database.';
$string['displaylettergrade'] = 'Visualizza graduatoria letterale';
$string['displaypercent'] = 'Visualizza percentuali';
$string['displaypoints'] = 'Visualizza punteggi';
$string['displayweighted'] = 'Visualizza valutazioni pesate';
$string['dropdown'] = 'Menu a discesa';
$string['droplow'] = 'Scarta voti peggiori';
$string['droplow_help'] = 'Consente di scartare il numero specificato di voti più bassi.';
$string['droplowestvalue'] = 'Valore per scartare voti peggiori';
$string['droplowestvalues'] = 'Scarta {$a} voti peggiori';
$string['dropped'] = 'Scartati';
$string['dropxlowest'] = 'Scarta le N più basse';
$string['dropxlowestwarning'] = 'Nota: Se si utilizza Scarta le N più basse, la valutazione assume che tutte gli elementi della corrispondente categoria hanno lo stesso valore per i punteggi. Se tali valori differiscono i risultati saranno imprevedibili';
$string['duplicatescale'] = 'Duplica scala';
$string['edit'] = 'Modifica';
$string['editcalculation'] = 'Modifica Calcolo';
$string['editcalculationverbose'] = 'Modifica calcolo per {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Modifica feedback';
$string['editgrade'] = 'Modifica voto';
$string['editgradeletters'] = 'Modifica graduatorie letterali';
$string['editoutcome'] = 'Modifica obiettivo';
$string['editoutcomes'] = 'Modifica obiettivi';
$string['editscale'] = 'Modifica scala';
$string['edittree'] = 'Impostazioni';
$string['editverbose'] = 'Modifica {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Abilita AJAX';
$string['enableajax_help'] = 'Abilita AJAX nel registro valutatore, semplificando e accelerando le operazioni più comuni. E\' necessario che il browser dell\'utente supporti JavaScript.';
$string['enableoutcomes'] = 'Abilita obiettivi';
$string['enableoutcomes_help'] = 'L\'abilitazione degli obiettivi rende possibile la valutazione con scale.';
$string['encoding'] = 'Codifica';
$string['encoding_help'] = 'Seleziona la codifica dei caratteri dei dati (la codifica standard è UTF-8). Se viene selezionata una codifica errata, il problema sarà visibile durante l\'anteprima.';
$string['errorcalculationbroken'] = 'Possibile presenza di riferimento circolare o formula di calcolo errata.';
$string['errorcalculationnoequal'] = 'La formula deve iniziare col segno uguale (=1+2)';
$string['errorcalculationunknown'] = 'Formula non valida';
$string['errorgradevaluenonnumeric'] = 'E\' stato inserito un valore non numerico come voto più basso o più alto in';
$string['errornocalculationallowed'] = 'Questo elemento non consente l\'uso di calcoli';
$string['errornocategorisedid'] = 'Non è stato possibile ottenere un id senza categoria!';
$string['errornocourse'] = 'Non è stato possibile ottenere informazioni sul corso';
$string['errorreprintheadersnonnumeric'] = 'E\' stato ricevuto un valore non numerico per reprint-headers';
$string['errorsavegrade'] = 'Non è stato possibile salvare il voto.';
$string['errorsettinggrade'] = 'Errore durante il salvataggio della valutazione "{$a->itemname}" per l\'userid {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Errore durante l\'aggiornamento dell\'impostazione "Aggrega solo i voti ricevuti" nella categoria ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Errore durante l\'aggiornamento dell\'impostazione "Aggrega gli obiettivi" nella categoria ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Errore durante l\'aggiornamento del tipo di aggregazione nella categoria ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Errore durante l\'aggiornamento del coefficiente di aggregazione (peso o credito extra) nella categoria ID {$a->id}';
$string['eventgradedeleted'] = 'Eliminata valutazione';
$string['eventgradeitemcreated'] = 'Creato elemento di valutazione';
$string['eventgradeitemupdated'] = 'Aggiornato elemento di valutazione';
$string['eventgradelettercreated'] = 'Creata graduatoria letterale';
$string['eventgradeletterdeleted'] = 'Eliminata graduatoria letterale';
$string['eventgradeletterupdated'] = 'Aggiornata graduatoria letterale';
$string['eventgradeviewed'] = 'Visualizzate valutazioni nel registro valutatore';
$string['eventscalecreated'] = 'Creata scala';
$string['eventscaledeleted'] = 'Eliminata scala';
$string['eventscaleupdated'] = 'Aggiornata scala';
$string['eventusergraded'] = 'Valutato utente';
$string['excluded'] = 'Escluso';
$string['excluded_help'] = 'Il voto sarà escluso da tutte le aggregazioni.';
$string['expand'] = 'Espandi categoria';
$string['export'] = 'Esporta';
$string['exportalloutcomes'] = 'Esporta tutti gli obiettivi';
$string['exportfeedback'] = 'Includi feedback';
$string['exportfeedback_desc'] = 'E\' possibile eseguire variazioni durante l\'esportazione.';
$string['exportformatoptions'] = 'Opzioni formati di esportazione';
$string['exportonlyactive'] = 'Escludi iscrizioni sospese';
$string['exportonlyactive_help'] = 'Nell\'esportazione saranno esclusi gli studenti la cui iscrizione risulti sospesa.';
$string['exportplugins'] = 'Plugin esportazione';
$string['exportsettings'] = 'Impostazioni esportazione';
$string['exportto'] = 'Esporta in';
$string['externalurl'] = 'URL esterna';
$string['externalurl_desc'] = 'Specificare qui l\'URL nel caso in cui si utilizzi un registro valutatore esterno.';
$string['extracreditvalue'] = 'Credito extra per {$a}';
$string['extracreditwarning'] = 'Nota: L\'impostazione Credito Extra per tutte gli elementi di una categoria di fatto rimuove gli stessi dal calcolo della valutazione, per cui non ci sarà  il punteggio totale.';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Consente di aggiungere commenti al voto.';
$string['feedbackadd'] = 'Aggiungi feedback';
$string['feedbackedit'] = 'Modifica feedback';
$string['feedbackfiles'] = 'File di feedback';
$string['feedbackforgradeitems'] = 'Feedback per {$a}';
$string['feedbacks'] = 'Feedback';
$string['feedbacksaved'] = 'Feedback salvato';
$string['feedbackview'] = 'Vedi feedback';
$string['finalgrade'] = 'Valutazione finale';
$string['finalgrade_help'] = 'La valutazione finale ricavata al termine di tutti i calcoli.';
$string['fixedstudents'] = 'Colonna studenti bloccata';
$string['fixedstudents_help'] = 'Blocca la posizione della colonna contenente i nomi degli studenti mentre si scorre orizzontalmente il registro valutatore.';
$string['forceimport'] = 'Forza importazione';
$string['forceimport_help'] = 'Forza l\'importazione delle valutazioni anche nel caso in cui le valutazioni siano state aggiornate dopo l\'importazione';
$string['forceoff'] = 'Forza: Disattivo';
$string['forceon'] = 'Forza: Attivo';
$string['forelementtypes'] = 'per il {$a} selezionato';
$string['forstudents'] = 'Per studenti';
$string['full'] = 'Tutte le colonne';
$string['fullmode'] = 'Cambia in vista completa';
$string['generalsettings'] = 'Impostazioni generali';
$string['grade'] = 'Valutazione';
$string['grade_help'] = 'Il punteggio da dare allo studente per il suo lavoro.';
$string['gradeadministration'] = 'Gestione valutazioni';
$string['gradealreadyupdated'] = 'Le valutazioni di {$a} non sono state importate poiché le valutazioni contenute nel file di importazione sono più vecchie di quelle presenti nel registro valutatore. Per importare comunque le valutazioni, usare l\'impostazione "Forza importazione".';
$string['gradeanalysis'] = 'Analisi delle valutazioni';
$string['gradebook'] = 'Registro valutatore';
$string['gradebookcalculationsfixbutton'] = 'Accetta le modifiche alle valutazione e risolvi gli errori di calcolo';
$string['gradebookcalculationsuptodate'] = 'I calcoli nel registro valutatore sono aggiornati. Per visualizzare i cambiamenti, ricaricare la pagaina.';
$string['gradebookcalculationswarning'] = 'Nota: sono stati rilevati degli errori nei calcoli delle valutazioni visualizzate nel registro valutatore. Se il tuo corso non è iniziato o è in svolgimento, si raccomanda di rimuovere gli errori cliccando sul pulsante sottostante, cosa che tuttavia comporterà variazioni nelle valutazioni. Qualora il corso sia già terminato, allora può non essere necessario correggere le valutazioni.

Per ulteriori informazioni sulle modifiche tra la versione {$a->gradebookversion} e {$a->currentversion}. <a href="{$a->url}">Gradebook calculation changes</a>.';
$string['gradebookhiddenerror'] = 'Al momento il registro è impostato in modo da non visualizzare nessun elemento agli studenti.';
$string['gradebookhistories'] = 'Storico delle valutazioni';
$string['gradebooksetup'] = 'Impostazione registro valutatore';
$string['gradeboundary'] = 'Soglia per il livello';
$string['gradeboundary_help'] = 'Limite percentuale della valutazione al di sopra del quale verrà assegnato il corrispondente livello di graduatoria letterale.';
$string['gradecategories'] = 'Categorie valutazione';
$string['gradecategory'] = 'Categoria valutazione';
$string['gradecategoryonmodform'] = 'Categoria della valutazione';
$string['gradecategoryonmodform_help'] = 'Imposta la categoria del registro valutatore nella quale comparirà la valutazione dell\'attività.';
$string['gradecategorysettings'] = 'Impostazioni categorie';
$string['gradedisplay'] = 'Visualizzazione della valutazione';
$string['gradedisplaytype'] = 'Visualizza i voti come';
$string['gradedisplaytype_help'] = 'Imposta la modalità di visualizzazione delle valutazioni nel registro valutatore e nella scheda individuale

* Graduatoria letterale - lettere o parole che rappresentano un intervallo di valutazioni, come impostato nel registro delle valutazioni
* Percentuale - Relativo al valore minimo o massimo
* Reale - i valori reali dei voti o della scala';
$string['gradedon'] = 'Valutato: {$a}';
$string['gradeexport'] = 'Esportazione valutazioni';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Campi personalizzati da esportare con le valutazioni';
$string['gradeexportcustomprofilefields_desc'] = 'Imposta i campi personalizzati del profilo utente da includere quando si esportano le valutazioni. Inserire l\'elenco dei campi personalizzati separati da virgola.';
$string['gradeexportdecimalpoints'] = 'Cifre decimali da usare nelle esportazioni delle valutazioni';
$string['gradeexportdecimalpoints_desc'] = 'Numero di cifre decimali da utilizzare nelle esportazioni. L\'impostazione può essere modificata durante l\'esportazione.';
$string['gradeexportdisplaytype'] = 'Esporta i voti come';
$string['gradeexportdisplaytype_desc'] = 'I voti possono essere esportati come punteggio, come percentuali (in riferimento alla valutazione minima e massima) o come graduatoria letterale (A, B, C, ecc.). Questa impostazione può essere modificata quando si configura l\'esportazione.';
$string['gradeexportdisplaytypes'] = 'Esporta i voti come';
$string['gradeexportuserprofilefields'] = 'Campi profilo utente da esportare con le valutazioni';
$string['gradeexportuserprofilefields_desc'] = 'Imposta i campi del profilo utente da includere quando si esportano le valutazioni. Inserire l\'elenco dei campi personalizzati separati da virgola.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Valutazione minima e massima iniziale';
$string['gradehelp'] = 'Help valutazioni';
$string['gradehistorylifetime'] = 'Durata storico delle valutazioni';
$string['gradehistorylifetime_help'] = 'Specifica per quanto tempo si vuole conservare lo storico delle modifiche nelle tabelle relative alle valutazioni. Si raccomanda di definire un tempo più lungo possibile. Se si manifestano problemi di performance o si dispone di spazio limitato per il database, impostare un valore più basso.';
$string['gradeimport'] = 'Importazione valutazioni';
$string['gradeimportfailed'] = 'Errore durante l\'importazione delle valutazioni. Dettagli:';
$string['gradeitem'] = 'Elemento di valutazione';
$string['gradeitemaddusers'] = 'Escludi dalla valutazione';
$string['gradeitemadvanced'] = 'Impostazioni avanzate degli elementi di valutazione';
$string['gradeitemadvanced_help'] = 'Selezionare le proprietà degli elementi di valutazione che desiderate considerare come \'impostazioni avanzate\' nella schermata di modifica degli elementi stessi.';
$string['gradeitemislocked'] = 'Questa attività risulta bloccata nel registro valutatore. Le modifiche apportate alle valutazioni di questa attività non saranno riportate nel registro valutatore finché l\'attività non sarà sbloccata.';
$string['gradeitemlocked'] = 'Valutazione bloccata';
$string['gradeitemmembersselected'] = 'Esclusi dalle valutazioni';
$string['gradeitemminmax'] = 'Valutazione minima e massima specificata nelle impostazioni dell\'elemento di valutazione';
$string['gradeitemnonmembers'] = 'Inclusi nelle valutazioni';
$string['gradeitemremovemembers'] = 'Includi nelle valutazioni';
$string['gradeitems'] = 'Elementi valutazione';
$string['gradeitemsettings'] = 'Impostazioni elementi';
$string['gradeitemsinc'] = 'Elementi valutazione da includere';
$string['gradeletter'] = 'Livello';
$string['gradeletter_help'] = '<p>Espressione alfanumerica che rappresenta un dato livello di valutazione.</p>';
$string['gradeletternote'] = 'Per eliminare una graduatoria letterale eliminare il contenuto di <br /> una delle tre aree di testo e salvare le modifiche.';
$string['gradeletteroverridden'] = 'Le graduatorie letterali di default risultano modificate.';
$string['gradeletters'] = 'Graduatoria letterale';
$string['gradelocked'] = 'La valutazione è bloccata';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Voto massimo';
$string['grademax_help'] = '<p>Scegliendo il Tipo di Valutazione \'Valore\', tramite questa impostazione è possibile impostare il Voto massimo. Il voto massimo di un elemento di valutazione basato su una attività si imposta nella pagina di modifica dell\'attività.</p>';
$string['grademin'] = 'Voto minimo';
$string['grademin_help'] = '<p>Scegliendo il Tipo di Valutazione \'Valore\', tramite questa impostazione è possibile impostare il Voto minimo.</p>';
$string['gradenotificationsubject'] = 'Si stato valutato';
$string['gradeoutcomeitem'] = 'Elemento raggiungimento obiettivo';
$string['gradeoutcomes'] = 'Obiettivi';
$string['gradeoutcomescourses'] = 'Obiettivi di corso';
$string['gradepass'] = 'Sufficienza';
$string['gradepass_help'] = 'Rappresenta il voto minimo necessario per considerare l\'attività come superata. Questo voto sarà utilizzato per il completamento delle attività e dei corsi. Nel registro valutatore il voto sarà visualizzato in rosso (non superato) o verde (superato)';
$string['gradepassgreaterthangrade'] = 'La sufficienza non può essere maggiore del punteggio massimo {$a}';
$string['gradepointdefault'] = 'Punteggio di default';
$string['gradepointdefault_help'] = 'Imposta il valore di default per il punteggio delle attività disponibile in un elemento di valutazione.';
$string['gradepointdefault_validateerror'] = 'Il valore impostabile deve essere compreso tra 1 e il valore del punteggio massimo.';
$string['gradepointmax'] = 'Punteggio massimo';
$string['gradepointmax_help'] = 'Imposta il valore massimo del punteggio delle attività';
$string['gradepointmax_validateerror'] = 'Il valore impostabile deve essere compreso tra 1 e 10000.';
$string['gradepreferences'] = 'Preferenze valutazioni';
$string['gradepreferenceshelp'] = 'Help Preferenze nelle valutazioni';
$string['gradepublishing'] = 'Abilita pubblicazione';
$string['gradepublishing_help'] = 'Abilitando la pubblicazione è possibile importare ed esportare le valutazioni accedendo ad una URL, senza la necessità di eseguire il login nel sito. Le valutazioni pubblicate possono essere importate accedendo direttamente alla URL consentendo ad altri siti (ad esempio un altro sito Moodle) di importare le valutazioni da questo sito. Di default solo gli amministratori possono abilitare questa funzione: è bene informare adeguatamente i vostri utenti prima di confere loro i privilegi necessari alla pubblicazione delle valutazioni in quanto si corrono dei rischi se questa funzione viene usata in modo improprio (bookmark sharing e acceleratori download, restrizioni IP, ecc.).';
$string['gradepublishinglink'] = 'Scarica: {$a}';
$string['gradereport'] = 'Report valutazioni';
$string['graderreport'] = 'Registro valutatore';
$string['grades'] = 'Valutazioni';
$string['gradesforuser'] = 'Voti di {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Attenzione: l\'eliminazione dell\'attività è in corso, le valutazioni stanno per essere eliminate.';
$string['gradesmoduledeletionprefix'] = '[Eliminazione in corso]';
$string['gradesonly'] = 'Solo le valutazioni';
$string['gradessettings'] = 'Impostazioni generali';
$string['gradetype'] = 'Tipo valutazione';
$string['gradetype_help'] = '<p>Specifica il tipo di valutazione da usare: Nessuno (non è possibile dare un voto), Valore (consente l\'impostazione del Voto massimo e minimo), Scala (consente l\'uso di una scala di valutazione), Testo (consente solo l\'uso dei feedback). Solamente i tipi Valore e Scala possono essere aggregati. Il tipo di valutazione per un elemento basato su un\'attività si imposta nella pagina di modifica dell\'attività.</p>';
$string['gradevaluetoobig'] = 'Un voto è più grande del voto massimo consentito {$a}';
$string['gradeview'] = 'Visualizza valutazione';
$string['gradewasmodifiedduringediting'] = 'La valutazione inserita per {$a->itemname} e riferita a {$a->username}, è stata ignorata poiché è stata aggiornata da altri più recentemente.';
$string['gradeweighthelp'] = 'Help peso valutazioni';
$string['gradingmodulename'] = 'Valutazione ({$a})';
$string['groupavg'] = 'Media di gruppo';
$string['hidden'] = 'Nascosto';
$string['hidden_help'] = 'I voti saranno invisibili agli studenti. E\' anche possibile indicare una data dopo la quale gli studenti potranno visualizzare i voti.';
$string['hiddenasdate'] = 'Visualizza la data dei voti nascosti';
$string['hiddenasdate_help'] = 'Se l\'utente non è autorizzato a vedere i voti nascosti, tramite questa impostazione potrà comunque vedere la data in cui ha ricevuto il voto.';
$string['hiddenuntil'] = 'Nascosto fino al';
$string['hiddenuntildate'] = 'Nascosto fino al: {$a}';
$string['hideadvanced'] = 'Nascondi opzioni avanzate';
$string['hideaverages'] = 'Nascondi medie di colonna';
$string['hidecalculations'] = 'Nascondi calcolatrice';
$string['hidecategory'] = 'Nascosta';
$string['hideeyecons'] = 'Nascondi icona visibilità';
$string['hidefeedback'] = 'Nascondi feedback';
$string['hideforcedsettings'] = 'Nascondi impostazioni forzate';
$string['hideforcedsettings_help'] = 'Le impostazioni forzate non saranno visualizzate nella interfaccia del registro valutatore';
$string['hidegroups'] = 'Nascondi gruppi';
$string['hidelocks'] = 'Nascondi icona blocca/sblocca';
$string['hidenooutcomes'] = 'Visualizza obiettivi';
$string['hidequickfeedback'] = 'Nascondi feedback rapido';
$string['hideranges'] = 'Nascondi intervalli';
$string['hidetotalifhiddenitems'] = 'Nasconde i totali se contengono elementi nascosti';
$string['hidetotalifhiddenitems_help'] = 'L\'impostazione determina come saranno visualizzati agli studenti i totali che aggregano voti nascosti, sostituiti con un meno (-) o visualizzati. Se  saranno visualizzati, il totale potrà aggregare i voti nascosti oppure no.

Se i voti nascosti non vengono aggregati, i totali visibili agli studenti potranno essere diversi dagli stessi totali visualizzati dai docenti poiché i docenti visualizzano tutti i voti, compresi quelli nascosti. Se i voti nascosti non vengono aggregati, gli studenti potrebbero essere in grado di ricavarli.';
$string['hidetotalshowexhiddenitems'] = 'Visualizza i totali escludendo gli elementi nascosti';
$string['hidetotalshowinchiddenitems'] = 'Visualizza i totali inclusivi di elementi nascosti';
$string['hideverbose'] = 'Nascondi {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Ordina per voti alti crescenti';
$string['highgradedescending'] = 'Ordinamento decrescente dei voti migliori';
$string['highgradeletter'] = 'Max';
$string['identifier'] = 'Identifica utente con';
$string['idnumbers'] = 'codici identificativi';
$string['ignore'] = 'Ignora';
$string['import'] = 'Importa';
$string['importcsv'] = 'Importazione CSV';
$string['importcsv_help'] = 'Le valutazioni possono essere importate tramite un file CSV con il seguente formato:

* ciascuna linea deve contenere un record
* ogni record è una serie di dati separati da virgola o altro separatore
* il primo record deve contenere l\'elenco dei nomi dei campi che definiscono il formato del dati presenti nel resto del file
* è obbligatorio un nome di campo che contenga l\'identificativo dell\'utente, ad esempio l\'indirizzo email oppure il codice identificativo

Per avere un esempio di formato, è possibile esportare delle valutazioni esistenti. Il file così ottenuto può essere modificato e salvato come CSV.';
$string['importcustom'] = 'Importa come obiettivi di questo corso';
$string['importerror'] = 'Si è verificato un errore, questo script non è stato attivato con i giusti parametri.';
$string['importfailed'] = 'L\'Importazione non è andata a buon fine. Nessun dato è stato importato.';
$string['importfeedback'] = 'Importa feedback';
$string['importfile'] = 'Importa da file';
$string['importfilemissing'] = 'Nessun file è stato ricevuto, torna indietro sul form e assicurati di carica un file valido.';
$string['importfrom'] = 'Importa da';
$string['importoutcomenofile'] = 'Il file caricato è vuoto o difettoso. Verifica che sia un file valido. Il problema è stato rilevato alla riga {$a}, che non sembra avere lo stesso numero di colonne della prima riga (riga di testata) oppure il file importato manca della testata. Guarda un file esportato come esempio di file con una testata valida.';
$string['importoutcomes'] = 'Importa obiettivi';
$string['importoutcomes_help'] = 'Gli obiettivi possono essere importati via file csv con lo stesso formato dell\'esportazione.';
$string['importoutcomesuccess'] = 'Obiettivo importato "{$a->name}" con ID #{$a->id}';
$string['importplugins'] = 'Plugin Importazione';
$string['importpreview'] = 'Anteprima importazione';
$string['importsettings'] = 'Impostazioni importazione';
$string['importskippednomanagescale'] = 'Non hai il permesso di aggiungere una nuova scala, per cui l\'obiettivo "{$a}" è stato saltato dal momento che richiedeva la creazione di una nuova scala';
$string['importskippedoutcome'] = 'Un obiettivo con nome breve "{$a}" già esiste in questo contesto, e quindi il corrispondente nel file importato è stato saltato';
$string['importstandard'] = 'Importa come obiettivi standard';
$string['importsuccess'] = 'Importazione valutazioni effettuata';
$string['importxml'] = 'Importazione XML';
$string['includescalesinaggregation'] = 'Aggrega le scale';
$string['includescalesinaggregation_help'] = 'Le scale possono essere incluse nelle aggregazioni dei voti equiparandole a valori numerici. L\'impostazione influenza tutte le aggregazioni di voti. ATTENZIONE: la modifica di questa impostazione avvierà il ricalcolo di tutte le aggregazioni di voti.';
$string['incorrectcourseid'] = 'L\'ID del corso non è corretto';
$string['incorrectcustomscale'] = '(Scala personalizzata non corretta, per favore cambiatela.)';
$string['incorrectminmax'] = 'Il minimo deve essere inferiore al massimo';
$string['inherit'] = 'Eredita';
$string['intersectioninfo'] = 'Info Sudente/Voti';
$string['invalidgradeexporteddate'] = 'La data di esportazione non è valida poiché si trova oltre un anno nel passato o nel futuro, oppure il formato non è valido.';
$string['item'] = 'Elemento';
$string['iteminfo'] = 'Info elemento';
$string['iteminfo_help'] = 'Campo per inserire informazioni utili sull\'elemento di valutazione. Il testo inserito comparirà solo in questa pagina.';
$string['itemname'] = 'Nome elemento';
$string['itemnamehelp'] = 'Il nome di questo elemento, preso dal modulo.';
$string['items'] = 'Elementi';
$string['itemsedit'] = 'Modifica elemento valutazione';
$string['keephigh'] = 'Utilizza voti migliori';
$string['keephigh_help'] = 'Saranno utilizzato gli N voti migliori, dove N è il valore scelto.';
$string['keephighestvalues'] = 'Utilizza {$a} voti migliori';
$string['keymanager'] = 'Gestore chiavi';
$string['lessthanmin'] = 'La valutazione inserita per {$a->itemname} per {$a->username} è inferiore al minimo consentito';
$string['letter'] = 'Graduatoria letterale';
$string['lettergrade'] = 'Graduatoria letterale';
$string['lettergradenonnumber'] = 'Il voto Basso e/o Alto non è numerico per';
$string['letterpercentage'] = 'Letterale (percentuale)';
$string['letterreal'] = 'Letterale (vera)';
$string['letters'] = 'Graduatoria letterale';
$string['linkedactivity'] = 'Attività collegata';
$string['linkedactivity_help'] = '<p>Indica l\'attività (o le attività) alla quale è collegato l\'obiettivo. Gli obiettivi sono utili per misurare le performance di uno studente in base a criteri diversi dal voto.</p>';
$string['linktoactivity'] = 'Collegamento all\'attività {$a->name} {$a->title}';
$string['lock'] = 'Blocca';
$string['locked'] = 'Bloccato';
$string['locked_help'] = 'Impedisce l\'aggiornamento automatico del voto da parte dell\'attività correlata.';
$string['locktime'] = 'Bloccato a partire da';
$string['locktimedate'] = 'Bloccata a partire da: {$a}';
$string['lockverbose'] = 'Blocca {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Minimo';
$string['lowgradeletter'] = 'Min';
$string['manualitem'] = 'Elemento manuale';
$string['mapfrom'] = 'Mappa da';
$string['mapfrom_help'] = 'Seleziona la colonna del foglio elettronico che contiene i dati utili per identificare l\'utente, ad esempio lo username, l\'id dell\'utente oppure l\'indirizzo email.';
$string['mappings'] = 'Mappatura degli elementi di valutazione';
$string['mappings_help'] = 'Per ciascuna colonna del foglio elettronico contenente una valutazione, seleziona il corrispondente elemento dove importare la valutazione';
$string['mapto'] = 'Mappa a';
$string['mapto_help'] = 'Seleziona gli stessi dati identificativi come definito in \'Mappa da\'';
$string['max'] = 'Massimo';
$string['maxgrade'] = 'Voto massimo';
$string['meanall'] = 'Tutti i voti, compresi i voti mancanti';
$string['meangraded'] = 'Solo i voti presenti nel registro';
$string['meanselection'] = 'Voti inclusi nel calcolo delle medie di colonna';
$string['meanselection_help'] = 'E\' possibile scegliere come calcolare le medie di colonna, includendo oppure escludendo i voti non ancora presenti nel registro valutatore.';
$string['median'] = 'Mediana';
$string['min'] = 'Minimo';
$string['minimum_show'] = 'Visualizza voto minimo';
$string['minimum_show_help'] = 'Il voto minimo viene usato nel calcolo delle valutazione e dei pesi. Se non visualizzato, come voto minimo di default sarà pari a zero e non potrà essere modificato.';
$string['minmaxtouse'] = 'Valutazione minima e massima utilizzata per i calcoli';
$string['minmaxtouse_desc'] = 'Per il calcolo della valutazione visualizzata nel registro valutatore, è possibile scegliere di utilizzare la valutazione minima e massima iniziale oppure la valutazione minima e massima specificata nelle impostazioni dell\'elemento di valutazione. Si raccomanda di modificare questa impostazioni durante momenti di basso carico poiché il ricalcolo delle valutazioni può comportare un carico elevato sul server.';
$string['minmaxtouse_help'] = 'Per il calcolo della valutazione visualizzata nel registro valutatore, è possibile scegliere di utilizzare la valutazione minima e massima iniziale oppure la valutazione minima e massima specificata nelle impostazioni dell\'elemento di valutazione';
$string['minmaxupgradedgrades'] = 'Nota: alcune valutazioni sono state modificate per ovviare a delle inconsistenze causate dal cambiamento delle valutazioni minime e massimo utilizzate per calcolare le valutazioni visualizzate.  Si raccomanda di rivedere i cambiamenti e di accettarli.';
$string['minmaxupgradefixbutton'] = 'Risolvi le inconsistenze';
$string['minmaxupgradewarning'] = 'Nota: in alcune valutazioni sono state rilevate delle inconsistenze causate dal cambiamento delle valutazioni minime e massimo utilizzate per calcolare le valutazioni visualizzate.  Si raccomanda di risolvere le inconsistenze cliccando sul pulsante sottostante, cosa che tuttavia comporterà variazioni nelle valutazioni.';
$string['missingitemtypeoreid'] = 'La chiave dell\'array (itemtype oppure eid) manca nel secondo parametro di grade_edit_tree_column_select::get_item_cell($item, $params)';
$string['missingscale'] = 'Deve essere scelta la scala';
$string['mode'] = 'Moda';
$string['modgrade'] = 'Voto';
$string['modgrade_help'] = 'Il tipo di valutazione da usare per l\'attività. Scegliendo \'scala\' sarà possibile selezionare una scala dal menù a discesa \'scala\'. Scegliendo \'punteggio\', sarà possibile impostare il punteggio massimo dell\'attività.';
$string['modgradecantchangegradetype'] = 'Non è possibile modificare il tipo poiché esistono già valutazioni per questo elemento';
$string['modgradecantchangegradetypemsg'] = 'Non è possibile modificare il tipo di valutazione poiché alcune valutazione sono già state rilasciate. Se desideri modificare il punteggio massimo, devi prima decidere se cambiare la scala delle valutazioni esistenti.';
$string['modgradecantchangegradetyporscalemsg'] = 'Non è possibile modificare il tipo di valutazione e la scala poiché alcune valutazione sono già state rilasciate.';
$string['modgradecantchangeratingmaxgrade'] = 'Non è possibile modificare il punteggio massimo quando esistono già valutazioni di attività.';
$string['modgradecantchangescale'] = 'Non è possibile modificare la scala poiché esistono già valutazioni per questo elemento';
$string['modgradecategorycantchangegradetypemsg'] = 'La categoria contiene elementi di valutazione che sono stati modificati. Di conseguenza non è possibile cambiare il tipo di valutazione perché alcune valutazioni sono state già date. Se vuoi modificare il punteggio massimo, devi prima scegliere se ricalcolare o meno le valutazioni esistenti.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'La categoria contiene elementi di valutazione che sono stati modificati. Di conseguenza non è possibile cambiare il tipo di valutazione perché alcune valutazioni sono state già date. Se vuoi modificare il punteggio massimo e la scala.';
$string['modgradecategoryrescalegrades'] = 'Ricalcola valutazioni modificate';
$string['modgradecategoryrescalegrades_help'] = 'Quando si cambia il punteggio massimo di un elemento di valutazione, è anche necessario indicare se la variazione causerà il cambiamento delle valutazioni percentuali già esistenti.

Selezionando \'Sì\', le valutazioni modificate già esistenti saranno scalate im modo da lasciare invariate le percentuali.

Ad esempio, selezionando \'Sì\' e cambiando il punteggio massimo di un elemento di valutazione da 10 a 20, una valutazione di 6/10 (60%) sarà scalata a 12/20 (60%).  Selezionando \'No\', la valutazione non cambierà e sarà necessario un intervento manuale per garantire punteggi corretti.';
$string['modgradedonotmodify'] = 'Non modificare le valutazioni esistenti';
$string['modgradeerrorbadpoint'] = 'E\' stato inserito un voto non valido. Deve essere un intero compreso tra 1 e {$a}';
$string['modgradeerrorbadscale'] = 'E\' stata sezionata una scala non valida. Assicurati di aver seclto una scala tra quelle disponibili sotto.';
$string['modgrademaxgrade'] = 'Punteggio massimo';
$string['modgraderescalegrades'] = 'Modifica la scala delle valutazioni esistenti';
$string['modgraderescalegrades_help'] = 'Quando vengono modificati i punteggi massimi nel registro valutatore è anche necessario decidere se dovranno essere cambiate anche le valutazioni percentuali già esistenti.

Impostando a \'Si\', la valutazioni esistenti saranno cambiate affinché le percentuali rimangano le stesse.

Ad esempio, modificando il punteggio massimo di un elemento da 10 a 20 con l\'impostazione a \'Si\', una valutazione di 6/10 (60%) verrà cambiata in 12/20 (60%). Con l\'impostazione a \'No\', la valutazione di 6/10 (60%) verrà cambiata in 6/20 (30%) e richiederà un aggiustamento manuale per garantire che i punteggi finali siano quelli attesi.';
$string['modgradetype'] = 'Tipo';
$string['modgradetypenone'] = 'Nessuno';
$string['modgradetypepoint'] = 'Punteggio';
$string['modgradetypescale'] = 'Scala';
$string['morethanmax'] = 'La valutazione immessa per {$a->itemname} for {$a->username} è superiore al massimo consentito';
$string['moveselectedto'] = 'Sposta gli elementi sezionanti in';
$string['movingelement'] = 'Spostamento {$a}';
$string['multfactor'] = 'Moltiplicatore';
$string['multfactor_help'] = '<p>Fattore di moltiplicazione dei voti di questo elemento. Il tetto è sempre il Voto massimo.</p>';
$string['multfactorvalue'] = 'Moltiplicatore per {$a}';
$string['mustchooserescaleyesorno'] = 'Devi decidere se cambiare la scala delle valutazioni esistenti oppure no.';
$string['mygrades'] = 'Link valutazioni nel menu utente';
$string['mygrades_desc'] = 'Consente di collegare un registro valutatore esterno nel menu utente.';
$string['mypreferences'] = 'Preferenze';
$string['myreportpreferences'] = 'Preferenze';
$string['navmethod'] = 'Modalità di navigazione';
$string['neverdeletehistory'] = 'Non eliminare mai lo storico';
$string['newcategory'] = 'Nuova categoria';
$string['newitem'] = 'Nuovo elemento di valutazione';
$string['newoutcomeitem'] = 'Nuovo obiettivo';
$string['no'] = 'No';
$string['nocategories'] = 'Categorie di valutazione non possono essere aggiunte o trovate per questo corso';
$string['nocategoryname'] = 'Manca il nome categoria.';
$string['nocategoryview'] = 'Nessuna categoria utilizzabile per la visualizzazione';
$string['nocourses'] = 'Non ci sono ancora corsi';
$string['noforce'] = 'Non forzare';
$string['nogradeletters'] = 'Graduatoria letterale non impostata';
$string['nogradesreturned'] = 'Non è stata ottenuta alcuna valutazione';
$string['noidnumber'] = 'Nessun codice identificativo';
$string['nolettergrade'] = 'Nessuna valutazione letterale per';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Ricevuto un valore non numerico per';
$string['nonunlockableverbose'] = 'Questo voto non può essere sbloccata finché non sarà sbloccato l\'elemento {$a->itemname}.';
$string['nonweightedpct'] = '% non pesata';
$string['nooutcome'] = 'Nessun obiettivo';
$string['nooutcomes'] = 'Gli elementi obiettivo devono essere collegati ad obiettivi di corso, ma non ci sono obiettivi in questo corso. Volete aggiungerne uno?';
$string['nopermissiontoresetweights'] = 'Autorizzazione mancante per reimpostare il peso';
$string['nopublish'] = 'Non pubblicare';
$string['noreports'] = 'Non sei iscritto o non sei docente in nessun corso di questo sito.';
$string['norolesdefined'] = 'Non ci sono ruoli definiti in Amministrazione > Valutazioni > Impostazioni Generali > Ruoli riportati nel registro';
$string['noscales'] = 'Gli obiettivi devono essere collegati ad una scala presente nel corso oppure ad una scala standard. Non ci sono scale disponibili, volete aggiungerne una?';
$string['noselectedcategories'] = 'nessuna categoria selezionata.';
$string['noselecteditems'] = 'nessun elemento selezionato.';
$string['notenrolled'] = 'Non sei iscritto in nessun corso.';
$string['notteachererror'] = 'È necessario essere docente per utilizzare questa caratteristica.';
$string['nousersloaded'] = 'Nessun utente caricato';
$string['nouserstograde'] = 'Non ci sono utenti da valutare';
$string['numberofgrades'] = 'Numero di valutazioni';
$string['onascaleof'] = 'su una scala da {$a->grademin} a {$a->grademax}';
$string['operations'] = 'Operazioni';
$string['options'] = 'Opzioni';
$string['others'] = 'Altri';
$string['outcome'] = 'Obiettivo';
$string['outcome_help'] = 'L\'obiettivo che questo elemento di valutazione rappresenta.';
$string['outcomeassigntocourse'] = 'Assegna un altro obiettivo a questo corso';
$string['outcomecategory'] = 'Crea obiettivi nella categoria';
$string['outcomecategorynew'] = 'Nuova categoria';
$string['outcomeconfirmdelete'] = 'Sei sicuro di eliminare l\'obiettivo "{$a}"?';
$string['outcomecreate'] = 'Aggiungi un obiettivo';
$string['outcomedelete'] = 'Elimina obiettivo';
$string['outcomefullname'] = 'Nome';
$string['outcomeitem'] = 'Elemento obiettivo';
$string['outcomeitemsedit'] = 'Modifica elemento obiettivo';
$string['outcomereport'] = 'Scheda obiettivi';
$string['outcomes'] = 'Obiettivi';
$string['outcomescourse'] = 'Obiettivi in uso nel corso';
$string['outcomescoursecustom'] = 'Personalizzati (non rimuovere)';
$string['outcomescoursenotused'] = 'Standard non usati';
$string['outcomescourseused'] = 'Standard (non rimuovere)';
$string['outcomescustom'] = 'Obiettivi personalizzati';
$string['outcomeshortname'] = 'Nome abbreviato';
$string['outcomesstandard'] = 'Obiettivi standard';
$string['outcomesstandardavailable'] = 'Obiettivi standard disponibili';
$string['outcomestandard'] = 'Obiettivo standard';
$string['outcomestandard_help'] = '<p>E\' un obiettivo definito a livello di sito e disponibile in qualsiasi corso.</p>';
$string['overallaverage'] = 'Media generale';
$string['overridden'] = 'Forzato';
$string['overridden_help'] = 'Consente di evitare l\'aggiornamento automatico del voto da parte della rispettiva attività.

Quando un voto viene modificato nel registro valutatore, la spunta viene impostata automaticamente. E\' sempre possibile deselezionarla per consentire la modifica del voto da parte dell\'attività.';
$string['overriddennotice'] = 'La tua valutazione finale di questa attività è stata modificata manualmente.';
$string['overridecat'] = 'Consenti di sostituire manualmente le valutazioni di categoria';
$string['overridecat_help'] = 'La disabilitazione di questa impostazione renderà impossibile modificare le valutazioni di categoria.';
$string['overridesitedefaultgradedisplaytype'] = 'Modifica default del sito';
$string['overridesitedefaultgradedisplaytype_help'] = 'A livello di corso consente di impostare una graduatoria letterale con limiti diversi dai valori di default del sito.';
$string['overrideweightofa'] = 'Modifica il peso di {$a}';
$string['parentcategory'] = 'Categoria superiore';
$string['pctoftotalgrade'] = '% del voto finale';
$string['percent'] = 'Percentuale';
$string['percentage'] = 'Percentuale';
$string['percentageletter'] = 'Percentuale (letterale)';
$string['percentagereal'] = 'Percentuale (vera)';
$string['percentascending'] = 'Ordina per percentuale crescente';
$string['percentdescending'] = 'Ordina per percentuale decrescente';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Incremento';
$string['plusfactor_help'] = '<p>Valore numerico che sarà sommato ai voti. La somma avviene dopo aver applicato il Moltiplicatore.</p>';
$string['plusfactorvalue'] = 'Incremento per {$a}';
$string['points'] = 'Punti';
$string['pointsascending'] = 'Ordina per punti crescenti';
$string['pointsdescending'] = 'Ordina per punti decrescenti';
$string['positionfirst'] = 'Prima colonna';
$string['positionlast'] = 'Ultima colonna';
$string['preferences'] = 'Preferenze';
$string['prefgeneral'] = 'Generale';
$string['prefletters'] = 'Graduatoria letterale e limiti';
$string['prefrows'] = 'Righe speciali';
$string['prefshow'] = 'Parametri di visualizzazione';
$string['previewrows'] = 'Righe anteprima';
$string['privacy:metadata:categorieshistory'] = 'Registro delle versioni precedenti delle categorie di valutazione';
$string['privacy:metadata:filepurpose'] = 'File di commento memorizzati per l\'utente nel registro valutatore.';
$string['privacy:metadata:grade_import_newitem'] = 'Tabella temporanea per la memorizzazione di nuovi elementi tramite l\'importazione delle valutazioni.';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Codice unico per identificare un lotto di importazione.';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Utente che importa i dati.';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Nome del nuovo elemento.';
$string['privacy:metadata:grade_import_values'] = 'Tabella temporanea per importare le valutazioni.';
$string['privacy:metadata:grade_import_values:feedback'] = 'Commento alle valutazioni.';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Voto grezzo.';
$string['privacy:metadata:grade_import_values:importcode'] = 'Codice unico per identificare un lotto di importazione.';
$string['privacy:metadata:grade_import_values:importer'] = 'Utente che importa i dati.';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Indicatore della sola importazione del feedback.';
$string['privacy:metadata:grade_import_values:userid'] = 'Utente del quale è stata importata la valutazione.';
$string['privacy:metadata:grades'] = 'Record delle valutazioni.';
$string['privacy:metadata:grades:aggregationstatus'] = 'Stato dell\'aggregazione.';
$string['privacy:metadata:grades:aggregationweight'] = 'Peso nell\'aggregazione.';
$string['privacy:metadata:grades:feedback'] = 'Commento.';
$string['privacy:metadata:grades:finalgrade'] = 'Valutazione.';
$string['privacy:metadata:grades:information'] = 'Informazioni aggiuntive sulla valutazione.';
$string['privacy:metadata:grades:timemodified'] = 'Data e ora dell\'ultima modifica della valutazione.';
$string['privacy:metadata:grades:userid'] = 'ID dell\'utente a cui appartiene la valutazione.';
$string['privacy:metadata:grades:usermodified'] = 'ID dell\'utente che ha apportato l\'ultima modifica al record.';
$string['privacy:metadata:gradeshistory'] = 'Record delle valutazioni precedenti.';
$string['privacy:metadata:history:loggeduser'] = 'ID dell\'utente autenticato al momento del cambio di versione.';
$string['privacy:metadata:history:timemodified'] = 'Data e ora del cambio di versione della valutazione.';
$string['privacy:metadata:itemshistory'] = 'Record delle versioni precedenti degli elementi di valutazione.';
$string['privacy:metadata:outcomes'] = 'Record degli obiettivi.';
$string['privacy:metadata:outcomes:timemodified'] = 'Data e ora dell\'ultima modifica del record.';
$string['privacy:metadata:outcomes:usermodified'] = 'L\'utente che ha apportato l\'ultima modifica al record.';
$string['privacy:metadata:outcomeshistory'] = 'Record delle versioni precedenti degli obiettivi.';
$string['privacy:metadata:scale'] = 'Record delle scale.';
$string['privacy:metadata:scale:timemodified'] = 'Data e ora dell\'ultima modifica del record.';
$string['privacy:metadata:scale:userid'] = 'L\'utente che ha apportato l\'ultima modifica al record.';
$string['privacy:metadata:scalehistory'] = 'Record delle versioni precedenti delle scale.';
$string['privacy:request:historyactiondelete'] = 'Elimina';
$string['privacy:request:historyactioninsert'] = 'Inserisci';
$string['privacy:request:historyactionupdate'] = 'Aggiorna';
$string['profilereport'] = 'Report nel profilo utente';
$string['profilereport_help'] = 'Il tipo di report da visualizzare nella pagina del profilo utente';
$string['publishing'] = 'Pubblicazione';
$string['publishingoptions'] = 'Opzioni pubblicazione valutazioni';
$string['quickfeedback'] = 'Feedback rapido';
$string['quickgrading'] = 'Valutazione rapida';
$string['quickgrading_help'] = '<p>La valutazione rapida aggiunge una casella di input di testo per ogni elemento presente nel registro valutatore, consentendo di inserire più velocemente i voti. Cliccando sul pulsante Aggiorna tutte le modifiche saranno salvate contemporaneamente.</p>';
$string['range'] = 'Intervallo';
$string['rangedecimals'] = 'Cifre decimali dell\'intervallo';
$string['rangedecimals_help'] = 'Il numero di cifre decimali da usare per l\'intervallo.';
$string['rangesdecimalpoints'] = 'Decimali negli intervalli';
$string['rangesdecimalpoints_help'] = 'Imposta il numero di cifre decimali da usare nella visualizzazione degli intervalli dei voti. L\'impostazione può essere modificata per ciascun elemento di valutazione.';
$string['rangesdisplaytype'] = 'Visualizza intervalli come';
$string['rangesdisplaytype_help'] = '<p>Specifica il tipo di visualizzazione degli intervalli dei voti. Scegliendo Eredita, verrà utilizzato il tipo di visualizzazione già impostato per ciascuna colonna.</p>';
$string['rank'] = 'Classifica';
$string['rawpct'] = '% grezza';
$string['real'] = 'Punteggio';
$string['realletter'] = 'Punteggio (letterale)';
$string['realpercentage'] = 'Punteggio (percentuale)';
$string['recalculatinggrades'] = 'Ricalcolo delle valutazioni in corso';
$string['recovergradesdefault'] = 'Default per il recupero delle valutazioni';
$string['recovergradesdefault_help'] = 'Recupera le valutazioni precedenti quando un utente si iscrive nuovamente in un corso';
$string['refreshpreview'] = 'Aggiorna anteprima';
$string['regradeanyway'] = 'Rivaluta comunque';
$string['removeallcoursegrades'] = 'Elimina tutte le valutazioni';
$string['removeallcoursegrades_help'] = 'Selezionando la casella, saranno eliminati tutti gli elementi di valutazione manualmente aggiunti al registro valutatore e tutte le valutazioni modificate, escluse, nascoste o bloccate. Saranno mantenute solo le valutazioni associate alle attività.';
$string['removeallcourseitems'] = 'Elimina tutti gli elementi e le categorie';
$string['removeallcourseitems_help'] = 'Selezionando la casella, saranno eliminati tutti gli elementi di valutazione e le categorie manualmente aggiunti al registro valutatore e tutte le valutazioni modificate, escluse, nascoste o bloccate. Saranno mantenute solo le valutazioni associate alle attività.';
$string['report'] = 'Report';
$string['reportdefault'] = 'Report default ({$a})';
$string['reportplugins'] = 'Report plugin';
$string['reportsettings'] = 'Impostazioni report';
$string['reprintheaders'] = 'Ristampa intestazioni';
$string['resetweights'] = 'Reimposta il peso di {$a->itemname}';
$string['resetweightsshort'] = 'Reimposta peso';
$string['respectingcurrentdata'] = 'configurazione corrente inalterata';
$string['rowpreviewnum'] = 'Righe di anteprima';
$string['rowpreviewnum_help'] = 'E\' possibile visualizzare un\'anteprima dei dati da importare. L\'impostazione definisce il numero di righe dell\'anteprima.';
$string['savechanges'] = 'Salva modifiche';
$string['savepreferences'] = 'Salva preferenze';
$string['scaleconfirmdelete'] = 'Sei sicuro di eliminare la scala "{$a}"?';
$string['scaledpct'] = 'Scalatura %';
$string['seeallcoursegrades'] = 'Vai alle valutazioni del corso';
$string['select'] = 'Seleziona {$a}';
$string['selectalloroneuser'] = 'Visualizza';
$string['selectauser'] = 'Seleziona un utente';
$string['selectdestination'] = 'Scegli la destinazione di {$a}';
$string['separator'] = 'Separatore';
$string['separator_help'] = 'Selezionare il separatore utilizzato nel file CSV (in genere la virgola).';
$string['sepcolon'] = 'due punti';
$string['sepcomma'] = 'Virgola';
$string['sepsemicolon'] = 'punto e virgola';
$string['septab'] = 'Tabulatore';
$string['setcategories'] = 'Imposta categorie';
$string['setcategorieserror'] = 'Bisogna definire le categorie prima di dare dei pesi alle stesse.';
$string['setgradeletters'] = 'Imposta graduatoria letterale';
$string['setpreferences'] = 'Imposta preferenze';
$string['setting'] = 'Impostazione';
$string['settings'] = 'Impostazioni';
$string['setweights'] = 'Imposta pesi';
$string['showactivityicons'] = 'Visualizza icone attività';
$string['showactivityicons_help'] = 'Visualizza, oltre al nome, anche l\'icona rappresentativa del modulo di attività.';
$string['showallhidden'] = 'Visualizza voti nascosti';
$string['showallstudents'] = 'Visualizza tutti gli studenti';
$string['showanalysisicon'] = 'Visualizza icona Analisi delle valutazioni';
$string['showanalysisicon_desc'] = 'Visualizza di default l\'icona Analisi delle valutazioni. Se il modulo di attività lo supporta, l\'icona Analisi delle valutazioni sarà un link ad una pagina con il dettaglio sulla valutazione e come è stata raggiunta.';
$string['showanalysisicon_help'] = 'Se il modulo di attività lo supporta, l\'icona Analisi delle valutazioni sarà un link ad una pagina con il dettaglio sulla valutazione e come è stata raggiunta.';
$string['showaverage'] = 'Visualizza media';
$string['showaverage_help'] = 'Se visualizzare o meno la colonna della media. Da notare che gli studenti potrebbero essere in grado di ricavare i voti degli altri studenti se le medie sono calcolate da una campione di pochi valori. Per motivi di performance le medie dipendenti da voti nascoste sono approssimate.';
$string['showaverages'] = 'Visualizza medie di colonna';
$string['showaverages_help'] = 'Visualizza le medie di colonna nel registro valutatore.';
$string['showcalculations'] = 'Visualizza calcolatrice';
$string['showcalculations_help'] = 'Durante la modifica, visualizza l\'icona della calcolatrice accanto agli elementi di valutazione ed alle categorie con un indicatore per ricordare che l\'elemento è calcolato.';
$string['showcontributiontocoursetotal'] = 'Visualizza quota di contribuzione rispetto al totale del corso';
$string['showcontributiontocoursetotal_help'] = 'Visualizza una colonna aggiuntiva dove comparirà la percentuale di contribuzione di ciascuna valutazione rispetto al totale del corso ottenuto dall\'utente (dopo l\'applicazione dei pesi).';
$string['showeyecons'] = 'Visualizza icona visibilità';
$string['showeyecons_help'] = 'Visualizza l\'icona visibilità accanto ad ogni voto. L\'icona visibilità consente di nascondere i voti attribuiti agli utenti.';
$string['showfeedback'] = 'Visualizza feedback';
$string['showfeedback_help'] = 'Se visualizzare o meno la colonna del feedback.';
$string['showgrade'] = 'Visualizza voti';
$string['showgrade_help'] = 'Se visualizzare o meno la colonna dei voti.';
$string['showgroups'] = 'Visualizza medie di gruppo';
$string['showhiddenitems'] = 'Visualizza voti nascosti';
$string['showhiddenitems_help'] = 'Specifica come visualizzare agli studenti gli elementi di valutazione nascosti

* Visualizza elementi con voti nascosti - i voti saranno nascosti ma il nome dell\'elemento di valutazione sarà visibile
* Solo elementi con voti nascosti a tempo -
Gli elementi di valutazione e i voti saranno invisibili fino alla data prefissata, trascorsa la quale diventeranno visibili
* Non visualizzare elementi con voti nascosti - I voti e gli elementi di valutazione non saranno visibili';
$string['showhiddenuntilonly'] = 'Solo i voti nascosti a tempo';
$string['showingaggregatesonly'] = 'Visualizzazione delle aggregazioni';
$string['showingfullmode'] = 'Vista completa';
$string['showinggradesonly'] = 'Visualizzazione delle valutazioni';
$string['showlettergrade'] = 'Visualizza graduatoria letterale';
$string['showlettergrade_help'] = 'Visualizza la colonna della graduatoria letterale';
$string['showlocks'] = 'Visualizza icona blocca/sblocca';
$string['showlocks_help'] = 'Visualizza l\'icona blocca/sblocca accanto ad ogni voto.';
$string['shownohidden'] = 'Non visualizzare';
$string['shownooutcomes'] = 'Nascondi obiettivi';
$string['shownumberofgrades'] = 'Visualizza numero voti usati nelle medie';
$string['shownumberofgrades_help'] = 'Visualizza tra parentesi, accanto ad ogni media, il numero di voti utilizzati per calcolare la media stessa. Esempio: 45 (34).';
$string['showonlyactiveenrol'] = 'Visualizza solo iscrizioni attive';
$string['showonlyactiveenrol_help'] = 'Nel registro valutatore saranno visualizzati solo gli utenti la cui iscrizione è attiva. Gli utenti con l\'iscrizione sospesa non saranno elencati.';
$string['showpercentage'] = 'Visualizza percentuale';
$string['showpercentage_help'] = 'Visualizza le valutazioni ricevute anche in percentuale.';
$string['showquickfeedback'] = 'Visualizza feedback rapido';
$string['showquickfeedback_help'] = 'Il feeback rapido aggiunge una casella di input di testo per ciascun elemento presente sul registro valutatore, consentendo di modificare più velocemente i feedback. Cliccando sul pulsante Aggiorna tutte le modiche saranno salvate contemporaneamente.';
$string['showrange'] = 'Visualizza intervallo';
$string['showrange_help'] = 'Se visualizzare o meno la colonna dell\'intervallo.';
$string['showranges'] = 'Visualizza intervalli';
$string['showranges_help'] = 'Visualizza nel registro valutatore una riga contenente gli intervalli ammessi per i voti (voto minimo e voto massimo).';
$string['showrank'] = 'Visualizza classifica';
$string['showrank_help'] = 'Visualizza la posizione in classifica dell\'utente rispetto al resto della classe per ciascun elemento di valutazione.';
$string['showuserimage'] = 'Visualizza immagine utente';
$string['showuserimage_help'] = 'Visualizza l\'immagine del profilo utente assieme al nome nel registro valutatore.';
$string['showverbose'] = 'Visualizza {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Visualizza pesi';
$string['showweight_help'] = 'Consente la visualizzazione della colonna dei pesi.';
$string['simpleview'] = 'Vista singola';
$string['singleview'] = 'Scheda singola: {$a}';
$string['sitewide'] = 'Obiettivo standard';
$string['sort'] = 'ordina';
$string['sortasc'] = 'Elenca in ordine ascendente';
$string['sortbyfirstname'] = 'Ordina per nome';
$string['sortbylastname'] = 'Ordina per cognome';
$string['sortdesc'] = 'Elenca in ordine discendente';
$string['standarddeviation'] = 'Deviazione standard';
$string['stats'] = 'Statistiche';
$string['statslink'] = 'Stat.';
$string['student'] = 'Studente';
$string['studentsperpage'] = 'Studenti per pagina';
$string['studentsperpage_help'] = 'Numero di studenti da visualizzare per pagina nel registro valutatore.';
$string['studentsperpagereduced'] = 'Il numero di studenti per pagina è stato ridotto da {$a->originalstudentsperpage} a {$a->studentsperpage}. Valuta se è il caso di aumentare l\'impostazione PHP max_input_vars di {$a->maxinputvars}.';
$string['subcategory'] = 'Categoria normale';
$string['submissions'] = 'Invii';
$string['submittedon'] = 'Sottomesso: {$a}';
$string['sumofgradesupgradedgrades'] = 'Nota: per effetto dell\'aggiornamento del sito, il metodo di aggregazione "Somma dei voti" è stata cambiata in "Naturale". Poiché questo corso utilizzava il metodo "Somma dei voti", si raccomanda di verificare le variazioni nel registro valutatore.';
$string['switchtofullview'] = 'Passa alla vista completa';
$string['switchtosimpleview'] = 'Passa alla vista semplificata';
$string['tabs'] = 'Tab';
$string['topcategory'] = 'Categoria Super';
$string['total'] = 'Totale';
$string['totalweight100'] = 'Il peso totale è uguale a 100';
$string['totalweightnot100'] = 'Il peso totale non è uguale a 100';
$string['turnfeedbackoff'] = 'Disattiva feedback';
$string['turnfeedbackon'] = 'Attiva feedback';
$string['typenone'] = 'Nessuno';
$string['typescale'] = 'Scala';
$string['typescale_help'] = 'Tramite questa impostazione è possibile scegliere la scala da utilizzare. La scala da associare ad un elemento di valutazione basato su una attività si sceglie nella pagina di modifica dell\'attività.';
$string['typetext'] = 'Testo';
$string['typevalue'] = 'Valore';
$string['uncategorised'] = 'Senza categoria';
$string['unchangedgrade'] = 'Valutazione non modificata';
$string['unenrolledusersinimport'] = 'Questa importazione includeva le seguenti valutazioni per utenti attualmente non iscritti in questo corso: {$a}';
$string['unlimitedgrades'] = 'Voti privi di limiti';
$string['unlimitedgrades_help'] = 'Di default i voti sono limitati dal valore massimo e minino dell\'elemento di valutazione. Abilitando questa impostazione sarà possibile rimuovere questi limiti ed usare voti superiori al 100% da inserire direttamente nel registro valutatore.';
$string['unlock'] = 'Sblocca';
$string['unlockverbose'] = 'Sblocca {$a->category} {$a->itemmodule} {$a->itemname';
$string['unused'] = 'Non usato';
$string['updatedgradesonly'] = 'Esporta solo valutazioni nuove o aggiornate';
$string['upgradedgradeshidemessage'] = 'OK';
$string['upgradedminmaxrevertmessage'] = 'Annulla modifche';
$string['uploadgrades'] = 'Importa valutazioni';
$string['useadvanced'] = 'Usa opzioni avanzate';
$string['usedcourses'] = 'Corsi usati';
$string['usedgradeitem'] = 'Elemento di valutazione usato';
$string['usenooutcome'] = 'Nessun obiettivo';
$string['usenoscale'] = 'Nessuna scala';
$string['usepercent'] = 'Usa percentuale';
$string['user'] = 'Utente';
$string['userenrolmentsuspended'] = 'Iscrizione utente sospesa';
$string['userfields_show'] = 'Visualizza campi utente';
$string['userfields_show_help'] = 'Nel registro valutatore  saranno visualizzati campi utente ulteriori come ad esempio l\'indirizzo email. E\' possibile impostare i campi che saranno visualizzati tramite l\'impostazione "showuseridentity" disponibile a livello di sito.';
$string['usergrade'] = 'Utente {$a->fullname} ({$a->useridnumber}) su elemento di valutazione {$a->gradeidnumber}';
$string['userid'] = 'ID utente';
$string['useridnumberwarning'] = 'Gli utenti privi di codice identificativo sono esclusi dall\'esportazione poiché non possono essere importati';
$string['usermappingerror'] = 'Errore mappatura utente. Non è stato possibile trovare l\'utente con {$a->field} contenente "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'L\'utente non fa parte del gruppo';
$string['usermappingerrorusernotfound'] = 'Errore mappatura utente. Non è stato possibile trovare l\'utente.';
$string['userpreferences'] = 'Preferenze utente';
$string['useweighted'] = 'Usa pesi';
$string['verbosescales'] = 'Scale letterali';
$string['verbosescales_help'] = 'Una scala letterale utilizza parole al posto dei numeri. Impostare a \'Si" per importare sia le scale numeriche sia le scale letterali. Impostare a \'No\' per importare solamente le scale numeriche.';
$string['viewbygroup'] = 'Gruppo';
$string['viewgrades'] = 'Visualizza valutazioni';
$string['weight'] = 'Peso';
$string['weight_help'] = 'Il valore utilizzato per determinare il valore relativo di più elementi di valutazione in una categoria o in un corso.';
$string['weightcourse'] = 'Usa valutazioni pesate per il corso';
$string['weightedascending'] = 'Ordinamento crescente per % pesata';
$string['weighteddescending'] = 'Ordinamento decrescente per % pesata';
$string['weightedpct'] = '% pesata';
$string['weightedpctcontribution'] = 'Contributo alla % pesata';
$string['weightofa'] = 'Peso di {$a}';
$string['weightorextracredit'] = 'Pesi o punti extra';
$string['weightoverride'] = 'Adeguamento del peso';
$string['weightoverride_help'] = 'Deselezionare per reimpostare il peso di una valutazione al valore calcolato automaticamente. Con l\'impostazione selezionata il peso non sarà adeguato automaticamente.';
$string['weights'] = 'Pesi';
$string['weightsadjusted'] = 'I peso sono stati adattati per un totale di 100.';
$string['weightsedit'] = 'Modifica pesi e punti extra';
$string['weightuc'] = 'Peso calcolato';
$string['writinggradebookinfo'] = 'Scrittura delle impostazioni del registro';
$string['xml'] = 'XML';
$string['yes'] = 'Si';
$string['yourgrade'] = 'La tua valutazione';
