<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'ru', version '3.8'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Обо мне';
$string['actingasrole'] = 'Вы в настоящее время действуете под другой ролью';
$string['activebreadcrumb'] = 'Цвет фона строки навигации';
$string['activebreadcrumbdesc'] = 'Установка цвета фона активной строки навигации (и оставшейся части панели).';
$string['activitiesheading'] = 'Действия';
$string['alertaccess'] = 'Видимость окна предупреждения';
$string['alertaccessadmins'] = 'Видно только администраторам';
$string['alertaccessdesc'] = 'Установка ограничений на видимость окна предупреждения.<br><b>Внимание:</b>: при использовании параметра "Ограничение на основе заданного поля профиля" необходимо задать значения полей ниже.';
$string['alertaccessglobal'] = 'Видно всем';
$string['alertaccessprofile'] = 'Ограничение на основе заданного поля профиля';
$string['alertaccessusers'] = 'Видно только зарегистрированным пользователям';
$string['alertannounce'] = 'Объявление';
$string['alertannouncedesc'] = 'Показать объявление в окне сообщения';
$string['alertbackgroundcolorinfo'] = 'Цвет фона информационной панели';
$string['alertbackgroundcolorinfodesc'] = 'Цвет фона информационного окна';
$string['alertbackgroundcolorsuccess'] = 'Цвет фона объявления';
$string['alertbackgroundcolorsuccessdesc'] = 'Цвет фона окна объявления';
$string['alertbackgroundcolorwarning'] = 'Цвет фона предупреждения';
$string['alertbackgroundcolorwarningdesc'] = 'Цвет фона окна предупреждения';
$string['alertbordercolorinfo'] = 'Цвет границы информационного окна';
$string['alertbordercolorinfodesc'] = 'Цвет границы информационного окна';
$string['alertbordercolorsuccess'] = 'Цвет границы объявления';
$string['alertbordercolorsuccessdesc'] = 'Цвет границы окна объявления';
$string['alertbordercolorwarning'] = 'Цвет границы предупреждения';
$string['alertbordercolorwarningdesc'] = 'Цвет границы окна предупреждения';
$string['alertcolorinfo'] = 'Цвет информационного окна';
$string['alertcolorinfodesc'] = 'Цвет иконки информационного окна';
$string['alertcolorsheading'] = 'Настройка важных окон сообщений';
$string['alertcolorsheadingdesc'] = 'Установите цвета и значок';
$string['alertcolorsuccess'] = 'Цвет объявления';
$string['alertcolorsuccessdesc'] = 'Цвет иконки окна сообщения';
$string['alertcolorwarning'] = 'Цвет предупреждения';
$string['alertcolorwarningdesc'] = 'Цвет иконки окна предупреждения';
$string['alertcount'] = 'Количество окон сообщений';
$string['alertcountdesc'] = 'Количество окон, показываемых ниже в области редактирования.';
$string['alertdesc'] = 'Введите и настройте текст, который будет отображаться как предупреждение в верхней части сайта. Разным типам пользователей можно показывать разные предупреждения. Также предупреждения можно отображать только на домашней странице или на всех страницах сайта.';
$string['alertdisabled'] = 'Отключить';
$string['alertdisabledesc'] = 'Отключить это оповещение';
$string['alerthiddencourse'] = 'Предупреждение о скрытом курсе';
$string['alerthiddencoursedesc'] = 'Отображать предупреждение на странице курса, если он скрыт';
$string['alerthiddencoursetext-1'] = 'Этот курс скрыт и недоступен для студентов';
$string['alerthiddencoursetext-2'] = 'Нажмите здесь, чтобы обновить настройки';
$string['alerticoninfo'] = 'Значок информации';
$string['alerticoninfodesc'] = 'Задайте <a href="http://fortawesome.github.io/Font-Awesome/icons/">значок «Font Awesome Icon»</a>, который будет использоваться в информационных окнах. Введите имя иконки без префикса.';
$string['alerticonsuccess'] = 'Значок объявления';
$string['alerticonsuccessdesc'] = 'Задайте <a href="http://fortawesome.github.io/Font-Awesome/icons/"> значок «Font Awesome Icon»</a>, который будет использоваться в окнах  объявлений. Введите имя иконки без префикса.';
$string['alerticonwarning'] = 'Значок предупреждения';
$string['alerticonwarningdesc'] = 'Задайте <a href="http://fortawesome.github.io/Font-Awesome/icons/"> значок «Font Awesome Icon»</a>, который будет использоваться в окнах предупреждений. Введите имя иконки без префикса.';
$string['alertinfo'] = 'Информация';
$string['alertinfodesc'] = 'Показать информацию в окне предупреждения';
$string['alertkeyvalue'] = 'Идентификатор предупреждения';
$string['alertkeyvalue_details'] = 'Идентификатор позволяет отличить данное предупреждение от предыдущих. Если его изменить, то предупреждение будет снова показано всем пользователям, которые его ранее просмотрели и закрыли. Чтобы убедиться, что все пользователи увидят предупреждение, обязательно измените идентификатор при смене его текста.';
$string['alertprofilefield'] = 'Имя заданного поля профиля=Значение (опционально)';
$string['alertprofilefielddesc'] = 'Добавление прав доступа для заданного поля профиля, например: usertype=student';
$string['alertsettings'] = 'Окно предупреждения {$a}';
$string['alertsettingscourse'] = 'Настройки оповещений';
$string['alertsettingsgeneral'] = 'Основные настройки окна предупреждения';
$string['alertsettingsheading'] = 'Настройка Окна предупреждения (в верхней части страницы). См. схему расположения элементов <a href="./../theme/adaptable/pix/layout.png" target="_blank">здесь</a>';
$string['alerttext'] = 'Текст предупреждения';
$string['alerttextdesc'] = 'Введите текст, отображаемый в окне предупреждения';
$string['alerttype'] = 'Тип окна предупреждения';
$string['alerttypedesc'] = 'Выберите тип предупреждения: информация (синее), предупреждение (желтый) или объявление (зелёный)';
$string['alertwarning'] = 'Предупреждение';
$string['alertwarningdesc'] = 'Показать предупреждение в окне предупреждения';
$string['analyticscount'] = 'Количество показателей аналитики';
$string['analyticscountdesc'] = 'Количество полей аналитики, отображаемых ниже';
$string['analyticsprofilefielddesc'] = 'Добавить правило доступа для пользовательского профиля. Например, тип пользователя=студент';
$string['analyticssettings'] = 'Аналитика';
$string['analyticssettingsdesc'] = 'Вы можете установить несколько кодов для Аналитики Google и задать их к полям профиля пользователя.';
$string['analyticssettingsheading'] = 'Настройка Аналитики Google';
$string['analyticstext'] = 'ID аналитики';
$string['analyticstextdesc'] = 'Введите ID Аналитики Google';
$string['anonymizega'] = 'Анонимизировать IP пользователя';
$string['anonymizegadesc'] = 'Анонимизировать IP пользователя, отправляемый в Google Analytics';
$string['answered'] = 'Ответил';
$string['attempted'] = 'Попытка';
$string['backcolor'] = 'Цвет фона';
$string['backcolordesc'] = 'Параметр задает цвет фона';
$string['bcustyle'] = 'Стиль BCU';
$string['beta'] = 'ТЕСТОВАЯ ВЕРСИЯ. НЕ ИСПОЛЬЗУЙТЕ НА РАБОЧИХ САЙТАХ';
$string['blockbackgroundcolor'] = 'Цвет фона блока';
$string['blockbackgroundcolordesc'] = 'Установите цвет фона для всех блоков';
$string['blockbordercolor'] = 'Цвет границы блока';
$string['blockbordercolordesc'] = 'Установите цвет границы блока';
$string['blockheaderbackgroundcolor'] = 'Цвет фона заголовка блока';
$string['blockheaderbackgroundcolordesc'] = 'Установите цвет фона заголовка для всех блоков';
$string['blockheaderborderbottom'] = 'Толщина нижней границы блока заголовка';
$string['blockheaderborderbottomdesc'] = 'Установить толщину нижней границы блоков заголовков';
$string['blockheaderborderleft'] = 'Толщина левой границы блока заголовка';
$string['blockheaderborderleftdesc'] = 'Установить толщину левой границы блоков заголовков';
$string['blockheaderborderright'] = 'Толщина правой границы блока заголовка';
$string['blockheaderborderrightdesc'] = 'Установить толщину правой границы блоков заголовков';
$string['blockheaderbordertop'] = 'Толщина верхней границы блока заголовка';
$string['blockheaderbordertopdesc'] = 'Установить толщину верхней границы блоков заголовков';
$string['blockheaderbordertopstyle'] = 'Стиль границы блока заголовка';
$string['blockheaderbordertopstyledesc'] = 'Установите стиль границы блока заголовков';
$string['blockheaderbottomradius'] = 'Нижний радиус блока заголовка';
$string['blockheaderbottomradiusdesc'] = 'Установить радиус нижнего блока заголовка, чтобы добиться эффекта закругленности';
$string['blockheadercolor'] = 'Цвет шрифта блока заголовка';
$string['blockheadercolordesc'] = 'Установите цвет шрифта блока заголовка';
$string['blockheadertopradius'] = 'Радиус верхнего блока заголовка';
$string['blockheadertopradiusdesc'] = 'Установить радиус верхнего блока заголовка, чтобы добиться эффекта закругленности';
$string['blockicons'] = 'Значки блоков';
$string['blockiconsdesc'] = 'Установите, чтобы показать значки блоков в заголовках блоков';
$string['blockiconsheadersize'] = 'Размер иконки блоков заголовков';
$string['blocklayoutbuilder'] = 'Регионы блоков главной страницы';
$string['blocklayoutlayoutcheck'] = 'Проверьте макет';
$string['blocklayoutlayoutcheckdesc'] = 'Используйте инструмент, который находится внизу, чтобы проверить количество использованных блоков, и увидеть отображение нового расположения.';
$string['blocklayoutlayoutcount1'] = 'Можно использовать максимум';
$string['blocklayoutlayoutcount2'] = 'блоковых областей. Сейчас используется:';
$string['blocklayoutlayoutrow'] = 'Макет ряда доп. блоков';
$string['blocklayoutlayoutrowdesc'] = 'Добавить / настроить макет ряда доп. блоков на главной странице.';
$string['blockmainborderbottom'] = 'Толщина нижней границы главного блока';
$string['blockmainborderbottomdesc'] = 'Установить толщину нижней границы главного блока';
$string['blockmainborderleft'] = 'Толщина левой границы главного блока';
$string['blockmainborderleftdesc'] = 'Установить толщину левой границы главного блока';
$string['blockmainborderright'] = 'Толщина правой границы главного блока';
$string['blockmainborderrightdesc'] = 'Установить толщину правой границы главного блока';
$string['blockmainbordertop'] = 'Толщина верхней границы главного блока';
$string['blockmainbordertopdesc'] = 'Установить толщину верхней границы главного блока';
$string['blockmainbordertopstyle'] = 'Стиль границы главного блока';
$string['blockmainbordertopstyledesc'] = 'Установить стиль границы блока с содержанием';
$string['blockmainbottomradius'] = 'Нижний радиус главного блока';
$string['blockmainbottomradiusdesc'] = 'Установить нижний радиус главного блока, чтобы добиться эффекта закругленности';
$string['blocksettings'] = 'Настройки блока';
$string['blockside'] = 'Расположение блоков';
$string['breadcrumb'] = 'Цвет фона верхнего меню навигации';
$string['breadcrumbhomeicon'] = 'Значки';
$string['breadcrumbhometext'] = 'Текст';
$string['breadcrumbtextcolor'] = 'Цвет текста верхнего меню навигации';
$string['buttoncolor'] = 'Цвет кнопки';
$string['buttonlogincolor'] = 'Цвет кнопки входа';
$string['buttonlogincolordesc'] = 'Цвет кнопки входа';
$string['buttonloginpaddingdesc'] = 'Чем больше число, тем больше кнопка';
$string['buttonlogintextcolor'] = 'Цвет текста кнопки входа';
$string['buttonlogintextcolordesc'] = 'Цвет текста на кнопке входа';
$string['buttonradiusdesc'] = 'Больший радиус = скругленные кнопки; меньший радиус = прямоугольные кнопки';
$string['buttonsettings'] = 'Кнопки';
$string['buttonsettingsheading'] = 'Настроить кнопки данной темы';
$string['buttontextcolor'] = 'Цвет текста кнопок';
$string['buttontextcolordesc'] = 'Цвет текста на кнопках';
$string['categoryheaderssettings'] = 'Заголовки категорий';
$string['categoryheaderssettingsdesc'] = 'Установите настройки для заголовков в категории.';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Adaptable</h2>
<p><img class="img-polaroid" src="adaptable/pix/screenshot.png" /></p>
</div>
<div class="well">
<h2>Сведения об авторах</h2>
<h3>О теме</h3>
<p>Adaptable - это двухколоночная,  хорошо настраиваемая адаптивная тема Moodle, основанная на популярной ранее теме BCU.</p>
<p>Тема распространяется на условиях лицензии GPL (универсальная общественная лицензия GNU). Полный текст лицензии можно найти  <a href="http://www.gnu.org/licenses/" target="_HERE">здесь</a></p>
<h4>Изменяйте ее! - Улучшайте ее! - Делитесь своими наработками!</h4>
<br>
<p>Эта тема создана:<br>
Джереми Хопкинсом (Университет Кавентри),<br>
Фернадо Эйседо (<a href="https://3-bits.com" target="_blank">3-bits.com</a>)</p>
<br>
<p>и многими другими разработчиками, тестерами, переводчиками и волонтерами (см. <a href="adaptable/README.txt" target="_blank">README.txt</a>)</p>
<br>
<h3>Сообщения об ошибках</h3>
<p>Вы можете сообщать об ошибках (и пожалуйста, <b>ТОЛЬКО</b> об ошибках) в нашем <a href="https://bitbucket.org/covuni/moodle-theme_adaptable/issues" target="_blank">репозитории Bitbucket</a></p>
<br>
<h3>Техническая поддержка</h3>
<p>Задавать вопросы, делиться предложениями и опытом можно в форумах moodle:</p>
<ul>
<li>English: <a href="https://moodle.org/mod/forum/discuss.php?d=340404" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340404</a>
<li>Español: <a href="https://moodle.org/mod/forum/discuss.php?d=326804" target="_blank">https://moodle.org/mod/forum/discuss.php?d=326804</a>
<li>Català: <a href="https://moodle.org/mod/forum/discuss.php?d=340406" target="_blank">https://moodle.org/mod/forum/discuss.php?d=340406</a>
</ul>
<br>
<h3>Документация</h3>
<p>...появится скоро</p>
<br>
<h3>Демо-версия</h3>
<p>Увидеть демо-версию можно <a href="https://3-bits.com/demo/adaptable" target="_blank">ЗДЕСЬ</a></p>
<br>
</div>
</div>';
$string['colordesc'] = 'Вы можете настроить цвета, которые хотите использовать в теме. Используйте шестнадцатеричную (Hex) или любую другую общепризнанную систему записи. Как вариант, можно использовать значения "transparent" (прозрачный) и "inherited" (наследуемый)';
$string['colorsettings'] = 'Цвета';
$string['colorsettingsheading'] = 'Изменение основных цветов, используемых в теме';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Курс';
$string['coursepageblocklayoutlayoutbottomrowdesc'] = 'Добавить / настроить макет ряда доп. блоков на странице курса.';
$string['coursepageblocklayoutlayouttoprowdesc'] = 'Добавить / настроить макет ряда доп. блоков на странице курса.';
$string['coursepageblockregionsettings'] = 'Область дополнительных блоков страниц курса';
$string['coursepageblocksenabled'] = 'Включить область дополнительных блоков страниц курса';
$string['coursepagesidebarinfooterenabledsection'] = 'Общие настройки';
$string['courses'] = 'Курсы';
$string['coursesectionactivityfurtherinformationassign'] = 'Показать информацию о задании';
$string['coursesectionactivityfurtherinformationchoice'] = 'Показать информацию об опросе';
$string['coursesectionactivityfurtherinformationdata'] = 'Показать информацию о базе данных';
$string['coursesectionactivityfurtherinformationfeedback'] = 'Показать информацию об обратной связи';
$string['coursesectionactivityfurtherinformationlesson'] = 'Показать информацию о лекции';
$string['coursesectionactivityfurtherinformationquiz'] = 'Показать информацию о тесте';
$string['coursesections'] = 'Разделы курса';
$string['coursesettings'] = 'Разделы (Темы) курса';
$string['coursesettingsheading'] = 'Настройки раздела курса';
$string['coursetitlefullname'] = 'Полное имя курса';
$string['coursetitlemaxwidth'] = 'Максимальная длина заголовка курса';
$string['coursetitlemaxwidthdesc'] = 'Задайте максимальное количество символов для области заголовка курса';
$string['customcss'] = 'Пользовательский CSS';
$string['customcssjssettings'] = 'Пользовательский CSS и JS';
$string['dashblocklayoutbuilder'] = 'Область дополнительных блоков страницы «Личный кабинет»';
$string['dashblocklayoutlayoutrow'] = 'Макет ряда доп. блоков страницы «Личный кабинет»';
$string['dashblocklayoutlayoutrowdesc'] = 'Добавить / настроить макет ряда доп. блоков на странице «Личный кабинет»';
$string['dashboardblockregionsettings'] = 'Область дополнительных блоков страницы «Личный кабинет»';
$string['defaultzoom'] = 'Масштаб по умолчанию';
$string['disabled'] = 'Отключено';
$string['discardbuttontext'] = 'Отмена';
$string['displayeditingbuttontext'] = 'Редактирование текста кнопки';
$string['displayloginbox'] = 'Окно входа';
$string['displayloginbutton'] = 'Кнопка';
$string['displayloginno'] = 'Нет окна входа';
$string['displayparticipants'] = 'Показать участников';
$string['emoticonsize'] = 'Размер смайликов';
$string['enablealert'] = 'Включить окно предупреждения {$a}';
$string['enablealertdesc'] = 'Включить окно предупреждения {$a}';
$string['enablealerts'] = 'Включить/Выключить предупреждения';
$string['enablealertsdesc'] = 'Включить/Выключить предупреждения на сайте';
$string['enablealertstriptags'] = 'Автоматически удалять теги html из предупреждений';
$string['enablealertstriptagsdesc'] = 'Включение опции позволит автоматически очищать тексты предупреждений. Отключение опции разрешает использовать в текстах предупреждений html и ссылки, но вам потребуется самостоятельно проводить чистку в режиме просмотра html';
$string['enableanalytics'] = 'Включить Аналитику Google';
$string['enablebadges'] = 'Значки';
$string['enablebadgesdesc'] = 'Отображать ссылку на значки пользователей';
$string['enableblog'] = 'Мои блоги';
$string['enableblogdesc'] = 'Отображать ссылку на страницу блогов пользователей';
$string['enablecalendar'] = 'Календарь пользователя';
$string['enablecalendardesc'] = 'Отображать ссылку на календарь пользователя';
$string['enabledtabbedprofileeditprofilelink'] = 'Разрешить редактировать ссылку на профиль';
$string['enabledtabbedprofileuserpreferenceslink'] = 'Разрешить ссылку на настройки';
$string['enableeditprofile'] = 'Редактировать профиль';
$string['enableeditprofiledesc'] = 'Отображать ссылку на редактирование профиля пользователя';
$string['enableeventsdesc'] = 'Отображать ссылку на календарь';
$string['enablefeed'] = 'Моя обратная связь';
$string['enablegrades'] = 'Оценки';
$string['enablegradesdesc'] = 'Отображать ссылку на оценки пользователей';
$string['enablehelp'] = 'Ссылка на справку';
$string['enablehelpdesc'] = 'Добавить в навигационную панель ссылку на справку.';
$string['enablehomedesc'] = 'Показать ссылку на главную страницу.';
$string['enablehomeredirect'] = 'Отключить перенаправление для ссылки "В начало".';
$string['enablehomeredirectdesc'] = 'Устанавливает redirect=0 для ссылки "В начало". Эта настройка используется на сайтах, для которых Личный кабинет - домашняя страница по умолчанию. С ее помощью предотвращается обратный переход в Личный кабинет по ссылке "В начало" (ссылка "В начало" начинает вести на главную страницу сайта).';
$string['enablemenus'] = 'Включить меню';
$string['enablemy'] = 'Моя домашняя страница';
$string['enablemydesc'] = 'Показать ссылку на домашнюю страницу';
$string['enablemyhomedesc'] = 'Показать ссылку на {$a}';
$string['enablemysitesdesc'] = 'Показать выпадающее меню со списком курсов, на которые записан пользователь';
$string['enablenavbarwhenloggedout'] = 'Включить панель навигации при выходе';
$string['enablenote'] = 'Мои уведомления';
$string['enablenotedesc'] = 'Отображать ссылку на страницу уведомлений пользователя';
$string['enableposts'] = 'Мои сообщения';
$string['enablepostsdesc'] = 'Отображать ссылку на страницу моих сообщений';
$string['enablepref'] = 'Мои настройки';
$string['enableprefdesc'] = 'Отображать ссылку на страницу пользовательских настроек';
$string['enableprivatefiles'] = 'Мои личные файлы';
$string['enableprofile'] = 'Профиль пользователя';
$string['enableprofiledesc'] = 'Отображать ссылку на профиль пользователя';
$string['enablesearchbox'] = 'Включить окно поиска';
$string['enablesearchboxdesc'] = 'Показать в заголовке окно поиска';
$string['enableticker'] = 'Отображать новостную ленту на главной странице?';
$string['enabletickerc'] = 'Отображать новостную ленту на внутренних страницах?';
$string['enabletickercdesc'] = 'Установите галочку, чтобы показывать новостную ленту на внутренних страницах';
$string['enabletickerdesc'] = 'Установите галочку, чтобы включить новостную ленту';
$string['enabletickermy'] = 'Отображать новостную ленту на домашней странице / в личном кабинете?';
$string['enabletickermydesc'] = 'Установите галочку, чтобы показывать новостную ленту на домашней странице / в личном кабинете.';
$string['enablezoom'] = 'Включить режим "Во весь экран"';
$string['enablezoomdesc'] = 'Разрешает пользователю переключаться между полноэкранным режимом и режимом фиксированной ширины.';
$string['events'] = 'События';
$string['fontcolor'] = 'Основной цвет шрифта';
$string['fontheadercolor'] = 'Цвет шрифта верхнего колонтитула';
$string['fontheadername'] = 'Шрифт верхнего колонтитула';
$string['fontname'] = 'Основной шрифт';
$string['fontsettings'] = 'Шрифты';
$string['fonttitlecolor'] = 'Цвет шрифта заголовка сайта';
$string['fonttitlecolorcourse'] = 'Цвет шрифта названия курса';
$string['fonttitlecolorcoursedesc'] = 'Установите для данной темы цвет шрифта названия курса, используя шестнадцатеричный (hex) код html.';
$string['fonttitlecolordesc'] = 'Установите для данной темы цвет шрифта заголовка сайта, используя шестнадцатеричный (hex) код html.';
$string['fonttitlename'] = 'Шрифт заголовка сайта';
$string['fonttitlenamedesc'] = 'Выберите шрифт по умолчанию или <a href="https://www.google.com/fonts" target="_blank">шрифты Google</a> для заголовка сайта.';
$string['fonttitlesize'] = 'Размер шрифта заголовка сайта';
$string['fonttitlesizedesc'] = 'Размер шрифта заголовка сайта, используемый на сайте. Выберите значение из списка.';
$string['fonttitleweight'] = 'Начертание шрифта заголовка сайта';
$string['fonttitleweightdesc'] = 'Установите начертание шрифта заголовка сайта. Введите значение от 100 до 900 в зависимости от выбранного шрифта (100 - сверхсветлое начертание; 400 - обычное; 700 - полужирное; 900 - сверхжирное).';
$string['fontweight'] = 'Начертание основного шрифта';
$string['fontweightdesc'] = 'Начертание шрифта сайта. Введите значение от 100 до 900 в зависимости от выбранного шрифта (100 - сверхсветлое начертание; 400 - обычное; 700 - полужирное; 900 - сверхжирное).';
$string['footerbkcolor'] = 'Цвет фона нижнего колонтитула';
$string['footerbkcolordesc'] = 'Установите фоновый цвет нижнего колонтитула.';
$string['footerblocksplacement'] = 'Расположение блоков в нижнем колонтитуле';
$string['footerblocksplacement1'] = 'по всему сайту';
$string['footerblocksplacement2'] = 'только на домашней странице';
$string['footerblocksplacement3'] = 'вообще не показывать';
$string['footercontent'] = 'Раздел содержания нижнего колонтитула';
$string['footercontentdesc'] = 'Добавить содержимое в нижний колонтитул';
$string['footerdesc'] = 'Добавить заголовок нижнего колонтитула';
$string['footerheader'] = 'Заголовок раздела нижнего колонтитула';
$string['footerlayoutrow'] = 'Компоновщик нижнего колонтитула';
$string['footerlayoutrowdesc'] = 'Разработайте собственную структуру блоков нижнего колонтитула.';
$string['footerlinkcolor'] = 'Цвет ссылки блоков нижнего колонтитула';
$string['footerlinkcolordesc'] = 'Цвет ссылки блоков нижнего колонтитула';
$string['footersettings'] = 'Нижний колонтитул';
$string['footersettingsheading'] = 'Настройте содержимое, которое должно отображаться в нижнем колонтитуле. См. структуру <a href="./../theme/adaptable/pix/layout.png" target="_blank"> здесь</a>';
$string['footertextcolor'] = 'Цвет текста нижнего колонтитула';
$string['footnote'] = 'Сноска';
$string['footnotedesc'] = 'Добавить текст в нижний колонтитул';
$string['frontpagealertsettings'] = 'Окно предупреждения';
$string['frontpageblockregionsettings'] = 'Область дополнительных блоков главной страницы';
$string['frontpageblocksenabled'] = 'Включить область дополнительных блоков на главной странице';
$string['frontpageblocksettings'] = 'Рекламные блоки';
$string['frontpagecoursesettings'] = 'Курсы главной страницы';
$string['frontpagemarketenabled'] = 'Включить рекламные блоки';
$string['frontpagemarketenableddesc'] = 'Установить рекламные блоки на главной странице';
$string['frontpagemarketoption'] = 'Выберите стиль для рекламных блоков';
$string['frontpagerendererdefaultimage'] = 'Изображение курса по умолчанию';
$string['frontpagerendereroption1'] = 'Плитка';
$string['frontpagerendereroption2'] = 'Плитка с наложением';
$string['frontpagerendereroption3'] = 'Стандартный стиль Moodle';
$string['frontpagerendereroption4'] = 'Плитка выдвижная';
$string['frontpageslidersettings'] = 'Слайдер главной страницы';
$string['frontpagetickersettings'] = 'Новостная лента главной страницы';
$string['frontpagetiles1'] = '1 плитка';
$string['frontpagetiles2'] = '2 плитки';
$string['frontpagetiles3'] = '3 плитки';
$string['frontpagetiles4'] = '4 плитки';
$string['frontpagetiles6'] = '6 плиток';
$string['fullscreen'] = 'Во весь экран';
$string['fullscreenwidth'] = 'Ширина на весь экран';
$string['fullscreenwidthdesc'] = 'Установите максимальную ширину темы для полноэкранного режима / масштабирования';
$string['genericsettingsdescription'] = 'Здесь вы можете найти различные настройки, чтобы добавить в тему свой собственный код CSS и JavaScript.';
$string['genericsettingsheading'] = 'Примените свои собственные модификации';
$string['googleanalyticssettings'] = 'Google Analytics';
$string['googleanalyticssettingsdesc'] = 'Вы можете настроить несколько кодов для Google Analytics и привязать их к полям профиля пользователя.';
$string['googleanalyticssettingsheading'] = 'Настройте Google Analytics для своего сайта';
$string['headerbgimage'] = 'Фоновое изображение';
$string['headerbgimagedesc'] = 'Установите фоновое изображение в заголовке. Минимальный размер 1600x180px (рекомендуется 1900x180px). Изображение охватывает весь заголовок. Вы можете добавить цвет в «Цвет фона верхнего колонтитула» или использовать <i> прозрачность </i>, чтобы показать фоновое изображение. В этом случае подберите цвет текста, чтобы он был виден поверх изображения.';
$string['headerbkcolor'] = 'Цвет фона верхнего заголовка';
$string['headerbkcolor2'] = 'Цвет фона нижнего заголовка';
$string['headerbkcolor2desc'] = 'Установите цвет фона нижнего заголовка.';
$string['headerbkcolordesc'] = 'Установите цвет фона верхнего заголовка';
$string['headerdesc'] = 'Загрузите ваш значок, логотип, установите в заголовке форму входа, измените название заголовка. <br />
Вы можете задать для названия размер шрифта и стили на странице<a href="./../admin/settings.php?section=theme_adaptable_font"> настроек шрифтов</a>.';
$string['headernavbarhelpheading'] = 'Ссылки на справки и параметры';
$string['headernavbarhelpheadingdesc'] = 'Параметры меню ссылок на справки.';
$string['headernavbarmycoursesheading'] = 'Меню моих курсов';
$string['headernavbarmycoursesheadingdesc'] = 'Все параметры для пункта меню «Мои курсы» («Мои сайты»), в котором отображается список курсов текущего пользователя';
$string['headernavbarthiscourseheading'] = 'Меню курса';
$string['headernavbarthiscourseheadingdesc'] = 'Это меню предоставляет студенту прямой доступ ко всем элементам курса, а также к списку участников и своим оценкам.';
$string['headersettings'] = 'Заголовок';
$string['headersettingsheading'] = 'Настройте заголовок этой темы. Макет можно<a href="./../theme/adaptable/pix/layout.png" target="_blank"> посмотреть здесь</a>.';
$string['headerstyle'] = 'Стиль заголовка';
$string['headertextcolor'] = 'Цвет текста и ссылок в блоках верхнего колонтитула';
$string['headertextcolor2'] = 'Цвет текста и ссылок в блоках нижнего колонтитула';
$string['headertextcolor2desc'] = 'Задайте цвет текста и ссылок для блоков нижнего колонтитула.';
$string['headertextcolordesc'] = 'Задайте цвет текста и ссылок для блоков верхнего колонтитула.';
$string['help'] = 'Справка';
$string['helpprofilefield'] = 'Справка пользовательского поля профиля (необязательно)';
$string['helpprofilefielddesc'] = 'Добавьте правило доступа, используя пользовательское поле профиля, например: usertype=student';
$string['helptarget'] = 'Открывать справку в';
$string['helptargetdesc'] = 'Открывать ссылки на справочную подсистему в новом окне?';
$string['helptitle'] = 'Справка';
$string['hiddencourses'] = 'Скрытые курсы';
$string['hide'] = 'Скрыть';
$string['hideblocks'] = 'Скрыть блоки';
$string['hidefootersocial'] = 'Показать иконки соцсетей';
$string['hidefootersocialdesc'] = 'Показывать иконки соцсетей в нижнем колонтитуле под блоками.';
$string['hideinforum'] = 'Скрыть справку и инструменты в форумах';
$string['hideinforumdesc'] = 'При использовании фиксированной ширины и всех опций меню поле поиска в форуме переезжает на строку ниже. Выбор данного параметра приведет к скрытию инструментов и элементов меню справки в форуме, что позволит правильно отобразить его.';
$string['home'] = 'Главная';
$string['homebk'] = 'Изображение фона главной страницы';
$string['homebkdesc'] = 'Загрузите изображение, которое будет фоном на главной странице.';
$string['infobox'] = 'Информационное окно главной страницы';
$string['infobox2'] = 'Второе информационное окно главной страницы';
$string['layoutcheck'] = 'Проверьте макет';
$string['layoutsettings'] = 'Расположение';
$string['leftblocks'] = 'Слева';
$string['linkcolor'] = 'Цвет ссылки';
$string['linkcolordesc'] = 'Цвет ссылок в данной теме (используйте шестнадцатеричный html код).';
$string['linkhover'] = 'Цвет ссылки под курсором';
$string['linkhoverdesc'] = 'Цвет ссылок при наведении на них курсора мыши (используйте шестнадцатеричный html код).';
$string['linksmenu'] = 'Меню ссылок';
$string['loadingcolor'] = 'Цвет полосы загрузки';
$string['loadingcolordesc'] = 'Цвет полосы загрузки в верхней части страницы';
$string['loginbgimage'] = 'Фоновое изображение';
$string['loginbgstyle'] = 'Фоновый стиль страницы входа';
$string['loginfooter'] = 'Нижний колонтитул страницы входа';
$string['loginfooterdesc'] = 'Показать нижний колонтитул страницы входа';
$string['loginheader'] = 'Верхний колонтитул страницы входа';
$string['loginheaderdesc'] = 'Показать верхний колонтитул страницы входа';
$string['loginplaceholder'] = 'Логин';
$string['loginsettings'] = 'Страница входа';
$string['logintextbutton'] = 'Вход';
$string['logo'] = 'Логотип';
$string['logodesc'] = 'Закачайте логотип своего сайта. Рекомендуемый размер 200 x 80 пикселей';
$string['maincolor'] = 'Основной цвет';
$string['maincolordesc'] = 'Основной цвет для блоков и нижнего колонтитула.';
$string['maincoursepage'] = 'Главная страница курса';
$string['market'] = 'Рекламный блок';
$string['marketblockbordercolor'] = 'Цвет границы рекламного блока';
$string['marketingbuilderheading'] = 'Построитель макета рекламных блоков';
$string['marketingsettings'] = 'Рекламные блоки';
$string['marketlayoutrow'] = 'Макет ряда рекламных блоков';
$string['marketlayoutrowdesc'] = 'Добавить / настроить макет ряда рекламных блоков на главной странице';
$string['menubkcolor'] = 'Цвет фона основного меню';
$string['menubkcolordesc'] = 'Установка цвета фона основного меню';
$string['menubordercolor'] = 'Цвет нижней границы основного меню';
$string['menubordercolordesc'] = 'Установка цвета нижней границы основного меню';
$string['menufontcolor'] = 'Цвет шрифта основного меню';
$string['menufontcolordesc'] = 'Настройка цвета шрифта основного меню';
$string['menusettings'] = 'Главное меню';
$string['moodledocs'] = 'Ссылка на документацию Moodle';
$string['moodledocsdesc'] = 'Показывать в нижнем колонтитуле ссылку на документацию Moodle';
$string['more'] = 'Больше';
$string['myblogs'] = 'Мои блоги';
$string['mysites'] = 'Мои курсы';
$string['mysitesdisabled'] = 'Отключить';
$string['mysitesexclude'] = 'Включить, кроме скрытых курсов';
$string['mysitesinclude'] = 'Включить, отображать скрытые курсы';
$string['mysitesmaxlength'] = 'Максимальная длина текста в меню «Мои курсы»';
$string['mysitesmaxlengthdesc'] = 'Установите максимальную длину названий курсов в выпадающем меню «Мои курсы» (ширина выпадающего меню постоянна; эта настройка используется, чтобы текст не вылезал за пределы меню).';
$string['mysitessortoverride'] = 'Включить настраиваемую сортировку "Моих курсов"';
$string['mysitessortoverridedesc'] = 'Используйте специальные поля профиля или общие строки (год и др.), чтобы свернуть прошлые курсы в подменю';
$string['navbardropdowntextcolor'] = 'Цвет текста выпадающего меню';
$string['navbardropdowntextcolordesc'] = 'Цвет текста пунктов в выпадающем меню';
$string['navbarsettings'] = 'Навигационная панель заголовка';
$string['navbarsettingsheading'] = 'Настройка навигационной панели';
$string['newmenuheading'] = 'Верхнее меню';
$string['newmenurequirelogin'] = 'Требовать вход';
$string['newmenutitle'] = 'Заголовок верхнего меню';
$string['newmenutitledefault'] = 'Меню';
$string['newstickercount'] = 'Число новостных лент';
$string['newstickercountdesc'] = 'Можно использовать несколько новостных лент, чтобы показывать разные новости - в зависимости от роли пользователя на сайте';
$string['nextactivity'] = 'Следующий акт. элемент';
$string['nextsection'] = 'Следующий раздел';
$string['noenrolments'] = 'Записей не найдено.';
$string['nostyle'] = 'Нет стиля';
$string['notanswered'] = 'Нет ответа';
$string['notattempted'] = 'Нет попыток';
$string['overdue'] = 'Просроченный';
$string['pageheaderheight'] = 'Высота заголовка страницы';
$string['passwordplaceholder'] = 'Пароль';
$string['pastcourses'] = 'Прошлые курсы';
$string['people'] = 'Участники';
$string['piwikenabled'] = 'Включено';
$string['piwiksiteid'] = 'Идентификатор сайта';
$string['piwiksiteiddesc'] = 'Введите ID вашего сайта.';
$string['pluginname'] = 'Adaptable';
$string['previousactivity'] = 'Предыдущий акт. элемент';
$string['previoussection'] = 'Предыдущий раздел';
$string['properties'] = 'Настройки импорта / экспорта';
$string['propertiesproperty'] = 'Свойство';
$string['propertiesreturn'] = 'Вернуть';
$string['propertiesvalue'] = 'Значение';
$string['putpropertiesadded'] = 'Добавленные:';
$string['putpropertieschanged'] = 'Измененные:';
$string['putpropertiesfrom'] = 'от';
$string['putpropertiesheading'] = 'Импорт настроек темы';
$string['putpropertiesignored'] = 'Игнорируемые:';
$string['putpropertiesname'] = 'Импорт свойств';
$string['putpropertiessettingsreport'] = 'Отчет о настройках:';
$string['putpropertiesunchanged'] = 'Без изменений:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyproperties'] = 'Свойства';
$string['putpropertyreport'] = 'Отчет:';
$string['putpropertyversion'] = 'версия:';
$string['region-frnt-footer'] = 'нижний колонтитул';
$string['region-frnt-market-a'] = 'Область страницы 1';
$string['region-frnt-market-b'] = 'Область страницы 2';
$string['region-frnt-market-c'] = 'Область страницы 3';
$string['region-frnt-market-d'] = 'Область страницы 4';
$string['region-frnt-market-e'] = 'Область страницы 5';
$string['region-frnt-market-f'] = 'Область страницы 6';
$string['region-frnt-market-g'] = 'Область страницы 7';
$string['region-frnt-market-h'] = 'Область страницы 8';
$string['region-frnt-market-i'] = 'Область страницы 9';
$string['region-frnt-market-j'] = 'Область страницы 10';
$string['region-frnt-market-k'] = 'Область страницы 11';
$string['region-frnt-market-l'] = 'Область страницы 12';
$string['region-frnt-market-m'] = 'Область страницы 13';
$string['region-frnt-market-n'] = 'Область страницы 14';
$string['region-frnt-market-o'] = 'Область страницы 15';
$string['region-frnt-market-p'] = 'Область страницы 16';
$string['region-frnt-market-q'] = 'Область страницы 17';
$string['region-frnt-market-r'] = 'Область страницы 18';
$string['region-frnt-market-s'] = 'Область страницы 19';
$string['region-frnt-market-t'] = 'Область страницы 20';
$string['region-middle'] = 'По середине';
$string['region-side-post'] = 'Справа';
$string['region-side-pre'] = 'Слева';
$string['regionmaincolor'] = 'Цвет основной области';
$string['regionmaincolordesc'] = 'Цвет фона области основного содержимого.';
$string['rightblocks'] = 'Справа';
$string['savebuttontext'] = 'Сохранить изменения';
$string['searchboxpadding'] = 'Отступ в окне поиска';
$string['searchcourses'] = 'Поиск курсов';
$string['sectionheadingcolor'] = 'Цвет заголовка раздела';
$string['sectionheadingcolordesc'] = 'Установите цвет текста заголовков разделов';
$string['sections'] = 'Разделы';
$string['selectionbackground'] = 'Цвет фона выделения';
$string['selectionbackgrounddesc'] = 'Цвет фона, когда текст на экране выделен.';
$string['selectiontext'] = 'Цвет выделенного текста';
$string['selectiontextdesc'] = 'Цвет текста, когда он выделен на экране.';
$string['settingsalertbox'] = 'Окно предупреждения';
$string['settingsanalytics'] = 'Аналитика';
$string['settingsblockicons'] = 'Значки';
$string['settingsborders'] = 'Границы';
$string['settingsbreadcrumbcolors'] = 'Цвет меню навигации';
$string['settingscolors'] = 'Цвета';
$string['settingsfonts'] = 'Шрифты';
$string['settingsfootercolors'] = 'Цвета нижнего колонтитула';
$string['settingsforumheading'] = 'Форум';
$string['settingsheadercolors'] = 'Цвета верхнего колонтитула';
$string['settingsinfoboxcolors'] = 'Цвета окна информации';
$string['settingsmaincolors'] = 'Основные цвета';
$string['settingsmarketingcolors'] = 'Цвета рекламного блока';
$string['settingsmessagescolors'] = 'Цвета всплывающих сообщений';
$string['settingsnavbarcolors'] = 'Цвета навигационной панели';
$string['settingstopicsweeks'] = 'Разделы / Недели';
$string['show'] = 'Показать';
$string['showblocks'] = 'Показать блоки';
$string['showfooterblocks'] = 'Показать блоки нижнего колонтитула';
$string['showfooterblocksdesc'] = 'Показать / скрыть четыре настраиваемых блока нижнего колонтитула';
$string['showusername'] = 'Показать имя пользователя';
$string['showyourprogress'] = 'Показать ссылку "Ваш прогресс"';
$string['sidebaricon'] = 'Показать / скрыть боковую панель';
$string['sidebarnotlogged'] = 'Показывать боковую панель, когда не вошли в систему';
$string['sitetitle'] = 'Показывать название сайта';
$string['sitetitlecoursesdisabled'] = 'Отключено - показывать только названия курсов на странице курсов';
$string['sitetitlecoursesenabled'] = 'Включено - показывать названия сайта и курсов на странице курсов';
$string['sitetitlecustom'] = 'Использовать настраиваемое имя сайта (введите в текстовом поле ниже)';
$string['sitetitledefault'] = 'Использовать имя сайта Moodle';
$string['sitetitledesc'] = 'Отображать имя сайта Moodle из <a href="./../admin/settings.php?section=frontpagesettings" target="_blank">Настроек Главной Страницы</a> или использовать настраиваемое имя сайта (заданное в текстовом поле ниже). Если вы добавите логотип, то имя не будет отображаться.';
$string['sitetitleoff'] = 'Отключить заголовок сайта';
$string['sitetitletext'] = 'Имя сайта';
$string['sitetitletextdesc'] = 'Имя сайта, отображаемое в заголовке. Вы можете использовать любой тег HTML и применять встроенные стили.';
$string['slider2h3bgcolor'] = 'Цвет фона слайдера 2 (H3)';
$string['slider2h3bgcolordesc'] = 'Выберите цвет фона, который хотите использовать в теге слайдера 2 (H3)';
$string['slider2h3color'] = 'Цвет текста слайдера 2 (H3)';
$string['slider2h3colordesc'] = 'Выберите цвет текста, который хотите использовать в теге слайдера 2 (H3)';
$string['slider2h4bgcolor'] = 'Цвет фона слайдера 2 (H4)';
$string['slider2h4bgcolordesc'] = 'Выберите цвет фона, который хотите использовать в теге слайдера 2 (H4)';
$string['slider2h4color'] = 'Цвет текста слайдера 2 (H4)';
$string['slider2h4colordesc'] = 'Выберите цвет текста, который хотите использовать в теге слайдера 2 (H4)';
$string['slidercaption'] = 'Заголовок слайдера';
$string['slidercaptiondesc'] = 'Добавьте заголовок к слайду';
$string['slidercount'] = 'Число слайдов';
$string['slidercountdesc'] = 'Выберите число слайдов, которое хотите добавить, <strong>затем нажмите СОХРАНИТЬ</strong>, чтобы отобразить поля ввода.';
$string['sliderenabled'] = 'Включить слайдер';
$string['sliderenableddesc'] = 'Включить слайдер вверху домашней страницы';
$string['sliderfullscreen'] = 'Полный текст слайда';
$string['sliderfullscreendesc'] = 'Установите этот флажок, чтобы сделать слайдер полноэкранным (ширина 100%)';
$string['sliderh3color'] = 'Цвет слайдера 1 (H3)';
$string['sliderh3colordesc'] = 'Выберите нужный цвет для тега H3 слайдера 1';
$string['sliderh4color'] = 'Цвет слайдера 1 (H4)';
$string['sliderh4colordesc'] = 'Выберите нужный цвет для тега H4 слайдера 1';
$string['slideroption2'] = 'Выберите тип слайдера';
$string['sliderstyle1'] = 'Стиль слайдера 1';
$string['sliderstyle2'] = 'Стиль слайдера 2';
$string['slideshowsettings'] = 'Слайд-шоу';
$string['socialheading'] = 'Настройки значков социальных сетей';
$string['socialicondesc'] = 'Установите значок из шрифта Font Awesome, например: fa-facebook';
$string['socialiconlist'] = 'Список значков социальных сетей';
$string['socialiconlistdesc'] = 'Введите список для настройки значков социальных сетей / ссылок в формате:
URL-адрес|название|значок';
$string['socialorsearch'] = 'Использовать поле поиска или значки социальных сетей';
$string['socialorsearchdesc'] = 'В заголовке можно отображать или строку поиска, или значки социальных сетей. <br />
Настроить значки социальных сетей можно на странице<a href="./../admin/settings.php?section=theme_adaptable_social">Социальные сети</a></strong>.';
$string['socialorsearchsearch'] = 'Показать окно поиска в верхнем колонтитуле';
$string['socialorsearchsocial'] = 'Показать значки социальных сетей в верхнем колонтитуле';
$string['socialpaddingtop'] = 'Настройка отступа над значками социальных сетей (меняет вертикальное положение)';
$string['socialsearchicon'] = 'Поиск Moodle';
$string['socialsearchicondesc'] = 'Включите для размещения ссылки поиска вместе со значками социальных сетей (так как использование раздела социальных сетей отключает поле поиска)';
$string['socialsettings'] = 'Социальные сети';
$string['socialsize'] = 'Размер шрифта значков социальных сетей';
$string['socialtarget'] = 'Открывать ссылки на социальные сети в';
$string['socialtargetdesc'] = 'Установите, как открывать ссылки на социальные сети (в этом же или новом окне)';
$string['socialtitledesc'] = '<pre>Можно убрать поле поиска по сайту и поместить значки социальных сетей / ссылки на его место.
Чтобы настроить значки, введите данные в поле «Список значков социальных сетей» ниже в таком формате:

URL-адрес|название|значок

Например:

http://localhost/moodle/course/search.php|Поиск Moodle|fa-search
https://facebook.com/|Facebook|fa-facebook-square
https://twitter.com/|Twitter|fa-twitter-square
https://instagram.com|Instagram|fa-instagram
http://example.com|Mi Web|fa-globe

Для информации - полный список значков шрифта Font Awesome  можно <a href="https://fortawesome.github.io/Font-Awesome/icons/">найти тут</a></pre>';
$string['socialwall'] = 'Социальная стена';
$string['socialwallactionlinkcolor'] = 'Цвет активной ссылки';
$string['socialwallactionlinkcolordesc'] = 'Цвет активных ссылок в курсе формата «Социальная стена»';
$string['socialwallactionlinkhovercolor'] = 'Цвет ссылки при наведении';
$string['socialwallactionlinkhovercolordesc'] = 'Цвет ссылки при наведении курсора мыши в курсе формата «Социальная стена»';
$string['socialwallbackgroundcolor'] = 'Цвет фона';
$string['socialwallbackgroundcolordesc'] = 'Цвет фона в курсе формата «Социальная стена»';
$string['socialwallbordercolor'] = 'Цвет рамки';
$string['socialwallbordercolordesc'] = 'Цвет рамки разделов в курсе формата «Социальная стена»';
$string['socialwallbordertopstyle'] = 'Стиль рамки';
$string['socialwallbordertopstyledesc'] = 'Стиль рамки разделов в курсе формата «Социальная стена»';
$string['socialwallborderwidth'] = 'Ширина рамки';
$string['socialwallborderwidthdesc'] = 'Ширина рамки разделов в курсе формата «Социальная стена»';
$string['socialwalldesc'] = 'Настройка отображения <a href="https://moodle.org/plugins/format_socialwall">формата курса «Социальная стена»</a> (если используется на вашем сайте)';
$string['socialwallheading'] = 'Настройки «Социальной стены»';
$string['socialwallsectionradius'] = 'Радиус рамки';
$string['socialwallsectionradiusdesc'] = 'Радиус рамки разделов в курсе формата «Социальная стена»';
$string['standard'] = '1170px';
$string['standardview'] = 'Стандартный вид';
$string['static'] = 'Статично';
$string['stickynavbar'] = 'Закрепить навигационную панель сверху';
$string['stickynavbardesc'] = 'Позволяет закрепить навигационную панель в верхней части экрана при прокрутке вниз.';
$string['tabbedlayouttablabelcourse'] = 'Содержание курса';
$string['tabbedlayouttablabelcourse1'] = 'Вкладка 1';
$string['tabbedlayouttablabelcourse2'] = 'Вкладка 2';
$string['tabbedlayouttablabeldashboard1'] = 'Вкладка 1';
$string['tabbedlayouttablabeldashboard2'] = 'Вкладка 2';
$string['targetnewwindow'] = 'Новое окно';
$string['targetsamewindow'] = 'То же окно';
$string['thiscourse'] = 'Этот курс';
$string['ticker'] = 'Объявления';
$string['tickerdefault'] = 'Нет новостей для отображения';
$string['tickerdesc'] = 'Здесь можно настроить новостную ленту главной страницы вашего сайта.
 Новостная лента - это менее навязчивая альтернатива слайдеру, занимающая совсем немного места.
 Чтобы настроить ленту, просто введите текст новости в соответствующее поле (каждую новость - с новой строки!). Разрешено использовать гиперссылки.<br />
  <strong>Внимание:</strong> если новостная лента загружается неверно, переключитесь в вид HTML и убедитесь, что вы используете только теги "p":
<pre>
<p>Первая новость.....</p>
<p>Вторая новость.....</p>
</pre>';
$string['tickersettings'] = 'Новостная лента';
$string['tickersettingsheading'] = 'Настройка новостной ленты главной страницы. См. оригинал-макет <a href="./../theme/adaptable/pix/layout.png" target="_blank">здесь</a>';
$string['tickertext'] = 'Текст новостной ленты';
$string['tickertextdesc'] = 'Введите текст новости в данное поле (каждую новость - с новой строки!). В файле "read me" приведена более подробная информация.';
$string['tickertextprofilefield'] = 'Имя поля профиля пользователя=Значение (не обязательно)';
$string['tickertextprofilefielddesc'] = 'Добавьте правило доступа, используя значения полей профиля пользователя, например: usertype=student';
$string['tickerwidth'] = 'Ширина новостной ленты';
$string['tickerwidthdesc'] = 'Можно ограничить ширину новостной ленты 100%-ной шириной страницы сайта.';
$string['tilescontactstitle'] = 'Показать роли контактов курса';
$string['tilescontactstitledesc'] = 'Показать / скрыть роль контакта курса. Если скрыть, то перед каждым контактом будет показано изображение.';
$string['tilesshowallcontacts'] = 'Показывать все контакты курса';
$string['tilesshowallcontactsdesc'] = 'Показывать только один контакт курса или все';
$string['tilesshowcontacts'] = 'Показывать контакты курса';
$string['tilesshowcontactsdesc'] = 'Показать / скрыть контакты курса';
$string['toolsmenu'] = 'Выпадающее меню инструментов';
$string['toolsmenu2'] = 'Второе меню инструментов';
$string['toolsmenu2desc'] = 'Можно настроить ссылки, отображаемые в меню инструментов. Каждая строка состоит из некоторого текста, URL-адреса ссылки (опционально), подсказки (опционально) и кода языка или списка кодов, разделенных запятыми (опционально, для отображения строки только пользователям, у которых выбран заданный язык). Элементы строки разделяются символом вертикальной черты. Структурировать строки можно при помощи дефисов. Например:
<pre>
Сообщество Moodle|https://moodle.org
-Бесплатная поддержка Moodle|https://moodle.org/support
-Разработка Moodle|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--Русский сайт Moodle Docs|http://docs.moodle.org/ru|Документация на русском|ru
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenudesc'] = 'Добавить выпадающее меню к главной навигационной панели';
$string['toolsmenufield'] = 'Имя заданного поля профиля=Значение (опционально)';
$string['toolsmenufielddesc'] = 'Добавление прав доступа для заданного поля профиля, например: usertype=student';
$string['toolsmenuheading'] = 'Меню инструментов';
$string['toolsmenulabel'] = 'Меню инструментов';
$string['toolsmenulabel2'] = 'Инструменты 2';
$string['toolsmenuscount'] = 'Число меню инструментов';
$string['toolsmenutitle'] = 'Заголовок меню инструментов';
$string['toolsmenutitledefault'] = 'Инструменты';
$string['topmenufontsize'] = 'Размер шрифта верхнего меню';
$string['topmenufontsizedesc'] = 'Настройка размера шрифта верхних меню';
$string['topmenuscount'] = 'Число верхних меню';
$string['usermenu'] = 'Меню пользователя';
$string['usersettings'] = 'Профиль пользователя';
$string['wide'] = 'В полный экран';
$string['xofyattempted'] = 'Попыток - {$a->completed} из {$a->participants}';
$string['xofysubmitted'] = 'Отправленных - {$a->completed} из {$a->participants}';
$string['xungraded'] = 'Не оценено - {$a}';
