<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fordson', language 'hu', version '3.8'.
 *
 * @package     theme_fordson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconsize'] = 'Tevékenységikon mérete';
$string['activityiconsize_desc'] = 'A kurzusokban használt tevékenységikonok méretének beállítása.';
$string['activitylinkstitle'] = 'Tevékenységek';
$string['activitylinkstitle_desc'] = 'A kurzus összes tevékenységének megjelenítése';
$string['activitymenu'] = 'Csoportosított tevékenységek menüje';
$string['activitymenu_desc'] = 'A csoportosított tevékenységek megjelenítése a tanulói és tanári paneleken. Ez a menü megjeleníti az összes tevékenység csoportosított listáját a tanulók és tanárok részére.';
$string['advancedsettings'] = 'További beállítások';
$string['alert'] = 'Honlapriasztás';
$string['alert_desc'] = 'Ez egy különleges figyelmeztető üzenet, amely megjelenik a honlapon.';
$string['backgroundimage'] = 'Alapértelmezett háttérkép';
$string['backgroundimage_desc'] = 'Az oldalak alapértelmezett háttérképe';
$string['backtotop'] = 'Vissza az elejére a ScrollSpy használatával';
$string['badges'] = 'Kitűzők';
$string['badges_desc'] = 'Tanulók jutalmazása';
$string['blockdisplay'] = 'Blokk megjelenítési helyek beállítása';
$string['blockdisplay_desc'] = 'A kezdőoldalon és a kurzusoldalakon lévő blokkok megjelenésének kiválasztása. A Fordson megjelenít egy 3 oszlopos, összecsukható blokkpanelt, amelyet a felhasználó elrejthet. Az "Alapértelmezett Boost" kiválasztásával a blokkok elhelyezhetők egyetlen, jobb oldali oszlopban. A Boost alapbeállítása esetén a Blokk hozzáadása gomb is visszakerül a bal oldalon található navigációs fiókba. A fenti beállítások közül bármelyik Boost oldalelrendezés használatához ajánlott az „Alapértelmezett egyoszlopos Boost” elemet választani.';
$string['blockdisplay_off'] = 'Alapértelmezett egyoszlopos Boost';
$string['blockdisplay_on'] = 'Alapértelmezett háromoszlopos Fordson';
$string['blockwidthfordson'] = 'Blokk oszlopszélessége';
$string['blockwidthfordson_desc'] = 'A blokk oszlopszélességének beállítása';
$string['blog'] = 'Blog webcíme';
$string['blogdesc'] = 'A szervezeti blog webcíme (pl. https://blog.example.com)';
$string['bodybackground'] = 'Az oldal háttérszíne';
$string['bodybackground_desc'] = 'A háttéren használt fő szín.';
$string['brandColour'] = 'Márkaszín';
$string['brandColour_desc'] = 'A márka azonosítására alkalmas fő szín';
$string['branddanger'] = 'Márka veszélyszíne';
$string['branddanger_desc'] = 'A szervezet által használt szín veszélyes helyzetek jelzésére';
$string['brandemail'] = 'Szervezet e-mail-címe';
$string['brandemaildesc'] = 'A láblécben megjelenő szervezet e-mail-címe';
$string['brandinfo'] = 'Márka infószíne';
$string['brandinfo_desc'] = 'A szervezet által információk kiemelésére használt szín';
$string['brandorganization'] = 'Szervezet neve';
$string['brandorganizationdesc'] = 'A szervezet láblécben megjelenő megnevezése';
$string['brandphone'] = 'Szervezeti telefonszám';
$string['brandphonedesc'] = 'A láblécben megjelenő telefonszám';
$string['brandprimary'] = 'Elsődleges márkaszín';
$string['brandprimary_desc'] = 'A szervezet elsődlegesen használt színe';
$string['brandsuccess'] = 'Márka sikerszíne';
$string['brandsuccess_desc'] = 'A sikeres tevékenységeket, pozitív megerősítést jelző szervezeti szín';
$string['brandwarning'] = 'Márka figyelmeztető színe';
$string['brandwarning_desc'] = 'A szervezet által figyelmeztetések kiemelésére használt szín';
$string['brandwebsite'] = 'Szervezeti weboldal';
$string['brandwebsitedesc'] = 'A szervezet láblécben megjelenő webcíme';
$string['breadcrumbbkg'] = 'Navigációs háttérszín';
$string['breadcrumbbkg_desc'] = 'A navigáció háttérszíne';
$string['cardbkg'] = 'Tartalom háttérszíne';
$string['cardbkg_desc'] = 'A kurzusok tartalma és a blokkok mögött megjelenő háttérszín';
$string['catsicon'] = 'Kategória ikonja';
$string['catsicon_desc'] = 'Ikon kiválasztása a kurzuskategóriák jelölésére';
$string['choosereadme'] = 'A Fordson egyedülálló vizuális élményt nyújt az alapértelmezett Boost stílushoz olyan testreszabási funkciókkal, mint a színválasztók, a továbbfejlesztett navigáció és a tetszetősebb weboldal.';
$string['collapsibletopics'] = 'Összecsukható témák kurzusformátuma';
$string['collapsibletopics_desc'] = 'Az összecsukható témák kurzusformátumának  (<a href="https://moodle.org/plugins/format_collapsibletopics"> format_collapsibletopics </a>) telepítésekor a Fordson stílus továbbfejlesztett kurzusformátum-nézetet és speciális stilizálást kínál, amelyek jobban integrálódnak a Fordson általános megjelenésébe. Különös figyelemmel fejlesztették ki annak érdekében, hogy gördülékenyebb felhasználói élményt biztosítson minden életkorú és készségekkel rendelkező felhasználók számára.';
$string['colours_desc'] = 'A színválasztókkal testre szabhatja az oldal fő elemeinek a megjelenését és viselkedését. Az alapértelmezettől eltérő előre beállított értékek használata esetén a legjobb eredmények érdekében távolítsa el az összes egyedi színt, mivel ezek nemkívánatos eredményekkel felülírják az előre beállított értékeket. Általában az előre beállított értékek olyan alapszíneket használnak, amelyeket testreszabás előtt érdemes megnézni.';
$string['colours_headingsub'] = 'Színbeállítások';
$string['colours_settings'] = 'Színek';
$string['commonlyused'] = 'Módosított tevékenység- és tananyagmodulok';
$string['commonlyuseddesc'] = 'Vesszővel elválasztott tevékenységek/tananyagok felsorolása a tevékenység-/tananyagválasztó tetején.<br>
Alapértelmezett tevékenységek: <br>
hozzárendelés, csevegés, választás, adatok, visszajelzés, fórum, szószedet, lecke, LTI, teszt, SCORM, felmérés, wiki, műhely<br>
Alapértelmezett tananyagok: <br>
könyv, fájl, mappa, I-MSCP, címke, oldal, webcím';
$string['configtitle'] = 'Fordson';
$string['contentsettings'] = 'Tartalomterületek';
$string['courseactivities'] = 'Kurzustevékenységek';
$string['courseblockpanelbtn'] = 'Kurzusblokkok';
$string['courseblockpanelbtnclose'] = 'Bezár';
$string['courseboxheight'] = 'Kurzus csempemagassága';
$string['courseboxheight_desc'] = 'A kurzus csempemagasságának beállítása a nyitóoldalon és a kurzuskategóriákban';
$string['courseeditingcog'] = 'Alapértelmezett Kurzusbeállítások menü megjelenítése';
$string['courseeditingcog_desc'] = 'A Kurzusbeállítások panel használata esetén az alapértelmezett menü el van rejtve. Ennek bejelölésével megjeleníthető az alapértelmezett menü, valamint a tanári kurzuskezelés panelje. Ez ideális a beállítások eléréséhez a kurzusmenüt használó, harmadik féltől származó segédprogram alkalmazása esetén.';
$string['coursehome'] = 'Kezdőlap';
$string['courseinfo'] = 'Kurzusleírás';
$string['coursemanage'] = 'Kurzusbeállítások';
$string['coursemanage_desc'] = 'A teljes kurzus kezelése';
$string['coursemanagementbutton'] = 'Kurzuskezelés';
$string['coursemanagementinfo'] = 'Kurzusadminisztrációs panelmenü';
$string['coursemanagementinfodesc'] = 'A Fordson egyedülálló és jól felépített kurzusadminisztrációs panelt kínál, amelyhez a tanárok a kurzus bármely pontjáról hozzáférhetnek a kurzusbeállítások kezelése céljából. A tanulók a kurzus tanulói irányítópultjához férhetnek hozzá, amely a kurzusra vonatkozó információkat tartalmazza. Ennek bekapcsolt állapotban tartása erősen ajánlott.';
$string['coursemanagementtextbox'] = 'Kurzuskezelési üzenet';
$string['coursemanagementtextbox_desc'] = 'Üzenet eljuttatása a tanárokhoz a minden kurzusoldalon elérhető kurzuskezelési panelen keresztül.';
$string['coursemanagementtoggle'] = 'Tanulói és tanári kurzuskezelési panel megjelenítése';
$string['coursemanagementtoggle_desc'] = 'Egy rendezett panelen megjeleníti a tanárok számára a kurzusadminisztrációs hivatkozásokat, amely tartalmaz egy irányítópultot a tanfolyam és a felhasználók kezeléséhez szükséges összes hivatkozással. Ezenkívül megjeleníti a tanulók számára a kurzusáttekintő panelt az osztályzatokkal, teljesítési szinttel és a kurzus egyéb elemeivel együtt.';
$string['coursestaff'] = 'A kurzus tanárai';
$string['coursestyle1'] = 'Első elrendezés';
$string['coursestyle10'] = 'A Moodle-kurzus alapértelmezett megjelenítése';
$string['coursestyle2'] = 'Második elrendezés';
$string['coursestyle3'] = 'Harmadik elrendezés';
$string['coursestyle4'] = 'Negyedik elrendezés kurzusösszefoglalóval';
$string['coursestyle5'] = 'Első vízszintes elrendezés';
$string['coursestyle6'] = 'Vízszintes háttérkép teljes részletességgel';
$string['coursestyle7'] = 'Vízszintes háttérkép csak a címsoroknál és a tanároknál';
$string['coursestyle8'] = 'Vízszintes kétoszlopos';
$string['coursestyle9'] = 'Céges képzés - minimalista a teljesítés szintjének megjelenítésével';
$string['coursetileinfo'] = 'Kursusmegjelenítési beállítások';
$string['coursetileinfodesc'] = 'Ezekkel a beállításokkal megadhatja, miként jelenjenek meg a kurzusok a  kezdőoldalon és a kurzuskategóriák oldalán.';
$string['coursetilestyle'] = 'Kurzuscsempe megjelenítése';
$string['coursetilestyle_desc'] = 'A kurzuskategóriák megtekintésekor a következő stílusok érhetők el a kurzusok megjelenítéséhez: <a href="https://goo.gl/fMXzSo" target="_new">Fordson Útmutató</a>';
$string['createinfo'] = 'Különleges kurzuskészítői gomb';
$string['createinfodesc'] = 'Ez a gomb a kezdőoldalon jelenik meg, ha a felhasználó új kurzusokat hozhat létre. A portálszinten kurzuskészítői jogosultsággal rendelkezők látják ezt a gombot.';
$string['currentinparentheses'] = '(jelenlegi)';
$string['customloginheading'] = 'Egyedi bejelentkezési oldal';
$string['customlogininfo'] = 'Egyedi bejelentkezési oldal beállításai';
$string['customlogininfo_desc'] = 'Lehetővé teszi egyéni bejelentkezési oldal létrehozását. A stílus bejelentkezési oldalt befolyásoló egyéb beállításai:<br>
<b> * Portáladminisztráció  > Biztonság > Portálszabályok > Felhasználói bejelentkezés előírása</b> = A felhasználóknak az egyéni bejelentkezési oldalra kerüléséhez ennek bekapcsolt állapotban kell lennie.<br>
<b>* Portáladminisztráció  > Megjelenés > Logók > Logó</b> = Itt tölthető fel a bejelentkezési űrlap felett megjelenő logó.<br>
<b>* Fordson > Egyedi képbeállítások > Alapértelmezett bejelentkezési kép</b> = Ez használható a bejelentkezési oldal háttérképének a megváltoztatására.<br>
<b>* Fordson > Tartalomterületek > Honlapfigyelmeztetés </b> = Ez használható az oldal tetején megjelenő értesítés megjelenítésére.';
$string['dashactivityoverview'] = 'TEVÉKENYSÉGEK ÁTTEKINTÉSE';
$string['displaybottom'] = 'Megjelenítés az oldal alján';
$string['displaymycourses'] = 'Felvett kurzusok megjelenítése';
$string['displaymycoursesdesc'] = 'A felvett kurzusok megjelenítése a felső navigációs sávban.';
$string['displaythiscourse'] = '"Ez a kurzus" menü megjelenítése';
$string['displaythiscoursedesc'] = 'A "Szakaszhoz ugrás" menü megjelenítése a felső navigációs sávban. Ez a navigációs fiókból származó menüelemeket tartalmazza.';
$string['displaytop'] = 'Megjelenítés az oldal tetején';
$string['drawerbkg'] = 'Oldalsó fiók háttérszíne';
$string['drawerbkg_desc'] = 'A bal oldali fiókban lévő menü háttérszíne.';
$string['easyenrollmentintegration'] = 'Egyszerű beiratkozás segédprogramja';
$string['easyenrollmentintegration_desc'] = 'Az Egyszerű beiratkozás segédprogramja (<a href="https://moodle.org/plugins/enrol_easy">Egyszerű beiratkozás segédprogramja</a>) lehetővé teszi a tanulók számára, hogy közvetlenül a Moodle honlapjáról jelentkezzenek a kurzusokra. A beiratkozási segédprogram a tanulók beiratkozásához egy 6 jegyű kódot vagy egy automatikusan generált QR-kódot használ, webkamera támogatással. A tanuló beírja a kódot vagy beolvassa a QR-kódot, és azonnal beiratkozik a kurzusba vagy a kurzusban lévő csoportba. Ez a beépülő modul az Egyszerű beiratkozás segédprogramjának a telepítésével és bekapcsolásával automatikusan aktiválódik, de csak akkor, ha a segédprogramot telepítette és megfelelően beállította.';
$string['editoff'] = 'Szerkesztés kikapcsolása';
$string['editon'] = 'Szerkesztés bekapcsolása';
$string['enablecategoryicon'] = 'Kategória megjelenítési ikonjai';
$string['enablecategoryicon_desc'] = 'Bejelölése esetén a kurzuskategóriák ikonok formájában jelennek meg.';
$string['enhancedmydashboard'] = 'Továbbfejlesztett Irányítópultom';
$string['enhancedmydashboard_desc'] = 'Ennek bekapcsolása esetén bővül az "Irányítópultom" oldal egyebek mellett a Fordson egyszerű beiratkozási űrlapjával, blokkos csúszkákkal, ikonos navigációs sávval, egyedi honlapszöveggel és diavetítéssel.';
$string['enrollcoursecard'] = 'Hozzáférés';
$string['facebook'] = 'Facebook webcíme';
$string['facebookdesc'] = 'A Facebook-oldal webcíme (pl. https://facebook.com/moodle/)';
$string['favicon'] = 'Weblapikon';
$string['favicon_desc'] = 'A Fordson weblapikonjának lecserélése. Legjobb egy 30×30px-es, átlátszó hátterű ikon. Elfogadott típusok: png, jpg és ico.';
$string['feature1info'] = '1. kiemelés';
$string['feature2info'] = '2. kiemelés';
$string['feature3info'] = '3. kiemelés';
$string['featureimage'] = 'Kiemelt kép';
$string['featureimage_desc'] = 'Ez a kép a kiemelt szöveggel egy sorban jelenik meg.';
$string['featureinfo_desc'] = 'A kiemelés egy képből és szövegből áll, amelyek egy sorban, az egyedi belépési oldalon jelennek meg.';
$string['featuretext'] = 'Kiemelt szöveg';
$string['featuretext_desc'] = 'Ez a szöveg a kiemelt képpel egy sorban, közvetlenül amellett jelenik meg.';
$string['flickr'] = 'Flickr webcíme';
$string['flickrdesc'] = 'Flickr-oldalának webcíme  (vagyis https://flickr.com/moodle/)';
$string['footerbkg'] = 'Lábléc háttérszíne';
$string['footerbkg_desc'] = 'Az oldal alján megjelenő lábléc háttérszíne.';
$string['footerdesc'] = 'A lenti elemekkel a téma láblécén márkajegyek helyezhetők el.';
$string['footerheading'] = 'Lábléc';
$string['footerheadingsocial'] = 'Közösségi ikonok';
$string['footerheadingsub'] = 'A lábléc beállításai';
$string['footnote'] = 'Lábjegyzet';
$string['footnotedesc'] = 'A fő lábléc lábjegyzetének szerkesztője';
$string['fploginform'] = 'Bejelentkezési űrlap színe';
$string['fploginform_desc'] = 'A módosított honlap belépési űrlapjának háttérszíne.';
$string['fpsignup'] = 'Bejelentkezés';
$string['fptextbox'] = 'Honlap szövegdoboza bejelentkezett felhasználóknak';
$string['fptextbox_desc'] = 'Ez a szövegdoboz a honlapon jelenik meg, amint a felhasználó belépett. Ideális üdvözlő üzenet elhelyezésére és utasítások megadására a tanuló számára.';
$string['fptextboxlogout'] = 'Honlap szövegdoboza vendégek számára';
$string['fptextboxlogout_desc'] = 'Ez a szövegdoboz a látogatók számára jelenik meg, és ideális üdvözlő üzenet vagy a bejelentkezési oldalra mutató hivatkozás elhelyezésére.';
$string['frontpagemycoursessorting'] = 'Kurzusaim rendezése utolsó hozzáférés időpontja szerint';
$string['frontpagemycoursessorting_desc'] = 'Ha be van jelölve, a Kurzusaim (felvett kurzusok) a felhasználó utolsó hozzáférési időpontja szerinti sorrendben jelennek meg. Ez felülbírálja a Navigálás alatti "Kurzusaim rendezése" beállítást. Ha nincs bejelölve, akkor a Kezdőoldalon a Kurzusaim a szokásos módon jelennek meg. Ez magában foglalja az oldal tetején a legördülő menüben megjelenő Kurzusaim részt, valamint a Kezdőoldalon megjelenő felvett kurzusokat. Ez nem érinti az Irányítópultot és annak blokkjait.';
$string['generalcontentinfo'] = 'A tartalom megjelenésének általános beállításai';
$string['generalcontentinfodesc'] = 'Az alábbi lehetőségek segítenek a tartalom megjelenésének testreszabásában és a Fordson kiegészítő funkcióinak bekapcsolásában.';
$string['generalsettings'] = 'Általános beállítások';
$string['googleplus'] = 'Google+ webcíme';
$string['googleplusdesc'] = 'A Google+ oldal webcíme  (azaz https://google.com/)';
$string['gutterwidth'] = 'Tartalom behúzása';
$string['gutterwidth_desc'] = 'Ez a beállítás szabályozza a tartalom két oldalán megjelenő üres terület méretét.';
$string['headerdefaultimage'] = 'Alapértelmezett fejléckép';
$string['headerdefaultimage_desc'] = 'A kurzusfejlécek és a nem kurzus jellegű oldalak alapbeállítás szerinti képe';
$string['headerimagepadding'] = 'Fejléckép magassága';
$string['headerimagepadding_desc'] = 'A kurzusok fejlécháttérképének magassága és behúzása';
$string['headerlogo'] = 'Fejléc logója';
$string['headerlogo_desc'] = 'Ez a logó jelenik meg az oldal tetején, a fejlécben Boostrap alkalmazkodó képátméretezés használatával.';
$string['homemyclasses'] = 'Osztály kezdőlapja';
$string['homemycomp'] = 'Kompetencia kezdőlapja';
$string['homemycourses'] = 'Kurzus kezdőlapja';
$string['homemycred'] = 'Köszönetnyilvánítás kezdőlapja';
$string['homemylectures'] = 'Előadás kezdőlapja';
$string['homemylessons'] = 'Lecke kezdőlapja';
$string['homemymodules'] = 'Modul kezdőlapja';
$string['homemyplans'] = 'Tanterv kezdőlapja';
$string['homemyprofessionaldevelopment'] = 'Szakképzés kezdőlapja';
$string['homemyprograms'] = 'Program kezdőlapja';
$string['homemytraining'] = 'Képzés kezdőlapja';
$string['homemyunits'] = 'Egység kezdőlapja';
$string['iconnavheading'] = 'Ikonos navigáció';
$string['iconnavheadingsub'] = 'Ikongombok készítése a honlapra. Hivatkozásai bárhova mutathatnak.';
$string['iconwidth'] = 'Honlapikon szélessége';
$string['iconwidth_desc'] = 'A kezdőlap ikonos navigációs sávjában lévő 8 ikon szélessége.';
$string['iconwidthinfo'] = 'Ikongomb szélességének beállítása';
$string['iconwidthinfodesc'] = 'A navigációs ikongombokon megjelenő szöveg szélességét úgy kell beállítani, hogy azok elférjenek a gombokon.';
$string['ilearnsecurebrowser'] = 'Ezt a tesztet az iLearn Secure Browser védi (csak egy iLearn kisalkalmazást futtató Chromebookkal nyitható meg).';
$string['imagesettings'] = 'Egyéni képbeállítások';
$string['instagram'] = 'Instagram webcíme';
$string['instagramdesc'] = 'Adja meg az Instagram-oldal webcímét  (pl. https://instagram.com/moodle/).';
$string['integrationinfo'] = 'Integrált segédprogramok';
$string['integrationinfo_desc'] = 'A Fordson elérhetővé tehet fejlettebb funkciókat, és jobban integrálhat bizonyos segédprogramokat. Az alábbi beállítások lehetővé teszik az alapértelmezett beépülő modul viselkedésének használatát vagy a speciális szolgáltatások bekapcsolását, amelyeket a Fordson fejlesztői létrehoztak.';
$string['integrationoff'] = 'Integráció kikapcsolása';
$string['integrationon'] = 'Integráció bekapcsolása';
$string['layoutinfo'] = 'Elrendezési beállítások';
$string['layoutinfodesc'] = 'Az oldalak elrendezésének megváltoztatása kész tervek alapján.';
$string['learningcontentpadding'] = 'Tananyagtartalom távolsága';
$string['learningcontentpadding_desc'] = 'Ezzel állítható be, hogy mekkora távolság legyen az oldal teteje és a tananyag tartalma között. Ez az érték általában kisebb, mint a kurzus fejlécében lévő kép magassága.';
$string['linkedin'] = 'LinkedIn webcíme';
$string['linkedindesc'] = 'Adja meg LinkedIn profiloldalának webcímét  (azaz: https://linkedin.com/)';
$string['loginimage'] = 'Alapértelmezett belépési oldal';
$string['loginimage_desc'] = 'Belépési oldal háttérképe';
$string['loginnavicon1'] = '1. ikon';
$string['loginnavicon2'] = '2. ikon';
$string['loginnavicon3'] = '3. ikon';
$string['loginnavicon4'] = '4. ikon';
$string['loginnavicontext'] = 'Ikonszöveg';
$string['loginnavicontextdesc'] = 'Az ikon alatt megjelenő szöveg. A legjobb hatás érdekében érdemes rövidre fogni.';
$string['loginnavicontitletext'] = 'Ikon címe';
$string['loginnavicontitletextdesc'] = 'Az ikon alatt címként megjelenő szöveg';
$string['logintopimage'] = 'Belépési oldali szalagképe';
$string['logintopimage_desc'] = 'A kép a belépési oldalon jelenik meg, az űrlaptól jobbra. Ideális logó vagy üzenet megjelenítésére.';
$string['marketboxbuttoncolor'] = 'Marketingdoboz gombjának a színe';
$string['marketboxbuttoncolor_desc'] = 'A marketingdobozban lévő gomb háttérszíne.';
$string['marketboxcolor'] = 'Marketingdoboz háttérszíne';
$string['marketboxcolor_desc'] = 'A marketingdobozhoz beállított háttérszín.';
$string['marketboxcontentcolor'] = 'Marketingdoboz tartalmának háttérszíne';
$string['marketboxcontentcolor_desc'] = 'A marketingdoboz tartalmának háttérszíne. Itt jelenik meg a marketing célú szöveg, aminek háttérszíne különbözhet a dobozétól, hogy felhívja a figyelmet a szövegre.';
$string['marketing1'] = '1. marketinghely';
$string['marketing2'] = '2. marketinghely';
$string['marketing3'] = '3. marketinghely';
$string['marketing4'] = '4. marketinghely';
$string['marketing5'] = '5. marketinghely';
$string['marketing6'] = '6. marketinghely';
$string['marketing7'] = '7. marketinghely';
$string['marketing8'] = '8. marketinghely';
$string['marketing9'] = '9. marketinghely';
$string['marketingbuttontext'] = 'Hivatkozás szövege';
$string['marketingbuttontextdesc'] = 'A gombon megjelenő szöveg';
$string['marketingbuttonurl'] = 'Hivatkozás webcíme';
$string['marketingbuttonurldesc'] = 'A webcím, ahova a gomb mutatni fog.';
$string['marketingcontent'] = 'Tartalom';
$string['marketingcontentdesc'] = 'A marketingdoboz tartalma. A legjobb hatás érdekében érdemes rövidre fogni.';
$string['marketingdesc'] = 'Ez a stílus három marketing- vagy hirdetési hely elhelyezését teszi lehetővé a diavetítés alatt, melyeken alapvető információk oszthatók meg a felhasználókkal és közvetlen hivatkozások adhatók meg.';
$string['marketingheading'] = 'Marketingcsempék';
$string['marketingheadingsub'] = 'Három hely a nyitóoldalon, ahol információk és hivatkozások jelenhetnek meg';
$string['marketingheight'] = 'Marketingképek magassága';
$string['marketingheightdesc'] = 'Itt állítható be a marketingdobozokban megjelenő képek magassága.';
$string['marketingicon'] = 'Hivatkozás ikonja';
$string['marketingicondesc'] = 'A marketing webcímgombján megjelenő ikon neve. A lista <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">itt található</a>. Az "fa-" utáni részt kell megadni, pl. "star".';
$string['marketingimage'] = 'Kép';
$string['marketingimage_desc'] = 'Lehetőséget nyújt egy kép megjelenítésére a marketinghelyen';
$string['marketinginfodesc'] = 'A marketinghely beállításai. Az egyes marketinghelyekhez címet kell megadni azok megjelenítéséhez.';
$string['marketingstyle'] = 'Marketingcsempe stílusválasztója';
$string['marketingstyle1'] = 'Felső sáv magassága';
$string['marketingstyle2'] = 'Postit jegyzet';
$string['marketingstyle3'] = 'Egyszerűség';
$string['marketingstyle4'] = 'Dobozolt árnyék';
$string['marketingstyle_desc'] = 'A következő marketingstílusokkal megváltoztathatja a portál nyitóoldalán lévő marketinghelyek megjelenését.';
$string['marketingtitle'] = 'Cím';
$string['marketingtitledesc'] = 'A marketinghely címe. Nélküle nem jelenik meg a marketingcsempe.';
$string['marketingurltarget'] = 'Hivatkozás célja';
$string['marketingurltargetdesc'] = 'A hivatkozás megnyitási módjának kiválasztása';
$string['marketingurltargetnew'] = 'Új oldal';
$string['marketingurltargetparent'] = 'Szülőkeret';
$string['marketingurltargetself'] = 'Jelenlegi oldal';
$string['markettextbg'] = 'Marketingcsempe szövegének háttere';
$string['markettextbg_desc'] = 'A marketingcsempék szövegterületének háttérszíne';
$string['menusettings'] = 'Menübeállítások';
$string['modchoosercommonlyused'] = 'Általában használt';
$string['modchoosercommonlyusedtitle'] = 'Közös modulok';
$string['modchoosercommonlyusedtitlecustom'] = '{$a}';
$string['modchoosercustomlabel'] = 'Egyedi választómodul címkéje';
$string['modchoosercustomlabel_desc'] = 'A választómodul paneljén megjelenő új menühöz saját, egyedi címke hozzáadása.';
$string['modchoosersettingspage'] = 'Tevékenységek/tananyagok';
$string['myclasses'] = 'Tanfolyamaim';
$string['mycomp'] = 'Megszerzett képességeim';
$string['mycourses'] = 'Kurzusaim';
$string['mycoursesinfo'] = 'Felvett kurzusok dinamikus listája és kurzusnavigációs menük';
$string['mycoursesinfodesc'] = 'A navigációs sáv felső részén megjeleníti a felhasználó számára a felvett kurzusok dinamikus listáját. Ez kezeli az egyes kurzusok legördülő navigációs menüjét is.';
$string['mycoursetitle'] = 'Szakkifejezések';
$string['mycoursetitledesc'] = 'A legördülő menü "Kurzusaim" pontjának szakkifejezései';
$string['mycred'] = 'Azonosító adataim';
$string['mygradestext'] = 'Osztályzataim';
$string['mylectures'] = 'Előadásaim';
$string['mylessons'] = 'Leckéim';
$string['mymodules'] = 'Moduljaim';
$string['myplans'] = 'Tanulási terveim';
$string['myprofessionaldevelopment'] = 'Előmenetelem';
$string['myprograms'] = 'Programjaim';
$string['myprogresspercentage'] = '% teljesítve';
$string['myprogresstext'] = 'Előrehaladásom';
$string['mytraining'] = 'Tréningem';
$string['myunits'] = 'Egységeim';
$string['navbarcolorswitch'] = 'Navigációs sáv színváltója';
$string['navbarcolorswitch_desc'] = 'Ez a szolgáltatás megváltoztatja a navigációs sáv színét a felhasználói szerep alapján. A tanuló egyfajta színt fog látni, a tanár pedig egy másikat. Ez akkor hasznos, ha a tanár megváltoztatja a szerepeket, emellett segít megkülönböztetni a tanulói és a tanári nézetet.';
$string['navbarcolorswitch_off'] = 'Ne változzon a navigációs sáv színe szerepek szerint.';
$string['navbarcolorswitch_on'] = 'Változzon a navigációs sáv színe szerepek szerint.';
$string['navdrawerbtn'] = 'Navigáció';
$string['navicon'] = 'Ikon';
$string['navicon1'] = '1. honlapikon';
$string['navicon2'] = '2. honlapikon';
$string['navicon3'] = '3. honlapikon';
$string['navicon4'] = '4. honlapikon';
$string['navicon5'] = '5. honlapikon';
$string['navicon6'] = '6. honlapikon';
$string['navicon7'] = '7. honlapikon';
$string['navicon8'] = '8. honlapikon';
$string['naviconbutton1textdefault'] = 'Irányítópult';
$string['naviconbutton2textdefault'] = 'Naptár';
$string['naviconbutton3textdefault'] = 'Kitűzők';
$string['naviconbutton4textdefault'] = 'Minden kurzus';
$string['naviconbuttoncreatetextdefault'] = 'Új kurzus létrehozása';
$string['naviconbuttontext'] = 'Hivatkozás szövege';
$string['naviconbuttontextdesc'] = 'Az ikon alatt megjelenő szöveg.';
$string['naviconbuttonurl'] = 'Hivatkozás webcíme';
$string['naviconbuttonurldesc'] = 'Webcím, amelyre a gomb mutat. Bármilyen érvényes webcímre mutathat, beleértve a külső webhelyeket is. Ha a Moodle-webhely egy alkönyvtárban van, akkor az alapértelmezett webcím nem fog működni, ezért úgy kell módosítani a címet, hogy tükrözze az alkönyvtárat. Példa: ha a "moodle" az alkönyvtár neve, akkor a cím legyen /moodle/aloldal/';
$string['navicondesc'] = 'A használni kívánt ikon neve. A lista <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">itt található</a>. Az "fa-" utáni részt kell megadni, pl. "star".';
$string['naviconslidedesc'] = 'Javasolt ikonszöveg: arrow-circle-down, de tetszés szerint másik is választható. A lista <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">itt található</a>. Az "fa-" utáni részt kell megadni, pl. "star".';
$string['noenrolments'] = 'Jelenleg nincs felvett kurzusa';
$string['nomycourses'] = 'Nem vett föl egy kurzust sem.';
$string['pagelayout'] = 'Elrendezésválasztó';
$string['pagelayout1'] = 'Alapértelmezett Boost elrendezés';
$string['pagelayout2'] = 'Teljes szélességű / Fejléckép';
$string['pagelayout3'] = 'Középre rendezett tartalom / Részben fedett fejléckép';
$string['pagelayout4'] = 'Középre rendezett tartalom / Teljes képernyős fejléckép';
$string['pagelayout5'] = 'Alapértelmezett Boost elrendezés / Fejléckép a kurzusok címdobozában';
$string['pagelayout_desc'] = 'Válasszon a következő elrendezések közül. Bizonyos oldalelrendezésekhez további beállítások szükségesek a "Beállítások hangolása" oldalon. A tananyagtartalom távolsága, a fejléckép magassága és a tartalom behúzása beállításai kiemelten fontosak, mert ezek segítik elő a fejléckép elhelyezését és a tananyag két oldalán a behúzás beállítását. <a href="https://goo.gl/fMXzSo" target="_new">Útmutató a Fordsonhoz</a>';
$string['pinterest'] = 'Pinterest webcíme';
$string['pinterestdesc'] = 'A Pinterest-oldal webcíme (pl. https://pinterest.com/moodle/)';
$string['pluginname'] = 'Fordson';
$string['preset'] = 'Stílusbeállítások';
$string['preset_desc'] = 'Válasszon beállítást a stílus megjelenésének módosításához. <a href="https://goo.gl/fMXzSo" target="_new">Útmutató a Fordsonhoz</a>';
$string['presetadjustmentsettings'] = 'Beállítások hangolása';
$string['presetfiles'] = 'További stílusbeállító fájlok';
$string['presetfiles_desc'] = 'A beállításokat tartalmazó fájlokkal drámaian megváltoztatható a megjelenés.
Saját beállításokat tartalmazó fájlok létrehozásáról és megosztásáról a <a href="https://docs.moodle.org/dev/Boost_Presets" target="_blank">Boost beállítások</a> oldalon található információ.';
$string['presets_settings'] = 'Beállítások';
$string['privacy:metadata'] = 'A Fordson stílus nem tárol egyedi felhasználói adatokat.';
$string['qbank'] = 'Kérdésbank';
$string['qbank_desc'] = 'Tesztkérdések létrehozása és rendszerezése';
$string['rawscss'] = 'Nyers SCSS';
$string['rawscss_desc'] = 'Itt adható meg az az SCSS-kód, amely a stíluslap végére lesz illesztve.';
$string['rawscsspre'] = 'Nyers kiinduló SCSS';
$string['rawscsspre_desc'] = 'Itt adható meg a kiinduló SCSS-kód, amely a stíluslap elejére lesz illesztve. Leginkább változók megadására használható.';
$string['region-fp-a'] = 'A oszlop';
$string['region-fp-b'] = 'B oszlop';
$string['region-fp-c'] = 'C oszlop';
$string['region-side-pre'] = 'Jobb';
$string['section_mods'] = 'Modulok:';
$string['sectionlayout'] = 'Szakasz stílusválasztója';
$string['sectionlayout1'] = 'Alapértelmezett Boost';
$string['sectionlayout2'] = 'Vastag jegyzetkártya';
$string['sectionlayout3'] = 'Mappalapok';
$string['sectionlayout4'] = 'Vágólap';
$string['sectionlayout5'] = 'Egyszerű doboz';
$string['sectionlayout6'] = 'Kiemelt szakaszcím';
$string['sectionlayout7'] = 'Egyetemi hallgató';
$string['sectionlayout8'] = 'Céges tanuló';
$string['sectionlayout_desc'] = 'A következő stílusok érhetők el a témaforma vagy heti forma megjelenítéséhez. <a href="https://goo.gl/fMXzSo" target="_new">Útmutató a Fordsonhoz</a>';
$string['setting_navdrawersettings'] = 'Navigációs fiók beállításai';
$string['setting_navdrawersettings_desc'] = 'A Boost navigációs fiók engedélyezése. A Fordson a navigációhoz nem igényli a navigációs fiókot, lecseréltük egy "Szakaszra ugrás" legördülő menüre. A navigációs fiók lejjebb újra engedélyezhető.';
$string['showactivitynav'] = 'Tevékenység navigációjának megjelenítése';
$string['showactivitynav_desc'] = 'A bejelölés törlésével a tevékenység navigációja nem jelenik meg a tevékenységoldalak alján.';
$string['showalltomanager'] = 'Minden tevékenység és tananyag megjelenítése a vezetők számára';
$string['showalltomanager_desc'] = 'Ez a beállítás lehetővé teszi a vezetői szereppel rendelkező felhasználók számára az összes tevékenység és tananyag megtekintését és elérését, még akkor is, ha az csak az egyedi menüt jeleníti meg. A vezetői szerepet a felhasználó általában a portál vagy a kategória szintjén kapja. A tanárok továbbra is csak az egyedi menüt látják. Ezt a szolgáltatást a felhasználói engedély határozza meg: tekintse meg a portáladminisztrációs felületet (moodle/site:configview). A portál rendszergazdái mindig láthatják az összes tevékenységet és tananyagot.';
$string['showblockregions'] = 'További nyitóoldali blokkterületek megjelenítése';
$string['showblockregions_desc'] = 'További 3 blokkterület megjelenítése a nyitóoldalon. Ezek közvetlenül az ikonos navigációs sor alatt jelennek meg.';
$string['showcourseadminstudents'] = 'Tanulói kurzusbeállítási ikon megjelenítése';
$string['showcourseadminstudents_desc'] = 'Megjeleníti a kurzusbeállítási lehetőségeket tanulók számára. Akkor szükséges, ha a kurzusleadás engedélyezett.';
$string['showcourseheaderimage'] = 'Kurzusképek megjelenítése';
$string['showcourseheaderimage_desc'] = 'Lehetővé teszi a tanárok számára, hogy egy kép feltöltésével egyéni megjelenést adjanak a kurzusuknak.';
$string['showcustomlogin'] = 'Egyedi bejelentkezési oldal bekapcsolása';
$string['showcustomlogin_desc'] = 'A további beállítások eléréséhez ezt be kell kapcsolni.';
$string['showloginform'] = 'Bejelentkezési űrlap megjelenítése';
$string['showloginform_desc'] = 'A bejelölés törlésével a kilépett felhasználók nem látják az egyedi bejelentkezési űrlapot.';
$string['shownavclosed'] = 'Alapesetben zárt navigációs fiók';
$string['shownavclosed_desc'] = 'Alapesetben a felhasználók összecsukott állapotban látják a navigációs fiókot.';
$string['shownavdrawer'] = 'Navigációs fiók megjelenítése';
$string['shownavdrawer_desc'] = 'A Fordson egy kurzusokon belüli legördülő menü beépítésével szükségtelenné tette a navigációs fiók használatát. Igény esetén itt lehet újra engedélyezni.';
$string['showonlycustomactivities'] = 'Csak az egyéni menü megjelenítése';
$string['showonlycustomactivities_desc'] = 'Ha be van jelölve, csak az egyéni menü jelenik meg. Ez lehetővé teszi a szervezet számára a kurzusokban használható tevékenységek és tananyagok körének korlátozását. FIGYELEM! A fenti szövegmezőben a tevékenységek/tananyagok vesszővel elválasztott listájának kell szerepelni, ellenkező esetben semmilyen tevékenység vagy tananyag nem lesz látható a kurzus szerkesztése során.';
$string['showonlygroupteachers'] = 'Csak a csoport tanárainak megjelenítése';
$string['showonlygroupteachers_desc'] = 'Bejelölése után a tanulók csak azokat  a tanárokat láthatják, akik velük egy csoportban vannak.';
$string['showslideshow'] = 'Diavetítés bekapcsolása';
$string['showslideshow_desc'] = 'Bejelölésével bekapcsol a diavetítés.';
$string['showstudentcompletion'] = 'Tanulói teljesítési szint megjelenítése';
$string['showstudentcompletion_desc'] = 'A tanulói teljesítési szint kördiagramjának megjelenítése az irányítópulton. A megjelenítéséhez a bejelölésen túl a kurzusban a teljesítést is be kell kapcsolni.';
$string['showstudentgrades'] = 'Tanulói osztályzatok megjelenítése';
$string['showstudentgrades_desc'] = 'Az osztályozónapló hivatkozásának a megjelenítése a tanulói irányítópulton. A megjelenítéséhez a bejelölésen túl a kurzusban a tanulói osztályzatok megjelenítését is be kell kapcsolni.';
$string['siteadminquicklink'] = 'Portáladminisztráció';
$string['skype'] = 'Skype-fiók';
$string['skypedesc'] = 'A szervezet Skype-fiókjának felhasználóneve';
$string['slide1info'] = '1. dia';
$string['slide1infodesc'] = '1. dia tulajdonságai.';
$string['slide2info'] = '2. dia';
$string['slide2infodesc'] = '2. dia tulajdonságai.';
$string['slide3info'] = '3. dia';
$string['slide3infodesc'] = '3. dia tulajdonságai';
$string['slidecontent'] = 'Dia leírása';
$string['slidecontent_desc'] = 'Leírás hozzáadása a diához';
$string['slideimage'] = 'Diakép';
$string['slideimage_desc'] = 'Háttérkép hozzáadása a diához';
$string['sliderinfo'] = 'Egyedi ikongomb a diához';
$string['sliderinfodesc'] = 'Ez a gomb megjelenít/elrejt egy speciális szövegdobozt, amely az ikon navigációs sávjáról gördül le. Ideális kurzusok bemutatására, segítségnyújtásra vagy előírt belső képzések felsorolására.';
$string['slideshowheight'] = 'Diavetítés magassága';
$string['slideshowheight_desc'] = 'A diavetítés magasságának beállítása a portál kezdőlapján vagy az irányítópult oldalain. Ez a beállítás nem vonatkozik az egyedi bejelentkezési oldalra. Az egyedi bejelentkezési oldalon a diák magasságát az oldal mérete és szélessége határozza meg.';
$string['slideshowpages'] = 'Diavetítés lapjai';
$string['slideshowpages0'] = 'Csak az egyedi bejelentkezési oldalon jelenjen meg';
$string['slideshowpages1'] = 'Csak a nyitóoldalon és a Irányítópulton jelenjen meg';
$string['slideshowpages2'] = 'Mindenhol jelenjen meg';
$string['slideshowpages_desc'] = 'Meghatározza, hogy a diavetítés mely oldalakon jelenjen meg. Ha az egyedi bejelentkezési oldalon is megjelenik, ajánlott csak képeket feltölteni a szövegekre vonatkozó lehetőségek mellőzésével. MEGJEGYZÉS: mobil eszközökön nem jelenik meg a diavetítés.';
$string['slideshowsettings'] = 'Diavetítés';
$string['slideshowspacer'] = 'Diavetítés távolsága az egyedi bejelentkezési oldalon';
$string['slideshowspacer_desc'] = 'Az egyedi bejelentkezési oldalon szöveges dia esetére ez szabja meg a diavetítés és az űrlap közötti távolságot.';
$string['slidetextbox'] = 'Dia szövegdoboza';
$string['slidetextbox_desc'] = 'E szövegdoboz tartalma jelenik meg, amikor valaki a dia gombjára kattint.';
$string['slidetitle'] = 'Dia címe';
$string['slidetitle_desc'] = 'Adja meg a dia címét.';
$string['sociallink'] = 'Egyéni közösségi link';
$string['sociallinkdesc'] = 'Az egyéni közösségi oldal webcíme (pl. https://moodle.com/)';
$string['sociallinkicon'] = 'Hivatkozás ikonja';
$string['sociallinkicondesc'] = 'A használni kívánt ikon neve. A lista <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">itt található</a>. Az "fa-" utáni részt kell megadni, pl. "star".';
$string['socialnetworks'] = 'Közösségi oldalak';
$string['studentdashboardtextbox'] = 'Tanulói irányítópult üzenete';
$string['studentdashboardtextbox_desc'] = 'Itt adható meg egy üzenet, amelyet a tanulók minden kurzusoldal tanulói irányítópultján látni fognak.';
$string['studentdashbutton'] = 'Kurzus irányítópultja';
$string['textcontentinfo'] = 'Egyedi tartalom';
$string['textcontentinfodesc'] = 'A felhasználóknak szóló testre szabott információk megadásához használja a lenti szövegdobozokat.';
$string['thiscourse'] = 'Ez a kurzus';
$string['thismyclasses'] = 'Ez az osztály';
$string['thismycomp'] = 'Ez a képesség';
$string['thismycourses'] = 'Ez a kurzus';
$string['thismycred'] = 'Ez a bizonyítvány';
$string['thismylectures'] = 'Ez a lecke';
$string['thismylessons'] = 'Ez az óra';
$string['thismymodules'] = 'Ez a modul';
$string['thismyplans'] = 'Ez a tanterv';
$string['thismyprofessionaldevelopment'] = 'Ez a fejlődési terv';
$string['thismyprograms'] = 'Ez a program';
$string['thismytraining'] = 'Ez a tréning';
$string['thismyunits'] = 'Ez az egység';
$string['titletooltip'] = 'Kurzuscímhez tartozó elemleírás';
$string['titletooltip_desc'] = 'A "Kurzuscímek megvágása" funkció használata esetén elemleírásokkal jelenítheti meg a kurzus teljes címét. Bekapcsolásukhoz jelölje be a négyzetet.';
$string['togglemarketing'] = 'Marketingcsempe helyzete';
$string['togglemarketing_desc'] = 'Meghatározza a marketingcsempék honlapon belüli elhelyezkedését.';
$string['topnavbarbg'] = 'Felső navigációs sáv háttérszíne';
$string['topnavbarbg_desc'] = 'A felső navigációs sáv tartalmának háttérszíne';
$string['topnavbarteacherbg'] = 'Felső navigációs sáv tanári szerephez';
$string['topnavbarteacherbg_desc'] = 'A felső navigációs sáv tartalmának háttérszíne tanárok esetén. Ezt a funkciót a menübeállításokban kell bekapcsolni. Lásd a navbarcolorswitch beállítását.';
$string['trimsummary'] = 'Kurzusösszefoglaló megvágása';
$string['trimsummary_desc'] = 'Ez a számként megadandó érték szabja meg, hogy hány karakteres hosszúságban jelenjenek meg a kurzusok összefoglalói.';
$string['trimtitle'] = 'Kurzuscím megvágása';
$string['trimtitle_desc'] = 'Ez a számként megadandó érték szabja meg, hogy hány karakteres hosszúságban jelenjenek meg a kurzuscímek.';
$string['tumblr'] = 'Tumblr webcíme';
$string['tumblrdesc'] = 'A Tumblr-oldal webcíme (pl. https://tumblr.com/moodle/)';
$string['twitter'] = 'Twitter webcíme';
$string['twitterdesc'] = 'A Twitter-csatorna webcíme (pl. https://twitter.com/moodle/)';
$string['userlinks'] = 'Felhasználói hivatkozások';
$string['userlinks_desc'] = 'Tanulók kezelése';
$string['viewfcfmodules'] = 'Tevékenységek és tananyagok megjelenítése';
$string['viewsectionmodules'] = 'Szakaszmodulok megjelenítése';
$string['vimeo'] = 'Vimeo webcíme';
$string['vimeodesc'] = 'A Vimeo-oldal webcíme (pl. https://vimeo.com/moodle/)';
$string['vk'] = 'VKontakte webcíme';
$string['vkdesc'] = 'A VKontakte-oldal webcíme (pl. https://vkontakte.com/moodle/)';
$string['website'] = 'Weboldal webcíme';
$string['websitedesc'] = 'Saját portáljának webcíme (pl. http://szervezetem.org/)';
$string['youtube'] = 'YouTube webcíme';
$string['youtubedesc'] = 'A Youtube-oldal webcíme (pl. https://youtube.com/moodle/)';
