<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reservation', language 'hu', version '3.8'.
 *
 * @package     reservation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addparticipant'] = 'Kérelem hozzáadása';
$string['after10min'] = 'Az esemény kezdete után 10 perccel';
$string['after12h'] = 'Az esemény kezdete után 12 órával';
$string['after1d'] = 'Az esemény kezdete után 1 nappal';
$string['after1h'] = 'Az esemény kezdete után 1 órával';
$string['after1w'] = 'Az esemény kezdete után 1 héttel';
$string['after2d'] = 'Az esemény kezdete után 2 nappal';
$string['after2h'] = 'Az esemény kezdete után 2 órával';
$string['after2w'] = 'Az esemény kezdete után 2 héttel';
$string['after30min'] = 'Az esemény kezdete után 30 perccel';
$string['after3w'] = 'Az esemény kezdete után 3 héttel';
$string['after4h'] = 'Az esemény kezdete után 4 órával';
$string['after4w'] = 'Az esemény kezdete után 4 héttel';
$string['after5min'] = 'Az esemény kezdete után 5 perccel';
$string['after6h'] = 'Az esemény kezdete után 6 órával';
$string['alreadybooked'] = 'Már foglalt';
$string['alreadyoverbooked'] = 'Már rajta van a várólistán.';
$string['atstart'] = 'Az esemény kezdetekor';
$string['autohide'] = 'A foglalási lista automatikus elrejtése';
$string['availablerequests'] = 'Elérhető helyek';
$string['badcourse'] = 'A kurzus nem létezik';
$string['badparent'] = 'Ez a foglalás egy másik, jelenleg nem visszaállított foglaláshoz volt kapcsolva. A kapcsolat most el lett távolítva. Ha szükséges, kapcsolja össze őket újra manuálisan.';
$string['badsection'] = 'A "{$a}" kurzusban nincs ilyen szekció';
$string['badteachers'] = '({$a} e-mail címmel tanár nem található';
$string['badteachersmail'] = 'A megadott tanári email cím ({$a}) nem valós';
$string['badtimeclose'] = 'timeclose nem valós';
$string['badtimeend'] = 'timeend nem valós';
$string['badtimeopen'] = 'timeopen nem valós';
$string['badtimestart'] = 'timestart nem valós';
$string['by'] = 'általa:';
$string['bydate'] = 'Esemény időpontja';
$string['byname'] = 'Név';
$string['bysection'] = 'Téma/hét';
$string['cancelledon'] = 'Visszavonva ekkor:';
$string['checkclashes'] = 'Időpont- és helyütközések ellenőrzése';
$string['clashesfound'] = 'Találtunk időpont- vagy helyütközést';
$string['clashesreport'] = 'Ütközésekről szóló jelentés';
$string['cleanview'] = 'Csak a jelenleg lefoglaltak megtekintése';
$string['close'] = 'zárt';
$string['closed'] = 'Zárva';
$string['completionreserved'] = 'A tanulónak foglalnia kell, hogy befejezhesse ezt a tevékenységet';
$string['config'] = 'Foglalási modul globális beállításai';
$string['configautohide'] = 'Ez meghatározza, hogy a foglalásoknak mikor kell rejtve lenniük a foglalási listán.';
$string['configcheckclashes'] = '"Időpont- és helyütközések ellenőrzése" gomb engedélyezése a szerkesztőoldalon';
$string['configconnectto'] = 'Itt keressen foglalásokat összekapcsoláshoz:';
$string['configdownload'] = 'Ez határozza meg minden kérelem és foglalási lista alapértelmezett letöltési fájlformátumát';
$string['configevents'] = 'Ez a beállítás határozza meg, hogy mely események jönnek létre minden foglaláshoz';
$string['configfields'] = 'Ez a beállítás határozza meg, hogy mely mezők jelennek meg a foglalási táblázatban';
$string['configlocations'] = 'Ezen az oldalon a foglalások alapvető helyszíneit lehet kezelni';
$string['configmanualusers'] = 'Ez határozza meg, hogy kézi foglalások esetén mely felhasználói lista jelenjen meg a legördülő menüben,';
$string['configmaxoverbook'] = 'Ez határozza meg a túlfoglalás maximális százalékát';
$string['configmaxrequests'] = 'A foglalások szerkesztésénél a legördülő menü korlátjának meghatározása';
$string['configminduration'] = 'Ez határozza meg a foglalási esemény minimális időtartamát. Végpont nélküli eseményeknél használható az idő- és térbeli elérhetőség meghatározásához';
$string['confignotifies'] = 'Ez határozza meg, mely értesítés legyen elküldve';
$string['configoverbookstep'] = 'Ez határozza meg a túlfoglalás százalékos értékének aprózottságát.';
$string['configpubliclists'] = 'Ez határozza meg, hogy a foglalási listák nyilvánosak-e vagy sem.';
$string['configsortby'] = 'Ez határozza meg a foglalási listák felsorolásának szempontjait';
$string['configsublimits'] = 'Részkorlátok számának meghatározása';
$string['configupload'] = 'Több foglalás létrehozása szöveges állományból való feltöltéssel';
$string['confirmdelete'] = 'Biztosan törölni szeretné a kiválasztott foglalási kérelmeket?';
$string['connectedto'] = 'Foglalás kapcsolva ehhez:';
$string['connectto'] = 'Foglalás kapcsolása:';
$string['description'] = 'Leírás';
$string['downloadas'] = 'Alapértelmezett letöltési formátum';
$string['duration10h'] = '10 óra';
$string['duration10min'] = '10 perc';
$string['duration11h'] = '11 óra';
$string['duration12h'] = '12 óra';
$string['duration15min'] = '15 perc';
$string['duration20min'] = '20 perc';
$string['duration2h'] = '2 óra';
$string['duration30min'] = '30 perc';
$string['duration3h'] = '3 óra';
$string['duration45min'] = '45 perc';
$string['duration4h'] = '4 óra';
$string['duration5h'] = '5 óra';
$string['duration5min'] = '5 perc';
$string['duration60min'] = '60 perc';
$string['duration6h'] = '6 óra';
$string['duration7h'] = '7 óra';
$string['duration8h'] = '8 óra';
$string['duration90min'] = '90 perc';
$string['duration9h'] = '9 óra';
$string['enablenote'] = 'Felhasználói megjegyzés engedélyezése';
$string['equal'] = 'egyenlő ezzel:';
$string['err_sublimitsgreater'] = 'A részkorlát száma nagyobb, mint a megengedett kérelmek maximális száma';
$string['err_timeendlower'] = 'Az esemény végpontja a kezdő dátum előttire van állítva';
$string['err_timeopengreater'] = 'A foglalás kezdetének időpontja a végpont utánra van állítva';
$string['eventevent'] = 'Esemény létrehozása kezdő- és végpontokkal';
$string['eventreminder'] = '{$a} (foglalt)';
$string['eventrequestadded'] = 'Foglalási kérelem hozzáadva';
$string['eventrequestcancelled'] = 'Foglalási kérelem visszavonva';
$string['eventrequestdeleted'] = 'Foglalási kérelem törölve';
$string['events'] = 'Naptári események';
$string['eventsettings'] = 'Eseménybeállítások';
$string['explainconfig'] = 'A rendszergazdák itt adhatják meg a foglalási modul globális beállításait';
$string['fields'] = 'Látható mezők';
$string['fullview'] = 'Mutassa a törölt foglalásokat is';
$string['gradedmail'] = '{$a->teacher} visszajelzést írt \'{$a->reservation}\' foglalásához.

Itt tudja elolvasni:

    {$a->url}';
$string['gradedmailhtml'] = '{$a->teacher} visszajelzést írt \'<i>{$a->reservation}</i>\' foglalásához<br /><br />
<a href="{$a->url}">Itt</a> tudja elolvasni.';
$string['importreservations'] = 'Foglalások importálása';
$string['justbooked'] = 'Lefoglalva ekként: {$a}';
$string['justoverbooked'] = 'Túlfoglalva ekként: {$a}';
$string['linenumber'] = '#';
$string['listafterclose'] = 'a foglalási listát a foglalás lezárása után';
$string['listalways'] = 'a foglalási listát bármikor';
$string['location'] = 'Helyszín';
$string['locations'] = 'Helyszínek kezelése';
$string['locationslist'] = 'Helyszínek listája';
$string['mail'] = 'A(z) \'{$a->reservation}\' foglalás lezárult.

A foglalási lista letölthető innen:

    {$a->url}';
$string['mailhtml'] = 'A(z) \'{$a->reservation}\' foglalás lezárult.<br /><br />
A foglalási lista letölthető <a href="{$a->url}">innen</a>.';
$string['mailrequest'] = 'A(z) \'{$a->reservation}\' foglalás lezárult.

Foglalási száma itt található:

    {$a->url}';
$string['mailrequesthtml'] = 'A(z) \'{$a->reservation}\' foglalás lezárult.<br /><br />
Foglalási száma <a href="{$a->url}">itt</a> található.';
$string['manage'] = 'Műveletek';
$string['manualusers'] = 'Manuálisan foglalt felhasználók';
$string['maxoverbook'] = 'Túlfoglalás maximális százaléka';
$string['maxrequest'] = 'Foglalások maximális száma';
$string['message'] = 'Üzenet a résztvevőknek';
$string['minduration'] = 'Az esemény minimális időtartama';
$string['modulename'] = 'Foglalás';
$string['modulename_help'] = '<p>A tevékenység fő célja a tantermi képzések és vizsgák ütemezése, de bármi más is ütemezhető a segítségével.</p><p>A tanár megadhatja az elérhető helyek számát, az esemény időpontját, a foglalás kezdetének és végének időpontjait.<br>Egy foglalásnak lehet pontszáma vagy skálája.<br/>A tanulók maguk is intézhetik a foglalásukat, megjegyzést is fűzhetnek hozzá.</p><p>Az esemény kezdete után a tanár pontozhatja azt, a tanulók e-mailben kapnak értesítést.</p><p>A foglalási lista többféle formátumban letölthető.</p>';
$string['modulenameplural'] = 'Foglalások';
$string['newlocation'] = 'Új helyszínek';
$string['noclashes'] = 'Nem található idő- és/vagy térbeli ütközés';
$string['nocourseswithnsections'] = 'Nem található kurzus {$a} szekcióval';
$string['nolimit'] = 'Nincs foglalási korlát';
$string['nomorerequest'] = 'Nincs több elérhető hely';
$string['none'] = 'nincs információ a foglalási sorrendről';
$string['nooverbook'] = 'Nincs túlfoglalás';
$string['noparent'] = 'Nincs';
$string['noreservations'] = 'Nincs foglalás';
$string['note'] = 'Megjegyzés';
$string['noteachers'] = 'Nincs elérhető tanár';
$string['notequal'] = 'nem egyenlő ezzel:';
$string['notifies'] = 'Értesítés elküldve';
$string['notifygrades'] = 'A foglalás pontozásáról értesítés küldése a tanulóknak';
$string['notifystudents'] = 'A foglalási idő lezárulásáról értesítés küldése a tanulóknak';
$string['notifyteachers'] = 'A foglalási idő lezárulásáról értesítés küldése a tanároknak';
$string['notopened'] = 'Nem nyitott';
$string['novalues'] = 'Nincsenek elérhető értékek ehhez a mezőhöz';
$string['number'] = 'Foglalási szám';
$string['numberafterclose'] = 'a foglalási kérelmük számát a foglalás lezárása után';
$string['numberalways'] = 'a foglalási kérelmük számát bármikor';
$string['otherlocation'] = 'Más meghatározott helyszín';
$string['overbook'] = 'Túlfoglalás';
$string['overbookonly'] = 'Csak túlfoglalásos helyek érhetőek el';
$string['overbookstep'] = 'Túlfoglalási mérték';
$string['overview'] = 'Áttekintés';
$string['parent'] = 'Ezen foglalás összekapcsolása ezzel:';
$string['pluginadministration'] = 'Foglalás adminisztrálása';
$string['pluginname'] = 'Foglalás';
$string['publiclists'] = 'Nyilvános foglalási lista';
$string['requestoverview'] = 'Kérelmek áttekintése';
$string['requests'] = 'Kérelmek';
$string['reservation:addinstance'] = 'Új foglalás hozzáadása';
$string['reservation:downloadrequests'] = 'Foglalási lista letölthető';
$string['reservation:grade'] = 'Pont adható';
$string['reservation:manualdelete'] = 'Más felhasználók kérelmeit törölheti';
$string['reservation:manualreserve'] = 'Kérelmeket nyújthat be más felhasználók helyett';
$string['reservation:reserve'] = 'Saját kérelmeket nyújthat be';
$string['reservation:uploadreservations'] = 'Feltölthet foglalásokat';
$string['reservation:viewnote'] = 'Megtekintheti a kérelmekhez tartozó megjegyzést';
$string['reservation:viewrequest'] = 'Megtekintheti a kérelmi listát';
$string['reservation_listing'] = 'Tárgymutató oldalának beállításai';
$string['reservation_other'] = 'Egyéb beállítások';
$string['reservation_settings'] = 'Szerkesztési beállítások';
$string['reservation_view'] = 'Oldalbeállítások megtekintése';
$string['reservationcancelled'] = 'Foglalás visszavonva';
$string['reservationclosed'] = 'Foglalások lezárva';
$string['reservationdenied'] = 'Foglalások nincsenek engedélyezve';
$string['reservationevent'] = 'Új esemény foglalási idővel';
$string['reservationnotopened'] = 'A foglalások még nem nyitottak';
$string['reservations'] = 'Foglalások';
$string['reservationsettings'] = 'Foglalási beállítások';
$string['reserve'] = 'Foglalás';
$string['reservecancel'] = 'Foglalás visszavonása';
$string['reserved'] = 'Lefoglalva';
$string['reservedon'] = 'Lefoglalva ekkor:';
$string['reservedonconnected'] = 'Már lefoglalt egy kapcsolódó foglaláson: {$a}';
$string['resetreservation'] = 'Minden foglalás eltávolítása';
$string['save'] = 'Pont mentése';
$string['search:activity'] = 'Foglalás - tevékenységről szóló adatok';
$string['selectvalue'] = 'Válasszon egy értéket';
$string['showrequest'] = 'A felhasználók megtekinthetik a kérelmeket';
$string['showuserrequest'] = 'A felhasználók láthatják';
$string['sortby'] = 'Foglalási listák rendezése e szerint:';
$string['sublimit'] = '{$a} részkorlát';
$string['sublimitrules'] = 'Részkorlátra vonatkozó szabályok';
$string['sublimits'] = 'Foglalásra vonatkozó részkorlátok';
$string['timeclose'] = 'Foglalás véget ér ekkor:';
$string['timeend'] = 'Vége időpont';
$string['timeopen'] = 'Foglalás kezdődik ekkor:';
$string['timestart'] = 'Kezdete időpont';
$string['tools'] = 'Foglalási eszközök';
$string['upload'] = 'Foglalások feltöltése';
$string['upload_help'] = '<p>A foglalások szövegfájlként tölthetőek fel. A fájlformátumnak a következőképpen kell kinéznie:</p><ul><li>Minden sorban egy bejegyzés lehet</li><li>Minden adatot vesszővel (vagy más határolóval) kell elválasztani</li><li>Az első bejegyzés a mezők neveit tartalmazza</li><li>A szükséges mezők: section, name és timestart</li><li>További mezők: course, intro, teachers, timeend, maxgrade, timeopen, timeclose, maxrequest</li><li>Ha nincs kurzus megadva, akkor az előnézetnél kell választani egyet.</li>';
$string['uploadreservations'] = 'Foglalások feltöltése';
$string['uploadreservationspreview'] = 'Feltöltött foglalások előnézete';
$string['uploadreservationsresult'] = 'Feltöltött foglalások eredménye';
$string['userevent'] = 'Felhasználói esemény létrehozása kezdő- és végdátumokkal, amikor egy felhasználó foglal';
$string['with'] = 'ezzel:';
$string['withselected'] = 'A kiválasztottal...';
$string['yourgrade'] = 'Az Ön pontszáma ehhez a foglaláshoz: {$a->grade}/{$a->maxgrade}';
$string['yourscale'] = 'Az Ön pontszáma ehhez a foglaláshoz: {$a}';
