<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_clean', language 'ja', version '3.8'.
 *
 * @package     theme_clean
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Clean</h2>
<p><img class="img-polaroid "src="clean/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>About</h3>
<p>Clean is a modified Moodle bootstrap theme which inherits styles and renderers from its parent theme.</p>
<h3>Parents</h3>
<p>This theme is based upon the Bootstrap theme, which was created for Moodle 2.5, with the help of:<br>
Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Theme Credits</h3>
<p>Authors: Bas Brands, David Scotson, Mary Evans<br>
Contact: bas@sonsbeekmedia.nl<br>
Website: <a href="http://www.basbrands.nl">www.basbrands.nl</a>
</p>
<h3>Report a bug:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
<h3>More information</h3>
<p><a href="clean/README.txt">How to copy and customise this theme.</a></p>
</div></div>';
$string['configtitle'] = 'Clean';
$string['customcss'] = 'カスタムCSS';
$string['customcssdesc'] = 'このテーマのカスタマイズを容易にするようあなたがここで入力したCSSはすべてのページに追加されます。';
$string['footnote'] = 'フットノート';
$string['footnotedesc'] = 'あなたがこのテキストエリアに入力した内容はMoodleサイトすべてのフッタに表示されます。';
$string['invert'] = 'ナビゲーションバーを反転する';
$string['invertdesc'] = 'ページトップのナビゲーションバーのテキストおよび背景色を黒と白の間で入れ替えます。';
$string['logo'] = 'ロゴ';
$string['logodesc'] = 'ロゴはフロントページおよびログインページのヘッダ内に表示されます。<br />あなたのロゴの高さが75px以上の場合、以下のカスタムCSSボックスに「div.logo {height: 100px;}」を追加してください。高さが100px以外の場合、それに応じて修正されます。ここでロゴが追加されていない場合、「アピアランス > ブランディング」のロゴが使用されます。';
$string['pluginname'] = 'Clean';
$string['privacy:metadata'] = 'Cleanテーマはすべてのユーザに関してどのような個人データも保存しません。';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
$string['sitelogo'] = 'サイトロゴ';
$string['sitename'] = 'スモールロゴと共にサイト名を表示する';
$string['sitenamedesc'] = 'スモールロゴがない場合、サイト名が常にナビゲーションバーに表示されます。スモールロゴが設定されている場合、サイト名と一緒またはサイト名なしにスモールロゴを表示することができます。';
$string['smalllogo'] = 'スモールロゴ';
$string['smalllogodesc'] = 'ナビゲーションバーにスモールロゴが表示されます。フロントページおよびログインページのヘッダロゴがある場合、それらのページではスモールロゴは表示されません。ここでロゴが追加されていない場合、「アピアランス > ブランディング」のロゴが使用されます。';
