<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodleoverflow', language 'ja', version '3.8'.
 *
 * @package     moodleoverflow
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addanewdiscussion'] = '新しいディスカッショントピックを追加する';
$string['addanewreply'] = '新しい回答を追加する';
$string['allowcoursereputation'] = 'コース内レピュテーションの合計です。';
$string['allownegativereputation'] = 'マイナスのレピュテーションを許可しますか?';
$string['allownegativereputation_help'] = 'この設定を有効にした場合、コース内またはモジュール内のユーザのレピュテーションをマイナスにできます。この設定を無効にした場合、レピュテーションの減少はゼロで止められます。';
$string['allowratingchange'] = '評価の変更を許可する';
$string['allsubscribe'] = 'すべてのフォーラムを購読する';
$string['allunsubscribe'] = 'すべてのフォーラムを購読解除する';
$string['areaattachment'] = '添付';
$string['areapost'] = 'メッセージ';
$string['attachment'] = '添付';
$string['attachment_help'] = 'あなたは任意で1つまたはそれ以上のファイルをフォーラムに添付できます。あなたがイメージを添付した場合、メッセージの後に表示されます。';
$string['attachments'] = '添付';
$string['bestanswer'] = '質問オーナーおよびコースオーナーがこれを最良の回答であると受け入れました。';
$string['bynameondate'] = 'by {$a->name} ({$a->rating}) - {$a->date}';
$string['bynameondatenorating'] = 'by {$a->name} - {$a->date}';
$string['cannotcreatediscussion'] = '新しいディスカッションを作成できませんでした。';
$string['cannotdeletepost'] = 'あなたはこの投稿を削除できません!';
$string['cannotfindparentpost'] = 'トップの親投稿 {$a} を見つけることができませんでした。';
$string['cannotreply'] = 'あなたはこの投稿に返信できません。';
$string['cannottrack'] = 'フォーラムの追跡を停止できませんでした。';
$string['cannotunsubscribe'] = 'あなたをフォーラムから購読解除できませんでした。';
$string['cannotupdatepost'] = 'あなたはこの投稿を更新できません。';
$string['cleanreadtime'] = '古い投稿を既読にする時間';
$string['clicktosubscribe'] = 'あなたはこのディスカッションを購読していません。購読するにはクリックしてください。';
$string['clicktounsubscribe'] = 'あなたはこのディスカッションを購読しています。購読解除するにはクリックしてください。';
$string['configallowcoursereputation'] = '現在のコースのすべてのインスタンスのレピュテーションの合計を許可しますか?';
$string['configallowratingchange'] = 'ユーザは評価を変更できますか?';
$string['configcleanreadtime'] = '古い投稿を「既読」テーブルから削除する1日の時間です。';
$string['configforcedreadtracking'] = 'Moodleoverflowに既読追跡の強制を許可します。結果として特に多くのMoodleoverflowおよび投稿のあるコースでは一部のユーザのパフォーマンスが下がります。この設定を無効にした場合、前に強制を設定されたすべてのMoodleoverflowは任意として扱われます。';
$string['configmanydiscussions'] = 'Moodleoverflowインスタンスの1ページあたりに表示する最大ディスカッション数です。';
$string['configmaxattachments'] = '1投稿あたりに許可されるデフォルトの最大添付数です。';
$string['configmaxbytes'] = 'サイトのすべてのフォーラム添付のデフォルトの最大サイズです (コース制限および他のローカル設定に依存します)。';
$string['configmaxeditingtime'] = 'デフォルトの最大秒は3600 (=1時間) です。';
$string['configmaxmailingtime'] = 'この時間より古い投稿はユーザにメール送信されません。これはcronが長時間動作していない場合にトラブルを避けるため有用です。';
$string['configoldpostdays'] = '投稿が読まれたとみなされる日数です。';
$string['configpreferteachersmark'] = 'コースオーナーにより「解決」とマークされた場合、ディスカッション開始者が回答にマークした「有益」に優先します。';
$string['configreputationnotnegative'] = 'ユーザレピュテーションがマイナスにされることを禁止します。';
$string['configtrackingtype'] = '既読追跡のデフォルト設定です。';
$string['configtrackmoodleoverflow'] = 'それぞれのユーザが既読/未読を追跡できるようにしたい場合、有効にしてください。';
$string['configvotescaledownvote'] = 'あなたの投稿に反対票を与えるためのレピュテーション数です。';
$string['configvotescalehelpful'] = 'あなたの投稿に有益マーク与えるためのレピュテーション数です。';
$string['configvotescalesolved'] = 'あなたの投稿に解決マークを与えるためのレピュテーション数です。';
$string['configvotescaleupvote'] = 'あなたの投稿に賛成票を与えるためのレピュテーション数です。';
$string['configvotescalevote'] = '投票によるレピュテーション数です。';
$string['confirmsubscribe'] = '本当にフォーラム「 {$a} 」を購読してもよろしいですか?';
$string['confirmsubscribediscussion'] = '本当にフォーラム「 {$a->moodleoverflow} 」内のディスカッション「 {$a->discussion} 」を購読してもよろしいですか?';
$string['confirmunsubscribe'] = '本当にMoodleoverflow「 {$a} 」を購読解除してもよろしいですか?';
$string['confirmunsubscribediscussion'] = '本当にMoodleoverflow「 {$a->moodleoverflow} 」内のディスカッション「 {$a->discussion} 」を購読解除してもよろしいですか?';
$string['couldnotadd'] = '不明なエラーのため、あなたの投稿を追加できませんでした。';
$string['couldnotdeletereplies'] = '申し訳ございません、すでに返信されているため削除できません。';
$string['couldnotupdate'] = '不明なエラーのため、あなたの投稿を更新できません。';
$string['coursewidereputation'] = 'クロスモジュールレピュテーション?';
$string['coursewidereputation_help'] = 'この設定を有効にした場合、このコースすべてのMoodleoverflowモジュールのユーザレピュテーションが合計されます。';
$string['crontask'] = 'Moodleoverflowメンテナンスジョブ';
$string['delete'] = '削除';
$string['deletesure'] = '本当にこの投稿を削除してもよろしいですか?';
$string['deletesureplural'] = '本当にこの投稿およびすべての返信を削除してもよろしいですか? ({$a} posts)';
$string['disallowsubscribe'] = '購読不許可';
$string['discussionlocked'] = 'このディスカッションはロックされているため、あなたは返信できません。';
$string['discussionname'] = 'ディスカッション名';
$string['discussionnownotsubscribed'] = '{$a->name} に「 {$a->moodleoverflow} 」内の「 {$a->discussion} 」の新しい投稿は通知されません。';
$string['discussionnowsubscribed'] = '{$a->name} に「 {$a->moodleoverflow} 」内の「 {$a->discussion} 」の新しい投稿が通知されます。';
$string['discussions'] = 'ディスカッション';
$string['discussionsubscription'] = 'ディスカッション購読';
$string['discussionsubscription_help'] = 'ディスカッションの購読はあなたがディスカッションの新しい投稿に関する通知を受信することを意味します。';
$string['downvote'] = '反対票';
$string['downvotenotchangeable'] = '反対票 (変更不可)';
$string['edit'] = '編集';
$string['editedby'] = '編集 by {$a->name} - オリジナルの送信日時 {$a->date}';
$string['editedpostupdated'] = '{$a} の投稿が更新されました。';
$string['erroremptymessage'] = '投稿メッセージは空白にできません。';
$string['erroremptysubject'] = '投稿件名は空白にできません。';
$string['errorwhiledelete'] = 'レコードの削除中にエラーが発生しました。';
$string['eventdiscussioncreated'] = 'ディスカッションが作成されました。';
$string['eventdiscussiondeleted'] = 'ディスカッションが削除されました。';
$string['eventdiscussionsubscriptioncreated'] = 'ディスカッション購読が作成されました。';
$string['eventdiscussionsubscriptiondeleted'] = 'ディスカッション購読が削除されました。';
$string['eventdiscussionviewed'] = 'ディスカッションが閲覧されました。';
$string['eventpostcreated'] = '投稿が作成されました。';
$string['eventpostdeleted'] = '投稿が削除されました。';
$string['eventpostupdated'] = '投稿が更新されました。';
$string['eventratingcreated'] = '評価が作成されました。';
$string['eventratingdeleted'] = '評価が削除されました。';
$string['eventratingupdated'] = '評価が更新されました。';
$string['eventreadtrackingdisabled'] = '既読追跡が無効にされました。';
$string['eventreadtrackingenabled'] = '既読追跡が有効にされました。';
$string['eventsubscriptioncreated'] = '購読が作成されました。';
$string['eventsubscriptiondeleted'] = '購読が削除されました。';
$string['everyonecannowchoose'] = '現在、誰でも購読を選択できます。';
$string['everyoneisnowsubscribed'] = '現在、誰でもこのフォーラムを購読できます。';
$string['everyoneissubscribed'] = '誰でもこのフォーラムを購読できる';
$string['forcedreadtracking'] = '強制既読追跡を許可する';
$string['generalmoodleoverflows'] = 'このコースのフォーラム';
$string['gotoindex'] = 'プリファレンスを管理する';
$string['grademaxgradeerror'] = '最大評点はゼロ以外の正の整数にしてください。';
$string['gradesreport'] = '評定レポート';
$string['gradesupdated'] = '評定が更新されました。';
$string['headerdiscussion'] = 'ディスカッション';
$string['headerlastpost'] = '最新の投稿';
$string['headerreplies'] = '返信';
$string['headerstartedby'] = '開始';
$string['headerstatus'] = 'ステータス';
$string['headerunread'] = '未読';
$string['headervotes'] = '投票';
$string['helpfulanswer'] = 'これが最良の回答であると質問のオーナーが受け入れました。';
$string['hiddenmoodleoverflowpost'] = '秘匿フォーラム投稿';
$string['invaliddiscussionid'] = 'ディスカッションIDが正しくありません。';
$string['invalidforcesubscribe'] = '無効な強制購読モードです。';
$string['invalidmoodleoverflowid'] = 'フォーラムIDが正しくありません。';
$string['invalidparentpostid'] = '親投稿IDが正しくありません。';
$string['invalidpostid'] = '無効な投稿ID - {$a}';
$string['invalidratingid'] = '送信された評価は賛成票または反対票でもありません。';
$string['mailindexlink'] = 'あなたのフォーラムプリファレンスを変更する: {$a}';
$string['manydiscussions'] = '1ページあたりのディスカッション数';
$string['markallread'] = 'このディスカッションの投稿すべてを既読マークします。';
$string['markdiscussionreadsuccessful'] = 'ディスカッションが既読マークされました。';
$string['markhelpful'] = '有益であるとマークする';
$string['markmoodleoverflowreadsuccessful'] = 'すべての投稿が既読にマークされました。';
$string['marknothelpful'] = '有益ではない';
$string['marknotsolved'] = '解決マークを削除する';
$string['markread'] = '既読マークする';
$string['markreadfailed'] = 'ディスカッションの投稿を既読にマークできませんでした。';
$string['marksolved'] = '解決したとマークする';
$string['markunread'] = '未読マークする';
$string['maxattachments'] = '最大添付数';
$string['maxattachments_help'] = 'この設定ではフォーラム投稿に添付できる最大ファイル数を指定します。';
$string['maxattachmentsize'] = '最大添付サイズ';
$string['maxattachmentsize_help'] = 'この設定ではフォーラム投稿に添付できる最大ファイルサイズを指定します。';
$string['maxeditingtime'] = 'オーナーが投稿を編集できる最大時間 (秒)';
$string['maxmailingtime'] = '最大メール時間';
$string['message'] = 'メッセージ';
$string['messageprovider:posts'] = '新しい投稿の通知';
$string['modulename'] = 'Moodleoverflow';
$string['modulename_help'] = 'Moodleoverflowモジュールでは参加者が質問-回答フォーラム構造を使用できます。並べ替え順は時間ではなく共同投票に依存するため、フォーラムは非時系列に表示されます。';
$string['modulenameplural'] = 'Moodleoverflow';
$string['moodleoverflow'] = 'Moodleoverflow';
$string['moodleoverflow:addinstance'] = '新しいMoodleoverflowインスタンスを追加する';
$string['moodleoverflow:allowforcesubscribe'] = '強制購読を許可する';
$string['moodleoverflow:createattachment'] = '添付を作成する';
$string['moodleoverflow:deleteanypost'] = '投稿を削除する';
$string['moodleoverflow:deleteownpost'] = '自分の投稿を削除する';
$string['moodleoverflow:editanypost'] = '投稿を編集する';
$string['moodleoverflow:managesubscriptions'] = '購読を管理する';
$string['moodleoverflow:marksolved'] = '投稿を解決したとマークする';
$string['moodleoverflow:ratehelpful'] = '投稿を有益であるとマークする';
$string['moodleoverflow:ratepost'] = '投稿を評価する';
$string['moodleoverflow:replypost'] = 'ディスカッションで返信する';
$string['moodleoverflow:startdiscussion'] = 'ディスカッションを開始する';
$string['moodleoverflow:view'] = 'ディスカッションリストを閲覧する';
$string['moodleoverflow:viewanyrating'] = '評価を表示する';
$string['moodleoverflow:viewdiscussion'] = 'ディスカッションを閲覧する';
$string['moodleoverflowauthorhidden'] = '作成者 (秘匿)';
$string['moodleoverflowbodyhidden'] = 'あなたはこの投稿を閲覧できません。恐らく、あなたがディスカッションに投稿していない、まだ最大編集時間が経過していない、ディスカッションが開始されていない、またはディスカッションの有効期限が切れたと考えられます。';
$string['moodleoverflowfieldset'] = 'カスタムフィールドセット例';
$string['moodleoverflowname'] = 'Moodleoverflow名';
$string['moodleoverflows'] = 'Moodleoverflow';
$string['moodleoverflowsubjecthidden'] = '件名 (非表示)';
$string['nodiscussions'] = 'このフォーラムにはまだディスカッショントピックがありません。';
$string['nodownvote'] = '反対票なし';
$string['noguestpost'] = '申し訳ございません、ゲストは投稿を許可されていません。';
$string['noguesttracking'] = '申し訳ございません、ゲストは追跡オプションを設定できません。';
$string['noonecansubscribenow'] = '現在、購読は許可されません。';
$string['nopermissiontosubscribe'] = 'あなたには購読者を閲覧するパーミッションがありません。';
$string['nopostmoodleoverflow'] = '申し訳ございません、あなたはこのフォーラムに投稿できません。';
$string['noratemoodleoverflow'] = '申し訳ございません、あなたはこのフォーラムで投票できません。';
$string['noratingchangeallowed'] = 'あなたはあなたの評価を変更できません。';
$string['notexists'] = 'ディスカッションは存在しません。';
$string['notpartofdiscussion'] = 'この投稿はディスカッションの一部ではありません!';
$string['notrackmoodleoverflow'] = '未読投稿を追跡しない';
$string['notstartuser'] = 'ディスカッションを開始したユーザのみ回答を有益であるとマークできます。';
$string['notteacher'] = 'コースオーナーのみこれを実行できます。';
$string['noupvote'] = '賛成票なし';
$string['noviewdiscussionspermission'] = 'あなたにはこのフォーラムのディスカッションを閲覧するパーミッションがありません。';
$string['nowallsubscribed'] = '{$a} のすべてのフォーラムが購読されます。';
$string['nowallunsubscribed'] = '{$a} のすべてのフォーラムが購読解除されます。';
$string['nownotsubscribed'] = '{$a->name} には「 {$a->moodleoverflow} 」の新しい投稿は通知されません。';
$string['nownottracking'] = '{$a->name} は「 {$a->moodleoverflow} 」を追跡していません。';
$string['nowsubscribed'] = '{$a->name} に「 {$a->moodleoverflow} 」の新しい投稿が通知されます。';
$string['nowtracking'] = '{$a->name} は「 {$a->moodleoverflow} 」を追跡しています。';
$string['oldpostdays'] = '次の日数以降既読にする';
$string['parent'] = '親を表示する';
$string['permalink'] = 'パーマリンク';
$string['pluginadministration'] = 'Moodleoverflow管理';
$string['pluginname'] = 'Moodleoverflow';
$string['postaddedsuccess'] = 'あなたの投稿が正常に追加されました。';
$string['postaddedtimeleft'] = '修正したい場合、あなたは {$a} 編集できます。';
$string['postbyuser'] = '{$a->post} by {$a->user}';
$string['postincontext'] = 'この投稿をコンテクスト内に表示する';
$string['postmailinfolink'] = 'これは {$a->coursename} に投稿されたメッセージのコピーです。

返信するにはこのリンクをクリックしてください: {$a->replylink}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postnotexist'] = 'リクエストされた投稿は存在しません。';
$string['posts'] = '投稿';
$string['posttomoodleoverflow'] = 'フォーラムに投稿する';
$string['postupdated'] = 'あなたの投稿が更新されました。';
$string['preferteachersmark'] = 'コースオーナーのマークを優先しますか?';
$string['privacy:anonym_discussion_name'] = 'ディスカッション名を匿名化する';
$string['privacy:anonym_post_message'] = 'このコンテンツは削除されました。';
$string['privacy:anonym_user_name'] = '匿名';
$string['privacy:discussionsubscriptionpreference'] = 'あなたはこのフォーラムの次のディスカッション購読プリファレンスを選択しました: {$a->preference}';
$string['privacy:metadata:core_files'] = 'Moodleoverflowはフォーラム投稿の一部としてユーザがフォームにアップロードしたファイルを保持します。';
$string['privacy:metadata:moodleoverflow_discuss_subs'] = '個別のフォーラムディスカッションの購読に関する情報です。これにはユーザがディスカッションの購読を選択した日時、または購読中のディスカッションの購読を解除した日時を含みます。';
$string['privacy:metadata:moodleoverflow_discuss_subs:discussion'] = '購読/購読解除されたディスカッションのDです。';
$string['privacy:metadata:moodleoverflow_discuss_subs:preference'] = '購読の開始日時です。';
$string['privacy:metadata:moodleoverflow_discuss_subs:userid'] = '購読設定を変更したユーザのIDです。';
$string['privacy:metadata:moodleoverflow_discussions'] = 'フォーラムディスカッションに関する情報です。これにはユーザが開始したディスカッションを含みます。';
$string['privacy:metadata:moodleoverflow_discussions:name'] = 'ディスカッションの名称です。';
$string['privacy:metadata:moodleoverflow_discussions:timemodified'] = 'ディスカッション (例 投稿) が最後に修正された時間です。';
$string['privacy:metadata:moodleoverflow_discussions:userid'] = 'ディスカッションを開始したユーザのIDです。';
$string['privacy:metadata:moodleoverflow_discussions:usermodified'] = '最後にディスカッション修正したユーザのIDです。';
$string['privacy:metadata:moodleoverflow_posts'] = 'フォーラム投稿に関する情報です。これにはユーザが書き込んだ投稿のデータを含みます。';
$string['privacy:metadata:moodleoverflow_posts:created'] = 'この投稿が作成された日時です。';
$string['privacy:metadata:moodleoverflow_posts:discussion'] = 'この投稿が追加されるディスカッションのIDです。';
$string['privacy:metadata:moodleoverflow_posts:message'] = 'この投稿のテキストです。';
$string['privacy:metadata:moodleoverflow_posts:modified'] = 'この投稿が最後に修正された日時です。';
$string['privacy:metadata:moodleoverflow_posts:parent'] = 'この投稿が参照する投稿のIDです。';
$string['privacy:metadata:moodleoverflow_posts:userid'] = 'この投稿を送信したユーザのIDです。';
$string['privacy:metadata:moodleoverflow_ratings'] = '投稿の評価に関する情報です。これにはユーザが投稿を評価した日時および評価詳細を含みます。';
$string['privacy:metadata:moodleoverflow_ratings:discussionid'] = '評価された投稿が一部であるディスカッションのIDです。';
$string['privacy:metadata:moodleoverflow_ratings:firstrated'] = '評価が送信された日時です。';
$string['privacy:metadata:moodleoverflow_ratings:lastchanged'] = '最後に評価が変更された日時です。';
$string['privacy:metadata:moodleoverflow_ratings:moodleoverflowid'] = '評価済み投稿を含むMoodleoverflowフォーラムのIDです。';
$string['privacy:metadata:moodleoverflow_ratings:postid'] = '評価された投稿のIDです。';
$string['privacy:metadata:moodleoverflow_ratings:rating'] = '送信された評価です。0 = 中立、1 = マイナス、2 = プラス、3 = 有益、4 = 解決';
$string['privacy:metadata:moodleoverflow_ratings:userid'] = '評価を送信したユーザのIDです。';
$string['privacy:metadata:moodleoverflow_read'] = '投稿の既読追跡に関する情報です。これにはユーザに投稿が読まれた日時を含みます。';
$string['privacy:metadata:moodleoverflow_read:discussionid'] = '既読投稿が属するディスカッションのIDです。';
$string['privacy:metadata:moodleoverflow_read:firstread'] = '投稿が最初に読まれた日時です。';
$string['privacy:metadata:moodleoverflow_read:lastread'] = '投稿が最後にユーザに読まれた日時です。';
$string['privacy:metadata:moodleoverflow_read:postid'] = '読まれた投稿のIDです。';
$string['privacy:metadata:moodleoverflow_read:userid'] = '投稿を読んだユーザのIDです。';
$string['privacy:metadata:moodleoverflow_subscriptions'] = 'フォーラムの購読に関する情報です。これにはユーザが購読しているフォーラムの情報を含みます。';
$string['privacy:metadata:moodleoverflow_subscriptions:moodleoverflow'] = 'ユーザが購読しているMoodleoverflowフォーラムのIDです。';
$string['privacy:metadata:moodleoverflow_subscriptions:userid'] = 'フォーラムを購読したユーザのIDです。';
$string['privacy:metadata:moodleoverflow_tracking'] = 'フォーラム追跡に関する情報です。これにはユーザが追跡していないフォーラムを含みます。';
$string['privacy:metadata:moodleoverflow_tracking:moodleoverflowid'] = 'ユーザに追跡されていないMoodleoverflowフォーラムのIDです。';
$string['privacy:metadata:moodleoverflow_tracking:userid'] = 'フォーラムを追跡していないユーザのIDです。';
$string['privacy:postwasread'] = 'この投稿が最初に読まれたのは {$a->firstread} です。また、最も最近に読まれたのは {$a->lastread} です。';
$string['privacy:readtrackingdisabled'] = 'あなたはこのフォーラム内で読んだ投稿を追跡しないよう選択しました。';
$string['privacy:subscribedtoforum'] = 'あなたはこのフォーラムを購読しています。';
$string['rateownpost'] = 'あなた自身の投稿は評価できません。';
$string['ratingfailed'] = '評価に失敗しました。再度お試しください。';
$string['ratingheading'] = '評価およびレピュテーション';
$string['ratingpreference'] = '最初に表示する';
$string['ratingpreference_help'] = '回答は解決または有益であるとマークできます。このオプションによりどれがディスカッションの最初の回答してピン留めされるか決定します。以下2つのオプションがあります:

* 有益 - トピック開始者の有益マークがディスカッションの先頭にピン留めされます。
* 解決 - 教師の解決マークがディスカッションの先頭にピン留めされます。';
$string['ratingtoold'] = '評価は最初の投票後30分以内のみ変更できます。';
$string['re'] = 'Re:';
$string['reply'] = 'コメント';
$string['replyfirst'] = '回答';
$string['reputation'] = 'レピュテーション';
$string['reputationnotnegative'] = 'レピュテーションはプラスのみですか?';
$string['scalefactor'] = 'スケール因子';
$string['scalefactor_help'] = 'それぞれのユーザの評点を取得するため、ユーザ評価はスケール因子で除算されます。結果の評点が最大評点より大きい場合、値は指定された最大評点に制限されます。';
$string['scalefactorerror'] = 'スケール因子はゼロ以外の正の整数にしてください。';
$string['smallmessage'] = '{$a->user} が {$a->moodleoverflowname} に投稿しました。';
$string['solvedanswer'] = 'この投稿は解決マークされています。';
$string['starterrating'] = '有益';
$string['subject'] = '件名';
$string['subscribe'] = 'このフォーラムを購読する';
$string['subscribed'] = '購読済み';
$string['subscribeenrolledonly'] = '申し訳ございません、登録ユーザのみが投稿通知の購読を許可されています。';
$string['subscribestart'] = 'このフォーラムの新しい投稿の通知を私に送信してください';
$string['subscribestop'] = 'このフォーラムの新しい投稿の通知を私に送信しないでください';
$string['subscriptionauto'] = '自動購読';
$string['subscriptiondisabled'] = '購読無効';
$string['subscriptionforced'] = '購読強制';
$string['subscriptionmode'] = '購読モード';
$string['subscriptionmode_help'] = '参加者がフォーラムを購読した場合、フォーラム投稿通知を受信することを意味します。以下、4つの購読モードオプションがあります:

* 任意購読 - 参加者は購読するかどうか選択できます。
* 強制購読 - すべての参加者が購読して購読解除はできません。
* 自動購読 - 最初はすべての参加者が購読しますが、いつでも購読解除を選択できます。
* 購読無効 - 購読は許可されません。

注意: すべての購読モードの変更は将来的にコースに登録するユーザにのみ影響します。既存のユーザには影響しません。';
$string['subscriptionoptional'] = '任意購読';
$string['subscriptiontrackingheader'] = '購読および追跡';
$string['taskcleanreadrecords'] = '古い既読レコードを削除するためのMoodleoverflowメンテナンスジョブ';
$string['tasksendmails'] = 'メールを送信するためのMoodleoverflowメンテナンスジョブ';
$string['taskupdategrades'] = '評定を更新するためのMoodleoverflowメンテナンスジョブ';
$string['teacherrating'] = '解決';
$string['tracking'] = '追跡';
$string['trackingoff'] = 'Off';
$string['trackingon'] = '強制';
$string['trackingoptional'] = '任意';
$string['trackingtype'] = '既読追跡';
$string['trackingtype_help'] = '既読追跡により参加者はまだ閲覧していない強調表示された新しい投稿を簡単にチェックできます。

任意に設定された場合、デフォルトで追跡は有効にされますが、参加者は追跡を解除できます。

「強制既読追跡を許可する」がサイト管理で有効にされた場合、さらにオプション「強制」が利用可能となります。これは常に追跡が有効にされることを意味します。';
$string['trackmoodleoverflow'] = '未読投稿を追跡する';
$string['unknownerror'] = 'これは発生しないはずです。';
$string['unreadposts'] = '未読投稿';
$string['unreadpostsnumber'] = '{$a} 未読投稿';
$string['unreadpostsone'] = '1 未読投稿';
$string['unsubscribe'] = 'このフォーラムを購読解除する';
$string['unsubscribediscussion'] = 'このディスカッションを購読解除する';
$string['unsubscribediscussionlink'] = 'このディスカッションを購読解除する: {$a}';
$string['unsubscribelink'] = 'このフォーラムを購読解除する: {$a}';
$string['updategrades'] = '評定を更新する';
$string['upvote'] = '賛成票';
$string['upvotenotchangeable'] = '賛成票 (変更不可)';
$string['votescaledownvote'] = 'レピュテーション: 反対票';
$string['votescalehelpful'] = 'レピュテーション: 有益';
$string['votescalesolved'] = 'レピュテーション: 解決';
$string['votescaleupvote'] = 'レピュテーション: 賛成票';
$string['votescalevote'] = 'レピュテーション: 投票';
$string['yournewtopic'] = 'あなたの新しいディスカッショントピック';
$string['yourreply'] = 'あなたの返信';
