<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'ja', version '3.8'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = 'カテゴリを追加する';
$string['addcomment'] = 'コメントを追加する';
$string['addentry'] = '新しいエントリを追加する';
$string['addingcomment'] = 'コメントを追加する';
$string['alias'] = 'キーワード';
$string['aliases'] = 'キーワード';
$string['aliases_help'] = '関連付けられたキーワードリスト (またはエイリアス) をそれぞれの用語集エントリに付加することができます。

新しい行にカンマで区切らずにそれぞれのキーワードを入力してください。';
$string['allcategories'] = 'すべてのカテゴリ';
$string['allentries'] = 'すべて';
$string['allowcomments'] = 'エントリへのコメントを許可する';
$string['allowcomments_help'] = 'この設定を有効にした場合、コメントを作成するパーミッションが与えられたすべてのユーザは用語集エントリにコメントを追加することができます。';
$string['allowduplicatedentries'] = '重複エントリを許可する';
$string['allowduplicatedentries_help'] = 'この設定を有効にした場合、同一用語に複数のエントリを作成することができます。';
$string['allowprintview'] = '印刷ビューを許可する';
$string['allowprintview_help'] = 'この設定を有効にした場合、学生には用語集のプリンタフレンドリバージョンのリンクが提供されます。教師は常にこのリンクを使用することができます。';
$string['andmorenewentries'] = 'および {$a} 件の新しいエントリ';
$string['answer'] = '答え';
$string['approvaldisplayformat'] = '表示フォーマットの承認';
$string['approvaldisplayformat_help'] = 'あなたが用語集フォーマットを承認した場合、異なる表示フォーマットを使用することができます。';
$string['approve'] = '承認';
$string['areaattachment'] = '添付';
$string['areaentry'] = '定義';
$string['areyousuredelete'] = '本当にこのエントリを削除してもよろしいですか?';
$string['areyousuredeletecomment'] = '本当にこのコメントを削除してもよろしいですか?';
$string['areyousureexport'] = '本当にこのエントリを以下の用語集にエクスポートしてもよろしいですか?';
$string['ascending'] = '昇順';
$string['attachment'] = '添付';
$string['attachment_help'] = 'あなたは1つまたはそれ以上のファイルを任意で用語集エントリに添付することができます。';
$string['author'] = '著者';
$string['authorview'] = '著者順';
$string['back'] = '戻る';
$string['cachedef_concepts'] = '用語リンク';
$string['cantinsertcat'] = 'カテゴリを追加できません。';
$string['cantinsertrec'] = 'レコードを追加できません。';
$string['cantinsertrel'] = '関連カテゴリエントリを追加できません。';
$string['casesensitive'] = '大文字小文字を区別する';
$string['casesensitive_help'] = 'この設定ではエントリにオートリンクする場合、大文字小文字を厳密に区別するかどうか設定します。';
$string['cat'] = 'カテゴリ';
$string['categories'] = 'カテゴリ';
$string['category'] = 'カテゴリ';
$string['categorydeleted'] = 'カテゴリが削除されました。';
$string['categoryview'] = 'カテゴリ順';
$string['changeto'] = '{$a} に変更する';
$string['cnfallowcomments'] = 'エントリへのコメントをデフォルトで許可します。';
$string['cnfallowdupentries'] = '重複エントリをデフォルトで許可します。';
$string['cnfapprovalstatus'] = '学生による投稿の承認ステータスのデフォルトを設定します。';
$string['cnfcasesensitive'] = 'エントリがリンクされる場合、大文字小文字を区別します。';
$string['cnfdefaulthook'] = '用語集が表示される時のデフォルトセクションを選択してください。';
$string['cnfdefaultmode'] = '用語集が最初に表示される時のデフォルトフレームを選択してください。';
$string['cnffullmatch'] = 'エントリがリンクされる場合、ターゲットテキストと文字の大小 (大文字小文字) を合致させます。';
$string['cnflinkentry'] = 'エントリをデフォルトで自動的にリンクさせます。';
$string['cnflinkglossaries'] = '用語集をデフォルトで自動的にリンクさせます。';
$string['cnfrelatedview'] = 'オートリンクおよびエントリ表示に使用する表示フォーマットを選択してください。';
$string['cnfshowgroup'] = 'グループ区切りを表示するかどうか指定してください。';
$string['cnfsortkey'] = 'デフォルトの並べ替えキーを選択してください。';
$string['cnfsortorder'] = 'デフォルトの並べ替え順を選択してください。';
$string['cnfstudentcanpost'] = '学生のエントリ投稿をデフォルトで許可します。';
$string['cnftabs'] = 'この用語集フォーマットに表示されるタブを選択してください。';
$string['comment'] = 'コメント';
$string['commentdeleted'] = 'コメントが削除されました。';
$string['comments'] = 'コメント';
$string['commentson'] = 'コメント';
$string['commentupdated'] = 'コメントが更新されました。';
$string['completionentries'] = '学生はエントリを作成する必要がある:';
$string['completionentriesdesc'] = '学生は少なくとも {$a} 件のエントリを作成する必要があります。';
$string['completionentriesgroup'] = '必須エントリ';
$string['concept'] = '用語';
$string['concepts'] = '用語';
$string['configenablerssfeeds'] = 'すべての用語集に関するRSSフィードを有効にします。あなたはそれぞれの用語集設定において手動でRSSフィードを有効にする必要があります。';
$string['current'] = '現在の並べ替え順: {$a}';
$string['currentglossary'] = '現在の用語集';
$string['date'] = '日付';
$string['dateview'] = '日付順';
$string['defaultapproval'] = 'デフォルトで承認する';
$string['defaultapproval_help'] = 'この設定を無効にした場合、エントリをすべてのユーザに閲覧できるようになる前に教師が承認する必要があります。';
$string['defaulthook'] = 'デフォルトフック';
$string['defaultmode'] = 'デフォルトモード';
$string['defaultsortkey'] = 'デフォルトの並べ替えキー';
$string['defaultsortorder'] = 'デフォルトの並べ替え順';
$string['definition'] = '定義';
$string['definitions'] = '定義';
$string['deletecategory'] = 'カテゴリを削除する';
$string['deleteentry'] = 'エントリを削除する';
$string['deleteentrya'] = 'エントリを削除する: {$a}';
$string['deletenotenrolled'] = '登録されていないユーザのエントリを削除する';
$string['deletingcomment'] = 'コメントの削除';
$string['deletingnoneemptycategory'] = 'このカテゴリを削除する削除することにより、含まれるエントリは削除されずにカテゴリなしとマークされます。';
$string['descending'] = '降順';
$string['destination'] = 'インポート先';
$string['destination_help'] = 'エントリは現在の用語集または新しい用語集にインポートおよび追加することができます。この場合、新しい用語集はXMLファイルの情報に基づき作成されます。';
$string['disapprove'] = '承認を取り消す';
$string['displayformat'] = '表示フォーマット';
$string['displayformat_help'] = '用語集には以下7つの表示フォーマットがあります:

*シンプル、辞書スタイル - 著者は表示されず、添付はリンクとして表示されます。
*連続 - エントリが編集アイコンと共に分離されずに連続表示されます。
*フル - 著者あり - 著者情報と共にフォーラムのように表示されます。添付はリンクとして表示されます。
*フル - 著者なし - 著者情報なしでフォーラムのように表示されます。添付はリンクとして表示されます。
*百科辞書 - 「フル、著者有り」のように表示されます。イメージは用語集の内部に表示されます。
*エントリリスト - 用語をリンクとして一覧表示します。
*FAQ - それぞれの「用語」および「定義」に対して、自動的に「質問」および「答え」の文字が追加されます。';
$string['displayformatcontinuous'] = '連続 - 著者なし';
$string['displayformatdefault'] = '表示フォーマットと同じデフォルトにする';
$string['displayformatdictionary'] = 'シンプル - 辞書スタイル';
$string['displayformatencyclopedia'] = '百科事典';
$string['displayformatentrylist'] = 'エントリリスト';
$string['displayformatfaq'] = 'FAQ';
$string['displayformatfullwithauthor'] = 'フル - 著者あり';
$string['displayformatfullwithoutauthor'] = 'フル - 著者なし';
$string['displayformats'] = '表示フォーマット';
$string['displayformatssetup'] = '表示フォーマット設定';
$string['duplicatecategory'] = '重複カテゴリ';
$string['duplicateentry'] = '重複エントリ';
$string['editalways'] = '常に編集を許可する';
$string['editalways_help'] = 'ここでは学生が常にエントリを編集できるか、または設定された時間内 (通常30分) 編集できるか指定することができます。';
$string['editcategories'] = 'カテゴリを編集する';
$string['editcategory'] = 'カテゴリを編集する';
$string['editentry'] = 'エントリを編集する';
$string['editentrya'] = 'エントリを編集する: {$a}';
$string['editingcomment'] = 'コメントの編集';
$string['entbypage'] = '1ページあたりのエントリ数';
$string['entries'] = 'エントリ';
$string['entrieswithoutcategory'] = 'カテゴリなしのエントリ';
$string['entry'] = 'エントリ';
$string['entryalreadyexist'] = 'エントリがすでに登録されています。';
$string['entryapproved'] = 'このエントリが承認されました。';
$string['entrydeleted'] = 'エントリが削除されました。';
$string['entryexported'] = 'エントリが正常にエクスポートされました。';
$string['entryishidden'] = '( このエントリは現在非表示にされています)';
$string['entryleveldefaultsettings'] = 'エントリレベルのデフォルト設定';
$string['entrylink'] = 'エントリリンク: {$a}';
$string['entrynotapproved'] = 'エントリが承認されていません。';
$string['entrysaved'] = 'このエントリが保存されました。';
$string['entryupdated'] = 'このエントリが更新されました。';
$string['entryusedynalink'] = 'このエントリを自動的にリンクさせる';
$string['entryusedynalink_help'] = '管理者によって用語集オートリンクが有効にされた上でこの設定が有効にされた場合、エントリはコース全体で出現した用語またはフレーズに自動的にリンクされます。';
$string['errcannoteditothers'] = 'あなたは他の人のエントリを編集できません。';
$string['errconceptalreadyexists'] = 'この用語はすでに登録されています。この用語集では重複は許可されていません。';
$string['errdeltimeexpired'] = 'あなたはこのエントリを削除できません。編集期限は終了しました!';
$string['erredittimeexpired'] = 'このエントリの編集期限は終了しました。';
$string['errorparsingxml'] = 'ファイルの構文解析中にエラーが発生しました。有効なXML構文かどうか確認してください。';
$string['eventcategorycreated'] = 'カテゴリが作成されました。';
$string['eventcategorydeleted'] = 'カテゴリが削除されました。';
$string['eventcategoryupdated'] = 'カテゴリが更新されました。';
$string['evententryapproved'] = 'エントリが承認されました。';
$string['evententrycreated'] = 'エントリが作成されました。';
$string['evententrydeleted'] = 'エントリが削除されました。';
$string['evententrydisapproved'] = 'エントリが承認されませんでした。';
$string['evententryupdated'] = 'エントリが更新されました。';
$string['evententryviewed'] = 'エントリが閲覧されました。';
$string['explainaddentry'] = '現在の用語集に新しいエントリを追加します。<br />用語および定義は必須入力フィールドです。';
$string['explainall'] = 'すべてのエントリを1ページに表示する';
$string['explainalphabet'] = 'このインデックスを使用して用語集を表示する';
$string['explainexport'] = '用語集をエクスポートするには以下のボタンをクリックしてください。<br />いつでも必要なときに用語集をこのコースまたは他のコースにインポートすることができます。<p>添付(例 イメージ) および著者はエクスポートされない点に留意してください。</p>';
$string['explainimport'] = 'インポートするファイルおよび処理のクライテリアを指定してください。<p>実行後、結果を検証してください。</p>';
$string['explainspecial'] = '１文字で始まらないエントリを表示します。';
$string['exportedentry'] = 'エクスポートされたエントリ';
$string['exportentries'] = 'エントリをエクスポートする';
$string['exportentriestoxml'] = 'エントリをXMLファイルにエクスポートする';
$string['exportfile'] = 'エントリをファイルにエクスポートする';
$string['exportglossary'] = '用語集をエクスポートする';
$string['exporttomainglossary'] = 'メイン用語集へエクスポートする';
$string['filetoimport'] = 'インポートするファイル';
$string['filetoimport_help'] = 'あなたのコンピュータのインポートするエントリを含むXMLファイルを選択してください。';
$string['fillfields'] = '用語および定義は必須入力フィールドです。';
$string['filtername'] = '用語集オートリンク';
$string['fullmatch'] = '完全一致のみ';
$string['fullmatch_help'] = 'この設定では単語が完全に一致した場合のみリンクするかどうか指定します。例えば用語集エントリの「construct」という単語は内部に同じ単語が含まれた「constructivism」にはリンクされません。';
$string['glossary:addinstance'] = '新しい用語集を追加する';
$string['glossary:approve'] = 'エントリを承認または承認済みエントリを取り消す';
$string['glossary:comment'] = 'コメントを作成する';
$string['glossary:export'] = 'エントリをエクスポートする';
$string['glossary:exportentry'] = '単一エントリをエクスポートする';
$string['glossary:exportownentry'] = 'あなたの単一エントリをエクスポートする';
$string['glossary:import'] = 'エントリをインポートする';
$string['glossary:managecategories'] = 'カテゴリを管理する';
$string['glossary:managecomments'] = 'コメントを管理する';
$string['glossary:manageentries'] = 'エントリを管理する';
$string['glossary:rate'] = 'エントリを評価する';
$string['glossary:view'] = '用語集を表示する';
$string['glossary:viewallratings'] = '個別のユーザから与えられた実評価すべてを表示する';
$string['glossary:viewanyrating'] = 'すべてのユーザが受けた評価合計を表示する';
$string['glossary:viewrating'] = 'あなたが受けた評価合計を表示する';
$string['glossary:write'] = '新しいエントリを作成する';
$string['glossaryleveldefaultsettings'] = '用語集レベルのデフォルト設定';
$string['glossarytype'] = '用語集タイプ';
$string['glossarytype_help'] = 'メイン用語集はサブ用語集からエントリをインポートできる用語集です。コース内でのメイン用語集は1つのみ存在することができます。用語集エントリのインポートが必須ではない場合、コース内の用語集すべてをサブ用語集にすることができます。';
$string['guestnoedit'] = 'ゲストは用語集を編集できません。';
$string['importcategories'] = 'カテゴリをインポートする';
$string['importedcategories'] = 'インポート済みカテゴリ';
$string['importedentries'] = 'インポート済みエントリ';
$string['importentries'] = 'エントリをインポートする';
$string['importentriesfromxml'] = 'エントリをXMLファイルからインポートする';
$string['includegroupbreaks'] = 'グループ区切りを含む';
$string['indicator:cognitivedepth'] = '用語集認知的';
$string['indicator:cognitivedepth_help'] = 'この指標は用語集活動で学生が到達した認識深度に基づきます。';
$string['indicator:cognitivedepthdef'] = '用語集認知的';
$string['indicator:cognitivedepthdef_help'] = 'この分析間隔中、参加者が用語集活動から提供された認知的関与のこのパーセンテージに到達しました (レベル = 閲覧なし, 閲覧, 送信)。';
$string['indicator:socialbreadth'] = '用語集社会的';
$string['indicator:socialbreadth_help'] = 'この指標は用語集活動で学生が到達した社会的広がりに基づきます。';
$string['indicator:socialbreadthdef'] = '用語集社会的';
$string['indicator:socialbreadthdef_help'] = 'この分析間隔中、参加者が用語集活動から提供された社会的関与のこのパーセンテージに到達しました (レベル = 参加なし, 個人で参加)。';
$string['isglobal'] = 'これはグローバル用語集ですか?';
$string['isglobal_help'] = '用語集エントリがコース内でのみリンクされるのに対してグローバル用語集はサイト全体からリンクされるエントリを持つことができます。管理者のみ用語集をグローバルに設定することができます。';
$string['letter'] = 'アルファベット';
$string['linkcategory'] = 'このカテゴリを自動的にリンクする';
$string['linkcategory_help'] = '用語集オートリンクが有効にされた上でこの設定が有効にされた場合、コース内で出現したカテゴリ名は自動的にリンクされます。参加者がカテゴリ名リンクをクリックした場合、用語集の「カテゴリ順」ページに移動します。';
$string['linking'] = 'オートリンク';
$string['mainglossary'] = 'メイン用語集';
$string['maxtimehaspassed'] = '申し訳ございません、このコメントの最大編集回数 ({$a}) を超えました!';
$string['modulename'] = '用語集';
$string['modulename_help'] = '用語集活動モジュールにおいて、参加者は辞書のような定義リストを作成および管理すること、またはリソースおよび情報を収集および整理することができます。

教師は用語集エントリへのファイルの添付を許可することができます。添付されたイメージはエントリ内に表示されます。エントリは検索、またはアルファベット順、カテゴリ順、日付順、著者順に閲覧することができます。エントリはデフォルトで承認すること、またはユーザによって閲覧できるようになる前に教師の承認を必要とすることができます。

用語集オートリンクフィルタが有効にされた場合、用語またはフレーズがコース内に表示された時点でエントリが自動的にリンクされます。

教師はエントリへのコメントを許可することができます。エントリは教師または学生 (ピア評価) により評価できるようにすることもできます。評価は合計した後に最終評価として評定表に記録させることができます。

用語集は以下のように使用することができます:

* 重要語の共同収集バンクとして
* 新しい学生が氏名および個人詳細を掲載する「あなたの知り合いになる」スペースとして
* 実習科目に関するベストプラクティスの「役立つヒント」リソースとして
* 有用なビデオ、イメージまたは音声ファイルの共有エリアとして
* 記憶しておくべき事実の試験対策リソースとして';
$string['modulenameplural'] = '用語集';
$string['newentries'] = '新しい用語集エントリ';
$string['newglossary'] = '新しい用語集';
$string['newglossarycreated'] = '新しい用語集が作成されました。';
$string['newglossaryentries'] = '新しい用語集エントリ:';
$string['nocomment'] = 'コメントが見つかりませんでした。';
$string['nocomments'] = '( このエントリにはコメントはありません)';
$string['noconceptfound'] = '用語または定義が見つかりませんでした。';
$string['noentries'] = 'このセクションにはエントリがありません。';
$string['noentry'] = 'エントリが見つかりませんでした。';
$string['nopermissiontodelcomment'] = 'あなたは他の人のコメントを削除できません!';
$string['nopermissiontodelinglossary'] = 'あなたはこの用語集にコメントを追加できません!';
$string['nopermissiontoviewresult'] = 'あなたは自分のエントリの結果のみ閲覧できます。';
$string['notapproved'] = '用語集エントリはまだ承認されていません。';
$string['notcategorised'] = 'カテゴリなし';
$string['numberofentries'] = 'エントリ数';
$string['onebyline'] = '(1行あたり1件)';
$string['page-mod-glossary-edit'] = '用語集エントリ追加/編集ページ';
$string['page-mod-glossary-view'] = '用語集編集ページを表示する';
$string['page-mod-glossary-x'] = 'すべての用語集モジュールページ';
$string['pluginadministration'] = '用語集管理';
$string['pluginname'] = '用語集';
$string['popupformat'] = 'ポップアップフォーマット';
$string['print'] = '印刷';
$string['printerfriendly'] = '印刷モード';
$string['printviewnotallowed'] = '印刷モードは許可されていません。';
$string['privacy'] = '結果のプライバシーです。';
$string['privacy:metadata:core_comments'] = '用語集定義のコメントはcore_commentシステムを使用して保存されます。';
$string['privacy:metadata:core_files'] = '用語集定義にリンクされたファイルはcore_filesシステムを使用して保存されます。';
$string['privacy:metadata:core_rating'] = '用語集エントリに追加された評価はcore_ratingシステムを使用して保存されます。';
$string['privacy:metadata:core_tag'] = '用語集定義に追加されたタグはcore_tagシステムを使用して保存されます。';
$string['privacy:metadata:glossary_entries'] = '所与の用語集活動のユーザのエントリに関する情報です。';
$string['privacy:metadata:glossary_entries:attachment'] = 'ユーザが追加したエントリの添付です。';
$string['privacy:metadata:glossary_entries:concept'] = 'ユーザが追加したエントリの用語です。';
$string['privacy:metadata:glossary_entries:definition'] = 'ユーザが追加したエントリの定義です。';
$string['privacy:metadata:glossary_entries:glossaryid'] = '用語集活動のIDです。';
$string['privacy:metadata:glossary_entries:timemodified'] = 'タイムスタンプは用語集エントリがユーザによって修正された日時を示します。';
$string['privacy:metadata:glossary_entries:userid'] = 'この用語集エントリを追加するユーザのIDです。';
$string['question'] = '質問';
$string['rejectedentries'] = '拒否されたエントリ';
$string['rejectionrpt'] = '拒否レポート';
$string['removeallglossarytags'] = 'すべての用語集タグを削除する';
$string['resetglossaries'] = 'エントリ削除対象';
$string['resetglossariesall'] = 'すべての用語集からエントリを削除する';
$string['rssarticles'] = '最近の記事のRSS数';
$string['rssarticles_help'] = 'ここではRSSフィードに含まれる記事数を設定します。一般的に5から20の間が適切です。';
$string['rsssubscriberss'] = '{$a} の用語のRSSフィードを表示する';
$string['rsstype'] = 'この活動のRSSフィード';
$string['rsstype_help'] = 'この活動のRSSフィードを有効にするにはフィードに含まれるのが著者ありの用語であるかまたは著者なしの用語であるか選択してください。';
$string['search:activity'] = '用語集 - 活動情報';
$string['search:entry'] = '用語集 - エントリ';
$string['searchindefinition'] = '全文検索する';
$string['secondaryglossary'] = 'サブ用語集';
$string['showall'] = 'すべてのリンクを表示する';
$string['showall_help'] = 'この設定を有効にした場合、参加者はすべてのエントリを一度に閲覧することができます。';
$string['showalphabet'] = 'アルファベットリンクを表示する';
$string['showalphabet_help'] = 'この設定を有効にした場合、参加者はアルファベット順で用語集を閲覧することができます。';
$string['showspecial'] = '特別リンクを表示する';
$string['showspecial_help'] = 'この設定を有効にした場合、参加者は@、#のような特殊文字順で用語集を閲覧することができます。';
$string['sortby'] = '並べ替え';
$string['sortbycreation'] = '作成日時';
$string['sortbylastupdate'] = '最終更新日時';
$string['sortchronogically'] = '日付順の並べ替え';
$string['special'] = '特別';
$string['standardview'] = 'アルファベット順';
$string['studentcanpost'] = '学生のエントリ追加を許可する';
$string['tagarea_glossary_entries'] = '用語集エントリ';
$string['tagsdeleted'] = '用語集タグが削除されました。';
$string['totalentries'] = 'エントリ合計';
$string['usedynalink'] = 'エントリを自動的にリンクする';
$string['usedynalink_help'] = '管理者によって用語集オートリンクが有効にされた上でこの設定が有効にされた場合、「新しいエントリを追加する」フォームにはコース全体で出現した用語またはフレーズにエントリを自動的にリンクするためのオプションを含みます。';
$string['visibletabs'] = '表示タブ';
$string['waitingapproval'] = '承認待ち';
$string['warningstudentcapost'] = '(用語集がメイン用語集ではない場合に適用)';
$string['withauthor'] = '用語 (著者あり)';
$string['withoutauthor'] = '用語 (著者なし)';
$string['writtenby'] = '作成';
$string['youarenottheauthor'] = 'あなたはこのコメントの投稿者ではありません。コメントの編集は許可されません。';
