<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'pt_br', version '3.8'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'Lá♭ maior';
$string['abminor'] = 'Lá♭ menor';
$string['acc_b'] = '♭';
$string['acc_bb'] = '♭♭';
$string['acc_n'] = '♮';
$string['acc_sharp'] = '♯';
$string['acc_x'] = 'x';
$string['alto'] = 'Clave de Dó';
$string['altoclef'] = 'Clave de Dó';
$string['anmajor'] = 'Lá maior';
$string['anminor'] = 'Lá menor';
$string['answerlbl'] = 'Resposta';
$string['asharpminor'] = 'Lá♯ menor';
$string['aug10'] = '10ª Aumentada';
$string['aug11'] = '11ª Aumentada';
$string['aug12'] = '12ª Aumentada';
$string['aug13'] = '13ª Aumentada';
$string['aug2'] = '2ª Aumentada';
$string['aug3'] = '3ª Aumentada';
$string['aug4'] = '4ª Aumentada';
$string['aug5'] = '5ª Aumentada';
$string['aug6'] = '6ª Aumentada';
$string['aug6thfr'] = 'Sexta Francesa';
$string['aug6thgr'] = 'Sexta Alemã';
$string['aug6thit'] = 'Sexta Italiana';
$string['aug7'] = '7ª Aumentada';
$string['aug8'] = 'Oitava Aumentada';
$string['aug9'] = '9ª Aumentada';
$string['augmented'] = 'Aumentado';
$string['bass'] = 'Clave de Fá';
$string['bassclef'] = 'Clave de Fá';
$string['bbmajor'] = 'Si♭ maior';
$string['bbminor'] = 'Si♭ menor';
$string['bnmajor'] = 'Si maior';
$string['bnminor'] = 'Si menor';
$string['cbmajor'] = 'Dó♭ maior';
$string['chordquality'] = 'Tipo de acorde';
$string['chordquality-random'] = 'Tipos de acorde';
$string['chordquality_write_questionastext'] = 'Tipo de acorde respondido';
$string['chordquality_write_questionastext_help'] = '<p>Insira uma sequência de notas separadas por vírgula,
  sem espaços, usando a seguinte sintaxe:</p><p>[Nota com MAIÚSCULAS][Acidente
  ("n" = natural, "#" = sustenido, "b" = bemol, "x" = dobrado-sustenido, "bb" = dobrado-bemol)]4, ... </p>
 <p>Exemplo: <b>resposta=>Cn4,En4,G#4</b></p>';
$string['chordquality_write_questionasui'] = 'Função Harmônica respondida';
$string['chordquality_write_questionasui_help'] = '<p>Insira as notas clicando na pauta após selecionar o tipo de alteração na barra da direita. Para apagar uma nota, clique novamente nela.</p>';
$string['chordroot'] = 'Fundamental do acorde';
$string['clef'] = 'Clave';
$string['clef-random'] = 'Claves possíveis';
$string['cnmajor'] = 'Dó maior';
$string['cnminor'] = 'Dó menor';
$string['considerregister'] = 'Incluir registro';
$string['considerregister_help'] = 'Indica se o registro da nota deve ser incluso como parte da questão.';
$string['correctansweris'] = 'A resposta correta é:';
$string['correctansweris_morethanone'] = 'Uma resposta possível é:';
$string['csharpmajor'] = 'Dó♯ maior';
$string['csharpminor'] = 'Dó♯ menor';
$string['dbmajor'] = 'Ré♭ maior';
$string['dim10'] = '10ª Diminuta';
$string['dim11'] = '11ª Diminuta';
$string['dim12'] = '12ª Diminuta';
$string['dim13'] = '13ª Diminuta';
$string['dim2'] = '2ª Diminuta';
$string['dim3'] = '3ª Diminuta';
$string['dim4'] = '4ª Diminuta';
$string['dim5'] = '5ª Diminuta';
$string['dim6'] = '6ª Diminuta';
$string['dim7'] = '7ª Diminuta';
$string['dim8'] = 'Oitava Diminuta';
$string['dim9'] = '9ª Diminuta';
$string['diminished'] = 'Diminuto';
$string['dirasc'] = 'Acima da nota indicada';
$string['dirdesc'] = 'Abaixo da nota indicada';
$string['direction'] = 'Direção';
$string['displaykeysignature'] = 'Mostrar armadura de clave';
$string['dnmajor'] = 'Ré maior';
$string['dnminor'] = 'Ré menor';
$string['dsharpminor'] = 'Ré♯ menor';
$string['ebmajor'] = 'Mi♭ maior';
$string['ebminor'] = 'Mi♭ menor';
$string['emptykeysignature'] = 'Sem armadura';
$string['enmajor'] = 'Mi maior';
$string['enminor'] = 'Mi menor';
$string['fnmajor'] = 'Fá maior';
$string['fnminor'] = 'Fá menor';
$string['fsharpmajor'] = 'Fá♯ maior';
$string['fsharpminor'] = 'Fá♯ menor';
$string['gbmajor'] = 'Sol♭ menor';
$string['givennoteelementgroup'] = 'Nota indicada';
$string['gnmajor'] = 'Sol maior';
$string['gnminor'] = 'Sol menor';
$string['grandstaff'] = 'Pauta Dupla';
$string['gsharpminor'] = 'Sol♯ menor';
$string['harmonicfunction_write_questionastext'] = 'Função Harmônica respondida';
$string['harmonicfunction_write_questionastext_help'] = '<p>Insira uma sequência de notas separadas por vírgula,
  sem espaços, usando a seguinte sintaxe:</p><p>[Nota com MAIÚSCULAS][Acidente
  ("n" = natural, "#" = sustenido, "b" = bemol, "x" = dobrado-sustenido, "bb" = dobrado-bemol)]4, ... </p>
 <p>Exemplo: <b>resposta=>Cn4,En4,G#4</b></p>';
$string['harmonicfunction_write_questionasui'] = 'Função Harmônica respondida';
$string['harmonicfunction_write_questionasui_help'] = '<P>Insira notas clicando na pauta após selecionar o tipo de acidente na barra de ferramentas. Para deletar uma nota, clique novamente nela.</p>';
$string['harmonicfunctiontype-random'] = 'Funções Harmônicas possíveis';
$string['hfidentifyresponsetypes'] = 'Funções harmônicas possíveis na resposta';
$string['hftype_aug6th'] = '6ª Aumentada';
$string['hftype_diatonictriad'] = 'Tríade diatônica';
$string['hftype_dom7th'] = 'Sétima da Dominante';
$string['hftype_extendeddom'] = 'Dominante estendida (9, 11 ou 13)';
$string['hftype_leadingtone7thfullydim'] = 'Sétima Diminuta';
$string['hftype_leadingtone7thhalfdim'] = 'Sétima Meio-diminuta';
$string['hftype_neapolitan'] = 'Napolitana';
$string['hftype_nondom7th'] = 'Acorde de sétima Sétima não-dominante';
$string['hftype_secdom7th'] = 'Dominante secundária (com sétima)';
$string['hftype_secdomtriad'] = 'Dominante secundária (tríade)';
$string['hftype_secltfullydim'] = 'Sétima diminuta secondária';
$string['hftype_seclthalfdim'] = 'Sétima meio-diminuta';
$string['hftype_seclttriad'] = 'Sensível secundária (tríade)';
$string['hftype_secnondom7th'] = 'Não-dominante secundária (sétima)';
$string['hftype_secnondomtriad'] = 'Tríade secundária sem função dominante';
$string['includealterations'] = 'Incluir alterações';
$string['includealterations_help'] = 'Indica se os acidentes devem ser incluídos como parte da questão.';
$string['includestaticnote'] = 'Incluir nota indicada';
$string['interval_write_questionastext'] = 'Intervalo respondido';
$string['interval_write_questionastext_help'] = '<p>Insira a nota da resposta, sem espaços, utilizando a seguinte sintaxe:</p><p>[Nota com MAÍSCULAS] [Acidente ("n" = natural, "#" = sustenido,
 "b" = bemol, "x" = dobrado-sustenido, "bb" = dobrado-bemol)] [Registro (um dígito entre 1 e 6, de acordo com a notação científica de alturas)]</p><p>Exemplos:
 </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['interval_write_questionasui'] = 'Intervalo respondido';
$string['interval_write_questionasui_help'] = '<b>Insira a nota clicando na pauta após selecionar o tipo de acidente na barra de ferramentas. Para apagar uma nota, clique nela novamente. </p>';
$string['javascriptrequired'] = 'Este texto deveria ser substituído por uma interface gráfica que requer que o Javascript esteja habilitado em seu browser.';
$string['keyboard_input_questionasui'] = 'Resposta submetida no teclado';
$string['keyboard_input_questionasui_help'] = '<p>Insira notas clicando no teclado. Para apagar uma nota, clique novamente nela.</p>';
$string['keymode'] = 'Tonalidade';
$string['keysignature_write_questionastext'] = 'Tonalidade respondida';
$string['keysignature_write_questionastext_help'] = '<p>Insira uma sequência de acidentes (entre 1 e 7 deles) separada por vírgulas, sem espaços, utilizando a seguinte sintaxe:</p><p>[Nota com MAIÚSCULAS]
 [Acidente ("#" = sustenido, "b" = bemol)] [Registro(um dígito entre 2 e 5, de acordo com a notação científica de alturas)], ... </p><p>Exemplo: <b>A#4,F#4,G#4</b></p>';
$string['keysignature_write_questionasui'] = 'Tonalidade respondida';
$string['keysignature_write_questionasui_help'] = '<p>Insira acidentes clicando na pauta após selecionar o tipo de acidente na barra de ferramentas. Para apagar um acidente, clique nele novamente.</p>';
$string['lbl_harmonicfunction'] = 'Função Harmônica';
$string['maj10'] = '10ª Maior';
$string['maj13'] = '13ª Maior';
$string['maj2'] = '2ª Maior';
$string['maj3'] = '3ª Maior';
$string['maj6'] = '6ª Maior';
$string['maj7'] = '7ª Maior';
$string['maj9'] = '9ª Maior';
$string['major'] = 'Maior';
$string['min10'] = '10ª Menor';
$string['min13'] = '13ª Menor';
$string['min2'] = '2ª Menor';
$string['min3'] = '3ª Menor';
$string['min6'] = '6ª Menor';
$string['min7'] = '7ª Menor';
$string['min9'] = '9ª Menor';
$string['minor'] = 'Menor';
$string['mode-random'] = 'Modos possíveis';
$string['musicqtype'] = 'Tipo de questão musical';
$string['musictheory_gradingstrategy'] = 'Estratégia de avaliação';
$string['musictheory_gradingstrategy_help'] = '<p>A estratégia de avaliação especifica como a questão será avaliada.</p>
<p><b>Tudo ou nada</b>: A resposta é comparada com a resposta correta. Se a resposta estiver correta, a nota inteira é atribuída. Se a resposta estiver correta, a nota será zero.</p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Estratégia de avaliação';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p>A estratégia de avaliação especifica como a questão será avaliada.</p>
<p><b>Tudo ou nada</b>: A resposta é comparada com a resposta correta. Se a resposta estiver correta, a nota inteira é atribuída. Se a resposta estiver correta, a nota será zero.</p>
<p><b>Crédito parcial para cada nota correta</b>:
Esta estratégia de avaliação divida a nota igualmente pelo número de notas que devem ser inseridas na escala, e atribui uma nota parcial para cada nota correta.</p>';
$string['musictheory_intervalelementgroup'] = 'Intervalo';
$string['musictheory_intervalelementgroup_help'] = 'Indica o tipo de intervalo.';
$string['musictheory_intervalelementgroup_random'] = 'Intervalos possíveis';
$string['nosectonic'] = '[Sem tônica secundária]';
$string['note_write_questionastext'] = 'Nota respondida';
$string['note_write_questionastext_help'] = '<p>Insira a nota da resposta, sem espaços, utilizando a seguinte sintaxe:</p><p>[Nota com MAIÚSCULAS] [Acidente("n" = natural, "#" = sustenido,
 "b" = bemol, "x" = dobrado-sustenido, "bb" = dobrado-bemol)] [Registro (um dígito entre 1 e 6, de acordo com a notação científica de alturas)]</p><p>Exemplos:
 </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['note_write_questionasui'] = 'Nota respondida';
$string['note_write_questionasui_help'] = '<b>Insira a nota clicando na pauta após selecionar o tipo de acidente na barra de ferramentas. Para apagar uma nota, clique nela novamente. </p>';
$string['notea'] = 'Lá';
$string['noteb'] = 'Si';
$string['notec'] = 'Dó';
$string['noted'] = 'Ré';
$string['notee'] = 'Mi';
$string['notef'] = 'Fá';
$string['noteg'] = 'Sol';
$string['notelbl'] = 'Nota';
$string['per11'] = '11ª Justa';
$string['per12'] = '12ª Justa';
$string['per4'] = '4ª Justa';
$string['per5'] = '5ª Justa';
$string['per8'] = 'Oitava Justa';
$string['perfect'] = 'Justa';
$string['pluginname'] = 'Teoria Musical';
$string['pluginname_help'] = 'Este tipo de questão possibilita a criação de exercícios de teoria musical utilizando uma interface gráfica.';
$string['pluginnameadding'] = 'Acrescentar questão de teoria musical';
$string['pluginnameediting'] = 'Editar questão de teoria musical';
$string['pluginnamesummary'] = 'Permite a criação de diversos tipos de exercícios de teoria musical.';
$string['possiblescalesinresponse'] = 'Tipos de escalas possíveis na resposta';
$string['privacy:metadata'] = 'O plugin de questionários de Teoria Musical não armazena nenhum data pessoal.';
$string['qtype_chordquality-identify'] = 'Identificação de tipo de acorde';
$string['qtype_chordquality-identify-random'] = 'Identificação de tipo de acorde (aleatório)';
$string['qtype_chordquality-write'] = 'Escrita de acorde';
$string['qtype_chordquality-write-random'] = 'Escrita de acorde (aleatório)';
$string['qtype_harmonicfunction-identify'] = 'Identificação de funções harmônicas';
$string['qtype_harmonicfunction-identify-random'] = 'Identificações de funções harmônicas (aleatório)';
$string['qtype_harmonicfunction-write'] = 'Escrita de função harmônica';
$string['qtype_harmonicfunction-write-random'] = 'Escrita de função harmônica (aleatória)';
$string['qtype_interval-identify'] = 'Identificação de intervalo';
$string['qtype_interval-identify-random'] = 'Identificação de intervalo (aleatório)';
$string['qtype_interval-write'] = 'Escrita de intervalo';
$string['qtype_interval-write-random'] = 'Escrita de intervalo (aleatório)';
$string['qtype_keyboard-input'] = 'Entrada com teclado';
$string['qtype_keysignature-identify'] = 'Identificação de armadura';
$string['qtype_keysignature-identify-random'] = 'Identificação de armadura (aleatório)';
$string['qtype_keysignature-write'] = 'Escrita de armadura';
$string['qtype_keysignature-write-random'] = 'Escrita de armadura (aleatório)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Tudo ou nada';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Tudo ou nada';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Tudo ou nada';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Tudo ou nada';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Tudo ou nada';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Tudo ou nada';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Crédito parcial para cada nota correta';
$string['qtype_note-identify'] = 'Identificação de nota';
$string['qtype_note-identify-random'] = 'Identificação de nota (aleatória)';
$string['qtype_note-write'] = 'Escrita de nota';
$string['qtype_note-write-random'] = 'Escrita de nota (aleatória)';
$string['qtype_scale-identify'] = 'Identificação de escala';
$string['qtype_scale-identify-random'] = 'Identificação de escala (aleatória)';
$string['qtype_scale-write'] = 'Escrita de escala';
$string['qtype_scale-write-random'] = 'Escrita de escala (aleatória)';
$string['quality-random'] = 'Tipos possíveis';
$string['qualityaug'] = 'Aumentado';
$string['qualitydim'] = 'Diminuto';
$string['qualitymaj'] = 'Maior';
$string['qualitymin'] = 'Menor';
$string['qualityper'] = 'Justa';
$string['questionoptions'] = 'Opções da questão';
$string['questiontext'] = 'Texto da questão';
$string['questiontext_chordquality_identify'] = 'Identifique a nota fundamental e o tipo do acorde';
$string['questiontext_chordquality_write'] = 'Insira o acorde';
$string['questiontext_harmonicfunction_identify'] = 'Identifique a função harmônica';
$string['questiontext_harmonicfunction_write'] = 'Insira a função harmõnica';
$string['questiontext_help'] = 'Este campo não é necessário. Se deixado em branco, o texto padrão do tipo de questão será exibido na atividade. Caso você insira um texto neste campo, este será exibido no lugar do texto padrão para o tipo de questão.';
$string['questiontext_interval_identify'] = 'Identifique o intervalo';
$string['questiontext_interval_write_above'] = 'Insira o intervalo especificado <b>acima</b> da nota indicada';
$string['questiontext_interval_write_below'] = 'Insira o intervalo especificado <b>abaixo</b> da nota indicada';
$string['questiontext_keyboard_input'] = 'Insira a seguinte nota no teclado';
$string['questiontext_keysignature_identify_major'] = 'Identifique a tonalidade maior representada pela armadura';
$string['questiontext_keysignature_identify_minor'] = 'Identifique a tonalidade menor representada pela armadura';
$string['questiontext_keysignature_write'] = 'Insira a seguinte armadura de clave';
$string['questiontext_note_identify'] = 'Identifique a nota';
$string['questiontext_note_write'] = 'Insira a nota';
$string['questiontext_scale_identify'] = 'Identifique a escala';
$string['questiontext_scale_write'] = 'Escreva a escala especificada em direção ascendente';
$string['questiontext_scale_write_melodic'] = 'Escreva a escala especificada em direção ascendente e descendente';
$string['rootposition'] = '[fundamental]';
$string['scale_write_questionastext'] = 'Escala respondida';
$string['scale_write_questionastext_help'] = '<p>Insira uma sequência de notas separadas por vírgula,
  sem espaços, usando a seguinte sintaxe:</p><p>
[Nota com MAIÚSCULAS]
 [Acidente ("n" = natural, "#" = sustenido, "b" = bemol, "x" = dobrado-sustenido, "bb" = dobrado-bemol)]
 [Registro (um dígito entre 2 e 6, de acordo com a notação científica de alturas)], ... </p>
 <p>Exemplo aleatório: <b>Tônica = An4 resposta=>An4,Bb4,C#5,D#5,E#5,F#5,G#5,An5</b></p>';
$string['scale_write_questionasui'] = 'Escala respondida';
$string['scale_write_questionasui_help'] = '<p>Insira notas clicando na pauta após selecionar o tipo de acidente na barra de ferramentas. Para deletar uma nota, clique nela novamente.</p>
<p>Lembre-se que acidentes afetam as notas seguintes. </p>';
$string['scaletype'] = 'Tipo de escala';
$string['scaletype-random'] = 'Tipos de escalas possíveis';
$string['scaletype_harmonic'] = 'Menor harmônica';
$string['scaletype_major'] = 'Maior';
$string['scaletype_melodic'] = 'Menor melódica';
$string['scaletype_natural'] = 'Menor natural';
$string['selectakey'] = 'Selecione uma tonalidade';
$string['selectanoption'] = 'Selecione';
$string['selectaquality'] = 'Selecione uma qualidade';
$string['selectasize'] = 'Selecione um tamanho';
$string['size-random'] = 'Tamanhos possíveis';
$string['size10'] = '10ª';
$string['size11'] = '11ª';
$string['size12'] = '12ª';
$string['size13'] = '13ª';
$string['size2'] = '2ª';
$string['size3'] = '3ª';
$string['size4'] = '4ª';
$string['size5'] = '5ª';
$string['size6'] = '6ª';
$string['size7'] = '7ª';
$string['size8'] = '8va';
$string['size9'] = '9ª';
$string['tenor'] = 'Tenor';
$string['tenorclef'] = 'Clave de Dó na 4ª linha';
$string['tonic'] = 'Tônica';
$string['treble'] = 'Soprano';
$string['trebleclef'] = 'Clave de sol';
$string['updatemusicqtype'] = 'Atualizar opções';
$string['validation_harmonicfunctionnotsupported'] = 'Essa função harmônica é inválida ou não suportada.';
$string['validation_harmonicfunctiontypenotselected'] = 'O tipo da função para a função harmônica especificada deve ser selecionado.';
$string['validation_interval_novalidcombo'] = 'Os tamanhos e tipos selecionados não produzem ao menos um intervalo válido.';
$string['validation_intervaloutsidestaff'] = 'O registro selecionado produz um intervalo que não pode ser inserido dentro da pauta da clave escolhida.';
$string['validation_invalidchordquality'] = 'Este tipo de acorde não pode ser construído na fundamental especificada.';
$string['validation_invalidinterval_above'] = 'Esse intervalo não pode ser escrito acima da nota especificada.';
$string['validation_invalidinterval_below'] = 'Esse intervalo não pode ser escrito abaixo da nota especificada.';
$string['validation_noteoutsidekeyboard'] = 'Esta nota está fora da extensão do teclado do piano.';
$string['validation_noteoutsidestaff'] = 'O registro da nota não pode ser escrito dentro da pauta da clave especificada.';
$string['validation_possiblescaletypenotselected'] = 'A qualidade da escala para o tipo de escala especificado deve ser selecionado.';
$string['validation_possiblescaletypesnotselected_random'] = 'Os tipos possíveis de escala na resposta devem incluir todos tipos possíveis de escala na questão.';
$string['validation_qualitymismatch'] = 'Esta combinação de tamanho e tipo de intervalo é inválida.';
$string['validation_samestaticandgivennote'] = 'A nota indicada e a resposta não podem ser a mesma nota do teclado.';
$string['validation_scale_invalidtonic'] = 'Tônica inválida para o tipo de escala especificado.';
$string['validation_scaleoutsidestaff'] = 'O registro da tônica especificado produz uma escala que não pode ser exibida na pauta da clave escolhida.';
$string['validationerror_chordquality_identify'] = 'Resposta incompleta. A nota, o acidente e o tipo do acorde devem ser selecionados.';
$string['validationerror_empty'] = 'Nenhuma resposta foi dada.';
$string['validationerror_harmonicfunction_identify'] = 'Resposta incompleta. Todos campos devem ser preenchidos.';
$string['validationerror_incompletechordquality'] = 'Resposta incompleta. Número de notas do acorde';
$string['validationerror_incompleteharmonicfunction'] = 'Resposta incompleta. Número de notas dafunção harmônica';
$string['validationerror_interval_identify'] = 'Resposta incompleta. A qualidade e o tamanho devem ser selecionados.';
$string['validationerror_invalidsyntax'] = 'Sintaxe de resposta inválida.';
$string['validationerror_note_identify'] = 'Resposta incompleta. A nota, o acidente e o registro devem ser selecionados.';
$string['validationerror_note_identify_ltr_acc'] = 'Resposta incompleta. A nota e o acidente devem ser selecionados.';
$string['validationerror_note_identify_ltr_reg'] = 'Resposta incompleta. A nota e o registro devem ser selecionados.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Duas notas foram inseridas. Insira somente uma.';
$string['validationerror_scale_identify'] = 'Resposta incompleta. Todos campos devem ser preenchidos.';
$string['validationerror_scale_incomplete'] = 'Resposta incompleta. Um total de 8 notas é necessário para resposta, incluindo a tônica.';
$string['validationerror_scale_incomplete_melodic'] = 'Resposta incompleta. Um total de 15 notas é necessário, incluindo a tônica especificada.';
$string['validationerror_whitespace'] = 'Sintaxe de resposta inválida; remova todos os espaços de sua resposta.';
