<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'cs', version '3.8'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akce';
$string['activityoverview'] = 'Máte jeden nebo více povinných dotazníků (klikněte zde pro zobrazení).';
$string['additionalinfo'] = 'Další informace';
$string['additionalinfo_help'] = 'Další informace slouží k podrobnější specifikaci dotazování nebo přidání jakýchkoli dalších informací, které jsou pak zobrazeny pod Podtitulem.';
$string['addnewquestion'] = 'Přidání otázky typu {$a}';
$string['addnewsection'] = 'Přidat novou sekci';
$string['addquestion'] = 'Přidat otázku ...';
$string['addquestions'] = 'Přidat otázky';
$string['addquestiontosection'] = 'Přidat otázku do sekce';
$string['addselqtype'] = 'Přidat vybraný typ otázky';
$string['alignment'] = 'Orientace tlačítek';
$string['alignment_help'] = 'Vyberte orientaci tlačítek: vodorovně (výchozí) nebo svisle';
$string['all'] = 'Vše';
$string['allnameddegrees'] = 'Pojmenované známky';
$string['allnameddegrees_help'] = 'Určete text, který se má zobrazit místo hodnot čísla. Když ji nepoužijete, nechte hodnotu prázdnou.';
$string['alreadyfilled'] = 'Tento dotazník jste již vyplnili. Děkujeme.';
$string['andaveragevalues'] = 'a průměrné hodnoty';
$string['anonymous'] = 'Anonymní';
$string['answer'] = 'Odpovědět';
$string['answerquestions'] = 'Odpovědět na otázky...';
$string['answers'] = 'Odpovědi';
$string['attempted'] = 'Dotazník byl odevzdán.';
$string['attemptstillinprogress'] = 'Zpracovává se. Uloženo na:';
$string['autonumbering'] = 'Automatické číslování';
$string['autonumbering_help'] = 'Umožňuje nastavit, zda mají být otázky či stránky automaticky číslovány. Použití automatického číslování by nemuselo být vhodné například u otázek s větvením.';
$string['autonumberno'] = 'Nečíslovat otázky ani stránky';
$string['autonumberpages'] = 'Automaticky číslovat stránky';
$string['autonumberpagesandquestions'] = 'Automaticky číslovat stránky i otázky';
$string['autonumberquestions'] = 'Automaticky číslovat otázky';
$string['average'] = 'Průměr';
$string['averageposition'] = 'Průměrné umístění';
$string['averagerank'] = 'Průměrný rozsah';
$string['averagesrow'] = 'Průměry (pokud existují):';
$string['bodytext'] = 'Textové pole';
$string['boxesnbexact'] = 'přesně {$a} polí.';
$string['boxesnbmax'] = 'maximálně z {$a} polí.';
$string['boxesnbmin'] = 'minimálně z {$a} polí.';
$string['boxesnbreq'] = 'Tuto otázku si musíte zaškrtnout';
$string['by'] = 'od';
$string['cannotviewpublicresponses'] = 'Ve veřejném dotazování nelze zobrazit odpovědi.';
$string['chart:bipolar'] = 'Bipolární sloupce';
$string['chart:hbar'] = 'Horizontální sloupce';
$string['chart:radar'] = 'Paprskový graf';
$string['chart:rose'] = 'Růžicový graf';
$string['chart:type'] = 'Typ grafu';
$string['chart:type_help'] = 'Vyberte typ grafu, který chcete použít';
$string['chart:vprogress'] = 'Ukazatel průběhu';
$string['checkallradiobuttons'] = 'Všechny přepínače musí být zodpovězeny. Zkontrolujte prosím <strong>{$a}</strong> přepínače.';
$string['checkboxes'] = 'Zaškrtávací pole';
$string['checkboxes_help'] = 'Vepište pod sebe možnosti pro účastníka, který bude následně vybírat jednu nebo více z těchto nabízených možností.';
$string['checkbreaksadded'] = 'Nová stránka byla přidána na pozici:';
$string['checkbreaksok'] = 'Všechny požadované Nové stránky již existují!';
$string['checkbreaksremoved'] = 'Odstraněno {$a} přebývajících Nových stránek';
$string['checknotstarted'] = 'Vybrat nezahájené';
$string['checkstarted'] = 'Vybrat zahájené';
$string['clicktoswitch'] = '(klikněte pro přepnutí)';
$string['closed'] = 'Dotazování bylo ukončeno {$a}. Děkuji.';
$string['closedate'] = 'Dostupné do';
$string['closeson'] = 'Dotazování bude uzavřeno: {$a}';
$string['completionsubmit'] = 'Pro splnění musí student tento dotazník odevzdat';
$string['condition'] = 'Podmínka';
$string['confalts'] = '- nebo - <br />Stránka potvrzení';
$string['configemailreporting'] = 'Povolit sestavy e-mailem';
$string['configemailreportinglong'] = 'Umožňuje volby pro některé sestavy, které mají být zaslány e-mailem přímo na zadané e-mailové adresy.';
$string['configmaxsections'] = 'Maximum sekcí dotazníku';
$string['configusergraph'] = 'Zobrazit grafy pro Dotazník "Test osobnosti"';
$string['configusergraphlong'] = 'Pro zobrazení grafu dotazníku "Test osobnosti" použijte knihovnu <a href="http://www.rgraph.net/">Rgraph</a> .';
$string['confirmdelallresp'] = 'Jste si jisti, že chcete smazat VŠECHNY odpovědi v tomto dotazníku?';
$string['confirmdelchildren'] = 'Odstraníte-li tuto otázku, budou odstraněny i její dceřiné otázky:';
$string['confirmdeletesection'] = 'Opravdu chcete smazat sekci zpětné vazby „{$a}“?';
$string['confirmdelgroupresp'] = 'Jste si jisti, že chcete odstranit VŠECHNY odpovědi {$a}?';
$string['confirmdelquestion'] = 'Jste si jisti, že chcete odstranit otázku na pozici {$a}?';
$string['confirmdelquestionresps'] = 'Tímto odstraníte také {$a} odpovědí na tuto otázku, které již byly odeslány.';
$string['confirmdelresp'] = 'Jste si jisti, že chcete smazat odpovědi &nbsp;{$a}&nbsp;?';
$string['confirmremovequestion'] = 'Opravdu chcete odebrat otázku „{$a->qname}“ z části „{$a->sname}“?';
$string['confpage'] = 'Text hlavičky';
$string['confpage_help'] = 'Hlavička (tučně) a tělo text pro  Stránku " potvrzení "  se zobrazí po vyplnění dotazníku uživatelem. (URL, pokud je uvedeno, má přednost před textem.)

Pokud toto pole necháte prázdné, bude zobrazena výchozí zpráva po vyplnění Dotazování (Děkujeme za vyplnění).';
$string['confpagedesc'] = 'Hlavička (tučně) a tělo text pro  Stránku " potvrzení "  se zobrazí po vyplnění dotazníku uživatelem. (URL, pokud je uvedeno, má přednost před textem.)';
$string['contentoptions'] = 'Volby obsahu';
$string['couldnotcreatenewsurvey'] = 'Nelze vytvořit nový průzkum!';
$string['couldnotdelresp'] = 'Odpověď nelze zrušit';
$string['createcontent'] = 'Definování nového obsahu';
$string['createcontent_help'] = 'Vyberte jeden z přepínačů. Výchozím je "Vytvořit nový".';
$string['createnew'] = 'Vytvořit nový';
$string['crontask'] = 'Vyčištění dotazníku';
$string['date'] = 'Datum';
$string['date_help'] = 'Použijte tento typ otázky požadujete-li odpověď ve formě data.';
$string['dateformatting'] = 'Použijte formát den/měsíc/rok, např. pro 14. 3. 1945:&nbsp; <strong>14/3/1945</strong>';
$string['deleteallresponses'] = 'Zrušit všechny odpovědi';
$string['deletecurrentquestion'] = 'Zrušit otázku {$a}';
$string['deletedallgroupresp'] = 'Zrušeny všechny odpovědi ve skupině {$a}';
$string['deletedallresp'] = 'Odpovědi dotazníku odstraněny';
$string['deletedisabled'] = 'Tuto položku není možné odstranit';
$string['deletedresp'] = 'Zrušená odpověď';
$string['deleteresp'] = 'Zrušit tuto odpověď';
$string['deletesection'] = 'Odstranit tuto sekci';
$string['deletingresp'] = 'Rušení odpovědi';
$string['dependencies'] = 'Závislosti';
$string['dependquestion'] = 'Mateřská otázka';
$string['dependquestion_help'] = 'Můžete zvolit mateřskou otázku a k ní možnou odpověď, po jejímž zvolení bude otevřena dceřiná otázka.';
$string['didnotrespondtoquestion'] = 'Neodpověděl na otázku';
$string['directwarnings'] = 'Přímé závislosti na této otázce budou odstraněny. To ovlivní:';
$string['displaymethod'] = 'Pro otázku není definován způsob zobrazení.';
$string['download'] = 'Stáhnout';
$string['downloadpdf'] = 'Stáhnout PDF';
$string['downloadtextformat'] = 'Stáhnout';
$string['downloadtextformat_help'] = 'Tato funkce umožňuje uložit všechny odpovědi z dotazníku do vybraného, podporovaného formátu souboru.
Můžete se rozhodnout zahrnout do exportu další datové položky a také automaticky odeslat soubor vybraným uživatelům.';
$string['downloadtypes'] = 'Typ sestavy';
$string['dropdown'] = 'Rozbalovací nabídka';
$string['dropdown_help'] = 'Otázku typu Rozbalovací nabídka může být vhodnější použít namísto otázky typu Přepínač tehdy, je-li seznam možných odpovědí dlouhý. Pomocí Rozbalovací nabídky je takto možné ušetřit místo na stránce.';
$string['edit'] = 'Upravit';
$string['editingfeedback'] = 'Úpravy nastavení zpětné vazby';
$string['editingquestionnaire'] = 'Upravit nastavení Dotazování';
$string['editquestion'] = 'Upravení {$a} otázky';
$string['email'] = 'Email';
$string['emailextra'] = 'Odeslat stahování do e-mailů';
$string['emailextra_help'] = 'Zašle soubor ke stažení na uvedené e-mailové adresy oddělené čárkami. Uvědomte si, že NENÍ provedena kontrola zabezpečení ani ochrany osobních údajů.  Aby bylo možné k tomuto přístupu přistupovat, musí být v nastavení modulu povoleno „allowemailreporting“.';
$string['emailroles'] = 'Odeslat stahování do rolí';
$string['emailroles_help'] = 'Zašle soubor ke stažení do všech rolí s oprávněním "mod/questionnaire:submissionnotification“ prostřednictvím e-mailu.  Aby bylo možné k tomuto přístupu přistupovat, musí být v nastavení modulu povoleno „allowemailreporting“.';
$string['emailsend'] = 'Odeslat sestavu';
$string['emailsnotspecified'] = 'Nebyly zadány žádné e-maily.';
$string['emailssent'] = 'Stažení odeslané na zadané e-maily.';
$string['errnewname'] = 'Je nám líto, název je již používán. Vyberte nový název.';
$string['erroropening'] = 'Chyba při otevírání dotazníku.';
$string['errortable'] = 'Systémová chyba - poškozená tabulka .';
$string['essaybox'] = 'Dlouhé textové pole';
$string['essaybox_help'] = 'Typ otázky Dlouhé textové pole nabízí pro vepsání odpovědi textové pole, jehož velikost může učitel nastavit podle svých potřeb nebo jej zanechat ve standardní velikosti. K nastavení velikosti textového pole slouží možnosti "Počet sloupců textového pole" a "Počet řádků textového pole".';
$string['event_all_responses_deleted'] = 'Všechny odpovědi odstraněny';
$string['event_all_responses_saved_as_text'] = 'Všechny odpovědi uloženy jako text';
$string['event_all_responses_viewed'] = 'Zobrazen seznam všech odpovědí';
$string['event_individual_responses_viewed'] = 'Zobrazen seznam jednotlivých odpovědí';
$string['event_non_respondents_viewed'] = 'Zobrazení účastníků, kteří neodpověděli';
$string['event_previewed'] = 'Dotazník zobrazen';
$string['event_question_created'] = 'Otázka vytvořena';
$string['event_question_deleted'] = 'Otázka odstraněna';
$string['event_response_deleted'] = 'Odstraněna jedna odpověď';
$string['event_resumed'] = 'Pokus obnoven';
$string['event_saved'] = 'Odpovědi uloženy';
$string['event_submitted'] = 'Odpovědi odeslány';
$string['feedback'] = 'Komentář';
$string['feedback_help'] = 'Nápověda zpětné vazby';
$string['feedbackaddmorefeedbacks'] = 'Přidat {no} pole se zpětnou vazbou.';
$string['feedbackbysection'] = 'Sekce komentáře';
$string['feedbackdefaultlabel'] = '[Nová sekce]';
$string['feedbackeditingglobal'] = 'Upravit celkovou zpětnou vazbu Dotazování';
$string['feedbackeditingmessages'] = 'Upravit sdělení zpětné vazby Dotazování';
$string['feedbackeditingsections'] = 'Upravit jednotlivé části zpětné vazby v Dotazování';
$string['feedbackeditmessages'] = 'Uložit nastavení částí a upravit sdělení zpětné vazby';
$string['feedbackeditsections'] = 'Uložit nastavení a upravit jednotlivé části zpětné vazby';
$string['feedbackerrorboundaryformat'] = 'Hranice skóre této zpětné vazby musí být buď procentní nebo číselná. Hodnota zadaná v hranici {$a} není rozpoznána.';
$string['feedbackerrorboundaryoutofrange'] = 'Hranice skóre zpětné vazby musí být mezi 0% a 100%. Hodnota zadaná v hranici {$a} je mimo rozsah.';
$string['feedbackerrorjunkinboundary'] = 'Musíte vyplnit rozbalovací pole ve zpětné vazbě beze mezery.';
$string['feedbackerrorjunkinfeedback'] = 'Musíte vyplnit pole ve zpětné vazbě beze mezery.';
$string['feedbackerrororder'] = 'Hranice skóre zpětné vazby musí být v pořadí, nejvyšší jako první. Hodnota zadaná v hranici {$a} je mimo posloupnost.';
$string['feedbackglobal'] = 'Celková zpětná vazba';
$string['feedbackglobalheading'] = 'Záhlaví celkové zpětné vazby';
$string['feedbackglobalmessages'] = 'Sdělení celkové zpětné vazby';
$string['feedbackhdr'] = 'Zpětné vazby';
$string['feedbackheading'] = 'Záhlaví zpětné vazby';
$string['feedbackheading_help'] = 'V poli Nadpis můžete použít dvě proměnné: $scorepercent a $oppositescorepercent.';
$string['feedbackmessages'] = 'Sdělení zpětné vazby pro část {$a}';
$string['feedbacknextsection'] = 'Další část {$a}';
$string['feedbacknone'] = 'Žádná zpětná vazba';
$string['feedbacknotes'] = 'Poznámky ke zpětné vazbě';
$string['feedbacknotes_help'] = 'Tento text se zobrazí respondentům na konci jejich zpětné vazby';
$string['feedbackoptions'] = 'Volby zpětné vazby';
$string['feedbackoptions_help'] = 'Volby zpětné vazby jsou dostupné pouze tehdy, obsahuje-li Dotazování následující typ otázek: Ano/Ne, Přepínač, Rozbalovací nabídka nebo Měřítko. Tyto otázky musí být nastaveny jako povinné, jejich pole Název otázky nesmí být prázdné a pole Možné odpovědi musí obsahovat číselnou hodnotu.';
$string['feedbackremovequestionfromsection'] = 'Tato otázka je součástí [{$a}]. části zpětné vazby';
$string['feedbackremovesection'] = 'Odstraněním této otázky dojde také k odstranění celé [{$a}]. části zpětné vazby';
$string['feedbackreport'] = 'Zpráva se zpětnou vazbou';
$string['feedbackscore'] = 'Skóre zpětné vazby';
$string['feedbackscoreboundary'] = 'Hranice skóre této zpětné vazby';
$string['feedbackscores'] = 'Zobrazit skóre';
$string['feedbackscores_help'] = 'Zobrazit tabulku skóre zpětné vazby';
$string['feedbacksection'] = 'Část';
$string['feedbacksectionheading'] = 'Záhlaví zpětné vazby pro část {$a}';
$string['feedbacksectionheadingmissing'] = 'Musíte vyplnit pole Nadpis pro tuto část zpětné vazby!';
$string['feedbacksectionheadingtext'] = 'Nadpis';
$string['feedbacksectionlabel'] = 'Štítek';
$string['feedbacksectionlabel_help'] = 'Tento text bude použit v grafickém znázornění. Napište ho, prosím, co nejkratší!';
$string['feedbacksectionquestions'] = '{$a} otázky sekce';
$string['feedbacksections'] = '{$a} části/í zpětné vazby';
$string['feedbacksectionsselect'] = 'Části';
$string['feedbacksectionsselect_help'] = 'Rozdělte následující otázky do jednotlivých částí';
$string['feedbacksettingssaved'] = 'Nastavení zpětné vazby uloženo';
$string['feedbacktype'] = 'Typ zpětné vazby';
$string['field'] = 'Otázka {$a}';
$string['fieldlength'] = 'Délka vstupního pole';
$string['fieldlength_help'] = 'Otázka typu Textové pole nabízí pro odpověď krátké textové pole, které může mít délku maximálně jednoho řádku. K nastavení délky pole a maximální délky textu slouží možnosti "Délka vstupního pole" (v původním nastavení má hodnotu 20) a "Max. délka textu" (v původním nastavení má hodnotu 25).';
$string['finished'] = 'Zodpověděli jste všechny otázky v tomto dotazníku.';
$string['firstrespondent'] = 'První respondent';
$string['formateditor'] = 'HTML editor';
$string['formatplain'] = 'Prostý text';
$string['grade'] = 'Hodnocení odpovědi';
$string['gradesdeleted'] = 'Hodnocení dotazování byla odstraněna';
$string['headingtext'] = 'Záhlaví textu';
$string['horizontal'] = 'Vodorovně';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Zahrnout kódy výběry';
$string['includechoicetext'] = 'Zahrnout text výběry';
$string['includeincomplete'] = 'Zahrnout neúplné odpovědi';
$string['includerankaverages'] = 'Zahrnout průměrné hodnoty otázky';
$string['incorrectcourseid'] = 'Nesprávné ID kurzu';
$string['incorrectmodule'] = 'Nesprávné ID modulu kurzu';
$string['incorrectquestionnaire'] = 'Nesprávné Dotazování';
$string['indirectwarnings'] = 'Tento seznam zobrazuje nepřímo závislé otázky a zbývající závislosti pro přímé závislé otázky:';
$string['invalidresponse'] = 'Uvadena neplatná odpověď.';
$string['invalidresponserecord'] = 'Uveden neplatný záznam odpovědi.';
$string['invalidsectionid'] = 'Byla zadána neplatná část zpětné vazby.';
$string['invalidsurveyid'] = 'Chybné ID Dotazování';
$string['kindofratescale'] = 'Typ stupnice měřítka';
$string['kindofratescale_help'] = 'Klepněte pravým tlačítkem myši na odkaz Další pomoc níže.';
$string['lastrespondent'] = 'Poslední respondent';
$string['length'] = 'Délka';
$string['managequestions'] = 'Spravovat otázky';
$string['managequestions_help'] = 'V sekci Spravovat otázky v nastavení dotazování je možno manipulovat s otázkami či upravovat jejich nastavení.';
$string['mandatory'] = 'Povinné - Všechny tyto závislosti musí být splněny.';
$string['maxdigitsallowed'] = 'Max. počet cifer';
$string['maxdigitsallowed_help'] = 'Pro nastavení limitu  počtu znaků vložených pro číselnou otázku použijte ** Max. počet cifer **. Všimněte si, že desetinná tečka se také počítá jako jeden znak!';
$string['maxforcedresponses'] = 'Max. vyžadované odpovědi';
$string['maxtextlength'] = 'Max. délka textu';
$string['messageprovider:message'] = 'Připomenutí dotazníku';
$string['messageprovider:notification'] = 'Odpověď dotazníku';
$string['minforcedresponses'] = 'Min. vyžadované odpovědi';
$string['misconfigured'] = 'Chybně nastavený kurz';
$string['missingname'] = 'Odpověď na otázku {$a} nemůže být zahrnuta do zpětné vazby, jelikož jste nevyplnili pole Název otázky.';
$string['missingnameandrequired'] = 'Odpověď na otázku {$a} nemůže být zahrnuta do zpětné vazby, jelikož jste nevyplnili pole Název otázky a odpověď není povinná.';
$string['missingquestion'] = 'Chyba, zodpovězte otázku';
$string['missingquestions'] = 'Chyba, zodpovězte otázky:';
$string['missingrequired'] = 'Odpověď na otázku {$a} nemůže být zahrnuta do zpětné vazby, jelikož odpověď není povinná.';
$string['modulename'] = 'Dotazování';
$string['modulename_help'] = 'Modul Dotazování poskytuje řadu standardních dotazníkových nástrojů, které mohou být velmi přínosné pro získání zpětné vazby na kurz a zjištění potřeb studentů. Velmi dobře mohou také sloužit ke stimulaci výuky v on-line prostředí. Učitel má možnost vytvořit širokou škálu otázek a díky odpovědím uživatelů tak zjistit, jak je kurz hodnocen. Cílem Dotazování není studenta nějakým způsobem testovat či hodnotit, slouží ke sběru dat, které mohou být uplatněny ke zlepšení chodu kurzu.';
$string['modulenameplural'] = 'Dotazování';
$string['movedisabled'] = 'Tuto položku nelze přesunout';
$string['myresponses'] = 'Všechny vaše odpovědi';
$string['myresponsetitle'] = 'Vaše {$a} odpověd(i)';
$string['myresults'] = 'Vaše odpovědi';
$string['name'] = 'Jméno';
$string['navigate'] = 'Povolit větvení otázek';
$string['navigate_help'] = 'Umožní k otázkám typu Ano/Ne a Přepínač přiřazovat dceřiné otázky v závislosti na zvolené odpovědi na mateřskou otázku.';
$string['navigatetosection'] = 'Přejít do sekce zpětné vazby';
$string['next'] = 'Další';
$string['nextpage'] = 'Další stránka';
$string['nlines'] = '{$a} řádků';
$string['noanswer'] = 'Žádná odpověď';
$string['noattempts'] = 'Žádné pokusy v tomto dotazníku';
$string['nodata'] = 'Neodeslána žádná data.';
$string['noduplicates'] = 'Bez duplicitních voleb';
$string['noduplicateschoiceserror'] = 'Musíte vložit alespoň 2 možné odpovědi.';
$string['non_respondents'] = 'Uživatelé, kteří dosud neodeslali své odpovědi na toto dotazování';
$string['noneinuse'] = 'Dotazník neobsahuje žádné otázky.';
$string['nopublicsurveys'] = 'Žádný veřejný dotazník.';
$string['noresponsedata'] = 'Pro tuto otázku nejsou žádné odpovědi';
$string['noresponses'] = 'Žádné odpovědi';
$string['normal'] = 'Normální';
$string['not_started'] = 'není zahájeno';
$string['notanumber'] = '<strong>{$a}</strong> je nepovolená číselný formát.';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'sloupec N/A';
$string['notavail'] = 'Dotazování není doposud dostupné. Zkuste později.';
$string['noteligible'] = 'Nemáte oprávnění užívat tento dotazník.';
$string['notemplatesurveys'] = 'Žádná šablona';
$string['notenoughscaleitems'] = 'Musíte zadat minimální hodnotu 2 položek stupnice!';
$string['notificationfull'] = 'Úplná odpověď';
$string['notifications'] = 'Odeslání oznámení o odpovědi';
$string['notifications_help'] = 'Upozornit role s oprávněním „mod/questionnaire:submissionnotification“, že je odeslán dotazník.';
$string['notificationsimple'] = 'Pouze oznámení';
$string['notopen'] = 'Dotazování nebude otevřeno do {$a}.';
$string['notrequired'] = 'Odpověď není vyžadována';
$string['notset'] = 'Nenastaveno';
$string['nousersselected'] = 'Není vybrán uživatel';
$string['num'] = '#';
$string['numattemptsmade'] = 'Počet pokusů v tomto dotazníku: {$a}';
$string['numberfloat'] = 'Vaše zadané číslo  <strong>{$a->number}</strong> bylo zaokrouhleno na <strong>{$a->precision}</strong> desetinných míst.';
$string['numberofdecimaldigits'] = 'Počet desetinných míst';
$string['numberofdecimaldigits_help'] = 'Pomocí ** Nb desítkových číslic ** určete formát průměrné hodnoty, která se má spočítat a zobrazit na stránce Sestava dotazníku.';
$string['numberscaleitems'] = 'Počet položek stupnice';
$string['numberscaleitems_help'] = 'Počet položek ve škále  je *počet položek*, které mají být ve škále použity. Normálně byste použili hodnotu 3 až 5. Výchozí hodnota: **5**.';
$string['numeric'] = 'Číselná odpověď';
$string['numeric_help'] = 'Tento typ otázky použijte v případě, že vyžadujete přesnou číselnou odpověď.';
$string['of'] = 'z';
$string['opendate'] = 'Použijte datum otevření';
$string['option'] = 'volba  {$a}';
$string['optional'] = 'Volitelné - Musí být splněna alespoň jedna z těchto závislostí.';
$string['optionalname'] = 'Název otázky';
$string['optionalname_help'] = 'Název otázky se používá pouze v případě převodu odpovědí do formátu CSV/Excel. Pokud tento převod nebudete provádět, můžete pole ponechat zcela prázdné. Pokud však plánujete pravidelně převádět data z Dotazování do formátu CSV/Excel, máte na výběr dvě možnosti pojmenování otázky.';
$string['or'] = '- nebo -';
$string['order_ascending'] = 'Vzestupné řazení';
$string['order_default'] = 'Zobrazit výchozí řazení';
$string['order_descending'] = 'Sestupné řazení';
$string['orderresponses'] = 'Řadit odpovědi';
$string['osgood'] = 'Osgood (Sémantický diferenciál)';
$string['other'] = 'Jiné:';
$string['otherempty'] = 'Když vyberete tuto volbu musíte vložit do textového pole nějaký text!';
$string['overviewnumresplog'] = 'odpovědi';
$string['overviewnumresplog1'] = 'odpověď';
$string['overviewnumrespvw'] = 'odpovědi';
$string['overviewnumrespvw1'] = 'odpověď';
$string['owner'] = 'Vlastník';
$string['page'] = 'Strana';
$string['pageof'] = 'Strana {$a->page} z {$a->totpages}';
$string['parent'] = 'Rodič';
$string['participant'] = 'Účastník';
$string['pleasecomplete'] = 'Vyplňte, prosím, tuto volbu.';
$string['pluginadministration'] = 'Správa Dotazování';
$string['pluginname'] = 'Dotazování';
$string['position'] = 'pozice';
$string['possibleanswers'] = 'Možné odpovědi';
$string['posteddata'] = 'Stránka s odeslanými údaji:';
$string['preview_label'] = 'Náhled';
$string['preview_questionnaire'] = 'Náhled Dotazování';
$string['previewing'] = 'Náhled Dotazování';
$string['previous'] = 'Předchozí';
$string['previouspage'] = 'Předchozí stránka';
$string['print'] = 'Tisk této odpovědi';
$string['printblank'] = 'Vytisknout nevyplněné';
$string['printblanktooltip'] = 'Otevřít okno pro tisk s prázdným dotazníkem';
$string['printtooltip'] = 'Otevřít okno pro tisk s aktuálním dotazníkem';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Odpověď na otázku s možností výběru z více možností.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'ID záznamu volby pro tuto odpověď.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'ID záznamu otázky pro tuto odpověď.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'ID záznamu odpovědi pro tuto odpověď.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Odpověď na jednu otázku.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'ID záznamu volby pro tuto odpověď.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'ID záznamu otázky pro tuto odpověď.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'ID záznamu odpovědi pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response'] = 'Odpověď probíhá nebo byla odeslána';
$string['privacy:metadata:questionnaire_response:complete'] = 'Stav dokončení odpovědi.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Známka pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'ID záznamu z dotazníku pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Časové razítko pro poslední uložení této odpovědi.';
$string['privacy:metadata:questionnaire_response:userid'] = 'ID uživatele pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Boolean (ano / ne) odpověď na otázku.';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Konkrétní logická odpověď.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'ID záznamu otázky pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'ID záznamu odpovědi pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_date'] = 'Odpověď otázky na datum.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'ID záznamu otázky pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Odpověď konkrétní datum.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'ID záznamu odpovědi pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_other'] = 'Textová odpověď na volbu „jiná“.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'ID záznamu volby pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'ID záznamu otázky pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Odpověď na konkrétní text.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'ID záznamu odpovědi pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Hodnota odpovědi na otázku.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'ID záznamu volby pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'ID záznamu otázky pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Odpověď na konkrétní pořadí.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'ID záznamu odpovědi pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_text'] = 'Odpověď na textovou otázku.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'ID záznamu otázky pro tuto odpověď.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Odpověď na konkrétní text.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'ID záznamu odpovědi pro tuto odpověď.';
$string['private'] = 'Soukromý';
$string['public'] = 'Veřejný';
$string['publiccopy'] = 'Kopie:';
$string['publicoriginal'] = 'Originál:';
$string['qtype'] = 'Typ';
$string['qtype_help'] = 'Vyberte, zda bude uživatelům povoleno odpovědět na dotazování vícekrát, jednou, denně, týdně nebo měsíčně.';
$string['qtypedaily'] = 'Odpovídat denně';
$string['qtypemonthly'] = 'Odpovídat měsíčně';
$string['qtypeonce'] = 'Odpovědět jednou';
$string['qtypeunlimited'] = 'Odpovídat vícekrát';
$string['qtypeweekly'] = 'Odpovídat týdně';
$string['questionnaire:addinstance'] = 'Přidat nový dotazník';
$string['questionnaire:copysurveys'] = 'Kopírovat šablonu a soukromé dotazníky';
$string['questionnaire:createpublic'] = 'Vytvořit veřejné dotazníky';
$string['questionnaire:createtemplates'] = 'Vytvořit šablonu dotazníků';
$string['questionnaire:deleteresponses'] = 'Odstranit odpověď';
$string['questionnaire:downloadresponses'] = 'Stáhnout odpovědi v CSV souboru';
$string['questionnaire:editquestions'] = 'Vytvořit a upravit otázky dotazníku';
$string['questionnaire:manage'] = 'Vytvořit a upravit dotazníky';
$string['questionnaire:message'] = 'Poslat učástrníkům, kteří neodpověděli zprávu';
$string['questionnaire:preview'] = 'Zobrazit náhled dotazníků';
$string['questionnaire:printblank'] = 'Tisk prázdného dotazníku';
$string['questionnaire:readallresponseanytime'] = 'Vidět kdykoli všechny odpovědi';
$string['questionnaire:readallresponses'] = 'Vidět kdykoli souhrny odpovědí';
$string['questionnaire:readownresponses'] = 'Číst vlastní odpovědi';
$string['questionnaire:submissionnotification'] = 'Dostávat oznámení pro každé odeslání dotazníku';
$string['questionnaire:submit'] = 'Ukončit a odeslat dotazník';
$string['questionnaire:view'] = 'Zobrazit dotazník';
$string['questionnaire:viewsingleresponse'] = 'Zobrazit úplně jednotlivé odpovědi';
$string['questionnaireadministration'] = 'Správa Dotazování';
$string['questionnairecloses'] = 'Zavřené dotazníky';
$string['questionnaireopens'] = 'Otevřené dotazníky';
$string['questionnairereport'] = 'Sestava Dotazování';
$string['questionnum'] = 'Otázka #';
$string['questions'] = 'Otázky';
$string['questionsinsection'] = 'Otázky v této sekci:';
$string['questiontypes'] = 'Typy otázek';
$string['questiontypes_help'] = 'Prohlédněte si dokumentaci Moodlu níže';
$string['radiobuttons'] = 'Přepínač';
$string['radiobuttons_help'] = 'V tomto typu dotazu musí respondent vybrat jednu z nabízených možností.';
$string['rank'] = 'Rozsah';
$string['ratescale'] = 'Měřítko (stupnice 1 .. 5)';
$string['ratescale_help'] = 'Prohlédněte si dokumentaci Moodlu níže';
$string['realm'] = 'Typ dotazníku';
$string['realm_help'] = 'K dispozici jsou tři typy dotazování:
 * Soukromý - určený pouze pro potřeby daného kurzu.
 * Šablona - může být zkopírován a editován v jiném kurzu.
 * Veřejný - může být používán v jiných kurzech v původní podobě, bez možnosti editace.';
$string['redirecturl'] = 'URL, na které je uživatel přesměrován po vyplnění tohoto dotazníku.';
$string['remove'] = 'Zrušit';
$string['removeallquestionnaireattempts'] = 'Odstranit všechny odpovědi v dotazníku';
$string['removenotinuse'] = 'Tento dotazník závisel na veřejném dotazníku, který byl smazán. Nelze ji používat a měl by být smazán.';
$string['required'] = 'Odpověď je vyžadována';
$string['required_help'] = 'Při zaškrtnutí možnosti **Ano** bude mít student povinnost na tuto otázku odpovědět, jinak nebude možné dotazování ukončit.';
$string['requiredparameter'] = 'Chybí povinný parametr.';
$string['reset'] = 'Reset';
$string['respeligiblerepl'] = '(nahrazeno přepsáním role)';
$string['respondent'] = 'Účastník';
$string['respondenteligibleall'] = 'vše';
$string['respondenteligiblestudents'] = 'jen studenti';
$string['respondenteligibleteachers'] = 'jen učitelé';
$string['respondents'] = 'Účastníci';
$string['respondenttype'] = 'Zobrazení jména účastníka';
$string['respondenttype_help'] = 'Umožňuje nastavit, zda se u odpovědí na dotazování bude zobrazovat respondentovo plné jméno, nebo zda budou jeho odpovědi anonymní.';
$string['respondenttypeanonymous'] = 'Anonym';
$string['respondenttypefullname'] = 'Plné jméno';
$string['response'] = 'Odpověď';
$string['responsefieldlines'] = 'Počet řádků textového pole';
$string['responseformat'] = 'Formát odpovědi';
$string['responseoptions'] = 'Možnosti odpovědi';
$string['responses'] = 'Odpovědi';
$string['responseview'] = 'Studenti mohou vidět VŠECHNY odpovědi';
$string['responseview_help'] = 'Zde je možno specifikovat, kdy budou studenti moci zobrazit odpovědi ostatních.';
$string['responseviewstudentsalways'] = 'Vždy';
$string['responseviewstudentsnever'] = 'Nikdy';
$string['responseviewstudentswhenanswered'] = 'Po odpovězení dotazníku';
$string['responseviewstudentswhenclosed'] = 'Po dotazníku je uzavřen';
$string['restrictedtoteacher'] = 'Tyto funkce jsou povoleny pouze pro učitele!';
$string['resume'] = 'Uložit odpovědi a pokračovat';
$string['resume_help'] = 'Nastavení této možnosti umožňuje uživatelům uložit odpovědi do dotazníku před odesláním.  Uživatelé mohou ponechat dotazník nedokončený a pokračovat od místa uložení později.';
$string['resumesurvey'] = 'Pokračovat v dotazníku';
$string['return'] = 'Zpět';
$string['save'] = 'Uložit';
$string['saveasnew'] = 'Uložit jako Novou otázku';
$string['savedbutnotsubmitted'] = 'Tento dotazník byl uložen, ale dosud nebyl odeslán.';
$string['savedprogress'] = 'Vaše odpovědi byly uloženy. K tomuto Dotazování se můžete kdykoli vrátit a dokončit jej.';
$string['saveeditedquestion'] = 'Uložit otázku {$a}';
$string['savesettings'] = 'Uložit nastavení';
$string['search:activity'] = 'Dotazování - informace o činnosti';
$string['search:question'] = 'Dotazování - otázky';
$string['section'] = 'Popis';
$string['sectionbreak'] = '----- Nová stránka -----';
$string['sectionbreak_help'] = '----- Nová stránka -----';
$string['sectionsnotset'] = 'Musíte na jednu sekci vybrat alespoň jednu otázku! <br /> Nevybrané sekce: {$ a}';
$string['sectiontext'] = 'Informace';
$string['sectiontext_help'] = 'Nejedná se přímo o otázku, ale o informativní text, který je možné použít ke konkretizaci určité otázky či série otázek.';
$string['selecttheme'] = 'Vyberte téma (css), které chcete použít s tímto dotazníkem.';
$string['send'] = 'Odeslat';
$string['send_message'] = 'Poslat zprávu vybraným uživatelům';
$string['send_message_to'] = 'Poslat zprávu:';
$string['sendemail'] = 'Odeslat mail';
$string['sendemail_help'] = 'Umožňuje odeslat potvrzení o vyplnění každého dotazníku na zadanou e-mailovou adresu. Potvrzovací e-mail je možno zaslat i na více adres, tyto adresy od sebe pak oddělujte čárkou.

Nepřejete-li si zasílat potvrzovací e-maily, žádnou adresu nezadávejte.
Aby bylo možné takto přistupovat, musí být v nastavení modulu povoleno „allowemailreporting“.';
$string['settings'] = 'Nastavení';
$string['settingssaved'] = 'Nastavení uloženo';
$string['show_nonrespondents'] = 'Účastníci bez odpovědi';
$string['started'] = 'zahájeno';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Použijte formát rok-měsíc-den, např. pro 4. března 1945: <strong> 1945-03-04 </strong>';
$string['subject'] = 'Předmět';
$string['submissionnotificationhtmlanon'] = 'Nová <a href="{$a->submissionurl}">odpověď  </a>  v dotazníku "{$a->name}".';
$string['submissionnotificationhtmluser'] = 'Nová <a href="{$a->submissionurl}">odpověď  </a>  v dotazníku "{$a->name}" od  "<a href="{$a->profileurl}">{$a->username}</a>".';
$string['submissionnotificationsubject'] = 'Nová odpověď dotazníku';
$string['submissionnotificationtextanon'] = 'Nová odpověď  ({$a->submissionurl}) v dotazníku "{$a->name}".';
$string['submissionnotificationtextuser'] = 'Nová odpověď  ({$a->submissionurl}) v dotazníku "{$a->name}" od  "{$a->username}" ({$a->profileurl}).';
$string['submitoptions'] = 'Volby odpovědi';
$string['submitpreview'] = 'Náhled odpovědi';
$string['submitpreviewcorrect'] = 'Tato odpověď bude považována za správně vyplněnou.';
$string['submitsurvey'] = 'Odeslat dotazník';
$string['submitted'] = 'Odesláno:';
$string['subtitle'] = 'Podtitul';
$string['subtitle_help'] = 'Podtitul je text, který bude zobrazen na první straně dotazování pod Nadpisem.';
$string['summary'] = 'Popis';
$string['summaryreportattached'] = 'Připojená souhrnná sestava dotazníku';
$string['surveynotexists'] = 'dotazník neexistuje.';
$string['surveyowner'] = 'Pro provedení operace musíte být vlastníkem dotazníku.';
$string['surveyresponse'] = 'Odpovědi z dotazníku';
$string['template'] = 'Šablona';
$string['templatenotviewable'] = 'Šablona dotazníků není zobrazitelná.';
$string['text'] = 'Text otázky';
$string['textareacolumns'] = 'Počet sloupců textového pole';
$string['textarearows'] = 'Počet řádků textového pole';
$string['textbox'] = 'Textové pole';
$string['textbox_help'] = 'Otázka typu Textové pole nabízí pro odpověď krátké textové pole, které může mít délku maximálně jednoho řádku. K nastavení délky pole a maximální délky textu slouží možnosti "Délka vstupního pole" (v původním nastavení má hodnotu 20) a "Max. délka textu" (v původním nastavení má hodnotu 25).';
$string['textdownloadoptions'] = 'Volby pro stáhnutí textu (CSV)';
$string['thank_head'] = 'Děkujeme Vám za vyplnění tohoto dotazníku.';
$string['theme'] = 'Motiv';
$string['thismonth'] = 'tento měsíc';
$string['thisresponse'] = 'Tato odpověď';
$string['thisweek'] = 'tento týden';
$string['thousands'] = 'Nepoužívejte tisíce oddělovačů.';
$string['title'] = 'Nadpis';
$string['title_help'] = 'Název tohoto dotazníku, který se objeví v horní části každé stránky. Ve výchozím nastavení je název nastaven na název činnosti Dotazování, ale můžete jej upravit, jak chcete.';
$string['today'] = 'Dnes';
$string['total'] = 'Celkem';
$string['totalofnumbers'] = 'Celkový počet zadaných čísel';
$string['totalresponses'] = 'Celkem odpovědí na otázku';
$string['type'] = 'Typ otázky';
$string['undefinedquestiontype'] = 'Nedefinován typ otázky!';
$string['unknown'] = 'Neznámý';
$string['unknownaction'] = 'Zadána neznámá akce ...';
$string['url'] = 'URL potvrzení';
$string['url_help'] = 'URL, na které je uživatel přesměrován po vyplnění tohoto dotazníku.';
$string['useprivate'] = 'Kopírovat existující';
$string['usepublic'] = 'Použít veřejný';
$string['usetemplate'] = 'Kopírovat existující';
$string['vertical'] = 'Svisle';
$string['view'] = 'Zobrazit';
$string['viewallresponses'] = 'Zobrazit všechny odpovědi';
$string['viewbyresponse'] = 'Seznam odpovědí';
$string['viewindividualresponse'] = 'Jednotlivé odpovědi';
$string['viewindividualresponse_help'] = 'Kliknutím na respondentovo jméno přejdete na zobrazení odpovědí, které do dotazování zadal.';
$string['viewresponses'] = 'Všechny odpovědi  ({$a})';
$string['viewyourresponses'] = 'Vaše odpovědi ({$a})';
$string['warning'] = 'Varování, došlo k chybě.';
$string['wronganswers'] = 'Něco je ve vaší odpovědi špatně (viz níže)';
$string['wrongdateformat'] = 'Zadané datum: <strong>{$a}</strong> neodpovídá formátu uvedeném v příkladu.';
$string['wrongdaterange'] = 'Chyba! Rok musí být vyplněnv rozmezí 1902 - 2037.';
$string['wrongformat'] = 'Něco je špatně ve vaší odpovědi na otázku:&nbsp;';
$string['wrongformats'] = 'Něco je špatně ve vaší odpovědi na otázku:&nbsp;';
$string['yesno'] = 'Ano/Ne';
$string['yesno_help'] = 'Otázka Ano/Ne.';
$string['yourresponse'] = 'Vaše odpověď';
$string['yourresponses'] = 'Vaše odpovědi';
